// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSHL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SSHL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sshl_2D[] = {
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000000f, 0x0000000000000000,
  0x000000000000001f, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000000f, 0x0000000000000000,
  0x000000000000001f, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x03e8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000000f, 0x0000000000000000,
  0x000000000000001f, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000003e8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000003e8, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000001f4, 0x0000000000000000,
  0x00000000000003e8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000000f, 0x0000000000000000,
  0x000000000000001f, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0010000000000000,
  0x0008000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000080,
  0x0000000000000004, 0x0000000000000100,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000001, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000001, 0x0200000000000000,
  0x0010000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000001, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000080,
  0x0000000000000004, 0x0000000000000100,
  0x0000000000000008, 0x0000000000000200,
  0x0000000000000010, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000080,
  0x0000000000000004, 0x0000000000000100,
  0x0000000000000008, 0x0000000000000200,
  0x0000000000000010, 0x0000000000000040,
  0x0000000000000002, 0x0000000000000080,
  0x0000000000000004, 0x0000000000000100,
  0x0000000000000008, 0x0000000000000200,
  0x0000000000000010, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x0000000000000008, 0x000000000000001f,
  0x0000000000000010, 0x000000000000003e,
  0x0000000000000020, 0x000000000000000f,
  0x0000000000000008, 0x000000000000001f,
  0x0000000000000010, 0x000000000000003e,
  0x0000000000000020, 0x03e8000000000000,
  0x0200000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x0000000000000008, 0x000000000000001f,
  0x0000000000000010, 0x000000000000003e,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x00000000000003e8,
  0x0000000000000200, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x00000000000003e8,
  0x0000000000000200, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x00000000000003e8,
  0x0000000000000200, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x0000000000000008, 0x000000000000001f,
  0x0000000000000010, 0x000000000000003e,
  0x000000000000003e, 0x000000000000007e,
  0x000000000000007d, 0x00000000000000fc,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000001f4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003e, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003e, 0x03f0000000000000,
  0x03e8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003e, 0x000000000000007e,
  0x000000000000007d, 0x00000000000000fc,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000001f4, 0x00000000000003f0,
  0x00000000000003e8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000007e,
  0x000000000000007d, 0x00000000000000fc,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000001f4, 0x00000000000003f0,
  0x00000000000003e8, 0x000000000000007e,
  0x000000000000007d, 0x00000000000000fc,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000001f4, 0x00000000000003f0,
  0x00000000000003e8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003f, 0x000000000000007f,
  0x000000000000007e, 0x00000000000000fe,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000001f8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003f, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003f, 0x03f8000000000000,
  0x03f0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003f, 0x000000000000007f,
  0x000000000000007e, 0x00000000000000fe,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000001f8, 0x00000000000003f8,
  0x00000000000003f0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000007f,
  0x000000000000007e, 0x00000000000000fe,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000001f8, 0x00000000000003f8,
  0x00000000000003f0, 0x000000000000007f,
  0x000000000000007e, 0x00000000000000fe,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000001f8, 0x00000000000003f8,
  0x00000000000003f0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000000f,
  0x000000000000000f, 0x000000000000001f,
  0x000000000000001f, 0x000000000000003f,
  0x000000000000003f, 0x0000000000007ffd,
  0x000000000000007f, 0x000000000000fffa,
  0x00000000000000fe, 0x000000000001fff4,
  0x00000000000001fc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x000000000000000f, 0x0000000000001fff,
  0x000000000000001f, 0x0000000000003ffe,
  0x000000000000003f, 0x0000000000000fff,
  0x000000000000000f, 0x0000000000001fff,
  0x000000000000001f, 0x0000000000003ffe,
  0x000000000000003f, 0xffe8000000000000,
  0x03f8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x000000000000000f, 0x0000000000001fff,
  0x000000000000001f, 0x0000000000003ffe,
  0x000000000000003f, 0x0000000000007ffd,
  0x000000000000007f, 0x000000000000fffa,
  0x00000000000000fe, 0x000000000001fff4,
  0x00000000000001fc, 0x000000000003ffe8,
  0x00000000000003f8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000007ffd,
  0x000000000000007f, 0x000000000000fffa,
  0x00000000000000fe, 0x000000000001fff4,
  0x00000000000001fc, 0x000000000003ffe8,
  0x00000000000003f8, 0x0000000000007ffd,
  0x000000000000007f, 0x000000000000fffa,
  0x00000000000000fe, 0x000000000001fff4,
  0x00000000000001fc, 0x000000000003ffe8,
  0x00000000000003f8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x000000000000000f, 0x0000000000001fff,
  0x000000000000001f, 0x0000000000003ffe,
  0x0000000000003ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x000000000000fffc,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000001fff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003ffe, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003ffe, 0xfff0000000000000,
  0xffe8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x000000000000fffc,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000001fff4, 0x000000000003fff0,
  0x000000000003ffe8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000007ffe,
  0x0000000000007ffd, 0x000000000000fffc,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000001fff4, 0x000000000003fff0,
  0x000000000003ffe8, 0x0000000000007ffe,
  0x0000000000007ffd, 0x000000000000fffc,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000001fff4, 0x000000000003fff0,
  0x000000000003ffe8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x000000000000fffe,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000001fff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003fff, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003fff, 0xfff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x000000000000fffe,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000001fff8, 0x000000000003fff8,
  0x000000000003fff0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000007fff,
  0x0000000000007ffe, 0x000000000000fffe,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000001fff8, 0x000000000003fff8,
  0x000000000003fff0, 0x0000000000007fff,
  0x0000000000007ffe, 0x000000000000fffe,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000001fff8, 0x000000000003fff8,
  0x000000000003fff0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000fff,
  0x0000000000000fff, 0x0000000000001fff,
  0x0000000000001fff, 0x0000000000003fff,
  0x0000000000003fff, 0x000000007ffffffd,
  0x0000000000007fff, 0x00000000fffffffa,
  0x000000000000fffe, 0x00000001fffffff4,
  0x000000000001fffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x0000000000000fff, 0x000000001fffffff,
  0x0000000000001fff, 0x000000003ffffffe,
  0x0000000000003fff, 0x000000000fffffff,
  0x0000000000000fff, 0x000000001fffffff,
  0x0000000000001fff, 0x000000003ffffffe,
  0x0000000000003fff, 0xffe8000000000000,
  0xfff8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x0000000000000fff, 0x000000001fffffff,
  0x0000000000001fff, 0x000000003ffffffe,
  0x0000000000003fff, 0x000000007ffffffd,
  0x0000000000007fff, 0x00000000fffffffa,
  0x000000000000fffe, 0x00000001fffffff4,
  0x000000000001fffc, 0x00000003ffffffe8,
  0x000000000003fff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000007ffffffd,
  0x0000000000007fff, 0x00000000fffffffa,
  0x000000000000fffe, 0x00000001fffffff4,
  0x000000000001fffc, 0x00000003ffffffe8,
  0x000000000003fff8, 0x000000007ffffffd,
  0x0000000000007fff, 0x00000000fffffffa,
  0x000000000000fffe, 0x00000001fffffff4,
  0x000000000001fffc, 0x00000003ffffffe8,
  0x000000000003fff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x0000000000000fff, 0x000000001fffffff,
  0x0000000000001fff, 0x000000003ffffffe,
  0x000000003ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x00000000fffffffc,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000001fffffff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003ffffffe, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003ffffffe, 0xfff0000000000000,
  0xffe8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x00000000fffffffc,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000001fffffff4, 0x00000003fffffff0,
  0x00000003ffffffe8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000007ffffffe,
  0x000000007ffffffd, 0x00000000fffffffc,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000001fffffff4, 0x00000003fffffff0,
  0x00000003ffffffe8, 0x000000007ffffffe,
  0x000000007ffffffd, 0x00000000fffffffc,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000001fffffff4, 0x00000003fffffff0,
  0x00000003ffffffe8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x00000000fffffffe,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000001fffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003fffffff, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003fffffff, 0xfff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x00000000fffffffe,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000001fffffff8, 0x00000003fffffff8,
  0x00000003fffffff0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000007fffffff,
  0x000000007ffffffe, 0x00000000fffffffe,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000001fffffff8, 0x00000003fffffff8,
  0x00000003fffffff0, 0x000000007fffffff,
  0x000000007ffffffe, 0x00000000fffffffe,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000001fffffff8, 0x00000003fffffff8,
  0x00000003fffffff0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x000000000fffffff,
  0x000000000fffffff, 0x000000001fffffff,
  0x000000001fffffff, 0x000000003fffffff,
  0x000000003fffffff, 0x3333333333333333,
  0x000000007fffffff, 0x6666666666666666,
  0x00000000fffffffe, 0xcccccccccccccccc,
  0x00000001fffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0666666666666666,
  0x000000000fffffff, 0x0ccccccccccccccc,
  0x000000001fffffff, 0x1999999999999999,
  0x000000003fffffff, 0x0666666666666666,
  0x000000000fffffff, 0x0ccccccccccccccc,
  0x000000001fffffff, 0x1999999999999999,
  0x000000003fffffff, 0x9998000000000000,
  0xfff8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0666666666666666,
  0x000000000fffffff, 0x0ccccccccccccccc,
  0x000000001fffffff, 0x1999999999999999,
  0x000000003fffffff, 0x3333333333333333,
  0x000000007fffffff, 0x6666666666666666,
  0x00000000fffffffe, 0xcccccccccccccccc,
  0x00000001fffffffc, 0x9999999999999998,
  0x00000003fffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000333,
  0x0000000000000000, 0x3333333333333333,
  0x000000007fffffff, 0x6666666666666666,
  0x00000000fffffffe, 0xcccccccccccccccc,
  0x00000001fffffffc, 0x9999999999999998,
  0x00000003fffffff8, 0x3333333333333333,
  0x000000007fffffff, 0x6666666666666666,
  0x00000000fffffffe, 0xcccccccccccccccc,
  0x00000001fffffffc, 0x9999999999999998,
  0x00000003fffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0666666666666666,
  0x000000000fffffff, 0x0ccccccccccccccc,
  0x000000001fffffff, 0x1999999999999999,
  0x1999999999999999, 0x5555555555555555,
  0x3333333333333333, 0xaaaaaaaaaaaaaaaa,
  0x6666666666666666, 0x5555555555555554,
  0xcccccccccccccccc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0aaaaaaaaaaaaaaa,
  0x0666666666666666, 0x1555555555555555,
  0x0ccccccccccccccc, 0x2aaaaaaaaaaaaaaa,
  0x1999999999999999, 0x0aaaaaaaaaaaaaaa,
  0x0666666666666666, 0x1555555555555555,
  0x0ccccccccccccccc, 0x2aaaaaaaaaaaaaaa,
  0x1999999999999999, 0xaaa8000000000000,
  0x9998000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0aaaaaaaaaaaaaaa,
  0x0666666666666666, 0x1555555555555555,
  0x0ccccccccccccccc, 0x2aaaaaaaaaaaaaaa,
  0x1999999999999999, 0x5555555555555555,
  0x3333333333333333, 0xaaaaaaaaaaaaaaaa,
  0x6666666666666666, 0x5555555555555554,
  0xcccccccccccccccc, 0xaaaaaaaaaaaaaaa8,
  0x9999999999999998, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000555,
  0x0000000000000333, 0x5555555555555555,
  0x3333333333333333, 0xaaaaaaaaaaaaaaaa,
  0x6666666666666666, 0x5555555555555554,
  0xcccccccccccccccc, 0xaaaaaaaaaaaaaaa8,
  0x9999999999999998, 0x5555555555555555,
  0x3333333333333333, 0xaaaaaaaaaaaaaaaa,
  0x6666666666666666, 0x5555555555555554,
  0xcccccccccccccccc, 0xaaaaaaaaaaaaaaa8,
  0x9999999999999998, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0aaaaaaaaaaaaaaa,
  0x0666666666666666, 0x1555555555555555,
  0x0ccccccccccccccc, 0x2aaaaaaaaaaaaaaa,
  0x2aaaaaaaaaaaaaaa, 0x7ffffffffffffffd,
  0x5555555555555555, 0xfffffffffffffffa,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffff4,
  0x5555555555555554, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0aaaaaaaaaaaaaaa, 0x1fffffffffffffff,
  0x1555555555555555, 0x3ffffffffffffffe,
  0x2aaaaaaaaaaaaaaa, 0x0fffffffffffffff,
  0x0aaaaaaaaaaaaaaa, 0x1fffffffffffffff,
  0x1555555555555555, 0x3ffffffffffffffe,
  0x2aaaaaaaaaaaaaaa, 0xffe8000000000000,
  0xaaa8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0aaaaaaaaaaaaaaa, 0x1fffffffffffffff,
  0x1555555555555555, 0x3ffffffffffffffe,
  0x2aaaaaaaaaaaaaaa, 0x7ffffffffffffffd,
  0x5555555555555555, 0xfffffffffffffffa,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffff4,
  0x5555555555555554, 0xffffffffffffffe8,
  0xaaaaaaaaaaaaaaa8, 0x0000000000000000,
  0x0000000000000000, 0x00000000000007ff,
  0x0000000000000555, 0x7ffffffffffffffd,
  0x5555555555555555, 0xfffffffffffffffa,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffff4,
  0x5555555555555554, 0xffffffffffffffe8,
  0xaaaaaaaaaaaaaaa8, 0x7ffffffffffffffd,
  0x5555555555555555, 0xfffffffffffffffa,
  0xaaaaaaaaaaaaaaaa, 0xfffffffffffffff4,
  0x5555555555555554, 0xffffffffffffffe8,
  0xaaaaaaaaaaaaaaa8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0aaaaaaaaaaaaaaa, 0x1fffffffffffffff,
  0x1555555555555555, 0x3ffffffffffffffe,
  0x3ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3ffffffffffffffe, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3ffffffffffffffe, 0xfff0000000000000,
  0xffe8000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0x0000000000000000,
  0x0000000000000000, 0x00000000000007ff,
  0x00000000000007ff, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3fffffffffffffff, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3fffffffffffffff, 0xfff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0x0000000000000000,
  0x0000000000000000, 0x00000000000007ff,
  0x00000000000007ff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0fffffffffffffff,
  0x0fffffffffffffff, 0x1fffffffffffffff,
  0x1fffffffffffffff, 0x3fffffffffffffff,
  0x3fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0x0fffffffffffffff, 0xe000000000000000,
  0x1fffffffffffffff, 0xc000000000000000,
  0x3fffffffffffffff, 0xf000000000000000,
  0x0fffffffffffffff, 0xe000000000000000,
  0x1fffffffffffffff, 0xc000000000000000,
  0x3fffffffffffffff, 0x0000000000000000,
  0xfff8000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0x0fffffffffffffff, 0xe000000000000000,
  0x1fffffffffffffff, 0xc000000000000000,
  0x3fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffff800,
  0x00000000000007ff, 0x8000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffff8, 0x8000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xf000000000000000,
  0x0fffffffffffffff, 0xe000000000000000,
  0x1fffffffffffffff, 0xc000000000000000,
  0xc000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000000,
  0xc000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000000,
  0xc000000000000000, 0x0008000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000000,
  0xc000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff800,
  0xfffffffffffff800, 0x8000000000000001,
  0x8000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x8000000000000001,
  0x8000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000000,
  0xc000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000000, 0x0010000000000000,
  0x0008000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000000, 0x8000000000000002,
  0x8000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff800,
  0xfffffffffffff800, 0x8000000000000002,
  0x8000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0x8000000000000002,
  0x8000000000000001, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000010,
  0x0000000000000008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x0000000000000006,
  0x0000000000000004, 0x000000000000000c,
  0x0000000000000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000001, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000001, 0x0018000000000000,
  0x0010000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000001, 0x8000000000000003,
  0x8000000000000002, 0x0000000000000006,
  0x0000000000000004, 0x000000000000000c,
  0x0000000000000008, 0x0000000000000018,
  0x0000000000000010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff800,
  0xfffffffffffff800, 0x8000000000000003,
  0x8000000000000002, 0x0000000000000006,
  0x0000000000000004, 0x000000000000000c,
  0x0000000000000008, 0x0000000000000018,
  0x0000000000000010, 0x8000000000000003,
  0x8000000000000002, 0x0000000000000006,
  0x0000000000000004, 0x000000000000000c,
  0x0000000000000008, 0x0000000000000018,
  0x0000000000000010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xf000000000000000,
  0xf000000000000000, 0xe000000000000000,
  0xe000000000000000, 0xc000000000000001,
  0xc000000000000001, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0x5555555555555554,
  0x0000000000000006, 0xaaaaaaaaaaaaaaa8,
  0x000000000000000c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf555555555555555,
  0xf000000000000000, 0xeaaaaaaaaaaaaaaa,
  0xe000000000000000, 0xd555555555555555,
  0xc000000000000001, 0xf555555555555555,
  0xf000000000000000, 0xeaaaaaaaaaaaaaaa,
  0xe000000000000000, 0xd555555555555555,
  0xc000000000000001, 0x5550000000000000,
  0x0018000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf555555555555555,
  0xf000000000000000, 0xeaaaaaaaaaaaaaaa,
  0xe000000000000000, 0xd555555555555555,
  0xc000000000000001, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0x5555555555555554,
  0x0000000000000006, 0xaaaaaaaaaaaaaaa8,
  0x000000000000000c, 0x5555555555555550,
  0x0000000000000018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffaaa,
  0xfffffffffffff800, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0x5555555555555554,
  0x0000000000000006, 0xaaaaaaaaaaaaaaa8,
  0x000000000000000c, 0x5555555555555550,
  0x0000000000000018, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0x5555555555555554,
  0x0000000000000006, 0xaaaaaaaaaaaaaaa8,
  0x000000000000000c, 0x5555555555555550,
  0x0000000000000018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xf555555555555555,
  0xf000000000000000, 0xeaaaaaaaaaaaaaaa,
  0xe000000000000000, 0xd555555555555555,
  0xd555555555555555, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0x9999999999999998,
  0x5555555555555554, 0x3333333333333330,
  0xaaaaaaaaaaaaaaa8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf999999999999999,
  0xf555555555555555, 0xf333333333333333,
  0xeaaaaaaaaaaaaaaa, 0xe666666666666666,
  0xd555555555555555, 0xf999999999999999,
  0xf555555555555555, 0xf333333333333333,
  0xeaaaaaaaaaaaaaaa, 0xe666666666666666,
  0xd555555555555555, 0x6660000000000000,
  0x5550000000000000, 0x0000000000000000,
  0x0000000000000000, 0xf999999999999999,
  0xf555555555555555, 0xf333333333333333,
  0xeaaaaaaaaaaaaaaa, 0xe666666666666666,
  0xd555555555555555, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0x9999999999999998,
  0x5555555555555554, 0x3333333333333330,
  0xaaaaaaaaaaaaaaa8, 0x6666666666666660,
  0x5555555555555550, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffccc,
  0xfffffffffffffaaa, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0x9999999999999998,
  0x5555555555555554, 0x3333333333333330,
  0xaaaaaaaaaaaaaaa8, 0x6666666666666660,
  0x5555555555555550, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0x9999999999999998,
  0x5555555555555554, 0x3333333333333330,
  0xaaaaaaaaaaaaaaa8, 0x6666666666666660,
  0x5555555555555550, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xf999999999999999,
  0xf555555555555555, 0xf333333333333333,
  0xeaaaaaaaaaaaaaaa, 0xe666666666666666,
  0xe666666666666666, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff00000000,
  0x9999999999999998, 0xfffffffe00000000,
  0x3333333333333330, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xf999999999999999, 0xffffffffe0000000,
  0xf333333333333333, 0xffffffffc0000000,
  0xe666666666666666, 0xfffffffff0000000,
  0xf999999999999999, 0xffffffffe0000000,
  0xf333333333333333, 0xffffffffc0000000,
  0xe666666666666666, 0x0000000000000000,
  0x6660000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xf999999999999999, 0xffffffffe0000000,
  0xf333333333333333, 0xffffffffc0000000,
  0xe666666666666666, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff00000000,
  0x9999999999999998, 0xfffffffe00000000,
  0x3333333333333330, 0xfffffffc00000000,
  0x6666666666666660, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffccc, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff00000000,
  0x9999999999999998, 0xfffffffe00000000,
  0x3333333333333330, 0xfffffffc00000000,
  0x6666666666666660, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff00000000,
  0x9999999999999998, 0xfffffffe00000000,
  0x3333333333333330, 0xfffffffc00000000,
  0x6666666666666660, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffff0000000,
  0xf999999999999999, 0xffffffffe0000000,
  0xf333333333333333, 0xffffffffc0000000,
  0xffffffffc0000000, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff00000002,
  0xffffffff00000000, 0xfffffffe00000004,
  0xfffffffe00000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000000,
  0xffffffffc0000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000000,
  0xffffffffc0000000, 0x0008000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000000,
  0xffffffffc0000000, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff00000002,
  0xffffffff00000000, 0xfffffffe00000004,
  0xfffffffe00000000, 0xfffffffc00000008,
  0xfffffffc00000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff00000002,
  0xffffffff00000000, 0xfffffffe00000004,
  0xfffffffe00000000, 0xfffffffc00000008,
  0xfffffffc00000000, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff00000002,
  0xffffffff00000000, 0xfffffffe00000004,
  0xfffffffe00000000, 0xfffffffc00000008,
  0xfffffffc00000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000000,
  0xffffffffc0000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff00000004,
  0xffffffff00000002, 0xfffffffe00000008,
  0xfffffffe00000004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000000, 0x0010000000000000,
  0x0008000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000000, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff00000004,
  0xffffffff00000002, 0xfffffffe00000008,
  0xfffffffe00000004, 0xfffffffc00000010,
  0xfffffffc00000008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff00000004,
  0xffffffff00000002, 0xfffffffe00000008,
  0xfffffffe00000004, 0xfffffffc00000010,
  0xfffffffc00000008, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff00000004,
  0xffffffff00000002, 0xfffffffe00000008,
  0xfffffffe00000004, 0xfffffffc00000010,
  0xfffffffc00000008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff00000006,
  0xffffffff00000004, 0xfffffffe0000000c,
  0xfffffffe00000008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000001, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000001, 0x0018000000000000,
  0x0010000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000001, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff00000006,
  0xffffffff00000004, 0xfffffffe0000000c,
  0xfffffffe00000008, 0xfffffffc00000018,
  0xfffffffc00000010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff00000006,
  0xffffffff00000004, 0xfffffffe0000000c,
  0xfffffffe00000008, 0xfffffffc00000018,
  0xfffffffc00000010, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff00000006,
  0xffffffff00000004, 0xfffffffe0000000c,
  0xfffffffe00000008, 0xfffffffc00000018,
  0xfffffffc00000010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffff0000000,
  0xfffffffff0000000, 0xffffffffe0000000,
  0xffffffffe0000000, 0xffffffffc0000001,
  0xffffffffc0000001, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff0000,
  0xffffffff00000006, 0xfffffffffffe0000,
  0xfffffffe0000000c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffff0000000, 0xffffffffffffe000,
  0xffffffffe0000000, 0xffffffffffffc000,
  0xffffffffc0000001, 0xfffffffffffff000,
  0xfffffffff0000000, 0xffffffffffffe000,
  0xffffffffe0000000, 0xffffffffffffc000,
  0xffffffffc0000001, 0x0000000000000000,
  0x0018000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffff0000000, 0xffffffffffffe000,
  0xffffffffe0000000, 0xffffffffffffc000,
  0xffffffffc0000001, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff0000,
  0xffffffff00000006, 0xfffffffffffe0000,
  0xfffffffe0000000c, 0xfffffffffffc0000,
  0xfffffffc00000018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff0000,
  0xffffffff00000006, 0xfffffffffffe0000,
  0xfffffffe0000000c, 0xfffffffffffc0000,
  0xfffffffc00000018, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff0000,
  0xffffffff00000006, 0xfffffffffffe0000,
  0xfffffffe0000000c, 0xfffffffffffc0000,
  0xfffffffc00000018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff000,
  0xfffffffff0000000, 0xffffffffffffe000,
  0xffffffffe0000000, 0xffffffffffffc000,
  0xffffffffffffc000, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff0002,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xfffffffffffe0000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc000,
  0xffffffffffffc000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc000,
  0xffffffffffffc000, 0x0008000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc000,
  0xffffffffffffc000, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff0002,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xfffffffffffe0000, 0xfffffffffffc0008,
  0xfffffffffffc0000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff0002,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xfffffffffffe0000, 0xfffffffffffc0008,
  0xfffffffffffc0000, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff0002,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xfffffffffffe0000, 0xfffffffffffc0008,
  0xfffffffffffc0000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc000,
  0xffffffffffffc000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xfffffffffffe0004, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc000, 0x0010000000000000,
  0x0008000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc000, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xfffffffffffe0004, 0xfffffffffffc0010,
  0xfffffffffffc0008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xfffffffffffe0004, 0xfffffffffffc0010,
  0xfffffffffffc0008, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xfffffffffffe0004, 0xfffffffffffc0010,
  0xfffffffffffc0008, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff0006,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xfffffffffffe0008, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc001, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc001, 0x0018000000000000,
  0x0010000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc001, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff0006,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xfffffffffffe0008, 0xfffffffffffc0018,
  0xfffffffffffc0010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff0006,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xfffffffffffe0008, 0xfffffffffffc0018,
  0xfffffffffffc0010, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff0006,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xfffffffffffe0008, 0xfffffffffffc0018,
  0xfffffffffffc0010, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffff000,
  0xfffffffffffff000, 0xffffffffffffe000,
  0xffffffffffffe000, 0xffffffffffffc001,
  0xffffffffffffc001, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff00,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xfffffffffffe000c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffff000, 0xffffffffffffffe0,
  0xffffffffffffe000, 0xffffffffffffffc0,
  0xffffffffffffc001, 0xfffffffffffffff0,
  0xfffffffffffff000, 0xffffffffffffffe0,
  0xffffffffffffe000, 0xffffffffffffffc0,
  0xffffffffffffc001, 0xfc00000000000000,
  0x0018000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffff000, 0xffffffffffffffe0,
  0xffffffffffffe000, 0xffffffffffffffc0,
  0xffffffffffffc001, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff00,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xfffffffffffe000c, 0xfffffffffffffc00,
  0xfffffffffffc0018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff00,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xfffffffffffe000c, 0xfffffffffffffc00,
  0xfffffffffffc0018, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff00,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xfffffffffffe000c, 0xfffffffffffffc00,
  0xfffffffffffc0018, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffff0,
  0xfffffffffffff000, 0xffffffffffffffe0,
  0xffffffffffffe000, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff02,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xfffffffffffffe00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xfc08000000000000,
  0xfc00000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff02,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xfffffffffffffe00, 0xfffffffffffffc08,
  0xfffffffffffffc00, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff02,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xfffffffffffffe00, 0xfffffffffffffc08,
  0xfffffffffffffc00, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff02,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xfffffffffffffe00, 0xfffffffffffffc08,
  0xfffffffffffffc00, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc0,
  0xffffffffffffffc0, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xfffffffffffffe04, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xfc10000000000000,
  0xfc08000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc0, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xfffffffffffffe04, 0xfffffffffffffc10,
  0xfffffffffffffc08, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xfffffffffffffe04, 0xfffffffffffffc10,
  0xfffffffffffffc08, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xfffffffffffffe04, 0xfffffffffffffc10,
  0xfffffffffffffc08, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff06,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xfffffffffffffe08, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xfc18000000000000,
  0xfc10000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff06,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xfffffffffffffe08, 0xfffffffffffffc18,
  0xfffffffffffffc10, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff06,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xfffffffffffffe08, 0xfffffffffffffc18,
  0xfffffffffffffc10, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff06,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xfffffffffffffe08, 0xfffffffffffffc18,
  0xfffffffffffffc10, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffff0,
  0xfffffffffffffff0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffff80,
  0xffffffffffffff06, 0xffffffffffffff00,
  0xfffffffffffffe0c, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc1, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc1, 0xfe00000000000000,
  0xfc18000000000000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffc1, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffff80,
  0xffffffffffffff06, 0xffffffffffffff00,
  0xfffffffffffffe0c, 0xfffffffffffffe00,
  0xfffffffffffffc18, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffff80,
  0xffffffffffffff06, 0xffffffffffffff00,
  0xfffffffffffffe0c, 0xfffffffffffffe00,
  0xfffffffffffffc18, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffff80,
  0xffffffffffffff06, 0xffffffffffffff00,
  0xfffffffffffffe0c, 0xfffffffffffffe00,
  0xfffffffffffffc18, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xfffffffffffffff0,
  0xffffffffffffffe0, 0xffffffffffffffe0,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xffffffffffffff80, 0xfffffffffffffff4,
  0xffffffffffffff00, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0xfffffffffffffff0, 0xfffffffffffffffe,
  0xffffffffffffffe0, 0xffffffffffffffff,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0xfffffffffffffff0, 0xfffffffffffffffe,
  0xffffffffffffffe0, 0xffe8000000000000,
  0xfe00000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0xfffffffffffffff0, 0xfffffffffffffffe,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xffffffffffffff80, 0xfffffffffffffff4,
  0xffffffffffffff00, 0xffffffffffffffe8,
  0xfffffffffffffe00, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xffffffffffffff80, 0xfffffffffffffff4,
  0xffffffffffffff00, 0xffffffffffffffe8,
  0xfffffffffffffe00, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xffffffffffffff80, 0xfffffffffffffff4,
  0xffffffffffffff00, 0xffffffffffffffe8,
  0xfffffffffffffe00, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffff8, 0xffffffffffffffff,
  0xfffffffffffffff0, 0xfffffffffffffffe,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfff0000000000000,
  0xffe8000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffc,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffff4, 0xfffffffffffffff0,
  0xffffffffffffffe8, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xfff8000000000000,
  0xfff0000000000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffff8, 0xfffffffffffffff8,
  0xfffffffffffffff0, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
};
const unsigned kExpectedCount_NEON_sshl_2D = 1600;

#endif  // VIXL_SIM_SSHL_2D_TRACE_AARCH64_H_
