// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLAL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SMLAL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smlal2_4S[] = {
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x00000020,
  0x3ffd8006, 0x3ffe8003, 0x00000002, 0x00000020,
  0x3ffe0003, 0x00000001, 0x00008001, 0x00000020,
  0x00000000, 0x00007fff, 0x00010000, 0x00000020,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0x00000020,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0x00000020,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0x00000020,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0x00000020,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0x00000020,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0x00000020,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0x00000020,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0x00000020,
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x00000020,
  0x3ffd8006, 0x3ffe8003, 0xc0008002, 0x00000020,
  0x3ffe0003, 0xc0010001, 0xc0010001, 0x00000020,
  0xc0018000, 0xc0017fff, 0xd5555558, 0x00000020,
  0xc001fffd, 0xd555aaad, 0xe6663336, 0x00000020,
  0xd5560002, 0xe6666669, 0xffc00082, 0x00000020,
  0xe666999c, 0xffc00101, 0xffc08081, 0x00000020,
  0xffc00180, 0xffc080ff, 0xffc10080, 0x00000020,
  0xffc0817d, 0xffc100fd, 0xffc1807f, 0x00000020,
  0xffc1017a, 0xffc180fb, 0xfff80012, 0x00000020,
  0xffc18177, 0xfff80021, 0xfffe8005, 0x00000020,
  0xfff80030, 0xfffe8007, 0xffff0004, 0x00000020,
  0xfffe8006, 0xffff0003, 0x00000002, 0x00000020,
  0xffff0004, 0xffff8002, 0x00000002, 0x00000021,
  0xffff8002, 0x00000001, 0x00000002, 0x00000022,
  0x00000000, 0x00008000, 0x00000002, 0x00000030,
  0x00007ffe, 0x0000ffff, 0x00000002, 0x0000009d,
  0x0000fffc, 0x0007fff1, 0x00000002, 0x0000009e,
  0x0007ffe0, 0x003e7f84, 0x00000002, 0x0000009f,
  0x003e7f06, 0x003eff83, 0x00000002, 0x00003353,
  0x003eff04, 0x003f7f82, 0x00000002, 0x00005575,
  0x003f7f02, 0x19994cce, 0x00000002, 0x0000801d,
  0x1999199a, 0x2aaa2aac, 0x00000002, 0x0000801e,
  0x2aa9d556, 0x3ffe0004, 0x00000002, 0x0000801f,
  0x3ffd8006, 0x3ffe8003, 0x00000002, 0xffff8020,
  0x3ffe0004, 0x3fff0002, 0x00000002, 0xffff8021,
  0x3ffe8002, 0xc0008001, 0x00000002, 0xffffaaca,
  0xc0010000, 0xc0010000, 0x00000002, 0xffffccec,
  0xc0017ffe, 0xd5555557, 0x00000002, 0xffffffa0,
  0xd555aaac, 0xe6663335, 0x00000002, 0xffffffa1,
  0xe6666668, 0xffc00081, 0x00000002, 0xffffffa2,
  0xffc00100, 0xffc08080, 0x00000002, 0xffffffa3,
  0xffc080fe, 0xffc1007f, 0x00000002, 0x00000010,
  0xffc100fc, 0xffc1807e, 0x00000002, 0x0000001d,
  0xffc180fa, 0xfff80011, 0x00000002, 0x0000001e,
  0xfff80020, 0xfffe8004, 0x00000002, 0x0000001f,
  0xfffe8003, 0x00000001, 0x00000001, 0x00000020,
  0xffff0002, 0x00000001, 0x00000002, 0x00000022,
  0xffff8001, 0x00000001, 0x00000003, 0x00000024,
  0x00000000, 0x00000001, 0x00000004, 0x00000040,
  0x00007fff, 0x00000001, 0x00000012, 0x0000011a,
  0x0000fffe, 0x00000001, 0x0000007f, 0x0000011c,
  0x0007fff0, 0x00000001, 0x00000080, 0x0000011e,
  0x003e7f83, 0x00000001, 0x00000081, 0x00006686,
  0x003eff82, 0x00000001, 0x00003335, 0x0000aaca,
  0x003f7f81, 0x00000001, 0x00005557, 0x0001001a,
  0x19994ccd, 0x00000001, 0x00007fff, 0x0001001c,
  0x2aaa2aab, 0x00000001, 0x00008000, 0x0001001e,
  0x3ffe0003, 0x00000001, 0x00008001, 0xffff0020,
  0x3ffe8002, 0x00000001, 0xffff8002, 0xffff0022,
  0x3fff0001, 0x00000001, 0xffff8003, 0xffff5574,
  0xc0008000, 0x00000001, 0xffffaaac, 0xffff99b8,
  0xc000ffff, 0x00000001, 0xffffccce, 0xffffff20,
  0xd5555556, 0x00000001, 0xffffff82, 0xffffff22,
  0xe6663334, 0x00000001, 0xffffff83, 0xffffff24,
  0xffc00080, 0x00000001, 0xffffff84, 0xffffff26,
  0xffc0807f, 0x00000001, 0xffffff85, 0x00000000,
  0xffc1007e, 0x00000001, 0xfffffff2, 0x0000001a,
  0xffc1807d, 0x00000001, 0xffffffff, 0x0000001c,
  0xfff80010, 0x00000001, 0x00000000, 0x0000001e,
  0x00000000, 0xffffffff, 0x00000000, 0x00000020,
  0x00000000, 0x00000000, 0x00000002, 0x00000030,
  0x00000000, 0x00000001, 0x00000004, 0x00000040,
  0x00000000, 0x00000002, 0x00000006, 0x00000120,
  0x00000000, 0x00000003, 0x00000022, 0x000007f0,
  0x00000000, 0x00000011, 0x000000fc, 0x00000800,
  0x00000000, 0x0000007e, 0x000000fe, 0x00000810,
  0x00000000, 0x0000007f, 0x00000100, 0x00033350,
  0x00000000, 0x00000080, 0x00006668, 0x00055570,
  0x00000000, 0x00003334, 0x0000aaac, 0x0007fff0,
  0x00000000, 0x00005556, 0x0000fffc, 0x00080000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080010,
  0x00000000, 0x00007fff, 0x00010000, 0xfff80020,
  0x00000000, 0x00008000, 0xffff0002, 0xfff80030,
  0x00000000, 0xffff8001, 0xffff0004, 0xfffaaac0,
  0x00000000, 0xffff8002, 0xffff5556, 0xfffccce0,
  0x00000000, 0xffffaaab, 0xffff999a, 0xfffff820,
  0x00000000, 0xffffcccd, 0xffffff02, 0xfffff830,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff840,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffff850,
  0x00000000, 0xffffff83, 0xffffff08, 0xffffff20,
  0x00000000, 0xffffff84, 0xffffffe2, 0xfffffff0,
  0x00000000, 0xfffffff1, 0xfffffffc, 0x00000000,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000010,
  0xfffffffd, 0xfffffffd, 0xfffffff2, 0x00000020,
  0xfffffffe, 0xffffffff, 0x00000002, 0x0000009d,
  0xffffffff, 0x00000001, 0x00000012, 0x0000011a,
  0x00000000, 0x00000003, 0x00000022, 0x000007f0,
  0x00000001, 0x00000005, 0x00000102, 0x00003d29,
  0x00000002, 0x00000021, 0x000007d2, 0x00003da6,
  0x00000010, 0x000000fb, 0x000007e2, 0x00003e23,
  0x0000007d, 0x000000fd, 0x000007f2, 0x00190007,
  0x0000007e, 0x000000ff, 0x00033332, 0x0029aaa1,
  0x0000007f, 0x00006667, 0x00055552, 0x003e7ea9,
  0x00003333, 0x0000aaab, 0x0007ffd2, 0x003e7f26,
  0x00005555, 0x0000fffb, 0x0007ffe2, 0x003e7fa3,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0xffc18020,
  0x00007ffe, 0x0000ffff, 0xfff80002, 0xffc1809d,
  0x00007fff, 0xffff0001, 0xfff80012, 0xffd65522,
  0xffff8000, 0xffff0003, 0xfffaaaa2, 0xffe6ffbc,
  0xffff8001, 0xffff5555, 0xfffcccc2, 0xffffc1a0,
  0xffffaaaa, 0xffff9999, 0xfffff802, 0xffffc21d,
  0xffffcccc, 0xffffff01, 0xfffff812, 0xffffc29a,
  0xffffff80, 0xffffff03, 0xfffff822, 0xffffc317,
  0xffffff81, 0xffffff05, 0xfffff832, 0xfffff850,
  0xffffff82, 0xffffff07, 0xffffff02, 0xfffffea9,
  0xffffff83, 0xffffffe1, 0xffffffd2, 0xffffff26,
  0xfffffff0, 0xfffffffb, 0xffffffe2, 0xffffffa3,
  0xfffffffa, 0xffffffe1, 0xffffff85, 0x00000020,
  0xfffffffc, 0xfffffff1, 0x00000002, 0x0000009e,
  0xfffffffe, 0x00000001, 0x0000007f, 0x0000011c,
  0x00000000, 0x00000011, 0x000000fc, 0x00000800,
  0x00000002, 0x00000021, 0x000007d2, 0x00003da6,
  0x00000004, 0x00000101, 0x00003d0b, 0x00003e24,
  0x00000020, 0x000007d1, 0x00003d88, 0x00003ea2,
  0x000000fa, 0x000007e1, 0x00003e05, 0x0019333a,
  0x000000fc, 0x000007f1, 0x0018ffe9, 0x0029fff6,
  0x000000fe, 0x00033331, 0x0029aa83, 0x003efea6,
  0x00006666, 0x00055551, 0x003e7e8b, 0x003eff24,
  0x0000aaaa, 0x0007ffd1, 0x003e7f08, 0x003effa2,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0xffc10020,
  0x0000fffc, 0x0007fff1, 0xffc18002, 0xffc1009e,
  0x0000fffe, 0xfff80001, 0xffc1807f, 0xffd5ffcc,
  0xffff0000, 0xfff80011, 0xffd65504, 0xffe6cc88,
  0xffff0002, 0xfffaaaa1, 0xffe6ff9e, 0xffffc120,
  0xffff5554, 0xfffcccc1, 0xffffc182, 0xffffc19e,
  0xffff9998, 0xfffff801, 0xffffc1ff, 0xffffc21c,
  0xffffff00, 0xfffff811, 0xffffc27c, 0xffffc29a,
  0xffffff02, 0xfffff821, 0xffffc2f9, 0xfffff840,
  0xffffff04, 0xfffff831, 0xfffff832, 0xfffffea6,
  0xffffff06, 0xffffff01, 0xfffffe8b, 0xffffff24,
  0xffffffe0, 0xffffffd1, 0xffffff08, 0xffffffa2,
  0xffffffd0, 0xffffff07, 0xffffff84, 0x00000020,
  0xffffffe0, 0xffffff84, 0x00000002, 0x0000009f,
  0xfffffff0, 0x00000001, 0x00000080, 0x0000011e,
  0x00000000, 0x0000007e, 0x000000fe, 0x00000810,
  0x00000010, 0x000000fb, 0x000007e2, 0x00003e23,
  0x00000020, 0x000007d1, 0x00003d88, 0x00003ea2,
  0x00000100, 0x00003d0a, 0x00003e06, 0x00003f21,
  0x000007d0, 0x00003d87, 0x00003e84, 0x0019666d,
  0x000007e0, 0x00003e04, 0x0019331c, 0x002a554b,
  0x000007f0, 0x0018ffe8, 0x0029ffd8, 0x003f7ea3,
  0x00033330, 0x0029aa82, 0x003efe88, 0x003f7f22,
  0x00055550, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0xffc08020,
  0x0007ffe0, 0x003e7f84, 0xffc10002, 0xffc0809f,
  0x0007fff0, 0xffc18001, 0xffc10080, 0xffd5aa76,
  0xfff80000, 0xffc1807e, 0xffd5ffae, 0xffe69954,
  0xfff80010, 0xffd65503, 0xffe6cc6a, 0xffffc0a0,
  0xfffaaaa0, 0xffe6ff9d, 0xffffc102, 0xffffc11f,
  0xfffcccc0, 0xffffc181, 0xffffc180, 0xffffc19e,
  0xfffff800, 0xffffc1fe, 0xffffc1fe, 0xffffc21d,
  0xfffff810, 0xffffc27b, 0xffffc27c, 0xfffff830,
  0xfffff820, 0xffffc2f8, 0xfffff822, 0xfffffea3,
  0xfffff830, 0xfffff831, 0xfffffe88, 0xffffff22,
  0xffffff00, 0xfffffe8a, 0xffffff06, 0xffffffa1,
  0xfffffe89, 0xffffff05, 0xffffff83, 0x00000020,
  0xffffff06, 0xffffff83, 0x00000002, 0x00003353,
  0xffffff83, 0x00000001, 0x00000081, 0x00006686,
  0x00000000, 0x0000007f, 0x00000100, 0x00033350,
  0x0000007d, 0x000000fd, 0x000007f2, 0x00190007,
  0x000000fa, 0x000007e1, 0x00003e05, 0x0019333a,
  0x000007d0, 0x00003d87, 0x00003e84, 0x0019666d,
  0x00003d09, 0x00003e05, 0x00003f03, 0x0a3d5c49,
  0x00003d86, 0x00003e83, 0x0019664f, 0x1110ef0f,
  0x00003e03, 0x0019331b, 0x002a552d, 0x1998e687,
  0x0018ffe7, 0x0029ffd7, 0x003f7e85, 0x199919ba,
  0x0029aa81, 0x003efe87, 0x003f7f04, 0x19994ced,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0xe6668020,
  0x003e7f06, 0x003eff83, 0xffc08002, 0xe666b353,
  0x003e7f83, 0xffc10001, 0xffc08081, 0xeeeeddfe,
  0xffc18000, 0xffc1007f, 0xffd5aa58, 0xf5c270c4,
  0xffc1807d, 0xffd5ffad, 0xffe69936, 0xffe666a0,
  0xffd65502, 0xffe6cc69, 0xffffc082, 0xffe699d3,
  0xffe6ff9c, 0xffffc101, 0xffffc101, 0xffe6cd06,
  0xffffc180, 0xffffc17f, 0xffffc180, 0xffe70039,
  0xffffc1fd, 0xffffc1fd, 0xffffc1ff, 0xfffcccf0,
  0xffffc27a, 0xffffc27b, 0xfffff812, 0xffff6687,
  0xffffc2f7, 0xfffff821, 0xfffffe85, 0xffff99ba,
  0xfffff830, 0xfffffe87, 0xffffff04, 0xffffcced,
  0xfffffe86, 0xffffff03, 0xffffcccf, 0x00000020,
  0xffffff04, 0xffffff82, 0x00000002, 0x00005575,
  0xffffff82, 0x00000001, 0x00003335, 0x0000aaca,
  0x00000000, 0x00000080, 0x00006668, 0x00055570,
  0x0000007e, 0x000000ff, 0x00033332, 0x0029aaa1,
  0x000000fc, 0x000007f1, 0x0018ffe9, 0x0029fff6,
  0x000007e0, 0x00003e04, 0x0019331c, 0x002a554b,
  0x00003d86, 0x00003e83, 0x0019664f, 0x1110ef0f,
  0x00003e04, 0x00003f02, 0x0a3d5c2b, 0x1c718e59,
  0x00003e82, 0x0019664e, 0x1110eef1, 0x2aa98021,
  0x0019331a, 0x002a552c, 0x1998e669, 0x2aa9d576,
  0x0029ffd6, 0x003f7e84, 0x1999199c, 0x2aaa2acb,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0xd5558020,
  0x003eff04, 0x003f7f82, 0xe6668002, 0xd555d575,
  0x003eff82, 0xffc08001, 0xe666b335, 0xe38e1c92,
  0xffc10000, 0xffc08080, 0xeeeedde0, 0xeeeebbdc,
  0xffc1007e, 0xffd5aa57, 0xf5c270a6, 0xffd555a0,
  0xffd5ffac, 0xffe69935, 0xffe66682, 0xffd5aaf5,
  0xffe6cc68, 0xffffc081, 0xffe699b5, 0xffd6004a,
  0xffffc100, 0xffffc100, 0xffe6cce8, 0xffd6559f,
  0xffffc17e, 0xffffc17f, 0xffe7001b, 0xfffaaad0,
  0xffffc1fc, 0xffffc1fe, 0xfffcccd2, 0xffff0021,
  0xffffc27a, 0xfffff811, 0xffff6669, 0xffff5576,
  0xfffff820, 0xfffffe84, 0xffff999c, 0xffffaacb,
  0xfffffe83, 0xffff999b, 0xffffaaad, 0x00000020,
  0xffffff02, 0xffffccce, 0x00000002, 0x0000801d,
  0xffffff81, 0x00000001, 0x00005557, 0x0001001a,
  0x00000000, 0x00003334, 0x0000aaac, 0x0007fff0,
  0x0000007f, 0x00006667, 0x00055552, 0x003e7ea9,
  0x000000fe, 0x00033331, 0x0029aa83, 0x003efea6,
  0x000007f0, 0x0018ffe8, 0x0029ffd8, 0x003f7ea3,
  0x00003e03, 0x0019331b, 0x002a552d, 0x1998e687,
  0x00003e82, 0x0019664e, 0x1110eef1, 0x2aa98021,
  0x00003f01, 0x0a3d5c2a, 0x1c718e3b, 0x3ffd0029,
  0x0019664d, 0x1110eef0, 0x2aa98003, 0x3ffd8026,
  0x002a552b, 0x1998e668, 0x2aa9d558, 0x3ffe0023,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0xc0018020,
  0x003f7f02, 0x19994cce, 0xd5558002, 0xc002001d,
  0x003f7f81, 0xe6668001, 0xd555d557, 0xd5560022,
  0xffc08000, 0xe666b334, 0xe38e1c74, 0xe66699bc,
  0xffc0807f, 0xeeeedddf, 0xeeeebbbe, 0xffc001a0,
  0xffd5aa56, 0xf5c270a5, 0xffd55582, 0xffc0819d,
  0xffe69934, 0xffe66681, 0xffd5aad7, 0xffc1019a,
  0xffffc080, 0xffe699b4, 0xffd6002c, 0xffc18197,
  0xffffc0ff, 0xffe6cce7, 0xffd65581, 0xfff80050,
  0xffffc17e, 0xffe7001a, 0xfffaaab2, 0xfffe8029,
  0xffffc1fd, 0xfffcccd1, 0xffff0003, 0xffff0026,
  0xfffff810, 0xffff6668, 0xffff5558, 0xffff8023,
  0xffff6667, 0xffff5557, 0xffff8005, 0x00000020,
  0xffff999a, 0xffffaaac, 0x00000002, 0x0000801e,
  0xffffcccd, 0x00000001, 0x00007fff, 0x0001001c,
  0x00000000, 0x00005556, 0x0000fffc, 0x00080000,
  0x00003333, 0x0000aaab, 0x0007ffd2, 0x003e7f26,
  0x00006666, 0x00055551, 0x003e7e8b, 0x003eff24,
  0x00033330, 0x0029aa82, 0x003efe88, 0x003f7f22,
  0x0018ffe7, 0x0029ffd7, 0x003f7e85, 0x199919ba,
  0x0019331a, 0x002a552c, 0x1998e669, 0x2aa9d576,
  0x0019664d, 0x1110eef0, 0x2aa98003, 0x3ffd8026,
  0x0a3d5c29, 0x1c718e3a, 0x3ffd000b, 0x3ffe0024,
  0x1110eeef, 0x2aa98002, 0x3ffd8008, 0x3ffe8022,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0xc0010020,
  0x1999199a, 0x2aaa2aac, 0xc0018002, 0xc001801e,
  0x19994ccd, 0xd5558001, 0xc001ffff, 0xd555aacc,
  0xe6668000, 0xd555d556, 0xd5560004, 0xe6666688,
  0xe666b333, 0xe38e1c73, 0xe666999e, 0xffc00120,
  0xeeeeddde, 0xeeeebbbd, 0xffc00182, 0xffc0811e,
  0xf5c270a4, 0xffd55581, 0xffc0817f, 0xffc1011c,
  0xffe66680, 0xffd5aad6, 0xffc1017c, 0xffc1811a,
  0xffe699b3, 0xffd6002b, 0xffc18179, 0xfff80040,
  0xffe6cce6, 0xffd65580, 0xfff80032, 0xfffe8026,
  0xffe70019, 0xfffaaab1, 0xfffe800b, 0xffff0024,
  0xfffcccd0, 0xffff0002, 0xffff0008, 0xffff8022,
  0xffff0001, 0xffff0007, 0xffff8004, 0x00000020,
  0xffff5556, 0xffff8004, 0x00000002, 0x0000801f,
  0xffffaaab, 0x00000001, 0x00008000, 0x0001001e,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00080010,
  0x00005555, 0x0000fffb, 0x0007ffe2, 0x003e7fa3,
  0x0000aaaa, 0x0007ffd1, 0x003e7f08, 0x003effa2,
  0x00055550, 0x003e7e8a, 0x003eff06, 0x003f7fa1,
  0x0029aa81, 0x003efe87, 0x003f7f04, 0x19994ced,
  0x0029ffd6, 0x003f7e84, 0x1999199c, 0x2aaa2acb,
  0x002a552b, 0x1998e668, 0x2aa9d558, 0x3ffe0023,
  0x1110eeef, 0x2aa98002, 0x3ffd8008, 0x3ffe8022,
  0x1c718e39, 0x3ffd000a, 0x3ffe0006, 0x3fff0021,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0xc0008020,
  0x2aa9d556, 0x3ffe0004, 0xc0010002, 0xc001001f,
  0x2aaa2aab, 0xc0018001, 0xc0018000, 0xd5555576,
  0xd5558000, 0xc001fffe, 0xd555aaae, 0xe6663354,
  0xd555d555, 0xd5560003, 0xe666666a, 0xffc000a0,
  0xe38e1c72, 0xe666999d, 0xffc00102, 0xffc0809f,
  0xeeeebbbc, 0xffc00181, 0xffc08100, 0xffc1009e,
  0xffd55580, 0xffc0817e, 0xffc100fe, 0xffc1809d,
  0xffd5aad5, 0xffc1017b, 0xffc180fc, 0xfff80030,
  0xffd6002a, 0xffc18178, 0xfff80022, 0xfffe8023,
  0xffd6557f, 0xfff80031, 0xfffe8008, 0xffff0022,
  0xfffaaab0, 0xfffe800a, 0xffff0006, 0xffff8021,
  0xfffe8009, 0xffff0005, 0xffff8003, 0x00000020,
  0xffff0006, 0xffff8003, 0x00000002, 0xffff8020,
  0xffff8003, 0x00000001, 0x00008001, 0xffff0020,
  0x00000000, 0x00007fff, 0x00010000, 0xfff80020,
  0x00007ffd, 0x0000fffd, 0x0007fff2, 0xffc18020,
  0x0000fffa, 0x0007ffe1, 0x003e7f85, 0xffc10020,
  0x0007ffd0, 0x003e7f07, 0x003eff84, 0xffc08020,
  0x003e7e89, 0x003eff05, 0x003f7f83, 0xe6668020,
  0x003efe86, 0x003f7f03, 0x19994ccf, 0xd5558020,
  0x003f7e83, 0x1999199b, 0x2aaa2aad, 0xc0018020,
  0x1998e667, 0x2aa9d557, 0x3ffe0005, 0xc0010020,
  0x2aa98001, 0x3ffd8007, 0x3ffe8004, 0xc0008020,
  0x3ffd0009, 0x3ffe0005, 0x3fff0003, 0x40000020,
  0x3ffd8006, 0x3ffe8003, 0xc0008002, 0x3fff8020,
  0x3ffe0003, 0xc0010001, 0xc0010001, 0x2aab0020,
  0xc0018000, 0xc0017fff, 0xd5555558, 0x199a0020,
  0xc001fffd, 0xd555aaad, 0xe6663336, 0x00400020,
  0xd5560002, 0xe6666669, 0xffc00082, 0x003f8020,
  0xe666999c, 0xffc00101, 0xffc08081, 0x003f0020,
  0xffc00180, 0xffc080ff, 0xffc10080, 0x003e8020,
  0xffc0817d, 0xffc100fd, 0xffc1807f, 0x00080020,
  0xffc1017a, 0xffc180fb, 0xfff80012, 0x00018020,
  0xffc18177, 0xfff80021, 0xfffe8005, 0x00010020,
  0xfff80030, 0xfffe8007, 0xffff0004, 0x00008020,
  0xfffe8006, 0xffff0003, 0x00008002, 0x00000020,
  0xffff0004, 0xffff8002, 0x00000002, 0xffff8021,
  0xffff8002, 0x00000001, 0xffff8002, 0xffff0022,
  0x00000000, 0x00008000, 0xffff0002, 0xfff80030,
  0x00007ffe, 0x0000ffff, 0xfff80002, 0xffc1809d,
  0x0000fffc, 0x0007fff1, 0xffc18002, 0xffc1009e,
  0x0007ffe0, 0x003e7f84, 0xffc10002, 0xffc0809f,
  0x003e7f06, 0x003eff83, 0xffc08002, 0xe666b353,
  0x003eff04, 0x003f7f82, 0xe6668002, 0xd555d575,
  0x003f7f02, 0x19994cce, 0xd5558002, 0xc002001d,
  0x1999199a, 0x2aaa2aac, 0xc0018002, 0xc001801e,
  0x2aa9d556, 0x3ffe0004, 0xc0010002, 0xc001001f,
  0x3ffd8006, 0x3ffe8003, 0xc0008002, 0x3fff8020,
  0x3ffe0004, 0x3fff0002, 0x40000002, 0x3fff0021,
  0x3ffe8002, 0xc0008001, 0x3fff8002, 0x2aaaaaca,
  0xc0010000, 0xc0010000, 0x2aab0002, 0x1999ccec,
  0xc0017ffe, 0xd5555557, 0x199a0002, 0x003fffa0,
  0xd555aaac, 0xe6663335, 0x00400002, 0x003f7fa1,
  0xe6666668, 0xffc00081, 0x003f8002, 0x003effa2,
  0xffc00100, 0xffc08080, 0x003f0002, 0x003e7fa3,
  0xffc080fe, 0xffc1007f, 0x003e8002, 0x00080010,
  0xffc100fc, 0xffc1807e, 0x00080002, 0x0001801d,
  0xffc180fa, 0xfff80011, 0x00018002, 0x0001001e,
  0xfff80020, 0xfffe8004, 0x00010002, 0x0000801f,
  0xfffe8003, 0x00010001, 0x00008001, 0x00000020,
  0xffff0002, 0x00008001, 0x00000002, 0xffffaaca,
  0xffff8001, 0x00000001, 0xffff8003, 0xffff5574,
  0x00000000, 0xffff8001, 0xffff0004, 0xfffaaac0,
  0x00007fff, 0xffff0001, 0xfff80012, 0xffd65522,
  0x0000fffe, 0xfff80001, 0xffc1807f, 0xffd5ffcc,
  0x0007fff0, 0xffc18001, 0xffc10080, 0xffd5aa76,
  0x003e7f83, 0xffc10001, 0xffc08081, 0xeeeeddfe,
  0x003eff82, 0xffc08001, 0xe666b335, 0xe38e1c92,
  0x003f7f81, 0xe6668001, 0xd555d557, 0xd5560022,
  0x19994ccd, 0xd5558001, 0xc001ffff, 0xd555aacc,
  0x2aaa2aab, 0xc0018001, 0xc0018000, 0xd5555576,
  0x3ffe0003, 0xc0010001, 0xc0010001, 0x2aab0020,
  0x3ffe8002, 0xc0008001, 0x3fff8002, 0x2aaaaaca,
  0x3fff0001, 0x40000001, 0x3fff0003, 0x1c723904,
  0xc0008000, 0x3fff8001, 0x2aaaaaac, 0x11117798,
  0xc000ffff, 0x2aab0001, 0x1999ccce, 0x002aab20,
  0xd5555556, 0x199a0001, 0x003fff82, 0x002a55ca,
  0xe6663334, 0x00400001, 0x003f7f83, 0x002a0074,
  0xffc00080, 0x003f8001, 0x003eff84, 0x0029ab1e,
  0xffc0807f, 0x003f0001, 0x003e7f85, 0x00055580,
  0xffc1007e, 0x003e8001, 0x0007fff2, 0x00010022,
  0xffc1807d, 0x00080001, 0x00017fff, 0x0000aacc,
  0xfff80010, 0x00018001, 0x00010000, 0x00005576,
  0x00018000, 0x0000ffff, 0x00005558, 0x00000020,
  0x00010000, 0x00008000, 0x00000002, 0xffffccec,
  0x00008000, 0x00000001, 0xffffaaac, 0xffff99b8,
  0x00000000, 0xffff8002, 0xffff5556, 0xfffccce0,
  0xffff8000, 0xffff0003, 0xfffaaaa2, 0xffe6ffbc,
  0xffff0000, 0xfff80011, 0xffd65504, 0xffe6cc88,
  0xfff80000, 0xffc1807e, 0xffd5ffae, 0xffe69954,
  0xffc18000, 0xffc1007f, 0xffd5aa58, 0xf5c270c4,
  0xffc10000, 0xffc08080, 0xeeeedde0, 0xeeeebbdc,
  0xffc08000, 0xe666b334, 0xe38e1c74, 0xe66699bc,
  0xe6668000, 0xd555d556, 0xd5560004, 0xe6666688,
  0xd5558000, 0xc001fffe, 0xd555aaae, 0xe6663354,
  0xc0018000, 0xc0017fff, 0xd5555558, 0x199a0020,
  0xc0010000, 0xc0010000, 0x2aab0002, 0x1999ccec,
  0xc0008000, 0x3fff8001, 0x2aaaaaac, 0x11117798,
  0x40000000, 0x3fff0002, 0x1c7238e6, 0x0a3dc2b0,
  0x3fff8000, 0x2aaaaaab, 0x1111777a, 0x00199a20,
  0x2aab0000, 0x1999cccd, 0x002aab02, 0x001966ec,
  0x199a0000, 0x003fff81, 0x002a55ac, 0x001933b8,
  0x00400000, 0x003f7f82, 0x002a0056, 0x00190084,
  0x003f8000, 0x003eff83, 0x0029ab00, 0x00033360,
  0x003f0000, 0x003e7f84, 0x00055562, 0x000099bc,
  0x003e8000, 0x0007fff1, 0x00010004, 0x00006688,
  0x00080000, 0x00017ffe, 0x0000aaae, 0x00003354,
  0x00017ffd, 0x0000aaad, 0x00003336, 0x00000020,
  0x0000fffe, 0x00005557, 0x00000002, 0xffffffa0,
  0x00007fff, 0x00000001, 0xffffccce, 0xffffff20,
  0x00000000, 0xffffaaab, 0xffff999a, 0xfffff820,
  0xffff8001, 0xffff5555, 0xfffcccc2, 0xffffc1a0,
  0xffff0002, 0xfffaaaa1, 0xffe6ff9e, 0xffffc120,
  0xfff80010, 0xffd65503, 0xffe6cc6a, 0xffffc0a0,
  0xffc1807d, 0xffd5ffad, 0xffe69936, 0xffe666a0,
  0xffc1007e, 0xffd5aa57, 0xf5c270a6, 0xffd555a0,
  0xffc0807f, 0xeeeedddf, 0xeeeebbbe, 0xffc001a0,
  0xe666b333, 0xe38e1c73, 0xe666999e, 0xffc00120,
  0xd555d555, 0xd5560003, 0xe666666a, 0xffc000a0,
  0xc001fffd, 0xd555aaad, 0xe6663336, 0x00400020,
  0xc0017ffe, 0xd5555557, 0x199a0002, 0x003fffa0,
  0xc000ffff, 0x2aab0001, 0x1999ccce, 0x002aab20,
  0x3fff8000, 0x2aaaaaab, 0x1111777a, 0x00199a20,
  0x3fff0001, 0x1c7238e5, 0x0a3dc292, 0x00004020,
  0x2aaaaaaa, 0x11117779, 0x00199a02, 0x00003fa0,
  0x1999cccc, 0x002aab01, 0x001966ce, 0x00003f20,
  0x003fff80, 0x002a55ab, 0x0019339a, 0x00003ea0,
  0x003f7f81, 0x002a0055, 0x00190066, 0x00000820,
  0x003eff82, 0x0029aaff, 0x00033342, 0x000001a0,
  0x003e7f83, 0x00055561, 0x0000999e, 0x00000120,
  0x0007fff0, 0x00010003, 0x0000666a, 0x000000a0,
  0x00010002, 0x00006669, 0x00000082, 0x00000020,
  0x0000aaac, 0x00003335, 0x00000002, 0xffffffa1,
  0x00005556, 0x00000001, 0xffffff82, 0xffffff22,
  0x00000000, 0xffffcccd, 0xffffff02, 0xfffff830,
  0xffffaaaa, 0xffff9999, 0xfffff802, 0xffffc21d,
  0xffff5554, 0xfffcccc1, 0xffffc182, 0xffffc19e,
  0xfffaaaa0, 0xffe6ff9d, 0xffffc102, 0xffffc11f,
  0xffd65502, 0xffe6cc69, 0xffffc082, 0xffe699d3,
  0xffd5ffac, 0xffe69935, 0xffe66682, 0xffd5aaf5,
  0xffd5aa56, 0xf5c270a5, 0xffd55582, 0xffc0819d,
  0xeeeeddde, 0xeeeebbbd, 0xffc00182, 0xffc0811e,
  0xe38e1c72, 0xe666999d, 0xffc00102, 0xffc0809f,
  0xd5560002, 0xe6666669, 0xffc00082, 0x003f8020,
  0xd555aaac, 0xe6663335, 0x00400002, 0x003f7fa1,
  0xd5555556, 0x199a0001, 0x003fff82, 0x002a55ca,
  0x2aab0000, 0x1999cccd, 0x002aab02, 0x001966ec,
  0x2aaaaaaa, 0x11117779, 0x00199a02, 0x00003fa0,
  0x1c7238e4, 0x0a3dc291, 0x00004002, 0x00003f21,
  0x11117778, 0x00199a01, 0x00003f82, 0x00003ea2,
  0x002aab00, 0x001966cd, 0x00003f02, 0x00003e23,
  0x002a55aa, 0x00193399, 0x00003e82, 0x00000810,
  0x002a0054, 0x00190065, 0x00000802, 0x0000019d,
  0x0029aafe, 0x00033341, 0x00000182, 0x0000011e,
  0x00055560, 0x0000999d, 0x00000102, 0x0000009f,
  0x0000999c, 0x00000101, 0x00000081, 0x00000020,
  0x00006668, 0x00000081, 0x00000002, 0xffffffa2,
  0x00003334, 0x00000001, 0xffffff83, 0xffffff24,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff840,
  0xffffcccc, 0xffffff01, 0xfffff812, 0xffffc29a,
  0xffff9998, 0xfffff801, 0xffffc1ff, 0xffffc21c,
  0xfffcccc0, 0xffffc181, 0xffffc180, 0xffffc19e,
  0xffe6ff9c, 0xffffc101, 0xffffc101, 0xffe6cd06,
  0xffe6cc68, 0xffffc081, 0xffe699b5, 0xffd6004a,
  0xffe69934, 0xffe66681, 0xffd5aad7, 0xffc1019a,
  0xf5c270a4, 0xffd55581, 0xffc0817f, 0xffc1011c,
  0xeeeebbbc, 0xffc00181, 0xffc08100, 0xffc1009e,
  0xe666999c, 0xffc00101, 0xffc08081, 0x003f0020,
  0xe6666668, 0xffc00081, 0x003f8002, 0x003effa2,
  0xe6663334, 0x00400001, 0x003f7f83, 0x002a0074,
  0x199a0000, 0x003fff81, 0x002a55ac, 0x001933b8,
  0x1999cccc, 0x002aab01, 0x001966ce, 0x00003f20,
  0x11117778, 0x00199a01, 0x00003f82, 0x00003ea2,
  0x0a3dc290, 0x00004001, 0x00003f03, 0x00003e24,
  0x00199a00, 0x00003f81, 0x00003e84, 0x00003da6,
  0x001966cc, 0x00003f01, 0x00003e05, 0x00000800,
  0x00193398, 0x00003e81, 0x000007f2, 0x0000019a,
  0x00190064, 0x00000801, 0x0000017f, 0x0000011c,
  0x00033340, 0x00000181, 0x00000100, 0x0000009e,
  0x00000180, 0x000000ff, 0x00000080, 0x00000020,
  0x00000100, 0x00000080, 0x00000002, 0xffffffa3,
  0x00000080, 0x00000001, 0xffffff84, 0xffffff26,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffff850,
  0xffffff80, 0xffffff03, 0xfffff822, 0xffffc317,
  0xffffff00, 0xfffff811, 0xffffc27c, 0xffffc29a,
  0xfffff800, 0xffffc1fe, 0xffffc1fe, 0xffffc21d,
  0xffffc180, 0xffffc17f, 0xffffc180, 0xffe70039,
  0xffffc100, 0xffffc100, 0xffe6cce8, 0xffd6559f,
  0xffffc080, 0xffe699b4, 0xffd6002c, 0xffc18197,
  0xffe66680, 0xffd5aad6, 0xffc1017c, 0xffc1811a,
  0xffd55580, 0xffc0817e, 0xffc100fe, 0xffc1809d,
  0xffc00180, 0xffc080ff, 0xffc10080, 0x003e8020,
  0xffc00100, 0xffc08080, 0x003f0002, 0x003e7fa3,
  0xffc00080, 0x003f8001, 0x003eff84, 0x0029ab1e,
  0x00400000, 0x003f7f82, 0x002a0056, 0x00190084,
  0x003fff80, 0x002a55ab, 0x0019339a, 0x00003ea0,
  0x002aab00, 0x001966cd, 0x00003f02, 0x00003e23,
  0x00199a00, 0x00003f81, 0x00003e84, 0x00003da6,
  0x00004000, 0x00003f02, 0x00003e06, 0x00003d29,
  0x00003f80, 0x00003e83, 0x00003d88, 0x000007f0,
  0x00003f00, 0x00003e04, 0x000007e2, 0x00000197,
  0x00003e80, 0x000007f1, 0x0000017c, 0x0000011a,
  0x00000800, 0x0000017e, 0x000000fe, 0x0000009d,
  0x0000017d, 0x000000fd, 0x0000007f, 0x00000020,
  0x000000fe, 0x0000007f, 0x00000002, 0x00000010,
  0x0000007f, 0x00000001, 0xffffff85, 0x00000000,
  0x00000000, 0xffffff83, 0xffffff08, 0xffffff20,
  0xffffff81, 0xffffff05, 0xfffff832, 0xfffff850,
  0xffffff02, 0xfffff821, 0xffffc2f9, 0xfffff840,
  0xfffff810, 0xffffc27b, 0xffffc27c, 0xfffff830,
  0xffffc1fd, 0xffffc1fd, 0xffffc1ff, 0xfffcccf0,
  0xffffc17e, 0xffffc17f, 0xffe7001b, 0xfffaaad0,
  0xffffc0ff, 0xffe6cce7, 0xffd65581, 0xfff80050,
  0xffe699b3, 0xffd6002b, 0xffc18179, 0xfff80040,
  0xffd5aad5, 0xffc1017b, 0xffc180fc, 0xfff80030,
  0xffc0817d, 0xffc100fd, 0xffc1807f, 0x00080020,
  0xffc080fe, 0xffc1007f, 0x003e8002, 0x00080010,
  0xffc0807f, 0x003f0001, 0x003e7f85, 0x00055580,
  0x003f8000, 0x003eff83, 0x0029ab00, 0x00033360,
  0x003f7f81, 0x002a0055, 0x00190066, 0x00000820,
  0x002a55aa, 0x00193399, 0x00003e82, 0x00000810,
  0x001966cc, 0x00003f01, 0x00003e05, 0x00000800,
  0x00003f80, 0x00003e83, 0x00003d88, 0x000007f0,
  0x00003f01, 0x00003e05, 0x00003d0b, 0x00000120,
  0x00003e82, 0x00003d87, 0x000007d2, 0x00000050,
  0x00003e03, 0x000007e1, 0x00000179, 0x00000040,
  0x000007f0, 0x0000017b, 0x000000fc, 0x00000030,
  0x0000017a, 0x000000fb, 0x00000012, 0x00000020,
  0x000000fc, 0x0000007e, 0x00000002, 0x0000001d,
  0x0000007e, 0x00000001, 0xfffffff2, 0x0000001a,
  0x00000000, 0xffffff84, 0xffffffe2, 0xfffffff0,
  0xffffff82, 0xffffff07, 0xffffff02, 0xfffffea9,
  0xffffff04, 0xfffff831, 0xfffff832, 0xfffffea6,
  0xfffff820, 0xffffc2f8, 0xfffff822, 0xfffffea3,
  0xffffc27a, 0xffffc27b, 0xfffff812, 0xffff6687,
  0xffffc1fc, 0xffffc1fe, 0xfffcccd2, 0xffff0021,
  0xffffc17e, 0xffe7001a, 0xfffaaab2, 0xfffe8029,
  0xffe6cce6, 0xffd65580, 0xfff80032, 0xfffe8026,
  0xffd6002a, 0xffc18178, 0xfff80022, 0xfffe8023,
  0xffc1017a, 0xffc180fb, 0xfff80012, 0x00018020,
  0xffc100fc, 0xffc1807e, 0x00080002, 0x0001801d,
  0xffc1007e, 0x003e8001, 0x0007fff2, 0x00010022,
  0x003f0000, 0x003e7f84, 0x00055562, 0x000099bc,
  0x003eff82, 0x0029aaff, 0x00033342, 0x000001a0,
  0x002a0054, 0x00190065, 0x00000802, 0x0000019d,
  0x00193398, 0x00003e81, 0x000007f2, 0x0000019a,
  0x00003f00, 0x00003e04, 0x000007e2, 0x00000197,
  0x00003e82, 0x00003d87, 0x000007d2, 0x00000050,
  0x00003e04, 0x00003d0a, 0x00000102, 0x00000029,
  0x00003d86, 0x000007d1, 0x00000032, 0x00000026,
  0x000007e0, 0x00000178, 0x00000022, 0x00000023,
  0x00000177, 0x00000021, 0x00000005, 0x00000020,
  0x000000fa, 0x00000011, 0x00000002, 0x0000001e,
  0x0000007d, 0x00000001, 0xffffffff, 0x0000001c,
  0x00000000, 0xfffffff1, 0xfffffffc, 0x00000000,
  0xffffff83, 0xffffffe1, 0xffffffd2, 0xffffff26,
  0xffffff06, 0xffffff01, 0xfffffe8b, 0xffffff24,
  0xfffff830, 0xfffff831, 0xfffffe88, 0xffffff22,
  0xffffc2f7, 0xfffff821, 0xfffffe85, 0xffff99ba,
  0xffffc27a, 0xfffff811, 0xffff6669, 0xffff5576,
  0xffffc1fd, 0xfffcccd1, 0xffff0003, 0xffff0026,
  0xffe70019, 0xfffaaab1, 0xfffe800b, 0xffff0024,
  0xffd6557f, 0xfff80031, 0xfffe8008, 0xffff0022,
  0xffc18177, 0xfff80021, 0xfffe8005, 0x00010020,
  0xffc180fa, 0xfff80011, 0x00018002, 0x0001001e,
  0xffc1807d, 0x00080001, 0x00017fff, 0x0000aacc,
  0x003e8000, 0x0007fff1, 0x00010004, 0x00006688,
  0x003e7f83, 0x00055561, 0x0000999e, 0x00000120,
  0x0029aafe, 0x00033341, 0x00000182, 0x0000011e,
  0x00190064, 0x00000801, 0x0000017f, 0x0000011c,
  0x00003e80, 0x000007f1, 0x0000017c, 0x0000011a,
  0x00003e03, 0x000007e1, 0x00000179, 0x00000040,
  0x00003d86, 0x000007d1, 0x00000032, 0x00000026,
  0x00003d09, 0x00000101, 0x0000000b, 0x00000024,
  0x000007d0, 0x00000031, 0x00000008, 0x00000022,
  0x00000030, 0x00000007, 0x00000004, 0x00000020,
  0x00000020, 0x00000004, 0x00000002, 0x0000001f,
  0x00000010, 0x00000001, 0x00000000, 0x0000001e,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000010,
  0xfffffff0, 0xfffffffb, 0xffffffe2, 0xffffffa3,
  0xffffffe0, 0xffffffd1, 0xffffff08, 0xffffffa2,
  0xffffff00, 0xfffffe8a, 0xffffff06, 0xffffffa1,
  0xfffff830, 0xfffffe87, 0xffffff04, 0xffffcced,
  0xfffff820, 0xfffffe84, 0xffff999c, 0xffffaacb,
  0xfffff810, 0xffff6668, 0xffff5558, 0xffff8023,
  0xfffcccd0, 0xffff0002, 0xffff0008, 0xffff8022,
  0xfffaaab0, 0xfffe800a, 0xffff0006, 0xffff8021,
  0xfff80030, 0xfffe8007, 0xffff0004, 0x00008020,
  0xfff80020, 0xfffe8004, 0x00010002, 0x0000801f,
  0xfff80010, 0x00018001, 0x00010000, 0x00005576,
  0x00080000, 0x00017ffe, 0x0000aaae, 0x00003354,
  0x0007fff0, 0x00010003, 0x0000666a, 0x000000a0,
  0x00055560, 0x0000999d, 0x00000102, 0x0000009f,
  0x00033340, 0x00000181, 0x00000100, 0x0000009e,
  0x00000800, 0x0000017e, 0x000000fe, 0x0000009d,
  0x000007f0, 0x0000017b, 0x000000fc, 0x00000030,
  0x000007e0, 0x00000178, 0x00000022, 0x00000023,
  0x000007d0, 0x00000031, 0x00000008, 0x00000022,
  0x00000100, 0x0000000a, 0x00000006, 0x00000021,
};
const unsigned kExpectedCount_NEON_smlal2_4S = 576;

#endif  // VIXL_SIM_SMLAL2_4S_TRACE_AARCH64_H_
