// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMIN_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SMIN_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smin_4S[] = {
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x00000000, 0x00000000,
  0x00007e00, 0x00000000, 0x00000001, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000000,
  0x00000001, 0x00000002, 0x00000020, 0x00000000,
  0x00000002, 0x00000020, 0x0000007d, 0x00000000,
  0x00000020, 0x0000007d, 0x0000007e, 0x00000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00000000,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00000000,
  0x0000007f, 0x00007f00, 0x00007ffe, 0x00000000,
  0x00007e00, 0x00007f00, 0x00007fff, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x00000000,
  0x00007e00, 0x00007f00, 0x007ffd00, 0x80000000,
  0x00007e00, 0x00007f00, 0x80000000, 0x80000001,
  0x00007e00, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000000, 0x00000001,
  0x00000000, 0x00000001, 0x00000000, 0x00000001,
  0x00000001, 0x00000002, 0x00000000, 0x00000001,
  0x00000002, 0x00000020, 0x00000000, 0x00000001,
  0x00000020, 0x0000007d, 0x00000000, 0x00000001,
  0x0000007d, 0x0000007e, 0x00000000, 0x00000001,
  0x0000007e, 0x0000007f, 0x00000000, 0x00000001,
  0x0000007f, 0x00007ffd, 0x00000000, 0x00000001,
  0x00007f00, 0x00007ffe, 0x00000000, 0x00000001,
  0x00007f00, 0x00007fff, 0x00000000, 0x00000001,
  0x00007f00, 0x007ffd00, 0x00000000, 0x00000001,
  0x00007f00, 0x007ffd00, 0x00000000, 0x00000001,
  0x00007f00, 0x007ffd00, 0x00000000, 0x00000001,
  0x00007f00, 0x007ffd00, 0x00000000, 0x80000000,
  0x00007f00, 0x007ffd00, 0x80000000, 0x80000001,
  0x00007f00, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000000, 0x00000001, 0x00000002,
  0x00000001, 0x00000000, 0x00000001, 0x00000002,
  0x00000002, 0x00000000, 0x00000001, 0x00000002,
  0x00000020, 0x00000000, 0x00000001, 0x00000002,
  0x0000007d, 0x00000000, 0x00000001, 0x00000002,
  0x0000007e, 0x00000000, 0x00000001, 0x00000002,
  0x0000007f, 0x00000000, 0x00000001, 0x00000002,
  0x00007ffd, 0x00000000, 0x00000001, 0x00000002,
  0x00007ffe, 0x00000000, 0x00000001, 0x00000002,
  0x00007fff, 0x00000000, 0x00000001, 0x00000002,
  0x007ffd00, 0x00000000, 0x00000001, 0x00000002,
  0x007ffd00, 0x00000000, 0x00000001, 0x00000002,
  0x007ffd00, 0x00000000, 0x00000001, 0x80000000,
  0x007ffd00, 0x00000000, 0x80000000, 0x80000001,
  0x007ffd00, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x80000000,
  0x00000000, 0x00000001, 0x80000000, 0x80000001,
  0x00000000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000001, 0x00000002, 0x00000020, 0x80000000,
  0x00000001, 0x00000002, 0x80000000, 0x80000001,
  0x00000001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000002, 0x00000020, 0x0000007d, 0x80000000,
  0x00000002, 0x00000020, 0x80000000, 0x80000001,
  0x00000002, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000020, 0x0000007d, 0x0000007e, 0x80000000,
  0x00000020, 0x0000007d, 0x80000000, 0x80000001,
  0x00000020, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007d, 0x0000007e, 0x0000007f, 0x80000000,
  0x0000007d, 0x0000007e, 0x80000000, 0x80000001,
  0x0000007d, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x80000000,
  0x0000007e, 0x0000007f, 0x80000000, 0x80000001,
  0x0000007e, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x80000000,
  0x0000007f, 0x00007ffd, 0x80000000, 0x80000001,
  0x0000007f, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x80000000,
  0x00007ffd, 0x00007ffe, 0x80000000, 0x80000001,
  0x00007ffd, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007ffe, 0x00007fff, 0x33333333, 0x80000000,
  0x00007ffe, 0x00007fff, 0x80000000, 0x80000001,
  0x00007ffe, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x00007fff, 0x33333333, 0x55555555, 0x80000000,
  0x00007fff, 0x33333333, 0x80000000, 0x80000001,
  0x00007fff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x33333333, 0x55555555, 0x7ffffffd, 0x80000000,
  0x33333333, 0x55555555, 0x80000000, 0x80000001,
  0x33333333, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x7fffffff,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x80000000,
  0x55555555, 0x7ffffffd, 0x80000000, 0x80000001,
  0x55555555, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x80000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x80000000,
  0xffffffff, 0x00000000, 0x00000001, 0x80000000,
  0x00000000, 0x00000001, 0x00000002, 0x80000000,
  0x00000001, 0x00000002, 0x00000020, 0x80000000,
  0x00000002, 0x00000020, 0x0000007d, 0x80000000,
  0x00000020, 0x0000007d, 0x0000007e, 0x80000000,
  0x0000007d, 0x0000007e, 0x0000007f, 0x80000000,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x80000000,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x80000000,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x80000000,
  0x00007ffe, 0x00007fff, 0x33333333, 0x80000000,
  0x00007fff, 0x33333333, 0x55555555, 0x80000000,
  0x33333333, 0x55555555, 0x7ffffffd, 0x80000000,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x80000000,
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0x7ffffffd, 0x7ffffffe, 0x80000000, 0x80000000,
  0x7ffffffd, 0x80000000, 0x80000001, 0x80000000,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0x80000000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0x80000000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0x80000000,
  0xcccccccc, 0xffff8000, 0xffff8001, 0x80000000,
  0xffff8000, 0xffff8001, 0xffff8002, 0x80000000,
  0xffff8001, 0xffff8002, 0xffff8003, 0x80000000,
  0xffff8002, 0xffff8003, 0xffffff80, 0x80000000,
  0xffff8003, 0xffffff80, 0xffffff81, 0x80000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0x80000000,
  0xffffff81, 0xffffff82, 0xffffff83, 0x80000000,
  0xffffff82, 0xffffff83, 0xffffffe0, 0x80000000,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0x80000000,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0x80000000,
  0xfffffffd, 0xfffffffe, 0x80000000, 0x80000001,
  0xfffffffe, 0xffffffff, 0x80000000, 0x80000001,
  0xffffffff, 0x00000000, 0x80000000, 0x80000001,
  0x00000000, 0x00000001, 0x80000000, 0x80000001,
  0x00000001, 0x00000002, 0x80000000, 0x80000001,
  0x00000002, 0x00000020, 0x80000000, 0x80000001,
  0x00000020, 0x0000007d, 0x80000000, 0x80000001,
  0x0000007d, 0x0000007e, 0x80000000, 0x80000001,
  0x0000007e, 0x0000007f, 0x80000000, 0x80000001,
  0x0000007f, 0x00007ffd, 0x80000000, 0x80000001,
  0x00007ffd, 0x00007ffe, 0x80000000, 0x80000001,
  0x00007ffe, 0x00007fff, 0x80000000, 0x80000001,
  0x00007fff, 0x33333333, 0x80000000, 0x80000001,
  0x33333333, 0x55555555, 0x80000000, 0x80000001,
  0x55555555, 0x7ffffffd, 0x80000000, 0x80000001,
  0x7ffffffd, 0x7ffffffe, 0x80000000, 0x80000000,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000001,
  0x7ffffffe, 0x80000000, 0x80000000, 0x80000001,
  0x80000000, 0x80000001, 0x80000000, 0x80000001,
  0x80000001, 0xaaaaaaaa, 0x80000000, 0x80000001,
  0xaaaaaaaa, 0xcccccccc, 0x80000000, 0x80000001,
  0xcccccccc, 0xffff8000, 0x80000000, 0x80000001,
  0xffff8000, 0xffff8001, 0x80000000, 0x80000001,
  0xffff8001, 0xffff8002, 0x80000000, 0x80000001,
  0xffff8002, 0xffff8003, 0x80000000, 0x80000001,
  0xffff8003, 0xffffff80, 0x80000000, 0x80000001,
  0xffffff80, 0xffffff81, 0x80000000, 0x80000001,
  0xffffff81, 0xffffff82, 0x80000000, 0x80000001,
  0xffffff82, 0xffffff83, 0x80000000, 0x80000001,
  0xffffff83, 0xffffffe0, 0x80000000, 0x80000001,
  0xffffffe0, 0xfffffffd, 0x80000000, 0x80000001,
  0xfffffffd, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xfffffffe, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00000000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00000001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00000002, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00000020, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x0000007d, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x0000007e, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x0000007f, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00007ffd, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00007ffe, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x00007fff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x33333333, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x55555555, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x7ffffffd, 0x80000000, 0x80000001, 0x80000000,
  0x7ffffffe, 0x80000000, 0x80000000, 0x80000001,
  0x7fffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xaaaaaaaa, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xcccccccc, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffff8000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffff8001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffff8002, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffff8003, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffff80, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffff81, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffff82, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffff83, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffffe0, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0x80000000,
  0x80000000, 0x80000001, 0x80000000, 0x80000001,
  0x80000000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0x80000000,
  0x80000001, 0xaaaaaaaa, 0x80000000, 0x80000001,
  0x80000001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0x80000000,
  0xaaaaaaaa, 0xcccccccc, 0x80000000, 0x80000001,
  0xaaaaaaaa, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0x80000000,
  0xcccccccc, 0xffff8000, 0x80000000, 0x80000001,
  0xcccccccc, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0x80000000,
  0xffff8000, 0xffff8001, 0x80000000, 0x80000001,
  0xffff8000, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0x80000000,
  0xffff8001, 0xffff8002, 0x80000000, 0x80000001,
  0xffff8001, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0x80000000,
  0xffff8002, 0xffff8003, 0x80000000, 0x80000001,
  0xffff8002, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0x80000000,
  0xffff8003, 0xffffff80, 0x80000000, 0x80000001,
  0xffff8003, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0x80000000,
  0xffffff80, 0xffffff81, 0x80000000, 0x80000001,
  0xffffff80, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0x80000000,
  0xffffff81, 0xffffff82, 0x80000000, 0x80000001,
  0xffffff81, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0x80000000,
  0xffffff82, 0xffffff83, 0x80000000, 0x80000001,
  0xffffff82, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0x80000000,
  0xffffff83, 0xffffffe0, 0x80000000, 0x80000001,
  0xffffff83, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0x80000000,
  0xffffffe0, 0xfffffffd, 0x80000000, 0x80000001,
  0xffffffe0, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
};
const unsigned kExpectedCount_NEON_smin_4S = 961;

#endif  // VIXL_SIM_SMIN_4S_TRACE_AARCH64_H_
