// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_ADDP_4H_TRACE_AARCH64_H_
#define VIXL_SIM_ADDP_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_addp_4H[] = {
  0x00fd, 0x8888, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffb, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x7fff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0x7fff, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0003, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0012, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0003, 0x008d, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0012, 0x00fb, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x008d, 0x00fd, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fb, 0x33b2, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fd, 0x8888, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x33b2, 0xd552, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8888, 0xfffb, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd552, 0xfffd, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffb, 0xffff, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfffd, 0x0001, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x2aab, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x7776, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0xcc4c, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7776, 0xff01, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcc4c, 0xff03, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xff03, 0xff73, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xff05, 0xffed, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xff73, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xffed, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xffff, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x0001, 0x0012, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x0003, 0x008d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x0012, 0x00fb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x008d, 0x00fd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x00fb, 0x33b2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x00fd, 0x8888, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x33b2, 0xd552, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x8888, 0xfffb, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xd552, 0xfffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xfffb, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xfffd, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xffff, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x0001, 0x7776, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x2aab, 0xcc4c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0x7776, 0xff01, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xcc4c, 0xff03, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff01, 0xff05, 0xff01, 0xff05, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_addp_4H = 576;

#endif  // VIXL_SIM_ADDP_4H_TRACE_AARCH64_H_
