// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(add)                       \
  M(sub)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{pl, r0, r0, 7}, true, pl, "pl r0 r0 7", "pl_r0_r0_7"},
     {{cs, r0, r2, 5}, true, cs, "cs r0 r2 5", "cs_r0_r2_5"},
     {{ls, r1, r6, 0}, true, ls, "ls r1 r6 0", "ls_r1_r6_0"},
     {{cc, r5, r1, 6}, true, cc, "cc r5 r1 6", "cc_r5_r1_6"},
     {{cs, r5, r2, 0}, true, cs, "cs r5 r2 0", "cs_r5_r2_0"},
     {{vs, r5, r6, 7}, true, vs, "vs r5 r6 7", "vs_r5_r6_7"},
     {{ls, r2, r0, 5}, true, ls, "ls r2 r0 5", "ls_r2_r0_5"},
     {{eq, r3, r4, 5}, true, eq, "eq r3 r4 5", "eq_r3_r4_5"},
     {{lt, r4, r5, 7}, true, lt, "lt r4 r5 7", "lt_r4_r5_7"},
     {{lt, r6, r7, 1}, true, lt, "lt r6 r7 1", "lt_r6_r7_1"},
     {{eq, r1, r0, 3}, true, eq, "eq r1 r0 3", "eq_r1_r0_3"},
     {{le, r4, r1, 0}, true, le, "le r4 r1 0", "le_r4_r1_0"},
     {{vc, r5, r2, 5}, true, vc, "vc r5 r2 5", "vc_r5_r2_5"},
     {{cs, r1, r1, 5}, true, cs, "cs r1 r1 5", "cs_r1_r1_5"},
     {{cs, r2, r5, 4}, true, cs, "cs r2 r5 4", "cs_r2_r5_4"},
     {{ge, r7, r5, 7}, true, ge, "ge r7 r5 7", "ge_r7_r5_7"},
     {{eq, r3, r4, 4}, true, eq, "eq r3 r4 4", "eq_r3_r4_4"},
     {{ls, r1, r0, 2}, true, ls, "ls r1 r0 2", "ls_r1_r0_2"},
     {{vc, r1, r2, 0}, true, vc, "vc r1 r2 0", "vc_r1_r2_0"},
     {{ls, r6, r6, 4}, true, ls, "ls r6 r6 4", "ls_r6_r6_4"},
     {{hi, r3, r1, 0}, true, hi, "hi r3 r1 0", "hi_r3_r1_0"},
     {{ge, r7, r1, 0}, true, ge, "ge r7 r1 0", "ge_r7_r1_0"},
     {{ge, r2, r0, 0}, true, ge, "ge r2 r0 0", "ge_r2_r0_0"},
     {{ge, r1, r7, 0}, true, ge, "ge r1 r7 0", "ge_r1_r7_0"},
     {{lt, r5, r2, 0}, true, lt, "lt r5 r2 0", "lt_r5_r2_0"},
     {{ls, r6, r3, 0}, true, ls, "ls r6 r3 0", "ls_r6_r3_0"},
     {{ne, r5, r7, 4}, true, ne, "ne r5 r7 4", "ne_r5_r7_4"},
     {{le, r5, r3, 2}, true, le, "le r5 r3 2", "le_r5_r3_2"},
     {{eq, r6, r1, 4}, true, eq, "eq r6 r1 4", "eq_r6_r1_4"},
     {{gt, r6, r0, 1}, true, gt, "gt r6 r0 1", "gt_r6_r0_1"},
     {{pl, r5, r2, 2}, true, pl, "pl r5 r2 2", "pl_r5_r2_2"},
     {{ls, r7, r2, 0}, true, ls, "ls r7 r2 0", "ls_r7_r2_0"},
     {{hi, r4, r7, 6}, true, hi, "hi r4 r7 6", "hi_r4_r7_6"},
     {{hi, r1, r2, 5}, true, hi, "hi r1 r2 5", "hi_r1_r2_5"},
     {{ls, r3, r0, 3}, true, ls, "ls r3 r0 3", "ls_r3_r0_3"},
     {{le, r5, r5, 7}, true, le, "le r5 r5 7", "le_r5_r5_7"},
     {{pl, r5, r0, 2}, true, pl, "pl r5 r0 2", "pl_r5_r0_2"},
     {{cs, r3, r1, 7}, true, cs, "cs r3 r1 7", "cs_r3_r1_7"},
     {{le, r4, r6, 6}, true, le, "le r4 r6 6", "le_r4_r6_6"},
     {{lt, r7, r5, 2}, true, lt, "lt r7 r5 2", "lt_r7_r5_2"},
     {{le, r5, r4, 3}, true, le, "le r5 r4 3", "le_r5_r4_3"},
     {{ne, r4, r7, 0}, true, ne, "ne r4 r7 0", "ne_r4_r7_0"},
     {{gt, r0, r3, 5}, true, gt, "gt r0 r3 5", "gt_r0_r3_5"},
     {{hi, r0, r4, 5}, true, hi, "hi r0 r4 5", "hi_r0_r4_5"},
     {{cs, r4, r0, 6}, true, cs, "cs r4 r0 6", "cs_r4_r0_6"},
     {{ne, r6, r3, 0}, true, ne, "ne r6 r3 0", "ne_r6_r3_0"},
     {{ge, r0, r5, 3}, true, ge, "ge r0 r5 3", "ge_r0_r5_3"},
     {{vc, r4, r2, 7}, true, vc, "vc r4 r2 7", "vc_r4_r2_7"},
     {{le, r3, r0, 6}, true, le, "le r3 r0 6", "le_r3_r0_6"},
     {{lt, r0, r4, 5}, true, lt, "lt r0 r4 5", "lt_r0_r4_5"},
     {{cs, r7, r0, 4}, true, cs, "cs r7 r0 4", "cs_r7_r0_4"},
     {{ge, r0, r0, 6}, true, ge, "ge r0 r0 6", "ge_r0_r0_6"},
     {{hi, r2, r6, 0}, true, hi, "hi r2 r6 0", "hi_r2_r6_0"},
     {{hi, r1, r4, 0}, true, hi, "hi r1 r4 0", "hi_r1_r4_0"},
     {{lt, r1, r5, 5}, true, lt, "lt r1 r5 5", "lt_r1_r5_5"},
     {{eq, r0, r6, 7}, true, eq, "eq r0 r6 7", "eq_r0_r6_7"},
     {{hi, r2, r4, 6}, true, hi, "hi r2 r4 6", "hi_r2_r4_6"},
     {{ls, r4, r4, 2}, true, ls, "ls r4 r4 2", "ls_r4_r4_2"},
     {{gt, r1, r5, 5}, true, gt, "gt r1 r5 5", "gt_r1_r5_5"},
     {{gt, r5, r4, 2}, true, gt, "gt r5 r4 2", "gt_r5_r4_2"},
     {{gt, r0, r3, 6}, true, gt, "gt r0 r3 6", "gt_r0_r3_6"},
     {{hi, r6, r2, 6}, true, hi, "hi r6 r2 6", "hi_r6_r2_6"},
     {{le, r0, r7, 5}, true, le, "le r0 r7 5", "le_r0_r7_5"},
     {{mi, r2, r7, 6}, true, mi, "mi r2 r7 6", "mi_r2_r7_6"},
     {{le, r5, r6, 2}, true, le, "le r5 r6 2", "le_r5_r6_2"},
     {{eq, r0, r4, 5}, true, eq, "eq r0 r4 5", "eq_r0_r4_5"},
     {{hi, r4, r5, 2}, true, hi, "hi r4 r5 2", "hi_r4_r5_2"},
     {{gt, r0, r7, 0}, true, gt, "gt r0 r7 0", "gt_r0_r7_0"},
     {{eq, r6, r4, 0}, true, eq, "eq r6 r4 0", "eq_r6_r4_0"},
     {{mi, r2, r2, 4}, true, mi, "mi r2 r2 4", "mi_r2_r2_4"},
     {{vs, r7, r4, 2}, true, vs, "vs r7 r4 2", "vs_r7_r4_2"},
     {{ne, r5, r3, 6}, true, ne, "ne r5 r3 6", "ne_r5_r3_6"},
     {{ge, r0, r3, 2}, true, ge, "ge r0 r3 2", "ge_r0_r3_2"},
     {{cc, r1, r5, 5}, true, cc, "cc r1 r5 5", "cc_r1_r5_5"},
     {{ge, r7, r3, 5}, true, ge, "ge r7 r3 5", "ge_r7_r3_5"},
     {{ls, r6, r4, 0}, true, ls, "ls r6 r4 0", "ls_r6_r4_0"},
     {{cs, r5, r1, 4}, true, cs, "cs r5 r1 4", "cs_r5_r1_4"},
     {{ls, r6, r7, 0}, true, ls, "ls r6 r7 0", "ls_r6_r7_0"},
     {{cc, r5, r7, 5}, true, cc, "cc r5 r7 5", "cc_r5_r7_5"},
     {{eq, r0, r2, 5}, true, eq, "eq r0 r2 5", "eq_r0_r2_5"},
     {{hi, r1, r6, 6}, true, hi, "hi r1 r6 6", "hi_r1_r6_6"},
     {{vs, r4, r6, 7}, true, vs, "vs r4 r6 7", "vs_r4_r6_7"},
     {{lt, r1, r5, 4}, true, lt, "lt r1 r5 4", "lt_r1_r5_4"},
     {{gt, r1, r2, 7}, true, gt, "gt r1 r2 7", "gt_r1_r2_7"},
     {{cc, r4, r5, 4}, true, cc, "cc r4 r5 4", "cc_r4_r5_4"},
     {{pl, r6, r5, 2}, true, pl, "pl r6 r5 2", "pl_r6_r5_2"},
     {{lt, r5, r1, 0}, true, lt, "lt r5 r1 0", "lt_r5_r1_0"},
     {{vc, r1, r7, 1}, true, vc, "vc r1 r7 1", "vc_r1_r7_1"},
     {{eq, r1, r2, 6}, true, eq, "eq r1 r2 6", "eq_r1_r2_6"},
     {{ls, r0, r4, 2}, true, ls, "ls r0 r4 2", "ls_r0_r4_2"},
     {{vs, r2, r6, 0}, true, vs, "vs r2 r6 0", "vs_r2_r6_0"},
     {{le, r6, r3, 6}, true, le, "le r6 r3 6", "le_r6_r3_6"},
     {{mi, r6, r7, 1}, true, mi, "mi r6 r7 1", "mi_r6_r7_1"},
     {{lt, r2, r0, 5}, true, lt, "lt r2 r0 5", "lt_r2_r0_5"},
     {{le, r0, r6, 1}, true, le, "le r0 r6 1", "le_r0_r6_1"},
     {{hi, r6, r6, 6}, true, hi, "hi r6 r6 6", "hi_r6_r6_6"},
     {{eq, r5, r6, 1}, true, eq, "eq r5 r6 1", "eq_r5_r6_1"},
     {{eq, r2, r1, 4}, true, eq, "eq r2 r1 4", "eq_r2_r1_4"},
     {{gt, r5, r6, 5}, true, gt, "gt r5 r6 5", "gt_r5_r6_5"},
     {{vc, r3, r4, 3}, true, vc, "vc r3 r4 3", "vc_r3_r4_3"},
     {{cc, r0, r1, 4}, true, cc, "cc r0 r1 4", "cc_r0_r1_4"},
     {{hi, r3, r1, 7}, true, hi, "hi r3 r1 7", "hi_r3_r1_7"},
     {{ge, r2, r3, 5}, true, ge, "ge r2 r3 5", "ge_r2_r3_5"},
     {{mi, r1, r0, 5}, true, mi, "mi r1 r0 5", "mi_r1_r0_5"},
     {{vc, r3, r0, 3}, true, vc, "vc r3 r0 3", "vc_r3_r0_3"},
     {{vs, r0, r5, 7}, true, vs, "vs r0 r5 7", "vs_r0_r5_7"},
     {{eq, r2, r1, 5}, true, eq, "eq r2 r1 5", "eq_r2_r1_5"},
     {{ne, r3, r0, 0}, true, ne, "ne r3 r0 0", "ne_r3_r0_0"},
     {{vs, r0, r6, 1}, true, vs, "vs r0 r6 1", "vs_r0_r6_1"},
     {{cs, r6, r1, 4}, true, cs, "cs r6 r1 4", "cs_r6_r1_4"},
     {{cs, r5, r2, 4}, true, cs, "cs r5 r2 4", "cs_r5_r2_4"},
     {{cs, r4, r4, 7}, true, cs, "cs r4 r4 7", "cs_r4_r4_7"},
     {{vs, r1, r2, 4}, true, vs, "vs r1 r2 4", "vs_r1_r2_4"},
     {{ne, r0, r1, 6}, true, ne, "ne r0 r1 6", "ne_r0_r1_6"},
     {{ge, r2, r4, 0}, true, ge, "ge r2 r4 0", "ge_r2_r4_0"},
     {{pl, r0, r4, 4}, true, pl, "pl r0 r4 4", "pl_r0_r4_4"},
     {{vs, r6, r2, 6}, true, vs, "vs r6 r2 6", "vs_r6_r2_6"},
     {{lt, r4, r0, 6}, true, lt, "lt r4 r0 6", "lt_r4_r0_6"},
     {{cc, r3, r1, 2}, true, cc, "cc r3 r1 2", "cc_r3_r1_2"},
     {{hi, r6, r1, 2}, true, hi, "hi r6 r1 2", "hi_r6_r1_2"},
     {{cc, r0, r5, 4}, true, cc, "cc r0 r5 4", "cc_r0_r5_4"},
     {{lt, r3, r3, 2}, true, lt, "lt r3 r3 2", "lt_r3_r3_2"},
     {{vc, r0, r2, 3}, true, vc, "vc r0 r2 3", "vc_r0_r2_3"},
     {{ne, r5, r3, 5}, true, ne, "ne r5 r3 5", "ne_r5_r3_5"},
     {{gt, r4, r3, 6}, true, gt, "gt r4 r3 6", "gt_r4_r3_6"},
     {{eq, r5, r5, 7}, true, eq, "eq r5 r5 7", "eq_r5_r5_7"},
     {{cc, r6, r1, 6}, true, cc, "cc r6 r1 6", "cc_r6_r1_6"},
     {{ls, r4, r4, 4}, true, ls, "ls r4 r4 4", "ls_r4_r4_4"},
     {{vs, r7, r3, 2}, true, vs, "vs r7 r3 2", "vs_r7_r3_2"},
     {{cc, r0, r4, 1}, true, cc, "cc r0 r4 1", "cc_r0_r4_1"},
     {{ge, r4, r2, 3}, true, ge, "ge r4 r2 3", "ge_r4_r2_3"},
     {{pl, r1, r6, 0}, true, pl, "pl r1 r6 0", "pl_r1_r6_0"},
     {{eq, r1, r5, 4}, true, eq, "eq r1 r5 4", "eq_r1_r5_4"},
     {{pl, r0, r1, 7}, true, pl, "pl r0 r1 7", "pl_r0_r1_7"},
     {{cs, r5, r6, 2}, true, cs, "cs r5 r6 2", "cs_r5_r6_2"},
     {{mi, r1, r2, 3}, true, mi, "mi r1 r2 3", "mi_r1_r2_3"},
     {{mi, r3, r4, 0}, true, mi, "mi r3 r4 0", "mi_r3_r4_0"},
     {{ne, r5, r1, 1}, true, ne, "ne r5 r1 1", "ne_r5_r1_1"},
     {{cc, r3, r5, 4}, true, cc, "cc r3 r5 4", "cc_r3_r5_4"},
     {{ne, r4, r1, 4}, true, ne, "ne r4 r1 4", "ne_r4_r1_4"},
     {{vs, r4, r4, 4}, true, vs, "vs r4 r4 4", "vs_r4_r4_4"},
     {{mi, r4, r2, 6}, true, mi, "mi r4 r2 6", "mi_r4_r2_6"},
     {{hi, r4, r5, 3}, true, hi, "hi r4 r5 3", "hi_r4_r5_3"},
     {{pl, r2, r5, 7}, true, pl, "pl r2 r5 7", "pl_r2_r5_7"},
     {{cs, r1, r4, 1}, true, cs, "cs r1 r4 1", "cs_r1_r4_1"},
     {{hi, r7, r5, 0}, true, hi, "hi r7 r5 0", "hi_r7_r5_0"},
     {{mi, r5, r6, 4}, true, mi, "mi r5 r6 4", "mi_r5_r6_4"},
     {{pl, r3, r2, 1}, true, pl, "pl r3 r2 1", "pl_r3_r2_1"},
     {{le, r1, r5, 2}, true, le, "le r1 r5 2", "le_r1_r5_2"},
     {{le, r1, r0, 0}, true, le, "le r1 r0 0", "le_r1_r0_0"},
     {{vc, r5, r5, 4}, true, vc, "vc r5 r5 4", "vc_r5_r5_4"},
     {{vc, r7, r2, 5}, true, vc, "vc r7 r2 5", "vc_r7_r2_5"},
     {{hi, r5, r4, 2}, true, hi, "hi r5 r4 2", "hi_r5_r4_2"},
     {{ls, r4, r4, 1}, true, ls, "ls r4 r4 1", "ls_r4_r4_1"},
     {{cc, r6, r6, 4}, true, cc, "cc r6 r6 4", "cc_r6_r6_4"},
     {{mi, r6, r7, 0}, true, mi, "mi r6 r7 0", "mi_r6_r7_0"},
     {{eq, r0, r1, 2}, true, eq, "eq r0 r1 2", "eq_r0_r1_2"},
     {{cc, r7, r2, 5}, true, cc, "cc r7 r2 5", "cc_r7_r2_5"},
     {{ls, r6, r7, 7}, true, ls, "ls r6 r7 7", "ls_r6_r7_7"},
     {{cs, r1, r1, 3}, true, cs, "cs r1 r1 3", "cs_r1_r1_3"},
     {{ls, r7, r1, 2}, true, ls, "ls r7 r1 2", "ls_r7_r1_2"},
     {{gt, r3, r1, 3}, true, gt, "gt r3 r1 3", "gt_r3_r1_3"},
     {{gt, r4, r7, 0}, true, gt, "gt r4 r7 0", "gt_r4_r7_0"},
     {{pl, r4, r5, 2}, true, pl, "pl r4 r5 2", "pl_r4_r5_2"},
     {{vs, r4, r7, 6}, true, vs, "vs r4 r7 6", "vs_r4_r7_6"},
     {{vc, r5, r1, 6}, true, vc, "vc r5 r1 6", "vc_r5_r1_6"},
     {{vs, r6, r5, 5}, true, vs, "vs r6 r5 5", "vs_r6_r5_5"},
     {{eq, r5, r0, 1}, true, eq, "eq r5 r0 1", "eq_r5_r0_1"},
     {{mi, r4, r6, 1}, true, mi, "mi r4 r6 1", "mi_r4_r6_1"},
     {{cs, r1, r5, 7}, true, cs, "cs r1 r5 7", "cs_r1_r5_7"},
     {{lt, r0, r3, 6}, true, lt, "lt r0 r3 6", "lt_r0_r3_6"},
     {{eq, r7, r0, 6}, true, eq, "eq r7 r0 6", "eq_r7_r0_6"},
     {{vc, r3, r5, 3}, true, vc, "vc r3 r5 3", "vc_r3_r5_3"},
     {{gt, r4, r7, 7}, true, gt, "gt r4 r7 7", "gt_r4_r7_7"},
     {{ne, r4, r1, 1}, true, ne, "ne r4 r1 1", "ne_r4_r1_1"},
     {{ge, r6, r7, 4}, true, ge, "ge r6 r7 4", "ge_r6_r7_4"},
     {{le, r2, r0, 2}, true, le, "le r2 r0 2", "le_r2_r0_2"},
     {{mi, r7, r5, 7}, true, mi, "mi r7 r5 7", "mi_r7_r5_7"},
     {{lt, r5, r3, 6}, true, lt, "lt r5 r3 6", "lt_r5_r3_6"},
     {{vs, r1, r4, 7}, true, vs, "vs r1 r4 7", "vs_r1_r4_7"},
     {{cs, r2, r2, 4}, true, cs, "cs r2 r2 4", "cs_r2_r2_4"},
     {{cs, r1, r0, 1}, true, cs, "cs r1 r0 1", "cs_r1_r0_1"},
     {{ne, r0, r7, 4}, true, ne, "ne r0 r7 4", "ne_r0_r7_4"},
     {{vs, r6, r0, 4}, true, vs, "vs r6 r0 4", "vs_r6_r0_4"},
     {{vc, r7, r1, 2}, true, vc, "vc r7 r1 2", "vc_r7_r1_2"},
     {{ls, r5, r0, 4}, true, ls, "ls r5 r0 4", "ls_r5_r0_4"},
     {{le, r0, r1, 1}, true, le, "le r0 r1 1", "le_r0_r1_1"},
     {{cs, r7, r3, 1}, true, cs, "cs r7 r3 1", "cs_r7_r3_1"},
     {{cs, r7, r5, 3}, true, cs, "cs r7 r5 3", "cs_r7_r5_3"},
     {{gt, r3, r7, 2}, true, gt, "gt r3 r7 2", "gt_r3_r7_2"},
     {{eq, r3, r4, 1}, true, eq, "eq r3 r4 1", "eq_r3_r4_1"},
     {{mi, r3, r4, 6}, true, mi, "mi r3 r4 6", "mi_r3_r4_6"},
     {{eq, r0, r4, 3}, true, eq, "eq r0 r4 3", "eq_r0_r4_3"},
     {{le, r0, r7, 6}, true, le, "le r0 r7 6", "le_r0_r7_6"},
     {{le, r5, r6, 3}, true, le, "le r5 r6 3", "le_r5_r6_3"},
     {{vs, r3, r5, 3}, true, vs, "vs r3 r5 3", "vs_r3_r5_3"},
     {{pl, r3, r4, 3}, true, pl, "pl r3 r4 3", "pl_r3_r4_3"},
     {{le, r2, r3, 0}, true, le, "le r2 r3 0", "le_r2_r3_0"},
     {{vc, r5, r4, 4}, true, vc, "vc r5 r4 4", "vc_r5_r4_4"},
     {{le, r5, r0, 6}, true, le, "le r5 r0 6", "le_r5_r0_6"},
     {{vs, r6, r5, 6}, true, vs, "vs r6 r5 6", "vs_r6_r5_6"},
     {{ge, r2, r2, 3}, true, ge, "ge r2 r2 3", "ge_r2_r2_3"},
     {{vs, r5, r4, 5}, true, vs, "vs r5 r4 5", "vs_r5_r4_5"},
     {{vc, r6, r4, 2}, true, vc, "vc r6 r4 2", "vc_r6_r4_2"},
     {{ne, r4, r2, 2}, true, ne, "ne r4 r2 2", "ne_r4_r2_2"},
     {{ge, r5, r7, 7}, true, ge, "ge r5 r7 7", "ge_r5_r7_7"},
     {{ne, r1, r7, 7}, true, ne, "ne r1 r7 7", "ne_r1_r7_7"},
     {{vc, r6, r1, 2}, true, vc, "vc r6 r1 2", "vc_r6_r1_2"},
     {{mi, r2, r4, 0}, true, mi, "mi r2 r4 0", "mi_r2_r4_0"},
     {{hi, r6, r3, 1}, true, hi, "hi r6 r3 1", "hi_r6_r3_1"},
     {{cc, r5, r1, 5}, true, cc, "cc r5 r1 5", "cc_r5_r1_5"},
     {{mi, r3, r5, 1}, true, mi, "mi r3 r5 1", "mi_r3_r5_1"},
     {{vs, r0, r5, 3}, true, vs, "vs r0 r5 3", "vs_r0_r5_3"},
     {{gt, r0, r1, 4}, true, gt, "gt r0 r1 4", "gt_r0_r1_4"},
     {{vs, r7, r5, 4}, true, vs, "vs r7 r5 4", "vs_r7_r5_4"},
     {{mi, r1, r5, 3}, true, mi, "mi r1 r5 3", "mi_r1_r5_3"},
     {{hi, r6, r6, 0}, true, hi, "hi r6 r6 0", "hi_r6_r6_0"},
     {{gt, r6, r4, 3}, true, gt, "gt r6 r4 3", "gt_r6_r4_3"},
     {{gt, r3, r2, 6}, true, gt, "gt r3 r2 6", "gt_r3_r2_6"},
     {{mi, r3, r7, 7}, true, mi, "mi r3 r7 7", "mi_r3_r7_7"},
     {{gt, r4, r6, 0}, true, gt, "gt r4 r6 0", "gt_r4_r6_0"},
     {{cs, r6, r4, 0}, true, cs, "cs r6 r4 0", "cs_r6_r4_0"},
     {{ne, r6, r2, 0}, true, ne, "ne r6 r2 0", "ne_r6_r2_0"},
     {{ne, r3, r3, 0}, true, ne, "ne r3 r3 0", "ne_r3_r3_0"},
     {{gt, r2, r3, 5}, true, gt, "gt r2 r3 5", "gt_r2_r3_5"},
     {{ne, r5, r0, 5}, true, ne, "ne r5 r0 5", "ne_r5_r0_5"},
     {{le, r7, r7, 4}, true, le, "le r7 r7 4", "le_r7_r7_4"},
     {{ge, r7, r3, 0}, true, ge, "ge r7 r3 0", "ge_r7_r3_0"},
     {{le, r4, r5, 6}, true, le, "le r4 r5 6", "le_r4_r5_6"},
     {{ls, r3, r2, 6}, true, ls, "ls r3 r2 6", "ls_r3_r2_6"},
     {{gt, r4, r5, 7}, true, gt, "gt r4 r5 7", "gt_r4_r5_7"},
     {{eq, r2, r1, 3}, true, eq, "eq r2 r1 3", "eq_r2_r1_3"},
     {{lt, r3, r0, 6}, true, lt, "lt r3 r0 6", "lt_r3_r0_6"},
     {{ne, r4, r0, 2}, true, ne, "ne r4 r0 2", "ne_r4_r0_2"},
     {{lt, r7, r6, 5}, true, lt, "lt r7 r6 5", "lt_r7_r6_5"},
     {{hi, r6, r0, 6}, true, hi, "hi r6 r0 6", "hi_r6_r0_6"},
     {{vs, r1, r6, 7}, true, vs, "vs r1 r6 7", "vs_r1_r6_7"},
     {{cc, r0, r6, 6}, true, cc, "cc r0 r6 6", "cc_r0_r6_6"},
     {{ne, r1, r7, 6}, true, ne, "ne r1 r7 6", "ne_r1_r7_6"},
     {{cs, r2, r3, 1}, true, cs, "cs r2 r3 1", "cs_r2_r3_1"},
     {{lt, r3, r7, 7}, true, lt, "lt r3 r7 7", "lt_r3_r7_7"},
     {{cc, r3, r3, 0}, true, cc, "cc r3 r3 0", "cc_r3_r3_0"},
     {{eq, r4, r3, 6}, true, eq, "eq r4 r3 6", "eq_r4_r3_6"},
     {{cs, r0, r5, 7}, true, cs, "cs r0 r5 7", "cs_r0_r5_7"},
     {{gt, r1, r2, 4}, true, gt, "gt r1 r2 4", "gt_r1_r2_4"},
     {{cc, r2, r1, 5}, true, cc, "cc r2 r1 5", "cc_r2_r1_5"},
     {{pl, r7, r5, 5}, true, pl, "pl r7 r5 5", "pl_r7_r5_5"},
     {{pl, r5, r7, 6}, true, pl, "pl r5 r7 6", "pl_r5_r7_6"},
     {{vc, r2, r2, 7}, true, vc, "vc r2 r2 7", "vc_r2_r2_7"},
     {{vs, r4, r4, 0}, true, vs, "vs r4 r4 0", "vs_r4_r4_0"},
     {{vc, r2, r6, 5}, true, vc, "vc r2 r6 5", "vc_r2_r6_5"},
     {{gt, r1, r7, 0}, true, gt, "gt r1 r7 0", "gt_r1_r7_0"},
     {{pl, r4, r1, 7}, true, pl, "pl r4 r1 7", "pl_r4_r1_7"},
     {{lt, r4, r3, 2}, true, lt, "lt r4 r3 2", "lt_r4_r3_2"},
     {{ge, r0, r2, 4}, true, ge, "ge r0 r2 4", "ge_r0_r2_4"},
     {{ne, r7, r5, 7}, true, ne, "ne r7 r5 7", "ne_r7_r5_7"},
     {{gt, r2, r1, 6}, true, gt, "gt r2 r1 6", "gt_r2_r1_6"},
     {{eq, r4, r1, 6}, true, eq, "eq r4 r1 6", "eq_r4_r1_6"},
     {{vs, r3, r7, 3}, true, vs, "vs r3 r7 3", "vs_r3_r7_3"},
     {{mi, r0, r7, 3}, true, mi, "mi r0 r7 3", "mi_r0_r7_3"},
     {{eq, r3, r5, 6}, true, eq, "eq r3 r5 6", "eq_r3_r5_6"},
     {{lt, r6, r2, 3}, true, lt, "lt r6 r2 3", "lt_r6_r2_3"},
     {{lt, r7, r5, 5}, true, lt, "lt r7 r5 5", "lt_r7_r5_5"},
     {{vc, r6, r5, 6}, true, vc, "vc r6 r5 6", "vc_r6_r5_6"},
     {{cs, r2, r0, 7}, true, cs, "cs r2 r0 7", "cs_r2_r0_7"},
     {{hi, r4, r2, 3}, true, hi, "hi r4 r2 3", "hi_r4_r2_3"},
     {{vs, r5, r4, 7}, true, vs, "vs r5 r4 7", "vs_r5_r4_7"},
     {{ge, r7, r1, 2}, true, ge, "ge r7 r1 2", "ge_r7_r1_2"},
     {{cc, r6, r4, 6}, true, cc, "cc r6 r4 6", "cc_r6_r4_6"},
     {{ls, r4, r1, 0}, true, ls, "ls r4 r1 0", "ls_r4_r1_0"},
     {{cc, r1, r1, 1}, true, cc, "cc r1 r1 1", "cc_r1_r1_1"},
     {{ls, r2, r3, 5}, true, ls, "ls r2 r3 5", "ls_r2_r3_5"},
     {{cc, r2, r0, 6}, true, cc, "cc r2 r0 6", "cc_r2_r0_6"},
     {{gt, r6, r5, 4}, true, gt, "gt r6 r5 4", "gt_r6_r5_4"},
     {{le, r3, r3, 3}, true, le, "le r3 r3 3", "le_r3_r3_3"},
     {{ls, r4, r5, 7}, true, ls, "ls r4 r5 7", "ls_r4_r5_7"},
     {{ls, r3, r7, 0}, true, ls, "ls r3 r7 0", "ls_r3_r7_0"},
     {{lt, r5, r4, 1}, true, lt, "lt r5 r4 1", "lt_r5_r4_1"},
     {{hi, r0, r2, 3}, true, hi, "hi r0 r2 3", "hi_r0_r2_3"},
     {{ne, r7, r2, 2}, true, ne, "ne r7 r2 2", "ne_r7_r2_2"},
     {{gt, r6, r4, 4}, true, gt, "gt r6 r4 4", "gt_r6_r4_4"},
     {{cc, r5, r1, 0}, true, cc, "cc r5 r1 0", "cc_r5_r1_0"},
     {{le, r6, r5, 3}, true, le, "le r6 r5 3", "le_r6_r5_3"},
     {{cs, r3, r4, 4}, true, cs, "cs r3 r4 4", "cs_r3_r4_4"},
     {{mi, r4, r7, 5}, true, mi, "mi r4 r7 5", "mi_r4_r7_5"},
     {{mi, r1, r3, 6}, true, mi, "mi r1 r3 6", "mi_r1_r3_6"},
     {{hi, r0, r7, 5}, true, hi, "hi r0 r7 5", "hi_r0_r7_5"},
     {{ls, r4, r3, 2}, true, ls, "ls r4 r3 2", "ls_r4_r3_2"},
     {{ne, r4, r7, 6}, true, ne, "ne r4 r7 6", "ne_r4_r7_6"},
     {{cs, r4, r5, 5}, true, cs, "cs r4 r5 5", "cs_r4_r5_5"},
     {{mi, r3, r5, 0}, true, mi, "mi r3 r5 0", "mi_r3_r5_0"},
     {{cs, r5, r0, 1}, true, cs, "cs r5 r0 1", "cs_r5_r0_1"},
     {{pl, r3, r2, 6}, true, pl, "pl r3 r2 6", "pl_r3_r2_6"},
     {{vs, r1, r6, 5}, true, vs, "vs r1 r6 5", "vs_r1_r6_5"},
     {{le, r4, r0, 2}, true, le, "le r4 r0 2", "le_r4_r0_2"},
     {{eq, r3, r7, 7}, true, eq, "eq r3 r7 7", "eq_r3_r7_7"},
     {{lt, r6, r4, 7}, true, lt, "lt r6 r4 7", "lt_r6_r4_7"},
     {{hi, r2, r0, 5}, true, hi, "hi r2 r0 5", "hi_r2_r0_5"},
     {{ge, r1, r3, 3}, true, ge, "ge r1 r3 3", "ge_r1_r3_3"},
     {{pl, r6, r3, 0}, true, pl, "pl r6 r3 0", "pl_r6_r3_0"},
     {{hi, r1, r0, 4}, true, hi, "hi r1 r0 4", "hi_r1_r0_4"},
     {{lt, r3, r5, 3}, true, lt, "lt r3 r5 3", "lt_r3_r5_3"},
     {{ge, r2, r7, 3}, true, ge, "ge r2 r7 3", "ge_r2_r7_3"},
     {{mi, r0, r7, 4}, true, mi, "mi r0 r7 4", "mi_r0_r7_4"},
     {{pl, r7, r5, 1}, true, pl, "pl r7 r5 1", "pl_r7_r5_1"},
     {{lt, r0, r3, 4}, true, lt, "lt r0 r3 4", "lt_r0_r3_4"},
     {{mi, r6, r4, 2}, true, mi, "mi r6 r4 2", "mi_r6_r4_2"},
     {{vc, r4, r4, 1}, true, vc, "vc r4 r4 1", "vc_r4_r4_1"},
     {{gt, r1, r5, 3}, true, gt, "gt r1 r5 3", "gt_r1_r5_3"},
     {{cc, r2, r0, 7}, true, cc, "cc r2 r0 7", "cc_r2_r0_7"},
     {{le, r6, r4, 0}, true, le, "le r6 r4 0", "le_r6_r4_0"},
     {{le, r0, r6, 2}, true, le, "le r0 r6 2", "le_r0_r6_2"},
     {{le, r1, r1, 7}, true, le, "le r1 r1 7", "le_r1_r1_7"},
     {{vs, r1, r1, 5}, true, vs, "vs r1 r1 5", "vs_r1_r1_5"},
     {{cs, r6, r0, 2}, true, cs, "cs r6 r0 2", "cs_r6_r0_2"},
     {{vs, r3, r0, 7}, true, vs, "vs r3 r0 7", "vs_r3_r0_7"},
     {{vs, r3, r3, 4}, true, vs, "vs r3 r3 4", "vs_r3_r3_4"},
     {{cs, r4, r2, 7}, true, cs, "cs r4 r2 7", "cs_r4_r2_7"},
     {{mi, r4, r0, 1}, true, mi, "mi r4 r0 1", "mi_r4_r0_1"},
     {{gt, r2, r4, 1}, true, gt, "gt r2 r4 1", "gt_r2_r4_1"},
     {{ne, r4, r6, 0}, true, ne, "ne r4 r6 0", "ne_r4_r6_0"},
     {{cs, r4, r1, 5}, true, cs, "cs r4 r1 5", "cs_r4_r1_5"},
     {{cc, r2, r6, 3}, true, cc, "cc r2 r6 3", "cc_r2_r6_3"},
     {{ge, r6, r1, 0}, true, ge, "ge r6 r1 0", "ge_r6_r1_0"},
     {{pl, r2, r5, 3}, true, pl, "pl r2 r5 3", "pl_r2_r5_3"},
     {{ne, r1, r7, 4}, true, ne, "ne r1 r7 4", "ne_r1_r7_4"},
     {{le, r2, r6, 0}, true, le, "le r2 r6 0", "le_r2_r6_0"},
     {{gt, r7, r1, 6}, true, gt, "gt r7 r1 6", "gt_r7_r1_6"},
     {{cs, r0, r3, 7}, true, cs, "cs r0 r3 7", "cs_r0_r3_7"},
     {{mi, r1, r1, 0}, true, mi, "mi r1 r1 0", "mi_r1_r1_0"},
     {{eq, r4, r0, 5}, true, eq, "eq r4 r0 5", "eq_r4_r0_5"},
     {{lt, r5, r0, 6}, true, lt, "lt r5 r0 6", "lt_r5_r0_6"},
     {{vc, r2, r6, 6}, true, vc, "vc r2 r6 6", "vc_r2_r6_6"},
     {{cs, r1, r2, 7}, true, cs, "cs r1 r2 7", "cs_r1_r2_7"},
     {{ls, r6, r6, 3}, true, ls, "ls r6 r6 3", "ls_r6_r6_3"},
     {{lt, r5, r0, 4}, true, lt, "lt r5 r0 4", "lt_r5_r0_4"},
     {{gt, r1, r6, 0}, true, gt, "gt r1 r6 0", "gt_r1_r6_0"},
     {{vs, r7, r2, 2}, true, vs, "vs r7 r2 2", "vs_r7_r2_2"},
     {{gt, r1, r3, 5}, true, gt, "gt r1 r3 5", "gt_r1_r3_5"},
     {{mi, r2, r6, 5}, true, mi, "mi r2 r6 5", "mi_r2_r6_5"},
     {{cs, r3, r6, 2}, true, cs, "cs r3 r6 2", "cs_r3_r6_2"},
     {{cs, r2, r6, 2}, true, cs, "cs r2 r6 2", "cs_r2_r6_2"},
     {{cs, r7, r3, 6}, true, cs, "cs r7 r3 6", "cs_r7_r3_6"},
     {{cs, r7, r7, 6}, true, cs, "cs r7 r7 6", "cs_r7_r7_6"},
     {{eq, r1, r1, 4}, true, eq, "eq r1 r1 4", "eq_r1_r1_4"},
     {{mi, r3, r2, 2}, true, mi, "mi r3 r2 2", "mi_r3_r2_2"},
     {{vc, r5, r7, 0}, true, vc, "vc r5 r7 0", "vc_r5_r7_0"},
     {{hi, r1, r6, 7}, true, hi, "hi r1 r6 7", "hi_r1_r6_7"},
     {{vs, r5, r7, 3}, true, vs, "vs r5 r7 3", "vs_r5_r7_3"},
     {{gt, r1, r7, 2}, true, gt, "gt r1 r7 2", "gt_r1_r7_2"},
     {{vc, r4, r5, 0}, true, vc, "vc r4 r5 0", "vc_r4_r5_0"},
     {{le, r6, r7, 0}, true, le, "le r6 r7 0", "le_r6_r7_0"},
     {{ge, r6, r1, 5}, true, ge, "ge r6 r1 5", "ge_r6_r1_5"},
     {{cc, r0, r2, 1}, true, cc, "cc r0 r2 1", "cc_r0_r2_1"},
     {{le, r7, r3, 5}, true, le, "le r7 r3 5", "le_r7_r3_5"},
     {{hi, r7, r1, 2}, true, hi, "hi r7 r1 2", "hi_r7_r1_2"},
     {{cc, r7, r5, 0}, true, cc, "cc r7 r5 0", "cc_r7_r5_0"},
     {{gt, r0, r6, 0}, true, gt, "gt r0 r6 0", "gt_r0_r6_0"},
     {{ne, r6, r5, 4}, true, ne, "ne r6 r5 4", "ne_r6_r5_4"},
     {{cc, r7, r0, 1}, true, cc, "cc r7 r0 1", "cc_r7_r0_1"},
     {{eq, r6, r6, 5}, true, eq, "eq r6 r6 5", "eq_r6_r6_5"},
     {{pl, r4, r3, 0}, true, pl, "pl r4 r3 0", "pl_r4_r3_0"},
     {{ne, r2, r3, 6}, true, ne, "ne r2 r3 6", "ne_r2_r3_6"},
     {{le, r0, r2, 1}, true, le, "le r0 r2 1", "le_r0_r2_1"},
     {{eq, r0, r1, 5}, true, eq, "eq r0 r1 5", "eq_r0_r1_5"},
     {{ls, r5, r6, 2}, true, ls, "ls r5 r6 2", "ls_r5_r6_2"},
     {{ne, r3, r4, 5}, true, ne, "ne r3 r4 5", "ne_r3_r4_5"},
     {{gt, r1, r4, 2}, true, gt, "gt r1 r4 2", "gt_r1_r4_2"},
     {{le, r3, r5, 2}, true, le, "le r3 r5 2", "le_r3_r5_2"},
     {{vc, r0, r5, 5}, true, vc, "vc r0 r5 5", "vc_r0_r5_5"},
     {{pl, r5, r3, 6}, true, pl, "pl r5 r3 6", "pl_r5_r3_6"},
     {{eq, r0, r1, 4}, true, eq, "eq r0 r1 4", "eq_r0_r1_4"},
     {{cs, r0, r0, 7}, true, cs, "cs r0 r0 7", "cs_r0_r0_7"},
     {{lt, r6, r5, 6}, true, lt, "lt r6 r5 6", "lt_r6_r5_6"},
     {{vs, r1, r1, 2}, true, vs, "vs r1 r1 2", "vs_r1_r1_2"},
     {{mi, r4, r5, 0}, true, mi, "mi r4 r5 0", "mi_r4_r5_0"},
     {{vc, r3, r0, 4}, true, vc, "vc r3 r0 4", "vc_r3_r0_4"},
     {{le, r2, r2, 3}, true, le, "le r2 r2 3", "le_r2_r2_3"},
     {{gt, r3, r7, 5}, true, gt, "gt r3 r7 5", "gt_r3_r7_5"},
     {{cs, r0, r4, 0}, true, cs, "cs r0 r4 0", "cs_r0_r4_0"},
     {{gt, r5, r0, 2}, true, gt, "gt r5 r0 2", "gt_r5_r0_2"},
     {{vs, r4, r1, 1}, true, vs, "vs r4 r1 1", "vs_r4_r1_1"},
     {{cc, r7, r3, 5}, true, cc, "cc r7 r3 5", "cc_r7_r3_5"},
     {{ls, r5, r0, 3}, true, ls, "ls r5 r0 3", "ls_r5_r0_3"},
     {{vs, r2, r4, 3}, true, vs, "vs r2 r4 3", "vs_r2_r4_3"},
     {{vc, r3, r3, 4}, true, vc, "vc r3 r3 4", "vc_r3_r3_4"},
     {{gt, r0, r6, 1}, true, gt, "gt r0 r6 1", "gt_r0_r6_1"},
     {{hi, r1, r7, 1}, true, hi, "hi r1 r7 1", "hi_r1_r7_1"},
     {{ne, r2, r4, 5}, true, ne, "ne r2 r4 5", "ne_r2_r4_5"},
     {{hi, r0, r7, 0}, true, hi, "hi r0 r7 0", "hi_r0_r7_0"},
     {{ne, r1, r1, 5}, true, ne, "ne r1 r1 5", "ne_r1_r1_5"},
     {{cc, r1, r0, 2}, true, cc, "cc r1 r0 2", "cc_r1_r0_2"},
     {{cc, r7, r3, 3}, true, cc, "cc r7 r3 3", "cc_r7_r3_3"},
     {{lt, r0, r0, 3}, true, lt, "lt r0 r0 3", "lt_r0_r0_3"},
     {{hi, r1, r1, 1}, true, hi, "hi r1 r1 1", "hi_r1_r1_1"},
     {{vs, r7, r2, 4}, true, vs, "vs r7 r2 4", "vs_r7_r2_4"},
     {{cs, r2, r1, 3}, true, cs, "cs r2 r1 3", "cs_r2_r1_3"},
     {{ge, r4, r0, 7}, true, ge, "ge r4 r0 7", "ge_r4_r0_7"},
     {{gt, r0, r2, 2}, true, gt, "gt r0 r2 2", "gt_r0_r2_2"},
     {{lt, r6, r4, 4}, true, lt, "lt r6 r4 4", "lt_r6_r4_4"},
     {{lt, r2, r4, 1}, true, lt, "lt r2 r4 1", "lt_r2_r4_1"},
     {{cc, r5, r5, 3}, true, cc, "cc r5 r5 3", "cc_r5_r5_3"},
     {{eq, r7, r3, 0}, true, eq, "eq r7 r3 0", "eq_r7_r3_0"},
     {{cc, r0, r2, 2}, true, cc, "cc r0 r2 2", "cc_r0_r2_2"},
     {{mi, r5, r7, 7}, true, mi, "mi r5 r7 7", "mi_r5_r7_7"},
     {{eq, r2, r4, 5}, true, eq, "eq r2 r4 5", "eq_r2_r4_5"},
     {{pl, r1, r7, 0}, true, pl, "pl r1 r7 0", "pl_r1_r7_0"},
     {{vs, r6, r2, 0}, true, vs, "vs r6 r2 0", "vs_r6_r2_0"},
     {{cc, r0, r1, 6}, true, cc, "cc r0 r1 6", "cc_r0_r1_6"},
     {{cs, r2, r2, 5}, true, cs, "cs r2 r2 5", "cs_r2_r2_5"},
     {{le, r0, r6, 7}, true, le, "le r0 r6 7", "le_r0_r6_7"},
     {{hi, r5, r0, 7}, true, hi, "hi r5 r0 7", "hi_r5_r0_7"},
     {{gt, r2, r5, 1}, true, gt, "gt r2 r5 1", "gt_r2_r5_1"},
     {{gt, r2, r1, 2}, true, gt, "gt r2 r1 2", "gt_r2_r1_2"},
     {{le, r6, r2, 5}, true, le, "le r6 r2 5", "le_r6_r2_5"},
     {{ls, r4, r3, 3}, true, ls, "ls r4 r3 3", "ls_r4_r3_3"},
     {{le, r0, r2, 6}, true, le, "le r0 r2 6", "le_r0_r2_6"},
     {{pl, r0, r7, 6}, true, pl, "pl r0 r7 6", "pl_r0_r7_6"},
     {{pl, r4, r5, 4}, true, pl, "pl r4 r5 4", "pl_r4_r5_4"},
     {{vs, r3, r2, 2}, true, vs, "vs r3 r2 2", "vs_r3_r2_2"},
     {{vc, r2, r4, 3}, true, vc, "vc r2 r4 3", "vc_r2_r4_3"},
     {{ge, r1, r5, 7}, true, ge, "ge r1 r5 7", "ge_r1_r5_7"},
     {{pl, r1, r6, 3}, true, pl, "pl r1 r6 3", "pl_r1_r6_3"},
     {{hi, r3, r6, 0}, true, hi, "hi r3 r6 0", "hi_r3_r6_0"},
     {{ne, r0, r4, 3}, true, ne, "ne r0 r4 3", "ne_r0_r4_3"},
     {{ne, r4, r5, 0}, true, ne, "ne r4 r5 0", "ne_r4_r5_0"},
     {{cc, r7, r6, 2}, true, cc, "cc r7 r6 2", "cc_r7_r6_2"},
     {{cc, r2, r0, 5}, true, cc, "cc r2 r0 5", "cc_r2_r0_5"},
     {{ge, r3, r1, 2}, true, ge, "ge r3 r1 2", "ge_r3_r1_2"},
     {{ge, r1, r1, 2}, true, ge, "ge r1 r1 2", "ge_r1_r1_2"},
     {{hi, r5, r6, 4}, true, hi, "hi r5 r6 4", "hi_r5_r6_4"},
     {{ne, r6, r4, 3}, true, ne, "ne r6 r4 3", "ne_r6_r4_3"},
     {{ne, r3, r1, 0}, true, ne, "ne r3 r1 0", "ne_r3_r1_0"},
     {{cs, r3, r4, 0}, true, cs, "cs r3 r4 0", "cs_r3_r4_0"},
     {{eq, r5, r0, 6}, true, eq, "eq r5 r0 6", "eq_r5_r0_6"},
     {{pl, r1, r5, 1}, true, pl, "pl r1 r5 1", "pl_r1_r5_1"},
     {{ls, r7, r7, 4}, true, ls, "ls r7 r7 4", "ls_r7_r7_4"},
     {{le, r2, r2, 2}, true, le, "le r2 r2 2", "le_r2_r2_2"},
     {{eq, r6, r4, 5}, true, eq, "eq r6 r4 5", "eq_r6_r4_5"},
     {{cc, r1, r3, 0}, true, cc, "cc r1 r3 0", "cc_r1_r3_0"},
     {{gt, r3, r5, 5}, true, gt, "gt r3 r5 5", "gt_r3_r5_5"},
     {{ge, r7, r2, 2}, true, ge, "ge r7 r2 2", "ge_r7_r2_2"},
     {{gt, r2, r7, 4}, true, gt, "gt r2 r7 4", "gt_r2_r7_4"},
     {{vs, r7, r3, 3}, true, vs, "vs r7 r3 3", "vs_r7_r3_3"},
     {{ge, r2, r5, 4}, true, ge, "ge r2 r5 4", "ge_r2_r5_4"},
     {{ge, r0, r3, 0}, true, ge, "ge r0 r3 0", "ge_r0_r3_0"},
     {{hi, r3, r1, 4}, true, hi, "hi r3 r1 4", "hi_r3_r1_4"},
     {{pl, r7, r7, 2}, true, pl, "pl r7 r7 2", "pl_r7_r7_2"},
     {{pl, r6, r0, 0}, true, pl, "pl r6 r0 0", "pl_r6_r0_0"},
     {{ls, r0, r6, 4}, true, ls, "ls r0 r6 4", "ls_r0_r6_4"},
     {{pl, r3, r4, 0}, true, pl, "pl r3 r4 0", "pl_r3_r4_0"},
     {{ge, r5, r3, 5}, true, ge, "ge r5 r3 5", "ge_r5_r3_5"},
     {{ls, r3, r2, 5}, true, ls, "ls r3 r2 5", "ls_r3_r2_5"},
     {{vs, r3, r2, 4}, true, vs, "vs r3 r2 4", "vs_r3_r2_4"},
     {{gt, r7, r6, 7}, true, gt, "gt r7 r6 7", "gt_r7_r6_7"},
     {{hi, r0, r2, 6}, true, hi, "hi r0 r2 6", "hi_r0_r2_6"},
     {{lt, r2, r6, 4}, true, lt, "lt r2 r6 4", "lt_r2_r6_4"},
     {{mi, r1, r0, 3}, true, mi, "mi r1 r0 3", "mi_r1_r0_3"},
     {{le, r5, r4, 7}, true, le, "le r5 r4 7", "le_r5_r4_7"},
     {{ge, r0, r7, 6}, true, ge, "ge r0 r7 6", "ge_r0_r7_6"},
     {{hi, r7, r3, 3}, true, hi, "hi r7 r3 3", "hi_r7_r3_3"},
     {{cc, r4, r4, 7}, true, cc, "cc r4 r4 7", "cc_r4_r4_7"},
     {{le, r4, r2, 5}, true, le, "le r4 r2 5", "le_r4_r2_5"},
     {{gt, r0, r0, 3}, true, gt, "gt r0 r0 3", "gt_r0_r0_3"},
     {{pl, r0, r4, 5}, true, pl, "pl r0 r4 5", "pl_r0_r4_5"},
     {{ge, r0, r5, 6}, true, ge, "ge r0 r5 6", "ge_r0_r5_6"},
     {{lt, r7, r3, 1}, true, lt, "lt r7 r3 1", "lt_r7_r3_1"},
     {{cs, r4, r2, 0}, true, cs, "cs r4 r2 0", "cs_r4_r2_0"},
     {{vs, r2, r5, 5}, true, vs, "vs r2 r5 5", "vs_r2_r5_5"},
     {{le, r5, r4, 1}, true, le, "le r5 r4 1", "le_r5_r4_1"},
     {{ge, r5, r5, 1}, true, ge, "ge r5 r5 1", "ge_r5_r5_1"},
     {{ls, r2, r4, 6}, true, ls, "ls r2 r4 6", "ls_r2_r4_6"},
     {{lt, r4, r4, 0}, true, lt, "lt r4 r4 0", "lt_r4_r4_0"},
     {{vs, r4, r6, 1}, true, vs, "vs r4 r6 1", "vs_r4_r6_1"},
     {{hi, r4, r1, 0}, true, hi, "hi r4 r1 0", "hi_r4_r1_0"},
     {{vc, r0, r7, 1}, true, vc, "vc r0 r7 1", "vc_r0_r7_1"},
     {{lt, r2, r7, 2}, true, lt, "lt r2 r7 2", "lt_r2_r7_2"},
     {{ls, r7, r5, 6}, true, ls, "ls r7 r5 6", "ls_r7_r5_6"},
     {{vs, r3, r2, 5}, true, vs, "vs r3 r2 5", "vs_r3_r2_5"},
     {{vs, r6, r3, 4}, true, vs, "vs r6 r3 4", "vs_r6_r3_4"},
     {{le, r1, r2, 6}, true, le, "le r1 r2 6", "le_r1_r2_6"},
     {{vc, r3, r7, 7}, true, vc, "vc r3 r7 7", "vc_r3_r7_7"},
     {{le, r7, r7, 0}, true, le, "le r7 r7 0", "le_r7_r7_0"},
     {{lt, r0, r0, 6}, true, lt, "lt r0 r0 6", "lt_r0_r0_6"},
     {{ne, r4, r5, 2}, true, ne, "ne r4 r5 2", "ne_r4_r5_2"},
     {{mi, r4, r1, 6}, true, mi, "mi r4 r1 6", "mi_r4_r1_6"},
     {{ge, r1, r4, 2}, true, ge, "ge r1 r4 2", "ge_r1_r4_2"},
     {{mi, r4, r3, 3}, true, mi, "mi r4 r3 3", "mi_r4_r3_3"},
     {{lt, r2, r5, 0}, true, lt, "lt r2 r5 0", "lt_r2_r5_0"},
     {{gt, r3, r4, 1}, true, gt, "gt r3 r4 1", "gt_r3_r4_1"},
     {{le, r6, r3, 3}, true, le, "le r6 r3 3", "le_r6_r3_3"},
     {{ge, r2, r6, 6}, true, ge, "ge r2 r6 6", "ge_r2_r6_6"},
     {{ne, r2, r1, 5}, true, ne, "ne r2 r1 5", "ne_r2_r1_5"},
     {{cc, r1, r6, 0}, true, cc, "cc r1 r6 0", "cc_r1_r6_0"},
     {{lt, r1, r6, 1}, true, lt, "lt r1 r6 1", "lt_r1_r6_1"},
     {{vc, r2, r7, 2}, true, vc, "vc r2 r7 2", "vc_r2_r7_2"},
     {{le, r5, r1, 1}, true, le, "le r5 r1 1", "le_r5_r1_1"},
     {{ge, r1, r7, 3}, true, ge, "ge r1 r7 3", "ge_r1_r7_3"},
     {{gt, r5, r3, 5}, true, gt, "gt r5 r3 5", "gt_r5_r3_5"},
     {{ne, r1, r5, 3}, true, ne, "ne r1 r5 3", "ne_r1_r5_3"},
     {{gt, r5, r6, 4}, true, gt, "gt r5 r6 4", "gt_r5_r6_4"},
     {{eq, r3, r2, 0}, true, eq, "eq r3 r2 0", "eq_r3_r2_0"},
     {{lt, r0, r0, 1}, true, lt, "lt r0 r0 1", "lt_r0_r0_1"},
     {{cc, r0, r3, 1}, true, cc, "cc r0 r3 1", "cc_r0_r3_1"},
     {{cc, r0, r1, 5}, true, cc, "cc r0 r1 5", "cc_r0_r1_5"},
     {{ne, r4, r4, 0}, true, ne, "ne r4 r4 0", "ne_r4_r4_0"},
     {{ge, r0, r6, 4}, true, ge, "ge r0 r6 4", "ge_r0_r6_4"},
     {{lt, r2, r6, 0}, true, lt, "lt r2 r6 0", "lt_r2_r6_0"},
     {{cs, r0, r6, 5}, true, cs, "cs r0 r6 5", "cs_r0_r6_5"},
     {{lt, r3, r5, 1}, true, lt, "lt r3 r5 1", "lt_r3_r5_1"},
     {{lt, r7, r1, 0}, true, lt, "lt r7 r1 0", "lt_r7_r1_0"},
     {{cc, r6, r3, 6}, true, cc, "cc r6 r3 6", "cc_r6_r3_6"},
     {{gt, r1, r0, 0}, true, gt, "gt r1 r0 0", "gt_r1_r0_0"},
     {{ls, r0, r7, 5}, true, ls, "ls r0 r7 5", "ls_r0_r7_5"},
     {{hi, r5, r2, 6}, true, hi, "hi r5 r2 6", "hi_r5_r2_6"},
     {{pl, r5, r2, 7}, true, pl, "pl r5 r2 7", "pl_r5_r2_7"},
     {{mi, r7, r0, 5}, true, mi, "mi r7 r0 5", "mi_r7_r0_5"},
     {{cc, r3, r0, 1}, true, cc, "cc r3 r0 1", "cc_r3_r0_1"},
     {{lt, r2, r2, 0}, true, lt, "lt r2 r2 0", "lt_r2_r2_0"},
     {{vc, r2, r1, 6}, true, vc, "vc r2 r1 6", "vc_r2_r1_6"},
     {{le, r2, r3, 3}, true, le, "le r2 r3 3", "le_r2_r3_3"},
     {{le, r1, r3, 1}, true, le, "le r1 r3 1", "le_r1_r3_1"},
     {{ls, r5, r6, 4}, true, ls, "ls r5 r6 4", "ls_r5_r6_4"},
     {{ne, r5, r1, 0}, true, ne, "ne r5 r1 0", "ne_r5_r1_0"},
     {{le, r0, r0, 5}, true, le, "le r0 r0 5", "le_r0_r0_5"},
     {{cc, r4, r7, 0}, true, cc, "cc r4 r7 0", "cc_r4_r7_0"},
     {{ne, r1, r4, 0}, true, ne, "ne r1 r4 0", "ne_r1_r4_0"},
     {{hi, r5, r3, 7}, true, hi, "hi r5 r3 7", "hi_r5_r3_7"},
     {{ne, r0, r3, 1}, true, ne, "ne r0 r3 1", "ne_r0_r3_1"},
     {{vs, r1, r3, 0}, true, vs, "vs r1 r3 0", "vs_r1_r3_0"},
     {{gt, r6, r5, 7}, true, gt, "gt r6 r5 7", "gt_r6_r5_7"},
     {{cs, r3, r0, 1}, true, cs, "cs r3 r0 1", "cs_r3_r0_1"},
     {{cc, r7, r0, 5}, true, cc, "cc r7 r0 5", "cc_r7_r0_5"},
     {{pl, r5, r2, 5}, true, pl, "pl r5 r2 5", "pl_r5_r2_5"},
     {{vs, r5, r1, 6}, true, vs, "vs r5 r1 6", "vs_r5_r1_6"},
     {{ge, r1, r1, 0}, true, ge, "ge r1 r1 0", "ge_r1_r1_0"},
     {{eq, r6, r1, 2}, true, eq, "eq r6 r1 2", "eq_r6_r1_2"},
     {{lt, r0, r5, 5}, true, lt, "lt r0 r5 5", "lt_r0_r5_5"},
     {{vc, r2, r2, 1}, true, vc, "vc r2 r2 1", "vc_r2_r2_1"},
     {{vc, r0, r4, 4}, true, vc, "vc r0 r4 4", "vc_r0_r4_4"},
     {{pl, r2, r6, 4}, true, pl, "pl r2 r6 4", "pl_r2_r6_4"},
     {{hi, r1, r3, 2}, true, hi, "hi r1 r3 2", "hi_r1_r3_2"},
     {{hi, r7, r2, 1}, true, hi, "hi r7 r2 1", "hi_r7_r2_1"},
     {{lt, r0, r1, 4}, true, lt, "lt r0 r1 4", "lt_r0_r1_4"},
     {{cc, r6, r2, 0}, true, cc, "cc r6 r2 0", "cc_r6_r2_0"},
     {{vs, r5, r4, 2}, true, vs, "vs r5 r4 2", "vs_r5_r4_2"},
     {{pl, r0, r5, 3}, true, pl, "pl r0 r5 3", "pl_r0_r5_3"},
     {{le, r0, r3, 4}, true, le, "le r0 r3 4", "le_r0_r3_4"},
     {{cc, r6, r2, 5}, true, cc, "cc r6 r2 5", "cc_r6_r2_5"},
     {{ls, r6, r1, 3}, true, ls, "ls r6 r1 3", "ls_r6_r1_3"},
     {{ne, r6, r6, 0}, true, ne, "ne r6 r6 0", "ne_r6_r6_0"},
     {{vc, r1, r3, 1}, true, vc, "vc r1 r3 1", "vc_r1_r3_1"},
     {{lt, r1, r7, 6}, true, lt, "lt r1 r7 6", "lt_r1_r7_6"},
     {{hi, r5, r3, 5}, true, hi, "hi r5 r3 5", "hi_r5_r3_5"},
     {{gt, r6, r4, 6}, true, gt, "gt r6 r4 6", "gt_r6_r4_6"},
     {{ne, r6, r6, 3}, true, ne, "ne r6 r6 3", "ne_r6_r6_3"},
     {{pl, r2, r4, 1}, true, pl, "pl r2 r4 1", "pl_r2_r4_1"},
     {{cc, r3, r6, 7}, true, cc, "cc r3 r6 7", "cc_r3_r6_7"},
     {{cs, r3, r7, 0}, true, cs, "cs r3 r7 0", "cs_r3_r7_0"},
     {{cc, r7, r7, 5}, true, cc, "cc r7 r7 5", "cc_r7_r7_5"},
     {{vc, r6, r0, 7}, true, vc, "vc r6 r0 7", "vc_r6_r0_7"},
     {{lt, r2, r0, 3}, true, lt, "lt r2 r0 3", "lt_r2_r0_3"},
     {{ne, r5, r4, 7}, true, ne, "ne r5 r4 7", "ne_r5_r4_7"},
     {{vc, r2, r7, 6}, true, vc, "vc r2 r7 6", "vc_r2_r7_6"},
     {{cc, r4, r3, 2}, true, cc, "cc r4 r3 2", "cc_r4_r3_2"},
     {{lt, r3, r7, 6}, true, lt, "lt r3 r7 6", "lt_r3_r7_6"},
     {{gt, r3, r7, 7}, true, gt, "gt r3 r7 7", "gt_r3_r7_7"},
     {{ge, r6, r7, 5}, true, ge, "ge r6 r7 5", "ge_r6_r7_5"},
     {{ls, r1, r4, 5}, true, ls, "ls r1 r4 5", "ls_r1_r4_5"},
     {{eq, r1, r7, 3}, true, eq, "eq r1 r7 3", "eq_r1_r7_3"},
     {{le, r1, r4, 6}, true, le, "le r1 r4 6", "le_r1_r4_6"},
     {{ne, r4, r3, 1}, true, ne, "ne r4 r3 1", "ne_r4_r3_1"},
     {{pl, r7, r3, 6}, true, pl, "pl r7 r3 6", "pl_r7_r3_6"},
     {{ne, r7, r7, 0}, true, ne, "ne r7 r7 0", "ne_r7_r7_0"},
     {{lt, r1, r2, 6}, true, lt, "lt r1 r2 6", "lt_r1_r2_6"},
     {{le, r0, r7, 2}, true, le, "le r0 r7 2", "le_r0_r7_2"},
     {{pl, r2, r2, 0}, true, pl, "pl r2 r2 0", "pl_r2_r2_0"},
     {{vs, r2, r6, 2}, true, vs, "vs r2 r6 2", "vs_r2_r6_2"},
     {{pl, r0, r7, 7}, true, pl, "pl r0 r7 7", "pl_r0_r7_7"},
     {{gt, r6, r2, 5}, true, gt, "gt r6 r2 5", "gt_r6_r2_5"},
     {{cs, r4, r3, 1}, true, cs, "cs r4 r3 1", "cs_r4_r3_1"},
     {{ne, r3, r5, 4}, true, ne, "ne r3 r5 4", "ne_r3_r5_4"},
     {{mi, r0, r0, 0}, true, mi, "mi r0 r0 0", "mi_r0_r0_0"},
     {{ge, r2, r0, 1}, true, ge, "ge r2 r0 1", "ge_r2_r0_1"},
     {{mi, r7, r3, 7}, true, mi, "mi r7 r3 7", "mi_r7_r3_7"},
     {{ne, r0, r7, 2}, true, ne, "ne r0 r7 2", "ne_r0_r7_2"},
     {{ge, r0, r6, 2}, true, ge, "ge r0 r6 2", "ge_r0_r6_2"},
     {{hi, r2, r7, 2}, true, hi, "hi r2 r7 2", "hi_r2_r7_2"},
     {{vs, r0, r4, 0}, true, vs, "vs r0 r4 0", "vs_r0_r4_0"},
     {{hi, r2, r1, 0}, true, hi, "hi r2 r1 0", "hi_r2_r1_0"},
     {{hi, r7, r0, 3}, true, hi, "hi r7 r0 3", "hi_r7_r0_3"},
     {{ge, r5, r4, 0}, true, ge, "ge r5 r4 0", "ge_r5_r4_0"},
     {{mi, r4, r1, 3}, true, mi, "mi r4 r1 3", "mi_r4_r1_3"},
     {{le, r1, r6, 3}, true, le, "le r1 r6 3", "le_r1_r6_3"},
     {{le, r7, r6, 2}, true, le, "le r7 r6 2", "le_r7_r6_2"},
     {{mi, r6, r3, 4}, true, mi, "mi r6 r3 4", "mi_r6_r3_4"},
     {{cs, r4, r4, 0}, true, cs, "cs r4 r4 0", "cs_r4_r4_0"},
     {{cc, r2, r3, 2}, true, cc, "cc r2 r3 2", "cc_r2_r3_2"},
     {{mi, r1, r5, 4}, true, mi, "mi r1 r5 4", "mi_r1_r5_4"},
     {{cc, r5, r3, 2}, true, cc, "cc r5 r3 2", "cc_r5_r3_2"},
     {{gt, r2, r0, 2}, true, gt, "gt r2 r0 2", "gt_r2_r0_2"},
     {{le, r2, r4, 7}, true, le, "le r2 r4 7", "le_r2_r4_7"},
     {{vc, r2, r3, 3}, true, vc, "vc r2 r3 3", "vc_r2_r3_3"},
     {{eq, r4, r2, 3}, true, eq, "eq r4 r2 3", "eq_r4_r2_3"},
     {{ge, r6, r0, 7}, true, ge, "ge r6 r0 7", "ge_r6_r0_7"},
     {{eq, r0, r7, 7}, true, eq, "eq r0 r7 7", "eq_r0_r7_7"},
     {{gt, r5, r6, 2}, true, gt, "gt r5 r6 2", "gt_r5_r6_2"},
     {{ne, r6, r0, 7}, true, ne, "ne r6 r0 7", "ne_r6_r0_7"},
     {{ne, r7, r0, 4}, true, ne, "ne r7 r0 4", "ne_r7_r0_4"},
     {{eq, r7, r7, 1}, true, eq, "eq r7 r7 1", "eq_r7_r7_1"},
     {{le, r6, r5, 0}, true, le, "le r6 r5 0", "le_r6_r5_0"},
     {{vc, r3, r6, 7}, true, vc, "vc r3 r6 7", "vc_r3_r6_7"},
     {{pl, r0, r3, 7}, true, pl, "pl r0 r3 7", "pl_r0_r3_7"},
     {{ls, r5, r5, 0}, true, ls, "ls r5 r5 0", "ls_r5_r5_0"},
     {{ge, r6, r3, 7}, true, ge, "ge r6 r3 7", "ge_r6_r3_7"},
     {{eq, r3, r2, 6}, true, eq, "eq r3 r2 6", "eq_r3_r2_6"},
     {{cs, r5, r3, 7}, true, cs, "cs r5 r3 7", "cs_r5_r3_7"},
     {{cc, r3, r5, 7}, true, cc, "cc r3 r5 7", "cc_r3_r5_7"},
     {{ge, r6, r1, 4}, true, ge, "ge r6 r1 4", "ge_r6_r1_4"},
     {{mi, r5, r4, 5}, true, mi, "mi r5 r4 5", "mi_r5_r4_5"},
     {{eq, r7, r6, 6}, true, eq, "eq r7 r6 6", "eq_r7_r6_6"},
     {{gt, r2, r2, 2}, true, gt, "gt r2 r2 2", "gt_r2_r2_2"},
     {{mi, r1, r0, 2}, true, mi, "mi r1 r0 2", "mi_r1_r0_2"},
     {{eq, r2, r2, 1}, true, eq, "eq r2 r2 1", "eq_r2_r2_1"},
     {{lt, r1, r2, 1}, true, lt, "lt r1 r2 1", "lt_r1_r2_1"},
     {{cc, r5, r1, 3}, true, cc, "cc r5 r1 3", "cc_r5_r1_3"},
     {{ge, r1, r7, 5}, true, ge, "ge r1 r7 5", "ge_r1_r7_5"},
     {{lt, r6, r3, 3}, true, lt, "lt r6 r3 3", "lt_r6_r3_3"},
     {{vc, r3, r1, 7}, true, vc, "vc r3 r1 7", "vc_r3_r1_7"},
     {{mi, r7, r2, 7}, true, mi, "mi r7 r2 7", "mi_r7_r2_7"},
     {{lt, r0, r3, 1}, true, lt, "lt r0 r3 1", "lt_r0_r3_1"},
     {{cs, r1, r7, 1}, true, cs, "cs r1 r7 1", "cs_r1_r7_1"},
     {{cc, r3, r4, 5}, true, cc, "cc r3 r4 5", "cc_r3_r4_5"},
     {{lt, r5, r0, 2}, true, lt, "lt r5 r0 2", "lt_r5_r0_2"},
     {{hi, r1, r5, 7}, true, hi, "hi r1 r5 7", "hi_r1_r5_7"},
     {{ne, r4, r6, 5}, true, ne, "ne r4 r6 5", "ne_r4_r6_5"},
     {{vc, r2, r3, 6}, true, vc, "vc r2 r3 6", "vc_r2_r3_6"},
     {{mi, r1, r7, 0}, true, mi, "mi r1 r7 0", "mi_r1_r7_0"},
     {{hi, r0, r2, 4}, true, hi, "hi r0 r2 4", "hi_r0_r2_4"},
     {{cs, r5, r2, 5}, true, cs, "cs r5 r2 5", "cs_r5_r2_5"},
     {{ge, r2, r6, 3}, true, ge, "ge r2 r6 3", "ge_r2_r6_3"},
     {{cs, r2, r7, 5}, true, cs, "cs r2 r7 5", "cs_r2_r7_5"},
     {{eq, r1, r6, 5}, true, eq, "eq r1 r6 5", "eq_r1_r6_5"},
     {{vc, r7, r0, 6}, true, vc, "vc r7 r0 6", "vc_r7_r0_6"},
     {{vs, r1, r0, 2}, true, vs, "vs r1 r0 2", "vs_r1_r0_2"},
     {{eq, r3, r3, 5}, true, eq, "eq r3 r3 5", "eq_r3_r3_5"},
     {{cc, r0, r4, 5}, true, cc, "cc r0 r4 5", "cc_r0_r4_5"},
     {{lt, r7, r2, 5}, true, lt, "lt r7 r2 5", "lt_r7_r2_5"},
     {{pl, r1, r1, 0}, true, pl, "pl r1 r1 0", "pl_r1_r1_0"},
     {{hi, r7, r2, 5}, true, hi, "hi r7 r2 5", "hi_r7_r2_5"},
     {{cc, r0, r4, 0}, true, cc, "cc r0 r4 0", "cc_r0_r4_0"},
     {{eq, r0, r3, 7}, true, eq, "eq r0 r3 7", "eq_r0_r3_7"},
     {{lt, r4, r5, 0}, true, lt, "lt r4 r5 0", "lt_r4_r5_0"},
     {{vc, r5, r4, 7}, true, vc, "vc r5 r4 7", "vc_r5_r4_7"},
     {{gt, r7, r7, 0}, true, gt, "gt r7 r7 0", "gt_r7_r7_0"},
     {{le, r1, r2, 7}, true, le, "le r1 r2 7", "le_r1_r2_7"},
     {{cc, r0, r4, 6}, true, cc, "cc r0 r4 6", "cc_r0_r4_6"},
     {{eq, r1, r5, 5}, true, eq, "eq r1 r5 5", "eq_r1_r5_5"},
     {{hi, r1, r5, 2}, true, hi, "hi r1 r5 2", "hi_r1_r5_2"},
     {{ne, r2, r4, 1}, true, ne, "ne r2 r4 1", "ne_r2_r4_1"},
     {{cc, r3, r6, 6}, true, cc, "cc r3 r6 6", "cc_r3_r6_6"},
     {{eq, r7, r7, 6}, true, eq, "eq r7 r7 6", "eq_r7_r7_6"},
     {{ne, r5, r4, 4}, true, ne, "ne r5 r4 4", "ne_r5_r4_4"},
     {{eq, r2, r4, 2}, true, eq, "eq r2 r4 2", "eq_r2_r4_2"},
     {{vc, r2, r1, 2}, true, vc, "vc r2 r1 2", "vc_r2_r1_2"},
     {{ge, r5, r1, 3}, true, ge, "ge r5 r1 3", "ge_r5_r1_3"},
     {{hi, r0, r0, 5}, true, hi, "hi r0 r0 5", "hi_r0_r0_5"},
     {{ne, r6, r2, 6}, true, ne, "ne r6 r2 6", "ne_r6_r2_6"},
     {{vc, r2, r5, 0}, true, vc, "vc r2 r5 0", "vc_r2_r5_0"},
     {{le, r1, r3, 3}, true, le, "le r1 r3 3", "le_r1_r3_3"},
     {{mi, r0, r2, 0}, true, mi, "mi r0 r2 0", "mi_r0_r2_0"},
     {{mi, r1, r2, 7}, true, mi, "mi r1 r2 7", "mi_r1_r2_7"},
     {{vc, r6, r5, 5}, true, vc, "vc r6 r5 5", "vc_r6_r5_5"},
     {{ge, r2, r0, 3}, true, ge, "ge r2 r0 3", "ge_r2_r0_3"},
     {{le, r5, r0, 7}, true, le, "le r5 r0 7", "le_r5_r0_7"},
     {{lt, r1, r4, 0}, true, lt, "lt r1 r4 0", "lt_r1_r4_0"},
     {{le, r4, r4, 3}, true, le, "le r4 r4 3", "le_r4_r4_3"},
     {{vs, r0, r6, 5}, true, vs, "vs r0 r6 5", "vs_r0_r6_5"},
     {{vs, r0, r0, 2}, true, vs, "vs r0 r0 2", "vs_r0_r0_2"},
     {{ne, r4, r3, 3}, true, ne, "ne r4 r3 3", "ne_r4_r3_3"},
     {{ge, r0, r6, 5}, true, ge, "ge r0 r6 5", "ge_r0_r6_5"},
     {{pl, r6, r0, 5}, true, pl, "pl r6 r0 5", "pl_r6_r0_5"},
     {{ls, r5, r3, 4}, true, ls, "ls r5 r3 4", "ls_r5_r3_4"},
     {{vs, r3, r4, 5}, true, vs, "vs r3 r4 5", "vs_r3_r4_5"},
     {{gt, r1, r4, 6}, true, gt, "gt r1 r4 6", "gt_r1_r4_6"},
     {{vc, r1, r1, 2}, true, vc, "vc r1 r1 2", "vc_r1_r1_2"},
     {{lt, r7, r1, 5}, true, lt, "lt r7 r1 5", "lt_r7_r1_5"},
     {{eq, r0, r4, 1}, true, eq, "eq r0 r4 1", "eq_r0_r4_1"},
     {{le, r0, r4, 2}, true, le, "le r0 r4 2", "le_r0_r4_2"},
     {{vc, r0, r0, 4}, true, vc, "vc r0 r0 4", "vc_r0_r0_4"},
     {{eq, r4, r6, 3}, true, eq, "eq r4 r6 3", "eq_r4_r6_3"},
     {{eq, r7, r1, 4}, true, eq, "eq r7 r1 4", "eq_r7_r1_4"},
     {{pl, r5, r4, 7}, true, pl, "pl r5 r4 7", "pl_r5_r4_7"},
     {{ge, r6, r0, 3}, true, ge, "ge r6 r0 3", "ge_r6_r0_3"},
     {{gt, r5, r5, 4}, true, gt, "gt r5 r5 4", "gt_r5_r5_4"},
     {{mi, r6, r0, 2}, true, mi, "mi r6 r0 2", "mi_r6_r0_2"},
     {{gt, r7, r5, 2}, true, gt, "gt r7 r5 2", "gt_r7_r5_2"},
     {{le, r0, r6, 5}, true, le, "le r0 r6 5", "le_r0_r6_5"},
     {{vc, r1, r5, 6}, true, vc, "vc r1 r5 6", "vc_r1_r5_6"},
     {{eq, r5, r5, 5}, true, eq, "eq r5 r5 5", "eq_r5_r5_5"},
     {{ge, r2, r6, 2}, true, ge, "ge r2 r6 2", "ge_r2_r6_2"},
     {{eq, r4, r4, 7}, true, eq, "eq r4 r4 7", "eq_r4_r4_7"},
     {{ne, r5, r5, 4}, true, ne, "ne r5 r5 4", "ne_r5_r5_4"},
     {{lt, r2, r1, 0}, true, lt, "lt r2 r1 0", "lt_r2_r1_0"},
     {{gt, r4, r0, 4}, true, gt, "gt r4 r0 4", "gt_r4_r0_4"},
     {{le, r0, r0, 1}, true, le, "le r0 r0 1", "le_r0_r0_1"},
     {{pl, r1, r3, 1}, true, pl, "pl r1 r3 1", "pl_r1_r3_1"},
     {{ge, r6, r2, 0}, true, ge, "ge r6 r2 0", "ge_r6_r2_0"},
     {{ne, r2, r6, 0}, true, ne, "ne r2 r6 0", "ne_r2_r6_0"},
     {{cs, r3, r2, 5}, true, cs, "cs r3 r2 5", "cs_r3_r2_5"},
     {{eq, r3, r3, 2}, true, eq, "eq r3 r3 2", "eq_r3_r3_2"},
     {{ne, r6, r6, 5}, true, ne, "ne r6 r6 5", "ne_r6_r6_5"},
     {{vc, r5, r2, 2}, true, vc, "vc r5 r2 2", "vc_r5_r2_2"},
     {{pl, r3, r6, 4}, true, pl, "pl r3 r6 4", "pl_r3_r6_4"},
     {{cs, r5, r7, 6}, true, cs, "cs r5 r7 6", "cs_r5_r7_6"},
     {{cs, r2, r1, 7}, true, cs, "cs r2 r1 7", "cs_r2_r1_7"},
     {{pl, r4, r5, 5}, true, pl, "pl r4 r5 5", "pl_r4_r5_5"},
     {{pl, r1, r5, 7}, true, pl, "pl r1 r5 7", "pl_r1_r5_7"},
     {{mi, r4, r3, 5}, true, mi, "mi r4 r3 5", "mi_r4_r3_5"},
     {{vc, r0, r4, 0}, true, vc, "vc r0 r4 0", "vc_r0_r4_0"},
     {{le, r2, r7, 0}, true, le, "le r2 r7 0", "le_r2_r7_0"},
     {{cc, r7, r2, 6}, true, cc, "cc r7 r2 6", "cc_r7_r2_6"},
     {{vs, r7, r1, 1}, true, vs, "vs r7 r1 1", "vs_r7_r1_1"},
     {{gt, r3, r3, 5}, true, gt, "gt r3 r3 5", "gt_r3_r3_5"},
     {{eq, r7, r1, 1}, true, eq, "eq r7 r1 1", "eq_r7_r1_1"},
     {{pl, r5, r7, 5}, true, pl, "pl r5 r7 5", "pl_r5_r7_5"},
     {{hi, r5, r6, 1}, true, hi, "hi r5 r6 1", "hi_r5_r6_1"},
     {{cc, r2, r0, 0}, true, cc, "cc r2 r0 0", "cc_r2_r0_0"},
     {{cs, r7, r7, 2}, true, cs, "cs r7 r7 2", "cs_r7_r7_2"},
     {{ne, r0, r3, 6}, true, ne, "ne r0 r3 6", "ne_r0_r3_6"},
     {{mi, r4, r7, 2}, true, mi, "mi r4 r7 2", "mi_r4_r7_2"},
     {{le, r4, r4, 7}, true, le, "le r4 r4 7", "le_r4_r4_7"},
     {{gt, r1, r1, 0}, true, gt, "gt r1 r1 0", "gt_r1_r1_0"},
     {{vs, r2, r5, 1}, true, vs, "vs r2 r5 1", "vs_r2_r5_1"},
     {{ls, r7, r2, 4}, true, ls, "ls r7 r2 4", "ls_r7_r2_4"},
     {{vs, r2, r1, 4}, true, vs, "vs r2 r1 4", "vs_r2_r1_4"},
     {{eq, r5, r6, 5}, true, eq, "eq r5 r6 5", "eq_r5_r6_5"},
     {{vs, r4, r3, 4}, true, vs, "vs r4 r3 4", "vs_r4_r3_4"},
     {{vs, r2, r1, 2}, true, vs, "vs r2 r1 2", "vs_r2_r1_2"},
     {{hi, r0, r3, 3}, true, hi, "hi r0 r3 3", "hi_r0_r3_3"},
     {{hi, r4, r1, 5}, true, hi, "hi r4 r1 5", "hi_r4_r1_5"},
     {{pl, r6, r6, 7}, true, pl, "pl r6 r6 7", "pl_r6_r6_7"},
     {{gt, r0, r5, 0}, true, gt, "gt r0 r5 0", "gt_r0_r5_0"},
     {{cc, r5, r0, 7}, true, cc, "cc r5 r0 7", "cc_r5_r0_7"},
     {{ls, r7, r7, 7}, true, ls, "ls r7 r7 7", "ls_r7_r7_7"},
     {{vc, r6, r3, 0}, true, vc, "vc r6 r3 0", "vc_r6_r3_0"},
     {{cc, r6, r4, 4}, true, cc, "cc r6 r4 4", "cc_r6_r4_4"},
     {{cc, r6, r5, 0}, true, cc, "cc r6 r5 0", "cc_r6_r5_0"},
     {{le, r2, r0, 6}, true, le, "le r2 r0 6", "le_r2_r0_6"},
     {{gt, r5, r6, 3}, true, gt, "gt r5 r6 3", "gt_r5_r6_3"},
     {{vs, r3, r4, 0}, true, vs, "vs r3 r4 0", "vs_r3_r4_0"},
     {{le, r4, r4, 1}, true, le, "le r4 r4 1", "le_r4_r4_1"},
     {{ge, r4, r0, 6}, true, ge, "ge r4 r0 6", "ge_r4_r0_6"},
     {{eq, r2, r3, 2}, true, eq, "eq r2 r3 2", "eq_r2_r3_2"},
     {{lt, r5, r1, 6}, true, lt, "lt r5 r1 6", "lt_r5_r1_6"},
     {{le, r7, r2, 0}, true, le, "le r7 r2 0", "le_r7_r2_0"},
     {{mi, r2, r4, 6}, true, mi, "mi r2 r4 6", "mi_r2_r4_6"},
     {{vc, r6, r5, 4}, true, vc, "vc r6 r5 4", "vc_r6_r5_4"},
     {{gt, r3, r6, 5}, true, gt, "gt r3 r6 5", "gt_r3_r6_5"},
     {{pl, r3, r2, 0}, true, pl, "pl r3 r2 0", "pl_r3_r2_0"},
     {{ls, r3, r2, 2}, true, ls, "ls r3 r2 2", "ls_r3_r2_2"},
     {{ge, r2, r7, 7}, true, ge, "ge r2 r7 7", "ge_r2_r7_7"},
     {{vc, r3, r5, 0}, true, vc, "vc r3 r5 0", "vc_r3_r5_0"},
     {{cc, r4, r0, 7}, true, cc, "cc r4 r0 7", "cc_r4_r0_7"},
     {{ls, r3, r5, 2}, true, ls, "ls r3 r5 2", "ls_r3_r5_2"},
     {{vc, r6, r7, 6}, true, vc, "vc r6 r7 6", "vc_r6_r7_6"},
     {{ls, r0, r3, 6}, true, ls, "ls r0 r3 6", "ls_r0_r3_6"},
     {{hi, r6, r0, 1}, true, hi, "hi r6 r0 1", "hi_r6_r0_1"},
     {{mi, r5, r0, 6}, true, mi, "mi r5 r0 6", "mi_r5_r0_6"},
     {{mi, r2, r5, 3}, true, mi, "mi r2 r5 3", "mi_r2_r5_3"},
     {{ge, r0, r7, 0}, true, ge, "ge r0 r7 0", "ge_r0_r7_0"},
     {{vc, r7, r3, 3}, true, vc, "vc r7 r3 3", "vc_r7_r3_3"},
     {{mi, r0, r2, 5}, true, mi, "mi r0 r2 5", "mi_r0_r2_5"},
     {{cc, r4, r3, 5}, true, cc, "cc r4 r3 5", "cc_r4_r3_5"},
     {{pl, r0, r3, 0}, true, pl, "pl r0 r3 0", "pl_r0_r3_0"},
     {{gt, r6, r3, 1}, true, gt, "gt r6 r3 1", "gt_r6_r3_1"},
     {{lt, r3, r3, 0}, true, lt, "lt r3 r3 0", "lt_r3_r3_0"},
     {{hi, r1, r5, 6}, true, hi, "hi r1 r5 6", "hi_r1_r5_6"},
     {{hi, r4, r7, 0}, true, hi, "hi r4 r7 0", "hi_r4_r7_0"},
     {{ge, r6, r2, 2}, true, ge, "ge r6 r2 2", "ge_r6_r2_2"},
     {{pl, r7, r4, 4}, true, pl, "pl r7 r4 4", "pl_r7_r4_4"},
     {{cc, r5, r5, 5}, true, cc, "cc r5 r5 5", "cc_r5_r5_5"},
     {{pl, r6, r1, 1}, true, pl, "pl r6 r1 1", "pl_r6_r1_1"},
     {{le, r7, r6, 3}, true, le, "le r7 r6 3", "le_r7_r6_3"},
     {{lt, r4, r7, 1}, true, lt, "lt r4 r7 1", "lt_r4_r7_1"},
     {{pl, r2, r4, 7}, true, pl, "pl r2 r4 7", "pl_r2_r4_7"},
     {{vc, r1, r3, 0}, true, vc, "vc r1 r3 0", "vc_r1_r3_0"},
     {{pl, r7, r7, 3}, true, pl, "pl r7 r7 3", "pl_r7_r7_3"},
     {{ls, r4, r1, 3}, true, ls, "ls r4 r1 3", "ls_r4_r1_3"},
     {{lt, r6, r6, 2}, true, lt, "lt r6 r6 2", "lt_r6_r6_2"},
     {{mi, r4, r2, 4}, true, mi, "mi r4 r2 4", "mi_r4_r2_4"},
     {{pl, r3, r4, 7}, true, pl, "pl r3 r4 7", "pl_r3_r4_7"},
     {{ls, r2, r6, 6}, true, ls, "ls r2 r6 6", "ls_r2_r6_6"},
     {{hi, r5, r7, 6}, true, hi, "hi r5 r7 6", "hi_r5_r7_6"},
     {{lt, r0, r4, 1}, true, lt, "lt r0 r4 1", "lt_r0_r4_1"},
     {{ge, r5, r5, 6}, true, ge, "ge r5 r5 6", "ge_r5_r5_6"},
     {{pl, r1, r7, 3}, true, pl, "pl r1 r7 3", "pl_r1_r7_3"},
     {{cs, r6, r2, 1}, true, cs, "cs r6 r2 1", "cs_r6_r2_1"},
     {{ne, r1, r3, 0}, true, ne, "ne r1 r3 0", "ne_r1_r3_0"},
     {{mi, r6, r5, 7}, true, mi, "mi r6 r5 7", "mi_r6_r5_7"},
     {{gt, r2, r2, 0}, true, gt, "gt r2 r2 0", "gt_r2_r2_0"},
     {{ls, r6, r4, 6}, true, ls, "ls r6 r4 6", "ls_r6_r4_6"},
     {{pl, r2, r6, 7}, true, pl, "pl r2 r6 7", "pl_r2_r6_7"},
     {{ne, r1, r5, 4}, true, ne, "ne r1 r5 4", "ne_r1_r5_4"},
     {{mi, r0, r0, 5}, true, mi, "mi r0 r0 5", "mi_r0_r0_5"},
     {{eq, r5, r5, 2}, true, eq, "eq r5 r5 2", "eq_r5_r5_2"},
     {{mi, r7, r7, 3}, true, mi, "mi r7 r7 3", "mi_r7_r7_3"},
     {{vc, r7, r7, 1}, true, vc, "vc r7 r7 1", "vc_r7_r7_1"},
     {{vc, r5, r4, 3}, true, vc, "vc r5 r4 3", "vc_r5_r4_3"},
     {{mi, r5, r7, 6}, true, mi, "mi r5 r7 6", "mi_r5_r7_6"},
     {{vs, r2, r3, 0}, true, vs, "vs r2 r3 0", "vs_r2_r3_0"},
     {{ne, r2, r4, 2}, true, ne, "ne r2 r4 2", "ne_r2_r4_2"},
     {{eq, r6, r7, 3}, true, eq, "eq r6 r7 3", "eq_r6_r7_3"},
     {{ne, r0, r1, 5}, true, ne, "ne r0 r1 5", "ne_r0_r1_5"},
     {{lt, r3, r2, 6}, true, lt, "lt r3 r2 6", "lt_r3_r2_6"},
     {{gt, r4, r2, 1}, true, gt, "gt r4 r2 1", "gt_r4_r2_1"},
     {{ls, r6, r1, 0}, true, ls, "ls r6 r1 0", "ls_r6_r1_0"},
     {{cc, r6, r2, 3}, true, cc, "cc r6 r2 3", "cc_r6_r2_3"},
     {{hi, r3, r2, 7}, true, hi, "hi r3 r2 7", "hi_r3_r2_7"},
     {{cc, r6, r7, 3}, true, cc, "cc r6 r7 3", "cc_r6_r7_3"},
     {{vs, r7, r6, 4}, true, vs, "vs r7 r6 4", "vs_r7_r6_4"},
     {{gt, r5, r4, 5}, true, gt, "gt r5 r4 5", "gt_r5_r4_5"},
     {{vc, r5, r7, 6}, true, vc, "vc r5 r7 6", "vc_r5_r7_6"},
     {{hi, r0, r6, 5}, true, hi, "hi r0 r6 5", "hi_r0_r6_5"},
     {{eq, r2, r7, 3}, true, eq, "eq r2 r7 3", "eq_r2_r7_3"},
     {{le, r6, r5, 7}, true, le, "le r6 r5 7", "le_r6_r5_7"},
     {{ge, r0, r5, 5}, true, ge, "ge r0 r5 5", "ge_r0_r5_5"},
     {{pl, r1, r6, 4}, true, pl, "pl r1 r6 4", "pl_r1_r6_4"},
     {{mi, r3, r0, 6}, true, mi, "mi r3 r0 6", "mi_r3_r0_6"},
     {{cs, r7, r6, 1}, true, cs, "cs r7 r6 1", "cs_r7_r6_1"},
     {{vc, r3, r6, 3}, true, vc, "vc r3 r6 3", "vc_r3_r6_3"},
     {{ls, r5, r1, 4}, true, ls, "ls r5 r1 4", "ls_r5_r1_4"},
     {{le, r6, r2, 3}, true, le, "le r6 r2 3", "le_r6_r2_3"},
     {{cc, r1, r6, 4}, true, cc, "cc r1 r6 4", "cc_r1_r6_4"},
     {{mi, r0, r7, 0}, true, mi, "mi r0 r7 0", "mi_r0_r7_0"},
     {{vc, r6, r2, 2}, true, vc, "vc r6 r2 2", "vc_r6_r2_2"},
     {{gt, r3, r0, 4}, true, gt, "gt r3 r0 4", "gt_r3_r0_4"},
     {{cs, r4, r0, 5}, true, cs, "cs r4 r0 5", "cs_r4_r0_5"},
     {{hi, r4, r4, 6}, true, hi, "hi r4 r4 6", "hi_r4_r4_6"},
     {{cc, r5, r5, 1}, true, cc, "cc r5 r5 1", "cc_r5_r5_1"},
     {{pl, r6, r3, 4}, true, pl, "pl r6 r3 4", "pl_r6_r3_4"},
     {{ge, r7, r4, 0}, true, ge, "ge r7 r4 0", "ge_r7_r4_0"},
     {{hi, r2, r1, 3}, true, hi, "hi r2 r1 3", "hi_r2_r1_3"},
     {{le, r4, r3, 1}, true, le, "le r4 r3 1", "le_r4_r3_1"},
     {{gt, r0, r0, 7}, true, gt, "gt r0 r0 7", "gt_r0_r0_7"},
     {{gt, r2, r0, 6}, true, gt, "gt r2 r0 6", "gt_r2_r0_6"},
     {{ge, r4, r3, 5}, true, ge, "ge r4 r3 5", "ge_r4_r3_5"},
     {{le, r2, r0, 7}, true, le, "le r2 r0 7", "le_r2_r0_7"},
     {{vc, r7, r7, 4}, true, vc, "vc r7 r7 4", "vc_r7_r7_4"},
     {{lt, r6, r5, 1}, true, lt, "lt r6 r5 1", "lt_r6_r5_1"},
     {{vs, r1, r0, 4}, true, vs, "vs r1 r0 4", "vs_r1_r0_4"},
     {{vs, r1, r1, 6}, true, vs, "vs r1 r1 6", "vs_r1_r1_6"},
     {{ge, r1, r0, 6}, true, ge, "ge r1 r0 6", "ge_r1_r0_6"},
     {{eq, r1, r6, 0}, true, eq, "eq r1 r6 0", "eq_r1_r6_0"},
     {{cs, r0, r5, 5}, true, cs, "cs r0 r5 5", "cs_r0_r5_5"},
     {{mi, r7, r6, 5}, true, mi, "mi r7 r6 5", "mi_r7_r6_5"},
     {{vc, r1, r4, 3}, true, vc, "vc r1 r4 3", "vc_r1_r4_3"},
     {{hi, r1, r3, 4}, true, hi, "hi r1 r3 4", "hi_r1_r3_4"},
     {{vs, r3, r6, 3}, true, vs, "vs r3 r6 3", "vs_r3_r6_3"},
     {{vc, r1, r6, 1}, true, vc, "vc r1 r6 1", "vc_r1_r6_1"},
     {{mi, r3, r7, 1}, true, mi, "mi r3 r7 1", "mi_r3_r7_1"},
     {{eq, r7, r0, 1}, true, eq, "eq r7 r0 1", "eq_r7_r0_1"},
     {{hi, r3, r7, 7}, true, hi, "hi r3 r7 7", "hi_r3_r7_7"},
     {{mi, r3, r4, 3}, true, mi, "mi r3 r4 3", "mi_r3_r4_3"},
     {{le, r3, r1, 2}, true, le, "le r3 r1 2", "le_r3_r1_2"},
     {{mi, r1, r3, 5}, true, mi, "mi r1 r3 5", "mi_r1_r3_5"},
     {{vc, r2, r2, 4}, true, vc, "vc r2 r2 4", "vc_r2_r2_4"},
     {{vc, r4, r7, 2}, true, vc, "vc r4 r7 2", "vc_r4_r7_2"},
     {{vs, r3, r7, 0}, true, vs, "vs r3 r7 0", "vs_r3_r7_0"},
     {{gt, r7, r1, 3}, true, gt, "gt r7 r1 3", "gt_r7_r1_3"},
     {{hi, r7, r4, 7}, true, hi, "hi r7 r4 7", "hi_r7_r4_7"},
     {{hi, r1, r0, 3}, true, hi, "hi r1 r0 3", "hi_r1_r0_3"},
     {{ne, r0, r4, 5}, true, ne, "ne r0 r4 5", "ne_r0_r4_5"},
     {{hi, r7, r6, 3}, true, hi, "hi r7 r6 3", "hi_r7_r6_3"},
     {{ne, r3, r4, 4}, true, ne, "ne r3 r4 4", "ne_r3_r4_4"},
     {{pl, r2, r5, 5}, true, pl, "pl r2 r5 5", "pl_r2_r5_5"},
     {{ge, r6, r7, 0}, true, ge, "ge r6 r7 0", "ge_r6_r7_0"},
     {{ne, r7, r3, 4}, true, ne, "ne r7 r3 4", "ne_r7_r3_4"},
     {{ls, r5, r2, 6}, true, ls, "ls r5 r2 6", "ls_r5_r2_6"},
     {{cs, r6, r3, 2}, true, cs, "cs r6 r3 2", "cs_r6_r3_2"},
     {{vs, r0, r1, 6}, true, vs, "vs r0 r1 6", "vs_r0_r1_6"},
     {{vc, r6, r3, 7}, true, vc, "vc r6 r3 7", "vc_r6_r3_7"},
     {{eq, r3, r0, 5}, true, eq, "eq r3 r0 5", "eq_r3_r0_5"},
     {{cc, r4, r5, 0}, true, cc, "cc r4 r5 0", "cc_r4_r5_0"},
     {{hi, r3, r1, 2}, true, hi, "hi r3 r1 2", "hi_r3_r1_2"},
     {{lt, r2, r5, 5}, true, lt, "lt r2 r5 5", "lt_r2_r5_5"},
     {{le, r0, r3, 3}, true, le, "le r0 r3 3", "le_r0_r3_3"},
     {{vc, r2, r5, 7}, true, vc, "vc r2 r5 7", "vc_r2_r5_7"},
     {{gt, r7, r1, 7}, true, gt, "gt r7 r1 7", "gt_r7_r1_7"},
     {{le, r2, r1, 5}, true, le, "le r2 r1 5", "le_r2_r1_5"},
     {{mi, r4, r2, 0}, true, mi, "mi r4 r2 0", "mi_r4_r2_0"},
     {{ne, r4, r3, 2}, true, ne, "ne r4 r3 2", "ne_r4_r3_2"},
     {{le, r3, r0, 7}, true, le, "le r3 r0 7", "le_r3_r0_7"},
     {{vc, r6, r5, 7}, true, vc, "vc r6 r5 7", "vc_r6_r5_7"},
     {{lt, r5, r5, 0}, true, lt, "lt r5 r5 0", "lt_r5_r5_0"},
     {{le, r5, r7, 2}, true, le, "le r5 r7 2", "le_r5_r7_2"},
     {{mi, r2, r6, 4}, true, mi, "mi r2 r6 4", "mi_r2_r6_4"},
     {{ne, r5, r4, 5}, true, ne, "ne r5 r4 5", "ne_r5_r4_5"},
     {{mi, r5, r7, 2}, true, mi, "mi r5 r7 2", "mi_r5_r7_2"},
     {{lt, r7, r1, 1}, true, lt, "lt r7 r1 1", "lt_r7_r1_1"},
     {{cc, r3, r0, 5}, true, cc, "cc r3 r0 5", "cc_r3_r0_5"},
     {{pl, r2, r2, 7}, true, pl, "pl r2 r2 7", "pl_r2_r2_7"},
     {{lt, r3, r5, 0}, true, lt, "lt r3 r5 0", "lt_r3_r5_0"},
     {{cs, r7, r7, 5}, true, cs, "cs r7 r7 5", "cs_r7_r7_5"},
     {{ge, r6, r5, 2}, true, ge, "ge r6 r5 2", "ge_r6_r5_2"},
     {{pl, r2, r7, 1}, true, pl, "pl r2 r7 1", "pl_r2_r7_1"},
     {{gt, r1, r5, 0}, true, gt, "gt r1 r5 0", "gt_r1_r5_0"},
     {{hi, r4, r2, 6}, true, hi, "hi r4 r2 6", "hi_r4_r2_6"},
     {{ls, r4, r6, 1}, true, ls, "ls r4 r6 1", "ls_r4_r6_1"},
     {{vc, r4, r6, 5}, true, vc, "vc r4 r6 5", "vc_r4_r6_5"},
     {{ne, r0, r2, 7}, true, ne, "ne r0 r2 7", "ne_r0_r2_7"},
     {{ne, r1, r7, 3}, true, ne, "ne r1 r7 3", "ne_r1_r7_3"},
     {{pl, r2, r1, 2}, true, pl, "pl r2 r1 2", "pl_r2_r1_2"},
     {{le, r6, r2, 2}, true, le, "le r6 r2 2", "le_r6_r2_2"},
     {{ne, r3, r6, 0}, true, ne, "ne r3 r6 0", "ne_r3_r6_0"},
     {{lt, r5, r6, 6}, true, lt, "lt r5 r6 6", "lt_r5_r6_6"},
     {{eq, r3, r2, 2}, true, eq, "eq r3 r2 2", "eq_r3_r2_2"},
     {{pl, r1, r6, 7}, true, pl, "pl r1 r6 7", "pl_r1_r6_7"},
     {{mi, r7, r0, 6}, true, mi, "mi r7 r0 6", "mi_r7_r0_6"},
     {{le, r7, r2, 7}, true, le, "le r7 r2 7", "le_r7_r2_7"},
     {{hi, r0, r3, 1}, true, hi, "hi r0 r3 1", "hi_r0_r3_1"},
     {{ls, r3, r6, 4}, true, ls, "ls r3 r6 4", "ls_r3_r6_4"},
     {{eq, r6, r0, 7}, true, eq, "eq r6 r0 7", "eq_r6_r0_7"},
     {{ne, r1, r4, 5}, true, ne, "ne r1 r4 5", "ne_r1_r4_5"},
     {{le, r1, r5, 3}, true, le, "le r1 r5 3", "le_r1_r5_3"},
     {{cc, r6, r1, 7}, true, cc, "cc r6 r1 7", "cc_r6_r1_7"},
     {{hi, r2, r4, 1}, true, hi, "hi r2 r4 1", "hi_r2_r4_1"},
     {{vs, r3, r7, 2}, true, vs, "vs r3 r7 2", "vs_r3_r7_2"},
     {{pl, r7, r6, 1}, true, pl, "pl r7 r6 1", "pl_r7_r6_1"},
     {{ne, r7, r2, 1}, true, ne, "ne r7 r2 1", "ne_r7_r2_1"},
     {{hi, r1, r0, 0}, true, hi, "hi r1 r0 0", "hi_r1_r0_0"},
     {{vs, r2, r1, 7}, true, vs, "vs r2 r1 7", "vs_r2_r1_7"},
     {{lt, r5, r4, 2}, true, lt, "lt r5 r4 2", "lt_r5_r4_2"},
     {{mi, r3, r1, 0}, true, mi, "mi r3 r1 0", "mi_r3_r1_0"},
     {{ls, r2, r6, 1}, true, ls, "ls r2 r6 1", "ls_r2_r6_1"},
     {{cc, r2, r2, 1}, true, cc, "cc r2 r2 1", "cc_r2_r2_1"},
     {{pl, r4, r0, 7}, true, pl, "pl r4 r0 7", "pl_r4_r0_7"},
     {{cc, r6, r4, 5}, true, cc, "cc r6 r4 5", "cc_r6_r4_5"},
     {{cc, r1, r3, 6}, true, cc, "cc r1 r3 6", "cc_r1_r3_6"},
     {{lt, r0, r3, 2}, true, lt, "lt r0 r3 2", "lt_r0_r3_2"},
     {{ge, r5, r4, 3}, true, ge, "ge r5 r4 3", "ge_r5_r4_3"},
     {{lt, r4, r4, 2}, true, lt, "lt r4 r4 2", "lt_r4_r4_2"},
     {{gt, r3, r1, 6}, true, gt, "gt r3 r1 6", "gt_r3_r1_6"},
     {{pl, r4, r2, 1}, true, pl, "pl r4 r2 1", "pl_r4_r2_1"},
     {{cc, r3, r1, 7}, true, cc, "cc r3 r1 7", "cc_r3_r1_7"},
     {{mi, r1, r3, 7}, true, mi, "mi r1 r3 7", "mi_r1_r3_7"},
     {{cc, r2, r5, 7}, true, cc, "cc r2 r5 7", "cc_r2_r5_7"},
     {{hi, r6, r5, 0}, true, hi, "hi r6 r5 0", "hi_r6_r5_0"},
     {{vc, r1, r0, 7}, true, vc, "vc r1 r0 7", "vc_r1_r0_7"},
     {{cs, r3, r0, 5}, true, cs, "cs r3 r0 5", "cs_r3_r0_5"},
     {{pl, r1, r2, 3}, true, pl, "pl r1 r2 3", "pl_r1_r2_3"},
     {{pl, r2, r6, 3}, true, pl, "pl r2 r6 3", "pl_r2_r6_3"},
     {{ne, r7, r1, 5}, true, ne, "ne r7 r1 5", "ne_r7_r1_5"},
     {{hi, r5, r0, 4}, true, hi, "hi r5 r0 4", "hi_r5_r0_4"},
     {{vc, r6, r1, 0}, true, vc, "vc r6 r1 0", "vc_r6_r1_0"},
     {{vc, r7, r3, 2}, true, vc, "vc r7 r3 2", "vc_r7_r3_2"},
     {{ge, r6, r6, 6}, true, ge, "ge r6 r6 6", "ge_r6_r6_6"},
     {{ne, r6, r1, 0}, true, ne, "ne r6 r1 0", "ne_r6_r1_0"},
     {{eq, r5, r1, 2}, true, eq, "eq r5 r1 2", "eq_r5_r1_2"},
     {{hi, r2, r0, 6}, true, hi, "hi r2 r0 6", "hi_r2_r0_6"},
     {{ne, r7, r4, 5}, true, ne, "ne r7 r4 5", "ne_r7_r4_5"},
     {{cc, r0, r0, 1}, true, cc, "cc r0 r0 1", "cc_r0_r0_1"},
     {{mi, r7, r5, 1}, true, mi, "mi r7 r5 1", "mi_r7_r5_1"},
     {{mi, r7, r0, 0}, true, mi, "mi r7 r0 0", "mi_r7_r0_0"},
     {{ls, r0, r2, 0}, true, ls, "ls r0 r2 0", "ls_r0_r2_0"},
     {{vs, r4, r7, 3}, true, vs, "vs r4 r7 3", "vs_r4_r7_3"},
     {{hi, r6, r2, 4}, true, hi, "hi r6 r2 4", "hi_r6_r2_4"},
     {{eq, r4, r1, 1}, true, eq, "eq r4 r1 1", "eq_r4_r1_1"},
     {{vs, r7, r5, 1}, true, vs, "vs r7 r5 1", "vs_r7_r5_1"},
     {{ne, r0, r4, 7}, true, ne, "ne r0 r4 7", "ne_r0_r4_7"},
     {{mi, r2, r7, 7}, true, mi, "mi r2 r7 7", "mi_r2_r7_7"},
     {{mi, r3, r2, 5}, true, mi, "mi r3 r2 5", "mi_r3_r2_5"},
     {{le, r7, r5, 5}, true, le, "le r7 r5 5", "le_r7_r5_5"},
     {{gt, r0, r5, 7}, true, gt, "gt r0 r5 7", "gt_r0_r5_7"},
     {{vc, r0, r4, 7}, true, vc, "vc r0 r4 7", "vc_r0_r4_7"},
     {{ls, r5, r7, 2}, true, ls, "ls r5 r7 2", "ls_r5_r7_2"},
     {{hi, r0, r6, 1}, true, hi, "hi r0 r6 1", "hi_r0_r6_1"},
     {{cc, r1, r4, 5}, true, cc, "cc r1 r4 5", "cc_r1_r4_5"},
     {{vs, r2, r2, 7}, true, vs, "vs r2 r2 7", "vs_r2_r2_7"},
     {{ge, r6, r6, 1}, true, ge, "ge r6 r6 1", "ge_r6_r6_1"},
     {{hi, r7, r1, 1}, true, hi, "hi r7 r1 1", "hi_r7_r1_1"},
     {{le, r3, r4, 3}, true, le, "le r3 r4 3", "le_r3_r4_3"},
     {{mi, r2, r1, 3}, true, mi, "mi r2 r1 3", "mi_r2_r1_3"},
     {{cs, r7, r7, 4}, true, cs, "cs r7 r7 4", "cs_r7_r7_4"},
     {{cs, r2, r5, 0}, true, cs, "cs r2 r5 0", "cs_r2_r5_0"},
     {{hi, r7, r6, 4}, true, hi, "hi r7 r6 4", "hi_r7_r6_4"},
     {{lt, r7, r5, 1}, true, lt, "lt r7 r5 1", "lt_r7_r5_1"},
     {{gt, r0, r0, 1}, true, gt, "gt r0 r0 1", "gt_r0_r0_1"},
     {{vs, r1, r2, 6}, true, vs, "vs r1 r2 6", "vs_r1_r2_6"},
     {{vs, r3, r3, 1}, true, vs, "vs r3 r3 1", "vs_r3_r3_1"},
     {{ls, r4, r2, 2}, true, ls, "ls r4 r2 2", "ls_r4_r2_2"},
     {{hi, r6, r3, 2}, true, hi, "hi r6 r3 2", "hi_r6_r3_2"},
     {{gt, r7, r5, 3}, true, gt, "gt r7 r5 3", "gt_r7_r5_3"},
     {{vc, r1, r6, 7}, true, vc, "vc r1 r6 7", "vc_r1_r6_7"},
     {{eq, r2, r2, 0}, true, eq, "eq r2 r2 0", "eq_r2_r2_0"},
     {{hi, r7, r6, 1}, true, hi, "hi r7 r6 1", "hi_r7_r6_1"},
     {{gt, r4, r6, 7}, true, gt, "gt r4 r6 7", "gt_r4_r6_7"},
     {{le, r7, r0, 6}, true, le, "le r7 r0 6", "le_r7_r0_6"},
     {{eq, r7, r1, 7}, true, eq, "eq r7 r1 7", "eq_r7_r1_7"},
     {{mi, r0, r6, 7}, true, mi, "mi r0 r6 7", "mi_r0_r6_7"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rdlow-rnlow-operand-immediate-imm3-in-it-block-add-t32.h"
#include "aarch32/traces/assembler-cond-rdlow-rnlow-operand-immediate-imm3-in-it-block-sub-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RDLOW_RNLOW_OPERAND_IMMEDIATE_IMM3_IN_IT_"    \
      "BLOCK_" #mnemonic "_T32",                                            \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
