/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import spec.jbb.JBBmain;

public class JBButil {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private static final String originalText = "ORIGINAL";
    private static Random r;
    private static final String[] last_name_parts;
    private static final char[] alnum;
    public static final short A_C_LAST = 255;
    public static final short C_C_LAST = 173;
    public static final short A_C_ID = 102;
    public static final short C_C_ID = 34;
    public static final short A_OL_I_ID = 8191;
    public static final short C_OL_I_ID = 5456;
    public static final byte MaxOrderLines = 15;
    private static Random[] warehouse_random_stream;
    private static Logger appLog;

    public static long currentFreeMem() {
        long l = 0L;
        l = Runtime.getRuntime().freeMemory();
        return l;
    }

    public static long currentTotalMem() {
        long l = 0L;
        l = Runtime.getRuntime().totalMemory();
        return l;
    }

    public static long currentUsedMem() {
        long l = 0L;
        l = Runtime.getRuntime().totalMemory();
        return l -= Runtime.getRuntime().freeMemory();
    }

    public static void random_init(int n) {
        r = new Random();
        r.setSeed(System.currentTimeMillis());
        warehouse_random_stream = new Random[n];
    }

    public static void set_random_seed(long l) {
        r.setSeed(l);
    }

    public static Random derived_random_init(short s) {
        Random random = new Random();
        random.setSeed((long)(r.nextInt() & Integer.MAX_VALUE) * (long)s);
        return random;
    }

    public static void register_warehouse_Random_stream(short s, Random random) {
        if (warehouse_random_stream[s] != null) {
            System.out.println("Warning:  reregistering Random stream for warehouse " + s);
        }
        JBButil.warehouse_random_stream[s] = random;
    }

    public static int random(int n, int n2) {
        return (r.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1) + n;
    }

    public static int random(int n, int n2, Random random) {
        return (random.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1) + n;
    }

    public static int random(int n, int n2, short s) {
        Random random = warehouse_random_stream[s];
        return (random.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1) + n;
    }

    public static char[] create_random_a_string(int n, int n2) {
        int n3 = JBButil.random(n, n2);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = JBButil.random(0, 61);
            if (n4 > 61) {
                n4 = 61;
            }
            cArray[i] = alnum[n4];
        }
        return cArray;
    }

    public static char[] create_random_a_string(int n, int n2, Random random) {
        int n3 = JBButil.random(n, n2, random);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = JBButil.random(0, 61, random);
            if (n4 > 61) {
                n4 = 61;
            }
            cArray[i] = alnum[n4];
        }
        return cArray;
    }

    public static char[] create_random_a_string(int n, int n2, short s) {
        Random random = warehouse_random_stream[s];
        int n3 = JBButil.random(n, n2, random);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = JBButil.random(0, 61, random);
            if (n4 > 61) {
                n4 = 61;
            }
            cArray[i] = alnum[n4];
        }
        return cArray;
    }

    public static char[] create_random_n_string(int n, int n2) {
        int n3 = JBButil.random(n, n2);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = (char)JBButil.random(48, 57);
        }
        return cArray;
    }

    public static char[] create_random_n_string(int n, int n2, Random random) {
        int n3 = JBButil.random(n, n2, random);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = (char)JBButil.random(48, 57, random);
        }
        return cArray;
    }

    public static char[] create_random_n_string(int n, int n2, short s) {
        Random random = warehouse_random_stream[s];
        int n3 = JBButil.random(n, n2, random);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = (char)JBButil.random(48, 57, random);
        }
        return cArray;
    }

    public static float create_random_float_val_return(float f, float f2, float f3) {
        float f4 = r.nextFloat() * (f2 - f) + f;
        float f5 = f4 - (float)Math.IEEEremainder(f4, f3);
        return f5;
    }

    public static float create_random_float_val_return(float f, float f2, float f3, Random random) {
        float f4 = random.nextFloat() * (f2 - f) + f;
        float f5 = f4 - (float)Math.IEEEremainder(f4, f3);
        return f5;
    }

    public static float create_random_float_val_return(float f, float f2, float f3, short s) {
        Random random = warehouse_random_stream[s];
        float f4 = random.nextFloat() * (f2 - f) + f;
        float f5 = f4 - (float)Math.IEEEremainder(f4, f3);
        return f5;
    }

    public static char[] create_a_string_with_original(int n, int n2, float f, Integer n3) {
        int n4 = JBButil.random(n, n2);
        char[] cArray = new char[n4];
        for (int i = 0; i < n4; ++i) {
            cArray[i] = (char)JBButil.random(48, 57);
        }
        long l = JBButil.random(0, 100);
        if ((float)l < f) {
            int n5 = JBButil.random(0, cArray.length - 8);
            originalText.getChars(0, 8, cArray, n5);
        }
        return cArray;
    }

    public static char[] create_a_string_with_original(int n, int n2, float f, Integer n3, short s) {
        int n4 = JBButil.random(n, n2, s);
        char[] cArray = new char[n4];
        for (int i = 0; i < n4; ++i) {
            cArray[i] = (char)JBButil.random(48, 57, s);
        }
        long l = JBButil.random(0, 100, s);
        if ((float)l < f) {
            int n5 = JBButil.random(0, cArray.length - 8, s);
            originalText.getChars(0, 8, cArray, n5);
        }
        return cArray;
    }

    public static String choose_random_last_name(int n, short s) {
        short s2 = JBButil.create_random_customer_id(n, s);
        String string = JBButil.create_random_last_name(s2, s);
        return string;
    }

    public static short create_random_customer_id(int n, short s) {
        int n2 = 102 * n / 3000;
        int n3 = 34 * n / 3000;
        short s2 = (short)JBButil.NUrand_val(n2, 1, n, n3, s);
        return s2;
    }

    public static int create_random_item_id(int n, short s) {
        int n2 = 8191 * n / 100000;
        int n3 = 5456 * n / 100000;
        int n4 = JBBmain.uniformRandomItems ? JBButil.random(1, n, s) : JBButil.NUrand_val(n2, 1, n, n3, s);
        return n4;
    }

    public static String create_random_last_name(int n, short s) {
        int n2 = n == 0 || n > 1000 ? JBButil.NUrand_val(255, 0, 999, 173, warehouse_random_stream[s]) : n - 1;
        String string = last_name_parts[n2 / 100];
        string = string + last_name_parts[(n2 %= 100) / 10];
        string = string + last_name_parts[n2 %= 10];
        return string;
    }

    public static int NUrand_val(int n, int n2, int n3, int n4, Random random) {
        return ((JBButil.random(0, n, random) | JBButil.random(n2, n3, random)) + n4) % (n3 - n2 + 1) + n2;
    }

    public static int NUrand_val(int n, int n2, int n3, int n4, short s) {
        Random random = warehouse_random_stream[s];
        return ((JBButil.random(0, n, random) | JBButil.random(n2, n3, random)) + n4) % (n3 - n2 + 1) + n2;
    }

    public static void milliSecondsToSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            JBButil.getLog().log(Level.WARNING, "  --> Exception: SLEEP INTERRUPTED!", interruptedException);
        }
    }

    public static void SecondsToSleep(long l) {
        long l2 = l * 1000L;
        try {
            Thread.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            JBButil.getLog().log(Level.WARNING, "  --> Exception: SLEEP INTERRUPTED!", interruptedException);
        }
    }

    public static void SecondsToSleep(double d) {
        long l = (long)(d * 1000.0);
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            JBButil.getLog().log(Level.WARNING, "  --> Exception: SLEEP INTERRUPTED!", interruptedException);
        }
    }

    public static double negativeExpDistribution(double d, short s) {
        Random random = warehouse_random_stream[s];
        double d2 = random.nextFloat();
        double d3 = d * 10.0;
        double d4 = -Math.log(d2) * d;
        if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public static Logger getLog() {
        return appLog;
    }

    public static synchronized void setLog(Logger logger) {
        appLog = logger;
    }

    static {
        last_name_parts = new String[]{"BAR", "OUGHT", "ABLE", "PRI", "PRES", "ESE", "ANTI", "CALLY", "ATION", "EING"};
        alnum = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }
}

