---
layout: transform
title: ResolveFilter Transform
permalink: /docs/transforms/resolvefilter/index.html
---

The **resolvefilter** transform uses the filter mask generated by a [crossfilter](../crossfilter) transform to efficiently generate filtered data streams. A single crossfilter instance can be used to support cross-filtering over multiple charts; the filtered data streams for each individual chart are generated by using one resolvefilter transform per chart.

A `resolvefilter` transform should always be followed by a consuming transform, such as an [aggregate](../aggregate). To simply collect the filtered data objects, add a [collect](../collect) transform after `resolvefilter`.

## Transform Parameters

| Property            | Type                           | Description   |
| :------------------ | :----------------------------: | :------------ |
| filter              | {% include type t="Signal" %}  | {% include required %} A signal reference to a backing [crossfilter](../crossfilter) transform.|
| ignore              | {% include type t="Number" %}  | {% include required %} A bit mask indicating which fields in the crossfilter should be ignored. Each bit corresponds to a field and query in the crossfilter transform's _fields_ and _query_ arrays. If the corresponding bit is on, that field and query will be ignored when resolving the filter. All other queries must pass the filter for a tuple to be included down stream.|


## Usage

This example cross-filters the _delay_, _time_, and _distance_ fields in a data set of flights. The `crossfilter` transform sets up the filters, using range queries defined by signal values. The three derived data sets use `resolvefilter` transforms to filter the data, in each case ignoring one of the fields. For example, the `"filterTimeDistance"` data set filters the data by the _time_ and _distance_ queries, ignoring the _delay_ query.

{: .suppress-error}
```json
{
  "signals": [
    { "name": "delayRange", "value": [-60, 180] },
    { "name": "timeRange", "value": [0, 24] },
    { "name": "distanceRange", "value": [0, 2400] },
  ],
  "data": [
    {
      "name": "flights",
      "url": "data/flights-200k.json",
      "transform": [
        {
          "type": "crossfilter",
          "signal": "xfilter",
          "fields": ["delay", "time", "distance"],
          "query": [
            {"signal": "delayRange"},
            {"signal": "timeRange"},
            {"signal": "distanceRange"}
          ]
        }
      ]
    },
    {
      "name": "filterTimeDistance",
      "source": "flights",
      "transform": [
        {
          "type": "resolvefilter",
          "filter": {"signal": "xfilter"},
          "ignore": 1,

        },
        ...
      ]
    },
    {
      "name": "filterDelayDistance",
      "source": "flights",
      "transform": [
        {
          "type": "resolvefilter",
          "filter": {"signal": "xfilter"},
          "ignore": 2
        },
        ...
      ]
    },
    {
      "name": "filterDelayTime",
      "source": "flights",
      "transform": [
        {
          "type": "resolvefilter",
          "filter": {"signal": "xfilter"},
          "ignore": 4
        },
        ...
      ]
    }
  ]
}
```
