/*
 * ===========================
 * VDK Builder
 * Version 1.2
 * Revision 0.3
 * August 2000
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h> 
#include <sys/types.h> 
#include <sys/wait.h> 
#include <unistd.h>
#include <string.h>
#include <vdkb2/vdkb.h>

#define VERBOSE 0
#define EMACS_SERVER "emacsserver"
#define EMACS_CLIENT "emacsclient"
#define EMACS_GREP_SERVER "ps -e | grep emacsserver" 

static char buff[1024];
static int timerId = 0;
static int HandleTimer(gpointer gp);
static unsigned int timerTries = 0;
static const unsigned int TIMER_TRIES = 10;
bool EmacsServerStarted();
/*
emacs server pid
*/
int emacsPid = 0;
extern VDKBuilder* TheApp;
/*
 */
static 
void sigchld_handler(int num) 
{ 
  sigset_t set, oldset; 
  pid_t pid; 
  int status, exitstatus; 
  /* block other incoming SIGCHLD signals */ 
  sigemptyset(&set); 
  sigaddset(&set, SIGCHLD); 
  sigprocmask(SIG_BLOCK, &set, &oldset); 
  /* wait for child */ 
  while((pid = waitpid((pid_t)-1, &status, WNOHANG)) > 0) 
  { 
    if(WIFEXITED(status)) 
    { 
      exitstatus = WEXITSTATUS(status); 
#if VERBOSE
      printf("\nParent: child exited, pid = %d, exit status = %d\n", 
	     (int) pid, exitstatus); 
      fflush(stdout);
#endif
      // emacs server terminated
      if(pid == emacsPid)
	{
	  VDKBMainForm* mainform = NULL;
	  emacsPid = 0;
	  // wake up builder editor
	  mainform = dynamic_cast<VDKBMainForm*>(TheApp->MainForm);
	  if(mainform)
	    mainform->MakeEditor();
	}
    } 
    else if(WIFSIGNALED(status)) 
      { 
	exitstatus = WTERMSIG(status); 
#if VERBOSE
	printf( "\nParent: child terminated by signal %d, pid = %d\n", 
		exitstatus, (int)pid); 
	fflush(stdout);
#endif
      } 
    else if(WIFSTOPPED(status)) 
      { 
	exitstatus = WSTOPSIG(status); 
#if VERBOSE
	printf("\nParent: child stopped by signal %d, pid = %d\n", 
	       exitstatus, (int)pid); 
	fflush(stdout);
#endif
      } 
    else 
      { 
#if VERBOSE
	printf("\nParent: child exited magically, pid = %d\n", 
	       (int)pid); 
	fflush(stdout);
#endif
      } 
  } 
  /* re-install the signal handler (some systems need this) */ 
  signal(SIGCHLD, sigchld_handler); 
  /* and unblock it */ 
  sigemptyset(&set); 
  sigaddset(&set, SIGCHLD); 
  sigprocmask(SIG_UNBLOCK, &set, &oldset); 
}

int StartEmacs(char ** args)
{
    // install a child signal catcher
    signal(SIGCHLD, sigchld_handler); 
    pid_t pid; 
    pid = fork(); 
    if(pid == -1) 
        return pid;
    else if(pid == 0) 
      { 
        /* child */ 
        execvp(args[0],args); 
        /* if exec() returns, there is something wrong */ 
        return pid;
      } 
    else 
      { 
        /* parent */ 
#if VERBOSE
        printf("\nParent: forked a child with pid = %d\n", (int) pid);
        fflush(stdout);
#endif
        if(!strcmp(args[0],"emacs"))
	  {
	    // even if child was started well, unix socket isn't ready yet.
	    // add a timeout, when timer expires
	    // call HandleTimer that checks if emacs server
	    // is on place.
	    timerId = gtk_timeout_add(500,HandleTimer,NULL);
	    emacsPid = (int) pid;
	  }
      }
  return getpid();
}
/*
  checks if emacs server is on place and start all
  clients retrieving filenames from builder editor list
 */
int HandleTimer(gpointer gp)
{
  if(EmacsServerStarted())
    {
      VDKBMainForm* mainform = (VDKBMainForm*) TheApp->MainForm;
      VDKBEditor* editor =   mainform->MakeEditor();
      // start emacs clients
      TextListIterator li(editor->textlist);
      for(;li;li++)
	{
	  char* file = li.current()->Filename(); 
	  char* args[3];
	  args[0] = "emacsclient";
	  args[1] = file;
	  args[2] = NULL;
	  StartEmacs(args);
	}
      timerTries = 0;
      // return FALSE so timer will stop here
      return FALSE;
    }
  else
    {
      timerTries = (timerTries < TIMER_TRIES) ? timerTries+1 : 0;
      return (timerTries > 0);
    }
}
/*
 */

bool EmacsServerStarted()
{
  bool result = false;
  FILE* fp;
  fp = popen(EMACS_GREP_SERVER,"r");
  if( fp != NULL)
    { 
      memset(buff,'\0',sizeof(buff));
      fread(buff,sizeof(char),sizeof(buff),fp); 
      result = strstr(buff, EMACS_SERVER);
      pclose(fp);
    }
  return result;
}

/*
 */
int EmacsPid()
{
  return emacsPid;
}







