/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.5
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_fixed_h
#define _vdkb_fixed_h

#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdk/menu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBFixed: public VDKBEventContainer
{
  VDKMenuItem *delBox;
  VDKMenuItem *addwidget,*delwidget,*setsize;
  VDKBEventBox* innerbox;
  VDKCustomButton *setgrid;
  VDKCheckButton *gridcb;
  VDKSpinButton *vspace,*hspace;
  void Init();
 public:
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, char* buffer,
			   VDKBParser& parser);
  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKBFixed(char* name, VDKForm* owner);
  VDKBFixed(char* name, VDKBEventContainer* outer);
  virtual ~VDKBFixed() {}
  void Mark();
  void ClearMark();
  void AddBox();
  void PopMenu() { popmenu->Popup(); }

  bool OnButtonPressed(VDKObject*, GdkEvent*);

  bool OnButtonReleased(VDKObject*, GdkEvent*);

  bool OnExpose(VDKObject* sender, GdkEvent* ev);

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);

  bool AddNewWidget(VDKObject* sender);

  bool DelBox(VDKObject* sender);
  
  virtual int Type() { return vdkbfixed_class; }

  virtual int isA() { return vdkbfixed_class; }

  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  virtual char* VDKName() { return "VDKFixed"; }
  bool SetBoxSize(VDKObject* sender);

  // designer
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetGrid(VDKObject*);
  DECLARE_EVENT_LIST(VDKBFixed);
  DECLARE_SIGNAL_LIST(VDKBFixed);
};

#endif

