
[subsection {Main Directories}]

The main directories in the Tcllib toplevel directory and of interest
to a developer are:

[list_begin definitions]

[def [file modules]]

Each child directory represents one or more packages.

In the case of the latter the packages are usually related in some
way. Examples are [file base64], [file math], and [file struct], with
loose (base64) to strong (math) relations between the packages in the
directory.

[def [file apps]]

This directory contains all the installable applications, with their
documentation. Note that this directory is currently [emph not] split
into sub-directories.

[def [file examples]]

Each child directory [file foo] contains one or more example
application for the packages in [file modules/foo]. These examples are
generally not polished enough to be considered for installation.

[list_end]

[subsection {More Directories}]

[list_begin definitions]

[def [file config]]

This directory contains files supporting the Unix build system,
i.e. [file configure] and [file Makefile.in].

[def [file devdoc]]

This directories contains the doctools sources for the global
documentation, like this document and its sibling guides.

[def [file embedded]]

This directory contains the entire documentation formatted for
[term HTML] and styled to properly mix into the web site generated by
fossil for the repository.

[para] This is the documentation accessible from the Tcllib home
directory, represented in the repository as [file embedded/index.md].

[def [file idoc]]

This directory contains the entire documentation formatted for
[term nroff] and [term HTML], the latter without any styling.
This is the documentation which will be installed.

[def [file support]]

This directory contains the sources of internal packages and utilities
used in the implementation of the [file installer.tcl] and
[file sak.tcl] scripts/tools.

[list_end]

[subsection {Top Files}]

[list_begin definitions]
[def [file aclocal.m4]]
[def [file configure]]
[def [file configure.in]]
[def [file Makefile.in]]

These four files comprise the Unix build system layered on top of the
[file installer.tcl] script.

[def [file installer.tcl]]

The Tcl-based installation script/tool.

[def [file project.shed]]

Configuration file for [term {Sean Wood}]'s [syscmd PracTcl]
buildsystem.

[def [file sak.tcl]]
This is the main tool for developers and release managers, the
[term {Swiss Army Knife}] of management operations on the collection.

[def [file ChangeLog]]

The log of changes to the global support, when the sources were held
in [term CVS]. Not relevant any longer with the switch to the
[term fossil] SCM.

[def [file license.terms]]

The license in plain ASCII. See also [term {Tcllib - License}] for the
nicely formatted form. The text is identical.

[def [file README.md]]
[def [file .github/CONTRIBUTING.md]]
[def [file .github/ISSUE_TEMPLATE.md]]
[def [file .github/PULL_REQUEST_TEMPLATE.md]]

These markdown-formatted documents are used and shown by the github
mirror of these sources, pointing people back to the official location
and issue trackers.

[def [file DESCRIPTION.txt]]
[def [file STATUS]]
[def [file tcllib.spec]]
[def [file tcllib.tap]]
[def [file tcllib.yml]]

????

[list_end]

[subsection {File Types}]

The most common file types, by file extension, are:

[list_begin definitions]

[def [file .tcl]]
Tcl code for a package, application, or example.

[def [file .man]]
Doctools-formatted documentation, usually for a package.

[def [file .test]]
Test suite for a package, or part of.
Based on [package tcltest].

[def [file .bench]]
Performance benchmarks for a package, or part of.
Based on [file modules/bench].

[def [file .pcx]]
Syntax rules for [term TclDevKit]'s [syscmd tclchecker]. Using these
rules allows the checker to validate the use of commands of a Tcllib
package [package foo] without having to scan the [file .tcl] files
implementing it.

[list_end]
