[comment {-*- tcl -*- doctools manpage}]
[vset PACKAGE_VERSION 1.0.3]
[manpage_begin json::write n [vset PACKAGE_VERSION]]
[keywords {data exchange}]
[keywords {exchange format}]
[keywords javascript]
[keywords json]
[copyright {2009-2013 Andreas Kupries <andreas_kupries@sourceforge.net>}]
[moddesc   {JSON}]
[titledesc {JSON generation}]
[category  {CGI programming}]
[require Tcl 8.5]
[require json::write [opt [vset PACKAGE_VERSION]]]
[description]
[para]

The [package json::write] package provides a simple Tcl-only library
for generation of text in the JSON [uri http://www.json.org/] data
exchange format as specified in
RFC 4627 [uri http://www.ietf.org/rfc/rfc4627.txt].

[section COMMANDS]

[list_begin definitions]

[call [cmd ::json::write] [method indented]]

This method returns the current state of the indentation setting.

[call [cmd ::json::write] [method indented] [arg flag]]

This and the method [method aligned] configure the layout of the JSON
generated by the package.

[para]

If this [arg flag] is set (default) the package will break the
generated JSON code across lines and indent it according to its inner
structure, with each key of an object on a separate line.

[para]

If this flag is not set, the whole JSON object will be written on a
single line, with minimum spacing between all elements.

[call [cmd ::json::write] [method aligned]]

This method returns the current state of the alignment setting.

[call [cmd ::json::write] [method aligned] [arg flag]]

This and the method [method indented] configure the layout of the JSON
generated by the package.

[para]

If this [arg flag] is set (default) the package ensures that the
values for the keys in an object are vertically aligned with each
other, for a nice table effect. To make this work this also implies
that [var indented] is set as well.

[para]

If this flag is not set, the output is formatted as per the value of
[var indented], without trying to align the values for object keys.

[call [cmd ::json::write] [method string] [arg s]]

This method takes the string [arg s] and returns it properly quoted
for JSON as its result.

[call [cmd ::json::write] [method array] [arg arg]...]

This method takes a series of JSON formatted arguments and returns
them as a properly formatted JSON array as its result.

[call [cmd ::json::write] [method object] [arg key] [arg value]...]

This method takes a series of key/value arguments, the values already
formatted for JSON, and returns them as a properly formatted JSON
object as its result, with the keys formatted as JSON strings.

[list_end]
[para]

[vset CATEGORY json]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
