#!/usr/bin/env tarantool
test = require("sqltester")
test:plan(2600)

--!./tcltestrunner.lua
-- 2008 December 16
--
-- The author disclaims copyright to this source code.  In place of
-- a legal notice, here is a blessing:
--
--    May you do good and not evil.
--    May you find forgiveness for yourself and forgive others.
--    May you share freely, never taking more than you give.
--
-------------------------------------------------------------------------
-- This file implements regression tests for sql library.
--
-- This file tests randomly generated SQL expressions.  The expressions
-- are generated by a TCL script.  The same TCL script also computes the
-- correct value of the expression.  So, from one point of view, this
-- file verifies the expression evaluation logic of sql against the
-- expression evaluation logic of TCL.
--
-- An early version of this script is how bug #3541 was detected.
--
-- $Id: randexpr1.test,v 1.1 2008/12/15 16:33:30 drh Exp $
-- ["set","testdir",[["file","dirname",["argv0"]]]]
-- ["source",[["testdir"],"\/tester.tcl"]]


-- Create test data
--
test:do_test(
    "randexpr1-1.1",
    function()
        return test:execsql [[
            CREATE TABLE t1(a  INT PRIMARY KEY,b INT ,c INT ,d INT ,e INT ,f INT );
            INSERT INTO t1 VALUES(100,200,300,400,500,600);
            SELECT * FROM t1
        ]]
    end, {
        -- <randexpr1-1.1>
        100, 200, 300, 400, 500, 600
        -- </randexpr1-1.1>
    })

test:do_test(
    "randexpr-2.1",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where 19 in (t1.b,+11,coalesce((select max((abs(17)/abs(t1.f))) from t1 where ((abs(t1.f)/abs(t1.b)) in (select case (min(t1.a | d*d)+(abs(count(*)-count(*)+ -count(*)*max( -t1.c))-max(f))) when  -count(distinct 19) then ((count(*))) else max(13) end from t1 union select count(distinct b) from t1)) or 19 in (t1.a,t1.c,17)),17) | 17)),13) FROM t1 WHERE not not c=a-+(select case ~case  -~+count(distinct (select count(distinct t1.a)*max(13) from t1))+max( -19*f)*max(f)*max(f)* -count(distinct d)-(count(distinct 11)) | max(t1.f)*count(*) when count(distinct b) then count(distinct t1.b) else  -min(t1.f) end*cast(avg(11) AS integer) when max(t1.f) then max(c) else count(*) end from t1)+d"
    end, {
        -- <randexpr-2.1>
        
        -- </randexpr-2.1>
    })

test:do_test(
    "randexpr-2.2",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where 19 in (t1.b,+11,coalesce((select max((abs(17)/abs(t1.f))) from t1 where ((abs(t1.f)/abs(t1.b)) in (select case (min(t1.a | d*d)+(abs(count(*)-count(*)+ -count(*)*max( -t1.c))-max(f))) when  -count(distinct 19) then ((count(*))) else max(13) end from t1 union select count(distinct b) from t1)) or 19 in (t1.a,t1.c,17)),17) | 17)),13) FROM t1 WHERE NOT (not not c=a-+(select case ~case  -~+count(distinct (select count(distinct t1.a)*max(13) from t1))+max( -19*f)*max(f)*max(f)* -count(distinct d)-(count(distinct 11)) | max(t1.f)*count(*) when count(distinct b) then count(distinct t1.b) else  -min(t1.f) end*cast(avg(11) AS integer) when max(t1.f) then max(c) else count(*) end from t1)+d)"
    end, {
        -- <randexpr-2.2>
        13
        -- </randexpr-2.2>
    })

test:do_test(
    "randexpr-2.3",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where 19 in (t1.b,+11,coalesce((select max((abs(17)/abs(t1.f))) from t1 where ((abs(t1.f)/abs(t1.b)) in (select case (min(t1.a & d*d)+(abs(count(*)-count(*)+ -count(*)*max( -t1.c))-max(f))) when  -count(distinct 19) then ((count(*))) else max(13) end from t1 union select count(distinct b) from t1)) or 19 in (t1.a,t1.c,17)),17) & 17)),13) FROM t1 WHERE NOT (not not c=a-+(select case ~case  -~+count(distinct (select count(distinct t1.a)*max(13) from t1))+max( -19*f)*max(f)*max(f)* -count(distinct d)-(count(distinct 11)) | max(t1.f)*count(*) when count(distinct b) then count(distinct t1.b) else  -min(t1.f) end*cast(avg(11) AS integer) when max(t1.f) then max(c) else count(*) end from t1)+d)"
    end, {
        -- <randexpr-2.3>
        13
        -- </randexpr-2.3>
    })

test:do_test(
    "randexpr-2.4",
    function()
        return test:execsql "SELECT t1.c*19-t1.f*19+coalesce((select 17 from t1 where e in (f,case (select cast(avg(t1.a) AS integer) from t1)-t1.d when coalesce((select +case when not exists(select 1 from t1 where 17<>t1.f and ((a))<t1.b) then t1.c when c not between b and 11 then case when t1.c<f then t1.b when e in (t1.d,t1.d, -e) then d else t1.b end else f end+11 from t1 where exists(select 1 from t1 where t1.f in (select (count(distinct f)) from t1 union select max(11) from t1))),e) then 11 else t1.a end,t1.d)),13)*b+b FROM t1 WHERE ~t1.b<case when t1.b+t1.c in (select  -count(distinct 17+coalesce((select max( -f+t1.c-d) from t1 where (19>=a) and t1.b between f and 13),t1.a))+case abs(+(max(19))) | count(distinct t1.e) | count(distinct 19) when count(*) then (max(a)) else count(distinct d) end from t1 union select (count(*)) from t1) and t1.b>=19 then d when t1.b in (select d from t1 union select c from t1) then t1.e else a end"
    end, {
        -- <randexpr-2.4>
        -2900
        -- </randexpr-2.4>
    })

test:do_test(
    "randexpr-2.5",
    function()
        return test:execsql "SELECT t1.c*19-t1.f*19+coalesce((select 17 from t1 where e in (f,case (select cast(avg(t1.a) AS integer) from t1)-t1.d when coalesce((select +case when not exists(select 1 from t1 where 17<>t1.f and ((a))<t1.b) then t1.c when c not between b and 11 then case when t1.c<f then t1.b when e in (t1.d,t1.d, -e) then d else t1.b end else f end+11 from t1 where exists(select 1 from t1 where t1.f in (select (count(distinct f)) from t1 union select max(11) from t1))),e) then 11 else t1.a end,t1.d)),13)*b+b FROM t1 WHERE NOT (~t1.b<case when t1.b+t1.c in (select  -count(distinct 17+coalesce((select max( -f+t1.c-d) from t1 where (19>=a) and t1.b between f and 13),t1.a))+case abs(+(max(19))) | count(distinct t1.e) | count(distinct 19) when count(*) then (max(a)) else count(distinct d) end from t1 union select (count(*)) from t1) and t1.b>=19 then d when t1.b in (select d from t1 union select c from t1) then t1.e else a end)"
    end, {
        -- <randexpr-2.5>
        
        -- </randexpr-2.5>
    })

test:do_test(
    "randexpr-2.6",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where e not in (~t1.d,+case when t1.c<b then t1.e else t1.a end-11 | t1.f,c) or b in (select cast(avg(b) AS integer)*(~abs((count(*))))* -( -cast(avg(e) AS integer)) from t1 union select min(t1.c) from t1)) then t1.f when not exists(select 1 from t1 where not c<>d) then 17 else t1.e end in (a,t1.e,17) or (not exists(select 1 from t1 where a in (f,t1.c,t1.a))) then 11 else 13 end FROM t1 WHERE t1.b<case when exists(select 1 from t1 where not  -(select min(t1.b*b*t1.a+t1.d)+abs(case count(*) | (cast(avg(c) AS integer)) when max(17) then min(c) else (min(13)) end)+min(e) from t1) not in (t1.c,f-d,11) and c not between (19) and e) then ~13*t1.a when 13 not in (t1.e,c,11) then b else t1.c end*c-t1.d"
    end, {
        -- <randexpr-2.6>
        11
        -- </randexpr-2.6>
    })

test:do_test(
    "randexpr-2.7",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where e not in (~t1.d,+case when t1.c<b then t1.e else t1.a end-11 | t1.f,c) or b in (select cast(avg(b) AS integer)*(~abs((count(*))))* -( -cast(avg(e) AS integer)) from t1 union select min(t1.c) from t1)) then t1.f when not exists(select 1 from t1 where not c<>d) then 17 else t1.e end in (a,t1.e,17) or (not exists(select 1 from t1 where a in (f,t1.c,t1.a))) then 11 else 13 end FROM t1 WHERE NOT (t1.b<case when exists(select 1 from t1 where not  -(select min(t1.b*b*t1.a+t1.d)+abs(case count(*) | (cast(avg(c) AS integer)) when max(17) then min(c) else (min(13)) end)+min(e) from t1) not in (t1.c,f-d,11) and c not between (19) and e) then ~13*t1.a when 13 not in (t1.e,c,11) then b else t1.c end*c-t1.d)"
    end, {
        -- <randexpr-2.7>
        
        -- </randexpr-2.7>
    })

test:do_test(
    "randexpr-2.8",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where e not in (~t1.d,+case when t1.c<b then t1.e else t1.a end-11 & t1.f,c) or b in (select cast(avg(b) AS integer)*(~abs((count(*))))* -( -cast(avg(e) AS integer)) from t1 union select min(t1.c) from t1)) then t1.f when not exists(select 1 from t1 where not c<>d) then 17 else t1.e end in (a,t1.e,17) or (not exists(select 1 from t1 where a in (f,t1.c,t1.a))) then 11 else 13 end FROM t1 WHERE t1.b<case when exists(select 1 from t1 where not  -(select min(t1.b*b*t1.a+t1.d)+abs(case count(*) | (cast(avg(c) AS integer)) when max(17) then min(c) else (min(13)) end)+min(e) from t1) not in (t1.c,f-d,11) and c not between (19) and e) then ~13*t1.a when 13 not in (t1.e,c,11) then b else t1.c end*c-t1.d"
    end, {
        -- <randexpr-2.8>
        11
        -- </randexpr-2.8>
    })

test:do_test(
    "randexpr-2.9",
    function()
        return test:execsql "SELECT coalesce((select max(11- -19-f-t1.b+a) from t1 where exists(select 1 from t1 where 11-~(d)-c*a*~t1.a-t1.e-t1.e+coalesce((select coalesce((select t1.c from t1 where case (c) when d then e else 11 end=t1.f),t1.d) from t1 where (t1.d)>b), -11) | f+t1.f not in (((c)),b,13))),f) FROM t1 WHERE case when 19+c>=t1.a then t1.c when not case when not exists(select 1 from t1 where +f | b*b*19+19*13-a | case when t1.e not in (t1.f,t1.c,b) then 11 when 17>t1.c then a else e end<>e) then b when 17=t1.e then b else e end<>t1.b then a else d end-t1.b=(13)"
    end, {
        -- <randexpr-2.9>
        
        -- </randexpr-2.9>
    })

test:do_test(
    "randexpr-2.10",
    function()
        return test:execsql "SELECT coalesce((select max(11- -19-f-t1.b+a) from t1 where exists(select 1 from t1 where 11-~(d)-c*a*~t1.a-t1.e-t1.e+coalesce((select coalesce((select t1.c from t1 where case (c) when d then e else 11 end=t1.f),t1.d) from t1 where (t1.d)>b), -11) | f+t1.f not in (((c)),b,13))),f) FROM t1 WHERE NOT (case when 19+c>=t1.a then t1.c when not case when not exists(select 1 from t1 where +f | b*b*19+19*13-a | case when t1.e not in (t1.f,t1.c,b) then 11 when 17>t1.c then a else e end<>e) then b when 17=t1.e then b else e end<>t1.b then a else d end-t1.b=(13))"
    end, {
        -- <randexpr-2.10>
        -670
        -- </randexpr-2.10>
    })

test:do_test(
    "randexpr-2.11",
    function()
        return test:execsql "SELECT coalesce((select max(11- -19-f-t1.b+a) from t1 where exists(select 1 from t1 where 11-~(d)-c*a*~t1.a-t1.e-t1.e+coalesce((select coalesce((select t1.c from t1 where case (c) when d then e else 11 end=t1.f),t1.d) from t1 where (t1.d)>b), -11) & f+t1.f not in (((c)),b,13))),f) FROM t1 WHERE NOT (case when 19+c>=t1.a then t1.c when not case when not exists(select 1 from t1 where +f | b*b*19+19*13-a | case when t1.e not in (t1.f,t1.c,b) then 11 when 17>t1.c then a else e end<>e) then b when 17=t1.e then b else e end<>t1.b then a else d end-t1.b=(13))"
    end, {
        -- <randexpr-2.11>
        -670
        -- </randexpr-2.11>
    })

test:do_test(
    "randexpr-2.12",
    function()
        return test:execsql "SELECT (abs(17)/abs(~case when (abs(t1.c* -(abs(case b | coalesce((select max(17*e*case when 11 in (select t1.b from t1 union select t1.c from t1) then 19 when d between f and t1.e then t1.e else t1.e end | b) from t1 where (13 not in (11,t1.d,e))),e)*a*d when 11 then e else d end*17)/abs(19)))/abs(t1.e))<>e then t1.b else t1.d end*(19))) FROM t1 WHERE exists(select 1 from t1 where t1.d+11 in (case t1.b++c when +a*(+case (select count(*) from t1) when 19 then t1.c else a end) then t1.a else case when (t1.b> -d) and not exists(select 1 from t1 where not exists(select 1 from t1 where (abs(f)/abs( -f*a+c*11))<>a)) then 13 else 19 end end,17,a)) or c=t1.d"
    end, {
        -- <randexpr-2.12>
        
        -- </randexpr-2.12>
    })

test:do_test(
    "randexpr-2.13",
    function()
        return test:execsql "SELECT (abs(17)/abs(~case when (abs(t1.c* -(abs(case b | coalesce((select max(17*e*case when 11 in (select t1.b from t1 union select t1.c from t1) then 19 when d between f and t1.e then t1.e else t1.e end | b) from t1 where (13 not in (11,t1.d,e))),e)*a*d when 11 then e else d end*17)/abs(19)))/abs(t1.e))<>e then t1.b else t1.d end*(19))) FROM t1 WHERE NOT (exists(select 1 from t1 where t1.d+11 in (case t1.b++c when +a*(+case (select count(*) from t1) when 19 then t1.c else a end) then t1.a else case when (t1.b> -d) and not exists(select 1 from t1 where not exists(select 1 from t1 where (abs(f)/abs( -f*a+c*11))<>a)) then 13 else 19 end end,17,a)) or c=t1.d)"
    end, {
        -- <randexpr-2.13>
        0
        -- </randexpr-2.13>
    })

test:do_test(
    "randexpr-2.14",
    function()
        return test:execsql "SELECT (abs(17)/abs(~case when (abs(t1.c* -(abs(case b & coalesce((select max(17*e*case when 11 in (select t1.b from t1 union select t1.c from t1) then 19 when d between f and t1.e then t1.e else t1.e end & b) from t1 where (13 not in (11,t1.d,e))),e)*a*d when 11 then e else d end*17)/abs(19)))/abs(t1.e))<>e then t1.b else t1.d end*(19))) FROM t1 WHERE NOT (exists(select 1 from t1 where t1.d+11 in (case t1.b++c when +a*(+case (select count(*) from t1) when 19 then t1.c else a end) then t1.a else case when (t1.b> -d) and not exists(select 1 from t1 where not exists(select 1 from t1 where (abs(f)/abs( -f*a+c*11))<>a)) then 13 else 19 end end,17,a)) or c=t1.d)"
    end, {
        -- <randexpr-2.14>
        0
        -- </randexpr-2.14>
    })

test:do_test(
    "randexpr-2.15",
    function()
        return test:execsql "SELECT coalesce((select t1.c from t1 where e not between 19 and b*d or not exists(select 1 from t1 where t1.a not in (case when d not between b+~(t1.d)-case when ((t1.f<=t1.e) and  -11<f) then e*(abs(t1.a)/abs((t1.c))) else c end+b and t1.e then e when not exists(select 1 from t1 where 11<17) then a else t1.f end,(c),c))),t1.d) FROM t1 WHERE t1.c*((select  -count(distinct t1.a) | + -count(distinct t1.b)*cast(avg(a) AS integer)-cast(avg(13) AS integer) | ~abs(min(17)) |  -min(c)*(count(distinct t1.e)) from t1)- -(abs(+t1.b-13)/abs(11)))+t1.f-coalesce((select max(f) from t1 where t1.d between c and t1.a),17)*a in (select 17 from t1 union select  -17 from t1)"
    end, {
        -- <randexpr-2.15>
        
        -- </randexpr-2.15>
    })

test:do_test(
    "randexpr-2.16",
    function()
        return test:execsql "SELECT coalesce((select t1.c from t1 where e not between 19 and b*d or not exists(select 1 from t1 where t1.a not in (case when d not between b+~(t1.d)-case when ((t1.f<=t1.e) and  -11<f) then e*(abs(t1.a)/abs((t1.c))) else c end+b and t1.e then e when not exists(select 1 from t1 where 11<17) then a else t1.f end,(c),c))),t1.d) FROM t1 WHERE NOT (t1.c*((select  -count(distinct t1.a) | + -count(distinct t1.b)*cast(avg(a) AS integer)-cast(avg(13) AS integer) | ~abs(min(17)) |  -min(c)*(count(distinct t1.e)) from t1)- -(abs(+t1.b-13)/abs(11)))+t1.f-coalesce((select max(f) from t1 where t1.d between c and t1.a),17)*a in (select 17 from t1 union select  -17 from t1))"
    end, {
        -- <randexpr-2.16>
        400
        -- </randexpr-2.16>
    })

test:do_test(
    "randexpr-2.17",
    function()
        return test:execsql "SELECT +t1.f*~t1.c-coalesce((select max(~b) from t1 where t1.e+11-(abs(e+case d when b then case when f=(13) then (abs(13+b*t1.f)/abs(t1.c)) when d<=t1.e then 13 else a end else 19 end*13+f)/abs((a)))*17<=c),b)-13*c FROM t1 WHERE not exists(select 1 from t1 where coalesce((select max(case when case when exists(select 1 from t1 where ~t1.d+d in (select ~count(distinct 13) from t1 union select count(*)+~abs(+(~min(t1.a))) from t1)) then t1.e+t1.c else  -(abs(t1.d)/abs(coalesce((select max(t1.d) from t1 where d not in (17,f,f)),11)*t1.c)) end<=(11) then 19 else (t1.e) end) from t1 where (13=11)),c) not between 13 and 19)"
    end, {
        -- <randexpr-2.17>
        
        -- </randexpr-2.17>
    })

test:do_test(
    "randexpr-2.18",
    function()
        return test:execsql "SELECT +t1.f*~t1.c-coalesce((select max(~b) from t1 where t1.e+11-(abs(e+case d when b then case when f=(13) then (abs(13+b*t1.f)/abs(t1.c)) when d<=t1.e then 13 else a end else 19 end*13+f)/abs((a)))*17<=c),b)-13*c FROM t1 WHERE NOT (not exists(select 1 from t1 where coalesce((select max(case when case when exists(select 1 from t1 where ~t1.d+d in (select ~count(distinct 13) from t1 union select count(*)+~abs(+(~min(t1.a))) from t1)) then t1.e+t1.c else  -(abs(t1.d)/abs(coalesce((select max(t1.d) from t1 where d not in (17,f,f)),11)*t1.c)) end<=(11) then 19 else (t1.e) end) from t1 where (13=11)),c) not between 13 and 19))"
    end, {
        -- <randexpr-2.18>
        -184299
        -- </randexpr-2.18>
    })

test:do_test(
    "randexpr-2.19",
    function()
        return test:execsql "SELECT case when (a not in (t1.e,(+case when t1.b<=(abs(coalesce((select max(a+(select count(distinct (select max(((abs( -t1.d)/abs(a))) | t1.c)*min(t1.e) from t1)) from t1)) from t1 where +t1.f>e),17))/abs( - -17)) then 17 else t1.d end-t1.b-d) |  -f,c)) then 11-t1.f when ( -13<e) then t1.d else a end FROM t1 WHERE t1.c not between ~case when case when (select  - -abs( -case  -count(distinct c) when count(*) then max(c) else count(distinct 13) end) | min(c) from t1) in (t1.f,b+11,19*t1.d) then 19 else a end*t1.b>13 or t1.e in (select (count(*)) from t1 union select cast(avg(t1.e) AS integer) from t1) or 19>17 and 13 not between 19 and 17 then (t1.f) when not t1.b<>t1.f or d<>b then t1.e else a end and c"
    end, {
        -- <randexpr-2.19>
        
        -- </randexpr-2.19>
    })

test:do_test(
    "randexpr-2.20",
    function()
        return test:execsql "SELECT case when (a not in (t1.e,(+case when t1.b<=(abs(coalesce((select max(a+(select count(distinct (select max(((abs( -t1.d)/abs(a))) | t1.c)*min(t1.e) from t1)) from t1)) from t1 where +t1.f>e),17))/abs( - -17)) then 17 else t1.d end-t1.b-d) |  -f,c)) then 11-t1.f when ( -13<e) then t1.d else a end FROM t1 WHERE NOT (t1.c not between ~case when case when (select  - -abs( -case  -count(distinct c) when count(*) then max(c) else count(distinct 13) end) | min(c) from t1) in (t1.f,b+11,19*t1.d) then 19 else a end*t1.b>13 or t1.e in (select (count(*)) from t1 union select cast(avg(t1.e) AS integer) from t1) or 19>17 and 13 not between 19 and 17 then (t1.f) when not t1.b<>t1.f or d<>b then t1.e else a end and c)"
    end, {
        -- <randexpr-2.20>
        -589
        -- </randexpr-2.20>
    })

test:do_test(
    "randexpr-2.21",
    function()
        return test:execsql "SELECT case when (a not in (t1.e,(+case when t1.b<=(abs(coalesce((select max(a+(select count(distinct (select max(((abs( -t1.d)/abs(a))) & t1.c)*min(t1.e) from t1)) from t1)) from t1 where +t1.f>e),17))/abs( - -17)) then 17 else t1.d end-t1.b-d) &  -f,c)) then 11-t1.f when ( -13<e) then t1.d else a end FROM t1 WHERE NOT (t1.c not between ~case when case when (select  - -abs( -case  -count(distinct c) when count(*) then max(c) else count(distinct 13) end) | min(c) from t1) in (t1.f,b+11,19*t1.d) then 19 else a end*t1.b>13 or t1.e in (select (count(*)) from t1 union select cast(avg(t1.e) AS integer) from t1) or 19>17 and 13 not between 19 and 17 then (t1.f) when not t1.b<>t1.f or d<>b then t1.e else a end and c)"
    end, {
        -- <randexpr-2.21>
        -589
        -- </randexpr-2.21>
    })

test:do_test(
    "randexpr-2.22",
    function()
        return test:execsql "SELECT t1.a | case when e in (select (13) from t1 union select d from t1) then (17) when c*~case (17) when coalesce((select max(case when case when 19 in (13,t1.f,11) then t1.b else t1.b end | 11>t1.a then 11 else t1.b end-b) from t1 where (13 not in (a,19,b)) and t1.a not between  -11 and t1.f),f) then e else t1.c end | a in (select 11 from t1 union select t1.d from t1) then 17 else t1.a end | f FROM t1 WHERE coalesce((select t1.a*t1.a from t1 where ~ -(abs((select abs(count(*))-count(distinct t1.d*11) from t1)*+b)/abs(~t1.c))+c not in (coalesce((select ~13*t1.a from t1 where f+(abs(d* -t1.f)/abs(t1.c))<=t1.b or not t1.a<=t1.c),t1.c),e,(t1.e))),(a))+11<>11"
    end, {
        -- <randexpr-2.22>
        636
        -- </randexpr-2.22>
    })

test:do_test(
    "randexpr-2.23",
    function()
        return test:execsql "SELECT t1.a | case when e in (select (13) from t1 union select d from t1) then (17) when c*~case (17) when coalesce((select max(case when case when 19 in (13,t1.f,11) then t1.b else t1.b end | 11>t1.a then 11 else t1.b end-b) from t1 where (13 not in (a,19,b)) and t1.a not between  -11 and t1.f),f) then e else t1.c end | a in (select 11 from t1 union select t1.d from t1) then 17 else t1.a end | f FROM t1 WHERE NOT (coalesce((select t1.a*t1.a from t1 where ~ -(abs((select abs(count(*))-count(distinct t1.d*11) from t1)*+b)/abs(~t1.c))+c not in (coalesce((select ~13*t1.a from t1 where f+(abs(d* -t1.f)/abs(t1.c))<=t1.b or not t1.a<=t1.c),t1.c),e,(t1.e))),(a))+11<>11)"
    end, {
        -- <randexpr-2.23>
        
        -- </randexpr-2.23>
    })

test:do_test(
    "randexpr-2.24",
    function()
        return test:execsql "SELECT t1.a & case when e in (select (13) from t1 union select d from t1) then (17) when c*~case (17) when coalesce((select max(case when case when 19 in (13,t1.f,11) then t1.b else t1.b end & 11>t1.a then 11 else t1.b end-b) from t1 where (13 not in (a,19,b)) and t1.a not between  -11 and t1.f),f) then e else t1.c end & a in (select 11 from t1 union select t1.d from t1) then 17 else t1.a end & f FROM t1 WHERE coalesce((select t1.a*t1.a from t1 where ~ -(abs((select abs(count(*))-count(distinct t1.d*11) from t1)*+b)/abs(~t1.c))+c not in (coalesce((select ~13*t1.a from t1 where f+(abs(d* -t1.f)/abs(t1.c))<=t1.b or not t1.a<=t1.c),t1.c),e,(t1.e))),(a))+11<>11"
    end, {
        -- <randexpr-2.24>
        64
        -- </randexpr-2.24>
    })

test:do_test(
    "randexpr-2.25",
    function()
        return test:execsql "SELECT c*coalesce((select ~19-e from t1 where not exists(select 1 from t1 where case when t1.b<>(d) then case when exists(select 1 from t1 where not exists(select 1 from t1 where case t1.e when e*(11) then 13 else 11 end in (select t1.a from t1 union select 13 from t1))) then coalesce((select case when f in (select t1.c from t1 union select (t1.b) from t1) then f else a end from t1 where t1.f not between 17 and f), -f) else 11 end else (a) end*d not in (e,t1.c,t1.e))),t1.e)-a FROM t1 WHERE 19+(select cast(avg((abs(t1.d)/abs(coalesce((select max(+b-(t1.e+b+ -c)*19) from t1 where 11 not between t1.b and f), -17)))*(11)) AS integer) from t1)*f in (select count(*) from t1 union select case max(t1.d)-( -min(t1.d)*(+max(e))) when max(t1.a) then cast(avg(t1.d) AS integer)-(count(distinct t1.f))-( -cast(avg(f) AS integer)) else max(t1.e) end from t1)"
    end, {
        -- <randexpr-2.25>
        
        -- </randexpr-2.25>
    })

test:do_test(
    "randexpr-2.26",
    function()
        return test:execsql "SELECT c*coalesce((select ~19-e from t1 where not exists(select 1 from t1 where case when t1.b<>(d) then case when exists(select 1 from t1 where not exists(select 1 from t1 where case t1.e when e*(11) then 13 else 11 end in (select t1.a from t1 union select 13 from t1))) then coalesce((select case when f in (select t1.c from t1 union select (t1.b) from t1) then f else a end from t1 where t1.f not between 17 and f), -f) else 11 end else (a) end*d not in (e,t1.c,t1.e))),t1.e)-a FROM t1 WHERE NOT (19+(select cast(avg((abs(t1.d)/abs(coalesce((select max(+b-(t1.e+b+ -c)*19) from t1 where 11 not between t1.b and f), -17)))*(11)) AS integer) from t1)*f in (select count(*) from t1 union select case max(t1.d)-( -min(t1.d)*(+max(e))) when max(t1.a) then cast(avg(t1.d) AS integer)-(count(distinct t1.f))-( -cast(avg(f) AS integer)) else max(t1.e) end from t1))"
    end, {
        -- <randexpr-2.26>
        149900
        -- </randexpr-2.26>
    })

test:do_test(
    "randexpr-2.27",
    function()
        return test:execsql "SELECT (abs((select (case abs(min(t1.f)) | count(distinct e) when (~+count(*)+max(e)++abs(cast(avg(~19) AS integer))) then +cast(avg(c) AS integer) else ~ -max(+t1.b)+~max(19)*count(distinct a)*min(17) | max(t1.d) end) from t1))/abs(~c+(select  -(count(distinct t1.e)) from t1)-11+t1.e)) FROM t1 WHERE 11>=t1.f"
    end, {
        -- <randexpr-2.27>
        
        -- </randexpr-2.27>
    })

test:do_test(
    "randexpr-2.28",
    function()
        return test:execsql "SELECT (abs((select (case abs(min(t1.f)) | count(distinct e) when (~+count(*)+max(e)++abs(cast(avg(~19) AS integer))) then +cast(avg(c) AS integer) else ~ -max(+t1.b)+~max(19)*count(distinct a)*min(17) | max(t1.d) end) from t1))/abs(~c+(select  -(count(distinct t1.e)) from t1)-11+t1.e)) FROM t1 WHERE NOT (11>=t1.f)"
    end, {
        -- <randexpr-2.28>
        0
        -- </randexpr-2.28>
    })

test:do_test(
    "randexpr-2.29",
    function()
        return test:execsql "SELECT (abs((select (case abs(min(t1.f)) & count(distinct e) when (~+count(*)+max(e)++abs(cast(avg(~19) AS integer))) then +cast(avg(c) AS integer) else ~ -max(+t1.b)+~max(19)*count(distinct a)*min(17) & max(t1.d) end) from t1))/abs(~c+(select  -(count(distinct t1.e)) from t1)-11+t1.e)) FROM t1 WHERE NOT (11>=t1.f)"
    end, {
        -- <randexpr-2.29>
        1
        -- </randexpr-2.29>
    })

test:do_test(
    "randexpr-2.30",
    function()
        return test:execsql "SELECT (select +count(distinct case when 11=a or e<+t1.f+t1.c and not exists(select 1 from t1 where not t1.a-t1.b=~a and f<=coalesce((select max((e)) from t1 where +t1.f>=b),t1.d)*13) and t1.c>t1.e and t1.a<17 then f when a<c then t1.d else c end) from t1) FROM t1 WHERE t1.b=case t1.e | f+t1.d when case when t1.f | t1.e in (select  -+min(case when t1.c in (select t1.b from t1 union select b-19*(abs(b)/abs(t1.b*case when not exists(select 1 from t1 where t1.a in (select ~cast(avg(d) AS integer) from t1 union select max(t1.f) from t1)) then ~(13) when  -c=t1.b then t1.c else f end)) from t1) then e else 17 end) from t1 union select max((a)) from t1) then  -b else t1.d end+13 then a else 13 end"
    end, {
        -- <randexpr-2.30>
        
        -- </randexpr-2.30>
    })

test:do_test(
    "randexpr-2.31",
    function()
        return test:execsql "SELECT (select +count(distinct case when 11=a or e<+t1.f+t1.c and not exists(select 1 from t1 where not t1.a-t1.b=~a and f<=coalesce((select max((e)) from t1 where +t1.f>=b),t1.d)*13) and t1.c>t1.e and t1.a<17 then f when a<c then t1.d else c end) from t1) FROM t1 WHERE NOT (t1.b=case t1.e | f+t1.d when case when t1.f | t1.e in (select  -+min(case when t1.c in (select t1.b from t1 union select b-19*(abs(b)/abs(t1.b*case when not exists(select 1 from t1 where t1.a in (select ~cast(avg(d) AS integer) from t1 union select max(t1.f) from t1)) then ~(13) when  -c=t1.b then t1.c else f end)) from t1) then e else 17 end) from t1 union select max((a)) from t1) then  -b else t1.d end+13 then a else 13 end)"
    end, {
        -- <randexpr-2.31>
        1
        -- </randexpr-2.31>
    })

test:do_test(
    "randexpr-2.32",
    function()
        return test:execsql "SELECT coalesce((select (select max(t1.a)*(max(a))*max(t1.f*~11*case when b not in ((select min(19) from t1),b,coalesce((select max((t1.f)) from t1 where t1.c in (c,t1.b,(t1.f)) or t1.a<>(c)),b)*t1.b-t1.b) then d else t1.e end | f* -13-c) from t1) from t1 where not ~a<f), -19)+t1.d+b FROM t1 WHERE 13*t1.d between coalesce((select t1.d from t1 where b in (select t1.d from t1 union select case b*t1.f+t1.a*+coalesce((select t1.a from t1 where (not exists(select 1 from t1 where b*t1.c=13))),11)+t1.e when ~f then d+case b when e then f else t1.e end*13 else f end from t1)),19) and t1.d and 19 between 17 and e and a>a"
    end, {
        -- <randexpr-2.32>
        
        -- </randexpr-2.32>
    })

test:do_test(
    "randexpr-2.33",
    function()
        return test:execsql "SELECT coalesce((select (select max(t1.a)*(max(a))*max(t1.f*~11*case when b not in ((select min(19) from t1),b,coalesce((select max((t1.f)) from t1 where t1.c in (c,t1.b,(t1.f)) or t1.a<>(c)),b)*t1.b-t1.b) then d else t1.e end | f* -13-c) from t1) from t1 where not ~a<f), -19)+t1.d+b FROM t1 WHERE NOT (13*t1.d between coalesce((select t1.d from t1 where b in (select t1.d from t1 union select case b*t1.f+t1.a*+coalesce((select t1.a from t1 where (not exists(select 1 from t1 where b*t1.c=13))),11)+t1.e when ~f then d+case b when e then f else t1.e end*13 else f end from t1)),19) and t1.d and 19 between 17 and e and a>a)"
    end, {
        -- <randexpr-2.33>
        581
        -- </randexpr-2.33>
    })

test:do_test(
    "randexpr-2.34",
    function()
        return test:execsql "SELECT coalesce((select (select max(t1.a)*(max(a))*max(t1.f*~11*case when b not in ((select min(19) from t1),b,coalesce((select max((t1.f)) from t1 where t1.c in (c,t1.b,(t1.f)) or t1.a<>(c)),b)*t1.b-t1.b) then d else t1.e end & f* -13-c) from t1) from t1 where not ~a<f), -19)+t1.d+b FROM t1 WHERE NOT (13*t1.d between coalesce((select t1.d from t1 where b in (select t1.d from t1 union select case b*t1.f+t1.a*+coalesce((select t1.a from t1 where (not exists(select 1 from t1 where b*t1.c=13))),11)+t1.e when ~f then d+case b when e then f else t1.e end*13 else f end from t1)),19) and t1.d and 19 between 17 and e and a>a)"
    end, {
        -- <randexpr-2.34>
        581
        -- </randexpr-2.34>
    })

test:do_test(
    "randexpr-2.35",
    function()
        return test:execsql "SELECT case when t1.d not in (t1.d,coalesce((select max(11) from t1 where f not between 13 and c-coalesce((select max(d) from t1 where 19 not in ((t1.f),f,11)),t1.d)*t1.e | a),13), -(t1.e)) then t1.b when t1.f=t1.a and exists(select 1 from t1 where b in (select c from t1 union select 11 from t1) and t1.c=b and not  -d in (t1.d,t1.d,t1.b) and d between 11 and c) or d<=17 or a not in (e,19,(t1.b)) then 17 else 11 end FROM t1 WHERE a<>f+f"
    end, {
        -- <randexpr-2.35>
        17
        -- </randexpr-2.35>
    })

test:do_test(
    "randexpr-2.36",
    function()
        return test:execsql "SELECT case when t1.d not in (t1.d,coalesce((select max(11) from t1 where f not between 13 and c-coalesce((select max(d) from t1 where 19 not in ((t1.f),f,11)),t1.d)*t1.e | a),13), -(t1.e)) then t1.b when t1.f=t1.a and exists(select 1 from t1 where b in (select c from t1 union select 11 from t1) and t1.c=b and not  -d in (t1.d,t1.d,t1.b) and d between 11 and c) or d<=17 or a not in (e,19,(t1.b)) then 17 else 11 end FROM t1 WHERE NOT (a<>f+f)"
    end, {
        -- <randexpr-2.36>
        
        -- </randexpr-2.36>
    })

test:do_test(
    "randexpr-2.37",
    function()
        return test:execsql "SELECT case when t1.d not in (t1.d,coalesce((select max(11) from t1 where f not between 13 and c-coalesce((select max(d) from t1 where 19 not in ((t1.f),f,11)),t1.d)*t1.e & a),13), -(t1.e)) then t1.b when t1.f=t1.a and exists(select 1 from t1 where b in (select c from t1 union select 11 from t1) and t1.c=b and not  -d in (t1.d,t1.d,t1.b) and d between 11 and c) or d<=17 or a not in (e,19,(t1.b)) then 17 else 11 end FROM t1 WHERE a<>f+f"
    end, {
        -- <randexpr-2.37>
        17
        -- </randexpr-2.37>
    })

test:do_test(
    "randexpr-2.38",
    function()
        return test:execsql "SELECT case 13 when coalesce((select t1.a*d+++b | b+(abs(t1.e)/abs(c))+(select count(*) from t1) from t1 where not exists(select 1 from t1 where 17 in (select d from t1 union select t1.f from t1))),t1.b) then ~t1.c-(select case min(case when 17 not in (19,19,t1.c) then c when 13 between (19) and t1.e then e else 19 end-19) when cast(avg( -11) AS integer) then max(t1.c)* -min(t1.d) else (count(distinct t1.f)) end from t1) | +t1.f else t1.c end FROM t1 WHERE coalesce((select max(t1.c) from t1 where (abs(t1.b)/abs(a))>=(e)),+ -case when (11<17) then t1.a when t1.a*e=19* -11 and not exists(select 1 from t1 where  -t1.d not between coalesce((select a from t1 where  -t1.c>t1.e), -19) and t1.d and not exists(select 1 from t1 where (t1.e) in (select d from t1 union select t1.c from t1))) then c else a end*a)-t1.b* -(b) in (e,d,b)"
    end, {
        -- <randexpr-2.38>
        
        -- </randexpr-2.38>
    })

test:do_test(
    "randexpr-2.39",
    function()
        return test:execsql "SELECT case 13 when coalesce((select t1.a*d+++b | b+(abs(t1.e)/abs(c))+(select count(*) from t1) from t1 where not exists(select 1 from t1 where 17 in (select d from t1 union select t1.f from t1))),t1.b) then ~t1.c-(select case min(case when 17 not in (19,19,t1.c) then c when 13 between (19) and t1.e then e else 19 end-19) when cast(avg( -11) AS integer) then max(t1.c)* -min(t1.d) else (count(distinct t1.f)) end from t1) | +t1.f else t1.c end FROM t1 WHERE NOT (coalesce((select max(t1.c) from t1 where (abs(t1.b)/abs(a))>=(e)),+ -case when (11<17) then t1.a when t1.a*e=19* -11 and not exists(select 1 from t1 where  -t1.d not between coalesce((select a from t1 where  -t1.c>t1.e), -19) and t1.d and not exists(select 1 from t1 where (t1.e) in (select d from t1 union select t1.c from t1))) then c else a end*a)-t1.b* -(b) in (e,d,b))"
    end, {
        -- <randexpr-2.39>
        300
        -- </randexpr-2.39>
    })

test:do_test(
    "randexpr-2.40",
    function()
        return test:execsql "SELECT case 13 when coalesce((select t1.a*d+++b & b+(abs(t1.e)/abs(c))+(select count(*) from t1) from t1 where not exists(select 1 from t1 where 17 in (select d from t1 union select t1.f from t1))),t1.b) then ~t1.c-(select case min(case when 17 not in (19,19,t1.c) then c when 13 between (19) and t1.e then e else 19 end-19) when cast(avg( -11) AS integer) then max(t1.c)* -min(t1.d) else (count(distinct t1.f)) end from t1) & +t1.f else t1.c end FROM t1 WHERE NOT (coalesce((select max(t1.c) from t1 where (abs(t1.b)/abs(a))>=(e)),+ -case when (11<17) then t1.a when t1.a*e=19* -11 and not exists(select 1 from t1 where  -t1.d not between coalesce((select a from t1 where  -t1.c>t1.e), -19) and t1.d and not exists(select 1 from t1 where (t1.e) in (select d from t1 union select t1.c from t1))) then c else a end*a)-t1.b* -(b) in (e,d,b))"
    end, {
        -- <randexpr-2.40>
        300
        -- </randexpr-2.40>
    })

test:do_test(
    "randexpr-2.41",
    function()
        return test:execsql "SELECT case when not exists(select 1 from t1 where ( -case when b in ((11),coalesce((select f from t1 where (not exists(select 1 from t1 where coalesce((select (t1.a) from t1 where e<=a),11) in (select t1.f from t1 union select 13 from t1)) or t1.a>d)),t1.a),t1.e) or not not exists(select 1 from t1 where (t1.f<=(t1.a))) then e*t1.a else t1.c end)<=d and not (t1.e)>=t1.e) then coalesce((select max( -t1.e) from t1 where t1.d between t1.b and t1.c),t1.d) else t1.c end+13*13 FROM t1 WHERE t1.b=t1.f | 19+coalesce((select max(a) from t1 where case t1.e when case when (11<=11 | t1.f and b>=b or t1.f<=a) then case when c between t1.e and b then e else +t1.f end else  -t1.c end then t1.b else 13 end*13 between t1.f and c and exists(select 1 from t1 where (b not between 11 and a)) and f>=t1.b), -t1.b)-c"
    end, {
        -- <randexpr-2.41>
        
        -- </randexpr-2.41>
    })

test:do_test(
    "randexpr-2.42",
    function()
        return test:execsql "SELECT case when not exists(select 1 from t1 where ( -case when b in ((11),coalesce((select f from t1 where (not exists(select 1 from t1 where coalesce((select (t1.a) from t1 where e<=a),11) in (select t1.f from t1 union select 13 from t1)) or t1.a>d)),t1.a),t1.e) or not not exists(select 1 from t1 where (t1.f<=(t1.a))) then e*t1.a else t1.c end)<=d and not (t1.e)>=t1.e) then coalesce((select max( -t1.e) from t1 where t1.d between t1.b and t1.c),t1.d) else t1.c end+13*13 FROM t1 WHERE NOT (t1.b=t1.f | 19+coalesce((select max(a) from t1 where case t1.e when case when (11<=11 | t1.f and b>=b or t1.f<=a) then case when c between t1.e and b then e else +t1.f end else  -t1.c end then t1.b else 13 end*13 between t1.f and c and exists(select 1 from t1 where (b not between 11 and a)) and f>=t1.b), -t1.b)-c)"
    end, {
        -- <randexpr-2.42>
        569
        -- </randexpr-2.42>
    })

test:do_test(
    "randexpr-2.43",
    function()
        return test:execsql "SELECT coalesce((select c from t1 where t1.a=case when a=t1.b+~(select case cast(avg( -b*13) AS integer) when max(f*13* -c) then (cast(avg(t1.d) AS integer)) else count(distinct t1.e*c) end from t1) then t1.d | t1.a else case when t1.a-b not between e and  -t1.c* -13 then 19 else d end end),d) | t1.d FROM t1 WHERE +13 in (f,t1.f+t1.f, -coalesce((select max(t1.f) from t1 where (t1.a-13)<=(case (select count(*) from t1) when 13 then  -+t1.e |  -(coalesce((select max(~coalesce((select ( -13) from t1 where  -c<(11) or 11 between a and t1.d),13)*t1.d) from t1 where d not between b and 13),19))*t1.a else 13 end-b-c)),t1.e)-19)"
    end, {
        -- <randexpr-2.43>
        
        -- </randexpr-2.43>
    })

test:do_test(
    "randexpr-2.44",
    function()
        return test:execsql "SELECT coalesce((select c from t1 where t1.a=case when a=t1.b+~(select case cast(avg( -b*13) AS integer) when max(f*13* -c) then (cast(avg(t1.d) AS integer)) else count(distinct t1.e*c) end from t1) then t1.d | t1.a else case when t1.a-b not between e and  -t1.c* -13 then 19 else d end end),d) | t1.d FROM t1 WHERE NOT (+13 in (f,t1.f+t1.f, -coalesce((select max(t1.f) from t1 where (t1.a-13)<=(case (select count(*) from t1) when 13 then  -+t1.e |  -(coalesce((select max(~coalesce((select ( -13) from t1 where  -c<(11) or 11 between a and t1.d),13)*t1.d) from t1 where d not between b and 13),19))*t1.a else 13 end-b-c)),t1.e)-19))"
    end, {
        -- <randexpr-2.44>
        400
        -- </randexpr-2.44>
    })

test:do_test(
    "randexpr-2.45",
    function()
        return test:execsql "SELECT coalesce((select c from t1 where t1.a=case when a=t1.b+~(select case cast(avg( -b*13) AS integer) when max(f*13* -c) then (cast(avg(t1.d) AS integer)) else count(distinct t1.e*c) end from t1) then t1.d & t1.a else case when t1.a-b not between e and  -t1.c* -13 then 19 else d end end),d) & t1.d FROM t1 WHERE NOT (+13 in (f,t1.f+t1.f, -coalesce((select max(t1.f) from t1 where (t1.a-13)<=(case (select count(*) from t1) when 13 then  -+t1.e |  -(coalesce((select max(~coalesce((select ( -13) from t1 where  -c<(11) or 11 between a and t1.d),13)*t1.d) from t1 where d not between b and 13),19))*t1.a else 13 end-b-c)),t1.e)-19))"
    end, {
        -- <randexpr-2.45>
        400
        -- </randexpr-2.45>
    })

test:do_test(
    "randexpr-2.46",
    function()
        return test:execsql "SELECT case ~11-13 when 11-d-case when t1.f*+a-t1.a-t1.f=t1.a then a when t1.f between 19-t1.a+coalesce((select a from t1 where e in (select case  -max(t1.c) when count(*) then max(t1.d) else  -(cast(avg((t1.e)) AS integer)) end from t1 union select (max(t1.b)) from t1)), -b) and e or ((11<c)) or e>=t1.d then t1.b else a end+13+(t1.c) then a else  -d end FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where (not +t1.b-~a*(d*t1.e | + -coalesce((select t1.c from t1 where t1.b*case t1.b when f then  -a*b else e end<>a+t1.a),17))+e*t1.e*11 | t1.a not between 13 and  -t1.a and b between d and  -f)))"
    end, {
        -- <randexpr-2.46>
        -400
        -- </randexpr-2.46>
    })

test:do_test(
    "randexpr-2.47",
    function()
        return test:execsql "SELECT case ~11-13 when 11-d-case when t1.f*+a-t1.a-t1.f=t1.a then a when t1.f between 19-t1.a+coalesce((select a from t1 where e in (select case  -max(t1.c) when count(*) then max(t1.d) else  -(cast(avg((t1.e)) AS integer)) end from t1 union select (max(t1.b)) from t1)), -b) and e or ((11<c)) or e>=t1.d then t1.b else a end+13+(t1.c) then a else  -d end FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where (not +t1.b-~a*(d*t1.e | + -coalesce((select t1.c from t1 where t1.b*case t1.b when f then  -a*b else e end<>a+t1.a),17))+e*t1.e*11 | t1.a not between 13 and  -t1.a and b between d and  -f))))"
    end, {
        -- <randexpr-2.47>
        
        -- </randexpr-2.47>
    })

test:do_test(
    "randexpr-2.48",
    function()
        return test:execsql "SELECT 11++(case 19 when t1.c-19-coalesce((select t1.b from t1 where e*19-t1.e<=+case when c in (select 19 | 17 from t1 union select 11 from t1) then (abs(a)/abs(19)) when a*t1.d>19 or (11) not in (b,t1.a,t1.a) then b else b end-11),f) then 13 else 11 end-t1.e*a) FROM t1 WHERE f in (17,t1.f | coalesce((select max(t1.e) from t1 where not 17 in (select f from t1 union select +17 from t1)),b+coalesce((select max(b) from t1 where 19 in (select case min(t1.d) when (count(*)) then min(d) else  -min(d) end from t1 union select max(d) from t1)),f)*f-17+19),b) or d<=f or t1.f>=11 or t1.b<=11 or t1.c<=11 or t1.b<=b"
    end, {
        -- <randexpr-2.48>
        -49978
        -- </randexpr-2.48>
    })

test:do_test(
    "randexpr-2.49",
    function()
        return test:execsql "SELECT 11++(case 19 when t1.c-19-coalesce((select t1.b from t1 where e*19-t1.e<=+case when c in (select 19 | 17 from t1 union select 11 from t1) then (abs(a)/abs(19)) when a*t1.d>19 or (11) not in (b,t1.a,t1.a) then b else b end-11),f) then 13 else 11 end-t1.e*a) FROM t1 WHERE NOT (f in (17,t1.f | coalesce((select max(t1.e) from t1 where not 17 in (select f from t1 union select +17 from t1)),b+coalesce((select max(b) from t1 where 19 in (select case min(t1.d) when (count(*)) then min(d) else  -min(d) end from t1 union select max(d) from t1)),f)*f-17+19),b) or d<=f or t1.f>=11 or t1.b<=11 or t1.c<=11 or t1.b<=b)"
    end, {
        -- <randexpr-2.49>
        
        -- </randexpr-2.49>
    })

test:do_test(
    "randexpr-2.50",
    function()
        return test:execsql "SELECT 11++(case 19 when t1.c-19-coalesce((select t1.b from t1 where e*19-t1.e<=+case when c in (select 19 & 17 from t1 union select 11 from t1) then (abs(a)/abs(19)) when a*t1.d>19 or (11) not in (b,t1.a,t1.a) then b else b end-11),f) then 13 else 11 end-t1.e*a) FROM t1 WHERE f in (17,t1.f | coalesce((select max(t1.e) from t1 where not 17 in (select f from t1 union select +17 from t1)),b+coalesce((select max(b) from t1 where 19 in (select case min(t1.d) when (count(*)) then min(d) else  -min(d) end from t1 union select max(d) from t1)),f)*f-17+19),b) or d<=f or t1.f>=11 or t1.b<=11 or t1.c<=11 or t1.b<=b"
    end, {
        -- <randexpr-2.50>
        -49978
        -- </randexpr-2.50>
    })

test:do_test(
    "randexpr-2.51",
    function()
        return test:execsql "SELECT  -c-coalesce((select max(t1.a) from t1 where (a>17-t1.a) and (select abs(min(t1.a))*case abs(case (((min((t1.c))))+min(a)) when count(distinct f) then min(11) else count(distinct b) end) when min(t1.f) then (count(distinct t1.b)) else  -count(*) end from t1)<>case d when +(select ((min(t1.a))) from t1)-(abs(c)/abs(f)) then b else 17 end+t1.c),coalesce((select t1.d from t1 where d>19),t1.a)) FROM t1 WHERE b+(coalesce((select max(a) from t1 where exists(select 1 from t1 where t1.b<=c-(select ~~max((abs(e)/abs(13 | (t1.e)-c-19))) from t1) or d in (select t1.b from t1 union select d from t1)) or 13 in (select cast(avg(19) AS integer) from t1 union select ( -cast(avg(19) AS integer) | count(*)*min(19)) from t1) or 19<=11),t1.c))-t1.d-c>f"
    end, {
        -- <randexpr-2.51>
        
        -- </randexpr-2.51>
    })

test:do_test(
    "randexpr-2.52",
    function()
        return test:execsql "SELECT  -c-coalesce((select max(t1.a) from t1 where (a>17-t1.a) and (select abs(min(t1.a))*case abs(case (((min((t1.c))))+min(a)) when count(distinct f) then min(11) else count(distinct b) end) when min(t1.f) then (count(distinct t1.b)) else  -count(*) end from t1)<>case d when +(select ((min(t1.a))) from t1)-(abs(c)/abs(f)) then b else 17 end+t1.c),coalesce((select t1.d from t1 where d>19),t1.a)) FROM t1 WHERE NOT (b+(coalesce((select max(a) from t1 where exists(select 1 from t1 where t1.b<=c-(select ~~max((abs(e)/abs(13 | (t1.e)-c-19))) from t1) or d in (select t1.b from t1 union select d from t1)) or 13 in (select cast(avg(19) AS integer) from t1 union select ( -cast(avg(19) AS integer) | count(*)*min(19)) from t1) or 19<=11),t1.c))-t1.d-c>f)"
    end, {
        -- <randexpr-2.52>
        -400
        -- </randexpr-2.52>
    })

test:do_test(
    "randexpr-2.53",
    function()
        return test:execsql "SELECT case when t1.b+coalesce((select max(a) from t1 where exists(select 1 from t1 where not not t1.d>19)),13) | case when f in (select a from t1 union select case when (a)<>t1.c then c when not exists(select 1 from t1 where t1.c not between 17 and  -(t1.d)) then f else (11) end from t1) then t1.c when (not exists(select 1 from t1 where 17 not between t1.f and a)) and d=b then t1.c else d end<=19 and (t1.c<>c and (13) not between t1.d and t1.c) and a>= -b or 11>13 and c<>13 then  -f else d end FROM t1 WHERE (case when (17 not in (f*11,+coalesce((select max(b-b) from t1 where t1.c+f not between 11 and t1.d),13),c)) or (t1.e in (select ~min(t1.f) from t1 union select ~count(*) from t1) and exists(select 1 from t1 where (not f>=19 and 17 not between a and t1.e)) or (e) not in (e,d,13) or t1.d>=f) then e when 17 between t1.c and 13 then case when 11<>19 then t1.d else t1.a end else b end in (select  -t1.a from t1 union select a from t1))"
    end, {
        -- <randexpr-2.53>
        
        -- </randexpr-2.53>
    })

test:do_test(
    "randexpr-2.54",
    function()
        return test:execsql "SELECT case when t1.b+coalesce((select max(a) from t1 where exists(select 1 from t1 where not not t1.d>19)),13) | case when f in (select a from t1 union select case when (a)<>t1.c then c when not exists(select 1 from t1 where t1.c not between 17 and  -(t1.d)) then f else (11) end from t1) then t1.c when (not exists(select 1 from t1 where 17 not between t1.f and a)) and d=b then t1.c else d end<=19 and (t1.c<>c and (13) not between t1.d and t1.c) and a>= -b or 11>13 and c<>13 then  -f else d end FROM t1 WHERE NOT ((case when (17 not in (f*11,+coalesce((select max(b-b) from t1 where t1.c+f not between 11 and t1.d),13),c)) or (t1.e in (select ~min(t1.f) from t1 union select ~count(*) from t1) and exists(select 1 from t1 where (not f>=19 and 17 not between a and t1.e)) or (e) not in (e,d,13) or t1.d>=f) then e when 17 between t1.c and 13 then case when 11<>19 then t1.d else t1.a end else b end in (select  -t1.a from t1 union select a from t1)))"
    end, {
        -- <randexpr-2.54>
        400
        -- </randexpr-2.54>
    })

test:do_test(
    "randexpr-2.55",
    function()
        return test:execsql "SELECT case when t1.b+coalesce((select max(a) from t1 where exists(select 1 from t1 where not not t1.d>19)),13) & case when f in (select a from t1 union select case when (a)<>t1.c then c when not exists(select 1 from t1 where t1.c not between 17 and  -(t1.d)) then f else (11) end from t1) then t1.c when (not exists(select 1 from t1 where 17 not between t1.f and a)) and d=b then t1.c else d end<=19 and (t1.c<>c and (13) not between t1.d and t1.c) and a>= -b or 11>13 and c<>13 then  -f else d end FROM t1 WHERE NOT ((case when (17 not in (f*11,+coalesce((select max(b-b) from t1 where t1.c+f not between 11 and t1.d),13),c)) or (t1.e in (select ~min(t1.f) from t1 union select ~count(*) from t1) and exists(select 1 from t1 where (not f>=19 and 17 not between a and t1.e)) or (e) not in (e,d,13) or t1.d>=f) then e when 17 between t1.c and 13 then case when 11<>19 then t1.d else t1.a end else b end in (select  -t1.a from t1 union select a from t1)))"
    end, {
        -- <randexpr-2.55>
        400
        -- </randexpr-2.55>
    })

test:do_test(
    "randexpr-2.56",
    function()
        return test:execsql "SELECT t1.e+case when d not between f and case when a in (select t1.c from t1 union select t1.e from t1) or coalesce((select 19 from t1 where 17<=t1.d or 19*t1.f*t1.b<>t1.d | t1.d | t1.a),t1.b)*case when (t1.a) in (t1.d,t1.a,a) then  -c when 17<13 then t1.f else 17 end-t1.f*e not in (19,t1.d,17) then 19 else t1.e end then  -b else t1.b end FROM t1 WHERE (coalesce((select t1.d-coalesce((select max(coalesce((select max(c+13) from t1 where ~13*t1.b in (select abs(abs(abs((cast(avg( -e) AS integer)))))- -count(distinct (13))*max(13) from t1 union select count(distinct 19) from t1)), -t1.f)) from t1 where exists(select 1 from t1 where 17 in (t1.b,13,b))),b)+d+t1.a from t1 where d not in (13,t1.b,b)),17) not between 11 and e or not 17 between d and d)"
    end, {
        -- <randexpr-2.56>
        300
        -- </randexpr-2.56>
    })

test:do_test(
    "randexpr-2.57",
    function()
        return test:execsql "SELECT t1.e+case when d not between f and case when a in (select t1.c from t1 union select t1.e from t1) or coalesce((select 19 from t1 where 17<=t1.d or 19*t1.f*t1.b<>t1.d | t1.d | t1.a),t1.b)*case when (t1.a) in (t1.d,t1.a,a) then  -c when 17<13 then t1.f else 17 end-t1.f*e not in (19,t1.d,17) then 19 else t1.e end then  -b else t1.b end FROM t1 WHERE NOT ((coalesce((select t1.d-coalesce((select max(coalesce((select max(c+13) from t1 where ~13*t1.b in (select abs(abs(abs((cast(avg( -e) AS integer)))))- -count(distinct (13))*max(13) from t1 union select count(distinct 19) from t1)), -t1.f)) from t1 where exists(select 1 from t1 where 17 in (t1.b,13,b))),b)+d+t1.a from t1 where d not in (13,t1.b,b)),17) not between 11 and e or not 17 between d and d))"
    end, {
        -- <randexpr-2.57>
        
        -- </randexpr-2.57>
    })

test:do_test(
    "randexpr-2.58",
    function()
        return test:execsql "SELECT t1.e+case when d not between f and case when a in (select t1.c from t1 union select t1.e from t1) or coalesce((select 19 from t1 where 17<=t1.d or 19*t1.f*t1.b<>t1.d & t1.d & t1.a),t1.b)*case when (t1.a) in (t1.d,t1.a,a) then  -c when 17<13 then t1.f else 17 end-t1.f*e not in (19,t1.d,17) then 19 else t1.e end then  -b else t1.b end FROM t1 WHERE (coalesce((select t1.d-coalesce((select max(coalesce((select max(c+13) from t1 where ~13*t1.b in (select abs(abs(abs((cast(avg( -e) AS integer)))))- -count(distinct (13))*max(13) from t1 union select count(distinct 19) from t1)), -t1.f)) from t1 where exists(select 1 from t1 where 17 in (t1.b,13,b))),b)+d+t1.a from t1 where d not in (13,t1.b,b)),17) not between 11 and e or not 17 between d and d)"
    end, {
        -- <randexpr-2.58>
        300
        -- </randexpr-2.58>
    })

test:do_test(
    "randexpr-2.59",
    function()
        return test:execsql "SELECT coalesce((select max(t1.f*case when not exists(select 1 from t1 where exists(select 1 from t1 where (select count(distinct 11) from t1) between coalesce((select max(c) from t1 where t1.e=t1.a+17),a) and t1.b) or c not in (t1.e,19,t1.e)) then 13 when exists(select 1 from t1 where t1.a between 19 and  -c) then coalesce((select coalesce((select max((( -d))) from t1 where 17 not in (t1.d,e,t1.e)),e) from t1 where c= -f),( -c)) else t1.f end) from t1 where not (11 between a and t1.e)),19) FROM t1 WHERE case c when case when (exists(select 1 from t1 where t1.d<>coalesce((select 13 from t1 where (t1.b>+e)),(17))+coalesce((select 13 from t1 where exists(select 1 from t1 where 13 in (t1.b+c,case when f between t1.f and b then t1.b else f end,(11)))),f)-17-17)) then  -c-(c) when 11 in (b,f,(t1.d)) then t1.c else t1.b end then t1.d else 11 end in (select  -count(*) from t1 union select count(*) from t1)"
    end, {
        -- <randexpr-2.59>
        
        -- </randexpr-2.59>
    })

test:do_test(
    "randexpr-2.60",
    function()
        return test:execsql "SELECT coalesce((select max(t1.f*case when not exists(select 1 from t1 where exists(select 1 from t1 where (select count(distinct 11) from t1) between coalesce((select max(c) from t1 where t1.e=t1.a+17),a) and t1.b) or c not in (t1.e,19,t1.e)) then 13 when exists(select 1 from t1 where t1.a between 19 and  -c) then coalesce((select coalesce((select max((( -d))) from t1 where 17 not in (t1.d,e,t1.e)),e) from t1 where c= -f),( -c)) else t1.f end) from t1 where not (11 between a and t1.e)),19) FROM t1 WHERE NOT (case c when case when (exists(select 1 from t1 where t1.d<>coalesce((select 13 from t1 where (t1.b>+e)),(17))+coalesce((select 13 from t1 where exists(select 1 from t1 where 13 in (t1.b+c,case when f between t1.f and b then t1.b else f end,(11)))),f)-17-17)) then  -c-(c) when 11 in (b,f,(t1.d)) then t1.c else t1.b end then t1.d else 11 end in (select  -count(*) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.60>
        360000
        -- </randexpr-2.60>
    })

test:do_test(
    "randexpr-2.61",
    function()
        return test:execsql "SELECT case when t1.a-coalesce((select t1.b from t1 where (d<=~a)),t1.b+t1.d | 19+13)-t1.a | ~coalesce((select ~17 from t1 where not exists(select 1 from t1 where ~case when 13 in (select +(cast(avg(b) AS integer)) from t1 union select count(*) from t1) then 17 when 11 not in (c,t1.a,t1.a) then e else e end*a not between 11 and c)),t1.c) in (11,t1.a,e) then t1.f when 19 in (select ~count(distinct d) from t1 union select cast(avg(19) AS integer) from t1) then t1.d else 19 end FROM t1 WHERE not exists(select 1 from t1 where (select count(*) from t1)+coalesce((select max(a) from t1 where t1.a between (abs(case when exists(select 1 from t1 where case when t1.e=case when 19 between 11 and e then t1.f else a end then t1.e else t1.b end in (select count(distinct d) | max(11)*abs(case count(*) when max(f) then cast(avg(e) AS integer) else count(distinct t1.e) end) from t1 union select  -cast(avg(c) AS integer) from t1)) then (select  -min(e) from t1) when (c>e) then t1.d else f end)/abs(b)) and (17)),e) not between t1.a and d)"
    end, {
        -- <randexpr-2.61>
        
        -- </randexpr-2.61>
    })

test:do_test(
    "randexpr-2.62",
    function()
        return test:execsql "SELECT case when t1.a-coalesce((select t1.b from t1 where (d<=~a)),t1.b+t1.d | 19+13)-t1.a | ~coalesce((select ~17 from t1 where not exists(select 1 from t1 where ~case when 13 in (select +(cast(avg(b) AS integer)) from t1 union select count(*) from t1) then 17 when 11 not in (c,t1.a,t1.a) then e else e end*a not between 11 and c)),t1.c) in (11,t1.a,e) then t1.f when 19 in (select ~count(distinct d) from t1 union select cast(avg(19) AS integer) from t1) then t1.d else 19 end FROM t1 WHERE NOT (not exists(select 1 from t1 where (select count(*) from t1)+coalesce((select max(a) from t1 where t1.a between (abs(case when exists(select 1 from t1 where case when t1.e=case when 19 between 11 and e then t1.f else a end then t1.e else t1.b end in (select count(distinct d) | max(11)*abs(case count(*) when max(f) then cast(avg(e) AS integer) else count(distinct t1.e) end) from t1 union select  -cast(avg(c) AS integer) from t1)) then (select  -min(e) from t1) when (c>e) then t1.d else f end)/abs(b)) and (17)),e) not between t1.a and d))"
    end, {
        -- <randexpr-2.62>
        400
        -- </randexpr-2.62>
    })

test:do_test(
    "randexpr-2.63",
    function()
        return test:execsql "SELECT case when t1.a-coalesce((select t1.b from t1 where (d<=~a)),t1.b+t1.d & 19+13)-t1.a & ~coalesce((select ~17 from t1 where not exists(select 1 from t1 where ~case when 13 in (select +(cast(avg(b) AS integer)) from t1 union select count(*) from t1) then 17 when 11 not in (c,t1.a,t1.a) then e else e end*a not between 11 and c)),t1.c) in (11,t1.a,e) then t1.f when 19 in (select ~count(distinct d) from t1 union select cast(avg(19) AS integer) from t1) then t1.d else 19 end FROM t1 WHERE NOT (not exists(select 1 from t1 where (select count(*) from t1)+coalesce((select max(a) from t1 where t1.a between (abs(case when exists(select 1 from t1 where case when t1.e=case when 19 between 11 and e then t1.f else a end then t1.e else t1.b end in (select count(distinct d) | max(11)*abs(case count(*) when max(f) then cast(avg(e) AS integer) else count(distinct t1.e) end) from t1 union select  -cast(avg(c) AS integer) from t1)) then (select  -min(e) from t1) when (c>e) then t1.d else f end)/abs(b)) and (17)),e) not between t1.a and d))"
    end, {
        -- <randexpr-2.63>
        400
        -- </randexpr-2.63>
    })

test:do_test(
    "randexpr-2.64",
    function()
        return test:execsql "SELECT case when 11 in (select max(f) from t1 union select min(19++13) | min(t1.c) from t1) and (e in (select t1.d from t1 union select t1.a | 17*case e when coalesce((select max(a) from t1 where b not in (b,f,d) or t1.a<=f),11) then t1.a else t1.b end from t1) and  -a not between b and d) then d when  -t1.f=b or t1.b between  -f and  -d then 19 else d end+d FROM t1 WHERE case when (coalesce((select case (select max(t1.b) from t1) when (b* -t1.e+e*e-t1.a) then c else a end from t1 where 17 in (select min(t1.d)-abs(count(*)) from t1 union select count(distinct c) from t1)),t1.d)=(t1.d)) and e in (select  -min(t1.b) from t1 union select count(distinct 11) from t1) and a< - -17 then t1.d | 11 else 19 end in (select 17 from t1 union select d from t1)"
    end, {
        -- <randexpr-2.64>
        
        -- </randexpr-2.64>
    })

test:do_test(
    "randexpr-2.65",
    function()
        return test:execsql "SELECT case when 11 in (select max(f) from t1 union select min(19++13) | min(t1.c) from t1) and (e in (select t1.d from t1 union select t1.a | 17*case e when coalesce((select max(a) from t1 where b not in (b,f,d) or t1.a<=f),11) then t1.a else t1.b end from t1) and  -a not between b and d) then d when  -t1.f=b or t1.b between  -f and  -d then 19 else d end+d FROM t1 WHERE NOT (case when (coalesce((select case (select max(t1.b) from t1) when (b* -t1.e+e*e-t1.a) then c else a end from t1 where 17 in (select min(t1.d)-abs(count(*)) from t1 union select count(distinct c) from t1)),t1.d)=(t1.d)) and e in (select  -min(t1.b) from t1 union select count(distinct 11) from t1) and a< - -17 then t1.d | 11 else 19 end in (select 17 from t1 union select d from t1))"
    end, {
        -- <randexpr-2.65>
        800
        -- </randexpr-2.65>
    })

test:do_test(
    "randexpr-2.66",
    function()
        return test:execsql "SELECT case when 11 in (select max(f) from t1 union select min(19++13) & min(t1.c) from t1) and (e in (select t1.d from t1 union select t1.a & 17*case e when coalesce((select max(a) from t1 where b not in (b,f,d) or t1.a<=f),11) then t1.a else t1.b end from t1) and  -a not between b and d) then d when  -t1.f=b or t1.b between  -f and  -d then 19 else d end+d FROM t1 WHERE NOT (case when (coalesce((select case (select max(t1.b) from t1) when (b* -t1.e+e*e-t1.a) then c else a end from t1 where 17 in (select min(t1.d)-abs(count(*)) from t1 union select count(distinct c) from t1)),t1.d)=(t1.d)) and e in (select  -min(t1.b) from t1 union select count(distinct 11) from t1) and a< - -17 then t1.d | 11 else 19 end in (select 17 from t1 union select d from t1))"
    end, {
        -- <randexpr-2.66>
        800
        -- </randexpr-2.66>
    })

test:do_test(
    "randexpr-2.67",
    function()
        return test:execsql "SELECT (abs((select min(13) from t1))/abs(coalesce((select t1.e from t1 where coalesce((select t1.f from t1 where  -11<=b-t1.c*case when (d)-t1.f+t1.e-13<>t1.b then 11 when exists(select 1 from t1 where t1.d<>((t1.b)) or t1.a not between d and 13) or t1.b<>t1.c then t1.e else  -t1.d end+t1.a or t1.c not between f and d),e)<>e), -f))) FROM t1 WHERE t1.c<>(select min((abs(( -19-t1.b*13- -++~t1.f*d-17*19*11))/abs(17))) from t1)"
    end, {
        -- <randexpr-2.67>
        0
        -- </randexpr-2.67>
    })

test:do_test(
    "randexpr-2.68",
    function()
        return test:execsql "SELECT (abs((select min(13) from t1))/abs(coalesce((select t1.e from t1 where coalesce((select t1.f from t1 where  -11<=b-t1.c*case when (d)-t1.f+t1.e-13<>t1.b then 11 when exists(select 1 from t1 where t1.d<>((t1.b)) or t1.a not between d and 13) or t1.b<>t1.c then t1.e else  -t1.d end+t1.a or t1.c not between f and d),e)<>e), -f))) FROM t1 WHERE NOT (t1.c<>(select min((abs(( -19-t1.b*13- -++~t1.f*d-17*19*11))/abs(17))) from t1))"
    end, {
        -- <randexpr-2.68>
        
        -- </randexpr-2.68>
    })

test:do_test(
    "randexpr-2.69",
    function()
        return test:execsql "SELECT case d-case when c< -case when b<=f or coalesce((select t1.e from t1 where 11<coalesce((select b+(t1.f)+t1.e-d from t1 where (t1.c<f)),t1.d)),t1.e)>e then 19 when not exists(select 1 from t1 where not exists(select 1 from t1 where t1.d>=d)) then t1.f else 17 end then e when not exists(select 1 from t1 where d=b) then t1.c else f end when 17 then 19 else t1.f end FROM t1 WHERE coalesce((select max(+t1.d) from t1 where e<>e or not exists(select 1 from t1 where not exists(select 1 from t1 where (abs(f)/abs(f))++t1.b in (select case abs(cast(avg(e) AS integer)) when cast(avg(17) AS integer) | max(d) | cast(avg(t1.e) AS integer) | min(t1.e) then (cast(avg(19) AS integer)) else cast(avg(c) AS integer) end from t1 union select cast(avg(t1.f) AS integer) from t1))) and t1.a between t1.f and b or not 17<13 or  -11= -t1.f or t1.f between c and 19),d)+(t1.d) not between b and e"
    end, {
        -- <randexpr-2.69>
        600
        -- </randexpr-2.69>
    })

test:do_test(
    "randexpr-2.70",
    function()
        return test:execsql "SELECT case d-case when c< -case when b<=f or coalesce((select t1.e from t1 where 11<coalesce((select b+(t1.f)+t1.e-d from t1 where (t1.c<f)),t1.d)),t1.e)>e then 19 when not exists(select 1 from t1 where not exists(select 1 from t1 where t1.d>=d)) then t1.f else 17 end then e when not exists(select 1 from t1 where d=b) then t1.c else f end when 17 then 19 else t1.f end FROM t1 WHERE NOT (coalesce((select max(+t1.d) from t1 where e<>e or not exists(select 1 from t1 where not exists(select 1 from t1 where (abs(f)/abs(f))++t1.b in (select case abs(cast(avg(e) AS integer)) when cast(avg(17) AS integer) | max(d) | cast(avg(t1.e) AS integer) | min(t1.e) then (cast(avg(19) AS integer)) else cast(avg(c) AS integer) end from t1 union select cast(avg(t1.f) AS integer) from t1))) and t1.a between t1.f and b or not 17<13 or  -11= -t1.f or t1.f between c and 19),d)+(t1.d) not between b and e)"
    end, {
        -- <randexpr-2.70>
        
        -- </randexpr-2.70>
    })

test:do_test(
    "randexpr-2.71",
    function()
        return test:execsql "SELECT case when t1.e in (select abs(max(case a+case when t1.a>=e+ -c then a else t1.b end+t1.a when t1.f then 19 else  -19 end)+abs( -count(distinct t1.c))+~(count(distinct t1.b)))-min(b) from t1 union select max(f) from t1) and case t1.e when  -t1.c then 19 else b end<t1.d then e+(d) when exists(select 1 from t1 where 19 not between t1.e and (19)) then  -19 else t1.c end FROM t1 WHERE (exists(select 1 from t1 where t1.e between t1.c-t1.d and (t1.a)) and ((not case 19 when 11 then e else ~d | t1.a*19 end*((b))>=t1.e))) or c in (select f from t1 union select 13 from t1) and (b)< -t1.c and f in (select max(13) from t1 union select ~+abs(count(distinct e)*abs(((count(*)))*((max(f))))) from t1)"
    end, {
        -- <randexpr-2.71>
        
        -- </randexpr-2.71>
    })

test:do_test(
    "randexpr-2.72",
    function()
        return test:execsql "SELECT case when t1.e in (select abs(max(case a+case when t1.a>=e+ -c then a else t1.b end+t1.a when t1.f then 19 else  -19 end)+abs( -count(distinct t1.c))+~(count(distinct t1.b)))-min(b) from t1 union select max(f) from t1) and case t1.e when  -t1.c then 19 else b end<t1.d then e+(d) when exists(select 1 from t1 where 19 not between t1.e and (19)) then  -19 else t1.c end FROM t1 WHERE NOT ((exists(select 1 from t1 where t1.e between t1.c-t1.d and (t1.a)) and ((not case 19 when 11 then e else ~d | t1.a*19 end*((b))>=t1.e))) or c in (select f from t1 union select 13 from t1) and (b)< -t1.c and f in (select max(13) from t1 union select ~+abs(count(distinct e)*abs(((count(*)))*((max(f))))) from t1))"
    end, {
        -- <randexpr-2.72>
        -19
        -- </randexpr-2.72>
    })

test:do_test(
    "randexpr-2.73",
    function()
        return test:execsql "SELECT c*case when t1.a in (select ~count(*) from t1 union select  -count(distinct ~case (abs(11)/abs(b-(coalesce((select 17-t1.a from t1 where not t1.d=t1.d),(abs(11)/abs(a)))))) when case when t1.d between 19 and c and t1.b between 11 and t1.a then 13 else (13) end then (13) else 19 end-19*13+11) from t1) then t1.a when t1.f<=t1.e then f else b end-19-c+f FROM t1 WHERE t1.b>=c+case when exists(select 1 from t1 where a>=+f- -c*e+coalesce((select max(b) from t1 where (b not between (t1.b) and 19) or t1.f<11),d)*f | t1.e+t1.b) then ( -t1.e)-19 when ((t1.a in (select 19 from t1 union select t1.f from t1) or b<c and b> -17)) then f else f end | d"
    end, {
        -- <randexpr-2.73>
        
        -- </randexpr-2.73>
    })

test:do_test(
    "randexpr-2.74",
    function()
        return test:execsql "SELECT c*case when t1.a in (select ~count(*) from t1 union select  -count(distinct ~case (abs(11)/abs(b-(coalesce((select 17-t1.a from t1 where not t1.d=t1.d),(abs(11)/abs(a)))))) when case when t1.d between 19 and c and t1.b between 11 and t1.a then 13 else (13) end then (13) else 19 end-19*13+11) from t1) then t1.a when t1.f<=t1.e then f else b end-19-c+f FROM t1 WHERE NOT (t1.b>=c+case when exists(select 1 from t1 where a>=+f- -c*e+coalesce((select max(b) from t1 where (b not between (t1.b) and 19) or t1.f<11),d)*f | t1.e+t1.b) then ( -t1.e)-19 when ((t1.a in (select 19 from t1 union select t1.f from t1) or b<c and b> -17)) then f else f end | d)"
    end, {
        -- <randexpr-2.74>
        60281
        -- </randexpr-2.74>
    })

test:do_test(
    "randexpr-2.75",
    function()
        return test:execsql "SELECT (abs(case when a>=b then t1.c-case when not exists(select 1 from t1 where case d when +17 then 19+c else 11 end-(abs((select  - -cast(avg(case when (11- -(abs(e)/abs(13))-t1.f<t1.e) then t1.c+d else a end-t1.c) AS integer) from t1))/abs(t1.a))<=b) then  -e+d else (t1.c) end else 19 end)/abs(c)) FROM t1 WHERE f<>11"
    end, {
        -- <randexpr-2.75>
        0
        -- </randexpr-2.75>
    })

test:do_test(
    "randexpr-2.76",
    function()
        return test:execsql "SELECT (abs(case when a>=b then t1.c-case when not exists(select 1 from t1 where case d when +17 then 19+c else 11 end-(abs((select  - -cast(avg(case when (11- -(abs(e)/abs(13))-t1.f<t1.e) then t1.c+d else a end-t1.c) AS integer) from t1))/abs(t1.a))<=b) then  -e+d else (t1.c) end else 19 end)/abs(c)) FROM t1 WHERE NOT (f<>11)"
    end, {
        -- <randexpr-2.76>
        
        -- </randexpr-2.76>
    })

test:do_test(
    "randexpr-2.77",
    function()
        return test:execsql "SELECT  -coalesce((select max(e-t1.b) from t1 where t1.e<11 and t1.b | e in ((abs(13)/abs(t1.b)),(abs((+17-case when t1.c | 13*(d) | b<>a or ((t1.e)>=a) then t1.b-t1.e when not exists(select 1 from t1 where 17<13) then  -(13) else 17 end*13))/abs(13)),t1.c)),t1.e) | c FROM t1 WHERE not exists(select 1 from t1 where 17<=(select (case (~+abs(cast(avg((t1.e)-17 | b) AS integer))-((case  -cast(avg(case when ~t1.b in (select d from t1 union select 19 from t1) then b when 13 in (t1.f,c,t1.b) then c else f end) AS integer)+count(distinct t1.f)+count(distinct t1.d) when count(*) then ((max(c))) else count(*) end)*cast(avg(t1.e) AS integer))) when ((cast(avg(a) AS integer))) then  -max(d) else ((count(*))) end) from t1))"
    end, {
        -- <randexpr-2.77>
        -212
        -- </randexpr-2.77>
    })

test:do_test(
    "randexpr-2.78",
    function()
        return test:execsql "SELECT  -coalesce((select max(e-t1.b) from t1 where t1.e<11 and t1.b | e in ((abs(13)/abs(t1.b)),(abs((+17-case when t1.c | 13*(d) | b<>a or ((t1.e)>=a) then t1.b-t1.e when not exists(select 1 from t1 where 17<13) then  -(13) else 17 end*13))/abs(13)),t1.c)),t1.e) | c FROM t1 WHERE NOT (not exists(select 1 from t1 where 17<=(select (case (~+abs(cast(avg((t1.e)-17 | b) AS integer))-((case  -cast(avg(case when ~t1.b in (select d from t1 union select 19 from t1) then b when 13 in (t1.f,c,t1.b) then c else f end) AS integer)+count(distinct t1.f)+count(distinct t1.d) when count(*) then ((max(c))) else count(*) end)*cast(avg(t1.e) AS integer))) when ((cast(avg(a) AS integer))) then  -max(d) else ((count(*))) end) from t1)))"
    end, {
        -- <randexpr-2.78>
        
        -- </randexpr-2.78>
    })

test:do_test(
    "randexpr-2.79",
    function()
        return test:execsql "SELECT  -coalesce((select max(e-t1.b) from t1 where t1.e<11 and t1.b & e in ((abs(13)/abs(t1.b)),(abs((+17-case when t1.c & 13*(d) & b<>a or ((t1.e)>=a) then t1.b-t1.e when not exists(select 1 from t1 where 17<13) then  -(13) else 17 end*13))/abs(13)),t1.c)),t1.e) & c FROM t1 WHERE not exists(select 1 from t1 where 17<=(select (case (~+abs(cast(avg((t1.e)-17 | b) AS integer))-((case  -cast(avg(case when ~t1.b in (select d from t1 union select 19 from t1) then b when 13 in (t1.f,c,t1.b) then c else f end) AS integer)+count(distinct t1.f)+count(distinct t1.d) when count(*) then ((max(c))) else count(*) end)*cast(avg(t1.e) AS integer))) when ((cast(avg(a) AS integer))) then  -max(d) else ((count(*))) end) from t1))"
    end, {
        -- <randexpr-2.79>
        12
        -- </randexpr-2.79>
    })

test:do_test(
    "randexpr-2.80",
    function()
        return test:execsql "SELECT 17-coalesce((select c+t1.f from t1 where (select count(distinct d)-abs(min((select case  - -count(*) when  -max(19) then  -count(*) else count(*) end from t1))-count(*)) from t1)-t1.a+case when (abs(t1.e)/abs(t1.e)) not in (a,t1.a,19) and (b between 19 and  -t1.c) then 17 else c end-19+t1.e*13<= -(t1.a)),11)-t1.d-c FROM t1 WHERE ((t1.d in ((select +cast(avg(coalesce((select max(coalesce((select max(a) from t1 where not a in (b,~(select ~count(*) from t1),case (select +max(11) |  -count(*) from t1) when 17*t1.f*17 then b else (t1.b) end+f | 17)),e)) from t1 where not exists(select 1 from t1 where 17 between a and a)),(19))) AS integer) from t1),coalesce((select max(e) from t1 where t1.e<>11),b),t1.d)))"
    end, {
        -- <randexpr-2.80>
        -694
        -- </randexpr-2.80>
    })

test:do_test(
    "randexpr-2.81",
    function()
        return test:execsql "SELECT 17-coalesce((select c+t1.f from t1 where (select count(distinct d)-abs(min((select case  - -count(*) when  -max(19) then  -count(*) else count(*) end from t1))-count(*)) from t1)-t1.a+case when (abs(t1.e)/abs(t1.e)) not in (a,t1.a,19) and (b between 19 and  -t1.c) then 17 else c end-19+t1.e*13<= -(t1.a)),11)-t1.d-c FROM t1 WHERE NOT (((t1.d in ((select +cast(avg(coalesce((select max(coalesce((select max(a) from t1 where not a in (b,~(select ~count(*) from t1),case (select +max(11) |  -count(*) from t1) when 17*t1.f*17 then b else (t1.b) end+f | 17)),e)) from t1 where not exists(select 1 from t1 where 17 between a and a)),(19))) AS integer) from t1),coalesce((select max(e) from t1 where t1.e<>11),b),t1.d))))"
    end, {
        -- <randexpr-2.81>
        
        -- </randexpr-2.81>
    })

test:do_test(
    "randexpr-2.82",
    function()
        return test:execsql "SELECT case (t1.a) when e then t1.a else t1.d end+(b)*t1.c | (select ~count(distinct (select count(distinct t1.f) from t1)) from t1)* -case c*t1.b when 19 then t1.d else (t1.b) | case when not (e)*f in (select count(distinct a)-count(distinct c) | min(a) from t1 union select  -count(*) from t1) and (t1.f in (d, -t1.c,f)) then e when t1.c not in (t1.b,t1.e,b) then t1.e else f end end FROM t1 WHERE t1.d<>coalesce((select max(case when exists(select 1 from t1 where f<=e | b) then (select min(+t1.f) from t1) else 11 end) from t1 where +case when t1.e=c then  -t1.c else t1.a end-t1.a-11-f in (select (case  -min(a) when count(*)*(( -+abs(cast(avg(a) AS integer))*max((17))) | max(19)) then min(11) else min(a) end | count(distinct  -d)) from t1 union select min(t1.e) from t1)),t1.c)"
    end, {
        -- <randexpr-2.82>
        60408
        -- </randexpr-2.82>
    })

test:do_test(
    "randexpr-2.83",
    function()
        return test:execsql "SELECT case (t1.a) when e then t1.a else t1.d end+(b)*t1.c | (select ~count(distinct (select count(distinct t1.f) from t1)) from t1)* -case c*t1.b when 19 then t1.d else (t1.b) | case when not (e)*f in (select count(distinct a)-count(distinct c) | min(a) from t1 union select  -count(*) from t1) and (t1.f in (d, -t1.c,f)) then e when t1.c not in (t1.b,t1.e,b) then t1.e else f end end FROM t1 WHERE NOT (t1.d<>coalesce((select max(case when exists(select 1 from t1 where f<=e | b) then (select min(+t1.f) from t1) else 11 end) from t1 where +case when t1.e=c then  -t1.c else t1.a end-t1.a-11-f in (select (case  -min(a) when count(*)*(( -+abs(cast(avg(a) AS integer))*max((17))) | max(19)) then min(11) else min(a) end | count(distinct  -d)) from t1 union select min(t1.e) from t1)),t1.c))"
    end, {
        -- <randexpr-2.83>
        
        -- </randexpr-2.83>
    })

test:do_test(
    "randexpr-2.84",
    function()
        return test:execsql "SELECT case (t1.a) when e then t1.a else t1.d end+(b)*t1.c & (select ~count(distinct (select count(distinct t1.f) from t1)) from t1)* -case c*t1.b when 19 then t1.d else (t1.b) & case when not (e)*f in (select count(distinct a)-count(distinct c) & min(a) from t1 union select  -count(*) from t1) and (t1.f in (d, -t1.c,f)) then e when t1.c not in (t1.b,t1.e,b) then t1.e else f end end FROM t1 WHERE t1.d<>coalesce((select max(case when exists(select 1 from t1 where f<=e | b) then (select min(+t1.f) from t1) else 11 end) from t1 where +case when t1.e=c then  -t1.c else t1.a end-t1.a-11-f in (select (case  -min(a) when count(*)*(( -+abs(cast(avg(a) AS integer))*max((17))) | max(19)) then min(11) else min(a) end | count(distinct  -d)) from t1 union select min(t1.e) from t1)),t1.c)"
    end, {
        -- <randexpr-2.84>
        384
        -- </randexpr-2.84>
    })

test:do_test(
    "randexpr-2.85",
    function()
        return test:execsql "SELECT (select abs(max((select (case cast(avg(t1.a) AS integer) when +~abs(cast(avg( -17+case when t1.a in (c,(e),t1.f) and f in (c,t1.d,t1.a) then d when d between c and t1.d then f else e end) AS integer))-(abs(~max((b)))-min(t1.f)) then cast(avg(t1.f) AS integer) else count(*) end) from t1)+case when (exists(select 1 from t1 where t1.a in (select  -max(e) from t1 union select  -count(*) from t1)) or e in (t1.b*d,a, - -d)) then 17*t1.c else c end)) from t1) FROM t1 WHERE ~t1.e>case 13 when e then a else coalesce((select ~t1.d from t1 where exists(select 1 from t1 where t1.f between coalesce((select t1.a from t1 where ((select min(d-d- -t1.d+a) from t1)) not between f and t1.c or exists(select 1 from t1 where b<>17)),(a)) and  -d) or not exists(select 1 from t1 where e in (select min(19)*(count(*))*cast(avg(11) AS integer) | min(b) from t1 union select (cast(avg(t1.e) AS integer)) from t1))),c) end-t1.c"
    end, {
        -- <randexpr-2.85>
        
        -- </randexpr-2.85>
    })

test:do_test(
    "randexpr-2.86",
    function()
        return test:execsql "SELECT (select abs(max((select (case cast(avg(t1.a) AS integer) when +~abs(cast(avg( -17+case when t1.a in (c,(e),t1.f) and f in (c,t1.d,t1.a) then d when d between c and t1.d then f else e end) AS integer))-(abs(~max((b)))-min(t1.f)) then cast(avg(t1.f) AS integer) else count(*) end) from t1)+case when (exists(select 1 from t1 where t1.a in (select  -max(e) from t1 union select  -count(*) from t1)) or e in (t1.b*d,a, - -d)) then 17*t1.c else c end)) from t1) FROM t1 WHERE NOT (~t1.e>case 13 when e then a else coalesce((select ~t1.d from t1 where exists(select 1 from t1 where t1.f between coalesce((select t1.a from t1 where ((select min(d-d- -t1.d+a) from t1)) not between f and t1.c or exists(select 1 from t1 where b<>17)),(a)) and  -d) or not exists(select 1 from t1 where e in (select min(19)*(count(*))*cast(avg(11) AS integer) | min(b) from t1 union select (cast(avg(t1.e) AS integer)) from t1))),c) end-t1.c)"
    end, {
        -- <randexpr-2.86>
        301
        -- </randexpr-2.86>
    })

test:do_test(
    "randexpr-2.87",
    function()
        return test:execsql "SELECT t1.c+(abs(t1.b*t1.b)/abs(++t1.a-t1.e-(abs(t1.b)/abs(d))*11*t1.f)) | 19-b-t1.e | t1.e-+~t1.d*13+a+case case when (d)+17-c=d then a else t1.b end when e then t1.a else 19 end FROM t1 WHERE not coalesce((select (abs(case t1.b when coalesce((select case when exists(select 1 from t1 where f between 17 and f) then 11 else f end from t1 where not exists(select 1 from t1 where c>=t1.d)),17)*t1.a then t1.e else 13 end)/abs(17)) from t1 where ((13 in (select abs(~min(d)*count(distinct  -(f)) | count(*)*cast(avg(11) AS integer)) from t1 union select count(*) from t1) and a<=13) and c<> -(t1.c))), -t1.a)*t1.e*f+d not in (11,d,t1.c)"
    end, {
        -- <randexpr-2.87>
        
        -- </randexpr-2.87>
    })

test:do_test(
    "randexpr-2.88",
    function()
        return test:execsql "SELECT t1.c+(abs(t1.b*t1.b)/abs(++t1.a-t1.e-(abs(t1.b)/abs(d))*11*t1.f)) | 19-b-t1.e | t1.e-+~t1.d*13+a+case case when (d)+17-c=d then a else t1.b end when e then t1.a else 19 end FROM t1 WHERE NOT (not coalesce((select (abs(case t1.b when coalesce((select case when exists(select 1 from t1 where f between 17 and f) then 11 else f end from t1 where not exists(select 1 from t1 where c>=t1.d)),17)*t1.a then t1.e else 13 end)/abs(17)) from t1 where ((13 in (select abs(~min(d)*count(distinct  -(f)) | count(*)*cast(avg(11) AS integer)) from t1 union select count(*) from t1) and a<=13) and c<> -(t1.c))), -t1.a)*t1.e*f+d not in (11,d,t1.c))"
    end, {
        -- <randexpr-2.88>
        -33
        -- </randexpr-2.88>
    })

test:do_test(
    "randexpr-2.89",
    function()
        return test:execsql "SELECT t1.c+(abs(t1.b*t1.b)/abs(++t1.a-t1.e-(abs(t1.b)/abs(d))*11*t1.f)) & 19-b-t1.e & t1.e-+~t1.d*13+a+case case when (d)+17-c=d then a else t1.b end when e then t1.a else 19 end FROM t1 WHERE NOT (not coalesce((select (abs(case t1.b when coalesce((select case when exists(select 1 from t1 where f between 17 and f) then 11 else f end from t1 where not exists(select 1 from t1 where c>=t1.d)),17)*t1.a then t1.e else 13 end)/abs(17)) from t1 where ((13 in (select abs(~min(d)*count(distinct  -(f)) | count(*)*cast(avg(11) AS integer)) from t1 union select count(*) from t1) and a<=13) and c<> -(t1.c))), -t1.a)*t1.e*f+d not in (11,d,t1.c))"
    end, {
        -- <randexpr-2.89>
        0
        -- </randexpr-2.89>
    })

test:do_test(
    "randexpr-2.90",
    function()
        return test:execsql "SELECT case when t1.f>t1.d then (select abs(+count(distinct c)+(abs(min((abs(+11)/abs(b)))* -count(*)))) from t1)-t1.a when d+case when (select cast(avg(t1.f) AS integer)-count(distinct 19) from t1)<>17 then c when t1.e in (select cast(avg(t1.a) AS integer) from t1 union select count(distinct f) from t1) and d>t1.c and t1.f not in (11,19,t1.b) then a else (c) end+(17)=c then t1.d else t1.c end-c FROM t1 WHERE 13 not in (e,t1.b,+coalesce((select max(b) from t1 where 13*b-t1.d-case when 11>=a then t1.a-t1.d else (t1.d)*e+19 end*t1.a+19+(11) | t1.c*t1.a-17<t1.e),b)-a+17*17*c)"
    end, {
        -- <randexpr-2.90>
        -399
        -- </randexpr-2.90>
    })

test:do_test(
    "randexpr-2.91",
    function()
        return test:execsql "SELECT case when t1.f>t1.d then (select abs(+count(distinct c)+(abs(min((abs(+11)/abs(b)))* -count(*)))) from t1)-t1.a when d+case when (select cast(avg(t1.f) AS integer)-count(distinct 19) from t1)<>17 then c when t1.e in (select cast(avg(t1.a) AS integer) from t1 union select count(distinct f) from t1) and d>t1.c and t1.f not in (11,19,t1.b) then a else (c) end+(17)=c then t1.d else t1.c end-c FROM t1 WHERE NOT (13 not in (e,t1.b,+coalesce((select max(b) from t1 where 13*b-t1.d-case when 11>=a then t1.a-t1.d else (t1.d)*e+19 end*t1.a+19+(11) | t1.c*t1.a-17<t1.e),b)-a+17*17*c))"
    end, {
        -- <randexpr-2.91>
        
        -- </randexpr-2.91>
    })

test:do_test(
    "randexpr-2.92",
    function()
        return test:execsql "SELECT coalesce((select +19 from t1 where 19-c+t1.c-f not in (coalesce((select 19 from t1 where (t1.b between t1.c*t1.a*t1.b | a-e | 13-(abs(19)/abs((select max(t1.d | coalesce((select max( -t1.c) from t1 where b in (select e from t1 union select (f) from t1)),t1.d)+(e)) from t1)+c)) and f)),11),f,17)),f) FROM t1 WHERE (select count(distinct 11)+min((coalesce((select max(case when t1.d<>(abs(t1.a)/abs(e)) then d else ~(t1.e)-e+d+13-t1.b+b*19 end) from t1 where (select max(19)-cast(avg(a) AS integer) from t1)> -t1.e),17)+e+t1.e-t1.c+(c))*17) from t1) between  -17 and t1.c"
    end, {
        -- <randexpr-2.92>
        
        -- </randexpr-2.92>
    })

test:do_test(
    "randexpr-2.93",
    function()
        return test:execsql "SELECT coalesce((select +19 from t1 where 19-c+t1.c-f not in (coalesce((select 19 from t1 where (t1.b between t1.c*t1.a*t1.b | a-e | 13-(abs(19)/abs((select max(t1.d | coalesce((select max( -t1.c) from t1 where b in (select e from t1 union select (f) from t1)),t1.d)+(e)) from t1)+c)) and f)),11),f,17)),f) FROM t1 WHERE NOT ((select count(distinct 11)+min((coalesce((select max(case when t1.d<>(abs(t1.a)/abs(e)) then d else ~(t1.e)-e+d+13-t1.b+b*19 end) from t1 where (select max(19)-cast(avg(a) AS integer) from t1)> -t1.e),17)+e+t1.e-t1.c+(c))*17) from t1) between  -17 and t1.c)"
    end, {
        -- <randexpr-2.93>
        19
        -- </randexpr-2.93>
    })

test:do_test(
    "randexpr-2.94",
    function()
        return test:execsql "SELECT coalesce((select +19 from t1 where 19-c+t1.c-f not in (coalesce((select 19 from t1 where (t1.b between t1.c*t1.a*t1.b & a-e & 13-(abs(19)/abs((select max(t1.d & coalesce((select max( -t1.c) from t1 where b in (select e from t1 union select (f) from t1)),t1.d)+(e)) from t1)+c)) and f)),11),f,17)),f) FROM t1 WHERE NOT ((select count(distinct 11)+min((coalesce((select max(case when t1.d<>(abs(t1.a)/abs(e)) then d else ~(t1.e)-e+d+13-t1.b+b*19 end) from t1 where (select max(19)-cast(avg(a) AS integer) from t1)> -t1.e),17)+e+t1.e-t1.c+(c))*17) from t1) between  -17 and t1.c)"
    end, {
        -- <randexpr-2.94>
        19
        -- </randexpr-2.94>
    })

test:do_test(
    "randexpr-2.95",
    function()
        return test:execsql "SELECT (case t1.a when (select (count(distinct t1.f)) from t1)-e then 11 else t1.c+17-f*~f | f+~e-a*t1.b+13 end | 13) FROM t1 WHERE (coalesce((select max(f) from t1 where (c+t1.f | (select count(distinct t1.d) from t1)>=coalesce((select b+(abs(case when t1.f>=(select case max(f) when max(19) then cast(avg(t1.a) AS integer) else count(distinct 13) end from t1) | t1.b and (a in (select (b) from t1 union select t1.b from t1)) then (a)-b when not exists(select 1 from t1 where c between t1.c and t1.a) then a else t1.a end)/abs(t1.b))- -f from t1 where b not in (t1.b,t1.f,c)),t1.d)-t1.d)), -17) between 13 and t1.f)"
    end, {
        -- <randexpr-2.95>
        -19491
        -- </randexpr-2.95>
    })

test:do_test(
    "randexpr-2.96",
    function()
        return test:execsql "SELECT (case t1.a when (select (count(distinct t1.f)) from t1)-e then 11 else t1.c+17-f*~f | f+~e-a*t1.b+13 end | 13) FROM t1 WHERE NOT ((coalesce((select max(f) from t1 where (c+t1.f | (select count(distinct t1.d) from t1)>=coalesce((select b+(abs(case when t1.f>=(select case max(f) when max(19) then cast(avg(t1.a) AS integer) else count(distinct 13) end from t1) | t1.b and (a in (select (b) from t1 union select t1.b from t1)) then (a)-b when not exists(select 1 from t1 where c between t1.c and t1.a) then a else t1.a end)/abs(t1.b))- -f from t1 where b not in (t1.b,t1.f,c)),t1.d)-t1.d)), -17) between 13 and t1.f))"
    end, {
        -- <randexpr-2.96>
        
        -- </randexpr-2.96>
    })

test:do_test(
    "randexpr-2.97",
    function()
        return test:execsql "SELECT (case t1.a when (select (count(distinct t1.f)) from t1)-e then 11 else t1.c+17-f*~f & f+~e-a*t1.b+13 end & 13) FROM t1 WHERE (coalesce((select max(f) from t1 where (c+t1.f | (select count(distinct t1.d) from t1)>=coalesce((select b+(abs(case when t1.f>=(select case max(f) when max(19) then cast(avg(t1.a) AS integer) else count(distinct 13) end from t1) | t1.b and (a in (select (b) from t1 union select t1.b from t1)) then (a)-b when not exists(select 1 from t1 where c between t1.c and t1.a) then a else t1.a end)/abs(t1.b))- -f from t1 where b not in (t1.b,t1.f,c)),t1.d)-t1.d)), -17) between 13 and t1.f)"
    end, {
        -- <randexpr-2.97>
        0
        -- </randexpr-2.97>
    })

test:do_test(
    "randexpr-2.98",
    function()
        return test:execsql "SELECT case when ((select  -abs(min(coalesce((select max(11 | t1.f) from t1 where coalesce((select f from t1 where e+c in (select 19 from t1 union select f from t1)),b) not in (t1.a,+case when 13>=t1.e then t1.a when 17 not in (t1.d,b,t1.e) then 13 else t1.b end-t1.e,t1.f)),t1.f))*count(*)*min(t1.c)) from t1)<17) and 13* -f+a not between (a) and f then c-11+b else 19 end FROM t1 WHERE e+case case when a<>c then (abs(case when coalesce((select (abs( -19+11)/abs(t1.c)) from t1 where (17) in (a,13,11) and 17 in (select 11 from t1 union select t1.f from t1)),t1.a) between t1.f and c then t1.d when not exists(select 1 from t1 where not exists(select 1 from t1 where 19=f)) then f else (b) end-19)/abs(e)) else 11 end when 17 then a else t1.f end-13 | e between  -t1.e and 13"
    end, {
        -- <randexpr-2.98>
        
        -- </randexpr-2.98>
    })

test:do_test(
    "randexpr-2.99",
    function()
        return test:execsql "SELECT case when ((select  -abs(min(coalesce((select max(11 | t1.f) from t1 where coalesce((select f from t1 where e+c in (select 19 from t1 union select f from t1)),b) not in (t1.a,+case when 13>=t1.e then t1.a when 17 not in (t1.d,b,t1.e) then 13 else t1.b end-t1.e,t1.f)),t1.f))*count(*)*min(t1.c)) from t1)<17) and 13* -f+a not between (a) and f then c-11+b else 19 end FROM t1 WHERE NOT (e+case case when a<>c then (abs(case when coalesce((select (abs( -19+11)/abs(t1.c)) from t1 where (17) in (a,13,11) and 17 in (select 11 from t1 union select t1.f from t1)),t1.a) between t1.f and c then t1.d when not exists(select 1 from t1 where not exists(select 1 from t1 where 19=f)) then f else (b) end-19)/abs(e)) else 11 end when 17 then a else t1.f end-13 | e between  -t1.e and 13)"
    end, {
        -- <randexpr-2.99>
        489
        -- </randexpr-2.99>
    })

test:do_test(
    "randexpr-2.100",
    function()
        return test:execsql "SELECT case when ((select  -abs(min(coalesce((select max(11 & t1.f) from t1 where coalesce((select f from t1 where e+c in (select 19 from t1 union select f from t1)),b) not in (t1.a,+case when 13>=t1.e then t1.a when 17 not in (t1.d,b,t1.e) then 13 else t1.b end-t1.e,t1.f)),t1.f))*count(*)*min(t1.c)) from t1)<17) and 13* -f+a not between (a) and f then c-11+b else 19 end FROM t1 WHERE NOT (e+case case when a<>c then (abs(case when coalesce((select (abs( -19+11)/abs(t1.c)) from t1 where (17) in (a,13,11) and 17 in (select 11 from t1 union select t1.f from t1)),t1.a) between t1.f and c then t1.d when not exists(select 1 from t1 where not exists(select 1 from t1 where 19=f)) then f else (b) end-19)/abs(e)) else 11 end when 17 then a else t1.f end-13 | e between  -t1.e and 13)"
    end, {
        -- <randexpr-2.100>
        489
        -- </randexpr-2.100>
    })

test:do_test(
    "randexpr-2.101",
    function()
        return test:execsql "SELECT case when t1.b-t1.e*c<>c then coalesce((select  -17 from t1 where (t1.f+((select case count(*) when  -cast(avg(19) AS integer)+count(distinct (t1.c)) | (cast(avg(19) AS integer))*max(t1.c)*count(*)-((count(*))) then cast(avg(b) AS integer) else (count(*)) end-min(a) from t1)) | case when t1.b | a in (select t1.a from t1 union select (select count(distinct e) from t1) from t1) then t1.e else b end+t1.a)<e),17) else 19 end FROM t1 WHERE case  -coalesce((select d-+t1.d-13-b from t1 where case when not exists(select 1 from t1 where (t1.a-t1.f in (select t1.e from t1 union select 17 from t1)) or 19<=t1.a) then t1.c-b else b end in (select  -max(13)++abs(max(t1.c))*+max(t1.d) from t1 union select cast(avg(t1.e) AS integer) from t1)),13) | t1.d when (t1.f) then f else a end not between 11 and b"
    end, {
        -- <randexpr-2.101>
        
        -- </randexpr-2.101>
    })

test:do_test(
    "randexpr-2.102",
    function()
        return test:execsql "SELECT case when t1.b-t1.e*c<>c then coalesce((select  -17 from t1 where (t1.f+((select case count(*) when  -cast(avg(19) AS integer)+count(distinct (t1.c)) | (cast(avg(19) AS integer))*max(t1.c)*count(*)-((count(*))) then cast(avg(b) AS integer) else (count(*)) end-min(a) from t1)) | case when t1.b | a in (select t1.a from t1 union select (select count(distinct e) from t1) from t1) then t1.e else b end+t1.a)<e),17) else 19 end FROM t1 WHERE NOT (case  -coalesce((select d-+t1.d-13-b from t1 where case when not exists(select 1 from t1 where (t1.a-t1.f in (select t1.e from t1 union select 17 from t1)) or 19<=t1.a) then t1.c-b else b end in (select  -max(13)++abs(max(t1.c))*+max(t1.d) from t1 union select cast(avg(t1.e) AS integer) from t1)),13) | t1.d when (t1.f) then f else a end not between 11 and b)"
    end, {
        -- <randexpr-2.102>
        17
        -- </randexpr-2.102>
    })

test:do_test(
    "randexpr-2.103",
    function()
        return test:execsql "SELECT case when t1.b-t1.e*c<>c then coalesce((select  -17 from t1 where (t1.f+((select case count(*) when  -cast(avg(19) AS integer)+count(distinct (t1.c)) & (cast(avg(19) AS integer))*max(t1.c)*count(*)-((count(*))) then cast(avg(b) AS integer) else (count(*)) end-min(a) from t1)) & case when t1.b & a in (select t1.a from t1 union select (select count(distinct e) from t1) from t1) then t1.e else b end+t1.a)<e),17) else 19 end FROM t1 WHERE NOT (case  -coalesce((select d-+t1.d-13-b from t1 where case when not exists(select 1 from t1 where (t1.a-t1.f in (select t1.e from t1 union select 17 from t1)) or 19<=t1.a) then t1.c-b else b end in (select  -max(13)++abs(max(t1.c))*+max(t1.d) from t1 union select cast(avg(t1.e) AS integer) from t1)),13) | t1.d when (t1.f) then f else a end not between 11 and b)"
    end, {
        -- <randexpr-2.103>
        -17
        -- </randexpr-2.103>
    })

test:do_test(
    "randexpr-2.104",
    function()
        return test:execsql "SELECT coalesce((select max(case when (select ~cast(avg(a) AS integer) from t1)>~t1.a then f else +~11 end) from t1 where ((select case ~abs(count(distinct t1.e)+(count(*)+count(*)+(abs( -~count(*) | max((t1.b))))))*(cast(avg(t1.a) AS integer)) when (count(*)) then min(19) else  -(min(b)) end from t1))+11<>t1.f), -c-f) FROM t1 WHERE ~e>coalesce((select max(case case case coalesce((select max(coalesce((select c from t1 where t1.a-t1.c>13),13)) from t1 where  -b not in (case d when ~t1.f | t1.c then 13 else 11 end,19,19)),t1.d) when c then t1.a else t1.b end+f-e*b when f then 19 else  -t1.b end when t1.b then 11 else 13 end) from t1 where c in (select 19 from t1 union select e from t1)),t1.d)"
    end, {
        -- <randexpr-2.104>
        
        -- </randexpr-2.104>
    })

test:do_test(
    "randexpr-2.105",
    function()
        return test:execsql "SELECT coalesce((select max(case when (select ~cast(avg(a) AS integer) from t1)>~t1.a then f else +~11 end) from t1 where ((select case ~abs(count(distinct t1.e)+(count(*)+count(*)+(abs( -~count(*) | max((t1.b))))))*(cast(avg(t1.a) AS integer)) when (count(*)) then min(19) else  -(min(b)) end from t1))+11<>t1.f), -c-f) FROM t1 WHERE NOT (~e>coalesce((select max(case case case coalesce((select max(coalesce((select c from t1 where t1.a-t1.c>13),13)) from t1 where  -b not in (case d when ~t1.f | t1.c then 13 else 11 end,19,19)),t1.d) when c then t1.a else t1.b end+f-e*b when f then 19 else  -t1.b end when t1.b then 11 else 13 end) from t1 where c in (select 19 from t1 union select e from t1)),t1.d))"
    end, {
        -- <randexpr-2.105>
        -12
        -- </randexpr-2.105>
    })

test:do_test(
    "randexpr-2.106",
    function()
        return test:execsql "SELECT coalesce((select max(case when (select ~cast(avg(a) AS integer) from t1)>~t1.a then f else +~11 end) from t1 where ((select case ~abs(count(distinct t1.e)+(count(*)+count(*)+(abs( -~count(*) & max((t1.b))))))*(cast(avg(t1.a) AS integer)) when (count(*)) then min(19) else  -(min(b)) end from t1))+11<>t1.f), -c-f) FROM t1 WHERE NOT (~e>coalesce((select max(case case case coalesce((select max(coalesce((select c from t1 where t1.a-t1.c>13),13)) from t1 where  -b not in (case d when ~t1.f | t1.c then 13 else 11 end,19,19)),t1.d) when c then t1.a else t1.b end+f-e*b when f then 19 else  -t1.b end when t1.b then 11 else 13 end) from t1 where c in (select 19 from t1 union select e from t1)),t1.d))"
    end, {
        -- <randexpr-2.106>
        -12
        -- </randexpr-2.106>
    })

test:do_test(
    "randexpr-2.107",
    function()
        return test:execsql "SELECT coalesce((select a from t1 where b>=~11-coalesce((select max((abs(19)/abs(t1.e))+19+t1.d) from t1 where (select abs(count(*) | count(*) | case count(*) when cast(avg(17) AS integer) then  -cast(avg(b) AS integer) else count(*) end*min(b))*(min(t1.e)) from t1) in (11*(select count(*) from t1)*17*t1.e-e*t1.b,t1.e,t1.f)),a)*t1.d),13)-f FROM t1 WHERE ~((case when not 13-+t1.c>=17 then  -~ -b+t1.f+case when t1.c<t1.b then t1.b when e*t1.b in (c,f,19) then (abs(a)/abs(case when 13=e then t1.e when  -a<>t1.d then 11 else t1.e end)) else t1.b end when d>a then (a) else t1.b end))+t1.c in (13,t1.a,13) or t1.e>c"
    end, {
        -- <randexpr-2.107>
        -500
        -- </randexpr-2.107>
    })

test:do_test(
    "randexpr-2.108",
    function()
        return test:execsql "SELECT coalesce((select a from t1 where b>=~11-coalesce((select max((abs(19)/abs(t1.e))+19+t1.d) from t1 where (select abs(count(*) | count(*) | case count(*) when cast(avg(17) AS integer) then  -cast(avg(b) AS integer) else count(*) end*min(b))*(min(t1.e)) from t1) in (11*(select count(*) from t1)*17*t1.e-e*t1.b,t1.e,t1.f)),a)*t1.d),13)-f FROM t1 WHERE NOT (~((case when not 13-+t1.c>=17 then  -~ -b+t1.f+case when t1.c<t1.b then t1.b when e*t1.b in (c,f,19) then (abs(a)/abs(case when 13=e then t1.e when  -a<>t1.d then 11 else t1.e end)) else t1.b end when d>a then (a) else t1.b end))+t1.c in (13,t1.a,13) or t1.e>c)"
    end, {
        -- <randexpr-2.108>
        
        -- </randexpr-2.108>
    })

test:do_test(
    "randexpr-2.109",
    function()
        return test:execsql "SELECT coalesce((select a from t1 where b>=~11-coalesce((select max((abs(19)/abs(t1.e))+19+t1.d) from t1 where (select abs(count(*) & count(*) & case count(*) when cast(avg(17) AS integer) then  -cast(avg(b) AS integer) else count(*) end*min(b))*(min(t1.e)) from t1) in (11*(select count(*) from t1)*17*t1.e-e*t1.b,t1.e,t1.f)),a)*t1.d),13)-f FROM t1 WHERE ~((case when not 13-+t1.c>=17 then  -~ -b+t1.f+case when t1.c<t1.b then t1.b when e*t1.b in (c,f,19) then (abs(a)/abs(case when 13=e then t1.e when  -a<>t1.d then 11 else t1.e end)) else t1.b end when d>a then (a) else t1.b end))+t1.c in (13,t1.a,13) or t1.e>c"
    end, {
        -- <randexpr-2.109>
        -500
        -- </randexpr-2.109>
    })

test:do_test(
    "randexpr-2.110",
    function()
        return test:execsql "SELECT case when 13>=~t1.a or (exists(select 1 from t1 where 11 not in (17,t1.f,17))) then f when not exists(select 1 from t1 where exists(select 1 from t1 where 13 not between e and ~+case b when t1.f then case  -case f when 11 then  -17 else 19 end+17 when b then b else 13 end else 13 end- -t1.a and t1.c not in (t1.f,a,c) or t1.f<11)) then t1.c else 11 end FROM t1 WHERE +t1.e in (select cast(avg(t1.c*t1.a*(abs(13)/abs(t1.e))) AS integer) from t1 union select min(c+13) from t1)"
    end, {
        -- <randexpr-2.110>
        
        -- </randexpr-2.110>
    })

test:do_test(
    "randexpr-2.111",
    function()
        return test:execsql "SELECT case when 13>=~t1.a or (exists(select 1 from t1 where 11 not in (17,t1.f,17))) then f when not exists(select 1 from t1 where exists(select 1 from t1 where 13 not between e and ~+case b when t1.f then case  -case f when 11 then  -17 else 19 end+17 when b then b else 13 end else 13 end- -t1.a and t1.c not in (t1.f,a,c) or t1.f<11)) then t1.c else 11 end FROM t1 WHERE NOT (+t1.e in (select cast(avg(t1.c*t1.a*(abs(13)/abs(t1.e))) AS integer) from t1 union select min(c+13) from t1))"
    end, {
        -- <randexpr-2.111>
        600
        -- </randexpr-2.111>
    })

test:do_test(
    "randexpr-2.112",
    function()
        return test:execsql "SELECT case when coalesce((select max(13) from t1 where coalesce((select max(c) from t1 where coalesce((select max(17) from t1 where 11 in (select ~d | case when t1.a>+19 then 11 when t1.d not in ( -e,e,c) or 13<t1.c then t1.b else d end-t1.d from t1 union select e from t1)),t1.b) in (select e from t1 union select c from t1)),d)<>d or t1.e<>b),t1.b)*13<=f then  -t1.e when 19 between  -t1.f and t1.a then  -t1.b else t1.f end FROM t1 WHERE exists(select 1 from t1 where t1.f between a and coalesce((select max(t1.f) from t1 where exists(select 1 from t1 where coalesce((select 19 from t1 where t1.c=b),a)= -t1.b and not exists(select 1 from t1 where b between e and b) and a<= -17 or exists(select 1 from t1 where 17<=f)) or t1.a>=t1.c),13)*~13*t1.c*13 or t1.d>13 and 11>=t1.d and 11 not between c and c and t1.f>=17 and (d)=f)"
    end, {
        -- <randexpr-2.112>
        
        -- </randexpr-2.112>
    })

test:do_test(
    "randexpr-2.113",
    function()
        return test:execsql "SELECT case when coalesce((select max(13) from t1 where coalesce((select max(c) from t1 where coalesce((select max(17) from t1 where 11 in (select ~d | case when t1.a>+19 then 11 when t1.d not in ( -e,e,c) or 13<t1.c then t1.b else d end-t1.d from t1 union select e from t1)),t1.b) in (select e from t1 union select c from t1)),d)<>d or t1.e<>b),t1.b)*13<=f then  -t1.e when 19 between  -t1.f and t1.a then  -t1.b else t1.f end FROM t1 WHERE NOT (exists(select 1 from t1 where t1.f between a and coalesce((select max(t1.f) from t1 where exists(select 1 from t1 where coalesce((select 19 from t1 where t1.c=b),a)= -t1.b and not exists(select 1 from t1 where b between e and b) and a<= -17 or exists(select 1 from t1 where 17<=f)) or t1.a>=t1.c),13)*~13*t1.c*13 or t1.d>13 and 11>=t1.d and 11 not between c and c and t1.f>=17 and (d)=f))"
    end, {
        -- <randexpr-2.113>
        -500
        -- </randexpr-2.113>
    })

test:do_test(
    "randexpr-2.114",
    function()
        return test:execsql "SELECT case when coalesce((select max(13) from t1 where coalesce((select max(c) from t1 where coalesce((select max(17) from t1 where 11 in (select ~d & case when t1.a>+19 then 11 when t1.d not in ( -e,e,c) or 13<t1.c then t1.b else d end-t1.d from t1 union select e from t1)),t1.b) in (select e from t1 union select c from t1)),d)<>d or t1.e<>b),t1.b)*13<=f then  -t1.e when 19 between  -t1.f and t1.a then  -t1.b else t1.f end FROM t1 WHERE NOT (exists(select 1 from t1 where t1.f between a and coalesce((select max(t1.f) from t1 where exists(select 1 from t1 where coalesce((select 19 from t1 where t1.c=b),a)= -t1.b and not exists(select 1 from t1 where b between e and b) and a<= -17 or exists(select 1 from t1 where 17<=f)) or t1.a>=t1.c),13)*~13*t1.c*13 or t1.d>13 and 11>=t1.d and 11 not between c and c and t1.f>=17 and (d)=f))"
    end, {
        -- <randexpr-2.114>
        -500
        -- </randexpr-2.114>
    })

test:do_test(
    "randexpr-2.115",
    function()
        return test:execsql "SELECT case when coalesce((select +case when not exists(select 1 from t1 where 19*t1.e< -~11*a or t1.b>=t1.c and t1.a<>e) then coalesce((select max(13) from t1 where 11>11), -(e)) | t1.a when (t1.d) in (select f from t1 union select b from t1) then a else e end from t1 where t1.f<> -t1.d),t1.b) not in (d,t1.d,t1.c) then 19 when (t1.b<>t1.e or  -t1.b>=t1.b) then (f) else d end FROM t1 WHERE t1.e=a and b>=(abs(case when 19 not between ~+17 and +case when ((b+e-f=t1.d or b not in (t1.a,t1.f,t1.b) or t1.a not between 19 and e or b>=(t1.d) or t1.b not in (d,t1.a,t1.b))) then e-f else t1.e*t1.f end | f then d else  -d end)/abs(11))"
    end, {
        -- <randexpr-2.115>
        
        -- </randexpr-2.115>
    })

test:do_test(
    "randexpr-2.116",
    function()
        return test:execsql "SELECT case when coalesce((select +case when not exists(select 1 from t1 where 19*t1.e< -~11*a or t1.b>=t1.c and t1.a<>e) then coalesce((select max(13) from t1 where 11>11), -(e)) | t1.a when (t1.d) in (select f from t1 union select b from t1) then a else e end from t1 where t1.f<> -t1.d),t1.b) not in (d,t1.d,t1.c) then 19 when (t1.b<>t1.e or  -t1.b>=t1.b) then (f) else d end FROM t1 WHERE NOT (t1.e=a and b>=(abs(case when 19 not between ~+17 and +case when ((b+e-f=t1.d or b not in (t1.a,t1.f,t1.b) or t1.a not between 19 and e or b>=(t1.d) or t1.b not in (d,t1.a,t1.b))) then e-f else t1.e*t1.f end | f then d else  -d end)/abs(11)))"
    end, {
        -- <randexpr-2.116>
        19
        -- </randexpr-2.116>
    })

test:do_test(
    "randexpr-2.117",
    function()
        return test:execsql "SELECT case when coalesce((select +case when not exists(select 1 from t1 where 19*t1.e< -~11*a or t1.b>=t1.c and t1.a<>e) then coalesce((select max(13) from t1 where 11>11), -(e)) & t1.a when (t1.d) in (select f from t1 union select b from t1) then a else e end from t1 where t1.f<> -t1.d),t1.b) not in (d,t1.d,t1.c) then 19 when (t1.b<>t1.e or  -t1.b>=t1.b) then (f) else d end FROM t1 WHERE NOT (t1.e=a and b>=(abs(case when 19 not between ~+17 and +case when ((b+e-f=t1.d or b not in (t1.a,t1.f,t1.b) or t1.a not between 19 and e or b>=(t1.d) or t1.b not in (d,t1.a,t1.b))) then e-f else t1.e*t1.f end | f then d else  -d end)/abs(11)))"
    end, {
        -- <randexpr-2.117>
        19
        -- </randexpr-2.117>
    })

test:do_test(
    "randexpr-2.118",
    function()
        return test:execsql "SELECT (select (cast(avg(b) AS integer) | count(distinct case when coalesce((select 13 from t1 where (+(abs(e)/abs(t1.b))) in ( -b, -(a),13)),t1.e)>=b then 11 else  - -19 end-17+19) | abs(~case count(distinct t1.b) when +min(e) then +abs(~ - -count(distinct 11)-count(distinct t1.b))-count(distinct a) else  -min(b) end)*count(distinct 19)-count(distinct t1.b)) from t1) FROM t1 WHERE 11<=t1.a-t1.f-19*t1.b+19+coalesce((select e from t1 where d not between (select count(distinct coalesce((select t1.a from t1 where (select cast(avg(t1.e) AS integer)-+count(distinct c)+max((abs(t1.c)/abs(t1.f))-a)-(count(*)-cast(avg((17)) AS integer)) from t1) in (t1.e, -e | d,b)),c)) from t1) and t1.a),t1.d)-t1.d"
    end, {
        -- <randexpr-2.118>
        
        -- </randexpr-2.118>
    })

test:do_test(
    "randexpr-2.119",
    function()
        return test:execsql "SELECT (select (cast(avg(b) AS integer) | count(distinct case when coalesce((select 13 from t1 where (+(abs(e)/abs(t1.b))) in ( -b, -(a),13)),t1.e)>=b then 11 else  - -19 end-17+19) | abs(~case count(distinct t1.b) when +min(e) then +abs(~ - -count(distinct 11)-count(distinct t1.b))-count(distinct a) else  -min(b) end)*count(distinct 19)-count(distinct t1.b)) from t1) FROM t1 WHERE NOT (11<=t1.a-t1.f-19*t1.b+19+coalesce((select e from t1 where d not between (select count(distinct coalesce((select t1.a from t1 where (select cast(avg(t1.e) AS integer)-+count(distinct c)+max((abs(t1.c)/abs(t1.f))-a)-(count(*)-cast(avg((17)) AS integer)) from t1) in (t1.e, -e | d,b)),c)) from t1) and t1.a),t1.d)-t1.d)"
    end, {
        -- <randexpr-2.119>
        207
        -- </randexpr-2.119>
    })

test:do_test(
    "randexpr-2.120",
    function()
        return test:execsql "SELECT (select (cast(avg(b) AS integer) & count(distinct case when coalesce((select 13 from t1 where (+(abs(e)/abs(t1.b))) in ( -b, -(a),13)),t1.e)>=b then 11 else  - -19 end-17+19) & abs(~case count(distinct t1.b) when +min(e) then +abs(~ - -count(distinct 11)-count(distinct t1.b))-count(distinct a) else  -min(b) end)*count(distinct 19)-count(distinct t1.b)) from t1) FROM t1 WHERE NOT (11<=t1.a-t1.f-19*t1.b+19+coalesce((select e from t1 where d not between (select count(distinct coalesce((select t1.a from t1 where (select cast(avg(t1.e) AS integer)-+count(distinct c)+max((abs(t1.c)/abs(t1.f))-a)-(count(*)-cast(avg((17)) AS integer)) from t1) in (t1.e, -e | d,b)),c)) from t1) and t1.a),t1.d)-t1.d)"
    end, {
        -- <randexpr-2.120>
        0
        -- </randexpr-2.120>
    })

test:do_test(
    "randexpr-2.121",
    function()
        return test:execsql "SELECT 11+a*case t1.a*t1.e when 17 then coalesce((select +t1.b from t1 where t1.c<>t1.c and e between +(abs(case b+f*coalesce((select c from t1 where t1.d>17), -t1.c)+(19) when b then t1.f else t1.d end)/abs(t1.d)) and t1.c and t1.a>b or t1.f<t1.a),t1.c)*17 else  -t1.d end*t1.b FROM t1 WHERE  -19-~t1.b<(select ~count(*) from t1)+(abs(++coalesce((select max(t1.a-c) from t1 where t1.a=11),11))/abs(case when not not exists(select 1 from t1 where exists(select 1 from t1 where t1.a>c or t1.d | 11 in (select t1.e from t1 union select d from t1))) then 17 else (abs(coalesce((select max(f) from t1 where not (c)<t1.a),t1.b))/abs(d))+f end-t1.c))-t1.e-t1.e"
    end, {
        -- <randexpr-2.121>
        
        -- </randexpr-2.121>
    })

test:do_test(
    "randexpr-2.122",
    function()
        return test:execsql "SELECT 11+a*case t1.a*t1.e when 17 then coalesce((select +t1.b from t1 where t1.c<>t1.c and e between +(abs(case b+f*coalesce((select c from t1 where t1.d>17), -t1.c)+(19) when b then t1.f else t1.d end)/abs(t1.d)) and t1.c and t1.a>b or t1.f<t1.a),t1.c)*17 else  -t1.d end*t1.b FROM t1 WHERE NOT ( -19-~t1.b<(select ~count(*) from t1)+(abs(++coalesce((select max(t1.a-c) from t1 where t1.a=11),11))/abs(case when not not exists(select 1 from t1 where exists(select 1 from t1 where t1.a>c or t1.d | 11 in (select t1.e from t1 union select d from t1))) then 17 else (abs(coalesce((select max(f) from t1 where not (c)<t1.a),t1.b))/abs(d))+f end-t1.c))-t1.e-t1.e)"
    end, {
        -- <randexpr-2.122>
        -7999989
        -- </randexpr-2.122>
    })

test:do_test(
    "randexpr-2.123",
    function()
        return test:execsql "SELECT (e)+case when t1.a>e then t1.f else t1.b+case when b between coalesce((select max(t1.d-~(abs(a)/abs(c))+t1.c) from t1 where f in (select  -min(t1.f)-+cast(avg(e) AS integer) from t1 union select  -(cast(avg(13) AS integer)) from t1) and f<=a and not exists(select 1 from t1 where f not between t1.d and t1.d or (f)<=a) and (t1.f) between 11 and d),t1.a) and t1.f then e when (11<d) then 11 else d end end | t1.e FROM t1 WHERE (abs(13)/abs(a)) in (+coalesce((select 13 from t1 where (t1.e in (select cast(avg(t1.c) AS integer) from t1 union select case +count(distinct t1.c) when +count(*) then ( -min( -b)) else count(*) end*max(e) from t1)) and +case when c in (select (11) from t1 union select  -t1.c from t1) then 17 when 17 in (select 17 from t1 union select d from t1) then c else t1.a end>13),case when c<=11 then t1.e when t1.e<=b then t1.d else t1.e end)-11,11,17)"
    end, {
        -- <randexpr-2.123>
        
        -- </randexpr-2.123>
    })

test:do_test(
    "randexpr-2.124",
    function()
        return test:execsql "SELECT (e)+case when t1.a>e then t1.f else t1.b+case when b between coalesce((select max(t1.d-~(abs(a)/abs(c))+t1.c) from t1 where f in (select  -min(t1.f)-+cast(avg(e) AS integer) from t1 union select  -(cast(avg(13) AS integer)) from t1) and f<=a and not exists(select 1 from t1 where f not between t1.d and t1.d or (f)<=a) and (t1.f) between 11 and d),t1.a) and t1.f then e when (11<d) then 11 else d end end | t1.e FROM t1 WHERE NOT ((abs(13)/abs(a)) in (+coalesce((select 13 from t1 where (t1.e in (select cast(avg(t1.c) AS integer) from t1 union select case +count(distinct t1.c) when +count(*) then ( -min( -b)) else count(*) end*max(e) from t1)) and +case when c in (select (11) from t1 union select  -t1.c from t1) then 17 when 17 in (select 17 from t1 union select d from t1) then c else t1.a end>13),case when c<=11 then t1.e when t1.e<=b then t1.d else t1.e end)-11,11,17))"
    end, {
        -- <randexpr-2.124>
        1524
        -- </randexpr-2.124>
    })

test:do_test(
    "randexpr-2.125",
    function()
        return test:execsql "SELECT (e)+case when t1.a>e then t1.f else t1.b+case when b between coalesce((select max(t1.d-~(abs(a)/abs(c))+t1.c) from t1 where f in (select  -min(t1.f)-+cast(avg(e) AS integer) from t1 union select  -(cast(avg(13) AS integer)) from t1) and f<=a and not exists(select 1 from t1 where f not between t1.d and t1.d or (f)<=a) and (t1.f) between 11 and d),t1.a) and t1.f then e when (11<d) then 11 else d end end & t1.e FROM t1 WHERE NOT ((abs(13)/abs(a)) in (+coalesce((select 13 from t1 where (t1.e in (select cast(avg(t1.c) AS integer) from t1 union select case +count(distinct t1.c) when +count(*) then ( -min( -b)) else count(*) end*max(e) from t1)) and +case when c in (select (11) from t1 union select  -t1.c from t1) then 17 when 17 in (select 17 from t1 union select d from t1) then c else t1.a end>13),case when c<=11 then t1.e when t1.e<=b then t1.d else t1.e end)-11,11,17))"
    end, {
        -- <randexpr-2.125>
        176
        -- </randexpr-2.125>
    })

test:do_test(
    "randexpr-2.126",
    function()
        return test:execsql "SELECT coalesce((select max(~d-t1.f+b-13) from t1 where t1.c not between case when +f=t1.b then 13 when ~f not in (~t1.a,coalesce((select max(t1.b) from t1 where b between c-t1.c+e and (t1.b)),coalesce((select max(t1.d) from t1 where not e in (select 17 from t1 union select t1.c+e | a from t1)),b)),t1.e) then t1.b else a end and c),t1.a) FROM t1 WHERE (select (++ -count(*) | cast(avg(t1.b) AS integer) | ++(max(t1.d))+count(*)+max(t1.b)-count(distinct t1.e)-+abs( -+~max((abs(t1.c)/abs((select min(a) from t1)))))+count(distinct t1.a-t1.b)) from t1) between e and c"
    end, {
        -- <randexpr-2.126>
        
        -- </randexpr-2.126>
    })

test:do_test(
    "randexpr-2.127",
    function()
        return test:execsql "SELECT coalesce((select max(~d-t1.f+b-13) from t1 where t1.c not between case when +f=t1.b then 13 when ~f not in (~t1.a,coalesce((select max(t1.b) from t1 where b between c-t1.c+e and (t1.b)),coalesce((select max(t1.d) from t1 where not e in (select 17 from t1 union select t1.c+e | a from t1)),b)),t1.e) then t1.b else a end and c),t1.a) FROM t1 WHERE NOT ((select (++ -count(*) | cast(avg(t1.b) AS integer) | ++(max(t1.d))+count(*)+max(t1.b)-count(distinct t1.e)-+abs( -+~max((abs(t1.c)/abs((select min(a) from t1)))))+count(distinct t1.a-t1.b)) from t1) between e and c)"
    end, {
        -- <randexpr-2.127>
        100
        -- </randexpr-2.127>
    })

test:do_test(
    "randexpr-2.128",
    function()
        return test:execsql "SELECT coalesce((select max(~d-t1.f+b-13) from t1 where t1.c not between case when +f=t1.b then 13 when ~f not in (~t1.a,coalesce((select max(t1.b) from t1 where b between c-t1.c+e and (t1.b)),coalesce((select max(t1.d) from t1 where not e in (select 17 from t1 union select t1.c+e & a from t1)),b)),t1.e) then t1.b else a end and c),t1.a) FROM t1 WHERE NOT ((select (++ -count(*) | cast(avg(t1.b) AS integer) | ++(max(t1.d))+count(*)+max(t1.b)-count(distinct t1.e)-+abs( -+~max((abs(t1.c)/abs((select min(a) from t1)))))+count(distinct t1.a-t1.b)) from t1) between e and c)"
    end, {
        -- <randexpr-2.128>
        100
        -- </randexpr-2.128>
    })

test:do_test(
    "randexpr-2.129",
    function()
        return test:execsql "SELECT a+case when exists(select 1 from t1 where 19>=e) then b*b+coalesce((select max( -coalesce((select max(19 | t1.e) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where +case t1.a when a then a else (17) end*19 in (select max(d) from t1 union select max(t1.a) from t1) and not exists(select 1 from t1 where t1.a<=11)) or 11>(19))),11* -a)) from t1 where t1.e<>17),f) else t1.e end-11 FROM t1 WHERE (t1.a>=(abs(coalesce((select +13*t1.a | c from t1 where 11+case when exists(select 1 from t1 where case when +t1.d in (select case +count(*) when count(distinct 11) then count(*) else (min(11)) end from t1 union select max( -11) from t1) or 11<> -t1.f then t1.d when t1.b in (13,a,d) then c else c end+t1.b=b) then e-c else (t1.d) end>t1.d),d))/abs(t1.f)) and 11 in (select  -t1.a from t1 union select 13 from t1))"
    end, {
        -- <randexpr-2.129>
        
        -- </randexpr-2.129>
    })

test:do_test(
    "randexpr-2.130",
    function()
        return test:execsql "SELECT a+case when exists(select 1 from t1 where 19>=e) then b*b+coalesce((select max( -coalesce((select max(19 | t1.e) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where +case t1.a when a then a else (17) end*19 in (select max(d) from t1 union select max(t1.a) from t1) and not exists(select 1 from t1 where t1.a<=11)) or 11>(19))),11* -a)) from t1 where t1.e<>17),f) else t1.e end-11 FROM t1 WHERE NOT ((t1.a>=(abs(coalesce((select +13*t1.a | c from t1 where 11+case when exists(select 1 from t1 where case when +t1.d in (select case +count(*) when count(distinct 11) then count(*) else (min(11)) end from t1 union select max( -11) from t1) or 11<> -t1.f then t1.d when t1.b in (13,a,d) then c else c end+t1.b=b) then e-c else (t1.d) end>t1.d),d))/abs(t1.f)) and 11 in (select  -t1.a from t1 union select 13 from t1)))"
    end, {
        -- <randexpr-2.130>
        589
        -- </randexpr-2.130>
    })

test:do_test(
    "randexpr-2.131",
    function()
        return test:execsql "SELECT a+case when exists(select 1 from t1 where 19>=e) then b*b+coalesce((select max( -coalesce((select max(19 & t1.e) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where +case t1.a when a then a else (17) end*19 in (select max(d) from t1 union select max(t1.a) from t1) and not exists(select 1 from t1 where t1.a<=11)) or 11>(19))),11* -a)) from t1 where t1.e<>17),f) else t1.e end-11 FROM t1 WHERE NOT ((t1.a>=(abs(coalesce((select +13*t1.a | c from t1 where 11+case when exists(select 1 from t1 where case when +t1.d in (select case +count(*) when count(distinct 11) then count(*) else (min(11)) end from t1 union select max( -11) from t1) or 11<> -t1.f then t1.d when t1.b in (13,a,d) then c else c end+t1.b=b) then e-c else (t1.d) end>t1.d),d))/abs(t1.f)) and 11 in (select  -t1.a from t1 union select 13 from t1)))"
    end, {
        -- <randexpr-2.131>
        589
        -- </randexpr-2.131>
    })

test:do_test(
    "randexpr-2.132",
    function()
        return test:execsql "SELECT case ~13 when t1.e then e else (select case case (abs(count(*))-~count(*)+count(*) | count(*)-count(*)+max(t1.b)* -(cast(avg(13) AS integer)) |  -(count(distinct t1.c))) when min(e) then (min(13)) else count(*) end*count(*) when max(e) then count(distinct  -d) else count(*) end from t1) end-t1.d*case (abs(e | t1.b)/abs((select cast(avg(t1.c) AS integer) from t1))) when (select cast(avg(a) AS integer) from t1) then t1.c else f+13 end FROM t1 WHERE not exists(select 1 from t1 where coalesce((select case when t1.a>t1.f-~case when ~t1.d+c+t1.f>11 then t1.a when (f between t1.f and t1.c) then t1.f else 13 end*t1.a then t1.d when c<t1.e or e>19 then c else t1.e end from t1 where e<>a and 19<>t1.f),t1.b)+t1.f-t1.e<d)"
    end, {
        -- <randexpr-2.132>
        -245199
        -- </randexpr-2.132>
    })

test:do_test(
    "randexpr-2.133",
    function()
        return test:execsql "SELECT case ~13 when t1.e then e else (select case case (abs(count(*))-~count(*)+count(*) | count(*)-count(*)+max(t1.b)* -(cast(avg(13) AS integer)) |  -(count(distinct t1.c))) when min(e) then (min(13)) else count(*) end*count(*) when max(e) then count(distinct  -d) else count(*) end from t1) end-t1.d*case (abs(e | t1.b)/abs((select cast(avg(t1.c) AS integer) from t1))) when (select cast(avg(a) AS integer) from t1) then t1.c else f+13 end FROM t1 WHERE NOT (not exists(select 1 from t1 where coalesce((select case when t1.a>t1.f-~case when ~t1.d+c+t1.f>11 then t1.a when (f between t1.f and t1.c) then t1.f else 13 end*t1.a then t1.d when c<t1.e or e>19 then c else t1.e end from t1 where e<>a and 19<>t1.f),t1.b)+t1.f-t1.e<d))"
    end, {
        -- <randexpr-2.133>
        
        -- </randexpr-2.133>
    })

test:do_test(
    "randexpr-2.134",
    function()
        return test:execsql "SELECT case ~13 when t1.e then e else (select case case (abs(count(*))-~count(*)+count(*) & count(*)-count(*)+max(t1.b)* -(cast(avg(13) AS integer)) &  -(count(distinct t1.c))) when min(e) then (min(13)) else count(*) end*count(*) when max(e) then count(distinct  -d) else count(*) end from t1) end-t1.d*case (abs(e & t1.b)/abs((select cast(avg(t1.c) AS integer) from t1))) when (select cast(avg(a) AS integer) from t1) then t1.c else f+13 end FROM t1 WHERE not exists(select 1 from t1 where coalesce((select case when t1.a>t1.f-~case when ~t1.d+c+t1.f>11 then t1.a when (f between t1.f and t1.c) then t1.f else 13 end*t1.a then t1.d when c<t1.e or e>19 then c else t1.e end from t1 where e<>a and 19<>t1.f),t1.b)+t1.f-t1.e<d)"
    end, {
        -- <randexpr-2.134>
        -245199
        -- </randexpr-2.134>
    })

test:do_test(
    "randexpr-2.135",
    function()
        return test:execsql "SELECT 11-case when 17<=c and (select ( -abs(case count(*)+~case  -min(e) when count(distinct t1.a) then  -count(*) else min(a) end+max(t1.c) when count(*) then max(b) else  -count(distinct 19) end)*cast(avg(17) AS integer)) from t1) not in (case f when e then 19 | 11 else (t1.d) end,d, -t1.b) then +t1.c when t1.d not in (11,c,t1.a) then 13 else a end-t1.d*t1.d FROM t1 WHERE ((abs((abs(coalesce((select a from t1 where (select max(case when t1.f=b then e when 11>t1.c and 11<>e then 13 else a end-(a))-max(t1.e)*count(distinct t1.f) | case max((f)) when (count(distinct f)) then count(*) else min(t1.c) end+min(19) from t1) not in (11,19,t1.e)),t1.f*17))/abs(a)))/abs(c)) in (select t1.c from t1 union select t1.a from t1)) or ( -t1.f=e)"
    end, {
        -- <randexpr-2.135>
        
        -- </randexpr-2.135>
    })

test:do_test(
    "randexpr-2.136",
    function()
        return test:execsql "SELECT 11-case when 17<=c and (select ( -abs(case count(*)+~case  -min(e) when count(distinct t1.a) then  -count(*) else min(a) end+max(t1.c) when count(*) then max(b) else  -count(distinct 19) end)*cast(avg(17) AS integer)) from t1) not in (case f when e then 19 | 11 else (t1.d) end,d, -t1.b) then +t1.c when t1.d not in (11,c,t1.a) then 13 else a end-t1.d*t1.d FROM t1 WHERE NOT (((abs((abs(coalesce((select a from t1 where (select max(case when t1.f=b then e when 11>t1.c and 11<>e then 13 else a end-(a))-max(t1.e)*count(distinct t1.f) | case max((f)) when (count(distinct f)) then count(*) else min(t1.c) end+min(19) from t1) not in (11,19,t1.e)),t1.f*17))/abs(a)))/abs(c)) in (select t1.c from t1 union select t1.a from t1)) or ( -t1.f=e))"
    end, {
        -- <randexpr-2.136>
        -160289
        -- </randexpr-2.136>
    })

test:do_test(
    "randexpr-2.137",
    function()
        return test:execsql "SELECT 11-case when 17<=c and (select ( -abs(case count(*)+~case  -min(e) when count(distinct t1.a) then  -count(*) else min(a) end+max(t1.c) when count(*) then max(b) else  -count(distinct 19) end)*cast(avg(17) AS integer)) from t1) not in (case f when e then 19 & 11 else (t1.d) end,d, -t1.b) then +t1.c when t1.d not in (11,c,t1.a) then 13 else a end-t1.d*t1.d FROM t1 WHERE NOT (((abs((abs(coalesce((select a from t1 where (select max(case when t1.f=b then e when 11>t1.c and 11<>e then 13 else a end-(a))-max(t1.e)*count(distinct t1.f) | case max((f)) when (count(distinct f)) then count(*) else min(t1.c) end+min(19) from t1) not in (11,19,t1.e)),t1.f*17))/abs(a)))/abs(c)) in (select t1.c from t1 union select t1.a from t1)) or ( -t1.f=e))"
    end, {
        -- <randexpr-2.137>
        -160289
        -- </randexpr-2.137>
    })

test:do_test(
    "randexpr-2.138",
    function()
        return test:execsql "SELECT (f+case +t1.e when t1.d then 17 else f*19 end |  -(abs( -coalesce((select 17* -c+19 from t1 where (abs(case 19*e*d when (select +(cast(avg( -11) AS integer)) |  -count(*)*max( -13) from t1) then 11 | case t1.b when a then a else t1.f end else t1.a end)/abs(a)) in (select t1.b from t1 union select (a) from t1)),t1.b))/abs( -13))) FROM t1 WHERE +b in (select case case case when not ((~coalesce((select t1.e+d from t1 where (19 between f and t1.b)),(select cast(avg(c+t1.b) AS integer)++cast(avg(b) AS integer) from t1))) not in (t1.c+c,b,e)) or (13 not between d and t1.d) then 13 else b end when  -11 then 13 else 19 end*t1.e when (f) then 19 else 19 end from t1 union select f from t1)"
    end, {
        -- <randexpr-2.138>
        
        -- </randexpr-2.138>
    })

test:do_test(
    "randexpr-2.139",
    function()
        return test:execsql "SELECT (f+case +t1.e when t1.d then 17 else f*19 end |  -(abs( -coalesce((select 17* -c+19 from t1 where (abs(case 19*e*d when (select +(cast(avg( -11) AS integer)) |  -count(*)*max( -13) from t1) then 11 | case t1.b when a then a else t1.f end else t1.a end)/abs(a)) in (select t1.b from t1 union select (a) from t1)),t1.b))/abs( -13))) FROM t1 WHERE NOT (+b in (select case case case when not ((~coalesce((select t1.e+d from t1 where (19 between f and t1.b)),(select cast(avg(c+t1.b) AS integer)++cast(avg(b) AS integer) from t1))) not in (t1.c+c,b,e)) or (13 not between d and t1.d) then 13 else b end when  -11 then 13 else 19 end*t1.e when (f) then 19 else 19 end from t1 union select f from t1))"
    end, {
        -- <randexpr-2.139>
        -15
        -- </randexpr-2.139>
    })

test:do_test(
    "randexpr-2.140",
    function()
        return test:execsql "SELECT (f+case +t1.e when t1.d then 17 else f*19 end &  -(abs( -coalesce((select 17* -c+19 from t1 where (abs(case 19*e*d when (select +(cast(avg( -11) AS integer)) &  -count(*)*max( -13) from t1) then 11 & case t1.b when a then a else t1.f end else t1.a end)/abs(a)) in (select t1.b from t1 union select (a) from t1)),t1.b))/abs( -13))) FROM t1 WHERE NOT (+b in (select case case case when not ((~coalesce((select t1.e+d from t1 where (19 between f and t1.b)),(select cast(avg(c+t1.b) AS integer)++cast(avg(b) AS integer) from t1))) not in (t1.c+c,b,e)) or (13 not between d and t1.d) then 13 else b end when  -11 then 13 else 19 end*t1.e when (f) then 19 else 19 end from t1 union select f from t1))"
    end, {
        -- <randexpr-2.140>
        12000
        -- </randexpr-2.140>
    })

test:do_test(
    "randexpr-2.141",
    function()
        return test:execsql "SELECT 11*coalesce((select max(t1.f) from t1 where a-case t1.c when +coalesce((select t1.a-t1.b from t1 where (abs(19)/abs(b)) in (17-case when a<t1.b then t1.a when c not between 19 and t1.d then e else (t1.b) end, -t1.b,f) or 19 in (select t1.b from t1 union select t1.a from t1)),e)+t1.f*t1.b then t1.c else 13 end in (select t1.b from t1 union select f from t1) or e<>17),d)*(t1.e) FROM t1 WHERE (coalesce((select max(~t1.b) from t1 where t1.c in (select ~+case count(distinct a) when (max(t1.a)) then (count(*)) else ~+abs(cast(avg(d | t1.a) AS integer)+case (cast(avg(13) AS integer)) when cast(avg(b) AS integer) then cast(avg(t1.f) AS integer) else min(t1.a) end) | count(distinct c)*( -( -max(t1.f)))*count(*) end from t1 union select count(distinct  -e) from t1)),~a-11)<19 or t1.a*13<>t1.d and not exists(select 1 from t1 where t1.e=e))"
    end, {
        -- <randexpr-2.141>
        3300000
        -- </randexpr-2.141>
    })

test:do_test(
    "randexpr-2.142",
    function()
        return test:execsql "SELECT 11*coalesce((select max(t1.f) from t1 where a-case t1.c when +coalesce((select t1.a-t1.b from t1 where (abs(19)/abs(b)) in (17-case when a<t1.b then t1.a when c not between 19 and t1.d then e else (t1.b) end, -t1.b,f) or 19 in (select t1.b from t1 union select t1.a from t1)),e)+t1.f*t1.b then t1.c else 13 end in (select t1.b from t1 union select f from t1) or e<>17),d)*(t1.e) FROM t1 WHERE NOT ((coalesce((select max(~t1.b) from t1 where t1.c in (select ~+case count(distinct a) when (max(t1.a)) then (count(*)) else ~+abs(cast(avg(d | t1.a) AS integer)+case (cast(avg(13) AS integer)) when cast(avg(b) AS integer) then cast(avg(t1.f) AS integer) else min(t1.a) end) | count(distinct c)*( -( -max(t1.f)))*count(*) end from t1 union select count(distinct  -e) from t1)),~a-11)<19 or t1.a*13<>t1.d and not exists(select 1 from t1 where t1.e=e)))"
    end, {
        -- <randexpr-2.142>
        
        -- </randexpr-2.142>
    })

test:do_test(
    "randexpr-2.143",
    function()
        return test:execsql "SELECT 11+t1.b+17+case when 13 not between t1.d*(17)+d-t1.f and 13 then t1.d when case when case when t1.f not in (t1.b,c,t1.f) and  -d between d and 11 then d else 19 end not between a and e then t1.b when t1.d in (17,13,11) then 19 else t1.e end*a>e then t1.a else t1.d end*f*e FROM t1 WHERE not exists(select 1 from t1 where (t1.f) in (b-b,(select +(max( -13*t1.c*c+t1.e+case t1.a when +t1.d-(c) then  -t1.a else t1.c end | 19* -17)*count(distinct a) | (count(distinct t1.f)))++cast(avg(f) AS integer)-max(13) | cast(avg(b) AS integer) from t1),t1.f))"
    end, {
        -- <randexpr-2.143>
        
        -- </randexpr-2.143>
    })

test:do_test(
    "randexpr-2.144",
    function()
        return test:execsql "SELECT 11+t1.b+17+case when 13 not between t1.d*(17)+d-t1.f and 13 then t1.d when case when case when t1.f not in (t1.b,c,t1.f) and  -d between d and 11 then d else 19 end not between a and e then t1.b when t1.d in (17,13,11) then 19 else t1.e end*a>e then t1.a else t1.d end*f*e FROM t1 WHERE NOT (not exists(select 1 from t1 where (t1.f) in (b-b,(select +(max( -13*t1.c*c+t1.e+case t1.a when +t1.d-(c) then  -t1.a else t1.c end | 19* -17)*count(distinct a) | (count(distinct t1.f)))++cast(avg(f) AS integer)-max(13) | cast(avg(b) AS integer) from t1),t1.f)))"
    end, {
        -- <randexpr-2.144>
        120000228
        -- </randexpr-2.144>
    })

test:do_test(
    "randexpr-2.145",
    function()
        return test:execsql "SELECT ((abs(+((select count(*)*abs(min((abs(case (abs(c)/abs(f)) | e when case when 19>=d then 13 when a=f then 13 else f end then b else a end+t1.a)/abs(11))*t1.c*17))-cast(avg(e) AS integer)*count(*) from t1)))/abs(coalesce((select max(case when t1.a in (select t1.c from t1 union select 19 from t1) then e else t1.e end) from t1 where (t1.a<= -t1.e)),17)+c*13))) FROM t1 WHERE exists(select 1 from t1 where ~coalesce((select max(c) from t1 where exists(select 1 from t1 where case when not case coalesce((select max(coalesce((select d from t1 where exists(select 1 from t1 where a<(t1.c))),19)) from t1 where e=t1.e),13) when t1.e then t1.b else f end in (select abs((min(e))*(max(t1.d))+min(t1.e)*(( -((max(t1.a)))))) from t1 union select count(distinct t1.a) from t1) then coalesce((select t1.c from t1 where t1.a< -t1.c and a in (t1.b,t1.f,t1.c)),17) else 17 end>=t1.f)),t1.f)+t1.a*b in (select c from t1 union select 19 from t1)) or exists(select 1 from t1 where not t1.f not in (t1.f,11,t1.d) and 19<=19)"
    end, {
        -- <randexpr-2.145>
        23
        -- </randexpr-2.145>
    })

test:do_test(
    "randexpr-2.146",
    function()
        return test:execsql "SELECT ((abs(+((select count(*)*abs(min((abs(case (abs(c)/abs(f)) | e when case when 19>=d then 13 when a=f then 13 else f end then b else a end+t1.a)/abs(11))*t1.c*17))-cast(avg(e) AS integer)*count(*) from t1)))/abs(coalesce((select max(case when t1.a in (select t1.c from t1 union select 19 from t1) then e else t1.e end) from t1 where (t1.a<= -t1.e)),17)+c*13))) FROM t1 WHERE NOT (exists(select 1 from t1 where ~coalesce((select max(c) from t1 where exists(select 1 from t1 where case when not case coalesce((select max(coalesce((select d from t1 where exists(select 1 from t1 where a<(t1.c))),19)) from t1 where e=t1.e),13) when t1.e then t1.b else f end in (select abs((min(e))*(max(t1.d))+min(t1.e)*(( -((max(t1.a)))))) from t1 union select count(distinct t1.a) from t1) then coalesce((select t1.c from t1 where t1.a< -t1.c and a in (t1.b,t1.f,t1.c)),17) else 17 end>=t1.f)),t1.f)+t1.a*b in (select c from t1 union select 19 from t1)) or exists(select 1 from t1 where not t1.f not in (t1.f,11,t1.d) and 19<=19))"
    end, {
        -- <randexpr-2.146>
        
        -- </randexpr-2.146>
    })

test:do_test(
    "randexpr-2.147",
    function()
        return test:execsql "SELECT ((abs(+((select count(*)*abs(min((abs(case (abs(c)/abs(f)) & e when case when 19>=d then 13 when a=f then 13 else f end then b else a end+t1.a)/abs(11))*t1.c*17))-cast(avg(e) AS integer)*count(*) from t1)))/abs(coalesce((select max(case when t1.a in (select t1.c from t1 union select 19 from t1) then e else t1.e end) from t1 where (t1.a<= -t1.e)),17)+c*13))) FROM t1 WHERE exists(select 1 from t1 where ~coalesce((select max(c) from t1 where exists(select 1 from t1 where case when not case coalesce((select max(coalesce((select d from t1 where exists(select 1 from t1 where a<(t1.c))),19)) from t1 where e=t1.e),13) when t1.e then t1.b else f end in (select abs((min(e))*(max(t1.d))+min(t1.e)*(( -((max(t1.a)))))) from t1 union select count(distinct t1.a) from t1) then coalesce((select t1.c from t1 where t1.a< -t1.c and a in (t1.b,t1.f,t1.c)),17) else 17 end>=t1.f)),t1.f)+t1.a*b in (select c from t1 union select 19 from t1)) or exists(select 1 from t1 where not t1.f not in (t1.f,11,t1.d) and 19<=19)"
    end, {
        -- <randexpr-2.147>
        23
        -- </randexpr-2.147>
    })

test:do_test(
    "randexpr-2.148",
    function()
        return test:execsql "SELECT coalesce((select max(case when t1.f between 17 and 11+case when not coalesce((select max(11) from t1 where t1.f in (select max(t1.d) from t1 union select  -count(*) from t1) or 17=(13) or f in (( -t1.b),13,a)),case when d>13 then 13 else 11 end) between 19 and 19 then 19 when t1.c=d then e else 17 end then t1.e else t1.d end) from t1 where e in (select  -(+max(11)-max((t1.a))+ -count(distinct d) | cast(avg(t1.a) AS integer)*count(distinct b))-count(*)* -count(distinct t1.e) from t1 union select cast(avg(d) AS integer) from t1)),d)+b FROM t1 WHERE (select +~abs( -min(t1.a)-abs(count(*)))+ -abs(+ -+case (cast(avg(a) AS integer)) when min(e+t1.d) then +case cast(avg(coalesce((select max(t1.f+ -t1.e) from t1 where t1.c between 13 and t1.b),19)) AS integer) when ~~min(t1.f) then count(distinct 13) else cast(avg(t1.b) AS integer) end+count(distinct t1.e) else  -count(*) end | max(a)+max(t1.e)) from t1)+e<a"
    end, {
        -- <randexpr-2.148>
        600
        -- </randexpr-2.148>
    })

test:do_test(
    "randexpr-2.149",
    function()
        return test:execsql "SELECT coalesce((select max(case when t1.f between 17 and 11+case when not coalesce((select max(11) from t1 where t1.f in (select max(t1.d) from t1 union select  -count(*) from t1) or 17=(13) or f in (( -t1.b),13,a)),case when d>13 then 13 else 11 end) between 19 and 19 then 19 when t1.c=d then e else 17 end then t1.e else t1.d end) from t1 where e in (select  -(+max(11)-max((t1.a))+ -count(distinct d) | cast(avg(t1.a) AS integer)*count(distinct b))-count(*)* -count(distinct t1.e) from t1 union select cast(avg(d) AS integer) from t1)),d)+b FROM t1 WHERE NOT ((select +~abs( -min(t1.a)-abs(count(*)))+ -abs(+ -+case (cast(avg(a) AS integer)) when min(e+t1.d) then +case cast(avg(coalesce((select max(t1.f+ -t1.e) from t1 where t1.c between 13 and t1.b),19)) AS integer) when ~~min(t1.f) then count(distinct 13) else cast(avg(t1.b) AS integer) end+count(distinct t1.e) else  -count(*) end | max(a)+max(t1.e)) from t1)+e<a)"
    end, {
        -- <randexpr-2.149>
        
        -- </randexpr-2.149>
    })

test:do_test(
    "randexpr-2.150",
    function()
        return test:execsql "SELECT coalesce((select max(case when t1.f between 17 and 11+case when not coalesce((select max(11) from t1 where t1.f in (select max(t1.d) from t1 union select  -count(*) from t1) or 17=(13) or f in (( -t1.b),13,a)),case when d>13 then 13 else 11 end) between 19 and 19 then 19 when t1.c=d then e else 17 end then t1.e else t1.d end) from t1 where e in (select  -(+max(11)-max((t1.a))+ -count(distinct d) & cast(avg(t1.a) AS integer)*count(distinct b))-count(*)* -count(distinct t1.e) from t1 union select cast(avg(d) AS integer) from t1)),d)+b FROM t1 WHERE (select +~abs( -min(t1.a)-abs(count(*)))+ -abs(+ -+case (cast(avg(a) AS integer)) when min(e+t1.d) then +case cast(avg(coalesce((select max(t1.f+ -t1.e) from t1 where t1.c between 13 and t1.b),19)) AS integer) when ~~min(t1.f) then count(distinct 13) else cast(avg(t1.b) AS integer) end+count(distinct t1.e) else  -count(*) end | max(a)+max(t1.e)) from t1)+e<a"
    end, {
        -- <randexpr-2.150>
        600
        -- </randexpr-2.150>
    })

test:do_test(
    "randexpr-2.151",
    function()
        return test:execsql "SELECT case when ((+b in (select min(coalesce((select c from t1 where t1.b-t1.c+coalesce((select max(case when 13 in (select  -count(distinct b)*max(c) from t1 union select (( - -cast(avg(d) AS integer))) from t1) then b else t1.f end) from t1 where t1.f<t1.e),13) between (b) and  -t1.b), -e)) from t1 union select +( -case  -abs(( -count(*))) | count(distinct d) when max(17) then max(13) else  -(min(13)) end) | (count(distinct t1.a)) from t1))) then t1.f else case c when t1.d then e else 11 end end FROM t1 WHERE t1.a+case t1.c when case c when 13 then t1.f*(select count(*) | cast(avg(a) AS integer) from t1)+13*t1.a else (select abs( -count(*)) from t1) end then b else t1.c end in (t1.a,d,17) or  -(select ~ -max(c) from t1)+17<>d or t1.a not between b and 13 or f<> -19 and t1.b>a"
    end, {
        -- <randexpr-2.151>
        11
        -- </randexpr-2.151>
    })

test:do_test(
    "randexpr-2.152",
    function()
        return test:execsql "SELECT case when ((+b in (select min(coalesce((select c from t1 where t1.b-t1.c+coalesce((select max(case when 13 in (select  -count(distinct b)*max(c) from t1 union select (( - -cast(avg(d) AS integer))) from t1) then b else t1.f end) from t1 where t1.f<t1.e),13) between (b) and  -t1.b), -e)) from t1 union select +( -case  -abs(( -count(*))) | count(distinct d) when max(17) then max(13) else  -(min(13)) end) | (count(distinct t1.a)) from t1))) then t1.f else case c when t1.d then e else 11 end end FROM t1 WHERE NOT (t1.a+case t1.c when case c when 13 then t1.f*(select count(*) | cast(avg(a) AS integer) from t1)+13*t1.a else (select abs( -count(*)) from t1) end then b else t1.c end in (t1.a,d,17) or  -(select ~ -max(c) from t1)+17<>d or t1.a not between b and 13 or f<> -19 and t1.b>a)"
    end, {
        -- <randexpr-2.152>
        
        -- </randexpr-2.152>
    })

test:do_test(
    "randexpr-2.153",
    function()
        return test:execsql "SELECT case when ((+b in (select min(coalesce((select c from t1 where t1.b-t1.c+coalesce((select max(case when 13 in (select  -count(distinct b)*max(c) from t1 union select (( - -cast(avg(d) AS integer))) from t1) then b else t1.f end) from t1 where t1.f<t1.e),13) between (b) and  -t1.b), -e)) from t1 union select +( -case  -abs(( -count(*))) & count(distinct d) when max(17) then max(13) else  -(min(13)) end) & (count(distinct t1.a)) from t1))) then t1.f else case c when t1.d then e else 11 end end FROM t1 WHERE t1.a+case t1.c when case c when 13 then t1.f*(select count(*) | cast(avg(a) AS integer) from t1)+13*t1.a else (select abs( -count(*)) from t1) end then b else t1.c end in (t1.a,d,17) or  -(select ~ -max(c) from t1)+17<>d or t1.a not between b and 13 or f<> -19 and t1.b>a"
    end, {
        -- <randexpr-2.153>
        11
        -- </randexpr-2.153>
    })

test:do_test(
    "randexpr-2.154",
    function()
        return test:execsql "SELECT case when t1.a | (abs(case when  -t1.e in (17,11,(abs(t1.b)/abs(b+case when (17 in (select f-c from t1 union select  -a from t1)) or t1.b<=a then d when t1.e in (select  -(count(*)) from t1 union select max(t1.b) from t1) then c else c end*a-t1.f))) then t1.b else t1.e end)/abs(t1.f))>=11 and not exists(select 1 from t1 where exists(select 1 from t1 where t1.d in (select t1.d from t1 union select 17 from t1))) then c else t1.c end FROM t1 WHERE (coalesce((select f from t1 where case a-e+a when (abs(t1.d)/abs((coalesce((select ~t1.e*+t1.a+b*a*(abs(19)/abs(a))*a+e from t1 where 13<t1.e),a))))+11 then 11 else d end>=13 or t1.b<= -19),t1.f)+17* -t1.c<t1.c)"
    end, {
        -- <randexpr-2.154>
        300
        -- </randexpr-2.154>
    })

test:do_test(
    "randexpr-2.155",
    function()
        return test:execsql "SELECT case when t1.a | (abs(case when  -t1.e in (17,11,(abs(t1.b)/abs(b+case when (17 in (select f-c from t1 union select  -a from t1)) or t1.b<=a then d when t1.e in (select  -(count(*)) from t1 union select max(t1.b) from t1) then c else c end*a-t1.f))) then t1.b else t1.e end)/abs(t1.f))>=11 and not exists(select 1 from t1 where exists(select 1 from t1 where t1.d in (select t1.d from t1 union select 17 from t1))) then c else t1.c end FROM t1 WHERE NOT ((coalesce((select f from t1 where case a-e+a when (abs(t1.d)/abs((coalesce((select ~t1.e*+t1.a+b*a*(abs(19)/abs(a))*a+e from t1 where 13<t1.e),a))))+11 then 11 else d end>=13 or t1.b<= -19),t1.f)+17* -t1.c<t1.c))"
    end, {
        -- <randexpr-2.155>
        
        -- </randexpr-2.155>
    })

test:do_test(
    "randexpr-2.156",
    function()
        return test:execsql "SELECT case when t1.a & (abs(case when  -t1.e in (17,11,(abs(t1.b)/abs(b+case when (17 in (select f-c from t1 union select  -a from t1)) or t1.b<=a then d when t1.e in (select  -(count(*)) from t1 union select max(t1.b) from t1) then c else c end*a-t1.f))) then t1.b else t1.e end)/abs(t1.f))>=11 and not exists(select 1 from t1 where exists(select 1 from t1 where t1.d in (select t1.d from t1 union select 17 from t1))) then c else t1.c end FROM t1 WHERE (coalesce((select f from t1 where case a-e+a when (abs(t1.d)/abs((coalesce((select ~t1.e*+t1.a+b*a*(abs(19)/abs(a))*a+e from t1 where 13<t1.e),a))))+11 then 11 else d end>=13 or t1.b<= -19),t1.f)+17* -t1.c<t1.c)"
    end, {
        -- <randexpr-2.156>
        300
        -- </randexpr-2.156>
    })

test:do_test(
    "randexpr-2.157",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.b) from t1 where b in (select count(distinct b) from t1 union select max(case coalesce((select max(b) from t1 where d in (select t1.f from t1 union select d from t1) and t1.a=d),t1.a) when  -t1.a then d*t1.e+t1.c-11+b | e-t1.a+e+t1.f else c end) from t1)),t1.a) FROM t1 WHERE (e<t1.f*case 17 when t1.a then t1.d else +coalesce((select max(17) from t1 where not 13<>~a-11),t1.f) end)"
    end, {
        -- <randexpr-2.157>
        100
        -- </randexpr-2.157>
    })

test:do_test(
    "randexpr-2.158",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.b) from t1 where b in (select count(distinct b) from t1 union select max(case coalesce((select max(b) from t1 where d in (select t1.f from t1 union select d from t1) and t1.a=d),t1.a) when  -t1.a then d*t1.e+t1.c-11+b | e-t1.a+e+t1.f else c end) from t1)),t1.a) FROM t1 WHERE NOT ((e<t1.f*case 17 when t1.a then t1.d else +coalesce((select max(17) from t1 where not 13<>~a-11),t1.f) end))"
    end, {
        -- <randexpr-2.158>
        
        -- </randexpr-2.158>
    })

test:do_test(
    "randexpr-2.159",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.b) from t1 where b in (select count(distinct b) from t1 union select max(case coalesce((select max(b) from t1 where d in (select t1.f from t1 union select d from t1) and t1.a=d),t1.a) when  -t1.a then d*t1.e+t1.c-11+b & e-t1.a+e+t1.f else c end) from t1)),t1.a) FROM t1 WHERE (e<t1.f*case 17 when t1.a then t1.d else +coalesce((select max(17) from t1 where not 13<>~a-11),t1.f) end)"
    end, {
        -- <randexpr-2.159>
        100
        -- </randexpr-2.159>
    })

test:do_test(
    "randexpr-2.160",
    function()
        return test:execsql "SELECT case when not t1.c not in (13,d,~case when coalesce((select max((abs(t1.c)/abs(t1.e))) from t1 where b-t1.d+b+t1.f>a),t1.a) in (select 19 from t1 union select t1.a from t1) then  -b else a end*b | d) and  -(t1.b)>=e and 11<d or ((19))<> -t1.c then t1.f else t1.f end+(t1.b)+a FROM t1 WHERE e>e"
    end, {
        -- <randexpr-2.160>
        
        -- </randexpr-2.160>
    })

test:do_test(
    "randexpr-2.161",
    function()
        return test:execsql "SELECT case when not t1.c not in (13,d,~case when coalesce((select max((abs(t1.c)/abs(t1.e))) from t1 where b-t1.d+b+t1.f>a),t1.a) in (select 19 from t1 union select t1.a from t1) then  -b else a end*b | d) and  -(t1.b)>=e and 11<d or ((19))<> -t1.c then t1.f else t1.f end+(t1.b)+a FROM t1 WHERE NOT (e>e)"
    end, {
        -- <randexpr-2.161>
        900
        -- </randexpr-2.161>
    })

test:do_test(
    "randexpr-2.162",
    function()
        return test:execsql "SELECT case when not t1.c not in (13,d,~case when coalesce((select max((abs(t1.c)/abs(t1.e))) from t1 where b-t1.d+b+t1.f>a),t1.a) in (select 19 from t1 union select t1.a from t1) then  -b else a end*b & d) and  -(t1.b)>=e and 11<d or ((19))<> -t1.c then t1.f else t1.f end+(t1.b)+a FROM t1 WHERE NOT (e>e)"
    end, {
        -- <randexpr-2.162>
        900
        -- </randexpr-2.162>
    })

test:do_test(
    "randexpr-2.163",
    function()
        return test:execsql "SELECT coalesce((select t1.c*c from t1 where (select (abs(cast(avg(b*13) AS integer))) from t1) in (select 11 from t1 union select e | a-17 from t1)), -case t1.c when t1.b++(select cast(avg(e) AS integer) from t1) then 17 else t1.b end)-d FROM t1 WHERE b<=t1.d"
    end, {
        -- <randexpr-2.163>
        -600
        -- </randexpr-2.163>
    })

test:do_test(
    "randexpr-2.164",
    function()
        return test:execsql "SELECT coalesce((select t1.c*c from t1 where (select (abs(cast(avg(b*13) AS integer))) from t1) in (select 11 from t1 union select e | a-17 from t1)), -case t1.c when t1.b++(select cast(avg(e) AS integer) from t1) then 17 else t1.b end)-d FROM t1 WHERE NOT (b<=t1.d)"
    end, {
        -- <randexpr-2.164>
        
        -- </randexpr-2.164>
    })

test:do_test(
    "randexpr-2.165",
    function()
        return test:execsql "SELECT coalesce((select t1.c*c from t1 where (select (abs(cast(avg(b*13) AS integer))) from t1) in (select 11 from t1 union select e & a-17 from t1)), -case t1.c when t1.b++(select cast(avg(e) AS integer) from t1) then 17 else t1.b end)-d FROM t1 WHERE b<=t1.d"
    end, {
        -- <randexpr-2.165>
        -600
        -- </randexpr-2.165>
    })

test:do_test(
    "randexpr-2.166",
    function()
        return test:execsql "SELECT coalesce((select max((case (abs(t1.b)/abs(e)) when 13 then ((select +case count(*)*count(distinct coalesce((select max((11)+b) from t1 where exists(select 1 from t1 where t1.e=(t1.b))), -13)) when count(distinct  -c) then count(*)*max( -d) else max((a)) end+min(c) from t1)) else t1.a end-(abs(case when a=17 and e<=b then a when a>=e then t1.c else t1.c end+13)/abs(e))*(e))) from t1 where t1.a in (select d from t1 union select  -t1.e from t1)),13) FROM t1 WHERE not coalesce((select max(case when f<=d | b | case when case when (t1.c in (f,19,c)) then t1.f when d>t1.b then t1.f else t1.f end<=c then 11 else c end- -t1.c-13 and t1.c in (select b from t1 union select  -17 from t1) then t1.b else a end) from t1 where 11 between d and a), -17) not between t1.f and t1.f and t1.f>11 or (not exists(select 1 from t1 where t1.b in (select min(t1.d) from t1 union select min(c) from t1)))"
    end, {
        -- <randexpr-2.166>
        13
        -- </randexpr-2.166>
    })

test:do_test(
    "randexpr-2.167",
    function()
        return test:execsql "SELECT coalesce((select max((case (abs(t1.b)/abs(e)) when 13 then ((select +case count(*)*count(distinct coalesce((select max((11)+b) from t1 where exists(select 1 from t1 where t1.e=(t1.b))), -13)) when count(distinct  -c) then count(*)*max( -d) else max((a)) end+min(c) from t1)) else t1.a end-(abs(case when a=17 and e<=b then a when a>=e then t1.c else t1.c end+13)/abs(e))*(e))) from t1 where t1.a in (select d from t1 union select  -t1.e from t1)),13) FROM t1 WHERE NOT (not coalesce((select max(case when f<=d | b | case when case when (t1.c in (f,19,c)) then t1.f when d>t1.b then t1.f else t1.f end<=c then 11 else c end- -t1.c-13 and t1.c in (select b from t1 union select  -17 from t1) then t1.b else a end) from t1 where 11 between d and a), -17) not between t1.f and t1.f and t1.f>11 or (not exists(select 1 from t1 where t1.b in (select min(t1.d) from t1 union select min(c) from t1))))"
    end, {
        -- <randexpr-2.167>
        
        -- </randexpr-2.167>
    })

test:do_test(
    "randexpr-2.168",
    function()
        return test:execsql "SELECT case when ((t1.e | (select min( -t1.f) from t1)*((abs(b)/abs(19)))-b<=t1.b and not e>13 or  -f in (select count(distinct e)-min(t1.a) from t1 union select count(distinct f) from t1))) then 13 when 17 between f and 19 or 11 between b and 19 or not t1.f>e then t1.d else d | f end FROM t1 WHERE not case when t1.a=t1.a then c when ~case when case when t1.e in (select + -count(distinct t1.d) from t1 union select cast(avg(t1.a) AS integer) from t1) then (t1.e) when 17 in (13, -f,a) then t1.d else d end<17 then e else f end+17+a* -e+b+b>t1.e then t1.e else t1.a end<c and a in (select max( -t1.f) | count(distinct t1.b)+~~count(distinct t1.b)-max(e)- -max(a) from t1 union select min(11) from t1)"
    end, {
        -- <randexpr-2.168>
        
        -- </randexpr-2.168>
    })

test:do_test(
    "randexpr-2.169",
    function()
        return test:execsql "SELECT case when ((t1.e | (select min( -t1.f) from t1)*((abs(b)/abs(19)))-b<=t1.b and not e>13 or  -f in (select count(distinct e)-min(t1.a) from t1 union select count(distinct f) from t1))) then 13 when 17 between f and 19 or 11 between b and 19 or not t1.f>e then t1.d else d | f end FROM t1 WHERE NOT (not case when t1.a=t1.a then c when ~case when case when t1.e in (select + -count(distinct t1.d) from t1 union select cast(avg(t1.a) AS integer) from t1) then (t1.e) when 17 in (13, -f,a) then t1.d else d end<17 then e else f end+17+a* -e+b+b>t1.e then t1.e else t1.a end<c and a in (select max( -t1.f) | count(distinct t1.b)+~~count(distinct t1.b)-max(e)- -max(a) from t1 union select min(11) from t1))"
    end, {
        -- <randexpr-2.169>
        984
        -- </randexpr-2.169>
    })

test:do_test(
    "randexpr-2.170",
    function()
        return test:execsql "SELECT case when ((t1.e & (select min( -t1.f) from t1)*((abs(b)/abs(19)))-b<=t1.b and not e>13 or  -f in (select count(distinct e)-min(t1.a) from t1 union select count(distinct f) from t1))) then 13 when 17 between f and 19 or 11 between b and 19 or not t1.f>e then t1.d else d & f end FROM t1 WHERE NOT (not case when t1.a=t1.a then c when ~case when case when t1.e in (select + -count(distinct t1.d) from t1 union select cast(avg(t1.a) AS integer) from t1) then (t1.e) when 17 in (13, -f,a) then t1.d else d end<17 then e else f end+17+a* -e+b+b>t1.e then t1.e else t1.a end<c and a in (select max( -t1.f) | count(distinct t1.b)+~~count(distinct t1.b)-max(e)- -max(a) from t1 union select min(11) from t1))"
    end, {
        -- <randexpr-2.170>
        16
        -- </randexpr-2.170>
    })

test:do_test(
    "randexpr-2.171",
    function()
        return test:execsql "SELECT coalesce((select (select cast(avg(~13) AS integer)-count(distinct ~19-coalesce((select d-17 from t1 where case when (case 17 when b then d else (select min(11) | min(17) from t1)++t1.a end in (d, -c,t1.d)) then b else t1.c end between t1.a and (t1.e)),19)-t1.f) from t1) | (abs(t1.e)/abs(t1.e)) from t1 where (t1.c not in (( -t1.d),(t1.b),(d)))),t1.e) FROM t1 WHERE 13 between 19 and ~ -(abs( -t1.d | coalesce((select t1.f from t1 where 19 not between + -case when ~~b+coalesce((select max(t1.d) from t1 where exists(select 1 from t1 where (select cast(avg(19) AS integer)-cast(avg(b) AS integer) from t1)<>a and 19 between 11 and b and 11 between a and b)),t1.f) | c in ( -t1.c,13,b) then 11 when f in (select min(t1.d) from t1 union select cast(avg(f) AS integer) from t1) then t1.b else a end and t1.a),t1.c))/abs(11))+ -f"
    end, {
        -- <randexpr-2.171>
        
        -- </randexpr-2.171>
    })

test:do_test(
    "randexpr-2.172",
    function()
        return test:execsql "SELECT coalesce((select (select cast(avg(~13) AS integer)-count(distinct ~19-coalesce((select d-17 from t1 where case when (case 17 when b then d else (select min(11) | min(17) from t1)++t1.a end in (d, -c,t1.d)) then b else t1.c end between t1.a and (t1.e)),19)-t1.f) from t1) | (abs(t1.e)/abs(t1.e)) from t1 where (t1.c not in (( -t1.d),(t1.b),(d)))),t1.e) FROM t1 WHERE NOT (13 between 19 and ~ -(abs( -t1.d | coalesce((select t1.f from t1 where 19 not between + -case when ~~b+coalesce((select max(t1.d) from t1 where exists(select 1 from t1 where (select cast(avg(19) AS integer)-cast(avg(b) AS integer) from t1)<>a and 19 between 11 and b and 11 between a and b)),t1.f) | c in ( -t1.c,13,b) then 11 when f in (select min(t1.d) from t1 union select cast(avg(f) AS integer) from t1) then t1.b else a end and t1.a),t1.c))/abs(11))+ -f)"
    end, {
        -- <randexpr-2.172>
        -15
        -- </randexpr-2.172>
    })

test:do_test(
    "randexpr-2.173",
    function()
        return test:execsql "SELECT coalesce((select (select cast(avg(~13) AS integer)-count(distinct ~19-coalesce((select d-17 from t1 where case when (case 17 when b then d else (select min(11) & min(17) from t1)++t1.a end in (d, -c,t1.d)) then b else t1.c end between t1.a and (t1.e)),19)-t1.f) from t1) & (abs(t1.e)/abs(t1.e)) from t1 where (t1.c not in (( -t1.d),(t1.b),(d)))),t1.e) FROM t1 WHERE NOT (13 between 19 and ~ -(abs( -t1.d | coalesce((select t1.f from t1 where 19 not between + -case when ~~b+coalesce((select max(t1.d) from t1 where exists(select 1 from t1 where (select cast(avg(19) AS integer)-cast(avg(b) AS integer) from t1)<>a and 19 between 11 and b and 11 between a and b)),t1.f) | c in ( -t1.c,13,b) then 11 when f in (select min(t1.d) from t1 union select cast(avg(f) AS integer) from t1) then t1.b else a end and t1.a),t1.c))/abs(11))+ -f)"
    end, {
        -- <randexpr-2.173>
        1
        -- </randexpr-2.173>
    })

test:do_test(
    "randexpr-2.174",
    function()
        return test:execsql "SELECT coalesce((select max(+(d+a)*b) from t1 where (case e-t1.b when 17+11*13 then t1.a else 17 end-(17)<>(select cast(avg(t1.f) AS integer) from t1))),case when case when 11+13<>19 then 13 else t1.f end*e in (a,t1.f,t1.c) and not exists(select 1 from t1 where t1.b in (select  - -count(distinct t1.b)*( -count(*)) from t1 union select count(distinct t1.e) from t1)) then t1.c else a end) FROM t1 WHERE case when t1.d in (select count(*)-count(*)+ -min(case d when t1.c then 19 else 11 end)*count(*) | min(19)-(max((e))) from t1 union select count(*) from t1) then c when exists(select 1 from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where (abs(b)/abs(t1.c))>coalesce((select max(f) from t1 where f<=t1.a),t1.d)))) then f*t1.c+11 else t1.f end+e-e*t1.f<=17"
    end, {
        -- <randexpr-2.174>
        100000
        -- </randexpr-2.174>
    })

test:do_test(
    "randexpr-2.175",
    function()
        return test:execsql "SELECT coalesce((select max(+(d+a)*b) from t1 where (case e-t1.b when 17+11*13 then t1.a else 17 end-(17)<>(select cast(avg(t1.f) AS integer) from t1))),case when case when 11+13<>19 then 13 else t1.f end*e in (a,t1.f,t1.c) and not exists(select 1 from t1 where t1.b in (select  - -count(distinct t1.b)*( -count(*)) from t1 union select count(distinct t1.e) from t1)) then t1.c else a end) FROM t1 WHERE NOT (case when t1.d in (select count(*)-count(*)+ -min(case d when t1.c then 19 else 11 end)*count(*) | min(19)-(max((e))) from t1 union select count(*) from t1) then c when exists(select 1 from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where (abs(b)/abs(t1.c))>coalesce((select max(f) from t1 where f<=t1.a),t1.d)))) then f*t1.c+11 else t1.f end+e-e*t1.f<=17)"
    end, {
        -- <randexpr-2.175>
        
        -- </randexpr-2.175>
    })

test:do_test(
    "randexpr-2.176",
    function()
        return test:execsql "SELECT t1.c*case when t1.e>(select +cast(avg(13) AS integer)*min((11)* - -d |  - -coalesce((select max(b) from t1 where (select cast(avg((abs(a)/abs(b-(e)))) AS integer) from t1)+11*c<t1.d),e)-t1.f-t1.b+(t1.a)) from t1) then t1.c when +b in (17,a,b) then d else f end FROM t1 WHERE ((not exists(select 1 from t1 where not (exists(select 1 from t1 where (t1.c in (select t1.d from t1 union select  -c from t1)) or (select cast(avg(~(e)) AS integer) | min(case when f=t1.e and t1.e in (t1.b,t1.f,t1.a) then t1.f when t1.d>=a then t1.b else t1.b end | 19+a-c)*count(distinct t1.d)-+count(distinct t1.d) from t1) not in (19,d,b) and t1.f not between b and t1.f)))))"
    end, {
        -- <randexpr-2.176>
        
        -- </randexpr-2.176>
    })

test:do_test(
    "randexpr-2.177",
    function()
        return test:execsql "SELECT t1.c*case when t1.e>(select +cast(avg(13) AS integer)*min((11)* - -d |  - -coalesce((select max(b) from t1 where (select cast(avg((abs(a)/abs(b-(e)))) AS integer) from t1)+11*c<t1.d),e)-t1.f-t1.b+(t1.a)) from t1) then t1.c when +b in (17,a,b) then d else f end FROM t1 WHERE NOT (((not exists(select 1 from t1 where not (exists(select 1 from t1 where (t1.c in (select t1.d from t1 union select  -c from t1)) or (select cast(avg(~(e)) AS integer) | min(case when f=t1.e and t1.e in (t1.b,t1.f,t1.a) then t1.f when t1.d>=a then t1.b else t1.b end | 19+a-c)*count(distinct t1.d)-+count(distinct t1.d) from t1) not in (19,d,b) and t1.f not between b and t1.f))))))"
    end, {
        -- <randexpr-2.177>
        90000
        -- </randexpr-2.177>
    })

test:do_test(
    "randexpr-2.178",
    function()
        return test:execsql "SELECT t1.c*case when t1.e>(select +cast(avg(13) AS integer)*min((11)* - -d &  - -coalesce((select max(b) from t1 where (select cast(avg((abs(a)/abs(b-(e)))) AS integer) from t1)+11*c<t1.d),e)-t1.f-t1.b+(t1.a)) from t1) then t1.c when +b in (17,a,b) then d else f end FROM t1 WHERE NOT (((not exists(select 1 from t1 where not (exists(select 1 from t1 where (t1.c in (select t1.d from t1 union select  -c from t1)) or (select cast(avg(~(e)) AS integer) | min(case when f=t1.e and t1.e in (t1.b,t1.f,t1.a) then t1.f when t1.d>=a then t1.b else t1.b end | 19+a-c)*count(distinct t1.d)-+count(distinct t1.d) from t1) not in (19,d,b) and t1.f not between b and t1.f))))))"
    end, {
        -- <randexpr-2.178>
        120000
        -- </randexpr-2.178>
    })

test:do_test(
    "randexpr-2.179",
    function()
        return test:execsql "SELECT case when not exists(select 1 from t1 where (not exists(select 1 from t1 where not exists(select 1 from t1 where not d*19=b))) or t1.a-a-t1.d*t1.f in (select ~case cast(avg(t1.d) AS integer) | count(*)+max(t1.c) when max(17) then cast(avg( -f) AS integer) else  -min(e) end from t1 union select max( -13) from t1)) then (select abs((+ -min(a)) | min(t1.a)-cast(avg(t1.f) AS integer)) | max(e) from t1) else 11 end*a | t1.a*f FROM t1 WHERE t1.c in (c,t1.b,~e) and 13+19-t1.b | coalesce((select max(case d when +t1.e+13*13 then coalesce((select case when f<t1.f then ~d else 19 end from t1 where not d>=e or  -f<=e and t1.d<>19),d) else d end) from t1 where t1.d<b),t1.a)*d*(a)<=t1.d"
    end, {
        -- <randexpr-2.179>
        61036
        -- </randexpr-2.179>
    })

test:do_test(
    "randexpr-2.180",
    function()
        return test:execsql "SELECT case when not exists(select 1 from t1 where (not exists(select 1 from t1 where not exists(select 1 from t1 where not d*19=b))) or t1.a-a-t1.d*t1.f in (select ~case cast(avg(t1.d) AS integer) | count(*)+max(t1.c) when max(17) then cast(avg( -f) AS integer) else  -min(e) end from t1 union select max( -13) from t1)) then (select abs((+ -min(a)) | min(t1.a)-cast(avg(t1.f) AS integer)) | max(e) from t1) else 11 end*a | t1.a*f FROM t1 WHERE NOT (t1.c in (c,t1.b,~e) and 13+19-t1.b | coalesce((select max(case d when +t1.e+13*13 then coalesce((select case when f<t1.f then ~d else 19 end from t1 where not d>=e or  -f<=e and t1.d<>19),d) else d end) from t1 where t1.d<b),t1.a)*d*(a)<=t1.d)"
    end, {
        -- <randexpr-2.180>
        
        -- </randexpr-2.180>
    })

test:do_test(
    "randexpr-2.181",
    function()
        return test:execsql "SELECT case when not exists(select 1 from t1 where (not exists(select 1 from t1 where not exists(select 1 from t1 where not d*19=b))) or t1.a-a-t1.d*t1.f in (select ~case cast(avg(t1.d) AS integer) & count(*)+max(t1.c) when max(17) then cast(avg( -f) AS integer) else  -min(e) end from t1 union select max( -13) from t1)) then (select abs((+ -min(a)) & min(t1.a)-cast(avg(t1.f) AS integer)) & max(e) from t1) else 11 end*a & t1.a*f FROM t1 WHERE t1.c in (c,t1.b,~e) and 13+19-t1.b | coalesce((select max(case d when +t1.e+13*13 then coalesce((select case when f<t1.f then ~d else 19 end from t1 where not d>=e or  -f<=e and t1.d<>19),d) else d end) from t1 where t1.d<b),t1.a)*d*(a)<=t1.d"
    end, {
        -- <randexpr-2.181>
        64
        -- </randexpr-2.181>
    })

test:do_test(
    "randexpr-2.182",
    function()
        return test:execsql "SELECT (abs(t1.f-(abs(case c when t1.a+(select max(17-coalesce((select +e-t1.a+11-13+d+11-t1.a from t1 where t1.e in (select ~coalesce((select a from t1 where t1.c-a=b),t1.c)+17 from t1 union select t1.e from t1)),c)-d) from t1) then 17 else  -t1.e end)/abs(d))-17)/abs(t1.b)) FROM t1 WHERE b in (select +count(distinct (19)-11) from t1 union select case count(*) when  -case min((abs(t1.c*(t1.c)+11)/abs(19))*~d*f) when abs(count(*)+count(*)) then (+(min(e)* -cast(avg(17) AS integer)* -cast(avg(d) AS integer)+max(t1.f))) else (count(*)) end | (min( -((t1.b)))) then (max(t1.c)) else  -count(distinct t1.d) end from t1) and not exists(select 1 from t1 where d<f)"
    end, {
        -- <randexpr-2.182>
        
        -- </randexpr-2.182>
    })

test:do_test(
    "randexpr-2.183",
    function()
        return test:execsql "SELECT (abs(t1.f-(abs(case c when t1.a+(select max(17-coalesce((select +e-t1.a+11-13+d+11-t1.a from t1 where t1.e in (select ~coalesce((select a from t1 where t1.c-a=b),t1.c)+17 from t1 union select t1.e from t1)),c)-d) from t1) then 17 else  -t1.e end)/abs(d))-17)/abs(t1.b)) FROM t1 WHERE NOT (b in (select +count(distinct (19)-11) from t1 union select case count(*) when  -case min((abs(t1.c*(t1.c)+11)/abs(19))*~d*f) when abs(count(*)+count(*)) then (+(min(e)* -cast(avg(17) AS integer)* -cast(avg(d) AS integer)+max(t1.f))) else (count(*)) end | (min( -((t1.b)))) then (max(t1.c)) else  -count(distinct t1.d) end from t1) and not exists(select 1 from t1 where d<f))"
    end, {
        -- <randexpr-2.183>
        2
        -- </randexpr-2.183>
    })

test:do_test(
    "randexpr-2.184",
    function()
        return test:execsql "SELECT ~case +~c+(case when not exists(select 1 from t1 where t1.d in (select abs( -abs(max(t1.f)-count(distinct e)* -cast(avg(11) AS integer) | count(*))+min(f)*min( -17)*cast(avg(19) AS integer)) from t1 union select count(*) from t1)) or (t1.f)<>t1.b then d*t1.f*17 else (b) end)+t1.f*13 when c then t1.a else t1.e end- -t1.f FROM t1 WHERE b-case when t1.b=t1.b and (coalesce((select max(t1.e) from t1 where t1.b in (select ~cast(avg(19) AS integer)+max(t1.b)+min(t1.e) from t1 union select max(t1.a) from t1) or exists(select 1 from t1 where 11 in (select max(t1.e) from t1 union select max(t1.f) from t1))),(abs(17)/abs(17)))) not between c and t1.a then 13 else 13 end | t1.c in (select ++cast(avg(f) AS integer)-(+(count(distinct 13) | max(19))-count(*) |  -max(t1.e)) from t1 union select count(*) from t1)"
    end, {
        -- <randexpr-2.184>
        
        -- </randexpr-2.184>
    })

test:do_test(
    "randexpr-2.185",
    function()
        return test:execsql "SELECT ~case +~c+(case when not exists(select 1 from t1 where t1.d in (select abs( -abs(max(t1.f)-count(distinct e)* -cast(avg(11) AS integer) | count(*))+min(f)*min( -17)*cast(avg(19) AS integer)) from t1 union select count(*) from t1)) or (t1.f)<>t1.b then d*t1.f*17 else (b) end)+t1.f*13 when c then t1.a else t1.e end- -t1.f FROM t1 WHERE NOT (b-case when t1.b=t1.b and (coalesce((select max(t1.e) from t1 where t1.b in (select ~cast(avg(19) AS integer)+max(t1.b)+min(t1.e) from t1 union select max(t1.a) from t1) or exists(select 1 from t1 where 11 in (select max(t1.e) from t1 union select max(t1.f) from t1))),(abs(17)/abs(17)))) not between c and t1.a then 13 else 13 end | t1.c in (select ++cast(avg(f) AS integer)-(+(count(distinct 13) | max(19))-count(*) |  -max(t1.e)) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.185>
        99
        -- </randexpr-2.185>
    })

test:do_test(
    "randexpr-2.186",
    function()
        return test:execsql "SELECT ~case +~c+(case when not exists(select 1 from t1 where t1.d in (select abs( -abs(max(t1.f)-count(distinct e)* -cast(avg(11) AS integer) & count(*))+min(f)*min( -17)*cast(avg(19) AS integer)) from t1 union select count(*) from t1)) or (t1.f)<>t1.b then d*t1.f*17 else (b) end)+t1.f*13 when c then t1.a else t1.e end- -t1.f FROM t1 WHERE NOT (b-case when t1.b=t1.b and (coalesce((select max(t1.e) from t1 where t1.b in (select ~cast(avg(19) AS integer)+max(t1.b)+min(t1.e) from t1 union select max(t1.a) from t1) or exists(select 1 from t1 where 11 in (select max(t1.e) from t1 union select max(t1.f) from t1))),(abs(17)/abs(17)))) not between c and t1.a then 13 else 13 end | t1.c in (select ++cast(avg(f) AS integer)-(+(count(distinct 13) | max(19))-count(*) |  -max(t1.e)) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.186>
        99
        -- </randexpr-2.186>
    })

test:do_test(
    "randexpr-2.187",
    function()
        return test:execsql "SELECT case when t1.c in (select c from t1 union select a from t1) then 11 when ((select max(19) from t1) | t1.a+e not between (case  -19 when b*e-b-case when b<>~d*t1.d+t1.c*d then t1.d when t1.c=19 then f else d end-f*t1.d then t1.d else 13 end) and 13) then 11 else t1.b end FROM t1 WHERE t1.b*coalesce((select max(t1.d) from t1 where  -f<=(select max(t1.e) from t1)*e),case when case when t1.e- -13>t1.b+t1.f+c then 13 else  -d end in (select 19 from t1 union select t1.f from t1) then e when t1.b in (select ~count(distinct t1.a)+count(*) from t1 union select abs( - -((cast(avg(c) AS integer)))*(cast(avg(t1.b) AS integer))) from t1) then 17 else d end)+ -17 | t1.a-t1.d in (t1.e,f,f)"
    end, {
        -- <randexpr-2.187>
        
        -- </randexpr-2.187>
    })

test:do_test(
    "randexpr-2.188",
    function()
        return test:execsql "SELECT case when t1.c in (select c from t1 union select a from t1) then 11 when ((select max(19) from t1) | t1.a+e not between (case  -19 when b*e-b-case when b<>~d*t1.d+t1.c*d then t1.d when t1.c=19 then f else d end-f*t1.d then t1.d else 13 end) and 13) then 11 else t1.b end FROM t1 WHERE NOT (t1.b*coalesce((select max(t1.d) from t1 where  -f<=(select max(t1.e) from t1)*e),case when case when t1.e- -13>t1.b+t1.f+c then 13 else  -d end in (select 19 from t1 union select t1.f from t1) then e when t1.b in (select ~count(distinct t1.a)+count(*) from t1 union select abs( - -((cast(avg(c) AS integer)))*(cast(avg(t1.b) AS integer))) from t1) then 17 else d end)+ -17 | t1.a-t1.d in (t1.e,f,f))"
    end, {
        -- <randexpr-2.188>
        11
        -- </randexpr-2.188>
    })

test:do_test(
    "randexpr-2.189",
    function()
        return test:execsql "SELECT case when t1.c in (select c from t1 union select a from t1) then 11 when ((select max(19) from t1) & t1.a+e not between (case  -19 when b*e-b-case when b<>~d*t1.d+t1.c*d then t1.d when t1.c=19 then f else d end-f*t1.d then t1.d else 13 end) and 13) then 11 else t1.b end FROM t1 WHERE NOT (t1.b*coalesce((select max(t1.d) from t1 where  -f<=(select max(t1.e) from t1)*e),case when case when t1.e- -13>t1.b+t1.f+c then 13 else  -d end in (select 19 from t1 union select t1.f from t1) then e when t1.b in (select ~count(distinct t1.a)+count(*) from t1 union select abs( - -((cast(avg(c) AS integer)))*(cast(avg(t1.b) AS integer))) from t1) then 17 else d end)+ -17 | t1.a-t1.d in (t1.e,f,f))"
    end, {
        -- <randexpr-2.189>
        11
        -- </randexpr-2.189>
    })

test:do_test(
    "randexpr-2.190",
    function()
        return test:execsql "SELECT ~(d)-(select case case cast(avg(t1.b- -~b) AS integer) when max(coalesce((select e from t1 where 11<>e),coalesce((select c from t1 where c not in (t1.e,a,(17)) or t1.b in ((b),t1.c,t1.f)),13))) then +cast(avg(d) AS integer) | case max(t1.c) when min((e)) then max(e)+cast(avg(t1.d) AS integer) else min(t1.f) end+max(d) else count(*) end |  -cast(avg(t1.f) AS integer) |  - -count(distinct c)*max(b) when count(distinct t1.d) then  - -min(a) else count(*) end from t1) FROM t1 WHERE t1.c+a=t1.e+t1.c*t1.e | case t1.d when case when 13 in (select min(c) from t1 union select max(d) from t1) or t1.f>=13 then 19 when t1.c<=11 then  -t1.b else 13 end then 13 else t1.e end or f in (select t1.a from t1 union select t1.f from t1) or (t1.a<t1.b) and e>t1.b and (((t1.d not between  -a and t1.f))) or t1.a not in ( -t1.d,13,a) and d<c or d=t1.d or e<d"
    end, {
        -- <randexpr-2.190>
        -402
        -- </randexpr-2.190>
    })

test:do_test(
    "randexpr-2.191",
    function()
        return test:execsql "SELECT ~(d)-(select case case cast(avg(t1.b- -~b) AS integer) when max(coalesce((select e from t1 where 11<>e),coalesce((select c from t1 where c not in (t1.e,a,(17)) or t1.b in ((b),t1.c,t1.f)),13))) then +cast(avg(d) AS integer) | case max(t1.c) when min((e)) then max(e)+cast(avg(t1.d) AS integer) else min(t1.f) end+max(d) else count(*) end |  -cast(avg(t1.f) AS integer) |  - -count(distinct c)*max(b) when count(distinct t1.d) then  - -min(a) else count(*) end from t1) FROM t1 WHERE NOT (t1.c+a=t1.e+t1.c*t1.e | case t1.d when case when 13 in (select min(c) from t1 union select max(d) from t1) or t1.f>=13 then 19 when t1.c<=11 then  -t1.b else 13 end then 13 else t1.e end or f in (select t1.a from t1 union select t1.f from t1) or (t1.a<t1.b) and e>t1.b and (((t1.d not between  -a and t1.f))) or t1.a not in ( -t1.d,13,a) and d<c or d=t1.d or e<d)"
    end, {
        -- <randexpr-2.191>
        
        -- </randexpr-2.191>
    })

test:do_test(
    "randexpr-2.192",
    function()
        return test:execsql "SELECT ~(d)-(select case case cast(avg(t1.b- -~b) AS integer) when max(coalesce((select e from t1 where 11<>e),coalesce((select c from t1 where c not in (t1.e,a,(17)) or t1.b in ((b),t1.c,t1.f)),13))) then +cast(avg(d) AS integer) & case max(t1.c) when min((e)) then max(e)+cast(avg(t1.d) AS integer) else min(t1.f) end+max(d) else count(*) end &  -cast(avg(t1.f) AS integer) &  - -count(distinct c)*max(b) when count(distinct t1.d) then  - -min(a) else count(*) end from t1) FROM t1 WHERE t1.c+a=t1.e+t1.c*t1.e | case t1.d when case when 13 in (select min(c) from t1 union select max(d) from t1) or t1.f>=13 then 19 when t1.c<=11 then  -t1.b else 13 end then 13 else t1.e end or f in (select t1.a from t1 union select t1.f from t1) or (t1.a<t1.b) and e>t1.b and (((t1.d not between  -a and t1.f))) or t1.a not in ( -t1.d,13,a) and d<c or d=t1.d or e<d"
    end, {
        -- <randexpr-2.192>
        -402
        -- </randexpr-2.192>
    })

test:do_test(
    "randexpr-2.193",
    function()
        return test:execsql "SELECT (abs(coalesce((select max(a) from t1 where exists(select 1 from t1 where t1.f<19 and coalesce((select max(case when t1.a+e in (select t1.c from t1 union select f from t1) then f else (17) end) from t1 where t1.e in (f,coalesce((select max(t1.f) from t1 where 17<=((abs(t1.d | (t1.a))/abs(13))*(a))-d),17),e)),t1.c) not between t1.b and 11 and 13<t1.f)),f+t1.d))/abs(19)) FROM t1 WHERE 11*c+17-f in (select min(t1.e*11*case when exists(select 1 from t1 where not exists(select 1 from t1 where + -17<a)) then (abs((d))/abs(13)) when 11 in (select case count(*) when count(distinct t1.f) then count(distinct 17) else cast(avg((11)) AS integer) end from t1 union select cast(avg(t1.c) AS integer) from t1) then b else e end) from t1 union select case count(*) when  -count(distinct t1.d) then max(a) else (count(distinct t1.c))-max((b)) | (count(distinct t1.e))*count(distinct (13))-count(distinct e) end-count(*)-count(*) from t1)"
    end, {
        -- <randexpr-2.193>
        
        -- </randexpr-2.193>
    })

test:do_test(
    "randexpr-2.194",
    function()
        return test:execsql "SELECT (abs(coalesce((select max(a) from t1 where exists(select 1 from t1 where t1.f<19 and coalesce((select max(case when t1.a+e in (select t1.c from t1 union select f from t1) then f else (17) end) from t1 where t1.e in (f,coalesce((select max(t1.f) from t1 where 17<=((abs(t1.d | (t1.a))/abs(13))*(a))-d),17),e)),t1.c) not between t1.b and 11 and 13<t1.f)),f+t1.d))/abs(19)) FROM t1 WHERE NOT (11*c+17-f in (select min(t1.e*11*case when exists(select 1 from t1 where not exists(select 1 from t1 where + -17<a)) then (abs((d))/abs(13)) when 11 in (select case count(*) when count(distinct t1.f) then count(distinct 17) else cast(avg((11)) AS integer) end from t1 union select cast(avg(t1.c) AS integer) from t1) then b else e end) from t1 union select case count(*) when  -count(distinct t1.d) then max(a) else (count(distinct t1.c))-max((b)) | (count(distinct t1.e))*count(distinct (13))-count(distinct e) end-count(*)-count(*) from t1))"
    end, {
        -- <randexpr-2.194>
        52
        -- </randexpr-2.194>
    })

test:do_test(
    "randexpr-2.195",
    function()
        return test:execsql "SELECT (abs(coalesce((select max(a) from t1 where exists(select 1 from t1 where t1.f<19 and coalesce((select max(case when t1.a+e in (select t1.c from t1 union select f from t1) then f else (17) end) from t1 where t1.e in (f,coalesce((select max(t1.f) from t1 where 17<=((abs(t1.d & (t1.a))/abs(13))*(a))-d),17),e)),t1.c) not between t1.b and 11 and 13<t1.f)),f+t1.d))/abs(19)) FROM t1 WHERE NOT (11*c+17-f in (select min(t1.e*11*case when exists(select 1 from t1 where not exists(select 1 from t1 where + -17<a)) then (abs((d))/abs(13)) when 11 in (select case count(*) when count(distinct t1.f) then count(distinct 17) else cast(avg((11)) AS integer) end from t1 union select cast(avg(t1.c) AS integer) from t1) then b else e end) from t1 union select case count(*) when  -count(distinct t1.d) then max(a) else (count(distinct t1.c))-max((b)) | (count(distinct t1.e))*count(distinct (13))-count(distinct e) end-count(*)-count(*) from t1))"
    end, {
        -- <randexpr-2.195>
        52
        -- </randexpr-2.195>
    })

test:do_test(
    "randexpr-2.196",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.d) from t1 where not exists(select 1 from t1 where exists(select 1 from t1 where c>t1.c or ((t1.f>e)) and t1.e-19+c+ -d*t1.d+11<>17+coalesce((select max(t1.d) from t1 where 17+t1.c<t1.d),t1.b) or f<>11))),11) | case e when c then a else t1.b end+a FROM t1 WHERE case when d not in (a,11,(13)) then a when exists(select 1 from t1 where case when case when case when (t1.c) in (c,e,b) then f else (19) end-t1.f<t1.d then 11 else a end>=t1.a then 11 else t1.c end in (select abs(~~max(t1.c)) from t1 union select cast(avg(c) AS integer) from t1)) then 11 else t1.f end in (select (~~count(*)*cast(avg(19) AS integer)) from t1 union select min(t1.d)+ -count(distinct f) from t1)"
    end, {
        -- <randexpr-2.196>
        
        -- </randexpr-2.196>
    })

test:do_test(
    "randexpr-2.197",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.d) from t1 where not exists(select 1 from t1 where exists(select 1 from t1 where c>t1.c or ((t1.f>e)) and t1.e-19+c+ -d*t1.d+11<>17+coalesce((select max(t1.d) from t1 where 17+t1.c<t1.d),t1.b) or f<>11))),11) | case e when c then a else t1.b end+a FROM t1 WHERE NOT (case when d not in (a,11,(13)) then a when exists(select 1 from t1 where case when case when case when (t1.c) in (c,e,b) then f else (19) end-t1.f<t1.d then 11 else a end>=t1.a then 11 else t1.c end in (select abs(~~max(t1.c)) from t1 union select cast(avg(c) AS integer) from t1)) then 11 else t1.f end in (select (~~count(*)*cast(avg(19) AS integer)) from t1 union select min(t1.d)+ -count(distinct f) from t1))"
    end, {
        -- <randexpr-2.197>
        303
        -- </randexpr-2.197>
    })

test:do_test(
    "randexpr-2.198",
    function()
        return test:execsql "SELECT coalesce((select max(~t1.d) from t1 where not exists(select 1 from t1 where exists(select 1 from t1 where c>t1.c or ((t1.f>e)) and t1.e-19+c+ -d*t1.d+11<>17+coalesce((select max(t1.d) from t1 where 17+t1.c<t1.d),t1.b) or f<>11))),11) & case e when c then a else t1.b end+a FROM t1 WHERE NOT (case when d not in (a,11,(13)) then a when exists(select 1 from t1 where case when case when case when (t1.c) in (c,e,b) then f else (19) end-t1.f<t1.d then 11 else a end>=t1.a then 11 else t1.c end in (select abs(~~max(t1.c)) from t1 union select cast(avg(c) AS integer) from t1)) then 11 else t1.f end in (select (~~count(*)*cast(avg(19) AS integer)) from t1 union select min(t1.d)+ -count(distinct f) from t1))"
    end, {
        -- <randexpr-2.198>
        8
        -- </randexpr-2.198>
    })

test:do_test(
    "randexpr-2.199",
    function()
        return test:execsql "SELECT case when t1.e*t1.b<>e then 19 else  -11-b+coalesce((select max(t1.e+t1.f) from t1 where 11+f*t1.c<>t1.a*(~f+case when t1.f in (t1.f, -((13)),19) then t1.a when t1.e>17 then a else a end+b-t1.e-(f))),13)+d end+t1.b* -c FROM t1 WHERE exists(select 1 from t1 where coalesce((select max(t1.a*t1.e+13) from t1 where 13 in ((abs(e)/abs(t1.a)),a+t1.c,17*t1.c)),(select  -case max(c) | cast(avg(e) AS integer) when ~+ -count(distinct coalesce((select d from t1 where exists(select 1 from t1 where  -17<e)),( -t1.e))) | case max(11) when cast(avg(a) AS integer) then max( -t1.f) else count(distinct  -11) end then cast(avg(t1.d) AS integer) else max((d)) end*count(distinct t1.b) from t1) | t1.b-t1.d*t1.c+11)<=b)"
    end, {
        -- <randexpr-2.199>
        -59981
        -- </randexpr-2.199>
    })

test:do_test(
    "randexpr-2.200",
    function()
        return test:execsql "SELECT case when t1.e*t1.b<>e then 19 else  -11-b+coalesce((select max(t1.e+t1.f) from t1 where 11+f*t1.c<>t1.a*(~f+case when t1.f in (t1.f, -((13)),19) then t1.a when t1.e>17 then a else a end+b-t1.e-(f))),13)+d end+t1.b* -c FROM t1 WHERE NOT (exists(select 1 from t1 where coalesce((select max(t1.a*t1.e+13) from t1 where 13 in ((abs(e)/abs(t1.a)),a+t1.c,17*t1.c)),(select  -case max(c) | cast(avg(e) AS integer) when ~+ -count(distinct coalesce((select d from t1 where exists(select 1 from t1 where  -17<e)),( -t1.e))) | case max(11) when cast(avg(a) AS integer) then max( -t1.f) else count(distinct  -11) end then cast(avg(t1.d) AS integer) else max((d)) end*count(distinct t1.b) from t1) | t1.b-t1.d*t1.c+11)<=b))"
    end, {
        -- <randexpr-2.200>
        
        -- </randexpr-2.200>
    })

test:do_test(
    "randexpr-2.201",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select 19 from t1 where (case when ((abs(coalesce((select max(case when t1.a between (t1.c)+ -b and d then e else d end) from t1 where t1.e in (select (count(*)) from t1 union select max( -a)-count(distinct t1.c)-((min(13))) | max((t1.f)) from t1)),11))/abs(19)))+d>c then t1.b when 17 not between t1.e and c then 11 else f end in (select a from t1 union select 13 from t1))),11)) from t1 where not exists(select 1 from t1 where f=17)),e) FROM t1 WHERE ( -13 in (13,b,case when 19=11 then t1.d else case when (d | b-case when t1.f-(select +abs(cast(avg( -17* -17) AS integer)*count(*)+max(t1.e)) from t1)*t1.f not in (f,a,c) then t1.a else t1.b end between 19 and e) then a else 13 end end-t1.a) or t1.c<19)"
    end, {
        -- <randexpr-2.201>
        
        -- </randexpr-2.201>
    })

test:do_test(
    "randexpr-2.202",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select 19 from t1 where (case when ((abs(coalesce((select max(case when t1.a between (t1.c)+ -b and d then e else d end) from t1 where t1.e in (select (count(*)) from t1 union select max( -a)-count(distinct t1.c)-((min(13))) | max((t1.f)) from t1)),11))/abs(19)))+d>c then t1.b when 17 not between t1.e and c then 11 else f end in (select a from t1 union select 13 from t1))),11)) from t1 where not exists(select 1 from t1 where f=17)),e) FROM t1 WHERE NOT (( -13 in (13,b,case when 19=11 then t1.d else case when (d | b-case when t1.f-(select +abs(cast(avg( -17* -17) AS integer)*count(*)+max(t1.e)) from t1)*t1.f not in (f,a,c) then t1.a else t1.b end between 19 and e) then a else 13 end end-t1.a) or t1.c<19))"
    end, {
        -- <randexpr-2.202>
        11
        -- </randexpr-2.202>
    })

test:do_test(
    "randexpr-2.203",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select 19 from t1 where (case when ((abs(coalesce((select max(case when t1.a between (t1.c)+ -b and d then e else d end) from t1 where t1.e in (select (count(*)) from t1 union select max( -a)-count(distinct t1.c)-((min(13))) & max((t1.f)) from t1)),11))/abs(19)))+d>c then t1.b when 17 not between t1.e and c then 11 else f end in (select a from t1 union select 13 from t1))),11)) from t1 where not exists(select 1 from t1 where f=17)),e) FROM t1 WHERE NOT (( -13 in (13,b,case when 19=11 then t1.d else case when (d | b-case when t1.f-(select +abs(cast(avg( -17* -17) AS integer)*count(*)+max(t1.e)) from t1)*t1.f not in (f,a,c) then t1.a else t1.b end between 19 and e) then a else 13 end end-t1.a) or t1.c<19))"
    end, {
        -- <randexpr-2.203>
        11
        -- </randexpr-2.203>
    })

test:do_test(
    "randexpr-2.204",
    function()
        return test:execsql "SELECT  -~d*19-a-c | t1.c+(abs(case  -19 | ~case t1.d when c then t1.f else c end when +t1.d then 17 else case case when b>case case when t1.c=d or  -t1.a=17 then ((a)) when t1.a<>d then (t1.c) else a end+19+11 when 19 then t1.a else b end-(t1.e) then f else t1.c end when 17 then t1.b else a end end)/abs(d))+t1.b FROM t1 WHERE t1.f+13<>19"
    end, {
        -- <randexpr-2.204>
        7671
        -- </randexpr-2.204>
    })

test:do_test(
    "randexpr-2.205",
    function()
        return test:execsql "SELECT  -~d*19-a-c | t1.c+(abs(case  -19 | ~case t1.d when c then t1.f else c end when +t1.d then 17 else case case when b>case case when t1.c=d or  -t1.a=17 then ((a)) when t1.a<>d then (t1.c) else a end+19+11 when 19 then t1.a else b end-(t1.e) then f else t1.c end when 17 then t1.b else a end end)/abs(d))+t1.b FROM t1 WHERE NOT (t1.f+13<>19)"
    end, {
        -- <randexpr-2.205>
        
        -- </randexpr-2.205>
    })

test:do_test(
    "randexpr-2.206",
    function()
        return test:execsql "SELECT  -~d*19-a-c & t1.c+(abs(case  -19 & ~case t1.d when c then t1.f else c end when +t1.d then 17 else case case when b>case case when t1.c=d or  -t1.a=17 then ((a)) when t1.a<>d then (t1.c) else a end+19+11 when 19 then t1.a else b end-(t1.e) then f else t1.c end when 17 then t1.b else a end end)/abs(d))+t1.b FROM t1 WHERE t1.f+13<>19"
    end, {
        -- <randexpr-2.206>
        48
        -- </randexpr-2.206>
    })

test:do_test(
    "randexpr-2.207",
    function()
        return test:execsql "SELECT (abs(coalesce((select b from t1 where t1.a>(abs(t1.f)/abs(coalesce((select 13 from t1 where not coalesce((select (select cast(avg(case when case when t1.e not between t1.c and 19 then t1.d when d in (11,t1.b,13) then e else 17 end*b between 13 and (t1.b) then t1.f when a<>19 and t1.c not in (a,t1.f,b) then t1.e else t1.f end) AS integer) from t1)+t1.c-b* -a*f from t1 where (t1.d in (select c from t1 union select t1.b from t1))),t1.e)-c<>c),t1.c)))),e))/abs(t1.e)) FROM t1 WHERE (t1.a-t1.c-case when e<c*17 then t1.e when case case t1.b when t1.c then coalesce((select max(t1.c) from t1 where t1.c in (select ~cast(avg(case when 17 in (t1.f,t1.f,t1.a) then c when 13<>b then f else d end | t1.d) AS integer) from t1 union select count(distinct 11) from t1)),c) else t1.f end when f then 19 else t1.b end<t1.f then t1.b else t1.e end-11 not between 11 and t1.d)"
    end, {
        -- <randexpr-2.207>
        0
        -- </randexpr-2.207>
    })

test:do_test(
    "randexpr-2.208",
    function()
        return test:execsql "SELECT (abs(coalesce((select b from t1 where t1.a>(abs(t1.f)/abs(coalesce((select 13 from t1 where not coalesce((select (select cast(avg(case when case when t1.e not between t1.c and 19 then t1.d when d in (11,t1.b,13) then e else 17 end*b between 13 and (t1.b) then t1.f when a<>19 and t1.c not in (a,t1.f,b) then t1.e else t1.f end) AS integer) from t1)+t1.c-b* -a*f from t1 where (t1.d in (select c from t1 union select t1.b from t1))),t1.e)-c<>c),t1.c)))),e))/abs(t1.e)) FROM t1 WHERE NOT ((t1.a-t1.c-case when e<c*17 then t1.e when case case t1.b when t1.c then coalesce((select max(t1.c) from t1 where t1.c in (select ~cast(avg(case when 17 in (t1.f,t1.f,t1.a) then c when 13<>b then f else d end | t1.d) AS integer) from t1 union select count(distinct 11) from t1)),c) else t1.f end when f then 19 else t1.b end<t1.f then t1.b else t1.e end-11 not between 11 and t1.d))"
    end, {
        -- <randexpr-2.208>
        
        -- </randexpr-2.208>
    })

test:do_test(
    "randexpr-2.209",
    function()
        return test:execsql "SELECT case when t1.d<>d then case 11 when ~+case t1.a when (abs(t1.a)/abs( -c))*t1.c+ -a+coalesce((select t1.c from t1 where ((abs(e)/abs((case when (11>=e) then  -17 when (11)<=a then e else b end)+t1.f))>19)),b)-d then c else 17 end+ -b then ( -t1.a) else c end when 11<=t1.f then 11 else 17 end FROM t1 WHERE (coalesce((select max(17) from t1 where ~case ((select min( -e-a)*+cast(avg(11) AS integer)*count(*)-(count(*))*max(b)*min( -13)+count(*)-min( -13) from t1)+19)+a when e then (select min(f) from t1) else coalesce((select t1.f from t1 where 17>t1.c),19) end=11 and f=t1.b),19) not between  -a and t1.a)"
    end, {
        -- <randexpr-2.209>
        
        -- </randexpr-2.209>
    })

test:do_test(
    "randexpr-2.210",
    function()
        return test:execsql "SELECT case when t1.d<>d then case 11 when ~+case t1.a when (abs(t1.a)/abs( -c))*t1.c+ -a+coalesce((select t1.c from t1 where ((abs(e)/abs((case when (11>=e) then  -17 when (11)<=a then e else b end)+t1.f))>19)),b)-d then c else 17 end+ -b then ( -t1.a) else c end when 11<=t1.f then 11 else 17 end FROM t1 WHERE NOT ((coalesce((select max(17) from t1 where ~case ((select min( -e-a)*+cast(avg(11) AS integer)*count(*)-(count(*))*max(b)*min( -13)+count(*)-min( -13) from t1)+19)+a when e then (select min(f) from t1) else coalesce((select t1.f from t1 where 17>t1.c),19) end=11 and f=t1.b),19) not between  -a and t1.a))"
    end, {
        -- <randexpr-2.210>
        11
        -- </randexpr-2.210>
    })

test:do_test(
    "randexpr-2.211",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e) from t1 where not d in (select (abs(t1.f)/abs(~case when (abs(t1.e)/abs( -t1.a))+t1.b-t1.e*t1.a-t1.c between b and t1.e then f else a end+19)) from t1 union select 13 from t1) or (t1.e=(a)) and  -11 in (select t1.f from t1 union select c from t1)),a)*coalesce((select max(f) from t1 where d=f),f)*c+(t1.c) FROM t1 WHERE case when +(abs(19)/abs(13*t1.e))<>11 then 19 when coalesce((select max(c) from t1 where t1.e+t1.a between t1.f and f),t1.a)=(a) then d else  -19 end<=f or (((e in (b,t1.b,13)))) or b<(f) and t1.a<>11 or exists(select 1 from t1 where t1.d=d) or (t1.a)<>a or t1.a<>e"
    end, {
        -- <randexpr-2.211>
        90000300
        -- </randexpr-2.211>
    })

test:do_test(
    "randexpr-2.212",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e) from t1 where not d in (select (abs(t1.f)/abs(~case when (abs(t1.e)/abs( -t1.a))+t1.b-t1.e*t1.a-t1.c between b and t1.e then f else a end+19)) from t1 union select 13 from t1) or (t1.e=(a)) and  -11 in (select t1.f from t1 union select c from t1)),a)*coalesce((select max(f) from t1 where d=f),f)*c+(t1.c) FROM t1 WHERE NOT (case when +(abs(19)/abs(13*t1.e))<>11 then 19 when coalesce((select max(c) from t1 where t1.e+t1.a between t1.f and f),t1.a)=(a) then d else  -19 end<=f or (((e in (b,t1.b,13)))) or b<(f) and t1.a<>11 or exists(select 1 from t1 where t1.d=d) or (t1.a)<>a or t1.a<>e)"
    end, {
        -- <randexpr-2.212>
        
        -- </randexpr-2.212>
    })

test:do_test(
    "randexpr-2.213",
    function()
        return test:execsql "SELECT case (select abs(count(distinct  -17+(abs(c)/abs(case when exists(select 1 from t1 where (17<>(f))) then e when t1.c not between 11 and t1.d then +11 else t1.e end | b))+d)*+ -(min(f)*max(t1.e))*+cast(avg(t1.f) AS integer) | count(distinct (f))- - -count(*)-cast(avg((e)) AS integer)) from t1) when (abs(11)/abs(t1.e)) then 13 else b end FROM t1 WHERE case when t1.e not between coalesce((select (select count(*)+case max(17) when count(distinct 19-t1.c*t1.c-e) then  -min(b)-cast(avg((13)) AS integer)*count(*) else min(19) end from t1)*a*t1.d-17*a+17 from t1 where t1.d not in (13,t1.f, -c)),t1.c) and e then ( -b) when (13)>=(e) then t1.c else e end in (t1.d,t1.c, -11)"
    end, {
        -- <randexpr-2.213>
        
        -- </randexpr-2.213>
    })

test:do_test(
    "randexpr-2.214",
    function()
        return test:execsql "SELECT case (select abs(count(distinct  -17+(abs(c)/abs(case when exists(select 1 from t1 where (17<>(f))) then e when t1.c not between 11 and t1.d then +11 else t1.e end | b))+d)*+ -(min(f)*max(t1.e))*+cast(avg(t1.f) AS integer) | count(distinct (f))- - -count(*)-cast(avg((e)) AS integer)) from t1) when (abs(11)/abs(t1.e)) then 13 else b end FROM t1 WHERE NOT (case when t1.e not between coalesce((select (select count(*)+case max(17) when count(distinct 19-t1.c*t1.c-e) then  -min(b)-cast(avg((13)) AS integer)*count(*) else min(19) end from t1)*a*t1.d-17*a+17 from t1 where t1.d not in (13,t1.f, -c)),t1.c) and e then ( -b) when (13)>=(e) then t1.c else e end in (t1.d,t1.c, -11))"
    end, {
        -- <randexpr-2.214>
        200
        -- </randexpr-2.214>
    })

test:do_test(
    "randexpr-2.215",
    function()
        return test:execsql "SELECT case (select abs(count(distinct  -17+(abs(c)/abs(case when exists(select 1 from t1 where (17<>(f))) then e when t1.c not between 11 and t1.d then +11 else t1.e end & b))+d)*+ -(min(f)*max(t1.e))*+cast(avg(t1.f) AS integer) & count(distinct (f))- - -count(*)-cast(avg((e)) AS integer)) from t1) when (abs(11)/abs(t1.e)) then 13 else b end FROM t1 WHERE NOT (case when t1.e not between coalesce((select (select count(*)+case max(17) when count(distinct 19-t1.c*t1.c-e) then  -min(b)-cast(avg((13)) AS integer)*count(*) else min(19) end from t1)*a*t1.d-17*a+17 from t1 where t1.d not in (13,t1.f, -c)),t1.c) and e then ( -b) when (13)>=(e) then t1.c else e end in (t1.d,t1.c, -11))"
    end, {
        -- <randexpr-2.215>
        200
        -- </randexpr-2.215>
    })

test:do_test(
    "randexpr-2.216",
    function()
        return test:execsql "SELECT  -case when d<d or not exists(select 1 from t1 where not exists(select 1 from t1 where not not not exists(select 1 from t1 where not e+~t1.c between t1.e and t1.c and t1.c>t1.d))) then case +coalesce((select case when 13>t1.b then 17+t1.d+d when 17 in (t1.b,b,b) and 17<=t1.e then (c) else t1.d end from t1 where 17<a),11) when f then t1.c else b end when 19 between 11 and t1.e then f else a end-19*13 FROM t1 WHERE exists(select 1 from t1 where +13 in (select count(distinct 13) from t1 union select case count(*)+ -(max(t1.c)) when count(*) | ~( -count(*)-count(distinct  -f))+min(a)-max(t1.b) then  - -max(13) else max(e) end+count(distinct 17) from t1) and d*t1.b>b+t1.a*t1.a-coalesce((select max(d) from t1 where (17 between (t1.d) and (f))),t1.e)-t1.c and t1.d>11)"
    end, {
        -- <randexpr-2.216>
        
        -- </randexpr-2.216>
    })

test:do_test(
    "randexpr-2.217",
    function()
        return test:execsql "SELECT  -case when d<d or not exists(select 1 from t1 where not exists(select 1 from t1 where not not not exists(select 1 from t1 where not e+~t1.c between t1.e and t1.c and t1.c>t1.d))) then case +coalesce((select case when 13>t1.b then 17+t1.d+d when 17 in (t1.b,b,b) and 17<=t1.e then (c) else t1.d end from t1 where 17<a),11) when f then t1.c else b end when 19 between 11 and t1.e then f else a end-19*13 FROM t1 WHERE NOT (exists(select 1 from t1 where +13 in (select count(distinct 13) from t1 union select case count(*)+ -(max(t1.c)) when count(*) | ~( -count(*)-count(distinct  -f))+min(a)-max(t1.b) then  - -max(13) else max(e) end+count(distinct 17) from t1) and d*t1.b>b+t1.a*t1.a-coalesce((select max(d) from t1 where (17 between (t1.d) and (f))),t1.e)-t1.c and t1.d>11))"
    end, {
        -- <randexpr-2.217>
        -447
        -- </randexpr-2.217>
    })

test:do_test(
    "randexpr-2.218",
    function()
        return test:execsql "SELECT (select + -max(t1.c)*abs(min(t1.b) | case (abs(min(13)))+count(*)-max(t1.a) when max(~13) then abs( -~min(t1.b)+abs(count(distinct (select +++cast(avg(t1.b) AS integer)-case  -count(*) when  -count(*) then  -count(distinct b) else count(distinct c) end from t1)))) else count(*) end-max((e))) |  -cast(avg(t1.e) AS integer) from t1) FROM t1 WHERE exists(select 1 from t1 where  -f-d*t1.f-c-coalesce((select max(t1.a) from t1 where 11 not in ((select count(*) from t1),coalesce((select max(t1.f+e) from t1 where t1.b in (select count(distinct t1.c) from t1 union select  -case abs(abs(count(distinct 13))) when max(t1.b) then abs(cast(avg(11) AS integer)) else  -cast(avg(17) AS integer) end from t1)),case t1.f when  -b then 17 else 17 end)- -t1.f,b)),a)+f+c-t1.c<t1.b)"
    end, {
        -- <randexpr-2.218>
        -452
        -- </randexpr-2.218>
    })

test:do_test(
    "randexpr-2.219",
    function()
        return test:execsql "SELECT (select + -max(t1.c)*abs(min(t1.b) | case (abs(min(13)))+count(*)-max(t1.a) when max(~13) then abs( -~min(t1.b)+abs(count(distinct (select +++cast(avg(t1.b) AS integer)-case  -count(*) when  -count(*) then  -count(distinct b) else count(distinct c) end from t1)))) else count(*) end-max((e))) |  -cast(avg(t1.e) AS integer) from t1) FROM t1 WHERE NOT (exists(select 1 from t1 where  -f-d*t1.f-c-coalesce((select max(t1.a) from t1 where 11 not in ((select count(*) from t1),coalesce((select max(t1.f+e) from t1 where t1.b in (select count(distinct t1.c) from t1 union select  -case abs(abs(count(distinct 13))) when max(t1.b) then abs(cast(avg(11) AS integer)) else  -cast(avg(17) AS integer) end from t1)),case t1.f when  -b then 17 else 17 end)- -t1.f,b)),a)+f+c-t1.c<t1.b))"
    end, {
        -- <randexpr-2.219>
        
        -- </randexpr-2.219>
    })

test:do_test(
    "randexpr-2.220",
    function()
        return test:execsql "SELECT (select + -max(t1.c)*abs(min(t1.b) & case (abs(min(13)))+count(*)-max(t1.a) when max(~13) then abs( -~min(t1.b)+abs(count(distinct (select +++cast(avg(t1.b) AS integer)-case  -count(*) when  -count(*) then  -count(distinct b) else count(distinct c) end from t1)))) else count(*) end-max((e))) &  -cast(avg(t1.e) AS integer) from t1) FROM t1 WHERE exists(select 1 from t1 where  -f-d*t1.f-c-coalesce((select max(t1.a) from t1 where 11 not in ((select count(*) from t1),coalesce((select max(t1.f+e) from t1 where t1.b in (select count(distinct t1.c) from t1 union select  -case abs(abs(count(distinct 13))) when max(t1.b) then abs(cast(avg(11) AS integer)) else  -cast(avg(17) AS integer) end from t1)),case t1.f when  -b then 17 else 17 end)- -t1.f,b)),a)+f+c-t1.c<t1.b)"
    end, {
        -- <randexpr-2.220>
        -2560
        -- </randexpr-2.220>
    })

test:do_test(
    "randexpr-2.221",
    function()
        return test:execsql "SELECT  -+(select count(distinct case when (case ~c | coalesce((select max(t1.e-f+t1.d) from t1 where b-coalesce((select max(b) from t1 where t1.c in (select max(t1.d) from t1 union select min(a) from t1)),t1.f) in (select t1.a from t1 union select e from t1)),c) when e then  -c else  -t1.b end in ( -19, -d,b)) then d when t1.e in (19,d,19) and (t1.b between c and t1.a) then t1.d else 17 end-d) from t1) FROM t1 WHERE f<= -b"
    end, {
        -- <randexpr-2.221>
        
        -- </randexpr-2.221>
    })

test:do_test(
    "randexpr-2.222",
    function()
        return test:execsql "SELECT  -+(select count(distinct case when (case ~c | coalesce((select max(t1.e-f+t1.d) from t1 where b-coalesce((select max(b) from t1 where t1.c in (select max(t1.d) from t1 union select min(a) from t1)),t1.f) in (select t1.a from t1 union select e from t1)),c) when e then  -c else  -t1.b end in ( -19, -d,b)) then d when t1.e in (19,d,19) and (t1.b between c and t1.a) then t1.d else 17 end-d) from t1) FROM t1 WHERE NOT (f<= -b)"
    end, {
        -- <randexpr-2.222>
        -1
        -- </randexpr-2.222>
    })

test:do_test(
    "randexpr-2.223",
    function()
        return test:execsql "SELECT  -+(select count(distinct case when (case ~c & coalesce((select max(t1.e-f+t1.d) from t1 where b-coalesce((select max(b) from t1 where t1.c in (select max(t1.d) from t1 union select min(a) from t1)),t1.f) in (select t1.a from t1 union select e from t1)),c) when e then  -c else  -t1.b end in ( -19, -d,b)) then d when t1.e in (19,d,19) and (t1.b between c and t1.a) then t1.d else 17 end-d) from t1) FROM t1 WHERE NOT (f<= -b)"
    end, {
        -- <randexpr-2.223>
        -1
        -- </randexpr-2.223>
    })

test:do_test(
    "randexpr-2.224",
    function()
        return test:execsql "SELECT (abs(~(+t1.b))/abs(~coalesce((select max(t1.a) from t1 where t1.f<+case when not exists(select 1 from t1 where not c+11=case c when t1.e then 13 else t1.f end+t1.e) and t1.f in (select 11 from t1 union select t1.d from t1) and c not in (t1.f,17,a) then case when a=17 or t1.c between t1.e and 19 or t1.a<>e then 19 else t1.c-t1.d end else b end),(e))-t1.a+(13)-19)) FROM t1 WHERE (not t1.e not in (case when exists(select 1 from t1 where 17<=t1.f*17*t1.b) then f+coalesce((select max(t1.b-c-11+t1.c-a) from t1 where 13 in (select t1.e from t1 union select case when a not between t1.f and d or f<t1.f then d when t1.f<=e then d else e end+17- -17 from t1)),t1.c) else t1.f end,e,t1.a) or exists(select 1 from t1 where t1.a not in (t1.c,(t1.d),(t1.c))))"
    end, {
        -- <randexpr-2.224>
        0
        -- </randexpr-2.224>
    })

test:do_test(
    "randexpr-2.225",
    function()
        return test:execsql "SELECT (abs(~(+t1.b))/abs(~coalesce((select max(t1.a) from t1 where t1.f<+case when not exists(select 1 from t1 where not c+11=case c when t1.e then 13 else t1.f end+t1.e) and t1.f in (select 11 from t1 union select t1.d from t1) and c not in (t1.f,17,a) then case when a=17 or t1.c between t1.e and 19 or t1.a<>e then 19 else t1.c-t1.d end else b end),(e))-t1.a+(13)-19)) FROM t1 WHERE NOT ((not t1.e not in (case when exists(select 1 from t1 where 17<=t1.f*17*t1.b) then f+coalesce((select max(t1.b-c-11+t1.c-a) from t1 where 13 in (select t1.e from t1 union select case when a not between t1.f and d or f<t1.f then d when t1.f<=e then d else e end+17- -17 from t1)),t1.c) else t1.f end,e,t1.a) or exists(select 1 from t1 where t1.a not in (t1.c,(t1.d),(t1.c)))))"
    end, {
        -- <randexpr-2.225>
        
        -- </randexpr-2.225>
    })

test:do_test(
    "randexpr-2.226",
    function()
        return test:execsql "SELECT (select min(b) | case case cast(avg(c) AS integer) when ~+~count(distinct  -19*f*f) then count(distinct (select cast(avg(d-case when t1.a<=19 then 19 else 11 end+f+a) AS integer) from t1))+count(distinct t1.c)+ -+ -count(*) |  - -max((17))*min(t1.b)*min((e)) else max(t1.c) end when ( - - -min(a)) then ( -min(c)) else max((11)) end from t1) FROM t1 WHERE case when (((exists(select 1 from t1 where ~t1.d-t1.f between  -+t1.f*c and f and not t1.e in (19,a,13))) or  -e>=t1.b) and (t1.e<>( -t1.d)) and (t1.c<=13)) then c else d+11 end<=case when (t1.c)>=19 then (t1.e) when (f) not between 11 and f then coalesce((select 13 from t1 where  -t1.b>=d),13) else b end"
    end, {
        -- <randexpr-2.226>
        203
        -- </randexpr-2.226>
    })

test:do_test(
    "randexpr-2.227",
    function()
        return test:execsql "SELECT (select min(b) | case case cast(avg(c) AS integer) when ~+~count(distinct  -19*f*f) then count(distinct (select cast(avg(d-case when t1.a<=19 then 19 else 11 end+f+a) AS integer) from t1))+count(distinct t1.c)+ -+ -count(*) |  - -max((17))*min(t1.b)*min((e)) else max(t1.c) end when ( - - -min(a)) then ( -min(c)) else max((11)) end from t1) FROM t1 WHERE NOT (case when (((exists(select 1 from t1 where ~t1.d-t1.f between  -+t1.f*c and f and not t1.e in (19,a,13))) or  -e>=t1.b) and (t1.e<>( -t1.d)) and (t1.c<=13)) then c else d+11 end<=case when (t1.c)>=19 then (t1.e) when (f) not between 11 and f then coalesce((select 13 from t1 where  -t1.b>=d),13) else b end)"
    end, {
        -- <randexpr-2.227>
        
        -- </randexpr-2.227>
    })

test:do_test(
    "randexpr-2.228",
    function()
        return test:execsql "SELECT (select min(b) & case case cast(avg(c) AS integer) when ~+~count(distinct  -19*f*f) then count(distinct (select cast(avg(d-case when t1.a<=19 then 19 else 11 end+f+a) AS integer) from t1))+count(distinct t1.c)+ -+ -count(*) &  - -max((17))*min(t1.b)*min((e)) else max(t1.c) end when ( - - -min(a)) then ( -min(c)) else max((11)) end from t1) FROM t1 WHERE case when (((exists(select 1 from t1 where ~t1.d-t1.f between  -+t1.f*c and f and not t1.e in (19,a,13))) or  -e>=t1.b) and (t1.e<>( -t1.d)) and (t1.c<=13)) then c else d+11 end<=case when (t1.c)>=19 then (t1.e) when (f) not between 11 and f then coalesce((select 13 from t1 where  -t1.b>=d),13) else b end"
    end, {
        -- <randexpr-2.228>
        8
        -- </randexpr-2.228>
    })

test:do_test(
    "randexpr-2.229",
    function()
        return test:execsql "SELECT case when 19-b in (select (min(case coalesce((select e from t1 where (c not between c and e)),(select abs(count(distinct coalesce((select max( -coalesce((select max(17) from t1 where (d)>17 and c not between d and b),11)-d) from t1 where ((11)) not in (d,d,e)), - -e))) from t1)+t1.e+t1.a) when f then t1.e else t1.a end)) from t1 union select max(11) from t1) then c else f end+t1.e FROM t1 WHERE coalesce((select max(d) from t1 where coalesce((select max(case when (a++19=case t1.d when t1.e then t1.b else t1.a end*f) and  -13=a then case t1.d+13 when t1.f then 17 else t1.f end when (11 not in (d,17,t1.f)) then e else 11 end+b*t1.b) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where t1.f in (select t1.e from t1 union select b from t1)))),(d))<=c),a) between t1.f and d"
    end, {
        -- <randexpr-2.229>
        
        -- </randexpr-2.229>
    })

test:do_test(
    "randexpr-2.230",
    function()
        return test:execsql "SELECT case when 19-b in (select (min(case coalesce((select e from t1 where (c not between c and e)),(select abs(count(distinct coalesce((select max( -coalesce((select max(17) from t1 where (d)>17 and c not between d and b),11)-d) from t1 where ((11)) not in (d,d,e)), - -e))) from t1)+t1.e+t1.a) when f then t1.e else t1.a end)) from t1 union select max(11) from t1) then c else f end+t1.e FROM t1 WHERE NOT (coalesce((select max(d) from t1 where coalesce((select max(case when (a++19=case t1.d when t1.e then t1.b else t1.a end*f) and  -13=a then case t1.d+13 when t1.f then 17 else t1.f end when (11 not in (d,17,t1.f)) then e else 11 end+b*t1.b) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where t1.f in (select t1.e from t1 union select b from t1)))),(d))<=c),a) between t1.f and d)"
    end, {
        -- <randexpr-2.230>
        1100
        -- </randexpr-2.230>
    })

test:do_test(
    "randexpr-2.231",
    function()
        return test:execsql "SELECT  -t1.e*coalesce((select max(17) from t1 where (11*(select case  -abs( -+count(*)) when  -case +(cast(avg( -f) AS integer)) | (abs(cast(avg(c) AS integer))) when min(d) then  -max(t1.f) else count(*) end then cast(avg( -t1.f) AS integer) else max(b) end from t1)*~t1.e*case (select min(e) from t1) when 17-t1.b then (e) else t1.f+t1.f end) in (select t1.d from t1 union select 19 from t1)), -t1.a) FROM t1 WHERE (select min(19) from t1) in (select 17 from t1 union select  -11+t1.d+t1.c from t1)"
    end, {
        -- <randexpr-2.231>
        
        -- </randexpr-2.231>
    })

test:do_test(
    "randexpr-2.232",
    function()
        return test:execsql "SELECT  -t1.e*coalesce((select max(17) from t1 where (11*(select case  -abs( -+count(*)) when  -case +(cast(avg( -f) AS integer)) | (abs(cast(avg(c) AS integer))) when min(d) then  -max(t1.f) else count(*) end then cast(avg( -t1.f) AS integer) else max(b) end from t1)*~t1.e*case (select min(e) from t1) when 17-t1.b then (e) else t1.f+t1.f end) in (select t1.d from t1 union select 19 from t1)), -t1.a) FROM t1 WHERE NOT ((select min(19) from t1) in (select 17 from t1 union select  -11+t1.d+t1.c from t1))"
    end, {
        -- <randexpr-2.232>
        50000
        -- </randexpr-2.232>
    })

test:do_test(
    "randexpr-2.233",
    function()
        return test:execsql "SELECT  -t1.e*coalesce((select max(17) from t1 where (11*(select case  -abs( -+count(*)) when  -case +(cast(avg( -f) AS integer)) & (abs(cast(avg(c) AS integer))) when min(d) then  -max(t1.f) else count(*) end then cast(avg( -t1.f) AS integer) else max(b) end from t1)*~t1.e*case (select min(e) from t1) when 17-t1.b then (e) else t1.f+t1.f end) in (select t1.d from t1 union select 19 from t1)), -t1.a) FROM t1 WHERE NOT ((select min(19) from t1) in (select 17 from t1 union select  -11+t1.d+t1.c from t1))"
    end, {
        -- <randexpr-2.233>
        50000
        -- </randexpr-2.233>
    })

test:do_test(
    "randexpr-2.234",
    function()
        return test:execsql "SELECT (coalesce((select max(case when t1.e>= -e | 13-19*d then case when c not in (+(select count(*) from t1),coalesce((select max(t1.a) from t1 where 13 in (select case count(distinct t1.a) | count(*) when cast(avg(t1.b) AS integer) then count(distinct a) else min(11) end from t1 union select count(*) from t1)),19),t1.a) then t1.c else c end when t1.f in (select t1.f from t1 union select t1.e from t1) then t1.e else  -t1.e end) from t1 where (17 in (e,d,a))),t1.d)* -19) FROM t1 WHERE (((abs(t1.f)/abs(d)) in (select case (case max(coalesce((select max(e*(t1.d*13+t1.b)-t1.b) from t1 where t1.a=13),(t1.c))) when (case max(t1.a) when  -abs(max(17))-count(distinct 19) then cast(avg(t1.d) AS integer) else max(13) end)*count(distinct t1.c) then (max((t1.b))) else min(19) end) when max(f) then  -(count(distinct t1.f)) else min(t1.b) end from t1 union select cast(avg(13) AS integer) from t1) and (13 in (select ((min(b))) from t1 union select  - -count(*) from t1))))"
    end, {
        -- <randexpr-2.234>
        
        -- </randexpr-2.234>
    })

test:do_test(
    "randexpr-2.235",
    function()
        return test:execsql "SELECT (coalesce((select max(case when t1.e>= -e | 13-19*d then case when c not in (+(select count(*) from t1),coalesce((select max(t1.a) from t1 where 13 in (select case count(distinct t1.a) | count(*) when cast(avg(t1.b) AS integer) then count(distinct a) else min(11) end from t1 union select count(*) from t1)),19),t1.a) then t1.c else c end when t1.f in (select t1.f from t1 union select t1.e from t1) then t1.e else  -t1.e end) from t1 where (17 in (e,d,a))),t1.d)* -19) FROM t1 WHERE NOT ((((abs(t1.f)/abs(d)) in (select case (case max(coalesce((select max(e*(t1.d*13+t1.b)-t1.b) from t1 where t1.a=13),(t1.c))) when (case max(t1.a) when  -abs(max(17))-count(distinct 19) then cast(avg(t1.d) AS integer) else max(13) end)*count(distinct t1.c) then (max((t1.b))) else min(19) end) when max(f) then  -(count(distinct t1.f)) else min(t1.b) end from t1 union select cast(avg(13) AS integer) from t1) and (13 in (select ((min(b))) from t1 union select  - -count(*) from t1)))))"
    end, {
        -- <randexpr-2.235>
        -7600
        -- </randexpr-2.235>
    })

test:do_test(
    "randexpr-2.236",
    function()
        return test:execsql "SELECT (coalesce((select max(case when t1.e>= -e & 13-19*d then case when c not in (+(select count(*) from t1),coalesce((select max(t1.a) from t1 where 13 in (select case count(distinct t1.a) & count(*) when cast(avg(t1.b) AS integer) then count(distinct a) else min(11) end from t1 union select count(*) from t1)),19),t1.a) then t1.c else c end when t1.f in (select t1.f from t1 union select t1.e from t1) then t1.e else  -t1.e end) from t1 where (17 in (e,d,a))),t1.d)* -19) FROM t1 WHERE NOT ((((abs(t1.f)/abs(d)) in (select case (case max(coalesce((select max(e*(t1.d*13+t1.b)-t1.b) from t1 where t1.a=13),(t1.c))) when (case max(t1.a) when  -abs(max(17))-count(distinct 19) then cast(avg(t1.d) AS integer) else max(13) end)*count(distinct t1.c) then (max((t1.b))) else min(19) end) when max(f) then  -(count(distinct t1.f)) else min(t1.b) end from t1 union select cast(avg(13) AS integer) from t1) and (13 in (select ((min(b))) from t1 union select  - -count(*) from t1)))))"
    end, {
        -- <randexpr-2.236>
        -7600
        -- </randexpr-2.236>
    })

test:do_test(
    "randexpr-2.237",
    function()
        return test:execsql "SELECT case when case when b in (select abs(abs( -max(case c+d when f then f else 19 end | c)-( -case min(c) when  -(cast(avg((t1.f)) AS integer)) then count(*) else ((cast(avg(t1.b) AS integer))) end))+count(*)+(max(17))) from t1 union select count(*) from t1) then t1.a when ~13*t1.a- -c not in (b,e,19) then t1.c else (t1.d) end<=(b) and 13 between t1.f and 11 then t1.f else  -19 end FROM t1 WHERE d>=case when t1.d+case when ( -17)-c>11 or b in ((select min(13)+ -cast(avg(11) AS integer) from t1)+~t1.f, -c,(13)) and e in (select (d) from t1 union select f from t1) then t1.a when d= -t1.d then a- -17 else 17 end-t1.c>d then 11 when exists(select 1 from t1 where 17 not between t1.b and t1.b) then t1.b else (t1.a) end"
    end, {
        -- <randexpr-2.237>
        -19
        -- </randexpr-2.237>
    })

test:do_test(
    "randexpr-2.238",
    function()
        return test:execsql "SELECT case when case when b in (select abs(abs( -max(case c+d when f then f else 19 end | c)-( -case min(c) when  -(cast(avg((t1.f)) AS integer)) then count(*) else ((cast(avg(t1.b) AS integer))) end))+count(*)+(max(17))) from t1 union select count(*) from t1) then t1.a when ~13*t1.a- -c not in (b,e,19) then t1.c else (t1.d) end<=(b) and 13 between t1.f and 11 then t1.f else  -19 end FROM t1 WHERE NOT (d>=case when t1.d+case when ( -17)-c>11 or b in ((select min(13)+ -cast(avg(11) AS integer) from t1)+~t1.f, -c,(13)) and e in (select (d) from t1 union select f from t1) then t1.a when d= -t1.d then a- -17 else 17 end-t1.c>d then 11 when exists(select 1 from t1 where 17 not between t1.b and t1.b) then t1.b else (t1.a) end)"
    end, {
        -- <randexpr-2.238>
        
        -- </randexpr-2.238>
    })

test:do_test(
    "randexpr-2.239",
    function()
        return test:execsql "SELECT case when case when b in (select abs(abs( -max(case c+d when f then f else 19 end & c)-( -case min(c) when  -(cast(avg((t1.f)) AS integer)) then count(*) else ((cast(avg(t1.b) AS integer))) end))+count(*)+(max(17))) from t1 union select count(*) from t1) then t1.a when ~13*t1.a- -c not in (b,e,19) then t1.c else (t1.d) end<=(b) and 13 between t1.f and 11 then t1.f else  -19 end FROM t1 WHERE d>=case when t1.d+case when ( -17)-c>11 or b in ((select min(13)+ -cast(avg(11) AS integer) from t1)+~t1.f, -c,(13)) and e in (select (d) from t1 union select f from t1) then t1.a when d= -t1.d then a- -17 else 17 end-t1.c>d then 11 when exists(select 1 from t1 where 17 not between t1.b and t1.b) then t1.b else (t1.a) end"
    end, {
        -- <randexpr-2.239>
        -19
        -- </randexpr-2.239>
    })

test:do_test(
    "randexpr-2.240",
    function()
        return test:execsql "SELECT e-coalesce((select coalesce((select max(19) from t1 where (coalesce((select max(case 11 when b then 13 else t1.a end) from t1 where 19 not in (c,t1.f,b)),t1.a)+t1.d in (select 17 from t1 union select 19 from t1) and 11 in (13,t1.c,17) or 19 not in (t1.f,a,17) or t1.e not between 13 and f and a>=d)),(a)-17+t1.f)+t1.a+17 from t1 where not exists(select 1 from t1 where a>t1.f)),t1.b) FROM t1 WHERE t1.a-17 in (select (abs(count(*)))-case case case abs(abs(count(*))) when min(t1.f) then count(*) else cast(avg(+t1.a+(e) | 19*e+t1.f) AS integer) end when abs(+cast(avg(b) AS integer) | count(distinct (13))*+~ -(min(e)) | cast(avg(19) AS integer)) then cast(avg(19) AS integer) else count(distinct t1.c) end | min(t1.d) when count(*) then (count(distinct d)) else (min(11)) end from t1 union select (cast(avg(t1.a) AS integer)) from t1)"
    end, {
        -- <randexpr-2.240>
        
        -- </randexpr-2.240>
    })

test:do_test(
    "randexpr-2.241",
    function()
        return test:execsql "SELECT e-coalesce((select coalesce((select max(19) from t1 where (coalesce((select max(case 11 when b then 13 else t1.a end) from t1 where 19 not in (c,t1.f,b)),t1.a)+t1.d in (select 17 from t1 union select 19 from t1) and 11 in (13,t1.c,17) or 19 not in (t1.f,a,17) or t1.e not between 13 and f and a>=d)),(a)-17+t1.f)+t1.a+17 from t1 where not exists(select 1 from t1 where a>t1.f)),t1.b) FROM t1 WHERE NOT (t1.a-17 in (select (abs(count(*)))-case case case abs(abs(count(*))) when min(t1.f) then count(*) else cast(avg(+t1.a+(e) | 19*e+t1.f) AS integer) end when abs(+cast(avg(b) AS integer) | count(distinct (13))*+~ -(min(e)) | cast(avg(19) AS integer)) then cast(avg(19) AS integer) else count(distinct t1.c) end | min(t1.d) when count(*) then (count(distinct d)) else (min(11)) end from t1 union select (cast(avg(t1.a) AS integer)) from t1))"
    end, {
        -- <randexpr-2.241>
        364
        -- </randexpr-2.241>
    })

test:do_test(
    "randexpr-2.242",
    function()
        return test:execsql "SELECT  -coalesce((select case when b>19 | f-(select abs(max(t1.b+case when e>17 then 11 else f end)+count(*)) from t1) and case when (19<11*t1.d*t1.b) then 13 else t1.e end not between c and b then d+17 else c end-f from t1 where t1.b>=f),t1.c)+17-a FROM t1 WHERE +c in (+~a+case when ((case t1.d when coalesce((select f from t1 where e in (select count(distinct t1.e) from t1 union select min((abs(t1.c)/abs(e | b)) | d* -t1.d) from t1)),t1.e)+a then c else b end in (select  -cast(avg(t1.c) AS integer)-~cast(avg(11) AS integer) from t1 union select  -count(distinct 19) from t1))) then  -e*19 else 13 end,t1.a,d)"
    end, {
        -- <randexpr-2.242>
        
        -- </randexpr-2.242>
    })

test:do_test(
    "randexpr-2.243",
    function()
        return test:execsql "SELECT  -coalesce((select case when b>19 | f-(select abs(max(t1.b+case when e>17 then 11 else f end)+count(*)) from t1) and case when (19<11*t1.d*t1.b) then 13 else t1.e end not between c and b then d+17 else c end-f from t1 where t1.b>=f),t1.c)+17-a FROM t1 WHERE NOT (+c in (+~a+case when ((case t1.d when coalesce((select f from t1 where e in (select count(distinct t1.e) from t1 union select min((abs(t1.c)/abs(e | b)) | d* -t1.d) from t1)),t1.e)+a then c else b end in (select  -cast(avg(t1.c) AS integer)-~cast(avg(11) AS integer) from t1 union select  -count(distinct 19) from t1))) then  -e*19 else 13 end,t1.a,d))"
    end, {
        -- <randexpr-2.243>
        -383
        -- </randexpr-2.243>
    })

test:do_test(
    "randexpr-2.244",
    function()
        return test:execsql "SELECT  -coalesce((select case when b>19 & f-(select abs(max(t1.b+case when e>17 then 11 else f end)+count(*)) from t1) and case when (19<11*t1.d*t1.b) then 13 else t1.e end not between c and b then d+17 else c end-f from t1 where t1.b>=f),t1.c)+17-a FROM t1 WHERE NOT (+c in (+~a+case when ((case t1.d when coalesce((select f from t1 where e in (select count(distinct t1.e) from t1 union select min((abs(t1.c)/abs(e | b)) | d* -t1.d) from t1)),t1.e)+a then c else b end in (select  -cast(avg(t1.c) AS integer)-~cast(avg(11) AS integer) from t1 union select  -count(distinct 19) from t1))) then  -e*19 else 13 end,t1.a,d))"
    end, {
        -- <randexpr-2.244>
        -383
        -- </randexpr-2.244>
    })

test:do_test(
    "randexpr-2.245",
    function()
        return test:execsql "SELECT case when t1.b>=+(abs(t1.e)/abs(coalesce((select c from t1 where 17<=+(e)),(e)-+~11*17+t1.d-e | +coalesce((select max(t1.d) from t1 where f>e),t1.a)*b | (e))))-t1.a and c>=t1.d or (17 not between e and b) then t1.e else d end FROM t1 WHERE exists(select 1 from t1 where (19-((17))+(b) in (select d*e*a from t1 union select ~19 from t1)) and case b-(abs(case a when coalesce((select max(19) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where b not between e and (t1.f) or a not in (t1.c,17,t1.d)))),case t1.b when  -d then 13 else 13 end)*a+t1.c then e else a end)/abs(t1.d))*t1.e when  -13 then t1.c else 19 end in (select +count(distinct e) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.245>
        
        -- </randexpr-2.245>
    })

test:do_test(
    "randexpr-2.246",
    function()
        return test:execsql "SELECT case when t1.b>=+(abs(t1.e)/abs(coalesce((select c from t1 where 17<=+(e)),(e)-+~11*17+t1.d-e | +coalesce((select max(t1.d) from t1 where f>e),t1.a)*b | (e))))-t1.a and c>=t1.d or (17 not between e and b) then t1.e else d end FROM t1 WHERE NOT (exists(select 1 from t1 where (19-((17))+(b) in (select d*e*a from t1 union select ~19 from t1)) and case b-(abs(case a when coalesce((select max(19) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where b not between e and (t1.f) or a not in (t1.c,17,t1.d)))),case t1.b when  -d then 13 else 13 end)*a+t1.c then e else a end)/abs(t1.d))*t1.e when  -13 then t1.c else 19 end in (select +count(distinct e) from t1 union select count(*) from t1)))"
    end, {
        -- <randexpr-2.246>
        500
        -- </randexpr-2.246>
    })

test:do_test(
    "randexpr-2.247",
    function()
        return test:execsql "SELECT case when t1.b>=+(abs(t1.e)/abs(coalesce((select c from t1 where 17<=+(e)),(e)-+~11*17+t1.d-e & +coalesce((select max(t1.d) from t1 where f>e),t1.a)*b & (e))))-t1.a and c>=t1.d or (17 not between e and b) then t1.e else d end FROM t1 WHERE NOT (exists(select 1 from t1 where (19-((17))+(b) in (select d*e*a from t1 union select ~19 from t1)) and case b-(abs(case a when coalesce((select max(19) from t1 where exists(select 1 from t1 where exists(select 1 from t1 where b not between e and (t1.f) or a not in (t1.c,17,t1.d)))),case t1.b when  -d then 13 else 13 end)*a+t1.c then e else a end)/abs(t1.d))*t1.e when  -13 then t1.c else 19 end in (select +count(distinct e) from t1 union select count(*) from t1)))"
    end, {
        -- <randexpr-2.247>
        500
        -- </randexpr-2.247>
    })

test:do_test(
    "randexpr-2.248",
    function()
        return test:execsql "SELECT case when 11 in (select min(+t1.e)* -max(a)+count(distinct d*11*c)*(count(distinct (e))) | ( -min(t1.b)) | count(distinct 19) | (max(t1.f))-max(t1.b) from t1 union select (min(19)) from t1) then coalesce((select max(17) from t1 where  -17=13 or c in (select t1.d from t1 union select d from t1)),b)*t1.b-a+19 when t1.d<(d) then (d) else 19 end FROM t1 WHERE case when case when t1.c not in (f,19,b) then t1.d-t1.c-case when 17<>t1.a then  -(abs((select cast(avg(b) AS integer)- -max(t1.c) from t1))/abs(t1.c)) else t1.f end-17 | 19 when exists(select 1 from t1 where exists(select 1 from t1 where (e between 13 and (t1.a))) and e<=t1.c) then f else t1.a end>=11 then c when f<a then t1.b else t1.e end=t1.c"
    end, {
        -- <randexpr-2.248>
        19
        -- </randexpr-2.248>
    })

test:do_test(
    "randexpr-2.249",
    function()
        return test:execsql "SELECT case when 11 in (select min(+t1.e)* -max(a)+count(distinct d*11*c)*(count(distinct (e))) | ( -min(t1.b)) | count(distinct 19) | (max(t1.f))-max(t1.b) from t1 union select (min(19)) from t1) then coalesce((select max(17) from t1 where  -17=13 or c in (select t1.d from t1 union select d from t1)),b)*t1.b-a+19 when t1.d<(d) then (d) else 19 end FROM t1 WHERE NOT (case when case when t1.c not in (f,19,b) then t1.d-t1.c-case when 17<>t1.a then  -(abs((select cast(avg(b) AS integer)- -max(t1.c) from t1))/abs(t1.c)) else t1.f end-17 | 19 when exists(select 1 from t1 where exists(select 1 from t1 where (e between 13 and (t1.a))) and e<=t1.c) then f else t1.a end>=11 then c when f<a then t1.b else t1.e end=t1.c)"
    end, {
        -- <randexpr-2.249>
        
        -- </randexpr-2.249>
    })

test:do_test(
    "randexpr-2.250",
    function()
        return test:execsql "SELECT case when 11 in (select min(+t1.e)* -max(a)+count(distinct d*11*c)*(count(distinct (e))) & ( -min(t1.b)) & count(distinct 19) & (max(t1.f))-max(t1.b) from t1 union select (min(19)) from t1) then coalesce((select max(17) from t1 where  -17=13 or c in (select t1.d from t1 union select d from t1)),b)*t1.b-a+19 when t1.d<(d) then (d) else 19 end FROM t1 WHERE case when case when t1.c not in (f,19,b) then t1.d-t1.c-case when 17<>t1.a then  -(abs((select cast(avg(b) AS integer)- -max(t1.c) from t1))/abs(t1.c)) else t1.f end-17 | 19 when exists(select 1 from t1 where exists(select 1 from t1 where (e between 13 and (t1.a))) and e<=t1.c) then f else t1.a end>=11 then c when f<a then t1.b else t1.e end=t1.c"
    end, {
        -- <randexpr-2.250>
        19
        -- </randexpr-2.250>
    })

test:do_test(
    "randexpr-2.251",
    function()
        return test:execsql "SELECT c*~17+~case when (exists(select 1 from t1 where not exists(select 1 from t1 where (abs(e)/abs(c))=case when t1.c not in (a,13,11) and t1.b>=c then t1.b else t1.f end)) and 17<>f) then case when (e) not in (t1.a,t1.f,e) then case case t1.c when 13 then 19 else t1.d end-19 when t1.d then  -t1.b else t1.f end when t1.d not in (17,t1.a,t1.d) or c in (d,(19),t1.b) then  -t1.b else c end else 19 end+t1.b-f+t1.e FROM t1 WHERE t1.f-case when (coalesce((select 13*(abs(~11)/abs(t1.b)) from t1 where ~a between +f+~+17 and t1.e),e) not between coalesce((select 19-(abs(11)/abs(t1.b)) from t1 where f<>c),t1.b) and t1.f or t1.d between (select case min(a) when cast(avg(e) AS integer) then  -((count(*))) else cast(avg(t1.a) AS integer) end | count(*) from t1) and (t1.a)) then 19 else f end=f"
    end, {
        -- <randexpr-2.251>
        
        -- </randexpr-2.251>
    })

test:do_test(
    "randexpr-2.252",
    function()
        return test:execsql "SELECT c*~17+~case when (exists(select 1 from t1 where not exists(select 1 from t1 where (abs(e)/abs(c))=case when t1.c not in (a,13,11) and t1.b>=c then t1.b else t1.f end)) and 17<>f) then case when (e) not in (t1.a,t1.f,e) then case case t1.c when 13 then 19 else t1.d end-19 when t1.d then  -t1.b else t1.f end when t1.d not in (17,t1.a,t1.d) or c in (d,(19),t1.b) then  -t1.b else c end else 19 end+t1.b-f+t1.e FROM t1 WHERE NOT (t1.f-case when (coalesce((select 13*(abs(~11)/abs(t1.b)) from t1 where ~a between +f+~+17 and t1.e),e) not between coalesce((select 19-(abs(11)/abs(t1.b)) from t1 where f<>c),t1.b) and t1.f or t1.d between (select case min(a) when cast(avg(e) AS integer) then  -((count(*))) else cast(avg(t1.a) AS integer) end | count(*) from t1) and (t1.a)) then 19 else f end=f)"
    end, {
        -- <randexpr-2.252>
        -5601
        -- </randexpr-2.252>
    })

test:do_test(
    "randexpr-2.253",
    function()
        return test:execsql "SELECT coalesce((select c-t1.a | 17 | b-~t1.e-11 from t1 where not exists(select 1 from t1 where t1.c<=t1.b)),17) FROM t1 WHERE (((coalesce((select max((abs(b-t1.d-19*t1.a*e+~case when t1.e=t1.f-e then (select abs(abs(cast(avg((f)) AS integer))) from t1) else ((abs(t1.b)/abs(t1.a))) end-t1.b-t1.c)/abs(t1.b))) from t1 where not t1.c in (select count(distinct c) from t1 union select count(*) from t1) and 17< -t1.e),(c)) |  -(c))<>e))"
    end, {
        -- <randexpr-2.253>
        763
        -- </randexpr-2.253>
    })

test:do_test(
    "randexpr-2.254",
    function()
        return test:execsql "SELECT coalesce((select c-t1.a | 17 | b-~t1.e-11 from t1 where not exists(select 1 from t1 where t1.c<=t1.b)),17) FROM t1 WHERE NOT ((((coalesce((select max((abs(b-t1.d-19*t1.a*e+~case when t1.e=t1.f-e then (select abs(abs(cast(avg((f)) AS integer))) from t1) else ((abs(t1.b)/abs(t1.a))) end-t1.b-t1.c)/abs(t1.b))) from t1 where not t1.c in (select count(distinct c) from t1 union select count(*) from t1) and 17< -t1.e),(c)) |  -(c))<>e)))"
    end, {
        -- <randexpr-2.254>
        
        -- </randexpr-2.254>
    })

test:do_test(
    "randexpr-2.255",
    function()
        return test:execsql "SELECT coalesce((select c-t1.a & 17 & b-~t1.e-11 from t1 where not exists(select 1 from t1 where t1.c<=t1.b)),17) FROM t1 WHERE (((coalesce((select max((abs(b-t1.d-19*t1.a*e+~case when t1.e=t1.f-e then (select abs(abs(cast(avg((f)) AS integer))) from t1) else ((abs(t1.b)/abs(t1.a))) end-t1.b-t1.c)/abs(t1.b))) from t1 where not t1.c in (select count(distinct c) from t1 union select count(*) from t1) and 17< -t1.e),(c)) |  -(c))<>e))"
    end, {
        -- <randexpr-2.255>
        0
        -- </randexpr-2.255>
    })

test:do_test(
    "randexpr-2.256",
    function()
        return test:execsql "SELECT case case +(select case count(distinct case when case when (abs(f | t1.d)/abs(13))<= -c then t1.a else t1.b end+t1.b<=19 then c when 19=a then 17 else 11 end+13) when ~+case (cast(avg(t1.b) AS integer) | ((count(*)))-max(t1.d)) when count(distinct d) then count(*) else cast(avg(t1.c) AS integer) end then count(*) else count(*) end from t1) when c*t1.a then 13 else t1.a end when a then  -f else t1.a end+d FROM t1 WHERE case when coalesce((select t1.c | c*t1.e-11 from t1 where exists(select 1 from t1 where t1.d-t1.d*d between  - -t1.e and a)), -13)<=e and 11 not in (d,t1.a,f) and t1.a not between 11 and 19 or t1.e<>t1.e and t1.e<c or a between t1.c and c and d>=t1.a or  -t1.e>=b then b when 17 not between t1.f and t1.b then a else b end in (select 11 from t1 union select f from t1)"
    end, {
        -- <randexpr-2.256>
        
        -- </randexpr-2.256>
    })

test:do_test(
    "randexpr-2.257",
    function()
        return test:execsql "SELECT case case +(select case count(distinct case when case when (abs(f | t1.d)/abs(13))<= -c then t1.a else t1.b end+t1.b<=19 then c when 19=a then 17 else 11 end+13) when ~+case (cast(avg(t1.b) AS integer) | ((count(*)))-max(t1.d)) when count(distinct d) then count(*) else cast(avg(t1.c) AS integer) end then count(*) else count(*) end from t1) when c*t1.a then 13 else t1.a end when a then  -f else t1.a end+d FROM t1 WHERE NOT (case when coalesce((select t1.c | c*t1.e-11 from t1 where exists(select 1 from t1 where t1.d-t1.d*d between  - -t1.e and a)), -13)<=e and 11 not in (d,t1.a,f) and t1.a not between 11 and 19 or t1.e<>t1.e and t1.e<c or a between t1.c and c and d>=t1.a or  -t1.e>=b then b when 17 not between t1.f and t1.b then a else b end in (select 11 from t1 union select f from t1))"
    end, {
        -- <randexpr-2.257>
        -200
        -- </randexpr-2.257>
    })

test:do_test(
    "randexpr-2.258",
    function()
        return test:execsql "SELECT case case +(select case count(distinct case when case when (abs(f & t1.d)/abs(13))<= -c then t1.a else t1.b end+t1.b<=19 then c when 19=a then 17 else 11 end+13) when ~+case (cast(avg(t1.b) AS integer) & ((count(*)))-max(t1.d)) when count(distinct d) then count(*) else cast(avg(t1.c) AS integer) end then count(*) else count(*) end from t1) when c*t1.a then 13 else t1.a end when a then  -f else t1.a end+d FROM t1 WHERE NOT (case when coalesce((select t1.c | c*t1.e-11 from t1 where exists(select 1 from t1 where t1.d-t1.d*d between  - -t1.e and a)), -13)<=e and 11 not in (d,t1.a,f) and t1.a not between 11 and 19 or t1.e<>t1.e and t1.e<c or a between t1.c and c and d>=t1.a or  -t1.e>=b then b when 17 not between t1.f and t1.b then a else b end in (select 11 from t1 union select f from t1))"
    end, {
        -- <randexpr-2.258>
        -200
        -- </randexpr-2.258>
    })

test:do_test(
    "randexpr-2.259",
    function()
        return test:execsql "SELECT f*coalesce((select max((select count(*) from t1)) from t1 where ~case when t1.e<=case when 17>=+case when c*a in (c,t1.b,13) then t1.e when a>t1.b and a<=19 then c else t1.e end then t1.c else 17 end-f*17 or a between b and 19 then t1.c when  -f<=11 then c else  -11 end*t1.c+d>=e),17) FROM t1 WHERE (19 not between t1.b and ~e)"
    end, {
        -- <randexpr-2.259>
        10200
        -- </randexpr-2.259>
    })

test:do_test(
    "randexpr-2.260",
    function()
        return test:execsql "SELECT f*coalesce((select max((select count(*) from t1)) from t1 where ~case when t1.e<=case when 17>=+case when c*a in (c,t1.b,13) then t1.e when a>t1.b and a<=19 then c else t1.e end then t1.c else 17 end-f*17 or a between b and 19 then t1.c when  -f<=11 then c else  -11 end*t1.c+d>=e),17) FROM t1 WHERE NOT ((19 not between t1.b and ~e))"
    end, {
        -- <randexpr-2.260>
        
        -- </randexpr-2.260>
    })

test:do_test(
    "randexpr-2.261",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c- -case when (~(select max(b*t1.a)*~((min(t1.e))-min((a))) |  -cast(avg(t1.e+t1.a) AS integer) from t1))<d then c else (abs( -~19)/abs(c)) end-coalesce((select max(t1.e+a) from t1 where 11<>c or (t1.b)> -(11)),11)) from t1 where  -11 in ((d),f,t1.d)),t1.a) FROM t1 WHERE c<>e+t1.c"
    end, {
        -- <randexpr-2.261>
        100
        -- </randexpr-2.261>
    })

test:do_test(
    "randexpr-2.262",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c- -case when (~(select max(b*t1.a)*~((min(t1.e))-min((a))) |  -cast(avg(t1.e+t1.a) AS integer) from t1))<d then c else (abs( -~19)/abs(c)) end-coalesce((select max(t1.e+a) from t1 where 11<>c or (t1.b)> -(11)),11)) from t1 where  -11 in ((d),f,t1.d)),t1.a) FROM t1 WHERE NOT (c<>e+t1.c)"
    end, {
        -- <randexpr-2.262>
        
        -- </randexpr-2.262>
    })

test:do_test(
    "randexpr-2.263",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c- -case when (~(select max(b*t1.a)*~((min(t1.e))-min((a))) &  -cast(avg(t1.e+t1.a) AS integer) from t1))<d then c else (abs( -~19)/abs(c)) end-coalesce((select max(t1.e+a) from t1 where 11<>c or (t1.b)> -(11)),11)) from t1 where  -11 in ((d),f,t1.d)),t1.a) FROM t1 WHERE c<>e+t1.c"
    end, {
        -- <randexpr-2.263>
        100
        -- </randexpr-2.263>
    })

test:do_test(
    "randexpr-2.264",
    function()
        return test:execsql "SELECT  -case when (not exists(select 1 from t1 where e*d*case 17 when case t1.c-t1.f when t1.a then t1.a else 11 end then t1.c else t1.b end-e+(t1.a)-e not in (e,e,t1.a) and (t1.f not between 19 and t1.e))) and t1.b<t1.a then f-d-c+b when 17=17 then 19 else d end FROM t1 WHERE f*t1.a not between coalesce((select t1.b from t1 where 17=13),17*e) and e"
    end, {
        -- <randexpr-2.264>
        -19
        -- </randexpr-2.264>
    })

test:do_test(
    "randexpr-2.265",
    function()
        return test:execsql "SELECT  -case when (not exists(select 1 from t1 where e*d*case 17 when case t1.c-t1.f when t1.a then t1.a else 11 end then t1.c else t1.b end-e+(t1.a)-e not in (e,e,t1.a) and (t1.f not between 19 and t1.e))) and t1.b<t1.a then f-d-c+b when 17=17 then 19 else d end FROM t1 WHERE NOT (f*t1.a not between coalesce((select t1.b from t1 where 17=13),17*e) and e)"
    end, {
        -- <randexpr-2.265>
        
        -- </randexpr-2.265>
    })

test:do_test(
    "randexpr-2.266",
    function()
        return test:execsql "SELECT coalesce((select 17+coalesce((select max(case when  -coalesce((select max((abs( -(abs(t1.a)/abs(t1.d))+11)/abs(e))-b) from t1 where t1.b not between f and t1.c and t1.f<>e),c) between t1.e and f then t1.e when  -f> - -b then c else t1.c end) from t1 where not 11 in (select f from t1 union select a from t1)),t1.d)-t1.a-13 from t1 where t1.d between  -t1.e and t1.a),f) FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where c in (select (abs(f)/abs(13)) from t1 union select t1.a+b from t1)))"
    end, {
        -- <randexpr-2.266>
        
        -- </randexpr-2.266>
    })

test:do_test(
    "randexpr-2.267",
    function()
        return test:execsql "SELECT coalesce((select 17+coalesce((select max(case when  -coalesce((select max((abs( -(abs(t1.a)/abs(t1.d))+11)/abs(e))-b) from t1 where t1.b not between f and t1.c and t1.f<>e),c) between t1.e and f then t1.e when  -f> - -b then c else t1.c end) from t1 where not 11 in (select f from t1 union select a from t1)),t1.d)-t1.a-13 from t1 where t1.d between  -t1.e and t1.a),f) FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where c in (select (abs(f)/abs(13)) from t1 union select t1.a+b from t1))))"
    end, {
        -- <randexpr-2.267>
        600
        -- </randexpr-2.267>
    })

test:do_test(
    "randexpr-2.268",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d) from t1 where exists(select 1 from t1 where t1.d in (select case (abs(((count(distinct t1.d-c))* -cast(avg(11) AS integer)+max(t1.c)))) when (cast(avg(t1.c+a) AS integer)*+min(a)*max(c)-max(t1.a)+cast(avg(f) AS integer))+cast(avg(t1.e) AS integer) then min(11) else (((min(11)))) end from t1 union select count(*) from t1))),coalesce((select max(b+13) from t1 where exists(select 1 from t1 where f in (select 11 from t1 union select t1.b from t1))),t1.e)) FROM t1 WHERE b>11"
    end, {
        -- <randexpr-2.268>
        500
        -- </randexpr-2.268>
    })

test:do_test(
    "randexpr-2.269",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d) from t1 where exists(select 1 from t1 where t1.d in (select case (abs(((count(distinct t1.d-c))* -cast(avg(11) AS integer)+max(t1.c)))) when (cast(avg(t1.c+a) AS integer)*+min(a)*max(c)-max(t1.a)+cast(avg(f) AS integer))+cast(avg(t1.e) AS integer) then min(11) else (((min(11)))) end from t1 union select count(*) from t1))),coalesce((select max(b+13) from t1 where exists(select 1 from t1 where f in (select 11 from t1 union select t1.b from t1))),t1.e)) FROM t1 WHERE NOT (b>11)"
    end, {
        -- <randexpr-2.269>
        
        -- </randexpr-2.269>
    })

test:do_test(
    "randexpr-2.270",
    function()
        return test:execsql "SELECT coalesce((select max( -(select count(*)-case min(19)-abs(count(*))+(max( -b)-+count(distinct (t1.e))) when max(a) then (count(distinct 19)) else count(*) end from t1)) from t1 where exists(select 1 from t1 where a<(abs(case when a-t1.c+ -19+t1.d between 11 and f then t1.f else d end+t1.a+d)/abs(c))) or t1.c>t1.c),17)*f FROM t1 WHERE not f<>t1.b"
    end, {
        -- <randexpr-2.270>
        
        -- </randexpr-2.270>
    })

test:do_test(
    "randexpr-2.271",
    function()
        return test:execsql "SELECT coalesce((select max( -(select count(*)-case min(19)-abs(count(*))+(max( -b)-+count(distinct (t1.e))) when max(a) then (count(distinct 19)) else count(*) end from t1)) from t1 where exists(select 1 from t1 where a<(abs(case when a-t1.c+ -19+t1.d between 11 and f then t1.f else d end+t1.a+d)/abs(c))) or t1.c>t1.c),17)*f FROM t1 WHERE NOT (not f<>t1.b)"
    end, {
        -- <randexpr-2.271>
        10200
        -- </randexpr-2.271>
    })

test:do_test(
    "randexpr-2.272",
    function()
        return test:execsql "SELECT case when coalesce((select f-coalesce((select +coalesce((select t1.c from t1 where (t1.c=(abs(t1.e)/abs(+t1.c+f+(f))))),13+17)+t1.b | t1.c from t1 where case when t1.a not in (d,17,t1.c) then f else f end |  -13 in (select cast(avg(t1.e) AS integer) from t1 union select min(t1.a) from t1)),c) from t1 where 17>c), -t1.b)>t1.c then 17 when t1.b<>11 then e else t1.f end FROM t1 WHERE case when t1.f in (t1.a+(abs(17)/abs((t1.d))),coalesce((select max(c) from t1 where (not (d- -case f when 17 then d else (17) end+e*t1.d) not in ((t1.d),t1.f,f))),coalesce((select c from t1 where 13 not in (19,d,b)),f)),17) then t1.b when e<=f then 17 else c end<d or t1.d> -19"
    end, {
        -- <randexpr-2.272>
        500
        -- </randexpr-2.272>
    })

test:do_test(
    "randexpr-2.273",
    function()
        return test:execsql "SELECT case when coalesce((select f-coalesce((select +coalesce((select t1.c from t1 where (t1.c=(abs(t1.e)/abs(+t1.c+f+(f))))),13+17)+t1.b | t1.c from t1 where case when t1.a not in (d,17,t1.c) then f else f end |  -13 in (select cast(avg(t1.e) AS integer) from t1 union select min(t1.a) from t1)),c) from t1 where 17>c), -t1.b)>t1.c then 17 when t1.b<>11 then e else t1.f end FROM t1 WHERE NOT (case when t1.f in (t1.a+(abs(17)/abs((t1.d))),coalesce((select max(c) from t1 where (not (d- -case f when 17 then d else (17) end+e*t1.d) not in ((t1.d),t1.f,f))),coalesce((select c from t1 where 13 not in (19,d,b)),f)),17) then t1.b when e<=f then 17 else c end<d or t1.d> -19)"
    end, {
        -- <randexpr-2.273>
        
        -- </randexpr-2.273>
    })

test:do_test(
    "randexpr-2.274",
    function()
        return test:execsql "SELECT case when coalesce((select f-coalesce((select +coalesce((select t1.c from t1 where (t1.c=(abs(t1.e)/abs(+t1.c+f+(f))))),13+17)+t1.b & t1.c from t1 where case when t1.a not in (d,17,t1.c) then f else f end &  -13 in (select cast(avg(t1.e) AS integer) from t1 union select min(t1.a) from t1)),c) from t1 where 17>c), -t1.b)>t1.c then 17 when t1.b<>11 then e else t1.f end FROM t1 WHERE case when t1.f in (t1.a+(abs(17)/abs((t1.d))),coalesce((select max(c) from t1 where (not (d- -case f when 17 then d else (17) end+e*t1.d) not in ((t1.d),t1.f,f))),coalesce((select c from t1 where 13 not in (19,d,b)),f)),17) then t1.b when e<=f then 17 else c end<d or t1.d> -19"
    end, {
        -- <randexpr-2.274>
        500
        -- </randexpr-2.274>
    })

test:do_test(
    "randexpr-2.275",
    function()
        return test:execsql "SELECT case when d*t1.c*a<>t1.b*~t1.b*t1.f-b then e else 17 end*t1.e+case when a not between t1.a and t1.d or (select  - -cast(avg(c) AS integer) from t1)<>17+c then case 11 when t1.f then  -t1.b else t1.b end when 13 not in (c,t1.f,19) or not exists(select 1 from t1 where 13=t1.d or t1.e<>a) then (17) else  -t1.f end FROM t1 WHERE (not (case e when e then +case when e>=a and 13<>e*t1.e or t1.d<>11 then t1.c else t1.b end else 17 end) in (select cast(avg( -t1.c) AS integer) from t1 union select case min(13) when  -+count(distinct 13) then case (+(cast(avg(e) AS integer))+((cast(avg(13) AS integer)))* - -count(distinct c)*count(*)) | count(*) when min(t1.c) then (min(11)) else max(f) end else cast(avg(17) AS integer) end from t1))"
    end, {
        -- <randexpr-2.275>
        250200
        -- </randexpr-2.275>
    })

test:do_test(
    "randexpr-2.276",
    function()
        return test:execsql "SELECT case when d*t1.c*a<>t1.b*~t1.b*t1.f-b then e else 17 end*t1.e+case when a not between t1.a and t1.d or (select  - -cast(avg(c) AS integer) from t1)<>17+c then case 11 when t1.f then  -t1.b else t1.b end when 13 not in (c,t1.f,19) or not exists(select 1 from t1 where 13=t1.d or t1.e<>a) then (17) else  -t1.f end FROM t1 WHERE NOT ((not (case e when e then +case when e>=a and 13<>e*t1.e or t1.d<>11 then t1.c else t1.b end else 17 end) in (select cast(avg( -t1.c) AS integer) from t1 union select case min(13) when  -+count(distinct 13) then case (+(cast(avg(e) AS integer))+((cast(avg(13) AS integer)))* - -count(distinct c)*count(*)) | count(*) when min(t1.c) then (min(11)) else max(f) end else cast(avg(17) AS integer) end from t1)))"
    end, {
        -- <randexpr-2.276>
        
        -- </randexpr-2.276>
    })

test:do_test(
    "randexpr-2.277",
    function()
        return test:execsql "SELECT (select max(t1.a)*abs(count(distinct f-t1.a-(abs(t1.a)/abs(case e when case t1.f when e*(b)-19 then 11 else t1.d end then t1.f else 11 end)))) | case +~cast(avg(t1.a) AS integer)-+abs(count(distinct 17)) when case count(distinct t1.b)*cast(avg(t1.a) AS integer)+count(distinct t1.c) when count(*) then min(t1.f) else count(distinct e) end then max((t1.e)) else max(d) end-count(*) from t1) FROM t1 WHERE e not between (select min(t1.a) from t1) and d+t1.d"
    end, {
        -- <randexpr-2.277>
        
        -- </randexpr-2.277>
    })

test:do_test(
    "randexpr-2.278",
    function()
        return test:execsql "SELECT (select max(t1.a)*abs(count(distinct f-t1.a-(abs(t1.a)/abs(case e when case t1.f when e*(b)-19 then 11 else t1.d end then t1.f else 11 end)))) | case +~cast(avg(t1.a) AS integer)-+abs(count(distinct 17)) when case count(distinct t1.b)*cast(avg(t1.a) AS integer)+count(distinct t1.c) when count(*) then min(t1.f) else count(distinct e) end then max((t1.e)) else max(d) end-count(*) from t1) FROM t1 WHERE NOT (e not between (select min(t1.a) from t1) and d+t1.d)"
    end, {
        -- <randexpr-2.278>
        495
        -- </randexpr-2.278>
    })

test:do_test(
    "randexpr-2.279",
    function()
        return test:execsql "SELECT (select max(t1.a)*abs(count(distinct f-t1.a-(abs(t1.a)/abs(case e when case t1.f when e*(b)-19 then 11 else t1.d end then t1.f else 11 end)))) & case +~cast(avg(t1.a) AS integer)-+abs(count(distinct 17)) when case count(distinct t1.b)*cast(avg(t1.a) AS integer)+count(distinct t1.c) when count(*) then min(t1.f) else count(distinct e) end then max((t1.e)) else max(d) end-count(*) from t1) FROM t1 WHERE NOT (e not between (select min(t1.a) from t1) and d+t1.d)"
    end, {
        -- <randexpr-2.279>
        4
        -- </randexpr-2.279>
    })

test:do_test(
    "randexpr-2.280",
    function()
        return test:execsql "SELECT e*c-t1.e*t1.c++(select abs(case abs(max(coalesce((select f from t1 where (b*coalesce((select max(b) from t1 where 17>f),t1.e) not between c and f or t1.a>d and t1.a<11 or a<> -f)),(t1.a)))) when  -+count(distinct e) then  -+(count(distinct 19))+min(t1.c) else  -min(t1.f) end) from t1)+t1.b-19 FROM t1 WHERE d-coalesce((select max(t1.d*c+c) from t1 where t1.f between (select count(distinct t1.b-e)+abs(~case case ~cast(avg(t1.f) AS integer)-count(distinct t1.a) when count(*) then count(distinct e) else count(*) end when min(e) then min( -t1.c) else max(a) end) from t1)+17 and  -case when d>=d-11 then t1.c else t1.a end),t1.a)*t1.a not in (t1.f,t1.f,d)"
    end, {
        -- <randexpr-2.280>
        781
        -- </randexpr-2.280>
    })

test:do_test(
    "randexpr-2.281",
    function()
        return test:execsql "SELECT e*c-t1.e*t1.c++(select abs(case abs(max(coalesce((select f from t1 where (b*coalesce((select max(b) from t1 where 17>f),t1.e) not between c and f or t1.a>d and t1.a<11 or a<> -f)),(t1.a)))) when  -+count(distinct e) then  -+(count(distinct 19))+min(t1.c) else  -min(t1.f) end) from t1)+t1.b-19 FROM t1 WHERE NOT (d-coalesce((select max(t1.d*c+c) from t1 where t1.f between (select count(distinct t1.b-e)+abs(~case case ~cast(avg(t1.f) AS integer)-count(distinct t1.a) when count(*) then count(distinct e) else count(*) end when min(e) then min( -t1.c) else max(a) end) from t1)+17 and  -case when d>=d-11 then t1.c else t1.a end),t1.a)*t1.a not in (t1.f,t1.f,d))"
    end, {
        -- <randexpr-2.281>
        
        -- </randexpr-2.281>
    })

test:do_test(
    "randexpr-2.282",
    function()
        return test:execsql "SELECT coalesce((select a from t1 where (exists(select 1 from t1 where 11-case when ((select count(distinct t1.e+d) from t1))<>t1.d*f then  -13 when t1.b in (select abs(cast(avg(c) AS integer)) from t1 union select count(distinct e)*count(distinct c)-cast(avg(e) AS integer) from t1) or c in (select t1.d from t1 union select 17 from t1) then a else t1.b end>=t1.c) and f>=d and d>=t1.f)),case when 11=19 and t1.a between t1.d and e then t1.d-b else t1.b end) FROM t1 WHERE 19 not in ( -t1.f,+19,t1.b)"
    end, {
        -- <randexpr-2.282>
        
        -- </randexpr-2.282>
    })

test:do_test(
    "randexpr-2.283",
    function()
        return test:execsql "SELECT coalesce((select a from t1 where (exists(select 1 from t1 where 11-case when ((select count(distinct t1.e+d) from t1))<>t1.d*f then  -13 when t1.b in (select abs(cast(avg(c) AS integer)) from t1 union select count(distinct e)*count(distinct c)-cast(avg(e) AS integer) from t1) or c in (select t1.d from t1 union select 17 from t1) then a else t1.b end>=t1.c) and f>=d and d>=t1.f)),case when 11=19 and t1.a between t1.d and e then t1.d-b else t1.b end) FROM t1 WHERE NOT (19 not in ( -t1.f,+19,t1.b))"
    end, {
        -- <randexpr-2.283>
        200
        -- </randexpr-2.283>
    })

test:do_test(
    "randexpr-2.284",
    function()
        return test:execsql "SELECT (~case when t1.f>(abs(t1.c)/abs(13-coalesce((select max(t1.a) from t1 where case when e not in (c,t1.a,~11) then 19+( -c) else a end in (select (19) from t1 union select t1.c from t1)),t1.b)+a)) and e>d and (t1.a)=e then t1.e when (not exists(select 1 from t1 where  -t1.d=e) and  -d in (select d from t1 union select e from t1)) then t1.b else a end) FROM t1 WHERE (t1.f in (select coalesce((select max(coalesce((select c from t1 where coalesce((select max(coalesce((select max(++13*t1.d) from t1 where case when case when e<>13 or b<= -t1.a then t1.c when t1.a not in ( - -13,t1.a,13) then a else c end not in ( -e,d,(11)) or t1.d<t1.a then t1.b when t1.a<> -b then t1.e else t1.d end<a),t1.d)) from t1 where e<>t1.b),c) not in (t1.e,c,b)),13)) from t1 where ((t1.f) in (select max(a) from t1 union select abs(abs(min(13))) from t1))),11) from t1 union select b from t1))"
    end, {
        -- <randexpr-2.284>
        
        -- </randexpr-2.284>
    })

test:do_test(
    "randexpr-2.285",
    function()
        return test:execsql "SELECT (~case when t1.f>(abs(t1.c)/abs(13-coalesce((select max(t1.a) from t1 where case when e not in (c,t1.a,~11) then 19+( -c) else a end in (select (19) from t1 union select t1.c from t1)),t1.b)+a)) and e>d and (t1.a)=e then t1.e when (not exists(select 1 from t1 where  -t1.d=e) and  -d in (select d from t1 union select e from t1)) then t1.b else a end) FROM t1 WHERE NOT ((t1.f in (select coalesce((select max(coalesce((select c from t1 where coalesce((select max(coalesce((select max(++13*t1.d) from t1 where case when case when e<>13 or b<= -t1.a then t1.c when t1.a not in ( - -13,t1.a,13) then a else c end not in ( -e,d,(11)) or t1.d<t1.a then t1.b when t1.a<> -b then t1.e else t1.d end<a),t1.d)) from t1 where e<>t1.b),c) not in (t1.e,c,b)),13)) from t1 where ((t1.f) in (select max(a) from t1 union select abs(abs(min(13))) from t1))),11) from t1 union select b from t1)))"
    end, {
        -- <randexpr-2.285>
        -101
        -- </randexpr-2.285>
    })

test:do_test(
    "randexpr-2.286",
    function()
        return test:execsql "SELECT (select count(distinct case b when 13 then (select (+(cast(avg(+(d)*case t1.f-c*(abs(case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (d<=t1.e) or d between c and t1.b)) then 11 else 19 end in ((t1.d),t1.a,t1.f) then t1.f when c<=t1.e then t1.c else b end | a)/abs(c))+t1.b when t1.c then a else d end) AS integer))) from t1) else t1.b*(e) end) from t1) FROM t1 WHERE not t1.a+t1.b | t1.f-11*(select max(+case when case ~e-(abs(d*t1.d+t1.d)/abs( -f)) when t1.a then t1.e else t1.c end in (select cast(avg((f)) AS integer) from t1 union select +~(min(t1.d)) from t1) then (t1.d) when not exists(select 1 from t1 where a not in (17,a,d)) then 19 else  -t1.a end* -t1.d) from t1)* -17>13"
    end, {
        -- <randexpr-2.286>
        1
        -- </randexpr-2.286>
    })

test:do_test(
    "randexpr-2.287",
    function()
        return test:execsql "SELECT (select count(distinct case b when 13 then (select (+(cast(avg(+(d)*case t1.f-c*(abs(case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (d<=t1.e) or d between c and t1.b)) then 11 else 19 end in ((t1.d),t1.a,t1.f) then t1.f when c<=t1.e then t1.c else b end | a)/abs(c))+t1.b when t1.c then a else d end) AS integer))) from t1) else t1.b*(e) end) from t1) FROM t1 WHERE NOT (not t1.a+t1.b | t1.f-11*(select max(+case when case ~e-(abs(d*t1.d+t1.d)/abs( -f)) when t1.a then t1.e else t1.c end in (select cast(avg((f)) AS integer) from t1 union select +~(min(t1.d)) from t1) then (t1.d) when not exists(select 1 from t1 where a not in (17,a,d)) then 19 else  -t1.a end* -t1.d) from t1)* -17>13)"
    end, {
        -- <randexpr-2.287>
        
        -- </randexpr-2.287>
    })

test:do_test(
    "randexpr-2.288",
    function()
        return test:execsql "SELECT (select count(distinct case b when 13 then (select (+(cast(avg(+(d)*case t1.f-c*(abs(case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (d<=t1.e) or d between c and t1.b)) then 11 else 19 end in ((t1.d),t1.a,t1.f) then t1.f when c<=t1.e then t1.c else b end & a)/abs(c))+t1.b when t1.c then a else d end) AS integer))) from t1) else t1.b*(e) end) from t1) FROM t1 WHERE not t1.a+t1.b | t1.f-11*(select max(+case when case ~e-(abs(d*t1.d+t1.d)/abs( -f)) when t1.a then t1.e else t1.c end in (select cast(avg((f)) AS integer) from t1 union select +~(min(t1.d)) from t1) then (t1.d) when not exists(select 1 from t1 where a not in (17,a,d)) then 19 else  -t1.a end* -t1.d) from t1)* -17>13"
    end, {
        -- <randexpr-2.288>
        1
        -- </randexpr-2.288>
    })

test:do_test(
    "randexpr-2.289",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13) from t1 where ((~t1.f) between b and (abs(e)/abs(f)))),13+(select case abs((+count(*)*max(19))) when (~min(b)) then  -min(a) | min( -a) else (max(t1.c)) end from t1)+17*f+11)) from t1 where not 19<=coalesce((select e from t1 where t1.d-d not between 19 and 19),11)),13) FROM t1 WHERE t1.f+t1.d=t1.f+17-case when (abs(t1.a*(case when not exists(select 1 from t1 where not exists(select 1 from t1 where (b) between d and t1.f)) then (t1.b |  -(t1.c)) | 19 when d=t1.a then 13 else d end)+ -t1.d)/abs(d)) not in (d,e,t1.d) then t1.f when 19 in (select t1.f from t1 union select t1.e from t1) then e else  -t1.a end- - -t1.e*17-t1.d-t1.d"
    end, {
        -- <randexpr-2.289>
        
        -- </randexpr-2.289>
    })

test:do_test(
    "randexpr-2.290",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13) from t1 where ((~t1.f) between b and (abs(e)/abs(f)))),13+(select case abs((+count(*)*max(19))) when (~min(b)) then  -min(a) | min( -a) else (max(t1.c)) end from t1)+17*f+11)) from t1 where not 19<=coalesce((select e from t1 where t1.d-d not between 19 and 19),11)),13) FROM t1 WHERE NOT (t1.f+t1.d=t1.f+17-case when (abs(t1.a*(case when not exists(select 1 from t1 where not exists(select 1 from t1 where (b) between d and t1.f)) then (t1.b |  -(t1.c)) | 19 when d=t1.a then 13 else d end)+ -t1.d)/abs(d)) not in (d,e,t1.d) then t1.f when 19 in (select t1.f from t1 union select t1.e from t1) then e else  -t1.a end- - -t1.e*17-t1.d-t1.d)"
    end, {
        -- <randexpr-2.290>
        13
        -- </randexpr-2.290>
    })

test:do_test(
    "randexpr-2.291",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13) from t1 where ((~t1.f) between b and (abs(e)/abs(f)))),13+(select case abs((+count(*)*max(19))) when (~min(b)) then  -min(a) & min( -a) else (max(t1.c)) end from t1)+17*f+11)) from t1 where not 19<=coalesce((select e from t1 where t1.d-d not between 19 and 19),11)),13) FROM t1 WHERE NOT (t1.f+t1.d=t1.f+17-case when (abs(t1.a*(case when not exists(select 1 from t1 where not exists(select 1 from t1 where (b) between d and t1.f)) then (t1.b |  -(t1.c)) | 19 when d=t1.a then 13 else d end)+ -t1.d)/abs(d)) not in (d,e,t1.d) then t1.f when 19 in (select t1.f from t1 union select t1.e from t1) then e else  -t1.a end- - -t1.e*17-t1.d-t1.d)"
    end, {
        -- <randexpr-2.291>
        13
        -- </randexpr-2.291>
    })

test:do_test(
    "randexpr-2.292",
    function()
        return test:execsql "SELECT case when  -t1.b=c and ((t1.c>t1.b)) and not exists(select 1 from t1 where (abs((select max(t1.d) from t1))/abs((abs(c+t1.b)/abs(t1.d))-t1.e))+c in (select cast(avg((t1.a)) AS integer) | abs(count(distinct t1.d))+count(*) | count(*)+count(*) from t1 union select (min(t1.d)) from t1)) then (abs(t1.b)/abs(t1.f)) when t1.b not in (a,t1.f,(a)) then t1.b else t1.d end-11 FROM t1 WHERE case when ~e in (coalesce((select 13 from t1 where 17 between t1.a and b or not exists(select 1 from t1 where (c in (11,e,a)))),t1.e),c,e) then e else t1.f end in (select ++abs(case case count(*) when (max(t1.d)) then cast(avg(t1.c) AS integer) else count(distinct b) end | count(*) when max(e) then min(c) else max(13) end | count(*)*count(*)) | max(t1.a) from t1 union select count(distinct t1.c) from t1) or b in (select cast(avg(t1.b) AS integer) from t1 union select cast(avg( -t1.a) AS integer) from t1)"
    end, {
        -- <randexpr-2.292>
        189
        -- </randexpr-2.292>
    })

test:do_test(
    "randexpr-2.293",
    function()
        return test:execsql "SELECT case when  -t1.b=c and ((t1.c>t1.b)) and not exists(select 1 from t1 where (abs((select max(t1.d) from t1))/abs((abs(c+t1.b)/abs(t1.d))-t1.e))+c in (select cast(avg((t1.a)) AS integer) | abs(count(distinct t1.d))+count(*) | count(*)+count(*) from t1 union select (min(t1.d)) from t1)) then (abs(t1.b)/abs(t1.f)) when t1.b not in (a,t1.f,(a)) then t1.b else t1.d end-11 FROM t1 WHERE NOT (case when ~e in (coalesce((select 13 from t1 where 17 between t1.a and b or not exists(select 1 from t1 where (c in (11,e,a)))),t1.e),c,e) then e else t1.f end in (select ++abs(case case count(*) when (max(t1.d)) then cast(avg(t1.c) AS integer) else count(distinct b) end | count(*) when max(e) then min(c) else max(13) end | count(*)*count(*)) | max(t1.a) from t1 union select count(distinct t1.c) from t1) or b in (select cast(avg(t1.b) AS integer) from t1 union select cast(avg( -t1.a) AS integer) from t1))"
    end, {
        -- <randexpr-2.293>
        
        -- </randexpr-2.293>
    })

test:do_test(
    "randexpr-2.294",
    function()
        return test:execsql "SELECT case when  -t1.b=c and ((t1.c>t1.b)) and not exists(select 1 from t1 where (abs((select max(t1.d) from t1))/abs((abs(c+t1.b)/abs(t1.d))-t1.e))+c in (select cast(avg((t1.a)) AS integer) & abs(count(distinct t1.d))+count(*) & count(*)+count(*) from t1 union select (min(t1.d)) from t1)) then (abs(t1.b)/abs(t1.f)) when t1.b not in (a,t1.f,(a)) then t1.b else t1.d end-11 FROM t1 WHERE case when ~e in (coalesce((select 13 from t1 where 17 between t1.a and b or not exists(select 1 from t1 where (c in (11,e,a)))),t1.e),c,e) then e else t1.f end in (select ++abs(case case count(*) when (max(t1.d)) then cast(avg(t1.c) AS integer) else count(distinct b) end | count(*) when max(e) then min(c) else max(13) end | count(*)*count(*)) | max(t1.a) from t1 union select count(distinct t1.c) from t1) or b in (select cast(avg(t1.b) AS integer) from t1 union select cast(avg( -t1.a) AS integer) from t1)"
    end, {
        -- <randexpr-2.294>
        189
        -- </randexpr-2.294>
    })

test:do_test(
    "randexpr-2.295",
    function()
        return test:execsql "SELECT case when (((abs(11 | e)/abs(17-d))+t1.b | a<>11)) and t1.d in (13,t1.c,11) or 17 between t1.f and b or not f in (select 19 from t1 union select t1.e from t1) and b<>19 or e between 19 and t1.d or b<=d or d<17 or t1.a<>t1.f then 17 when t1.e=t1.b then 11 else coalesce((select t1.e from t1 where (b) between  - -d and e),t1.b) end FROM t1 WHERE t1.a between d and +17-17*coalesce((select ~ -19-13-19 from t1 where 19>(select abs(count(distinct t1.d-17))+count(distinct case when 19>17 then t1.f else t1.e end+b) | max(t1.b)+count(distinct 13) from t1)-coalesce((select 13 from t1 where t1.e not in (19,17,e) and 11<=t1.d),c)),t1.f)"
    end, {
        -- <randexpr-2.295>
        
        -- </randexpr-2.295>
    })

test:do_test(
    "randexpr-2.296",
    function()
        return test:execsql "SELECT case when (((abs(11 | e)/abs(17-d))+t1.b | a<>11)) and t1.d in (13,t1.c,11) or 17 between t1.f and b or not f in (select 19 from t1 union select t1.e from t1) and b<>19 or e between 19 and t1.d or b<=d or d<17 or t1.a<>t1.f then 17 when t1.e=t1.b then 11 else coalesce((select t1.e from t1 where (b) between  - -d and e),t1.b) end FROM t1 WHERE NOT (t1.a between d and +17-17*coalesce((select ~ -19-13-19 from t1 where 19>(select abs(count(distinct t1.d-17))+count(distinct case when 19>17 then t1.f else t1.e end+b) | max(t1.b)+count(distinct 13) from t1)-coalesce((select 13 from t1 where t1.e not in (19,17,e) and 11<=t1.d),c)),t1.f))"
    end, {
        -- <randexpr-2.296>
        17
        -- </randexpr-2.296>
    })

test:do_test(
    "randexpr-2.297",
    function()
        return test:execsql "SELECT case when (((abs(11 & e)/abs(17-d))+t1.b & a<>11)) and t1.d in (13,t1.c,11) or 17 between t1.f and b or not f in (select 19 from t1 union select t1.e from t1) and b<>19 or e between 19 and t1.d or b<=d or d<17 or t1.a<>t1.f then 17 when t1.e=t1.b then 11 else coalesce((select t1.e from t1 where (b) between  - -d and e),t1.b) end FROM t1 WHERE NOT (t1.a between d and +17-17*coalesce((select ~ -19-13-19 from t1 where 19>(select abs(count(distinct t1.d-17))+count(distinct case when 19>17 then t1.f else t1.e end+b) | max(t1.b)+count(distinct 13) from t1)-coalesce((select 13 from t1 where t1.e not in (19,17,e) and 11<=t1.d),c)),t1.f))"
    end, {
        -- <randexpr-2.297>
        17
        -- </randexpr-2.297>
    })

test:do_test(
    "randexpr-2.298",
    function()
        return test:execsql "SELECT case when 19=13 or 13+a | 19*11+b<>b and ((19<=b+(select count(*) from t1))) then t1.d when t1.e<= -19 then d-t1.e+(select ~max(19)*+(count(distinct b)) from t1)+t1.d*t1.d+f else t1.c end FROM t1 WHERE (13*case when 19*case when 19 not between 17 and t1.e then t1.e when ((case when case case when e<>11 or t1.b not in (t1.a, -c,17) then b else a end when  -e then b else a end*a in (select 19 from t1 union select 13 from t1) then e else t1.c end in (select  -abs(+count(*)) from t1 union select count(distinct f) from t1))) then 19 else d end>=f then t1.a when t1.e>=b then a else c end>=t1.d)"
    end, {
        -- <randexpr-2.298>
        400
        -- </randexpr-2.298>
    })

test:do_test(
    "randexpr-2.299",
    function()
        return test:execsql "SELECT case when 19=13 or 13+a | 19*11+b<>b and ((19<=b+(select count(*) from t1))) then t1.d when t1.e<= -19 then d-t1.e+(select ~max(19)*+(count(distinct b)) from t1)+t1.d*t1.d+f else t1.c end FROM t1 WHERE NOT ((13*case when 19*case when 19 not between 17 and t1.e then t1.e when ((case when case case when e<>11 or t1.b not in (t1.a, -c,17) then b else a end when  -e then b else a end*a in (select 19 from t1 union select 13 from t1) then e else t1.c end in (select  -abs(+count(*)) from t1 union select count(distinct f) from t1))) then 19 else d end>=f then t1.a when t1.e>=b then a else c end>=t1.d))"
    end, {
        -- <randexpr-2.299>
        
        -- </randexpr-2.299>
    })

test:do_test(
    "randexpr-2.300",
    function()
        return test:execsql "SELECT case when 19=13 or 13+a & 19*11+b<>b and ((19<=b+(select count(*) from t1))) then t1.d when t1.e<= -19 then d-t1.e+(select ~max(19)*+(count(distinct b)) from t1)+t1.d*t1.d+f else t1.c end FROM t1 WHERE (13*case when 19*case when 19 not between 17 and t1.e then t1.e when ((case when case case when e<>11 or t1.b not in (t1.a, -c,17) then b else a end when  -e then b else a end*a in (select 19 from t1 union select 13 from t1) then e else t1.c end in (select  -abs(+count(*)) from t1 union select count(distinct f) from t1))) then 19 else d end>=f then t1.a when t1.e>=b then a else c end>=t1.d)"
    end, {
        -- <randexpr-2.300>
        400
        -- </randexpr-2.300>
    })

test:do_test(
    "randexpr-2.301",
    function()
        return test:execsql "SELECT +coalesce((select t1.d from t1 where coalesce((select t1.c+t1.b-case (19) when t1.c then 13+13+17 else t1.e end from t1 where (not exists(select 1 from t1 where t1.f<13)) and d not in (t1.e,11,19) and not 19>=t1.f or e in (select min(t1.c) from t1 union select cast(avg(t1.c) AS integer) from t1)), -a)-b*(13)<t1.b),(t1.c)) | t1.e FROM t1 WHERE not (11>(+b))"
    end, {
        -- <randexpr-2.301>
        500
        -- </randexpr-2.301>
    })

test:do_test(
    "randexpr-2.302",
    function()
        return test:execsql "SELECT +coalesce((select t1.d from t1 where coalesce((select t1.c+t1.b-case (19) when t1.c then 13+13+17 else t1.e end from t1 where (not exists(select 1 from t1 where t1.f<13)) and d not in (t1.e,11,19) and not 19>=t1.f or e in (select min(t1.c) from t1 union select cast(avg(t1.c) AS integer) from t1)), -a)-b*(13)<t1.b),(t1.c)) | t1.e FROM t1 WHERE NOT (not (11>(+b)))"
    end, {
        -- <randexpr-2.302>
        
        -- </randexpr-2.302>
    })

test:do_test(
    "randexpr-2.303",
    function()
        return test:execsql "SELECT +coalesce((select t1.d from t1 where coalesce((select t1.c+t1.b-case (19) when t1.c then 13+13+17 else t1.e end from t1 where (not exists(select 1 from t1 where t1.f<13)) and d not in (t1.e,11,19) and not 19>=t1.f or e in (select min(t1.c) from t1 union select cast(avg(t1.c) AS integer) from t1)), -a)-b*(13)<t1.b),(t1.c)) & t1.e FROM t1 WHERE not (11>(+b))"
    end, {
        -- <randexpr-2.303>
        400
        -- </randexpr-2.303>
    })

test:do_test(
    "randexpr-2.304",
    function()
        return test:execsql "SELECT case when (((t1.c)<=a-11*t1.e)) then t1.b else a end | ((abs(b*(abs(t1.e | +c)/abs(11)))/abs(t1.a))) FROM t1 WHERE case when t1.e in (select t1.a-e from t1 union select t1.e from t1) then 19*coalesce((select a*t1.c-19+f+t1.d-case case when 11>=d then f when not f<>17 then t1.d else t1.f end+t1.e-t1.c when d then b else t1.f end from t1 where t1.f>a), -t1.a)- -(t1.c)-t1.e+b else 11 end<t1.f"
    end, {
        -- <randexpr-2.304>
        
        -- </randexpr-2.304>
    })

test:do_test(
    "randexpr-2.305",
    function()
        return test:execsql "SELECT case when (((t1.c)<=a-11*t1.e)) then t1.b else a end | ((abs(b*(abs(t1.e | +c)/abs(11)))/abs(t1.a))) FROM t1 WHERE NOT (case when t1.e in (select t1.a-e from t1 union select t1.e from t1) then 19*coalesce((select a*t1.c-19+f+t1.d-case case when 11>=d then f when not f<>17 then t1.d else t1.f end+t1.e-t1.c when d then b else t1.f end from t1 where t1.f>a), -t1.a)- -(t1.c)-t1.e+b else 11 end<t1.f)"
    end, {
        -- <randexpr-2.305>
        124
        -- </randexpr-2.305>
    })

test:do_test(
    "randexpr-2.306",
    function()
        return test:execsql "SELECT case when (((t1.c)<=a-11*t1.e)) then t1.b else a end & ((abs(b*(abs(t1.e & +c)/abs(11)))/abs(t1.a))) FROM t1 WHERE NOT (case when t1.e in (select t1.a-e from t1 union select t1.e from t1) then 19*coalesce((select a*t1.c-19+f+t1.d-case case when 11>=d then f when not f<>17 then t1.d else t1.f end+t1.e-t1.c when d then b else t1.f end from t1 where t1.f>a), -t1.a)- -(t1.c)-t1.e+b else 11 end<t1.f)"
    end, {
        -- <randexpr-2.306>
        36
        -- </randexpr-2.306>
    })

test:do_test(
    "randexpr-2.307",
    function()
        return test:execsql "SELECT 17*case when case t1.e when 13-c+f then d else (select + -case cast(avg(b) AS integer)*count(*) when (count(distinct 17)+case abs((count(distinct t1.e))) when count(*) then count(*) else count(distinct c) end) | count(*) then  -count(distinct b) else  - -min(e) end*min(f)-min(t1.e) from t1) end-(select (count(*)) from t1) in (select 19 from t1 union select t1.a-(select count(distinct t1.c) from t1) from t1) then a-13 else t1.d end FROM t1 WHERE not exists(select 1 from t1 where (case  -17 when c then (abs(t1.d)/abs(c-(abs(case when t1.e in (17,t1.a,(abs(e)/abs(t1.d))) then +d-17*t1.b when (select +cast(avg(t1.a*t1.e+e-19) AS integer) from t1) in (select (abs(b)/abs(f)) from t1 union select (19) from t1) then b else t1.f end)/abs(e))*e))+(c) else  -t1.c end<=(11)))"
    end, {
        -- <randexpr-2.307>
        
        -- </randexpr-2.307>
    })

test:do_test(
    "randexpr-2.308",
    function()
        return test:execsql "SELECT 17*case when case t1.e when 13-c+f then d else (select + -case cast(avg(b) AS integer)*count(*) when (count(distinct 17)+case abs((count(distinct t1.e))) when count(*) then count(*) else count(distinct c) end) | count(*) then  -count(distinct b) else  - -min(e) end*min(f)-min(t1.e) from t1) end-(select (count(*)) from t1) in (select 19 from t1 union select t1.a-(select count(distinct t1.c) from t1) from t1) then a-13 else t1.d end FROM t1 WHERE NOT (not exists(select 1 from t1 where (case  -17 when c then (abs(t1.d)/abs(c-(abs(case when t1.e in (17,t1.a,(abs(e)/abs(t1.d))) then +d-17*t1.b when (select +cast(avg(t1.a*t1.e+e-19) AS integer) from t1) in (select (abs(b)/abs(f)) from t1 union select (19) from t1) then b else t1.f end)/abs(e))*e))+(c) else  -t1.c end<=(11))))"
    end, {
        -- <randexpr-2.308>
        6800
        -- </randexpr-2.308>
    })

test:do_test(
    "randexpr-2.309",
    function()
        return test:execsql "SELECT 17*case when case t1.e when 13-c+f then d else (select + -case cast(avg(b) AS integer)*count(*) when (count(distinct 17)+case abs((count(distinct t1.e))) when count(*) then count(*) else count(distinct c) end) & count(*) then  -count(distinct b) else  - -min(e) end*min(f)-min(t1.e) from t1) end-(select (count(*)) from t1) in (select 19 from t1 union select t1.a-(select count(distinct t1.c) from t1) from t1) then a-13 else t1.d end FROM t1 WHERE NOT (not exists(select 1 from t1 where (case  -17 when c then (abs(t1.d)/abs(c-(abs(case when t1.e in (17,t1.a,(abs(e)/abs(t1.d))) then +d-17*t1.b when (select +cast(avg(t1.a*t1.e+e-19) AS integer) from t1) in (select (abs(b)/abs(f)) from t1 union select (19) from t1) then b else t1.f end)/abs(e))*e))+(c) else  -t1.c end<=(11))))"
    end, {
        -- <randexpr-2.309>
        6800
        -- </randexpr-2.309>
    })

test:do_test(
    "randexpr-2.310",
    function()
        return test:execsql "SELECT t1.f+coalesce((select t1.b-13-(coalesce((select 17 from t1 where b>a),13)*11)-t1.c from t1 where 11 between t1.a and  -13+t1.f*~coalesce((select max(b-f) from t1 where t1.a<=13 or a not in (13,f,17)),b) or (t1.d<19 or b> -t1.c)),b) FROM t1 WHERE 11 not between d and coalesce((select  -(select (cast(avg(d) AS integer)) from t1) from t1 where case when 17<t1.a then t1.b else coalesce((select max(f) from t1 where t1.d-+case when (d<=t1.f) and t1.e not in (17,t1.d,t1.a) and 11 in (13,t1.e, -t1.a) and t1.c<13 then  -b else case when a>13 then e when 19 between t1.a and t1.b then b else b end end*13<=c),t1.c) end in (select t1.e from t1 union select d from t1)),t1.b)"
    end, {
        -- <randexpr-2.310>
        300
        -- </randexpr-2.310>
    })

test:do_test(
    "randexpr-2.311",
    function()
        return test:execsql "SELECT t1.f+coalesce((select t1.b-13-(coalesce((select 17 from t1 where b>a),13)*11)-t1.c from t1 where 11 between t1.a and  -13+t1.f*~coalesce((select max(b-f) from t1 where t1.a<=13 or a not in (13,f,17)),b) or (t1.d<19 or b> -t1.c)),b) FROM t1 WHERE NOT (11 not between d and coalesce((select  -(select (cast(avg(d) AS integer)) from t1) from t1 where case when 17<t1.a then t1.b else coalesce((select max(f) from t1 where t1.d-+case when (d<=t1.f) and t1.e not in (17,t1.d,t1.a) and 11 in (13,t1.e, -t1.a) and t1.c<13 then  -b else case when a>13 then e when 19 between t1.a and t1.b then b else b end end*13<=c),t1.c) end in (select t1.e from t1 union select d from t1)),t1.b))"
    end, {
        -- <randexpr-2.311>
        
        -- </randexpr-2.311>
    })

test:do_test(
    "randexpr-2.312",
    function()
        return test:execsql "SELECT (abs(13)/abs((select min(case when case when exists(select 1 from t1 where not exists(select 1 from t1 where (select count(distinct (t1.e)) from t1)+t1.f>t1.e) and t1.a>=13 or f in (select t1.e from t1 union select t1.e from t1)) then b when f not in (13,13,13) then coalesce((select max(d*f) from t1 where t1.e in (t1.d,t1.e,(e))),t1.e) else a end>=t1.f then b when t1.c in (e,f,t1.e) then b else t1.c end)*abs(count(*))-abs(~count(*)-min(e))-cast(avg(17) AS integer) from t1))) FROM t1 WHERE t1.b not in (a*17-17-case when  -17-t1.f in (select coalesce((select t1.a from t1 where (d)=t1.a),d) from t1 union select 19 from t1) or 13 not between 17 and 13 and (19 between (t1.e) and t1.f) or ( -t1.e)>=17 then b when t1.d not in (19,f,t1.f) then a else case when t1.a=t1.d then e when 17 in (t1.e,t1.b,t1.d) then t1.a else a end end,e,11)"
    end, {
        -- <randexpr-2.312>
        0
        -- </randexpr-2.312>
    })

test:do_test(
    "randexpr-2.313",
    function()
        return test:execsql "SELECT (abs(13)/abs((select min(case when case when exists(select 1 from t1 where not exists(select 1 from t1 where (select count(distinct (t1.e)) from t1)+t1.f>t1.e) and t1.a>=13 or f in (select t1.e from t1 union select t1.e from t1)) then b when f not in (13,13,13) then coalesce((select max(d*f) from t1 where t1.e in (t1.d,t1.e,(e))),t1.e) else a end>=t1.f then b when t1.c in (e,f,t1.e) then b else t1.c end)*abs(count(*))-abs(~count(*)-min(e))-cast(avg(17) AS integer) from t1))) FROM t1 WHERE NOT (t1.b not in (a*17-17-case when  -17-t1.f in (select coalesce((select t1.a from t1 where (d)=t1.a),d) from t1 union select 19 from t1) or 13 not between 17 and 13 and (19 between (t1.e) and t1.f) or ( -t1.e)>=17 then b when t1.d not in (19,f,t1.f) then a else case when t1.a=t1.d then e when 17 in (t1.e,t1.b,t1.d) then t1.a else a end end,e,11))"
    end, {
        -- <randexpr-2.313>
        
        -- </randexpr-2.313>
    })

test:do_test(
    "randexpr-2.314",
    function()
        return test:execsql "SELECT (abs(case coalesce((select t1.d* -case when d in (select cast(avg(13) AS integer)*abs(((cast(avg(d) AS integer)))+ -count(distinct c))-max(t1.c) from t1 union select min(e) from t1) then (abs(19)/abs(case when b not in (19,d,13) or t1.b not in (b,17,17) then e else b end)) else 19 end from t1 where a>=t1.c and 17 not in (t1.c,17,t1.f)),13)*t1.f when e then (11) else 17 end+19 | b)/abs(f))-t1.e FROM t1 WHERE not exists(select 1 from t1 where case a when coalesce((select max(case 19 when 17 then b-d else t1.e end) from t1 where ( -coalesce((select max(t1.a) from t1 where e between t1.b and (abs(e)/abs(17))),(abs(case when case when 13 between e and (t1.b) and 11 not in (t1.f,t1.e,c) then (t1.d) else  -c end< -e then 11 when 13>t1.b then 11 else t1.a end*13)/abs((f)))-t1.a) not in (e,(b),t1.c))),19) then t1.b else 13 end not between t1.b and 11)"
    end, {
        -- <randexpr-2.314>
        
        -- </randexpr-2.314>
    })

test:do_test(
    "randexpr-2.315",
    function()
        return test:execsql "SELECT (abs(case coalesce((select t1.d* -case when d in (select cast(avg(13) AS integer)*abs(((cast(avg(d) AS integer)))+ -count(distinct c))-max(t1.c) from t1 union select min(e) from t1) then (abs(19)/abs(case when b not in (19,d,13) or t1.b not in (b,17,17) then e else b end)) else 19 end from t1 where a>=t1.c and 17 not in (t1.c,17,t1.f)),13)*t1.f when e then (11) else 17 end+19 | b)/abs(f))-t1.e FROM t1 WHERE NOT (not exists(select 1 from t1 where case a when coalesce((select max(case 19 when 17 then b-d else t1.e end) from t1 where ( -coalesce((select max(t1.a) from t1 where e between t1.b and (abs(e)/abs(17))),(abs(case when case when 13 between e and (t1.b) and 11 not in (t1.f,t1.e,c) then (t1.d) else  -c end< -e then 11 when 13>t1.b then 11 else t1.a end*13)/abs((f)))-t1.a) not in (e,(b),t1.c))),19) then t1.b else 13 end not between t1.b and 11))"
    end, {
        -- <randexpr-2.315>
        -500
        -- </randexpr-2.315>
    })

test:do_test(
    "randexpr-2.316",
    function()
        return test:execsql "SELECT (abs(case coalesce((select t1.d* -case when d in (select cast(avg(13) AS integer)*abs(((cast(avg(d) AS integer)))+ -count(distinct c))-max(t1.c) from t1 union select min(e) from t1) then (abs(19)/abs(case when b not in (19,d,13) or t1.b not in (b,17,17) then e else b end)) else 19 end from t1 where a>=t1.c and 17 not in (t1.c,17,t1.f)),13)*t1.f when e then (11) else 17 end+19 & b)/abs(f))-t1.e FROM t1 WHERE NOT (not exists(select 1 from t1 where case a when coalesce((select max(case 19 when 17 then b-d else t1.e end) from t1 where ( -coalesce((select max(t1.a) from t1 where e between t1.b and (abs(e)/abs(17))),(abs(case when case when 13 between e and (t1.b) and 11 not in (t1.f,t1.e,c) then (t1.d) else  -c end< -e then 11 when 13>t1.b then 11 else t1.a end*13)/abs((f)))-t1.a) not in (e,(b),t1.c))),19) then t1.b else 13 end not between t1.b and 11))"
    end, {
        -- <randexpr-2.316>
        -500
        -- </randexpr-2.316>
    })

test:do_test(
    "randexpr-2.317",
    function()
        return test:execsql "SELECT  -(+case when ~t1.d-f-case coalesce((select max((select (min((abs(t1.f)/abs(t1.b))-17)) from t1)) from t1 where e<=17),f) when t1.f then (select case  -( -count(distinct b)) when cast(avg( -13) AS integer) then cast(avg(13) AS integer) else max(19) end from t1)-t1.e else 13 end*b between t1.c and t1.d then t1.d when e<t1.f then  -t1.b else 19 end | d*e) FROM t1 WHERE ~t1.d*~( -coalesce((select max(t1.d | t1.a) from t1 where d-(select  -( - -count(distinct 13)) | min((t1.f))+min(t1.c) from t1) not between case t1.a when t1.b then e else  -c end and c or t1.a not in (a,19,c)),d)) in (select +(max(t1.b))*max((13))++(count(distinct t1.a))+count(*)-count(distinct f) | cast(avg(t1.d) AS integer) from t1 union select cast(avg(13) AS integer) from t1)"
    end, {
        -- <randexpr-2.317>
        
        -- </randexpr-2.317>
    })

test:do_test(
    "randexpr-2.318",
    function()
        return test:execsql "SELECT  -(+case when ~t1.d-f-case coalesce((select max((select (min((abs(t1.f)/abs(t1.b))-17)) from t1)) from t1 where e<=17),f) when t1.f then (select case  -( -count(distinct b)) when cast(avg( -13) AS integer) then cast(avg(13) AS integer) else max(19) end from t1)-t1.e else 13 end*b between t1.c and t1.d then t1.d when e<t1.f then  -t1.b else 19 end | d*e) FROM t1 WHERE NOT (~t1.d*~( -coalesce((select max(t1.d | t1.a) from t1 where d-(select  -( - -count(distinct 13)) | min((t1.f))+min(t1.c) from t1) not between case t1.a when t1.b then e else  -c end and c or t1.a not in (a,19,c)),d)) in (select +(max(t1.b))*max((13))++(count(distinct t1.a))+count(*)-count(distinct f) | cast(avg(t1.d) AS integer) from t1 union select cast(avg(13) AS integer) from t1))"
    end, {
        -- <randexpr-2.318>
        136
        -- </randexpr-2.318>
    })

test:do_test(
    "randexpr-2.319",
    function()
        return test:execsql "SELECT  -(+case when ~t1.d-f-case coalesce((select max((select (min((abs(t1.f)/abs(t1.b))-17)) from t1)) from t1 where e<=17),f) when t1.f then (select case  -( -count(distinct b)) when cast(avg( -13) AS integer) then cast(avg(13) AS integer) else max(19) end from t1)-t1.e else 13 end*b between t1.c and t1.d then t1.d when e<t1.f then  -t1.b else 19 end & d*e) FROM t1 WHERE NOT (~t1.d*~( -coalesce((select max(t1.d | t1.a) from t1 where d-(select  -( - -count(distinct 13)) | min((t1.f))+min(t1.c) from t1) not between case t1.a when t1.b then e else  -c end and c or t1.a not in (a,19,c)),d)) in (select +(max(t1.b))*max((13))++(count(distinct t1.a))+count(*)-count(distinct f) | cast(avg(t1.d) AS integer) from t1 union select cast(avg(13) AS integer) from t1))"
    end, {
        -- <randexpr-2.319>
        -199936
        -- </randexpr-2.319>
    })

test:do_test(
    "randexpr-2.320",
    function()
        return test:execsql "SELECT ~d-coalesce((select +e from t1 where b not between b and ~d++ -t1.b),f)-f-+19-t1.a+case when d<=(abs(19)/abs(+coalesce((select 11 from t1 where not exists(select 1 from t1 where not coalesce((select t1.d from t1 where not t1.a<=t1.c),11) in (select 19 from t1 union select t1.a from t1) or t1.c<=t1.c and a<t1.b)),17-t1.e))) then f else t1.a end*c FROM t1 WHERE (select count(*) from t1)*e-17 | f not between 11 and t1.d or t1.c* -b in (select (abs(case when not 19<( -(t1.e-c*t1.b)+(d)-c) then t1.f-t1.b when t1.f<=11 or exists(select 1 from t1 where t1.e in (13,t1.f,t1.d)) then t1.f else 19 end)/abs(e)) from t1 union select 17 from t1)"
    end, {
        -- <randexpr-2.320>
        28380
        -- </randexpr-2.320>
    })

test:do_test(
    "randexpr-2.321",
    function()
        return test:execsql "SELECT ~d-coalesce((select +e from t1 where b not between b and ~d++ -t1.b),f)-f-+19-t1.a+case when d<=(abs(19)/abs(+coalesce((select 11 from t1 where not exists(select 1 from t1 where not coalesce((select t1.d from t1 where not t1.a<=t1.c),11) in (select 19 from t1 union select t1.a from t1) or t1.c<=t1.c and a<t1.b)),17-t1.e))) then f else t1.a end*c FROM t1 WHERE NOT ((select count(*) from t1)*e-17 | f not between 11 and t1.d or t1.c* -b in (select (abs(case when not 19<( -(t1.e-c*t1.b)+(d)-c) then t1.f-t1.b when t1.f<=11 or exists(select 1 from t1 where t1.e in (13,t1.f,t1.d)) then t1.f else 19 end)/abs(e)) from t1 union select 17 from t1))"
    end, {
        -- <randexpr-2.321>
        
        -- </randexpr-2.321>
    })

test:do_test(
    "randexpr-2.322",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where 11 in (select count(distinct d-coalesce((select t1.c-t1.f from t1 where 13 in (19,e,t1.b) and e in (select ( -count(*)) from t1 union select max(e) from t1) or t1.a>t1.f),d)*t1.e)+max(t1.f)+cast(avg(e) AS integer) | (abs((count(distinct 17)))) from t1 union select max(t1.b) from t1) or 17 in (select  -t1.b from t1 union select t1.a from t1) and exists(select 1 from t1 where t1.e=t1.c))),f+(t1.e)) FROM t1 WHERE exists(select 1 from t1 where +t1.d between (abs((abs(t1.c)/abs(case when not exists(select 1 from t1 where d*~(select abs(min(13))-( -(max(t1.f))*( -(count(distinct a)))-max(17)*min(t1.a) | (cast(avg(t1.b) AS integer))) from t1)>case when a in (select max(c) from t1 union select count(distinct  -t1.a) from t1) or +17 in (select  -count(distinct t1.f) from t1 union select cast(avg(t1.f) AS integer) from t1) then c else t1.a end) then  -t1.f else t1.f end)))/abs(c+a)) and d)"
    end, {
        -- <randexpr-2.322>
        17
        -- </randexpr-2.322>
    })

test:do_test(
    "randexpr-2.323",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where 11 in (select count(distinct d-coalesce((select t1.c-t1.f from t1 where 13 in (19,e,t1.b) and e in (select ( -count(*)) from t1 union select max(e) from t1) or t1.a>t1.f),d)*t1.e)+max(t1.f)+cast(avg(e) AS integer) | (abs((count(distinct 17)))) from t1 union select max(t1.b) from t1) or 17 in (select  -t1.b from t1 union select t1.a from t1) and exists(select 1 from t1 where t1.e=t1.c))),f+(t1.e)) FROM t1 WHERE NOT (exists(select 1 from t1 where +t1.d between (abs((abs(t1.c)/abs(case when not exists(select 1 from t1 where d*~(select abs(min(13))-( -(max(t1.f))*( -(count(distinct a)))-max(17)*min(t1.a) | (cast(avg(t1.b) AS integer))) from t1)>case when a in (select max(c) from t1 union select count(distinct  -t1.a) from t1) or +17 in (select  -count(distinct t1.f) from t1 union select cast(avg(t1.f) AS integer) from t1) then c else t1.a end) then  -t1.f else t1.f end)))/abs(c+a)) and d))"
    end, {
        -- <randexpr-2.323>
        
        -- </randexpr-2.323>
    })

test:do_test(
    "randexpr-2.324",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where 11 in (select count(distinct d-coalesce((select t1.c-t1.f from t1 where 13 in (19,e,t1.b) and e in (select ( -count(*)) from t1 union select max(e) from t1) or t1.a>t1.f),d)*t1.e)+max(t1.f)+cast(avg(e) AS integer) & (abs((count(distinct 17)))) from t1 union select max(t1.b) from t1) or 17 in (select  -t1.b from t1 union select t1.a from t1) and exists(select 1 from t1 where t1.e=t1.c))),f+(t1.e)) FROM t1 WHERE exists(select 1 from t1 where +t1.d between (abs((abs(t1.c)/abs(case when not exists(select 1 from t1 where d*~(select abs(min(13))-( -(max(t1.f))*( -(count(distinct a)))-max(17)*min(t1.a) | (cast(avg(t1.b) AS integer))) from t1)>case when a in (select max(c) from t1 union select count(distinct  -t1.a) from t1) or +17 in (select  -count(distinct t1.f) from t1 union select cast(avg(t1.f) AS integer) from t1) then c else t1.a end) then  -t1.f else t1.f end)))/abs(c+a)) and d)"
    end, {
        -- <randexpr-2.324>
        17
        -- </randexpr-2.324>
    })

test:do_test(
    "randexpr-2.325",
    function()
        return test:execsql "SELECT t1.d*17- -case when case (b) when t1.c then (abs(t1.f)/abs((select + -~abs(min(f) | +cast(avg(++t1.e+t1.d) AS integer) | ((count(distinct t1.a)-count(*)))) from t1))) else c*case t1.b when t1.d then (t1.c) else t1.c end*(b)-c end=t1.d then t1.c when  -17=c then t1.e else t1.c end FROM t1 WHERE t1.b in (f,b,a)"
    end, {
        -- <randexpr-2.325>
        7100
        -- </randexpr-2.325>
    })

test:do_test(
    "randexpr-2.326",
    function()
        return test:execsql "SELECT t1.d*17- -case when case (b) when t1.c then (abs(t1.f)/abs((select + -~abs(min(f) | +cast(avg(++t1.e+t1.d) AS integer) | ((count(distinct t1.a)-count(*)))) from t1))) else c*case t1.b when t1.d then (t1.c) else t1.c end*(b)-c end=t1.d then t1.c when  -17=c then t1.e else t1.c end FROM t1 WHERE NOT (t1.b in (f,b,a))"
    end, {
        -- <randexpr-2.326>
        
        -- </randexpr-2.326>
    })

test:do_test(
    "randexpr-2.327",
    function()
        return test:execsql "SELECT t1.d*17- -case when case (b) when t1.c then (abs(t1.f)/abs((select + -~abs(min(f) & +cast(avg(++t1.e+t1.d) AS integer) & ((count(distinct t1.a)-count(*)))) from t1))) else c*case t1.b when t1.d then (t1.c) else t1.c end*(b)-c end=t1.d then t1.c when  -17=c then t1.e else t1.c end FROM t1 WHERE t1.b in (f,b,a)"
    end, {
        -- <randexpr-2.327>
        7100
        -- </randexpr-2.327>
    })

test:do_test(
    "randexpr-2.328",
    function()
        return test:execsql "SELECT coalesce((select e-t1.d-+b*coalesce((select 11 from t1 where (t1.a<=coalesce((select  - -coalesce((select max(case case 19 when t1.d then t1.e else t1.a end when b then 13 else t1.e end) from t1 where (c)>=(b)),t1.c)+t1.b from t1 where t1.e>e and exists(select 1 from t1 where b in (t1.b,e,t1.c) or e not between a and d) and 13<b),a))),t1.e) from t1 where t1.a<t1.a),t1.e) FROM t1 WHERE exists(select 1 from t1 where coalesce((select max(coalesce((select case case coalesce((select d from t1 where b in (17,t1.a,13)),11) when (coalesce((select 11 from t1 where a++t1.d>(coalesce((select (f)+t1.c from t1 where a>t1.c),b))),t1.e)) then 19 else e end when t1.d then t1.e else b end from t1 where t1.b>=f),13)-b*17) from t1 where 11<>e),t1.b)<(c))"
    end, {
        -- <randexpr-2.328>
        500
        -- </randexpr-2.328>
    })

test:do_test(
    "randexpr-2.329",
    function()
        return test:execsql "SELECT coalesce((select e-t1.d-+b*coalesce((select 11 from t1 where (t1.a<=coalesce((select  - -coalesce((select max(case case 19 when t1.d then t1.e else t1.a end when b then 13 else t1.e end) from t1 where (c)>=(b)),t1.c)+t1.b from t1 where t1.e>e and exists(select 1 from t1 where b in (t1.b,e,t1.c) or e not between a and d) and 13<b),a))),t1.e) from t1 where t1.a<t1.a),t1.e) FROM t1 WHERE NOT (exists(select 1 from t1 where coalesce((select max(coalesce((select case case coalesce((select d from t1 where b in (17,t1.a,13)),11) when (coalesce((select 11 from t1 where a++t1.d>(coalesce((select (f)+t1.c from t1 where a>t1.c),b))),t1.e)) then 19 else e end when t1.d then t1.e else b end from t1 where t1.b>=f),13)-b*17) from t1 where 11<>e),t1.b)<(c)))"
    end, {
        -- <randexpr-2.329>
        
        -- </randexpr-2.329>
    })

test:do_test(
    "randexpr-2.330",
    function()
        return test:execsql "SELECT (abs(case when ++e not in (~c-(19)*+case t1.c when t1.d-coalesce((select max(t1.f) from t1 where (select count(*) from t1)>case when exists(select 1 from t1 where not exists(select 1 from t1 where (not not exists(select 1 from t1 where 19<t1.c)))) then ~t1.d else case coalesce((select 17 from t1 where  -t1.b<>e),t1.e) when 13 then b else t1.c end end+f),c)*t1.c then t1.e else t1.b end,11,b) then  -(t1.b) else a end)/abs(13)) FROM t1 WHERE a*t1.a<=17 and exists(select 1 from t1 where (+case coalesce((select max(f) from t1 where d in (select ((+count(*)-( -max(b))))*min(t1.c)* -max(11) from t1 union select count(distinct (19)) from t1)),t1.c) when 13 then 19 else coalesce((select t1.a from t1 where t1.c not in (t1.c,f,13)),b) end)>t1.c) and ( -( -19) between 13 and b or b in (select 11 from t1 union select a from t1) and 19 in (t1.d,t1.d,19))"
    end, {
        -- <randexpr-2.330>
        
        -- </randexpr-2.330>
    })

test:do_test(
    "randexpr-2.331",
    function()
        return test:execsql "SELECT (abs(case when ++e not in (~c-(19)*+case t1.c when t1.d-coalesce((select max(t1.f) from t1 where (select count(*) from t1)>case when exists(select 1 from t1 where not exists(select 1 from t1 where (not not exists(select 1 from t1 where 19<t1.c)))) then ~t1.d else case coalesce((select 17 from t1 where  -t1.b<>e),t1.e) when 13 then b else t1.c end end+f),c)*t1.c then t1.e else t1.b end,11,b) then  -(t1.b) else a end)/abs(13)) FROM t1 WHERE NOT (a*t1.a<=17 and exists(select 1 from t1 where (+case coalesce((select max(f) from t1 where d in (select ((+count(*)-( -max(b))))*min(t1.c)* -max(11) from t1 union select count(distinct (19)) from t1)),t1.c) when 13 then 19 else coalesce((select t1.a from t1 where t1.c not in (t1.c,f,13)),b) end)>t1.c) and ( -( -19) between 13 and b or b in (select 11 from t1 union select a from t1) and 19 in (t1.d,t1.d,19)))"
    end, {
        -- <randexpr-2.331>
        15
        -- </randexpr-2.331>
    })

test:do_test(
    "randexpr-2.332",
    function()
        return test:execsql "SELECT case when a>=f then  -t1.a-11*t1.c when ((t1.e-t1.e+17 between (select max(c) from t1)-13 and coalesce((select t1.d from t1 where ((coalesce((select max(case when (not b>17) then t1.b-b when  -e in (c,a,13) then 11 else t1.a end) from t1 where 19<=11),t1.e)>=e))),t1.a))) then c else t1.b end | 17 FROM t1 WHERE 11-t1.d+d-13+(t1.f*case when exists(select 1 from t1 where ( -coalesce((select max(t1.d) from t1 where (exists(select 1 from t1 where 19 in (select d from t1 union select t1.f from t1)))),t1.d)<=case when 13*11+11 in (select abs(+~abs( -min(c))) from t1 union select (min(t1.e)) from t1) then t1.f else 19 end)) then t1.c else (abs(e)/abs(19)) end*t1.f*f)<(t1.d)"
    end, {
        -- <randexpr-2.332>
        
        -- </randexpr-2.332>
    })

test:do_test(
    "randexpr-2.333",
    function()
        return test:execsql "SELECT case when a>=f then  -t1.a-11*t1.c when ((t1.e-t1.e+17 between (select max(c) from t1)-13 and coalesce((select t1.d from t1 where ((coalesce((select max(case when (not b>17) then t1.b-b when  -e in (c,a,13) then 11 else t1.a end) from t1 where 19<=11),t1.e)>=e))),t1.a))) then c else t1.b end | 17 FROM t1 WHERE NOT (11-t1.d+d-13+(t1.f*case when exists(select 1 from t1 where ( -coalesce((select max(t1.d) from t1 where (exists(select 1 from t1 where 19 in (select d from t1 union select t1.f from t1)))),t1.d)<=case when 13*11+11 in (select abs(+~abs( -min(c))) from t1 union select (min(t1.e)) from t1) then t1.f else 19 end)) then t1.c else (abs(e)/abs(19)) end*t1.f*f)<(t1.d))"
    end, {
        -- <randexpr-2.333>
        217
        -- </randexpr-2.333>
    })

test:do_test(
    "randexpr-2.334",
    function()
        return test:execsql "SELECT case when a>=f then  -t1.a-11*t1.c when ((t1.e-t1.e+17 between (select max(c) from t1)-13 and coalesce((select t1.d from t1 where ((coalesce((select max(case when (not b>17) then t1.b-b when  -e in (c,a,13) then 11 else t1.a end) from t1 where 19<=11),t1.e)>=e))),t1.a))) then c else t1.b end & 17 FROM t1 WHERE NOT (11-t1.d+d-13+(t1.f*case when exists(select 1 from t1 where ( -coalesce((select max(t1.d) from t1 where (exists(select 1 from t1 where 19 in (select d from t1 union select t1.f from t1)))),t1.d)<=case when 13*11+11 in (select abs(+~abs( -min(c))) from t1 union select (min(t1.e)) from t1) then t1.f else 19 end)) then t1.c else (abs(e)/abs(19)) end*t1.f*f)<(t1.d))"
    end, {
        -- <randexpr-2.334>
        0
        -- </randexpr-2.334>
    })

test:do_test(
    "randexpr-2.335",
    function()
        return test:execsql "SELECT case ~13*c-t1.f- -t1.f when coalesce((select max(coalesce((select max(t1.c) from t1 where coalesce((select t1.d from t1 where 11*f-a=a),t1.e) in (select case ~count(distinct 11) | min(c) when (count(*))-count(*) then max( -17) else (min(13)) end from t1 union select  - -cast(avg(b) AS integer) from t1)),19)-t1.c) from t1 where exists(select 1 from t1 where t1.b not between t1.e and 11 and ((a<>t1.f)) and (t1.a)=t1.d)),17) then t1.d else  -b end FROM t1 WHERE case when ~13+t1.e-19>=13 then 17 else t1.c end>=a*19 and (f in (select case min(t1.e*+(abs(11)/abs(13))) when count(distinct t1.c) | abs((min(t1.b)-(max(t1.d)))+abs(max(a))+count(*)) | cast(avg(e) AS integer) then max(c) else max(c) end from t1 union select min(t1.c) from t1))"
    end, {
        -- <randexpr-2.335>
        
        -- </randexpr-2.335>
    })

test:do_test(
    "randexpr-2.336",
    function()
        return test:execsql "SELECT case ~13*c-t1.f- -t1.f when coalesce((select max(coalesce((select max(t1.c) from t1 where coalesce((select t1.d from t1 where 11*f-a=a),t1.e) in (select case ~count(distinct 11) | min(c) when (count(*))-count(*) then max( -17) else (min(13)) end from t1 union select  - -cast(avg(b) AS integer) from t1)),19)-t1.c) from t1 where exists(select 1 from t1 where t1.b not between t1.e and 11 and ((a<>t1.f)) and (t1.a)=t1.d)),17) then t1.d else  -b end FROM t1 WHERE NOT (case when ~13+t1.e-19>=13 then 17 else t1.c end>=a*19 and (f in (select case min(t1.e*+(abs(11)/abs(13))) when count(distinct t1.c) | abs((min(t1.b)-(max(t1.d)))+abs(max(a))+count(*)) | cast(avg(e) AS integer) then max(c) else max(c) end from t1 union select min(t1.c) from t1)))"
    end, {
        -- <randexpr-2.336>
        -200
        -- </randexpr-2.336>
    })

test:do_test(
    "randexpr-2.337",
    function()
        return test:execsql "SELECT case ~13*c-t1.f- -t1.f when coalesce((select max(coalesce((select max(t1.c) from t1 where coalesce((select t1.d from t1 where 11*f-a=a),t1.e) in (select case ~count(distinct 11) & min(c) when (count(*))-count(*) then max( -17) else (min(13)) end from t1 union select  - -cast(avg(b) AS integer) from t1)),19)-t1.c) from t1 where exists(select 1 from t1 where t1.b not between t1.e and 11 and ((a<>t1.f)) and (t1.a)=t1.d)),17) then t1.d else  -b end FROM t1 WHERE NOT (case when ~13+t1.e-19>=13 then 17 else t1.c end>=a*19 and (f in (select case min(t1.e*+(abs(11)/abs(13))) when count(distinct t1.c) | abs((min(t1.b)-(max(t1.d)))+abs(max(a))+count(*)) | cast(avg(e) AS integer) then max(c) else max(c) end from t1 union select min(t1.c) from t1)))"
    end, {
        -- <randexpr-2.337>
        -200
        -- </randexpr-2.337>
    })

test:do_test(
    "randexpr-2.338",
    function()
        return test:execsql "SELECT f*13-t1.f*(abs(19*t1.a*c-(select ~max(t1.c)- -( -cast(avg(f) AS integer))+(max(d))*cast(avg(t1.d) AS integer)*(count(*)) from t1))/abs(case when coalesce((select (coalesce((select max(t1.c) from t1 where  -(b)<> -t1.a),b)+11) from t1 where not (11)<=t1.e and c not between 17 and t1.e and b not in (f,(t1.a),t1.e)),t1.f) in (select t1.d from t1 union select 19 from t1) then t1.a when f>13 then t1.e else a end)) FROM t1 WHERE  -b<>b*t1.e"
    end, {
        -- <randexpr-2.338>
        -484800
        -- </randexpr-2.338>
    })

test:do_test(
    "randexpr-2.339",
    function()
        return test:execsql "SELECT f*13-t1.f*(abs(19*t1.a*c-(select ~max(t1.c)- -( -cast(avg(f) AS integer))+(max(d))*cast(avg(t1.d) AS integer)*(count(*)) from t1))/abs(case when coalesce((select (coalesce((select max(t1.c) from t1 where  -(b)<> -t1.a),b)+11) from t1 where not (11)<=t1.e and c not between 17 and t1.e and b not in (f,(t1.a),t1.e)),t1.f) in (select t1.d from t1 union select 19 from t1) then t1.a when f>13 then t1.e else a end)) FROM t1 WHERE NOT ( -b<>b*t1.e)"
    end, {
        -- <randexpr-2.339>
        
        -- </randexpr-2.339>
    })

test:do_test(
    "randexpr-2.340",
    function()
        return test:execsql "SELECT case when coalesce((select c from t1 where (13-(11-t1.e | t1.b) in (select +min(c)*+case +min(t1.e) when min(coalesce((select t1.e*t1.a from t1 where t1.f in (t1.d,11,t1.d) or t1.e>11 or t1.d>=c),17))+max(11)-count(distinct  -a) | max(11)+min(t1.c)-max(13) then count(distinct c) else (max(13)) end from t1 union select (( -cast(avg(11) AS integer))) from t1))),d) in (select f from t1 union select t1.a from t1) then 17 else 19 end FROM t1 WHERE not exists(select 1 from t1 where (select +min(case when not (f*e between (select min(~~t1.d) from t1)*(abs(c)/abs(d)) and case when f<t1.b then 19 else e end+t1.b) and not exists(select 1 from t1 where exists(select 1 from t1 where 11 in (select t1.e from t1 union select (a) from t1))) then case when  -c>=b then t1.f when not c>=17 then ~t1.b else 11 end else 19 end) from t1)-19 not in (d,t1.a,d))"
    end, {
        -- <randexpr-2.340>
        
        -- </randexpr-2.340>
    })

test:do_test(
    "randexpr-2.341",
    function()
        return test:execsql "SELECT case when coalesce((select c from t1 where (13-(11-t1.e | t1.b) in (select +min(c)*+case +min(t1.e) when min(coalesce((select t1.e*t1.a from t1 where t1.f in (t1.d,11,t1.d) or t1.e>11 or t1.d>=c),17))+max(11)-count(distinct  -a) | max(11)+min(t1.c)-max(13) then count(distinct c) else (max(13)) end from t1 union select (( -cast(avg(11) AS integer))) from t1))),d) in (select f from t1 union select t1.a from t1) then 17 else 19 end FROM t1 WHERE NOT (not exists(select 1 from t1 where (select +min(case when not (f*e between (select min(~~t1.d) from t1)*(abs(c)/abs(d)) and case when f<t1.b then 19 else e end+t1.b) and not exists(select 1 from t1 where exists(select 1 from t1 where 11 in (select t1.e from t1 union select (a) from t1))) then case when  -c>=b then t1.f when not c>=17 then ~t1.b else 11 end else 19 end) from t1)-19 not in (d,t1.a,d)))"
    end, {
        -- <randexpr-2.341>
        19
        -- </randexpr-2.341>
    })

test:do_test(
    "randexpr-2.342",
    function()
        return test:execsql "SELECT case when coalesce((select c from t1 where (13-(11-t1.e & t1.b) in (select +min(c)*+case +min(t1.e) when min(coalesce((select t1.e*t1.a from t1 where t1.f in (t1.d,11,t1.d) or t1.e>11 or t1.d>=c),17))+max(11)-count(distinct  -a) & max(11)+min(t1.c)-max(13) then count(distinct c) else (max(13)) end from t1 union select (( -cast(avg(11) AS integer))) from t1))),d) in (select f from t1 union select t1.a from t1) then 17 else 19 end FROM t1 WHERE NOT (not exists(select 1 from t1 where (select +min(case when not (f*e between (select min(~~t1.d) from t1)*(abs(c)/abs(d)) and case when f<t1.b then 19 else e end+t1.b) and not exists(select 1 from t1 where exists(select 1 from t1 where 11 in (select t1.e from t1 union select (a) from t1))) then case when  -c>=b then t1.f when not c>=17 then ~t1.b else 11 end else 19 end) from t1)-19 not in (d,t1.a,d)))"
    end, {
        -- <randexpr-2.342>
        19
        -- </randexpr-2.342>
    })

test:do_test(
    "randexpr-2.343",
    function()
        return test:execsql "SELECT t1.c*a+(case when t1.b+11 | case when exists(select 1 from t1 where b<>17 or not exists(select 1 from t1 where t1.f in (19,t1.f,c)) or (t1.d)<>b) then e else d end+t1.b+t1.a*b=t1.d or d=b then t1.e when not exists(select 1 from t1 where b>t1.c or 17 between t1.f and e and d>=t1.c) then t1.d else c end) FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where (abs(c)/abs(b)) in (t1.a, -e*~e*17,17)))"
    end, {
        -- <randexpr-2.343>
        30400
        -- </randexpr-2.343>
    })

test:do_test(
    "randexpr-2.344",
    function()
        return test:execsql "SELECT t1.c*a+(case when t1.b+11 | case when exists(select 1 from t1 where b<>17 or not exists(select 1 from t1 where t1.f in (19,t1.f,c)) or (t1.d)<>b) then e else d end+t1.b+t1.a*b=t1.d or d=b then t1.e when not exists(select 1 from t1 where b>t1.c or 17 between t1.f and e and d>=t1.c) then t1.d else c end) FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where (abs(c)/abs(b)) in (t1.a, -e*~e*17,17))))"
    end, {
        -- <randexpr-2.344>
        
        -- </randexpr-2.344>
    })

test:do_test(
    "randexpr-2.345",
    function()
        return test:execsql "SELECT t1.c*a+(case when t1.b+11 & case when exists(select 1 from t1 where b<>17 or not exists(select 1 from t1 where t1.f in (19,t1.f,c)) or (t1.d)<>b) then e else d end+t1.b+t1.a*b=t1.d or d=b then t1.e when not exists(select 1 from t1 where b>t1.c or 17 between t1.f and e and d>=t1.c) then t1.d else c end) FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where (abs(c)/abs(b)) in (t1.a, -e*~e*17,17)))"
    end, {
        -- <randexpr-2.345>
        30400
        -- </randexpr-2.345>
    })

test:do_test(
    "randexpr-2.346",
    function()
        return test:execsql "SELECT coalesce((select  -b from t1 where t1.f=d),case when case  -17-t1.b*t1.d+d when b then t1.a else t1.e end not in (t1.c,13,19) and e>f and 13 not between 17 and  -f and e not between d and a then 13 when c<=a then 13 else 19 | e end)*a-d*t1.e FROM t1 WHERE (abs(+t1.f)/abs(coalesce((select max(coalesce((select max(e) from t1 where t1.a in (select (abs( -t1.b)/abs(a)) from t1 union select e from t1)),(abs(case t1.f when c then (select (~cast(avg(b*d) AS integer))*abs(min(11)) from t1) else coalesce((select f from t1 where d in (select ( -min(e)) from t1 union select  -count(*) from t1)),t1.c) end*t1.b)/abs(c))+17)) from t1 where exists(select 1 from t1 where d not between t1.f and t1.b)),(t1.c))))*t1.d between t1.f and t1.a"
    end, {
        -- <randexpr-2.346>
        
        -- </randexpr-2.346>
    })

test:do_test(
    "randexpr-2.347",
    function()
        return test:execsql "SELECT coalesce((select  -b from t1 where t1.f=d),case when case  -17-t1.b*t1.d+d when b then t1.a else t1.e end not in (t1.c,13,19) and e>f and 13 not between 17 and  -f and e not between d and a then 13 when c<=a then 13 else 19 | e end)*a-d*t1.e FROM t1 WHERE NOT ((abs(+t1.f)/abs(coalesce((select max(coalesce((select max(e) from t1 where t1.a in (select (abs( -t1.b)/abs(a)) from t1 union select e from t1)),(abs(case t1.f when c then (select (~cast(avg(b*d) AS integer))*abs(min(11)) from t1) else coalesce((select f from t1 where d in (select ( -min(e)) from t1 union select  -count(*) from t1)),t1.c) end*t1.b)/abs(c))+17)) from t1 where exists(select 1 from t1 where d not between t1.f and t1.b)),(t1.c))))*t1.d between t1.f and t1.a)"
    end, {
        -- <randexpr-2.347>
        -149700
        -- </randexpr-2.347>
    })

test:do_test(
    "randexpr-2.348",
    function()
        return test:execsql "SELECT coalesce((select  -b from t1 where t1.f=d),case when case  -17-t1.b*t1.d+d when b then t1.a else t1.e end not in (t1.c,13,19) and e>f and 13 not between 17 and  -f and e not between d and a then 13 when c<=a then 13 else 19 & e end)*a-d*t1.e FROM t1 WHERE NOT ((abs(+t1.f)/abs(coalesce((select max(coalesce((select max(e) from t1 where t1.a in (select (abs( -t1.b)/abs(a)) from t1 union select e from t1)),(abs(case t1.f when c then (select (~cast(avg(b*d) AS integer))*abs(min(11)) from t1) else coalesce((select f from t1 where d in (select ( -min(e)) from t1 union select  -count(*) from t1)),t1.c) end*t1.b)/abs(c))+17)) from t1 where exists(select 1 from t1 where d not between t1.f and t1.b)),(t1.c))))*t1.d between t1.f and t1.a)"
    end, {
        -- <randexpr-2.348>
        -198400
        -- </randexpr-2.348>
    })

test:do_test(
    "randexpr-2.349",
    function()
        return test:execsql "SELECT coalesce((select t1.b*19 from t1 where ~f in (select 19 from t1 union select ~b-+case 13 when coalesce((select max(a) from t1 where (abs(d)/abs(t1.d)) | t1.e-c-t1.d-t1.c+11*f-c+t1.a>17), -a) then f else t1.d end+17 | a*f | t1.c-d from t1)),19) FROM t1 WHERE t1.e*t1.c>coalesce((select 13 from t1 where ~t1.a<>case when exists(select 1 from t1 where e<>~d and not +17 not between a+case 13 when d then case t1.d when t1.a then b else 13 end else 13 end and 13) or 13 not in (t1.e,t1.f,t1.c) then 19-e+19 when f<=t1.f then b else 11 end),e)-13"
    end, {
        -- <randexpr-2.349>
        19
        -- </randexpr-2.349>
    })

test:do_test(
    "randexpr-2.350",
    function()
        return test:execsql "SELECT coalesce((select t1.b*19 from t1 where ~f in (select 19 from t1 union select ~b-+case 13 when coalesce((select max(a) from t1 where (abs(d)/abs(t1.d)) | t1.e-c-t1.d-t1.c+11*f-c+t1.a>17), -a) then f else t1.d end+17 | a*f | t1.c-d from t1)),19) FROM t1 WHERE NOT (t1.e*t1.c>coalesce((select 13 from t1 where ~t1.a<>case when exists(select 1 from t1 where e<>~d and not +17 not between a+case 13 when d then case t1.d when t1.a then b else 13 end else 13 end and 13) or 13 not in (t1.e,t1.f,t1.c) then 19-e+19 when f<=t1.f then b else 11 end),e)-13)"
    end, {
        -- <randexpr-2.350>
        
        -- </randexpr-2.350>
    })

test:do_test(
    "randexpr-2.351",
    function()
        return test:execsql "SELECT coalesce((select t1.b*19 from t1 where ~f in (select 19 from t1 union select ~b-+case 13 when coalesce((select max(a) from t1 where (abs(d)/abs(t1.d)) & t1.e-c-t1.d-t1.c+11*f-c+t1.a>17), -a) then f else t1.d end+17 & a*f & t1.c-d from t1)),19) FROM t1 WHERE t1.e*t1.c>coalesce((select 13 from t1 where ~t1.a<>case when exists(select 1 from t1 where e<>~d and not +17 not between a+case 13 when d then case t1.d when t1.a then b else 13 end else 13 end and 13) or 13 not in (t1.e,t1.f,t1.c) then 19-e+19 when f<=t1.f then b else 11 end),e)-13"
    end, {
        -- <randexpr-2.351>
        19
        -- </randexpr-2.351>
    })

test:do_test(
    "randexpr-2.352",
    function()
        return test:execsql "SELECT (abs( -coalesce((select max((t1.f)) from t1 where not exists(select 1 from t1 where  -b-~b not between t1.c and f and t1.d*( -(select abs(+count(*)) from t1))-d>=a) and case when +case when ((f)) in (select  -count(distinct t1.a) from t1 union select count(*) from t1) then t1.b else d end in (select min(17) from t1 union select min(t1.e) from t1) then d else 17 end+c not between 11 and a),f)*11)/abs(a)) FROM t1 WHERE t1.f*t1.a*(+c)+case case when t1.d=f and (t1.a<>~+a*a*e*t1.e+case when t1.c between 11 and b and t1.a<>e then 13 when ( -t1.e)<>(t1.a) then (t1.b) else 13 end-t1.b-e+f) then t1.f+a else 17 end when d then 17 else d end-t1.e not in (13,t1.a,11)"
    end, {
        -- <randexpr-2.352>
        66
        -- </randexpr-2.352>
    })

test:do_test(
    "randexpr-2.353",
    function()
        return test:execsql "SELECT (abs( -coalesce((select max((t1.f)) from t1 where not exists(select 1 from t1 where  -b-~b not between t1.c and f and t1.d*( -(select abs(+count(*)) from t1))-d>=a) and case when +case when ((f)) in (select  -count(distinct t1.a) from t1 union select count(*) from t1) then t1.b else d end in (select min(17) from t1 union select min(t1.e) from t1) then d else 17 end+c not between 11 and a),f)*11)/abs(a)) FROM t1 WHERE NOT (t1.f*t1.a*(+c)+case case when t1.d=f and (t1.a<>~+a*a*e*t1.e+case when t1.c between 11 and b and t1.a<>e then 13 when ( -t1.e)<>(t1.a) then (t1.b) else 13 end-t1.b-e+f) then t1.f+a else 17 end when d then 17 else d end-t1.e not in (13,t1.a,11))"
    end, {
        -- <randexpr-2.353>
        
        -- </randexpr-2.353>
    })

test:do_test(
    "randexpr-2.354",
    function()
        return test:execsql "SELECT case t1.b- -t1.d+t1.d+t1.f when t1.f then 19+~13 else d end-case when not exists(select 1 from t1 where (f not between coalesce((select b from t1 where d in (17,13,t1.a) and 13 between c and 13 and 19>=f),13) and e or d not between 13 and f) or f>=d) then t1.f else coalesce((select max(~e-11) from t1 where t1.b in (f,13,13)),t1.a) end FROM t1 WHERE a<e"
    end, {
        -- <randexpr-2.354>
        300
        -- </randexpr-2.354>
    })

test:do_test(
    "randexpr-2.355",
    function()
        return test:execsql "SELECT case t1.b- -t1.d+t1.d+t1.f when t1.f then 19+~13 else d end-case when not exists(select 1 from t1 where (f not between coalesce((select b from t1 where d in (17,13,t1.a) and 13 between c and 13 and 19>=f),13) and e or d not between 13 and f) or f>=d) then t1.f else coalesce((select max(~e-11) from t1 where t1.b in (f,13,13)),t1.a) end FROM t1 WHERE NOT (a<e)"
    end, {
        -- <randexpr-2.355>
        
        -- </randexpr-2.355>
    })

test:do_test(
    "randexpr-2.356",
    function()
        return test:execsql "SELECT  -coalesce((select max(13) from t1 where case case when f in (select e from t1 union select coalesce((select max(e) from t1 where (select  -max(e) from t1)*t1.e<e and exists(select 1 from t1 where  -c in (a,a,a))),t1.d) from t1) and e>=t1.c and exists(select 1 from t1 where t1.f>=13) then t1.d when d between t1.d and t1.a then 19 else a end | e when (a) then e else a end between b and t1.c and not exists(select 1 from t1 where 13 in (t1.d,t1.a,13)) or t1.a>= -13),c) FROM t1 WHERE t1.e not in ( -coalesce((select max(13) from t1 where exists(select 1 from t1 where not t1.d>a) and t1.a not in (d*+case when t1.b in (select max(e*11+t1.a)+ -count(*)-( -max(t1.e))-min(11)-count(distinct t1.a) from t1 union select  - -min(t1.b) from t1) then t1.e when e in (select count(distinct t1.a) from t1 union select (max(d)) from t1) then e else  -(19) end+ -t1.d, -17,f)),case c when a then f else 17 end),d,11)"
    end, {
        -- <randexpr-2.356>
        -13
        -- </randexpr-2.356>
    })

test:do_test(
    "randexpr-2.357",
    function()
        return test:execsql "SELECT  -coalesce((select max(13) from t1 where case case when f in (select e from t1 union select coalesce((select max(e) from t1 where (select  -max(e) from t1)*t1.e<e and exists(select 1 from t1 where  -c in (a,a,a))),t1.d) from t1) and e>=t1.c and exists(select 1 from t1 where t1.f>=13) then t1.d when d between t1.d and t1.a then 19 else a end | e when (a) then e else a end between b and t1.c and not exists(select 1 from t1 where 13 in (t1.d,t1.a,13)) or t1.a>= -13),c) FROM t1 WHERE NOT (t1.e not in ( -coalesce((select max(13) from t1 where exists(select 1 from t1 where not t1.d>a) and t1.a not in (d*+case when t1.b in (select max(e*11+t1.a)+ -count(*)-( -max(t1.e))-min(11)-count(distinct t1.a) from t1 union select  - -min(t1.b) from t1) then t1.e when e in (select count(distinct t1.a) from t1 union select (max(d)) from t1) then e else  -(19) end+ -t1.d, -17,f)),case c when a then f else 17 end),d,11))"
    end, {
        -- <randexpr-2.357>
        
        -- </randexpr-2.357>
    })

test:do_test(
    "randexpr-2.358",
    function()
        return test:execsql "SELECT  -coalesce((select max(13) from t1 where case case when f in (select e from t1 union select coalesce((select max(e) from t1 where (select  -max(e) from t1)*t1.e<e and exists(select 1 from t1 where  -c in (a,a,a))),t1.d) from t1) and e>=t1.c and exists(select 1 from t1 where t1.f>=13) then t1.d when d between t1.d and t1.a then 19 else a end & e when (a) then e else a end between b and t1.c and not exists(select 1 from t1 where 13 in (t1.d,t1.a,13)) or t1.a>= -13),c) FROM t1 WHERE t1.e not in ( -coalesce((select max(13) from t1 where exists(select 1 from t1 where not t1.d>a) and t1.a not in (d*+case when t1.b in (select max(e*11+t1.a)+ -count(*)-( -max(t1.e))-min(11)-count(distinct t1.a) from t1 union select  - -min(t1.b) from t1) then t1.e when e in (select count(distinct t1.a) from t1 union select (max(d)) from t1) then e else  -(19) end+ -t1.d, -17,f)),case c when a then f else 17 end),d,11)"
    end, {
        -- <randexpr-2.358>
        -13
        -- </randexpr-2.358>
    })

test:do_test(
    "randexpr-2.359",
    function()
        return test:execsql "SELECT case d when  -e+coalesce((select max(case (select +abs((~case case count(distinct b) when  -count(*) then count(*) else max(t1.e) end when max(e) then min(t1.c) else count(*) end-min(c))) from t1) when t1.c then t1.a else  -11 end) from t1 where case ~t1.b when e then d else 11 end in (b,t1.e,t1.b) or not t1.f>=b or (t1.f in (a,e,t1.e)) or f<b),t1.e) then t1.b else f end FROM t1 WHERE b<=(d) and (abs(coalesce((select max(coalesce((select case when (abs(~11)/abs(((abs(17+f+t1.f)/abs(t1.c))-11*c)-d*17)) not in (b,13,((e))) then 19 else 19 end from t1 where a in (select t1.b from t1 union select t1.b from t1)),13)) from t1 where t1.d in (select a from t1 union select 13 from t1)), -e)+17*c)/abs(t1.c))=13"
    end, {
        -- <randexpr-2.359>
        
        -- </randexpr-2.359>
    })

test:do_test(
    "randexpr-2.360",
    function()
        return test:execsql "SELECT case d when  -e+coalesce((select max(case (select +abs((~case case count(distinct b) when  -count(*) then count(*) else max(t1.e) end when max(e) then min(t1.c) else count(*) end-min(c))) from t1) when t1.c then t1.a else  -11 end) from t1 where case ~t1.b when e then d else 11 end in (b,t1.e,t1.b) or not t1.f>=b or (t1.f in (a,e,t1.e)) or f<b),t1.e) then t1.b else f end FROM t1 WHERE NOT (b<=(d) and (abs(coalesce((select max(coalesce((select case when (abs(~11)/abs(((abs(17+f+t1.f)/abs(t1.c))-11*c)-d*17)) not in (b,13,((e))) then 19 else 19 end from t1 where a in (select t1.b from t1 union select t1.b from t1)),13)) from t1 where t1.d in (select a from t1 union select 13 from t1)), -e)+17*c)/abs(t1.c))=13)"
    end, {
        -- <randexpr-2.360>
        600
        -- </randexpr-2.360>
    })

test:do_test(
    "randexpr-2.361",
    function()
        return test:execsql "SELECT case a when ~c then e+17-d else case t1.a when c then t1.b else case when ((case t1.e when c then d-11 else t1.f end not in (e,(17),t1.d))) or not exists(select 1 from t1 where e not in (d,t1.f,11) and  -t1.a>t1.b) or t1.a not in (f,t1.b,t1.e) or t1.d<=t1.b and 19 not in (t1.d,11,t1.f) then t1.d else 19 end+e+17 end |  -t1.c*d end-13 FROM t1 WHERE e not in (e,t1.b,t1.d)"
    end, {
        -- <randexpr-2.361>
        
        -- </randexpr-2.361>
    })

test:do_test(
    "randexpr-2.362",
    function()
        return test:execsql "SELECT case a when ~c then e+17-d else case t1.a when c then t1.b else case when ((case t1.e when c then d-11 else t1.f end not in (e,(17),t1.d))) or not exists(select 1 from t1 where e not in (d,t1.f,11) and  -t1.a>t1.b) or t1.a not in (f,t1.b,t1.e) or t1.d<=t1.b and 19 not in (t1.d,11,t1.f) then t1.d else 19 end+e+17 end |  -t1.c*d end-13 FROM t1 WHERE NOT (e not in (e,t1.b,t1.d))"
    end, {
        -- <randexpr-2.362>
        -119864
        -- </randexpr-2.362>
    })

test:do_test(
    "randexpr-2.363",
    function()
        return test:execsql "SELECT case a when ~c then e+17-d else case t1.a when c then t1.b else case when ((case t1.e when c then d-11 else t1.f end not in (e,(17),t1.d))) or not exists(select 1 from t1 where e not in (d,t1.f,11) and  -t1.a>t1.b) or t1.a not in (f,t1.b,t1.e) or t1.d<=t1.b and 19 not in (t1.d,11,t1.f) then t1.d else 19 end+e+17 end &  -t1.c*d end-13 FROM t1 WHERE NOT (e not in (e,t1.b,t1.d))"
    end, {
        -- <randexpr-2.363>
        755
        -- </randexpr-2.363>
    })

test:do_test(
    "randexpr-2.364",
    function()
        return test:execsql "SELECT coalesce((select max(case t1.a when d then ~11 else t1.e end) from t1 where (t1.f*17<t1.d-(t1.a*t1.a+t1.b+case case d when coalesce((select max(19) from t1 where  -(t1.e) in (select count(distinct c) from t1 union select (count(distinct t1.f)) from t1)),13) then c else 19 end*d when c then 13 else 17 end+t1.c)) and (f>=a or t1.e=t1.a and  -c>=t1.b)),t1.b) FROM t1 WHERE a+( -t1.c) between case when case a when t1.f then ~t1.b*t1.c+17 else  -case when f not in (e,f,17) then a when 11=13 then t1.c else t1.d end end>=t1.b then b when t1.d in (select +max(19) from t1 union select abs(cast(avg(t1.f) AS integer))+case ~count(*)-max(t1.a)+max(11) when (max(a)) then (max(t1.d)) else count(distinct 11) end from t1) and e in (t1.d,17,11) then (11) else b end and a"
    end, {
        -- <randexpr-2.364>
        
        -- </randexpr-2.364>
    })

test:do_test(
    "randexpr-2.365",
    function()
        return test:execsql "SELECT coalesce((select max(case t1.a when d then ~11 else t1.e end) from t1 where (t1.f*17<t1.d-(t1.a*t1.a+t1.b+case case d when coalesce((select max(19) from t1 where  -(t1.e) in (select count(distinct c) from t1 union select (count(distinct t1.f)) from t1)),13) then c else 19 end*d when c then 13 else 17 end+t1.c)) and (f>=a or t1.e=t1.a and  -c>=t1.b)),t1.b) FROM t1 WHERE NOT (a+( -t1.c) between case when case a when t1.f then ~t1.b*t1.c+17 else  -case when f not in (e,f,17) then a when 11=13 then t1.c else t1.d end end>=t1.b then b when t1.d in (select +max(19) from t1 union select abs(cast(avg(t1.f) AS integer))+case ~count(*)-max(t1.a)+max(11) when (max(a)) then (max(t1.d)) else count(distinct 11) end from t1) and e in (t1.d,17,11) then (11) else b end and a)"
    end, {
        -- <randexpr-2.365>
        200
        -- </randexpr-2.365>
    })

test:do_test(
    "randexpr-2.366",
    function()
        return test:execsql "SELECT t1.f+case when c*f | (t1.a) in (select b*f from t1 union select  -case when d not between ~13 | 13+case a when a then e else a end and f then 11 else e-t1.d end from t1) then  -(abs(case when ((case t1.f when t1.b then t1.f else a end*f+t1.c)) in (select d from t1 union select (t1.e) from t1) then d else (t1.f) end)/abs(b)) else t1.a end FROM t1 WHERE ~(f+17-(select +max(t1.f)-case count(distinct d-19) when ~count(distinct (abs(b)/abs(a))) then cast(avg(17) AS integer) else ~count(distinct e)*count(*) end from t1)-f-coalesce((select t1.f from t1 where t1.a>=t1.c or t1.b between  -t1.a and 19 or exists(select 1 from t1 where t1.e not in (13,t1.c,e)) and d>a),t1.d)) not between d and c"
    end, {
        -- <randexpr-2.366>
        700
        -- </randexpr-2.366>
    })

test:do_test(
    "randexpr-2.367",
    function()
        return test:execsql "SELECT t1.f+case when c*f | (t1.a) in (select b*f from t1 union select  -case when d not between ~13 | 13+case a when a then e else a end and f then 11 else e-t1.d end from t1) then  -(abs(case when ((case t1.f when t1.b then t1.f else a end*f+t1.c)) in (select d from t1 union select (t1.e) from t1) then d else (t1.f) end)/abs(b)) else t1.a end FROM t1 WHERE NOT (~(f+17-(select +max(t1.f)-case count(distinct d-19) when ~count(distinct (abs(b)/abs(a))) then cast(avg(17) AS integer) else ~count(distinct e)*count(*) end from t1)-f-coalesce((select t1.f from t1 where t1.a>=t1.c or t1.b between  -t1.a and 19 or exists(select 1 from t1 where t1.e not in (13,t1.c,e)) and d>a),t1.d)) not between d and c)"
    end, {
        -- <randexpr-2.367>
        
        -- </randexpr-2.367>
    })

test:do_test(
    "randexpr-2.368",
    function()
        return test:execsql "SELECT t1.f+case when c*f & (t1.a) in (select b*f from t1 union select  -case when d not between ~13 & 13+case a when a then e else a end and f then 11 else e-t1.d end from t1) then  -(abs(case when ((case t1.f when t1.b then t1.f else a end*f+t1.c)) in (select d from t1 union select (t1.e) from t1) then d else (t1.f) end)/abs(b)) else t1.a end FROM t1 WHERE ~(f+17-(select +max(t1.f)-case count(distinct d-19) when ~count(distinct (abs(b)/abs(a))) then cast(avg(17) AS integer) else ~count(distinct e)*count(*) end from t1)-f-coalesce((select t1.f from t1 where t1.a>=t1.c or t1.b between  -t1.a and 19 or exists(select 1 from t1 where t1.e not in (13,t1.c,e)) and d>a),t1.d)) not between d and c"
    end, {
        -- <randexpr-2.368>
        700
        -- </randexpr-2.368>
    })

test:do_test(
    "randexpr-2.369",
    function()
        return test:execsql "SELECT case when coalesce((select d from t1 where not coalesce((select f*t1.b from t1 where exists(select 1 from t1 where (t1.f*t1.a)-19-13 in (select ~(cast(avg(t1.b) AS integer)) from t1 union select min(t1.a)+case min( -t1.a) when cast(avg(19) AS integer) then cast(avg(19) AS integer) else min(13) end+( -min(a)) from t1))),(t1.f)) between 17 and d),11)=19 then t1.b when 17<11 or exists(select 1 from t1 where d in (select 13 from t1 union select f from t1)) then 11 else t1.c end FROM t1 WHERE case c when 13 then +t1.d else t1.a end in (select abs(case + -count(*)+count(distinct coalesce((select (abs(~case when t1.c=19 | 13 then t1.c when not e>(13) then f else d end)/abs(a)) from t1 where 17>=t1.b),t1.b))+min(t1.a)*count(*) | (((max(a)))-cast(avg((17)) AS integer)) when max(d) then count(*) else cast(avg(t1.e) AS integer) end) from t1 union select count(*) from t1)"
    end, {
        -- <randexpr-2.369>
        
        -- </randexpr-2.369>
    })

test:do_test(
    "randexpr-2.370",
    function()
        return test:execsql "SELECT case when coalesce((select d from t1 where not coalesce((select f*t1.b from t1 where exists(select 1 from t1 where (t1.f*t1.a)-19-13 in (select ~(cast(avg(t1.b) AS integer)) from t1 union select min(t1.a)+case min( -t1.a) when cast(avg(19) AS integer) then cast(avg(19) AS integer) else min(13) end+( -min(a)) from t1))),(t1.f)) between 17 and d),11)=19 then t1.b when 17<11 or exists(select 1 from t1 where d in (select 13 from t1 union select f from t1)) then 11 else t1.c end FROM t1 WHERE NOT (case c when 13 then +t1.d else t1.a end in (select abs(case + -count(*)+count(distinct coalesce((select (abs(~case when t1.c=19 | 13 then t1.c when not e>(13) then f else d end)/abs(a)) from t1 where 17>=t1.b),t1.b))+min(t1.a)*count(*) | (((max(a)))-cast(avg((17)) AS integer)) when max(d) then count(*) else cast(avg(t1.e) AS integer) end) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.370>
        300
        -- </randexpr-2.370>
    })

test:do_test(
    "randexpr-2.371",
    function()
        return test:execsql "SELECT  -(select count(*) from t1)*(select (+(cast(avg(+f) AS integer))+++case +max(t1.b-case when t1.e+t1.e>=11 then  -a else t1.e end)-abs(min(e)+ -max(c) | ((max(11)))) when max(11) then (min(b)) else cast(avg( -b) AS integer) end-cast(avg(b) AS integer)-count(*)+count(*)) from t1)+~17- -t1.a FROM t1 WHERE f between 19*t1.d and 19"
    end, {
        -- <randexpr-2.371>
        
        -- </randexpr-2.371>
    })

test:do_test(
    "randexpr-2.372",
    function()
        return test:execsql "SELECT  -(select count(*) from t1)*(select (+(cast(avg(+f) AS integer))+++case +max(t1.b-case when t1.e+t1.e>=11 then  -a else t1.e end)-abs(min(e)+ -max(c) | ((max(11)))) when max(11) then (min(b)) else cast(avg( -b) AS integer) end-cast(avg(b) AS integer)-count(*)+count(*)) from t1)+~17- -t1.a FROM t1 WHERE NOT (f between 19*t1.d and 19)"
    end, {
        -- <randexpr-2.372>
        -118
        -- </randexpr-2.372>
    })

test:do_test(
    "randexpr-2.373",
    function()
        return test:execsql "SELECT  -(select count(*) from t1)*(select (+(cast(avg(+f) AS integer))+++case +max(t1.b-case when t1.e+t1.e>=11 then  -a else t1.e end)-abs(min(e)+ -max(c) & ((max(11)))) when max(11) then (min(b)) else cast(avg( -b) AS integer) end-cast(avg(b) AS integer)-count(*)+count(*)) from t1)+~17- -t1.a FROM t1 WHERE NOT (f between 19*t1.d and 19)"
    end, {
        -- <randexpr-2.373>
        -118
        -- </randexpr-2.373>
    })

test:do_test(
    "randexpr-2.374",
    function()
        return test:execsql "SELECT case when not t1.a< -~~e then b when c*(select +case max((abs( -a)/abs(a))) when min(t1.b) then case ~min(t1.d)-cast(avg(e) AS integer) | max(e) when count(distinct 11) then count(*) else max(b) end else count(*) end from t1) not between 13 and case when exists(select 1 from t1 where exists(select 1 from t1 where f not in (19,t1.f,19)) and 11 between t1.b and t1.b) then (13) else  -t1.d end then f else e end FROM t1 WHERE d>11"
    end, {
        -- <randexpr-2.374>
        200
        -- </randexpr-2.374>
    })

test:do_test(
    "randexpr-2.375",
    function()
        return test:execsql "SELECT case when not t1.a< -~~e then b when c*(select +case max((abs( -a)/abs(a))) when min(t1.b) then case ~min(t1.d)-cast(avg(e) AS integer) | max(e) when count(distinct 11) then count(*) else max(b) end else count(*) end from t1) not between 13 and case when exists(select 1 from t1 where exists(select 1 from t1 where f not in (19,t1.f,19)) and 11 between t1.b and t1.b) then (13) else  -t1.d end then f else e end FROM t1 WHERE NOT (d>11)"
    end, {
        -- <randexpr-2.375>
        
        -- </randexpr-2.375>
    })

test:do_test(
    "randexpr-2.376",
    function()
        return test:execsql "SELECT case when not t1.a< -~~e then b when c*(select +case max((abs( -a)/abs(a))) when min(t1.b) then case ~min(t1.d)-cast(avg(e) AS integer) & max(e) when count(distinct 11) then count(*) else max(b) end else count(*) end from t1) not between 13 and case when exists(select 1 from t1 where exists(select 1 from t1 where f not in (19,t1.f,19)) and 11 between t1.b and t1.b) then (13) else  -t1.d end then f else e end FROM t1 WHERE d>11"
    end, {
        -- <randexpr-2.376>
        200
        -- </randexpr-2.376>
    })

test:do_test(
    "randexpr-2.377",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c | ~17) from t1 where exists(select 1 from t1 where t1.f<>b-(abs(13)/abs(e)))),13) FROM t1 WHERE case when case (abs(c+a+19+coalesce((select max(t1.a) from t1 where coalesce((select coalesce((select (f) from t1 where t1.d between 19 and b),t1.a) from t1 where 13=(c)),f) in (select ~case count(*) when max(t1.b) then ((count(distinct 11))) else count(*) end- -count(distinct a) from t1 union select count(distinct 13) from t1)),t1.c) | t1.b+t1.d)/abs(e)) when t1.d then a else 17 end not between 19 and t1.f then t1.b else d end in (select t1.c from t1 union select (t1.a) from t1)"
    end, {
        -- <randexpr-2.377>
        
        -- </randexpr-2.377>
    })

test:do_test(
    "randexpr-2.378",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c | ~17) from t1 where exists(select 1 from t1 where t1.f<>b-(abs(13)/abs(e)))),13) FROM t1 WHERE NOT (case when case (abs(c+a+19+coalesce((select max(t1.a) from t1 where coalesce((select coalesce((select (f) from t1 where t1.d between 19 and b),t1.a) from t1 where 13=(c)),f) in (select ~case count(*) when max(t1.b) then ((count(distinct 11))) else count(*) end- -count(distinct a) from t1 union select count(distinct 13) from t1)),t1.c) | t1.b+t1.d)/abs(e)) when t1.d then a else 17 end not between 19 and t1.f then t1.b else d end in (select t1.c from t1 union select (t1.a) from t1))"
    end, {
        -- <randexpr-2.378>
        -18
        -- </randexpr-2.378>
    })

test:do_test(
    "randexpr-2.379",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c & ~17) from t1 where exists(select 1 from t1 where t1.f<>b-(abs(13)/abs(e)))),13) FROM t1 WHERE NOT (case when case (abs(c+a+19+coalesce((select max(t1.a) from t1 where coalesce((select coalesce((select (f) from t1 where t1.d between 19 and b),t1.a) from t1 where 13=(c)),f) in (select ~case count(*) when max(t1.b) then ((count(distinct 11))) else count(*) end- -count(distinct a) from t1 union select count(distinct 13) from t1)),t1.c) | t1.b+t1.d)/abs(e)) when t1.d then a else 17 end not between 19 and t1.f then t1.b else d end in (select t1.c from t1 union select (t1.a) from t1))"
    end, {
        -- <randexpr-2.379>
        300
        -- </randexpr-2.379>
    })

test:do_test(
    "randexpr-2.380",
    function()
        return test:execsql "SELECT (coalesce((select (coalesce((select d from t1 where not exists(select 1 from t1 where 17>t1.c)),d))*c from t1 where t1.b between t1.d | (select count(distinct coalesce((select max(t1.e) from t1 where case when  -e>t1.b then f when t1.a<t1.f then t1.e else t1.d end<=c),(19))) from t1) and b or 13 in (t1.d,t1.d,t1.d)),t1.b)-b*f)+11-t1.e FROM t1 WHERE d<case when d>(abs(19*case when coalesce((select b*case when 11 not between 19 and (abs(13)/abs(t1.b-t1.d-e+b-f+19*t1.a)) then  -t1.a else f end from t1 where (b=17)),f)= -t1.d then 17 when 11<>19 then f else t1.d end)/abs(t1.b)) then d else 19 end"
    end, {
        -- <randexpr-2.380>
        
        -- </randexpr-2.380>
    })

test:do_test(
    "randexpr-2.381",
    function()
        return test:execsql "SELECT (coalesce((select (coalesce((select d from t1 where not exists(select 1 from t1 where 17>t1.c)),d))*c from t1 where t1.b between t1.d | (select count(distinct coalesce((select max(t1.e) from t1 where case when  -e>t1.b then f when t1.a<t1.f then t1.e else t1.d end<=c),(19))) from t1) and b or 13 in (t1.d,t1.d,t1.d)),t1.b)-b*f)+11-t1.e FROM t1 WHERE NOT (d<case when d>(abs(19*case when coalesce((select b*case when 11 not between 19 and (abs(13)/abs(t1.b-t1.d-e+b-f+19*t1.a)) then  -t1.a else f end from t1 where (b=17)),f)= -t1.d then 17 when 11<>19 then f else t1.d end)/abs(t1.b)) then d else 19 end)"
    end, {
        -- <randexpr-2.381>
        -120289
        -- </randexpr-2.381>
    })

test:do_test(
    "randexpr-2.382",
    function()
        return test:execsql "SELECT (coalesce((select (coalesce((select d from t1 where not exists(select 1 from t1 where 17>t1.c)),d))*c from t1 where t1.b between t1.d & (select count(distinct coalesce((select max(t1.e) from t1 where case when  -e>t1.b then f when t1.a<t1.f then t1.e else t1.d end<=c),(19))) from t1) and b or 13 in (t1.d,t1.d,t1.d)),t1.b)-b*f)+11-t1.e FROM t1 WHERE NOT (d<case when d>(abs(19*case when coalesce((select b*case when 11 not between 19 and (abs(13)/abs(t1.b-t1.d-e+b-f+19*t1.a)) then  -t1.a else f end from t1 where (b=17)),f)= -t1.d then 17 when 11<>19 then f else t1.d end)/abs(t1.b)) then d else 19 end)"
    end, {
        -- <randexpr-2.382>
        -489
        -- </randexpr-2.382>
    })

test:do_test(
    "randexpr-2.383",
    function()
        return test:execsql "SELECT 19*case when coalesce((select max(t1.e-c) from t1 where f=(abs(coalesce((select t1.c from t1 where not (not exists(select 1 from t1 where a in (select b from t1 union select c from t1)))),13))/abs(coalesce((select 13 from t1 where t1.b in (d,t1.d,a)), -t1.b)))),c) in (select ~min(t1.c) from t1 union select count(*) from t1) and  -f<>t1.c then t1.a-t1.e when not t1.a in (select cast(avg(a) AS integer) from t1 union select min(13) from t1) then  -19 else f end FROM t1 WHERE 11<>13"
    end, {
        -- <randexpr-2.383>
        11400
        -- </randexpr-2.383>
    })

test:do_test(
    "randexpr-2.384",
    function()
        return test:execsql "SELECT 19*case when coalesce((select max(t1.e-c) from t1 where f=(abs(coalesce((select t1.c from t1 where not (not exists(select 1 from t1 where a in (select b from t1 union select c from t1)))),13))/abs(coalesce((select 13 from t1 where t1.b in (d,t1.d,a)), -t1.b)))),c) in (select ~min(t1.c) from t1 union select count(*) from t1) and  -f<>t1.c then t1.a-t1.e when not t1.a in (select cast(avg(a) AS integer) from t1 union select min(13) from t1) then  -19 else f end FROM t1 WHERE NOT (11<>13)"
    end, {
        -- <randexpr-2.384>
        
        -- </randexpr-2.384>
    })

test:do_test(
    "randexpr-2.385",
    function()
        return test:execsql "SELECT t1.b*(select max(t1.b*coalesce((select max(t1.f*(t1.b)) from t1 where 17 not in (d,(a),(t1.b)+13)),t1.c)-t1.a) | cast(avg(t1.d) AS integer) | ~+case abs(abs(count(distinct t1.b))) when ~count(distinct e)-(count(*)) then max(t1.e) else max(d) end | max((19)) | min(19) from t1)-t1.d-t1.d*17 FROM t1 WHERE t1.f-case t1.d+19+13*case when (abs(e)/abs((select count(*)+cast(avg(a) AS integer)*count(*) from t1)-c*(abs(d)/abs(c*t1.e-19)))) not in (17,17,t1.a) then t1.f when t1.d<>t1.f then b else d end+ - -f*t1.b*d when b then 11 else  -13 end<=(t1.b)"
    end, {
        -- <randexpr-2.385>
        
        -- </randexpr-2.385>
    })

test:do_test(
    "randexpr-2.386",
    function()
        return test:execsql "SELECT t1.b*(select max(t1.b*coalesce((select max(t1.f*(t1.b)) from t1 where 17 not in (d,(a),(t1.b)+13)),t1.c)-t1.a) | cast(avg(t1.d) AS integer) | ~+case abs(abs(count(distinct t1.b))) when ~count(distinct e)-(count(*)) then max(t1.e) else max(d) end | max((19)) | min(19) from t1)-t1.d-t1.d*17 FROM t1 WHERE NOT (t1.f-case t1.d+19+13*case when (abs(e)/abs((select count(*)+cast(avg(a) AS integer)*count(*) from t1)-c*(abs(d)/abs(c*t1.e-19)))) not in (17,17,t1.a) then t1.f when t1.d<>t1.f then b else d end+ - -f*t1.b*d when b then 11 else  -13 end<=(t1.b))"
    end, {
        -- <randexpr-2.386>
        -7400
        -- </randexpr-2.386>
    })

test:do_test(
    "randexpr-2.387",
    function()
        return test:execsql "SELECT t1.b*(select max(t1.b*coalesce((select max(t1.f*(t1.b)) from t1 where 17 not in (d,(a),(t1.b)+13)),t1.c)-t1.a) & cast(avg(t1.d) AS integer) & ~+case abs(abs(count(distinct t1.b))) when ~count(distinct e)-(count(*)) then max(t1.e) else max(d) end & max((19)) & min(19) from t1)-t1.d-t1.d*17 FROM t1 WHERE NOT (t1.f-case t1.d+19+13*case when (abs(e)/abs((select count(*)+cast(avg(a) AS integer)*count(*) from t1)-c*(abs(d)/abs(c*t1.e-19)))) not in (17,17,t1.a) then t1.f when t1.d<>t1.f then b else d end+ - -f*t1.b*d when b then 11 else  -13 end<=(t1.b))"
    end, {
        -- <randexpr-2.387>
        -7200
        -- </randexpr-2.387>
    })

test:do_test(
    "randexpr-2.388",
    function()
        return test:execsql "SELECT (select abs(count(distinct t1.e) | min(b))-cast(avg(c) AS integer) | case +~+max(t1.a)*abs(+~ - -+cast(avg(19*f) AS integer) | count(*) | ~max(b) | ((max(t1.e)))-count(distinct t1.d)+ -(count(distinct t1.c)))* -count(distinct 17) | count(distinct a) when ((count(distinct t1.d))) then  -min(t1.c) else count(distinct t1.c) end- -min(d) from t1) FROM t1 WHERE ((not exists(select 1 from t1 where c=f)) and case when not 19+t1.c- -11+11+e>=a or t1.d>b then f else t1.e end<> -t1.c) or (t1.a in (select +count(*) from t1 union select abs((case max(d) when count(distinct d) then min( -t1.e) else count(distinct a) end-count(distinct  -t1.f)))*count(*) from t1) or not exists(select 1 from t1 where t1.d not in (c,17,e)))"
    end, {
        -- <randexpr-2.388>
        -99
        -- </randexpr-2.388>
    })

test:do_test(
    "randexpr-2.389",
    function()
        return test:execsql "SELECT (select abs(count(distinct t1.e) | min(b))-cast(avg(c) AS integer) | case +~+max(t1.a)*abs(+~ - -+cast(avg(19*f) AS integer) | count(*) | ~max(b) | ((max(t1.e)))-count(distinct t1.d)+ -(count(distinct t1.c)))* -count(distinct 17) | count(distinct a) when ((count(distinct t1.d))) then  -min(t1.c) else count(distinct t1.c) end- -min(d) from t1) FROM t1 WHERE NOT (((not exists(select 1 from t1 where c=f)) and case when not 19+t1.c- -11+11+e>=a or t1.d>b then f else t1.e end<> -t1.c) or (t1.a in (select +count(*) from t1 union select abs((case max(d) when count(distinct d) then min( -t1.e) else count(distinct a) end-count(distinct  -t1.f)))*count(*) from t1) or not exists(select 1 from t1 where t1.d not in (c,17,e))))"
    end, {
        -- <randexpr-2.389>
        
        -- </randexpr-2.389>
    })

test:do_test(
    "randexpr-2.390",
    function()
        return test:execsql "SELECT (select abs(count(distinct t1.e) & min(b))-cast(avg(c) AS integer) & case +~+max(t1.a)*abs(+~ - -+cast(avg(19*f) AS integer) & count(*) & ~max(b) & ((max(t1.e)))-count(distinct t1.d)+ -(count(distinct t1.c)))* -count(distinct 17) & count(distinct a) when ((count(distinct t1.d))) then  -min(t1.c) else count(distinct t1.c) end- -min(d) from t1) FROM t1 WHERE ((not exists(select 1 from t1 where c=f)) and case when not 19+t1.c- -11+11+e>=a or t1.d>b then f else t1.e end<> -t1.c) or (t1.a in (select +count(*) from t1 union select abs((case max(d) when count(distinct d) then min( -t1.e) else count(distinct a) end-count(distinct  -t1.f)))*count(*) from t1) or not exists(select 1 from t1 where t1.d not in (c,17,e)))"
    end, {
        -- <randexpr-2.390>
        144
        -- </randexpr-2.390>
    })

test:do_test(
    "randexpr-2.391",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where coalesce((select b from t1 where case when (b<t1.b) then (select (min(a+17+a-t1.f)) from t1) else t1.a end in (select (17-a)*t1.e+c*c from t1 union select 17 from t1)),t1.f)<e) then case when t1.e in (t1.d, -t1.a,c) then 17 else  -e end when not t1.c in (select t1.e from t1 union select e from t1) then t1.c else t1.b end FROM t1 WHERE coalesce((select max(13) from t1 where e=t1.a),case when f+(d)<=~case when (case when 17*t1.a in (select 13 from t1 union select 19 from t1) then f else 17 end in (select max(t1.a) from t1 union select cast(avg(t1.e) AS integer)+max(a) | count(*) from t1)) or 13 in (b,t1.e,19) then t1.b*b when t1.a> -11 then  -t1.c else  -b end then d else t1.a end) not in (t1.b,d,t1.b)"
    end, {
        -- <randexpr-2.391>
        300
        -- </randexpr-2.391>
    })

test:do_test(
    "randexpr-2.392",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where coalesce((select b from t1 where case when (b<t1.b) then (select (min(a+17+a-t1.f)) from t1) else t1.a end in (select (17-a)*t1.e+c*c from t1 union select 17 from t1)),t1.f)<e) then case when t1.e in (t1.d, -t1.a,c) then 17 else  -e end when not t1.c in (select t1.e from t1 union select e from t1) then t1.c else t1.b end FROM t1 WHERE NOT (coalesce((select max(13) from t1 where e=t1.a),case when f+(d)<=~case when (case when 17*t1.a in (select 13 from t1 union select 19 from t1) then f else 17 end in (select max(t1.a) from t1 union select cast(avg(t1.e) AS integer)+max(a) | count(*) from t1)) or 13 in (b,t1.e,19) then t1.b*b when t1.a> -11 then  -t1.c else  -b end then d else t1.a end) not in (t1.b,d,t1.b))"
    end, {
        -- <randexpr-2.392>
        
        -- </randexpr-2.392>
    })

test:do_test(
    "randexpr-2.393",
    function()
        return test:execsql "SELECT t1.f+coalesce((select t1.a-t1.d*f-coalesce((select max(coalesce((select max(t1.c) from t1 where exists(select 1 from t1 where a=~t1.d+case when (c in (select abs(~( -cast(avg(e) AS integer))) from t1 union select  -min(19) from t1)) and 19<>t1.e or t1.e<11 and c in (t1.b,t1.b,t1.d) or 17 between  -t1.d and t1.d then 11 else d end)),c-f)) from t1 where t1.a<=t1.c),11)-t1.c from t1 where f between t1.a and d),19) FROM t1 WHERE exists(select 1 from t1 where case +t1.d when d then f else t1.e end in (t1.e,17,11) or 13*e-t1.b in (select t1.e from t1 union select 17 from t1)) and 11<=case  -case when not exists(select 1 from t1 where (17 | t1.e in (11,11,11) and b<(19))) then case t1.c+t1.f+c when t1.b then c else 19 end else 17 end when d then t1.b else t1.a end"
    end, {
        -- <randexpr-2.393>
        
        -- </randexpr-2.393>
    })

test:do_test(
    "randexpr-2.394",
    function()
        return test:execsql "SELECT t1.f+coalesce((select t1.a-t1.d*f-coalesce((select max(coalesce((select max(t1.c) from t1 where exists(select 1 from t1 where a=~t1.d+case when (c in (select abs(~( -cast(avg(e) AS integer))) from t1 union select  -min(19) from t1)) and 19<>t1.e or t1.e<11 and c in (t1.b,t1.b,t1.d) or 17 between  -t1.d and t1.d then 11 else d end)),c-f)) from t1 where t1.a<=t1.c),11)-t1.c from t1 where f between t1.a and d),19) FROM t1 WHERE NOT (exists(select 1 from t1 where case +t1.d when d then f else t1.e end in (t1.e,17,11) or 13*e-t1.b in (select t1.e from t1 union select 17 from t1)) and 11<=case  -case when not exists(select 1 from t1 where (17 | t1.e in (11,11,11) and b<(19))) then case t1.c+t1.f+c when t1.b then c else 19 end else 17 end when d then t1.b else t1.a end)"
    end, {
        -- <randexpr-2.394>
        619
        -- </randexpr-2.394>
    })

test:do_test(
    "randexpr-2.395",
    function()
        return test:execsql "SELECT case when (coalesce((select coalesce((select max( -11) from t1 where not case t1.c*case when exists(select 1 from t1 where (t1.d) in (select case count(*) when count(distinct t1.c) then count(*) else count(*) end from t1 union select cast(avg(t1.c) AS integer) from t1)) then +e when f=19 then 17 else t1.e end when t1.a then 19 else c end=e),t1.a)- -d*f-a from t1 where (t1.e)<>13),19)*(a)=19) then (c) when (exists(select 1 from t1 where 17=t1.d)) then 19 else c end FROM t1 WHERE t1.d*c*(select cast(avg(((abs(t1.d*13)/abs(f)))) AS integer) from t1)+t1.d=case when +(coalesce((select t1.a from t1 where case when not exists(select 1 from t1 where not exists(select 1 from t1 where c=t1.e)) then 19 |  -17 else 13 end not in (t1.f,b,t1.b)),t1.f))*t1.a-t1.c-13 in (e,11,t1.c) then t1.a when (d between  -t1.f and f) then t1.d else t1.a end"
    end, {
        -- <randexpr-2.395>
        
        -- </randexpr-2.395>
    })

test:do_test(
    "randexpr-2.396",
    function()
        return test:execsql "SELECT case when (coalesce((select coalesce((select max( -11) from t1 where not case t1.c*case when exists(select 1 from t1 where (t1.d) in (select case count(*) when count(distinct t1.c) then count(*) else count(*) end from t1 union select cast(avg(t1.c) AS integer) from t1)) then +e when f=19 then 17 else t1.e end when t1.a then 19 else c end=e),t1.a)- -d*f-a from t1 where (t1.e)<>13),19)*(a)=19) then (c) when (exists(select 1 from t1 where 17=t1.d)) then 19 else c end FROM t1 WHERE NOT (t1.d*c*(select cast(avg(((abs(t1.d*13)/abs(f)))) AS integer) from t1)+t1.d=case when +(coalesce((select t1.a from t1 where case when not exists(select 1 from t1 where not exists(select 1 from t1 where c=t1.e)) then 19 |  -17 else 13 end not in (t1.f,b,t1.b)),t1.f))*t1.a-t1.c-13 in (e,11,t1.c) then t1.a when (d between  -t1.f and f) then t1.d else t1.a end)"
    end, {
        -- <randexpr-2.396>
        300
        -- </randexpr-2.396>
    })

test:do_test(
    "randexpr-2.397",
    function()
        return test:execsql "SELECT coalesce((select d from t1 where f in (select max(19) from t1 union select ~+max(t1.e) from t1)),b-case  -11 when 13 then t1.a-e else case when not exists(select 1 from t1 where c not in ( -t1.c,(t1.e),19)) and d+t1.b-t1.b in (select t1.a from t1 union select t1.d from t1) then 19+19*(t1.f) when t1.b<=a then 17 else t1.a end end+t1.b)*t1.a FROM t1 WHERE (select +cast(avg(~13+(select count(*) from t1)) AS integer)++min(case when (not d<>a) then coalesce((select t1.b from t1 where t1.f not between e and t1.d),13)+13 when t1.d not between 11 and t1.d then 17 else f end) | count(*) | ~count(distinct t1.e) | cast(avg(e) AS integer)-max(t1.d) from t1) not between coalesce((select case t1.a when a then e else 17 end from t1 where t1.a in (t1.e,11,( -t1.d))), -(b)) and t1.a"
    end, {
        -- <randexpr-2.397>
        
        -- </randexpr-2.397>
    })

test:do_test(
    "randexpr-2.398",
    function()
        return test:execsql "SELECT coalesce((select d from t1 where f in (select max(19) from t1 union select ~+max(t1.e) from t1)),b-case  -11 when 13 then t1.a-e else case when not exists(select 1 from t1 where c not in ( -t1.c,(t1.e),19)) and d+t1.b-t1.b in (select t1.a from t1 union select t1.d from t1) then 19+19*(t1.f) when t1.b<=a then 17 else t1.a end end+t1.b)*t1.a FROM t1 WHERE NOT ((select +cast(avg(~13+(select count(*) from t1)) AS integer)++min(case when (not d<>a) then coalesce((select t1.b from t1 where t1.f not between e and t1.d),13)+13 when t1.d not between 11 and t1.d then 17 else f end) | count(*) | ~count(distinct t1.e) | cast(avg(e) AS integer)-max(t1.d) from t1) not between coalesce((select case t1.a when a then e else 17 end from t1 where t1.a in (t1.e,11,( -t1.d))), -(b)) and t1.a)"
    end, {
        -- <randexpr-2.398>
        30000
        -- </randexpr-2.398>
    })

test:do_test(
    "randexpr-2.399",
    function()
        return test:execsql "SELECT (abs(c)/abs((coalesce((select t1.d from t1 where ((19) in (select count(distinct  - -(abs(coalesce((select max(t1.e) from t1 where t1.c*t1.a | t1.d=t1.d or t1.f in (select min(t1.f)-cast(avg(e) AS integer) from t1 union select  -count(*) from t1)),c))/abs(a))) from t1 union select case cast(avg(c) AS integer)-abs( -((count(*))))*(count(*))*min(d) when cast(avg(a) AS integer) then count(distinct 11) else count(*) end-(count(distinct 17)) from t1))),a))))*t1.e FROM t1 WHERE case when a between  -t1.a+(t1.c) and c-case when (~+t1.b-~case when t1.a not between 19*11 and 11 then t1.a when 11=f and  -t1.d not between t1.a and d then e else b end in (select min(19) from t1 union select case count(distinct 17) when count(*) then count(distinct t1.f) else min(c) end from t1)) then t1.f else 17 end then 17 else 13 end in (t1.a,t1.d,a)"
    end, {
        -- <randexpr-2.399>
        
        -- </randexpr-2.399>
    })

test:do_test(
    "randexpr-2.400",
    function()
        return test:execsql "SELECT (abs(c)/abs((coalesce((select t1.d from t1 where ((19) in (select count(distinct  - -(abs(coalesce((select max(t1.e) from t1 where t1.c*t1.a | t1.d=t1.d or t1.f in (select min(t1.f)-cast(avg(e) AS integer) from t1 union select  -count(*) from t1)),c))/abs(a))) from t1 union select case cast(avg(c) AS integer)-abs( -((count(*))))*(count(*))*min(d) when cast(avg(a) AS integer) then count(distinct 11) else count(*) end-(count(distinct 17)) from t1))),a))))*t1.e FROM t1 WHERE NOT (case when a between  -t1.a+(t1.c) and c-case when (~+t1.b-~case when t1.a not between 19*11 and 11 then t1.a when 11=f and  -t1.d not between t1.a and d then e else b end in (select min(19) from t1 union select case count(distinct 17) when count(*) then count(distinct t1.f) else min(c) end from t1)) then t1.f else 17 end then 17 else 13 end in (t1.a,t1.d,a))"
    end, {
        -- <randexpr-2.400>
        1500
        -- </randexpr-2.400>
    })

test:do_test(
    "randexpr-2.401",
    function()
        return test:execsql "SELECT (abs(c)/abs((coalesce((select t1.d from t1 where ((19) in (select count(distinct  - -(abs(coalesce((select max(t1.e) from t1 where t1.c*t1.a & t1.d=t1.d or t1.f in (select min(t1.f)-cast(avg(e) AS integer) from t1 union select  -count(*) from t1)),c))/abs(a))) from t1 union select case cast(avg(c) AS integer)-abs( -((count(*))))*(count(*))*min(d) when cast(avg(a) AS integer) then count(distinct 11) else count(*) end-(count(distinct 17)) from t1))),a))))*t1.e FROM t1 WHERE NOT (case when a between  -t1.a+(t1.c) and c-case when (~+t1.b-~case when t1.a not between 19*11 and 11 then t1.a when 11=f and  -t1.d not between t1.a and d then e else b end in (select min(19) from t1 union select case count(distinct 17) when count(*) then count(distinct t1.f) else min(c) end from t1)) then t1.f else 17 end then 17 else 13 end in (t1.a,t1.d,a))"
    end, {
        -- <randexpr-2.401>
        1500
        -- </randexpr-2.401>
    })

test:do_test(
    "randexpr-2.402",
    function()
        return test:execsql "SELECT case when d=c-(select (~max(t1.f*t1.c-11)) from t1) then coalesce((select max(19) from t1 where 13<coalesce((select case when (select count(distinct t1.f+13) from t1)>d then t1.e when not not exists(select 1 from t1 where t1.c not in (a,a,t1.d) and d not between b and 19) then t1.a else 11 end*f-f from t1 where t1.f between e and e and d between 19 and t1.e or 11<>t1.a),t1.c)),d) else 17 end FROM t1 WHERE (t1.e=11)"
    end, {
        -- <randexpr-2.402>
        
        -- </randexpr-2.402>
    })

test:do_test(
    "randexpr-2.403",
    function()
        return test:execsql "SELECT case when d=c-(select (~max(t1.f*t1.c-11)) from t1) then coalesce((select max(19) from t1 where 13<coalesce((select case when (select count(distinct t1.f+13) from t1)>d then t1.e when not not exists(select 1 from t1 where t1.c not in (a,a,t1.d) and d not between b and 19) then t1.a else 11 end*f-f from t1 where t1.f between e and e and d between 19 and t1.e or 11<>t1.a),t1.c)),d) else 17 end FROM t1 WHERE NOT ((t1.e=11))"
    end, {
        -- <randexpr-2.403>
        17
        -- </randexpr-2.403>
    })

test:do_test(
    "randexpr-2.404",
    function()
        return test:execsql "SELECT case when t1.a-t1.a | case when (abs(t1.d)/abs(t1.c | t1.a))<>t1.e then e*+t1.c-t1.d*coalesce((select t1.b from t1 where b>=+d+ -e*11),11)+t1.b | t1.f when not exists(select 1 from t1 where d not in (17,e,d)) then 11 else t1.d end>=13 then 11 when d=c then a else f end FROM t1 WHERE (abs(case when not t1.d<=t1.f and not t1.d not between  -f and  -17-11*t1.d and (13<t1.b) and 17 in (select min(c)-+min(13)-min(t1.b) from t1 union select  -max((( -11))) from t1) then 13 when c<>d then t1.d*coalesce((select max(t1.a) from t1 where (17) not between (t1.b) and 11),d) else t1.d end)/abs(f)) not between 13 and 19"
    end, {
        -- <randexpr-2.404>
        11
        -- </randexpr-2.404>
    })

test:do_test(
    "randexpr-2.405",
    function()
        return test:execsql "SELECT case when t1.a-t1.a | case when (abs(t1.d)/abs(t1.c | t1.a))<>t1.e then e*+t1.c-t1.d*coalesce((select t1.b from t1 where b>=+d+ -e*11),11)+t1.b | t1.f when not exists(select 1 from t1 where d not in (17,e,d)) then 11 else t1.d end>=13 then 11 when d=c then a else f end FROM t1 WHERE NOT ((abs(case when not t1.d<=t1.f and not t1.d not between  -f and  -17-11*t1.d and (13<t1.b) and 17 in (select min(c)-+min(13)-min(t1.b) from t1 union select  -max((( -11))) from t1) then 13 when c<>d then t1.d*coalesce((select max(t1.a) from t1 where (17) not between (t1.b) and 11),d) else t1.d end)/abs(f)) not between 13 and 19)"
    end, {
        -- <randexpr-2.405>
        
        -- </randexpr-2.405>
    })

test:do_test(
    "randexpr-2.406",
    function()
        return test:execsql "SELECT case when t1.a-t1.a & case when (abs(t1.d)/abs(t1.c & t1.a))<>t1.e then e*+t1.c-t1.d*coalesce((select t1.b from t1 where b>=+d+ -e*11),11)+t1.b & t1.f when not exists(select 1 from t1 where d not in (17,e,d)) then 11 else t1.d end>=13 then 11 when d=c then a else f end FROM t1 WHERE (abs(case when not t1.d<=t1.f and not t1.d not between  -f and  -17-11*t1.d and (13<t1.b) and 17 in (select min(c)-+min(13)-min(t1.b) from t1 union select  -max((( -11))) from t1) then 13 when c<>d then t1.d*coalesce((select max(t1.a) from t1 where (17) not between (t1.b) and 11),d) else t1.d end)/abs(f)) not between 13 and 19"
    end, {
        -- <randexpr-2.406>
        600
        -- </randexpr-2.406>
    })

test:do_test(
    "randexpr-2.407",
    function()
        return test:execsql "SELECT coalesce((select t1.f*13 from t1 where exists(select 1 from t1 where 13<=t1.e)),(abs(+ -17)/abs(c))) FROM t1 WHERE coalesce((select 17 from t1 where 11>++a-~t1.a+d | (19)),(abs(t1.c)/abs(case when case t1.c*17-case when b not between t1.b and f then t1.a when f>=a then 19 else 13 end when 19 then 13 else t1.f end not between c and a then c else 13 end)))> -e or 13 between f and c and t1.e>=b"
    end, {
        -- <randexpr-2.407>
        7800
        -- </randexpr-2.407>
    })

test:do_test(
    "randexpr-2.408",
    function()
        return test:execsql "SELECT coalesce((select t1.f*13 from t1 where exists(select 1 from t1 where 13<=t1.e)),(abs(+ -17)/abs(c))) FROM t1 WHERE NOT (coalesce((select 17 from t1 where 11>++a-~t1.a+d | (19)),(abs(t1.c)/abs(case when case t1.c*17-case when b not between t1.b and f then t1.a when f>=a then 19 else 13 end when 19 then 13 else t1.f end not between c and a then c else 13 end)))> -e or 13 between f and c and t1.e>=b)"
    end, {
        -- <randexpr-2.408>
        
        -- </randexpr-2.408>
    })

test:do_test(
    "randexpr-2.409",
    function()
        return test:execsql "SELECT ~+coalesce((select (select count(distinct +coalesce((select c from t1 where e>=13),+c)-t1.c) from t1) from t1 where case a when t1.d*(select cast(avg(case when t1.b*coalesce((select 17 from t1 where case  -a when t1.b then d else (t1.f) end not in ((t1.e),a,t1.f)),t1.c)-c in (d,a,t1.c) then c else b end) AS integer) from t1)+t1.d then 13 else t1.e end not in (19,a,17)),13) FROM t1 WHERE +c in (a,17,t1.d)"
    end, {
        -- <randexpr-2.409>
        
        -- </randexpr-2.409>
    })

test:do_test(
    "randexpr-2.410",
    function()
        return test:execsql "SELECT ~+coalesce((select (select count(distinct +coalesce((select c from t1 where e>=13),+c)-t1.c) from t1) from t1 where case a when t1.d*(select cast(avg(case when t1.b*coalesce((select 17 from t1 where case  -a when t1.b then d else (t1.f) end not in ((t1.e),a,t1.f)),t1.c)-c in (d,a,t1.c) then c else b end) AS integer) from t1)+t1.d then 13 else t1.e end not in (19,a,17)),13) FROM t1 WHERE NOT (+c in (a,17,t1.d))"
    end, {
        -- <randexpr-2.410>
        -2
        -- </randexpr-2.410>
    })

test:do_test(
    "randexpr-2.411",
    function()
        return test:execsql "SELECT f-coalesce((select t1.d from t1 where t1.a>11+t1.d),coalesce((select coalesce((select t1.d from t1 where 17>=d or (case c when t1.c then (t1.c) else t1.e end in (b,17,17) or t1.b>=t1.a) or t1.b<=e),case d when (19) then t1.d else t1.a end)-t1.d from t1 where 13 in (select ( -count(distinct (e)) | cast(avg(t1.d) AS integer)*count(*))+max( -11) | max( -c) from t1 union select count(distinct 11) from t1)),a)) FROM t1 WHERE not b<=13 or (coalesce((select max(t1.b) from t1 where b in (case when not a<>13 then 17 when  -(select ~abs( -(max(f))+count(distinct t1.a)) from t1)+13>=t1.b then case c when t1.a then d else f end-c else t1.d end-19, -t1.d,f)),19)) not in (t1.a,c,t1.d) or t1.e>t1.f"
    end, {
        -- <randexpr-2.411>
        500
        -- </randexpr-2.411>
    })

test:do_test(
    "randexpr-2.412",
    function()
        return test:execsql "SELECT f-coalesce((select t1.d from t1 where t1.a>11+t1.d),coalesce((select coalesce((select t1.d from t1 where 17>=d or (case c when t1.c then (t1.c) else t1.e end in (b,17,17) or t1.b>=t1.a) or t1.b<=e),case d when (19) then t1.d else t1.a end)-t1.d from t1 where 13 in (select ( -count(distinct (e)) | cast(avg(t1.d) AS integer)*count(*))+max( -11) | max( -c) from t1 union select count(distinct 11) from t1)),a)) FROM t1 WHERE NOT (not b<=13 or (coalesce((select max(t1.b) from t1 where b in (case when not a<>13 then 17 when  -(select ~abs( -(max(f))+count(distinct t1.a)) from t1)+13>=t1.b then case c when t1.a then d else f end-c else t1.d end-19, -t1.d,f)),19)) not in (t1.a,c,t1.d) or t1.e>t1.f)"
    end, {
        -- <randexpr-2.412>
        
        -- </randexpr-2.412>
    })

test:do_test(
    "randexpr-2.413",
    function()
        return test:execsql "SELECT f-coalesce((select t1.d from t1 where t1.a>11+t1.d),coalesce((select coalesce((select t1.d from t1 where 17>=d or (case c when t1.c then (t1.c) else t1.e end in (b,17,17) or t1.b>=t1.a) or t1.b<=e),case d when (19) then t1.d else t1.a end)-t1.d from t1 where 13 in (select ( -count(distinct (e)) & cast(avg(t1.d) AS integer)*count(*))+max( -11) & max( -c) from t1 union select count(distinct 11) from t1)),a)) FROM t1 WHERE not b<=13 or (coalesce((select max(t1.b) from t1 where b in (case when not a<>13 then 17 when  -(select ~abs( -(max(f))+count(distinct t1.a)) from t1)+13>=t1.b then case c when t1.a then d else f end-c else t1.d end-19, -t1.d,f)),19)) not in (t1.a,c,t1.d) or t1.e>t1.f"
    end, {
        -- <randexpr-2.413>
        500
        -- </randexpr-2.413>
    })

test:do_test(
    "randexpr-2.414",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where (coalesce((select max(+e+e*11*t1.c-e) from t1 where exists(select 1 from t1 where (19<=~t1.f))),case (abs(t1.c)/abs(case t1.c when 19 then f*~case when t1.e+t1.d between  -t1.f and (d) then b when (d=a) then t1.e else e end else c end*t1.a)) | f when (d) then 17 else t1.f end)<t1.c)),13) FROM t1 WHERE a>coalesce((select coalesce((select e from t1 where case when  -d+t1.e>e then coalesce((select d+b from t1 where exists(select 1 from t1 where not 13-b not in (f,a,d)) and (t1.b between (a) and t1.c)),c) when a=13 then t1.e else a end in (select t1.d from t1 union select t1.d from t1) and e not in (d, -19,11)),d) from t1 where not f in (t1.a,19,t1.d)),t1.d)"
    end, {
        -- <randexpr-2.414>
        
        -- </randexpr-2.414>
    })

test:do_test(
    "randexpr-2.415",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where (coalesce((select max(+e+e*11*t1.c-e) from t1 where exists(select 1 from t1 where (19<=~t1.f))),case (abs(t1.c)/abs(case t1.c when 19 then f*~case when t1.e+t1.d between  -t1.f and (d) then b when (d=a) then t1.e else e end else c end*t1.a)) | f when (d) then 17 else t1.f end)<t1.c)),13) FROM t1 WHERE NOT (a>coalesce((select coalesce((select e from t1 where case when  -d+t1.e>e then coalesce((select d+b from t1 where exists(select 1 from t1 where not 13-b not in (f,a,d)) and (t1.b between (a) and t1.c)),c) when a=13 then t1.e else a end in (select t1.d from t1 union select t1.d from t1) and e not in (d, -19,11)),d) from t1 where not f in (t1.a,19,t1.d)),t1.d))"
    end, {
        -- <randexpr-2.415>
        13
        -- </randexpr-2.415>
    })

test:do_test(
    "randexpr-2.416",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where (coalesce((select max(+e+e*11*t1.c-e) from t1 where exists(select 1 from t1 where (19<=~t1.f))),case (abs(t1.c)/abs(case t1.c when 19 then f*~case when t1.e+t1.d between  -t1.f and (d) then b when (d=a) then t1.e else e end else c end*t1.a)) & f when (d) then 17 else t1.f end)<t1.c)),13) FROM t1 WHERE NOT (a>coalesce((select coalesce((select e from t1 where case when  -d+t1.e>e then coalesce((select d+b from t1 where exists(select 1 from t1 where not 13-b not in (f,a,d)) and (t1.b between (a) and t1.c)),c) when a=13 then t1.e else a end in (select t1.d from t1 union select t1.d from t1) and e not in (d, -19,11)),d) from t1 where not f in (t1.a,19,t1.d)),t1.d))"
    end, {
        -- <randexpr-2.416>
        13
        -- </randexpr-2.416>
    })

test:do_test(
    "randexpr-2.417",
    function()
        return test:execsql "SELECT (select count(distinct 11-17-11) from t1)-coalesce((select (abs(13)/abs(t1.b-c*11+coalesce((select max(f) from t1 where t1.a>t1.a),(e))*case when (abs(e)/abs(t1.b)) not between ~f and t1.e then c else (abs(t1.b)/abs(t1.d)) end | 13+b | b+t1.e)) from t1 where t1.c in (select t1.c from t1 union select (a) from t1)),19) FROM t1 WHERE t1.f>=19"
    end, {
        -- <randexpr-2.417>
        1
        -- </randexpr-2.417>
    })

test:do_test(
    "randexpr-2.418",
    function()
        return test:execsql "SELECT (select count(distinct 11-17-11) from t1)-coalesce((select (abs(13)/abs(t1.b-c*11+coalesce((select max(f) from t1 where t1.a>t1.a),(e))*case when (abs(e)/abs(t1.b)) not between ~f and t1.e then c else (abs(t1.b)/abs(t1.d)) end | 13+b | b+t1.e)) from t1 where t1.c in (select t1.c from t1 union select (a) from t1)),19) FROM t1 WHERE NOT (t1.f>=19)"
    end, {
        -- <randexpr-2.418>
        
        -- </randexpr-2.418>
    })

test:do_test(
    "randexpr-2.419",
    function()
        return test:execsql "SELECT (select count(distinct 11-17-11) from t1)-coalesce((select (abs(13)/abs(t1.b-c*11+coalesce((select max(f) from t1 where t1.a>t1.a),(e))*case when (abs(e)/abs(t1.b)) not between ~f and t1.e then c else (abs(t1.b)/abs(t1.d)) end & 13+b & b+t1.e)) from t1 where t1.c in (select t1.c from t1 union select (a) from t1)),19) FROM t1 WHERE t1.f>=19"
    end, {
        -- <randexpr-2.419>
        1
        -- </randexpr-2.419>
    })

test:do_test(
    "randexpr-2.420",
    function()
        return test:execsql "SELECT coalesce((select max(case when 11+(select +abs(count(*)) from t1) not in (case when (case when not exists(select 1 from t1 where t1.d=f) then a else a end+11 in (select ((13)) from t1 union select t1.d from t1)) then (abs(t1.c)/abs(t1.b)) when a>=t1.c then b else f end,t1.a,c) then t1.a when b in (select cast(avg(t1.a) AS integer) | ~ -count(distinct 17) from t1 union select min(c) from t1) then b else  -t1.e end) from t1 where d not between c and  -t1.b and b=d and b between 13 and t1.c),(17)) FROM t1 WHERE t1.a in (coalesce((select max(e) from t1 where case case (select count(*) from t1)-~19 when t1.f*t1.d+coalesce((select max((select + -(((min(t1.b)))) |  -(count(distinct t1.c)) | count(*) from t1)*11) from t1 where f>=case when d in ((d),t1.d,13) then 19 when 17=17 then 11 else a end),t1.e) then c else t1.f end when t1.e then f else t1.d end in (13,(13),c)),t1.d),t1.e,a)"
    end, {
        -- <randexpr-2.420>
        17
        -- </randexpr-2.420>
    })

test:do_test(
    "randexpr-2.421",
    function()
        return test:execsql "SELECT coalesce((select max(case when 11+(select +abs(count(*)) from t1) not in (case when (case when not exists(select 1 from t1 where t1.d=f) then a else a end+11 in (select ((13)) from t1 union select t1.d from t1)) then (abs(t1.c)/abs(t1.b)) when a>=t1.c then b else f end,t1.a,c) then t1.a when b in (select cast(avg(t1.a) AS integer) | ~ -count(distinct 17) from t1 union select min(c) from t1) then b else  -t1.e end) from t1 where d not between c and  -t1.b and b=d and b between 13 and t1.c),(17)) FROM t1 WHERE NOT (t1.a in (coalesce((select max(e) from t1 where case case (select count(*) from t1)-~19 when t1.f*t1.d+coalesce((select max((select + -(((min(t1.b)))) |  -(count(distinct t1.c)) | count(*) from t1)*11) from t1 where f>=case when d in ((d),t1.d,13) then 19 when 17=17 then 11 else a end),t1.e) then c else t1.f end when t1.e then f else t1.d end in (13,(13),c)),t1.d),t1.e,a))"
    end, {
        -- <randexpr-2.421>
        
        -- </randexpr-2.421>
    })

test:do_test(
    "randexpr-2.422",
    function()
        return test:execsql "SELECT coalesce((select max(case when 11+(select +abs(count(*)) from t1) not in (case when (case when not exists(select 1 from t1 where t1.d=f) then a else a end+11 in (select ((13)) from t1 union select t1.d from t1)) then (abs(t1.c)/abs(t1.b)) when a>=t1.c then b else f end,t1.a,c) then t1.a when b in (select cast(avg(t1.a) AS integer) & ~ -count(distinct 17) from t1 union select min(c) from t1) then b else  -t1.e end) from t1 where d not between c and  -t1.b and b=d and b between 13 and t1.c),(17)) FROM t1 WHERE t1.a in (coalesce((select max(e) from t1 where case case (select count(*) from t1)-~19 when t1.f*t1.d+coalesce((select max((select + -(((min(t1.b)))) |  -(count(distinct t1.c)) | count(*) from t1)*11) from t1 where f>=case when d in ((d),t1.d,13) then 19 when 17=17 then 11 else a end),t1.e) then c else t1.f end when t1.e then f else t1.d end in (13,(13),c)),t1.d),t1.e,a)"
    end, {
        -- <randexpr-2.422>
        17
        -- </randexpr-2.422>
    })

test:do_test(
    "randexpr-2.423",
    function()
        return test:execsql "SELECT coalesce((select t1.a-case t1.a when c then coalesce((select case (abs(11-(abs(t1.b)/abs(t1.a)))/abs((abs(t1.c)/abs(t1.a))))-t1.f when t1.d then f else 19 end from t1 where +t1.b*a in (select t1.e from t1 union select c from t1) and e between d and 11),t1.b) else a end from t1 where exists(select 1 from t1 where ((a in (13,c,d)))) and  -t1.e in ((t1.d),t1.a,t1.b)),t1.c) FROM t1 WHERE ++e*19 in (case when case when not (d<>case when  -case when (t1.a not between b and  -e) then 17 when f<>a then  -t1.d else t1.a end not in (a,a,c) then b when b<=c then e else b end) then 19 when (t1.b not in ( -13,t1.a,a)) then t1.b | 13 else e end* -19*t1.a<t1.f then t1.c when t1.f=t1.f then t1.a else t1.b end+d,a,11)"
    end, {
        -- <randexpr-2.423>
        
        -- </randexpr-2.423>
    })

test:do_test(
    "randexpr-2.424",
    function()
        return test:execsql "SELECT coalesce((select t1.a-case t1.a when c then coalesce((select case (abs(11-(abs(t1.b)/abs(t1.a)))/abs((abs(t1.c)/abs(t1.a))))-t1.f when t1.d then f else 19 end from t1 where +t1.b*a in (select t1.e from t1 union select c from t1) and e between d and 11),t1.b) else a end from t1 where exists(select 1 from t1 where ((a in (13,c,d)))) and  -t1.e in ((t1.d),t1.a,t1.b)),t1.c) FROM t1 WHERE NOT (++e*19 in (case when case when not (d<>case when  -case when (t1.a not between b and  -e) then 17 when f<>a then  -t1.d else t1.a end not in (a,a,c) then b when b<=c then e else b end) then 19 when (t1.b not in ( -13,t1.a,a)) then t1.b | 13 else e end* -19*t1.a<t1.f then t1.c when t1.f=t1.f then t1.a else t1.b end+d,a,11))"
    end, {
        -- <randexpr-2.424>
        300
        -- </randexpr-2.424>
    })

test:do_test(
    "randexpr-2.425",
    function()
        return test:execsql "SELECT (abs(e-((coalesce((select max(t1.c) from t1 where t1.f-a-case coalesce((select max(d) from t1 where (13<>~19)),f) when a- -t1.a | t1.f then t1.a*11-t1.e else coalesce((select max(t1.b) from t1 where not exists(select 1 from t1 where 17=t1.a or b>=f)),c) | t1.b end>19),t1.a))+c)-t1.c*e)/abs(t1.d)) FROM t1 WHERE a-t1.b not in (a,a-19-c | t1.d-d | e*t1.c*b,t1.e+t1.a)"
    end, {
        -- <randexpr-2.425>
        375
        -- </randexpr-2.425>
    })

test:do_test(
    "randexpr-2.426",
    function()
        return test:execsql "SELECT (abs(e-((coalesce((select max(t1.c) from t1 where t1.f-a-case coalesce((select max(d) from t1 where (13<>~19)),f) when a- -t1.a | t1.f then t1.a*11-t1.e else coalesce((select max(t1.b) from t1 where not exists(select 1 from t1 where 17=t1.a or b>=f)),c) | t1.b end>19),t1.a))+c)-t1.c*e)/abs(t1.d)) FROM t1 WHERE NOT (a-t1.b not in (a,a-19-c | t1.d-d | e*t1.c*b,t1.e+t1.a))"
    end, {
        -- <randexpr-2.426>
        
        -- </randexpr-2.426>
    })

test:do_test(
    "randexpr-2.427",
    function()
        return test:execsql "SELECT (abs(e-((coalesce((select max(t1.c) from t1 where t1.f-a-case coalesce((select max(d) from t1 where (13<>~19)),f) when a- -t1.a & t1.f then t1.a*11-t1.e else coalesce((select max(t1.b) from t1 where not exists(select 1 from t1 where 17=t1.a or b>=f)),c) & t1.b end>19),t1.a))+c)-t1.c*e)/abs(t1.d)) FROM t1 WHERE a-t1.b not in (a,a-19-c | t1.d-d | e*t1.c*b,t1.e+t1.a)"
    end, {
        -- <randexpr-2.427>
        375
        -- </randexpr-2.427>
    })

test:do_test(
    "randexpr-2.428",
    function()
        return test:execsql "SELECT t1.b-coalesce((select t1.a from t1 where (d<=f)),~~case b when coalesce((select coalesce((select t1.c from t1 where a+~+~(abs(t1.d)/abs(17)) |  -d*a*(b++ -13)*b>=b),17) | a from t1 where a<a),17)-13 then 11 else t1.a end) FROM t1 WHERE  -coalesce((select (abs(t1.d)/abs(~t1.e))-a from t1 where (c>=coalesce((select t1.d+(select case min(a) | max(t1.b) when max(e) then count(*) else  -count(distinct f) end from t1)-t1.f+( - - -19) from t1 where t1.c in (select 19 from t1 union select 17 from t1)),11))),19)+11 not in ((b),e,e) or t1.e in (select min(t1.f) from t1 union select count(*)- -(cast(avg(17) AS integer)) from t1) or e>=t1.c"
    end, {
        -- <randexpr-2.428>
        100
        -- </randexpr-2.428>
    })

test:do_test(
    "randexpr-2.429",
    function()
        return test:execsql "SELECT t1.b-coalesce((select t1.a from t1 where (d<=f)),~~case b when coalesce((select coalesce((select t1.c from t1 where a+~+~(abs(t1.d)/abs(17)) |  -d*a*(b++ -13)*b>=b),17) | a from t1 where a<a),17)-13 then 11 else t1.a end) FROM t1 WHERE NOT ( -coalesce((select (abs(t1.d)/abs(~t1.e))-a from t1 where (c>=coalesce((select t1.d+(select case min(a) | max(t1.b) when max(e) then count(*) else  -count(distinct f) end from t1)-t1.f+( - - -19) from t1 where t1.c in (select 19 from t1 union select 17 from t1)),11))),19)+11 not in ((b),e,e) or t1.e in (select min(t1.f) from t1 union select count(*)- -(cast(avg(17) AS integer)) from t1) or e>=t1.c)"
    end, {
        -- <randexpr-2.429>
        
        -- </randexpr-2.429>
    })

test:do_test(
    "randexpr-2.430",
    function()
        return test:execsql "SELECT t1.b-coalesce((select t1.a from t1 where (d<=f)),~~case b when coalesce((select coalesce((select t1.c from t1 where a+~+~(abs(t1.d)/abs(17)) &  -d*a*(b++ -13)*b>=b),17) & a from t1 where a<a),17)-13 then 11 else t1.a end) FROM t1 WHERE  -coalesce((select (abs(t1.d)/abs(~t1.e))-a from t1 where (c>=coalesce((select t1.d+(select case min(a) | max(t1.b) when max(e) then count(*) else  -count(distinct f) end from t1)-t1.f+( - - -19) from t1 where t1.c in (select 19 from t1 union select 17 from t1)),11))),19)+11 not in ((b),e,e) or t1.e in (select min(t1.f) from t1 union select count(*)- -(cast(avg(17) AS integer)) from t1) or e>=t1.c"
    end, {
        -- <randexpr-2.430>
        100
        -- </randexpr-2.430>
    })

test:do_test(
    "randexpr-2.431",
    function()
        return test:execsql "SELECT coalesce((select max(case when e<=t1.d then f*+case 17 when 17 then (abs((select abs(cast(avg(13) AS integer)+min(t1.b)) from t1))/abs(t1.c)) else d end*t1.c else a end) from t1 where coalesce((select t1.c from t1 where a<>t1.e+f-t1.c-a),+t1.a)+t1.d*case when d in (select t1.c from t1 union select 11 from t1) then a when 19 not in (d,e,b) then 11 else 19 end | t1.b in (select 19 from t1 union select t1.a from t1)),17)*11 FROM t1 WHERE 17>=t1.b"
    end, {
        -- <randexpr-2.431>
        
        -- </randexpr-2.431>
    })

test:do_test(
    "randexpr-2.432",
    function()
        return test:execsql "SELECT coalesce((select max(case when e<=t1.d then f*+case 17 when 17 then (abs((select abs(cast(avg(13) AS integer)+min(t1.b)) from t1))/abs(t1.c)) else d end*t1.c else a end) from t1 where coalesce((select t1.c from t1 where a<>t1.e+f-t1.c-a),+t1.a)+t1.d*case when d in (select t1.c from t1 union select 11 from t1) then a when 19 not in (d,e,b) then 11 else 19 end | t1.b in (select 19 from t1 union select t1.a from t1)),17)*11 FROM t1 WHERE NOT (17>=t1.b)"
    end, {
        -- <randexpr-2.432>
        187
        -- </randexpr-2.432>
    })

test:do_test(
    "randexpr-2.433",
    function()
        return test:execsql "SELECT coalesce((select max(case when e<=t1.d then f*+case 17 when 17 then (abs((select abs(cast(avg(13) AS integer)+min(t1.b)) from t1))/abs(t1.c)) else d end*t1.c else a end) from t1 where coalesce((select t1.c from t1 where a<>t1.e+f-t1.c-a),+t1.a)+t1.d*case when d in (select t1.c from t1 union select 11 from t1) then a when 19 not in (d,e,b) then 11 else 19 end & t1.b in (select 19 from t1 union select t1.a from t1)),17)*11 FROM t1 WHERE NOT (17>=t1.b)"
    end, {
        -- <randexpr-2.433>
        187
        -- </randexpr-2.433>
    })

test:do_test(
    "randexpr-2.434",
    function()
        return test:execsql "SELECT case when coalesce((select max(case f when (abs(t1.d)/abs(case when +~e not in (t1.d,c,t1.a) or 17 in (select count(distinct  -b) from t1 union select count(distinct d) from t1) and d<=t1.b or b>(f) then coalesce((select c from t1 where t1.f<t1.e),e)+(d) when 17<19 then t1.c else t1.b end)) then t1.b else f end) from t1 where (17 not between 11 and t1.b) or t1.f>f or t1.b<> -t1.c), -t1.d)<11 then c else f end FROM t1 WHERE not exists(select 1 from t1 where exists(select 1 from t1 where case  -case when case t1.c-t1.b-e when t1.b then t1.e else  -t1.c+~17 | coalesce((select max(t1.c) from t1 where 19 not between  -(a)-t1.c and 17),t1.c) end in (select (t1.f) from t1 union select b from t1) then e when c<>19 then t1.b else f end when  -11 then 11 else 19 end in ( -19,t1.a,d)) and not 17<t1.d)"
    end, {
        -- <randexpr-2.434>
        600
        -- </randexpr-2.434>
    })

test:do_test(
    "randexpr-2.435",
    function()
        return test:execsql "SELECT case when coalesce((select max(case f when (abs(t1.d)/abs(case when +~e not in (t1.d,c,t1.a) or 17 in (select count(distinct  -b) from t1 union select count(distinct d) from t1) and d<=t1.b or b>(f) then coalesce((select c from t1 where t1.f<t1.e),e)+(d) when 17<19 then t1.c else t1.b end)) then t1.b else f end) from t1 where (17 not between 11 and t1.b) or t1.f>f or t1.b<> -t1.c), -t1.d)<11 then c else f end FROM t1 WHERE NOT (not exists(select 1 from t1 where exists(select 1 from t1 where case  -case when case t1.c-t1.b-e when t1.b then t1.e else  -t1.c+~17 | coalesce((select max(t1.c) from t1 where 19 not between  -(a)-t1.c and 17),t1.c) end in (select (t1.f) from t1 union select b from t1) then e when c<>19 then t1.b else f end when  -11 then 11 else 19 end in ( -19,t1.a,d)) and not 17<t1.d))"
    end, {
        -- <randexpr-2.435>
        
        -- </randexpr-2.435>
    })

test:do_test(
    "randexpr-2.436",
    function()
        return test:execsql "SELECT ((select abs(min(t1.b-t1.b)-cast(avg((t1.d-t1.a*a) | (select max(t1.e-e) | max(17)*~abs(count(*)-cast(avg(coalesce((select t1.c from t1 where t1.c<=11),19)+ -e) AS integer) | max(t1.c)) | min(b) | (count(*))*min(19)- -count(*) | (cast(avg(b) AS integer)) from t1)) AS integer)-cast(avg(t1.b) AS integer)) from t1)) FROM t1 WHERE +b+(19*19)+c+t1.d<=e-19+case 13 when t1.f+~11+(select cast(avg(t1.e) AS integer) from t1) then (case when not exists(select 1 from t1 where t1.a between d and t1.b) then case c when d then d else t1.f end when not t1.b in (11,t1.c,t1.d) or t1.c<=(d) then (t1.a) else t1.b end) else  -e end or f in (t1.f,d,t1.c)"
    end, {
        -- <randexpr-2.436>
        7995
        -- </randexpr-2.436>
    })

test:do_test(
    "randexpr-2.437",
    function()
        return test:execsql "SELECT ((select abs(min(t1.b-t1.b)-cast(avg((t1.d-t1.a*a) | (select max(t1.e-e) | max(17)*~abs(count(*)-cast(avg(coalesce((select t1.c from t1 where t1.c<=11),19)+ -e) AS integer) | max(t1.c)) | min(b) | (count(*))*min(19)- -count(*) | (cast(avg(b) AS integer)) from t1)) AS integer)-cast(avg(t1.b) AS integer)) from t1)) FROM t1 WHERE NOT (+b+(19*19)+c+t1.d<=e-19+case 13 when t1.f+~11+(select cast(avg(t1.e) AS integer) from t1) then (case when not exists(select 1 from t1 where t1.a between d and t1.b) then case c when d then d else t1.f end when not t1.b in (11,t1.c,t1.d) or t1.c<=(d) then (t1.a) else t1.b end) else  -e end or f in (t1.f,d,t1.c))"
    end, {
        -- <randexpr-2.437>
        
        -- </randexpr-2.437>
    })

test:do_test(
    "randexpr-2.438",
    function()
        return test:execsql "SELECT ((select abs(min(t1.b-t1.b)-cast(avg((t1.d-t1.a*a) & (select max(t1.e-e) & max(17)*~abs(count(*)-cast(avg(coalesce((select t1.c from t1 where t1.c<=11),19)+ -e) AS integer) & max(t1.c)) & min(b) & (count(*))*min(19)- -count(*) & (cast(avg(b) AS integer)) from t1)) AS integer)-cast(avg(t1.b) AS integer)) from t1)) FROM t1 WHERE +b+(19*19)+c+t1.d<=e-19+case 13 when t1.f+~11+(select cast(avg(t1.e) AS integer) from t1) then (case when not exists(select 1 from t1 where t1.a between d and t1.b) then case c when d then d else t1.f end when not t1.b in (11,t1.c,t1.d) or t1.c<=(d) then (t1.a) else t1.b end) else  -e end or f in (t1.f,d,t1.c)"
    end, {
        -- <randexpr-2.438>
        200
        -- </randexpr-2.438>
    })

test:do_test(
    "randexpr-2.439",
    function()
        return test:execsql "SELECT case when (b<coalesce((select coalesce((select max(19 | t1.c) from t1 where 13 not in (t1.f,e,t1.e) or (select (count(distinct coalesce((select d from t1 where t1.c between  -17 and b),11)) | count(*)-max(t1.d)* -(max(d))) from t1)-c*t1.e in (select 19 | f from t1 union select a from t1)),c)*a from t1 where (13 not between a and 19)),19) and b>a) then t1.f else t1.c end FROM t1 WHERE case when (((case coalesce((select  -t1.b-t1.b*19*c | 19 from t1 where (exists(select 1 from t1 where e>=t1.a))),t1.a)+11 when d then t1.e else t1.c end=t1.d))) then t1.b when not not exists(select 1 from t1 where t1.f<(t1.a)) and t1.d>=f or t1.c>t1.a or t1.b between t1.f and 19 then t1.c else ~t1.c end=11 or (t1.e) not between 13 and t1.c"
    end, {
        -- <randexpr-2.439>
        600
        -- </randexpr-2.439>
    })

test:do_test(
    "randexpr-2.440",
    function()
        return test:execsql "SELECT case when (b<coalesce((select coalesce((select max(19 | t1.c) from t1 where 13 not in (t1.f,e,t1.e) or (select (count(distinct coalesce((select d from t1 where t1.c between  -17 and b),11)) | count(*)-max(t1.d)* -(max(d))) from t1)-c*t1.e in (select 19 | f from t1 union select a from t1)),c)*a from t1 where (13 not between a and 19)),19) and b>a) then t1.f else t1.c end FROM t1 WHERE NOT (case when (((case coalesce((select  -t1.b-t1.b*19*c | 19 from t1 where (exists(select 1 from t1 where e>=t1.a))),t1.a)+11 when d then t1.e else t1.c end=t1.d))) then t1.b when not not exists(select 1 from t1 where t1.f<(t1.a)) and t1.d>=f or t1.c>t1.a or t1.b between t1.f and 19 then t1.c else ~t1.c end=11 or (t1.e) not between 13 and t1.c)"
    end, {
        -- <randexpr-2.440>
        
        -- </randexpr-2.440>
    })

test:do_test(
    "randexpr-2.441",
    function()
        return test:execsql "SELECT case when (b<coalesce((select coalesce((select max(19 & t1.c) from t1 where 13 not in (t1.f,e,t1.e) or (select (count(distinct coalesce((select d from t1 where t1.c between  -17 and b),11)) & count(*)-max(t1.d)* -(max(d))) from t1)-c*t1.e in (select 19 & f from t1 union select a from t1)),c)*a from t1 where (13 not between a and 19)),19) and b>a) then t1.f else t1.c end FROM t1 WHERE case when (((case coalesce((select  -t1.b-t1.b*19*c | 19 from t1 where (exists(select 1 from t1 where e>=t1.a))),t1.a)+11 when d then t1.e else t1.c end=t1.d))) then t1.b when not not exists(select 1 from t1 where t1.f<(t1.a)) and t1.d>=f or t1.c>t1.a or t1.b between t1.f and 19 then t1.c else ~t1.c end=11 or (t1.e) not between 13 and t1.c"
    end, {
        -- <randexpr-2.441>
        300
        -- </randexpr-2.441>
    })

test:do_test(
    "randexpr-2.442",
    function()
        return test:execsql "SELECT case when not t1.d not in (coalesce((select 17 |  -coalesce((select (select min(a-t1.a+t1.a-t1.c*t1.e) from t1) from t1 where t1.d<=a),11) | 19 from t1 where not ( -13 in ( -t1.d,t1.d,19))),e)+11,11,13) then e when ((t1.b<t1.c) or d=19) then (t1.a) else a end FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where ~f-e+t1.b*d+case when coalesce((select max(d) from t1 where (t1.c*t1.b in (b,t1.e,17)) or t1.b not in (t1.c,t1.a,t1.c)), -17) in (select count(distinct 13) from t1 union select  - -~min( -11) | cast(avg(c) AS integer) from t1) then f else a end+e*t1.c+t1.c>t1.f and a>=17))"
    end, {
        -- <randexpr-2.442>
        
        -- </randexpr-2.442>
    })

test:do_test(
    "randexpr-2.443",
    function()
        return test:execsql "SELECT case when not t1.d not in (coalesce((select 17 |  -coalesce((select (select min(a-t1.a+t1.a-t1.c*t1.e) from t1) from t1 where t1.d<=a),11) | 19 from t1 where not ( -13 in ( -t1.d,t1.d,19))),e)+11,11,13) then e when ((t1.b<t1.c) or d=19) then (t1.a) else a end FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where ~f-e+t1.b*d+case when coalesce((select max(d) from t1 where (t1.c*t1.b in (b,t1.e,17)) or t1.b not in (t1.c,t1.a,t1.c)), -17) in (select count(distinct 13) from t1 union select  - -~min( -11) | cast(avg(c) AS integer) from t1) then f else a end+e*t1.c+t1.c>t1.f and a>=17)))"
    end, {
        -- <randexpr-2.443>
        100
        -- </randexpr-2.443>
    })

test:do_test(
    "randexpr-2.444",
    function()
        return test:execsql "SELECT case when not t1.d not in (coalesce((select 17 &  -coalesce((select (select min(a-t1.a+t1.a-t1.c*t1.e) from t1) from t1 where t1.d<=a),11) & 19 from t1 where not ( -13 in ( -t1.d,t1.d,19))),e)+11,11,13) then e when ((t1.b<t1.c) or d=19) then (t1.a) else a end FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where ~f-e+t1.b*d+case when coalesce((select max(d) from t1 where (t1.c*t1.b in (b,t1.e,17)) or t1.b not in (t1.c,t1.a,t1.c)), -17) in (select count(distinct 13) from t1 union select  - -~min( -11) | cast(avg(c) AS integer) from t1) then f else a end+e*t1.c+t1.c>t1.f and a>=17)))"
    end, {
        -- <randexpr-2.444>
        100
        -- </randexpr-2.444>
    })

test:do_test(
    "randexpr-2.445",
    function()
        return test:execsql "SELECT e+c-(c)+t1.e*(abs(case when 13 in (select abs(max(17)*case  -count(*) when cast(avg(a) AS integer) then count(distinct b) else  -max(f) end | (cast(avg(t1.e) AS integer)) |  -min(f)) from t1 union select count(distinct d) from t1) and case when (t1.e+a> -(a)) then e when not c<t1.f or t1.d=f then e else t1.e end<=t1.f then  -a when t1.d<=13 then a else t1.b end)/abs( -t1.a))-t1.b+t1.b FROM t1 WHERE case when  -case when t1.f<t1.c then  -(t1.e) when 11 between e and coalesce((select c from t1 where not exists(select 1 from t1 where b>=e)),coalesce((select max(case t1.e when t1.c then t1.a else a end) from t1 where b>=t1.c and b<>t1.c),13)) then t1.b else a end<11 then b when (11 in (select a from t1 union select t1.b from t1)) or t1.b=e or a between a and 13 then t1.b else b end>19"
    end, {
        -- <randexpr-2.445>
        1500
        -- </randexpr-2.445>
    })

test:do_test(
    "randexpr-2.446",
    function()
        return test:execsql "SELECT e+c-(c)+t1.e*(abs(case when 13 in (select abs(max(17)*case  -count(*) when cast(avg(a) AS integer) then count(distinct b) else  -max(f) end | (cast(avg(t1.e) AS integer)) |  -min(f)) from t1 union select count(distinct d) from t1) and case when (t1.e+a> -(a)) then e when not c<t1.f or t1.d=f then e else t1.e end<=t1.f then  -a when t1.d<=13 then a else t1.b end)/abs( -t1.a))-t1.b+t1.b FROM t1 WHERE NOT (case when  -case when t1.f<t1.c then  -(t1.e) when 11 between e and coalesce((select c from t1 where not exists(select 1 from t1 where b>=e)),coalesce((select max(case t1.e when t1.c then t1.a else a end) from t1 where b>=t1.c and b<>t1.c),13)) then t1.b else a end<11 then b when (11 in (select a from t1 union select t1.b from t1)) or t1.b=e or a between a and 13 then t1.b else b end>19)"
    end, {
        -- <randexpr-2.446>
        
        -- </randexpr-2.446>
    })

test:do_test(
    "randexpr-2.447",
    function()
        return test:execsql "SELECT e+c-(c)+t1.e*(abs(case when 13 in (select abs(max(17)*case  -count(*) when cast(avg(a) AS integer) then count(distinct b) else  -max(f) end & (cast(avg(t1.e) AS integer)) &  -min(f)) from t1 union select count(distinct d) from t1) and case when (t1.e+a> -(a)) then e when not c<t1.f or t1.d=f then e else t1.e end<=t1.f then  -a when t1.d<=13 then a else t1.b end)/abs( -t1.a))-t1.b+t1.b FROM t1 WHERE case when  -case when t1.f<t1.c then  -(t1.e) when 11 between e and coalesce((select c from t1 where not exists(select 1 from t1 where b>=e)),coalesce((select max(case t1.e when t1.c then t1.a else a end) from t1 where b>=t1.c and b<>t1.c),13)) then t1.b else a end<11 then b when (11 in (select a from t1 union select t1.b from t1)) or t1.b=e or a between a and 13 then t1.b else b end>19"
    end, {
        -- <randexpr-2.447>
        1500
        -- </randexpr-2.447>
    })

test:do_test(
    "randexpr-2.448",
    function()
        return test:execsql "SELECT 13-coalesce((select t1.a*a from t1 where not exists(select 1 from t1 where 17 not between case +coalesce((select  -case 19 when a*b then 19 else f end from t1 where (t1.d-t1.e between case f when (select abs(case abs( -min(13)) when min(t1.b) then  -(count(distinct f)) else min(t1.b) end) from t1) then 17*( -13) | f else t1.e end and  -t1.a)),d)*c when 13 then 11 else t1.a end and c)),t1.a)*19 FROM t1 WHERE ((not f-c<=(abs(a)/abs(+t1.a)) or t1.e not between coalesce((select 11 from t1 where  - -a*t1.d*case coalesce((select max(d) from t1 where ((t1.b<=t1.c))),case when f>t1.d or t1.d=t1.a or t1.c<=c then a else  -c end*t1.b) when (f) then 11 else 19 end-t1.a<=b),c) and 13))"
    end, {
        -- <randexpr-2.448>
        -1887
        -- </randexpr-2.448>
    })

test:do_test(
    "randexpr-2.449",
    function()
        return test:execsql "SELECT 13-coalesce((select t1.a*a from t1 where not exists(select 1 from t1 where 17 not between case +coalesce((select  -case 19 when a*b then 19 else f end from t1 where (t1.d-t1.e between case f when (select abs(case abs( -min(13)) when min(t1.b) then  -(count(distinct f)) else min(t1.b) end) from t1) then 17*( -13) | f else t1.e end and  -t1.a)),d)*c when 13 then 11 else t1.a end and c)),t1.a)*19 FROM t1 WHERE NOT (((not f-c<=(abs(a)/abs(+t1.a)) or t1.e not between coalesce((select 11 from t1 where  - -a*t1.d*case coalesce((select max(d) from t1 where ((t1.b<=t1.c))),case when f>t1.d or t1.d=t1.a or t1.c<=c then a else  -c end*t1.b) when (f) then 11 else 19 end-t1.a<=b),c) and 13)))"
    end, {
        -- <randexpr-2.449>
        
        -- </randexpr-2.449>
    })

test:do_test(
    "randexpr-2.450",
    function()
        return test:execsql "SELECT 13-coalesce((select t1.a*a from t1 where not exists(select 1 from t1 where 17 not between case +coalesce((select  -case 19 when a*b then 19 else f end from t1 where (t1.d-t1.e between case f when (select abs(case abs( -min(13)) when min(t1.b) then  -(count(distinct f)) else min(t1.b) end) from t1) then 17*( -13) & f else t1.e end and  -t1.a)),d)*c when 13 then 11 else t1.a end and c)),t1.a)*19 FROM t1 WHERE ((not f-c<=(abs(a)/abs(+t1.a)) or t1.e not between coalesce((select 11 from t1 where  - -a*t1.d*case coalesce((select max(d) from t1 where ((t1.b<=t1.c))),case when f>t1.d or t1.d=t1.a or t1.c<=c then a else  -c end*t1.b) when (f) then 11 else 19 end-t1.a<=b),c) and 13))"
    end, {
        -- <randexpr-2.450>
        -1887
        -- </randexpr-2.450>
    })

test:do_test(
    "randexpr-2.451",
    function()
        return test:execsql "SELECT ~case when (t1.d | 17 in (b*t1.e,19*case when t1.d<= -a then t1.d*~t1.c*e*t1.c-19 else ~t1.b+17 end-d,(t1.c))) then +t1.d else (abs( -case t1.e when t1.c then (t1.b) else t1.f end-11+ -a)/abs(f))+a end FROM t1 WHERE not exists(select 1 from t1 where not c in (select case count(distinct (f)-19) when ~( -+~cast(avg(c) AS integer) | count(distinct 11)-max(d)+min(t1.a)+ -( -count(distinct b))+(count(*)))-count(*)+cast(avg(c) AS integer) then count(distinct d) else ((max(t1.b))) end-min(b) from t1 union select min(t1.c) from t1)) and t1.c in (select +d from t1 union select case when c+b=17 then a else 13 end+11 from t1)"
    end, {
        -- <randexpr-2.451>
        
        -- </randexpr-2.451>
    })

test:do_test(
    "randexpr-2.452",
    function()
        return test:execsql "SELECT ~case when (t1.d | 17 in (b*t1.e,19*case when t1.d<= -a then t1.d*~t1.c*e*t1.c-19 else ~t1.b+17 end-d,(t1.c))) then +t1.d else (abs( -case t1.e when t1.c then (t1.b) else t1.f end-11+ -a)/abs(f))+a end FROM t1 WHERE NOT (not exists(select 1 from t1 where not c in (select case count(distinct (f)-19) when ~( -+~cast(avg(c) AS integer) | count(distinct 11)-max(d)+min(t1.a)+ -( -count(distinct b))+(count(*)))-count(*)+cast(avg(c) AS integer) then count(distinct d) else ((max(t1.b))) end-min(b) from t1 union select min(t1.c) from t1)) and t1.c in (select +d from t1 union select case when c+b=17 then a else 13 end+11 from t1))"
    end, {
        -- <randexpr-2.452>
        -102
        -- </randexpr-2.452>
    })

test:do_test(
    "randexpr-2.453",
    function()
        return test:execsql "SELECT ~case when (t1.d & 17 in (b*t1.e,19*case when t1.d<= -a then t1.d*~t1.c*e*t1.c-19 else ~t1.b+17 end-d,(t1.c))) then +t1.d else (abs( -case t1.e when t1.c then (t1.b) else t1.f end-11+ -a)/abs(f))+a end FROM t1 WHERE NOT (not exists(select 1 from t1 where not c in (select case count(distinct (f)-19) when ~( -+~cast(avg(c) AS integer) | count(distinct 11)-max(d)+min(t1.a)+ -( -count(distinct b))+(count(*)))-count(*)+cast(avg(c) AS integer) then count(distinct d) else ((max(t1.b))) end-min(b) from t1 union select min(t1.c) from t1)) and t1.c in (select +d from t1 union select case when c+b=17 then a else 13 end+11 from t1))"
    end, {
        -- <randexpr-2.453>
        -102
        -- </randexpr-2.453>
    })

test:do_test(
    "randexpr-2.454",
    function()
        return test:execsql "SELECT (select case case min(d) when abs(cast(avg((abs(a)/abs(coalesce((select (select abs(cast(avg(t1.f) AS integer)) from t1) from t1 where (case when t1.e in (select 11 from t1 union select 17 from t1) then  -t1.e- -t1.e else a end<>a) and not not exists(select 1 from t1 where t1.b in (select ~+max( -t1.b) | max(t1.c) from t1 union select count(distinct  -t1.a) from t1))),t1.a)))) AS integer)) then (count(*) | ((count(distinct b)))-count(*)) else min(11) end when max(a) then count(distinct f) else (min(17)) end from t1) FROM t1 WHERE coalesce((select max(13) from t1 where t1.b not in ( -case when 13 not between 17 and b then f when t1.e+~+e between coalesce((select max(case 19 when e then 17 else coalesce((select coalesce((select max(f) from t1 where exists(select 1 from t1 where t1.b not between t1.a and a)),e)*b*t1.f from t1 where t1.f>=t1.c),c) end) from t1 where e>b),t1.f) | f and f then c else 11 end,(c),t1.e)),19)-t1.c in (select t1.a from t1 union select e from t1)"
    end, {
        -- <randexpr-2.454>
        
        -- </randexpr-2.454>
    })

test:do_test(
    "randexpr-2.455",
    function()
        return test:execsql "SELECT (select case case min(d) when abs(cast(avg((abs(a)/abs(coalesce((select (select abs(cast(avg(t1.f) AS integer)) from t1) from t1 where (case when t1.e in (select 11 from t1 union select 17 from t1) then  -t1.e- -t1.e else a end<>a) and not not exists(select 1 from t1 where t1.b in (select ~+max( -t1.b) | max(t1.c) from t1 union select count(distinct  -t1.a) from t1))),t1.a)))) AS integer)) then (count(*) | ((count(distinct b)))-count(*)) else min(11) end when max(a) then count(distinct f) else (min(17)) end from t1) FROM t1 WHERE NOT (coalesce((select max(13) from t1 where t1.b not in ( -case when 13 not between 17 and b then f when t1.e+~+e between coalesce((select max(case 19 when e then 17 else coalesce((select coalesce((select max(f) from t1 where exists(select 1 from t1 where t1.b not between t1.a and a)),e)*b*t1.f from t1 where t1.f>=t1.c),c) end) from t1 where e>b),t1.f) | f and f then c else 11 end,(c),t1.e)),19)-t1.c in (select t1.a from t1 union select e from t1))"
    end, {
        -- <randexpr-2.455>
        17
        -- </randexpr-2.455>
    })

test:do_test(
    "randexpr-2.456",
    function()
        return test:execsql "SELECT (select case case min(d) when abs(cast(avg((abs(a)/abs(coalesce((select (select abs(cast(avg(t1.f) AS integer)) from t1) from t1 where (case when t1.e in (select 11 from t1 union select 17 from t1) then  -t1.e- -t1.e else a end<>a) and not not exists(select 1 from t1 where t1.b in (select ~+max( -t1.b) & max(t1.c) from t1 union select count(distinct  -t1.a) from t1))),t1.a)))) AS integer)) then (count(*) & ((count(distinct b)))-count(*)) else min(11) end when max(a) then count(distinct f) else (min(17)) end from t1) FROM t1 WHERE NOT (coalesce((select max(13) from t1 where t1.b not in ( -case when 13 not between 17 and b then f when t1.e+~+e between coalesce((select max(case 19 when e then 17 else coalesce((select coalesce((select max(f) from t1 where exists(select 1 from t1 where t1.b not between t1.a and a)),e)*b*t1.f from t1 where t1.f>=t1.c),c) end) from t1 where e>b),t1.f) | f and f then c else 11 end,(c),t1.e)),19)-t1.c in (select t1.a from t1 union select e from t1))"
    end, {
        -- <randexpr-2.456>
        17
        -- </randexpr-2.456>
    })

test:do_test(
    "randexpr-2.457",
    function()
        return test:execsql "SELECT (a*f+c | ~b*(select cast(avg(19) AS integer) from t1)+17*(select max(a*b-d) from t1)+(abs((select count(distinct b) from t1))/abs(case when  -13*c between t1.f and t1.c then c when not 17 between 17 and 11 and 17<=((t1.c)) then c else a end*t1.c))-a*a)-c FROM t1 WHERE exists(select 1 from t1 where t1.e-11+t1.d*e+(abs(coalesce((select max(t1.b) from t1 where 19-13- -coalesce((select c*t1.e+t1.f*f from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (17<=d or  -11 in (select cast(avg(c) AS integer) from t1 union select +count(*) from t1))))),t1.b)<a),(t1.c)))/abs(t1.c))<=a or 13 between t1.e and  -t1.b)"
    end, {
        -- <randexpr-2.457>
        
        -- </randexpr-2.457>
    })

test:do_test(
    "randexpr-2.458",
    function()
        return test:execsql "SELECT (a*f+c | ~b*(select cast(avg(19) AS integer) from t1)+17*(select max(a*b-d) from t1)+(abs((select count(distinct b) from t1))/abs(case when  -13*c between t1.f and t1.c then c when not 17 between 17 and 11 and 17<=((t1.c)) then c else a end*t1.c))-a*a)-c FROM t1 WHERE NOT (exists(select 1 from t1 where t1.e-11+t1.d*e+(abs(coalesce((select max(t1.b) from t1 where 19-13- -coalesce((select c*t1.e+t1.f*f from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (17<=d or  -11 in (select cast(avg(c) AS integer) from t1 union select +count(*) from t1))))),t1.b)<a),(t1.c)))/abs(t1.c))<=a or 13 between t1.e and  -t1.b))"
    end, {
        -- <randexpr-2.458>
        327281
        -- </randexpr-2.458>
    })

test:do_test(
    "randexpr-2.459",
    function()
        return test:execsql "SELECT (a*f+c & ~b*(select cast(avg(19) AS integer) from t1)+17*(select max(a*b-d) from t1)+(abs((select count(distinct b) from t1))/abs(case when  -13*c between t1.f and t1.c then c when not 17 between 17 and 11 and 17<=((t1.c)) then c else a end*t1.c))-a*a)-c FROM t1 WHERE NOT (exists(select 1 from t1 where t1.e-11+t1.d*e+(abs(coalesce((select max(t1.b) from t1 where 19-13- -coalesce((select c*t1.e+t1.f*f from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (17<=d or  -11 in (select cast(avg(c) AS integer) from t1 union select +count(*) from t1))))),t1.b)<a),(t1.c)))/abs(t1.c))<=a or 13 between t1.e and  -t1.b))"
    end, {
        -- <randexpr-2.459>
        51800
        -- </randexpr-2.459>
    })

test:do_test(
    "randexpr-2.460",
    function()
        return test:execsql "SELECT coalesce((select max(case when not ((select ((count(distinct t1.f)*(cast(avg(e) AS integer)))-min(t1.d)*min(t1.c)) from t1)*(select min(t1.d) from t1) not in ((select count(distinct b) from t1),f*d,19) and  -a in (t1.d,b,a)) and d>=t1.c or t1.b>t1.c or 19 not between c and t1.e then 17 else t1.b end) from t1 where (e<=t1.b)),11) FROM t1 WHERE t1.a in (f,t1.d*+a,t1.c* -(select (abs(case +(max(coalesce((select max((select count(*)-cast(avg(b) AS integer) from t1)) from t1 where (c<c)),b)-t1.d))+max(c)*+count(distinct coalesce((select max((17)) from t1 where d in (select 11 from t1 union select 17 from t1)),t1.e))*count(*) when ~count(*) then cast(avg(d) AS integer) else max(t1.a) end*count(distinct c))) from t1))"
    end, {
        -- <randexpr-2.460>
        
        -- </randexpr-2.460>
    })

test:do_test(
    "randexpr-2.461",
    function()
        return test:execsql "SELECT coalesce((select max(case when not ((select ((count(distinct t1.f)*(cast(avg(e) AS integer)))-min(t1.d)*min(t1.c)) from t1)*(select min(t1.d) from t1) not in ((select count(distinct b) from t1),f*d,19) and  -a in (t1.d,b,a)) and d>=t1.c or t1.b>t1.c or 19 not between c and t1.e then 17 else t1.b end) from t1 where (e<=t1.b)),11) FROM t1 WHERE NOT (t1.a in (f,t1.d*+a,t1.c* -(select (abs(case +(max(coalesce((select max((select count(*)-cast(avg(b) AS integer) from t1)) from t1 where (c<c)),b)-t1.d))+max(c)*+count(distinct coalesce((select max((17)) from t1 where d in (select 11 from t1 union select 17 from t1)),t1.e))*count(*) when ~count(*) then cast(avg(d) AS integer) else max(t1.a) end*count(distinct c))) from t1)))"
    end, {
        -- <randexpr-2.461>
        11
        -- </randexpr-2.461>
    })

test:do_test(
    "randexpr-2.462",
    function()
        return test:execsql "SELECT (case case when +c>e then case t1.d when 13 then t1.c else 19 end-13 else t1.e+coalesce((select max(19) from t1 where case when e in (+b,coalesce((select a+(11) from t1 where b not between c and d or t1.b not in (a,11,17)),b),11) then 19 when (c) not in (t1.c,t1.b,d) then t1.c else t1.d end*f not between t1.a and d),13) end when c then 11 else c end) FROM t1 WHERE 19 not between coalesce((select max(d*t1.c) from t1 where (select cast(avg((b)) AS integer) from t1) in (select ( - -(abs(case max(b) when cast(avg( -13-11) AS integer) then count(distinct a-e) else ~ -cast(avg((c)) AS integer)-min(17)+count(*) end) | (min(e)))-min((19))) from t1 union select count(distinct 13) from t1)),case when  -e | 19 between  -11 and f then 19 else 19 end) and (f)"
    end, {
        -- <randexpr-2.462>
        
        -- </randexpr-2.462>
    })

test:do_test(
    "randexpr-2.463",
    function()
        return test:execsql "SELECT (case case when +c>e then case t1.d when 13 then t1.c else 19 end-13 else t1.e+coalesce((select max(19) from t1 where case when e in (+b,coalesce((select a+(11) from t1 where b not between c and d or t1.b not in (a,11,17)),b),11) then 19 when (c) not in (t1.c,t1.b,d) then t1.c else t1.d end*f not between t1.a and d),13) end when c then 11 else c end) FROM t1 WHERE NOT (19 not between coalesce((select max(d*t1.c) from t1 where (select cast(avg((b)) AS integer) from t1) in (select ( - -(abs(case max(b) when cast(avg( -13-11) AS integer) then count(distinct a-e) else ~ -cast(avg((c)) AS integer)-min(17)+count(*) end) | (min(e)))-min((19))) from t1 union select count(distinct 13) from t1)),case when  -e | 19 between  -11 and f then 19 else 19 end) and (f))"
    end, {
        -- <randexpr-2.463>
        300
        -- </randexpr-2.463>
    })

test:do_test(
    "randexpr-2.464",
    function()
        return test:execsql "SELECT (abs((select abs(case  -max(e)+max(t1.f)+(count(*)* -count(distinct case e when 19 then c else 13 end))*~min(t1.a) when cast(avg(t1.a) AS integer) then  -min(e) else  -count(*) end) from t1)*coalesce((select (t1.a) from t1 where case when c+t1.b-b | d in (select max(d) from t1 union select  -max(19) from t1) then t1.b else f end=t1.d),t1.b)*(t1.d) | e+t1.a)/abs(t1.d)) FROM t1 WHERE t1.f in (19,d*t1.d,(select min((select count(*)*min((17)+(abs(11)/abs(+~coalesce((select max(f) from t1 where 13 not between t1.c and t1.a),t1.e)-11))) from t1)) from t1)+17)"
    end, {
        -- <randexpr-2.464>
        
        -- </randexpr-2.464>
    })

test:do_test(
    "randexpr-2.465",
    function()
        return test:execsql "SELECT (abs((select abs(case  -max(e)+max(t1.f)+(count(*)* -count(distinct case e when 19 then c else 13 end))*~min(t1.a) when cast(avg(t1.a) AS integer) then  -min(e) else  -count(*) end) from t1)*coalesce((select (t1.a) from t1 where case when c+t1.b-b | d in (select max(d) from t1 union select  -max(19) from t1) then t1.b else f end=t1.d),t1.b)*(t1.d) | e+t1.a)/abs(t1.d)) FROM t1 WHERE NOT (t1.f in (19,d*t1.d,(select min((select count(*)*min((17)+(abs(11)/abs(+~coalesce((select max(f) from t1 where 13 not between t1.c and t1.a),t1.e)-11))) from t1)) from t1)+17))"
    end, {
        -- <randexpr-2.465>
        201
        -- </randexpr-2.465>
    })

test:do_test(
    "randexpr-2.466",
    function()
        return test:execsql "SELECT (abs((select abs(case  -max(e)+max(t1.f)+(count(*)* -count(distinct case e when 19 then c else 13 end))*~min(t1.a) when cast(avg(t1.a) AS integer) then  -min(e) else  -count(*) end) from t1)*coalesce((select (t1.a) from t1 where case when c+t1.b-b & d in (select max(d) from t1 union select  -max(19) from t1) then t1.b else f end=t1.d),t1.b)*(t1.d) & e+t1.a)/abs(t1.d)) FROM t1 WHERE NOT (t1.f in (19,d*t1.d,(select min((select count(*)*min((17)+(abs(11)/abs(+~coalesce((select max(f) from t1 where 13 not between t1.c and t1.a),t1.e)-11))) from t1)) from t1)+17))"
    end, {
        -- <randexpr-2.466>
        0
        -- </randexpr-2.466>
    })

test:do_test(
    "randexpr-2.467",
    function()
        return test:execsql "SELECT d+case when (coalesce((select max(t1.a) from t1 where t1.a not in (t1.d,f*(select count(distinct t1.d) from t1)+t1.f,c)),b)-c-17-t1.c)-case when 13*t1.a-19*e<>11 then f when t1.f not between 11 and t1.d then b else f end=t1.d then t1.f when not e>t1.f then 17 else b end FROM t1 WHERE exists(select 1 from t1 where 11* -d>=e) or t1.c<+ -e*11 or (17 not between t1.d and case t1.a when t1.a then t1.d+f-b else 11 end | t1.e)"
    end, {
        -- <randexpr-2.467>
        417
        -- </randexpr-2.467>
    })

test:do_test(
    "randexpr-2.468",
    function()
        return test:execsql "SELECT d+case when (coalesce((select max(t1.a) from t1 where t1.a not in (t1.d,f*(select count(distinct t1.d) from t1)+t1.f,c)),b)-c-17-t1.c)-case when 13*t1.a-19*e<>11 then f when t1.f not between 11 and t1.d then b else f end=t1.d then t1.f when not e>t1.f then 17 else b end FROM t1 WHERE NOT (exists(select 1 from t1 where 11* -d>=e) or t1.c<+ -e*11 or (17 not between t1.d and case t1.a when t1.a then t1.d+f-b else 11 end | t1.e))"
    end, {
        -- <randexpr-2.468>
        
        -- </randexpr-2.468>
    })

test:do_test(
    "randexpr-2.469",
    function()
        return test:execsql "SELECT t1.f-coalesce((select max(+e | b) from t1 where case when  -(abs(11)/abs(~(19 | t1.d)))-~c*e not in (19,b*t1.b,b) then 11 when f<=13 then d else t1.d end in (select (count(*))-cast(avg(11 | 17*t1.b) AS integer) from t1 union select count(distinct a-17) from t1)),t1.c)-c FROM t1 WHERE case when (t1.f*a<=11+d+coalesce((select max(19+19) from t1 where 13 in (select min(f)+cast(avg((abs(t1.e)/abs((select count(distinct c) from t1)))) AS integer)+(~cast(avg(e) AS integer))-min(c) from t1 union select count(*) from t1)),b)) then (a) else t1.b end-t1.b<=t1.b and 13 in (select t1.e from t1 union select t1.e from t1) and a<e"
    end, {
        -- <randexpr-2.469>
        
        -- </randexpr-2.469>
    })

test:do_test(
    "randexpr-2.470",
    function()
        return test:execsql "SELECT t1.f-coalesce((select max(+e | b) from t1 where case when  -(abs(11)/abs(~(19 | t1.d)))-~c*e not in (19,b*t1.b,b) then 11 when f<=13 then d else t1.d end in (select (count(*))-cast(avg(11 | 17*t1.b) AS integer) from t1 union select count(distinct a-17) from t1)),t1.c)-c FROM t1 WHERE NOT (case when (t1.f*a<=11+d+coalesce((select max(19+19) from t1 where 13 in (select min(f)+cast(avg((abs(t1.e)/abs((select count(distinct c) from t1)))) AS integer)+(~cast(avg(e) AS integer))-min(c) from t1 union select count(*) from t1)),b)) then (a) else t1.b end-t1.b<=t1.b and 13 in (select t1.e from t1 union select t1.e from t1) and a<e)"
    end, {
        -- <randexpr-2.470>
        0
        -- </randexpr-2.470>
    })

test:do_test(
    "randexpr-2.471",
    function()
        return test:execsql "SELECT t1.f-coalesce((select max(+e & b) from t1 where case when  -(abs(11)/abs(~(19 & t1.d)))-~c*e not in (19,b*t1.b,b) then 11 when f<=13 then d else t1.d end in (select (count(*))-cast(avg(11 & 17*t1.b) AS integer) from t1 union select count(distinct a-17) from t1)),t1.c)-c FROM t1 WHERE NOT (case when (t1.f*a<=11+d+coalesce((select max(19+19) from t1 where 13 in (select min(f)+cast(avg((abs(t1.e)/abs((select count(distinct c) from t1)))) AS integer)+(~cast(avg(e) AS integer))-min(c) from t1 union select count(*) from t1)),b)) then (a) else t1.b end-t1.b<=t1.b and 13 in (select t1.e from t1 union select t1.e from t1) and a<e)"
    end, {
        -- <randexpr-2.471>
        0
        -- </randexpr-2.471>
    })

test:do_test(
    "randexpr-2.472",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c) from t1 where case when (t1.e*19*f-t1.b in (select cast(avg(d-~d) AS integer) from t1 union select +( -case +~count(*)*count(distinct (c)) when cast(avg(19) AS integer) then min(c) else count(distinct 17) end*cast(avg((13)) AS integer)-max(11)+(count(distinct b))) from t1)) then +11 else t1.b end>=t1.d or (exists(select 1 from t1 where (t1.e=t1.c)))),t1.c)-11 FROM t1 WHERE (not exists(select 1 from t1 where 11+t1.c-13>=t1.c or not exists(select 1 from t1 where a in (select b from t1 union select 19-d from t1) and ((abs(a+(abs(coalesce((select t1.d from t1 where exists(select 1 from t1 where case when t1.e>= -13 or  -e<>f then d when t1.c=13 then (b) else t1.c end not between 13 and b)),d))/abs(t1.d))-b)/abs(t1.a))<> -13 and exists(select 1 from t1 where 19<>e) or 13>=19))))"
    end, {
        -- <randexpr-2.472>
        
        -- </randexpr-2.472>
    })

test:do_test(
    "randexpr-2.473",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c) from t1 where case when (t1.e*19*f-t1.b in (select cast(avg(d-~d) AS integer) from t1 union select +( -case +~count(*)*count(distinct (c)) when cast(avg(19) AS integer) then min(c) else count(distinct 17) end*cast(avg((13)) AS integer)-max(11)+(count(distinct b))) from t1)) then +11 else t1.b end>=t1.d or (exists(select 1 from t1 where (t1.e=t1.c)))),t1.c)-11 FROM t1 WHERE NOT ((not exists(select 1 from t1 where 11+t1.c-13>=t1.c or not exists(select 1 from t1 where a in (select b from t1 union select 19-d from t1) and ((abs(a+(abs(coalesce((select t1.d from t1 where exists(select 1 from t1 where case when t1.e>= -13 or  -e<>f then d when t1.c=13 then (b) else t1.c end not between 13 and b)),d))/abs(t1.d))-b)/abs(t1.a))<> -13 and exists(select 1 from t1 where 19<>e) or 13>=19)))))"
    end, {
        -- <randexpr-2.473>
        289
        -- </randexpr-2.473>
    })

test:do_test(
    "randexpr-2.474",
    function()
        return test:execsql "SELECT +coalesce((select max(11) from t1 where not case d+t1.c*coalesce((select max(coalesce((select d | e from t1 where 17 not between coalesce((select (t1.d) from t1 where t1.a between (select max(t1.b+d+t1.a) from t1)-t1.e and 17),t1.a) and 11),19)) from t1 where t1.d<t1.b),d)+t1.e when t1.f then t1.d else t1.f end not in (e,t1.c,t1.c)),c) | c FROM t1 WHERE exists(select 1 from t1 where c in (t1.a,(select count(distinct  -t1.d) from t1),t1.b)) or (~d=t1.e)"
    end, {
        -- <randexpr-2.474>
        
        -- </randexpr-2.474>
    })

test:do_test(
    "randexpr-2.475",
    function()
        return test:execsql "SELECT +coalesce((select max(11) from t1 where not case d+t1.c*coalesce((select max(coalesce((select d | e from t1 where 17 not between coalesce((select (t1.d) from t1 where t1.a between (select max(t1.b+d+t1.a) from t1)-t1.e and 17),t1.a) and 11),19)) from t1 where t1.d<t1.b),d)+t1.e when t1.f then t1.d else t1.f end not in (e,t1.c,t1.c)),c) | c FROM t1 WHERE NOT (exists(select 1 from t1 where c in (t1.a,(select count(distinct  -t1.d) from t1),t1.b)) or (~d=t1.e))"
    end, {
        -- <randexpr-2.475>
        300
        -- </randexpr-2.475>
    })

test:do_test(
    "randexpr-2.476",
    function()
        return test:execsql "SELECT +coalesce((select max(11) from t1 where not case d+t1.c*coalesce((select max(coalesce((select d & e from t1 where 17 not between coalesce((select (t1.d) from t1 where t1.a between (select max(t1.b+d+t1.a) from t1)-t1.e and 17),t1.a) and 11),19)) from t1 where t1.d<t1.b),d)+t1.e when t1.f then t1.d else t1.f end not in (e,t1.c,t1.c)),c) & c FROM t1 WHERE NOT (exists(select 1 from t1 where c in (t1.a,(select count(distinct  -t1.d) from t1),t1.b)) or (~d=t1.e))"
    end, {
        -- <randexpr-2.476>
        300
        -- </randexpr-2.476>
    })

test:do_test(
    "randexpr-2.477",
    function()
        return test:execsql "SELECT case when ((select  -min(e)+cast(avg(t1.a) AS integer) from t1)>t1.d*a) then (abs(~a)/abs(+11))*f when (c-(coalesce((select 11 from t1 where t1.d in (case when (19)+11>=c then 19 when e<>b then 13 else c end,a,13)),17))+13) not between 11 and t1.c then (t1.b) else 17 end+b FROM t1 WHERE a*b*11 in (select case when not coalesce((select max(~13 | (select abs((count(distinct t1.f))*cast(avg(t1.f) AS integer)+(max(t1.e))) from t1)) from t1 where coalesce((select max(11) from t1 where t1.b=19),b) in (f,11,19) and t1.f between a and t1.c or 19=t1.a and d=17 or c>=t1.f or t1.d<>t1.c),11)*c in (select f from t1 union select  -t1.b from t1) then t1.c when c not between f and 13 then e else  -e end from t1 union select e from t1)"
    end, {
        -- <randexpr-2.477>
        
        -- </randexpr-2.477>
    })

test:do_test(
    "randexpr-2.478",
    function()
        return test:execsql "SELECT case when ((select  -min(e)+cast(avg(t1.a) AS integer) from t1)>t1.d*a) then (abs(~a)/abs(+11))*f when (c-(coalesce((select 11 from t1 where t1.d in (case when (19)+11>=c then 19 when e<>b then 13 else c end,a,13)),17))+13) not between 11 and t1.c then (t1.b) else 17 end+b FROM t1 WHERE NOT (a*b*11 in (select case when not coalesce((select max(~13 | (select abs((count(distinct t1.f))*cast(avg(t1.f) AS integer)+(max(t1.e))) from t1)) from t1 where coalesce((select max(11) from t1 where t1.b=19),b) in (f,11,19) and t1.f between a and t1.c or 19=t1.a and d=17 or c>=t1.f or t1.d<>t1.c),11)*c in (select f from t1 union select  -t1.b from t1) then t1.c when c not between f and 13 then e else  -e end from t1 union select e from t1))"
    end, {
        -- <randexpr-2.478>
        217
        -- </randexpr-2.478>
    })

test:do_test(
    "randexpr-2.479",
    function()
        return test:execsql "SELECT t1.d-coalesce((select  -t1.c from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where t1.d<=case t1.d+e when case when d>19 then 11+t1.c else t1.b end-t1.f-t1.e then (abs(t1.d-19*t1.b)/abs(13+case when t1.f in (select count(*)-count(distinct t1.b) from t1 union select (max((t1.f))) from t1) then (((t1.d))) when t1.b not in (t1.d,13,a) then t1.d else 19 end*t1.c))-t1.d else e end))),13)+c*t1.a FROM t1 WHERE exists(select 1 from t1 where ~coalesce((select a+t1.a from t1 where ~(abs(c)/abs(17 | +13))-t1.f in (select f from t1 union select case when t1.b between 11*e and f then e when a in (e* -t1.f-f,coalesce((select 17 from t1 where t1.e in (select (cast(avg(e) AS integer)) from t1 union select max(b) from t1)),a),d) then t1.c else (f) end from t1)),f) between  -19 and (13) or t1.f<>t1.a)"
    end, {
        -- <randexpr-2.479>
        30700
        -- </randexpr-2.479>
    })

test:do_test(
    "randexpr-2.480",
    function()
        return test:execsql "SELECT t1.d-coalesce((select  -t1.c from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where t1.d<=case t1.d+e when case when d>19 then 11+t1.c else t1.b end-t1.f-t1.e then (abs(t1.d-19*t1.b)/abs(13+case when t1.f in (select count(*)-count(distinct t1.b) from t1 union select (max((t1.f))) from t1) then (((t1.d))) when t1.b not in (t1.d,13,a) then t1.d else 19 end*t1.c))-t1.d else e end))),13)+c*t1.a FROM t1 WHERE NOT (exists(select 1 from t1 where ~coalesce((select a+t1.a from t1 where ~(abs(c)/abs(17 | +13))-t1.f in (select f from t1 union select case when t1.b between 11*e and f then e when a in (e* -t1.f-f,coalesce((select 17 from t1 where t1.e in (select (cast(avg(e) AS integer)) from t1 union select max(b) from t1)),a),d) then t1.c else (f) end from t1)),f) between  -19 and (13) or t1.f<>t1.a))"
    end, {
        -- <randexpr-2.480>
        
        -- </randexpr-2.480>
    })

test:do_test(
    "randexpr-2.481",
    function()
        return test:execsql "SELECT (abs((abs(t1.b*t1.b*t1.f+a)/abs(t1.f))*t1.a-case  -(abs(coalesce((select (case when 11*19 in (select count(*) from t1 union select  -min(13)-(max(t1.a)) from t1) then 19 else  -17 end) from t1 where t1.e between 13 and (a)),t1.b)+d)/abs(t1.f))-t1.b-t1.c | d when  -t1.f then c else 17 end)/abs(13))-b*t1.d FROM t1 WHERE 13 in (t1.b,17*e+c*a,coalesce((select max(d) from t1 where +f+b not in (a,t1.a*~t1.c | t1.b-case when t1.a<=case when t1.f in (b,11,e) then d else t1.e end+f then 19 else (f) end-b*13- -t1.f-17,t1.c)),17))"
    end, {
        -- <randexpr-2.481>
        
        -- </randexpr-2.481>
    })

test:do_test(
    "randexpr-2.482",
    function()
        return test:execsql "SELECT (abs((abs(t1.b*t1.b*t1.f+a)/abs(t1.f))*t1.a-case  -(abs(coalesce((select (case when 11*19 in (select count(*) from t1 union select  -min(13)-(max(t1.a)) from t1) then 19 else  -17 end) from t1 where t1.e between 13 and (a)),t1.b)+d)/abs(t1.f))-t1.b-t1.c | d when  -t1.f then c else 17 end)/abs(13))-b*t1.d FROM t1 WHERE NOT (13 in (t1.b,17*e+c*a,coalesce((select max(d) from t1 where +f+b not in (a,t1.a*~t1.c | t1.b-case when t1.a<=case when t1.f in (b,11,e) then d else t1.e end+f then 19 else (f) end-b*13- -t1.f-17,t1.c)),17)))"
    end, {
        -- <randexpr-2.482>
        227691
        -- </randexpr-2.482>
    })

test:do_test(
    "randexpr-2.483",
    function()
        return test:execsql "SELECT (abs((abs(t1.b*t1.b*t1.f+a)/abs(t1.f))*t1.a-case  -(abs(coalesce((select (case when 11*19 in (select count(*) from t1 union select  -min(13)-(max(t1.a)) from t1) then 19 else  -17 end) from t1 where t1.e between 13 and (a)),t1.b)+d)/abs(t1.f))-t1.b-t1.c & d when  -t1.f then c else 17 end)/abs(13))-b*t1.d FROM t1 WHERE NOT (13 in (t1.b,17*e+c*a,coalesce((select max(d) from t1 where +f+b not in (a,t1.a*~t1.c | t1.b-case when t1.a<=case when t1.f in (b,11,e) then d else t1.e end+f then 19 else (f) end-b*13- -t1.f-17,t1.c)),17)))"
    end, {
        -- <randexpr-2.483>
        227691
        -- </randexpr-2.483>
    })

test:do_test(
    "randexpr-2.484",
    function()
        return test:execsql "SELECT coalesce((select t1.c*f from t1 where t1.f-+coalesce((select max(t1.d) from t1 where  - -t1.e in (select f from t1 union select t1.e from t1)),a)+case when 19 not in (t1.e,case when ~t1.a<>e+a then  -t1.d else t1.e end,f) then t1.b when  -(t1.e) in (e,(19),t1.c) then t1.f else e end+17*t1.c+d>b),t1.c)+a FROM t1 WHERE t1.b>=~b"
    end, {
        -- <randexpr-2.484>
        180100
        -- </randexpr-2.484>
    })

test:do_test(
    "randexpr-2.485",
    function()
        return test:execsql "SELECT coalesce((select t1.c*f from t1 where t1.f-+coalesce((select max(t1.d) from t1 where  - -t1.e in (select f from t1 union select t1.e from t1)),a)+case when 19 not in (t1.e,case when ~t1.a<>e+a then  -t1.d else t1.e end,f) then t1.b when  -(t1.e) in (e,(19),t1.c) then t1.f else e end+17*t1.c+d>b),t1.c)+a FROM t1 WHERE NOT (t1.b>=~b)"
    end, {
        -- <randexpr-2.485>
        
        -- </randexpr-2.485>
    })

test:do_test(
    "randexpr-2.486",
    function()
        return test:execsql "SELECT case case when case when 13 between coalesce((select max(t1.f) from t1 where b+f in (b+(coalesce((select t1.f from t1 where (t1.c)>=17 or 19 not in (11,t1.e,c)),13)),b,t1.e) and c<=e and not t1.b<>13 and 19 not between t1.c and a or c between f and f),t1.c) and b then t1.b when 13<>t1.a then 11 else d end in (select 13 from t1 union select 19 from t1) then t1.c when t1.f not in (17,b,b) then t1.f else e end when t1.e then t1.e else  -d end FROM t1 WHERE case when not exists(select 1 from t1 where t1.f not between coalesce((select coalesce((select max(+case t1.a when f then t1.a else t1.e end+case when t1.f>t1.d or 11 in (t1.e,11,b) then b else a end) from t1 where t1.f in (select a from t1 union select d from t1)),t1.d) from t1 where t1.a=b),(t1.c)) and d) then (select case max(t1.a) when ~min((11)) | min(e) then max(t1.e) else abs(max(t1.c)*count(distinct 19)) end from t1) else t1.b end<>b"
    end, {
        -- <randexpr-2.486>
        
        -- </randexpr-2.486>
    })

test:do_test(
    "randexpr-2.487",
    function()
        return test:execsql "SELECT case case when case when 13 between coalesce((select max(t1.f) from t1 where b+f in (b+(coalesce((select t1.f from t1 where (t1.c)>=17 or 19 not in (11,t1.e,c)),13)),b,t1.e) and c<=e and not t1.b<>13 and 19 not between t1.c and a or c between f and f),t1.c) and b then t1.b when 13<>t1.a then 11 else d end in (select 13 from t1 union select 19 from t1) then t1.c when t1.f not in (17,b,b) then t1.f else e end when t1.e then t1.e else  -d end FROM t1 WHERE NOT (case when not exists(select 1 from t1 where t1.f not between coalesce((select coalesce((select max(+case t1.a when f then t1.a else t1.e end+case when t1.f>t1.d or 11 in (t1.e,11,b) then b else a end) from t1 where t1.f in (select a from t1 union select d from t1)),t1.d) from t1 where t1.a=b),(t1.c)) and d) then (select case max(t1.a) when ~min((11)) | min(e) then max(t1.e) else abs(max(t1.c)*count(distinct 19)) end from t1) else t1.b end<>b)"
    end, {
        -- <randexpr-2.487>
        -400
        -- </randexpr-2.487>
    })

test:do_test(
    "randexpr-2.488",
    function()
        return test:execsql "SELECT case  -coalesce((select max(case when case when t1.e in (11*t1.e*17,(select (min(b) |  - -+cast(avg(17) AS integer)*max((t1.c))+cast(avg(t1.a) AS integer))+(( -(min(t1.c))))*count(*) from t1), -~b*t1.d+t1.d) then d else t1.a end<(t1.c) then t1.f else e end) from t1 where 13<>c),e)-(t1.b) when t1.a then 17 else t1.f end FROM t1 WHERE coalesce((select max(t1.e) from t1 where (not exists(select 1 from t1 where b<+c))),case when b | ~case t1.a when  -t1.b then  -t1.f else t1.f end*f+f in (select t1.b from t1 union select t1.c from t1) then  -(t1.f) when a<>11 then (d) else 11 end) in (select abs(~(abs(case (min(t1.b)*abs(count(distinct a)+count(*) |  -count(distinct a)))- -max(19) when max(t1.e) then min(d) else (max(a)) end))) from t1 union select count(*) from t1)"
    end, {
        -- <randexpr-2.488>
        
        -- </randexpr-2.488>
    })

test:do_test(
    "randexpr-2.489",
    function()
        return test:execsql "SELECT case  -coalesce((select max(case when case when t1.e in (11*t1.e*17,(select (min(b) |  - -+cast(avg(17) AS integer)*max((t1.c))+cast(avg(t1.a) AS integer))+(( -(min(t1.c))))*count(*) from t1), -~b*t1.d+t1.d) then d else t1.a end<(t1.c) then t1.f else e end) from t1 where 13<>c),e)-(t1.b) when t1.a then 17 else t1.f end FROM t1 WHERE NOT (coalesce((select max(t1.e) from t1 where (not exists(select 1 from t1 where b<+c))),case when b | ~case t1.a when  -t1.b then  -t1.f else t1.f end*f+f in (select t1.b from t1 union select t1.c from t1) then  -(t1.f) when a<>11 then (d) else 11 end) in (select abs(~(abs(case (min(t1.b)*abs(count(distinct a)+count(*) |  -count(distinct a)))- -max(19) when max(t1.e) then min(d) else (max(a)) end))) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.489>
        600
        -- </randexpr-2.489>
    })

test:do_test(
    "randexpr-2.490",
    function()
        return test:execsql "SELECT case  -coalesce((select max(case when case when t1.e in (11*t1.e*17,(select (min(b) &  - -+cast(avg(17) AS integer)*max((t1.c))+cast(avg(t1.a) AS integer))+(( -(min(t1.c))))*count(*) from t1), -~b*t1.d+t1.d) then d else t1.a end<(t1.c) then t1.f else e end) from t1 where 13<>c),e)-(t1.b) when t1.a then 17 else t1.f end FROM t1 WHERE NOT (coalesce((select max(t1.e) from t1 where (not exists(select 1 from t1 where b<+c))),case when b | ~case t1.a when  -t1.b then  -t1.f else t1.f end*f+f in (select t1.b from t1 union select t1.c from t1) then  -(t1.f) when a<>11 then (d) else 11 end) in (select abs(~(abs(case (min(t1.b)*abs(count(distinct a)+count(*) |  -count(distinct a)))- -max(19) when max(t1.e) then min(d) else (max(a)) end))) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.490>
        600
        -- </randexpr-2.490>
    })

test:do_test(
    "randexpr-2.491",
    function()
        return test:execsql "SELECT +case when case when ~t1.b<=case when ~17*19 | 11*11*f between t1.c and b then t1.a when e in (t1.a,t1.e,e) then t1.c else 19 end-t1.c-17+a then (t1.d) when 13 not between 13 and 19 then c else c end=(f) or d<t1.f then  -t1.f else t1.d end FROM t1 WHERE 19*++t1.e=coalesce((select case  -t1.f when case when d-t1.a*d*coalesce((select max(t1.d) from t1 where b-b> -coalesce((select t1.b from t1 where c*13+c<>t1.f),a)),t1.e)+t1.f=t1.f then  - - -f else b end then  -11 else  -d end from t1 where ( -t1.c<f)),t1.e)+19"
    end, {
        -- <randexpr-2.491>
        
        -- </randexpr-2.491>
    })

test:do_test(
    "randexpr-2.492",
    function()
        return test:execsql "SELECT +case when case when ~t1.b<=case when ~17*19 | 11*11*f between t1.c and b then t1.a when e in (t1.a,t1.e,e) then t1.c else 19 end-t1.c-17+a then (t1.d) when 13 not between 13 and 19 then c else c end=(f) or d<t1.f then  -t1.f else t1.d end FROM t1 WHERE NOT (19*++t1.e=coalesce((select case  -t1.f when case when d-t1.a*d*coalesce((select max(t1.d) from t1 where b-b> -coalesce((select t1.b from t1 where c*13+c<>t1.f),a)),t1.e)+t1.f=t1.f then  - - -f else b end then  -11 else  -d end from t1 where ( -t1.c<f)),t1.e)+19)"
    end, {
        -- <randexpr-2.492>
        -600
        -- </randexpr-2.492>
    })

test:do_test(
    "randexpr-2.493",
    function()
        return test:execsql "SELECT +case when case when ~t1.b<=case when ~17*19 & 11*11*f between t1.c and b then t1.a when e in (t1.a,t1.e,e) then t1.c else 19 end-t1.c-17+a then (t1.d) when 13 not between 13 and 19 then c else c end=(f) or d<t1.f then  -t1.f else t1.d end FROM t1 WHERE NOT (19*++t1.e=coalesce((select case  -t1.f when case when d-t1.a*d*coalesce((select max(t1.d) from t1 where b-b> -coalesce((select t1.b from t1 where c*13+c<>t1.f),a)),t1.e)+t1.f=t1.f then  - - -f else b end then  -11 else  -d end from t1 where ( -t1.c<f)),t1.e)+19)"
    end, {
        -- <randexpr-2.493>
        -600
        -- </randexpr-2.493>
    })

test:do_test(
    "randexpr-2.494",
    function()
        return test:execsql "SELECT case when case when 19 in (select abs(abs(count(distinct f))*~~~count(*)-abs(+abs(count(*))* -cast(avg(17) AS integer) | cast(avg(t1.d) AS integer))+count(distinct  -t1.a)+count(*)) from t1 union select  -cast(avg(19) AS integer) from t1) then b* -b-c else t1.e*c end=17 then d else coalesce((select  -11 from t1 where e<e),a)-c end+d*t1.a FROM t1 WHERE (a-t1.b+19<>case when b between ~11 and (abs(case when (coalesce((select max(+13) from t1 where not not exists(select 1 from t1 where t1.b+e in (b,t1.b,t1.d)) and 13 not in (d,f,17)),t1.a) not in (t1.f,17,17)) then coalesce((select max(19) from t1 where (17) in (t1.a,17,a)),t1.b) when b in (13,t1.a,b) then t1.c else d end)/abs(11)) then t1.f when t1.d>19 then d else d end)"
    end, {
        -- <randexpr-2.494>
        39800
        -- </randexpr-2.494>
    })

test:do_test(
    "randexpr-2.495",
    function()
        return test:execsql "SELECT case when case when 19 in (select abs(abs(count(distinct f))*~~~count(*)-abs(+abs(count(*))* -cast(avg(17) AS integer) | cast(avg(t1.d) AS integer))+count(distinct  -t1.a)+count(*)) from t1 union select  -cast(avg(19) AS integer) from t1) then b* -b-c else t1.e*c end=17 then d else coalesce((select  -11 from t1 where e<e),a)-c end+d*t1.a FROM t1 WHERE NOT ((a-t1.b+19<>case when b between ~11 and (abs(case when (coalesce((select max(+13) from t1 where not not exists(select 1 from t1 where t1.b+e in (b,t1.b,t1.d)) and 13 not in (d,f,17)),t1.a) not in (t1.f,17,17)) then coalesce((select max(19) from t1 where (17) in (t1.a,17,a)),t1.b) when b in (13,t1.a,b) then t1.c else d end)/abs(11)) then t1.f when t1.d>19 then d else d end))"
    end, {
        -- <randexpr-2.495>
        
        -- </randexpr-2.495>
    })

test:do_test(
    "randexpr-2.496",
    function()
        return test:execsql "SELECT case when case when 19 in (select abs(abs(count(distinct f))*~~~count(*)-abs(+abs(count(*))* -cast(avg(17) AS integer) & cast(avg(t1.d) AS integer))+count(distinct  -t1.a)+count(*)) from t1 union select  -cast(avg(19) AS integer) from t1) then b* -b-c else t1.e*c end=17 then d else coalesce((select  -11 from t1 where e<e),a)-c end+d*t1.a FROM t1 WHERE (a-t1.b+19<>case when b between ~11 and (abs(case when (coalesce((select max(+13) from t1 where not not exists(select 1 from t1 where t1.b+e in (b,t1.b,t1.d)) and 13 not in (d,f,17)),t1.a) not in (t1.f,17,17)) then coalesce((select max(19) from t1 where (17) in (t1.a,17,a)),t1.b) when b in (13,t1.a,b) then t1.c else d end)/abs(11)) then t1.f when t1.d>19 then d else d end)"
    end, {
        -- <randexpr-2.496>
        39800
        -- </randexpr-2.496>
    })

test:do_test(
    "randexpr-2.497",
    function()
        return test:execsql "SELECT t1.a-coalesce((select t1.e from t1 where not exists(select 1 from t1 where a in (select min(d-11) | cast(avg((select  -case count(*) when count(*) then +abs(+case ~min((abs(13- -a)/abs(t1.c))) when ~~count(*)+min((13)) then max(t1.e) else cast(avg(t1.a) AS integer) end | max(c))+count(*) else count(*) end*max(t1.d) from t1)) AS integer)+max(t1.c)*count(distinct f) from t1 union select  -count(*) from t1))),~17) FROM t1 WHERE case 11 when coalesce((select coalesce((select 19 from t1 where t1.b not between t1.e and e and not not exists(select 1 from t1 where (e in ((abs(c)/abs(17)),(d) | e,(select count(distinct t1.b) from t1)-b)))),case d when a then f else t1.c end) | (t1.d) | b from t1 where t1.c not in (t1.a,19,11)),t1.b)-d then t1.e else t1.d end*t1.d<>f"
    end, {
        -- <randexpr-2.497>
        -400
        -- </randexpr-2.497>
    })

test:do_test(
    "randexpr-2.498",
    function()
        return test:execsql "SELECT t1.a-coalesce((select t1.e from t1 where not exists(select 1 from t1 where a in (select min(d-11) | cast(avg((select  -case count(*) when count(*) then +abs(+case ~min((abs(13- -a)/abs(t1.c))) when ~~count(*)+min((13)) then max(t1.e) else cast(avg(t1.a) AS integer) end | max(c))+count(*) else count(*) end*max(t1.d) from t1)) AS integer)+max(t1.c)*count(distinct f) from t1 union select  -count(*) from t1))),~17) FROM t1 WHERE NOT (case 11 when coalesce((select coalesce((select 19 from t1 where t1.b not between t1.e and e and not not exists(select 1 from t1 where (e in ((abs(c)/abs(17)),(d) | e,(select count(distinct t1.b) from t1)-b)))),case d when a then f else t1.c end) | (t1.d) | b from t1 where t1.c not in (t1.a,19,11)),t1.b)-d then t1.e else t1.d end*t1.d<>f)"
    end, {
        -- <randexpr-2.498>
        
        -- </randexpr-2.498>
    })

test:do_test(
    "randexpr-2.499",
    function()
        return test:execsql "SELECT t1.a-coalesce((select t1.e from t1 where not exists(select 1 from t1 where a in (select min(d-11) & cast(avg((select  -case count(*) when count(*) then +abs(+case ~min((abs(13- -a)/abs(t1.c))) when ~~count(*)+min((13)) then max(t1.e) else cast(avg(t1.a) AS integer) end & max(c))+count(*) else count(*) end*max(t1.d) from t1)) AS integer)+max(t1.c)*count(distinct f) from t1 union select  -count(*) from t1))),~17) FROM t1 WHERE case 11 when coalesce((select coalesce((select 19 from t1 where t1.b not between t1.e and e and not not exists(select 1 from t1 where (e in ((abs(c)/abs(17)),(d) | e,(select count(distinct t1.b) from t1)-b)))),case d when a then f else t1.c end) | (t1.d) | b from t1 where t1.c not in (t1.a,19,11)),t1.b)-d then t1.e else t1.d end*t1.d<>f"
    end, {
        -- <randexpr-2.499>
        -400
        -- </randexpr-2.499>
    })

test:do_test(
    "randexpr-2.500",
    function()
        return test:execsql "SELECT case b*coalesce((select coalesce((select max(coalesce((select t1.b from t1 where t1.a<>11),17+~19)) from t1 where (t1.e<>e)),case 13 when 17 then 13 else c-coalesce((select max(case when (select min(d) from t1) in (select max(13) from t1 union select min(t1.f) from t1) then 13 else t1.a end*c) from t1 where t1.b<(t1.b)),f) end) from t1 where 19<=t1.e),(t1.b)) when t1.b then e else t1.d end+t1.c FROM t1 WHERE b+coalesce((select max((d)) from t1 where e=b),t1.c)*((select  -(min(coalesce((select 19+(abs((abs((t1.a)*case f when c then t1.b else t1.d end-e)/abs((t1.f))))/abs( -t1.e))+b from t1 where 13 not between d and t1.c),t1.f))) from t1))*case e when 19 then t1.d else t1.b end+t1.e not in (t1.d,t1.a,17)"
    end, {
        -- <randexpr-2.500>
        700
        -- </randexpr-2.500>
    })

test:do_test(
    "randexpr-2.501",
    function()
        return test:execsql "SELECT case b*coalesce((select coalesce((select max(coalesce((select t1.b from t1 where t1.a<>11),17+~19)) from t1 where (t1.e<>e)),case 13 when 17 then 13 else c-coalesce((select max(case when (select min(d) from t1) in (select max(13) from t1 union select min(t1.f) from t1) then 13 else t1.a end*c) from t1 where t1.b<(t1.b)),f) end) from t1 where 19<=t1.e),(t1.b)) when t1.b then e else t1.d end+t1.c FROM t1 WHERE NOT (b+coalesce((select max((d)) from t1 where e=b),t1.c)*((select  -(min(coalesce((select 19+(abs((abs((t1.a)*case f when c then t1.b else t1.d end-e)/abs((t1.f))))/abs( -t1.e))+b from t1 where 13 not between d and t1.c),t1.f))) from t1))*case e when 19 then t1.d else t1.b end+t1.e not in (t1.d,t1.a,17))"
    end, {
        -- <randexpr-2.501>
        
        -- </randexpr-2.501>
    })

test:do_test(
    "randexpr-2.502",
    function()
        return test:execsql "SELECT case when case when exists(select 1 from t1 where 17 in (select b from t1 union select 13 from t1)) and 19+a in (select count(distinct  -(select min(t1.a-f) from t1)) from t1 union select min(case when 11 between coalesce((select max(t1.b) from t1 where case when t1.d<>c or t1.b>=t1.a then ( -11) else t1.d end>=t1.a),t1.c) and  -17 then  -t1.f else e end) from t1) then a else 19 end+t1.e in (select e from t1 union select  -t1.b from t1) then t1.b when not (f) between f and t1.c then t1.e else e end FROM t1 WHERE 17>coalesce((select t1.b from t1 where t1.a+case when b in (19,t1.c,case t1.e when d-(b) then t1.f else 13 end) then 13 when d in (select count(distinct t1.a) from t1 union select case ~max(f) when cast(avg(b) AS integer) then max(d) else min(t1.f) end*min(e) from t1) or (t1.c<a) then t1.f else  -t1.c end<f or 13<=f),c) or 19>=t1.e"
    end, {
        -- <randexpr-2.502>
        
        -- </randexpr-2.502>
    })

test:do_test(
    "randexpr-2.503",
    function()
        return test:execsql "SELECT case when case when exists(select 1 from t1 where 17 in (select b from t1 union select 13 from t1)) and 19+a in (select count(distinct  -(select min(t1.a-f) from t1)) from t1 union select min(case when 11 between coalesce((select max(t1.b) from t1 where case when t1.d<>c or t1.b>=t1.a then ( -11) else t1.d end>=t1.a),t1.c) and  -17 then  -t1.f else e end) from t1) then a else 19 end+t1.e in (select e from t1 union select  -t1.b from t1) then t1.b when not (f) between f and t1.c then t1.e else e end FROM t1 WHERE NOT (17>coalesce((select t1.b from t1 where t1.a+case when b in (19,t1.c,case t1.e when d-(b) then t1.f else 13 end) then 13 when d in (select count(distinct t1.a) from t1 union select case ~max(f) when cast(avg(b) AS integer) then max(d) else min(t1.f) end*min(e) from t1) or (t1.c<a) then t1.f else  -t1.c end<f or 13<=f),c) or 19>=t1.e)"
    end, {
        -- <randexpr-2.503>
        500
        -- </randexpr-2.503>
    })

test:do_test(
    "randexpr-2.504",
    function()
        return test:execsql "SELECT c*(select (count(distinct (abs(case when t1.c<>e then e else 19 end)/abs(case when case when +case when a | t1.e+t1.e in (select  -count(*) from t1 union select (max(case when 11 not in (t1.f,11,f) then c when c not in (d,t1.f,t1.f) then  -t1.a else 13 end)) from t1) then 17 else 13 end>=t1.e then  -11 when (t1.f)>c then 11 else 11 end<=11 and not exists(select 1 from t1 where t1.a between t1.e and e) then 19 else (17) end)))) from t1) FROM t1 WHERE ((select  -case min(a-13*17+c*coalesce((select 19 from t1 where 19>=t1.d),(t1.b))+t1.e) when +(min(17)) then min(17) else +min(b) end* -cast(avg(19) AS integer)*count(*) from t1) not between a and d) and +c in (c,t1.d,d) or d<>t1.f"
    end, {
        -- <randexpr-2.504>
        300
        -- </randexpr-2.504>
    })

test:do_test(
    "randexpr-2.505",
    function()
        return test:execsql "SELECT c*(select (count(distinct (abs(case when t1.c<>e then e else 19 end)/abs(case when case when +case when a | t1.e+t1.e in (select  -count(*) from t1 union select (max(case when 11 not in (t1.f,11,f) then c when c not in (d,t1.f,t1.f) then  -t1.a else 13 end)) from t1) then 17 else 13 end>=t1.e then  -11 when (t1.f)>c then 11 else 11 end<=11 and not exists(select 1 from t1 where t1.a between t1.e and e) then 19 else (17) end)))) from t1) FROM t1 WHERE NOT (((select  -case min(a-13*17+c*coalesce((select 19 from t1 where 19>=t1.d),(t1.b))+t1.e) when +(min(17)) then min(17) else +min(b) end* -cast(avg(19) AS integer)*count(*) from t1) not between a and d) and +c in (c,t1.d,d) or d<>t1.f)"
    end, {
        -- <randexpr-2.505>
        
        -- </randexpr-2.505>
    })

test:do_test(
    "randexpr-2.506",
    function()
        return test:execsql "SELECT c*(select (count(distinct (abs(case when t1.c<>e then e else 19 end)/abs(case when case when +case when a & t1.e+t1.e in (select  -count(*) from t1 union select (max(case when 11 not in (t1.f,11,f) then c when c not in (d,t1.f,t1.f) then  -t1.a else 13 end)) from t1) then 17 else 13 end>=t1.e then  -11 when (t1.f)>c then 11 else 11 end<=11 and not exists(select 1 from t1 where t1.a between t1.e and e) then 19 else (17) end)))) from t1) FROM t1 WHERE ((select  -case min(a-13*17+c*coalesce((select 19 from t1 where 19>=t1.d),(t1.b))+t1.e) when +(min(17)) then min(17) else +min(b) end* -cast(avg(19) AS integer)*count(*) from t1) not between a and d) and +c in (c,t1.d,d) or d<>t1.f"
    end, {
        -- <randexpr-2.506>
        300
        -- </randexpr-2.506>
    })

test:do_test(
    "randexpr-2.507",
    function()
        return test:execsql "SELECT a*coalesce((select t1.d+17 from t1 where 13*case a when t1.a then 11 else  -t1.a-d-11-coalesce((select max(e-coalesce((select d from t1 where a<=t1.d*(coalesce((select max( -t1.d) from t1 where t1.f not in (11, -t1.d,17) and t1.a between (13) and c and e not in (t1.b,t1.b,b)),b))), -17)) from t1 where t1.b<>a),19)+t1.d+t1.c end<13),t1.e) FROM t1 WHERE t1.e not between f and 19"
    end, {
        -- <randexpr-2.507>
        50000
        -- </randexpr-2.507>
    })

test:do_test(
    "randexpr-2.508",
    function()
        return test:execsql "SELECT a*coalesce((select t1.d+17 from t1 where 13*case a when t1.a then 11 else  -t1.a-d-11-coalesce((select max(e-coalesce((select d from t1 where a<=t1.d*(coalesce((select max( -t1.d) from t1 where t1.f not in (11, -t1.d,17) and t1.a between (13) and c and e not in (t1.b,t1.b,b)),b))), -17)) from t1 where t1.b<>a),19)+t1.d+t1.c end<13),t1.e) FROM t1 WHERE NOT (t1.e not between f and 19)"
    end, {
        -- <randexpr-2.508>
        
        -- </randexpr-2.508>
    })

test:do_test(
    "randexpr-2.509",
    function()
        return test:execsql "SELECT 17 | case case when exists(select 1 from t1 where (not t1.d between a and f)) then t1.e when not (b=coalesce((select ~t1.c-case when (select (count(*))*(count(distinct t1.f)) from t1)>=11 then b else 19 end from t1 where not not (13<=e) and t1.b=t1.b),13)) then coalesce((select max((abs(11)/abs(t1.b))) from t1 where t1.a not between t1.e and t1.b),(t1.a)) else t1.a end when c then 13 else 19 end+b FROM t1 WHERE ~t1.a+t1.d+c*17 | (select max(t1.d)*abs(case (max(t1.f)+count(distinct t1.b))*(count(distinct f)) when count(distinct e) then  -min(t1.e) else min(t1.f) end)+max(b)+count(distinct t1.d) from t1) in (select max(t1.d*(19)) from t1 union select count(distinct case when t1.c+b in (select max(e) from t1 union select cast(avg(f) AS integer) from t1) then (17) when e not in (c,d,19) or 11=19 then (19) else t1.e end+t1.a) from t1)"
    end, {
        -- <randexpr-2.509>
        
        -- </randexpr-2.509>
    })

test:do_test(
    "randexpr-2.510",
    function()
        return test:execsql "SELECT 17 | case case when exists(select 1 from t1 where (not t1.d between a and f)) then t1.e when not (b=coalesce((select ~t1.c-case when (select (count(*))*(count(distinct t1.f)) from t1)>=11 then b else 19 end from t1 where not not (13<=e) and t1.b=t1.b),13)) then coalesce((select max((abs(11)/abs(t1.b))) from t1 where t1.a not between t1.e and t1.b),(t1.a)) else t1.a end when c then 13 else 19 end+b FROM t1 WHERE NOT (~t1.a+t1.d+c*17 | (select max(t1.d)*abs(case (max(t1.f)+count(distinct t1.b))*(count(distinct f)) when count(distinct e) then  -min(t1.e) else min(t1.f) end)+max(b)+count(distinct t1.d) from t1) in (select max(t1.d*(19)) from t1 union select count(distinct case when t1.c+b in (select max(e) from t1 union select cast(avg(f) AS integer) from t1) then (17) when e not in (c,d,19) or 11=19 then (19) else t1.e end+t1.a) from t1))"
    end, {
        -- <randexpr-2.510>
        219
        -- </randexpr-2.510>
    })

test:do_test(
    "randexpr-2.511",
    function()
        return test:execsql "SELECT 17 & case case when exists(select 1 from t1 where (not t1.d between a and f)) then t1.e when not (b=coalesce((select ~t1.c-case when (select (count(*))*(count(distinct t1.f)) from t1)>=11 then b else 19 end from t1 where not not (13<=e) and t1.b=t1.b),13)) then coalesce((select max((abs(11)/abs(t1.b))) from t1 where t1.a not between t1.e and t1.b),(t1.a)) else t1.a end when c then 13 else 19 end+b FROM t1 WHERE NOT (~t1.a+t1.d+c*17 | (select max(t1.d)*abs(case (max(t1.f)+count(distinct t1.b))*(count(distinct f)) when count(distinct e) then  -min(t1.e) else min(t1.f) end)+max(b)+count(distinct t1.d) from t1) in (select max(t1.d*(19)) from t1 union select count(distinct case when t1.c+b in (select max(e) from t1 union select cast(avg(f) AS integer) from t1) then (17) when e not in (c,d,19) or 11=19 then (19) else t1.e end+t1.a) from t1))"
    end, {
        -- <randexpr-2.511>
        17
        -- </randexpr-2.511>
    })

test:do_test(
    "randexpr-2.512",
    function()
        return test:execsql "SELECT case when coalesce((select max((+t1.a+17+11+case when (abs(19)/abs(t1.a)) in (select ~(case count(*) when min( -c) then count(distinct b) else count(*) end) from t1 union select  -min(t1.e) from t1) or 13>=t1.a then case c when 13 then t1.d else e end when  -t1.e<=t1.a then t1.c else t1.c end)) from t1 where not t1.c= -t1.f),b)=f and t1.e<=(t1.f) then ~(t1.a) when 17=e then 19 else t1.b end FROM t1 WHERE case when  -t1.f in (select (13) from t1 union select coalesce((select max(coalesce((select (~13) from t1 where t1.b>(11)),e*t1.c)) from t1 where (not (abs(t1.c)/abs(a))>=c)),t1.d) from t1) then  -t1.e+ -a-coalesce((select t1.d from t1 where not exists(select 1 from t1 where  -b=t1.f-f)),t1.c)*17 when 19<=11 then 19 else t1.d end>=b"
    end, {
        -- <randexpr-2.512>
        200
        -- </randexpr-2.512>
    })

test:do_test(
    "randexpr-2.513",
    function()
        return test:execsql "SELECT case when coalesce((select max((+t1.a+17+11+case when (abs(19)/abs(t1.a)) in (select ~(case count(*) when min( -c) then count(distinct b) else count(*) end) from t1 union select  -min(t1.e) from t1) or 13>=t1.a then case c when 13 then t1.d else e end when  -t1.e<=t1.a then t1.c else t1.c end)) from t1 where not t1.c= -t1.f),b)=f and t1.e<=(t1.f) then ~(t1.a) when 17=e then 19 else t1.b end FROM t1 WHERE NOT (case when  -t1.f in (select (13) from t1 union select coalesce((select max(coalesce((select (~13) from t1 where t1.b>(11)),e*t1.c)) from t1 where (not (abs(t1.c)/abs(a))>=c)),t1.d) from t1) then  -t1.e+ -a-coalesce((select t1.d from t1 where not exists(select 1 from t1 where  -b=t1.f-f)),t1.c)*17 when 19<=11 then 19 else t1.d end>=b)"
    end, {
        -- <randexpr-2.513>
        
        -- </randexpr-2.513>
    })

test:do_test(
    "randexpr-2.514",
    function()
        return test:execsql "SELECT +(case when t1.a<=a then t1.d when ((abs(t1.a)/abs((coalesce((select t1.e from t1 where t1.f>=t1.c),e))))) between coalesce((select case when not 19> -11 then (case when t1.d in (select e from t1 union select f from t1) then  -d when t1.b not between 11 and t1.d then (19) else c end) else t1.e end from t1 where not exists(select 1 from t1 where e not in (t1.d,a, -a)) and t1.d>t1.b),a) and t1.a then d else b end)-17 FROM t1 WHERE (+e*t1.d in (select (+abs(abs(min(~+b)-min(a)-case  -case abs(max(t1.c)) when max(e) then count(*) else count(distinct 19) end- -max(t1.a) when count(distinct t1.a) then (count(*)) else min(t1.f) end)))-(count(*)) from t1 union select max(t1.f) from t1) or ~c*case when not exists(select 1 from t1 where t1.f in (t1.f,t1.a,d)) then t1.c when t1.c<t1.d then (17) else e end+t1.b |  -((c)) not between a and 17)"
    end, {
        -- <randexpr-2.514>
        383
        -- </randexpr-2.514>
    })

test:do_test(
    "randexpr-2.515",
    function()
        return test:execsql "SELECT +(case when t1.a<=a then t1.d when ((abs(t1.a)/abs((coalesce((select t1.e from t1 where t1.f>=t1.c),e))))) between coalesce((select case when not 19> -11 then (case when t1.d in (select e from t1 union select f from t1) then  -d when t1.b not between 11 and t1.d then (19) else c end) else t1.e end from t1 where not exists(select 1 from t1 where e not in (t1.d,a, -a)) and t1.d>t1.b),a) and t1.a then d else b end)-17 FROM t1 WHERE NOT ((+e*t1.d in (select (+abs(abs(min(~+b)-min(a)-case  -case abs(max(t1.c)) when max(e) then count(*) else count(distinct 19) end- -max(t1.a) when count(distinct t1.a) then (count(*)) else min(t1.f) end)))-(count(*)) from t1 union select max(t1.f) from t1) or ~c*case when not exists(select 1 from t1 where t1.f in (t1.f,t1.a,d)) then t1.c when t1.c<t1.d then (17) else e end+t1.b |  -((c)) not between a and 17))"
    end, {
        -- <randexpr-2.515>
        
        -- </randexpr-2.515>
    })

test:do_test(
    "randexpr-2.516",
    function()
        return test:execsql "SELECT  -case when coalesce((select max(case when ~(+case when t1.b*t1.b>t1.e then t1.a when  -d=t1.e or t1.c not between t1.c and e then c else t1.d end)- -17 in (select a from t1 union select  -t1.e from t1) then 19 else a end) from t1 where t1.a in (select  -a from t1 union select 19 from t1)),t1.a)<>t1.d then 13 when a in (19,d,c) and a<11 then t1.a else b end+t1.a-t1.b FROM t1 WHERE c>=t1.e"
    end, {
        -- <randexpr-2.516>
        
        -- </randexpr-2.516>
    })

test:do_test(
    "randexpr-2.517",
    function()
        return test:execsql "SELECT  -case when coalesce((select max(case when ~(+case when t1.b*t1.b>t1.e then t1.a when  -d=t1.e or t1.c not between t1.c and e then c else t1.d end)- -17 in (select a from t1 union select  -t1.e from t1) then 19 else a end) from t1 where t1.a in (select  -a from t1 union select 19 from t1)),t1.a)<>t1.d then 13 when a in (19,d,c) and a<11 then t1.a else b end+t1.a-t1.b FROM t1 WHERE NOT (c>=t1.e)"
    end, {
        -- <randexpr-2.517>
        -113
        -- </randexpr-2.517>
    })

test:do_test(
    "randexpr-2.518",
    function()
        return test:execsql "SELECT coalesce((select case coalesce((select max(19) from t1 where +case when exists(select 1 from t1 where not exists(select 1 from t1 where not c in (case when e>=c then b else t1.b end,t1.b,t1.e))) then a-f+13-t1.f+19 when f>=t1.e then t1.e else t1.c end+17 in (select count(distinct 19) from t1 union select cast(avg(b) AS integer) | count(distinct 11)-count(*) from t1)),a) when b then 17 else c end from t1 where t1.f<=t1.e),t1.e) FROM t1 WHERE ~~+d-d*19*case ~(select count(*) from t1)-11 when 19 then  -+(abs(t1.a)/abs(a)) | (f)-(abs(+t1.c)/abs((select ~+max(13*e)+min(f)*count(distinct 13) from t1)))*t1.a else  -t1.f-t1.b end*t1.a not between  -e and t1.e"
    end, {
        -- <randexpr-2.518>
        500
        -- </randexpr-2.518>
    })

test:do_test(
    "randexpr-2.519",
    function()
        return test:execsql "SELECT coalesce((select case coalesce((select max(19) from t1 where +case when exists(select 1 from t1 where not exists(select 1 from t1 where not c in (case when e>=c then b else t1.b end,t1.b,t1.e))) then a-f+13-t1.f+19 when f>=t1.e then t1.e else t1.c end+17 in (select count(distinct 19) from t1 union select cast(avg(b) AS integer) | count(distinct 11)-count(*) from t1)),a) when b then 17 else c end from t1 where t1.f<=t1.e),t1.e) FROM t1 WHERE NOT (~~+d-d*19*case ~(select count(*) from t1)-11 when 19 then  -+(abs(t1.a)/abs(a)) | (f)-(abs(+t1.c)/abs((select ~+max(13*e)+min(f)*count(distinct 13) from t1)))*t1.a else  -t1.f-t1.b end*t1.a not between  -e and t1.e)"
    end, {
        -- <randexpr-2.519>
        
        -- </randexpr-2.519>
    })

test:do_test(
    "randexpr-2.520",
    function()
        return test:execsql "SELECT coalesce((select case coalesce((select max(19) from t1 where +case when exists(select 1 from t1 where not exists(select 1 from t1 where not c in (case when e>=c then b else t1.b end,t1.b,t1.e))) then a-f+13-t1.f+19 when f>=t1.e then t1.e else t1.c end+17 in (select count(distinct 19) from t1 union select cast(avg(b) AS integer) & count(distinct 11)-count(*) from t1)),a) when b then 17 else c end from t1 where t1.f<=t1.e),t1.e) FROM t1 WHERE ~~+d-d*19*case ~(select count(*) from t1)-11 when 19 then  -+(abs(t1.a)/abs(a)) | (f)-(abs(+t1.c)/abs((select ~+max(13*e)+min(f)*count(distinct 13) from t1)))*t1.a else  -t1.f-t1.b end*t1.a not between  -e and t1.e"
    end, {
        -- <randexpr-2.520>
        500
        -- </randexpr-2.520>
    })

test:do_test(
    "randexpr-2.521",
    function()
        return test:execsql "SELECT a*17+ -case when not exists(select 1 from t1 where 11=t1.d) then 11-b when case when t1.c<>t1.c++t1.a or t1.c*t1.a+d-f between 19 and case when not t1.e>=11 and t1.b<=t1.c then coalesce((select max(a) from t1 where 19=11),f) when f not in (t1.b,13,b) then f else  -d end then d else t1.c end in (select 17 from t1 union select d from t1) then 17 else b end FROM t1 WHERE  -(+~ -d++c+b)>=t1.a-case when coalesce((select t1.a-(select max(t1.e) from t1)-(abs(11)/abs(17))+t1.d from t1 where not (not exists(select 1 from t1 where c=t1.c)) or t1.b in (select abs(max(11)+count(*)) from t1 union select ((max(a))) from t1)),f)>=a then t1.f when d not in (11,c,17) then a else 19 end"
    end, {
        -- <randexpr-2.521>
        
        -- </randexpr-2.521>
    })

test:do_test(
    "randexpr-2.522",
    function()
        return test:execsql "SELECT a*17+ -case when not exists(select 1 from t1 where 11=t1.d) then 11-b when case when t1.c<>t1.c++t1.a or t1.c*t1.a+d-f between 19 and case when not t1.e>=11 and t1.b<=t1.c then coalesce((select max(a) from t1 where 19=11),f) when f not in (t1.b,13,b) then f else  -d end then d else t1.c end in (select 17 from t1 union select d from t1) then 17 else b end FROM t1 WHERE NOT ( -(+~ -d++c+b)>=t1.a-case when coalesce((select t1.a-(select max(t1.e) from t1)-(abs(11)/abs(17))+t1.d from t1 where not (not exists(select 1 from t1 where c=t1.c)) or t1.b in (select abs(max(11)+count(*)) from t1 union select ((max(a))) from t1)),f)>=a then t1.f when d not in (11,c,17) then a else 19 end)"
    end, {
        -- <randexpr-2.522>
        1889
        -- </randexpr-2.522>
    })

test:do_test(
    "randexpr-2.523",
    function()
        return test:execsql "SELECT coalesce((select max(t1.b+a) from t1 where case (select count(distinct b*case when t1.f*+~a | b+17*13+a+11 in (select c from t1 union select d from t1) then t1.f else t1.b end) from t1) when t1.a then f else t1.c end+ -f between 17 and d and b in (13,t1.e,t1.e) and d not between t1.f and d),13) FROM t1 WHERE coalesce((select max(t1.d) from t1 where (coalesce((select ~t1.c from t1 where  -t1.a<=c*+d or not (case when (t1.b)>=t1.d then t1.e when 17<d then (a) else 11 end>a and a<>e and t1.e<t1.e) or 19<=t1.c),(c))+b*t1.c+17*t1.a | 11+(t1.f)>=19)),19)<>t1.c"
    end, {
        -- <randexpr-2.523>
        13
        -- </randexpr-2.523>
    })

test:do_test(
    "randexpr-2.524",
    function()
        return test:execsql "SELECT coalesce((select max(t1.b+a) from t1 where case (select count(distinct b*case when t1.f*+~a | b+17*13+a+11 in (select c from t1 union select d from t1) then t1.f else t1.b end) from t1) when t1.a then f else t1.c end+ -f between 17 and d and b in (13,t1.e,t1.e) and d not between t1.f and d),13) FROM t1 WHERE NOT (coalesce((select max(t1.d) from t1 where (coalesce((select ~t1.c from t1 where  -t1.a<=c*+d or not (case when (t1.b)>=t1.d then t1.e when 17<d then (a) else 11 end>a and a<>e and t1.e<t1.e) or 19<=t1.c),(c))+b*t1.c+17*t1.a | 11+(t1.f)>=19)),19)<>t1.c)"
    end, {
        -- <randexpr-2.524>
        
        -- </randexpr-2.524>
    })

test:do_test(
    "randexpr-2.525",
    function()
        return test:execsql "SELECT coalesce((select max(t1.b+a) from t1 where case (select count(distinct b*case when t1.f*+~a & b+17*13+a+11 in (select c from t1 union select d from t1) then t1.f else t1.b end) from t1) when t1.a then f else t1.c end+ -f between 17 and d and b in (13,t1.e,t1.e) and d not between t1.f and d),13) FROM t1 WHERE coalesce((select max(t1.d) from t1 where (coalesce((select ~t1.c from t1 where  -t1.a<=c*+d or not (case when (t1.b)>=t1.d then t1.e when 17<d then (a) else 11 end>a and a<>e and t1.e<t1.e) or 19<=t1.c),(c))+b*t1.c+17*t1.a | 11+(t1.f)>=19)),19)<>t1.c"
    end, {
        -- <randexpr-2.525>
        13
        -- </randexpr-2.525>
    })

test:do_test(
    "randexpr-2.526",
    function()
        return test:execsql "SELECT coalesce((select (t1.b-(abs(t1.b-~17 | 13+13)/abs(t1.e))* -t1.a- -19+t1.d) from t1 where exists(select 1 from t1 where 19 in (select t1.a from t1 union select  -19 from t1) and a in (c,e,13) and 19 in (select t1.a from t1 union select b from t1) or 13 in (select 19 from t1 union select d from t1) and not t1.c=t1.f or ( -t1.d between e and 19) or  -((17))<>c)),e) FROM t1 WHERE ((abs(a)/abs(f-a)) between  -(abs(++t1.b)/abs(13)) and t1.c)"
    end, {
        -- <randexpr-2.526>
        619
        -- </randexpr-2.526>
    })

test:do_test(
    "randexpr-2.527",
    function()
        return test:execsql "SELECT coalesce((select (t1.b-(abs(t1.b-~17 | 13+13)/abs(t1.e))* -t1.a- -19+t1.d) from t1 where exists(select 1 from t1 where 19 in (select t1.a from t1 union select  -19 from t1) and a in (c,e,13) and 19 in (select t1.a from t1 union select b from t1) or 13 in (select 19 from t1 union select d from t1) and not t1.c=t1.f or ( -t1.d between e and 19) or  -((17))<>c)),e) FROM t1 WHERE NOT (((abs(a)/abs(f-a)) between  -(abs(++t1.b)/abs(13)) and t1.c))"
    end, {
        -- <randexpr-2.527>
        
        -- </randexpr-2.527>
    })

test:do_test(
    "randexpr-2.528",
    function()
        return test:execsql "SELECT coalesce((select (t1.b-(abs(t1.b-~17 & 13+13)/abs(t1.e))* -t1.a- -19+t1.d) from t1 where exists(select 1 from t1 where 19 in (select t1.a from t1 union select  -19 from t1) and a in (c,e,13) and 19 in (select t1.a from t1 union select b from t1) or 13 in (select 19 from t1 union select d from t1) and not t1.c=t1.f or ( -t1.d between e and 19) or  -((17))<>c)),e) FROM t1 WHERE ((abs(a)/abs(f-a)) between  -(abs(++t1.b)/abs(13)) and t1.c)"
    end, {
        -- <randexpr-2.528>
        619
        -- </randexpr-2.528>
    })

test:do_test(
    "randexpr-2.529",
    function()
        return test:execsql "SELECT case when coalesce((select max(c- -b-t1.c) from t1 where t1.d between 11 and case when b | ~t1.e*(t1.f)>t1.f then a when (19<13) and not exists(select 1 from t1 where f not in (t1.a,((b)),17)) or d in ((a),t1.c,19) or (f)>13 then t1.e else f end*t1.a),t1.a)>=e then t1.d when t1.e>=c then 13 else f end FROM t1 WHERE +11 between case when t1.f>t1.c then t1.b else t1.b end and ((select count(distinct case when t1.a between (abs(coalesce((select t1.b from t1 where case when t1.d<=(abs((c))/abs(coalesce((select max(17) from t1 where 11=b),13))) then 17 when b=t1.e then d else e end-13>=(e)), -d))/abs(b)) and b then t1.d when (b) in (13,t1.b,t1.a) then f else 19 end) from t1))-d"
    end, {
        -- <randexpr-2.529>
        
        -- </randexpr-2.529>
    })

test:do_test(
    "randexpr-2.530",
    function()
        return test:execsql "SELECT case when coalesce((select max(c- -b-t1.c) from t1 where t1.d between 11 and case when b | ~t1.e*(t1.f)>t1.f then a when (19<13) and not exists(select 1 from t1 where f not in (t1.a,((b)),17)) or d in ((a),t1.c,19) or (f)>13 then t1.e else f end*t1.a),t1.a)>=e then t1.d when t1.e>=c then 13 else f end FROM t1 WHERE NOT (+11 between case when t1.f>t1.c then t1.b else t1.b end and ((select count(distinct case when t1.a between (abs(coalesce((select t1.b from t1 where case when t1.d<=(abs((c))/abs(coalesce((select max(17) from t1 where 11=b),13))) then 17 when b=t1.e then d else e end-13>=(e)), -d))/abs(b)) and b then t1.d when (b) in (13,t1.b,t1.a) then f else 19 end) from t1))-d)"
    end, {
        -- <randexpr-2.530>
        13
        -- </randexpr-2.530>
    })

test:do_test(
    "randexpr-2.531",
    function()
        return test:execsql "SELECT case when coalesce((select max(c- -b-t1.c) from t1 where t1.d between 11 and case when b & ~t1.e*(t1.f)>t1.f then a when (19<13) and not exists(select 1 from t1 where f not in (t1.a,((b)),17)) or d in ((a),t1.c,19) or (f)>13 then t1.e else f end*t1.a),t1.a)>=e then t1.d when t1.e>=c then 13 else f end FROM t1 WHERE NOT (+11 between case when t1.f>t1.c then t1.b else t1.b end and ((select count(distinct case when t1.a between (abs(coalesce((select t1.b from t1 where case when t1.d<=(abs((c))/abs(coalesce((select max(17) from t1 where 11=b),13))) then 17 when b=t1.e then d else e end-13>=(e)), -d))/abs(b)) and b then t1.d when (b) in (13,t1.b,t1.a) then f else 19 end) from t1))-d)"
    end, {
        -- <randexpr-2.531>
        13
        -- </randexpr-2.531>
    })

test:do_test(
    "randexpr-2.532",
    function()
        return test:execsql "SELECT (select ~abs(max(case when (case when ( -t1.a>e) then t1.a else (select (~count(*) | max(case when t1.d<>c then  -+13 else case when b between 19 and 17 or (t1.a)>=13 then 19 else t1.c end end)) from t1) end<>t1.e) then 19 when c*e+t1.b<=19 then f else (t1.d) end | b)) from t1)+c FROM t1 WHERE f | t1.a+b>=t1.d"
    end, {
        -- <randexpr-2.532>
        80
        -- </randexpr-2.532>
    })

test:do_test(
    "randexpr-2.533",
    function()
        return test:execsql "SELECT (select ~abs(max(case when (case when ( -t1.a>e) then t1.a else (select (~count(*) | max(case when t1.d<>c then  -+13 else case when b between 19 and 17 or (t1.a)>=13 then 19 else t1.c end end)) from t1) end<>t1.e) then 19 when c*e+t1.b<=19 then f else (t1.d) end | b)) from t1)+c FROM t1 WHERE NOT (f | t1.a+b>=t1.d)"
    end, {
        -- <randexpr-2.533>
        
        -- </randexpr-2.533>
    })

test:do_test(
    "randexpr-2.534",
    function()
        return test:execsql "SELECT (select ~abs(max(case when (case when ( -t1.a>e) then t1.a else (select (~count(*) & max(case when t1.d<>c then  -+13 else case when b between 19 and 17 or (t1.a)>=13 then 19 else t1.c end end)) from t1) end<>t1.e) then 19 when c*e+t1.b<=19 then f else (t1.d) end & b)) from t1)+c FROM t1 WHERE f | t1.a+b>=t1.d"
    end, {
        -- <randexpr-2.534>
        299
        -- </randexpr-2.534>
    })

test:do_test(
    "randexpr-2.535",
    function()
        return test:execsql "SELECT  -case when ~case t1.f+13+t1.a when coalesce((select max(17) from t1 where coalesce((select max(( -11)) from t1 where not exists(select 1 from t1 where case case when not exists(select 1 from t1 where (a in (select f from t1 union select b from t1))) then d when (a) in (f,t1.a, -f) then t1.a else b end when t1.d then c else t1.b end<>a and 11= -t1.a and 19=a)),11) in (select c from t1 union select 17 from t1)),t1.c) then e else 11 end=t1.d then 17 else 17 end FROM t1 WHERE not exists(select 1 from t1 where f<d or exists(select 1 from t1 where ~t1.a not between coalesce((select max(case b+(select  -case max(t1.b)- -count(distinct c)*max(t1.b) when min(17) then (count(*)) else cast(avg(t1.d) AS integer) end*max(f) from t1)+case when (abs((abs(19)/abs(e)))/abs(t1.d))*t1.a not between b and 13 then e else (e) end when d then b else 17 end) from t1 where t1.c between b and t1.f),t1.b) and a))"
    end, {
        -- <randexpr-2.535>
        
        -- </randexpr-2.535>
    })

test:do_test(
    "randexpr-2.536",
    function()
        return test:execsql "SELECT  -case when ~case t1.f+13+t1.a when coalesce((select max(17) from t1 where coalesce((select max(( -11)) from t1 where not exists(select 1 from t1 where case case when not exists(select 1 from t1 where (a in (select f from t1 union select b from t1))) then d when (a) in (f,t1.a, -f) then t1.a else b end when t1.d then c else t1.b end<>a and 11= -t1.a and 19=a)),11) in (select c from t1 union select 17 from t1)),t1.c) then e else 11 end=t1.d then 17 else 17 end FROM t1 WHERE NOT (not exists(select 1 from t1 where f<d or exists(select 1 from t1 where ~t1.a not between coalesce((select max(case b+(select  -case max(t1.b)- -count(distinct c)*max(t1.b) when min(17) then (count(*)) else cast(avg(t1.d) AS integer) end*max(f) from t1)+case when (abs((abs(19)/abs(e)))/abs(t1.d))*t1.a not between b and 13 then e else (e) end when d then b else 17 end) from t1 where t1.c between b and t1.f),t1.b) and a)))"
    end, {
        -- <randexpr-2.536>
        -17
        -- </randexpr-2.536>
    })

test:do_test(
    "randexpr-2.537",
    function()
        return test:execsql "SELECT t1.f-t1.b | coalesce((select max((select max(case  -case when t1.f>coalesce((select max(case when (17> -t1.e) then f when 19=t1.a then t1.a else a end) from t1 where t1.c<=t1.e or (t1.d)>=t1.d),t1.a)+a then f when b not in (e,t1.e,t1.b) or t1.f not in (f,t1.c, -d) or e<=13 then f else (17) end-t1.d+t1.f*13 when (t1.c) then b else  -t1.e end) from t1)) from t1 where t1.b in (t1.b,t1.f,(t1.e))),t1.e)*(a) FROM t1 WHERE t1.f<=a"
    end, {
        -- <randexpr-2.537>
        
        -- </randexpr-2.537>
    })

test:do_test(
    "randexpr-2.538",
    function()
        return test:execsql "SELECT t1.f-t1.b | coalesce((select max((select max(case  -case when t1.f>coalesce((select max(case when (17> -t1.e) then f when 19=t1.a then t1.a else a end) from t1 where t1.c<=t1.e or (t1.d)>=t1.d),t1.a)+a then f when b not in (e,t1.e,t1.b) or t1.f not in (f,t1.c, -d) or e<=13 then f else (17) end-t1.d+t1.f*13 when (t1.c) then b else  -t1.e end) from t1)) from t1 where t1.b in (t1.b,t1.f,(t1.e))),t1.e)*(a) FROM t1 WHERE NOT (t1.f<=a)"
    end, {
        -- <randexpr-2.538>
        -49744
        -- </randexpr-2.538>
    })

test:do_test(
    "randexpr-2.539",
    function()
        return test:execsql "SELECT t1.f-t1.b & coalesce((select max((select max(case  -case when t1.f>coalesce((select max(case when (17> -t1.e) then f when 19=t1.a then t1.a else a end) from t1 where t1.c<=t1.e or (t1.d)>=t1.d),t1.a)+a then f when b not in (e,t1.e,t1.b) or t1.f not in (f,t1.c, -d) or e<=13 then f else (17) end-t1.d+t1.f*13 when (t1.c) then b else  -t1.e end) from t1)) from t1 where t1.b in (t1.b,t1.f,(t1.e))),t1.e)*(a) FROM t1 WHERE NOT (t1.f<=a)"
    end, {
        -- <randexpr-2.539>
        144
        -- </randexpr-2.539>
    })

test:do_test(
    "randexpr-2.540",
    function()
        return test:execsql "SELECT t1.e+t1.a*case when not t1.f<=d-(c)*13 then t1.e+13*(abs(case when exists(select 1 from t1 where (select  -count(*)* -max(t1.a) | ((((cast(avg((e)) AS integer))))) from t1)>=+c+b) then +11 when t1.a not between t1.c and c then t1.b else  -19 end)/abs(b)) | (19) when not exists(select 1 from t1 where t1.c between t1.e and t1.c) then d else t1.f end FROM t1 WHERE b in (+c,case b when f*~19-t1.b*t1.f then t1.f else a end,a | t1.a)"
    end, {
        -- <randexpr-2.540>
        
        -- </randexpr-2.540>
    })

test:do_test(
    "randexpr-2.541",
    function()
        return test:execsql "SELECT t1.e+t1.a*case when not t1.f<=d-(c)*13 then t1.e+13*(abs(case when exists(select 1 from t1 where (select  -count(*)* -max(t1.a) | ((((cast(avg((e)) AS integer))))) from t1)>=+c+b) then +11 when t1.a not between t1.c and c then t1.b else  -19 end)/abs(b)) | (19) when not exists(select 1 from t1 where t1.c between t1.e and t1.c) then d else t1.f end FROM t1 WHERE NOT (b in (+c,case b when f*~19-t1.b*t1.f then t1.f else a end,a | t1.a))"
    end, {
        -- <randexpr-2.541>
        50800
        -- </randexpr-2.541>
    })

test:do_test(
    "randexpr-2.542",
    function()
        return test:execsql "SELECT t1.e+t1.a*case when not t1.f<=d-(c)*13 then t1.e+13*(abs(case when exists(select 1 from t1 where (select  -count(*)* -max(t1.a) & ((((cast(avg((e)) AS integer))))) from t1)>=+c+b) then +11 when t1.a not between t1.c and c then t1.b else  -19 end)/abs(b)) & (19) when not exists(select 1 from t1 where t1.c between t1.e and t1.c) then d else t1.f end FROM t1 WHERE NOT (b in (+c,case b when f*~19-t1.b*t1.f then t1.f else a end,a | t1.a))"
    end, {
        -- <randexpr-2.542>
        600
        -- </randexpr-2.542>
    })

test:do_test(
    "randexpr-2.543",
    function()
        return test:execsql "SELECT t1.e++a-c-a+coalesce((select t1.e from t1 where 11=case when t1.f not between 13 and t1.b+a*t1.c then 17 when (select min((select cast(avg(17) AS integer)*max(d)-(cast(avg(c) AS integer))*count(distinct t1.b) from t1)) from t1)>=case coalesce((select t1.b | e from t1 where t1.d in (t1.c,17,t1.c)),a) when 13 then t1.a else 19 end then t1.a else e end),t1.d) FROM t1 WHERE +t1.a*t1.c between case when case coalesce((select max(+t1.f-t1.b*(select min((b))+count(distinct c) from t1)) from t1 where  -b between 11 and t1.b or b in (select  -max(19) from t1 union select  -count(*)+ -count(*) from t1) and 17=d),13)-t1.b*a when t1.b then (17) else c end>b then e else 11 end and ( -b) or t1.e not between a and 11"
    end, {
        -- <randexpr-2.543>
        600
        -- </randexpr-2.543>
    })

test:do_test(
    "randexpr-2.544",
    function()
        return test:execsql "SELECT t1.e++a-c-a+coalesce((select t1.e from t1 where 11=case when t1.f not between 13 and t1.b+a*t1.c then 17 when (select min((select cast(avg(17) AS integer)*max(d)-(cast(avg(c) AS integer))*count(distinct t1.b) from t1)) from t1)>=case coalesce((select t1.b | e from t1 where t1.d in (t1.c,17,t1.c)),a) when 13 then t1.a else 19 end then t1.a else e end),t1.d) FROM t1 WHERE NOT (+t1.a*t1.c between case when case coalesce((select max(+t1.f-t1.b*(select min((b))+count(distinct c) from t1)) from t1 where  -b between 11 and t1.b or b in (select  -max(19) from t1 union select  -count(*)+ -count(*) from t1) and 17=d),13)-t1.b*a when t1.b then (17) else c end>b then e else 11 end and ( -b) or t1.e not between a and 11)"
    end, {
        -- <randexpr-2.544>
        
        -- </randexpr-2.544>
    })

test:do_test(
    "randexpr-2.545",
    function()
        return test:execsql "SELECT t1.e++a-c-a+coalesce((select t1.e from t1 where 11=case when t1.f not between 13 and t1.b+a*t1.c then 17 when (select min((select cast(avg(17) AS integer)*max(d)-(cast(avg(c) AS integer))*count(distinct t1.b) from t1)) from t1)>=case coalesce((select t1.b & e from t1 where t1.d in (t1.c,17,t1.c)),a) when 13 then t1.a else 19 end then t1.a else e end),t1.d) FROM t1 WHERE +t1.a*t1.c between case when case coalesce((select max(+t1.f-t1.b*(select min((b))+count(distinct c) from t1)) from t1 where  -b between 11 and t1.b or b in (select  -max(19) from t1 union select  -count(*)+ -count(*) from t1) and 17=d),13)-t1.b*a when t1.b then (17) else c end>b then e else 11 end and ( -b) or t1.e not between a and 11"
    end, {
        -- <randexpr-2.545>
        600
        -- </randexpr-2.545>
    })

test:do_test(
    "randexpr-2.546",
    function()
        return test:execsql "SELECT (select case ~case count(*) when (count(distinct d)*min(17)+min(13)+min(11))-max(t1.a) then count(distinct  -13) else min(t1.c) end-max( - -t1.d)*count(*) when  -count(*) then count(*) else (cast(avg(e) AS integer)) end from t1)-case when a>b then t1.d+case when (e= -t1.a) and c<c then coalesce((select t1.f+f from t1 where t1.b not in (f,13,t1.b)),t1.d) else d end+ -t1.a-c+e else 19 end FROM t1 WHERE t1.b not between a and 11 and t1.c in (select +case count(*) when count(*)*cast(avg(13) AS integer) then min(~b-c-t1.e*(abs(a)/abs(case when t1.d>=(13) and t1.e<=c then 11 else t1.f end | t1.a)))-abs(abs(count(*)))-+~min(t1.e)+~count(distinct 11)* -count(*) | max(t1.d)-( -cast(avg(13) AS integer))*(min(e)) else  -min(t1.a) end from t1 union select max(t1.f) from t1)"
    end, {
        -- <randexpr-2.546>
        
        -- </randexpr-2.546>
    })

test:do_test(
    "randexpr-2.547",
    function()
        return test:execsql "SELECT (select case ~case count(*) when (count(distinct d)*min(17)+min(13)+min(11))-max(t1.a) then count(distinct  -13) else min(t1.c) end-max( - -t1.d)*count(*) when  -count(*) then count(*) else (cast(avg(e) AS integer)) end from t1)-case when a>b then t1.d+case when (e= -t1.a) and c<c then coalesce((select t1.f+f from t1 where t1.b not in (f,13,t1.b)),t1.d) else d end+ -t1.a-c+e else 19 end FROM t1 WHERE NOT (t1.b not between a and 11 and t1.c in (select +case count(*) when count(*)*cast(avg(13) AS integer) then min(~b-c-t1.e*(abs(a)/abs(case when t1.d>=(13) and t1.e<=c then 11 else t1.f end | t1.a)))-abs(abs(count(*)))-+~min(t1.e)+~count(distinct 11)* -count(*) | max(t1.d)-( -cast(avg(13) AS integer))*(min(e)) else  -min(t1.a) end from t1 union select max(t1.f) from t1))"
    end, {
        -- <randexpr-2.547>
        481
        -- </randexpr-2.547>
    })

test:do_test(
    "randexpr-2.548",
    function()
        return test:execsql "SELECT case ~case 19 when t1.e then f else 19*f end*case when exists(select 1 from t1 where t1.e not between t1.f-~case case  -e when f then t1.d else case when t1.b in (t1.e,f,11) then e when 11<=d then  -t1.d else 17 end end when 13 then 19 else c end and 19) then coalesce((select t1.b from t1 where not exists(select 1 from t1 where (a<>b))),b) else t1.c end | e+t1.b when a then f else 19 end FROM t1 WHERE 17 in (select count(distinct t1.f)+~min(coalesce((select max(e*f-case when case when 11<>e and t1.e<=t1.d or (t1.d)<=t1.e then d when ( -17) not between  -t1.c and t1.a then coalesce((select max((19)) from t1 where  -b between e and 11), -a) else d end in (b,t1.d,a) and 19 in (13,13,t1.c) or b not in (f,(t1.e),19) then t1.c when 17 not in ((19),(t1.b),f) then +t1.d else f end) from t1 where (not a between 19 and d and (d>a))),d)) from t1 union select cast(avg(f) AS integer) from t1)"
    end, {
        -- <randexpr-2.548>
        
        -- </randexpr-2.548>
    })

test:do_test(
    "randexpr-2.549",
    function()
        return test:execsql "SELECT case ~case 19 when t1.e then f else 19*f end*case when exists(select 1 from t1 where t1.e not between t1.f-~case case  -e when f then t1.d else case when t1.b in (t1.e,f,11) then e when 11<=d then  -t1.d else 17 end end when 13 then 19 else c end and 19) then coalesce((select t1.b from t1 where not exists(select 1 from t1 where (a<>b))),b) else t1.c end | e+t1.b when a then f else 19 end FROM t1 WHERE NOT (17 in (select count(distinct t1.f)+~min(coalesce((select max(e*f-case when case when 11<>e and t1.e<=t1.d or (t1.d)<=t1.e then d when ( -17) not between  -t1.c and t1.a then coalesce((select max((19)) from t1 where  -b between e and 11), -a) else d end in (b,t1.d,a) and 19 in (13,13,t1.c) or b not in (f,(t1.e),19) then t1.c when 17 not in ((19),(t1.b),f) then +t1.d else f end) from t1 where (not a between 19 and d and (d>a))),d)) from t1 union select cast(avg(f) AS integer) from t1))"
    end, {
        -- <randexpr-2.549>
        19
        -- </randexpr-2.549>
    })

test:do_test(
    "randexpr-2.550",
    function()
        return test:execsql "SELECT case ~case 19 when t1.e then f else 19*f end*case when exists(select 1 from t1 where t1.e not between t1.f-~case case  -e when f then t1.d else case when t1.b in (t1.e,f,11) then e when 11<=d then  -t1.d else 17 end end when 13 then 19 else c end and 19) then coalesce((select t1.b from t1 where not exists(select 1 from t1 where (a<>b))),b) else t1.c end & e+t1.b when a then f else 19 end FROM t1 WHERE NOT (17 in (select count(distinct t1.f)+~min(coalesce((select max(e*f-case when case when 11<>e and t1.e<=t1.d or (t1.d)<=t1.e then d when ( -17) not between  -t1.c and t1.a then coalesce((select max((19)) from t1 where  -b between e and 11), -a) else d end in (b,t1.d,a) and 19 in (13,13,t1.c) or b not in (f,(t1.e),19) then t1.c when 17 not in ((19),(t1.b),f) then +t1.d else f end) from t1 where (not a between 19 and d and (d>a))),d)) from t1 union select cast(avg(f) AS integer) from t1))"
    end, {
        -- <randexpr-2.550>
        19
        -- </randexpr-2.550>
    })

test:do_test(
    "randexpr-2.551",
    function()
        return test:execsql "SELECT (abs(11*coalesce((select max(t1.a) from t1 where d>=case when coalesce((select case when not exists(select 1 from t1 where  -d in (select b-(abs(13)/abs(t1.e)) from t1 union select e from t1)) then ~c when not exists(select 1 from t1 where not exists(select 1 from t1 where  -t1.d in (select cast(avg(c) AS integer) | count(distinct e)+max( -t1.d)-(max(f)) from t1 union select count(*) from t1))) then t1.a else e end from t1 where exists(select 1 from t1 where t1.f between d and t1.b) or 17 in (11,17,d)),11) not between t1.c and t1.d then 17 when 13=t1.a then 19 else (13) end), -t1.b)-e)/abs(a)) FROM t1 WHERE t1.c+t1.c=t1.f"
    end, {
        -- <randexpr-2.551>
        6
        -- </randexpr-2.551>
    })

test:do_test(
    "randexpr-2.552",
    function()
        return test:execsql "SELECT (abs(11*coalesce((select max(t1.a) from t1 where d>=case when coalesce((select case when not exists(select 1 from t1 where  -d in (select b-(abs(13)/abs(t1.e)) from t1 union select e from t1)) then ~c when not exists(select 1 from t1 where not exists(select 1 from t1 where  -t1.d in (select cast(avg(c) AS integer) | count(distinct e)+max( -t1.d)-(max(f)) from t1 union select count(*) from t1))) then t1.a else e end from t1 where exists(select 1 from t1 where t1.f between d and t1.b) or 17 in (11,17,d)),11) not between t1.c and t1.d then 17 when 13=t1.a then 19 else (13) end), -t1.b)-e)/abs(a)) FROM t1 WHERE NOT (t1.c+t1.c=t1.f)"
    end, {
        -- <randexpr-2.552>
        
        -- </randexpr-2.552>
    })

test:do_test(
    "randexpr-2.553",
    function()
        return test:execsql "SELECT (abs(11*coalesce((select max(t1.a) from t1 where d>=case when coalesce((select case when not exists(select 1 from t1 where  -d in (select b-(abs(13)/abs(t1.e)) from t1 union select e from t1)) then ~c when not exists(select 1 from t1 where not exists(select 1 from t1 where  -t1.d in (select cast(avg(c) AS integer) & count(distinct e)+max( -t1.d)-(max(f)) from t1 union select count(*) from t1))) then t1.a else e end from t1 where exists(select 1 from t1 where t1.f between d and t1.b) or 17 in (11,17,d)),11) not between t1.c and t1.d then 17 when 13=t1.a then 19 else (13) end), -t1.b)-e)/abs(a)) FROM t1 WHERE t1.c+t1.c=t1.f"
    end, {
        -- <randexpr-2.553>
        6
        -- </randexpr-2.553>
    })

test:do_test(
    "randexpr-2.554",
    function()
        return test:execsql "SELECT  -t1.a*coalesce((select max(c) from t1 where  -(17 | case when (select cast(avg(17+coalesce((select max(c) from t1 where exists(select 1 from t1 where (coalesce((select max( -f) from t1 where (t1.b<=t1.b)),t1.e)<>e))),f |  -t1.a)) AS integer) from t1) in (13,e,t1.c) then f when (f>e) then b else t1.a end)*c*e not between 19 and t1.b),11)+13-19*(19) FROM t1 WHERE (c<=t1.e)"
    end, {
        -- <randexpr-2.554>
        -30348
        -- </randexpr-2.554>
    })

test:do_test(
    "randexpr-2.555",
    function()
        return test:execsql "SELECT  -t1.a*coalesce((select max(c) from t1 where  -(17 | case when (select cast(avg(17+coalesce((select max(c) from t1 where exists(select 1 from t1 where (coalesce((select max( -f) from t1 where (t1.b<=t1.b)),t1.e)<>e))),f |  -t1.a)) AS integer) from t1) in (13,e,t1.c) then f when (f>e) then b else t1.a end)*c*e not between 19 and t1.b),11)+13-19*(19) FROM t1 WHERE NOT ((c<=t1.e))"
    end, {
        -- <randexpr-2.555>
        
        -- </randexpr-2.555>
    })

test:do_test(
    "randexpr-2.556",
    function()
        return test:execsql "SELECT  -t1.a*coalesce((select max(c) from t1 where  -(17 & case when (select cast(avg(17+coalesce((select max(c) from t1 where exists(select 1 from t1 where (coalesce((select max( -f) from t1 where (t1.b<=t1.b)),t1.e)<>e))),f &  -t1.a)) AS integer) from t1) in (13,e,t1.c) then f when (f>e) then b else t1.a end)*c*e not between 19 and t1.b),11)+13-19*(19) FROM t1 WHERE (c<=t1.e)"
    end, {
        -- <randexpr-2.556>
        -30348
        -- </randexpr-2.556>
    })

test:do_test(
    "randexpr-2.557",
    function()
        return test:execsql "SELECT 19-coalesce((select max(case when 17 | t1.a in (select case case coalesce((select max(t1.b) from t1 where t1.f not between case when  -b in (13,f,a) then a else a end and t1.f or (a not in (d,d,t1.c))),c) when a then t1.e else f end when 13 then 13 else b end from t1 union select 17 from t1) then c when not b not in (d, -t1.e,c) then 17 else b end) from t1 where e not in (17,t1.e,b)),t1.e) FROM t1 WHERE t1.a in (select  -count(*) from t1 union select min((select (cast(avg((select +max(t1.b) from t1)) AS integer)) from t1)+17*c) from t1)"
    end, {
        -- <randexpr-2.557>
        
        -- </randexpr-2.557>
    })

test:do_test(
    "randexpr-2.558",
    function()
        return test:execsql "SELECT 19-coalesce((select max(case when 17 | t1.a in (select case case coalesce((select max(t1.b) from t1 where t1.f not between case when  -b in (13,f,a) then a else a end and t1.f or (a not in (d,d,t1.c))),c) when a then t1.e else f end when 13 then 13 else b end from t1 union select 17 from t1) then c when not b not in (d, -t1.e,c) then 17 else b end) from t1 where e not in (17,t1.e,b)),t1.e) FROM t1 WHERE NOT (t1.a in (select  -count(*) from t1 union select min((select (cast(avg((select +max(t1.b) from t1)) AS integer)) from t1)+17*c) from t1))"
    end, {
        -- <randexpr-2.558>
        -481
        -- </randexpr-2.558>
    })

test:do_test(
    "randexpr-2.559",
    function()
        return test:execsql "SELECT 19-coalesce((select max(case when 17 & t1.a in (select case case coalesce((select max(t1.b) from t1 where t1.f not between case when  -b in (13,f,a) then a else a end and t1.f or (a not in (d,d,t1.c))),c) when a then t1.e else f end when 13 then 13 else b end from t1 union select 17 from t1) then c when not b not in (d, -t1.e,c) then 17 else b end) from t1 where e not in (17,t1.e,b)),t1.e) FROM t1 WHERE NOT (t1.a in (select  -count(*) from t1 union select min((select (cast(avg((select +max(t1.b) from t1)) AS integer)) from t1)+17*c) from t1))"
    end, {
        -- <randexpr-2.559>
        -481
        -- </randexpr-2.559>
    })

test:do_test(
    "randexpr-2.560",
    function()
        return test:execsql "SELECT  -f-coalesce((select max(case a-t1.a when t1.f then 13 else +t1.a-t1.f end) from t1 where (select count(distinct a) from t1)>d),( -~t1.a+17+case when (not exists(select 1 from t1 where c=t1.b and c>t1.d)) then ~coalesce((select t1.f from t1 where t1.e not between t1.b and t1.e),11)+a when b<=t1.d then t1.c else 11 end+t1.b)*d)*17+d FROM t1 WHERE +t1.c in (select max(~case when 17>t1.f then 19 else  -case when d=11 or t1.b> -t1.e or d not in (b,t1.a,t1.e) then e-( -13)+d else 11 end end-t1.d) from t1 union select max(17)+case min(t1.a) | case + -case abs(cast(avg(t1.d) AS integer)) when  -count(*) then count(*) else max(19) end when min(e) then count(*) else cast(avg(t1.c) AS integer) end when min(t1.f) then count(*) else min(b) end from t1)"
    end, {
        -- <randexpr-2.560>
        
        -- </randexpr-2.560>
    })

test:do_test(
    "randexpr-2.561",
    function()
        return test:execsql "SELECT  -f-coalesce((select max(case a-t1.a when t1.f then 13 else +t1.a-t1.f end) from t1 where (select count(distinct a) from t1)>d),( -~t1.a+17+case when (not exists(select 1 from t1 where c=t1.b and c>t1.d)) then ~coalesce((select t1.f from t1 where t1.e not between t1.b and t1.e),11)+a when b<=t1.d then t1.c else 11 end+t1.b)*d)*17+d FROM t1 WHERE NOT (+t1.c in (select max(~case when 17>t1.f then 19 else  -case when d=11 or t1.b> -t1.e or d not in (b,t1.a,t1.e) then e-( -13)+d else 11 end end-t1.d) from t1 union select max(17)+case min(t1.a) | case + -case abs(cast(avg(t1.d) AS integer)) when  -count(*) then count(*) else max(19) end when min(e) then count(*) else cast(avg(t1.c) AS integer) end when min(t1.f) then count(*) else min(b) end from t1))"
    end, {
        -- <randexpr-2.561>
        -2761000
        -- </randexpr-2.561>
    })

test:do_test(
    "randexpr-2.562",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where not (select +count(*)* -count(distinct case when exists(select 1 from t1 where 13+a=t1.b) then d else 13 end-t1.b) from t1)<=17 | e-13)) or not exists(select 1 from t1 where not t1.e in ((13),17,19) and not t1.d>a and t1.e not between t1.e and b)),coalesce((select max(coalesce((select max(b) from t1 where (b)>11),d)) from t1 where 11> -19),f)-c) FROM t1 WHERE case when  -13 not in (b,(abs(coalesce((select max(case when  -17<>t1.f then b when coalesce((select t1.b from t1 where t1.c in (select (a) from t1 union select c from t1)),17)<=t1.e then b else f end) from t1 where b<=11),t1.c))/abs((d))),19) then t1.b when (exists(select 1 from t1 where not exists(select 1 from t1 where ((13)=e and t1.f between 17 and t1.a) or t1.f between (a) and  -(t1.f)))) and t1.e between b and 13 or b<>(f) then t1.f else d end>=a or d>=13"
    end, {
        -- <randexpr-2.562>
        11
        -- </randexpr-2.562>
    })

test:do_test(
    "randexpr-2.563",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where not (select +count(*)* -count(distinct case when exists(select 1 from t1 where 13+a=t1.b) then d else 13 end-t1.b) from t1)<=17 | e-13)) or not exists(select 1 from t1 where not t1.e in ((13),17,19) and not t1.d>a and t1.e not between t1.e and b)),coalesce((select max(coalesce((select max(b) from t1 where (b)>11),d)) from t1 where 11> -19),f)-c) FROM t1 WHERE NOT (case when  -13 not in (b,(abs(coalesce((select max(case when  -17<>t1.f then b when coalesce((select t1.b from t1 where t1.c in (select (a) from t1 union select c from t1)),17)<=t1.e then b else f end) from t1 where b<=11),t1.c))/abs((d))),19) then t1.b when (exists(select 1 from t1 where not exists(select 1 from t1 where ((13)=e and t1.f between 17 and t1.a) or t1.f between (a) and  -(t1.f)))) and t1.e between b and 13 or b<>(f) then t1.f else d end>=a or d>=13)"
    end, {
        -- <randexpr-2.563>
        
        -- </randexpr-2.563>
    })

test:do_test(
    "randexpr-2.564",
    function()
        return test:execsql "SELECT coalesce((select 11 from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where not (select +count(*)* -count(distinct case when exists(select 1 from t1 where 13+a=t1.b) then d else 13 end-t1.b) from t1)<=17 & e-13)) or not exists(select 1 from t1 where not t1.e in ((13),17,19) and not t1.d>a and t1.e not between t1.e and b)),coalesce((select max(coalesce((select max(b) from t1 where (b)>11),d)) from t1 where 11> -19),f)-c) FROM t1 WHERE case when  -13 not in (b,(abs(coalesce((select max(case when  -17<>t1.f then b when coalesce((select t1.b from t1 where t1.c in (select (a) from t1 union select c from t1)),17)<=t1.e then b else f end) from t1 where b<=11),t1.c))/abs((d))),19) then t1.b when (exists(select 1 from t1 where not exists(select 1 from t1 where ((13)=e and t1.f between 17 and t1.a) or t1.f between (a) and  -(t1.f)))) and t1.e between b and 13 or b<>(f) then t1.f else d end>=a or d>=13"
    end, {
        -- <randexpr-2.564>
        11
        -- </randexpr-2.564>
    })

test:do_test(
    "randexpr-2.565",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13+f | c+a) from t1 where 17<t1.a),~case when 17 in (select count(distinct 11) from t1 union select ++cast(avg(a | 11) AS integer)-count(*) from t1) then t1.a else 17 end)) from t1 where case t1.d when 17 then t1.a else 17 end not between 13 and case t1.c when t1.b*case when t1.d<>d then 13 else c end-c then e else t1.e end),c) FROM t1 WHERE exists(select 1 from t1 where t1.a+( -case when exists(select 1 from t1 where exists(select 1 from t1 where b | c-c+t1.d not between 19 and 11)) then coalesce((select t1.c from t1 where c+17 in (f,13,c) or t1.e*coalesce((select case when (not exists(select 1 from t1 where 17>e)) then t1.d else ~t1.e end from t1 where (t1.f not in (19,a,t1.b) or c=f)),c)=c), -11) else e end)<=t1.b)"
    end, {
        -- <randexpr-2.565>
        300
        -- </randexpr-2.565>
    })

test:do_test(
    "randexpr-2.566",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13+f | c+a) from t1 where 17<t1.a),~case when 17 in (select count(distinct 11) from t1 union select ++cast(avg(a | 11) AS integer)-count(*) from t1) then t1.a else 17 end)) from t1 where case t1.d when 17 then t1.a else 17 end not between 13 and case t1.c when t1.b*case when t1.d<>d then 13 else c end-c then e else t1.e end),c) FROM t1 WHERE NOT (exists(select 1 from t1 where t1.a+( -case when exists(select 1 from t1 where exists(select 1 from t1 where b | c-c+t1.d not between 19 and 11)) then coalesce((select t1.c from t1 where c+17 in (f,13,c) or t1.e*coalesce((select case when (not exists(select 1 from t1 where 17>e)) then t1.d else ~t1.e end from t1 where (t1.f not in (19,a,t1.b) or c=f)),c)=c), -11) else e end)<=t1.b))"
    end, {
        -- <randexpr-2.566>
        
        -- </randexpr-2.566>
    })

test:do_test(
    "randexpr-2.567",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select max(13+f & c+a) from t1 where 17<t1.a),~case when 17 in (select count(distinct 11) from t1 union select ++cast(avg(a & 11) AS integer)-count(*) from t1) then t1.a else 17 end)) from t1 where case t1.d when 17 then t1.a else 17 end not between 13 and case t1.c when t1.b*case when t1.d<>d then 13 else c end-c then e else t1.e end),c) FROM t1 WHERE exists(select 1 from t1 where t1.a+( -case when exists(select 1 from t1 where exists(select 1 from t1 where b | c-c+t1.d not between 19 and 11)) then coalesce((select t1.c from t1 where c+17 in (f,13,c) or t1.e*coalesce((select case when (not exists(select 1 from t1 where 17>e)) then t1.d else ~t1.e end from t1 where (t1.f not in (19,a,t1.b) or c=f)),c)=c), -11) else e end)<=t1.b)"
    end, {
        -- <randexpr-2.567>
        300
        -- </randexpr-2.567>
    })

test:do_test(
    "randexpr-2.568",
    function()
        return test:execsql "SELECT case when ((coalesce((select max((select ~cast(avg((~d*f)) AS integer) from t1)) from t1 where  - -t1.f<>d),e) in (select cast(avg(+13) AS integer)*~count(*) | case count(*) when  -abs(abs(max(f))) then cast(avg(e) AS integer) else (count(distinct b)) end from t1 union select count(*) from t1) and b>= -t1.d)) then (17) when b between 13 and t1.d then  -e+t1.a else t1.f end FROM t1 WHERE (case when +t1.f-(select abs(count(distinct d)) from t1)*case when c in (select min(b) from t1 union select max(c+f*case 11*t1.b when b then t1.c else c end | t1.a) from t1) then d else f end | t1.a*b in (t1.d,17,a) then  -t1.a else t1.d end) in (e,t1.c,f) and  -((t1.c)) in (11,t1.e,t1.c)"
    end, {
        -- <randexpr-2.568>
        
        -- </randexpr-2.568>
    })

test:do_test(
    "randexpr-2.569",
    function()
        return test:execsql "SELECT case when ((coalesce((select max((select ~cast(avg((~d*f)) AS integer) from t1)) from t1 where  - -t1.f<>d),e) in (select cast(avg(+13) AS integer)*~count(*) | case count(*) when  -abs(abs(max(f))) then cast(avg(e) AS integer) else (count(distinct b)) end from t1 union select count(*) from t1) and b>= -t1.d)) then (17) when b between 13 and t1.d then  -e+t1.a else t1.f end FROM t1 WHERE NOT ((case when +t1.f-(select abs(count(distinct d)) from t1)*case when c in (select min(b) from t1 union select max(c+f*case 11*t1.b when b then t1.c else c end | t1.a) from t1) then d else f end | t1.a*b in (t1.d,17,a) then  -t1.a else t1.d end) in (e,t1.c,f) and  -((t1.c)) in (11,t1.e,t1.c))"
    end, {
        -- <randexpr-2.569>
        -400
        -- </randexpr-2.569>
    })

test:do_test(
    "randexpr-2.570",
    function()
        return test:execsql "SELECT case when ((coalesce((select max((select ~cast(avg((~d*f)) AS integer) from t1)) from t1 where  - -t1.f<>d),e) in (select cast(avg(+13) AS integer)*~count(*) & case count(*) when  -abs(abs(max(f))) then cast(avg(e) AS integer) else (count(distinct b)) end from t1 union select count(*) from t1) and b>= -t1.d)) then (17) when b between 13 and t1.d then  -e+t1.a else t1.f end FROM t1 WHERE NOT ((case when +t1.f-(select abs(count(distinct d)) from t1)*case when c in (select min(b) from t1 union select max(c+f*case 11*t1.b when b then t1.c else c end | t1.a) from t1) then d else f end | t1.a*b in (t1.d,17,a) then  -t1.a else t1.d end) in (e,t1.c,f) and  -((t1.c)) in (11,t1.e,t1.c))"
    end, {
        -- <randexpr-2.570>
        -400
        -- </randexpr-2.570>
    })

test:do_test(
    "randexpr-2.571",
    function()
        return test:execsql "SELECT t1.d-case when e in (17,coalesce((select max((select count(*) from t1)) from t1 where (~t1.f++19*t1.f+b in (a,t1.b, -t1.e)) and b in (select count(distinct t1.a) from t1 union select (abs(abs(abs(max(t1.e)*max(t1.d))-min(11)* -count(*)))) from t1)),17),13) and t1.f in (select t1.b from t1 union select f from t1) then t1.c else c end+f FROM t1 WHERE not (select (abs(abs((+count(*)*~ -cast(avg(+t1.f-c) AS integer)*count(distinct +coalesce((select max((abs(c)/abs(t1.e))) from t1 where coalesce((select coalesce((select max(f) from t1 where t1.d<=t1.d),e)*c from t1 where t1.f<>f),c) not between t1.a and c),t1.e)+13)-count(distinct f) | abs(cast(avg(t1.b) AS integer)))))) from t1)-13<t1.c"
    end, {
        -- <randexpr-2.571>
        700
        -- </randexpr-2.571>
    })

test:do_test(
    "randexpr-2.572",
    function()
        return test:execsql "SELECT t1.d-case when e in (17,coalesce((select max((select count(*) from t1)) from t1 where (~t1.f++19*t1.f+b in (a,t1.b, -t1.e)) and b in (select count(distinct t1.a) from t1 union select (abs(abs(abs(max(t1.e)*max(t1.d))-min(11)* -count(*)))) from t1)),17),13) and t1.f in (select t1.b from t1 union select f from t1) then t1.c else c end+f FROM t1 WHERE NOT (not (select (abs(abs((+count(*)*~ -cast(avg(+t1.f-c) AS integer)*count(distinct +coalesce((select max((abs(c)/abs(t1.e))) from t1 where coalesce((select coalesce((select max(f) from t1 where t1.d<=t1.d),e)*c from t1 where t1.f<>f),c) not between t1.a and c),t1.e)+13)-count(distinct f) | abs(cast(avg(t1.b) AS integer)))))) from t1)-13<t1.c)"
    end, {
        -- <randexpr-2.572>
        
        -- </randexpr-2.572>
    })

test:do_test(
    "randexpr-2.573",
    function()
        return test:execsql "SELECT (abs(t1.f*case when (abs(t1.f+17-(t1.a*11*(abs(d)/abs(coalesce((select max(11) from t1 where e=a-t1.a or e not between 17 and 11 or (t1.f)>=c or f<>e),+d))) | t1.c*b+t1.d)- -f)/abs(13))<>t1.e then  -t1.e when t1.e not between f and t1.a then t1.c else t1.c end)/abs(t1.e)) FROM t1 WHERE (abs(b*t1.e+t1.a)/abs(t1.c))<case when 13 in (coalesce((select max(~(abs( -11*t1.a)/abs(c))+t1.e) from t1 where t1.d in (f,c,(f))),f)-f,b,t1.b) then e when not exists(select 1 from t1 where f in (select max(19) from t1 union select cast(avg(t1.e) AS integer)- -min(11) | abs((cast(avg(t1.d) AS integer))) from t1)) then d else d end and e<e"
    end, {
        -- <randexpr-2.573>
        
        -- </randexpr-2.573>
    })

test:do_test(
    "randexpr-2.574",
    function()
        return test:execsql "SELECT (abs(t1.f*case when (abs(t1.f+17-(t1.a*11*(abs(d)/abs(coalesce((select max(11) from t1 where e=a-t1.a or e not between 17 and 11 or (t1.f)>=c or f<>e),+d))) | t1.c*b+t1.d)- -f)/abs(13))<>t1.e then  -t1.e when t1.e not between f and t1.a then t1.c else t1.c end)/abs(t1.e)) FROM t1 WHERE NOT ((abs(b*t1.e+t1.a)/abs(t1.c))<case when 13 in (coalesce((select max(~(abs( -11*t1.a)/abs(c))+t1.e) from t1 where t1.d in (f,c,(f))),f)-f,b,t1.b) then e when not exists(select 1 from t1 where f in (select max(19) from t1 union select cast(avg(t1.e) AS integer)- -min(11) | abs((cast(avg(t1.d) AS integer))) from t1)) then d else d end and e<e)"
    end, {
        -- <randexpr-2.574>
        600
        -- </randexpr-2.574>
    })

test:do_test(
    "randexpr-2.575",
    function()
        return test:execsql "SELECT (abs(t1.f*case when (abs(t1.f+17-(t1.a*11*(abs(d)/abs(coalesce((select max(11) from t1 where e=a-t1.a or e not between 17 and 11 or (t1.f)>=c or f<>e),+d))) & t1.c*b+t1.d)- -f)/abs(13))<>t1.e then  -t1.e when t1.e not between f and t1.a then t1.c else t1.c end)/abs(t1.e)) FROM t1 WHERE NOT ((abs(b*t1.e+t1.a)/abs(t1.c))<case when 13 in (coalesce((select max(~(abs( -11*t1.a)/abs(c))+t1.e) from t1 where t1.d in (f,c,(f))),f)-f,b,t1.b) then e when not exists(select 1 from t1 where f in (select max(19) from t1 union select cast(avg(t1.e) AS integer)- -min(11) | abs((cast(avg(t1.d) AS integer))) from t1)) then d else d end and e<e)"
    end, {
        -- <randexpr-2.575>
        600
        -- </randexpr-2.575>
    })

test:do_test(
    "randexpr-2.576",
    function()
        return test:execsql "SELECT (abs(t1.c-case when +coalesce((select max(coalesce((select max(a-a*t1.f) from t1 where ~t1.a*t1.a-t1.b+f* -19 not in (t1.d,e,b)),11)*t1.a) from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (c) in (b,c,t1.c))) or t1.e between  -b and b),a)+a<=e then t1.d else 17 end)/abs(f)) FROM t1 WHERE t1.d-t1.c+~t1.c<>case when (17) in (select + -abs(count(distinct t1.e*17*c+f)-max(19)) from t1 union select count(*)-max(case t1.f when a then (11+19*t1.b+t1.f) else (19) end*t1.c) from t1) then (abs(b- -f)/abs(f)) else t1.f end"
    end, {
        -- <randexpr-2.576>
        0
        -- </randexpr-2.576>
    })

test:do_test(
    "randexpr-2.577",
    function()
        return test:execsql "SELECT (abs(t1.c-case when +coalesce((select max(coalesce((select max(a-a*t1.f) from t1 where ~t1.a*t1.a-t1.b+f* -19 not in (t1.d,e,b)),11)*t1.a) from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (c) in (b,c,t1.c))) or t1.e between  -b and b),a)+a<=e then t1.d else 17 end)/abs(f)) FROM t1 WHERE NOT (t1.d-t1.c+~t1.c<>case when (17) in (select + -abs(count(distinct t1.e*17*c+f)-max(19)) from t1 union select count(*)-max(case t1.f when a then (11+19*t1.b+t1.f) else (19) end*t1.c) from t1) then (abs(b- -f)/abs(f)) else t1.f end)"
    end, {
        -- <randexpr-2.577>
        
        -- </randexpr-2.577>
    })

test:do_test(
    "randexpr-2.578",
    function()
        return test:execsql "SELECT (abs( -coalesce((select 11 from t1 where (case f when (19+ -(select count(*) from t1)) then (select ++~count(distinct 17+t1.f*(17)) | cast(avg(c) AS integer) from t1) else 13-t1.b*t1.b end*t1.c*(select max(e)*cast(avg(t1.b) AS integer) from t1) | 13) | 17 between 11 and 17),(e))+d)/abs(t1.b))-t1.d FROM t1 WHERE 11<>t1.b"
    end, {
        -- <randexpr-2.578>
        -400
        -- </randexpr-2.578>
    })

test:do_test(
    "randexpr-2.579",
    function()
        return test:execsql "SELECT (abs( -coalesce((select 11 from t1 where (case f when (19+ -(select count(*) from t1)) then (select ++~count(distinct 17+t1.f*(17)) | cast(avg(c) AS integer) from t1) else 13-t1.b*t1.b end*t1.c*(select max(e)*cast(avg(t1.b) AS integer) from t1) | 13) | 17 between 11 and 17),(e))+d)/abs(t1.b))-t1.d FROM t1 WHERE NOT (11<>t1.b)"
    end, {
        -- <randexpr-2.579>
        
        -- </randexpr-2.579>
    })

test:do_test(
    "randexpr-2.580",
    function()
        return test:execsql "SELECT (abs( -coalesce((select 11 from t1 where (case f when (19+ -(select count(*) from t1)) then (select ++~count(distinct 17+t1.f*(17)) & cast(avg(c) AS integer) from t1) else 13-t1.b*t1.b end*t1.c*(select max(e)*cast(avg(t1.b) AS integer) from t1) & 13) & 17 between 11 and 17),(e))+d)/abs(t1.b))-t1.d FROM t1 WHERE 11<>t1.b"
    end, {
        -- <randexpr-2.580>
        -400
        -- </randexpr-2.580>
    })

test:do_test(
    "randexpr-2.581",
    function()
        return test:execsql "SELECT ( -13)-case when (13)+19 between (select cast(avg(11+coalesce((select d from t1 where t1.a in (select b from t1 union select c from t1)),11)+t1.e*d) AS integer)*+(max(t1.c))+cast(avg((c)) AS integer)*count(*) | max( -t1.b) from t1)-t1.d and t1.a then t1.b when b<>t1.f then t1.c else a end-b-t1.b FROM t1 WHERE 11<=t1.e+19*+t1.d"
    end, {
        -- <randexpr-2.581>
        -613
        -- </randexpr-2.581>
    })

test:do_test(
    "randexpr-2.582",
    function()
        return test:execsql "SELECT ( -13)-case when (13)+19 between (select cast(avg(11+coalesce((select d from t1 where t1.a in (select b from t1 union select c from t1)),11)+t1.e*d) AS integer)*+(max(t1.c))+cast(avg((c)) AS integer)*count(*) | max( -t1.b) from t1)-t1.d and t1.a then t1.b when b<>t1.f then t1.c else a end-b-t1.b FROM t1 WHERE NOT (11<=t1.e+19*+t1.d)"
    end, {
        -- <randexpr-2.582>
        
        -- </randexpr-2.582>
    })

test:do_test(
    "randexpr-2.583",
    function()
        return test:execsql "SELECT ( -13)-case when (13)+19 between (select cast(avg(11+coalesce((select d from t1 where t1.a in (select b from t1 union select c from t1)),11)+t1.e*d) AS integer)*+(max(t1.c))+cast(avg((c)) AS integer)*count(*) & max( -t1.b) from t1)-t1.d and t1.a then t1.b when b<>t1.f then t1.c else a end-b-t1.b FROM t1 WHERE 11<=t1.e+19*+t1.d"
    end, {
        -- <randexpr-2.583>
        -713
        -- </randexpr-2.583>
    })

test:do_test(
    "randexpr-2.584",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e++case ~t1.c when t1.f-c then t1.b*+coalesce((select max(+t1.c) from t1 where 19-19-13 | t1.d+(select ~min(17) from t1) not in (case when t1.a<>b then e else  -e end,(t1.d),t1.a)),b)+((e))* -t1.e else t1.d end | b) from t1 where a not between 13 and c),t1.e) FROM t1 WHERE not case when (exists(select 1 from t1 where (((abs(19)/abs((case when exists(select 1 from t1 where +t1.f>c) then 19 when f in (t1.d,t1.a,13) and b=t1.e then t1.f else t1.a end))) in (e, -t1.c,t1.b))))) then  -t1.f when b in (d,11, -d) then t1.e*t1.a else a end+d<>t1.f and (t1.f=( -17))"
    end, {
        -- <randexpr-2.584>
        
        -- </randexpr-2.584>
    })

test:do_test(
    "randexpr-2.585",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e++case ~t1.c when t1.f-c then t1.b*+coalesce((select max(+t1.c) from t1 where 19-19-13 | t1.d+(select ~min(17) from t1) not in (case when t1.a<>b then e else  -e end,(t1.d),t1.a)),b)+((e))* -t1.e else t1.d end | b) from t1 where a not between 13 and c),t1.e) FROM t1 WHERE NOT (not case when (exists(select 1 from t1 where (((abs(19)/abs((case when exists(select 1 from t1 where +t1.f>c) then 19 when f in (t1.d,t1.a,13) and b=t1.e then t1.f else t1.a end))) in (e, -t1.c,t1.b))))) then  -t1.f when b in (d,11, -d) then t1.e*t1.a else a end+d<>t1.f and (t1.f=( -17)))"
    end, {
        -- <randexpr-2.585>
        500
        -- </randexpr-2.585>
    })

test:do_test(
    "randexpr-2.586",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e++case ~t1.c when t1.f-c then t1.b*+coalesce((select max(+t1.c) from t1 where 19-19-13 & t1.d+(select ~min(17) from t1) not in (case when t1.a<>b then e else  -e end,(t1.d),t1.a)),b)+((e))* -t1.e else t1.d end & b) from t1 where a not between 13 and c),t1.e) FROM t1 WHERE NOT (not case when (exists(select 1 from t1 where (((abs(19)/abs((case when exists(select 1 from t1 where +t1.f>c) then 19 when f in (t1.d,t1.a,13) and b=t1.e then t1.f else t1.a end))) in (e, -t1.c,t1.b))))) then  -t1.f when b in (d,11, -d) then t1.e*t1.a else a end+d<>t1.f and (t1.f=( -17)))"
    end, {
        -- <randexpr-2.586>
        500
        -- </randexpr-2.586>
    })

test:do_test(
    "randexpr-2.587",
    function()
        return test:execsql "SELECT case when t1.d-~case t1.b when coalesce((select max(b) from t1 where exists(select 1 from t1 where t1.c<>b)),case when 17 in (select min(c+17) from t1 union select ~ -count(distinct 11) | max(d) from t1) then d when ((t1.a not between t1.f and t1.f)) then t1.a else t1.b end) then (c) else (t1.c) end<t1.a then t1.d when f not between 19 and c and 17 in (t1.f,t1.d,c) then t1.f else 11 end+t1.e*( -11) FROM t1 WHERE case c when f then case (abs(t1.d | case when ((13))*a+c+19>=d then  -13 when b in (select cast(avg((a)) AS integer) from t1 union select  -~abs(count(*))*min(t1.f) from t1) then d else 19 end)/abs(19)) when 11 then 11 else t1.f end+13-t1.d else t1.b end+b>=d and not exists(select 1 from t1 where e>=19)"
    end, {
        -- <randexpr-2.587>
        
        -- </randexpr-2.587>
    })

test:do_test(
    "randexpr-2.588",
    function()
        return test:execsql "SELECT case when t1.d-~case t1.b when coalesce((select max(b) from t1 where exists(select 1 from t1 where t1.c<>b)),case when 17 in (select min(c+17) from t1 union select ~ -count(distinct 11) | max(d) from t1) then d when ((t1.a not between t1.f and t1.f)) then t1.a else t1.b end) then (c) else (t1.c) end<t1.a then t1.d when f not between 19 and c and 17 in (t1.f,t1.d,c) then t1.f else 11 end+t1.e*( -11) FROM t1 WHERE NOT (case c when f then case (abs(t1.d | case when ((13))*a+c+19>=d then  -13 when b in (select cast(avg((a)) AS integer) from t1 union select  -~abs(count(*))*min(t1.f) from t1) then d else 19 end)/abs(19)) when 11 then 11 else t1.f end+13-t1.d else t1.b end+b>=d and not exists(select 1 from t1 where e>=19))"
    end, {
        -- <randexpr-2.588>
        -5489
        -- </randexpr-2.588>
    })

test:do_test(
    "randexpr-2.589",
    function()
        return test:execsql "SELECT case when t1.d-~case t1.b when coalesce((select max(b) from t1 where exists(select 1 from t1 where t1.c<>b)),case when 17 in (select min(c+17) from t1 union select ~ -count(distinct 11) & max(d) from t1) then d when ((t1.a not between t1.f and t1.f)) then t1.a else t1.b end) then (c) else (t1.c) end<t1.a then t1.d when f not between 19 and c and 17 in (t1.f,t1.d,c) then t1.f else 11 end+t1.e*( -11) FROM t1 WHERE NOT (case c when f then case (abs(t1.d | case when ((13))*a+c+19>=d then  -13 when b in (select cast(avg((a)) AS integer) from t1 union select  -~abs(count(*))*min(t1.f) from t1) then d else 19 end)/abs(19)) when 11 then 11 else t1.f end+13-t1.d else t1.b end+b>=d and not exists(select 1 from t1 where e>=19))"
    end, {
        -- <randexpr-2.589>
        -5489
        -- </randexpr-2.589>
    })

test:do_test(
    "randexpr-2.590",
    function()
        return test:execsql "SELECT b+coalesce((select (t1.e) from t1 where coalesce((select max((select abs(cast(avg( -t1.f*17) AS integer))+count(*) from t1)-19*coalesce((select b*+~(t1.c)*(abs(c)/abs(a))+t1.e from t1 where 11 in (t1.a,17,b* -t1.f)),t1.e)*t1.b) from t1 where t1.f<>17),17) in (11,11, -t1.f)),t1.e) FROM t1 WHERE coalesce((select max(coalesce((select 19-e from t1 where t1.b not in (coalesce((select max(t1.e+coalesce((select 11+ -coalesce((select max(t1.a) from t1 where t1.a in (select cast(avg( -11) AS integer) from t1 union select  -max(c) from t1)),11)*t1.a from t1 where exists(select 1 from t1 where a= -e)),e)-t1.c | t1.d) from t1 where t1.e=t1.a),17),(t1.e),c)),t1.b)) from t1 where not exists(select 1 from t1 where (13>=a) or exists(select 1 from t1 where d<>11))), -19)<=t1.b"
    end, {
        -- <randexpr-2.590>
        700
        -- </randexpr-2.590>
    })

test:do_test(
    "randexpr-2.591",
    function()
        return test:execsql "SELECT b+coalesce((select (t1.e) from t1 where coalesce((select max((select abs(cast(avg( -t1.f*17) AS integer))+count(*) from t1)-19*coalesce((select b*+~(t1.c)*(abs(c)/abs(a))+t1.e from t1 where 11 in (t1.a,17,b* -t1.f)),t1.e)*t1.b) from t1 where t1.f<>17),17) in (11,11, -t1.f)),t1.e) FROM t1 WHERE NOT (coalesce((select max(coalesce((select 19-e from t1 where t1.b not in (coalesce((select max(t1.e+coalesce((select 11+ -coalesce((select max(t1.a) from t1 where t1.a in (select cast(avg( -11) AS integer) from t1 union select  -max(c) from t1)),11)*t1.a from t1 where exists(select 1 from t1 where a= -e)),e)-t1.c | t1.d) from t1 where t1.e=t1.a),17),(t1.e),c)),t1.b)) from t1 where not exists(select 1 from t1 where (13>=a) or exists(select 1 from t1 where d<>11))), -19)<=t1.b)"
    end, {
        -- <randexpr-2.591>
        
        -- </randexpr-2.591>
    })

test:do_test(
    "randexpr-2.592",
    function()
        return test:execsql "SELECT (select count(distinct t1.a)-cast(avg(~c+coalesce((select e from t1 where e in (select t1.f from t1 union select d from t1) or t1.d not in (case when a not in (t1.d,t1.c,t1.b) then a-case when ~t1.b+t1.e |  -t1.e not in (a,(b),19) then t1.d else 11 end*b when 13 in (c,13,t1.a) then  -t1.a else 17 end,c,d)),t1.e)) AS integer) from t1) FROM t1 WHERE ~e<=(a-(select count(*) from t1)+c+(select  -abs(abs( -(max((abs(coalesce((select a*(abs(b-b)/abs((c*a*b)-11+coalesce((select max(b) from t1 where a<c),e))) from t1 where 17<>e),e))/abs(11))*t1.e)))) | abs((count(*))) from t1))"
    end, {
        -- <randexpr-2.592>
        -198
        -- </randexpr-2.592>
    })

test:do_test(
    "randexpr-2.593",
    function()
        return test:execsql "SELECT (select count(distinct t1.a)-cast(avg(~c+coalesce((select e from t1 where e in (select t1.f from t1 union select d from t1) or t1.d not in (case when a not in (t1.d,t1.c,t1.b) then a-case when ~t1.b+t1.e |  -t1.e not in (a,(b),19) then t1.d else 11 end*b when 13 in (c,13,t1.a) then  -t1.a else 17 end,c,d)),t1.e)) AS integer) from t1) FROM t1 WHERE NOT (~e<=(a-(select count(*) from t1)+c+(select  -abs(abs( -(max((abs(coalesce((select a*(abs(b-b)/abs((c*a*b)-11+coalesce((select max(b) from t1 where a<c),e))) from t1 where 17<>e),e))/abs(11))*t1.e)))) | abs((count(*))) from t1)))"
    end, {
        -- <randexpr-2.593>
        
        -- </randexpr-2.593>
    })

test:do_test(
    "randexpr-2.594",
    function()
        return test:execsql "SELECT (select count(distinct t1.a)-cast(avg(~c+coalesce((select e from t1 where e in (select t1.f from t1 union select d from t1) or t1.d not in (case when a not in (t1.d,t1.c,t1.b) then a-case when ~t1.b+t1.e &  -t1.e not in (a,(b),19) then t1.d else 11 end*b when 13 in (c,13,t1.a) then  -t1.a else 17 end,c,d)),t1.e)) AS integer) from t1) FROM t1 WHERE ~e<=(a-(select count(*) from t1)+c+(select  -abs(abs( -(max((abs(coalesce((select a*(abs(b-b)/abs((c*a*b)-11+coalesce((select max(b) from t1 where a<c),e))) from t1 where 17<>e),e))/abs(11))*t1.e)))) | abs((count(*))) from t1))"
    end, {
        -- <randexpr-2.594>
        -198
        -- </randexpr-2.594>
    })

test:do_test(
    "randexpr-2.595",
    function()
        return test:execsql "SELECT 13-(select cast(avg(t1.c-13) AS integer) from t1) | 11+t1.b | coalesce((select max(case when b in (select case  -case max(17) when ~cast(avg(13-t1.a) AS integer) then count(distinct 13) else  - -((cast(avg(e) AS integer))) end when cast(avg(t1.c) AS integer) then count(distinct d) else count(*) end from t1 union select count(*) from t1) then case when t1.d<>~13 then b when t1.c<>13 then t1.a else a end else t1.a end) from t1 where t1.f<>( -(17))),t1.e)+c FROM t1 WHERE (~coalesce((select (11+t1.d) from t1 where 17 in (select f+a from t1 union select case when 11>coalesce((select  -case when (11 not in (t1.f,(abs(t1.a)/abs((select count(distinct  -case when 13<=e then c when d between (t1.d) and t1.d then a else 11 end) from t1)-f)),c)) then f when (t1.f>t1.d) then 17 else 13 end from t1 where t1.e>a),17) then f else t1.b end from t1)),b)*13>e)"
    end, {
        -- <randexpr-2.595>
        
        -- </randexpr-2.595>
    })

test:do_test(
    "randexpr-2.596",
    function()
        return test:execsql "SELECT 13-(select cast(avg(t1.c-13) AS integer) from t1) | 11+t1.b | coalesce((select max(case when b in (select case  -case max(17) when ~cast(avg(13-t1.a) AS integer) then count(distinct 13) else  - -((cast(avg(e) AS integer))) end when cast(avg(t1.c) AS integer) then count(distinct d) else count(*) end from t1 union select count(*) from t1) then case when t1.d<>~13 then b when t1.c<>13 then t1.a else a end else t1.a end) from t1 where t1.f<>( -(17))),t1.e)+c FROM t1 WHERE NOT ((~coalesce((select (11+t1.d) from t1 where 17 in (select f+a from t1 union select case when 11>coalesce((select  -case when (11 not in (t1.f,(abs(t1.a)/abs((select count(distinct  -case when 13<=e then c when d between (t1.d) and t1.d then a else 11 end) from t1)-f)),c)) then f when (t1.f>t1.d) then 17 else 13 end from t1 where t1.e>a),17) then f else t1.b end from t1)),b)*13>e))"
    end, {
        -- <randexpr-2.596>
        -1
        -- </randexpr-2.596>
    })

test:do_test(
    "randexpr-2.597",
    function()
        return test:execsql "SELECT 13-(select cast(avg(t1.c-13) AS integer) from t1) & 11+t1.b & coalesce((select max(case when b in (select case  -case max(17) when ~cast(avg(13-t1.a) AS integer) then count(distinct 13) else  - -((cast(avg(e) AS integer))) end when cast(avg(t1.c) AS integer) then count(distinct d) else count(*) end from t1 union select count(*) from t1) then case when t1.d<>~13 then b when t1.c<>13 then t1.a else a end else t1.a end) from t1 where t1.f<>( -(17))),t1.e)+c FROM t1 WHERE NOT ((~coalesce((select (11+t1.d) from t1 where 17 in (select f+a from t1 union select case when 11>coalesce((select  -case when (11 not in (t1.f,(abs(t1.a)/abs((select count(distinct  -case when 13<=e then c when d between (t1.d) and t1.d then a else 11 end) from t1)-f)),c)) then f when (t1.f>t1.d) then 17 else 13 end from t1 where t1.e>a),17) then f else t1.b end from t1)),b)*13>e))"
    end, {
        -- <randexpr-2.597>
        128
        -- </randexpr-2.597>
    })

test:do_test(
    "randexpr-2.598",
    function()
        return test:execsql "SELECT f+coalesce((select case when ~case when coalesce((select max(b) from t1 where not exists(select 1 from t1 where 11*t1.b>case t1.b when 13 then 11 else b end)),t1.b) not in (a,b,+t1.e | case when t1.a<>17 then 17 else t1.e end) then c when (t1.e)<>d then 11 else f end*(e) not between d and e then 17 else 17 end from t1 where 13 not between 19 and f),t1.b)*11 FROM t1 WHERE not exists(select 1 from t1 where 11 between c and b and  -case when 13 between  -f | case when t1.b<+c then b when t1.f>13 then a else (d) end and d then t1.d when t1.a in (select 19 from t1 union select 11 from t1) or not exists(select 1 from t1 where exists(select 1 from t1 where not b=t1.b)) then  -19 else t1.b end in (select max(17) from t1 union select count(distinct a)+count(distinct 11) from t1) and t1.f<t1.d or b not in (d,t1.d,a))"
    end, {
        -- <randexpr-2.598>
        
        -- </randexpr-2.598>
    })

test:do_test(
    "randexpr-2.599",
    function()
        return test:execsql "SELECT f+coalesce((select case when ~case when coalesce((select max(b) from t1 where not exists(select 1 from t1 where 11*t1.b>case t1.b when 13 then 11 else b end)),t1.b) not in (a,b,+t1.e | case when t1.a<>17 then 17 else t1.e end) then c when (t1.e)<>d then 11 else f end*(e) not between d and e then 17 else 17 end from t1 where 13 not between 19 and f),t1.b)*11 FROM t1 WHERE NOT (not exists(select 1 from t1 where 11 between c and b and  -case when 13 between  -f | case when t1.b<+c then b when t1.f>13 then a else (d) end and d then t1.d when t1.a in (select 19 from t1 union select 11 from t1) or not exists(select 1 from t1 where exists(select 1 from t1 where not b=t1.b)) then  -19 else t1.b end in (select max(17) from t1 union select count(distinct a)+count(distinct 11) from t1) and t1.f<t1.d or b not in (d,t1.d,a)))"
    end, {
        -- <randexpr-2.599>
        787
        -- </randexpr-2.599>
    })

test:do_test(
    "randexpr-2.600",
    function()
        return test:execsql "SELECT f+coalesce((select case when ~case when coalesce((select max(b) from t1 where not exists(select 1 from t1 where 11*t1.b>case t1.b when 13 then 11 else b end)),t1.b) not in (a,b,+t1.e & case when t1.a<>17 then 17 else t1.e end) then c when (t1.e)<>d then 11 else f end*(e) not between d and e then 17 else 17 end from t1 where 13 not between 19 and f),t1.b)*11 FROM t1 WHERE NOT (not exists(select 1 from t1 where 11 between c and b and  -case when 13 between  -f | case when t1.b<+c then b when t1.f>13 then a else (d) end and d then t1.d when t1.a in (select 19 from t1 union select 11 from t1) or not exists(select 1 from t1 where exists(select 1 from t1 where not b=t1.b)) then  -19 else t1.b end in (select max(17) from t1 union select count(distinct a)+count(distinct 11) from t1) and t1.f<t1.d or b not in (d,t1.d,a)))"
    end, {
        -- <randexpr-2.600>
        787
        -- </randexpr-2.600>
    })

test:do_test(
    "randexpr-2.601",
    function()
        return test:execsql "SELECT coalesce((select max(e) from t1 where e*~t1.b*e+c*case when +(abs(coalesce((select max(t1.b) from t1 where t1.b>=t1.a-11),11))/abs(17))=t1.f and ((t1.f)=t1.e) then t1.a+t1.d when not exists(select 1 from t1 where  -b>c) or t1.a>=11 then t1.e else e end*13*t1.f | d>=19),t1.b)+t1.a FROM t1 WHERE t1.e not in (t1.f+case when f-d not between coalesce((select max(d) from t1 where (coalesce((select max(17) from t1 where not 19 in (select cast(avg(c) AS integer)-~count(distinct f- -e)+cast(avg(19) AS integer) from t1 union select cast(avg(d) AS integer) from t1)),b) not in (13,t1.c,13))),17)+ -e+t1.f and  -(t1.b) then (t1.d) when t1.b in (select min(a) from t1 union select min(17) from t1) then c else 11 end,c, -13)"
    end, {
        -- <randexpr-2.601>
        600
        -- </randexpr-2.601>
    })

test:do_test(
    "randexpr-2.602",
    function()
        return test:execsql "SELECT coalesce((select max(e) from t1 where e*~t1.b*e+c*case when +(abs(coalesce((select max(t1.b) from t1 where t1.b>=t1.a-11),11))/abs(17))=t1.f and ((t1.f)=t1.e) then t1.a+t1.d when not exists(select 1 from t1 where  -b>c) or t1.a>=11 then t1.e else e end*13*t1.f | d>=19),t1.b)+t1.a FROM t1 WHERE NOT (t1.e not in (t1.f+case when f-d not between coalesce((select max(d) from t1 where (coalesce((select max(17) from t1 where not 19 in (select cast(avg(c) AS integer)-~count(distinct f- -e)+cast(avg(19) AS integer) from t1 union select cast(avg(d) AS integer) from t1)),b) not in (13,t1.c,13))),17)+ -e+t1.f and  -(t1.b) then (t1.d) when t1.b in (select min(a) from t1 union select min(17) from t1) then c else 11 end,c, -13))"
    end, {
        -- <randexpr-2.602>
        
        -- </randexpr-2.602>
    })

test:do_test(
    "randexpr-2.603",
    function()
        return test:execsql "SELECT coalesce((select max(e) from t1 where e*~t1.b*e+c*case when +(abs(coalesce((select max(t1.b) from t1 where t1.b>=t1.a-11),11))/abs(17))=t1.f and ((t1.f)=t1.e) then t1.a+t1.d when not exists(select 1 from t1 where  -b>c) or t1.a>=11 then t1.e else e end*13*t1.f & d>=19),t1.b)+t1.a FROM t1 WHERE t1.e not in (t1.f+case when f-d not between coalesce((select max(d) from t1 where (coalesce((select max(17) from t1 where not 19 in (select cast(avg(c) AS integer)-~count(distinct f- -e)+cast(avg(19) AS integer) from t1 union select cast(avg(d) AS integer) from t1)),b) not in (13,t1.c,13))),17)+ -e+t1.f and  -(t1.b) then (t1.d) when t1.b in (select min(a) from t1 union select min(17) from t1) then c else 11 end,c, -13)"
    end, {
        -- <randexpr-2.603>
        600
        -- </randexpr-2.603>
    })

test:do_test(
    "randexpr-2.604",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where f in (select cast(avg(t1.c) AS integer) from t1 union select min(t1.b) from t1)) then c+d-d when (coalesce((select a from t1 where a<(select abs(count(*)) from t1)),(select count(distinct t1.e) | abs(+ -count(distinct t1.e)*min(t1.b) | count(distinct 11)) from t1))) not in (17,(abs(t1.d)/abs(coalesce((select max(t1.f) from t1 where t1.a*t1.f>=t1.c),t1.f))),t1.e) then t1.c else t1.e end-f FROM t1 WHERE 13*~~(abs(b)/abs(coalesce((select max(t1.a) from t1 where t1.e in ( -(13-17)-b+(e | (abs(t1.e)/abs(case when ~t1.d between t1.e and c and t1.b in (select t1.c from t1 union select b from t1) then 11+t1.b when a=t1.d then b else c end)))*17,t1.c, -17)),13)))-e+b-19>19"
    end, {
        -- <randexpr-2.604>
        
        -- </randexpr-2.604>
    })

test:do_test(
    "randexpr-2.605",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where f in (select cast(avg(t1.c) AS integer) from t1 union select min(t1.b) from t1)) then c+d-d when (coalesce((select a from t1 where a<(select abs(count(*)) from t1)),(select count(distinct t1.e) | abs(+ -count(distinct t1.e)*min(t1.b) | count(distinct 11)) from t1))) not in (17,(abs(t1.d)/abs(coalesce((select max(t1.f) from t1 where t1.a*t1.f>=t1.c),t1.f))),t1.e) then t1.c else t1.e end-f FROM t1 WHERE NOT (13*~~(abs(b)/abs(coalesce((select max(t1.a) from t1 where t1.e in ( -(13-17)-b+(e | (abs(t1.e)/abs(case when ~t1.d between t1.e and c and t1.b in (select t1.c from t1 union select b from t1) then 11+t1.b when a=t1.d then b else c end)))*17,t1.c, -17)),13)))-e+b-19>19)"
    end, {
        -- <randexpr-2.605>
        -300
        -- </randexpr-2.605>
    })

test:do_test(
    "randexpr-2.606",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where f in (select cast(avg(t1.c) AS integer) from t1 union select min(t1.b) from t1)) then c+d-d when (coalesce((select a from t1 where a<(select abs(count(*)) from t1)),(select count(distinct t1.e) & abs(+ -count(distinct t1.e)*min(t1.b) & count(distinct 11)) from t1))) not in (17,(abs(t1.d)/abs(coalesce((select max(t1.f) from t1 where t1.a*t1.f>=t1.c),t1.f))),t1.e) then t1.c else t1.e end-f FROM t1 WHERE NOT (13*~~(abs(b)/abs(coalesce((select max(t1.a) from t1 where t1.e in ( -(13-17)-b+(e | (abs(t1.e)/abs(case when ~t1.d between t1.e and c and t1.b in (select t1.c from t1 union select b from t1) then 11+t1.b when a=t1.d then b else c end)))*17,t1.c, -17)),13)))-e+b-19>19)"
    end, {
        -- <randexpr-2.606>
        -100
        -- </randexpr-2.606>
    })

test:do_test(
    "randexpr-2.607",
    function()
        return test:execsql "SELECT case when t1.f<d or t1.d>=17 then t1.d-19-11*f*t1.a*t1.b-case (select +cast(avg(a) AS integer) from t1) when 19 then 17 else a end when t1.a between case t1.c when t1.c*t1.c then (d) else t1.c end and c then e else t1.a end FROM t1 WHERE not exists(select 1 from t1 where exists(select 1 from t1 where (abs(+f-( -~(select count(distinct ~a*e | (select max(f)*count(distinct t1.f) from t1)) |  -max(17)+(count(*))+max(11)+count(distinct t1.e)- - -count(distinct f) from t1)+b*b-t1.c) | t1.e)/abs(17))*c*b in (17,19,t1.e)))"
    end, {
        -- <randexpr-2.607>
        -131999719
        -- </randexpr-2.607>
    })

test:do_test(
    "randexpr-2.608",
    function()
        return test:execsql "SELECT case when t1.f<d or t1.d>=17 then t1.d-19-11*f*t1.a*t1.b-case (select +cast(avg(a) AS integer) from t1) when 19 then 17 else a end when t1.a between case t1.c when t1.c*t1.c then (d) else t1.c end and c then e else t1.a end FROM t1 WHERE NOT (not exists(select 1 from t1 where exists(select 1 from t1 where (abs(+f-( -~(select count(distinct ~a*e | (select max(f)*count(distinct t1.f) from t1)) |  -max(17)+(count(*))+max(11)+count(distinct t1.e)- - -count(distinct f) from t1)+b*b-t1.c) | t1.e)/abs(17))*c*b in (17,19,t1.e))))"
    end, {
        -- <randexpr-2.608>
        
        -- </randexpr-2.608>
    })

test:do_test(
    "randexpr-2.609",
    function()
        return test:execsql "SELECT f-~+17*(abs(t1.f)/abs(a*case when case when (case when d>=t1.b or t1.b>=11 then t1.c when t1.b>t1.d then t1.d else t1.a end+17) not in (11,t1.e,17) then c when (t1.b>=a and b>b) then t1.d else d end in (select +abs( -max(t1.e)) from t1 union select count(*) | max(17) from t1) then (t1.a) else a end+(t1.e)))*(11)-f | t1.a-f FROM t1 WHERE ((t1.d>=t1.c))"
    end, {
        -- <randexpr-2.609>
        -500
        -- </randexpr-2.609>
    })

test:do_test(
    "randexpr-2.610",
    function()
        return test:execsql "SELECT f-~+17*(abs(t1.f)/abs(a*case when case when (case when d>=t1.b or t1.b>=11 then t1.c when t1.b>t1.d then t1.d else t1.a end+17) not in (11,t1.e,17) then c when (t1.b>=a and b>b) then t1.d else d end in (select +abs( -max(t1.e)) from t1 union select count(*) | max(17) from t1) then (t1.a) else a end+(t1.e)))*(11)-f | t1.a-f FROM t1 WHERE NOT (((t1.d>=t1.c)))"
    end, {
        -- <randexpr-2.610>
        
        -- </randexpr-2.610>
    })

test:do_test(
    "randexpr-2.611",
    function()
        return test:execsql "SELECT f-~+17*(abs(t1.f)/abs(a*case when case when (case when d>=t1.b or t1.b>=11 then t1.c when t1.b>t1.d then t1.d else t1.a end+17) not in (11,t1.e,17) then c when (t1.b>=a and b>b) then t1.d else d end in (select +abs( -max(t1.e)) from t1 union select count(*) & max(17) from t1) then (t1.a) else a end+(t1.e)))*(11)-f & t1.a-f FROM t1 WHERE ((t1.d>=t1.c))"
    end, {
        -- <randexpr-2.611>
        0
        -- </randexpr-2.611>
    })

test:do_test(
    "randexpr-2.612",
    function()
        return test:execsql "SELECT e+ -((abs(f)/abs(17))) | t1.e*11-coalesce((select max(f) from t1 where ((abs(~+t1.b-coalesce((select coalesce((select max(t1.d) from t1 where not exists(select 1 from t1 where ((f) not in (11,19,t1.b)))),11* -t1.b) from t1 where  -a<=c),t1.f))/abs( -b)) between t1.c and e and not exists(select 1 from t1 where f not in ( -t1.f,19,t1.e)))),case t1.c when 19 then (11) else (t1.a) end) | (13) FROM t1 WHERE d<>13 or t1.c in (select count(distinct  -c*11-( -e)-t1.e)-( -case +max(t1.c)-min((select +cast(avg(19*17) AS integer) from t1)* -t1.f)+~(~count(distinct f))+count(*)-cast(avg(t1.c) AS integer) when count(distinct t1.f) then count(distinct e) else  -count(*) end-count(*)) from t1 union select count(distinct 11) from t1)"
    end, {
        -- <randexpr-2.612>
        5597
        -- </randexpr-2.612>
    })

test:do_test(
    "randexpr-2.613",
    function()
        return test:execsql "SELECT e+ -((abs(f)/abs(17))) | t1.e*11-coalesce((select max(f) from t1 where ((abs(~+t1.b-coalesce((select coalesce((select max(t1.d) from t1 where not exists(select 1 from t1 where ((f) not in (11,19,t1.b)))),11* -t1.b) from t1 where  -a<=c),t1.f))/abs( -b)) between t1.c and e and not exists(select 1 from t1 where f not in ( -t1.f,19,t1.e)))),case t1.c when 19 then (11) else (t1.a) end) | (13) FROM t1 WHERE NOT (d<>13 or t1.c in (select count(distinct  -c*11-( -e)-t1.e)-( -case +max(t1.c)-min((select +cast(avg(19*17) AS integer) from t1)* -t1.f)+~(~count(distinct f))+count(*)-cast(avg(t1.c) AS integer) when count(distinct t1.f) then count(distinct e) else  -count(*) end-count(*)) from t1 union select count(distinct 11) from t1))"
    end, {
        -- <randexpr-2.613>
        
        -- </randexpr-2.613>
    })

test:do_test(
    "randexpr-2.614",
    function()
        return test:execsql "SELECT e+ -((abs(f)/abs(17))) & t1.e*11-coalesce((select max(f) from t1 where ((abs(~+t1.b-coalesce((select coalesce((select max(t1.d) from t1 where not exists(select 1 from t1 where ((f) not in (11,19,t1.b)))),11* -t1.b) from t1 where  -a<=c),t1.f))/abs( -b)) between t1.c and e and not exists(select 1 from t1 where f not in ( -t1.f,19,t1.e)))),case t1.c when 19 then (11) else (t1.a) end) & (13) FROM t1 WHERE d<>13 or t1.c in (select count(distinct  -c*11-( -e)-t1.e)-( -case +max(t1.c)-min((select +cast(avg(19*17) AS integer) from t1)* -t1.f)+~(~count(distinct f))+count(*)-cast(avg(t1.c) AS integer) when count(distinct t1.f) then count(distinct e) else  -count(*) end-count(*)) from t1 union select count(distinct 11) from t1)"
    end, {
        -- <randexpr-2.614>
        0
        -- </randexpr-2.614>
    })

test:do_test(
    "randexpr-2.615",
    function()
        return test:execsql "SELECT coalesce((select case t1.e when t1.d then  -t1.b else b | t1.f end from t1 where case e when case 11 when t1.f then 13 else c end-19 then case  -(select count(distinct 19+ - -d*t1.f+d) from t1)*(abs(c)/abs(coalesce((select max(e) from t1 where not t1.c>t1.d),(17-t1.a)))) when 11 then t1.f else t1.a end else a end<>t1.c),t1.e) FROM t1 WHERE (select case count(*)* -+abs(+count(*)+min(t1.d)) | max(+(17)) when ~count(*)*(count(*))-(count(distinct t1.b)) then count(distinct 11) else max(t1.e) end from t1)>=(abs(coalesce((select t1.b from t1 where (a<f)),b-t1.a))/abs((11*c)-t1.f-b)) and 13 not between (t1.b) and t1.b"
    end, {
        -- <randexpr-2.615>
        728
        -- </randexpr-2.615>
    })

test:do_test(
    "randexpr-2.616",
    function()
        return test:execsql "SELECT coalesce((select case t1.e when t1.d then  -t1.b else b | t1.f end from t1 where case e when case 11 when t1.f then 13 else c end-19 then case  -(select count(distinct 19+ - -d*t1.f+d) from t1)*(abs(c)/abs(coalesce((select max(e) from t1 where not t1.c>t1.d),(17-t1.a)))) when 11 then t1.f else t1.a end else a end<>t1.c),t1.e) FROM t1 WHERE NOT ((select case count(*)* -+abs(+count(*)+min(t1.d)) | max(+(17)) when ~count(*)*(count(*))-(count(distinct t1.b)) then count(distinct 11) else max(t1.e) end from t1)>=(abs(coalesce((select t1.b from t1 where (a<f)),b-t1.a))/abs((11*c)-t1.f-b)) and 13 not between (t1.b) and t1.b)"
    end, {
        -- <randexpr-2.616>
        
        -- </randexpr-2.616>
    })

test:do_test(
    "randexpr-2.617",
    function()
        return test:execsql "SELECT coalesce((select case t1.e when t1.d then  -t1.b else b & t1.f end from t1 where case e when case 11 when t1.f then 13 else c end-19 then case  -(select count(distinct 19+ - -d*t1.f+d) from t1)*(abs(c)/abs(coalesce((select max(e) from t1 where not t1.c>t1.d),(17-t1.a)))) when 11 then t1.f else t1.a end else a end<>t1.c),t1.e) FROM t1 WHERE (select case count(*)* -+abs(+count(*)+min(t1.d)) | max(+(17)) when ~count(*)*(count(*))-(count(distinct t1.b)) then count(distinct 11) else max(t1.e) end from t1)>=(abs(coalesce((select t1.b from t1 where (a<f)),b-t1.a))/abs((11*c)-t1.f-b)) and 13 not between (t1.b) and t1.b"
    end, {
        -- <randexpr-2.617>
        72
        -- </randexpr-2.617>
    })

test:do_test(
    "randexpr-2.618",
    function()
        return test:execsql "SELECT case when 13<11 then 19 when  -(abs(f)/abs(13))*17-13 | case t1.b when ~((select (count(*)-abs(case cast(avg(19) AS integer) when count(distinct 19)*(count(*))-count(*) then count(distinct t1.d) else  -count(distinct 17) end)+max(17)) from t1)) then t1.c else d end+11*t1.e*t1.a | e>(t1.c) then t1.d else t1.d end FROM t1 WHERE case when 17-t1.f in (select case  -~max(c-~e+19)*max(c)*count(*)+~count(distinct f)+case count(distinct d) when max(t1.b) then cast(avg(t1.d) AS integer) else count(distinct d) end-count(distinct d)*max(f)+ -count(distinct 13) when count(*) then ( -min(t1.c)) else min(( -d)) end from t1 union select  -min(c) from t1) then 13 else case t1.c when t1.c then f else d end end-e-(17) in (select c from t1 union select c from t1)"
    end, {
        -- <randexpr-2.618>
        
        -- </randexpr-2.618>
    })

test:do_test(
    "randexpr-2.619",
    function()
        return test:execsql "SELECT case when 13<11 then 19 when  -(abs(f)/abs(13))*17-13 | case t1.b when ~((select (count(*)-abs(case cast(avg(19) AS integer) when count(distinct 19)*(count(*))-count(*) then count(distinct t1.d) else  -count(distinct 17) end)+max(17)) from t1)) then t1.c else d end+11*t1.e*t1.a | e>(t1.c) then t1.d else t1.d end FROM t1 WHERE NOT (case when 17-t1.f in (select case  -~max(c-~e+19)*max(c)*count(*)+~count(distinct f)+case count(distinct d) when max(t1.b) then cast(avg(t1.d) AS integer) else count(distinct d) end-count(distinct d)*max(f)+ -count(distinct 13) when count(*) then ( -min(t1.c)) else min(( -d)) end from t1 union select  -min(c) from t1) then 13 else case t1.c when t1.c then f else d end end-e-(17) in (select c from t1 union select c from t1))"
    end, {
        -- <randexpr-2.619>
        400
        -- </randexpr-2.619>
    })

test:do_test(
    "randexpr-2.620",
    function()
        return test:execsql "SELECT case when 13<11 then 19 when  -(abs(f)/abs(13))*17-13 & case t1.b when ~((select (count(*)-abs(case cast(avg(19) AS integer) when count(distinct 19)*(count(*))-count(*) then count(distinct t1.d) else  -count(distinct 17) end)+max(17)) from t1)) then t1.c else d end+11*t1.e*t1.a & e>(t1.c) then t1.d else t1.d end FROM t1 WHERE NOT (case when 17-t1.f in (select case  -~max(c-~e+19)*max(c)*count(*)+~count(distinct f)+case count(distinct d) when max(t1.b) then cast(avg(t1.d) AS integer) else count(distinct d) end-count(distinct d)*max(f)+ -count(distinct 13) when count(*) then ( -min(t1.c)) else min(( -d)) end from t1 union select  -min(c) from t1) then 13 else case t1.c when t1.c then f else d end end-e-(17) in (select c from t1 union select c from t1))"
    end, {
        -- <randexpr-2.620>
        400
        -- </randexpr-2.620>
    })

test:do_test(
    "randexpr-2.621",
    function()
        return test:execsql "SELECT coalesce((select case ~(case when  -f between t1.e and f then coalesce((select max(t1.a-t1.d) from t1 where d=b),case when (f*11-a-t1.d-c>t1.e and b>=19) then  -+d when t1.b>= -13 then 17 else t1.f end) else (19) end) when 11 then b else f end from t1 where  -t1.e<=t1.d),a) FROM t1 WHERE (+coalesce((select max((abs(19*a-t1.b+t1.a*a)/abs(19))) from t1 where not t1.f in (select case  -count(*)-cast(avg(c) AS integer)+cast(avg(e) AS integer)*count(*) when min(t1.d) then  -(cast(avg(t1.f) AS integer)) else max(13) end+min(t1.d)+count(*) | count(*) | min(11) | count(distinct f) from t1 union select  -count(*) from t1)),e))-t1.e*d | f in (t1.d,e,e)"
    end, {
        -- <randexpr-2.621>
        
        -- </randexpr-2.621>
    })

test:do_test(
    "randexpr-2.622",
    function()
        return test:execsql "SELECT coalesce((select case ~(case when  -f between t1.e and f then coalesce((select max(t1.a-t1.d) from t1 where d=b),case when (f*11-a-t1.d-c>t1.e and b>=19) then  -+d when t1.b>= -13 then 17 else t1.f end) else (19) end) when 11 then b else f end from t1 where  -t1.e<=t1.d),a) FROM t1 WHERE NOT ((+coalesce((select max((abs(19*a-t1.b+t1.a*a)/abs(19))) from t1 where not t1.f in (select case  -count(*)-cast(avg(c) AS integer)+cast(avg(e) AS integer)*count(*) when min(t1.d) then  -(cast(avg(t1.f) AS integer)) else max(13) end+min(t1.d)+count(*) | count(*) | min(11) | count(distinct f) from t1 union select  -count(*) from t1)),e))-t1.e*d | f in (t1.d,e,e))"
    end, {
        -- <randexpr-2.622>
        600
        -- </randexpr-2.622>
    })

test:do_test(
    "randexpr-2.623",
    function()
        return test:execsql "SELECT case d*t1.f when  -t1.a then t1.c+(coalesce((select max(13+case when  -t1.d*13*c*d | case t1.e when t1.e then t1.b+t1.d else (abs(t1.b)/abs(case when c>b or d in (t1.e,a,d) then d else e end))+f end=t1.f then a when t1.a<=19 then 17 else d end) from t1 where (t1.f>t1.b)),(f))) else f end+t1.a FROM t1 WHERE t1.f+case d when 19 then +t1.c else 19-(abs((t1.b)*~coalesce((select f from t1 where (case when +case when t1.d>13 then t1.e else (t1.a) end<13 then f when t1.c<=e then d else t1.a end*t1.d in (select +case ~min(b) when  -max(13) then cast(avg( -(11)) AS integer) else  -cast(avg(17) AS integer) end+count(distinct t1.a) from t1 union select min(t1.f) from t1))),t1.a))/abs(f)) end+(a) in (b,t1.c,t1.a)"
    end, {
        -- <randexpr-2.623>
        
        -- </randexpr-2.623>
    })

test:do_test(
    "randexpr-2.624",
    function()
        return test:execsql "SELECT case d*t1.f when  -t1.a then t1.c+(coalesce((select max(13+case when  -t1.d*13*c*d | case t1.e when t1.e then t1.b+t1.d else (abs(t1.b)/abs(case when c>b or d in (t1.e,a,d) then d else e end))+f end=t1.f then a when t1.a<=19 then 17 else d end) from t1 where (t1.f>t1.b)),(f))) else f end+t1.a FROM t1 WHERE NOT (t1.f+case d when 19 then +t1.c else 19-(abs((t1.b)*~coalesce((select f from t1 where (case when +case when t1.d>13 then t1.e else (t1.a) end<13 then f when t1.c<=e then d else t1.a end*t1.d in (select +case ~min(b) when  -max(13) then cast(avg( -(11)) AS integer) else  -cast(avg(17) AS integer) end+count(distinct t1.a) from t1 union select min(t1.f) from t1))),t1.a))/abs(f)) end+(a) in (b,t1.c,t1.a))"
    end, {
        -- <randexpr-2.624>
        700
        -- </randexpr-2.624>
    })

test:do_test(
    "randexpr-2.625",
    function()
        return test:execsql "SELECT case d*t1.f when  -t1.a then t1.c+(coalesce((select max(13+case when  -t1.d*13*c*d & case t1.e when t1.e then t1.b+t1.d else (abs(t1.b)/abs(case when c>b or d in (t1.e,a,d) then d else e end))+f end=t1.f then a when t1.a<=19 then 17 else d end) from t1 where (t1.f>t1.b)),(f))) else f end+t1.a FROM t1 WHERE NOT (t1.f+case d when 19 then +t1.c else 19-(abs((t1.b)*~coalesce((select f from t1 where (case when +case when t1.d>13 then t1.e else (t1.a) end<13 then f when t1.c<=e then d else t1.a end*t1.d in (select +case ~min(b) when  -max(13) then cast(avg( -(11)) AS integer) else  -cast(avg(17) AS integer) end+count(distinct t1.a) from t1 union select min(t1.f) from t1))),t1.a))/abs(f)) end+(a) in (b,t1.c,t1.a))"
    end, {
        -- <randexpr-2.625>
        700
        -- </randexpr-2.625>
    })

test:do_test(
    "randexpr-2.626",
    function()
        return test:execsql "SELECT case case when (not exists(select 1 from t1 where  -e in (select t1.c from t1 union select b from t1))) then coalesce((select max(t1.d) from t1 where (17+~t1.c in (select min(t1.b) from t1 union select min(13) from t1))),t1.d)*t1.a+d when not a=a and t1.b not in (b,13,d) or d<13 or t1.f not between t1.c and f or t1.c<>c then t1.e else t1.d end when t1.c then (t1.d) else  -f end FROM t1 WHERE (abs(case when (t1.e in (17,19+t1.b,t1.a)) or (t1.d-19)+(t1.d)+t1.d in (select t1.f from t1 union select t1.e from t1) and 13 in (select t1.c from t1 union select c from t1) or 11 not between e and 17 then  -17-a else d end*13)/abs((b)))*d-f-13 between t1.d and (b)"
    end, {
        -- <randexpr-2.626>
        
        -- </randexpr-2.626>
    })

test:do_test(
    "randexpr-2.627",
    function()
        return test:execsql "SELECT case case when (not exists(select 1 from t1 where  -e in (select t1.c from t1 union select b from t1))) then coalesce((select max(t1.d) from t1 where (17+~t1.c in (select min(t1.b) from t1 union select min(13) from t1))),t1.d)*t1.a+d when not a=a and t1.b not in (b,13,d) or d<13 or t1.f not between t1.c and f or t1.c<>c then t1.e else t1.d end when t1.c then (t1.d) else  -f end FROM t1 WHERE NOT ((abs(case when (t1.e in (17,19+t1.b,t1.a)) or (t1.d-19)+(t1.d)+t1.d in (select t1.f from t1 union select t1.e from t1) and 13 in (select t1.c from t1 union select c from t1) or 11 not between e and 17 then  -17-a else d end*13)/abs((b)))*d-f-13 between t1.d and (b))"
    end, {
        -- <randexpr-2.627>
        -600
        -- </randexpr-2.627>
    })

test:do_test(
    "randexpr-2.628",
    function()
        return test:execsql "SELECT a+a+(f)-(t1.f+d+t1.e | case when case (13) when t1.c then case coalesce((select  -t1.b-t1.f-13 from t1 where t1.f between t1.d and (a)),t1.b) when b then 13 else t1.f end-f else t1.d end>=e then 19 else t1.c end*t1.c)*f-(t1.d)-b FROM t1 WHERE (t1.b)=t1.a+t1.d-13 | +~f+13 | e+t1.c+coalesce((select t1.a+e from t1 where b in (select (~max(b-t1.b-coalesce((select ((a)) from t1 where e=d or b not between b and t1.e),t1.b)))++~case case count(*) when  -max(t1.c) then min(b) else min(17) end when max( -t1.a) then (min(t1.f)) else max((a)) end*cast(avg(f) AS integer)+max(19) from t1 union select count(distinct f) from t1)),(t1.e)) | t1.b"
    end, {
        -- <randexpr-2.628>
        
        -- </randexpr-2.628>
    })

test:do_test(
    "randexpr-2.629",
    function()
        return test:execsql "SELECT a+a+(f)-(t1.f+d+t1.e | case when case (13) when t1.c then case coalesce((select  -t1.b-t1.f-13 from t1 where t1.f between t1.d and (a)),t1.b) when b then 13 else t1.f end-f else t1.d end>=e then 19 else t1.c end*t1.c)*f-(t1.d)-b FROM t1 WHERE NOT ((t1.b)=t1.a+t1.d-13 | +~f+13 | e+t1.c+coalesce((select t1.a+e from t1 where b in (select (~max(b-t1.b-coalesce((select ((a)) from t1 where e=d or b not between b and t1.e),t1.b)))++~case case count(*) when  -max(t1.c) then min(b) else min(17) end when max( -t1.a) then (min(t1.f)) else max((a)) end*cast(avg(f) AS integer)+max(19) from t1 union select count(distinct f) from t1)),(t1.e)) | t1.b)"
    end, {
        -- <randexpr-2.629>
        -54045400
        -- </randexpr-2.629>
    })

test:do_test(
    "randexpr-2.630",
    function()
        return test:execsql "SELECT a+a+(f)-(t1.f+d+t1.e & case when case (13) when t1.c then case coalesce((select  -t1.b-t1.f-13 from t1 where t1.f between t1.d and (a)),t1.b) when b then 13 else t1.f end-f else t1.d end>=e then 19 else t1.c end*t1.c)*f-(t1.d)-b FROM t1 WHERE NOT ((t1.b)=t1.a+t1.d-13 | +~f+13 | e+t1.c+coalesce((select t1.a+e from t1 where b in (select (~max(b-t1.b-coalesce((select ((a)) from t1 where e=d or b not between b and t1.e),t1.b)))++~case case count(*) when  -max(t1.c) then min(b) else min(17) end when max( -t1.a) then (min(t1.f)) else max((a)) end*cast(avg(f) AS integer)+max(19) from t1 union select count(distinct f) from t1)),(t1.e)) | t1.b)"
    end, {
        -- <randexpr-2.630>
        -854200
        -- </randexpr-2.630>
    })

test:do_test(
    "randexpr-2.631",
    function()
        return test:execsql "SELECT 19-e+t1.d | 19-(abs(11)/abs(t1.b-(select case cast(avg(t1.f) AS integer)-count(*)-count(distinct t1.c)-abs(count(*))-(cast(avg(case when 11<b then d when (c) in (t1.a,t1.b,t1.a) then t1.a else t1.f end) AS integer) | min(t1.a) | (max(t1.a)))+max((t1.d)) when min(t1.a) then  -count(*) else min((e)) end from t1)*19))-c+13 FROM t1 WHERE case when case when not b-(t1.c)-11 in (case  -(b*11) when t1.d then coalesce((select 13 from t1 where e<>b),t1.d) else ~11 end+t1.b,11,19) then t1.a else  -t1.d-case d*a when t1.d then t1.e else 13 end end+e+b>19 then t1.a else t1.f end not between t1.d and e"
    end, {
        -- <randexpr-2.631>
        -1
        -- </randexpr-2.631>
    })

test:do_test(
    "randexpr-2.632",
    function()
        return test:execsql "SELECT 19-e+t1.d | 19-(abs(11)/abs(t1.b-(select case cast(avg(t1.f) AS integer)-count(*)-count(distinct t1.c)-abs(count(*))-(cast(avg(case when 11<b then d when (c) in (t1.a,t1.b,t1.a) then t1.a else t1.f end) AS integer) | min(t1.a) | (max(t1.a)))+max((t1.d)) when min(t1.a) then  -count(*) else min((e)) end from t1)*19))-c+13 FROM t1 WHERE NOT (case when case when not b-(t1.c)-11 in (case  -(b*11) when t1.d then coalesce((select 13 from t1 where e<>b),t1.d) else ~11 end+t1.b,11,19) then t1.a else  -t1.d-case d*a when t1.d then t1.e else 13 end end+e+b>19 then t1.a else t1.f end not between t1.d and e)"
    end, {
        -- <randexpr-2.632>
        
        -- </randexpr-2.632>
    })

test:do_test(
    "randexpr-2.633",
    function()
        return test:execsql "SELECT 19-e+t1.d & 19-(abs(11)/abs(t1.b-(select case cast(avg(t1.f) AS integer)-count(*)-count(distinct t1.c)-abs(count(*))-(cast(avg(case when 11<b then d when (c) in (t1.a,t1.b,t1.a) then t1.a else t1.f end) AS integer) & min(t1.a) & (max(t1.a)))+max((t1.d)) when min(t1.a) then  -count(*) else min((e)) end from t1)*19))-c+13 FROM t1 WHERE case when case when not b-(t1.c)-11 in (case  -(b*11) when t1.d then coalesce((select 13 from t1 where e<>b),t1.d) else ~11 end+t1.b,11,19) then t1.a else  -t1.d-case d*a when t1.d then t1.e else 13 end end+e+b>19 then t1.a else t1.f end not between t1.d and e"
    end, {
        -- <randexpr-2.633>
        -348
        -- </randexpr-2.633>
    })

test:do_test(
    "randexpr-2.634",
    function()
        return test:execsql "SELECT (select abs(abs(~ -min(case t1.a-d when (abs(f)/abs(f+t1.b)) then ~e-11-+ -13*t1.a else 13 end)-count(*)*case + -count(*) when (count(distinct t1.e)) then max(t1.f) else (count(*)* - -+count(*) | min(17)) end+(cast(avg(t1.f) AS integer))+min(d))) from t1) FROM t1 WHERE not t1.f>=t1.a or not exists(select 1 from t1 where 19=17) and 13 in (select abs(count(*) | ((count(*)))) from t1 union select count(distinct  -t1.c | t1.a) | abs(abs(min(d+c))) from t1)"
    end, {
        -- <randexpr-2.634>
        
        -- </randexpr-2.634>
    })

test:do_test(
    "randexpr-2.635",
    function()
        return test:execsql "SELECT (select abs(abs(~ -min(case t1.a-d when (abs(f)/abs(f+t1.b)) then ~e-11-+ -13*t1.a else 13 end)-count(*)*case + -count(*) when (count(distinct t1.e)) then max(t1.f) else (count(*)* - -+count(*) | min(17)) end+(cast(avg(t1.f) AS integer))+min(d))) from t1) FROM t1 WHERE NOT (not t1.f>=t1.a or not exists(select 1 from t1 where 19=17) and 13 in (select abs(count(*) | ((count(*)))) from t1 union select count(distinct  -t1.c | t1.a) | abs(abs(min(d+c))) from t1))"
    end, {
        -- <randexpr-2.635>
        995
        -- </randexpr-2.635>
    })

test:do_test(
    "randexpr-2.636",
    function()
        return test:execsql "SELECT (select abs(abs(~ -min(case t1.a-d when (abs(f)/abs(f+t1.b)) then ~e-11-+ -13*t1.a else 13 end)-count(*)*case + -count(*) when (count(distinct t1.e)) then max(t1.f) else (count(*)* - -+count(*) & min(17)) end+(cast(avg(t1.f) AS integer))+min(d))) from t1) FROM t1 WHERE NOT (not t1.f>=t1.a or not exists(select 1 from t1 where 19=17) and 13 in (select abs(count(*) | ((count(*)))) from t1 union select count(distinct  -t1.c | t1.a) | abs(abs(min(d+c))) from t1))"
    end, {
        -- <randexpr-2.636>
        1011
        -- </randexpr-2.636>
    })

test:do_test(
    "randexpr-2.637",
    function()
        return test:execsql "SELECT (case when not exists(select 1 from t1 where ((not t1.f in (b,17-d,t1.a) and f<t1.f)) or b=t1.e or a in (select  - -count(distinct t1.c) from t1 union select min(11) from t1)) then (select case max( -t1.c) when (~ -count(distinct (b))-count(*))* -count(*) then count(distinct 11) else  -cast(avg(c) AS integer) end | min(t1.e)*cast(avg(13) AS integer) from t1)+b else (abs(t1.c)/abs( -b)) end-t1.b) FROM t1 WHERE exists(select 1 from t1 where (13>=t1.a))"
    end, {
        -- <randexpr-2.637>
        
        -- </randexpr-2.637>
    })

test:do_test(
    "randexpr-2.638",
    function()
        return test:execsql "SELECT (case when not exists(select 1 from t1 where ((not t1.f in (b,17-d,t1.a) and f<t1.f)) or b=t1.e or a in (select  - -count(distinct t1.c) from t1 union select min(11) from t1)) then (select case max( -t1.c) when (~ -count(distinct (b))-count(*))* -count(*) then count(distinct 11) else  -cast(avg(c) AS integer) end | min(t1.e)*cast(avg(13) AS integer) from t1)+b else (abs(t1.c)/abs( -b)) end-t1.b) FROM t1 WHERE NOT (exists(select 1 from t1 where (13>=t1.a)))"
    end, {
        -- <randexpr-2.638>
        -12
        -- </randexpr-2.638>
    })

test:do_test(
    "randexpr-2.639",
    function()
        return test:execsql "SELECT (case when not exists(select 1 from t1 where ((not t1.f in (b,17-d,t1.a) and f<t1.f)) or b=t1.e or a in (select  - -count(distinct t1.c) from t1 union select min(11) from t1)) then (select case max( -t1.c) when (~ -count(distinct (b))-count(*))* -count(*) then count(distinct 11) else  -cast(avg(c) AS integer) end & min(t1.e)*cast(avg(13) AS integer) from t1)+b else (abs(t1.c)/abs( -b)) end-t1.b) FROM t1 WHERE NOT (exists(select 1 from t1 where (13>=t1.a)))"
    end, {
        -- <randexpr-2.639>
        6212
        -- </randexpr-2.639>
    })

test:do_test(
    "randexpr-2.640",
    function()
        return test:execsql "SELECT coalesce((select t1.a from t1 where case when +(abs(e)/abs(19))+(abs(coalesce((select max(b) from t1 where 19 not in (f,(c),11) or  -c not in (t1.f,e,d)),13)*e+t1.f)/abs((d)))<>t1.b then t1.e when t1.d not in (t1.f,17,t1.b) or t1.f not between t1.d and 13 then t1.a else t1.e end>e or not exists(select 1 from t1 where a>=e or not exists(select 1 from t1 where d<>t1.b))),f)+19 FROM t1 WHERE 13 in (case when (select +max( -t1.b+a*case when not 13*13<t1.c then 19 else d end*11*c)+max(b) from t1)<>t1.f and ~e>= -t1.b then t1.c when 11 not between t1.d and e and (d<c) then t1.f else d end | e,a,t1.c)"
    end, {
        -- <randexpr-2.640>
        
        -- </randexpr-2.640>
    })

test:do_test(
    "randexpr-2.641",
    function()
        return test:execsql "SELECT coalesce((select t1.a from t1 where case when +(abs(e)/abs(19))+(abs(coalesce((select max(b) from t1 where 19 not in (f,(c),11) or  -c not in (t1.f,e,d)),13)*e+t1.f)/abs((d)))<>t1.b then t1.e when t1.d not in (t1.f,17,t1.b) or t1.f not between t1.d and 13 then t1.a else t1.e end>e or not exists(select 1 from t1 where a>=e or not exists(select 1 from t1 where d<>t1.b))),f)+19 FROM t1 WHERE NOT (13 in (case when (select +max( -t1.b+a*case when not 13*13<t1.c then 19 else d end*11*c)+max(b) from t1)<>t1.f and ~e>= -t1.b then t1.c when 11 not between t1.d and e and (d<c) then t1.f else d end | e,a,t1.c))"
    end, {
        -- <randexpr-2.641>
        119
        -- </randexpr-2.641>
    })

test:do_test(
    "randexpr-2.642",
    function()
        return test:execsql "SELECT +coalesce((select case when coalesce((select f+t1.e from t1 where b not in (case when not exists(select 1 from t1 where (f not in (t1.f-t1.b,t1.d,t1.d))) then t1.a when t1.f*t1.c*17>+(t1.e*(d))-t1.d then t1.f else 11 end,17,f)),e) | 19-13<d then t1.a else t1.d end from t1 where d not between c and e),19) FROM t1 WHERE not exists(select 1 from t1 where ((t1.c not between case d-c+(t1.b) when d then 17 else 13 end+f and coalesce((select t1.f from t1 where ((t1.f*case when not exists(select 1 from t1 where t1.f>=t1.b) then (select max(11)-(count(distinct f)) from t1) else t1.a end+c in (t1.d,e,f) or e in (11,11,11)))),b)*t1.b*11))) and t1.b>=a"
    end, {
        -- <randexpr-2.642>
        
        -- </randexpr-2.642>
    })

test:do_test(
    "randexpr-2.643",
    function()
        return test:execsql "SELECT +coalesce((select case when coalesce((select f+t1.e from t1 where b not in (case when not exists(select 1 from t1 where (f not in (t1.f-t1.b,t1.d,t1.d))) then t1.a when t1.f*t1.c*17>+(t1.e*(d))-t1.d then t1.f else 11 end,17,f)),e) | 19-13<d then t1.a else t1.d end from t1 where d not between c and e),19) FROM t1 WHERE NOT (not exists(select 1 from t1 where ((t1.c not between case d-c+(t1.b) when d then 17 else 13 end+f and coalesce((select t1.f from t1 where ((t1.f*case when not exists(select 1 from t1 where t1.f>=t1.b) then (select max(11)-(count(distinct f)) from t1) else t1.a end+c in (t1.d,e,f) or e in (11,11,11)))),b)*t1.b*11))) and t1.b>=a)"
    end, {
        -- <randexpr-2.643>
        19
        -- </randexpr-2.643>
    })

test:do_test(
    "randexpr-2.644",
    function()
        return test:execsql "SELECT +coalesce((select case when coalesce((select f+t1.e from t1 where b not in (case when not exists(select 1 from t1 where (f not in (t1.f-t1.b,t1.d,t1.d))) then t1.a when t1.f*t1.c*17>+(t1.e*(d))-t1.d then t1.f else 11 end,17,f)),e) & 19-13<d then t1.a else t1.d end from t1 where d not between c and e),19) FROM t1 WHERE NOT (not exists(select 1 from t1 where ((t1.c not between case d-c+(t1.b) when d then 17 else 13 end+f and coalesce((select t1.f from t1 where ((t1.f*case when not exists(select 1 from t1 where t1.f>=t1.b) then (select max(11)-(count(distinct f)) from t1) else t1.a end+c in (t1.d,e,f) or e in (11,11,11)))),b)*t1.b*11))) and t1.b>=a)"
    end, {
        -- <randexpr-2.644>
        19
        -- </randexpr-2.644>
    })

test:do_test(
    "randexpr-2.645",
    function()
        return test:execsql "SELECT (case when case 19 when b then 13 else t1.e end in (select (c) from t1 union select a from t1) then 11 else (d*coalesce((select t1.b from t1 where 19 | (t1.c)+case when  -17>t1.a then t1.a when (19>=13) then t1.a else t1.e end=f and (e)>a or 11 in (select e from t1 union select t1.b from t1)),t1.d*t1.e))+c+a end) FROM t1 WHERE case case when case when not (abs(t1.d | f)/abs(a)) in (d,a,t1.c) then  -d when (not exists(select 1 from t1 where f>=c)) then t1.a else e end+t1.d not in (t1.b,(t1.f),11) or not exists(select 1 from t1 where not exists(select 1 from t1 where t1.b in (19,t1.c,13))) then b+t1.c when t1.d>=t1.a then t1.c else (c) end when (13) then t1.e else b end in (t1.a,t1.b,13)"
    end, {
        -- <randexpr-2.645>
        80000400
        -- </randexpr-2.645>
    })

test:do_test(
    "randexpr-2.646",
    function()
        return test:execsql "SELECT (case when case 19 when b then 13 else t1.e end in (select (c) from t1 union select a from t1) then 11 else (d*coalesce((select t1.b from t1 where 19 | (t1.c)+case when  -17>t1.a then t1.a when (19>=13) then t1.a else t1.e end=f and (e)>a or 11 in (select e from t1 union select t1.b from t1)),t1.d*t1.e))+c+a end) FROM t1 WHERE NOT (case case when case when not (abs(t1.d | f)/abs(a)) in (d,a,t1.c) then  -d when (not exists(select 1 from t1 where f>=c)) then t1.a else e end+t1.d not in (t1.b,(t1.f),11) or not exists(select 1 from t1 where not exists(select 1 from t1 where t1.b in (19,t1.c,13))) then b+t1.c when t1.d>=t1.a then t1.c else (c) end when (13) then t1.e else b end in (t1.a,t1.b,13))"
    end, {
        -- <randexpr-2.646>
        
        -- </randexpr-2.646>
    })

test:do_test(
    "randexpr-2.647",
    function()
        return test:execsql "SELECT (case when case 19 when b then 13 else t1.e end in (select (c) from t1 union select a from t1) then 11 else (d*coalesce((select t1.b from t1 where 19 & (t1.c)+case when  -17>t1.a then t1.a when (19>=13) then t1.a else t1.e end=f and (e)>a or 11 in (select e from t1 union select t1.b from t1)),t1.d*t1.e))+c+a end) FROM t1 WHERE case case when case when not (abs(t1.d | f)/abs(a)) in (d,a,t1.c) then  -d when (not exists(select 1 from t1 where f>=c)) then t1.a else e end+t1.d not in (t1.b,(t1.f),11) or not exists(select 1 from t1 where not exists(select 1 from t1 where t1.b in (19,t1.c,13))) then b+t1.c when t1.d>=t1.a then t1.c else (c) end when (13) then t1.e else b end in (t1.a,t1.b,13)"
    end, {
        -- <randexpr-2.647>
        80000400
        -- </randexpr-2.647>
    })

test:do_test(
    "randexpr-2.648",
    function()
        return test:execsql "SELECT case when 19<=19 then d when not exists(select 1 from t1 where case case when case when (select  -min(((t1.f)))*((cast(avg(t1.d) AS integer))) from t1) in (select t1.a-b from t1 union select 17 from t1) then f when (19 not between t1.c and 13 and f>13) then d else a end | b-t1.b in (t1.e,t1.f, -d) then t1.e when c<t1.e then ( -b) else (c) end-t1.e | (17)+17 when 13 then t1.a else d end+19>=17) then t1.e else t1.e end FROM t1 WHERE coalesce((select +a- -t1.d*b*coalesce((select t1.c from t1 where t1.a in (select (abs(11)/abs(case when not exists(select 1 from t1 where +e=t1.e) then case t1.b when a-c then b else b end when (not exists(select 1 from t1 where 19 in (select 13 from t1 union select t1.b from t1))) and e in (t1.e, -f,e) then 19 else t1.a end)) from t1 union select b from t1)),17)*d from t1 where t1.f not in (t1.a,(t1.b),t1.d)),13)<=(13)"
    end, {
        -- <randexpr-2.648>
        
        -- </randexpr-2.648>
    })

test:do_test(
    "randexpr-2.649",
    function()
        return test:execsql "SELECT case when 19<=19 then d when not exists(select 1 from t1 where case case when case when (select  -min(((t1.f)))*((cast(avg(t1.d) AS integer))) from t1) in (select t1.a-b from t1 union select 17 from t1) then f when (19 not between t1.c and 13 and f>13) then d else a end | b-t1.b in (t1.e,t1.f, -d) then t1.e when c<t1.e then ( -b) else (c) end-t1.e | (17)+17 when 13 then t1.a else d end+19>=17) then t1.e else t1.e end FROM t1 WHERE NOT (coalesce((select +a- -t1.d*b*coalesce((select t1.c from t1 where t1.a in (select (abs(11)/abs(case when not exists(select 1 from t1 where +e=t1.e) then case t1.b when a-c then b else b end when (not exists(select 1 from t1 where 19 in (select 13 from t1 union select t1.b from t1))) and e in (t1.e, -f,e) then 19 else t1.a end)) from t1 union select b from t1)),17)*d from t1 where t1.f not in (t1.a,(t1.b),t1.d)),13)<=(13))"
    end, {
        -- <randexpr-2.649>
        400
        -- </randexpr-2.649>
    })

test:do_test(
    "randexpr-2.650",
    function()
        return test:execsql "SELECT case when 19<=19 then d when not exists(select 1 from t1 where case case when case when (select  -min(((t1.f)))*((cast(avg(t1.d) AS integer))) from t1) in (select t1.a-b from t1 union select 17 from t1) then f when (19 not between t1.c and 13 and f>13) then d else a end & b-t1.b in (t1.e,t1.f, -d) then t1.e when c<t1.e then ( -b) else (c) end-t1.e & (17)+17 when 13 then t1.a else d end+19>=17) then t1.e else t1.e end FROM t1 WHERE NOT (coalesce((select +a- -t1.d*b*coalesce((select t1.c from t1 where t1.a in (select (abs(11)/abs(case when not exists(select 1 from t1 where +e=t1.e) then case t1.b when a-c then b else b end when (not exists(select 1 from t1 where 19 in (select 13 from t1 union select t1.b from t1))) and e in (t1.e, -f,e) then 19 else t1.a end)) from t1 union select b from t1)),17)*d from t1 where t1.f not in (t1.a,(t1.b),t1.d)),13)<=(13))"
    end, {
        -- <randexpr-2.650>
        400
        -- </randexpr-2.650>
    })

test:do_test(
    "randexpr-2.651",
    function()
        return test:execsql "SELECT case when c<=t1.b*e+case when not exists(select 1 from t1 where a+ -t1.f= -t1.e*(17)+f and 19 in (select  -13 from t1 union select t1.f from t1) and 19>=t1.a or  -11 in (select a from t1 union select 17 from t1)) then t1.f else 19 end+t1.d or ((c))<>a then t1.f-t1.c when c not between ((t1.b)) and f then a else d end FROM t1 WHERE coalesce((select t1.e from t1 where t1.c in (t1.a,f,coalesce((select max( -f) from t1 where t1.f<coalesce((select (select cast(avg(b) AS integer) from t1) from t1 where a>=(abs(13)/abs(~19+(abs((select count(distinct t1.f) from t1))/abs(coalesce((select 13 from t1 where d | 17*c*a*b+d<>t1.a),b)-(b)))))),b)),19))),t1.e)*c<>t1.e"
    end, {
        -- <randexpr-2.651>
        300
        -- </randexpr-2.651>
    })

test:do_test(
    "randexpr-2.652",
    function()
        return test:execsql "SELECT case when c<=t1.b*e+case when not exists(select 1 from t1 where a+ -t1.f= -t1.e*(17)+f and 19 in (select  -13 from t1 union select t1.f from t1) and 19>=t1.a or  -11 in (select a from t1 union select 17 from t1)) then t1.f else 19 end+t1.d or ((c))<>a then t1.f-t1.c when c not between ((t1.b)) and f then a else d end FROM t1 WHERE NOT (coalesce((select t1.e from t1 where t1.c in (t1.a,f,coalesce((select max( -f) from t1 where t1.f<coalesce((select (select cast(avg(b) AS integer) from t1) from t1 where a>=(abs(13)/abs(~19+(abs((select count(distinct t1.f) from t1))/abs(coalesce((select 13 from t1 where d | 17*c*a*b+d<>t1.a),b)-(b)))))),b)),19))),t1.e)*c<>t1.e)"
    end, {
        -- <randexpr-2.652>
        
        -- </randexpr-2.652>
    })

test:do_test(
    "randexpr-2.653",
    function()
        return test:execsql "SELECT case when t1.c>=13 or d in (select case ((case min(t1.f)+min(f) when max( -11) then min(19) else cast(avg( -t1.d) AS integer) end | count(*))) when count(distinct 13) then  -cast(avg( -t1.e) AS integer) else min(e) end from t1 union select max( -a) from t1) then case when +c-11+(t1.d)<e or f in (select 17 from t1 union select 13 from t1) then f when t1.c in (select t1.c from t1 union select 19 from t1) then t1.f else  -f end when e in (a,19,t1.e) then t1.d else f end FROM t1 WHERE (c<=t1.f or 11<case when t1.b+ -~a*case when exists(select 1 from t1 where case when b | 17 not between 17 and c then 11 else t1.e end in (d,a,b)) then t1.b when t1.b not in (t1.f,b,c) then 11 else b end>13 then d when not exists(select 1 from t1 where t1.c in (f,t1.b,t1.b)) then a else 19 end*t1.c and t1.d>=19)"
    end, {
        -- <randexpr-2.653>
        600
        -- </randexpr-2.653>
    })

test:do_test(
    "randexpr-2.654",
    function()
        return test:execsql "SELECT case when t1.c>=13 or d in (select case ((case min(t1.f)+min(f) when max( -11) then min(19) else cast(avg( -t1.d) AS integer) end | count(*))) when count(distinct 13) then  -cast(avg( -t1.e) AS integer) else min(e) end from t1 union select max( -a) from t1) then case when +c-11+(t1.d)<e or f in (select 17 from t1 union select 13 from t1) then f when t1.c in (select t1.c from t1 union select 19 from t1) then t1.f else  -f end when e in (a,19,t1.e) then t1.d else f end FROM t1 WHERE NOT ((c<=t1.f or 11<case when t1.b+ -~a*case when exists(select 1 from t1 where case when b | 17 not between 17 and c then 11 else t1.e end in (d,a,b)) then t1.b when t1.b not in (t1.f,b,c) then 11 else b end>13 then d when not exists(select 1 from t1 where t1.c in (f,t1.b,t1.b)) then a else 19 end*t1.c and t1.d>=19))"
    end, {
        -- <randexpr-2.654>
        
        -- </randexpr-2.654>
    })

test:do_test(
    "randexpr-2.655",
    function()
        return test:execsql "SELECT case when t1.c>=13 or d in (select case ((case min(t1.f)+min(f) when max( -11) then min(19) else cast(avg( -t1.d) AS integer) end & count(*))) when count(distinct 13) then  -cast(avg( -t1.e) AS integer) else min(e) end from t1 union select max( -a) from t1) then case when +c-11+(t1.d)<e or f in (select 17 from t1 union select 13 from t1) then f when t1.c in (select t1.c from t1 union select 19 from t1) then t1.f else  -f end when e in (a,19,t1.e) then t1.d else f end FROM t1 WHERE (c<=t1.f or 11<case when t1.b+ -~a*case when exists(select 1 from t1 where case when b | 17 not between 17 and c then 11 else t1.e end in (d,a,b)) then t1.b when t1.b not in (t1.f,b,c) then 11 else b end>13 then d when not exists(select 1 from t1 where t1.c in (f,t1.b,t1.b)) then a else 19 end*t1.c and t1.d>=19)"
    end, {
        -- <randexpr-2.655>
        600
        -- </randexpr-2.655>
    })

test:do_test(
    "randexpr-2.656",
    function()
        return test:execsql "SELECT t1.a+(e*a)*t1.d+(abs(d)/abs(case when case f when t1.a then t1.f else d end*t1.f*t1.e*c*17+coalesce((select t1.d from t1 where c<=~t1.f | 13),e)*t1.a<case when 13 between a and 19 and c<a then t1.b else f end then t1.e when exists(select 1 from t1 where ((t1.b)=t1.f)) then t1.c else f end)) FROM t1 WHERE d*19 between 11 and f"
    end, {
        -- <randexpr-2.656>
        
        -- </randexpr-2.656>
    })

test:do_test(
    "randexpr-2.657",
    function()
        return test:execsql "SELECT t1.a+(e*a)*t1.d+(abs(d)/abs(case when case f when t1.a then t1.f else d end*t1.f*t1.e*c*17+coalesce((select t1.d from t1 where c<=~t1.f | 13),e)*t1.a<case when 13 between a and 19 and c<a then t1.b else f end then t1.e when exists(select 1 from t1 where ((t1.b)=t1.f)) then t1.c else f end)) FROM t1 WHERE NOT (d*19 between 11 and f)"
    end, {
        -- <randexpr-2.657>
        20000100
        -- </randexpr-2.657>
    })

test:do_test(
    "randexpr-2.658",
    function()
        return test:execsql "SELECT t1.a+(e*a)*t1.d+(abs(d)/abs(case when case f when t1.a then t1.f else d end*t1.f*t1.e*c*17+coalesce((select t1.d from t1 where c<=~t1.f & 13),e)*t1.a<case when 13 between a and 19 and c<a then t1.b else f end then t1.e when exists(select 1 from t1 where ((t1.b)=t1.f)) then t1.c else f end)) FROM t1 WHERE NOT (d*19 between 11 and f)"
    end, {
        -- <randexpr-2.658>
        20000100
        -- </randexpr-2.658>
    })

test:do_test(
    "randexpr-2.659",
    function()
        return test:execsql "SELECT case f when (abs(t1.f)/abs(case when d+case when exists(select 1 from t1 where exists(select 1 from t1 where exists(select 1 from t1 where case when not case when +11>=t1.d then t1.d when (t1.b)<>17 or t1.b<=t1.c then a else (e) end in (select min(t1.e) from t1 union select abs( -max((17))) from t1) then c when 19<>17 then 13 else  -d end>t1.d))) then 17 when t1.a<=13 then coalesce((select (17) | t1.c from t1 where t1.e>d),b) else 13 end in (select min(f) from t1 union select count(*) from t1) then 19 else t1.f end)) then t1.f else f end FROM t1 WHERE coalesce((select max(11 | e+case c*t1.b+13 when 19 | ~t1.f+case when d>11 then t1.f-(case t1.d when a then 19+t1.f else t1.b end) else d-case e when c+t1.a then 13 else case when not exists(select 1 from t1 where (t1.d)<>17) then d when b in ( -f,11,17) then 11 else t1.f end end end+d then e else t1.a end) from t1 where t1.a>= -11),b)>t1.c"
    end, {
        -- <randexpr-2.659>
        600
        -- </randexpr-2.659>
    })

test:do_test(
    "randexpr-2.660",
    function()
        return test:execsql "SELECT case f when (abs(t1.f)/abs(case when d+case when exists(select 1 from t1 where exists(select 1 from t1 where exists(select 1 from t1 where case when not case when +11>=t1.d then t1.d when (t1.b)<>17 or t1.b<=t1.c then a else (e) end in (select min(t1.e) from t1 union select abs( -max((17))) from t1) then c when 19<>17 then 13 else  -d end>t1.d))) then 17 when t1.a<=13 then coalesce((select (17) | t1.c from t1 where t1.e>d),b) else 13 end in (select min(f) from t1 union select count(*) from t1) then 19 else t1.f end)) then t1.f else f end FROM t1 WHERE NOT (coalesce((select max(11 | e+case c*t1.b+13 when 19 | ~t1.f+case when d>11 then t1.f-(case t1.d when a then 19+t1.f else t1.b end) else d-case e when c+t1.a then 13 else case when not exists(select 1 from t1 where (t1.d)<>17) then d when b in ( -f,11,17) then 11 else t1.f end end end+d then e else t1.a end) from t1 where t1.a>= -11),b)>t1.c)"
    end, {
        -- <randexpr-2.660>
        
        -- </randexpr-2.660>
    })

test:do_test(
    "randexpr-2.661",
    function()
        return test:execsql "SELECT case f when (abs(t1.f)/abs(case when d+case when exists(select 1 from t1 where exists(select 1 from t1 where exists(select 1 from t1 where case when not case when +11>=t1.d then t1.d when (t1.b)<>17 or t1.b<=t1.c then a else (e) end in (select min(t1.e) from t1 union select abs( -max((17))) from t1) then c when 19<>17 then 13 else  -d end>t1.d))) then 17 when t1.a<=13 then coalesce((select (17) & t1.c from t1 where t1.e>d),b) else 13 end in (select min(f) from t1 union select count(*) from t1) then 19 else t1.f end)) then t1.f else f end FROM t1 WHERE coalesce((select max(11 | e+case c*t1.b+13 when 19 | ~t1.f+case when d>11 then t1.f-(case t1.d when a then 19+t1.f else t1.b end) else d-case e when c+t1.a then 13 else case when not exists(select 1 from t1 where (t1.d)<>17) then d when b in ( -f,11,17) then 11 else t1.f end end end+d then e else t1.a end) from t1 where t1.a>= -11),b)>t1.c"
    end, {
        -- <randexpr-2.661>
        600
        -- </randexpr-2.661>
    })

test:do_test(
    "randexpr-2.662",
    function()
        return test:execsql "SELECT (select abs(case max(t1.b)-(min(17))* -count(distinct case when case t1.f when t1.b then case e when c then t1.c else c end else t1.b end>=t1.e then d else e end) | ~+count(distinct t1.c)-(abs( -count(*))- -max(c)) | count(distinct t1.c) when count(distinct ( -t1.c)) then count(*) else max(t1.b) end* -count(*))-cast(avg( -11) AS integer)*min(19)+max(e) from t1) FROM t1 WHERE t1.a+t1.a>13"
    end, {
        -- <randexpr-2.662>
        909
        -- </randexpr-2.662>
    })

test:do_test(
    "randexpr-2.663",
    function()
        return test:execsql "SELECT (select abs(case max(t1.b)-(min(17))* -count(distinct case when case t1.f when t1.b then case e when c then t1.c else c end else t1.b end>=t1.e then d else e end) | ~+count(distinct t1.c)-(abs( -count(*))- -max(c)) | count(distinct t1.c) when count(distinct ( -t1.c)) then count(*) else max(t1.b) end* -count(*))-cast(avg( -11) AS integer)*min(19)+max(e) from t1) FROM t1 WHERE NOT (t1.a+t1.a>13)"
    end, {
        -- <randexpr-2.663>
        
        -- </randexpr-2.663>
    })

test:do_test(
    "randexpr-2.664",
    function()
        return test:execsql "SELECT (select abs(case max(t1.b)-(min(17))* -count(distinct case when case t1.f when t1.b then case e when c then t1.c else c end else t1.b end>=t1.e then d else e end) & ~+count(distinct t1.c)-(abs( -count(*))- -max(c)) & count(distinct t1.c) when count(distinct ( -t1.c)) then count(*) else max(t1.b) end* -count(*))-cast(avg( -11) AS integer)*min(19)+max(e) from t1) FROM t1 WHERE t1.a+t1.a>13"
    end, {
        -- <randexpr-2.664>
        710
        -- </randexpr-2.664>
    })

test:do_test(
    "randexpr-2.665",
    function()
        return test:execsql "SELECT (t1.d- -c+e-f++case when a between case f when case when ~~~11-coalesce((select b from t1 where coalesce((select max(e) from t1 where not t1.d>= -11),a)+a between 11 and t1.a), -d)*17-a-13 | 13>=17 then a else 11 end then t1.a else t1.d end and t1.f then 19 else t1.a end) FROM t1 WHERE t1.f<> -13"
    end, {
        -- <randexpr-2.665>
        700
        -- </randexpr-2.665>
    })

test:do_test(
    "randexpr-2.666",
    function()
        return test:execsql "SELECT (t1.d- -c+e-f++case when a between case f when case when ~~~11-coalesce((select b from t1 where coalesce((select max(e) from t1 where not t1.d>= -11),a)+a between 11 and t1.a), -d)*17-a-13 | 13>=17 then a else 11 end then t1.a else t1.d end and t1.f then 19 else t1.a end) FROM t1 WHERE NOT (t1.f<> -13)"
    end, {
        -- <randexpr-2.666>
        
        -- </randexpr-2.666>
    })

test:do_test(
    "randexpr-2.667",
    function()
        return test:execsql "SELECT (t1.d- -c+e-f++case when a between case f when case when ~~~11-coalesce((select b from t1 where coalesce((select max(e) from t1 where not t1.d>= -11),a)+a between 11 and t1.a), -d)*17-a-13 & 13>=17 then a else 11 end then t1.a else t1.d end and t1.f then 19 else t1.a end) FROM t1 WHERE t1.f<> -13"
    end, {
        -- <randexpr-2.667>
        700
        -- </randexpr-2.667>
    })

test:do_test(
    "randexpr-2.668",
    function()
        return test:execsql "SELECT (abs(case when (c<=b+t1.b) then  -11+t1.a-d when b*(select count(distinct e)*+max(~t1.a*case when (select count(*)*+min(t1.b)+max(t1.a) from t1) in (c,t1.d,t1.d) then (select  -(count(*)) from t1) else e end) from t1)<=a-11 then 11 else t1.e end)/abs(t1.e))+c FROM t1 WHERE a<+coalesce((select t1.f from t1 where exists(select 1 from t1 where ~case when (e not between t1.a-~case d when b then  -c else 13 end and d) then 11 else a end+17-f-a*19*t1.f not in (f, -t1.d,11))),c)-t1.f and (t1.d<17) and t1.f=c or f<= -e"
    end, {
        -- <randexpr-2.668>
        
        -- </randexpr-2.668>
    })

test:do_test(
    "randexpr-2.669",
    function()
        return test:execsql "SELECT (abs(case when (c<=b+t1.b) then  -11+t1.a-d when b*(select count(distinct e)*+max(~t1.a*case when (select count(*)*+min(t1.b)+max(t1.a) from t1) in (c,t1.d,t1.d) then (select  -(count(*)) from t1) else e end) from t1)<=a-11 then 11 else t1.e end)/abs(t1.e))+c FROM t1 WHERE NOT (a<+coalesce((select t1.f from t1 where exists(select 1 from t1 where ~case when (e not between t1.a-~case d when b then  -c else 13 end and d) then 11 else a end+17-f-a*19*t1.f not in (f, -t1.d,11))),c)-t1.f and (t1.d<17) and t1.f=c or f<= -e)"
    end, {
        -- <randexpr-2.669>
        300
        -- </randexpr-2.669>
    })

test:do_test(
    "randexpr-2.670",
    function()
        return test:execsql "SELECT case when case when c in (select abs((max(d*case t1.b when t1.b+t1.f then d else b end+d))- - -~count(*)*cast(avg(t1.b) AS integer)-min(d)*cast(avg(b) AS integer)*count(*)) from t1 union select  -count(distinct t1.f) from t1) then case when 17 between t1.f and 11 then c else d end when t1.c>=13 then a else a end<=c then t1.d else 13 end+e FROM t1 WHERE t1.f between  -11 and b"
    end, {
        -- <randexpr-2.670>
        
        -- </randexpr-2.670>
    })

test:do_test(
    "randexpr-2.671",
    function()
        return test:execsql "SELECT case when case when c in (select abs((max(d*case t1.b when t1.b+t1.f then d else b end+d))- - -~count(*)*cast(avg(t1.b) AS integer)-min(d)*cast(avg(b) AS integer)*count(*)) from t1 union select  -count(distinct t1.f) from t1) then case when 17 between t1.f and 11 then c else d end when t1.c>=13 then a else a end<=c then t1.d else 13 end+e FROM t1 WHERE NOT (t1.f between  -11 and b)"
    end, {
        -- <randexpr-2.671>
        900
        -- </randexpr-2.671>
    })

test:do_test(
    "randexpr-2.672",
    function()
        return test:execsql "SELECT b*~~t1.b*(a-t1.c+t1.b)+13-+~case t1.b when d then case 17*13 when t1.e then case when case when t1.c<>~(11) then t1.e else coalesce((select max( -c) from t1 where (f<>e)),t1.f) end<=a then (t1.c) else t1.c end else  -f end else 13 end*t1.e-t1.f | 13 FROM t1 WHERE b between (d) and t1.c*(abs(t1.c-13 | t1.d+t1.a)/abs(13))"
    end, {
        -- <randexpr-2.672>
        
        -- </randexpr-2.672>
    })

test:do_test(
    "randexpr-2.673",
    function()
        return test:execsql "SELECT b*~~t1.b*(a-t1.c+t1.b)+13-+~case t1.b when d then case 17*13 when t1.e then case when case when t1.c<>~(11) then t1.e else coalesce((select max( -c) from t1 where (f<>e)),t1.f) end<=a then (t1.c) else t1.c end else  -f end else 13 end*t1.e-t1.f | 13 FROM t1 WHERE NOT (b between (d) and t1.c*(abs(t1.c-13 | t1.d+t1.a)/abs(13)))"
    end, {
        -- <randexpr-2.673>
        6413
        -- </randexpr-2.673>
    })

test:do_test(
    "randexpr-2.674",
    function()
        return test:execsql "SELECT b*~~t1.b*(a-t1.c+t1.b)+13-+~case t1.b when d then case 17*13 when t1.e then case when case when t1.c<>~(11) then t1.e else coalesce((select max( -c) from t1 where (f<>e)),t1.f) end<=a then (t1.c) else t1.c end else  -f end else 13 end*t1.e-t1.f & 13 FROM t1 WHERE NOT (b between (d) and t1.c*(abs(t1.c-13 | t1.d+t1.a)/abs(13)))"
    end, {
        -- <randexpr-2.674>
        13
        -- </randexpr-2.674>
    })

test:do_test(
    "randexpr-2.675",
    function()
        return test:execsql "SELECT case when t1.b in (select case 13 when 13 | t1.e then case +(select (min((e)))-case count(*) | max(t1.b*d+17+e) when abs(count(distinct (11))*count(*)-cast(avg(a) AS integer) | max( -t1.a)) then (count(distinct 13)) else  -(cast(avg(t1.b) AS integer)) end from t1) when (select count(distinct e) from t1) then t1.e else a+(t1.b) end-d-t1.d else t1.e end from t1 union select (f) from t1) then t1.b else (b) end FROM t1 WHERE b in (select a from t1 union select 11+t1.e from t1)"
    end, {
        -- <randexpr-2.675>
        
        -- </randexpr-2.675>
    })

test:do_test(
    "randexpr-2.676",
    function()
        return test:execsql "SELECT case when t1.b in (select case 13 when 13 | t1.e then case +(select (min((e)))-case count(*) | max(t1.b*d+17+e) when abs(count(distinct (11))*count(*)-cast(avg(a) AS integer) | max( -t1.a)) then (count(distinct 13)) else  -(cast(avg(t1.b) AS integer)) end from t1) when (select count(distinct e) from t1) then t1.e else a+(t1.b) end-d-t1.d else t1.e end from t1 union select (f) from t1) then t1.b else (b) end FROM t1 WHERE NOT (b in (select a from t1 union select 11+t1.e from t1))"
    end, {
        -- <randexpr-2.676>
        200
        -- </randexpr-2.676>
    })

test:do_test(
    "randexpr-2.677",
    function()
        return test:execsql "SELECT case when t1.b in (select case 13 when 13 & t1.e then case +(select (min((e)))-case count(*) & max(t1.b*d+17+e) when abs(count(distinct (11))*count(*)-cast(avg(a) AS integer) & max( -t1.a)) then (count(distinct 13)) else  -(cast(avg(t1.b) AS integer)) end from t1) when (select count(distinct e) from t1) then t1.e else a+(t1.b) end-d-t1.d else t1.e end from t1 union select (f) from t1) then t1.b else (b) end FROM t1 WHERE NOT (b in (select a from t1 union select 11+t1.e from t1))"
    end, {
        -- <randexpr-2.677>
        200
        -- </randexpr-2.677>
    })

test:do_test(
    "randexpr-2.678",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where d between 17 and 13),case when t1.f in (select c+a from t1 union select a from t1) and (abs(f)/abs(t1.b))-t1.e>=case when not exists(select 1 from t1 where t1.e>(select count(distinct t1.f) from t1)) then t1.f when (11)-~t1.f<case 13 when f then 19 else coalesce((select  -t1.c from t1 where 11<=t1.e),e) end then t1.e else 13 end*t1.e then t1.f else b end) FROM t1 WHERE  -coalesce((select max(11) from t1 where (abs( -case 19 when (abs(coalesce((select max(coalesce((select 13 from t1 where a>e),b)) from t1 where (t1.f) in (13,e,t1.c) or t1.c>13),t1.b))/abs(13)) then t1.b else d end)/abs(13)) in (t1.f,t1.e,t1.a) or 17 between 13 and f or (f>11 and t1.f<t1.b)),case when 19 not between  -17 and d then 11 when t1.c=d then t1.a else t1.f end)>=t1.e"
    end, {
        -- <randexpr-2.678>
        
        -- </randexpr-2.678>
    })

test:do_test(
    "randexpr-2.679",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where d between 17 and 13),case when t1.f in (select c+a from t1 union select a from t1) and (abs(f)/abs(t1.b))-t1.e>=case when not exists(select 1 from t1 where t1.e>(select count(distinct t1.f) from t1)) then t1.f when (11)-~t1.f<case 13 when f then 19 else coalesce((select  -t1.c from t1 where 11<=t1.e),e) end then t1.e else 13 end*t1.e then t1.f else b end) FROM t1 WHERE NOT ( -coalesce((select max(11) from t1 where (abs( -case 19 when (abs(coalesce((select max(coalesce((select 13 from t1 where a>e),b)) from t1 where (t1.f) in (13,e,t1.c) or t1.c>13),t1.b))/abs(13)) then t1.b else d end)/abs(13)) in (t1.f,t1.e,t1.a) or 17 between 13 and f or (f>11 and t1.f<t1.b)),case when 19 not between  -17 and d then 11 when t1.c=d then t1.a else t1.f end)>=t1.e)"
    end, {
        -- <randexpr-2.679>
        200
        -- </randexpr-2.679>
    })

test:do_test(
    "randexpr-2.680",
    function()
        return test:execsql "SELECT (select min(19-case 19 when  -t1.a+13 then coalesce((select c from t1 where (abs(13)/abs(11))>=coalesce((select f+b*+t1.c from t1 where t1.c=+11+t1.e),11) or (e in (a,a,13) and t1.a<f) and t1.c not between t1.f and  -b),t1.b) else t1.b end) from t1) | f FROM t1 WHERE case 13-t1.e when 13 then f*c else ~f+(abs(t1.f | t1.e-c)/abs((coalesce((select max((select  -cast(avg(b) AS integer) from t1)-b) from t1 where 17 in (c,( -(f)),11) and 17>=f or t1.a=t1.e),t1.f)*t1.a+t1.f)*19)) end*f-t1.f in (select d from t1 union select t1.c from t1) and b in (t1.f,t1.d,c)"
    end, {
        -- <randexpr-2.680>
        
        -- </randexpr-2.680>
    })

test:do_test(
    "randexpr-2.681",
    function()
        return test:execsql "SELECT (select min(19-case 19 when  -t1.a+13 then coalesce((select c from t1 where (abs(13)/abs(11))>=coalesce((select f+b*+t1.c from t1 where t1.c=+11+t1.e),11) or (e in (a,a,13) and t1.a<f) and t1.c not between t1.f and  -b),t1.b) else t1.b end) from t1) | f FROM t1 WHERE NOT (case 13-t1.e when 13 then f*c else ~f+(abs(t1.f | t1.e-c)/abs((coalesce((select max((select  -cast(avg(b) AS integer) from t1)-b) from t1 where 17 in (c,( -(f)),11) and 17>=f or t1.a=t1.e),t1.f)*t1.a+t1.f)*19)) end*f-t1.f in (select d from t1 union select t1.c from t1) and b in (t1.f,t1.d,c))"
    end, {
        -- <randexpr-2.681>
        -165
        -- </randexpr-2.681>
    })

test:do_test(
    "randexpr-2.682",
    function()
        return test:execsql "SELECT (select min(19-case 19 when  -t1.a+13 then coalesce((select c from t1 where (abs(13)/abs(11))>=coalesce((select f+b*+t1.c from t1 where t1.c=+11+t1.e),11) or (e in (a,a,13) and t1.a<f) and t1.c not between t1.f and  -b),t1.b) else t1.b end) from t1) & f FROM t1 WHERE NOT (case 13-t1.e when 13 then f*c else ~f+(abs(t1.f | t1.e-c)/abs((coalesce((select max((select  -cast(avg(b) AS integer) from t1)-b) from t1 where 17 in (c,( -(f)),11) and 17>=f or t1.a=t1.e),t1.f)*t1.a+t1.f)*19)) end*f-t1.f in (select d from t1 union select t1.c from t1) and b in (t1.f,t1.d,c))"
    end, {
        -- <randexpr-2.682>
        584
        -- </randexpr-2.682>
    })

test:do_test(
    "randexpr-2.683",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where t1.c not between case case ~t1.b*19 when b then t1.c*t1.e else t1.d end when c then case ++13 when case when a+d+~~11 not between e and  -19 then 19 else b end then t1.d else 19 end else t1.a end and d) then 19 when c in (select abs(count(distinct 17)) from t1 union select max(t1.b) from t1) then (d) else t1.e end | 19 FROM t1 WHERE t1.d between 11 and ~19-coalesce((select d from t1 where (d>=c)),t1.d)*+t1.e+t1.e"
    end, {
        -- <randexpr-2.683>
        
        -- </randexpr-2.683>
    })

test:do_test(
    "randexpr-2.684",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where t1.c not between case case ~t1.b*19 when b then t1.c*t1.e else t1.d end when c then case ++13 when case when a+d+~~11 not between e and  -19 then 19 else b end then t1.d else 19 end else t1.a end and d) then 19 when c in (select abs(count(distinct 17)) from t1 union select max(t1.b) from t1) then (d) else t1.e end | 19 FROM t1 WHERE NOT (t1.d between 11 and ~19-coalesce((select d from t1 where (d>=c)),t1.d)*+t1.e+t1.e)"
    end, {
        -- <randexpr-2.684>
        -485
        -- </randexpr-2.684>
    })

test:do_test(
    "randexpr-2.685",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where t1.c not between case case ~t1.b*19 when b then t1.c*t1.e else t1.d end when c then case ++13 when case when a+d+~~11 not between e and  -19 then 19 else b end then t1.d else 19 end else t1.a end and d) then 19 when c in (select abs(count(distinct 17)) from t1 union select max(t1.b) from t1) then (d) else t1.e end & 19 FROM t1 WHERE NOT (t1.d between 11 and ~19-coalesce((select d from t1 where (d>=c)),t1.d)*+t1.e+t1.e)"
    end, {
        -- <randexpr-2.685>
        3
        -- </randexpr-2.685>
    })

test:do_test(
    "randexpr-2.686",
    function()
        return test:execsql "SELECT +t1.b-17*11-coalesce((select coalesce((select max(t1.f+a-t1.c+b) from t1 where 17* -b+t1.e=13),coalesce((select +t1.f*coalesce((select b from t1 where 19 between  -a and c),t1.d) from t1 where 17<>b),17)*11) from t1 where f<c),e) |  -t1.e-b-t1.b-t1.e FROM t1 WHERE t1.b=11"
    end, {
        -- <randexpr-2.686>
        
        -- </randexpr-2.686>
    })

test:do_test(
    "randexpr-2.687",
    function()
        return test:execsql "SELECT +t1.b-17*11-coalesce((select coalesce((select max(t1.f+a-t1.c+b) from t1 where 17* -b+t1.e=13),coalesce((select +t1.f*coalesce((select b from t1 where 19 between  -a and c),t1.d) from t1 where 17<>b),17)*11) from t1 where f<c),e) |  -t1.e-b-t1.b-t1.e FROM t1 WHERE NOT (t1.b=11)"
    end, {
        -- <randexpr-2.687>
        -359
        -- </randexpr-2.687>
    })

test:do_test(
    "randexpr-2.688",
    function()
        return test:execsql "SELECT +t1.b-17*11-coalesce((select coalesce((select max(t1.f+a-t1.c+b) from t1 where 17* -b+t1.e=13),coalesce((select +t1.f*coalesce((select b from t1 where 19 between  -a and c),t1.d) from t1 where 17<>b),17)*11) from t1 where f<c),e) &  -t1.e-b-t1.b-t1.e FROM t1 WHERE NOT (t1.b=11)"
    end, {
        -- <randexpr-2.688>
        -1528
        -- </randexpr-2.688>
    })

test:do_test(
    "randexpr-2.689",
    function()
        return test:execsql "SELECT  -d+t1.d-t1.a-+t1.c-(select +min((abs(+(case when b>=case when b not between  -t1.f and c then e else f end or a<=11 or t1.e between a and 11 or t1.d not in (b,d,d) then case when f>=c then t1.c else 19 end when t1.e=a then e else t1.e end) | f)/abs(t1.a))) from t1)+e* -t1.a+f+d FROM t1 WHERE t1.b<=t1.c+ -(abs(t1.b)/abs(case t1.b+t1.e when 11 then t1.c else 17 end))*coalesce((select coalesce((select coalesce((select 13 from t1 where b=t1.b),f) | t1.f-11 from t1 where (t1.c) in (select +min(19)*(~max(b)-max(11))*max(11) from t1 union select min(f) from t1)),t1.f) from t1 where f in (select case count(distinct 19) when max(t1.b) then  -cast(avg(t1.e) AS integer) else cast(avg(b) AS integer) end from t1 union select count(*) from t1)),t1.a)"
    end, {
        -- <randexpr-2.689>
        
        -- </randexpr-2.689>
    })

test:do_test(
    "randexpr-2.690",
    function()
        return test:execsql "SELECT  -d+t1.d-t1.a-+t1.c-(select +min((abs(+(case when b>=case when b not between  -t1.f and c then e else f end or a<=11 or t1.e between a and 11 or t1.d not in (b,d,d) then case when f>=c then t1.c else 19 end when t1.e=a then e else t1.e end) | f)/abs(t1.a))) from t1)+e* -t1.a+f+d FROM t1 WHERE NOT (t1.b<=t1.c+ -(abs(t1.b)/abs(case t1.b+t1.e when 11 then t1.c else 17 end))*coalesce((select coalesce((select coalesce((select 13 from t1 where b=t1.b),f) | t1.f-11 from t1 where (t1.c) in (select +min(19)*(~max(b)-max(11))*max(11) from t1 union select min(f) from t1)),t1.f) from t1 where f in (select case count(distinct 19) when max(t1.b) then  -cast(avg(t1.e) AS integer) else cast(avg(b) AS integer) end from t1 union select count(*) from t1)),t1.a))"
    end, {
        -- <randexpr-2.690>
        -49410
        -- </randexpr-2.690>
    })

test:do_test(
    "randexpr-2.691",
    function()
        return test:execsql "SELECT  -d+t1.d-t1.a-+t1.c-(select +min((abs(+(case when b>=case when b not between  -t1.f and c then e else f end or a<=11 or t1.e between a and 11 or t1.d not in (b,d,d) then case when f>=c then t1.c else 19 end when t1.e=a then e else t1.e end) & f)/abs(t1.a))) from t1)+e* -t1.a+f+d FROM t1 WHERE NOT (t1.b<=t1.c+ -(abs(t1.b)/abs(case t1.b+t1.e when 11 then t1.c else 17 end))*coalesce((select coalesce((select coalesce((select 13 from t1 where b=t1.b),f) | t1.f-11 from t1 where (t1.c) in (select +min(19)*(~max(b)-max(11))*max(11) from t1 union select min(f) from t1)),t1.f) from t1 where f in (select case count(distinct 19) when max(t1.b) then  -cast(avg(t1.e) AS integer) else cast(avg(b) AS integer) end from t1 union select count(*) from t1)),t1.a))"
    end, {
        -- <randexpr-2.691>
        -49400
        -- </randexpr-2.691>
    })

test:do_test(
    "randexpr-2.692",
    function()
        return test:execsql "SELECT ~case +t1.a when t1.a then 19 else coalesce((select max(t1.d) from t1 where not exists(select 1 from t1 where t1.b*f<>e and e not in (17,t1.c-case when t1.e<19 then t1.c else (abs(t1.c)/abs(d*coalesce((select t1.e from t1 where exists(select 1 from t1 where t1.c in (select t1.f from t1 union select 11 from t1)) or t1.a<=t1.d),a))) end*t1.e,t1.e))),coalesce((select max(a) from t1 where (b) in ((11),e,b)),17)) end FROM t1 WHERE not (c)+c*d>t1.e and exists(select 1 from t1 where d*coalesce((select +case when ((select cast(avg((c)) AS integer)- -cast(avg(a) AS integer) from t1) in (select min(b)-count(*) from t1 union select count(distinct 19) from t1)) or not t1.b between 19 and 19 then t1.c else coalesce((select e from t1 where t1.e>=e),c) end from t1 where ( -f)<a),17)>19) and 17<> -t1.e and b>=a"
    end, {
        -- <randexpr-2.692>
        
        -- </randexpr-2.692>
    })

test:do_test(
    "randexpr-2.693",
    function()
        return test:execsql "SELECT ~case +t1.a when t1.a then 19 else coalesce((select max(t1.d) from t1 where not exists(select 1 from t1 where t1.b*f<>e and e not in (17,t1.c-case when t1.e<19 then t1.c else (abs(t1.c)/abs(d*coalesce((select t1.e from t1 where exists(select 1 from t1 where t1.c in (select t1.f from t1 union select 11 from t1)) or t1.a<=t1.d),a))) end*t1.e,t1.e))),coalesce((select max(a) from t1 where (b) in ((11),e,b)),17)) end FROM t1 WHERE NOT (not (c)+c*d>t1.e and exists(select 1 from t1 where d*coalesce((select +case when ((select cast(avg((c)) AS integer)- -cast(avg(a) AS integer) from t1) in (select min(b)-count(*) from t1 union select count(distinct 19) from t1)) or not t1.b between 19 and 19 then t1.c else coalesce((select e from t1 where t1.e>=e),c) end from t1 where ( -f)<a),17)>19) and 17<> -t1.e and b>=a)"
    end, {
        -- <randexpr-2.693>
        -20
        -- </randexpr-2.693>
    })

test:do_test(
    "randexpr-2.694",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d-t1.e) from t1 where not exists(select 1 from t1 where c*+19<=(d)) or c+e not between a and ~f*t1.f*case when t1.e<> -coalesce((select case when ((e between t1.d and f)) then  -(17) | b else t1.d end from t1 where b in (select t1.c from t1 union select 11 from t1)),d) then t1.d when e not in ( -t1.b,t1.c,(t1.e)) then t1.c else d end), -b) FROM t1 WHERE t1.d<>d"
    end, {
        -- <randexpr-2.694>
        
        -- </randexpr-2.694>
    })

test:do_test(
    "randexpr-2.695",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d-t1.e) from t1 where not exists(select 1 from t1 where c*+19<=(d)) or c+e not between a and ~f*t1.f*case when t1.e<> -coalesce((select case when ((e between t1.d and f)) then  -(17) | b else t1.d end from t1 where b in (select t1.c from t1 union select 11 from t1)),d) then t1.d when e not in ( -t1.b,t1.c,(t1.e)) then t1.c else d end), -b) FROM t1 WHERE NOT (t1.d<>d)"
    end, {
        -- <randexpr-2.695>
        -100
        -- </randexpr-2.695>
    })

test:do_test(
    "randexpr-2.696",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d-t1.e) from t1 where not exists(select 1 from t1 where c*+19<=(d)) or c+e not between a and ~f*t1.f*case when t1.e<> -coalesce((select case when ((e between t1.d and f)) then  -(17) & b else t1.d end from t1 where b in (select t1.c from t1 union select 11 from t1)),d) then t1.d when e not in ( -t1.b,t1.c,(t1.e)) then t1.c else d end), -b) FROM t1 WHERE NOT (t1.d<>d)"
    end, {
        -- <randexpr-2.696>
        -100
        -- </randexpr-2.696>
    })

test:do_test(
    "randexpr-2.697",
    function()
        return test:execsql "SELECT case when a in (select max(17) from t1 union select abs(count(*)) from t1) then t1.a- -e-t1.d | e- -t1.f*19+(select  -abs(max(a))*count(distinct e)*max(19) from t1)-11-13-d*11+t1.a else d end-b FROM t1 WHERE t1.e in (select (abs(case when (abs(f)/abs((select ~min(a) from t1)+coalesce((select t1.f from t1 where 11<>t1.b),19)))*t1.e+ -t1.d | e<=t1.f then  -e when (b)>t1.a then t1.d else t1.a end)/abs(11)) from t1 union select 13 from t1) and f not between t1.b and e or not exists(select 1 from t1 where not exists(select 1 from t1 where 19<c)) and t1.c not in (t1.d,e,t1.a)"
    end, {
        -- <randexpr-2.697>
        200
        -- </randexpr-2.697>
    })

test:do_test(
    "randexpr-2.698",
    function()
        return test:execsql "SELECT case when a in (select max(17) from t1 union select abs(count(*)) from t1) then t1.a- -e-t1.d | e- -t1.f*19+(select  -abs(max(a))*count(distinct e)*max(19) from t1)-11-13-d*11+t1.a else d end-b FROM t1 WHERE NOT (t1.e in (select (abs(case when (abs(f)/abs((select ~min(a) from t1)+coalesce((select t1.f from t1 where 11<>t1.b),19)))*t1.e+ -t1.d | e<=t1.f then  -e when (b)>t1.a then t1.d else t1.a end)/abs(11)) from t1 union select 13 from t1) and f not between t1.b and e or not exists(select 1 from t1 where not exists(select 1 from t1 where 19<c)) and t1.c not in (t1.d,e,t1.a))"
    end, {
        -- <randexpr-2.698>
        
        -- </randexpr-2.698>
    })

test:do_test(
    "randexpr-2.699",
    function()
        return test:execsql "SELECT case when a in (select max(17) from t1 union select abs(count(*)) from t1) then t1.a- -e-t1.d & e- -t1.f*19+(select  -abs(max(a))*count(distinct e)*max(19) from t1)-11-13-d*11+t1.a else d end-b FROM t1 WHERE t1.e in (select (abs(case when (abs(f)/abs((select ~min(a) from t1)+coalesce((select t1.f from t1 where 11<>t1.b),19)))*t1.e+ -t1.d | e<=t1.f then  -e when (b)>t1.a then t1.d else t1.a end)/abs(11)) from t1 union select 13 from t1) and f not between t1.b and e or not exists(select 1 from t1 where not exists(select 1 from t1 where 19<c)) and t1.c not in (t1.d,e,t1.a)"
    end, {
        -- <randexpr-2.699>
        200
        -- </randexpr-2.699>
    })

test:do_test(
    "randexpr-2.700",
    function()
        return test:execsql "SELECT coalesce((select f from t1 where (case t1.a*t1.b*c when t1.d*coalesce((select max(coalesce((select 19 from t1 where t1.b in (select max(~case  -e when c+coalesce((select max(e) from t1 where (t1.d) not between c and t1.f),17) then c else 13 end) from t1 union select count(distinct a) from t1)),t1.f)) from t1 where f>t1.d),c) then 19 else 17 end between t1.b and t1.f and t1.d not in (c,e,(17)))),11) FROM t1 WHERE (((select min(t1.f) from t1)<=e))"
    end, {
        -- <randexpr-2.700>
        
        -- </randexpr-2.700>
    })

test:do_test(
    "randexpr-2.701",
    function()
        return test:execsql "SELECT coalesce((select f from t1 where (case t1.a*t1.b*c when t1.d*coalesce((select max(coalesce((select 19 from t1 where t1.b in (select max(~case  -e when c+coalesce((select max(e) from t1 where (t1.d) not between c and t1.f),17) then c else 13 end) from t1 union select count(distinct a) from t1)),t1.f)) from t1 where f>t1.d),c) then 19 else 17 end between t1.b and t1.f and t1.d not in (c,e,(17)))),11) FROM t1 WHERE NOT ((((select min(t1.f) from t1)<=e)))"
    end, {
        -- <randexpr-2.701>
        11
        -- </randexpr-2.701>
    })

test:do_test(
    "randexpr-2.702",
    function()
        return test:execsql "SELECT case t1.a when e*t1.e then case when exists(select 1 from t1 where (coalesce((select max(17) from t1 where (not (case when not a>=13*c then t1.f else (11)*t1.b end between 11 and t1.f or t1.c>(t1.c)))),t1.b*~t1.c)*b*d>=13)) then (abs(17)/abs(e)) else b end else t1.f end | t1.c+t1.f FROM t1 WHERE coalesce((select max(11) from t1 where c-d not between ~case when (select +~count(distinct t1.f)*cast(avg(t1.e) AS integer) from t1)+19 not in (t1.e,t1.f,t1.a) then t1.a when a in (e,t1.d,d) then t1.b else t1.e end and t1.b and c>=e or (t1.d<>b) and not exists(select 1 from t1 where (t1.f between 13 and a))),t1.a)-e<=t1.e"
    end, {
        -- <randexpr-2.702>
        988
        -- </randexpr-2.702>
    })

test:do_test(
    "randexpr-2.703",
    function()
        return test:execsql "SELECT case t1.a when e*t1.e then case when exists(select 1 from t1 where (coalesce((select max(17) from t1 where (not (case when not a>=13*c then t1.f else (11)*t1.b end between 11 and t1.f or t1.c>(t1.c)))),t1.b*~t1.c)*b*d>=13)) then (abs(17)/abs(e)) else b end else t1.f end | t1.c+t1.f FROM t1 WHERE NOT (coalesce((select max(11) from t1 where c-d not between ~case when (select +~count(distinct t1.f)*cast(avg(t1.e) AS integer) from t1)+19 not in (t1.e,t1.f,t1.a) then t1.a when a in (e,t1.d,d) then t1.b else t1.e end and t1.b and c>=e or (t1.d<>b) and not exists(select 1 from t1 where (t1.f between 13 and a))),t1.a)-e<=t1.e)"
    end, {
        -- <randexpr-2.703>
        
        -- </randexpr-2.703>
    })

test:do_test(
    "randexpr-2.704",
    function()
        return test:execsql "SELECT case t1.a when e*t1.e then case when exists(select 1 from t1 where (coalesce((select max(17) from t1 where (not (case when not a>=13*c then t1.f else (11)*t1.b end between 11 and t1.f or t1.c>(t1.c)))),t1.b*~t1.c)*b*d>=13)) then (abs(17)/abs(e)) else b end else t1.f end & t1.c+t1.f FROM t1 WHERE coalesce((select max(11) from t1 where c-d not between ~case when (select +~count(distinct t1.f)*cast(avg(t1.e) AS integer) from t1)+19 not in (t1.e,t1.f,t1.a) then t1.a when a in (e,t1.d,d) then t1.b else t1.e end and t1.b and c>=e or (t1.d<>b) and not exists(select 1 from t1 where (t1.f between 13 and a))),t1.a)-e<=t1.e"
    end, {
        -- <randexpr-2.704>
        512
        -- </randexpr-2.704>
    })

test:do_test(
    "randexpr-2.705",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e+(t1.b)) from t1 where 17<=t1.d-(select ~+cast(avg(b) AS integer) | case  -case cast(avg(t1.e) AS integer) when min((abs((a))/abs(t1.e))) then cast(avg(t1.c) AS integer)+count(*) else min(d) end when max(t1.e) then count(*) else ( -count(*)) end-min(t1.b)-count(distinct  -a)*count(*) from t1) | c+coalesce((select f from t1 where (19=t1.c-t1.b)),t1.f+17)),f) FROM t1 WHERE c not between (abs(t1.f)/abs(case when t1.f+e<=t1.c+t1.d then case when d in (select +count(distinct case when  -t1.a*19-t1.c not between 11 and c then t1.e when (19<>19) then t1.d else d end) from t1 union select cast(avg(e) AS integer) from t1) then t1.e when c in (select count(*) from t1 union select cast(avg(f) AS integer)* - - -cast(avg(t1.e) AS integer) from t1) then b else (t1.b) end when not (11>=11) then  -t1.e else b end)) and t1.f"
    end, {
        -- <randexpr-2.705>
        
        -- </randexpr-2.705>
    })

test:do_test(
    "randexpr-2.706",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e+(t1.b)) from t1 where 17<=t1.d-(select ~+cast(avg(b) AS integer) | case  -case cast(avg(t1.e) AS integer) when min((abs((a))/abs(t1.e))) then cast(avg(t1.c) AS integer)+count(*) else min(d) end when max(t1.e) then count(*) else ( -count(*)) end-min(t1.b)-count(distinct  -a)*count(*) from t1) | c+coalesce((select f from t1 where (19=t1.c-t1.b)),t1.f+17)),f) FROM t1 WHERE NOT (c not between (abs(t1.f)/abs(case when t1.f+e<=t1.c+t1.d then case when d in (select +count(distinct case when  -t1.a*19-t1.c not between 11 and c then t1.e when (19<>19) then t1.d else d end) from t1 union select cast(avg(e) AS integer) from t1) then t1.e when c in (select count(*) from t1 union select cast(avg(f) AS integer)* - - -cast(avg(t1.e) AS integer) from t1) then b else (t1.b) end when not (11>=11) then  -t1.e else b end)) and t1.f)"
    end, {
        -- <randexpr-2.706>
        700
        -- </randexpr-2.706>
    })

test:do_test(
    "randexpr-2.707",
    function()
        return test:execsql "SELECT coalesce((select max(t1.e+(t1.b)) from t1 where 17<=t1.d-(select ~+cast(avg(b) AS integer) & case  -case cast(avg(t1.e) AS integer) when min((abs((a))/abs(t1.e))) then cast(avg(t1.c) AS integer)+count(*) else min(d) end when max(t1.e) then count(*) else ( -count(*)) end-min(t1.b)-count(distinct  -a)*count(*) from t1) & c+coalesce((select f from t1 where (19=t1.c-t1.b)),t1.f+17)),f) FROM t1 WHERE NOT (c not between (abs(t1.f)/abs(case when t1.f+e<=t1.c+t1.d then case when d in (select +count(distinct case when  -t1.a*19-t1.c not between 11 and c then t1.e when (19<>19) then t1.d else d end) from t1 union select cast(avg(e) AS integer) from t1) then t1.e when c in (select count(*) from t1 union select cast(avg(f) AS integer)* - - -cast(avg(t1.e) AS integer) from t1) then b else (t1.b) end when not (11>=11) then  -t1.e else b end)) and t1.f)"
    end, {
        -- <randexpr-2.707>
        700
        -- </randexpr-2.707>
    })

test:do_test(
    "randexpr-2.708",
    function()
        return test:execsql "SELECT 17-(abs(case when t1.e<+(select count(distinct  -f) from t1)+t1.b then +case when t1.b not in (coalesce((select max(coalesce((select case when 17<e then 13 else t1.e end+t1.b from t1 where not (t1.f) between d and ((t1.d))),t1.f)) from t1 where t1.f>=a and 13 not in (b,t1.f,d)),b),t1.d, -13) then (e) else (13) end-19 when not exists(select 1 from t1 where 19<>f) then c else t1.e end | t1.d)/abs((13)))*f FROM t1 WHERE coalesce((select f from t1 where coalesce((select ~d*19-d*~case c when case a when t1.e*19 then (select  - -( -max(t1.f))*cast(avg(t1.c) AS integer) from t1) else 13 end*13-11 then  -11 else t1.f end | t1.e | t1.f*19 from t1 where t1.f>t1.a),b)*b not in (17,17,t1.e)),t1.a)-b*d>=11"
    end, {
        -- <randexpr-2.708>
        
        -- </randexpr-2.708>
    })

test:do_test(
    "randexpr-2.709",
    function()
        return test:execsql "SELECT 17-(abs(case when t1.e<+(select count(distinct  -f) from t1)+t1.b then +case when t1.b not in (coalesce((select max(coalesce((select case when 17<e then 13 else t1.e end+t1.b from t1 where not (t1.f) between d and ((t1.d))),t1.f)) from t1 where t1.f>=a and 13 not in (b,t1.f,d)),b),t1.d, -13) then (e) else (13) end-19 when not exists(select 1 from t1 where 19<>f) then c else t1.e end | t1.d)/abs((13)))*f FROM t1 WHERE NOT (coalesce((select f from t1 where coalesce((select ~d*19-d*~case c when case a when t1.e*19 then (select  - -( -max(t1.f))*cast(avg(t1.c) AS integer) from t1) else 13 end*13-11 then  -11 else t1.f end | t1.e | t1.f*19 from t1 where t1.f>t1.a),b)*b not in (17,17,t1.e)),t1.a)-b*d>=11)"
    end, {
        -- <randexpr-2.709>
        -22783
        -- </randexpr-2.709>
    })

test:do_test(
    "randexpr-2.710",
    function()
        return test:execsql "SELECT 17-(abs(case when t1.e<+(select count(distinct  -f) from t1)+t1.b then +case when t1.b not in (coalesce((select max(coalesce((select case when 17<e then 13 else t1.e end+t1.b from t1 where not (t1.f) between d and ((t1.d))),t1.f)) from t1 where t1.f>=a and 13 not in (b,t1.f,d)),b),t1.d, -13) then (e) else (13) end-19 when not exists(select 1 from t1 where 19<>f) then c else t1.e end & t1.d)/abs((13)))*f FROM t1 WHERE NOT (coalesce((select f from t1 where coalesce((select ~d*19-d*~case c when case a when t1.e*19 then (select  - -( -max(t1.f))*cast(avg(t1.c) AS integer) from t1) else 13 end*13-11 then  -11 else t1.f end | t1.e | t1.f*19 from t1 where t1.f>t1.a),b)*b not in (17,17,t1.e)),t1.a)-b*d>=11)"
    end, {
        -- <randexpr-2.710>
        -17983
        -- </randexpr-2.710>
    })

test:do_test(
    "randexpr-2.711",
    function()
        return test:execsql "SELECT (select cast(avg(case when (e=case when e>d and case coalesce((select ((t1.b)) from t1 where 17<=t1.c),a) when t1.b then f else d end*b>t1.d then (t1.a) else 11 end or 17 not in (19,f,d) or not not exists(select 1 from t1 where  - -e>=13)) and 17 in ( -t1.b,c,t1.f) then t1.c when t1.c not between t1.f and 17 then t1.c else d end) AS integer) from t1)+b+a FROM t1 WHERE (((coalesce((select coalesce((select max(19) from t1 where d between ~t1.a and 11),c+d-coalesce((select e from t1 where (abs(b)/abs(coalesce((select 13 from t1 where case when (17) not in (19,t1.c,t1.b) or 17 not in (t1.b,t1.f,t1.e) then 11 else 19 end<>t1.c),11)*17))=t1.b),d)) from t1 where d not in (b,b,d)),t1.a) not between b and b) and d>=t1.d) and t1.d in (13,c,t1.b))"
    end, {
        -- <randexpr-2.711>
        
        -- </randexpr-2.711>
    })

test:do_test(
    "randexpr-2.712",
    function()
        return test:execsql "SELECT (select cast(avg(case when (e=case when e>d and case coalesce((select ((t1.b)) from t1 where 17<=t1.c),a) when t1.b then f else d end*b>t1.d then (t1.a) else 11 end or 17 not in (19,f,d) or not not exists(select 1 from t1 where  - -e>=13)) and 17 in ( -t1.b,c,t1.f) then t1.c when t1.c not between t1.f and 17 then t1.c else d end) AS integer) from t1)+b+a FROM t1 WHERE NOT ((((coalesce((select coalesce((select max(19) from t1 where d between ~t1.a and 11),c+d-coalesce((select e from t1 where (abs(b)/abs(coalesce((select 13 from t1 where case when (17) not in (19,t1.c,t1.b) or 17 not in (t1.b,t1.f,t1.e) then 11 else 19 end<>t1.c),11)*17))=t1.b),d)) from t1 where d not in (b,b,d)),t1.a) not between b and b) and d>=t1.d) and t1.d in (13,c,t1.b)))"
    end, {
        -- <randexpr-2.712>
        600
        -- </randexpr-2.712>
    })

test:do_test(
    "randexpr-2.713",
    function()
        return test:execsql "SELECT (abs((select +abs(+max(b) | abs(~~count(distinct  -19))) from t1))/abs(coalesce((select max(19*11*d) from t1 where (t1.e<=t1.e)),t1.f)))+case e when (t1.e) then d else c*13 | 11 end FROM t1 WHERE t1.d>=(case when (select count(*) from t1)*t1.c*t1.e+e<>t1.e*13 | f+(select (min(13+t1.b) | ~+~count(*)) from t1)*e*coalesce((select max(19+t1.a) from t1 where t1.e in (select +(count(distinct b))+count(*) from t1 union select ( -min(17)) from t1)),t1.a)-t1.d* -t1.e then e else  -a end)"
    end, {
        -- <randexpr-2.713>
        
        -- </randexpr-2.713>
    })

test:do_test(
    "randexpr-2.714",
    function()
        return test:execsql "SELECT (abs((select +abs(+max(b) | abs(~~count(distinct  -19))) from t1))/abs(coalesce((select max(19*11*d) from t1 where (t1.e<=t1.e)),t1.f)))+case e when (t1.e) then d else c*13 | 11 end FROM t1 WHERE NOT (t1.d>=(case when (select count(*) from t1)*t1.c*t1.e+e<>t1.e*13 | f+(select (min(13+t1.b) | ~+~count(*)) from t1)*e*coalesce((select max(19+t1.a) from t1 where t1.e in (select +(count(distinct b))+count(*) from t1 union select ( -min(17)) from t1)),t1.a)-t1.d* -t1.e then e else  -a end))"
    end, {
        -- <randexpr-2.714>
        400
        -- </randexpr-2.714>
    })

test:do_test(
    "randexpr-2.715",
    function()
        return test:execsql "SELECT (abs((select +abs(+max(b) & abs(~~count(distinct  -19))) from t1))/abs(coalesce((select max(19*11*d) from t1 where (t1.e<=t1.e)),t1.f)))+case e when (t1.e) then d else c*13 & 11 end FROM t1 WHERE NOT (t1.d>=(case when (select count(*) from t1)*t1.c*t1.e+e<>t1.e*13 | f+(select (min(13+t1.b) | ~+~count(*)) from t1)*e*coalesce((select max(19+t1.a) from t1 where t1.e in (select +(count(distinct b))+count(*) from t1 union select ( -min(17)) from t1)),t1.a)-t1.d* -t1.e then e else  -a end))"
    end, {
        -- <randexpr-2.715>
        400
        -- </randexpr-2.715>
    })

test:do_test(
    "randexpr-2.716",
    function()
        return test:execsql "SELECT  -17+c-(abs(t1.a)/abs(t1.c))-case when t1.a<>c then case when exists(select 1 from t1 where 11 not between + -d and d and 13 not between 13 and 17 or not  -f<=19 or (t1.a)<a or t1.a>(11)) and 11<t1.b then t1.e else coalesce((select case when t1.f not in (c,t1.c,t1.e) then (select +count(*) from t1) when  -t1.f>=t1.f then b else a end from t1 where t1.e in (e,t1.c,b)),11) end else  -17 end FROM t1 WHERE not exists(select 1 from t1 where t1.a>=coalesce((select t1.f from t1 where + -19*t1.c<~+t1.a*13),a))"
    end, {
        -- <randexpr-2.716>
        -217
        -- </randexpr-2.716>
    })

test:do_test(
    "randexpr-2.717",
    function()
        return test:execsql "SELECT  -17+c-(abs(t1.a)/abs(t1.c))-case when t1.a<>c then case when exists(select 1 from t1 where 11 not between + -d and d and 13 not between 13 and 17 or not  -f<=19 or (t1.a)<a or t1.a>(11)) and 11<t1.b then t1.e else coalesce((select case when t1.f not in (c,t1.c,t1.e) then (select +count(*) from t1) when  -t1.f>=t1.f then b else a end from t1 where t1.e in (e,t1.c,b)),11) end else  -17 end FROM t1 WHERE NOT (not exists(select 1 from t1 where t1.a>=coalesce((select t1.f from t1 where + -19*t1.c<~+t1.a*13),a)))"
    end, {
        -- <randexpr-2.717>
        
        -- </randexpr-2.717>
    })

test:do_test(
    "randexpr-2.718",
    function()
        return test:execsql "SELECT f*19+17*(select max(b)+count(*)- -~count(*)-min(case when (e<=b-t1.b) then case when t1.b>t1.a or f not in (c, -c,f) or f in (e,13,13) then t1.b else t1.b end else a end*a) from t1)+t1.f*(abs(case b | t1.c+t1.a when ((f)) then f else c end+b)/abs(17))-(c) FROM t1 WHERE t1.e>11"
    end, {
        -- <randexpr-2.718>
        -138117
        -- </randexpr-2.718>
    })

test:do_test(
    "randexpr-2.719",
    function()
        return test:execsql "SELECT f*19+17*(select max(b)+count(*)- -~count(*)-min(case when (e<=b-t1.b) then case when t1.b>t1.a or f not in (c, -c,f) or f in (e,13,13) then t1.b else t1.b end else a end*a) from t1)+t1.f*(abs(case b | t1.c+t1.a when ((f)) then f else c end+b)/abs(17))-(c) FROM t1 WHERE NOT (t1.e>11)"
    end, {
        -- <randexpr-2.719>
        
        -- </randexpr-2.719>
    })

test:do_test(
    "randexpr-2.720",
    function()
        return test:execsql "SELECT f*19+17*(select max(b)+count(*)- -~count(*)-min(case when (e<=b-t1.b) then case when t1.b>t1.a or f not in (c, -c,f) or f in (e,13,13) then t1.b else t1.b end else a end*a) from t1)+t1.f*(abs(case b & t1.c+t1.a when ((f)) then f else c end+b)/abs(17))-(c) FROM t1 WHERE t1.e>11"
    end, {
        -- <randexpr-2.720>
        -138117
        -- </randexpr-2.720>
    })

test:do_test(
    "randexpr-2.721",
    function()
        return test:execsql "SELECT  -case when case when (case (abs(13)/abs(t1.e-13*t1.f)) when b- -13+t1.d then 11 else a end) not between t1.b and b then t1.c when d not between t1.e and t1.c or t1.f in (select 11 from t1 union select f from t1) and 17=d then 13 else t1.a end+11>=f then a when f>b then t1.d else 17 end-t1.e FROM t1 WHERE (case when not exists(select 1 from t1 where exists(select 1 from t1 where (abs(b*d-t1.e)/abs(t1.b))>c)) and t1.d in (13,t1.f,17) then e else ( - -t1.a)+11+c end*t1.b in (select (case  -+min(17) when +count(*) | min(t1.a) | cast(avg(11) AS integer) then cast(avg(11) AS integer) else cast(avg(a) AS integer) end)-cast(avg(t1.a) AS integer) from t1 union select (min(t1.e)) from t1) or not t1.c in ((f),t1.c,(t1.e)))"
    end, {
        -- <randexpr-2.721>
        
        -- </randexpr-2.721>
    })

test:do_test(
    "randexpr-2.722",
    function()
        return test:execsql "SELECT  -case when case when (case (abs(13)/abs(t1.e-13*t1.f)) when b- -13+t1.d then 11 else a end) not between t1.b and b then t1.c when d not between t1.e and t1.c or t1.f in (select 11 from t1 union select f from t1) and 17=d then 13 else t1.a end+11>=f then a when f>b then t1.d else 17 end-t1.e FROM t1 WHERE NOT ((case when not exists(select 1 from t1 where exists(select 1 from t1 where (abs(b*d-t1.e)/abs(t1.b))>c)) and t1.d in (13,t1.f,17) then e else ( - -t1.a)+11+c end*t1.b in (select (case  -+min(17) when +count(*) | min(t1.a) | cast(avg(11) AS integer) then cast(avg(11) AS integer) else cast(avg(a) AS integer) end)-cast(avg(t1.a) AS integer) from t1 union select (min(t1.e)) from t1) or not t1.c in ((f),t1.c,(t1.e))))"
    end, {
        -- <randexpr-2.722>
        -900
        -- </randexpr-2.722>
    })

test:do_test(
    "randexpr-2.723",
    function()
        return test:execsql "SELECT case t1.a when a then t1.c else  -case coalesce((select t1.e from t1 where (abs(case when not (a*case when f>=f*13-19 then t1.e else +t1.a end=t1.a) then (select min(a)+min(+19) from t1) else case when t1.a=(f) then c else c end+17 end)/abs(t1.e)) between 17 and 13),e) when 17 then 13 else t1.d end end FROM t1 WHERE 17 in (select case cast(avg(b+b) AS integer) when abs(abs(count(*))) then min(case t1.c+t1.b+t1.e+17+case case when t1.b<>17 and t1.e>=t1.b then b else  -t1.f end when 11 then 13 else f end*t1.f*b when 19 then  -11 else t1.d end- -t1.f) else min(t1.c) end from t1 union select abs(abs(count(distinct b)*max(t1.d))+count(distinct 13)-count(*)) from t1)"
    end, {
        -- <randexpr-2.723>
        
        -- </randexpr-2.723>
    })

test:do_test(
    "randexpr-2.724",
    function()
        return test:execsql "SELECT case t1.a when a then t1.c else  -case coalesce((select t1.e from t1 where (abs(case when not (a*case when f>=f*13-19 then t1.e else +t1.a end=t1.a) then (select min(a)+min(+19) from t1) else case when t1.a=(f) then c else c end+17 end)/abs(t1.e)) between 17 and 13),e) when 17 then 13 else t1.d end end FROM t1 WHERE NOT (17 in (select case cast(avg(b+b) AS integer) when abs(abs(count(*))) then min(case t1.c+t1.b+t1.e+17+case case when t1.b<>17 and t1.e>=t1.b then b else  -t1.f end when 11 then 13 else f end*t1.f*b when 19 then  -11 else t1.d end- -t1.f) else min(t1.c) end from t1 union select abs(abs(count(distinct b)*max(t1.d))+count(distinct 13)-count(*)) from t1))"
    end, {
        -- <randexpr-2.724>
        300
        -- </randexpr-2.724>
    })

test:do_test(
    "randexpr-2.725",
    function()
        return test:execsql "SELECT case when coalesce((select e from t1 where coalesce((select coalesce((select max( -coalesce((select max(case when exists(select 1 from t1 where not exists(select 1 from t1 where b in (select e+d from t1 union select t1.e from t1))) then t1.d else t1.f end) from t1 where exists(select 1 from t1 where f not in ((c),a,11))),e)) from t1 where t1.b=t1.f and e<d or d>t1.b),t1.b) from t1 where t1.a in (select a from t1 union select  -f from t1)),17)>=17),((b))) not in (t1.e,b,e) then 19 when not  -a<=f then t1.f else t1.b end FROM t1 WHERE 13=t1.d"
    end, {
        -- <randexpr-2.725>
        
        -- </randexpr-2.725>
    })

test:do_test(
    "randexpr-2.726",
    function()
        return test:execsql "SELECT case when coalesce((select e from t1 where coalesce((select coalesce((select max( -coalesce((select max(case when exists(select 1 from t1 where not exists(select 1 from t1 where b in (select e+d from t1 union select t1.e from t1))) then t1.d else t1.f end) from t1 where exists(select 1 from t1 where f not in ((c),a,11))),e)) from t1 where t1.b=t1.f and e<d or d>t1.b),t1.b) from t1 where t1.a in (select a from t1 union select  -f from t1)),17)>=17),((b))) not in (t1.e,b,e) then 19 when not  -a<=f then t1.f else t1.b end FROM t1 WHERE NOT (13=t1.d)"
    end, {
        -- <randexpr-2.726>
        200
        -- </randexpr-2.726>
    })

test:do_test(
    "randexpr-2.727",
    function()
        return test:execsql "SELECT 19*13+((abs(case when 17*d in ((abs((case (abs((abs((select abs(min(d))+cast(avg(19) AS integer) from t1) | t1.d | 11 | b)/abs(19)))/abs(b)) when 11 then a else e end))/abs(13)),t1.f,b) then t1.b when t1.c>=t1.d then (t1.c) else c end*d)/abs(f))) | t1.a-a-17 FROM t1 WHERE ( -t1.d+coalesce((select max(11) from t1 where t1.c between 13 and t1.d and case d when b then 13+ -~t1.a else +case when coalesce((select max((select +case (cast(avg(e) AS integer)) when count(distinct t1.a) then count(*) else min(( -d)) end from t1)-+a+d) from t1 where (e in (17,t1.e, -a))),b)<>f then a else 11 end end<(t1.e)),t1.d) in (select t1.a from t1 union select b from t1))"
    end, {
        -- <randexpr-2.727>
        
        -- </randexpr-2.727>
    })

test:do_test(
    "randexpr-2.728",
    function()
        return test:execsql "SELECT 19*13+((abs(case when 17*d in ((abs((case (abs((abs((select abs(min(d))+cast(avg(19) AS integer) from t1) | t1.d | 11 | b)/abs(19)))/abs(b)) when 11 then a else e end))/abs(13)),t1.f,b) then t1.b when t1.c>=t1.d then (t1.c) else c end*d)/abs(f))) | t1.a-a-17 FROM t1 WHERE NOT (( -t1.d+coalesce((select max(11) from t1 where t1.c between 13 and t1.d and case d when b then 13+ -~t1.a else +case when coalesce((select max((select +case (cast(avg(e) AS integer)) when count(distinct t1.a) then count(*) else min(( -d)) end from t1)-+a+d) from t1 where (e in (17,t1.e, -a))),b)<>f then a else 11 end end<(t1.e)),t1.d) in (select t1.a from t1 union select b from t1)))"
    end, {
        -- <randexpr-2.728>
        -1
        -- </randexpr-2.728>
    })

test:do_test(
    "randexpr-2.729",
    function()
        return test:execsql "SELECT 19*13+((abs(case when 17*d in ((abs((case (abs((abs((select abs(min(d))+cast(avg(19) AS integer) from t1) & t1.d & 11 & b)/abs(19)))/abs(b)) when 11 then a else e end))/abs(13)),t1.f,b) then t1.b when t1.c>=t1.d then (t1.c) else c end*d)/abs(f))) & t1.a-a-17 FROM t1 WHERE NOT (( -t1.d+coalesce((select max(11) from t1 where t1.c between 13 and t1.d and case d when b then 13+ -~t1.a else +case when coalesce((select max((select +case (cast(avg(e) AS integer)) when count(distinct t1.a) then count(*) else min(( -d)) end from t1)-+a+d) from t1 where (e in (17,t1.e, -a))),b)<>f then a else 11 end end<(t1.e)),t1.d) in (select t1.a from t1 union select b from t1)))"
    end, {
        -- <randexpr-2.729>
        431
        -- </randexpr-2.729>
    })

test:do_test(
    "randexpr-2.730",
    function()
        return test:execsql "SELECT case when (19*b)+11*~f-coalesce((select max(11) from t1 where f<>case when case 17 when 11 then 17 else c end-11 in (t1.c,c,t1.e) and 19=t1.a or 17<=e or e<=19 then 19 | c when t1.b=t1.f then d else 19 end or t1.e not in (13,19,c)),b) |  -c not between  -e and  -a then (t1.c) else t1.d end FROM t1 WHERE c in (select case abs((count(*))) when  -max(t1.c) | abs(abs(+count(*)))-~case (case  -max(e) when max(11)- -count(*) then ((max(t1.e))) else count(*) end) when count(distinct t1.e) then cast(avg(f) AS integer) else cast(avg(t1.c) AS integer) end* -cast(avg(f) AS integer) then max(f) else (max(b)) end from t1 union select (max(13)) from t1) and not exists(select 1 from t1 where case when t1.e<=19-b then c else c end in (select c from t1 union select (select  -((count(distinct t1.d))) from t1)-t1.b from t1))"
    end, {
        -- <randexpr-2.730>
        
        -- </randexpr-2.730>
    })

test:do_test(
    "randexpr-2.731",
    function()
        return test:execsql "SELECT case when (19*b)+11*~f-coalesce((select max(11) from t1 where f<>case when case 17 when 11 then 17 else c end-11 in (t1.c,c,t1.e) and 19=t1.a or 17<=e or e<=19 then 19 | c when t1.b=t1.f then d else 19 end or t1.e not in (13,19,c)),b) |  -c not between  -e and  -a then (t1.c) else t1.d end FROM t1 WHERE NOT (c in (select case abs((count(*))) when  -max(t1.c) | abs(abs(+count(*)))-~case (case  -max(e) when max(11)- -count(*) then ((max(t1.e))) else count(*) end) when count(distinct t1.e) then cast(avg(f) AS integer) else cast(avg(t1.c) AS integer) end* -cast(avg(f) AS integer) then max(f) else (max(b)) end from t1 union select (max(13)) from t1) and not exists(select 1 from t1 where case when t1.e<=19-b then c else c end in (select c from t1 union select (select  -((count(distinct t1.d))) from t1)-t1.b from t1)))"
    end, {
        -- <randexpr-2.731>
        400
        -- </randexpr-2.731>
    })

test:do_test(
    "randexpr-2.732",
    function()
        return test:execsql "SELECT case when (19*b)+11*~f-coalesce((select max(11) from t1 where f<>case when case 17 when 11 then 17 else c end-11 in (t1.c,c,t1.e) and 19=t1.a or 17<=e or e<=19 then 19 & c when t1.b=t1.f then d else 19 end or t1.e not in (13,19,c)),b) &  -c not between  -e and  -a then (t1.c) else t1.d end FROM t1 WHERE NOT (c in (select case abs((count(*))) when  -max(t1.c) | abs(abs(+count(*)))-~case (case  -max(e) when max(11)- -count(*) then ((max(t1.e))) else count(*) end) when count(distinct t1.e) then cast(avg(f) AS integer) else cast(avg(t1.c) AS integer) end* -cast(avg(f) AS integer) then max(f) else (max(b)) end from t1 union select (max(13)) from t1) and not exists(select 1 from t1 where case when t1.e<=19-b then c else c end in (select c from t1 union select (select  -((count(distinct t1.d))) from t1)-t1.b from t1)))"
    end, {
        -- <randexpr-2.732>
        300
        -- </randexpr-2.732>
    })

test:do_test(
    "randexpr-2.733",
    function()
        return test:execsql "SELECT case when t1.e not between e and 13 then (select count(*) from t1) when f>=case when c in (select a from t1 union select t1.e+coalesce((select 11 from t1 where (select count(distinct t1.b) from t1)+17 not in (b,t1.c,t1.f-(select ~count(distinct 17) from t1)+ -e)),13) from t1) or 19 between d and t1.f then (select min(19) from t1) when not (e not between c and a) then d else a end then d else (t1.c) end FROM t1 WHERE f not in (17,f+d | f+case when  -f=19 then (select max((select +abs(abs(max(((select ((max(t1.d))+count(distinct t1.e))-min(t1.a) from t1))+t1.e)-abs(count(distinct  -t1.b)-count(distinct 11)))*min(a)-count(*))-min(t1.a) from t1)) from t1) else t1.f end,c-a) and c<>11"
    end, {
        -- <randexpr-2.733>
        1
        -- </randexpr-2.733>
    })

test:do_test(
    "randexpr-2.734",
    function()
        return test:execsql "SELECT case when t1.e not between e and 13 then (select count(*) from t1) when f>=case when c in (select a from t1 union select t1.e+coalesce((select 11 from t1 where (select count(distinct t1.b) from t1)+17 not in (b,t1.c,t1.f-(select ~count(distinct 17) from t1)+ -e)),13) from t1) or 19 between d and t1.f then (select min(19) from t1) when not (e not between c and a) then d else a end then d else (t1.c) end FROM t1 WHERE NOT (f not in (17,f+d | f+case when  -f=19 then (select max((select +abs(abs(max(((select ((max(t1.d))+count(distinct t1.e))-min(t1.a) from t1))+t1.e)-abs(count(distinct  -t1.b)-count(distinct 11)))*min(a)-count(*))-min(t1.a) from t1)) from t1) else t1.f end,c-a) and c<>11)"
    end, {
        -- <randexpr-2.734>
        
        -- </randexpr-2.734>
    })

test:do_test(
    "randexpr-2.735",
    function()
        return test:execsql "SELECT case c-+case when t1.f in (t1.a,t1.e,19) then t1.b else case when a<>t1.a then case ~(t1.d) when t1.e then (select max(t1.f) from t1)-(select +(cast(avg(b) AS integer))*cast(avg(t1.a) AS integer)+max(d)*count(*)+count(*) from t1)* -t1.f else 13 end else t1.a+a end*t1.f-t1.b*(e) end when d then d else 17 end FROM t1 WHERE case when not exists(select 1 from t1 where not exists(select 1 from t1 where c in (select t1.a*t1.b from t1 union select t1.d | e from t1))) and (coalesce((select (abs(11)/abs(13-17*c)) from t1 where b in (select 13 from t1 union select (t1.c) from t1)),11) not in (17,b,b)) then (abs(+t1.f)/abs(c)) when exists(select 1 from t1 where not exists(select 1 from t1 where not (not exists(select 1 from t1 where e<=19 and e>19)))) then c else t1.e end not between t1.f and c"
    end, {
        -- <randexpr-2.735>
        17
        -- </randexpr-2.735>
    })

test:do_test(
    "randexpr-2.736",
    function()
        return test:execsql "SELECT case c-+case when t1.f in (t1.a,t1.e,19) then t1.b else case when a<>t1.a then case ~(t1.d) when t1.e then (select max(t1.f) from t1)-(select +(cast(avg(b) AS integer))*cast(avg(t1.a) AS integer)+max(d)*count(*)+count(*) from t1)* -t1.f else 13 end else t1.a+a end*t1.f-t1.b*(e) end when d then d else 17 end FROM t1 WHERE NOT (case when not exists(select 1 from t1 where not exists(select 1 from t1 where c in (select t1.a*t1.b from t1 union select t1.d | e from t1))) and (coalesce((select (abs(11)/abs(13-17*c)) from t1 where b in (select 13 from t1 union select (t1.c) from t1)),11) not in (17,b,b)) then (abs(+t1.f)/abs(c)) when exists(select 1 from t1 where not exists(select 1 from t1 where not (not exists(select 1 from t1 where e<=19 and e>19)))) then c else t1.e end not between t1.f and c)"
    end, {
        -- <randexpr-2.736>
        
        -- </randexpr-2.736>
    })

test:do_test(
    "randexpr-2.737",
    function()
        return test:execsql "SELECT 11+a+(select count(distinct coalesce((select  -coalesce((select case when (t1.a<=a) then (case when 17=t1.c then (select count(distinct e)-min(11) from t1) else f end) when f>=t1.f and t1.c not in (t1.e,a,17) and 17=t1.f then  -t1.d else 11 end*t1.d from t1 where t1.a<=t1.b),t1.b) from t1 where t1.e not between d and 13),t1.a)) | +max(t1.c) from t1) FROM t1 WHERE 11 in (t1.a,+t1.c* -t1.f | t1.d*+t1.c-b-(abs((select min(case when 19 in (select abs(count(distinct c)) from t1 union select ~ -min(t1.c) from t1) then case (11) when a then t1.c else t1.d end when (f)<=t1.b then t1.b else t1.a end)+min((t1.d)) | min(b) from t1))/abs(t1.e))+case 13 when t1.b then b else  - -t1.b end*b-11, -f)"
    end, {
        -- <randexpr-2.737>
        
        -- </randexpr-2.737>
    })

test:do_test(
    "randexpr-2.738",
    function()
        return test:execsql "SELECT 11+a+(select count(distinct coalesce((select  -coalesce((select case when (t1.a<=a) then (case when 17=t1.c then (select count(distinct e)-min(11) from t1) else f end) when f>=t1.f and t1.c not in (t1.e,a,17) and 17=t1.f then  -t1.d else 11 end*t1.d from t1 where t1.a<=t1.b),t1.b) from t1 where t1.e not between d and 13),t1.a)) | +max(t1.c) from t1) FROM t1 WHERE NOT (11 in (t1.a,+t1.c* -t1.f | t1.d*+t1.c-b-(abs((select min(case when 19 in (select abs(count(distinct c)) from t1 union select ~ -min(t1.c) from t1) then case (11) when a then t1.c else t1.d end when (f)<=t1.b then t1.b else t1.a end)+min((t1.d)) | min(b) from t1))/abs(t1.e))+case 13 when t1.b then b else  - -t1.b end*b-11, -f))"
    end, {
        -- <randexpr-2.738>
        412
        -- </randexpr-2.738>
    })

test:do_test(
    "randexpr-2.739",
    function()
        return test:execsql "SELECT 11+a+(select count(distinct coalesce((select  -coalesce((select case when (t1.a<=a) then (case when 17=t1.c then (select count(distinct e)-min(11) from t1) else f end) when f>=t1.f and t1.c not in (t1.e,a,17) and 17=t1.f then  -t1.d else 11 end*t1.d from t1 where t1.a<=t1.b),t1.b) from t1 where t1.e not between d and 13),t1.a)) & +max(t1.c) from t1) FROM t1 WHERE NOT (11 in (t1.a,+t1.c* -t1.f | t1.d*+t1.c-b-(abs((select min(case when 19 in (select abs(count(distinct c)) from t1 union select ~ -min(t1.c) from t1) then case (11) when a then t1.c else t1.d end when (f)<=t1.b then t1.b else t1.a end)+min((t1.d)) | min(b) from t1))/abs(t1.e))+case 13 when t1.b then b else  - -t1.b end*b-11, -f))"
    end, {
        -- <randexpr-2.739>
        111
        -- </randexpr-2.739>
    })

test:do_test(
    "randexpr-2.740",
    function()
        return test:execsql "SELECT  -c-case 11 when ++e*(select cast(avg( -t1.f+case when case when 19=t1.e+((select min(17 | a) from t1)) then t1.f else t1.b end>=t1.e then t1.e when (((exists(select 1 from t1 where b in (select case  -count(*) when (count(distinct d)) then count(*) else (cast(avg(t1.b) AS integer)) end from t1 union select  -count(*) from t1))))) then t1.a else a end+t1.a*d) AS integer) from t1) then 13 else f end*e FROM t1 WHERE (select cast(avg(case when +d>=e+17 and (not case when 13>=(select case  -count(distinct t1.e) when cast(avg(c) AS integer) then cast(avg(19) AS integer) else count(distinct t1.a) end from t1) then t1.e else t1.f end in (select t1.b from t1 union select 13 from t1)) or t1.a<=e and e in (select count(*) from t1 union select  -count(*) from t1) and b>=t1.b or t1.e between c and 19 then c when f between 19 and b then coalesce((select max(t1.d) from t1 where a<>t1.b),13)* -(d) else t1.e end) AS integer) from t1)<=19"
    end, {
        -- <randexpr-2.740>
        
        -- </randexpr-2.740>
    })

test:do_test(
    "randexpr-2.741",
    function()
        return test:execsql "SELECT  -c-case 11 when ++e*(select cast(avg( -t1.f+case when case when 19=t1.e+((select min(17 | a) from t1)) then t1.f else t1.b end>=t1.e then t1.e when (((exists(select 1 from t1 where b in (select case  -count(*) when (count(distinct d)) then count(*) else (cast(avg(t1.b) AS integer)) end from t1 union select  -count(*) from t1))))) then t1.a else a end+t1.a*d) AS integer) from t1) then 13 else f end*e FROM t1 WHERE NOT ((select cast(avg(case when +d>=e+17 and (not case when 13>=(select case  -count(distinct t1.e) when cast(avg(c) AS integer) then cast(avg(19) AS integer) else count(distinct t1.a) end from t1) then t1.e else t1.f end in (select t1.b from t1 union select 13 from t1)) or t1.a<=e and e in (select count(*) from t1 union select  -count(*) from t1) and b>=t1.b or t1.e between c and 19 then c when f between 19 and b then coalesce((select max(t1.d) from t1 where a<>t1.b),13)* -(d) else t1.e end) AS integer) from t1)<=19)"
    end, {
        -- <randexpr-2.741>
        -300300
        -- </randexpr-2.741>
    })

test:do_test(
    "randexpr-2.742",
    function()
        return test:execsql "SELECT  -c-case 11 when ++e*(select cast(avg( -t1.f+case when case when 19=t1.e+((select min(17 & a) from t1)) then t1.f else t1.b end>=t1.e then t1.e when (((exists(select 1 from t1 where b in (select case  -count(*) when (count(distinct d)) then count(*) else (cast(avg(t1.b) AS integer)) end from t1 union select  -count(*) from t1))))) then t1.a else a end+t1.a*d) AS integer) from t1) then 13 else f end*e FROM t1 WHERE NOT ((select cast(avg(case when +d>=e+17 and (not case when 13>=(select case  -count(distinct t1.e) when cast(avg(c) AS integer) then cast(avg(19) AS integer) else count(distinct t1.a) end from t1) then t1.e else t1.f end in (select t1.b from t1 union select 13 from t1)) or t1.a<=e and e in (select count(*) from t1 union select  -count(*) from t1) and b>=t1.b or t1.e between c and 19 then c when f between 19 and b then coalesce((select max(t1.d) from t1 where a<>t1.b),13)* -(d) else t1.e end) AS integer) from t1)<=19)"
    end, {
        -- <randexpr-2.742>
        -300300
        -- </randexpr-2.742>
    })

test:do_test(
    "randexpr-2.743",
    function()
        return test:execsql "SELECT case d when 11 then t1.d-(abs(t1.d)/abs(19))+coalesce((select d*d from t1 where (select cast(avg(case when f | c+case when e in (select min(coalesce((select t1.f from t1 where 11 not between t1.b and 19),t1.f)) from t1 union select (max(t1.b)) from t1) then 19 when t1.b=b or t1.c>=c then 13 else e end*19 in (select 17 from t1 union select 11 from t1) then  -c else t1.d end) AS integer) from t1)<13),d) else 11 end FROM t1 WHERE (b>~t1.c-+(abs(case when 11>(c) and t1.a>13 then t1.d else (b) end)/abs(t1.d))-13 or t1.f between t1.a and 19 and 11 in (select (min(t1.e))-~( -+count(*)) from t1 union select count(distinct t1.c) from t1)) and 17 not in (f,(t1.b),t1.c) and (t1.f<>t1.e) or d in (f,t1.a,t1.d) or (d)<=t1.e"
    end, {
        -- <randexpr-2.743>
        11
        -- </randexpr-2.743>
    })

test:do_test(
    "randexpr-2.744",
    function()
        return test:execsql "SELECT case d when 11 then t1.d-(abs(t1.d)/abs(19))+coalesce((select d*d from t1 where (select cast(avg(case when f | c+case when e in (select min(coalesce((select t1.f from t1 where 11 not between t1.b and 19),t1.f)) from t1 union select (max(t1.b)) from t1) then 19 when t1.b=b or t1.c>=c then 13 else e end*19 in (select 17 from t1 union select 11 from t1) then  -c else t1.d end) AS integer) from t1)<13),d) else 11 end FROM t1 WHERE NOT ((b>~t1.c-+(abs(case when 11>(c) and t1.a>13 then t1.d else (b) end)/abs(t1.d))-13 or t1.f between t1.a and 19 and 11 in (select (min(t1.e))-~( -+count(*)) from t1 union select count(distinct t1.c) from t1)) and 17 not in (f,(t1.b),t1.c) and (t1.f<>t1.e) or d in (f,t1.a,t1.d) or (d)<=t1.e)"
    end, {
        -- <randexpr-2.744>
        
        -- </randexpr-2.744>
    })

test:do_test(
    "randexpr-2.745",
    function()
        return test:execsql "SELECT case d when 11 then t1.d-(abs(t1.d)/abs(19))+coalesce((select d*d from t1 where (select cast(avg(case when f & c+case when e in (select min(coalesce((select t1.f from t1 where 11 not between t1.b and 19),t1.f)) from t1 union select (max(t1.b)) from t1) then 19 when t1.b=b or t1.c>=c then 13 else e end*19 in (select 17 from t1 union select 11 from t1) then  -c else t1.d end) AS integer) from t1)<13),d) else 11 end FROM t1 WHERE (b>~t1.c-+(abs(case when 11>(c) and t1.a>13 then t1.d else (b) end)/abs(t1.d))-13 or t1.f between t1.a and 19 and 11 in (select (min(t1.e))-~( -+count(*)) from t1 union select count(distinct t1.c) from t1)) and 17 not in (f,(t1.b),t1.c) and (t1.f<>t1.e) or d in (f,t1.a,t1.d) or (d)<=t1.e"
    end, {
        -- <randexpr-2.745>
        11
        -- </randexpr-2.745>
    })

test:do_test(
    "randexpr-2.746",
    function()
        return test:execsql "SELECT (select  -~count(distinct ~+case when c<>coalesce((select max(case when ~13 in (t1.a,t1.f,13+t1.d+(19)*t1.d*f-e) then 13 else a end) from t1 where  -t1.d<>19),(a))*d+a then t1.d when exists(select 1 from t1 where b=d) then t1.f else 17 end*11) | count(*)-max(t1.e) from t1) FROM t1 WHERE 19 in (select max(b) from t1 union select count(*) from t1) and +t1.b+c*d+coalesce((select max(17) from t1 where case when t1.a=coalesce((select max((select (min(t1.f)) from t1)) from t1 where not case when not exists(select 1 from t1 where ( -t1.b)=13 and d in (f,c,e)) or 17 between 17 and e then t1.e-t1.c else 11 end>=d),19)-11 then 11 else 17 end<=t1.a),t1.f)+t1.f-f<>17"
    end, {
        -- <randexpr-2.746>
        
        -- </randexpr-2.746>
    })

test:do_test(
    "randexpr-2.747",
    function()
        return test:execsql "SELECT (select  -~count(distinct ~+case when c<>coalesce((select max(case when ~13 in (t1.a,t1.f,13+t1.d+(19)*t1.d*f-e) then 13 else a end) from t1 where  -t1.d<>19),(a))*d+a then t1.d when exists(select 1 from t1 where b=d) then t1.f else 17 end*11) | count(*)-max(t1.e) from t1) FROM t1 WHERE NOT (19 in (select max(b) from t1 union select count(*) from t1) and +t1.b+c*d+coalesce((select max(17) from t1 where case when t1.a=coalesce((select max((select (min(t1.f)) from t1)) from t1 where not case when not exists(select 1 from t1 where ( -t1.b)=13 and d in (f,c,e)) or 17 between 17 and e then t1.e-t1.c else 11 end>=d),19)-11 then 11 else 17 end<=t1.a),t1.f)+t1.f-f<>17)"
    end, {
        -- <randexpr-2.747>
        -497
        -- </randexpr-2.747>
    })

test:do_test(
    "randexpr-2.748",
    function()
        return test:execsql "SELECT (select  -~count(distinct ~+case when c<>coalesce((select max(case when ~13 in (t1.a,t1.f,13+t1.d+(19)*t1.d*f-e) then 13 else a end) from t1 where  -t1.d<>19),(a))*d+a then t1.d when exists(select 1 from t1 where b=d) then t1.f else 17 end*11) & count(*)-max(t1.e) from t1) FROM t1 WHERE NOT (19 in (select max(b) from t1 union select count(*) from t1) and +t1.b+c*d+coalesce((select max(17) from t1 where case when t1.a=coalesce((select max((select (min(t1.f)) from t1)) from t1 where not case when not exists(select 1 from t1 where ( -t1.b)=13 and d in (f,c,e)) or 17 between 17 and e then t1.e-t1.c else 11 end>=d),19)-11 then 11 else 17 end<=t1.a),t1.f)+t1.f-f<>17)"
    end, {
        -- <randexpr-2.748>
        0
        -- </randexpr-2.748>
    })

test:do_test(
    "randexpr-2.749",
    function()
        return test:execsql "SELECT coalesce((select max(a) from t1 where exists(select 1 from t1 where (abs(t1.f)/abs(case when (t1.a+case when exists(select 1 from t1 where t1.e>=(abs(coalesce((select f from t1 where (((b>=t1.d) or t1.e= -a) or 17=a)),case when t1.d between t1.a and b then t1.b when e in (e,t1.a,t1.e) then 13 else (f) end))/abs(13))) then 11 else t1.d end* - -t1.f)<=c then d else t1.d end))-t1.c-19>=t1.a)),((t1.b))) FROM t1 WHERE case when t1.f in (e,19,(abs(t1.e)/abs(t1.e))) and (17 between 11+(select +max(case case when f=(t1.b) then e when t1.e in (13,19,c) then c else  -t1.b end- -c when (13) then d else t1.f end) from t1) and 17 and (19 in (b,t1.d,11))) and f not between 19 and b then e when 13 not between (t1.e) and t1.a then 11 else 11 end not between d and t1.a"
    end, {
        -- <randexpr-2.749>
        200
        -- </randexpr-2.749>
    })

test:do_test(
    "randexpr-2.750",
    function()
        return test:execsql "SELECT coalesce((select max(a) from t1 where exists(select 1 from t1 where (abs(t1.f)/abs(case when (t1.a+case when exists(select 1 from t1 where t1.e>=(abs(coalesce((select f from t1 where (((b>=t1.d) or t1.e= -a) or 17=a)),case when t1.d between t1.a and b then t1.b when e in (e,t1.a,t1.e) then 13 else (f) end))/abs(13))) then 11 else t1.d end* - -t1.f)<=c then d else t1.d end))-t1.c-19>=t1.a)),((t1.b))) FROM t1 WHERE NOT (case when t1.f in (e,19,(abs(t1.e)/abs(t1.e))) and (17 between 11+(select +max(case case when f=(t1.b) then e when t1.e in (13,19,c) then c else  -t1.b end- -c when (13) then d else t1.f end) from t1) and 17 and (19 in (b,t1.d,11))) and f not between 19 and b then e when 13 not between (t1.e) and t1.a then 11 else 11 end not between d and t1.a)"
    end, {
        -- <randexpr-2.750>
        
        -- </randexpr-2.750>
    })

test:do_test(
    "randexpr-2.751",
    function()
        return test:execsql "SELECT 11-17 | case when 11<t1.c then case when ~f<=(abs(t1.e)/abs(19))-t1.f then 17 when 11>=c or 11 in (select cast(avg(t1.c) AS integer)-case cast(avg(t1.b) AS integer) when count(distinct e) then min(t1.a) else  -count(distinct 19) end from t1 union select count(*) from t1) or e in (t1.e,t1.b,b) or 13=t1.f and e>=t1.a then e else e end when ( -19<=e) then 13 else e end+a FROM t1 WHERE t1.c*d not in ( -t1.a,coalesce((select d from t1 where coalesce((select c from t1 where ((d<=11))),(17)+(abs(coalesce((select (select ( -+count(*))+count(distinct d) from t1) from t1 where (coalesce((select b from t1 where ~a<>13),(t1.c))) not between d and t1.d),17))/abs(d)))*f<a and t1.b<>17),e),t1.b)"
    end, {
        -- <randexpr-2.751>
        -1
        -- </randexpr-2.751>
    })

test:do_test(
    "randexpr-2.752",
    function()
        return test:execsql "SELECT 11-17 | case when 11<t1.c then case when ~f<=(abs(t1.e)/abs(19))-t1.f then 17 when 11>=c or 11 in (select cast(avg(t1.c) AS integer)-case cast(avg(t1.b) AS integer) when count(distinct e) then min(t1.a) else  -count(distinct 19) end from t1 union select count(*) from t1) or e in (t1.e,t1.b,b) or 13=t1.f and e>=t1.a then e else e end when ( -19<=e) then 13 else e end+a FROM t1 WHERE NOT (t1.c*d not in ( -t1.a,coalesce((select d from t1 where coalesce((select c from t1 where ((d<=11))),(17)+(abs(coalesce((select (select ( -+count(*))+count(distinct d) from t1) from t1 where (coalesce((select b from t1 where ~a<>13),(t1.c))) not between d and t1.d),17))/abs(d)))*f<a and t1.b<>17),e),t1.b))"
    end, {
        -- <randexpr-2.752>
        
        -- </randexpr-2.752>
    })

test:do_test(
    "randexpr-2.753",
    function()
        return test:execsql "SELECT 11-17 & case when 11<t1.c then case when ~f<=(abs(t1.e)/abs(19))-t1.f then 17 when 11>=c or 11 in (select cast(avg(t1.c) AS integer)-case cast(avg(t1.b) AS integer) when count(distinct e) then min(t1.a) else  -count(distinct 19) end from t1 union select count(*) from t1) or e in (t1.e,t1.b,b) or 13=t1.f and e>=t1.a then e else e end when ( -19<=e) then 13 else e end+a FROM t1 WHERE t1.c*d not in ( -t1.a,coalesce((select d from t1 where coalesce((select c from t1 where ((d<=11))),(17)+(abs(coalesce((select (select ( -+count(*))+count(distinct d) from t1) from t1 where (coalesce((select b from t1 where ~a<>13),(t1.c))) not between d and t1.d),17))/abs(d)))*f<a and t1.b<>17),e),t1.b)"
    end, {
        -- <randexpr-2.753>
        112
        -- </randexpr-2.753>
    })

test:do_test(
    "randexpr-2.754",
    function()
        return test:execsql "SELECT (abs(f-case when +(t1.f)-c<case when 17=case when not exists(select 1 from t1 where (19)=17 or c<>13 and  -f<t1.a) then (select max((select min(t1.b) | count(distinct 19) from t1)) from t1) when e not between t1.b and e then t1.e else 17 end+t1.e or t1.c in (t1.f,f,t1.d) then (11)+f when t1.c=11 and t1.e not in (a,(t1.e),a) then a else t1.f end-d then 11 else (t1.e) end-t1.b)/abs(11))*11 FROM t1 WHERE (case when (f not in (~(t1.f*case when case when case 11 when t1.e then t1.c else a end | 19 in (select t1.a from t1 union select t1.e from t1) then f when d>t1.c then 11 else  -11 end<>t1.c and t1.f not between (11) and (t1.f) then b else 11 end)*b+t1.f,a,t1.d)) then 11 else t1.d end=e) or e<(t1.f)"
    end, {
        -- <randexpr-2.754>
        99
        -- </randexpr-2.754>
    })

test:do_test(
    "randexpr-2.755",
    function()
        return test:execsql "SELECT (abs(f-case when +(t1.f)-c<case when 17=case when not exists(select 1 from t1 where (19)=17 or c<>13 and  -f<t1.a) then (select max((select min(t1.b) | count(distinct 19) from t1)) from t1) when e not between t1.b and e then t1.e else 17 end+t1.e or t1.c in (t1.f,f,t1.d) then (11)+f when t1.c=11 and t1.e not in (a,(t1.e),a) then a else t1.f end-d then 11 else (t1.e) end-t1.b)/abs(11))*11 FROM t1 WHERE NOT ((case when (f not in (~(t1.f*case when case when case 11 when t1.e then t1.c else a end | 19 in (select t1.a from t1 union select t1.e from t1) then f when d>t1.c then 11 else  -11 end<>t1.c and t1.f not between (11) and (t1.f) then b else 11 end)*b+t1.f,a,t1.d)) then 11 else t1.d end=e) or e<(t1.f))"
    end, {
        -- <randexpr-2.755>
        
        -- </randexpr-2.755>
    })

test:do_test(
    "randexpr-2.756",
    function()
        return test:execsql "SELECT (abs(f-case when +(t1.f)-c<case when 17=case when not exists(select 1 from t1 where (19)=17 or c<>13 and  -f<t1.a) then (select max((select min(t1.b) & count(distinct 19) from t1)) from t1) when e not between t1.b and e then t1.e else 17 end+t1.e or t1.c in (t1.f,f,t1.d) then (11)+f when t1.c=11 and t1.e not in (a,(t1.e),a) then a else t1.f end-d then 11 else (t1.e) end-t1.b)/abs(11))*11 FROM t1 WHERE (case when (f not in (~(t1.f*case when case when case 11 when t1.e then t1.c else a end | 19 in (select t1.a from t1 union select t1.e from t1) then f when d>t1.c then 11 else  -11 end<>t1.c and t1.f not between (11) and (t1.f) then b else 11 end)*b+t1.f,a,t1.d)) then 11 else t1.d end=e) or e<(t1.f)"
    end, {
        -- <randexpr-2.756>
        99
        -- </randexpr-2.756>
    })

test:do_test(
    "randexpr-2.757",
    function()
        return test:execsql "SELECT +(select (max(case when not (((exists(select 1 from t1 where b not between t1.a and t1.d) or t1.a>=coalesce((select max(17) from t1 where  -t1.e between t1.e and a),f)-11) or 11<=t1.c)) then b when 19 between 19 and b then t1.f else +d+ -t1.a-t1.f-e end | f-t1.b+ -t1.b)+min(t1.b)) from t1)*t1.c FROM t1 WHERE b in (t1.b-b,coalesce((select max(e) from t1 where t1.d not between 11 and case when d>=+13 then case when t1.a between e and a then t1.c else (t1.f)+(t1.b) end else case (d)*e when b then f else a end end or t1.d in (select cast(avg(d) AS integer) from t1 union select +abs( -max(e))*max(19) | max(d) from t1)),11),t1.c)"
    end, {
        -- <randexpr-2.757>
        
        -- </randexpr-2.757>
    })

test:do_test(
    "randexpr-2.758",
    function()
        return test:execsql "SELECT +(select (max(case when not (((exists(select 1 from t1 where b not between t1.a and t1.d) or t1.a>=coalesce((select max(17) from t1 where  -t1.e between t1.e and a),f)-11) or 11<=t1.c)) then b when 19 between 19 and b then t1.f else +d+ -t1.a-t1.f-e end | f-t1.b+ -t1.b)+min(t1.b)) from t1)*t1.c FROM t1 WHERE NOT (b in (t1.b-b,coalesce((select max(e) from t1 where t1.d not between 11 and case when d>=+13 then case when t1.a between e and a then t1.c else (t1.f)+(t1.b) end else case (d)*e when b then f else a end end or t1.d in (select cast(avg(d) AS integer) from t1 union select +abs( -max(e))*max(19) | max(d) from t1)),11),t1.c))"
    end, {
        -- <randexpr-2.758>
        278400
        -- </randexpr-2.758>
    })

test:do_test(
    "randexpr-2.759",
    function()
        return test:execsql "SELECT +(select (max(case when not (((exists(select 1 from t1 where b not between t1.a and t1.d) or t1.a>=coalesce((select max(17) from t1 where  -t1.e between t1.e and a),f)-11) or 11<=t1.c)) then b when 19 between 19 and b then t1.f else +d+ -t1.a-t1.f-e end & f-t1.b+ -t1.b)+min(t1.b)) from t1)*t1.c FROM t1 WHERE NOT (b in (t1.b-b,coalesce((select max(e) from t1 where t1.d not between 11 and case when d>=+13 then case when t1.a between e and a then t1.c else (t1.f)+(t1.b) end else case (d)*e when b then f else a end end or t1.d in (select cast(avg(d) AS integer) from t1 union select +abs( -max(e))*max(19) | max(d) from t1)),11),t1.c))"
    end, {
        -- <randexpr-2.759>
        81600
        -- </randexpr-2.759>
    })

test:do_test(
    "randexpr-2.760",
    function()
        return test:execsql "SELECT t1.e*t1.c*(select count(*)+abs(cast(avg(case t1.a when (select  -count(*)-(min(t1.a)) | +(abs(case max(a) when abs(min(17)) then +cast(avg(a) AS integer) | count(distinct d) else count(*) end)) from t1) then a else  -+b-coalesce((select max(f*19) from t1 where ~~c in (a,13,t1.a)),t1.b) end) AS integer)) from t1) FROM t1 WHERE 19-(abs(b)/abs(t1.b)) | case when t1.e in (select case (+cast(avg(t1.c+a) AS integer) | (cast(avg(t1.d) AS integer) |  -cast(avg( -d) AS integer)* -( -count(*))+min(17))) when min(13) then max( -11) else count(*) end from t1 union select min(17) from t1) or 13 in (case when t1.e between e and coalesce((select c from t1 where not exists(select 1 from t1 where (b)>=t1.e)),t1.b) then 19 else 11 end,17,f) then 11 else b end in (select c from t1 union select 19 from t1)"
    end, {
        -- <randexpr-2.760>
        
        -- </randexpr-2.760>
    })

test:do_test(
    "randexpr-2.761",
    function()
        return test:execsql "SELECT t1.e*t1.c*(select count(*)+abs(cast(avg(case t1.a when (select  -count(*)-(min(t1.a)) | +(abs(case max(a) when abs(min(17)) then +cast(avg(a) AS integer) | count(distinct d) else count(*) end)) from t1) then a else  -+b-coalesce((select max(f*19) from t1 where ~~c in (a,13,t1.a)),t1.b) end) AS integer)) from t1) FROM t1 WHERE NOT (19-(abs(b)/abs(t1.b)) | case when t1.e in (select case (+cast(avg(t1.c+a) AS integer) | (cast(avg(t1.d) AS integer) |  -cast(avg( -d) AS integer)* -( -count(*))+min(17))) when min(13) then max( -11) else count(*) end from t1 union select min(17) from t1) or 13 in (case when t1.e between e and coalesce((select c from t1 where not exists(select 1 from t1 where (b)>=t1.e)),t1.b) then 19 else 11 end,17,f) then 11 else b end in (select c from t1 union select 19 from t1))"
    end, {
        -- <randexpr-2.761>
        60150000
        -- </randexpr-2.761>
    })

test:do_test(
    "randexpr-2.762",
    function()
        return test:execsql "SELECT t1.e*t1.c*(select count(*)+abs(cast(avg(case t1.a when (select  -count(*)-(min(t1.a)) & +(abs(case max(a) when abs(min(17)) then +cast(avg(a) AS integer) & count(distinct d) else count(*) end)) from t1) then a else  -+b-coalesce((select max(f*19) from t1 where ~~c in (a,13,t1.a)),t1.b) end) AS integer)) from t1) FROM t1 WHERE NOT (19-(abs(b)/abs(t1.b)) | case when t1.e in (select case (+cast(avg(t1.c+a) AS integer) | (cast(avg(t1.d) AS integer) |  -cast(avg( -d) AS integer)* -( -count(*))+min(17))) when min(13) then max( -11) else count(*) end from t1 union select min(17) from t1) or 13 in (case when t1.e between e and coalesce((select c from t1 where not exists(select 1 from t1 where (b)>=t1.e)),t1.b) then 19 else 11 end,17,f) then 11 else b end in (select c from t1 union select 19 from t1))"
    end, {
        -- <randexpr-2.762>
        60150000
        -- </randexpr-2.762>
    })

test:do_test(
    "randexpr-2.763",
    function()
        return test:execsql "SELECT t1.b+case when e+(select abs(abs(min(d+case 11 when t1.d+19 | b | case when e<=b+coalesce((select 11 from t1 where 11<>13),17)-17 then t1.d else d end+19 then 11 else d end))) from t1)- -d-(t1.e) in (select 17 from t1 union select 11 from t1) then t1.e when exists(select 1 from t1 where e>t1.c) then t1.b else 13 end FROM t1 WHERE e in (select count(*) from t1 union select min(case when (select abs(cast(avg(+17) AS integer)) from t1) not between t1.e and 17+t1.f then f when ((case when ((select cast(avg(t1.d) AS integer) from t1)=17) then 19 else t1.f end)<>t1.c or t1.a in (select  -+abs(cast(avg(t1.b) AS integer)) from t1 union select +((cast(avg(11) AS integer)))+ -min(b) from t1)) or not exists(select 1 from t1 where ((t1.d in (b,a,17)) and f<=t1.a)) and t1.f<> - -t1.a then d else  - -t1.d end) from t1)"
    end, {
        -- <randexpr-2.763>
        
        -- </randexpr-2.763>
    })

test:do_test(
    "randexpr-2.764",
    function()
        return test:execsql "SELECT t1.b+case when e+(select abs(abs(min(d+case 11 when t1.d+19 | b | case when e<=b+coalesce((select 11 from t1 where 11<>13),17)-17 then t1.d else d end+19 then 11 else d end))) from t1)- -d-(t1.e) in (select 17 from t1 union select 11 from t1) then t1.e when exists(select 1 from t1 where e>t1.c) then t1.b else 13 end FROM t1 WHERE NOT (e in (select count(*) from t1 union select min(case when (select abs(cast(avg(+17) AS integer)) from t1) not between t1.e and 17+t1.f then f when ((case when ((select cast(avg(t1.d) AS integer) from t1)=17) then 19 else t1.f end)<>t1.c or t1.a in (select  -+abs(cast(avg(t1.b) AS integer)) from t1 union select +((cast(avg(11) AS integer)))+ -min(b) from t1)) or not exists(select 1 from t1 where ((t1.d in (b,a,17)) and f<=t1.a)) and t1.f<> - -t1.a then d else  - -t1.d end) from t1))"
    end, {
        -- <randexpr-2.764>
        400
        -- </randexpr-2.764>
    })

test:do_test(
    "randexpr-2.765",
    function()
        return test:execsql "SELECT t1.b+case when e+(select abs(abs(min(d+case 11 when t1.d+19 & b & case when e<=b+coalesce((select 11 from t1 where 11<>13),17)-17 then t1.d else d end+19 then 11 else d end))) from t1)- -d-(t1.e) in (select 17 from t1 union select 11 from t1) then t1.e when exists(select 1 from t1 where e>t1.c) then t1.b else 13 end FROM t1 WHERE NOT (e in (select count(*) from t1 union select min(case when (select abs(cast(avg(+17) AS integer)) from t1) not between t1.e and 17+t1.f then f when ((case when ((select cast(avg(t1.d) AS integer) from t1)=17) then 19 else t1.f end)<>t1.c or t1.a in (select  -+abs(cast(avg(t1.b) AS integer)) from t1 union select +((cast(avg(11) AS integer)))+ -min(b) from t1)) or not exists(select 1 from t1 where ((t1.d in (b,a,17)) and f<=t1.a)) and t1.f<> - -t1.a then d else  - -t1.d end) from t1))"
    end, {
        -- <randexpr-2.765>
        400
        -- </randexpr-2.765>
    })

test:do_test(
    "randexpr-2.766",
    function()
        return test:execsql "SELECT (select cast(avg( -coalesce((select max(+(abs(t1.d)/abs(~d))*+c*t1.c) from t1 where e in (select coalesce((select f from t1 where t1.f<> -11),17)+c*19 from t1 union select f from t1)),t1.c)) AS integer)-~case ~count(distinct 17)*count(distinct 19) when count(distinct t1.c)*count(*)-count(distinct 19) then +(max(a)+case  - - - -min(t1.f) when max(c) then count(distinct (f)) else min(13) end) else ( -cast(avg( -t1.b) AS integer)) end from t1) FROM t1 WHERE exists(select 1 from t1 where (abs(e*coalesce((select (abs(b*(t1.b)+f)/abs(d)) from t1 where t1.c in (select min(a | t1.b) from t1 union select abs(case  -case ~ -~cast(avg(e) AS integer) when ++min(17)+( -cast(avg(a) AS integer))-max(t1.c) then cast(avg(t1.b) AS integer) else cast(avg(f) AS integer) end when  - -max((t1.d)) then  -min(t1.b) else cast(avg(t1.c) AS integer) end) from t1)),b))/abs(t1.d)) in (select min(t1.c)-cast(avg( -e) AS integer)- -cast(avg(t1.f) AS integer) from t1 union select (max((19))) from t1))"
    end, {
        -- <randexpr-2.766>
        
        -- </randexpr-2.766>
    })

test:do_test(
    "randexpr-2.767",
    function()
        return test:execsql "SELECT (select cast(avg( -coalesce((select max(+(abs(t1.d)/abs(~d))*+c*t1.c) from t1 where e in (select coalesce((select f from t1 where t1.f<> -11),17)+c*19 from t1 union select f from t1)),t1.c)) AS integer)-~case ~count(distinct 17)*count(distinct 19) when count(distinct t1.c)*count(*)-count(distinct 19) then +(max(a)+case  - - - -min(t1.f) when max(c) then count(distinct (f)) else min(13) end) else ( -cast(avg( -t1.b) AS integer)) end from t1) FROM t1 WHERE NOT (exists(select 1 from t1 where (abs(e*coalesce((select (abs(b*(t1.b)+f)/abs(d)) from t1 where t1.c in (select min(a | t1.b) from t1 union select abs(case  -case ~ -~cast(avg(e) AS integer) when ++min(17)+( -cast(avg(a) AS integer))-max(t1.c) then cast(avg(t1.b) AS integer) else cast(avg(f) AS integer) end when  - -max((t1.d)) then  -min(t1.b) else cast(avg(t1.c) AS integer) end) from t1)),b))/abs(t1.d)) in (select min(t1.c)-cast(avg( -e) AS integer)- -cast(avg(t1.f) AS integer) from t1 union select (max((19))) from t1)))"
    end, {
        -- <randexpr-2.767>
        -99
        -- </randexpr-2.767>
    })

test:do_test(
    "randexpr-2.768",
    function()
        return test:execsql "SELECT t1.a+11*coalesce((select max( -t1.e-coalesce((select max((abs(t1.c)/abs((13*e+t1.c)-t1.f))) from t1 where exists(select 1 from t1 where d<>a) or ~(select case abs(count(distinct f)) when (count(*)) then count(*) else min(t1.f) end from t1)+coalesce((select f from t1 where d in (select min(t1.d) from t1 union select count(*) from t1)),c) in (11,t1.a,t1.b)),11)- -11) from t1 where 13<11),t1.b) FROM t1 WHERE not ++coalesce((select t1.f from t1 where not exists(select 1 from t1 where ((select min(b) from t1)<>case t1.d when coalesce((select max(case e-t1.c when 19-t1.c+f+(t1.c*coalesce((select max(17) from t1 where 17 between 11 and t1.a),t1.d)+b) then  -17 else d end-a) from t1 where t1.d>11),b) then 11 else c end))),b | t1.d)*17 not between t1.e and 17"
    end, {
        -- <randexpr-2.768>
        
        -- </randexpr-2.768>
    })

test:do_test(
    "randexpr-2.769",
    function()
        return test:execsql "SELECT t1.a+11*coalesce((select max( -t1.e-coalesce((select max((abs(t1.c)/abs((13*e+t1.c)-t1.f))) from t1 where exists(select 1 from t1 where d<>a) or ~(select case abs(count(distinct f)) when (count(*)) then count(*) else min(t1.f) end from t1)+coalesce((select f from t1 where d in (select min(t1.d) from t1 union select count(*) from t1)),c) in (11,t1.a,t1.b)),11)- -11) from t1 where 13<11),t1.b) FROM t1 WHERE NOT (not ++coalesce((select t1.f from t1 where not exists(select 1 from t1 where ((select min(b) from t1)<>case t1.d when coalesce((select max(case e-t1.c when 19-t1.c+f+(t1.c*coalesce((select max(17) from t1 where 17 between 11 and t1.a),t1.d)+b) then  -17 else d end-a) from t1 where t1.d>11),b) then 11 else c end))),b | t1.d)*17 not between t1.e and 17)"
    end, {
        -- <randexpr-2.769>
        2300
        -- </randexpr-2.769>
    })

test:do_test(
    "randexpr-2.770",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select ((abs(coalesce((select max((select ~(count(distinct e-11)-cast(avg(t1.a) AS integer) | count(*)) from t1)) from t1 where t1.f<case when not exists(select 1 from t1 where exists(select 1 from t1 where t1.a not in (11,e,13))) then t1.b when t1.d<t1.b then t1.e else t1.b end+ -c or t1.e>b or t1.c in (select c from t1 union select 19 from t1)),e | b))/abs(t1.f))) from t1 where e in (select  -(b) from t1 union select 13 from t1)),t1.a)) from t1 where f<>11),t1.e) FROM t1 WHERE  -11 in (a,case when exists(select 1 from t1 where 11 in (select 13 from t1 union select t1.d from t1)) and exists(select 1 from t1 where exists(select 1 from t1 where (t1.a) not between t1.c and t1.c)) then ~case when ~t1.f not between +t1.b-11 and e or not b in (c,17,e) and (not exists(select 1 from t1 where b in (( -t1.e), -t1.c,t1.c))) or 17 not in (t1.e,t1.c,t1.f) then c when 19= - -11 then t1.b else t1.c end when (13) between t1.f and ( -t1.e) then t1.d else  -t1.d end*c,d)"
    end, {
        -- <randexpr-2.770>
        
        -- </randexpr-2.770>
    })

test:do_test(
    "randexpr-2.771",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select ((abs(coalesce((select max((select ~(count(distinct e-11)-cast(avg(t1.a) AS integer) | count(*)) from t1)) from t1 where t1.f<case when not exists(select 1 from t1 where exists(select 1 from t1 where t1.a not in (11,e,13))) then t1.b when t1.d<t1.b then t1.e else t1.b end+ -c or t1.e>b or t1.c in (select c from t1 union select 19 from t1)),e | b))/abs(t1.f))) from t1 where e in (select  -(b) from t1 union select 13 from t1)),t1.a)) from t1 where f<>11),t1.e) FROM t1 WHERE NOT ( -11 in (a,case when exists(select 1 from t1 where 11 in (select 13 from t1 union select t1.d from t1)) and exists(select 1 from t1 where exists(select 1 from t1 where (t1.a) not between t1.c and t1.c)) then ~case when ~t1.f not between +t1.b-11 and e or not b in (c,17,e) and (not exists(select 1 from t1 where b in (( -t1.e), -t1.c,t1.c))) or 17 not in (t1.e,t1.c,t1.f) then c when 19= - -11 then t1.b else t1.c end when (13) between t1.f and ( -t1.e) then t1.d else  -t1.d end*c,d))"
    end, {
        -- <randexpr-2.771>
        100
        -- </randexpr-2.771>
    })

test:do_test(
    "randexpr-2.772",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select ((abs(coalesce((select max((select ~(count(distinct e-11)-cast(avg(t1.a) AS integer) & count(*)) from t1)) from t1 where t1.f<case when not exists(select 1 from t1 where exists(select 1 from t1 where t1.a not in (11,e,13))) then t1.b when t1.d<t1.b then t1.e else t1.b end+ -c or t1.e>b or t1.c in (select c from t1 union select 19 from t1)),e & b))/abs(t1.f))) from t1 where e in (select  -(b) from t1 union select 13 from t1)),t1.a)) from t1 where f<>11),t1.e) FROM t1 WHERE NOT ( -11 in (a,case when exists(select 1 from t1 where 11 in (select 13 from t1 union select t1.d from t1)) and exists(select 1 from t1 where exists(select 1 from t1 where (t1.a) not between t1.c and t1.c)) then ~case when ~t1.f not between +t1.b-11 and e or not b in (c,17,e) and (not exists(select 1 from t1 where b in (( -t1.e), -t1.c,t1.c))) or 17 not in (t1.e,t1.c,t1.f) then c when 19= - -11 then t1.b else t1.c end when (13) between t1.f and ( -t1.e) then t1.d else  -t1.d end*c,d))"
    end, {
        -- <randexpr-2.772>
        100
        -- </randexpr-2.772>
    })

test:do_test(
    "randexpr-2.773",
    function()
        return test:execsql "SELECT 17-13-case 19 when 17+case case t1.b when t1.b then coalesce((select coalesce((select 11 from t1 where (coalesce((select t1.a from t1 where (abs(f)/abs(case t1.e when 11 then a else t1.c end))<c),b)*a- -t1.e) not between t1.e and  -13),19) from t1 where d>19 or d not between f and t1.e),(t1.c)) else 11 end when  -a then 13 else e end then t1.b else b end+t1.c FROM t1 WHERE not exists(select 1 from t1 where coalesce((select e from t1 where case when not exists(select 1 from t1 where not not exists(select 1 from t1 where f<> -t1.e-t1.c)) or coalesce((select max(17+t1.c) from t1 where t1.f in (select cast(avg(17) AS integer) from t1 union select cast(avg(t1.c) AS integer) from t1)),t1.d)<>19 then 19 else t1.a+ -(b)+t1.c end<=t1.c),t1.b)>t1.d) or (e) in (t1.c,f,13) or d in (select +count(*) from t1 union select count(*) from t1)"
    end, {
        -- <randexpr-2.773>
        
        -- </randexpr-2.773>
    })

test:do_test(
    "randexpr-2.774",
    function()
        return test:execsql "SELECT 17-13-case 19 when 17+case case t1.b when t1.b then coalesce((select coalesce((select 11 from t1 where (coalesce((select t1.a from t1 where (abs(f)/abs(case t1.e when 11 then a else t1.c end))<c),b)*a- -t1.e) not between t1.e and  -13),19) from t1 where d>19 or d not between f and t1.e),(t1.c)) else 11 end when  -a then 13 else e end then t1.b else b end+t1.c FROM t1 WHERE NOT (not exists(select 1 from t1 where coalesce((select e from t1 where case when not exists(select 1 from t1 where not not exists(select 1 from t1 where f<> -t1.e-t1.c)) or coalesce((select max(17+t1.c) from t1 where t1.f in (select cast(avg(17) AS integer) from t1 union select cast(avg(t1.c) AS integer) from t1)),t1.d)<>19 then 19 else t1.a+ -(b)+t1.c end<=t1.c),t1.b)>t1.d) or (e) in (t1.c,f,13) or d in (select +count(*) from t1 union select count(*) from t1))"
    end, {
        -- <randexpr-2.774>
        104
        -- </randexpr-2.774>
    })

test:do_test(
    "randexpr-2.775",
    function()
        return test:execsql "SELECT t1.e*(abs(coalesce((select max(case when t1.c in (select (case when d>13 then t1.c else 11 end+e) from t1 union select t1.a from t1) or t1.a between 17 and c then c when t1.d>=a then t1.c else t1.e end-t1.e*t1.b-d) from t1 where b<>(t1.c) or not exists(select 1 from t1 where b in (t1.d,13,a))),11)*t1.a)/abs(t1.a))+t1.c FROM t1 WHERE a>c"
    end, {
        -- <randexpr-2.775>
        
        -- </randexpr-2.775>
    })

test:do_test(
    "randexpr-2.776",
    function()
        return test:execsql "SELECT t1.e*(abs(coalesce((select max(case when t1.c in (select (case when d>13 then t1.c else 11 end+e) from t1 union select t1.a from t1) or t1.a between 17 and c then c when t1.d>=a then t1.c else t1.e end-t1.e*t1.b-d) from t1 where b<>(t1.c) or not exists(select 1 from t1 where b in (t1.d,13,a))),11)*t1.a)/abs(t1.a))+t1.c FROM t1 WHERE NOT (a>c)"
    end, {
        -- <randexpr-2.776>
        50050300
        -- </randexpr-2.776>
    })

test:do_test(
    "randexpr-2.777",
    function()
        return test:execsql "SELECT t1.d*(+coalesce((select max(case when coalesce((select (abs(f)/abs((abs(d)/abs((select cast(avg(19+11) AS integer) from t1)))+t1.b)) from t1 where exists(select 1 from t1 where t1.d not between t1.f and t1.e)),17) not in (17,t1.f, -t1.b) then 19 else  -19 end) from t1 where exists(select 1 from t1 where 11 in (select abs(count(distinct t1.f)) from t1 union select cast(avg(t1.e) AS integer) from t1) and exists(select 1 from t1 where t1.f<t1.c) or 17<f)),13)+13) FROM t1 WHERE not exists(select 1 from t1 where t1.c*coalesce((select max(19) from t1 where a between (select abs(+min(b)*case cast(avg(b) AS integer) when case  -(count(distinct 11)) when max(coalesce((select 11 from t1 where c in (13,17,t1.b)),b)) then  -count(*) else (cast(avg(19) AS integer)) end+max(11) then max(t1.e) else count(*) end | count(*))+count(*) from t1) and ~a),(select  -count(*) from t1)) between t1.c and 13-d)"
    end, {
        -- <randexpr-2.777>
        12800
        -- </randexpr-2.777>
    })

test:do_test(
    "randexpr-2.778",
    function()
        return test:execsql "SELECT t1.d*(+coalesce((select max(case when coalesce((select (abs(f)/abs((abs(d)/abs((select cast(avg(19+11) AS integer) from t1)))+t1.b)) from t1 where exists(select 1 from t1 where t1.d not between t1.f and t1.e)),17) not in (17,t1.f, -t1.b) then 19 else  -19 end) from t1 where exists(select 1 from t1 where 11 in (select abs(count(distinct t1.f)) from t1 union select cast(avg(t1.e) AS integer) from t1) and exists(select 1 from t1 where t1.f<t1.c) or 17<f)),13)+13) FROM t1 WHERE NOT (not exists(select 1 from t1 where t1.c*coalesce((select max(19) from t1 where a between (select abs(+min(b)*case cast(avg(b) AS integer) when case  -(count(distinct 11)) when max(coalesce((select 11 from t1 where c in (13,17,t1.b)),b)) then  -count(*) else (cast(avg(19) AS integer)) end+max(11) then max(t1.e) else count(*) end | count(*))+count(*) from t1) and ~a),(select  -count(*) from t1)) between t1.c and 13-d))"
    end, {
        -- <randexpr-2.778>
        
        -- </randexpr-2.778>
    })

test:do_test(
    "randexpr-2.779",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select (select cast(avg(d) AS integer) | case max(~f) | count(distinct t1.d) when count(*) then count(*) else  -min(17) end from t1) from t1 where b=t1.e+ -e or t1.a not in (t1.f,t1.d,t1.d) or f not in (t1.a, -t1.b,f)),t1.c)+b | 13-d) from t1 where t1.b> -11),(17)) | b-19*d FROM t1 WHERE b>coalesce((select max(13+d) from t1 where 17>=11),t1.b)"
    end, {
        -- <randexpr-2.779>
        
        -- </randexpr-2.779>
    })

test:do_test(
    "randexpr-2.780",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select (select cast(avg(d) AS integer) | case max(~f) | count(distinct t1.d) when count(*) then count(*) else  -min(17) end from t1) from t1 where b=t1.e+ -e or t1.a not in (t1.f,t1.d,t1.d) or f not in (t1.a, -t1.b,f)),t1.c)+b | 13-d) from t1 where t1.b> -11),(17)) | b-19*d FROM t1 WHERE NOT (b>coalesce((select max(13+d) from t1 where 17>=11),t1.b))"
    end, {
        -- <randexpr-2.780>
        -1
        -- </randexpr-2.780>
    })

test:do_test(
    "randexpr-2.781",
    function()
        return test:execsql "SELECT coalesce((select max(coalesce((select (select cast(avg(d) AS integer) & case max(~f) & count(distinct t1.d) when count(*) then count(*) else  -min(17) end from t1) from t1 where b=t1.e+ -e or t1.a not in (t1.f,t1.d,t1.d) or f not in (t1.a, -t1.b,f)),t1.c)+b & 13-d) from t1 where t1.b> -11),(17)) & b-19*d FROM t1 WHERE NOT (b>coalesce((select max(13+d) from t1 where 17>=11),t1.b))"
    end, {
        -- <randexpr-2.781>
        8
        -- </randexpr-2.781>
    })

test:do_test(
    "randexpr-2.782",
    function()
        return test:execsql "SELECT (d+f*t1.c-t1.e+coalesce((select c from t1 where c>=a),case when (c in (select e from t1 union select 13 from t1)) then 11+a else f end))-13 FROM t1 WHERE c not between c and b+coalesce((select c from t1 where t1.d<case when 13 not in (case a when b then coalesce((select max(case when f in (select case when ((t1.c | t1.f not between c and 13)) then t1.e-(t1.a) else 17 end from t1 union select 13 from t1) then t1.e else e end*a) from t1 where 11=17),t1.f) else f end,17,t1.f) then t1.d else t1.d end+t1.a | b),f)"
    end, {
        -- <randexpr-2.782>
        
        -- </randexpr-2.782>
    })

test:do_test(
    "randexpr-2.783",
    function()
        return test:execsql "SELECT (d+f*t1.c-t1.e+coalesce((select c from t1 where c>=a),case when (c in (select e from t1 union select 13 from t1)) then 11+a else f end))-13 FROM t1 WHERE NOT (c not between c and b+coalesce((select c from t1 where t1.d<case when 13 not in (case a when b then coalesce((select max(case when f in (select case when ((t1.c | t1.f not between c and 13)) then t1.e-(t1.a) else 17 end from t1 union select 13 from t1) then t1.e else e end*a) from t1 where 11=17),t1.f) else f end,17,t1.f) then t1.d else t1.d end+t1.a | b),f))"
    end, {
        -- <randexpr-2.783>
        180187
        -- </randexpr-2.783>
    })

test:do_test(
    "randexpr-2.784",
    function()
        return test:execsql "SELECT case when t1.e not in (t1.a,~case when case when 17>=d then (abs(13)/abs(t1.f)) when (d in ((select abs(min(19)) from t1), -(select count(*)-abs( -count(*)) from t1),t1.e)) then coalesce((select max(19) from t1 where (c)>t1.f),17) else 13 end<>a then 11 when b<(d) then b else c end,d) then 17 when (17 in (13,t1.a,t1.c)) then e else c end+t1.c FROM t1 WHERE t1.a+t1.e in (select 19 from t1 union select t1.c from t1)"
    end, {
        -- <randexpr-2.784>
        
        -- </randexpr-2.784>
    })

test:do_test(
    "randexpr-2.785",
    function()
        return test:execsql "SELECT case when t1.e not in (t1.a,~case when case when 17>=d then (abs(13)/abs(t1.f)) when (d in ((select abs(min(19)) from t1), -(select count(*)-abs( -count(*)) from t1),t1.e)) then coalesce((select max(19) from t1 where (c)>t1.f),17) else 13 end<>a then 11 when b<(d) then b else c end,d) then 17 when (17 in (13,t1.a,t1.c)) then e else c end+t1.c FROM t1 WHERE NOT (t1.a+t1.e in (select 19 from t1 union select t1.c from t1))"
    end, {
        -- <randexpr-2.785>
        317
        -- </randexpr-2.785>
    })

test:do_test(
    "randexpr-2.786",
    function()
        return test:execsql "SELECT (select ~cast(avg(t1.c) AS integer)*case count(*) | +min(case +case when a<13 or case t1.f when c then 17 else t1.d end in (11,a,(t1.a)) and a<>a then t1.b+f when f not in (d,t1.a,c) then t1.f else t1.e end when t1.f then 17 else f end)+abs(++count(distinct 19))*(count(distinct 13))-count(distinct t1.e)-(count(*))*max(19) when max(11) then cast(avg(a) AS integer) else min(t1.f) end from t1) FROM t1 WHERE t1.a not between 17 and d"
    end, {
        -- <randexpr-2.786>
        
        -- </randexpr-2.786>
    })

test:do_test(
    "randexpr-2.787",
    function()
        return test:execsql "SELECT (select ~cast(avg(t1.c) AS integer)*case count(*) | +min(case +case when a<13 or case t1.f when c then 17 else t1.d end in (11,a,(t1.a)) and a<>a then t1.b+f when f not in (d,t1.a,c) then t1.f else t1.e end when t1.f then 17 else f end)+abs(++count(distinct 19))*(count(distinct 13))-count(distinct t1.e)-(count(*))*max(19) when max(11) then cast(avg(a) AS integer) else min(t1.f) end from t1) FROM t1 WHERE NOT (t1.a not between 17 and d)"
    end, {
        -- <randexpr-2.787>
        -180600
        -- </randexpr-2.787>
    })

test:do_test(
    "randexpr-2.788",
    function()
        return test:execsql "SELECT (select ~cast(avg(t1.c) AS integer)*case count(*) & +min(case +case when a<13 or case t1.f when c then 17 else t1.d end in (11,a,(t1.a)) and a<>a then t1.b+f when f not in (d,t1.a,c) then t1.f else t1.e end when t1.f then 17 else f end)+abs(++count(distinct 19))*(count(distinct 13))-count(distinct t1.e)-(count(*))*max(19) when max(11) then cast(avg(a) AS integer) else min(t1.f) end from t1) FROM t1 WHERE NOT (t1.a not between 17 and d)"
    end, {
        -- <randexpr-2.788>
        -180600
        -- </randexpr-2.788>
    })

test:do_test(
    "randexpr-2.789",
    function()
        return test:execsql "SELECT case t1.a when c then  -~t1.d*t1.e-coalesce((select max((abs(d+e+d)/abs(case when 11-t1.d in (select t1.d from t1 union select coalesce((select t1.c from t1 where 17<=t1.d and e between 11 and a),c) from t1) or 11 in (select ( -+(count(*))) from t1 union select count(distinct  -t1.a) from t1) then (f) when b=a then c else t1.b end))) from t1 where t1.c not between 17 and t1.b),13)+t1.f else d end FROM t1 WHERE not exists(select 1 from t1 where f<=a)"
    end, {
        -- <randexpr-2.789>
        400
        -- </randexpr-2.789>
    })

test:do_test(
    "randexpr-2.790",
    function()
        return test:execsql "SELECT case t1.a when c then  -~t1.d*t1.e-coalesce((select max((abs(d+e+d)/abs(case when 11-t1.d in (select t1.d from t1 union select coalesce((select t1.c from t1 where 17<=t1.d and e between 11 and a),c) from t1) or 11 in (select ( -+(count(*))) from t1 union select count(distinct  -t1.a) from t1) then (f) when b=a then c else t1.b end))) from t1 where t1.c not between 17 and t1.b),13)+t1.f else d end FROM t1 WHERE NOT (not exists(select 1 from t1 where f<=a))"
    end, {
        -- <randexpr-2.790>
        
        -- </randexpr-2.790>
    })

test:do_test(
    "randexpr-2.791",
    function()
        return test:execsql "SELECT (select  -max(d) from t1)+coalesce((select max(t1.e*t1.d*f) from t1 where t1.b-coalesce((select  -a*d from t1 where t1.c not in (t1.f,coalesce((select b+t1.b from t1 where t1.a not between f and t1.b),coalesce((select  -b from t1 where (t1.d>=t1.c) and 19<>t1.f),t1.a))-e*a,e)),(t1.a))+t1.f between 19 and e),t1.a)*a FROM t1 WHERE exists(select 1 from t1 where not exists(select 1 from t1 where case when t1.d-t1.b-t1.d*(case when t1.b>= -t1.d then c when t1.d not between c and t1.d then (19) else d end*e)+t1.d | 19>t1.c then e when exists(select 1 from t1 where t1.e not between d and t1.b or (17 in (t1.e, - -a,t1.d))) then t1.f else (e) end between 13 and e or 11>t1.b))"
    end, {
        -- <randexpr-2.791>
        9600
        -- </randexpr-2.791>
    })

test:do_test(
    "randexpr-2.792",
    function()
        return test:execsql "SELECT (select  -max(d) from t1)+coalesce((select max(t1.e*t1.d*f) from t1 where t1.b-coalesce((select  -a*d from t1 where t1.c not in (t1.f,coalesce((select b+t1.b from t1 where t1.a not between f and t1.b),coalesce((select  -b from t1 where (t1.d>=t1.c) and 19<>t1.f),t1.a))-e*a,e)),(t1.a))+t1.f between 19 and e),t1.a)*a FROM t1 WHERE NOT (exists(select 1 from t1 where not exists(select 1 from t1 where case when t1.d-t1.b-t1.d*(case when t1.b>= -t1.d then c when t1.d not between c and t1.d then (19) else d end*e)+t1.d | 19>t1.c then e when exists(select 1 from t1 where t1.e not between d and t1.b or (17 in (t1.e, - -a,t1.d))) then t1.f else (e) end between 13 and e or 11>t1.b)))"
    end, {
        -- <randexpr-2.792>
        
        -- </randexpr-2.792>
    })

test:do_test(
    "randexpr-2.793",
    function()
        return test:execsql "SELECT 11-t1.d-t1.e-case when (select count(distinct t1.b+coalesce((select max((abs(19)/abs(case when coalesce((select t1.f from t1 where e not between t1.f and t1.f),f)*( -11)=((e)) then 11 else d end))) from t1 where e in (17,t1.b,t1.b)), -t1.a)-(t1.c)) from t1)>t1.f then t1.b when 11>13 and a>=f then 11 else d end-t1.f FROM t1 WHERE (select min(d)-case cast(avg(case (d-~t1.c+~(select max(+d-coalesce((select max(t1.f) from t1 where c<>e),t1.a))-(( - -(cast(avg(13) AS integer)))-count(distinct e))*max(17) from t1) | 19-13*b) when  -t1.d then 13 else  -13 end) AS integer) when min(t1.c) then cast(avg(e) AS integer) else ~count(*) end from t1)<b"
    end, {
        -- <randexpr-2.793>
        
        -- </randexpr-2.793>
    })

test:do_test(
    "randexpr-2.794",
    function()
        return test:execsql "SELECT 11-t1.d-t1.e-case when (select count(distinct t1.b+coalesce((select max((abs(19)/abs(case when coalesce((select t1.f from t1 where e not between t1.f and t1.f),f)*( -11)=((e)) then 11 else d end))) from t1 where e in (17,t1.b,t1.b)), -t1.a)-(t1.c)) from t1)>t1.f then t1.b when 11>13 and a>=f then 11 else d end-t1.f FROM t1 WHERE NOT ((select min(d)-case cast(avg(case (d-~t1.c+~(select max(+d-coalesce((select max(t1.f) from t1 where c<>e),t1.a))-(( - -(cast(avg(13) AS integer)))-count(distinct e))*max(17) from t1) | 19-13*b) when  -t1.d then 13 else  -13 end) AS integer) when min(t1.c) then cast(avg(e) AS integer) else ~count(*) end from t1)<b)"
    end, {
        -- <randexpr-2.794>
        -1889
        -- </randexpr-2.794>
    })

test:do_test(
    "randexpr-2.795",
    function()
        return test:execsql "SELECT case f when 13 then 19 else case when (case when c not between b and d then t1.c when +~t1.d+(select  -+cast(avg(t1.a) AS integer) | ((max(t1.d)))*(max(e)) from t1)-19+t1.a*t1.d in (select ~max(c) from t1 union select count(distinct d)-count(distinct b) from t1) then f else  -11 end not between 11 and 11) or 17>(c) then t1.d else 13 end end FROM t1 WHERE not ((abs(f)/abs(t1.b))<=(select min(+t1.d)+~+case count(distinct (abs(case d when 11 then coalesce((select coalesce((select max(t1.a) from t1 where t1.b=t1.e),t1.f) | a from t1 where 13<>(a)),d) else 17 end*f)/abs(t1.f))) when cast(avg(t1.c) AS integer) then case count(*) when min(t1.b) | cast(avg(t1.c) AS integer) then count(distinct f) else max(17) end else cast(avg((c)) AS integer) end from t1))"
    end, {
        -- <randexpr-2.795>
        
        -- </randexpr-2.795>
    })

test:do_test(
    "randexpr-2.796",
    function()
        return test:execsql "SELECT case f when 13 then 19 else case when (case when c not between b and d then t1.c when +~t1.d+(select  -+cast(avg(t1.a) AS integer) | ((max(t1.d)))*(max(e)) from t1)-19+t1.a*t1.d in (select ~max(c) from t1 union select count(distinct d)-count(distinct b) from t1) then f else  -11 end not between 11 and 11) or 17>(c) then t1.d else 13 end end FROM t1 WHERE NOT (not ((abs(f)/abs(t1.b))<=(select min(+t1.d)+~+case count(distinct (abs(case d when 11 then coalesce((select coalesce((select max(t1.a) from t1 where t1.b=t1.e),t1.f) | a from t1 where 13<>(a)),d) else 17 end*f)/abs(t1.f))) when cast(avg(t1.c) AS integer) then case count(*) when min(t1.b) | cast(avg(t1.c) AS integer) then count(distinct f) else max(17) end else cast(avg((c)) AS integer) end from t1)))"
    end, {
        -- <randexpr-2.796>
        400
        -- </randexpr-2.796>
    })

test:do_test(
    "randexpr-2.797",
    function()
        return test:execsql "SELECT case f when 13 then 19 else case when (case when c not between b and d then t1.c when +~t1.d+(select  -+cast(avg(t1.a) AS integer) & ((max(t1.d)))*(max(e)) from t1)-19+t1.a*t1.d in (select ~max(c) from t1 union select count(distinct d)-count(distinct b) from t1) then f else  -11 end not between 11 and 11) or 17>(c) then t1.d else 13 end end FROM t1 WHERE NOT (not ((abs(f)/abs(t1.b))<=(select min(+t1.d)+~+case count(distinct (abs(case d when 11 then coalesce((select coalesce((select max(t1.a) from t1 where t1.b=t1.e),t1.f) | a from t1 where 13<>(a)),d) else 17 end*f)/abs(t1.f))) when cast(avg(t1.c) AS integer) then case count(*) when min(t1.b) | cast(avg(t1.c) AS integer) then count(distinct f) else max(17) end else cast(avg((c)) AS integer) end from t1)))"
    end, {
        -- <randexpr-2.797>
        400
        -- </randexpr-2.797>
    })

test:do_test(
    "randexpr-2.798",
    function()
        return test:execsql "SELECT f+case when (not exists(select 1 from t1 where ((17<>+t1.b+t1.f or b between t1.e and t1.e)))) then (abs( -(abs(case when exists(select 1 from t1 where not exists(select 1 from t1 where d in (select (select cast(avg((t1.b)) AS integer)-count(*) from t1) from t1 union select t1.e+(11) from t1))) then c when not t1.d between f and 11 or d>a then (a) else 13 end+t1.e+e)/abs(d)))/abs(t1.b)) else f end-13 FROM t1 WHERE case when 17< - -t1.b-case when not exists(select 1 from t1 where 19<>t1.d) then 13+coalesce((select max((abs((case case when  - -t1.c*11 in (select +max(t1.d)*count(distinct  -t1.c) from t1 union select max(t1.b) from t1) then 13 else 19 end when f then 19 else (t1.d) end)+e)/abs(f))) from t1 where (13 between t1.d and 19)),t1.b) else 13 end then a else t1.a end-13 not in (t1.d,d,(t1.f))"
    end, {
        -- <randexpr-2.798>
        1187
        -- </randexpr-2.798>
    })

test:do_test(
    "randexpr-2.799",
    function()
        return test:execsql "SELECT f+case when (not exists(select 1 from t1 where ((17<>+t1.b+t1.f or b between t1.e and t1.e)))) then (abs( -(abs(case when exists(select 1 from t1 where not exists(select 1 from t1 where d in (select (select cast(avg((t1.b)) AS integer)-count(*) from t1) from t1 union select t1.e+(11) from t1))) then c when not t1.d between f and 11 or d>a then (a) else 13 end+t1.e+e)/abs(d)))/abs(t1.b)) else f end-13 FROM t1 WHERE NOT (case when 17< - -t1.b-case when not exists(select 1 from t1 where 19<>t1.d) then 13+coalesce((select max((abs((case case when  - -t1.c*11 in (select +max(t1.d)*count(distinct  -t1.c) from t1 union select max(t1.b) from t1) then 13 else 19 end when f then 19 else (t1.d) end)+e)/abs(f))) from t1 where (13 between t1.d and 19)),t1.b) else 13 end then a else t1.a end-13 not in (t1.d,d,(t1.f)))"
    end, {
        -- <randexpr-2.799>
        
        -- </randexpr-2.799>
    })

test:do_test(
    "randexpr-2.800",
    function()
        return test:execsql "SELECT +~t1.a-(abs(+case when (((t1.d*t1.c+11 in (select cast(avg(17) AS integer) from t1 union select  -(count(*)) from t1)))) then  -coalesce((select t1.e-b from t1 where not exists(select 1 from t1 where t1.c in (select max(f) from t1 union select max(e) | max( -t1.e)-count(*) from t1))),f) else f end)/abs(t1.f))-e+11+t1.b+t1.a- -17 FROM t1 WHERE +b between case when c<=t1.a then t1.b when case when  -t1.a*d-17+17*~e- -13 in (select + -max(19) | +cast(avg(19) AS integer) from t1 union select (count(distinct  -19)*case max((13)) when max(e)*count(*) then min(t1.d) else count(*) end) from t1) then t1.f else (d) end in (select e from t1 union select d from t1) then f else  -t1.b end and b"
    end, {
        -- <randexpr-2.800>
        
        -- </randexpr-2.800>
    })

test:do_test(
    "randexpr-2.801",
    function()
        return test:execsql "SELECT +~t1.a-(abs(+case when (((t1.d*t1.c+11 in (select cast(avg(17) AS integer) from t1 union select  -(count(*)) from t1)))) then  -coalesce((select t1.e-b from t1 where not exists(select 1 from t1 where t1.c in (select max(f) from t1 union select max(e) | max( -t1.e)-count(*) from t1))),f) else f end)/abs(t1.f))-e+11+t1.b+t1.a- -17 FROM t1 WHERE NOT (+b between case when c<=t1.a then t1.b when case when  -t1.a*d-17+17*~e- -13 in (select + -max(19) | +cast(avg(19) AS integer) from t1 union select (count(distinct  -19)*case max((13)) when max(e)*count(*) then min(t1.d) else count(*) end) from t1) then t1.f else (d) end in (select e from t1 union select d from t1) then f else  -t1.b end and b)"
    end, {
        -- <randexpr-2.801>
        -274
        -- </randexpr-2.801>
    })

test:do_test(
    "randexpr-2.802",
    function()
        return test:execsql "SELECT +~t1.a-(abs(+case when (((t1.d*t1.c+11 in (select cast(avg(17) AS integer) from t1 union select  -(count(*)) from t1)))) then  -coalesce((select t1.e-b from t1 where not exists(select 1 from t1 where t1.c in (select max(f) from t1 union select max(e) & max( -t1.e)-count(*) from t1))),f) else f end)/abs(t1.f))-e+11+t1.b+t1.a- -17 FROM t1 WHERE NOT (+b between case when c<=t1.a then t1.b when case when  -t1.a*d-17+17*~e- -13 in (select + -max(19) | +cast(avg(19) AS integer) from t1 union select (count(distinct  -19)*case max((13)) when max(e)*count(*) then min(t1.d) else count(*) end) from t1) then t1.f else (d) end in (select e from t1 union select d from t1) then f else  -t1.b end and b)"
    end, {
        -- <randexpr-2.802>
        -274
        -- </randexpr-2.802>
    })

test:do_test(
    "randexpr-2.803",
    function()
        return test:execsql "SELECT case when 19=(select ( -count(*)* -(cast(avg(t1.e) AS integer))+count(distinct 13)*min(t1.f)) | cast(avg(t1.e) AS integer) |  -cast(avg(13) AS integer)-(min(d)) from t1) then 13*a when t1.a+((select min((t1.d)) from t1)) in (select t1.b from t1 union select 11 from t1) or not exists(select 1 from t1 where not exists(select 1 from t1 where  - -e in (select t1.e from t1 union select t1.d from t1) or t1.d in (select count(distinct t1.a) from t1 union select count(*) from t1)) or  -b=(19) and 11<c) then b else t1.c end*a FROM t1 WHERE 17-case 19 when t1.f-+(t1.d)-t1.a*t1.a then ~t1.d | e*coalesce((select b from t1 where 17< -17), -f)-17 else 19 end-case when (~t1.d)*17<f then f when t1.c in (f,a,t1.e) then t1.f else 17 end not in (t1.c,e,t1.d)"
    end, {
        -- <randexpr-2.803>
        20000
        -- </randexpr-2.803>
    })

test:do_test(
    "randexpr-2.804",
    function()
        return test:execsql "SELECT case when 19=(select ( -count(*)* -(cast(avg(t1.e) AS integer))+count(distinct 13)*min(t1.f)) | cast(avg(t1.e) AS integer) |  -cast(avg(13) AS integer)-(min(d)) from t1) then 13*a when t1.a+((select min((t1.d)) from t1)) in (select t1.b from t1 union select 11 from t1) or not exists(select 1 from t1 where not exists(select 1 from t1 where  - -e in (select t1.e from t1 union select t1.d from t1) or t1.d in (select count(distinct t1.a) from t1 union select count(*) from t1)) or  -b=(19) and 11<c) then b else t1.c end*a FROM t1 WHERE NOT (17-case 19 when t1.f-+(t1.d)-t1.a*t1.a then ~t1.d | e*coalesce((select b from t1 where 17< -17), -f)-17 else 19 end-case when (~t1.d)*17<f then f when t1.c in (f,a,t1.e) then t1.f else 17 end not in (t1.c,e,t1.d))"
    end, {
        -- <randexpr-2.804>
        
        -- </randexpr-2.804>
    })

test:do_test(
    "randexpr-2.805",
    function()
        return test:execsql "SELECT case when 19=(select ( -count(*)* -(cast(avg(t1.e) AS integer))+count(distinct 13)*min(t1.f)) & cast(avg(t1.e) AS integer) &  -cast(avg(13) AS integer)-(min(d)) from t1) then 13*a when t1.a+((select min((t1.d)) from t1)) in (select t1.b from t1 union select 11 from t1) or not exists(select 1 from t1 where not exists(select 1 from t1 where  - -e in (select t1.e from t1 union select t1.d from t1) or t1.d in (select count(distinct t1.a) from t1 union select count(*) from t1)) or  -b=(19) and 11<c) then b else t1.c end*a FROM t1 WHERE 17-case 19 when t1.f-+(t1.d)-t1.a*t1.a then ~t1.d | e*coalesce((select b from t1 where 17< -17), -f)-17 else 19 end-case when (~t1.d)*17<f then f when t1.c in (f,a,t1.e) then t1.f else 17 end not in (t1.c,e,t1.d)"
    end, {
        -- <randexpr-2.805>
        20000
        -- </randexpr-2.805>
    })

test:do_test(
    "randexpr-2.806",
    function()
        return test:execsql "SELECT +t1.a*11+case when 19<13-11 or exists(select 1 from t1 where not (abs(f)/abs(+t1.a+t1.c*t1.d-t1.c))*t1.a between t1.e and 17) then coalesce((select max(t1.a) from t1 where t1.b not between t1.a and t1.a),17) when 13 not between  -f and  -t1.d then t1.c else d end-13-13*c*t1.e FROM t1 WHERE 19<=case t1.b when  -t1.d+c-t1.a-19-t1.f*t1.b-coalesce((select max(coalesce((select max( -b) from t1 where not t1.f+19 in (select case cast(avg(17) AS integer) when min(t1.a) then max((d)) else max(b) end | count(*) from t1 union select max(13) from t1) and not exists(select 1 from t1 where t1.c not between 19 and 11)),t1.e)*19) from t1 where 13 in (select  -d from t1 union select t1.f from t1)),b)-e-(t1.e) then t1.f else t1.e end"
    end, {
        -- <randexpr-2.806>
        -1948813
        -- </randexpr-2.806>
    })

test:do_test(
    "randexpr-2.807",
    function()
        return test:execsql "SELECT +t1.a*11+case when 19<13-11 or exists(select 1 from t1 where not (abs(f)/abs(+t1.a+t1.c*t1.d-t1.c))*t1.a between t1.e and 17) then coalesce((select max(t1.a) from t1 where t1.b not between t1.a and t1.a),17) when 13 not between  -f and  -t1.d then t1.c else d end-13-13*c*t1.e FROM t1 WHERE NOT (19<=case t1.b when  -t1.d+c-t1.a-19-t1.f*t1.b-coalesce((select max(coalesce((select max( -b) from t1 where not t1.f+19 in (select case cast(avg(17) AS integer) when min(t1.a) then max((d)) else max(b) end | count(*) from t1 union select max(13) from t1) and not exists(select 1 from t1 where t1.c not between 19 and 11)),t1.e)*19) from t1 where 13 in (select  -d from t1 union select t1.f from t1)),b)-e-(t1.e) then t1.f else t1.e end)"
    end, {
        -- <randexpr-2.807>
        
        -- </randexpr-2.807>
    })

test:do_test(
    "randexpr-2.808",
    function()
        return test:execsql "SELECT case (abs(f)/abs(f)) when t1.e*t1.f then (abs(t1.d)/abs(t1.b*11)) else ~case when case ~~19 when t1.f then e else case coalesce((select (abs(f)/abs(a)) from t1 where t1.a<>17 and t1.a>= -t1.b),t1.f) when t1.d then c else t1.d end end in (select count(*) from t1 union select ~abs(min(t1.a)) | count(*) from t1) then 17 when t1.f not between (e) and t1.c then f else b end+c+a end FROM t1 WHERE t1.f in (case when ~(select max(d) from t1)*t1.f>=case when 17*d<t1.f then d when (t1.d) not between t1.e-t1.d-e and +(t1.e*13*(select case count(*) when  -count(distinct e) then max(13) else count(distinct t1.b) end from t1)-case when c<e then c else 11 end)-17 then  -c else t1.c end then e else (13) end+d,t1.a,11)"
    end, {
        -- <randexpr-2.808>
        
        -- </randexpr-2.808>
    })

test:do_test(
    "randexpr-2.809",
    function()
        return test:execsql "SELECT case (abs(f)/abs(f)) when t1.e*t1.f then (abs(t1.d)/abs(t1.b*11)) else ~case when case ~~19 when t1.f then e else case coalesce((select (abs(f)/abs(a)) from t1 where t1.a<>17 and t1.a>= -t1.b),t1.f) when t1.d then c else t1.d end end in (select count(*) from t1 union select ~abs(min(t1.a)) | count(*) from t1) then 17 when t1.f not between (e) and t1.c then f else b end+c+a end FROM t1 WHERE NOT (t1.f in (case when ~(select max(d) from t1)*t1.f>=case when 17*d<t1.f then d when (t1.d) not between t1.e-t1.d-e and +(t1.e*13*(select case count(*) when  -count(distinct e) then max(13) else count(distinct t1.b) end from t1)-case when c<e then c else 11 end)-17 then  -c else t1.c end then e else (13) end+d,t1.a,11))"
    end, {
        -- <randexpr-2.809>
        -201
        -- </randexpr-2.809>
    })

test:do_test(
    "randexpr-2.810",
    function()
        return test:execsql "SELECT case (abs(f)/abs(f)) when t1.e*t1.f then (abs(t1.d)/abs(t1.b*11)) else ~case when case ~~19 when t1.f then e else case coalesce((select (abs(f)/abs(a)) from t1 where t1.a<>17 and t1.a>= -t1.b),t1.f) when t1.d then c else t1.d end end in (select count(*) from t1 union select ~abs(min(t1.a)) & count(*) from t1) then 17 when t1.f not between (e) and t1.c then f else b end+c+a end FROM t1 WHERE NOT (t1.f in (case when ~(select max(d) from t1)*t1.f>=case when 17*d<t1.f then d when (t1.d) not between t1.e-t1.d-e and +(t1.e*13*(select case count(*) when  -count(distinct e) then max(13) else count(distinct t1.b) end from t1)-case when c<e then c else 11 end)-17 then  -c else t1.c end then e else (13) end+d,t1.a,11))"
    end, {
        -- <randexpr-2.810>
        -201
        -- </randexpr-2.810>
    })

test:do_test(
    "randexpr-2.811",
    function()
        return test:execsql "SELECT (abs(case when a*case when e<+(t1.e) then e else d end+t1.f<c then t1.e when d not between +13 and case when (e>=(select cast(avg(13) AS integer) from t1)) and (exists(select 1 from t1 where not exists(select 1 from t1 where coalesce((select t1.c from t1 where (b between d and 13)),t1.e)>13))) then case when b not between 19 and t1.c then a else 13 end+t1.b when t1.c>11 then c else b end then 13 else t1.d end*t1.f)/abs(17)) FROM t1 WHERE c not in (coalesce((select max(d) from t1 where (select min(t1.e) from t1)-17<=coalesce((select t1.c from t1 where exists(select 1 from t1 where 17<19 or coalesce((select 13 from t1 where t1.e not in (a+t1.c,t1.e*t1.a+t1.d* -a*(a)*f,((b)))),19) not in (c,t1.f,t1.b))),(select abs( -max(19)) from t1))),t1.f)-t1.b, -f,17)"
    end, {
        -- <randexpr-2.811>
        458
        -- </randexpr-2.811>
    })

test:do_test(
    "randexpr-2.812",
    function()
        return test:execsql "SELECT (abs(case when a*case when e<+(t1.e) then e else d end+t1.f<c then t1.e when d not between +13 and case when (e>=(select cast(avg(13) AS integer) from t1)) and (exists(select 1 from t1 where not exists(select 1 from t1 where coalesce((select t1.c from t1 where (b between d and 13)),t1.e)>13))) then case when b not between 19 and t1.c then a else 13 end+t1.b when t1.c>11 then c else b end then 13 else t1.d end*t1.f)/abs(17)) FROM t1 WHERE NOT (c not in (coalesce((select max(d) from t1 where (select min(t1.e) from t1)-17<=coalesce((select t1.c from t1 where exists(select 1 from t1 where 17<19 or coalesce((select 13 from t1 where t1.e not in (a+t1.c,t1.e*t1.a+t1.d* -a*(a)*f,((b)))),19) not in (c,t1.f,t1.b))),(select abs( -max(19)) from t1))),t1.f)-t1.b, -f,17))"
    end, {
        -- <randexpr-2.812>
        
        -- </randexpr-2.812>
    })

test:do_test(
    "randexpr-2.813",
    function()
        return test:execsql "SELECT t1.c*case when (t1.f in (select case (coalesce((select t1.d from t1 where not (coalesce((select d from t1 where f<=(11)),19)*e in (select ((min((17)) |  -min(t1.b))) from t1 union select  -cast(avg(t1.f) AS integer) from t1))),19)+11)*t1.a when t1.d then t1.a else f end-e-t1.a*( -17) from t1 union select c from t1) or 13 not between t1.e and b) then d+19-t1.f else t1.c end-e FROM t1 WHERE t1.f in (~t1.b,13,+e) and 11<>d-case when t1.e<>t1.b or f>t1.f and 19 not between 17 and case when (b not in (b,t1.d,a)) then e else (abs(11)/abs(d)) end and not exists(select 1 from t1 where t1.a<>c) then t1.f when not (t1.b) in (select t1.d from t1 union select t1.c from t1) then 13 else t1.b+a end"
    end, {
        -- <randexpr-2.813>
        
        -- </randexpr-2.813>
    })

test:do_test(
    "randexpr-2.814",
    function()
        return test:execsql "SELECT t1.c*case when (t1.f in (select case (coalesce((select t1.d from t1 where not (coalesce((select d from t1 where f<=(11)),19)*e in (select ((min((17)) |  -min(t1.b))) from t1 union select  -cast(avg(t1.f) AS integer) from t1))),19)+11)*t1.a when t1.d then t1.a else f end-e-t1.a*( -17) from t1 union select c from t1) or 13 not between t1.e and b) then d+19-t1.f else t1.c end-e FROM t1 WHERE NOT (t1.f in (~t1.b,13,+e) and 11<>d-case when t1.e<>t1.b or f>t1.f and 19 not between 17 and case when (b not in (b,t1.d,a)) then e else (abs(11)/abs(d)) end and not exists(select 1 from t1 where t1.a<>c) then t1.f when not (t1.b) in (select t1.d from t1 union select t1.c from t1) then 13 else t1.b+a end)"
    end, {
        -- <randexpr-2.814>
        -54800
        -- </randexpr-2.814>
    })

test:do_test(
    "randexpr-2.815",
    function()
        return test:execsql "SELECT t1.c*case when (t1.f in (select case (coalesce((select t1.d from t1 where not (coalesce((select d from t1 where f<=(11)),19)*e in (select ((min((17)) &  -min(t1.b))) from t1 union select  -cast(avg(t1.f) AS integer) from t1))),19)+11)*t1.a when t1.d then t1.a else f end-e-t1.a*( -17) from t1 union select c from t1) or 13 not between t1.e and b) then d+19-t1.f else t1.c end-e FROM t1 WHERE NOT (t1.f in (~t1.b,13,+e) and 11<>d-case when t1.e<>t1.b or f>t1.f and 19 not between 17 and case when (b not in (b,t1.d,a)) then e else (abs(11)/abs(d)) end and not exists(select 1 from t1 where t1.a<>c) then t1.f when not (t1.b) in (select t1.d from t1 union select t1.c from t1) then 13 else t1.b+a end)"
    end, {
        -- <randexpr-2.815>
        -54800
        -- </randexpr-2.815>
    })

test:do_test(
    "randexpr-2.816",
    function()
        return test:execsql "SELECT e-t1.e+a*f*11*c*case when ~f*t1.d-t1.c*b-13*19+(abs(t1.d)/abs(case when t1.c=13 then 17 else 19 end))*a between b*(select abs(cast(avg(( -13)) AS integer)) from t1)-19+19 and t1.b then t1.d else t1.d end+13 FROM t1 WHERE t1.b not between a and e"
    end, {
        -- <randexpr-2.816>
        
        -- </randexpr-2.816>
    })

test:do_test(
    "randexpr-2.817",
    function()
        return test:execsql "SELECT e-t1.e+a*f*11*c*case when ~f*t1.d-t1.c*b-13*19+(abs(t1.d)/abs(case when t1.c=13 then 17 else 19 end))*a between b*(select abs(cast(avg(( -13)) AS integer)) from t1)-19+19 and t1.b then t1.d else t1.d end+13 FROM t1 WHERE NOT (t1.b not between a and e)"
    end, {
        -- <randexpr-2.817>
        79200000013
        -- </randexpr-2.817>
    })

test:do_test(
    "randexpr-2.818",
    function()
        return test:execsql "SELECT case case when coalesce((select b from t1 where not exists(select 1 from t1 where d-e+coalesce((select max(b) from t1 where case case when t1.d-t1.e not between t1.f and e then 11 else t1.d end when t1.e then f else b end+t1.e=13),t1.c) not in (( -c),c,t1.d))),t1.f)<>a and c not in (t1.b,c,t1.a) then (select count(*) from t1) else c end-11 when t1.d then t1.e else c end FROM t1 WHERE ~b | coalesce((select case (select +count(distinct b) from t1) when coalesce((select case when coalesce((select e from t1 where c>b),t1.c) between 11 and (b) then t1.d else t1.b end-e from t1 where t1.d in (13,t1.a,f)),17) then e else 17 end from t1 where not b=t1.c or t1.d in (select abs(abs( -min(13)*(cast(avg(t1.c) AS integer)))) from t1 union select (max(c)) from t1) and b>t1.a),t1.f) in (select 11 from t1 union select c from t1)"
    end, {
        -- <randexpr-2.818>
        
        -- </randexpr-2.818>
    })

test:do_test(
    "randexpr-2.819",
    function()
        return test:execsql "SELECT case case when coalesce((select b from t1 where not exists(select 1 from t1 where d-e+coalesce((select max(b) from t1 where case case when t1.d-t1.e not between t1.f and e then 11 else t1.d end when t1.e then f else b end+t1.e=13),t1.c) not in (( -c),c,t1.d))),t1.f)<>a and c not in (t1.b,c,t1.a) then (select count(*) from t1) else c end-11 when t1.d then t1.e else c end FROM t1 WHERE NOT (~b | coalesce((select case (select +count(distinct b) from t1) when coalesce((select case when coalesce((select e from t1 where c>b),t1.c) between 11 and (b) then t1.d else t1.b end-e from t1 where t1.d in (13,t1.a,f)),17) then e else 17 end from t1 where not b=t1.c or t1.d in (select abs(abs( -min(13)*(cast(avg(t1.c) AS integer)))) from t1 union select (max(c)) from t1) and b>t1.a),t1.f) in (select 11 from t1 union select c from t1))"
    end, {
        -- <randexpr-2.819>
        300
        -- </randexpr-2.819>
    })

test:do_test(
    "randexpr-2.820",
    function()
        return test:execsql "SELECT case t1.c when t1.e then 19 else  -case when not exists(select 1 from t1 where t1.b in (select (t1.b) from t1 union select +13 from t1)) then coalesce((select max(c*t1.b) from t1 where 17>=19*e),coalesce((select (select abs(~min(coalesce((select max(t1.a) from t1 where  -19 in (f,a,13)),f)))+min(e) | ( -(min(13))) from t1) from t1 where f between  -a and t1.c),t1.e)) when 19<>a then 13 else c end end FROM t1 WHERE t1.e<>f"
    end, {
        -- <randexpr-2.820>
        -13
        -- </randexpr-2.820>
    })

test:do_test(
    "randexpr-2.821",
    function()
        return test:execsql "SELECT case t1.c when t1.e then 19 else  -case when not exists(select 1 from t1 where t1.b in (select (t1.b) from t1 union select +13 from t1)) then coalesce((select max(c*t1.b) from t1 where 17>=19*e),coalesce((select (select abs(~min(coalesce((select max(t1.a) from t1 where  -19 in (f,a,13)),f)))+min(e) | ( -(min(13))) from t1) from t1 where f between  -a and t1.c),t1.e)) when 19<>a then 13 else c end end FROM t1 WHERE NOT (t1.e<>f)"
    end, {
        -- <randexpr-2.821>
        
        -- </randexpr-2.821>
    })

test:do_test(
    "randexpr-2.822",
    function()
        return test:execsql "SELECT case t1.c when t1.e then 19 else  -case when not exists(select 1 from t1 where t1.b in (select (t1.b) from t1 union select +13 from t1)) then coalesce((select max(c*t1.b) from t1 where 17>=19*e),coalesce((select (select abs(~min(coalesce((select max(t1.a) from t1 where  -19 in (f,a,13)),f)))+min(e) & ( -(min(13))) from t1) from t1 where f between  -a and t1.c),t1.e)) when 19<>a then 13 else c end end FROM t1 WHERE t1.e<>f"
    end, {
        -- <randexpr-2.822>
        -13
        -- </randexpr-2.822>
    })

test:do_test(
    "randexpr-2.823",
    function()
        return test:execsql "SELECT 13- -(abs(coalesce((select max(17) from t1 where f*b in (select count(*)*case  -min(~t1.f)+min(coalesce((select  -(select min(17) from t1) from t1 where (t1.b in (select abs(min(t1.f)) from t1 union select  -max(t1.e) from t1))),17)+d) when count(distinct a) then abs(count(*)) else count(*) end from t1 union select min(t1.c) from t1)),coalesce((select max(f) from t1 where d in (select t1.b from t1 union select t1.e from t1)),17)) | t1.a)/abs(c)) | t1.f FROM t1 WHERE (abs(t1.f*11++ -f)/abs(19 | (abs(((abs(f)/abs(17))))/abs(case when a not in (t1.d,(c)-~c*f |  -13-t1.b+ -d,13) then t1.f when 11=11 then c else d end))*d+t1.c))+e+ -(t1.d) in (select t1.a from t1 union select 19 from t1)"
    end, {
        -- <randexpr-2.823>
        
        -- </randexpr-2.823>
    })

test:do_test(
    "randexpr-2.824",
    function()
        return test:execsql "SELECT 13- -(abs(coalesce((select max(17) from t1 where f*b in (select count(*)*case  -min(~t1.f)+min(coalesce((select  -(select min(17) from t1) from t1 where (t1.b in (select abs(min(t1.f)) from t1 union select  -max(t1.e) from t1))),17)+d) when count(distinct a) then abs(count(*)) else count(*) end from t1 union select min(t1.c) from t1)),coalesce((select max(f) from t1 where d in (select t1.b from t1 union select t1.e from t1)),17)) | t1.a)/abs(c)) | t1.f FROM t1 WHERE NOT ((abs(t1.f*11++ -f)/abs(19 | (abs(((abs(f)/abs(17))))/abs(case when a not in (t1.d,(c)-~c*f |  -13-t1.b+ -d,13) then t1.f when 11=11 then c else d end))*d+t1.c))+e+ -(t1.d) in (select t1.a from t1 union select 19 from t1))"
    end, {
        -- <randexpr-2.824>
        605
        -- </randexpr-2.824>
    })

test:do_test(
    "randexpr-2.825",
    function()
        return test:execsql "SELECT 13- -(abs(coalesce((select max(17) from t1 where f*b in (select count(*)*case  -min(~t1.f)+min(coalesce((select  -(select min(17) from t1) from t1 where (t1.b in (select abs(min(t1.f)) from t1 union select  -max(t1.e) from t1))),17)+d) when count(distinct a) then abs(count(*)) else count(*) end from t1 union select min(t1.c) from t1)),coalesce((select max(f) from t1 where d in (select t1.b from t1 union select t1.e from t1)),17)) & t1.a)/abs(c)) & t1.f FROM t1 WHERE NOT ((abs(t1.f*11++ -f)/abs(19 | (abs(((abs(f)/abs(17))))/abs(case when a not in (t1.d,(c)-~c*f |  -13-t1.b+ -d,13) then t1.f when 11=11 then c else d end))*d+t1.c))+e+ -(t1.d) in (select t1.a from t1 union select 19 from t1))"
    end, {
        -- <randexpr-2.825>
        8
        -- </randexpr-2.825>
    })

test:do_test(
    "randexpr-2.826",
    function()
        return test:execsql "SELECT (a+case when (exists(select 1 from t1 where not exists(select 1 from t1 where not t1.e*13=13-f or (e)=t1.c or  -d not between t1.b and t1.a or e not between 17 and (a) and 11 not in (a,(t1.f),a) or t1.e<>13 or t1.d between t1.e and t1.c or t1.d=17 or a>=b))) and a between t1.e and t1.b then case when e not between (17) and t1.d then ~c*coalesce((select t1.a | 13+d from t1 where t1.e not between b and 11),t1.a) else t1.f end else t1.f end-11) FROM t1 WHERE case when case case when case when  -(select +min(11) from t1)*(13)>11 then t1.e when 13<e then 19 else c end in (t1.a,a,t1.e) then 17 when c<>t1.a then t1.d else  -t1.e end when (a) then a else t1.e end>t1.a then 13 when t1.a not in (t1.f,t1.b,t1.a) then a else t1.c end in (select cast(avg(13) AS integer) from t1 union select (max(t1.e)+min(17)) from t1)"
    end, {
        -- <randexpr-2.826>
        689
        -- </randexpr-2.826>
    })

test:do_test(
    "randexpr-2.827",
    function()
        return test:execsql "SELECT (a+case when (exists(select 1 from t1 where not exists(select 1 from t1 where not t1.e*13=13-f or (e)=t1.c or  -d not between t1.b and t1.a or e not between 17 and (a) and 11 not in (a,(t1.f),a) or t1.e<>13 or t1.d between t1.e and t1.c or t1.d=17 or a>=b))) and a between t1.e and t1.b then case when e not between (17) and t1.d then ~c*coalesce((select t1.a | 13+d from t1 where t1.e not between b and 11),t1.a) else t1.f end else t1.f end-11) FROM t1 WHERE NOT (case when case case when case when  -(select +min(11) from t1)*(13)>11 then t1.e when 13<e then 19 else c end in (t1.a,a,t1.e) then 17 when c<>t1.a then t1.d else  -t1.e end when (a) then a else t1.e end>t1.a then 13 when t1.a not in (t1.f,t1.b,t1.a) then a else t1.c end in (select cast(avg(13) AS integer) from t1 union select (max(t1.e)+min(17)) from t1))"
    end, {
        -- <randexpr-2.827>
        
        -- </randexpr-2.827>
    })

test:do_test(
    "randexpr-2.828",
    function()
        return test:execsql "SELECT (a+case when (exists(select 1 from t1 where not exists(select 1 from t1 where not t1.e*13=13-f or (e)=t1.c or  -d not between t1.b and t1.a or e not between 17 and (a) and 11 not in (a,(t1.f),a) or t1.e<>13 or t1.d between t1.e and t1.c or t1.d=17 or a>=b))) and a between t1.e and t1.b then case when e not between (17) and t1.d then ~c*coalesce((select t1.a & 13+d from t1 where t1.e not between b and 11),t1.a) else t1.f end else t1.f end-11) FROM t1 WHERE case when case case when case when  -(select +min(11) from t1)*(13)>11 then t1.e when 13<e then 19 else c end in (t1.a,a,t1.e) then 17 when c<>t1.a then t1.d else  -t1.e end when (a) then a else t1.e end>t1.a then 13 when t1.a not in (t1.f,t1.b,t1.a) then a else t1.c end in (select cast(avg(13) AS integer) from t1 union select (max(t1.e)+min(17)) from t1)"
    end, {
        -- <randexpr-2.828>
        689
        -- </randexpr-2.828>
    })

test:do_test(
    "randexpr-2.829",
    function()
        return test:execsql "SELECT ~b-t1.a-f*+case when exists(select 1 from t1 where 17<>t1.d-f or not exists(select 1 from t1 where (select (min(a)+count(distinct d)) from t1)+( -f)- -c<t1.e or d not between t1.a and b and exists(select 1 from t1 where 11<(a)) and 13=d or 13 between (t1.f) and f)) then t1.b when a not in (e,d,d) then (select ((count(*))) from t1) else case d when d then  -e else 11 end end FROM t1 WHERE ~(abs(17)/abs((a)))*~t1.e-coalesce((select (abs((select abs(cast(avg(d) AS integer)) from t1) | 13*e+17)/abs(t1.f)) from t1 where t1.c<>f and not exists(select 1 from t1 where t1.c<b or 19 in (17,19,b) or 17 not between a and f) or a not in (c,b,17)),t1.c)+t1.a-e-t1.f*e+ -a-t1.a*d not in (d,( -f),t1.a)"
    end, {
        -- <randexpr-2.829>
        -120301
        -- </randexpr-2.829>
    })

test:do_test(
    "randexpr-2.830",
    function()
        return test:execsql "SELECT ~b-t1.a-f*+case when exists(select 1 from t1 where 17<>t1.d-f or not exists(select 1 from t1 where (select (min(a)+count(distinct d)) from t1)+( -f)- -c<t1.e or d not between t1.a and b and exists(select 1 from t1 where 11<(a)) and 13=d or 13 between (t1.f) and f)) then t1.b when a not in (e,d,d) then (select ((count(*))) from t1) else case d when d then  -e else 11 end end FROM t1 WHERE NOT (~(abs(17)/abs((a)))*~t1.e-coalesce((select (abs((select abs(cast(avg(d) AS integer)) from t1) | 13*e+17)/abs(t1.f)) from t1 where t1.c<>f and not exists(select 1 from t1 where t1.c<b or 19 in (17,19,b) or 17 not between a and f) or a not in (c,b,17)),t1.c)+t1.a-e-t1.f*e+ -a-t1.a*d not in (d,( -f),t1.a))"
    end, {
        -- <randexpr-2.830>
        
        -- </randexpr-2.830>
    })

test:do_test(
    "randexpr-2.831",
    function()
        return test:execsql "SELECT (t1.a)*t1.d*t1.c+t1.b*case when (select case count(*) when (count(*))+ - -count(*)+cast(avg(t1.d) AS integer)- - -min(f) then min(11) else cast(avg(c) AS integer) end from t1) in (select (cast(avg((19)) AS integer)) from t1 union select max(t1.e) from t1) then b when d=a then t1.f else coalesce((select t1.c from t1 where not exists(select 1 from t1 where (~+a not in ((a),b,t1.f)))),case e when 13 then t1.f else 13 end) end FROM t1 WHERE c | a | ~(t1.d)+t1.b not in (t1.a* -+13+~(abs( -case when (11) in (select e from t1 union select t1.f*coalesce((select case when e<e then t1.f when (13) in (13,t1.d,t1.c) then c else t1.d end from t1 where t1.b between  -11 and e),e) from t1) then t1.a else d end*t1.a)/abs(t1.e)),19,d) or t1.e<b"
    end, {
        -- <randexpr-2.831>
        12002600
        -- </randexpr-2.831>
    })

test:do_test(
    "randexpr-2.832",
    function()
        return test:execsql "SELECT (t1.a)*t1.d*t1.c+t1.b*case when (select case count(*) when (count(*))+ - -count(*)+cast(avg(t1.d) AS integer)- - -min(f) then min(11) else cast(avg(c) AS integer) end from t1) in (select (cast(avg((19)) AS integer)) from t1 union select max(t1.e) from t1) then b when d=a then t1.f else coalesce((select t1.c from t1 where not exists(select 1 from t1 where (~+a not in ((a),b,t1.f)))),case e when 13 then t1.f else 13 end) end FROM t1 WHERE NOT (c | a | ~(t1.d)+t1.b not in (t1.a* -+13+~(abs( -case when (11) in (select e from t1 union select t1.f*coalesce((select case when e<e then t1.f when (13) in (13,t1.d,t1.c) then c else t1.d end from t1 where t1.b between  -11 and e),e) from t1) then t1.a else d end*t1.a)/abs(t1.e)),19,d) or t1.e<b)"
    end, {
        -- <randexpr-2.832>
        
        -- </randexpr-2.832>
    })

test:do_test(
    "randexpr-2.833",
    function()
        return test:execsql "SELECT case when case ~( -t1.e)-a when coalesce((select max(case +t1.e when t1.b*~19 | t1.a*case when c-c<>19 then 13 else c end*d+t1.c then f else 17 end) from t1 where d<=e), -d) then 19 else 17 end in (t1.b,19,c) then 19 when t1.a in (select a from t1 union select 13 from t1) then t1.d else t1.d end FROM t1 WHERE (select abs(cast(avg(t1.d*t1.f) AS integer))-cast(avg(b) AS integer) from t1)-~coalesce((select max(t1.a+t1.d-coalesce((select max(a*case when t1.e<=e then f when t1.d<>a then 11 else 11 end*t1.a*11) from t1 where t1.d>=d),t1.f)) from t1 where 11 not between (13) and 17),f)*t1.b+17-e not in (t1.d,t1.f,t1.f)"
    end, {
        -- <randexpr-2.833>
        400
        -- </randexpr-2.833>
    })

test:do_test(
    "randexpr-2.834",
    function()
        return test:execsql "SELECT case when case ~( -t1.e)-a when coalesce((select max(case +t1.e when t1.b*~19 | t1.a*case when c-c<>19 then 13 else c end*d+t1.c then f else 17 end) from t1 where d<=e), -d) then 19 else 17 end in (t1.b,19,c) then 19 when t1.a in (select a from t1 union select 13 from t1) then t1.d else t1.d end FROM t1 WHERE NOT ((select abs(cast(avg(t1.d*t1.f) AS integer))-cast(avg(b) AS integer) from t1)-~coalesce((select max(t1.a+t1.d-coalesce((select max(a*case when t1.e<=e then f when t1.d<>a then 11 else 11 end*t1.a*11) from t1 where t1.d>=d),t1.f)) from t1 where 11 not between (13) and 17),f)*t1.b+17-e not in (t1.d,t1.f,t1.f))"
    end, {
        -- <randexpr-2.834>
        
        -- </randexpr-2.834>
    })

test:do_test(
    "randexpr-2.835",
    function()
        return test:execsql "SELECT case when case ~( -t1.e)-a when coalesce((select max(case +t1.e when t1.b*~19 & t1.a*case when c-c<>19 then 13 else c end*d+t1.c then f else 17 end) from t1 where d<=e), -d) then 19 else 17 end in (t1.b,19,c) then 19 when t1.a in (select a from t1 union select 13 from t1) then t1.d else t1.d end FROM t1 WHERE (select abs(cast(avg(t1.d*t1.f) AS integer))-cast(avg(b) AS integer) from t1)-~coalesce((select max(t1.a+t1.d-coalesce((select max(a*case when t1.e<=e then f when t1.d<>a then 11 else 11 end*t1.a*11) from t1 where t1.d>=d),t1.f)) from t1 where 11 not between (13) and 17),f)*t1.b+17-e not in (t1.d,t1.f,t1.f)"
    end, {
        -- <randexpr-2.835>
        400
        -- </randexpr-2.835>
    })

test:do_test(
    "randexpr-2.836",
    function()
        return test:execsql "SELECT t1.d+case when case when case when (19 not between ~(t1.a)*b and t1.c) then (select (abs(case count(distinct t1.e) when min( -f) then  -max(t1.d) else cast(avg(19) AS integer) end-(count(distinct t1.e)))) from t1) when a<>t1.f then  -19 else 11 end>f or b in ((13),f,11) then t1.a when t1.e in (e,f,t1.f) then (t1.d) else t1.d end in (17,t1.c,17) then 13 when b not between t1.a and (19) then t1.e else  -11 end+a+((f)) FROM t1 WHERE t1.f in (select case +cast(avg(t1.f+c) AS integer)++count(*) when count(*) then ~~(count(distinct 11+t1.a)) else +(case max(e-f) | ~ -max(t1.f) |  -abs(abs(min(e-19+e))-abs(count(*)))-abs(cast(avg(f) AS integer)) when (min(f)) then cast(avg(a) AS integer) else min(13) end) end from t1 union select  -count(distinct 13) from t1)"
    end, {
        -- <randexpr-2.836>
        
        -- </randexpr-2.836>
    })

test:do_test(
    "randexpr-2.837",
    function()
        return test:execsql "SELECT t1.d+case when case when case when (19 not between ~(t1.a)*b and t1.c) then (select (abs(case count(distinct t1.e) when min( -f) then  -max(t1.d) else cast(avg(19) AS integer) end-(count(distinct t1.e)))) from t1) when a<>t1.f then  -19 else 11 end>f or b in ((13),f,11) then t1.a when t1.e in (e,f,t1.f) then (t1.d) else t1.d end in (17,t1.c,17) then 13 when b not between t1.a and (19) then t1.e else  -11 end+a+((f)) FROM t1 WHERE NOT (t1.f in (select case +cast(avg(t1.f+c) AS integer)++count(*) when count(*) then ~~(count(distinct 11+t1.a)) else +(case max(e-f) | ~ -max(t1.f) |  -abs(abs(min(e-19+e))-abs(count(*)))-abs(cast(avg(f) AS integer)) when (min(f)) then cast(avg(a) AS integer) else min(13) end) end from t1 union select  -count(distinct 13) from t1))"
    end, {
        -- <randexpr-2.837>
        1600
        -- </randexpr-2.837>
    })

test:do_test(
    "randexpr-2.838",
    function()
        return test:execsql "SELECT (select (min(case when b+b*(select cast(avg(e+19-t1.f*case when case when not (c) in (select (e) from t1 union select f from t1) or t1.b not in (t1.e,t1.b,11) or 19= -t1.a then 17 else  -d end<e then e when t1.b>13 then 13 else t1.f end+11*19) AS integer) from t1)+d not between 11 and c then t1.c else t1.c end)) from t1) FROM t1 WHERE 13 not between +b* -f and coalesce((select f*19-case when not a=~f+t1.d then case when d*b not in (case when d not between  -c and t1.d then e else 13 end+17,c,t1.a) then b when t1.e>t1.f then b else  -d end else f end-e+(d) from t1 where 17 between t1.a and t1.e),t1.d) | t1.b"
    end, {
        -- <randexpr-2.838>
        
        -- </randexpr-2.838>
    })

test:do_test(
    "randexpr-2.839",
    function()
        return test:execsql "SELECT (select (min(case when b+b*(select cast(avg(e+19-t1.f*case when case when not (c) in (select (e) from t1 union select f from t1) or t1.b not in (t1.e,t1.b,11) or 19= -t1.a then 17 else  -d end<e then e when t1.b>13 then 13 else t1.f end+11*19) AS integer) from t1)+d not between 11 and c then t1.c else t1.c end)) from t1) FROM t1 WHERE NOT (13 not between +b* -f and coalesce((select f*19-case when not a=~f+t1.d then case when d*b not in (case when d not between  -c and t1.d then e else 13 end+17,c,t1.a) then b when t1.e>t1.f then b else  -d end else f end-e+(d) from t1 where 17 between t1.a and t1.e),t1.d) | t1.b)"
    end, {
        -- <randexpr-2.839>
        300
        -- </randexpr-2.839>
    })

test:do_test(
    "randexpr-2.840",
    function()
        return test:execsql "SELECT t1.c-(abs((select (case abs(count(distinct 11-c*11)) when count(*) then count(*) else  -min(+e+~e+coalesce((select d-a*t1.d+t1.e from t1 where (t1.f>=17) and t1.e in (11,a,e)),13)*t1.d) end) from t1)-(a-t1.f)-t1.d)/abs(d)) FROM t1 WHERE t1.c in (select d from t1 union select ( -t1.e) from t1)"
    end, {
        -- <randexpr-2.840>
        
        -- </randexpr-2.840>
    })

test:do_test(
    "randexpr-2.841",
    function()
        return test:execsql "SELECT t1.c-(abs((select (case abs(count(distinct 11-c*11)) when count(*) then count(*) else  -min(+e+~e+coalesce((select d-a*t1.d+t1.e from t1 where (t1.f>=17) and t1.e in (11,a,e)),13)*t1.d) end) from t1)-(a-t1.f)-t1.d)/abs(d)) FROM t1 WHERE NOT (t1.c in (select d from t1 union select ( -t1.e) from t1))"
    end, {
        -- <randexpr-2.841>
        300
        -- </randexpr-2.841>
    })

test:do_test(
    "randexpr-2.842",
    function()
        return test:execsql "SELECT case when coalesce((select max(t1.a-case when not (coalesce((select d+c from t1 where c between ( -(a)) and b or 17 between 11 and (c)),(t1.f)))=f then b | d when f not in (t1.b,f,a) then t1.a else f end-t1.f) from t1 where 19<=11 and t1.c between 19 and t1.a or t1.f>11), -t1.e)*e between b and 17 then  -t1.f when  -a<=19 or  -11<>t1.f then  -19 else d end FROM t1 WHERE ((13 in (t1.b,f,b)))"
    end, {
        -- <randexpr-2.842>
        
        -- </randexpr-2.842>
    })

test:do_test(
    "randexpr-2.843",
    function()
        return test:execsql "SELECT case when coalesce((select max(t1.a-case when not (coalesce((select d+c from t1 where c between ( -(a)) and b or 17 between 11 and (c)),(t1.f)))=f then b | d when f not in (t1.b,f,a) then t1.a else f end-t1.f) from t1 where 19<=11 and t1.c between 19 and t1.a or t1.f>11), -t1.e)*e between b and 17 then  -t1.f when  -a<=19 or  -11<>t1.f then  -19 else d end FROM t1 WHERE NOT (((13 in (t1.b,f,b))))"
    end, {
        -- <randexpr-2.843>
        -19
        -- </randexpr-2.843>
    })

test:do_test(
    "randexpr-2.844",
    function()
        return test:execsql "SELECT case when coalesce((select max(t1.a-case when not (coalesce((select d+c from t1 where c between ( -(a)) and b or 17 between 11 and (c)),(t1.f)))=f then b & d when f not in (t1.b,f,a) then t1.a else f end-t1.f) from t1 where 19<=11 and t1.c between 19 and t1.a or t1.f>11), -t1.e)*e between b and 17 then  -t1.f when  -a<=19 or  -11<>t1.f then  -19 else d end FROM t1 WHERE NOT (((13 in (t1.b,f,b))))"
    end, {
        -- <randexpr-2.844>
        -19
        -- </randexpr-2.844>
    })

test:do_test(
    "randexpr-2.845",
    function()
        return test:execsql "SELECT case  -(abs(t1.b-13*d*b*t1.e- -11)/abs(+d-t1.f*(11+ -13)-t1.c))+c+(e*t1.c)+f*17*a | t1.e-13+f when t1.d then t1.e else f end-t1.f FROM t1 WHERE  -b*t1.c>13"
    end, {
        -- <randexpr-2.845>
        
        -- </randexpr-2.845>
    })

test:do_test(
    "randexpr-2.846",
    function()
        return test:execsql "SELECT case  -(abs(t1.b-13*d*b*t1.e- -11)/abs(+d-t1.f*(11+ -13)-t1.c))+c+(e*t1.c)+f*17*a | t1.e-13+f when t1.d then t1.e else f end-t1.f FROM t1 WHERE NOT ( -b*t1.c>13)"
    end, {
        -- <randexpr-2.846>
        0
        -- </randexpr-2.846>
    })

test:do_test(
    "randexpr-2.847",
    function()
        return test:execsql "SELECT case  -(abs(t1.b-13*d*b*t1.e- -11)/abs(+d-t1.f*(11+ -13)-t1.c))+c+(e*t1.c)+f*17*a & t1.e-13+f when t1.d then t1.e else f end-t1.f FROM t1 WHERE NOT ( -b*t1.c>13)"
    end, {
        -- <randexpr-2.847>
        0
        -- </randexpr-2.847>
    })

test:do_test(
    "randexpr-2.848",
    function()
        return test:execsql "SELECT case when t1.c between t1.e and ~t1.d+(abs(~d*case t1.b-19 when t1.e then e else e end)/abs(case case t1.b when c then t1.d else 13+17 | e end when (select abs(abs(min(11) | max((a)))) from t1) then d else ~t1.f end)) | t1.b then t1.c when (not (11>=b)) then 13 else e end-a FROM t1 WHERE +13*case when +11*t1.f=f+t1.b then t1.f else t1.b end not between coalesce((select max(f) from t1 where (not exists(select 1 from t1 where exists(select 1 from t1 where not not exists(select 1 from t1 where t1.c in (select abs(min(e)) from t1 union select ~ -case cast(avg(~17) AS integer) when min(e | 17) then min(e) else cast(avg(c) AS integer) end from t1)))) or f>e*t1.a+e)),t1.c) and 17"
    end, {
        -- <randexpr-2.848>
        -87
        -- </randexpr-2.848>
    })

test:do_test(
    "randexpr-2.849",
    function()
        return test:execsql "SELECT case when t1.c between t1.e and ~t1.d+(abs(~d*case t1.b-19 when t1.e then e else e end)/abs(case case t1.b when c then t1.d else 13+17 | e end when (select abs(abs(min(11) | max((a)))) from t1) then d else ~t1.f end)) | t1.b then t1.c when (not (11>=b)) then 13 else e end-a FROM t1 WHERE NOT (+13*case when +11*t1.f=f+t1.b then t1.f else t1.b end not between coalesce((select max(f) from t1 where (not exists(select 1 from t1 where exists(select 1 from t1 where not not exists(select 1 from t1 where t1.c in (select abs(min(e)) from t1 union select ~ -case cast(avg(~17) AS integer) when min(e | 17) then min(e) else cast(avg(c) AS integer) end from t1)))) or f>e*t1.a+e)),t1.c) and 17)"
    end, {
        -- <randexpr-2.849>
        
        -- </randexpr-2.849>
    })

test:do_test(
    "randexpr-2.850",
    function()
        return test:execsql "SELECT case when t1.c between t1.e and ~t1.d+(abs(~d*case t1.b-19 when t1.e then e else e end)/abs(case case t1.b when c then t1.d else 13+17 & e end when (select abs(abs(min(11) & max((a)))) from t1) then d else ~t1.f end)) & t1.b then t1.c when (not (11>=b)) then 13 else e end-a FROM t1 WHERE +13*case when +11*t1.f=f+t1.b then t1.f else t1.b end not between coalesce((select max(f) from t1 where (not exists(select 1 from t1 where exists(select 1 from t1 where not not exists(select 1 from t1 where t1.c in (select abs(min(e)) from t1 union select ~ -case cast(avg(~17) AS integer) when min(e | 17) then min(e) else cast(avg(c) AS integer) end from t1)))) or f>e*t1.a+e)),t1.c) and 17"
    end, {
        -- <randexpr-2.850>
        -87
        -- </randexpr-2.850>
    })

test:do_test(
    "randexpr-2.851",
    function()
        return test:execsql "SELECT coalesce((select +case when case d when b then e else (select min(case b when 17 then b else t1.c end)+ -+ -(abs(max(t1.e))-min(t1.d)+max( -d)) | count(distinct t1.e)+( -cast(avg(13) AS integer)) | max(t1.f)+min(e)+count(*) from t1) end<>b then t1.a else 19*~t1.e-c | t1.c end from t1 where b in ( -c,t1.f,t1.c)),19) FROM t1 WHERE (abs(d)/abs(coalesce((select max(coalesce((select d*c from t1 where ((abs(t1.b)/abs(t1.d))-(abs(t1.f)/abs(t1.c))+(t1.a)*13-t1.e not between t1.e and ~f*11+t1.f-11 | t1.a+13+d)),19)) from t1 where c not in (+ -11,a,c)),t1.c))) in (b,b,a)"
    end, {
        -- <randexpr-2.851>
        
        -- </randexpr-2.851>
    })

test:do_test(
    "randexpr-2.852",
    function()
        return test:execsql "SELECT coalesce((select +case when case d when b then e else (select min(case b when 17 then b else t1.c end)+ -+ -(abs(max(t1.e))-min(t1.d)+max( -d)) | count(distinct t1.e)+( -cast(avg(13) AS integer)) | max(t1.f)+min(e)+count(*) from t1) end<>b then t1.a else 19*~t1.e-c | t1.c end from t1 where b in ( -c,t1.f,t1.c)),19) FROM t1 WHERE NOT ((abs(d)/abs(coalesce((select max(coalesce((select d*c from t1 where ((abs(t1.b)/abs(t1.d))-(abs(t1.f)/abs(t1.c))+(t1.a)*13-t1.e not between t1.e and ~f*11+t1.f-11 | t1.a+13+d)),19)) from t1 where c not in (+ -11,a,c)),t1.c))) in (b,b,a))"
    end, {
        -- <randexpr-2.852>
        19
        -- </randexpr-2.852>
    })

test:do_test(
    "randexpr-2.853",
    function()
        return test:execsql "SELECT coalesce((select +case when case d when b then e else (select min(case b when 17 then b else t1.c end)+ -+ -(abs(max(t1.e))-min(t1.d)+max( -d)) & count(distinct t1.e)+( -cast(avg(13) AS integer)) & max(t1.f)+min(e)+count(*) from t1) end<>b then t1.a else 19*~t1.e-c & t1.c end from t1 where b in ( -c,t1.f,t1.c)),19) FROM t1 WHERE NOT ((abs(d)/abs(coalesce((select max(coalesce((select d*c from t1 where ((abs(t1.b)/abs(t1.d))-(abs(t1.f)/abs(t1.c))+(t1.a)*13-t1.e not between t1.e and ~f*11+t1.f-11 | t1.a+13+d)),19)) from t1 where c not in (+ -11,a,c)),t1.c))) in (b,b,a))"
    end, {
        -- <randexpr-2.853>
        19
        -- </randexpr-2.853>
    })

test:do_test(
    "randexpr-2.854",
    function()
        return test:execsql "SELECT a-a-(abs(f)/abs(coalesce((select 17+19 from t1 where (select min(t1.e*e) from t1)>t1.b+case when not exists(select 1 from t1 where e not between 11 and t1.f-e) then coalesce((select max(f*case when t1.f not in (19,t1.c,(t1.a)) and c<=17 then 11 when 17 not between 11 and 17 then c else 17 end) from t1 where d not between t1.a and 13),t1.c) else t1.b end-13 and a=t1.e),17)+t1.c))-f FROM t1 WHERE +(select cast(avg(13-t1.a-t1.b++t1.a-(select count(*) from t1)+case b-(select +~ -min(case when exists(select 1 from t1 where ((select count(*)+ -(min(13)) from t1)) not between 13 and 13) then d else e end) from t1) when f*t1.b*t1.b then t1.a else b end*t1.a) AS integer) from t1)*t1.b in (t1.f,17,f)"
    end, {
        -- <randexpr-2.854>
        
        -- </randexpr-2.854>
    })

test:do_test(
    "randexpr-2.855",
    function()
        return test:execsql "SELECT a-a-(abs(f)/abs(coalesce((select 17+19 from t1 where (select min(t1.e*e) from t1)>t1.b+case when not exists(select 1 from t1 where e not between 11 and t1.f-e) then coalesce((select max(f*case when t1.f not in (19,t1.c,(t1.a)) and c<=17 then 11 when 17 not between 11 and 17 then c else 17 end) from t1 where d not between t1.a and 13),t1.c) else t1.b end-13 and a=t1.e),17)+t1.c))-f FROM t1 WHERE NOT (+(select cast(avg(13-t1.a-t1.b++t1.a-(select count(*) from t1)+case b-(select +~ -min(case when exists(select 1 from t1 where ((select count(*)+ -(min(13)) from t1)) not between 13 and 13) then d else e end) from t1) when f*t1.b*t1.b then t1.a else b end*t1.a) AS integer) from t1)*t1.b in (t1.f,17,f))"
    end, {
        -- <randexpr-2.855>
        -601
        -- </randexpr-2.855>
    })

test:do_test(
    "randexpr-2.856",
    function()
        return test:execsql "SELECT case when (11+19 | t1.e-e*17=t1.e*~d+t1.a+ -d | a-~(abs((abs((case when 13 not in (b,((t1.a)),f) then t1.d else t1.a end+e))/abs(t1.f))*b+t1.b)/abs(17))+t1.e+t1.a) then 11 else t1.a end FROM t1 WHERE case (case when (select +~ -~ -cast(avg(b*e*case when t1.a between t1.c and a and d<13 then b else 19 end* -f*d) AS integer) | count(*)++~+min((11))*max(19)-min((b)) from t1) in (select 13 from t1 union select (select min(19) from t1) from t1) then t1.f+t1.d else 13 end-t1.e) when t1.e then t1.f else a end<e"
    end, {
        -- <randexpr-2.856>
        100
        -- </randexpr-2.856>
    })

test:do_test(
    "randexpr-2.857",
    function()
        return test:execsql "SELECT case when (11+19 | t1.e-e*17=t1.e*~d+t1.a+ -d | a-~(abs((abs((case when 13 not in (b,((t1.a)),f) then t1.d else t1.a end+e))/abs(t1.f))*b+t1.b)/abs(17))+t1.e+t1.a) then 11 else t1.a end FROM t1 WHERE NOT (case (case when (select +~ -~ -cast(avg(b*e*case when t1.a between t1.c and a and d<13 then b else 19 end* -f*d) AS integer) | count(*)++~+min((11))*max(19)-min((b)) from t1) in (select 13 from t1 union select (select min(19) from t1) from t1) then t1.f+t1.d else 13 end-t1.e) when t1.e then t1.f else a end<e)"
    end, {
        -- <randexpr-2.857>
        
        -- </randexpr-2.857>
    })

test:do_test(
    "randexpr-2.858",
    function()
        return test:execsql "SELECT case when (11+19 & t1.e-e*17=t1.e*~d+t1.a+ -d & a-~(abs((abs((case when 13 not in (b,((t1.a)),f) then t1.d else t1.a end+e))/abs(t1.f))*b+t1.b)/abs(17))+t1.e+t1.a) then 11 else t1.a end FROM t1 WHERE case (case when (select +~ -~ -cast(avg(b*e*case when t1.a between t1.c and a and d<13 then b else 19 end* -f*d) AS integer) | count(*)++~+min((11))*max(19)-min((b)) from t1) in (select 13 from t1 union select (select min(19) from t1) from t1) then t1.f+t1.d else 13 end-t1.e) when t1.e then t1.f else a end<e"
    end, {
        -- <randexpr-2.858>
        100
        -- </randexpr-2.858>
    })

test:do_test(
    "randexpr-2.859",
    function()
        return test:execsql "SELECT coalesce((select max(+t1.a) from t1 where c in (select  -max(d | coalesce((select max(t1.b) from t1 where (abs(case d when t1.f then t1.e else t1.c end-t1.f)/abs(13))<=11), -a)) | min(t1.c) | (max(f))++abs(case max(b) when (count(distinct e)) then count(*) else min(17) end) from t1 union select (min(19)) from t1) or not exists(select 1 from t1 where coalesce((select c from t1 where b in (select  - - - -count(*) from t1 union select  -min((a)) from t1)),13)<t1.d)),17) FROM t1 WHERE ~a in (select count(*) from t1 union select case +abs((abs(abs(count(*))))+min(a))*max(case when exists(select 1 from t1 where d between 17+(b)-a and 17) then (select count(*) from t1) when 13<> -t1.b then t1.f else t1.e end)*min(t1.a)+ -count(*) | +max(e)*(min(t1.e)) | count(distinct t1.d) | (count(*)) when count(distinct ((19))) then count(*) else max(t1.f) end from t1)"
    end, {
        -- <randexpr-2.859>
        
        -- </randexpr-2.859>
    })

test:do_test(
    "randexpr-2.860",
    function()
        return test:execsql "SELECT coalesce((select max(+t1.a) from t1 where c in (select  -max(d | coalesce((select max(t1.b) from t1 where (abs(case d when t1.f then t1.e else t1.c end-t1.f)/abs(13))<=11), -a)) | min(t1.c) | (max(f))++abs(case max(b) when (count(distinct e)) then count(*) else min(17) end) from t1 union select (min(19)) from t1) or not exists(select 1 from t1 where coalesce((select c from t1 where b in (select  - - - -count(*) from t1 union select  -min((a)) from t1)),13)<t1.d)),17) FROM t1 WHERE NOT (~a in (select count(*) from t1 union select case +abs((abs(abs(count(*))))+min(a))*max(case when exists(select 1 from t1 where d between 17+(b)-a and 17) then (select count(*) from t1) when 13<> -t1.b then t1.f else t1.e end)*min(t1.a)+ -count(*) | +max(e)*(min(t1.e)) | count(distinct t1.d) | (count(*)) when count(distinct ((19))) then count(*) else max(t1.f) end from t1))"
    end, {
        -- <randexpr-2.860>
        17
        -- </randexpr-2.860>
    })

test:do_test(
    "randexpr-2.861",
    function()
        return test:execsql "SELECT coalesce((select max(+t1.a) from t1 where c in (select  -max(d & coalesce((select max(t1.b) from t1 where (abs(case d when t1.f then t1.e else t1.c end-t1.f)/abs(13))<=11), -a)) & min(t1.c) & (max(f))++abs(case max(b) when (count(distinct e)) then count(*) else min(17) end) from t1 union select (min(19)) from t1) or not exists(select 1 from t1 where coalesce((select c from t1 where b in (select  - - - -count(*) from t1 union select  -min((a)) from t1)),13)<t1.d)),17) FROM t1 WHERE NOT (~a in (select count(*) from t1 union select case +abs((abs(abs(count(*))))+min(a))*max(case when exists(select 1 from t1 where d between 17+(b)-a and 17) then (select count(*) from t1) when 13<> -t1.b then t1.f else t1.e end)*min(t1.a)+ -count(*) | +max(e)*(min(t1.e)) | count(distinct t1.d) | (count(*)) when count(distinct ((19))) then count(*) else max(t1.f) end from t1))"
    end, {
        -- <randexpr-2.861>
        17
        -- </randexpr-2.861>
    })

test:do_test(
    "randexpr-2.862",
    function()
        return test:execsql "SELECT case 17 when (select ~count(distinct t1.d) from t1) then e else case when not not exists(select 1 from t1 where (abs(~coalesce((select (coalesce((select max(13) from t1 where e>a),19)) from t1 where (not exists(select 1 from t1 where t1.c in (f,b,c)))),c)*t1.c | 17-(e))/abs(t1.f)) | 17*17*a in (select e from t1 union select f from t1)) then 13 when t1.a not between (b) and t1.c then (abs(17)/abs(17)) else t1.d end*f end FROM t1 WHERE t1.a>t1.c-19"
    end, {
        -- <randexpr-2.862>
        
        -- </randexpr-2.862>
    })

test:do_test(
    "randexpr-2.863",
    function()
        return test:execsql "SELECT case 17 when (select ~count(distinct t1.d) from t1) then e else case when not not exists(select 1 from t1 where (abs(~coalesce((select (coalesce((select max(13) from t1 where e>a),19)) from t1 where (not exists(select 1 from t1 where t1.c in (f,b,c)))),c)*t1.c | 17-(e))/abs(t1.f)) | 17*17*a in (select e from t1 union select f from t1)) then 13 when t1.a not between (b) and t1.c then (abs(17)/abs(17)) else t1.d end*f end FROM t1 WHERE NOT (t1.a>t1.c-19)"
    end, {
        -- <randexpr-2.863>
        600
        -- </randexpr-2.863>
    })

test:do_test(
    "randexpr-2.864",
    function()
        return test:execsql "SELECT case 17 when (select ~count(distinct t1.d) from t1) then e else case when not not exists(select 1 from t1 where (abs(~coalesce((select (coalesce((select max(13) from t1 where e>a),19)) from t1 where (not exists(select 1 from t1 where t1.c in (f,b,c)))),c)*t1.c & 17-(e))/abs(t1.f)) & 17*17*a in (select e from t1 union select f from t1)) then 13 when t1.a not between (b) and t1.c then (abs(17)/abs(17)) else t1.d end*f end FROM t1 WHERE NOT (t1.a>t1.c-19)"
    end, {
        -- <randexpr-2.864>
        600
        -- </randexpr-2.864>
    })

test:do_test(
    "randexpr-2.865",
    function()
        return test:execsql "SELECT case when f>=t1.c then t1.d when coalesce((select max(+11-b) from t1 where a-t1.d in (select +case when f in (13,b | 11,t1.b) then  -t1.d when f in (select ~count(distinct 17) from t1 union select count(distinct t1.a) from t1) then 19 else c end-d+b from t1 union select a from t1) and (17) in (t1.f,11,t1.c)),f)< -a then d else t1.c end-11 FROM t1 WHERE a<(select count(distinct +11*coalesce((select max(coalesce((select max(t1.d) from t1 where t1.e>t1.b),b)*t1.f) from t1 where case 11 when t1.a then  -t1.e else a end<=17),e)-11+c-19) | count(distinct 19)*count(*)* -(count(distinct t1.f))+cast(avg(17) AS integer)-(~~(count(*)))-cast(avg(11) AS integer) | cast(avg((19)) AS integer) from t1)-t1.c"
    end, {
        -- <randexpr-2.865>
        
        -- </randexpr-2.865>
    })

test:do_test(
    "randexpr-2.866",
    function()
        return test:execsql "SELECT case when f>=t1.c then t1.d when coalesce((select max(+11-b) from t1 where a-t1.d in (select +case when f in (13,b | 11,t1.b) then  -t1.d when f in (select ~count(distinct 17) from t1 union select count(distinct t1.a) from t1) then 19 else c end-d+b from t1 union select a from t1) and (17) in (t1.f,11,t1.c)),f)< -a then d else t1.c end-11 FROM t1 WHERE NOT (a<(select count(distinct +11*coalesce((select max(coalesce((select max(t1.d) from t1 where t1.e>t1.b),b)*t1.f) from t1 where case 11 when t1.a then  -t1.e else a end<=17),e)-11+c-19) | count(distinct 19)*count(*)* -(count(distinct t1.f))+cast(avg(17) AS integer)-(~~(count(*)))-cast(avg(11) AS integer) | cast(avg((19)) AS integer) from t1)-t1.c)"
    end, {
        -- <randexpr-2.866>
        389
        -- </randexpr-2.866>
    })

test:do_test(
    "randexpr-2.867",
    function()
        return test:execsql "SELECT case when f>=t1.c then t1.d when coalesce((select max(+11-b) from t1 where a-t1.d in (select +case when f in (13,b & 11,t1.b) then  -t1.d when f in (select ~count(distinct 17) from t1 union select count(distinct t1.a) from t1) then 19 else c end-d+b from t1 union select a from t1) and (17) in (t1.f,11,t1.c)),f)< -a then d else t1.c end-11 FROM t1 WHERE NOT (a<(select count(distinct +11*coalesce((select max(coalesce((select max(t1.d) from t1 where t1.e>t1.b),b)*t1.f) from t1 where case 11 when t1.a then  -t1.e else a end<=17),e)-11+c-19) | count(distinct 19)*count(*)* -(count(distinct t1.f))+cast(avg(17) AS integer)-(~~(count(*)))-cast(avg(11) AS integer) | cast(avg((19)) AS integer) from t1)-t1.c)"
    end, {
        -- <randexpr-2.867>
        389
        -- </randexpr-2.867>
    })

test:do_test(
    "randexpr-2.868",
    function()
        return test:execsql "SELECT coalesce((select max(17) from t1 where  -coalesce((select t1.b+coalesce((select case when case t1.f when c then (e) else a end+t1.c+(f)>17 and e>=f and (13>t1.f) then (select ~(cast(avg(t1.e) AS integer)) | min(t1.a) from t1) when  -c>c then 19 else t1.f end from t1 where (17<t1.f)),t1.f) from t1 where not exists(select 1 from t1 where 13 not between t1.a and c)),d)*17< -t1.c),b) FROM t1 WHERE not exists(select 1 from t1 where not exists(select 1 from t1 where  -11=17*t1.d*f))"
    end, {
        -- <randexpr-2.868>
        
        -- </randexpr-2.868>
    })

test:do_test(
    "randexpr-2.869",
    function()
        return test:execsql "SELECT coalesce((select max(17) from t1 where  -coalesce((select t1.b+coalesce((select case when case t1.f when c then (e) else a end+t1.c+(f)>17 and e>=f and (13>t1.f) then (select ~(cast(avg(t1.e) AS integer)) | min(t1.a) from t1) when  -c>c then 19 else t1.f end from t1 where (17<t1.f)),t1.f) from t1 where not exists(select 1 from t1 where 13 not between t1.a and c)),d)*17< -t1.c),b) FROM t1 WHERE NOT (not exists(select 1 from t1 where not exists(select 1 from t1 where  -11=17*t1.d*f)))"
    end, {
        -- <randexpr-2.869>
        17
        -- </randexpr-2.869>
    })

test:do_test(
    "randexpr-2.870",
    function()
        return test:execsql "SELECT coalesce((select max(17) from t1 where  -coalesce((select t1.b+coalesce((select case when case t1.f when c then (e) else a end+t1.c+(f)>17 and e>=f and (13>t1.f) then (select ~(cast(avg(t1.e) AS integer)) & min(t1.a) from t1) when  -c>c then 19 else t1.f end from t1 where (17<t1.f)),t1.f) from t1 where not exists(select 1 from t1 where 13 not between t1.a and c)),d)*17< -t1.c),b) FROM t1 WHERE NOT (not exists(select 1 from t1 where not exists(select 1 from t1 where  -11=17*t1.d*f)))"
    end, {
        -- <randexpr-2.870>
        17
        -- </randexpr-2.870>
    })

test:do_test(
    "randexpr-2.871",
    function()
        return test:execsql "SELECT case when a*t1.a*a in (select case (e- -11+case when ~c>=a then 13 when ((case when t1.d<t1.d then f when t1.c not between a and t1.e then  -f else t1.f end>=a)) then 19 else t1.b end-t1.f) when 19 then  - -13 else 17 end from t1 union select  -17 from t1) and 19 in (select d from t1 union select e from t1) then (select abs(min(t1.f)) from t1) else c end FROM t1 WHERE case coalesce((select 19 from t1 where 13<coalesce((select 19 | case when t1.e>=e then d when (case when not exists(select 1 from t1 where (a>d and d not between e and ((19)) and c in (e,t1.b,(b)) and e not in (t1.f,t1.a,t1.b))) then t1.b when f not between 11 and d then t1.d else d end<=11) then (abs(13)/abs(11)) else  -11 end from t1 where (t1.b)<d),b)),11) | d when c then 17 else (e) end not in (t1.e,t1.c,a)"
    end, {
        -- <randexpr-2.871>
        
        -- </randexpr-2.871>
    })

test:do_test(
    "randexpr-2.872",
    function()
        return test:execsql "SELECT case when a*t1.a*a in (select case (e- -11+case when ~c>=a then 13 when ((case when t1.d<t1.d then f when t1.c not between a and t1.e then  -f else t1.f end>=a)) then 19 else t1.b end-t1.f) when 19 then  - -13 else 17 end from t1 union select  -17 from t1) and 19 in (select d from t1 union select e from t1) then (select abs(min(t1.f)) from t1) else c end FROM t1 WHERE NOT (case coalesce((select 19 from t1 where 13<coalesce((select 19 | case when t1.e>=e then d when (case when not exists(select 1 from t1 where (a>d and d not between e and ((19)) and c in (e,t1.b,(b)) and e not in (t1.f,t1.a,t1.b))) then t1.b when f not between 11 and d then t1.d else d end<=11) then (abs(13)/abs(11)) else  -11 end from t1 where (t1.b)<d),b)),11) | d when c then 17 else (e) end not in (t1.e,t1.c,a))"
    end, {
        -- <randexpr-2.872>
        300
        -- </randexpr-2.872>
    })

test:do_test(
    "randexpr-2.873",
    function()
        return test:execsql "SELECT case when t1.e not between (select +max(17) from t1)*t1.f and d then t1.c+case when e+f<=coalesce((select max((19)) from t1 where t1.e not in ((abs( -17-17)/abs(t1.e)),(c),(t1.b))),d) and 13 in (select d from t1 union select c from t1) then 19 else c end-19 when exists(select 1 from t1 where t1.a in (select t1.a from t1 union select 13 from t1)) and not exists(select 1 from t1 where a<19) then b else t1.b end FROM t1 WHERE not t1.d=b"
    end, {
        -- <randexpr-2.873>
        581
        -- </randexpr-2.873>
    })

test:do_test(
    "randexpr-2.874",
    function()
        return test:execsql "SELECT case when t1.e not between (select +max(17) from t1)*t1.f and d then t1.c+case when e+f<=coalesce((select max((19)) from t1 where t1.e not in ((abs( -17-17)/abs(t1.e)),(c),(t1.b))),d) and 13 in (select d from t1 union select c from t1) then 19 else c end-19 when exists(select 1 from t1 where t1.a in (select t1.a from t1 union select 13 from t1)) and not exists(select 1 from t1 where a<19) then b else t1.b end FROM t1 WHERE NOT (not t1.d=b)"
    end, {
        -- <randexpr-2.874>
        
        -- </randexpr-2.874>
    })

test:do_test(
    "randexpr-2.875",
    function()
        return test:execsql "SELECT +17+(11)-coalesce((select max(case (11) when f then +e+case when +11< -13-f or b between (b) and t1.b and e<>t1.c and e not between 13 and t1.d and t1.e in (t1.d,17,t1.c) then c+t1.e*t1.d when t1.f>=t1.d then t1.a else t1.c end else t1.e end-e) from t1 where t1.b not in (t1.b,t1.d,d)), -c)*13 FROM t1 WHERE (abs(e+17)/abs((select count(distinct 11-t1.b)*cast(avg(case c when coalesce((select max(19-coalesce((select max(f) from t1 where 19 in (17,t1.f,11)),t1.d)) from t1 where c in (t1.a,11,13) and t1.a<=t1.c),t1.c) then t1.c else e end) AS integer) | max(e) | (+~case case cast(avg(t1.d) AS integer) when  -min(13) then count(*) else count(*) end when max(t1.c) then count(distinct f) else count(*) end-count(distinct 19)) from t1)))>=t1.e | f"
    end, {
        -- <randexpr-2.875>
        
        -- </randexpr-2.875>
    })

test:do_test(
    "randexpr-2.876",
    function()
        return test:execsql "SELECT +17+(11)-coalesce((select max(case (11) when f then +e+case when +11< -13-f or b between (b) and t1.b and e<>t1.c and e not between 13 and t1.d and t1.e in (t1.d,17,t1.c) then c+t1.e*t1.d when t1.f>=t1.d then t1.a else t1.c end else t1.e end-e) from t1 where t1.b not in (t1.b,t1.d,d)), -c)*13 FROM t1 WHERE NOT ((abs(e+17)/abs((select count(distinct 11-t1.b)*cast(avg(case c when coalesce((select max(19-coalesce((select max(f) from t1 where 19 in (17,t1.f,11)),t1.d)) from t1 where c in (t1.a,11,13) and t1.a<=t1.c),t1.c) then t1.c else e end) AS integer) | max(e) | (+~case case cast(avg(t1.d) AS integer) when  -min(13) then count(*) else count(*) end when max(t1.c) then count(distinct f) else count(*) end-count(distinct 19)) from t1)))>=t1.e | f)"
    end, {
        -- <randexpr-2.876>
        3928
        -- </randexpr-2.876>
    })

test:do_test(
    "randexpr-2.877",
    function()
        return test:execsql "SELECT case when case when d*c not in (13,a,d) then (t1.b-f)+coalesce((select max((select count(distinct 13)-case max(11) when count(*) then count(*) else min(t1.b) end*min(17)+(min(t1.c)) from t1)) from t1 where not exists(select 1 from t1 where t1.c between 17-d | d and t1.e)),b) else t1.e end<=d then e when f in (a,13,d) or t1.b between f and  -b then c else t1.a end FROM t1 WHERE t1.d<>t1.a"
    end, {
        -- <randexpr-2.877>
        500
        -- </randexpr-2.877>
    })

test:do_test(
    "randexpr-2.878",
    function()
        return test:execsql "SELECT case when case when d*c not in (13,a,d) then (t1.b-f)+coalesce((select max((select count(distinct 13)-case max(11) when count(*) then count(*) else min(t1.b) end*min(17)+(min(t1.c)) from t1)) from t1 where not exists(select 1 from t1 where t1.c between 17-d | d and t1.e)),b) else t1.e end<=d then e when f in (a,13,d) or t1.b between f and  -b then c else t1.a end FROM t1 WHERE NOT (t1.d<>t1.a)"
    end, {
        -- <randexpr-2.878>
        
        -- </randexpr-2.878>
    })

test:do_test(
    "randexpr-2.879",
    function()
        return test:execsql "SELECT case when case when d*c not in (13,a,d) then (t1.b-f)+coalesce((select max((select count(distinct 13)-case max(11) when count(*) then count(*) else min(t1.b) end*min(17)+(min(t1.c)) from t1)) from t1 where not exists(select 1 from t1 where t1.c between 17-d & d and t1.e)),b) else t1.e end<=d then e when f in (a,13,d) or t1.b between f and  -b then c else t1.a end FROM t1 WHERE t1.d<>t1.a"
    end, {
        -- <randexpr-2.879>
        500
        -- </randexpr-2.879>
    })

test:do_test(
    "randexpr-2.880",
    function()
        return test:execsql "SELECT case case c when  -b then (abs(b)/abs(c)) else (select count(distinct f) | (~abs(min(c-+case 11 when case when t1.a between b and t1.e-case when (13<=b) then (select  -count(*) from t1) else a end then t1.e when e>=11 then (19) else b end then d else 17 end | e))) from t1) end when  -13 then t1.f else +17 end FROM t1 WHERE 17 in (select +(count(*) | case abs( -abs(abs( -min(d)))) | max(+11) when  -+~count(distinct  -(abs(coalesce((select max(f) from t1 where t1.e in (select e from t1 union select t1.a from t1)),f) | t1.c-t1.b)/abs(13))) | +abs(case max(b) when count(*) then  -min(t1.e) else (cast(avg(t1.f) AS integer)) end)- -count(*) then  -count(*) else max(19) end* -cast(avg(t1.b) AS integer))+(max(t1.f)) from t1 union select count(distinct b) from t1)"
    end, {
        -- <randexpr-2.880>
        
        -- </randexpr-2.880>
    })

test:do_test(
    "randexpr-2.881",
    function()
        return test:execsql "SELECT case case c when  -b then (abs(b)/abs(c)) else (select count(distinct f) | (~abs(min(c-+case 11 when case when t1.a between b and t1.e-case when (13<=b) then (select  -count(*) from t1) else a end then t1.e when e>=11 then (19) else b end then d else 17 end | e))) from t1) end when  -13 then t1.f else +17 end FROM t1 WHERE NOT (17 in (select +(count(*) | case abs( -abs(abs( -min(d)))) | max(+11) when  -+~count(distinct  -(abs(coalesce((select max(f) from t1 where t1.e in (select e from t1 union select t1.a from t1)),f) | t1.c-t1.b)/abs(13))) | +abs(case max(b) when count(*) then  -min(t1.e) else (cast(avg(t1.f) AS integer)) end)- -count(*) then  -count(*) else max(19) end* -cast(avg(t1.b) AS integer))+(max(t1.f)) from t1 union select count(distinct b) from t1))"
    end, {
        -- <randexpr-2.881>
        17
        -- </randexpr-2.881>
    })

test:do_test(
    "randexpr-2.882",
    function()
        return test:execsql "SELECT case case c when  -b then (abs(b)/abs(c)) else (select count(distinct f) & (~abs(min(c-+case 11 when case when t1.a between b and t1.e-case when (13<=b) then (select  -count(*) from t1) else a end then t1.e when e>=11 then (19) else b end then d else 17 end & e))) from t1) end when  -13 then t1.f else +17 end FROM t1 WHERE NOT (17 in (select +(count(*) | case abs( -abs(abs( -min(d)))) | max(+11) when  -+~count(distinct  -(abs(coalesce((select max(f) from t1 where t1.e in (select e from t1 union select t1.a from t1)),f) | t1.c-t1.b)/abs(13))) | +abs(case max(b) when count(*) then  -min(t1.e) else (cast(avg(t1.f) AS integer)) end)- -count(*) then  -count(*) else max(19) end* -cast(avg(t1.b) AS integer))+(max(t1.f)) from t1 union select count(distinct b) from t1))"
    end, {
        -- <randexpr-2.882>
        17
        -- </randexpr-2.882>
    })

test:do_test(
    "randexpr-2.883",
    function()
        return test:execsql "SELECT case 11 when (case when t1.e in (select +cast(avg(coalesce((select max(13) from t1 where case when exists(select 1 from t1 where t1.b in ((a),d,(t1.e))) then case when 19 in (select  -max(17) from t1 union select min(t1.f) from t1) then t1.b else 17 end when a not in ((t1.f),11,t1.e) then 17 else t1.c end<t1.b),11)*a) AS integer) from t1 union select max(b) | case (+min(t1.f)) when cast(avg(a) AS integer) then count(distinct 13) else max(t1.c) end from t1) then t1.e when c<=t1.d then t1.b else t1.f end-17) then b else t1.e end FROM t1 WHERE e-case when a*b between t1.d-(abs(11)/abs(coalesce((select t1.b from t1 where not exists(select 1 from t1 where c=17) or a not between (coalesce((select t1.c from t1 where 19>(19)),c)) and c and (11 in (select t1.b from t1 union select 13 from t1) and ( -t1.d)=d)),e | 19*t1.a))) and t1.a then t1.a when 19>=t1.a then e else c end> -e"
    end, {
        -- <randexpr-2.883>
        500
        -- </randexpr-2.883>
    })

test:do_test(
    "randexpr-2.884",
    function()
        return test:execsql "SELECT case 11 when (case when t1.e in (select +cast(avg(coalesce((select max(13) from t1 where case when exists(select 1 from t1 where t1.b in ((a),d,(t1.e))) then case when 19 in (select  -max(17) from t1 union select min(t1.f) from t1) then t1.b else 17 end when a not in ((t1.f),11,t1.e) then 17 else t1.c end<t1.b),11)*a) AS integer) from t1 union select max(b) | case (+min(t1.f)) when cast(avg(a) AS integer) then count(distinct 13) else max(t1.c) end from t1) then t1.e when c<=t1.d then t1.b else t1.f end-17) then b else t1.e end FROM t1 WHERE NOT (e-case when a*b between t1.d-(abs(11)/abs(coalesce((select t1.b from t1 where not exists(select 1 from t1 where c=17) or a not between (coalesce((select t1.c from t1 where 19>(19)),c)) and c and (11 in (select t1.b from t1 union select 13 from t1) and ( -t1.d)=d)),e | 19*t1.a))) and t1.a then t1.a when 19>=t1.a then e else c end> -e)"
    end, {
        -- <randexpr-2.884>
        
        -- </randexpr-2.884>
    })

test:do_test(
    "randexpr-2.885",
    function()
        return test:execsql "SELECT case 11 when (case when t1.e in (select +cast(avg(coalesce((select max(13) from t1 where case when exists(select 1 from t1 where t1.b in ((a),d,(t1.e))) then case when 19 in (select  -max(17) from t1 union select min(t1.f) from t1) then t1.b else 17 end when a not in ((t1.f),11,t1.e) then 17 else t1.c end<t1.b),11)*a) AS integer) from t1 union select max(b) & case (+min(t1.f)) when cast(avg(a) AS integer) then count(distinct 13) else max(t1.c) end from t1) then t1.e when c<=t1.d then t1.b else t1.f end-17) then b else t1.e end FROM t1 WHERE e-case when a*b between t1.d-(abs(11)/abs(coalesce((select t1.b from t1 where not exists(select 1 from t1 where c=17) or a not between (coalesce((select t1.c from t1 where 19>(19)),c)) and c and (11 in (select t1.b from t1 union select 13 from t1) and ( -t1.d)=d)),e | 19*t1.a))) and t1.a then t1.a when 19>=t1.a then e else c end> -e"
    end, {
        -- <randexpr-2.885>
        500
        -- </randexpr-2.885>
    })

test:do_test(
    "randexpr-2.886",
    function()
        return test:execsql "SELECT case a*t1.a when ~++a*(abs(e)/abs(19)) | t1.d+(select count(*) from t1) then b else t1.a end*coalesce((select max(f) from t1 where f<>t1.d),b) FROM t1 WHERE (abs(c-~t1.b)/abs(d))-((+coalesce((select max(c) from t1 where  -+(select ~ -(cast(avg((13+case 11*t1.c when t1.b then f else ~e-coalesce((select max((f)) from t1 where t1.f<a), -t1.c-(t1.c)) end)) AS integer)) from t1)=d*a),t1.d)+a))* -t1.e=t1.f"
    end, {
        -- <randexpr-2.886>
        
        -- </randexpr-2.886>
    })

test:do_test(
    "randexpr-2.887",
    function()
        return test:execsql "SELECT case a*t1.a when ~++a*(abs(e)/abs(19)) | t1.d+(select count(*) from t1) then b else t1.a end*coalesce((select max(f) from t1 where f<>t1.d),b) FROM t1 WHERE NOT ((abs(c-~t1.b)/abs(d))-((+coalesce((select max(c) from t1 where  -+(select ~ -(cast(avg((13+case 11*t1.c when t1.b then f else ~e-coalesce((select max((f)) from t1 where t1.f<a), -t1.c-(t1.c)) end)) AS integer)) from t1)=d*a),t1.d)+a))* -t1.e=t1.f)"
    end, {
        -- <randexpr-2.887>
        60000
        -- </randexpr-2.887>
    })

test:do_test(
    "randexpr-2.888",
    function()
        return test:execsql "SELECT case a*t1.a when ~++a*(abs(e)/abs(19)) & t1.d+(select count(*) from t1) then b else t1.a end*coalesce((select max(f) from t1 where f<>t1.d),b) FROM t1 WHERE NOT ((abs(c-~t1.b)/abs(d))-((+coalesce((select max(c) from t1 where  -+(select ~ -(cast(avg((13+case 11*t1.c when t1.b then f else ~e-coalesce((select max((f)) from t1 where t1.f<a), -t1.c-(t1.c)) end)) AS integer)) from t1)=d*a),t1.d)+a))* -t1.e=t1.f)"
    end, {
        -- <randexpr-2.888>
        60000
        -- </randexpr-2.888>
    })

test:do_test(
    "randexpr-2.889",
    function()
        return test:execsql "SELECT t1.c-t1.f-coalesce((select max(a) from t1 where e in ((abs(a)/abs(t1.d))*coalesce((select max((abs(case when e>=+t1.b then f when t1.c+f<a or e<>13 then t1.d else t1.a end)/abs(t1.d))) from t1 where t1.c not between t1.c and 11 and e>d),f)*t1.e+d,a,13)),e) | t1.b FROM t1 WHERE (abs(+(+t1.a)+case a-case when c>=d then 13 when t1.c not in (17,17,e) then a else t1.d end when c then  -f else b end*d)/abs(17))<=11 and 11 in (select cast(avg(17) AS integer) from t1 union select min( -19)+(case max(a) when abs(count(*)) then  -abs(count(*)*min(t1.e)+max(11)) else min(c) end) from t1)"
    end, {
        -- <randexpr-2.889>
        
        -- </randexpr-2.889>
    })

test:do_test(
    "randexpr-2.890",
    function()
        return test:execsql "SELECT t1.c-t1.f-coalesce((select max(a) from t1 where e in ((abs(a)/abs(t1.d))*coalesce((select max((abs(case when e>=+t1.b then f when t1.c+f<a or e<>13 then t1.d else t1.a end)/abs(t1.d))) from t1 where t1.c not between t1.c and 11 and e>d),f)*t1.e+d,a,13)),e) | t1.b FROM t1 WHERE NOT ((abs(+(+t1.a)+case a-case when c>=d then 13 when t1.c not in (17,17,e) then a else t1.d end when c then  -f else b end*d)/abs(17))<=11 and 11 in (select cast(avg(17) AS integer) from t1 union select min( -19)+(case max(a) when abs(count(*)) then  -abs(count(*)*min(t1.e)+max(11)) else min(c) end) from t1))"
    end, {
        -- <randexpr-2.890>
        -792
        -- </randexpr-2.890>
    })

test:do_test(
    "randexpr-2.891",
    function()
        return test:execsql "SELECT t1.c-t1.f-coalesce((select max(a) from t1 where e in ((abs(a)/abs(t1.d))*coalesce((select max((abs(case when e>=+t1.b then f when t1.c+f<a or e<>13 then t1.d else t1.a end)/abs(t1.d))) from t1 where t1.c not between t1.c and 11 and e>d),f)*t1.e+d,a,13)),e) & t1.b FROM t1 WHERE NOT ((abs(+(+t1.a)+case a-case when c>=d then 13 when t1.c not in (17,17,e) then a else t1.d end when c then  -f else b end*d)/abs(17))<=11 and 11 in (select cast(avg(17) AS integer) from t1 union select min( -19)+(case max(a) when abs(count(*)) then  -abs(count(*)*min(t1.e)+max(11)) else min(c) end) from t1))"
    end, {
        -- <randexpr-2.891>
        192
        -- </randexpr-2.891>
    })

test:do_test(
    "randexpr-2.892",
    function()
        return test:execsql "SELECT coalesce((select (select count(*) from t1)*a*b from t1 where ((~b*a-t1.d+11*e-(select  -count(*) | count(*) | count(*) from t1)*(select min((abs(coalesce((select max(t1.c) from t1 where not exists(select 1 from t1 where  -17 in (t1.b,t1.f,t1.d))),11))/abs(t1.d))) from t1)-17+(abs(11)/abs(11)) | b+d | 11 in (select t1.a from t1 union select 13 from t1)))),t1.a) FROM t1 WHERE f>case when f-case when not exists(select 1 from t1 where case when b in (select abs(max(coalesce((select max(~t1.c) from t1 where t1.f<=13),17))) from t1 union select cast(avg(t1.c) AS integer) from t1) then t1.e else (13) end> -t1.e) or d<>19 then coalesce((select max((select abs(max(d)+cast(avg(d) AS integer)) from t1)) from t1 where t1.e<t1.c),19) when  -t1.c in (t1.e,t1.f,e) then 11 else t1.a end<>19 then b when t1.a<=11 then 11 else t1.d end"
    end, {
        -- <randexpr-2.892>
        100
        -- </randexpr-2.892>
    })

test:do_test(
    "randexpr-2.893",
    function()
        return test:execsql "SELECT coalesce((select (select count(*) from t1)*a*b from t1 where ((~b*a-t1.d+11*e-(select  -count(*) | count(*) | count(*) from t1)*(select min((abs(coalesce((select max(t1.c) from t1 where not exists(select 1 from t1 where  -17 in (t1.b,t1.f,t1.d))),11))/abs(t1.d))) from t1)-17+(abs(11)/abs(11)) | b+d | 11 in (select t1.a from t1 union select 13 from t1)))),t1.a) FROM t1 WHERE NOT (f>case when f-case when not exists(select 1 from t1 where case when b in (select abs(max(coalesce((select max(~t1.c) from t1 where t1.f<=13),17))) from t1 union select cast(avg(t1.c) AS integer) from t1) then t1.e else (13) end> -t1.e) or d<>19 then coalesce((select max((select abs(max(d)+cast(avg(d) AS integer)) from t1)) from t1 where t1.e<t1.c),19) when  -t1.c in (t1.e,t1.f,e) then 11 else t1.a end<>19 then b when t1.a<=11 then 11 else t1.d end)"
    end, {
        -- <randexpr-2.893>
        
        -- </randexpr-2.893>
    })

test:do_test(
    "randexpr-2.894",
    function()
        return test:execsql "SELECT coalesce((select (select count(*) from t1)*a*b from t1 where ((~b*a-t1.d+11*e-(select  -count(*) & count(*) & count(*) from t1)*(select min((abs(coalesce((select max(t1.c) from t1 where not exists(select 1 from t1 where  -17 in (t1.b,t1.f,t1.d))),11))/abs(t1.d))) from t1)-17+(abs(11)/abs(11)) & b+d & 11 in (select t1.a from t1 union select 13 from t1)))),t1.a) FROM t1 WHERE f>case when f-case when not exists(select 1 from t1 where case when b in (select abs(max(coalesce((select max(~t1.c) from t1 where t1.f<=13),17))) from t1 union select cast(avg(t1.c) AS integer) from t1) then t1.e else (13) end> -t1.e) or d<>19 then coalesce((select max((select abs(max(d)+cast(avg(d) AS integer)) from t1)) from t1 where t1.e<t1.c),19) when  -t1.c in (t1.e,t1.f,e) then 11 else t1.a end<>19 then b when t1.a<=11 then 11 else t1.d end"
    end, {
        -- <randexpr-2.894>
        100
        -- </randexpr-2.894>
    })

test:do_test(
    "randexpr-2.895",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where ((abs((select case (~max(f) | ~max(19-t1.d) | cast(avg(11) AS integer)) when min(+t1.d*c) then max(case when 19+13 not between 13 and t1.c or t1.c not in ((b),11,(e)) then d else t1.d end+ -t1.d) else min(a) end from t1))/abs(11)))<17),t1.b)+17 FROM t1 WHERE (13 in (a,t1.a,~+(e)+t1.c*t1.c | t1.c- -t1.b-t1.b+e*b | t1.e-t1.e-e*coalesce((select max(t1.b) from t1 where t1.a*d<>coalesce((select max(t1.e-t1.b) from t1 where exists(select 1 from t1 where coalesce((select e from t1 where (17 not between 13 and t1.c)),t1.c)>=t1.c)),b)),t1.f)+17))"
    end, {
        -- <randexpr-2.895>
        
        -- </randexpr-2.895>
    })

test:do_test(
    "randexpr-2.896",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where ((abs((select case (~max(f) | ~max(19-t1.d) | cast(avg(11) AS integer)) when min(+t1.d*c) then max(case when 19+13 not between 13 and t1.c or t1.c not in ((b),11,(e)) then d else t1.d end+ -t1.d) else min(a) end from t1))/abs(11)))<17),t1.b)+17 FROM t1 WHERE NOT ((13 in (a,t1.a,~+(e)+t1.c*t1.c | t1.c- -t1.b-t1.b+e*b | t1.e-t1.e-e*coalesce((select max(t1.b) from t1 where t1.a*d<>coalesce((select max(t1.e-t1.b) from t1 where exists(select 1 from t1 where coalesce((select e from t1 where (17 not between 13 and t1.c)),t1.c)>=t1.c)),b)),t1.f)+17)))"
    end, {
        -- <randexpr-2.896>
        517
        -- </randexpr-2.896>
    })

test:do_test(
    "randexpr-2.897",
    function()
        return test:execsql "SELECT coalesce((select e from t1 where ((abs((select case (~max(f) & ~max(19-t1.d) & cast(avg(11) AS integer)) when min(+t1.d*c) then max(case when 19+13 not between 13 and t1.c or t1.c not in ((b),11,(e)) then d else t1.d end+ -t1.d) else min(a) end from t1))/abs(11)))<17),t1.b)+17 FROM t1 WHERE NOT ((13 in (a,t1.a,~+(e)+t1.c*t1.c | t1.c- -t1.b-t1.b+e*b | t1.e-t1.e-e*coalesce((select max(t1.b) from t1 where t1.a*d<>coalesce((select max(t1.e-t1.b) from t1 where exists(select 1 from t1 where coalesce((select e from t1 where (17 not between 13 and t1.c)),t1.c)>=t1.c)),b)),t1.f)+17)))"
    end, {
        -- <randexpr-2.897>
        517
        -- </randexpr-2.897>
    })

test:do_test(
    "randexpr-2.898",
    function()
        return test:execsql "SELECT c | coalesce((select max(~b*case +coalesce((select max( -(abs(c)/abs(11))+case when t1.c*17 not in (a,a,c) then t1.e when t1.b in (select 13 from t1 union select (c) from t1) then  -(t1.c) else d end* -t1.c+a) from t1 where t1.f>=11),17) | t1.b when t1.b then c else t1.a end) from t1 where t1.f>t1.a),t1.c)+13*17 FROM t1 WHERE t1.e<t1.c*(select min((select count(*) from t1)) from t1)*f"
    end, {
        -- <randexpr-2.898>
        -19587
        -- </randexpr-2.898>
    })

test:do_test(
    "randexpr-2.899",
    function()
        return test:execsql "SELECT c | coalesce((select max(~b*case +coalesce((select max( -(abs(c)/abs(11))+case when t1.c*17 not in (a,a,c) then t1.e when t1.b in (select 13 from t1 union select (c) from t1) then  -(t1.c) else d end* -t1.c+a) from t1 where t1.f>=11),17) | t1.b when t1.b then c else t1.a end) from t1 where t1.f>t1.a),t1.c)+13*17 FROM t1 WHERE NOT (t1.e<t1.c*(select min((select count(*) from t1)) from t1)*f)"
    end, {
        -- <randexpr-2.899>
        
        -- </randexpr-2.899>
    })

test:do_test(
    "randexpr-2.900",
    function()
        return test:execsql "SELECT c & coalesce((select max(~b*case +coalesce((select max( -(abs(c)/abs(11))+case when t1.c*17 not in (a,a,c) then t1.e when t1.b in (select 13 from t1 union select (c) from t1) then  -(t1.c) else d end* -t1.c+a) from t1 where t1.f>=11),17) & t1.b when t1.b then c else t1.a end) from t1 where t1.f>t1.a),t1.c)+13*17 FROM t1 WHERE t1.e<t1.c*(select min((select count(*) from t1)) from t1)*f"
    end, {
        -- <randexpr-2.900>
        8
        -- </randexpr-2.900>
    })

test:do_test(
    "randexpr-2.901",
    function()
        return test:execsql "SELECT coalesce((select max(a) from t1 where t1.b<t1.b),13 |  -(coalesce((select max((abs(~t1.a | (abs(11)/abs((abs(t1.e)/abs(coalesce((select max(t1.e) from t1 where not exists(select 1 from t1 where exists(select 1 from t1 where (t1.d)<>e) and not exists(select 1 from t1 where (19)=t1.e))),19*t1.e)-t1.c)) | 17))*t1.b)/abs(17))) from t1 where (t1.b) between d and t1.b),t1.c)) | t1.f-c-d) FROM t1 WHERE 13 not in (f,t1.c+11*c,coalesce((select e from t1 where case t1.b when c- -case (select cast(avg(+t1.c*t1.f) AS integer) from t1) when 13*case when not case when  -17 in (select (t1.c) from t1 union select t1.c from t1) or t1.f in (t1.b,t1.d,t1.b) then t1.a when 11<>t1.c then e else a end>=(11) and a=d or  -t1.f between c and b then e else t1.f end then 19 else t1.d end then t1.c else t1.b end<>13),d))"
    end, {
        -- <randexpr-2.901>
        -35
        -- </randexpr-2.901>
    })

test:do_test(
    "randexpr-2.902",
    function()
        return test:execsql "SELECT coalesce((select max(a) from t1 where t1.b<t1.b),13 |  -(coalesce((select max((abs(~t1.a | (abs(11)/abs((abs(t1.e)/abs(coalesce((select max(t1.e) from t1 where not exists(select 1 from t1 where exists(select 1 from t1 where (t1.d)<>e) and not exists(select 1 from t1 where (19)=t1.e))),19*t1.e)-t1.c)) | 17))*t1.b)/abs(17))) from t1 where (t1.b) between d and t1.b),t1.c)) | t1.f-c-d) FROM t1 WHERE NOT (13 not in (f,t1.c+11*c,coalesce((select e from t1 where case t1.b when c- -case (select cast(avg(+t1.c*t1.f) AS integer) from t1) when 13*case when not case when  -17 in (select (t1.c) from t1 union select t1.c from t1) or t1.f in (t1.b,t1.d,t1.b) then t1.a when 11<>t1.c then e else a end>=(11) and a=d or  -t1.f between c and b then e else t1.f end then 19 else t1.d end then t1.c else t1.b end<>13),d)))"
    end, {
        -- <randexpr-2.902>
        
        -- </randexpr-2.902>
    })

test:do_test(
    "randexpr-2.903",
    function()
        return test:execsql "SELECT f+b+(t1.a+c)+(case when (select (cast(avg(coalesce((select max(t1.b) from t1 where case  -(select +cast(avg(b-t1.e) AS integer)-abs(cast(avg(~(abs(f)/abs(f))) AS integer)) from t1)+d when 11 then d else 13 end+t1.e<>t1.e),(t1.e))-13+13) AS integer)) from t1)-t1.b<>a then t1.e else e end) FROM t1 WHERE c in (select abs((max(t1.d))) from t1 union select count(*) from t1) and (coalesce((select max(+ -(t1.f-d)* -b) from t1 where not exists(select 1 from t1 where (b not in (coalesce((select t1.e-a from t1 where not t1.a between 13 and f or t1.b in (t1.e,e,17)),11),17,t1.a) and (b<>d)))),b) in (select  -min(17) from t1 union select abs(max(e)) from t1))"
    end, {
        -- <randexpr-2.903>
        
        -- </randexpr-2.903>
    })

test:do_test(
    "randexpr-2.904",
    function()
        return test:execsql "SELECT f+b+(t1.a+c)+(case when (select (cast(avg(coalesce((select max(t1.b) from t1 where case  -(select +cast(avg(b-t1.e) AS integer)-abs(cast(avg(~(abs(f)/abs(f))) AS integer)) from t1)+d when 11 then d else 13 end+t1.e<>t1.e),(t1.e))-13+13) AS integer)) from t1)-t1.b<>a then t1.e else e end) FROM t1 WHERE NOT (c in (select abs((max(t1.d))) from t1 union select count(*) from t1) and (coalesce((select max(+ -(t1.f-d)* -b) from t1 where not exists(select 1 from t1 where (b not in (coalesce((select t1.e-a from t1 where not t1.a between 13 and f or t1.b in (t1.e,e,17)),11),17,t1.a) and (b<>d)))),b) in (select  -min(17) from t1 union select abs(max(e)) from t1)))"
    end, {
        -- <randexpr-2.904>
        1700
        -- </randexpr-2.904>
    })

test:do_test(
    "randexpr-2.905",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (case when (select  -min(t1.e) from t1) in (select f from t1 union select d from t1) then +e else d end | t1.e not between t1.a and t1.b))) and not exists(select 1 from t1 where a>=t1.e) and b=e then 13 else coalesce((select 19 from t1 where t1.d>=t1.e),13) end<11*t1.b then 17 when 17 in (19,t1.e, -t1.c) or 17<f then t1.d else t1.b end FROM t1 WHERE exists(select 1 from t1 where f<=19)"
    end, {
        -- <randexpr-2.905>
        
        -- </randexpr-2.905>
    })

test:do_test(
    "randexpr-2.906",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (case when (select  -min(t1.e) from t1) in (select f from t1 union select d from t1) then +e else d end | t1.e not between t1.a and t1.b))) and not exists(select 1 from t1 where a>=t1.e) and b=e then 13 else coalesce((select 19 from t1 where t1.d>=t1.e),13) end<11*t1.b then 17 when 17 in (19,t1.e, -t1.c) or 17<f then t1.d else t1.b end FROM t1 WHERE NOT (exists(select 1 from t1 where f<=19))"
    end, {
        -- <randexpr-2.906>
        17
        -- </randexpr-2.906>
    })

test:do_test(
    "randexpr-2.907",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where not exists(select 1 from t1 where (case when (select  -min(t1.e) from t1) in (select f from t1 union select d from t1) then +e else d end & t1.e not between t1.a and t1.b))) and not exists(select 1 from t1 where a>=t1.e) and b=e then 13 else coalesce((select 19 from t1 where t1.d>=t1.e),13) end<11*t1.b then 17 when 17 in (19,t1.e, -t1.c) or 17<f then t1.d else t1.b end FROM t1 WHERE NOT (exists(select 1 from t1 where f<=19))"
    end, {
        -- <randexpr-2.907>
        17
        -- </randexpr-2.907>
    })

test:do_test(
    "randexpr-2.908",
    function()
        return test:execsql "SELECT 11*t1.c* -case when t1.d<=t1.c then case when case case +t1.b-case when exists(select 1 from t1 where (exists(select 1 from t1 where t1.e not in (t1.a,a,11)))) then (abs((select case count(distinct d) when cast(avg(19) AS integer) then  -min(t1.a) else (cast(avg(f) AS integer)) end from t1))/abs(b)) when t1.c<>t1.a then c else 19 end when t1.c then e else t1.d end when 17 then t1.d else  -d end between e and t1.e then 13 when (13<>13) then t1.c else 17 end when exists(select 1 from t1 where (t1.c between b and 11)) then e else f end FROM t1 WHERE ~a* -b+11-case when coalesce((select max(case when (t1.c in (case t1.b when t1.c then 13 else 17 end,17,19)) then case e when a then c else 13 end else c end) from t1 where a between b and t1.c),t1.a)=c or (17>d) then case when f= -t1.a then t1.b when (t1.d)<t1.e then (f) else t1.e end else c end+d<a"
    end, {
        -- <randexpr-2.908>
        
        -- </randexpr-2.908>
    })

test:do_test(
    "randexpr-2.909",
    function()
        return test:execsql "SELECT 11*t1.c* -case when t1.d<=t1.c then case when case case +t1.b-case when exists(select 1 from t1 where (exists(select 1 from t1 where t1.e not in (t1.a,a,11)))) then (abs((select case count(distinct d) when cast(avg(19) AS integer) then  -min(t1.a) else (cast(avg(f) AS integer)) end from t1))/abs(b)) when t1.c<>t1.a then c else 19 end when t1.c then e else t1.d end when 17 then t1.d else  -d end between e and t1.e then 13 when (13<>13) then t1.c else 17 end when exists(select 1 from t1 where (t1.c between b and 11)) then e else f end FROM t1 WHERE NOT (~a* -b+11-case when coalesce((select max(case when (t1.c in (case t1.b when t1.c then 13 else 17 end,17,19)) then case e when a then c else 13 end else c end) from t1 where a between b and t1.c),t1.a)=c or (17>d) then case when f= -t1.a then t1.b when (t1.d)<t1.e then (f) else t1.e end else c end+d<a)"
    end, {
        -- <randexpr-2.909>
        -1980000
        -- </randexpr-2.909>
    })

test:do_test(
    "randexpr-2.910",
    function()
        return test:execsql "SELECT +case when e in (13, -b,11) then d else coalesce((select max(13 | d | d+19+(abs(case when (19) between (abs(case f when t1.f then (13) else 17 end)/abs(a)) and d then 19 when (not exists(select 1 from t1 where t1.a>=t1.f)) and t1.f>t1.a or e<>c then 17 else d end)/abs(a))) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where (t1.f) in (t1.c,(t1.e),17)))),t1.a) end+e FROM t1 WHERE exists(select 1 from t1 where 17>(case coalesce((select max((abs(+t1.f-case when 11=(abs((select count(*) from t1)-13*13)/abs(t1.d)) then coalesce((select max(t1.c) from t1 where 19 in (select ((max(19))) from t1 union select min(t1.d) from t1) or  -t1.a=t1.a and f<17),t1.e-d) when not exists(select 1 from t1 where t1.b not between (d) and  -t1.f) then 11 else t1.a end)/abs(t1.a))) from t1 where t1.e not in ((f),11,t1.f)),t1.c) when b then  -t1.a else 13 end)-t1.c)"
    end, {
        -- <randexpr-2.910>
        947
        -- </randexpr-2.910>
    })

test:do_test(
    "randexpr-2.911",
    function()
        return test:execsql "SELECT +case when e in (13, -b,11) then d else coalesce((select max(13 | d | d+19+(abs(case when (19) between (abs(case f when t1.f then (13) else 17 end)/abs(a)) and d then 19 when (not exists(select 1 from t1 where t1.a>=t1.f)) and t1.f>t1.a or e<>c then 17 else d end)/abs(a))) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where (t1.f) in (t1.c,(t1.e),17)))),t1.a) end+e FROM t1 WHERE NOT (exists(select 1 from t1 where 17>(case coalesce((select max((abs(+t1.f-case when 11=(abs((select count(*) from t1)-13*13)/abs(t1.d)) then coalesce((select max(t1.c) from t1 where 19 in (select ((max(19))) from t1 union select min(t1.d) from t1) or  -t1.a=t1.a and f<17),t1.e-d) when not exists(select 1 from t1 where t1.b not between (d) and  -t1.f) then 11 else t1.a end)/abs(t1.a))) from t1 where t1.e not in ((f),11,t1.f)),t1.c) when b then  -t1.a else 13 end)-t1.c))"
    end, {
        -- <randexpr-2.911>
        
        -- </randexpr-2.911>
    })

test:do_test(
    "randexpr-2.912",
    function()
        return test:execsql "SELECT +case when e in (13, -b,11) then d else coalesce((select max(13 & d & d+19+(abs(case when (19) between (abs(case f when t1.f then (13) else 17 end)/abs(a)) and d then 19 when (not exists(select 1 from t1 where t1.a>=t1.f)) and t1.f>t1.a or e<>c then 17 else d end)/abs(a))) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where (t1.f) in (t1.c,(t1.e),17)))),t1.a) end+e FROM t1 WHERE exists(select 1 from t1 where 17>(case coalesce((select max((abs(+t1.f-case when 11=(abs((select count(*) from t1)-13*13)/abs(t1.d)) then coalesce((select max(t1.c) from t1 where 19 in (select ((max(19))) from t1 union select min(t1.d) from t1) or  -t1.a=t1.a and f<17),t1.e-d) when not exists(select 1 from t1 where t1.b not between (d) and  -t1.f) then 11 else t1.a end)/abs(t1.a))) from t1 where t1.e not in ((f),11,t1.f)),t1.c) when b then  -t1.a else 13 end)-t1.c)"
    end, {
        -- <randexpr-2.912>
        500
        -- </randexpr-2.912>
    })

test:do_test(
    "randexpr-2.913",
    function()
        return test:execsql "SELECT (13*case when exists(select 1 from t1 where exists(select 1 from t1 where coalesce((select max(b) from t1 where t1.b=e),a)<(b-a)+13)) then 11 else t1.e end*coalesce((select 17 from t1 where not ((select cast(avg(13) AS integer) from t1)< -t1.c) and 17 between 13 and 13),case when f<c then b when t1.c<t1.a then  -d else e end)*d+b)+ - -t1.b+11 FROM t1 WHERE not exists(select 1 from t1 where b>=case when exists(select 1 from t1 where (13 in ( -(b)*(select count(*)* -cast(avg(case t1.e when t1.b then (f)-f-f else e end) AS integer)*cast(avg(17) AS integer) | cast(avg((17)) AS integer) | min(d) | count(distinct e) from t1),19+(abs(19)/abs(17))*f,t1.b))) then 11 when 17>t1.f then +a else t1.d end)"
    end, {
        -- <randexpr-2.913>
        28600411
        -- </randexpr-2.913>
    })

test:do_test(
    "randexpr-2.914",
    function()
        return test:execsql "SELECT (13*case when exists(select 1 from t1 where exists(select 1 from t1 where coalesce((select max(b) from t1 where t1.b=e),a)<(b-a)+13)) then 11 else t1.e end*coalesce((select 17 from t1 where not ((select cast(avg(13) AS integer) from t1)< -t1.c) and 17 between 13 and 13),case when f<c then b when t1.c<t1.a then  -d else e end)*d+b)+ - -t1.b+11 FROM t1 WHERE NOT (not exists(select 1 from t1 where b>=case when exists(select 1 from t1 where (13 in ( -(b)*(select count(*)* -cast(avg(case t1.e when t1.b then (f)-f-f else e end) AS integer)*cast(avg(17) AS integer) | cast(avg((17)) AS integer) | min(d) | count(distinct e) from t1),19+(abs(19)/abs(17))*f,t1.b))) then 11 when 17>t1.f then +a else t1.d end))"
    end, {
        -- <randexpr-2.914>
        
        -- </randexpr-2.914>
    })

test:do_test(
    "randexpr-2.915",
    function()
        return test:execsql "SELECT case when +11 | (select min(case 13+a when e then d else 17-t1.b-~b*a end) from t1)-f*t1.f=(coalesce((select e from t1 where a<=f and not exists(select 1 from t1 where d-case 19 when 11 then (b) else t1.e end not between  -t1.a and (t1.c))),e)) then t1.e when  -17>=d then t1.f else t1.b end*t1.a FROM t1 WHERE e<=19"
    end, {
        -- <randexpr-2.915>
        
        -- </randexpr-2.915>
    })

test:do_test(
    "randexpr-2.916",
    function()
        return test:execsql "SELECT case when +11 | (select min(case 13+a when e then d else 17-t1.b-~b*a end) from t1)-f*t1.f=(coalesce((select e from t1 where a<=f and not exists(select 1 from t1 where d-case 19 when 11 then (b) else t1.e end not between  -t1.a and (t1.c))),e)) then t1.e when  -17>=d then t1.f else t1.b end*t1.a FROM t1 WHERE NOT (e<=19)"
    end, {
        -- <randexpr-2.916>
        20000
        -- </randexpr-2.916>
    })

test:do_test(
    "randexpr-2.917",
    function()
        return test:execsql "SELECT case when +11 & (select min(case 13+a when e then d else 17-t1.b-~b*a end) from t1)-f*t1.f=(coalesce((select e from t1 where a<=f and not exists(select 1 from t1 where d-case 19 when 11 then (b) else t1.e end not between  -t1.a and (t1.c))),e)) then t1.e when  -17>=d then t1.f else t1.b end*t1.a FROM t1 WHERE NOT (e<=19)"
    end, {
        -- <randexpr-2.917>
        20000
        -- </randexpr-2.917>
    })

test:do_test(
    "randexpr-2.918",
    function()
        return test:execsql "SELECT 11-coalesce((select max(coalesce((select max((select abs(case +max((e)) when abs(abs( -count(distinct e))) then +cast(avg(f) AS integer) else count(*) end+count(*)+min( -e)) from t1)) from t1 where t1.b in (select count(distinct (17 | case case when e in (13,t1.a,e) or t1.d>=t1.e then 17 else a end when t1.e then 17 else t1.d end*t1.c)) from t1 union select cast(avg(t1.a) AS integer) from t1)),17)) from t1 where t1.c in (select ~cast(avg(t1.b) AS integer) from t1 union select  -(cast(avg(t1.c) AS integer)) from t1)),(t1.c)) FROM t1 WHERE t1.b not in (case when 11 in (select case +min(t1.f) when (+cast(avg((case t1.c when a then f else a end-f)) AS integer)) then +count(distinct (t1.f))-count(distinct t1.f) else count(*) end-count(*) | count(*) from t1 union select min(e) from t1) then (abs(b | 13-f | c)/abs(t1.f)) else t1.c end,f,t1.b) or not  -t1.a<t1.f or t1.f>=11"
    end, {
        -- <randexpr-2.918>
        -289
        -- </randexpr-2.918>
    })

test:do_test(
    "randexpr-2.919",
    function()
        return test:execsql "SELECT 11-coalesce((select max(coalesce((select max((select abs(case +max((e)) when abs(abs( -count(distinct e))) then +cast(avg(f) AS integer) else count(*) end+count(*)+min( -e)) from t1)) from t1 where t1.b in (select count(distinct (17 | case case when e in (13,t1.a,e) or t1.d>=t1.e then 17 else a end when t1.e then 17 else t1.d end*t1.c)) from t1 union select cast(avg(t1.a) AS integer) from t1)),17)) from t1 where t1.c in (select ~cast(avg(t1.b) AS integer) from t1 union select  -(cast(avg(t1.c) AS integer)) from t1)),(t1.c)) FROM t1 WHERE NOT (t1.b not in (case when 11 in (select case +min(t1.f) when (+cast(avg((case t1.c when a then f else a end-f)) AS integer)) then +count(distinct (t1.f))-count(distinct t1.f) else count(*) end-count(*) | count(*) from t1 union select min(e) from t1) then (abs(b | 13-f | c)/abs(t1.f)) else t1.c end,f,t1.b) or not  -t1.a<t1.f or t1.f>=11)"
    end, {
        -- <randexpr-2.919>
        
        -- </randexpr-2.919>
    })

test:do_test(
    "randexpr-2.920",
    function()
        return test:execsql "SELECT 11-coalesce((select max(coalesce((select max((select abs(case +max((e)) when abs(abs( -count(distinct e))) then +cast(avg(f) AS integer) else count(*) end+count(*)+min( -e)) from t1)) from t1 where t1.b in (select count(distinct (17 & case case when e in (13,t1.a,e) or t1.d>=t1.e then 17 else a end when t1.e then 17 else t1.d end*t1.c)) from t1 union select cast(avg(t1.a) AS integer) from t1)),17)) from t1 where t1.c in (select ~cast(avg(t1.b) AS integer) from t1 union select  -(cast(avg(t1.c) AS integer)) from t1)),(t1.c)) FROM t1 WHERE t1.b not in (case when 11 in (select case +min(t1.f) when (+cast(avg((case t1.c when a then f else a end-f)) AS integer)) then +count(distinct (t1.f))-count(distinct t1.f) else count(*) end-count(*) | count(*) from t1 union select min(e) from t1) then (abs(b | 13-f | c)/abs(t1.f)) else t1.c end,f,t1.b) or not  -t1.a<t1.f or t1.f>=11"
    end, {
        -- <randexpr-2.920>
        -289
        -- </randexpr-2.920>
    })

test:do_test(
    "randexpr-2.921",
    function()
        return test:execsql "SELECT (select  -abs(max(+(select +count(*) from t1)))-max(case when b in (select (abs(13)/abs(b)) from t1 union select case when exists(select 1 from t1 where not exists(select 1 from t1 where (abs(17)/abs(coalesce((select max(+19*t1.e+case t1.f when (abs(f)/abs(t1.f)) then t1.f else e end) from t1 where 19<17),t1.a)))+11 in (select b from t1 union select t1.e from t1))) then d else t1.c end from t1) then f when 13=d then  -a else t1.a end) from t1) FROM t1 WHERE ~(select ~ -(min(f)- -cast(avg(f) AS integer)-abs(count(distinct case when t1.d=b then d when e in (select +cast(avg(e) AS integer) from t1 union select count(*) from t1) then t1.f else c end*17*f))) | (count(*)) from t1)-f<>case when (select + -max(t1.e) from t1)+(select  -min(17) from t1)*13 between 17 and 19 then t1.b else t1.d end"
    end, {
        -- <randexpr-2.921>
        -101
        -- </randexpr-2.921>
    })

test:do_test(
    "randexpr-2.922",
    function()
        return test:execsql "SELECT (select  -abs(max(+(select +count(*) from t1)))-max(case when b in (select (abs(13)/abs(b)) from t1 union select case when exists(select 1 from t1 where not exists(select 1 from t1 where (abs(17)/abs(coalesce((select max(+19*t1.e+case t1.f when (abs(f)/abs(t1.f)) then t1.f else e end) from t1 where 19<17),t1.a)))+11 in (select b from t1 union select t1.e from t1))) then d else t1.c end from t1) then f when 13=d then  -a else t1.a end) from t1) FROM t1 WHERE NOT (~(select ~ -(min(f)- -cast(avg(f) AS integer)-abs(count(distinct case when t1.d=b then d when e in (select +cast(avg(e) AS integer) from t1 union select count(*) from t1) then t1.f else c end*17*f))) | (count(*)) from t1)-f<>case when (select + -max(t1.e) from t1)+(select  -min(17) from t1)*13 between 17 and 19 then t1.b else t1.d end)"
    end, {
        -- <randexpr-2.922>
        
        -- </randexpr-2.922>
    })

test:do_test(
    "randexpr-2.923",
    function()
        return test:execsql "SELECT case (select ( - - -(+max(c))+min(e)-(count(*))+cast(avg(t1.e) AS integer)-min(t1.a)*(cast(avg(11) AS integer))) from t1) when t1.d then t1.c else case (select max(a) from t1) when  -t1.b then case when not 17<>case when t1.e<=t1.d or ((t1.e))=t1.e then t1.f when e>=t1.b then 11 else t1.d end or d in (t1.f,t1.a,t1.a) then c | 17 when t1.f between t1.a and  -t1.e then d else t1.c end else t1.c end end-t1.c FROM t1 WHERE not (exists(select 1 from t1 where a<>11+t1.d-t1.a+(select count(distinct t1.d)++max(case e when coalesce((select 11 from t1 where a>=case when coalesce((select f from t1 where exists(select 1 from t1 where 13 in (t1.c,13,t1.a))),(d))+f not between d and t1.e then d else (t1.c) end-13),(d))-t1.d then t1.a else 17 end) from t1)) and not a<(d)*19)"
    end, {
        -- <randexpr-2.923>
        0
        -- </randexpr-2.923>
    })

test:do_test(
    "randexpr-2.924",
    function()
        return test:execsql "SELECT case (select ( - - -(+max(c))+min(e)-(count(*))+cast(avg(t1.e) AS integer)-min(t1.a)*(cast(avg(11) AS integer))) from t1) when t1.d then t1.c else case (select max(a) from t1) when  -t1.b then case when not 17<>case when t1.e<=t1.d or ((t1.e))=t1.e then t1.f when e>=t1.b then 11 else t1.d end or d in (t1.f,t1.a,t1.a) then c | 17 when t1.f between t1.a and  -t1.e then d else t1.c end else t1.c end end-t1.c FROM t1 WHERE NOT (not (exists(select 1 from t1 where a<>11+t1.d-t1.a+(select count(distinct t1.d)++max(case e when coalesce((select 11 from t1 where a>=case when coalesce((select f from t1 where exists(select 1 from t1 where 13 in (t1.c,13,t1.a))),(d))+f not between d and t1.e then d else (t1.c) end-13),(d))-t1.d then t1.a else 17 end) from t1)) and not a<(d)*19))"
    end, {
        -- <randexpr-2.924>
        
        -- </randexpr-2.924>
    })

test:do_test(
    "randexpr-2.925",
    function()
        return test:execsql "SELECT case (select ( - - -(+max(c))+min(e)-(count(*))+cast(avg(t1.e) AS integer)-min(t1.a)*(cast(avg(11) AS integer))) from t1) when t1.d then t1.c else case (select max(a) from t1) when  -t1.b then case when not 17<>case when t1.e<=t1.d or ((t1.e))=t1.e then t1.f when e>=t1.b then 11 else t1.d end or d in (t1.f,t1.a,t1.a) then c & 17 when t1.f between t1.a and  -t1.e then d else t1.c end else t1.c end end-t1.c FROM t1 WHERE not (exists(select 1 from t1 where a<>11+t1.d-t1.a+(select count(distinct t1.d)++max(case e when coalesce((select 11 from t1 where a>=case when coalesce((select f from t1 where exists(select 1 from t1 where 13 in (t1.c,13,t1.a))),(d))+f not between d and t1.e then d else (t1.c) end-13),(d))-t1.d then t1.a else 17 end) from t1)) and not a<(d)*19)"
    end, {
        -- <randexpr-2.925>
        0
        -- </randexpr-2.925>
    })

test:do_test(
    "randexpr-2.926",
    function()
        return test:execsql "SELECT case t1.b when c*(case when ((select ++case abs(cast(avg(a) AS integer))*min(c) when min(t1.c) then cast(avg(t1.b) AS integer) else count(*) end | (count(distinct t1.c)) | ((max(t1.a))) | count(distinct b) from t1) not between t1.e and 11 and coalesce((select max(e) from t1 where a between t1.c and c+b),e) in (select t1.d from t1 union select t1.b from t1) or (not exists(select 1 from t1 where 13<>t1.a))) then 11*b else t1.b end) then t1.c else e end FROM t1 WHERE exists(select 1 from t1 where t1.d>=f)"
    end, {
        -- <randexpr-2.926>
        
        -- </randexpr-2.926>
    })

test:do_test(
    "randexpr-2.927",
    function()
        return test:execsql "SELECT case t1.b when c*(case when ((select ++case abs(cast(avg(a) AS integer))*min(c) when min(t1.c) then cast(avg(t1.b) AS integer) else count(*) end | (count(distinct t1.c)) | ((max(t1.a))) | count(distinct b) from t1) not between t1.e and 11 and coalesce((select max(e) from t1 where a between t1.c and c+b),e) in (select t1.d from t1 union select t1.b from t1) or (not exists(select 1 from t1 where 13<>t1.a))) then 11*b else t1.b end) then t1.c else e end FROM t1 WHERE NOT (exists(select 1 from t1 where t1.d>=f))"
    end, {
        -- <randexpr-2.927>
        500
        -- </randexpr-2.927>
    })

test:do_test(
    "randexpr-2.928",
    function()
        return test:execsql "SELECT case t1.b when c*(case when ((select ++case abs(cast(avg(a) AS integer))*min(c) when min(t1.c) then cast(avg(t1.b) AS integer) else count(*) end & (count(distinct t1.c)) & ((max(t1.a))) & count(distinct b) from t1) not between t1.e and 11 and coalesce((select max(e) from t1 where a between t1.c and c+b),e) in (select t1.d from t1 union select t1.b from t1) or (not exists(select 1 from t1 where 13<>t1.a))) then 11*b else t1.b end) then t1.c else e end FROM t1 WHERE NOT (exists(select 1 from t1 where t1.d>=f))"
    end, {
        -- <randexpr-2.928>
        500
        -- </randexpr-2.928>
    })

test:do_test(
    "randexpr-2.929",
    function()
        return test:execsql "SELECT d-coalesce((select d from t1 where case when ~11*a*c>=17 then coalesce((select (abs(t1.e+c+(abs(f*(select abs((min(e))) from t1)-t1.f)/abs( - -a))-a)/abs(t1.d)) from t1 where f not in (e,b,t1.f) and c<>f),f)*19 else f end in (b,e,17)),13)-19 FROM t1 WHERE not f>=11"
    end, {
        -- <randexpr-2.929>
        
        -- </randexpr-2.929>
    })

test:do_test(
    "randexpr-2.930",
    function()
        return test:execsql "SELECT d-coalesce((select d from t1 where case when ~11*a*c>=17 then coalesce((select (abs(t1.e+c+(abs(f*(select abs((min(e))) from t1)-t1.f)/abs( - -a))-a)/abs(t1.d)) from t1 where f not in (e,b,t1.f) and c<>f),f)*19 else f end in (b,e,17)),13)-19 FROM t1 WHERE NOT (not f>=11)"
    end, {
        -- <randexpr-2.930>
        368
        -- </randexpr-2.930>
    })

test:do_test(
    "randexpr-2.931",
    function()
        return test:execsql "SELECT f*t1.d+coalesce((select a+17-t1.e from t1 where 13=t1.f and not (t1.f | b*t1.d-t1.c*coalesce((select max(coalesce((select t1.f from t1 where f not in (13,a,d)),d)) from t1 where t1.a in (select cast(avg(c) AS integer) from t1 union select count(distinct b)*count(distinct t1.c) from t1)),((17)))+ -b+19+13)=t1.f and 19>=t1.a or  - -a>=t1.b),a) FROM t1 WHERE f not in (coalesce((select max(19) from t1 where (t1.e<=+t1.f*case when ~(abs(b)/abs(b)) in (f,t1.d,17) then (abs(t1.e-11 | d)/abs(coalesce((select d from t1 where not coalesce((select t1.a from t1 where not exists(select 1 from t1 where c>=t1.c)),d) in (select count(distinct f)*cast(avg(19) AS integer) from t1 union select count(distinct d) from t1)),13))) when not 11<=t1.a then t1.f else 19 end-19)),f)-17, -a,e)"
    end, {
        -- <randexpr-2.931>
        240100
        -- </randexpr-2.931>
    })

test:do_test(
    "randexpr-2.932",
    function()
        return test:execsql "SELECT f*t1.d+coalesce((select a+17-t1.e from t1 where 13=t1.f and not (t1.f | b*t1.d-t1.c*coalesce((select max(coalesce((select t1.f from t1 where f not in (13,a,d)),d)) from t1 where t1.a in (select cast(avg(c) AS integer) from t1 union select count(distinct b)*count(distinct t1.c) from t1)),((17)))+ -b+19+13)=t1.f and 19>=t1.a or  - -a>=t1.b),a) FROM t1 WHERE NOT (f not in (coalesce((select max(19) from t1 where (t1.e<=+t1.f*case when ~(abs(b)/abs(b)) in (f,t1.d,17) then (abs(t1.e-11 | d)/abs(coalesce((select d from t1 where not coalesce((select t1.a from t1 where not exists(select 1 from t1 where c>=t1.c)),d) in (select count(distinct f)*cast(avg(19) AS integer) from t1 union select count(distinct d) from t1)),13))) when not 11<=t1.a then t1.f else 19 end-19)),f)-17, -a,e))"
    end, {
        -- <randexpr-2.932>
        
        -- </randexpr-2.932>
    })

test:do_test(
    "randexpr-2.933",
    function()
        return test:execsql "SELECT f*t1.d+coalesce((select a+17-t1.e from t1 where 13=t1.f and not (t1.f & b*t1.d-t1.c*coalesce((select max(coalesce((select t1.f from t1 where f not in (13,a,d)),d)) from t1 where t1.a in (select cast(avg(c) AS integer) from t1 union select count(distinct b)*count(distinct t1.c) from t1)),((17)))+ -b+19+13)=t1.f and 19>=t1.a or  - -a>=t1.b),a) FROM t1 WHERE f not in (coalesce((select max(19) from t1 where (t1.e<=+t1.f*case when ~(abs(b)/abs(b)) in (f,t1.d,17) then (abs(t1.e-11 | d)/abs(coalesce((select d from t1 where not coalesce((select t1.a from t1 where not exists(select 1 from t1 where c>=t1.c)),d) in (select count(distinct f)*cast(avg(19) AS integer) from t1 union select count(distinct d) from t1)),13))) when not 11<=t1.a then t1.f else 19 end-19)),f)-17, -a,e)"
    end, {
        -- <randexpr-2.933>
        240100
        -- </randexpr-2.933>
    })

test:do_test(
    "randexpr-2.934",
    function()
        return test:execsql "SELECT coalesce((select case e*+(abs(t1.f-t1.b)/abs(e))-d when coalesce((select t1.e from t1 where exists(select 1 from t1 where +d+ -t1.e not between case when (abs(b)/abs(t1.b)) between a and 17 then t1.b when not 11 not between b and d then 19 else 19 end and t1.f and t1.a between 17 and b)), -13) then (t1.a) else 13 end from t1 where 17 between b and 13), -19) | c FROM t1 WHERE case when t1.e*t1.b | f+d | f+11+(a)-+a+ -t1.c-t1.f | coalesce((select case t1.e when 17 then e else t1.a end from t1 where t1.a<t1.b),t1.b)*f<= -t1.a and c<t1.f then (select (max((b))) from t1) else t1.b end not in (a,a,t1.c)"
    end, {
        -- <randexpr-2.934>
        -19
        -- </randexpr-2.934>
    })

test:do_test(
    "randexpr-2.935",
    function()
        return test:execsql "SELECT coalesce((select case e*+(abs(t1.f-t1.b)/abs(e))-d when coalesce((select t1.e from t1 where exists(select 1 from t1 where +d+ -t1.e not between case when (abs(b)/abs(t1.b)) between a and 17 then t1.b when not 11 not between b and d then 19 else 19 end and t1.f and t1.a between 17 and b)), -13) then (t1.a) else 13 end from t1 where 17 between b and 13), -19) | c FROM t1 WHERE NOT (case when t1.e*t1.b | f+d | f+11+(a)-+a+ -t1.c-t1.f | coalesce((select case t1.e when 17 then e else t1.a end from t1 where t1.a<t1.b),t1.b)*f<= -t1.a and c<t1.f then (select (max((b))) from t1) else t1.b end not in (a,a,t1.c))"
    end, {
        -- <randexpr-2.935>
        
        -- </randexpr-2.935>
    })

test:do_test(
    "randexpr-2.936",
    function()
        return test:execsql "SELECT coalesce((select case e*+(abs(t1.f-t1.b)/abs(e))-d when coalesce((select t1.e from t1 where exists(select 1 from t1 where +d+ -t1.e not between case when (abs(b)/abs(t1.b)) between a and 17 then t1.b when not 11 not between b and d then 19 else 19 end and t1.f and t1.a between 17 and b)), -13) then (t1.a) else 13 end from t1 where 17 between b and 13), -19) & c FROM t1 WHERE case when t1.e*t1.b | f+d | f+11+(a)-+a+ -t1.c-t1.f | coalesce((select case t1.e when 17 then e else t1.a end from t1 where t1.a<t1.b),t1.b)*f<= -t1.a and c<t1.f then (select (max((b))) from t1) else t1.b end not in (a,a,t1.c)"
    end, {
        -- <randexpr-2.936>
        300
        -- </randexpr-2.936>
    })

test:do_test(
    "randexpr-2.937",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d*case when case when ~ -t1.d+17-b-13*t1.f*(abs(t1.b+13)/abs(t1.a))+a*t1.e*t1.a+c*t1.d-t1.a in (select t1.b from t1 union select t1.d from t1) then t1.e else t1.e end not in (t1.f,t1.e,19) then t1.d else 11 end) from t1 where d not between t1.a and a),c) FROM t1 WHERE t1.e in (select a from t1 union select +b-t1.b from t1)"
    end, {
        -- <randexpr-2.937>
        
        -- </randexpr-2.937>
    })

test:do_test(
    "randexpr-2.938",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d*case when case when ~ -t1.d+17-b-13*t1.f*(abs(t1.b+13)/abs(t1.a))+a*t1.e*t1.a+c*t1.d-t1.a in (select t1.b from t1 union select t1.d from t1) then t1.e else t1.e end not in (t1.f,t1.e,19) then t1.d else 11 end) from t1 where d not between t1.a and a),c) FROM t1 WHERE NOT (t1.e in (select a from t1 union select +b-t1.b from t1))"
    end, {
        -- <randexpr-2.938>
        4400
        -- </randexpr-2.938>
    })

test:do_test(
    "randexpr-2.939",
    function()
        return test:execsql "SELECT d*(select  - - -max( -(abs(e)/abs(~t1.c))) from t1)-13 | coalesce((select max(+t1.a*a) from t1 where t1.e+case e when a then t1.f+(select case ~ -max(d)* - -cast(avg(c) AS integer) when  -min( -t1.b) then min(t1.b) else count(distinct 13) end from t1)-a else ~case when t1.f not in (b,b,a) or c between d and t1.a then c when t1.b>b then e else t1.d end end-11>=13),e) | 13 FROM t1 WHERE not exists(select 1 from t1 where t1.c< -d or t1.e between c and  -t1.d or d<=17)"
    end, {
        -- <randexpr-2.939>
        10143
        -- </randexpr-2.939>
    })

test:do_test(
    "randexpr-2.940",
    function()
        return test:execsql "SELECT d*(select  - - -max( -(abs(e)/abs(~t1.c))) from t1)-13 | coalesce((select max(+t1.a*a) from t1 where t1.e+case e when a then t1.f+(select case ~ -max(d)* - -cast(avg(c) AS integer) when  -min( -t1.b) then min(t1.b) else count(distinct 13) end from t1)-a else ~case when t1.f not in (b,b,a) or c between d and t1.a then c when t1.b>b then e else t1.d end end-11>=13),e) | 13 FROM t1 WHERE NOT (not exists(select 1 from t1 where t1.c< -d or t1.e between c and  -t1.d or d<=17))"
    end, {
        -- <randexpr-2.940>
        
        -- </randexpr-2.940>
    })

test:do_test(
    "randexpr-2.941",
    function()
        return test:execsql "SELECT d*(select  - - -max( -(abs(e)/abs(~t1.c))) from t1)-13 & coalesce((select max(+t1.a*a) from t1 where t1.e+case e when a then t1.f+(select case ~ -max(d)* - -cast(avg(c) AS integer) when  -min( -t1.b) then min(t1.b) else count(distinct 13) end from t1)-a else ~case when t1.f not in (b,b,a) or c between d and t1.a then c when t1.b>b then e else t1.d end end-11>=13),e) & 13 FROM t1 WHERE not exists(select 1 from t1 where t1.c< -d or t1.e between c and  -t1.d or d<=17)"
    end, {
        -- <randexpr-2.941>
        0
        -- </randexpr-2.941>
    })

test:do_test(
    "randexpr-2.942",
    function()
        return test:execsql "SELECT t1.c*+case when a<>+case when b>t1.e or exists(select 1 from t1 where not exists(select 1 from t1 where t1.e in (select coalesce((select b from t1 where (d<f) or t1.e in ((t1.f),(t1.a),13) and (t1.e)<>( -t1.d)),(( -b))) from t1 union select t1.d from t1))) then (select  -max(t1.e)-count(*) from t1) else (t1.c) end+b+(t1.f) | f | e then t1.d when t1.f not in (19,13,e) then 13 else 11 end FROM t1 WHERE (f<>coalesce((select max(a) from t1 where (exists(select 1 from t1 where c between t1.b and case when (abs(19)/abs(t1.f)) in (t1.f,17,t1.a) then t1.b when t1.d<=t1.a then t1.a else c end or c<c) or 13>=b and c>=t1.d and t1.d between c and t1.c)),e+case (select count(distinct case 19 when 13 then t1.b else 11 end) from t1) when 13 then b else t1.b end)-17-17)"
    end, {
        -- <randexpr-2.942>
        120000
        -- </randexpr-2.942>
    })

test:do_test(
    "randexpr-2.943",
    function()
        return test:execsql "SELECT t1.c*+case when a<>+case when b>t1.e or exists(select 1 from t1 where not exists(select 1 from t1 where t1.e in (select coalesce((select b from t1 where (d<f) or t1.e in ((t1.f),(t1.a),13) and (t1.e)<>( -t1.d)),(( -b))) from t1 union select t1.d from t1))) then (select  -max(t1.e)-count(*) from t1) else (t1.c) end+b+(t1.f) | f | e then t1.d when t1.f not in (19,13,e) then 13 else 11 end FROM t1 WHERE NOT ((f<>coalesce((select max(a) from t1 where (exists(select 1 from t1 where c between t1.b and case when (abs(19)/abs(t1.f)) in (t1.f,17,t1.a) then t1.b when t1.d<=t1.a then t1.a else c end or c<c) or 13>=b and c>=t1.d and t1.d between c and t1.c)),e+case (select count(distinct case 19 when 13 then t1.b else 11 end) from t1) when 13 then b else t1.b end)-17-17))"
    end, {
        -- <randexpr-2.943>
        
        -- </randexpr-2.943>
    })

test:do_test(
    "randexpr-2.944",
    function()
        return test:execsql "SELECT t1.c*+case when a<>+case when b>t1.e or exists(select 1 from t1 where not exists(select 1 from t1 where t1.e in (select coalesce((select b from t1 where (d<f) or t1.e in ((t1.f),(t1.a),13) and (t1.e)<>( -t1.d)),(( -b))) from t1 union select t1.d from t1))) then (select  -max(t1.e)-count(*) from t1) else (t1.c) end+b+(t1.f) & f & e then t1.d when t1.f not in (19,13,e) then 13 else 11 end FROM t1 WHERE (f<>coalesce((select max(a) from t1 where (exists(select 1 from t1 where c between t1.b and case when (abs(19)/abs(t1.f)) in (t1.f,17,t1.a) then t1.b when t1.d<=t1.a then t1.a else c end or c<c) or 13>=b and c>=t1.d and t1.d between c and t1.c)),e+case (select count(distinct case 19 when 13 then t1.b else 11 end) from t1) when 13 then b else t1.b end)-17-17)"
    end, {
        -- <randexpr-2.944>
        120000
        -- </randexpr-2.944>
    })

test:do_test(
    "randexpr-2.945",
    function()
        return test:execsql "SELECT case when (e)- -((select case min(case when e in (select coalesce((select max(d) from t1 where 13<>(t1.d-e)),e) from t1 union select c from t1) then d else  -11 end+a) when count(distinct  -f) then count(*) else  -(case cast(avg(17) AS integer)- -count(distinct t1.c)+cast(avg(b) AS integer) when  -max(11) then count(*) else cast(avg(t1.e) AS integer) end+max(t1.f)) end from t1))<=t1.b | t1.e then t1.d when not exists(select 1 from t1 where c<>13) then 11 else d end FROM t1 WHERE (select max(t1.a*case f when b then ~case when not exists(select 1 from t1 where f-d>(select abs(cast(avg(~17+b+d) AS integer)) from t1) or f-e in (select b from t1 union select t1.d from t1) or exists(select 1 from t1 where 13<>b)) then (abs(a)/abs( -d)) when (d<t1.a) then e else t1.e end else t1.a end) from t1)*t1.e in (select t1.f from t1 union select t1.b from t1)"
    end, {
        -- <randexpr-2.945>
        
        -- </randexpr-2.945>
    })

test:do_test(
    "randexpr-2.946",
    function()
        return test:execsql "SELECT case when (e)- -((select case min(case when e in (select coalesce((select max(d) from t1 where 13<>(t1.d-e)),e) from t1 union select c from t1) then d else  -11 end+a) when count(distinct  -f) then count(*) else  -(case cast(avg(17) AS integer)- -count(distinct t1.c)+cast(avg(b) AS integer) when  -max(11) then count(*) else cast(avg(t1.e) AS integer) end+max(t1.f)) end from t1))<=t1.b | t1.e then t1.d when not exists(select 1 from t1 where c<>13) then 11 else d end FROM t1 WHERE NOT ((select max(t1.a*case f when b then ~case when not exists(select 1 from t1 where f-d>(select abs(cast(avg(~17+b+d) AS integer)) from t1) or f-e in (select b from t1 union select t1.d from t1) or exists(select 1 from t1 where 13<>b)) then (abs(a)/abs( -d)) when (d<t1.a) then e else t1.e end else t1.a end) from t1)*t1.e in (select t1.f from t1 union select t1.b from t1))"
    end, {
        -- <randexpr-2.946>
        400
        -- </randexpr-2.946>
    })

test:do_test(
    "randexpr-2.947",
    function()
        return test:execsql "SELECT case when (e)- -((select case min(case when e in (select coalesce((select max(d) from t1 where 13<>(t1.d-e)),e) from t1 union select c from t1) then d else  -11 end+a) when count(distinct  -f) then count(*) else  -(case cast(avg(17) AS integer)- -count(distinct t1.c)+cast(avg(b) AS integer) when  -max(11) then count(*) else cast(avg(t1.e) AS integer) end+max(t1.f)) end from t1))<=t1.b & t1.e then t1.d when not exists(select 1 from t1 where c<>13) then 11 else d end FROM t1 WHERE NOT ((select max(t1.a*case f when b then ~case when not exists(select 1 from t1 where f-d>(select abs(cast(avg(~17+b+d) AS integer)) from t1) or f-e in (select b from t1 union select t1.d from t1) or exists(select 1 from t1 where 13<>b)) then (abs(a)/abs( -d)) when (d<t1.a) then e else t1.e end else t1.a end) from t1)*t1.e in (select t1.f from t1 union select t1.b from t1))"
    end, {
        -- <randexpr-2.947>
        400
        -- </randexpr-2.947>
    })

test:do_test(
    "randexpr-2.948",
    function()
        return test:execsql "SELECT (t1.b+coalesce((select case when e-13+11 | f+case when not t1.b not between t1.f and t1.f then e else (t1.e) end-c-b+c>=e and d between d and a then t1.c when (t1.c>19) then  -11 else a end from t1 where a<d),e)+f+t1.e*d)*17 FROM t1 WHERE t1.b in (select cast(avg(17) AS integer) from t1 union select ~case (+abs(cast(avg((d)) AS integer))) when count(distinct case when (case when c>c then t1.e else  -d end-t1.e) between b and 11 then b when exists(select 1 from t1 where a<=d) then 11 else 13 end) then cast(avg(t1.b) AS integer)-(cast(avg(11) AS integer)-min(a))-count(distinct  -e) else cast(avg(13) AS integer) end*max(b) from t1) or (t1.f not between t1.d and 17 | 19*e)"
    end, {
        -- <randexpr-2.948>
        
        -- </randexpr-2.948>
    })

test:do_test(
    "randexpr-2.949",
    function()
        return test:execsql "SELECT (t1.b+coalesce((select case when e-13+11 | f+case when not t1.b not between t1.f and t1.f then e else (t1.e) end-c-b+c>=e and d between d and a then t1.c when (t1.c>19) then  -11 else a end from t1 where a<d),e)+f+t1.e*d)*17 FROM t1 WHERE NOT (t1.b in (select cast(avg(17) AS integer) from t1 union select ~case (+abs(cast(avg((d)) AS integer))) when count(distinct case when (case when c>c then t1.e else  -d end-t1.e) between b and 11 then b when exists(select 1 from t1 where a<=d) then 11 else 13 end) then cast(avg(t1.b) AS integer)-(cast(avg(11) AS integer)-min(a))-count(distinct  -e) else cast(avg(13) AS integer) end*max(b) from t1) or (t1.f not between t1.d and 17 | 19*e))"
    end, {
        -- <randexpr-2.949>
        3413413
        -- </randexpr-2.949>
    })

test:do_test(
    "randexpr-2.950",
    function()
        return test:execsql "SELECT (t1.b+coalesce((select case when e-13+11 & f+case when not t1.b not between t1.f and t1.f then e else (t1.e) end-c-b+c>=e and d between d and a then t1.c when (t1.c>19) then  -11 else a end from t1 where a<d),e)+f+t1.e*d)*17 FROM t1 WHERE NOT (t1.b in (select cast(avg(17) AS integer) from t1 union select ~case (+abs(cast(avg((d)) AS integer))) when count(distinct case when (case when c>c then t1.e else  -d end-t1.e) between b and 11 then b when exists(select 1 from t1 where a<=d) then 11 else 13 end) then cast(avg(t1.b) AS integer)-(cast(avg(11) AS integer)-min(a))-count(distinct  -e) else cast(avg(13) AS integer) end*max(b) from t1) or (t1.f not between t1.d and 17 | 19*e))"
    end, {
        -- <randexpr-2.950>
        3413413
        -- </randexpr-2.950>
    })

test:do_test(
    "randexpr-2.951",
    function()
        return test:execsql "SELECT coalesce((select max(+19) from t1 where t1.f>=(abs(19)/abs(t1.c*(select count(distinct (abs(t1.f)/abs(t1.c))*coalesce((select max(case when (select count(*) from t1)*t1.f in (t1.b,17,t1.f) then d when t1.e not in (t1.b,t1.a,t1.b) then  -17 else t1.d end) from t1 where (11 not in (t1.b,(f),t1.c)) and t1.c>=t1.f),e)) from t1))) or ((t1.d<=t1.b))),13) FROM t1 WHERE t1.a<>(coalesce((select coalesce((select max(t1.a) from t1 where case  -t1.c when t1.b then coalesce((select t1.b from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where ((select count(*)++count(distinct a) from t1) not between b and +(17))))),19)*t1.e else f end<=(t1.b)),t1.c) from t1 where d<>b),13)-17+a)+d+(19)+a or d between 11 and  -11"
    end, {
        -- <randexpr-2.951>
        19
        -- </randexpr-2.951>
    })

test:do_test(
    "randexpr-2.952",
    function()
        return test:execsql "SELECT coalesce((select max(+19) from t1 where t1.f>=(abs(19)/abs(t1.c*(select count(distinct (abs(t1.f)/abs(t1.c))*coalesce((select max(case when (select count(*) from t1)*t1.f in (t1.b,17,t1.f) then d when t1.e not in (t1.b,t1.a,t1.b) then  -17 else t1.d end) from t1 where (11 not in (t1.b,(f),t1.c)) and t1.c>=t1.f),e)) from t1))) or ((t1.d<=t1.b))),13) FROM t1 WHERE NOT (t1.a<>(coalesce((select coalesce((select max(t1.a) from t1 where case  -t1.c when t1.b then coalesce((select t1.b from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where ((select count(*)++count(distinct a) from t1) not between b and +(17))))),19)*t1.e else f end<=(t1.b)),t1.c) from t1 where d<>b),13)-17+a)+d+(19)+a or d between 11 and  -11)"
    end, {
        -- <randexpr-2.952>
        
        -- </randexpr-2.952>
    })

test:do_test(
    "randexpr-2.953",
    function()
        return test:execsql "SELECT t1.b-coalesce((select max(~t1.a) from t1 where coalesce((select max(t1.d) from t1 where coalesce((select max(coalesce((select t1.c*t1.d from t1 where not f>=a-t1.c+ -coalesce((select t1.f*e from t1 where (not exists(select 1 from t1 where d<=19))),b)-d),13)* -e) from t1 where (d<19 or 13 not between t1.f and t1.d)),11) between 17 and 19),t1.c)< -b),d) FROM t1 WHERE +case when b in (b+~b+t1.f,coalesce((select max(13) from t1 where exists(select 1 from t1 where 17<>+a or not exists(select 1 from t1 where e+19=f))),(e)),case when c>case when coalesce((select 13 from t1 where f>=t1.b and c not between t1.e and t1.d),11) in (select (case max(11) when (min(b)) then min( -d) else cast(avg(t1.e) AS integer) end) from t1 union select max(19) from t1) then t1.d else 13 end then t1.f else t1.e end) or b>=(t1.f) then t1.e else t1.e end*b>f"
    end, {
        -- <randexpr-2.953>
        -200
        -- </randexpr-2.953>
    })

test:do_test(
    "randexpr-2.954",
    function()
        return test:execsql "SELECT t1.b-coalesce((select max(~t1.a) from t1 where coalesce((select max(t1.d) from t1 where coalesce((select max(coalesce((select t1.c*t1.d from t1 where not f>=a-t1.c+ -coalesce((select t1.f*e from t1 where (not exists(select 1 from t1 where d<=19))),b)-d),13)* -e) from t1 where (d<19 or 13 not between t1.f and t1.d)),11) between 17 and 19),t1.c)< -b),d) FROM t1 WHERE NOT (+case when b in (b+~b+t1.f,coalesce((select max(13) from t1 where exists(select 1 from t1 where 17<>+a or not exists(select 1 from t1 where e+19=f))),(e)),case when c>case when coalesce((select 13 from t1 where f>=t1.b and c not between t1.e and t1.d),11) in (select (case max(11) when (min(b)) then min( -d) else cast(avg(t1.e) AS integer) end) from t1 union select max(19) from t1) then t1.d else 13 end then t1.f else t1.e end) or b>=(t1.f) then t1.e else t1.e end*b>f)"
    end, {
        -- <randexpr-2.954>
        
        -- </randexpr-2.954>
    })

test:do_test(
    "randexpr-2.955",
    function()
        return test:execsql "SELECT (select count(distinct + - -f-c-17*a+(t1.d)-+((select abs( - - -count(distinct 13)-count(*)*count(distinct t1.d)*count(*))-cast(avg(f) AS integer) from t1))-~19+13- -d*t1.e*(19)+ -f- -b) from t1)-e FROM t1 WHERE not t1.c between t1.f and coalesce((select coalesce((select case when exists(select 1 from t1 where +~f=case when d<>t1.d then t1.f else  -d end and d between 17 and t1.c) then ~case when a in (d,c,t1.d) then 17 else t1.f end when f=f then d else  -b end from t1 where c>f),e) from t1 where not exists(select 1 from t1 where t1.d<=c) and 19=(11) and t1.e<>19),a)"
    end, {
        -- <randexpr-2.955>
        -499
        -- </randexpr-2.955>
    })

test:do_test(
    "randexpr-2.956",
    function()
        return test:execsql "SELECT (select count(distinct + - -f-c-17*a+(t1.d)-+((select abs( - - -count(distinct 13)-count(*)*count(distinct t1.d)*count(*))-cast(avg(f) AS integer) from t1))-~19+13- -d*t1.e*(19)+ -f- -b) from t1)-e FROM t1 WHERE NOT (not t1.c between t1.f and coalesce((select coalesce((select case when exists(select 1 from t1 where +~f=case when d<>t1.d then t1.f else  -d end and d between 17 and t1.c) then ~case when a in (d,c,t1.d) then 17 else t1.f end when f=f then d else  -b end from t1 where c>f),e) from t1 where not exists(select 1 from t1 where t1.d<=c) and 19=(11) and t1.e<>19),a))"
    end, {
        -- <randexpr-2.956>
        
        -- </randexpr-2.956>
    })

test:do_test(
    "randexpr-2.957",
    function()
        return test:execsql "SELECT case when f-t1.b*coalesce((select max(11) from t1 where exists(select 1 from t1 where (abs(t1.b)/abs(13-11))=(19+c))),coalesce((select t1.c | f from t1 where (abs(c*19)/abs(17))=t1.e),19))-e between t1.f and  -((19)) and 13 not between t1.c and 11 and not exists(select 1 from t1 where t1.b>b) then t1.d when t1.c>=13 then c else f end FROM t1 WHERE e-t1.c=+e*~coalesce((select max(t1.f) from t1 where (t1.f in (coalesce((select max(11) from t1 where  -13<>(13)-(select (count(*)) from t1)*t1.f and ( -11+t1.b+b*b-(select max(13) from t1)) in (t1.f,a,f)),d),17,13))),t1.f)-e"
    end, {
        -- <randexpr-2.957>
        
        -- </randexpr-2.957>
    })

test:do_test(
    "randexpr-2.958",
    function()
        return test:execsql "SELECT case when f-t1.b*coalesce((select max(11) from t1 where exists(select 1 from t1 where (abs(t1.b)/abs(13-11))=(19+c))),coalesce((select t1.c | f from t1 where (abs(c*19)/abs(17))=t1.e),19))-e between t1.f and  -((19)) and 13 not between t1.c and 11 and not exists(select 1 from t1 where t1.b>b) then t1.d when t1.c>=13 then c else f end FROM t1 WHERE NOT (e-t1.c=+e*~coalesce((select max(t1.f) from t1 where (t1.f in (coalesce((select max(11) from t1 where  -13<>(13)-(select (count(*)) from t1)*t1.f and ( -11+t1.b+b*b-(select max(13) from t1)) in (t1.f,a,f)),d),17,13))),t1.f)-e)"
    end, {
        -- <randexpr-2.958>
        300
        -- </randexpr-2.958>
    })

test:do_test(
    "randexpr-2.959",
    function()
        return test:execsql "SELECT case when f-t1.b*coalesce((select max(11) from t1 where exists(select 1 from t1 where (abs(t1.b)/abs(13-11))=(19+c))),coalesce((select t1.c & f from t1 where (abs(c*19)/abs(17))=t1.e),19))-e between t1.f and  -((19)) and 13 not between t1.c and 11 and not exists(select 1 from t1 where t1.b>b) then t1.d when t1.c>=13 then c else f end FROM t1 WHERE NOT (e-t1.c=+e*~coalesce((select max(t1.f) from t1 where (t1.f in (coalesce((select max(11) from t1 where  -13<>(13)-(select (count(*)) from t1)*t1.f and ( -11+t1.b+b*b-(select max(13) from t1)) in (t1.f,a,f)),d),17,13))),t1.f)-e)"
    end, {
        -- <randexpr-2.959>
        300
        -- </randexpr-2.959>
    })

test:do_test(
    "randexpr-2.960",
    function()
        return test:execsql "SELECT t1.e+case when coalesce((select  -(abs(t1.e)/abs(t1.c-t1.e)) from t1 where d | d between  -t1.d and ~case t1.d when t1.f then ((abs((select ((min(b)+abs(cast(avg(t1.a) AS integer)*(max(19))))-(cast(avg(t1.d) AS integer))) from t1)*~f)/abs(t1.a*t1.c)))*17 else 19 end),f)- -c<>t1.c then f else t1.f end FROM t1 WHERE 19*coalesce((select max(a) from t1 where not (select count(distinct ~t1.b | t1.d) from t1)<case when b+(case when t1.c not in (f,(b),t1.c) then t1.d else 19 end)>t1.e then c when  -b<11 then t1.c else  -t1.e end and not d in ( -t1.d,t1.a,f) and c=t1.f and f<>t1.a),t1.b) between t1.a and b"
    end, {
        -- <randexpr-2.960>
        
        -- </randexpr-2.960>
    })

test:do_test(
    "randexpr-2.961",
    function()
        return test:execsql "SELECT t1.e+case when coalesce((select  -(abs(t1.e)/abs(t1.c-t1.e)) from t1 where d | d between  -t1.d and ~case t1.d when t1.f then ((abs((select ((min(b)+abs(cast(avg(t1.a) AS integer)*(max(19))))-(cast(avg(t1.d) AS integer))) from t1)*~f)/abs(t1.a*t1.c)))*17 else 19 end),f)- -c<>t1.c then f else t1.f end FROM t1 WHERE NOT (19*coalesce((select max(a) from t1 where not (select count(distinct ~t1.b | t1.d) from t1)<case when b+(case when t1.c not in (f,(b),t1.c) then t1.d else 19 end)>t1.e then c when  -b<11 then t1.c else  -t1.e end and not d in ( -t1.d,t1.a,f) and c=t1.f and f<>t1.a),t1.b) between t1.a and b)"
    end, {
        -- <randexpr-2.961>
        1100
        -- </randexpr-2.961>
    })

test:do_test(
    "randexpr-2.962",
    function()
        return test:execsql "SELECT t1.e+case when coalesce((select  -(abs(t1.e)/abs(t1.c-t1.e)) from t1 where d & d between  -t1.d and ~case t1.d when t1.f then ((abs((select ((min(b)+abs(cast(avg(t1.a) AS integer)*(max(19))))-(cast(avg(t1.d) AS integer))) from t1)*~f)/abs(t1.a*t1.c)))*17 else 19 end),f)- -c<>t1.c then f else t1.f end FROM t1 WHERE NOT (19*coalesce((select max(a) from t1 where not (select count(distinct ~t1.b | t1.d) from t1)<case when b+(case when t1.c not in (f,(b),t1.c) then t1.d else 19 end)>t1.e then c when  -b<11 then t1.c else  -t1.e end and not d in ( -t1.d,t1.a,f) and c=t1.f and f<>t1.a),t1.b) between t1.a and b)"
    end, {
        -- <randexpr-2.962>
        1100
        -- </randexpr-2.962>
    })

test:do_test(
    "randexpr-2.963",
    function()
        return test:execsql "SELECT t1.b*coalesce((select max(e) from t1 where ((t1.d))<=case case when +coalesce((select (abs(t1.a)/abs(c))-(abs( -e)/abs(11* -t1.b+t1.d* -c))-t1.c from t1 where not exists(select 1 from t1 where t1.c=(11))), -11) between 17 and t1.a then t1.a when t1.b>t1.e then (b) else b end-c when d then d else t1.f end),((t1.e))) FROM t1 WHERE ~ -case when not exists(select 1 from t1 where t1.b between b and 11 | d) then  -(abs(17+d)/abs(e)) else case when not (t1.d>=case when case a when case t1.f when (e) then 17 else 19 end then 13 else 19 end in (t1.e,b,((t1.b))) then d when t1.d not in (19,t1.a, -c) then 11 else  -a end) then 11 else c end end*17*t1.b not in (a,b,13)"
    end, {
        -- <randexpr-2.963>
        100000
        -- </randexpr-2.963>
    })

test:do_test(
    "randexpr-2.964",
    function()
        return test:execsql "SELECT t1.b*coalesce((select max(e) from t1 where ((t1.d))<=case case when +coalesce((select (abs(t1.a)/abs(c))-(abs( -e)/abs(11* -t1.b+t1.d* -c))-t1.c from t1 where not exists(select 1 from t1 where t1.c=(11))), -11) between 17 and t1.a then t1.a when t1.b>t1.e then (b) else b end-c when d then d else t1.f end),((t1.e))) FROM t1 WHERE NOT (~ -case when not exists(select 1 from t1 where t1.b between b and 11 | d) then  -(abs(17+d)/abs(e)) else case when not (t1.d>=case when case a when case t1.f when (e) then 17 else 19 end then 13 else 19 end in (t1.e,b,((t1.b))) then d when t1.d not in (19,t1.a, -c) then 11 else  -a end) then 11 else c end end*17*t1.b not in (a,b,13))"
    end, {
        -- <randexpr-2.964>
        
        -- </randexpr-2.964>
    })

test:do_test(
    "randexpr-2.965",
    function()
        return test:execsql "SELECT e*case +case when not (select max(17) from t1)>=case when not d=c+t1.c then 11 else 11 end or (c in (select t1.c from t1 union select c from t1) or 11<=t1.a) or d<=11 or 19 in ( -13,d,19) or a not between 13 and (t1.c) then case when t1.f<=(t1.a) then t1.e+13*e when (t1.b) not between f and a then c else 11 end*11 else a end when 19 then t1.a else 17 end FROM t1 WHERE b<>17"
    end, {
        -- <randexpr-2.965>
        8500
        -- </randexpr-2.965>
    })

test:do_test(
    "randexpr-2.966",
    function()
        return test:execsql "SELECT e*case +case when not (select max(17) from t1)>=case when not d=c+t1.c then 11 else 11 end or (c in (select t1.c from t1 union select c from t1) or 11<=t1.a) or d<=11 or 19 in ( -13,d,19) or a not between 13 and (t1.c) then case when t1.f<=(t1.a) then t1.e+13*e when (t1.b) not between f and a then c else 11 end*11 else a end when 19 then t1.a else 17 end FROM t1 WHERE NOT (b<>17)"
    end, {
        -- <randexpr-2.966>
        
        -- </randexpr-2.966>
    })

test:do_test(
    "randexpr-2.967",
    function()
        return test:execsql "SELECT (abs(case when (13+e in (select min(a) | case abs(min(case when t1.e in (select b from t1 union select a from t1) then t1.e when t1.b=t1.c then t1.b else c end-f)) when ~(cast(avg(c) AS integer)) then min(t1.e) else count(*) end from t1 union select min(f) from t1)) and t1.d not between c and 13 then coalesce((select t1.d from t1 where t1.e<>a),19)-t1.d else 19 end)/abs(c))-c+11+c FROM t1 WHERE t1.e<f+11-b"
    end, {
        -- <randexpr-2.967>
        
        -- </randexpr-2.967>
    })

test:do_test(
    "randexpr-2.968",
    function()
        return test:execsql "SELECT (abs(case when (13+e in (select min(a) | case abs(min(case when t1.e in (select b from t1 union select a from t1) then t1.e when t1.b=t1.c then t1.b else c end-f)) when ~(cast(avg(c) AS integer)) then min(t1.e) else count(*) end from t1 union select min(f) from t1)) and t1.d not between c and 13 then coalesce((select t1.d from t1 where t1.e<>a),19)-t1.d else 19 end)/abs(c))-c+11+c FROM t1 WHERE NOT (t1.e<f+11-b)"
    end, {
        -- <randexpr-2.968>
        11
        -- </randexpr-2.968>
    })

test:do_test(
    "randexpr-2.969",
    function()
        return test:execsql "SELECT (abs(case when (13+e in (select min(a) & case abs(min(case when t1.e in (select b from t1 union select a from t1) then t1.e when t1.b=t1.c then t1.b else c end-f)) when ~(cast(avg(c) AS integer)) then min(t1.e) else count(*) end from t1 union select min(f) from t1)) and t1.d not between c and 13 then coalesce((select t1.d from t1 where t1.e<>a),19)-t1.d else 19 end)/abs(c))-c+11+c FROM t1 WHERE NOT (t1.e<f+11-b)"
    end, {
        -- <randexpr-2.969>
        11
        -- </randexpr-2.969>
    })

test:do_test(
    "randexpr-2.970",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where (11 not between ~~t1.d-case c when coalesce((select case f when coalesce((select max(t1.f) from t1 where 11 not in (((13)),d,t1.d)),11) then f else a end from t1 where 11 not between (t1.a) and 17),t1.c)-c*17 then (17) else t1.b end+t1.d+t1.a and d)) then t1.e-11+19 else (d) end*d<=11 then t1.b else f end FROM t1 WHERE not exists(select 1 from t1 where d>=t1.f)"
    end, {
        -- <randexpr-2.970>
        600
        -- </randexpr-2.970>
    })

test:do_test(
    "randexpr-2.971",
    function()
        return test:execsql "SELECT case when case when not exists(select 1 from t1 where (11 not between ~~t1.d-case c when coalesce((select case f when coalesce((select max(t1.f) from t1 where 11 not in (((13)),d,t1.d)),11) then f else a end from t1 where 11 not between (t1.a) and 17),t1.c)-c*17 then (17) else t1.b end+t1.d+t1.a and d)) then t1.e-11+19 else (d) end*d<=11 then t1.b else f end FROM t1 WHERE NOT (not exists(select 1 from t1 where d>=t1.f))"
    end, {
        -- <randexpr-2.971>
        
        -- </randexpr-2.971>
    })

test:do_test(
    "randexpr-2.972",
    function()
        return test:execsql "SELECT 13 | t1.c+case when (not t1.d-c between +t1.b and  -coalesce((select (select count(distinct 17) from t1)*a from t1 where  -case when not t1.f in (select count(distinct 13) from t1 union select min( -t1.a) from t1) then case when (t1.e)< -11 then  -c else t1.a end else d end-c*t1.a-d+ -e-t1.a not in (17,e,t1.a)),b) | t1.f) then c else 11 end FROM t1 WHERE case when (+e | (t1.e) | 11)<>b then t1.b when t1.e<>~(case when (t1.a*b) in (select d from t1 union select b from t1) or t1.c not in (t1.a,t1.d,13) and t1.f in (select case min(19) when min(17) then min(19) else count(distinct t1.e) end from t1 union select (count(*)) from t1) then t1.f else b end)+11 then b else 13 end+t1.d between b and 17"
    end, {
        -- <randexpr-2.972>
        
        -- </randexpr-2.972>
    })

test:do_test(
    "randexpr-2.973",
    function()
        return test:execsql "SELECT 13 | t1.c+case when (not t1.d-c between +t1.b and  -coalesce((select (select count(distinct 17) from t1)*a from t1 where  -case when not t1.f in (select count(distinct 13) from t1 union select min( -t1.a) from t1) then case when (t1.e)< -11 then  -c else t1.a end else d end-c*t1.a-d+ -e-t1.a not in (17,e,t1.a)),b) | t1.f) then c else 11 end FROM t1 WHERE NOT (case when (+e | (t1.e) | 11)<>b then t1.b when t1.e<>~(case when (t1.a*b) in (select d from t1 union select b from t1) or t1.c not in (t1.a,t1.d,13) and t1.f in (select case min(19) when min(17) then min(19) else count(distinct t1.e) end from t1 union select (count(*)) from t1) then t1.f else b end)+11 then b else 13 end+t1.d between b and 17)"
    end, {
        -- <randexpr-2.973>
        605
        -- </randexpr-2.973>
    })

test:do_test(
    "randexpr-2.974",
    function()
        return test:execsql "SELECT 13 & t1.c+case when (not t1.d-c between +t1.b and  -coalesce((select (select count(distinct 17) from t1)*a from t1 where  -case when not t1.f in (select count(distinct 13) from t1 union select min( -t1.a) from t1) then case when (t1.e)< -11 then  -c else t1.a end else d end-c*t1.a-d+ -e-t1.a not in (17,e,t1.a)),b) & t1.f) then c else 11 end FROM t1 WHERE NOT (case when (+e | (t1.e) | 11)<>b then t1.b when t1.e<>~(case when (t1.a*b) in (select d from t1 union select b from t1) or t1.c not in (t1.a,t1.d,13) and t1.f in (select case min(19) when min(17) then min(19) else count(distinct t1.e) end from t1 union select (count(*)) from t1) then t1.f else b end)+11 then b else 13 end+t1.d between b and 17)"
    end, {
        -- <randexpr-2.974>
        8
        -- </randexpr-2.974>
    })

test:do_test(
    "randexpr-2.975",
    function()
        return test:execsql "SELECT case when case when t1.a<>t1.d then d*t1.a*11-e-(+11+d)-e else (select case  -count(distinct t1.e) when cast(avg(b) AS integer) then count(distinct t1.d) else cast(avg(13) AS integer) end*cast(avg(19) AS integer) from t1) end<>case e when e then t1.e else (t1.f) end or not exists(select 1 from t1 where 19=f) and  -t1.d>t1.e then t1.e+e*e when 11=t1.c then e else c end FROM t1 WHERE ~c>(case when t1.e<=e then case when case when 17+f in (d,t1.d | t1.c,t1.b) and 13<>19 or not t1.c<f then coalesce((select max(b) from t1 where c not between b and t1.c),c)+(17) when d<=t1.c then t1.b else t1.c end-b not in (a,f,11) then c else 17 end else f end)"
    end, {
        -- <randexpr-2.975>
        
        -- </randexpr-2.975>
    })

test:do_test(
    "randexpr-2.976",
    function()
        return test:execsql "SELECT case when case when t1.a<>t1.d then d*t1.a*11-e-(+11+d)-e else (select case  -count(distinct t1.e) when cast(avg(b) AS integer) then count(distinct t1.d) else cast(avg(13) AS integer) end*cast(avg(19) AS integer) from t1) end<>case e when e then t1.e else (t1.f) end or not exists(select 1 from t1 where 19=f) and  -t1.d>t1.e then t1.e+e*e when 11=t1.c then e else c end FROM t1 WHERE NOT (~c>(case when t1.e<=e then case when case when 17+f in (d,t1.d | t1.c,t1.b) and 13<>19 or not t1.c<f then coalesce((select max(b) from t1 where c not between b and t1.c),c)+(17) when d<=t1.c then t1.b else t1.c end-b not in (a,f,11) then c else 17 end else f end))"
    end, {
        -- <randexpr-2.976>
        250500
        -- </randexpr-2.976>
    })

test:do_test(
    "randexpr-2.977",
    function()
        return test:execsql "SELECT case when (13 in (select ~t1.c from t1 union select case when t1.a in (select t1.f-t1.e | t1.c+19 from t1 union select coalesce((select max(13) from t1 where e in (select ~19-(select case count(*)-cast(avg(c) AS integer) when cast(avg(t1.f) AS integer) then  -max(d) else min(t1.d) end | ( -cast(avg(t1.a) AS integer)) from t1)-b*d-coalesce((select max(f) from t1 where not t1.c=c),b) from t1 union select 13 from t1)),a) from t1) then t1.c else t1.b end from t1)) then (abs(c)/abs(19)) else c end FROM t1 WHERE coalesce((select  -case (select count(*) from t1) when d*+b then a else d end from t1 where b not in (11*case t1.e when case +coalesce((select b+19*+case t1.c when t1.a then t1.b else t1.f end*f*11 from t1 where t1.a=t1.f),c) when t1.e then 17 else d end then t1.f else t1.b end,f,d)),t1.d) in (13,e, -b)"
    end, {
        -- <randexpr-2.977>
        
        -- </randexpr-2.977>
    })

test:do_test(
    "randexpr-2.978",
    function()
        return test:execsql "SELECT case when (13 in (select ~t1.c from t1 union select case when t1.a in (select t1.f-t1.e | t1.c+19 from t1 union select coalesce((select max(13) from t1 where e in (select ~19-(select case count(*)-cast(avg(c) AS integer) when cast(avg(t1.f) AS integer) then  -max(d) else min(t1.d) end | ( -cast(avg(t1.a) AS integer)) from t1)-b*d-coalesce((select max(f) from t1 where not t1.c=c),b) from t1 union select 13 from t1)),a) from t1) then t1.c else t1.b end from t1)) then (abs(c)/abs(19)) else c end FROM t1 WHERE NOT (coalesce((select  -case (select count(*) from t1) when d*+b then a else d end from t1 where b not in (11*case t1.e when case +coalesce((select b+19*+case t1.c when t1.a then t1.b else t1.f end*f*11 from t1 where t1.a=t1.f),c) when t1.e then 17 else d end then t1.f else t1.b end,f,d)),t1.d) in (13,e, -b))"
    end, {
        -- <randexpr-2.978>
        300
        -- </randexpr-2.978>
    })

test:do_test(
    "randexpr-2.979",
    function()
        return test:execsql "SELECT case when (13 in (select ~t1.c from t1 union select case when t1.a in (select t1.f-t1.e & t1.c+19 from t1 union select coalesce((select max(13) from t1 where e in (select ~19-(select case count(*)-cast(avg(c) AS integer) when cast(avg(t1.f) AS integer) then  -max(d) else min(t1.d) end & ( -cast(avg(t1.a) AS integer)) from t1)-b*d-coalesce((select max(f) from t1 where not t1.c=c),b) from t1 union select 13 from t1)),a) from t1) then t1.c else t1.b end from t1)) then (abs(c)/abs(19)) else c end FROM t1 WHERE NOT (coalesce((select  -case (select count(*) from t1) when d*+b then a else d end from t1 where b not in (11*case t1.e when case +coalesce((select b+19*+case t1.c when t1.a then t1.b else t1.f end*f*11 from t1 where t1.a=t1.f),c) when t1.e then 17 else d end then t1.f else t1.b end,f,d)),t1.d) in (13,e, -b))"
    end, {
        -- <randexpr-2.979>
        300
        -- </randexpr-2.979>
    })

test:do_test(
    "randexpr-2.980",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where ((coalesce((select d from t1 where t1.e-f | +t1.d between t1.c and t1.a or exists(select 1 from t1 where 19 in (11,11,13)) and 17 in (select case min(d) when count(*) then (min(13)) else  -(cast(avg( -c) AS integer)) end*count(distinct 19) from t1 union select count(distinct e) from t1)),f) | c*b<= -b or not not t1.c<13 or (t1.f)>=t1.f))) and t1.c not in (17,b,e) then a else (select count(distinct t1.d) from t1) end FROM t1 WHERE (select (count(*)) from t1) between 11 and t1.d"
    end, {
        -- <randexpr-2.980>
        
        -- </randexpr-2.980>
    })

test:do_test(
    "randexpr-2.981",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where ((coalesce((select d from t1 where t1.e-f | +t1.d between t1.c and t1.a or exists(select 1 from t1 where 19 in (11,11,13)) and 17 in (select case min(d) when count(*) then (min(13)) else  -(cast(avg( -c) AS integer)) end*count(distinct 19) from t1 union select count(distinct e) from t1)),f) | c*b<= -b or not not t1.c<13 or (t1.f)>=t1.f))) and t1.c not in (17,b,e) then a else (select count(distinct t1.d) from t1) end FROM t1 WHERE NOT ((select (count(*)) from t1) between 11 and t1.d)"
    end, {
        -- <randexpr-2.981>
        -101
        -- </randexpr-2.981>
    })

test:do_test(
    "randexpr-2.982",
    function()
        return test:execsql "SELECT ~case when exists(select 1 from t1 where ((coalesce((select d from t1 where t1.e-f & +t1.d between t1.c and t1.a or exists(select 1 from t1 where 19 in (11,11,13)) and 17 in (select case min(d) when count(*) then (min(13)) else  -(cast(avg( -c) AS integer)) end*count(distinct 19) from t1 union select count(distinct e) from t1)),f) & c*b<= -b or not not t1.c<13 or (t1.f)>=t1.f))) and t1.c not in (17,b,e) then a else (select count(distinct t1.d) from t1) end FROM t1 WHERE NOT ((select (count(*)) from t1) between 11 and t1.d)"
    end, {
        -- <randexpr-2.982>
        -101
        -- </randexpr-2.982>
    })

test:do_test(
    "randexpr-2.983",
    function()
        return test:execsql "SELECT coalesce((select max(b) from t1 where not not c*t1.e>=19 or case when 17<=t1.b and case when 13 not between d and  -f then case e when 11 then case when e in (select ( -d) from t1 union select e from t1) and 19<=(a) then t1.a else (19) end else f end else t1.a end+t1.a<19 then ~d when e in (a,11, -b) then b else e end not between f and 13),a) FROM t1 WHERE t1.a>=+a"
    end, {
        -- <randexpr-2.983>
        200
        -- </randexpr-2.983>
    })

test:do_test(
    "randexpr-2.984",
    function()
        return test:execsql "SELECT coalesce((select max(b) from t1 where not not c*t1.e>=19 or case when 17<=t1.b and case when 13 not between d and  -f then case e when 11 then case when e in (select ( -d) from t1 union select e from t1) and 19<=(a) then t1.a else (19) end else f end else t1.a end+t1.a<19 then ~d when e in (a,11, -b) then b else e end not between f and 13),a) FROM t1 WHERE NOT (t1.a>=+a)"
    end, {
        -- <randexpr-2.984>
        
        -- </randexpr-2.984>
    })

test:do_test(
    "randexpr-2.985",
    function()
        return test:execsql "SELECT case when case when 11 between a+a+t1.b and b then c*e-t1.c*t1.a when +b<= -t1.c-t1.e-19*t1.b+c*t1.b then e else d end-(11)-e<d then 11 when 13=t1.e then a else 13 end+c-d FROM t1 WHERE ~coalesce((select max((select count(*) from t1)+t1.f) from t1 where 17 in (~t1.a,d,13)), -(select max(13) from t1) | coalesce((select c from t1 where t1.e* -coalesce((select 17 from t1 where (abs(t1.a+t1.d)/abs(t1.f))*t1.e | 17 | 11 not in ((t1.d),c,t1.c)),13)*13 in (11,t1.e,a)),19)) in (13,13,c)"
    end, {
        -- <randexpr-2.985>
        
        -- </randexpr-2.985>
    })

test:do_test(
    "randexpr-2.986",
    function()
        return test:execsql "SELECT case when case when 11 between a+a+t1.b and b then c*e-t1.c*t1.a when +b<= -t1.c-t1.e-19*t1.b+c*t1.b then e else d end-(11)-e<d then 11 when 13=t1.e then a else 13 end+c-d FROM t1 WHERE NOT (~coalesce((select max((select count(*) from t1)+t1.f) from t1 where 17 in (~t1.a,d,13)), -(select max(13) from t1) | coalesce((select c from t1 where t1.e* -coalesce((select 17 from t1 where (abs(t1.a+t1.d)/abs(t1.f))*t1.e | 17 | 11 not in ((t1.d),c,t1.c)),13)*13 in (11,t1.e,a)),19)) in (13,13,c))"
    end, {
        -- <randexpr-2.986>
        -89
        -- </randexpr-2.986>
    })

test:do_test(
    "randexpr-2.987",
    function()
        return test:execsql "SELECT c-case 17 when c+b-t1.a-a*coalesce((select max(t1.c) from t1 where t1.b- -(abs(13)/abs(t1.e)) in (case t1.f when f then coalesce((select max(coalesce((select 13 from t1 where exists(select 1 from t1 where f not between e and c)),e)) from t1 where d not between t1.a and 13),d)-b else a end, -13,(t1.f)) and 13 between e and 17),a) | a then t1.d else e end+ -t1.e FROM t1 WHERE not exists(select 1 from t1 where coalesce((select  -+t1.c | case when a in (select case max(+b) when ~count(*) then count(*) else (abs((max(f)))) end from t1 union select  -max(e) from t1) then case when (t1.d>=11) or t1.c not between t1.d and  - -11 then t1.a when 11 not between  -t1.e and t1.a then 11 else t1.b end when (d not in (a,c,19)) then f else c end*17 from t1 where  -11<=t1.c),t1.c)+f not in (t1.f, -d,19))"
    end, {
        -- <randexpr-2.987>
        
        -- </randexpr-2.987>
    })

test:do_test(
    "randexpr-2.988",
    function()
        return test:execsql "SELECT c-case 17 when c+b-t1.a-a*coalesce((select max(t1.c) from t1 where t1.b- -(abs(13)/abs(t1.e)) in (case t1.f when f then coalesce((select max(coalesce((select 13 from t1 where exists(select 1 from t1 where f not between e and c)),e)) from t1 where d not between t1.a and 13),d)-b else a end, -13,(t1.f)) and 13 between e and 17),a) | a then t1.d else e end+ -t1.e FROM t1 WHERE NOT (not exists(select 1 from t1 where coalesce((select  -+t1.c | case when a in (select case max(+b) when ~count(*) then count(*) else (abs((max(f)))) end from t1 union select  -max(e) from t1) then case when (t1.d>=11) or t1.c not between t1.d and  - -11 then t1.a when 11 not between  -t1.e and t1.a then 11 else t1.b end when (d not in (a,c,19)) then f else c end*17 from t1 where  -11<=t1.c),t1.c)+f not in (t1.f, -d,19)))"
    end, {
        -- <randexpr-2.988>
        -700
        -- </randexpr-2.988>
    })

test:do_test(
    "randexpr-2.989",
    function()
        return test:execsql "SELECT c-case 17 when c+b-t1.a-a*coalesce((select max(t1.c) from t1 where t1.b- -(abs(13)/abs(t1.e)) in (case t1.f when f then coalesce((select max(coalesce((select 13 from t1 where exists(select 1 from t1 where f not between e and c)),e)) from t1 where d not between t1.a and 13),d)-b else a end, -13,(t1.f)) and 13 between e and 17),a) & a then t1.d else e end+ -t1.e FROM t1 WHERE NOT (not exists(select 1 from t1 where coalesce((select  -+t1.c | case when a in (select case max(+b) when ~count(*) then count(*) else (abs((max(f)))) end from t1 union select  -max(e) from t1) then case when (t1.d>=11) or t1.c not between t1.d and  - -11 then t1.a when 11 not between  -t1.e and t1.a then 11 else t1.b end when (d not in (a,c,19)) then f else c end*17 from t1 where  -11<=t1.c),t1.c)+f not in (t1.f, -d,19)))"
    end, {
        -- <randexpr-2.989>
        -700
        -- </randexpr-2.989>
    })

test:do_test(
    "randexpr-2.990",
    function()
        return test:execsql "SELECT (select ( -count(distinct case case a when e then c*case when e<=t1.d+b then a when (abs(t1.f)/abs(case when b-coalesce((select max(t1.f-t1.b) from t1 where not exists(select 1 from t1 where 17 in (b,13,(b)) or b in (d,c,t1.e))),t1.b) not in (d,((c)),t1.b) then  -19 when c between a and 13 then 19 else t1.f end))=13 then f else 13 end else 17 end when 13 then t1.f else t1.b end-t1.c)) from t1) FROM t1 WHERE coalesce((select max(t1.d) from t1 where t1.c<>t1.c-13),t1.a)>=d or b*coalesce((select max((d)) from t1 where c not between +coalesce((select max(13) from t1 where e between  -(abs(( -coalesce((select max(case f when t1.f then e else  -t1.c end) from t1 where 11>e and t1.b<t1.e),t1.c)))/abs(b)) and d),a) and t1.e),t1.b)* -19 not between (17) and t1.f and (t1.e<=a)"
    end, {
        -- <randexpr-2.990>
        -1
        -- </randexpr-2.990>
    })

test:do_test(
    "randexpr-2.991",
    function()
        return test:execsql "SELECT (select ( -count(distinct case case a when e then c*case when e<=t1.d+b then a when (abs(t1.f)/abs(case when b-coalesce((select max(t1.f-t1.b) from t1 where not exists(select 1 from t1 where 17 in (b,13,(b)) or b in (d,c,t1.e))),t1.b) not in (d,((c)),t1.b) then  -19 when c between a and 13 then 19 else t1.f end))=13 then f else 13 end else 17 end when 13 then t1.f else t1.b end-t1.c)) from t1) FROM t1 WHERE NOT (coalesce((select max(t1.d) from t1 where t1.c<>t1.c-13),t1.a)>=d or b*coalesce((select max((d)) from t1 where c not between +coalesce((select max(13) from t1 where e between  -(abs(( -coalesce((select max(case f when t1.f then e else  -t1.c end) from t1 where 11>e and t1.b<t1.e),t1.c)))/abs(b)) and d),a) and t1.e),t1.b)* -19 not between (17) and t1.f and (t1.e<=a))"
    end, {
        -- <randexpr-2.991>
        
        -- </randexpr-2.991>
    })

test:do_test(
    "randexpr-2.992",
    function()
        return test:execsql "SELECT case when (11=(t1.b)) then t1.c-coalesce((select case when t1.f*c-b<>b then t1.a else e end | f from t1 where 13 in (select abs(~max((17))) from t1 union select cast(avg(t1.b) AS integer)-min(19) from t1)), -t1.a) when c<d or (e=17 or t1.f in (select min(t1.a) from t1 union select max(a) from t1)) then e else d end*b+t1.e FROM t1 WHERE (select case case case cast(avg(+(select abs(+count(distinct t1.d)-count(distinct t1.b) | max(17)) |  -cast(avg(f) AS integer)*count(*) from t1)) AS integer) when  -count(*)* - -max(b) then (count(distinct 19)) else max(t1.e) end when count(*) then count(*) else cast(avg(t1.c) AS integer) end when max(c) then (cast(avg(t1.c) AS integer)) else min(t1.f) end-max(17) | min((11)) from t1)<>+case ~e+~t1.d | 13 when case when t1.c<=t1.c or (11)=t1.a then 11 when  -11 in (17,11, -d) then t1.a else t1.b end then 19 else 13 end* -t1.c"
    end, {
        -- <randexpr-2.992>
        100500
        -- </randexpr-2.992>
    })

test:do_test(
    "randexpr-2.993",
    function()
        return test:execsql "SELECT case when (11=(t1.b)) then t1.c-coalesce((select case when t1.f*c-b<>b then t1.a else e end | f from t1 where 13 in (select abs(~max((17))) from t1 union select cast(avg(t1.b) AS integer)-min(19) from t1)), -t1.a) when c<d or (e=17 or t1.f in (select min(t1.a) from t1 union select max(a) from t1)) then e else d end*b+t1.e FROM t1 WHERE NOT ((select case case case cast(avg(+(select abs(+count(distinct t1.d)-count(distinct t1.b) | max(17)) |  -cast(avg(f) AS integer)*count(*) from t1)) AS integer) when  -count(*)* - -max(b) then (count(distinct 19)) else max(t1.e) end when count(*) then count(*) else cast(avg(t1.c) AS integer) end when max(c) then (cast(avg(t1.c) AS integer)) else min(t1.f) end-max(17) | min((11)) from t1)<>+case ~e+~t1.d | 13 when case when t1.c<=t1.c or (11)=t1.a then 11 when  -11 in (17,11, -d) then t1.a else t1.b end then 19 else 13 end* -t1.c)"
    end, {
        -- <randexpr-2.993>
        
        -- </randexpr-2.993>
    })

test:do_test(
    "randexpr-2.994",
    function()
        return test:execsql "SELECT case when (11=(t1.b)) then t1.c-coalesce((select case when t1.f*c-b<>b then t1.a else e end & f from t1 where 13 in (select abs(~max((17))) from t1 union select cast(avg(t1.b) AS integer)-min(19) from t1)), -t1.a) when c<d or (e=17 or t1.f in (select min(t1.a) from t1 union select max(a) from t1)) then e else d end*b+t1.e FROM t1 WHERE (select case case case cast(avg(+(select abs(+count(distinct t1.d)-count(distinct t1.b) | max(17)) |  -cast(avg(f) AS integer)*count(*) from t1)) AS integer) when  -count(*)* - -max(b) then (count(distinct 19)) else max(t1.e) end when count(*) then count(*) else cast(avg(t1.c) AS integer) end when max(c) then (cast(avg(t1.c) AS integer)) else min(t1.f) end-max(17) | min((11)) from t1)<>+case ~e+~t1.d | 13 when case when t1.c<=t1.c or (11)=t1.a then 11 when  -11 in (17,11, -d) then t1.a else t1.b end then 19 else 13 end* -t1.c"
    end, {
        -- <randexpr-2.994>
        100500
        -- </randexpr-2.994>
    })

test:do_test(
    "randexpr-2.995",
    function()
        return test:execsql "SELECT case when (f in (select count(distinct 17) from t1 union select count(distinct t1.b) from t1)) then d when e in (coalesce((select max(e+e) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where 11-t1.a in (select case  -max(11)-max(b) when min(t1.f) then count(distinct f) else count(distinct t1.c) end | count(*) from t1 union select min( -a) from t1)) and t1.e in (select count(distinct  -t1.e) from t1 union select count(distinct a) from t1) and d not in (b,f,t1.d)) and a between t1.c and t1.e),f),c,11) then c else t1.f end | a FROM t1 WHERE coalesce((select a from t1 where t1.a | (17-coalesce((select t1.b from t1 where ~t1.f | t1.e=d and a<=19+(select (cast(avg(c) AS integer)) from t1)),t1.c))+t1.e*t1.d+t1.c not between t1.d and 19), -t1.d) in (select (count(*)) from t1 union select (++~min(c)*+max(t1.a)+cast(avg( -(t1.e)) AS integer)) from t1)"
    end, {
        -- <randexpr-2.995>
        
        -- </randexpr-2.995>
    })

test:do_test(
    "randexpr-2.996",
    function()
        return test:execsql "SELECT case when (f in (select count(distinct 17) from t1 union select count(distinct t1.b) from t1)) then d when e in (coalesce((select max(e+e) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where 11-t1.a in (select case  -max(11)-max(b) when min(t1.f) then count(distinct f) else count(distinct t1.c) end | count(*) from t1 union select min( -a) from t1)) and t1.e in (select count(distinct  -t1.e) from t1 union select count(distinct a) from t1) and d not in (b,f,t1.d)) and a between t1.c and t1.e),f),c,11) then c else t1.f end | a FROM t1 WHERE NOT (coalesce((select a from t1 where t1.a | (17-coalesce((select t1.b from t1 where ~t1.f | t1.e=d and a<=19+(select (cast(avg(c) AS integer)) from t1)),t1.c))+t1.e*t1.d+t1.c not between t1.d and 19), -t1.d) in (select (count(*)) from t1 union select (++~min(c)*+max(t1.a)+cast(avg( -(t1.e)) AS integer)) from t1))"
    end, {
        -- <randexpr-2.996>
        636
        -- </randexpr-2.996>
    })

test:do_test(
    "randexpr-2.997",
    function()
        return test:execsql "SELECT case when (f in (select count(distinct 17) from t1 union select count(distinct t1.b) from t1)) then d when e in (coalesce((select max(e+e) from t1 where exists(select 1 from t1 where not exists(select 1 from t1 where 11-t1.a in (select case  -max(11)-max(b) when min(t1.f) then count(distinct f) else count(distinct t1.c) end & count(*) from t1 union select min( -a) from t1)) and t1.e in (select count(distinct  -t1.e) from t1 union select count(distinct a) from t1) and d not in (b,f,t1.d)) and a between t1.c and t1.e),f),c,11) then c else t1.f end & a FROM t1 WHERE NOT (coalesce((select a from t1 where t1.a | (17-coalesce((select t1.b from t1 where ~t1.f | t1.e=d and a<=19+(select (cast(avg(c) AS integer)) from t1)),t1.c))+t1.e*t1.d+t1.c not between t1.d and 19), -t1.d) in (select (count(*)) from t1 union select (++~min(c)*+max(t1.a)+cast(avg( -(t1.e)) AS integer)) from t1))"
    end, {
        -- <randexpr-2.997>
        64
        -- </randexpr-2.997>
    })

test:do_test(
    "randexpr-2.998",
    function()
        return test:execsql "SELECT case when coalesce((select t1.b from t1 where a not in (19,coalesce((select max(t1.f) from t1 where (select count(distinct t1.b) from t1) in (t1.e,t1.f*13-11,d)),(t1.f))-17*c,c) or t1.c<=11),19)>13 and f not in (t1.a,11,t1.d) then (((e))) when f=11 or f not in (a,19,17) then 13 else e end FROM t1 WHERE c in (select min(t1.a*a+(select count(distinct t1.b+(t1.a)- - -c) from t1)-t1.e) from t1 union select count(*) from t1) and c in (select min(t1.d) from t1 union select cast(avg(d) AS integer)+abs(case count(*) when count(distinct 11) then  -count(distinct 19) else count(distinct (t1.b)) end) | cast(avg((t1.c)) AS integer)+count(*) from t1) and e=13 and t1.d>c or 13 not in (17,(t1.f),t1.a) or (11)=t1.b and t1.e>=a or 11<=t1.b or d<=17"
    end, {
        -- <randexpr-2.998>
        500
        -- </randexpr-2.998>
    })

test:do_test(
    "randexpr-2.999",
    function()
        return test:execsql "SELECT case when coalesce((select t1.b from t1 where a not in (19,coalesce((select max(t1.f) from t1 where (select count(distinct t1.b) from t1) in (t1.e,t1.f*13-11,d)),(t1.f))-17*c,c) or t1.c<=11),19)>13 and f not in (t1.a,11,t1.d) then (((e))) when f=11 or f not in (a,19,17) then 13 else e end FROM t1 WHERE NOT (c in (select min(t1.a*a+(select count(distinct t1.b+(t1.a)- - -c) from t1)-t1.e) from t1 union select count(*) from t1) and c in (select min(t1.d) from t1 union select cast(avg(d) AS integer)+abs(case count(*) when count(distinct 11) then  -count(distinct 19) else count(distinct (t1.b)) end) | cast(avg((t1.c)) AS integer)+count(*) from t1) and e=13 and t1.d>c or 13 not in (17,(t1.f),t1.a) or (11)=t1.b and t1.e>=a or 11<=t1.b or d<=17)"
    end, {
        -- <randexpr-2.999>
        
        -- </randexpr-2.999>
    })

test:do_test(
    "randexpr-2.1000",
    function()
        return test:execsql "SELECT case when t1.d not between (abs(d)/abs(t1.e))+t1.f*t1.a*a and 17*e then case when 11 between a and coalesce((select max(t1.b) from t1 where (case when t1.e+(t1.b) not in (t1.e,d,f) or 13<>17 then 17 when a>e then 11 else a end in (select count(*) from t1 union select min(a) from t1))),17) then 19 when  -11 in (select t1.c from t1 union select  -19 from t1) or  - - -t1.e=t1.a then 17 else t1.a end else t1.e end FROM t1 WHERE (select +count(distinct f) from t1)-t1.f between t1.f and c"
    end, {
        -- <randexpr-2.1000>
        
        -- </randexpr-2.1000>
    })

test:do_test(
    "randexpr-2.1001",
    function()
        return test:execsql "SELECT case when t1.d not between (abs(d)/abs(t1.e))+t1.f*t1.a*a and 17*e then case when 11 between a and coalesce((select max(t1.b) from t1 where (case when t1.e+(t1.b) not in (t1.e,d,f) or 13<>17 then 17 when a>e then 11 else a end in (select count(*) from t1 union select min(a) from t1))),17) then 19 when  -11 in (select t1.c from t1 union select  -19 from t1) or  - - -t1.e=t1.a then 17 else t1.a end else t1.e end FROM t1 WHERE NOT ((select +count(distinct f) from t1)-t1.f between t1.f and c)"
    end, {
        -- <randexpr-2.1001>
        100
        -- </randexpr-2.1001>
    })

test:do_test(
    "randexpr-2.1002",
    function()
        return test:execsql "SELECT case when (case when e between t1.b and c+(select cast(avg( -case c when a then t1.f+c else 17 end) AS integer) from t1) then t1.e when not 19>=t1.a then 17 else d end in (select cast(avg(13) AS integer)-max(11) | +count(*) from t1 union select case (cast(avg(d) AS integer)) when min(a) then abs( -max(19)) else count(*) end from t1)) then (t1.a) else c end |  -e*a FROM t1 WHERE f*t1.d*(abs(case d when coalesce((select max((abs(t1.e)/abs(t1.f))) from t1 where ((e between (b) and 13) or t1.d=(c)) and t1.f between 17 and t1.e),a) then  -b else  -e end+ -t1.e)/abs(t1.c))+f<=17 or t1.f not between f and t1.e or (t1.c in (select 17 from t1 union select f from t1)) or exists(select 1 from t1 where (a not in (d,t1.a,t1.e) and t1.a in (t1.a,c,19))) and f not in (t1.d,t1.c,c)"
    end, {
        -- <randexpr-2.1002>
        -49732
        -- </randexpr-2.1002>
    })

test:do_test(
    "randexpr-2.1003",
    function()
        return test:execsql "SELECT case when (case when e between t1.b and c+(select cast(avg( -case c when a then t1.f+c else 17 end) AS integer) from t1) then t1.e when not 19>=t1.a then 17 else d end in (select cast(avg(13) AS integer)-max(11) | +count(*) from t1 union select case (cast(avg(d) AS integer)) when min(a) then abs( -max(19)) else count(*) end from t1)) then (t1.a) else c end |  -e*a FROM t1 WHERE NOT (f*t1.d*(abs(case d when coalesce((select max((abs(t1.e)/abs(t1.f))) from t1 where ((e between (b) and 13) or t1.d=(c)) and t1.f between 17 and t1.e),a) then  -b else  -e end+ -t1.e)/abs(t1.c))+f<=17 or t1.f not between f and t1.e or (t1.c in (select 17 from t1 union select f from t1)) or exists(select 1 from t1 where (a not in (d,t1.a,t1.e) and t1.a in (t1.a,c,19))) and f not in (t1.d,t1.c,c))"
    end, {
        -- <randexpr-2.1003>
        
        -- </randexpr-2.1003>
    })

test:do_test(
    "randexpr-2.1004",
    function()
        return test:execsql "SELECT case when (case when e between t1.b and c+(select cast(avg( -case c when a then t1.f+c else 17 end) AS integer) from t1) then t1.e when not 19>=t1.a then 17 else d end in (select cast(avg(13) AS integer)-max(11) & +count(*) from t1 union select case (cast(avg(d) AS integer)) when min(a) then abs( -max(19)) else count(*) end from t1)) then (t1.a) else c end &  -e*a FROM t1 WHERE f*t1.d*(abs(case d when coalesce((select max((abs(t1.e)/abs(t1.f))) from t1 where ((e between (b) and 13) or t1.d=(c)) and t1.f between 17 and t1.e),a) then  -b else  -e end+ -t1.e)/abs(t1.c))+f<=17 or t1.f not between f and t1.e or (t1.c in (select 17 from t1 union select f from t1)) or exists(select 1 from t1 where (a not in (d,t1.a,t1.e) and t1.a in (t1.a,c,19))) and f not in (t1.d,t1.c,c)"
    end, {
        -- <randexpr-2.1004>
        32
        -- </randexpr-2.1004>
    })

test:do_test(
    "randexpr-2.1005",
    function()
        return test:execsql "SELECT  -case coalesce((select case when f<>t1.d | c-(e)*t1.b and 17 in (select t1.b from t1 union select  -(t1.c) from t1) or t1.e>=11 and t1.f not between b and f or e not in (11,19,t1.e) and t1.c<=a then coalesce((select max(t1.f+t1.f) from t1 where  -t1.a<t1.f),t1.c) when e not in (t1.c,t1.d,t1.e) then t1.f else t1.e end-d from t1 where e>=13),e) when t1.e then c else t1.a end FROM t1 WHERE coalesce((select t1.f from t1 where (t1.e>=case (abs(11)/abs(t1.a)) when 11 then case t1.c when t1.a then t1.e else a end else t1.f end+t1.d) and (exists(select 1 from t1 where t1.b not in (t1.b,a,19))) or t1.a>=11),(select abs((~cast(avg(t1.b) AS integer)-~cast(avg((t1.b)) AS integer)* -count(*))+ -count(distinct t1.b)) from t1)*19)<=f and b in (select count(*) from t1 union select  -min(d) from t1)"
    end, {
        -- <randexpr-2.1005>
        
        -- </randexpr-2.1005>
    })

test:do_test(
    "randexpr-2.1006",
    function()
        return test:execsql "SELECT  -case coalesce((select case when f<>t1.d | c-(e)*t1.b and 17 in (select t1.b from t1 union select  -(t1.c) from t1) or t1.e>=11 and t1.f not between b and f or e not in (11,19,t1.e) and t1.c<=a then coalesce((select max(t1.f+t1.f) from t1 where  -t1.a<t1.f),t1.c) when e not in (t1.c,t1.d,t1.e) then t1.f else t1.e end-d from t1 where e>=13),e) when t1.e then c else t1.a end FROM t1 WHERE NOT (coalesce((select t1.f from t1 where (t1.e>=case (abs(11)/abs(t1.a)) when 11 then case t1.c when t1.a then t1.e else a end else t1.f end+t1.d) and (exists(select 1 from t1 where t1.b not in (t1.b,a,19))) or t1.a>=11),(select abs((~cast(avg(t1.b) AS integer)-~cast(avg((t1.b)) AS integer)* -count(*))+ -count(distinct t1.b)) from t1)*19)<=f and b in (select count(*) from t1 union select  -min(d) from t1))"
    end, {
        -- <randexpr-2.1006>
        -100
        -- </randexpr-2.1006>
    })

test:do_test(
    "randexpr-2.1007",
    function()
        return test:execsql "SELECT  -case coalesce((select case when f<>t1.d & c-(e)*t1.b and 17 in (select t1.b from t1 union select  -(t1.c) from t1) or t1.e>=11 and t1.f not between b and f or e not in (11,19,t1.e) and t1.c<=a then coalesce((select max(t1.f+t1.f) from t1 where  -t1.a<t1.f),t1.c) when e not in (t1.c,t1.d,t1.e) then t1.f else t1.e end-d from t1 where e>=13),e) when t1.e then c else t1.a end FROM t1 WHERE NOT (coalesce((select t1.f from t1 where (t1.e>=case (abs(11)/abs(t1.a)) when 11 then case t1.c when t1.a then t1.e else a end else t1.f end+t1.d) and (exists(select 1 from t1 where t1.b not in (t1.b,a,19))) or t1.a>=11),(select abs((~cast(avg(t1.b) AS integer)-~cast(avg((t1.b)) AS integer)* -count(*))+ -count(distinct t1.b)) from t1)*19)<=f and b in (select count(*) from t1 union select  -min(d) from t1))"
    end, {
        -- <randexpr-2.1007>
        -100
        -- </randexpr-2.1007>
    })

test:do_test(
    "randexpr-2.1008",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where exists(select 1 from t1 where  -case when t1.d<=coalesce((select t1.d | (f)*t1.a from t1 where not exists(select 1 from t1 where t1.f not in ((e),t1.e,13) or t1.a not between a and  -t1.d or (f) not between f and 13)),19) then e when (t1.f)<19 or e<=d then b else d end in (select case ~ -(cast(avg(b) AS integer)*cast(avg(t1.b) AS integer)*min(t1.f)) | count(*) when min(t1.c) then ( - -count(distinct  -d)) else count(*) end from t1 union select cast(avg(f) AS integer) from t1) and b<a)) then t1.b else t1.d end FROM t1 WHERE case case when case when not d<t1.a+t1.d+t1.c then ~f when ((not exists(select 1 from t1 where 19 in ( -(t1.f),17, -e)))) or f not between a and a then t1.f else 19 end in (select min(e)-~ -count(*)*(count(*))+count(*)*min(e) from t1 union select  -( -( -count(*))) from t1) then 11 when e<=f then 17 else 13 end+(19)+f when c then b else c end<>t1.b or 19<>t1.f"
    end, {
        -- <randexpr-2.1008>
        400
        -- </randexpr-2.1008>
    })

test:do_test(
    "randexpr-2.1009",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where exists(select 1 from t1 where  -case when t1.d<=coalesce((select t1.d | (f)*t1.a from t1 where not exists(select 1 from t1 where t1.f not in ((e),t1.e,13) or t1.a not between a and  -t1.d or (f) not between f and 13)),19) then e when (t1.f)<19 or e<=d then b else d end in (select case ~ -(cast(avg(b) AS integer)*cast(avg(t1.b) AS integer)*min(t1.f)) | count(*) when min(t1.c) then ( - -count(distinct  -d)) else count(*) end from t1 union select cast(avg(f) AS integer) from t1) and b<a)) then t1.b else t1.d end FROM t1 WHERE NOT (case case when case when not d<t1.a+t1.d+t1.c then ~f when ((not exists(select 1 from t1 where 19 in ( -(t1.f),17, -e)))) or f not between a and a then t1.f else 19 end in (select min(e)-~ -count(*)*(count(*))+count(*)*min(e) from t1 union select  -( -( -count(*))) from t1) then 11 when e<=f then 17 else 13 end+(19)+f when c then b else c end<>t1.b or 19<>t1.f)"
    end, {
        -- <randexpr-2.1009>
        
        -- </randexpr-2.1009>
    })

test:do_test(
    "randexpr-2.1010",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where exists(select 1 from t1 where  -case when t1.d<=coalesce((select t1.d & (f)*t1.a from t1 where not exists(select 1 from t1 where t1.f not in ((e),t1.e,13) or t1.a not between a and  -t1.d or (f) not between f and 13)),19) then e when (t1.f)<19 or e<=d then b else d end in (select case ~ -(cast(avg(b) AS integer)*cast(avg(t1.b) AS integer)*min(t1.f)) & count(*) when min(t1.c) then ( - -count(distinct  -d)) else count(*) end from t1 union select cast(avg(f) AS integer) from t1) and b<a)) then t1.b else t1.d end FROM t1 WHERE case case when case when not d<t1.a+t1.d+t1.c then ~f when ((not exists(select 1 from t1 where 19 in ( -(t1.f),17, -e)))) or f not between a and a then t1.f else 19 end in (select min(e)-~ -count(*)*(count(*))+count(*)*min(e) from t1 union select  -( -( -count(*))) from t1) then 11 when e<=f then 17 else 13 end+(19)+f when c then b else c end<>t1.b or 19<>t1.f"
    end, {
        -- <randexpr-2.1010>
        400
        -- </randexpr-2.1010>
    })

test:do_test(
    "randexpr-2.1011",
    function()
        return test:execsql "SELECT case when ~+11<>f then case e when 11 then coalesce((select case d when t1.e-coalesce((select a+t1.c from t1 where (d) in (select +min(t1.f)+count(*) from t1 union select count(distinct t1.e) from t1)),t1.f) then t1.c else d end from t1 where t1.f in (select t1.f from t1 union select b from t1) or (t1.a not in ( -a,t1.a,t1.b))),t1.c) else t1.f end-t1.f when not exists(select 1 from t1 where b between f and t1.a) then t1.c else t1.f end FROM t1 WHERE t1.a<=coalesce((select max(b) from t1 where coalesce((select t1.c*case when coalesce((select max((select count(*) from t1)) from t1 where not not exists(select 1 from t1 where case t1.b | a when t1.f then c else 11 end<>f and 13>=13 and f between t1.b and c)),13)=case e when a then 19 else d end then t1.b when t1.a not in (a,t1.b,a) then e else b end-d from t1 where t1.f between t1.d and t1.e),e)>t1.f),17)+t1.f"
    end, {
        -- <randexpr-2.1011>
        0
        -- </randexpr-2.1011>
    })

test:do_test(
    "randexpr-2.1012",
    function()
        return test:execsql "SELECT case when ~+11<>f then case e when 11 then coalesce((select case d when t1.e-coalesce((select a+t1.c from t1 where (d) in (select +min(t1.f)+count(*) from t1 union select count(distinct t1.e) from t1)),t1.f) then t1.c else d end from t1 where t1.f in (select t1.f from t1 union select b from t1) or (t1.a not in ( -a,t1.a,t1.b))),t1.c) else t1.f end-t1.f when not exists(select 1 from t1 where b between f and t1.a) then t1.c else t1.f end FROM t1 WHERE NOT (t1.a<=coalesce((select max(b) from t1 where coalesce((select t1.c*case when coalesce((select max((select count(*) from t1)) from t1 where not not exists(select 1 from t1 where case t1.b | a when t1.f then c else 11 end<>f and 13>=13 and f between t1.b and c)),13)=case e when a then 19 else d end then t1.b when t1.a not in (a,t1.b,a) then e else b end-d from t1 where t1.f between t1.d and t1.e),e)>t1.f),17)+t1.f)"
    end, {
        -- <randexpr-2.1012>
        
        -- </randexpr-2.1012>
    })

test:do_test(
    "randexpr-2.1013",
    function()
        return test:execsql "SELECT (abs(d)/abs(t1.f++(select cast(avg(coalesce((select max(b) from t1 where case when t1.a*+(abs( -t1.b)/abs((select cast(avg(13) AS integer) from t1)))<=(t1.c-t1.d- -t1.c) then case d when 17 then  -t1.d else f end when t1.b between t1.b and t1.b then a else t1.d end in (select count(*) from t1 union select abs(cast(avg(13) AS integer)) | min(t1.c) from t1) or ((13))>=b),17)) AS integer) from t1)+13)) FROM t1 WHERE coalesce((select +t1.a from t1 where not exists(select 1 from t1 where (select cast(avg(13) AS integer) from t1)<=(abs( -11)/abs(t1.f))*coalesce((select t1.e from t1 where not t1.f in (select max(+b-t1.d) from t1 union select + -(abs(cast(avg((t1.b)) AS integer)))-+count(*)-(min(13)) from t1)),d+t1.d*t1.d) | (17)-t1.b)),f) in (select max(t1.c) from t1 union select count(distinct f) from t1)"
    end, {
        -- <randexpr-2.1013>
        
        -- </randexpr-2.1013>
    })

test:do_test(
    "randexpr-2.1014",
    function()
        return test:execsql "SELECT (abs(d)/abs(t1.f++(select cast(avg(coalesce((select max(b) from t1 where case when t1.a*+(abs( -t1.b)/abs((select cast(avg(13) AS integer) from t1)))<=(t1.c-t1.d- -t1.c) then case d when 17 then  -t1.d else f end when t1.b between t1.b and t1.b then a else t1.d end in (select count(*) from t1 union select abs(cast(avg(13) AS integer)) | min(t1.c) from t1) or ((13))>=b),17)) AS integer) from t1)+13)) FROM t1 WHERE NOT (coalesce((select +t1.a from t1 where not exists(select 1 from t1 where (select cast(avg(13) AS integer) from t1)<=(abs( -11)/abs(t1.f))*coalesce((select t1.e from t1 where not t1.f in (select max(+b-t1.d) from t1 union select + -(abs(cast(avg((t1.b)) AS integer)))-+count(*)-(min(13)) from t1)),d+t1.d*t1.d) | (17)-t1.b)),f) in (select max(t1.c) from t1 union select count(distinct f) from t1))"
    end, {
        -- <randexpr-2.1014>
        0
        -- </randexpr-2.1014>
    })

test:do_test(
    "randexpr-2.1015",
    function()
        return test:execsql "SELECT (abs(d)/abs(t1.f++(select cast(avg(coalesce((select max(b) from t1 where case when t1.a*+(abs( -t1.b)/abs((select cast(avg(13) AS integer) from t1)))<=(t1.c-t1.d- -t1.c) then case d when 17 then  -t1.d else f end when t1.b between t1.b and t1.b then a else t1.d end in (select count(*) from t1 union select abs(cast(avg(13) AS integer)) & min(t1.c) from t1) or ((13))>=b),17)) AS integer) from t1)+13)) FROM t1 WHERE NOT (coalesce((select +t1.a from t1 where not exists(select 1 from t1 where (select cast(avg(13) AS integer) from t1)<=(abs( -11)/abs(t1.f))*coalesce((select t1.e from t1 where not t1.f in (select max(+b-t1.d) from t1 union select + -(abs(cast(avg((t1.b)) AS integer)))-+count(*)-(min(13)) from t1)),d+t1.d*t1.d) | (17)-t1.b)),f) in (select max(t1.c) from t1 union select count(distinct f) from t1))"
    end, {
        -- <randexpr-2.1015>
        0
        -- </randexpr-2.1015>
    })

test:do_test(
    "randexpr-2.1016",
    function()
        return test:execsql "SELECT case t1.a when (select ~max(coalesce((select (t1.b-a*+t1.c-t1.e) from t1 where not 11*t1.f++t1.f-t1.a*f*+t1.e*t1.b>17 and 19+e not in (t1.c,t1.b,a)),19)) from t1) then 19*11 else d end | (17) | t1.d FROM t1 WHERE exists(select 1 from t1 where coalesce((select max(13) from t1 where t1.e not in (d,13-19,17) or e*19=d or ((t1.a< -t1.a or 11- -t1.d-case when 13<( -t1.e) then a else e end*t1.b+t1.e in (select t1.d from t1 union select t1.e from t1) and 19<>d))),b)+11*11=t1.e)"
    end, {
        -- <randexpr-2.1016>
        
        -- </randexpr-2.1016>
    })

test:do_test(
    "randexpr-2.1017",
    function()
        return test:execsql "SELECT case t1.a when (select ~max(coalesce((select (t1.b-a*+t1.c-t1.e) from t1 where not 11*t1.f++t1.f-t1.a*f*+t1.e*t1.b>17 and 19+e not in (t1.c,t1.b,a)),19)) from t1) then 19*11 else d end | (17) | t1.d FROM t1 WHERE NOT (exists(select 1 from t1 where coalesce((select max(13) from t1 where t1.e not in (d,13-19,17) or e*19=d or ((t1.a< -t1.a or 11- -t1.d-case when 13<( -t1.e) then a else e end*t1.b+t1.e in (select t1.d from t1 union select t1.e from t1) and 19<>d))),b)+11*11=t1.e))"
    end, {
        -- <randexpr-2.1017>
        401
        -- </randexpr-2.1017>
    })

test:do_test(
    "randexpr-2.1018",
    function()
        return test:execsql "SELECT case t1.a when (select ~max(coalesce((select (t1.b-a*+t1.c-t1.e) from t1 where not 11*t1.f++t1.f-t1.a*f*+t1.e*t1.b>17 and 19+e not in (t1.c,t1.b,a)),19)) from t1) then 19*11 else d end & (17) & t1.d FROM t1 WHERE NOT (exists(select 1 from t1 where coalesce((select max(13) from t1 where t1.e not in (d,13-19,17) or e*19=d or ((t1.a< -t1.a or 11- -t1.d-case when 13<( -t1.e) then a else e end*t1.b+t1.e in (select t1.d from t1 union select t1.e from t1) and 19<>d))),b)+11*11=t1.e))"
    end, {
        -- <randexpr-2.1018>
        16
        -- </randexpr-2.1018>
    })

test:do_test(
    "randexpr-2.1019",
    function()
        return test:execsql "SELECT t1.a-coalesce((select 11-case when 11<19-f+t1.a then a | (t1.a+++(select cast(avg((abs(t1.d | e)/abs((abs(t1.a)/abs(13))))) AS integer)-max(a) from t1)+e+13*19+t1.a-c) else 13 end+t1.e-19 from t1 where 13>t1.f),e) FROM t1 WHERE ~(abs((select max( -case when d+(11)*d between coalesce((select 11 from t1 where (t1.f)=e),d*f) and t1.e then d-case when a<> -17+(abs(t1.d)/abs(t1.f)) then t1.f else t1.e end*11+c-(c) else d end) from t1)*t1.e)/abs((t1.f)))-f<>11"
    end, {
        -- <randexpr-2.1019>
        -400
        -- </randexpr-2.1019>
    })

test:do_test(
    "randexpr-2.1020",
    function()
        return test:execsql "SELECT t1.a-coalesce((select 11-case when 11<19-f+t1.a then a | (t1.a+++(select cast(avg((abs(t1.d | e)/abs((abs(t1.a)/abs(13))))) AS integer)-max(a) from t1)+e+13*19+t1.a-c) else 13 end+t1.e-19 from t1 where 13>t1.f),e) FROM t1 WHERE NOT (~(abs((select max( -case when d+(11)*d between coalesce((select 11 from t1 where (t1.f)=e),d*f) and t1.e then d-case when a<> -17+(abs(t1.d)/abs(t1.f)) then t1.f else t1.e end*11+c-(c) else d end) from t1)*t1.e)/abs((t1.f)))-f<>11)"
    end, {
        -- <randexpr-2.1020>
        
        -- </randexpr-2.1020>
    })

test:do_test(
    "randexpr-2.1021",
    function()
        return test:execsql "SELECT t1.a-coalesce((select 11-case when 11<19-f+t1.a then a & (t1.a+++(select cast(avg((abs(t1.d & e)/abs((abs(t1.a)/abs(13))))) AS integer)-max(a) from t1)+e+13*19+t1.a-c) else 13 end+t1.e-19 from t1 where 13>t1.f),e) FROM t1 WHERE ~(abs((select max( -case when d+(11)*d between coalesce((select 11 from t1 where (t1.f)=e),d*f) and t1.e then d-case when a<> -17+(abs(t1.d)/abs(t1.f)) then t1.f else t1.e end*11+c-(c) else d end) from t1)*t1.e)/abs((t1.f)))-f<>11"
    end, {
        -- <randexpr-2.1021>
        -400
        -- </randexpr-2.1021>
    })

test:do_test(
    "randexpr-2.1022",
    function()
        return test:execsql "SELECT d | (select (cast(avg((abs(case when b*(abs((abs(case f when 17 then t1.e else t1.c end)/abs( -d)))/abs(t1.c)) in (d,a,a) then 19 when (exists(select 1 from t1 where t1.c=t1.a) or a<>d) then a else c end)/abs(t1.e))-17) AS integer)* -min(19)-count(distinct a)-+count(distinct 17)*min(t1.a)+ -cast(avg(t1.a) AS integer)- -max(17) | max(e)) from t1) FROM t1 WHERE  -f-t1.f++e+case when not (((select abs(count(*)) from t1)) not in ((case when (t1.b>t1.c) then t1.b else f end),e,13)) and not exists(select 1 from t1 where 11 in (select t1.f from t1 union select ((t1.f)) from t1)) then (t1.e)+c-c+c when  -b in (13,19,t1.c) then 17 else 13 end-d | t1.a not in (a,b,b)"
    end, {
        -- <randexpr-2.1022>
        511
        -- </randexpr-2.1022>
    })

test:do_test(
    "randexpr-2.1023",
    function()
        return test:execsql "SELECT d | (select (cast(avg((abs(case when b*(abs((abs(case f when 17 then t1.e else t1.c end)/abs( -d)))/abs(t1.c)) in (d,a,a) then 19 when (exists(select 1 from t1 where t1.c=t1.a) or a<>d) then a else c end)/abs(t1.e))-17) AS integer)* -min(19)-count(distinct a)-+count(distinct 17)*min(t1.a)+ -cast(avg(t1.a) AS integer)- -max(17) | max(e)) from t1) FROM t1 WHERE NOT ( -f-t1.f++e+case when not (((select abs(count(*)) from t1)) not in ((case when (t1.b>t1.c) then t1.b else f end),e,13)) and not exists(select 1 from t1 where 11 in (select t1.f from t1 union select ((t1.f)) from t1)) then (t1.e)+c-c+c when  -b in (13,19,t1.c) then 17 else 13 end-d | t1.a not in (a,b,b))"
    end, {
        -- <randexpr-2.1023>
        
        -- </randexpr-2.1023>
    })

test:do_test(
    "randexpr-2.1024",
    function()
        return test:execsql "SELECT d & (select (cast(avg((abs(case when b*(abs((abs(case f when 17 then t1.e else t1.c end)/abs( -d)))/abs(t1.c)) in (d,a,a) then 19 when (exists(select 1 from t1 where t1.c=t1.a) or a<>d) then a else c end)/abs(t1.e))-17) AS integer)* -min(19)-count(distinct a)-+count(distinct 17)*min(t1.a)+ -cast(avg(t1.a) AS integer)- -max(17) & max(e)) from t1) FROM t1 WHERE  -f-t1.f++e+case when not (((select abs(count(*)) from t1)) not in ((case when (t1.b>t1.c) then t1.b else f end),e,13)) and not exists(select 1 from t1 where 11 in (select t1.f from t1 union select ((t1.f)) from t1)) then (t1.e)+c-c+c when  -b in (13,19,t1.c) then 17 else 13 end-d | t1.a not in (a,b,b)"
    end, {
        -- <randexpr-2.1024>
        128
        -- </randexpr-2.1024>
    })

test:do_test(
    "randexpr-2.1025",
    function()
        return test:execsql "SELECT 11-(select min((abs(e)/abs(f*t1.e*c+17+~case when f | 11 between (select case  -max(19) when (cast(avg(t1.a) AS integer)) then count(distinct t1.f) else count(*) end from t1) and coalesce((select 13 from t1 where a<=(t1.d)),f)-a then t1.a when f in (select 17 from t1 union select  -b from t1) and t1.d<a or d<>(17) or 19>=d then (f) else 11 end))) from t1) FROM t1 WHERE e in (e, -17*t1.c*17,e)"
    end, {
        -- <randexpr-2.1025>
        11
        -- </randexpr-2.1025>
    })

test:do_test(
    "randexpr-2.1026",
    function()
        return test:execsql "SELECT 11-(select min((abs(e)/abs(f*t1.e*c+17+~case when f | 11 between (select case  -max(19) when (cast(avg(t1.a) AS integer)) then count(distinct t1.f) else count(*) end from t1) and coalesce((select 13 from t1 where a<=(t1.d)),f)-a then t1.a when f in (select 17 from t1 union select  -b from t1) and t1.d<a or d<>(17) or 19>=d then (f) else 11 end))) from t1) FROM t1 WHERE NOT (e in (e, -17*t1.c*17,e))"
    end, {
        -- <randexpr-2.1026>
        
        -- </randexpr-2.1026>
    })

test:do_test(
    "randexpr-2.1027",
    function()
        return test:execsql "SELECT 11-(select min((abs(e)/abs(f*t1.e*c+17+~case when f & 11 between (select case  -max(19) when (cast(avg(t1.a) AS integer)) then count(distinct t1.f) else count(*) end from t1) and coalesce((select 13 from t1 where a<=(t1.d)),f)-a then t1.a when f in (select 17 from t1 union select  -b from t1) and t1.d<a or d<>(17) or 19>=d then (f) else 11 end))) from t1) FROM t1 WHERE e in (e, -17*t1.c*17,e)"
    end, {
        -- <randexpr-2.1027>
        11
        -- </randexpr-2.1027>
    })

test:do_test(
    "randexpr-2.1028",
    function()
        return test:execsql "SELECT coalesce((select max( -t1.d-f+~t1.d*t1.b) from t1 where (select ~+min(t1.f)+abs(min(+(select cast(avg((b)) AS integer) from t1)-d*d))-max(f)-count(distinct 19) | count(*)*count(*) from t1)>c),case 13 when +t1.c-t1.c-t1.a then c else c end*d) FROM t1 WHERE ((t1.b>=case when not exists(select 1 from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where e>=t1.a or (coalesce((select max(coalesce((select case when a in (select t1.d from t1 union select t1.c from t1) then a when  -b in (17,c,t1.f) then f else b end from t1 where not exists(select 1 from t1 where f<=13)),17)) from t1 where t1.f>=t1.b),d) between t1.f and 11) or t1.b between 13 and t1.b))) then a when e<=17 then t1.b+ -~11 else a end and not e>= - -b or 13 not in (c,f,11)) and d not between 11 and t1.a)"
    end, {
        -- <randexpr-2.1028>
        -81200
        -- </randexpr-2.1028>
    })

test:do_test(
    "randexpr-2.1029",
    function()
        return test:execsql "SELECT coalesce((select max( -t1.d-f+~t1.d*t1.b) from t1 where (select ~+min(t1.f)+abs(min(+(select cast(avg((b)) AS integer) from t1)-d*d))-max(f)-count(distinct 19) | count(*)*count(*) from t1)>c),case 13 when +t1.c-t1.c-t1.a then c else c end*d) FROM t1 WHERE NOT (((t1.b>=case when not exists(select 1 from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where e>=t1.a or (coalesce((select max(coalesce((select case when a in (select t1.d from t1 union select t1.c from t1) then a when  -b in (17,c,t1.f) then f else b end from t1 where not exists(select 1 from t1 where f<=13)),17)) from t1 where t1.f>=t1.b),d) between t1.f and 11) or t1.b between 13 and t1.b))) then a when e<=17 then t1.b+ -~11 else a end and not e>= - -b or 13 not in (c,f,11)) and d not between 11 and t1.a))"
    end, {
        -- <randexpr-2.1029>
        
        -- </randexpr-2.1029>
    })

test:do_test(
    "randexpr-2.1030",
    function()
        return test:execsql "SELECT coalesce((select max( -t1.d-f+~t1.d*t1.b) from t1 where (select ~+min(t1.f)+abs(min(+(select cast(avg((b)) AS integer) from t1)-d*d))-max(f)-count(distinct 19) & count(*)*count(*) from t1)>c),case 13 when +t1.c-t1.c-t1.a then c else c end*d) FROM t1 WHERE ((t1.b>=case when not exists(select 1 from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where e>=t1.a or (coalesce((select max(coalesce((select case when a in (select t1.d from t1 union select t1.c from t1) then a when  -b in (17,c,t1.f) then f else b end from t1 where not exists(select 1 from t1 where f<=13)),17)) from t1 where t1.f>=t1.b),d) between t1.f and 11) or t1.b between 13 and t1.b))) then a when e<=17 then t1.b+ -~11 else a end and not e>= - -b or 13 not in (c,f,11)) and d not between 11 and t1.a)"
    end, {
        -- <randexpr-2.1030>
        120000
        -- </randexpr-2.1030>
    })

test:do_test(
    "randexpr-2.1031",
    function()
        return test:execsql "SELECT case when t1.d<>coalesce((select 13 from t1 where (d in (select case when (13<>t1.a*d-19-+11*13-t1.c) then case when t1.c=d then e else t1.b end when not exists(select 1 from t1 where 17<>t1.b) then t1.e else t1.e end | t1.a+t1.e from t1 union select t1.d from t1))),t1.f) or a> -t1.e then 11 else 17 end*d FROM t1 WHERE t1.a-d<=d-(abs(coalesce((select b from t1 where ~e<case when (case when case when d>=13 then t1.d else (t1.c) end not between t1.a and 13 then a when (17) not between 11 and t1.c then a else a end) not between 13 and t1.d then 13 else a end),19))/abs(t1.e))+t1.c+t1.e*b+c or ((17 in (select f from t1 union select t1.e from t1)))"
    end, {
        -- <randexpr-2.1031>
        4400
        -- </randexpr-2.1031>
    })

test:do_test(
    "randexpr-2.1032",
    function()
        return test:execsql "SELECT case when t1.d<>coalesce((select 13 from t1 where (d in (select case when (13<>t1.a*d-19-+11*13-t1.c) then case when t1.c=d then e else t1.b end when not exists(select 1 from t1 where 17<>t1.b) then t1.e else t1.e end | t1.a+t1.e from t1 union select t1.d from t1))),t1.f) or a> -t1.e then 11 else 17 end*d FROM t1 WHERE NOT (t1.a-d<=d-(abs(coalesce((select b from t1 where ~e<case when (case when case when d>=13 then t1.d else (t1.c) end not between t1.a and 13 then a when (17) not between 11 and t1.c then a else a end) not between 13 and t1.d then 13 else a end),19))/abs(t1.e))+t1.c+t1.e*b+c or ((17 in (select f from t1 union select t1.e from t1))))"
    end, {
        -- <randexpr-2.1032>
        
        -- </randexpr-2.1032>
    })

test:do_test(
    "randexpr-2.1033",
    function()
        return test:execsql "SELECT case when t1.d<>coalesce((select 13 from t1 where (d in (select case when (13<>t1.a*d-19-+11*13-t1.c) then case when t1.c=d then e else t1.b end when not exists(select 1 from t1 where 17<>t1.b) then t1.e else t1.e end & t1.a+t1.e from t1 union select t1.d from t1))),t1.f) or a> -t1.e then 11 else 17 end*d FROM t1 WHERE t1.a-d<=d-(abs(coalesce((select b from t1 where ~e<case when (case when case when d>=13 then t1.d else (t1.c) end not between t1.a and 13 then a when (17) not between 11 and t1.c then a else a end) not between 13 and t1.d then 13 else a end),19))/abs(t1.e))+t1.c+t1.e*b+c or ((17 in (select f from t1 union select t1.e from t1)))"
    end, {
        -- <randexpr-2.1033>
        4400
        -- </randexpr-2.1033>
    })

test:do_test(
    "randexpr-2.1034",
    function()
        return test:execsql "SELECT coalesce((select (abs(c)/abs(case when 13<=11 then t1.a when case t1.d when (11) then coalesce((select coalesce((select d-17 from t1 where t1.e=a),11) from t1 where 13 in (select t1.e from t1 union select c from t1)),19) else d end>=t1.f or 11 in (select cast(avg(t1.f) AS integer) from t1 union select ( - -count(*)) from t1) and t1.c between 13 and  -b then f else e end)) from t1 where d<=(19)),d)-t1.b FROM t1 WHERE 17>=case when t1.c not in (f,t1.a,c*17*a | t1.c-~t1.d+(+coalesce((select max(case when exists(select 1 from t1 where (t1.e in (select  -t1.e from t1 union select t1.c from t1))) then t1.b else t1.b*t1.b end) from t1 where not exists(select 1 from t1 where 17=t1.a)),d))+t1.e | (13)*t1.e+c) and e in (select  -c from t1 union select 17 from t1) then t1.d*13 else c end- -e"
    end, {
        -- <randexpr-2.1034>
        
        -- </randexpr-2.1034>
    })

test:do_test(
    "randexpr-2.1035",
    function()
        return test:execsql "SELECT coalesce((select (abs(c)/abs(case when 13<=11 then t1.a when case t1.d when (11) then coalesce((select coalesce((select d-17 from t1 where t1.e=a),11) from t1 where 13 in (select t1.e from t1 union select c from t1)),19) else d end>=t1.f or 11 in (select cast(avg(t1.f) AS integer) from t1 union select ( - -count(*)) from t1) and t1.c between 13 and  -b then f else e end)) from t1 where d<=(19)),d)-t1.b FROM t1 WHERE NOT (17>=case when t1.c not in (f,t1.a,c*17*a | t1.c-~t1.d+(+coalesce((select max(case when exists(select 1 from t1 where (t1.e in (select  -t1.e from t1 union select t1.c from t1))) then t1.b else t1.b*t1.b end) from t1 where not exists(select 1 from t1 where 17=t1.a)),d))+t1.e | (13)*t1.e+c) and e in (select  -c from t1 union select 17 from t1) then t1.d*13 else c end- -e)"
    end, {
        -- <randexpr-2.1035>
        200
        -- </randexpr-2.1035>
    })

test:do_test(
    "randexpr-2.1036",
    function()
        return test:execsql "SELECT (abs(case when t1.a in (select case when d=(select ~cast(avg(t1.a) AS integer) | ~+min(17*(abs(19)/abs(t1.a))) from t1) or 13 in (select count(distinct t1.b | 11) from t1 union select count(*) | count(distinct c) | count(distinct 17) from t1) and not b<=17 then t1.a when 11=t1.f then (abs(t1.c)/abs(11)) else f end from t1 union select c from t1) then t1.c else a end)/abs(t1.d))-t1.d FROM t1 WHERE ((abs(e)/abs(t1.a* -(coalesce((select max(t1.b-t1.d) from t1 where f>=13),~a+ -a)) | case when not exists(select 1 from t1 where coalesce((select max(c) from t1 where 19-t1.a | e<=17),~( -t1.a)) in (select f from t1 union select t1.d from t1)) then t1.d else (t1.c) end)) in (17,f,t1.a)) or 19=13 or 19=17"
    end, {
        -- <randexpr-2.1036>
        
        -- </randexpr-2.1036>
    })

test:do_test(
    "randexpr-2.1037",
    function()
        return test:execsql "SELECT (abs(case when t1.a in (select case when d=(select ~cast(avg(t1.a) AS integer) | ~+min(17*(abs(19)/abs(t1.a))) from t1) or 13 in (select count(distinct t1.b | 11) from t1 union select count(*) | count(distinct c) | count(distinct 17) from t1) and not b<=17 then t1.a when 11=t1.f then (abs(t1.c)/abs(11)) else f end from t1 union select c from t1) then t1.c else a end)/abs(t1.d))-t1.d FROM t1 WHERE NOT (((abs(e)/abs(t1.a* -(coalesce((select max(t1.b-t1.d) from t1 where f>=13),~a+ -a)) | case when not exists(select 1 from t1 where coalesce((select max(c) from t1 where 19-t1.a | e<=17),~( -t1.a)) in (select f from t1 union select t1.d from t1)) then t1.d else (t1.c) end)) in (17,f,t1.a)) or 19=13 or 19=17)"
    end, {
        -- <randexpr-2.1037>
        -400
        -- </randexpr-2.1037>
    })

test:do_test(
    "randexpr-2.1038",
    function()
        return test:execsql "SELECT (abs(case when t1.a in (select case when d=(select ~cast(avg(t1.a) AS integer) & ~+min(17*(abs(19)/abs(t1.a))) from t1) or 13 in (select count(distinct t1.b & 11) from t1 union select count(*) & count(distinct c) & count(distinct 17) from t1) and not b<=17 then t1.a when 11=t1.f then (abs(t1.c)/abs(11)) else f end from t1 union select c from t1) then t1.c else a end)/abs(t1.d))-t1.d FROM t1 WHERE NOT (((abs(e)/abs(t1.a* -(coalesce((select max(t1.b-t1.d) from t1 where f>=13),~a+ -a)) | case when not exists(select 1 from t1 where coalesce((select max(c) from t1 where 19-t1.a | e<=17),~( -t1.a)) in (select f from t1 union select t1.d from t1)) then t1.d else (t1.c) end)) in (17,f,t1.a)) or 19=13 or 19=17)"
    end, {
        -- <randexpr-2.1038>
        -400
        -- </randexpr-2.1038>
    })

test:do_test(
    "randexpr-2.1039",
    function()
        return test:execsql "SELECT case when f>coalesce((select c from t1 where coalesce((select max(c+c) from t1 where t1.f in (select  - -abs(max(19))+(min(a)) from t1 union select count(distinct  -t1.d) from t1)),e)>=e),t1.f) | t1.a | 19 or (t1.c) not in (19, - -t1.f,t1.c) or exists(select 1 from t1 where t1.b not between t1.a and  -11) then coalesce((select  -b from t1 where  -t1.a in (select c from t1 union select 17 from t1)),t1.d) when t1.a=c then c else t1.e end FROM t1 WHERE t1.e in (select +cast(avg(f) AS integer) from t1 union select case +max(19) | count(*) when count(*)*+count(*) then ~+count(*) else count(*) end from t1)"
    end, {
        -- <randexpr-2.1039>
        
        -- </randexpr-2.1039>
    })

test:do_test(
    "randexpr-2.1040",
    function()
        return test:execsql "SELECT case when f>coalesce((select c from t1 where coalesce((select max(c+c) from t1 where t1.f in (select  - -abs(max(19))+(min(a)) from t1 union select count(distinct  -t1.d) from t1)),e)>=e),t1.f) | t1.a | 19 or (t1.c) not in (19, - -t1.f,t1.c) or exists(select 1 from t1 where t1.b not between t1.a and  -11) then coalesce((select  -b from t1 where  -t1.a in (select c from t1 union select 17 from t1)),t1.d) when t1.a=c then c else t1.e end FROM t1 WHERE NOT (t1.e in (select +cast(avg(f) AS integer) from t1 union select case +max(19) | count(*) when count(*)*+count(*) then ~+count(*) else count(*) end from t1))"
    end, {
        -- <randexpr-2.1040>
        400
        -- </randexpr-2.1040>
    })

test:do_test(
    "randexpr-2.1041",
    function()
        return test:execsql "SELECT case when f>coalesce((select c from t1 where coalesce((select max(c+c) from t1 where t1.f in (select  - -abs(max(19))+(min(a)) from t1 union select count(distinct  -t1.d) from t1)),e)>=e),t1.f) & t1.a & 19 or (t1.c) not in (19, - -t1.f,t1.c) or exists(select 1 from t1 where t1.b not between t1.a and  -11) then coalesce((select  -b from t1 where  -t1.a in (select c from t1 union select 17 from t1)),t1.d) when t1.a=c then c else t1.e end FROM t1 WHERE NOT (t1.e in (select +cast(avg(f) AS integer) from t1 union select case +max(19) | count(*) when count(*)*+count(*) then ~+count(*) else count(*) end from t1))"
    end, {
        -- <randexpr-2.1041>
        400
        -- </randexpr-2.1041>
    })

test:do_test(
    "randexpr-2.1042",
    function()
        return test:execsql "SELECT +case t1.d when d then t1.f else +t1.b+(select  -count(distinct coalesce((select max(c) from t1 where exists(select 1 from t1 where 17 not between d and e)),case when t1.f+f-~17<>d then case when exists(select 1 from t1 where t1.d=(13)) then t1.e when c=t1.e then  -a else f end when not 17>11 then t1.b else e end))-max(t1.d) from t1)+ -e-(t1.d) end-11-b FROM t1 WHERE e-case +t1.e when e*e then t1.d else case (abs(case when (abs(case when t1.a+11+t1.a>11-t1.e then +t1.f when e<=a then (c) else b end)/abs(13))*b between b and t1.f then  -a else t1.c end+d)/abs(a)) when d then 13 else t1.e end end+e+t1.d<=c"
    end, {
        -- <randexpr-2.1042>
        
        -- </randexpr-2.1042>
    })

test:do_test(
    "randexpr-2.1043",
    function()
        return test:execsql "SELECT +case t1.d when d then t1.f else +t1.b+(select  -count(distinct coalesce((select max(c) from t1 where exists(select 1 from t1 where 17 not between d and e)),case when t1.f+f-~17<>d then case when exists(select 1 from t1 where t1.d=(13)) then t1.e when c=t1.e then  -a else f end when not 17>11 then t1.b else e end))-max(t1.d) from t1)+ -e-(t1.d) end-11-b FROM t1 WHERE NOT (e-case +t1.e when e*e then t1.d else case (abs(case when (abs(case when t1.a+11+t1.a>11-t1.e then +t1.f when e<=a then (c) else b end)/abs(13))*b between b and t1.f then  -a else t1.c end+d)/abs(a)) when d then 13 else t1.e end end+e+t1.d<=c)"
    end, {
        -- <randexpr-2.1043>
        389
        -- </randexpr-2.1043>
    })

test:do_test(
    "randexpr-2.1044",
    function()
        return test:execsql "SELECT + -(select count(*) from t1)*(t1.b)-a-t1.e+17*coalesce((select max(13) from t1 where not exists(select 1 from t1 where case when t1.f<coalesce((select a from t1 where t1.a not in (t1.b,t1.a,19)),t1.a)*f and not exists(select 1 from t1 where exists(select 1 from t1 where (t1.d)=19)) then +t1.d when c<>t1.d then 17 else  -17 end* -(t1.f)=(t1.a))), -d)*t1.f*t1.a* -e FROM t1 WHERE not exists(select 1 from t1 where ~case when d+ -t1.c+11*t1.e-t1.c*a*(t1.b)<=~~t1.b then f else case b when t1.b*t1.c-t1.d then c-b else  -t1.c end end-13+f>=case when d not between t1.c and (t1.b) then t1.e else t1.c end) or t1.d in (d,t1.c,t1.c)"
    end, {
        -- <randexpr-2.1044>
        -6630000800
        -- </randexpr-2.1044>
    })

test:do_test(
    "randexpr-2.1045",
    function()
        return test:execsql "SELECT + -(select count(*) from t1)*(t1.b)-a-t1.e+17*coalesce((select max(13) from t1 where not exists(select 1 from t1 where case when t1.f<coalesce((select a from t1 where t1.a not in (t1.b,t1.a,19)),t1.a)*f and not exists(select 1 from t1 where exists(select 1 from t1 where (t1.d)=19)) then +t1.d when c<>t1.d then 17 else  -17 end* -(t1.f)=(t1.a))), -d)*t1.f*t1.a* -e FROM t1 WHERE NOT (not exists(select 1 from t1 where ~case when d+ -t1.c+11*t1.e-t1.c*a*(t1.b)<=~~t1.b then f else case b when t1.b*t1.c-t1.d then c-b else  -t1.c end end-13+f>=case when d not between t1.c and (t1.b) then t1.e else t1.c end) or t1.d in (d,t1.c,t1.c))"
    end, {
        -- <randexpr-2.1045>
        
        -- </randexpr-2.1045>
    })

test:do_test(
    "randexpr-2.1046",
    function()
        return test:execsql "SELECT (abs((select  -~~ -count(*)+++count(distinct c) from t1))/abs(coalesce((select e from t1 where (case when case when b not between case t1.d when f then  -t1.c else t1.e end and c then d when b=19 then t1.c else d end in (select max(13) from t1 union select count(distinct b) from t1) and t1.d not in (a,t1.b,a) or  -t1.d between 13 and e then 17+t1.e when 19 not between t1.f and 17 then t1.b else t1.a end in (17,(t1.e),t1.a))),b) | 17)) FROM t1 WHERE 11>t1.b"
    end, {
        -- <randexpr-2.1046>
        
        -- </randexpr-2.1046>
    })

test:do_test(
    "randexpr-2.1047",
    function()
        return test:execsql "SELECT (abs((select  -~~ -count(*)+++count(distinct c) from t1))/abs(coalesce((select e from t1 where (case when case when b not between case t1.d when f then  -t1.c else t1.e end and c then d when b=19 then t1.c else d end in (select max(13) from t1 union select count(distinct b) from t1) and t1.d not in (a,t1.b,a) or  -t1.d between 13 and e then 17+t1.e when 19 not between t1.f and 17 then t1.b else t1.a end in (17,(t1.e),t1.a))),b) | 17)) FROM t1 WHERE NOT (11>t1.b)"
    end, {
        -- <randexpr-2.1047>
        0
        -- </randexpr-2.1047>
    })

test:do_test(
    "randexpr-2.1048",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d) from t1 where coalesce((select e from t1 where case when (c)<>11+case f when t1.a then (select abs( -cast(avg(t1.c) AS integer)) | max((17)) | cast(avg(t1.d) AS integer)-count(distinct e) from t1) else 17*(abs(case t1.d when t1.b then a else b end)/abs(b)) end- -c-17+c*t1.c- -t1.d then t1.c else e end>=f),d)<>t1.a), -t1.f) FROM t1 WHERE not a<=17-t1.f"
    end, {
        -- <randexpr-2.1048>
        400
        -- </randexpr-2.1048>
    })

test:do_test(
    "randexpr-2.1049",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d) from t1 where coalesce((select e from t1 where case when (c)<>11+case f when t1.a then (select abs( -cast(avg(t1.c) AS integer)) | max((17)) | cast(avg(t1.d) AS integer)-count(distinct e) from t1) else 17*(abs(case t1.d when t1.b then a else b end)/abs(b)) end- -c-17+c*t1.c- -t1.d then t1.c else e end>=f),d)<>t1.a), -t1.f) FROM t1 WHERE NOT (not a<=17-t1.f)"
    end, {
        -- <randexpr-2.1049>
        
        -- </randexpr-2.1049>
    })

test:do_test(
    "randexpr-2.1050",
    function()
        return test:execsql "SELECT coalesce((select max(t1.d) from t1 where coalesce((select e from t1 where case when (c)<>11+case f when t1.a then (select abs( -cast(avg(t1.c) AS integer)) & max((17)) & cast(avg(t1.d) AS integer)-count(distinct e) from t1) else 17*(abs(case t1.d when t1.b then a else b end)/abs(b)) end- -c-17+c*t1.c- -t1.d then t1.c else e end>=f),d)<>t1.a), -t1.f) FROM t1 WHERE not a<=17-t1.f"
    end, {
        -- <randexpr-2.1050>
        400
        -- </randexpr-2.1050>
    })

test:do_test(
    "randexpr-2.1051",
    function()
        return test:execsql "SELECT coalesce((select coalesce((select ~d from t1 where t1.b-t1.c+13 not between t1.b and (abs(t1.a-case t1.c when t1.c | (select max((abs(case when (select count(*) from t1)<>(~t1.e-13*+d+d) then  -t1.e else  -t1.f end*13)/abs(f))-t1.f) from t1) then t1.f else t1.c end)/abs(c))),t1.e) from t1 where t1.f=f), - -11) FROM t1 WHERE case ((abs(t1.e)/abs(case b when ~17 then 19+(t1.d)+13 else case t1.a*17 when c then 19*case when c<>coalesce((select max(~a) from t1 where 19<>case case when t1.d in (select +count(distinct 11) from t1 union select ( -max(a)) from t1) then t1.f else b end when t1.f then d else t1.a end-t1.b),11) then t1.b else t1.d end else 11 end end))) when t1.b then 11 else t1.d end*t1.c= -t1.f"
    end, {
        -- <randexpr-2.1051>
        
        -- </randexpr-2.1051>
    })

test:do_test(
    "randexpr-2.1052",
    function()
        return test:execsql "SELECT coalesce((select coalesce((select ~d from t1 where t1.b-t1.c+13 not between t1.b and (abs(t1.a-case t1.c when t1.c | (select max((abs(case when (select count(*) from t1)<>(~t1.e-13*+d+d) then  -t1.e else  -t1.f end*13)/abs(f))-t1.f) from t1) then t1.f else t1.c end)/abs(c))),t1.e) from t1 where t1.f=f), - -11) FROM t1 WHERE NOT (case ((abs(t1.e)/abs(case b when ~17 then 19+(t1.d)+13 else case t1.a*17 when c then 19*case when c<>coalesce((select max(~a) from t1 where 19<>case case when t1.d in (select +count(distinct 11) from t1 union select ( -max(a)) from t1) then t1.f else b end when t1.f then d else t1.a end-t1.b),11) then t1.b else t1.d end else 11 end end))) when t1.b then 11 else t1.d end*t1.c= -t1.f)"
    end, {
        -- <randexpr-2.1052>
        -401
        -- </randexpr-2.1052>
    })

test:do_test(
    "randexpr-2.1053",
    function()
        return test:execsql "SELECT coalesce((select coalesce((select ~d from t1 where t1.b-t1.c+13 not between t1.b and (abs(t1.a-case t1.c when t1.c & (select max((abs(case when (select count(*) from t1)<>(~t1.e-13*+d+d) then  -t1.e else  -t1.f end*13)/abs(f))-t1.f) from t1) then t1.f else t1.c end)/abs(c))),t1.e) from t1 where t1.f=f), - -11) FROM t1 WHERE NOT (case ((abs(t1.e)/abs(case b when ~17 then 19+(t1.d)+13 else case t1.a*17 when c then 19*case when c<>coalesce((select max(~a) from t1 where 19<>case case when t1.d in (select +count(distinct 11) from t1 union select ( -max(a)) from t1) then t1.f else b end when t1.f then d else t1.a end-t1.b),11) then t1.b else t1.d end else 11 end end))) when t1.b then 11 else t1.d end*t1.c= -t1.f)"
    end, {
        -- <randexpr-2.1053>
        -401
        -- </randexpr-2.1053>
    })

test:do_test(
    "randexpr-2.1054",
    function()
        return test:execsql "SELECT  -13-case when (not d<=11-t1.c*t1.e+t1.b) then case when t1.f | coalesce((select +d from t1 where t1.d= -c),(t1.a)) not between b and t1.a then t1.f+a when t1.a<11 and exists(select 1 from t1 where t1.f in (t1.b,17,11)) then b else 19 end when (t1.b between t1.d and e) then b else  -t1.c end FROM t1 WHERE case when b between case when coalesce((select t1.c-t1.c from t1 where 13*(select case min(11) when cast(avg(t1.c) AS integer) then (count(*)) else count(distinct 11) end+cast(avg( -f) AS integer) from t1)>=t1.a),t1.c) in ( -t1.c,d,b) then t1.e when f in (select e from t1 union select t1.d from t1) then f else c end and a and 13<>c and exists(select 1 from t1 where f<>c) then case when c in (11,b, -11) then t1.e else e end else 13 end<=t1.c"
    end, {
        -- <randexpr-2.1054>
        -713
        -- </randexpr-2.1054>
    })

test:do_test(
    "randexpr-2.1055",
    function()
        return test:execsql "SELECT  -13-case when (not d<=11-t1.c*t1.e+t1.b) then case when t1.f | coalesce((select +d from t1 where t1.d= -c),(t1.a)) not between b and t1.a then t1.f+a when t1.a<11 and exists(select 1 from t1 where t1.f in (t1.b,17,11)) then b else 19 end when (t1.b between t1.d and e) then b else  -t1.c end FROM t1 WHERE NOT (case when b between case when coalesce((select t1.c-t1.c from t1 where 13*(select case min(11) when cast(avg(t1.c) AS integer) then (count(*)) else count(distinct 11) end+cast(avg( -f) AS integer) from t1)>=t1.a),t1.c) in ( -t1.c,d,b) then t1.e when f in (select e from t1 union select t1.d from t1) then f else c end and a and 13<>c and exists(select 1 from t1 where f<>c) then case when c in (11,b, -11) then t1.e else e end else 13 end<=t1.c)"
    end, {
        -- <randexpr-2.1055>
        
        -- </randexpr-2.1055>
    })

test:do_test(
    "randexpr-2.1056",
    function()
        return test:execsql "SELECT  -13-case when (not d<=11-t1.c*t1.e+t1.b) then case when t1.f & coalesce((select +d from t1 where t1.d= -c),(t1.a)) not between b and t1.a then t1.f+a when t1.a<11 and exists(select 1 from t1 where t1.f in (t1.b,17,11)) then b else 19 end when (t1.b between t1.d and e) then b else  -t1.c end FROM t1 WHERE case when b between case when coalesce((select t1.c-t1.c from t1 where 13*(select case min(11) when cast(avg(t1.c) AS integer) then (count(*)) else count(distinct 11) end+cast(avg( -f) AS integer) from t1)>=t1.a),t1.c) in ( -t1.c,d,b) then t1.e when f in (select e from t1 union select t1.d from t1) then f else c end and a and 13<>c and exists(select 1 from t1 where f<>c) then case when c in (11,b, -11) then t1.e else e end else 13 end<=t1.c"
    end, {
        -- <randexpr-2.1056>
        -713
        -- </randexpr-2.1056>
    })

test:do_test(
    "randexpr-2.1057",
    function()
        return test:execsql "SELECT t1.b | (abs( -(select ~ -~abs(case ~min((c* -b+c))+min(f) when ~abs(count(distinct 13))+(min(13)) then max(11) else count(*) end) from t1)-11 | +(abs(t1.d-t1.e)/abs(t1.b))-t1.f*19+t1.c*17)/abs(f))+t1.b FROM t1 WHERE (a between t1.e and  -13)"
    end, {
        -- <randexpr-2.1057>
        
        -- </randexpr-2.1057>
    })

test:do_test(
    "randexpr-2.1058",
    function()
        return test:execsql "SELECT t1.b | (abs( -(select ~ -~abs(case ~min((c* -b+c))+min(f) when ~abs(count(distinct 13))+(min(13)) then max(11) else count(*) end) from t1)-11 | +(abs(t1.d-t1.e)/abs(t1.b))-t1.f*19+t1.c*17)/abs(f))+t1.b FROM t1 WHERE NOT ((a between t1.e and  -13))"
    end, {
        -- <randexpr-2.1058>
        200
        -- </randexpr-2.1058>
    })

test:do_test(
    "randexpr-2.1059",
    function()
        return test:execsql "SELECT t1.b & (abs( -(select ~ -~abs(case ~min((c* -b+c))+min(f) when ~abs(count(distinct 13))+(min(13)) then max(11) else count(*) end) from t1)-11 & +(abs(t1.d-t1.e)/abs(t1.b))-t1.f*19+t1.c*17)/abs(f))+t1.b FROM t1 WHERE NOT ((a between t1.e and  -13))"
    end, {
        -- <randexpr-2.1059>
        192
        -- </randexpr-2.1059>
    })

test:do_test(
    "randexpr-2.1060",
    function()
        return test:execsql "SELECT t1.c-case t1.b when t1.f-t1.b-f then +coalesce((select b from t1 where (t1.d in (select (select count(*)+abs(count(*)) | ~cast(avg(b | case when 11 between b and (f) then b when (19)>19 then 17 else t1.e end) AS integer) | min(d) from t1) from t1 union select 19 from t1))),(abs(c*c)/abs(11))-a-t1.c+t1.f-t1.c)+b else b end FROM t1 WHERE (t1.d)+t1.b<( -t1.b)"
    end, {
        -- <randexpr-2.1060>
        
        -- </randexpr-2.1060>
    })

test:do_test(
    "randexpr-2.1061",
    function()
        return test:execsql "SELECT t1.c-case t1.b when t1.f-t1.b-f then +coalesce((select b from t1 where (t1.d in (select (select count(*)+abs(count(*)) | ~cast(avg(b | case when 11 between b and (f) then b when (19)>19 then 17 else t1.e end) AS integer) | min(d) from t1) from t1 union select 19 from t1))),(abs(c*c)/abs(11))-a-t1.c+t1.f-t1.c)+b else b end FROM t1 WHERE NOT ((t1.d)+t1.b<( -t1.b))"
    end, {
        -- <randexpr-2.1061>
        100
        -- </randexpr-2.1061>
    })

test:do_test(
    "randexpr-2.1062",
    function()
        return test:execsql "SELECT t1.c-case t1.b when t1.f-t1.b-f then +coalesce((select b from t1 where (t1.d in (select (select count(*)+abs(count(*)) & ~cast(avg(b & case when 11 between b and (f) then b when (19)>19 then 17 else t1.e end) AS integer) & min(d) from t1) from t1 union select 19 from t1))),(abs(c*c)/abs(11))-a-t1.c+t1.f-t1.c)+b else b end FROM t1 WHERE NOT ((t1.d)+t1.b<( -t1.b))"
    end, {
        -- <randexpr-2.1062>
        100
        -- </randexpr-2.1062>
    })

test:do_test(
    "randexpr-2.1063",
    function()
        return test:execsql "SELECT 17*(select (case case min(t1.d+( -d | case 11* -11*11 when 13 then t1.c else  -17 end)-d*t1.d)-count(*)-abs( -max(17)+~max(t1.b)) | +abs(cast(avg((a)) AS integer))+(count(*)) when  -max(17) then  -max(19) else (cast(avg(d) AS integer)) end when count(distinct t1.c) then min(b) else count(*) end) from t1) FROM t1 WHERE d>=(abs(coalesce((select max(d) from t1 where not not case when a in (select count(*)* -case +min(case when t1.e<t1.e then 11 else a end-19)*case count(*) when max(13) then count(*) else min(b) end | ( -cast(avg(b) AS integer)) when max(t1.d) then (cast(avg((t1.a)) AS integer)) else min(f) end |  -max(t1.d) from t1 union select  -min(c) from t1) then e else e end<(select max(t1.c) from t1)),c++t1.f*c))/abs(e))+t1.d"
    end, {
        -- <randexpr-2.1063>
        
        -- </randexpr-2.1063>
    })

test:do_test(
    "randexpr-2.1064",
    function()
        return test:execsql "SELECT 17*(select (case case min(t1.d+( -d | case 11* -11*11 when 13 then t1.c else  -17 end)-d*t1.d)-count(*)-abs( -max(17)+~max(t1.b)) | +abs(cast(avg((a)) AS integer))+(count(*)) when  -max(17) then  -max(19) else (cast(avg(d) AS integer)) end when count(distinct t1.c) then min(b) else count(*) end) from t1) FROM t1 WHERE NOT (d>=(abs(coalesce((select max(d) from t1 where not not case when a in (select count(*)* -case +min(case when t1.e<t1.e then 11 else a end-19)*case count(*) when max(13) then count(*) else min(b) end | ( -cast(avg(b) AS integer)) when max(t1.d) then (cast(avg((t1.a)) AS integer)) else min(f) end |  -max(t1.d) from t1 union select  -min(c) from t1) then e else e end<(select max(t1.c) from t1)),c++t1.f*c))/abs(e))+t1.d)"
    end, {
        -- <randexpr-2.1064>
        17
        -- </randexpr-2.1064>
    })

test:do_test(
    "randexpr-2.1065",
    function()
        return test:execsql "SELECT 17*(select (case case min(t1.d+( -d & case 11* -11*11 when 13 then t1.c else  -17 end)-d*t1.d)-count(*)-abs( -max(17)+~max(t1.b)) & +abs(cast(avg((a)) AS integer))+(count(*)) when  -max(17) then  -max(19) else (cast(avg(d) AS integer)) end when count(distinct t1.c) then min(b) else count(*) end) from t1) FROM t1 WHERE NOT (d>=(abs(coalesce((select max(d) from t1 where not not case when a in (select count(*)* -case +min(case when t1.e<t1.e then 11 else a end-19)*case count(*) when max(13) then count(*) else min(b) end | ( -cast(avg(b) AS integer)) when max(t1.d) then (cast(avg((t1.a)) AS integer)) else min(f) end |  -max(t1.d) from t1 union select  -min(c) from t1) then e else e end<(select max(t1.c) from t1)),c++t1.f*c))/abs(e))+t1.d)"
    end, {
        -- <randexpr-2.1065>
        17
        -- </randexpr-2.1065>
    })

test:do_test(
    "randexpr-2.1066",
    function()
        return test:execsql "SELECT 11 | ~case case when e between 17 and coalesce((select max(((f-t1.f))) from t1 where d<>f),t1.f) and 11 not between 13 and 13 and ( -11<>c and t1.b>c) or 19<>t1.e and t1.b<=t1.f then +f*b when t1.d>=e then  -13 else t1.c end when b then (17) else t1.d end+a+f*a FROM t1 WHERE not exists(select 1 from t1 where a between t1.f and 17 or e>=(d)*19+t1.e*c)"
    end, {
        -- <randexpr-2.1066>
        59707
        -- </randexpr-2.1066>
    })

test:do_test(
    "randexpr-2.1067",
    function()
        return test:execsql "SELECT 11 | ~case case when e between 17 and coalesce((select max(((f-t1.f))) from t1 where d<>f),t1.f) and 11 not between 13 and 13 and ( -11<>c and t1.b>c) or 19<>t1.e and t1.b<=t1.f then +f*b when t1.d>=e then  -13 else t1.c end when b then (17) else t1.d end+a+f*a FROM t1 WHERE NOT (not exists(select 1 from t1 where a between t1.f and 17 or e>=(d)*19+t1.e*c))"
    end, {
        -- <randexpr-2.1067>
        
        -- </randexpr-2.1067>
    })

test:do_test(
    "randexpr-2.1068",
    function()
        return test:execsql "SELECT 11 & ~case case when e between 17 and coalesce((select max(((f-t1.f))) from t1 where d<>f),t1.f) and 11 not between 13 and 13 and ( -11<>c and t1.b>c) or 19<>t1.e and t1.b<=t1.f then +f*b when t1.d>=e then  -13 else t1.c end when b then (17) else t1.d end+a+f*a FROM t1 WHERE not exists(select 1 from t1 where a between t1.f and 17 or e>=(d)*19+t1.e*c)"
    end, {
        -- <randexpr-2.1068>
        3
        -- </randexpr-2.1068>
    })

test:do_test(
    "randexpr-2.1069",
    function()
        return test:execsql "SELECT  -case when t1.d | ~b<>coalesce((select max(t1.c) from t1 where t1.c not between coalesce((select max(coalesce((select max(e) from t1 where 11 not in (case when 13 not between d and c then 17 when (t1.a) not in (e,b,b) then 19 else c end,a,t1.d)),b)+f) from t1 where t1.d not in (11,f,t1.e)),t1.b) and f),11) or 11<>(d) then  -f* -d else (e) end*f FROM t1 WHERE case f when 11 then coalesce((select b from t1 where 19+case when 17*t1.d-t1.f+t1.f between t1.d-case when +d=coalesce((select max(f) from t1 where e>t1.f),17) and c=t1.e and b not in (17,11,(t1.f)) then  -17 else t1.c end and c then  -t1.a else t1.d end+11*e not between t1.f and d),13)+t1.d else  -13 end=c"
    end, {
        -- <randexpr-2.1069>
        
        -- </randexpr-2.1069>
    })

test:do_test(
    "randexpr-2.1070",
    function()
        return test:execsql "SELECT  -case when t1.d | ~b<>coalesce((select max(t1.c) from t1 where t1.c not between coalesce((select max(coalesce((select max(e) from t1 where 11 not in (case when 13 not between d and c then 17 when (t1.a) not in (e,b,b) then 19 else c end,a,t1.d)),b)+f) from t1 where t1.d not in (11,f,t1.e)),t1.b) and f),11) or 11<>(d) then  -f* -d else (e) end*f FROM t1 WHERE NOT (case f when 11 then coalesce((select b from t1 where 19+case when 17*t1.d-t1.f+t1.f between t1.d-case when +d=coalesce((select max(f) from t1 where e>t1.f),17) and c=t1.e and b not in (17,11,(t1.f)) then  -17 else t1.c end and c then  -t1.a else t1.d end+11*e not between t1.f and d),13)+t1.d else  -13 end=c)"
    end, {
        -- <randexpr-2.1070>
        -144000000
        -- </randexpr-2.1070>
    })

test:do_test(
    "randexpr-2.1071",
    function()
        return test:execsql "SELECT  -case when t1.d & ~b<>coalesce((select max(t1.c) from t1 where t1.c not between coalesce((select max(coalesce((select max(e) from t1 where 11 not in (case when 13 not between d and c then 17 when (t1.a) not in (e,b,b) then 19 else c end,a,t1.d)),b)+f) from t1 where t1.d not in (11,f,t1.e)),t1.b) and f),11) or 11<>(d) then  -f* -d else (e) end*f FROM t1 WHERE NOT (case f when 11 then coalesce((select b from t1 where 19+case when 17*t1.d-t1.f+t1.f between t1.d-case when +d=coalesce((select max(f) from t1 where e>t1.f),17) and c=t1.e and b not in (17,11,(t1.f)) then  -17 else t1.c end and c then  -t1.a else t1.d end+11*e not between t1.f and d),13)+t1.d else  -13 end=c)"
    end, {
        -- <randexpr-2.1071>
        -144000000
        -- </randexpr-2.1071>
    })

test:do_test(
    "randexpr-2.1072",
    function()
        return test:execsql "SELECT coalesce((select t1.b from t1 where not (t1.c>19) and 11<=+(abs(t1.b-19)/abs(a))+case when ((coalesce((select 13 from t1 where c in (b,t1.b,t1.d)),e))<>13) or f in ((t1.b),t1.e, -b) then 11+(c) else b end or b<>d),t1.f+t1.f+13) |  - -a FROM t1 WHERE 13 between t1.c and 13+~19+c+(select min(f-(abs(17)/abs((t1.e)))) from t1)"
    end, {
        -- <randexpr-2.1072>
        
        -- </randexpr-2.1072>
    })

test:do_test(
    "randexpr-2.1073",
    function()
        return test:execsql "SELECT coalesce((select t1.b from t1 where not (t1.c>19) and 11<=+(abs(t1.b-19)/abs(a))+case when ((coalesce((select 13 from t1 where c in (b,t1.b,t1.d)),e))<>13) or f in ((t1.b),t1.e, -b) then 11+(c) else b end or b<>d),t1.f+t1.f+13) |  - -a FROM t1 WHERE NOT (13 between t1.c and 13+~19+c+(select min(f-(abs(17)/abs((t1.e)))) from t1))"
    end, {
        -- <randexpr-2.1073>
        236
        -- </randexpr-2.1073>
    })

test:do_test(
    "randexpr-2.1074",
    function()
        return test:execsql "SELECT coalesce((select t1.b from t1 where not (t1.c>19) and 11<=+(abs(t1.b-19)/abs(a))+case when ((coalesce((select 13 from t1 where c in (b,t1.b,t1.d)),e))<>13) or f in ((t1.b),t1.e, -b) then 11+(c) else b end or b<>d),t1.f+t1.f+13) &  - -a FROM t1 WHERE NOT (13 between t1.c and 13+~19+c+(select min(f-(abs(17)/abs((t1.e)))) from t1))"
    end, {
        -- <randexpr-2.1074>
        64
        -- </randexpr-2.1074>
    })

test:do_test(
    "randexpr-2.1075",
    function()
        return test:execsql "SELECT  -(coalesce((select max(coalesce((select t1.f from t1 where not exists(select 1 from t1 where (abs(+b+19+19)/abs(t1.b))<t1.b) or 19+f>=(select  -max(19) from t1)+t1.f),t1.e+t1.f)* -t1.e+19-f) from t1 where (( -t1.c<19) or d>=c)),t1.c))*c*((t1.b))-17 FROM t1 WHERE t1.e not between t1.f*c and t1.f+ -d"
    end, {
        -- <randexpr-2.1075>
        18034859983
        -- </randexpr-2.1075>
    })

test:do_test(
    "randexpr-2.1076",
    function()
        return test:execsql "SELECT  -(coalesce((select max(coalesce((select t1.f from t1 where not exists(select 1 from t1 where (abs(+b+19+19)/abs(t1.b))<t1.b) or 19+f>=(select  -max(19) from t1)+t1.f),t1.e+t1.f)* -t1.e+19-f) from t1 where (( -t1.c<19) or d>=c)),t1.c))*c*((t1.b))-17 FROM t1 WHERE NOT (t1.e not between t1.f*c and t1.f+ -d)"
    end, {
        -- <randexpr-2.1076>
        
        -- </randexpr-2.1076>
    })

test:do_test(
    "randexpr-2.1077",
    function()
        return test:execsql "SELECT case 17 when (t1.d)*coalesce((select (select case (cast(avg(c) AS integer)+max(case when (not d+ -t1.e not between 11 and  -f) then f when b<(11) then t1.b else 11 end))+count(distinct t1.c)*max(b) when  -min(e) |  -count(distinct t1.c) then cast(avg(e) AS integer) else count(*) end from t1) from t1 where case c when a then a else t1.d end-11<>19),t1.a)+t1.b then f else t1.f end FROM t1 WHERE not exists(select 1 from t1 where exists(select 1 from t1 where (abs(d)/abs((f*+coalesce((select  -~case when exists(select 1 from t1 where b<c) then t1.b else 17 end+case (select (min(coalesce((select b from t1 where 11<>t1.c or ((t1.c))<>e),(t1.e)))) from t1)*17 when e then a else t1.e end-t1.b-19 from t1 where t1.e in (select abs(+min(f)+cast(avg( -a) AS integer)) from t1 union select count(distinct c) from t1)),d))))<>f))"
    end, {
        -- <randexpr-2.1077>
        
        -- </randexpr-2.1077>
    })

test:do_test(
    "randexpr-2.1078",
    function()
        return test:execsql "SELECT case 17 when (t1.d)*coalesce((select (select case (cast(avg(c) AS integer)+max(case when (not d+ -t1.e not between 11 and  -f) then f when b<(11) then t1.b else 11 end))+count(distinct t1.c)*max(b) when  -min(e) |  -count(distinct t1.c) then cast(avg(e) AS integer) else count(*) end from t1) from t1 where case c when a then a else t1.d end-11<>19),t1.a)+t1.b then f else t1.f end FROM t1 WHERE NOT (not exists(select 1 from t1 where exists(select 1 from t1 where (abs(d)/abs((f*+coalesce((select  -~case when exists(select 1 from t1 where b<c) then t1.b else 17 end+case (select (min(coalesce((select b from t1 where 11<>t1.c or ((t1.c))<>e),(t1.e)))) from t1)*17 when e then a else t1.e end-t1.b-19 from t1 where t1.e in (select abs(+min(f)+cast(avg( -a) AS integer)) from t1 union select count(distinct c) from t1)),d))))<>f)))"
    end, {
        -- <randexpr-2.1078>
        600
        -- </randexpr-2.1078>
    })

test:do_test(
    "randexpr-2.1079",
    function()
        return test:execsql "SELECT case 17 when (t1.d)*coalesce((select (select case (cast(avg(c) AS integer)+max(case when (not d+ -t1.e not between 11 and  -f) then f when b<(11) then t1.b else 11 end))+count(distinct t1.c)*max(b) when  -min(e) &  -count(distinct t1.c) then cast(avg(e) AS integer) else count(*) end from t1) from t1 where case c when a then a else t1.d end-11<>19),t1.a)+t1.b then f else t1.f end FROM t1 WHERE NOT (not exists(select 1 from t1 where exists(select 1 from t1 where (abs(d)/abs((f*+coalesce((select  -~case when exists(select 1 from t1 where b<c) then t1.b else 17 end+case (select (min(coalesce((select b from t1 where 11<>t1.c or ((t1.c))<>e),(t1.e)))) from t1)*17 when e then a else t1.e end-t1.b-19 from t1 where t1.e in (select abs(+min(f)+cast(avg( -a) AS integer)) from t1 union select count(distinct c) from t1)),d))))<>f)))"
    end, {
        -- <randexpr-2.1079>
        600
        -- </randexpr-2.1079>
    })

test:do_test(
    "randexpr-2.1080",
    function()
        return test:execsql "SELECT ((select  -case min(17 | (abs(a)/abs(case (select max(a) from t1)+13+t1.c when c then (abs(case when 17<>a and t1.c=d then ((17)) else e end)/abs(t1.b)) else 17 end)) | f*a) when abs(~(count(distinct t1.e))-abs((~max(c)))-count(*) | min(t1.f)+max(11)) then  -cast(avg((b)) AS integer) else min(b) end from t1))*a FROM t1 WHERE (13)-(t1.a*17-t1.b)-coalesce((select (select  -cast(avg(t1.c) AS integer)+case  - -count(*) | (count(distinct t1.a)) when  -min(t1.e) then (max(t1.d)) else count(distinct t1.b) end from t1)-e+(abs(17)/abs(e)) from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (d)>=13 and (t1.b not in (c,a, -t1.d) or t1.e in (select c from t1 union select t1.c from t1)) or 11<=t1.d))),17) in (select e from t1 union select e from t1)"
    end, {
        -- <randexpr-2.1080>
        
        -- </randexpr-2.1080>
    })

test:do_test(
    "randexpr-2.1081",
    function()
        return test:execsql "SELECT ((select  -case min(17 | (abs(a)/abs(case (select max(a) from t1)+13+t1.c when c then (abs(case when 17<>a and t1.c=d then ((17)) else e end)/abs(t1.b)) else 17 end)) | f*a) when abs(~(count(distinct t1.e))-abs((~max(c)))-count(*) | min(t1.f)+max(11)) then  -cast(avg((b)) AS integer) else min(b) end from t1))*a FROM t1 WHERE NOT ((13)-(t1.a*17-t1.b)-coalesce((select (select  -cast(avg(t1.c) AS integer)+case  - -count(*) | (count(distinct t1.a)) when  -min(t1.e) then (max(t1.d)) else count(distinct t1.b) end from t1)-e+(abs(17)/abs(e)) from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (d)>=13 and (t1.b not in (c,a, -t1.d) or t1.e in (select c from t1 union select t1.c from t1)) or 11<=t1.d))),17) in (select e from t1 union select e from t1))"
    end, {
        -- <randexpr-2.1081>
        -20000
        -- </randexpr-2.1081>
    })

test:do_test(
    "randexpr-2.1082",
    function()
        return test:execsql "SELECT ((select  -case min(17 & (abs(a)/abs(case (select max(a) from t1)+13+t1.c when c then (abs(case when 17<>a and t1.c=d then ((17)) else e end)/abs(t1.b)) else 17 end)) & f*a) when abs(~(count(distinct t1.e))-abs((~max(c)))-count(*) & min(t1.f)+max(11)) then  -cast(avg((b)) AS integer) else min(b) end from t1))*a FROM t1 WHERE NOT ((13)-(t1.a*17-t1.b)-coalesce((select (select  -cast(avg(t1.c) AS integer)+case  - -count(*) | (count(distinct t1.a)) when  -min(t1.e) then (max(t1.d)) else count(distinct t1.b) end from t1)-e+(abs(17)/abs(e)) from t1 where not exists(select 1 from t1 where not exists(select 1 from t1 where (d)>=13 and (t1.b not in (c,a, -t1.d) or t1.e in (select c from t1 union select t1.c from t1)) or 11<=t1.d))),17) in (select e from t1 union select e from t1))"
    end, {
        -- <randexpr-2.1082>
        -20000
        -- </randexpr-2.1082>
    })

test:do_test(
    "randexpr-2.1083",
    function()
        return test:execsql "SELECT case when (select  -min(11) from t1)<>(abs(17)/abs(t1.d | e)) then case 11+case 11 when b | e-e then 19+e else b end*(abs(t1.a)/abs(b | a)) | coalesce((select case when a in (select cast(avg(d) AS integer) from t1 union select  - - -max(c) from t1) or e not in (c,d,a) then +13 when t1.a>a then 19 else f end from t1 where t1.c=13 or f<>t1.e),a) when f then f else c end else t1.e end FROM t1 WHERE ~17 in (11,t1.c,19)"
    end, {
        -- <randexpr-2.1083>
        
        -- </randexpr-2.1083>
    })

test:do_test(
    "randexpr-2.1084",
    function()
        return test:execsql "SELECT case when (select  -min(11) from t1)<>(abs(17)/abs(t1.d | e)) then case 11+case 11 when b | e-e then 19+e else b end*(abs(t1.a)/abs(b | a)) | coalesce((select case when a in (select cast(avg(d) AS integer) from t1 union select  - - -max(c) from t1) or e not in (c,d,a) then +13 when t1.a>a then 19 else f end from t1 where t1.c=13 or f<>t1.e),a) when f then f else c end else t1.e end FROM t1 WHERE NOT (~17 in (11,t1.c,19))"
    end, {
        -- <randexpr-2.1084>
        300
        -- </randexpr-2.1084>
    })

test:do_test(
    "randexpr-2.1085",
    function()
        return test:execsql "SELECT case when (select  -min(11) from t1)<>(abs(17)/abs(t1.d & e)) then case 11+case 11 when b & e-e then 19+e else b end*(abs(t1.a)/abs(b & a)) & coalesce((select case when a in (select cast(avg(d) AS integer) from t1 union select  - - -max(c) from t1) or e not in (c,d,a) then +13 when t1.a>a then 19 else f end from t1 where t1.c=13 or f<>t1.e),a) when f then f else c end else t1.e end FROM t1 WHERE NOT (~17 in (11,t1.c,19))"
    end, {
        -- <randexpr-2.1085>
        300
        -- </randexpr-2.1085>
    })

test:do_test(
    "randexpr-2.1086",
    function()
        return test:execsql "SELECT (select case +cast(avg(+19) AS integer) when (abs(count(*))) then (cast(avg(e*t1.b) AS integer)) else cast(avg(t1.a) AS integer) end+count(*) | +max(f-t1.e*t1.e | (f)* -19+ -b*d) | count(*)*count(*)* -count(*) | ~count(distinct  -b)*cast(avg(t1.f) AS integer)+count(*) from t1)-t1.c+t1.b FROM t1 WHERE ((select  -count(*)+min(case ~coalesce((select max(d) from t1 where (not not exists(select 1 from t1 where t1.b not in ((select  -max(a)+(count(*)) from t1) | c+case when t1.e not in (13,e,c) then (t1.f) else t1.c end+17*c+19,c,e)))),t1.f) when (f) then t1.a else t1.f end | b | t1.a) from t1) in (c,t1.c+ -a,f))"
    end, {
        -- <randexpr-2.1086>
        
        -- </randexpr-2.1086>
    })

test:do_test(
    "randexpr-2.1087",
    function()
        return test:execsql "SELECT (select case +cast(avg(+19) AS integer) when (abs(count(*))) then (cast(avg(e*t1.b) AS integer)) else cast(avg(t1.a) AS integer) end+count(*) | +max(f-t1.e*t1.e | (f)* -19+ -b*d) | count(*)*count(*)* -count(*) | ~count(distinct  -b)*cast(avg(t1.f) AS integer)+count(*) from t1)-t1.c+t1.b FROM t1 WHERE NOT (((select  -count(*)+min(case ~coalesce((select max(d) from t1 where (not not exists(select 1 from t1 where t1.b not in ((select  -max(a)+(count(*)) from t1) | c+case when t1.e not in (13,e,c) then (t1.f) else t1.c end+17*c+19,c,e)))),t1.f) when (f) then t1.a else t1.f end | b | t1.a) from t1) in (c,t1.c+ -a,f)))"
    end, {
        -- <randexpr-2.1087>
        -101
        -- </randexpr-2.1087>
    })

test:do_test(
    "randexpr-2.1088",
    function()
        return test:execsql "SELECT (select case +cast(avg(+19) AS integer) when (abs(count(*))) then (cast(avg(e*t1.b) AS integer)) else cast(avg(t1.a) AS integer) end+count(*) & +max(f-t1.e*t1.e & (f)* -19+ -b*d) & count(*)*count(*)* -count(*) & ~count(distinct  -b)*cast(avg(t1.f) AS integer)+count(*) from t1)-t1.c+t1.b FROM t1 WHERE NOT (((select  -count(*)+min(case ~coalesce((select max(d) from t1 where (not not exists(select 1 from t1 where t1.b not in ((select  -max(a)+(count(*)) from t1) | c+case when t1.e not in (13,e,c) then (t1.f) else t1.c end+17*c+19,c,e)))),t1.f) when (f) then t1.a else t1.f end | b | t1.a) from t1) in (c,t1.c+ -a,f)))"
    end, {
        -- <randexpr-2.1088>
        -36
        -- </randexpr-2.1088>
    })

test:do_test(
    "randexpr-2.1089",
    function()
        return test:execsql "SELECT (coalesce((select (select  -~+ -abs(case cast(avg(a*t1.d) AS integer) when case ~case count(distinct ((abs(t1.a)/abs(d)))) when case cast(avg(17) AS integer)-count(*) when  -count(*) then count(distinct d) else (max(t1.d)) end*count(*) then count(distinct t1.c) else min(19) end-count(*) when cast(avg(t1.a) AS integer) then ((count(*))) else min(a) end then (count(*)) else max(e) end)*(count(*))*max(a) from t1) from t1 where (19>=(17))),d)) FROM t1 WHERE exists(select 1 from t1 where 19 in (t1.a*coalesce((select a from t1 where (11<case a when (t1.e+c-t1.a) then t1.b else t1.c end) or d between +t1.e-+coalesce((select max(coalesce((select (select cast(avg((19)) AS integer) from t1) from t1 where t1.e>t1.b),t1.e)) from t1 where e not between 13 and t1.c),(a))-t1.d and 13),13*b)-17, -b,17))"
    end, {
        -- <randexpr-2.1089>
        
        -- </randexpr-2.1089>
    })

test:do_test(
    "randexpr-2.1090",
    function()
        return test:execsql "SELECT (coalesce((select (select  -~+ -abs(case cast(avg(a*t1.d) AS integer) when case ~case count(distinct ((abs(t1.a)/abs(d)))) when case cast(avg(17) AS integer)-count(*) when  -count(*) then count(distinct d) else (max(t1.d)) end*count(*) then count(distinct t1.c) else min(19) end-count(*) when cast(avg(t1.a) AS integer) then ((count(*))) else min(a) end then (count(*)) else max(e) end)*(count(*))*max(a) from t1) from t1 where (19>=(17))),d)) FROM t1 WHERE NOT (exists(select 1 from t1 where 19 in (t1.a*coalesce((select a from t1 where (11<case a when (t1.e+c-t1.a) then t1.b else t1.c end) or d between +t1.e-+coalesce((select max(coalesce((select (select cast(avg((19)) AS integer) from t1) from t1 where t1.e>t1.b),t1.e)) from t1 where e not between 13 and t1.c),(a))-t1.d and 13),13*b)-17, -b,17)))"
    end, {
        -- <randexpr-2.1090>
        -49900
        -- </randexpr-2.1090>
    })

test:do_test(
    "randexpr-2.1091",
    function()
        return test:execsql "SELECT case when (coalesce((select max((select +max(c) from t1)) from t1 where t1.c<>t1.a),d) not in (t1.d,+case when 17>19 then e when t1.b<>+(select count(*) from t1) then t1.e else t1.d end,t1.c)) then (select count(*)-count(distinct t1.d)+ -max( -t1.c-a)*case cast(avg((f)) AS integer) when count(distinct d) then max((13)) else max(t1.d) end from t1)*t1.b else t1.c end |  -13*t1.d*t1.c FROM t1 WHERE c in (select case count(distinct ~(abs( -a)/abs(d))) when ~count(*) then ~min(coalesce((select max((abs(e)/abs(d))) from t1 where not exists(select 1 from t1 where t1.e>( -+t1.a-t1.e*17))),19))+count(*) else case ~ -cast(avg((11)) AS integer) | +cast(avg(d) AS integer) | (cast(avg(c) AS integer))+min(t1.e) when min(t1.c) then max(11) else  -count(*) end end+max(t1.c) from t1 union select  -count(*) from t1)"
    end, {
        -- <randexpr-2.1091>
        
        -- </randexpr-2.1091>
    })

test:do_test(
    "randexpr-2.1092",
    function()
        return test:execsql "SELECT case when (coalesce((select max((select +max(c) from t1)) from t1 where t1.c<>t1.a),d) not in (t1.d,+case when 17>19 then e when t1.b<>+(select count(*) from t1) then t1.e else t1.d end,t1.c)) then (select count(*)-count(distinct t1.d)+ -max( -t1.c-a)*case cast(avg((f)) AS integer) when count(distinct d) then max((13)) else max(t1.d) end from t1)*t1.b else t1.c end |  -13*t1.d*t1.c FROM t1 WHERE NOT (c in (select case count(distinct ~(abs( -a)/abs(d))) when ~count(*) then ~min(coalesce((select max((abs(e)/abs(d))) from t1 where not exists(select 1 from t1 where t1.e>( -+t1.a-t1.e*17))),19))+count(*) else case ~ -cast(avg((11)) AS integer) | +cast(avg(d) AS integer) | (cast(avg(c) AS integer))+min(t1.e) when min(t1.c) then max(11) else  -count(*) end end+max(t1.c) from t1 union select  -count(*) from t1))"
    end, {
        -- <randexpr-2.1092>
        -1559700
        -- </randexpr-2.1092>
    })

test:do_test(
    "randexpr-2.1093",
    function()
        return test:execsql "SELECT case when (coalesce((select max((select +max(c) from t1)) from t1 where t1.c<>t1.a),d) not in (t1.d,+case when 17>19 then e when t1.b<>+(select count(*) from t1) then t1.e else t1.d end,t1.c)) then (select count(*)-count(distinct t1.d)+ -max( -t1.c-a)*case cast(avg((f)) AS integer) when count(distinct d) then max((13)) else max(t1.d) end from t1)*t1.b else t1.c end &  -13*t1.d*t1.c FROM t1 WHERE NOT (c in (select case count(distinct ~(abs( -a)/abs(d))) when ~count(*) then ~min(coalesce((select max((abs(e)/abs(d))) from t1 where not exists(select 1 from t1 where t1.e>( -+t1.a-t1.e*17))),19))+count(*) else case ~ -cast(avg((11)) AS integer) | +cast(avg(d) AS integer) | (cast(avg(c) AS integer))+min(t1.e) when min(t1.c) then max(11) else  -count(*) end end+max(t1.c) from t1 union select  -count(*) from t1))"
    end, {
        -- <randexpr-2.1093>
        0
        -- </randexpr-2.1093>
    })

test:do_test(
    "randexpr-2.1094",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c+t1.b-t1.b+(abs(d++t1.f)/abs(t1.a)) | 13*17) from t1 where coalesce((select 11 from t1 where case case case c when d then t1.d else 13 end when b then  -11 else t1.b end when 13 then (t1.a) else d end not in (c,13,a)),t1.c) | f not in (t1.a,t1.c,13) and not exists(select 1 from t1 where t1.c in (select e from t1 union select  -11 from t1))),t1.f) FROM t1 WHERE (((13+coalesce((select max(13) from t1 where not exists(select 1 from t1 where ((abs(c-case when not exists(select 1 from t1 where ((f) between c and 13)) then (select case min(f) when max(17) then min(13) else min(b) end from t1) when 17 in (t1.e,13,f) then  -13 else 11 end)/abs(t1.f)) in (select min(c) from t1 union select  -count(*) | + -min(19) from t1))) and f<13),t1.e+t1.c) in (select count(distinct c)-count(*) from t1 union select  -case min((e))+cast(avg(t1.a) AS integer) when ((min(t1.c))) then count(distinct e) else  -cast(avg(t1.d) AS integer) end from t1))))"
    end, {
        -- <randexpr-2.1094>
        
        -- </randexpr-2.1094>
    })

test:do_test(
    "randexpr-2.1095",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c+t1.b-t1.b+(abs(d++t1.f)/abs(t1.a)) | 13*17) from t1 where coalesce((select 11 from t1 where case case case c when d then t1.d else 13 end when b then  -11 else t1.b end when 13 then (t1.a) else d end not in (c,13,a)),t1.c) | f not in (t1.a,t1.c,13) and not exists(select 1 from t1 where t1.c in (select e from t1 union select  -11 from t1))),t1.f) FROM t1 WHERE NOT ((((13+coalesce((select max(13) from t1 where not exists(select 1 from t1 where ((abs(c-case when not exists(select 1 from t1 where ((f) between c and 13)) then (select case min(f) when max(17) then min(13) else min(b) end from t1) when 17 in (t1.e,13,f) then  -13 else 11 end)/abs(t1.f)) in (select min(c) from t1 union select  -count(*) | + -min(19) from t1))) and f<13),t1.e+t1.c) in (select count(distinct c)-count(*) from t1 union select  -case min((e))+cast(avg(t1.a) AS integer) when ((min(t1.c))) then count(distinct e) else  -cast(avg(t1.d) AS integer) end from t1)))))"
    end, {
        -- <randexpr-2.1095>
        511
        -- </randexpr-2.1095>
    })

test:do_test(
    "randexpr-2.1096",
    function()
        return test:execsql "SELECT coalesce((select max(t1.c+t1.b-t1.b+(abs(d++t1.f)/abs(t1.a)) & 13*17) from t1 where coalesce((select 11 from t1 where case case case c when d then t1.d else 13 end when b then  -11 else t1.b end when 13 then (t1.a) else d end not in (c,13,a)),t1.c) & f not in (t1.a,t1.c,13) and not exists(select 1 from t1 where t1.c in (select e from t1 union select  -11 from t1))),t1.f) FROM t1 WHERE NOT ((((13+coalesce((select max(13) from t1 where not exists(select 1 from t1 where ((abs(c-case when not exists(select 1 from t1 where ((f) between c and 13)) then (select case min(f) when max(17) then min(13) else min(b) end from t1) when 17 in (t1.e,13,f) then  -13 else 11 end)/abs(t1.f)) in (select min(c) from t1 union select  -count(*) | + -min(19) from t1))) and f<13),t1.e+t1.c) in (select count(distinct c)-count(*) from t1 union select  -case min((e))+cast(avg(t1.a) AS integer) when ((min(t1.c))) then count(distinct e) else  -cast(avg(t1.d) AS integer) end from t1)))))"
    end, {
        -- <randexpr-2.1096>
        20
        -- </randexpr-2.1096>
    })

test:do_test(
    "randexpr-2.1097",
    function()
        return test:execsql "SELECT case when t1.a in (select t1.e*case when t1.b between t1.d and 11 or c-case when (t1.e=13) then ~e when e<>a then t1.d else t1.f end in (11,t1.e,t1.c) and 11 not between t1.a and 13 and 19<11 then 11 else t1.e end*t1.d from t1 union select t1.c from t1) then a when e between e and b then ((19)) else 11 end FROM t1 WHERE coalesce((select (select count(distinct t1.f) from t1) from t1 where case coalesce((select max(t1.d) from t1 where 17<>19),t1.d) when a then coalesce((select ~t1.f- - -c-c*17-f-c-t1.a from t1 where (t1.f) in (select max(11) from t1 union select ~cast(avg(17) AS integer) | ~count(*)+max(f)- -cast(avg(11) AS integer) from t1)),13) else e end in (a,t1.c,11)),c)>=t1.e"
    end, {
        -- <randexpr-2.1097>
        
        -- </randexpr-2.1097>
    })

test:do_test(
    "randexpr-2.1098",
    function()
        return test:execsql "SELECT case when t1.a in (select t1.e*case when t1.b between t1.d and 11 or c-case when (t1.e=13) then ~e when e<>a then t1.d else t1.f end in (11,t1.e,t1.c) and 11 not between t1.a and 13 and 19<11 then 11 else t1.e end*t1.d from t1 union select t1.c from t1) then a when e between e and b then ((19)) else 11 end FROM t1 WHERE NOT (coalesce((select (select count(distinct t1.f) from t1) from t1 where case coalesce((select max(t1.d) from t1 where 17<>19),t1.d) when a then coalesce((select ~t1.f- - -c-c*17-f-c-t1.a from t1 where (t1.f) in (select max(11) from t1 union select ~cast(avg(17) AS integer) | ~count(*)+max(f)- -cast(avg(11) AS integer) from t1)),13) else e end in (a,t1.c,11)),c)>=t1.e)"
    end, {
        -- <randexpr-2.1098>
        11
        -- </randexpr-2.1098>
    })

test:do_test(
    "randexpr-2.1099",
    function()
        return test:execsql "SELECT coalesce((select max(case t1.b+(select ~((cast(avg(17) AS integer)))*min(a)+ -count(distinct b)*cast(avg(t1.b) AS integer)-count(*)+max(19) from t1)-(e) when d then 13 else 13*c end+t1.c) from t1 where t1.b in (select +cast(avg(e) AS integer)*case count(*) when cast(avg(13) AS integer) then count(distinct t1.b) else count(*) end-(count(distinct 19))*min(t1.d) from t1 union select max(a) from t1)),(f))*e+t1.f*19 FROM t1 WHERE 17 not between  -t1.e and d"
    end, {
        -- <randexpr-2.1099>
        
        -- </randexpr-2.1099>
    })

test:do_test(
    "randexpr-2.1100",
    function()
        return test:execsql "SELECT coalesce((select max(case t1.b+(select ~((cast(avg(17) AS integer)))*min(a)+ -count(distinct b)*cast(avg(t1.b) AS integer)-count(*)+max(19) from t1)-(e) when d then 13 else 13*c end+t1.c) from t1 where t1.b in (select +cast(avg(e) AS integer)*case count(*) when cast(avg(13) AS integer) then count(distinct t1.b) else count(*) end-(count(distinct 19))*min(t1.d) from t1 union select max(a) from t1)),(f))*e+t1.f*19 FROM t1 WHERE NOT (17 not between  -t1.e and d)"
    end, {
        -- <randexpr-2.1100>
        311400
        -- </randexpr-2.1100>
    })

test:do_test(
    "randexpr-2.1101",
    function()
        return test:execsql "SELECT coalesce((select max(~19) from t1 where 11 in (select t1.b-11*coalesce((select max(b) from t1 where coalesce((select max(e) from t1 where c*case 19*19+coalesce((select 19 from t1 where (11 not in (13+t1.d,b,(11)))),13)*d when t1.e then t1.b else t1.b end+t1.e between d and t1.b),t1.b) | (f)<>13), - -17)+c from t1 union select  -19 from t1)),17) FROM t1 WHERE ~t1.d not between 11*13-+t1.d-11-f and t1.d"
    end, {
        -- <randexpr-2.1101>
        
        -- </randexpr-2.1101>
    })

test:do_test(
    "randexpr-2.1102",
    function()
        return test:execsql "SELECT coalesce((select max(~19) from t1 where 11 in (select t1.b-11*coalesce((select max(b) from t1 where coalesce((select max(e) from t1 where c*case 19*19+coalesce((select 19 from t1 where (11 not in (13+t1.d,b,(11)))),13)*d when t1.e then t1.b else t1.b end+t1.e between d and t1.b),t1.b) | (f)<>13), - -17)+c from t1 union select  -19 from t1)),17) FROM t1 WHERE NOT (~t1.d not between 11*13-+t1.d-11-f and t1.d)"
    end, {
        -- <randexpr-2.1102>
        17
        -- </randexpr-2.1102>
    })

test:do_test(
    "randexpr-2.1103",
    function()
        return test:execsql "SELECT coalesce((select max(~19) from t1 where 11 in (select t1.b-11*coalesce((select max(b) from t1 where coalesce((select max(e) from t1 where c*case 19*19+coalesce((select 19 from t1 where (11 not in (13+t1.d,b,(11)))),13)*d when t1.e then t1.b else t1.b end+t1.e between d and t1.b),t1.b) & (f)<>13), - -17)+c from t1 union select  -19 from t1)),17) FROM t1 WHERE NOT (~t1.d not between 11*13-+t1.d-11-f and t1.d)"
    end, {
        -- <randexpr-2.1103>
        17
        -- </randexpr-2.1103>
    })

test:do_test(
    "randexpr-2.1104",
    function()
        return test:execsql "SELECT case t1.b when coalesce((select max(17+coalesce((select max(coalesce((select (select count(distinct case f when 19 then coalesce((select coalesce((select max(11-(abs(d)/abs(11))) from t1 where not  -a in (19,t1.b,17)),17) from t1 where (f in (b,f,t1.a))),b) else b end) from t1) from t1 where 17 between e and t1.f),t1.a)) from t1 where 13>=e),b)) from t1 where t1.f>t1.f),t1.b) then 17 else t1.f end FROM t1 WHERE not exists(select 1 from t1 where 13 between a+17 and (t1.c))"
    end, {
        -- <randexpr-2.1104>
        17
        -- </randexpr-2.1104>
    })

test:do_test(
    "randexpr-2.1105",
    function()
        return test:execsql "SELECT case t1.b when coalesce((select max(17+coalesce((select max(coalesce((select (select count(distinct case f when 19 then coalesce((select coalesce((select max(11-(abs(d)/abs(11))) from t1 where not  -a in (19,t1.b,17)),17) from t1 where (f in (b,f,t1.a))),b) else b end) from t1) from t1 where 17 between e and t1.f),t1.a)) from t1 where 13>=e),b)) from t1 where t1.f>t1.f),t1.b) then 17 else t1.f end FROM t1 WHERE NOT (not exists(select 1 from t1 where 13 between a+17 and (t1.c)))"
    end, {
        -- <randexpr-2.1105>
        
        -- </randexpr-2.1105>
    })

test:do_test(
    "randexpr-2.1106",
    function()
        return test:execsql "SELECT case when coalesce((select max(d) from t1 where t1.a in (select a-a from t1 union select a from t1)),t1.b)*(select max(t1.b) from t1)>=case when t1.b<case 17 when 19 then t1.a else t1.a end then b when 17<19 then t1.e else t1.b end and (t1.e=t1.c or (not exists(select 1 from t1 where not exists(select 1 from t1 where a=(13)))) or t1.b between 17 and t1.d and b in (t1.f,f,13) or t1.d<e) then t1.c when t1.c between 19 and 11 then d else a end FROM t1 WHERE t1.c>=t1.a"
    end, {
        -- <randexpr-2.1106>
        300
        -- </randexpr-2.1106>
    })

test:do_test(
    "randexpr-2.1107",
    function()
        return test:execsql "SELECT case when coalesce((select max(d) from t1 where t1.a in (select a-a from t1 union select a from t1)),t1.b)*(select max(t1.b) from t1)>=case when t1.b<case 17 when 19 then t1.a else t1.a end then b when 17<19 then t1.e else t1.b end and (t1.e=t1.c or (not exists(select 1 from t1 where not exists(select 1 from t1 where a=(13)))) or t1.b between 17 and t1.d and b in (t1.f,f,13) or t1.d<e) then t1.c when t1.c between 19 and 11 then d else a end FROM t1 WHERE NOT (t1.c>=t1.a)"
    end, {
        -- <randexpr-2.1107>
        
        -- </randexpr-2.1107>
    })

test:do_test(
    "randexpr-2.1108",
    function()
        return test:execsql "SELECT case when case when f*~case when t1.c*t1.f in (c,t1.b,(17)) then 17 when 11>t1.c then 13 else t1.e end+t1.f in (select +max(e)+case (count(distinct a)*count(*))+max(19) when  -max(11) then count(distinct a) else ((count(distinct t1.d))) end from t1 union select count(distinct c) from t1) then 17 else d end+(t1.c)<17 then b when not exists(select 1 from t1 where 11>t1.b) then t1.d else t1.a end FROM t1 WHERE t1.b< -f"
    end, {
        -- <randexpr-2.1108>
        
        -- </randexpr-2.1108>
    })

test:do_test(
    "randexpr-2.1109",
    function()
        return test:execsql "SELECT case when case when f*~case when t1.c*t1.f in (c,t1.b,(17)) then 17 when 11>t1.c then 13 else t1.e end+t1.f in (select +max(e)+case (count(distinct a)*count(*))+max(19) when  -max(11) then count(distinct a) else ((count(distinct t1.d))) end from t1 union select count(distinct c) from t1) then 17 else d end+(t1.c)<17 then b when not exists(select 1 from t1 where 11>t1.b) then t1.d else t1.a end FROM t1 WHERE NOT (t1.b< -f)"
    end, {
        -- <randexpr-2.1109>
        400
        -- </randexpr-2.1109>
    })

test:do_test(
    "randexpr-2.1110",
    function()
        return test:execsql "SELECT (select cast(avg(f) AS integer) | ~++cast(avg((abs(17)/abs( -f+(c-coalesce((select case when c=d and t1.e=t1.b then e when e in (t1.b,19,t1.c) then 17 else d end from t1 where e between t1.a and t1.c),a))+a))) AS integer)-abs( -min(t1.c))-abs(max((t1.b)) |  -~(count(*))+max(17))+cast(avg(t1.a) AS integer) | min(a)*(count(*))*min(17) from t1) FROM t1 WHERE b-(t1.e*t1.e)-t1.d=t1.c"
    end, {
        -- <randexpr-2.1110>
        
        -- </randexpr-2.1110>
    })

test:do_test(
    "randexpr-2.1111",
    function()
        return test:execsql "SELECT (select cast(avg(f) AS integer) | ~++cast(avg((abs(17)/abs( -f+(c-coalesce((select case when c=d and t1.e=t1.b then e when e in (t1.b,19,t1.c) then 17 else d end from t1 where e between t1.a and t1.c),a))+a))) AS integer)-abs( -min(t1.c))-abs(max((t1.b)) |  -~(count(*))+max(17))+cast(avg(t1.a) AS integer) | min(a)*(count(*))*min(17) from t1) FROM t1 WHERE NOT (b-(t1.e*t1.e)-t1.d=t1.c)"
    end, {
        -- <randexpr-2.1111>
        -260
        -- </randexpr-2.1111>
    })

test:do_test(
    "randexpr-2.1112",
    function()
        return test:execsql "SELECT (select cast(avg(f) AS integer) & ~++cast(avg((abs(17)/abs( -f+(c-coalesce((select case when c=d and t1.e=t1.b then e when e in (t1.b,19,t1.c) then 17 else d end from t1 where e between t1.a and t1.c),a))+a))) AS integer)-abs( -min(t1.c))-abs(max((t1.b)) &  -~(count(*))+max(17))+cast(avg(t1.a) AS integer) & min(a)*(count(*))*min(17) from t1) FROM t1 WHERE NOT (b-(t1.e*t1.e)-t1.d=t1.c)"
    end, {
        -- <randexpr-2.1112>
        512
        -- </randexpr-2.1112>
    })

test:do_test(
    "randexpr-2.1113",
    function()
        return test:execsql "SELECT ~+coalesce((select case when t1.f>d then b when (abs(t1.a)/abs((abs(f)/abs(t1.c))))*case ~b when e then (select cast(avg( -+t1.f) AS integer) from t1) else c end+coalesce((select max(17*case t1.a+b when t1.b then t1.d else t1.f end) from t1 where d=e),t1.f)+13>=17 then 19 else f end from t1 where t1.a in (select d from t1 union select e from t1)),b) FROM t1 WHERE 17<>f-~t1.a-case when  -b in (t1.b,(select min( -coalesce((select max(coalesce((select a- -t1.b from t1 where 11 in (t1.b,13, -t1.e) and f not between  -13 and t1.b),c)) from t1 where b not in (a,11,17)),t1.e)) from t1),e) or not exists(select 1 from t1 where t1.c in (select t1.b from t1 union select t1.b from t1)) then coalesce((select  -t1.e from t1 where e<>t1.e),f) when not t1.e<>t1.c then 19 else e end"
    end, {
        -- <randexpr-2.1113>
        -201
        -- </randexpr-2.1113>
    })

test:do_test(
    "randexpr-2.1114",
    function()
        return test:execsql "SELECT ~+coalesce((select case when t1.f>d then b when (abs(t1.a)/abs((abs(f)/abs(t1.c))))*case ~b when e then (select cast(avg( -+t1.f) AS integer) from t1) else c end+coalesce((select max(17*case t1.a+b when t1.b then t1.d else t1.f end) from t1 where d=e),t1.f)+13>=17 then 19 else f end from t1 where t1.a in (select d from t1 union select e from t1)),b) FROM t1 WHERE NOT (17<>f-~t1.a-case when  -b in (t1.b,(select min( -coalesce((select max(coalesce((select a- -t1.b from t1 where 11 in (t1.b,13, -t1.e) and f not between  -13 and t1.b),c)) from t1 where b not in (a,11,17)),t1.e)) from t1),e) or not exists(select 1 from t1 where t1.c in (select t1.b from t1 union select t1.b from t1)) then coalesce((select  -t1.e from t1 where e<>t1.e),f) when not t1.e<>t1.c then 19 else e end)"
    end, {
        -- <randexpr-2.1114>
        
        -- </randexpr-2.1114>
    })

test:do_test(
    "randexpr-2.1115",
    function()
        return test:execsql "SELECT d- -e*(abs(t1.c)/abs(d)) | t1.a+ -coalesce((select max(t1.e) from t1 where case when case when (a in (13,b,t1.b)) and d in (t1.c,17,a) then 17+t1.e when 19>=t1.b then a else 11 end=t1.f and d between c and (d) then (abs(17)/abs(d)) else t1.d end*f>e and not f<=13 and  -t1.f>=t1.e and t1.b<t1.b),t1.e)-case when t1.c<>e then t1.b else c end FROM t1 WHERE b-coalesce((select (coalesce((select max((coalesce((select d from t1 where not  -case when case 13 when +~(select case count(*) when  -max(t1.b) then max(a) else min(c) end from t1) then c else  -a end in (17,t1.b,(b)) then f else b end-f+17<=t1.a),t1.f)-d)) from t1 where t1.e=b),t1.b)) from t1 where (t1.a=t1.c)), -t1.a) not between 19 and 19"
    end, {
        -- <randexpr-2.1115>
        -584
        -- </randexpr-2.1115>
    })

test:do_test(
    "randexpr-2.1116",
    function()
        return test:execsql "SELECT d- -e*(abs(t1.c)/abs(d)) | t1.a+ -coalesce((select max(t1.e) from t1 where case when case when (a in (13,b,t1.b)) and d in (t1.c,17,a) then 17+t1.e when 19>=t1.b then a else 11 end=t1.f and d between c and (d) then (abs(17)/abs(d)) else t1.d end*f>e and not f<=13 and  -t1.f>=t1.e and t1.b<t1.b),t1.e)-case when t1.c<>e then t1.b else c end FROM t1 WHERE NOT (b-coalesce((select (coalesce((select max((coalesce((select d from t1 where not  -case when case 13 when +~(select case count(*) when  -max(t1.b) then max(a) else min(c) end from t1) then c else  -a end in (17,t1.b,(b)) then f else b end-f+17<=t1.a),t1.f)-d)) from t1 where t1.e=b),t1.b)) from t1 where (t1.a=t1.c)), -t1.a) not between 19 and 19)"
    end, {
        -- <randexpr-2.1116>
        
        -- </randexpr-2.1116>
    })

test:do_test(
    "randexpr-2.1117",
    function()
        return test:execsql "SELECT d- -e*(abs(t1.c)/abs(d)) & t1.a+ -coalesce((select max(t1.e) from t1 where case when case when (a in (13,b,t1.b)) and d in (t1.c,17,a) then 17+t1.e when 19>=t1.b then a else 11 end=t1.f and d between c and (d) then (abs(17)/abs(d)) else t1.d end*f>e and not f<=13 and  -t1.f>=t1.e and t1.b<t1.b),t1.e)-case when t1.c<>e then t1.b else c end FROM t1 WHERE b-coalesce((select (coalesce((select max((coalesce((select d from t1 where not  -case when case 13 when +~(select case count(*) when  -max(t1.b) then max(a) else min(c) end from t1) then c else  -a end in (17,t1.b,(b)) then f else b end-f+17<=t1.a),t1.f)-d)) from t1 where t1.e=b),t1.b)) from t1 where (t1.a=t1.c)), -t1.a) not between 19 and 19"
    end, {
        -- <randexpr-2.1117>
        384
        -- </randexpr-2.1117>
    })

test:do_test(
    "randexpr-2.1118",
    function()
        return test:execsql "SELECT 19-case 13-f when b then t1.a*11-t1.d-+17*t1.b-coalesce((select 17 from t1 where 13<=f),+coalesce((select (abs(17+~coalesce((select a from t1 where 11<>t1.b and 11 not between t1.e and 19),17)+t1.e+t1.d | b)/abs(c))+f from t1 where 19 not between 19 and c),d)) else 19 end*t1.e+b FROM t1 WHERE 11+11 not in (t1.c,t1.e,19) and f+19*19*case when ~t1.a+19*b between t1.a-case case when f=(t1.d) then ((t1.d)) else  -d end*e when c then e else t1.a end*t1.e and c then t1.e else b end in (select d from t1 union select t1.a from t1) or t1.d>=t1.f or not exists(select 1 from t1 where a<=13)"
    end, {
        -- <randexpr-2.1118>
        -9281
        -- </randexpr-2.1118>
    })

test:do_test(
    "randexpr-2.1119",
    function()
        return test:execsql "SELECT 19-case 13-f when b then t1.a*11-t1.d-+17*t1.b-coalesce((select 17 from t1 where 13<=f),+coalesce((select (abs(17+~coalesce((select a from t1 where 11<>t1.b and 11 not between t1.e and 19),17)+t1.e+t1.d | b)/abs(c))+f from t1 where 19 not between 19 and c),d)) else 19 end*t1.e+b FROM t1 WHERE NOT (11+11 not in (t1.c,t1.e,19) and f+19*19*case when ~t1.a+19*b between t1.a-case case when f=(t1.d) then ((t1.d)) else  -d end*e when c then e else t1.a end*t1.e and c then t1.e else b end in (select d from t1 union select t1.a from t1) or t1.d>=t1.f or not exists(select 1 from t1 where a<=13))"
    end, {
        -- <randexpr-2.1119>
        
        -- </randexpr-2.1119>
    })

test:do_test(
    "randexpr-2.1120",
    function()
        return test:execsql "SELECT 19-case 13-f when b then t1.a*11-t1.d-+17*t1.b-coalesce((select 17 from t1 where 13<=f),+coalesce((select (abs(17+~coalesce((select a from t1 where 11<>t1.b and 11 not between t1.e and 19),17)+t1.e+t1.d & b)/abs(c))+f from t1 where 19 not between 19 and c),d)) else 19 end*t1.e+b FROM t1 WHERE 11+11 not in (t1.c,t1.e,19) and f+19*19*case when ~t1.a+19*b between t1.a-case case when f=(t1.d) then ((t1.d)) else  -d end*e when c then e else t1.a end*t1.e and c then t1.e else b end in (select d from t1 union select t1.a from t1) or t1.d>=t1.f or not exists(select 1 from t1 where a<=13)"
    end, {
        -- <randexpr-2.1120>
        -9281
        -- </randexpr-2.1120>
    })

test:do_test(
    "randexpr-2.1121",
    function()
        return test:execsql "SELECT case 19 when e then t1.b-t1.d else 11+coalesce((select 19 from t1 where not (t1.a)+(abs(case coalesce((select coalesce((select t1.e from t1 where 11=d),a) from t1 where t1.d<=13),a) when 17 then 13 else t1.a end)/abs(t1.b))-t1.d*e+t1.d not between b and b or e in (select  -min(c) from t1 union select min(t1.b) from t1)),(abs(e)/abs(t1.b)))+t1.c end FROM t1 WHERE exists(select 1 from t1 where c in (select t1.a from t1 union select f from t1))"
    end, {
        -- <randexpr-2.1121>
        
        -- </randexpr-2.1121>
    })

test:do_test(
    "randexpr-2.1122",
    function()
        return test:execsql "SELECT case 19 when e then t1.b-t1.d else 11+coalesce((select 19 from t1 where not (t1.a)+(abs(case coalesce((select coalesce((select t1.e from t1 where 11=d),a) from t1 where t1.d<=13),a) when 17 then 13 else t1.a end)/abs(t1.b))-t1.d*e+t1.d not between b and b or e in (select  -min(c) from t1 union select min(t1.b) from t1)),(abs(e)/abs(t1.b)))+t1.c end FROM t1 WHERE NOT (exists(select 1 from t1 where c in (select t1.a from t1 union select f from t1)))"
    end, {
        -- <randexpr-2.1122>
        313
        -- </randexpr-2.1122>
    })

test:do_test(
    "randexpr-2.1123",
    function()
        return test:execsql "SELECT 17 | t1.d-(select +max(case when not exists(select 1 from t1 where (a<=t1.f)) then  -19 else  -t1.d end)- -min(t1.f+t1.f-(select (count(*)) from t1)) from t1)- -19 | b-d+coalesce((select max(d) from t1 where e-t1.a in (19,b,11) or e in (19,t1.b,c)),11) FROM t1 WHERE (11<=11 and case coalesce((select max((f)) from t1 where t1.b | case 11 when t1.e*t1.e then e else case when ~b-case when 19 not in (t1.d,13,e) then 13 when c between t1.e and b then 19 else t1.c end-(c) in (select  -t1.f from t1 union select d from t1) then c else t1.b end end*t1.a in (19,e,c)),t1.a) when t1.d then t1.a else  -a end not in (t1.c,b,t1.f))"
    end, {
        -- <randexpr-2.1123>
        -41
        -- </randexpr-2.1123>
    })

test:do_test(
    "randexpr-2.1124",
    function()
        return test:execsql "SELECT 17 | t1.d-(select +max(case when not exists(select 1 from t1 where (a<=t1.f)) then  -19 else  -t1.d end)- -min(t1.f+t1.f-(select (count(*)) from t1)) from t1)- -19 | b-d+coalesce((select max(d) from t1 where e-t1.a in (19,b,11) or e in (19,t1.b,c)),11) FROM t1 WHERE NOT ((11<=11 and case coalesce((select max((f)) from t1 where t1.b | case 11 when t1.e*t1.e then e else case when ~b-case when 19 not in (t1.d,13,e) then 13 when c between t1.e and b then 19 else t1.c end-(c) in (select  -t1.f from t1 union select d from t1) then c else t1.b end end*t1.a in (19,e,c)),t1.a) when t1.d then t1.a else  -a end not in (t1.c,b,t1.f)))"
    end, {
        -- <randexpr-2.1124>
        
        -- </randexpr-2.1124>
    })

test:do_test(
    "randexpr-2.1125",
    function()
        return test:execsql "SELECT 17 & t1.d-(select +max(case when not exists(select 1 from t1 where (a<=t1.f)) then  -19 else  -t1.d end)- -min(t1.f+t1.f-(select (count(*)) from t1)) from t1)- -19 & b-d+coalesce((select max(d) from t1 where e-t1.a in (19,b,11) or e in (19,t1.b,c)),11) FROM t1 WHERE (11<=11 and case coalesce((select max((f)) from t1 where t1.b | case 11 when t1.e*t1.e then e else case when ~b-case when 19 not in (t1.d,13,e) then 13 when c between t1.e and b then 19 else t1.c end-(c) in (select  -t1.f from t1 union select d from t1) then c else t1.b end end*t1.a in (19,e,c)),t1.a) when t1.d then t1.a else  -a end not in (t1.c,b,t1.f))"
    end, {
        -- <randexpr-2.1125>
        0
        -- </randexpr-2.1125>
    })

test:do_test(
    "randexpr-2.1126",
    function()
        return test:execsql "SELECT case t1.e-d+b when coalesce((select (select max(t1.a | a |  -(select (count(*))+( - - -count(*)) from t1)*19+ -f+t1.e) from t1) from t1 where not exists(select 1 from t1 where (d not between a and 11) or not d>=11 and exists(select 1 from t1 where not t1.a<>13)) or 19 not in (17,t1.c,t1.c)),19)*t1.c+d then b else c end-b FROM t1 WHERE c<17"
    end, {
        -- <randexpr-2.1126>
        
        -- </randexpr-2.1126>
    })

test:do_test(
    "randexpr-2.1127",
    function()
        return test:execsql "SELECT case t1.e-d+b when coalesce((select (select max(t1.a | a |  -(select (count(*))+( - - -count(*)) from t1)*19+ -f+t1.e) from t1) from t1 where not exists(select 1 from t1 where (d not between a and 11) or not d>=11 and exists(select 1 from t1 where not t1.a<>13)) or 19 not in (17,t1.c,t1.c)),19)*t1.c+d then b else c end-b FROM t1 WHERE NOT (c<17)"
    end, {
        -- <randexpr-2.1127>
        100
        -- </randexpr-2.1127>
    })

test:do_test(
    "randexpr-2.1128",
    function()
        return test:execsql "SELECT case t1.e-d+b when coalesce((select (select max(t1.a & a &  -(select (count(*))+( - - -count(*)) from t1)*19+ -f+t1.e) from t1) from t1 where not exists(select 1 from t1 where (d not between a and 11) or not d>=11 and exists(select 1 from t1 where not t1.a<>13)) or 19 not in (17,t1.c,t1.c)),19)*t1.c+d then b else c end-b FROM t1 WHERE NOT (c<17)"
    end, {
        -- <randexpr-2.1128>
        100
        -- </randexpr-2.1128>
    })

test:do_test(
    "randexpr-2.1129",
    function()
        return test:execsql "SELECT f*f*(abs(case when (17-coalesce((select max(11) from t1 where coalesce((select max(t1.c-11*t1.a) from t1 where +e=(abs(d)/abs(11))+ -13),t1.b)<b and exists(select 1 from t1 where t1.f between d and  -t1.c)),19)-19 in (select max(t1.e) | min(t1.e) from t1 union select count(*) from t1) and 17>t1.e) then e else 17 end)/abs(c)) FROM t1 WHERE (t1.a in ((t1.f-t1.c)+b,11,t1.a+f))"
    end, {
        -- <randexpr-2.1129>
        
        -- </randexpr-2.1129>
    })

test:do_test(
    "randexpr-2.1130",
    function()
        return test:execsql "SELECT f*f*(abs(case when (17-coalesce((select max(11) from t1 where coalesce((select max(t1.c-11*t1.a) from t1 where +e=(abs(d)/abs(11))+ -13),t1.b)<b and exists(select 1 from t1 where t1.f between d and  -t1.c)),19)-19 in (select max(t1.e) | min(t1.e) from t1 union select count(*) from t1) and 17>t1.e) then e else 17 end)/abs(c)) FROM t1 WHERE NOT ((t1.a in ((t1.f-t1.c)+b,11,t1.a+f)))"
    end, {
        -- <randexpr-2.1130>
        0
        -- </randexpr-2.1130>
    })

test:do_test(
    "randexpr-2.1131",
    function()
        return test:execsql "SELECT f*f*(abs(case when (17-coalesce((select max(11) from t1 where coalesce((select max(t1.c-11*t1.a) from t1 where +e=(abs(d)/abs(11))+ -13),t1.b)<b and exists(select 1 from t1 where t1.f between d and  -t1.c)),19)-19 in (select max(t1.e) & min(t1.e) from t1 union select count(*) from t1) and 17>t1.e) then e else 17 end)/abs(c)) FROM t1 WHERE NOT ((t1.a in ((t1.f-t1.c)+b,11,t1.a+f)))"
    end, {
        -- <randexpr-2.1131>
        0
        -- </randexpr-2.1131>
    })

test:do_test(
    "randexpr-2.1132",
    function()
        return test:execsql "SELECT ( -19-f+coalesce((select max( -~case when case 11 when ~coalesce((select max(13) from t1 where not (e)<>(t1.c)),19)+11 |  -19-f then  -13 else t1.c end-e<=t1.a then 11 when not exists(select 1 from t1 where (not t1.c<19) and not (13<>17)) then  -e else f end) from t1 where (b)<=t1.e),t1.d)+ -t1.c) | b FROM t1 WHERE (~(select (max(f)-count(distinct c)) from t1) | case when e>=t1.c then t1.b+(select abs(count(*)+max(c)*abs(count(distinct e)+max(t1.f))+cast(avg(c) AS integer)) | cast(avg(t1.d) AS integer)*min(11) from t1)-t1.c else c end in (select case  -t1.b when 17 then 17 else  -case when not t1.c not in (17,t1.d,17) then 19 else a end end from t1 union select a from t1)) or (11)<=t1.b"
    end, {
        -- <randexpr-2.1132>
        -771
        -- </randexpr-2.1132>
    })

test:do_test(
    "randexpr-2.1133",
    function()
        return test:execsql "SELECT ( -19-f+coalesce((select max( -~case when case 11 when ~coalesce((select max(13) from t1 where not (e)<>(t1.c)),19)+11 |  -19-f then  -13 else t1.c end-e<=t1.a then 11 when not exists(select 1 from t1 where (not t1.c<19) and not (13<>17)) then  -e else f end) from t1 where (b)<=t1.e),t1.d)+ -t1.c) | b FROM t1 WHERE NOT ((~(select (max(f)-count(distinct c)) from t1) | case when e>=t1.c then t1.b+(select abs(count(*)+max(c)*abs(count(distinct e)+max(t1.f))+cast(avg(c) AS integer)) | cast(avg(t1.d) AS integer)*min(11) from t1)-t1.c else c end in (select case  -t1.b when 17 then 17 else  -case when not t1.c not in (17,t1.d,17) then 19 else a end end from t1 union select a from t1)) or (11)<=t1.b)"
    end, {
        -- <randexpr-2.1133>
        
        -- </randexpr-2.1133>
    })

test:do_test(
    "randexpr-2.1134",
    function()
        return test:execsql "SELECT ( -19-f+coalesce((select max( -~case when case 11 when ~coalesce((select max(13) from t1 where not (e)<>(t1.c)),19)+11 &  -19-f then  -13 else t1.c end-e<=t1.a then 11 when not exists(select 1 from t1 where (not t1.c<19) and not (13<>17)) then  -e else f end) from t1 where (b)<=t1.e),t1.d)+ -t1.c) & b FROM t1 WHERE (~(select (max(f)-count(distinct c)) from t1) | case when e>=t1.c then t1.b+(select abs(count(*)+max(c)*abs(count(distinct e)+max(t1.f))+cast(avg(c) AS integer)) | cast(avg(t1.d) AS integer)*min(11) from t1)-t1.c else c end in (select case  -t1.b when 17 then 17 else  -case when not t1.c not in (17,t1.d,17) then 19 else a end end from t1 union select a from t1)) or (11)<=t1.b"
    end, {
        -- <randexpr-2.1134>
        64
        -- </randexpr-2.1134>
    })

test:do_test(
    "randexpr-2.1135",
    function()
        return test:execsql "SELECT +case when (not exists(select 1 from t1 where (abs(t1.a+coalesce((select max(b+ -case when e=t1.f then (abs(d)/abs(t1.e)) when not exists(select 1 from t1 where 17<t1.c) then d else f end |  -(t1.e) | 13*e) from t1 where f in (select t1.e from t1 union select t1.f from t1)),d) | 11)/abs(t1.b))-b not between b and t1.d) and t1.d>t1.c) then e else e end FROM t1 WHERE not t1.d-d+case b when t1.a+t1.a then t1.f+ -t1.e else 11+b*coalesce((select max(t1.f) from t1 where 11>= -f+t1.d),t1.c)*19 end not between d and t1.c-(11)+17"
    end, {
        -- <randexpr-2.1135>
        
        -- </randexpr-2.1135>
    })

test:do_test(
    "randexpr-2.1136",
    function()
        return test:execsql "SELECT +case when (not exists(select 1 from t1 where (abs(t1.a+coalesce((select max(b+ -case when e=t1.f then (abs(d)/abs(t1.e)) when not exists(select 1 from t1 where 17<t1.c) then d else f end |  -(t1.e) | 13*e) from t1 where f in (select t1.e from t1 union select t1.f from t1)),d) | 11)/abs(t1.b))-b not between b and t1.d) and t1.d>t1.c) then e else e end FROM t1 WHERE NOT (not t1.d-d+case b when t1.a+t1.a then t1.f+ -t1.e else 11+b*coalesce((select max(t1.f) from t1 where 11>= -f+t1.d),t1.c)*19 end not between d and t1.c-(11)+17)"
    end, {
        -- <randexpr-2.1136>
        500
        -- </randexpr-2.1136>
    })

test:do_test(
    "randexpr-2.1137",
    function()
        return test:execsql "SELECT +case when (not exists(select 1 from t1 where (abs(t1.a+coalesce((select max(b+ -case when e=t1.f then (abs(d)/abs(t1.e)) when not exists(select 1 from t1 where 17<t1.c) then d else f end &  -(t1.e) & 13*e) from t1 where f in (select t1.e from t1 union select t1.f from t1)),d) & 11)/abs(t1.b))-b not between b and t1.d) and t1.d>t1.c) then e else e end FROM t1 WHERE NOT (not t1.d-d+case b when t1.a+t1.a then t1.f+ -t1.e else 11+b*coalesce((select max(t1.f) from t1 where 11>= -f+t1.d),t1.c)*19 end not between d and t1.c-(11)+17)"
    end, {
        -- <randexpr-2.1137>
        500
        -- </randexpr-2.1137>
    })

test:do_test(
    "randexpr-2.1138",
    function()
        return test:execsql "SELECT t1.d+case when (t1.a)<=11 then ~t1.a else ~19 end-+~ -coalesce((select t1.d from t1 where ~t1.f in (select (cast(avg(t1.e+c) AS integer)) from t1 union select count(distinct (abs(coalesce((select max(19) from t1 where not ~11-t1.a=t1.c+case when t1.d between c and t1.d then 11 when t1.f>=17 then f else 19 end*t1.c),17)+f)/abs(f))) from t1)),11) FROM t1 WHERE e>c"
    end, {
        -- <randexpr-2.1138>
        370
        -- </randexpr-2.1138>
    })

test:do_test(
    "randexpr-2.1139",
    function()
        return test:execsql "SELECT t1.d+case when (t1.a)<=11 then ~t1.a else ~19 end-+~ -coalesce((select t1.d from t1 where ~t1.f in (select (cast(avg(t1.e+c) AS integer)) from t1 union select count(distinct (abs(coalesce((select max(19) from t1 where not ~11-t1.a=t1.c+case when t1.d between c and t1.d then 11 when t1.f>=17 then f else 19 end*t1.c),17)+f)/abs(f))) from t1)),11) FROM t1 WHERE NOT (e>c)"
    end, {
        -- <randexpr-2.1139>
        
        -- </randexpr-2.1139>
    })

test:do_test(
    "randexpr-2.1140",
    function()
        return test:execsql "SELECT case when coalesce((select max(case b | d*(abs(t1.e)/abs(a))-f | t1.b when t1.e then coalesce((select max(t1.e) from t1 where t1.e between (select ~count(*)*cast(avg(19) AS integer) from t1) and case c when a then 13 else a end),t1.f)+e*c else t1.d end) from t1 where t1.a in (select t1.d from t1 union select 17 from t1)),e)+17<19 then t1.a else 19 end | 11+e-17*19 FROM t1 WHERE d*t1.c-case when case when ((13 in (17+e,b,11)) or 19>(13)) then (abs(coalesce((select t1.a from t1 where t1.a not in (13,c,t1.f)),11))/abs(t1.e))-f when t1.b not between t1.b and f then t1.d else t1.a end in (a,e,t1.d) then t1.f else t1.f end+f+t1.e in (t1.d,e,b)"
    end, {
        -- <randexpr-2.1140>
        
        -- </randexpr-2.1140>
    })

test:do_test(
    "randexpr-2.1141",
    function()
        return test:execsql "SELECT case when coalesce((select max(case b | d*(abs(t1.e)/abs(a))-f | t1.b when t1.e then coalesce((select max(t1.e) from t1 where t1.e between (select ~count(*)*cast(avg(19) AS integer) from t1) and case c when a then 13 else a end),t1.f)+e*c else t1.d end) from t1 where t1.a in (select t1.d from t1 union select 17 from t1)),e)+17<19 then t1.a else 19 end | 11+e-17*19 FROM t1 WHERE NOT (d*t1.c-case when case when ((13 in (17+e,b,11)) or 19>(13)) then (abs(coalesce((select t1.a from t1 where t1.a not in (13,c,t1.f)),11))/abs(t1.e))-f when t1.b not between t1.b and f then t1.d else t1.a end in (a,e,t1.d) then t1.f else t1.f end+f+t1.e in (t1.d,e,b))"
    end, {
        -- <randexpr-2.1141>
        191
        -- </randexpr-2.1141>
    })

test:do_test(
    "randexpr-2.1142",
    function()
        return test:execsql "SELECT case when coalesce((select max(case b & d*(abs(t1.e)/abs(a))-f & t1.b when t1.e then coalesce((select max(t1.e) from t1 where t1.e between (select ~count(*)*cast(avg(19) AS integer) from t1) and case c when a then 13 else a end),t1.f)+e*c else t1.d end) from t1 where t1.a in (select t1.d from t1 union select 17 from t1)),e)+17<19 then t1.a else 19 end & 11+e-17*19 FROM t1 WHERE NOT (d*t1.c-case when case when ((13 in (17+e,b,11)) or 19>(13)) then (abs(coalesce((select t1.a from t1 where t1.a not in (13,c,t1.f)),11))/abs(t1.e))-f when t1.b not between t1.b and f then t1.d else t1.a end in (a,e,t1.d) then t1.f else t1.f end+f+t1.e in (t1.d,e,b))"
    end, {
        -- <randexpr-2.1142>
        16
        -- </randexpr-2.1142>
    })

test:do_test(
    "randexpr-2.1143",
    function()
        return test:execsql "SELECT ((select (count(*) | +~(case ++(min(t1.f+17+(11-case when b between d and d and t1.a not in (13,c,t1.c) and e< -t1.b then 17+(11) else t1.e end+ -b))) when case min(e) when min( -13) | ~max(t1.f) then count(distinct t1.f) | ~count(distinct t1.d) else count(*) end then min(t1.c) else  -cast(avg(11) AS integer) end)+count(distinct (f))) from t1)+e) FROM t1 WHERE (a in (11*a-t1.a | t1.b+e*13,(f | a | (select min((select min(13)-min(17)*((count(distinct t1.d))) from t1)) from t1)+t1.a- -11)+(11),t1.c) and (a) between t1.d and t1.f or t1.d not between t1.c and f or d not in (t1.c,t1.f,c))"
    end, {
        -- <randexpr-2.1143>
        511
        -- </randexpr-2.1143>
    })

test:do_test(
    "randexpr-2.1144",
    function()
        return test:execsql "SELECT ((select (count(*) | +~(case ++(min(t1.f+17+(11-case when b between d and d and t1.a not in (13,c,t1.c) and e< -t1.b then 17+(11) else t1.e end+ -b))) when case min(e) when min( -13) | ~max(t1.f) then count(distinct t1.f) | ~count(distinct t1.d) else count(*) end then min(t1.c) else  -cast(avg(11) AS integer) end)+count(distinct (f))) from t1)+e) FROM t1 WHERE NOT ((a in (11*a-t1.a | t1.b+e*13,(f | a | (select min((select min(13)-min(17)*((count(distinct t1.d))) from t1)) from t1)+t1.a- -11)+(11),t1.c) and (a) between t1.d and t1.f or t1.d not between t1.c and f or d not in (t1.c,t1.f,c)))"
    end, {
        -- <randexpr-2.1144>
        
        -- </randexpr-2.1144>
    })

test:do_test(
    "randexpr-2.1145",
    function()
        return test:execsql "SELECT ((select (count(*) & +~(case ++(min(t1.f+17+(11-case when b between d and d and t1.a not in (13,c,t1.c) and e< -t1.b then 17+(11) else t1.e end+ -b))) when case min(e) when min( -13) & ~max(t1.f) then count(distinct t1.f) & ~count(distinct t1.d) else count(*) end then min(t1.c) else  -cast(avg(11) AS integer) end)+count(distinct (f))) from t1)+e) FROM t1 WHERE (a in (11*a-t1.a | t1.b+e*13,(f | a | (select min((select min(13)-min(17)*((count(distinct t1.d))) from t1)) from t1)+t1.a- -11)+(11),t1.c) and (a) between t1.d and t1.f or t1.d not between t1.c and f or d not in (t1.c,t1.f,c))"
    end, {
        -- <randexpr-2.1145>
        501
        -- </randexpr-2.1145>
    })

test:do_test(
    "randexpr-2.1146",
    function()
        return test:execsql "SELECT coalesce((select max(13) from t1 where d in (select (max(19)*count(distinct case when t1.f between ~e and  -b-t1.f then b else d end)-count(distinct f)) from t1 union select cast(avg(case e when case t1.b when  -a | t1.e*19 then t1.a else  -t1.c end then  -d else t1.e end) AS integer) from t1)),case when t1.d in (select t1.e from t1 union select b from t1) then t1.f when t1.f between 13 and f then f else f end) FROM t1 WHERE c in (select (t1.a) from t1 union select e from t1)"
    end, {
        -- <randexpr-2.1146>
        
        -- </randexpr-2.1146>
    })

test:do_test(
    "randexpr-2.1147",
    function()
        return test:execsql "SELECT coalesce((select max(13) from t1 where d in (select (max(19)*count(distinct case when t1.f between ~e and  -b-t1.f then b else d end)-count(distinct f)) from t1 union select cast(avg(case e when case t1.b when  -a | t1.e*19 then t1.a else  -t1.c end then  -d else t1.e end) AS integer) from t1)),case when t1.d in (select t1.e from t1 union select b from t1) then t1.f when t1.f between 13 and f then f else f end) FROM t1 WHERE NOT (c in (select (t1.a) from t1 union select e from t1))"
    end, {
        -- <randexpr-2.1147>
        600
        -- </randexpr-2.1147>
    })

test:do_test(
    "randexpr-2.1148",
    function()
        return test:execsql "SELECT coalesce((select max(13) from t1 where d in (select (max(19)*count(distinct case when t1.f between ~e and  -b-t1.f then b else d end)-count(distinct f)) from t1 union select cast(avg(case e when case t1.b when  -a & t1.e*19 then t1.a else  -t1.c end then  -d else t1.e end) AS integer) from t1)),case when t1.d in (select t1.e from t1 union select b from t1) then t1.f when t1.f between 13 and f then f else f end) FROM t1 WHERE NOT (c in (select (t1.a) from t1 union select e from t1))"
    end, {
        -- <randexpr-2.1148>
        600
        -- </randexpr-2.1148>
    })

test:do_test(
    "randexpr-2.1149",
    function()
        return test:execsql "SELECT (abs(t1.d+b)/abs(~t1.f+case when t1.f=t1.c or exists(select 1 from t1 where c>=+~t1.c*17) or exists(select 1 from t1 where (select  -cast(avg(case when 19<>t1.f then  -c when c<>b then t1.e else t1.d end) AS integer) from t1) in (d-t1.f,b,19)) then d+b when 11<b then t1.c else d end* -t1.a-19)) FROM t1 WHERE t1.a-(select cast(avg(a) AS integer) from t1) in (select t1.c from t1 union select 19 from t1) and not exists(select 1 from t1 where coalesce((select max(11) from t1 where case when not d>(19) then c else  -case when 11>b or t1.c<=c then f when t1.f>t1.a then t1.a else t1.e end*d-11 end+d*t1.b>t1.e),d)>t1.b and c<>d and not exists(select 1 from t1 where 17>=(t1.f)) and t1.e not in (f,t1.b,t1.b))"
    end, {
        -- <randexpr-2.1149>
        
        -- </randexpr-2.1149>
    })

test:do_test(
    "randexpr-2.1150",
    function()
        return test:execsql "SELECT (abs(t1.d+b)/abs(~t1.f+case when t1.f=t1.c or exists(select 1 from t1 where c>=+~t1.c*17) or exists(select 1 from t1 where (select  -cast(avg(case when 19<>t1.f then  -c when c<>b then t1.e else t1.d end) AS integer) from t1) in (d-t1.f,b,19)) then d+b when 11<b then t1.c else d end* -t1.a-19)) FROM t1 WHERE NOT (t1.a-(select cast(avg(a) AS integer) from t1) in (select t1.c from t1 union select 19 from t1) and not exists(select 1 from t1 where coalesce((select max(11) from t1 where case when not d>(19) then c else  -case when 11>b or t1.c<=c then f when t1.f>t1.a then t1.a else t1.e end*d-11 end+d*t1.b>t1.e),d)>t1.b and c<>d and not exists(select 1 from t1 where 17>=(t1.f)) and t1.e not in (f,t1.b,t1.b)))"
    end, {
        -- <randexpr-2.1150>
        0
        -- </randexpr-2.1150>
    })

test:do_test(
    "randexpr-2.1151",
    function()
        return test:execsql "SELECT t1.b-~case when +a in (select ~min(11) from t1 union select  -count(*)+count(distinct ~coalesce((select coalesce((select t1.b-19+c from t1 where a<>13 or 13 in (t1.b,d,t1.e)),11) from t1 where 19 in (19,e,17)),e)) from t1) then (select  -min(19)+cast(avg(t1.d) AS integer) from t1) else d end | 17 | t1.e FROM t1 WHERE c-b+e*11+(c+13+11)+(13)+(select cast(avg((abs(e-d+a)/abs(t1.f))) AS integer) from t1)-t1.d+~13<=t1.e-c-17"
    end, {
        -- <randexpr-2.1151>
        
        -- </randexpr-2.1151>
    })

test:do_test(
    "randexpr-2.1152",
    function()
        return test:execsql "SELECT t1.b-~case when +a in (select ~min(11) from t1 union select  -count(*)+count(distinct ~coalesce((select coalesce((select t1.b-19+c from t1 where a<>13 or 13 in (t1.b,d,t1.e)),11) from t1 where 19 in (19,e,17)),e)) from t1) then (select  -min(19)+cast(avg(t1.d) AS integer) from t1) else d end | 17 | t1.e FROM t1 WHERE NOT (c-b+e*11+(c+13+11)+(13)+(select cast(avg((abs(e-d+a)/abs(t1.f))) AS integer) from t1)-t1.d+~13<=t1.e-c-17)"
    end, {
        -- <randexpr-2.1152>
        1021
        -- </randexpr-2.1152>
    })

test:do_test(
    "randexpr-2.1153",
    function()
        return test:execsql "SELECT t1.b-~case when +a in (select ~min(11) from t1 union select  -count(*)+count(distinct ~coalesce((select coalesce((select t1.b-19+c from t1 where a<>13 or 13 in (t1.b,d,t1.e)),11) from t1 where 19 in (19,e,17)),e)) from t1) then (select  -min(19)+cast(avg(t1.d) AS integer) from t1) else d end & 17 & t1.e FROM t1 WHERE NOT (c-b+e*11+(c+13+11)+(13)+(select cast(avg((abs(e-d+a)/abs(t1.f))) AS integer) from t1)-t1.d+~13<=t1.e-c-17)"
    end, {
        -- <randexpr-2.1153>
        16
        -- </randexpr-2.1153>
    })

test:do_test(
    "randexpr-2.1154",
    function()
        return test:execsql "SELECT coalesce((select max(b) from t1 where t1.e<t1.b-11*case when ( -c*case d when case +t1.c+t1.b when ~11*(select count(distinct d) from t1) then a else t1.d end then t1.b else (abs((select max(+coalesce((select (t1.d) from t1 where 19 not between t1.b and t1.a and t1.d between 19 and  -13),t1.a)) from t1))/abs(f)) end)<>t1.e then 17 when 19 not between 11 and b then t1.e else 19 end*t1.c),t1.c) FROM t1 WHERE not t1.f*(abs(case when ~19-17*e>=t1.d then t1.b when (select cast(avg(t1.e) AS integer) from t1) in ((abs(t1.e)/abs(t1.e))-case when f not in (t1.d,13,c) then c else t1.e end-t1.b-t1.a | b-(t1.c), -a,e) then t1.e else e end+a)/abs(t1.d)) | b not between b and t1.d"
    end, {
        -- <randexpr-2.1154>
        
        -- </randexpr-2.1154>
    })

test:do_test(
    "randexpr-2.1155",
    function()
        return test:execsql "SELECT coalesce((select max(b) from t1 where t1.e<t1.b-11*case when ( -c*case d when case +t1.c+t1.b when ~11*(select count(distinct d) from t1) then a else t1.d end then t1.b else (abs((select max(+coalesce((select (t1.d) from t1 where 19 not between t1.b and t1.a and t1.d between 19 and  -13),t1.a)) from t1))/abs(f)) end)<>t1.e then 17 when 19 not between 11 and b then t1.e else 19 end*t1.c),t1.c) FROM t1 WHERE NOT (not t1.f*(abs(case when ~19-17*e>=t1.d then t1.b when (select cast(avg(t1.e) AS integer) from t1) in ((abs(t1.e)/abs(t1.e))-case when f not in (t1.d,13,c) then c else t1.e end-t1.b-t1.a | b-(t1.c), -a,e) then t1.e else e end+a)/abs(t1.d)) | b not between b and t1.d)"
    end, {
        -- <randexpr-2.1155>
        300
        -- </randexpr-2.1155>
    })

test:do_test(
    "randexpr-2.1156",
    function()
        return test:execsql "SELECT  -f+( - -case when 13-b not between case when (a<>t1.f or case when not exists(select 1 from t1 where 11<>t1.a) then b when c<=t1.b then t1.f else 11 end in (select 17 from t1 union select t1.b from t1)) then b-c-b when t1.f=13 then a else 19 end | t1.d and t1.e and not exists(select 1 from t1 where 19=t1.f) then  -c else 19 end+17) FROM t1 WHERE not not exists(select 1 from t1 where ~(select cast(avg(t1.d) AS integer) from t1) | +~~case case when f-case when exists(select 1 from t1 where 13 not in (d,11,case when not exists(select 1 from t1 where f between t1.d and e) then 13 when t1.e<>19 then f else 11 end) or b in ( -d,t1.c,17)) then b else f end-(t1.d) in (t1.c,t1.c,b) then t1.b else e end when 11 then t1.e else  -c end-c<>t1.b)"
    end, {
        -- <randexpr-2.1156>
        -883
        -- </randexpr-2.1156>
    })

test:do_test(
    "randexpr-2.1157",
    function()
        return test:execsql "SELECT  -f+( - -case when 13-b not between case when (a<>t1.f or case when not exists(select 1 from t1 where 11<>t1.a) then b when c<=t1.b then t1.f else 11 end in (select 17 from t1 union select t1.b from t1)) then b-c-b when t1.f=13 then a else 19 end | t1.d and t1.e and not exists(select 1 from t1 where 19=t1.f) then  -c else 19 end+17) FROM t1 WHERE NOT (not not exists(select 1 from t1 where ~(select cast(avg(t1.d) AS integer) from t1) | +~~case case when f-case when exists(select 1 from t1 where 13 not in (d,11,case when not exists(select 1 from t1 where f between t1.d and e) then 13 when t1.e<>19 then f else 11 end) or b in ( -d,t1.c,17)) then b else f end-(t1.d) in (t1.c,t1.c,b) then t1.b else e end when 11 then t1.e else  -c end-c<>t1.b))"
    end, {
        -- <randexpr-2.1157>
        
        -- </randexpr-2.1157>
    })

test:do_test(
    "randexpr-2.1158",
    function()
        return test:execsql "SELECT  -f+( - -case when 13-b not between case when (a<>t1.f or case when not exists(select 1 from t1 where 11<>t1.a) then b when c<=t1.b then t1.f else 11 end in (select 17 from t1 union select t1.b from t1)) then b-c-b when t1.f=13 then a else 19 end & t1.d and t1.e and not exists(select 1 from t1 where 19=t1.f) then  -c else 19 end+17) FROM t1 WHERE not not exists(select 1 from t1 where ~(select cast(avg(t1.d) AS integer) from t1) | +~~case case when f-case when exists(select 1 from t1 where 13 not in (d,11,case when not exists(select 1 from t1 where f between t1.d and e) then 13 when t1.e<>19 then f else 11 end) or b in ( -d,t1.c,17)) then b else f end-(t1.d) in (t1.c,t1.c,b) then t1.b else e end when 11 then t1.e else  -c end-c<>t1.b)"
    end, {
        -- <randexpr-2.1158>
        -883
        -- </randexpr-2.1158>
    })

test:do_test(
    "randexpr-2.1159",
    function()
        return test:execsql "SELECT +(abs(d+d+a+b+t1.d)/abs(coalesce((select (select abs(cast(avg(17-11+e*t1.d) AS integer)++cast(avg(coalesce((select max(11-+t1.f- -e-a* -19+t1.a) from t1 where  -a in (select 11 from t1 union select  -11 from t1)),e)) AS integer)) from t1) from t1 where f=17),t1.b)*a)) FROM t1 WHERE t1.b in (select t1.e from t1 union select coalesce((select max(11) from t1 where d<t1.f),f) from t1)"
    end, {
        -- <randexpr-2.1159>
        
        -- </randexpr-2.1159>
    })

test:do_test(
    "randexpr-2.1160",
    function()
        return test:execsql "SELECT +(abs(d+d+a+b+t1.d)/abs(coalesce((select (select abs(cast(avg(17-11+e*t1.d) AS integer)++cast(avg(coalesce((select max(11-+t1.f- -e-a* -19+t1.a) from t1 where  -a in (select 11 from t1 union select  -11 from t1)),e)) AS integer)) from t1) from t1 where f=17),t1.b)*a)) FROM t1 WHERE NOT (t1.b in (select t1.e from t1 union select coalesce((select max(11) from t1 where d<t1.f),f) from t1))"
    end, {
        -- <randexpr-2.1160>
        0
        -- </randexpr-2.1160>
    })

test:do_test(
    "randexpr-2.1161",
    function()
        return test:execsql "SELECT case when t1.b*t1.c=coalesce((select t1.f from t1 where case when exists(select 1 from t1 where t1.d in (select e from t1 union select 19 from t1)) or t1.e>t1.e then t1.a+e-a when 19>t1.c then c else t1.c end+c not between b and t1.d),t1.f) and  -(t1.b) between t1.e and  -t1.d or b<>19 then (select ~(min(13))+max(f) from t1) else (t1.b) end*t1.b FROM t1 WHERE b in (b,e,case coalesce((select max(t1.b) from t1 where e>13 or ( -(select case  -~count(distinct 17)-cast(avg((t1.f)) AS integer)*cast(avg(d) AS integer) when  -cast(avg(f) AS integer) then max(17) else  -(count(*)) end from t1)-(coalesce((select (b) from t1 where t1.b>=t1.e),t1.c)) in (17,t1.e,b)) or (exists(select 1 from t1 where (t1.d=(d))))),t1.c) when b then c else (e) end)"
    end, {
        -- <randexpr-2.1161>
        117200
        -- </randexpr-2.1161>
    })

test:do_test(
    "randexpr-2.1162",
    function()
        return test:execsql "SELECT case when t1.b*t1.c=coalesce((select t1.f from t1 where case when exists(select 1 from t1 where t1.d in (select e from t1 union select 19 from t1)) or t1.e>t1.e then t1.a+e-a when 19>t1.c then c else t1.c end+c not between b and t1.d),t1.f) and  -(t1.b) between t1.e and  -t1.d or b<>19 then (select ~(min(13))+max(f) from t1) else (t1.b) end*t1.b FROM t1 WHERE NOT (b in (b,e,case coalesce((select max(t1.b) from t1 where e>13 or ( -(select case  -~count(distinct 17)-cast(avg((t1.f)) AS integer)*cast(avg(d) AS integer) when  -cast(avg(f) AS integer) then max(17) else  -(count(*)) end from t1)-(coalesce((select (b) from t1 where t1.b>=t1.e),t1.c)) in (17,t1.e,b)) or (exists(select 1 from t1 where (t1.d=(d))))),t1.c) when b then c else (e) end))"
    end, {
        -- <randexpr-2.1162>
        
        -- </randexpr-2.1162>
    })

test:do_test(
    "randexpr-2.1163",
    function()
        return test:execsql "SELECT +t1.c+case when t1.e not in ((e)-(case when 17<11 then 19 when (t1.d in (d,coalesce((select max(t1.a) from t1 where not b<>t1.b),case t1.b when coalesce((select max(t1.a) from t1 where exists(select 1 from t1 where e not in (t1.f,11,17))),(19))*t1.f then c else t1.c end+ -t1.d)-t1.b+t1.e,d)) then 19 else b end)-e,t1.c, -13) then e else 17 end FROM t1 WHERE t1.e*t1.b | t1.b<>17*+coalesce((select max(t1.b) from t1 where case when coalesce((select max(b) from t1 where case when (b between 17 and d) then t1.f when t1.c between b and t1.a then t1.e else t1.a end not in (11,19,13)),11) in (t1.d,17,17) then t1.f when d<>13 then 11 else t1.a end+a<17),t1.a)-17+t1.f*d-a"
    end, {
        -- <randexpr-2.1163>
        800
        -- </randexpr-2.1163>
    })

test:do_test(
    "randexpr-2.1164",
    function()
        return test:execsql "SELECT +t1.c+case when t1.e not in ((e)-(case when 17<11 then 19 when (t1.d in (d,coalesce((select max(t1.a) from t1 where not b<>t1.b),case t1.b when coalesce((select max(t1.a) from t1 where exists(select 1 from t1 where e not in (t1.f,11,17))),(19))*t1.f then c else t1.c end+ -t1.d)-t1.b+t1.e,d)) then 19 else b end)-e,t1.c, -13) then e else 17 end FROM t1 WHERE NOT (t1.e*t1.b | t1.b<>17*+coalesce((select max(t1.b) from t1 where case when coalesce((select max(b) from t1 where case when (b between 17 and d) then t1.f when t1.c between b and t1.a then t1.e else t1.a end not in (11,19,13)),11) in (t1.d,17,17) then t1.f when d<>13 then 11 else t1.a end+a<17),t1.a)-17+t1.f*d-a)"
    end, {
        -- <randexpr-2.1164>
        
        -- </randexpr-2.1164>
    })

test:do_test(
    "randexpr-2.1165",
    function()
        return test:execsql "SELECT 11+case when case case f when (abs(t1.a)/abs(19))+t1.e then (abs(19)/abs(b+e)) else 13 end | 11 when (select ~~+min(t1.e) from t1) then t1.c else  -e end<>case t1.a when 17 then case when (c not between 19 and t1.b) and t1.b<>t1.d then coalesce((select a from t1 where t1.d in (t1.e,t1.f,f)),t1.e) else 13 end else d end or t1.c<t1.d then t1.f else 17 end-f FROM t1 WHERE (f*c*coalesce((select e from t1 where (exists(select 1 from t1 where +t1.e<= -e | t1.f))),a)+b in (select t1.c from t1 union select c from t1) or (t1.e between b and (19)) and 13 between t1.e and 13 and 11 in (13,t1.c,17) and exists(select 1 from t1 where t1.d in (select count(*)-max(e)-((max((11)))) from t1 union select max(17) from t1)) and c>f)"
    end, {
        -- <randexpr-2.1165>
        
        -- </randexpr-2.1165>
    })

test:do_test(
    "randexpr-2.1166",
    function()
        return test:execsql "SELECT 11+case when case case f when (abs(t1.a)/abs(19))+t1.e then (abs(19)/abs(b+e)) else 13 end | 11 when (select ~~+min(t1.e) from t1) then t1.c else  -e end<>case t1.a when 17 then case when (c not between 19 and t1.b) and t1.b<>t1.d then coalesce((select a from t1 where t1.d in (t1.e,t1.f,f)),t1.e) else 13 end else d end or t1.c<t1.d then t1.f else 17 end-f FROM t1 WHERE NOT ((f*c*coalesce((select e from t1 where (exists(select 1 from t1 where +t1.e<= -e | t1.f))),a)+b in (select t1.c from t1 union select c from t1) or (t1.e between b and (19)) and 13 between t1.e and 13 and 11 in (13,t1.c,17) and exists(select 1 from t1 where t1.d in (select count(*)-max(e)-((max((11)))) from t1 union select max(17) from t1)) and c>f))"
    end, {
        -- <randexpr-2.1166>
        11
        -- </randexpr-2.1166>
    })

test:do_test(
    "randexpr-2.1167",
    function()
        return test:execsql "SELECT 11+case when case case f when (abs(t1.a)/abs(19))+t1.e then (abs(19)/abs(b+e)) else 13 end & 11 when (select ~~+min(t1.e) from t1) then t1.c else  -e end<>case t1.a when 17 then case when (c not between 19 and t1.b) and t1.b<>t1.d then coalesce((select a from t1 where t1.d in (t1.e,t1.f,f)),t1.e) else 13 end else d end or t1.c<t1.d then t1.f else 17 end-f FROM t1 WHERE NOT ((f*c*coalesce((select e from t1 where (exists(select 1 from t1 where +t1.e<= -e | t1.f))),a)+b in (select t1.c from t1 union select c from t1) or (t1.e between b and (19)) and 13 between t1.e and 13 and 11 in (13,t1.c,17) and exists(select 1 from t1 where t1.d in (select count(*)-max(e)-((max((11)))) from t1 union select max(17) from t1)) and c>f))"
    end, {
        -- <randexpr-2.1167>
        11
        -- </randexpr-2.1167>
    })

test:do_test(
    "randexpr-2.1168",
    function()
        return test:execsql "SELECT d-case when ~c<>case when not exists(select 1 from t1 where  -t1.b<>19) then coalesce((select max(t1.f) from t1 where exists(select 1 from t1 where (t1.c in (select ~~+~max(~case when 13 not between t1.d and t1.d or c between c and f then t1.f else t1.a end)*abs(count(*)+(min( -t1.e))) from t1 union select cast(avg(e) AS integer) from t1) and (abs(t1.f*f-t1.a)/abs(d))>t1.b)) and (17) not in ( -t1.f,13,17)),19) else a end then b else f end FROM t1 WHERE f=(select case ~ -~count(distinct t1.b)+count(distinct d) |  -count(distinct t1.e)*count(*)* -cast(avg(b) AS integer)*(cast(avg(13) AS integer)) when  -min(19) then min(t1.e) else ((cast(avg(17) AS integer))) end from t1) or 19>=(19) and not exists(select 1 from t1 where (select count(*) from t1)*t1.d not between 19+11 and d) and  -t1.e not in (e,t1.a, -a) and t1.e between t1.f and (t1.b) or c in ( -11,17,t1.c) or t1.a in (a,11,t1.d)"
    end, {
        -- <randexpr-2.1168>
        200
        -- </randexpr-2.1168>
    })

test:do_test(
    "randexpr-2.1169",
    function()
        return test:execsql "SELECT d-case when ~c<>case when not exists(select 1 from t1 where  -t1.b<>19) then coalesce((select max(t1.f) from t1 where exists(select 1 from t1 where (t1.c in (select ~~+~max(~case when 13 not between t1.d and t1.d or c between c and f then t1.f else t1.a end)*abs(count(*)+(min( -t1.e))) from t1 union select cast(avg(e) AS integer) from t1) and (abs(t1.f*f-t1.a)/abs(d))>t1.b)) and (17) not in ( -t1.f,13,17)),19) else a end then b else f end FROM t1 WHERE NOT (f=(select case ~ -~count(distinct t1.b)+count(distinct d) |  -count(distinct t1.e)*count(*)* -cast(avg(b) AS integer)*(cast(avg(13) AS integer)) when  -min(19) then min(t1.e) else ((cast(avg(17) AS integer))) end from t1) or 19>=(19) and not exists(select 1 from t1 where (select count(*) from t1)*t1.d not between 19+11 and d) and  -t1.e not in (e,t1.a, -a) and t1.e between t1.f and (t1.b) or c in ( -11,17,t1.c) or t1.a in (a,11,t1.d))"
    end, {
        -- <randexpr-2.1169>
        
        -- </randexpr-2.1169>
    })

test:do_test(
    "randexpr-2.1170",
    function()
        return test:execsql "SELECT case when a in (select t1.b from t1 union select coalesce((select ~19 from t1 where e>13*t1.d or c in (select b from t1 union select case a*t1.f when e then (t1.c) else (t1.b) end from t1)),t1.a) from t1) and t1.d>b or not exists(select 1 from t1 where t1.e in (select count(*)*min(t1.b)*~count(*) from t1 union select case  -min((19)) when  -max(b) then (min(t1.a)) else (count(distinct t1.d)) end from t1)) then (t1.c) when exists(select 1 from t1 where f not between 19 and f) then 19 else t1.c end-a FROM t1 WHERE a=coalesce((select f from t1 where t1.c in (11,(abs(coalesce((select max(t1.d) from t1 where (abs(t1.c | 13)/abs(11)) not in (b+case when coalesce((select max(b) from t1 where 11 between d and t1.a),b)<a then 19 when (e) not in (t1.e,13,t1.d) then t1.c else  - -t1.e end-19,a,17)),19))/abs(t1.a)),t1.b) or (((13)>=t1.b))),c) and f between 19 and t1.d or c>(f)"
    end, {
        -- <randexpr-2.1170>
        
        -- </randexpr-2.1170>
    })

test:do_test(
    "randexpr-2.1171",
    function()
        return test:execsql "SELECT case when a in (select t1.b from t1 union select coalesce((select ~19 from t1 where e>13*t1.d or c in (select b from t1 union select case a*t1.f when e then (t1.c) else (t1.b) end from t1)),t1.a) from t1) and t1.d>b or not exists(select 1 from t1 where t1.e in (select count(*)*min(t1.b)*~count(*) from t1 union select case  -min((19)) when  -max(b) then (min(t1.a)) else (count(distinct t1.d)) end from t1)) then (t1.c) when exists(select 1 from t1 where f not between 19 and f) then 19 else t1.c end-a FROM t1 WHERE NOT (a=coalesce((select f from t1 where t1.c in (11,(abs(coalesce((select max(t1.d) from t1 where (abs(t1.c | 13)/abs(11)) not in (b+case when coalesce((select max(b) from t1 where 11 between d and t1.a),b)<a then 19 when (e) not in (t1.e,13,t1.d) then t1.c else  - -t1.e end-19,a,17)),19))/abs(t1.a)),t1.b) or (((13)>=t1.b))),c) and f between 19 and t1.d or c>(f))"
    end, {
        -- <randexpr-2.1171>
        200
        -- </randexpr-2.1171>
    })

test:do_test(
    "randexpr-2.1172",
    function()
        return test:execsql "SELECT case when  -(t1.f)- -case when t1.e not in ((t1.d)+a-t1.a,t1.c, - -a) then t1.b when (not exists(select 1 from t1 where t1.d>= -t1.f)) then  -19 else f end-t1.f in (select cast(avg(19) AS integer)*case count(*) when abs((++min( -11))*max(13)-count(distinct 13)) then min(t1.a) else count(distinct 17) end from t1 union select count(distinct t1.a) from t1) then t1.c when b not between t1.f and 13 then e else t1.a end FROM t1 WHERE 11 not between ~17+d and ~case when t1.b in (c*((abs(case 13 when  -(select abs(count(distinct coalesce((select max(coalesce((select t1.b from t1 where not exists(select 1 from t1 where (t1.c) in (t1.a,e,13))),t1.d)) from t1 where not t1.d>c),b))) from t1) then t1.f else t1.b end- -t1.c)/abs(c))+a),t1.d,t1.a) then (t1.c) else (d) end-13 or  -t1.a in (17,a,f)"
    end, {
        -- <randexpr-2.1172>
        500
        -- </randexpr-2.1172>
    })

test:do_test(
    "randexpr-2.1173",
    function()
        return test:execsql "SELECT case when  -(t1.f)- -case when t1.e not in ((t1.d)+a-t1.a,t1.c, - -a) then t1.b when (not exists(select 1 from t1 where t1.d>= -t1.f)) then  -19 else f end-t1.f in (select cast(avg(19) AS integer)*case count(*) when abs((++min( -11))*max(13)-count(distinct 13)) then min(t1.a) else count(distinct 17) end from t1 union select count(distinct t1.a) from t1) then t1.c when b not between t1.f and 13 then e else t1.a end FROM t1 WHERE NOT (11 not between ~17+d and ~case when t1.b in (c*((abs(case 13 when  -(select abs(count(distinct coalesce((select max(coalesce((select t1.b from t1 where not exists(select 1 from t1 where (t1.c) in (t1.a,e,13))),t1.d)) from t1 where not t1.d>c),b))) from t1) then t1.f else t1.b end- -t1.c)/abs(c))+a),t1.d,t1.a) then (t1.c) else (d) end-13 or  -t1.a in (17,a,f))"
    end, {
        -- <randexpr-2.1173>
        
        -- </randexpr-2.1173>
    })

test:do_test(
    "randexpr-2.1174",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where (t1.b- -b+(select +case max(b)-~count(distinct e*(select case max(c) when abs((count(*))) then max(t1.f) else max(t1.c) end+cast(avg(t1.b) AS integer) from t1)) when abs(count(distinct e*19)) then max(b) else max(t1.c) end | count(distinct t1.e) from t1)-b*+t1.b not in ((11),17,13)))),t1.e) FROM t1 WHERE t1.c in (select min(coalesce((select 17 from t1 where t1.c | 17>=(abs(t1.a)/abs(case when t1.e not in (19,t1.d,19) then a when 13<=case when not exists(select 1 from t1 where (abs(e)/abs(t1.c)) in (select 19 from t1 union select d from t1) and t1.c>=17 or 19=t1.a) then f else a end then t1.d else e end))-f),e))*min(f) | ++min(a) from t1 union select cast(avg(f) AS integer) from t1)"
    end, {
        -- <randexpr-2.1174>
        
        -- </randexpr-2.1174>
    })

test:do_test(
    "randexpr-2.1175",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where (t1.b- -b+(select +case max(b)-~count(distinct e*(select case max(c) when abs((count(*))) then max(t1.f) else max(t1.c) end+cast(avg(t1.b) AS integer) from t1)) when abs(count(distinct e*19)) then max(b) else max(t1.c) end | count(distinct t1.e) from t1)-b*+t1.b not in ((11),17,13)))),t1.e) FROM t1 WHERE NOT (t1.c in (select min(coalesce((select 17 from t1 where t1.c | 17>=(abs(t1.a)/abs(case when t1.e not in (19,t1.d,19) then a when 13<=case when not exists(select 1 from t1 where (abs(e)/abs(t1.c)) in (select 19 from t1 union select d from t1) and t1.c>=17 or 19=t1.a) then f else a end then t1.d else e end))-f),e))*min(f) | ++min(a) from t1 union select cast(avg(f) AS integer) from t1))"
    end, {
        -- <randexpr-2.1175>
        500
        -- </randexpr-2.1175>
    })

test:do_test(
    "randexpr-2.1176",
    function()
        return test:execsql "SELECT coalesce((select 17 from t1 where not exists(select 1 from t1 where (t1.b- -b+(select +case max(b)-~count(distinct e*(select case max(c) when abs((count(*))) then max(t1.f) else max(t1.c) end+cast(avg(t1.b) AS integer) from t1)) when abs(count(distinct e*19)) then max(b) else max(t1.c) end & count(distinct t1.e) from t1)-b*+t1.b not in ((11),17,13)))),t1.e) FROM t1 WHERE NOT (t1.c in (select min(coalesce((select 17 from t1 where t1.c | 17>=(abs(t1.a)/abs(case when t1.e not in (19,t1.d,19) then a when 13<=case when not exists(select 1 from t1 where (abs(e)/abs(t1.c)) in (select 19 from t1 union select d from t1) and t1.c>=17 or 19=t1.a) then f else a end then t1.d else e end))-f),e))*min(f) | ++min(a) from t1 union select cast(avg(f) AS integer) from t1))"
    end, {
        -- <randexpr-2.1176>
        500
        -- </randexpr-2.1176>
    })

test:do_test(
    "randexpr-2.1177",
    function()
        return test:execsql "SELECT case coalesce((select t1.e from t1 where +coalesce((select a from t1 where 13 | b | t1.b<=11*a*case when exists(select 1 from t1 where (a-t1.d+t1.e-f<17 and  -17 between 19 and a)) then c when 17 between f and t1.c then a*11 else t1.d end),t1.e) not in (b,t1.f,t1.d)),a) when c then  -c else t1.b end FROM t1 WHERE (exists(select 1 from t1 where case when not exists(select 1 from t1 where (select cast(avg(d) AS integer) from t1) in (select a from t1 union select case case when t1.e>t1.d or t1.b in (select c from t1 union select e from t1) or t1.a>=f and b>=11 then t1.c-(t1.c)*19 when b not in (e,c,t1.d) then t1.b else t1.c end when 13 then f else  -t1.f end from t1)) then 17 when not exists(select 1 from t1 where not exists(select 1 from t1 where f not in (t1.d,f, -t1.b)) or  -19<=t1.c) or t1.e between 13 and t1.a then f else d end<>t1.f) and f between 11 and t1.c and t1.e not in (t1.d,c,t1.e)) or d not between t1.b and t1.d"
    end, {
        -- <randexpr-2.1177>
        
        -- </randexpr-2.1177>
    })

test:do_test(
    "randexpr-2.1178",
    function()
        return test:execsql "SELECT case coalesce((select t1.e from t1 where +coalesce((select a from t1 where 13 | b | t1.b<=11*a*case when exists(select 1 from t1 where (a-t1.d+t1.e-f<17 and  -17 between 19 and a)) then c when 17 between f and t1.c then a*11 else t1.d end),t1.e) not in (b,t1.f,t1.d)),a) when c then  -c else t1.b end FROM t1 WHERE NOT ((exists(select 1 from t1 where case when not exists(select 1 from t1 where (select cast(avg(d) AS integer) from t1) in (select a from t1 union select case case when t1.e>t1.d or t1.b in (select c from t1 union select e from t1) or t1.a>=f and b>=11 then t1.c-(t1.c)*19 when b not in (e,c,t1.d) then t1.b else t1.c end when 13 then f else  -t1.f end from t1)) then 17 when not exists(select 1 from t1 where not exists(select 1 from t1 where f not in (t1.d,f, -t1.b)) or  -19<=t1.c) or t1.e between 13 and t1.a then f else d end<>t1.f) and f between 11 and t1.c and t1.e not in (t1.d,c,t1.e)) or d not between t1.b and t1.d)"
    end, {
        -- <randexpr-2.1178>
        200
        -- </randexpr-2.1178>
    })

test:do_test(
    "randexpr-2.1179",
    function()
        return test:execsql "SELECT case coalesce((select t1.e from t1 where +coalesce((select a from t1 where 13 & b & t1.b<=11*a*case when exists(select 1 from t1 where (a-t1.d+t1.e-f<17 and  -17 between 19 and a)) then c when 17 between f and t1.c then a*11 else t1.d end),t1.e) not in (b,t1.f,t1.d)),a) when c then  -c else t1.b end FROM t1 WHERE NOT ((exists(select 1 from t1 where case when not exists(select 1 from t1 where (select cast(avg(d) AS integer) from t1) in (select a from t1 union select case case when t1.e>t1.d or t1.b in (select c from t1 union select e from t1) or t1.a>=f and b>=11 then t1.c-(t1.c)*19 when b not in (e,c,t1.d) then t1.b else t1.c end when 13 then f else  -t1.f end from t1)) then 17 when not exists(select 1 from t1 where not exists(select 1 from t1 where f not in (t1.d,f, -t1.b)) or  -19<=t1.c) or t1.e between 13 and t1.a then f else d end<>t1.f) and f between 11 and t1.c and t1.e not in (t1.d,c,t1.e)) or d not between t1.b and t1.d)"
    end, {
        -- <randexpr-2.1179>
        200
        -- </randexpr-2.1179>
    })

test:do_test(
    "randexpr-2.1180",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where b<>coalesce((select (select + - -count(*)-~count(*)+~+case  - -count(distinct (t1.d)) when max(t1.d) then count(*) else max(a) end+(cast(avg(17) AS integer)) from t1) | d from t1 where not exists(select 1 from t1 where (abs(f)/abs(t1.c)) between 13+a and  -t1.d)),19) or (coalesce((select t1.d from t1 where (( - -19)>a)),t1.f) in (e,e,t1.e))) then t1.b*t1.f when t1.d not between (a) and a then e else b end FROM t1 WHERE not exists(select 1 from t1 where a in (select 13 from t1 union select 17 from t1))"
    end, {
        -- <randexpr-2.1180>
        120000
        -- </randexpr-2.1180>
    })

test:do_test(
    "randexpr-2.1181",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where b<>coalesce((select (select + - -count(*)-~count(*)+~+case  - -count(distinct (t1.d)) when max(t1.d) then count(*) else max(a) end+(cast(avg(17) AS integer)) from t1) | d from t1 where not exists(select 1 from t1 where (abs(f)/abs(t1.c)) between 13+a and  -t1.d)),19) or (coalesce((select t1.d from t1 where (( - -19)>a)),t1.f) in (e,e,t1.e))) then t1.b*t1.f when t1.d not between (a) and a then e else b end FROM t1 WHERE NOT (not exists(select 1 from t1 where a in (select 13 from t1 union select 17 from t1)))"
    end, {
        -- <randexpr-2.1181>
        
        -- </randexpr-2.1181>
    })

test:do_test(
    "randexpr-2.1182",
    function()
        return test:execsql "SELECT case when exists(select 1 from t1 where b<>coalesce((select (select + - -count(*)-~count(*)+~+case  - -count(distinct (t1.d)) when max(t1.d) then count(*) else max(a) end+(cast(avg(17) AS integer)) from t1) & d from t1 where not exists(select 1 from t1 where (abs(f)/abs(t1.c)) between 13+a and  -t1.d)),19) or (coalesce((select t1.d from t1 where (( - -19)>a)),t1.f) in (e,e,t1.e))) then t1.b*t1.f when t1.d not between (a) and a then e else b end FROM t1 WHERE not exists(select 1 from t1 where a in (select 13 from t1 union select 17 from t1))"
    end, {
        -- <randexpr-2.1182>
        120000
        -- </randexpr-2.1182>
    })

test:do_test(
    "randexpr-2.1183",
    function()
        return test:execsql "SELECT coalesce((select case when f>17-t1.f then (select +max(coalesce((select +11 from t1 where coalesce((select max(d) from t1 where +t1.c between (f) and c),t1.f) not in (c, -f,t1.e)),d)) from t1) else 17+19 end from t1 where not not exists(select 1 from t1 where t1.a in (select a from t1 union select t1.a from t1) and 17=d or (17)<=(( -19)) and t1.f in (select d from t1 union select 13 from t1) or 19>13 or t1.b not in (t1.b,17,d))), -(t1.c)) FROM t1 WHERE +t1.a-13+(select count(distinct a) from t1)-e*e*case when coalesce((select max(coalesce((select a from t1 where ((case b+t1.c-t1.c*d*17 when t1.a then t1.a else f end<>c))),t1.b+13)) from t1 where t1.f between 17 and t1.d),t1.c)<=(b) then f else t1.e end-13<>t1.f"
    end, {
        -- <randexpr-2.1183>
        11
        -- </randexpr-2.1183>
    })

test:do_test(
    "randexpr-2.1184",
    function()
        return test:execsql "SELECT coalesce((select case when f>17-t1.f then (select +max(coalesce((select +11 from t1 where coalesce((select max(d) from t1 where +t1.c between (f) and c),t1.f) not in (c, -f,t1.e)),d)) from t1) else 17+19 end from t1 where not not exists(select 1 from t1 where t1.a in (select a from t1 union select t1.a from t1) and 17=d or (17)<=(( -19)) and t1.f in (select d from t1 union select 13 from t1) or 19>13 or t1.b not in (t1.b,17,d))), -(t1.c)) FROM t1 WHERE NOT (+t1.a-13+(select count(distinct a) from t1)-e*e*case when coalesce((select max(coalesce((select a from t1 where ((case b+t1.c-t1.c*d*17 when t1.a then t1.a else f end<>c))),t1.b+13)) from t1 where t1.f between 17 and t1.d),t1.c)<=(b) then f else t1.e end-13<>t1.f)"
    end, {
        -- <randexpr-2.1184>
        
        -- </randexpr-2.1184>
    })

test:do_test(
    "randexpr-2.1185",
    function()
        return test:execsql "SELECT coalesce((select 13 from t1 where ~(select max(b) from t1)<= -+d*f+t1.b*f or coalesce((select max(case when d=(abs(19)/abs(t1.f)) then case b+d when (abs(coalesce((select 11 from t1 where t1.f between  -d and c),t1.f))/abs(t1.a)) then b else t1.d end when a<t1.d then 13 else 11 end) from t1 where a not between t1.e and b),t1.d)>=t1.e),17)+ -c FROM t1 WHERE t1.b-+(t1.b) in (select a from t1 union select 19 from t1)"
    end, {
        -- <randexpr-2.1185>
        
        -- </randexpr-2.1185>
    })

test:do_test(
    "randexpr-2.1186",
    function()
        return test:execsql "SELECT coalesce((select 13 from t1 where ~(select max(b) from t1)<= -+d*f+t1.b*f or coalesce((select max(case when d=(abs(19)/abs(t1.f)) then case b+d when (abs(coalesce((select 11 from t1 where t1.f between  -d and c),t1.f))/abs(t1.a)) then b else t1.d end when a<t1.d then 13 else 11 end) from t1 where a not between t1.e and b),t1.d)>=t1.e),17)+ -c FROM t1 WHERE NOT (t1.b-+(t1.b) in (select a from t1 union select 19 from t1))"
    end, {
        -- <randexpr-2.1186>
        -283
        -- </randexpr-2.1186>
    })

test:do_test(
    "randexpr-2.1187",
    function()
        return test:execsql "SELECT case when (abs((abs(d)/abs(t1.f-c)))/abs( -t1.f))*case when (t1.c not in (case when t1.b>case t1.d when t1.b then e else 11 end then t1.a when ( -t1.d in (select  -count(*)-cast(avg(f) AS integer) from t1 union select count(*) from t1)) or 11 in (e,t1.e,c) then a else b end,t1.a,11) or t1.a in (17,t1.a,t1.d) and b>(t1.a)) then 11 when c<b then t1.f+t1.e else b end+t1.a>t1.b then t1.c else 17 end FROM t1 WHERE t1.b>f"
    end, {
        -- <randexpr-2.1187>
        
        -- </randexpr-2.1187>
    })

test:do_test(
    "randexpr-2.1188",
    function()
        return test:execsql "SELECT case when (abs((abs(d)/abs(t1.f-c)))/abs( -t1.f))*case when (t1.c not in (case when t1.b>case t1.d when t1.b then e else 11 end then t1.a when ( -t1.d in (select  -count(*)-cast(avg(f) AS integer) from t1 union select count(*) from t1)) or 11 in (e,t1.e,c) then a else b end,t1.a,11) or t1.a in (17,t1.a,t1.d) and b>(t1.a)) then 11 when c<b then t1.f+t1.e else b end+t1.a>t1.b then t1.c else 17 end FROM t1 WHERE NOT (t1.b>f)"
    end, {
        -- <randexpr-2.1188>
        17
        -- </randexpr-2.1188>
    })

test:do_test(
    "randexpr-2.1189",
    function()
        return test:execsql "SELECT t1.e-case when case when ((exists(select 1 from t1 where not exists(select 1 from t1 where case when not 13<=13 or (t1.c<>t1.e) then t1.d else +13 end+13 in (select max(13) | max((t1.b)) from t1 union select max(f) from t1))))) then t1.f else ~t1.e | t1.d*t1.b end+11 not between t1.c and 13 then b when (t1.f not in (19,t1.f,t1.d)) then c else  -b end FROM t1 WHERE ( -(select  -min(13-t1.b) from t1)-coalesce((select case when  -d>=t1.e or 11 between 17 and  -t1.e then 19+f when t1.f=11 then  -t1.c else t1.b end from t1 where t1.a not in (11,t1.e,t1.a)),t1.c)*11 in (select  -case abs((abs(min(t1.d)))) when max(19) then cast(avg(f) AS integer) else case count(*) when count(*) then (count(distinct t1.f)) else cast(avg(11) AS integer) end end from t1 union select min(d) from t1)) or b in (select (count(*)) from t1 union select max(t1.a) from t1)"
    end, {
        -- <randexpr-2.1189>
        
        -- </randexpr-2.1189>
    })

test:do_test(
    "randexpr-2.1190",
    function()
        return test:execsql "SELECT t1.e-case when case when ((exists(select 1 from t1 where not exists(select 1 from t1 where case when not 13<=13 or (t1.c<>t1.e) then t1.d else +13 end+13 in (select max(13) | max((t1.b)) from t1 union select max(f) from t1))))) then t1.f else ~t1.e | t1.d*t1.b end+11 not between t1.c and 13 then b when (t1.f not in (19,t1.f,t1.d)) then c else  -b end FROM t1 WHERE NOT (( -(select  -min(13-t1.b) from t1)-coalesce((select case when  -d>=t1.e or 11 between 17 and  -t1.e then 19+f when t1.f=11 then  -t1.c else t1.b end from t1 where t1.a not in (11,t1.e,t1.a)),t1.c)*11 in (select  -case abs((abs(min(t1.d)))) when max(19) then cast(avg(f) AS integer) else case count(*) when count(*) then (count(distinct t1.f)) else cast(avg(11) AS integer) end end from t1 union select min(d) from t1)) or b in (select (count(*)) from t1 union select max(t1.a) from t1))"
    end, {
        -- <randexpr-2.1190>
        300
        -- </randexpr-2.1190>
    })

test:do_test(
    "randexpr-2.1191",
    function()
        return test:execsql "SELECT t1.e-case when case when ((exists(select 1 from t1 where not exists(select 1 from t1 where case when not 13<=13 or (t1.c<>t1.e) then t1.d else +13 end+13 in (select max(13) & max((t1.b)) from t1 union select max(f) from t1))))) then t1.f else ~t1.e & t1.d*t1.b end+11 not between t1.c and 13 then b when (t1.f not in (19,t1.f,t1.d)) then c else  -b end FROM t1 WHERE NOT (( -(select  -min(13-t1.b) from t1)-coalesce((select case when  -d>=t1.e or 11 between 17 and  -t1.e then 19+f when t1.f=11 then  -t1.c else t1.b end from t1 where t1.a not in (11,t1.e,t1.a)),t1.c)*11 in (select  -case abs((abs(min(t1.d)))) when max(19) then cast(avg(f) AS integer) else case count(*) when count(*) then (count(distinct t1.f)) else cast(avg(11) AS integer) end end from t1 union select min(d) from t1)) or b in (select (count(*)) from t1 union select max(t1.a) from t1))"
    end, {
        -- <randexpr-2.1191>
        300
        -- </randexpr-2.1191>
    })

test:do_test(
    "randexpr-2.1192",
    function()
        return test:execsql "SELECT (coalesce((select c*(select +~count(distinct 19)-cast(avg(~ -c) AS integer)-max( -f)-cast(avg(t1.d) AS integer) from t1)+t1.a*t1.f+t1.e-a*b from t1 where not t1.e<t1.b or 11=d and 19<>d and 11<=t1.e and (not exists(select 1 from t1 where exists(select 1 from t1 where (13=a)) or t1.e>t1.b))),19)) FROM t1 WHERE coalesce((select max(t1.f*11) from t1 where not exists(select 1 from t1 where t1.a<>17) and t1.b>case (abs(b* -t1.a)/abs(11)) when b*case case when f>=t1.e then 11 when t1.b<=d then 17 else a end* -a when e then 11 else c end then (t1.b) else 19 end or t1.f<13), -b)>=e and ((d in (select f from t1 union select f from t1)))"
    end, {
        -- <randexpr-2.1192>
        
        -- </randexpr-2.1192>
    })

test:do_test(
    "randexpr-2.1193",
    function()
        return test:execsql "SELECT (coalesce((select c*(select +~count(distinct 19)-cast(avg(~ -c) AS integer)-max( -f)-cast(avg(t1.d) AS integer) from t1)+t1.a*t1.f+t1.e-a*b from t1 where not t1.e<t1.b or 11=d and 19<>d and 11<=t1.e and (not exists(select 1 from t1 where exists(select 1 from t1 where (13=a)) or t1.e>t1.b))),19)) FROM t1 WHERE NOT (coalesce((select max(t1.f*11) from t1 where not exists(select 1 from t1 where t1.a<>17) and t1.b>case (abs(b* -t1.a)/abs(11)) when b*case case when f>=t1.e then 11 when t1.b<=d then 17 else a end* -a when e then 11 else c end then (t1.b) else 19 end or t1.f<13), -b)>=e and ((d in (select f from t1 union select f from t1))))"
    end, {
        -- <randexpr-2.1193>
        10200
        -- </randexpr-2.1193>
    })

test:do_test(
    "randexpr-2.1194",
    function()
        return test:execsql "SELECT b-b+case when d+e between 17 and case when exists(select 1 from t1 where coalesce((select max(coalesce((select 11 from t1 where t1.e not between 13 and case when t1.e<>c then c | 19+t1.a else 17 end),t1.a)) from t1 where t1.d<=17 or a not in (b,11,a)),(t1.b))+b>=t1.a) then 11 else a end then d else a end+11*f FROM t1 WHERE (t1.b*19<=17)"
    end, {
        -- <randexpr-2.1194>
        
        -- </randexpr-2.1194>
    })

test:do_test(
    "randexpr-2.1195",
    function()
        return test:execsql "SELECT b-b+case when d+e between 17 and case when exists(select 1 from t1 where coalesce((select max(coalesce((select 11 from t1 where t1.e not between 13 and case when t1.e<>c then c | 19+t1.a else 17 end),t1.a)) from t1 where t1.d<=17 or a not in (b,11,a)),(t1.b))+b>=t1.a) then 11 else a end then d else a end+11*f FROM t1 WHERE NOT ((t1.b*19<=17))"
    end, {
        -- <randexpr-2.1195>
        6700
        -- </randexpr-2.1195>
    })

test:do_test(
    "randexpr-2.1196",
    function()
        return test:execsql "SELECT b-b+case when d+e between 17 and case when exists(select 1 from t1 where coalesce((select max(coalesce((select 11 from t1 where t1.e not between 13 and case when t1.e<>c then c & 19+t1.a else 17 end),t1.a)) from t1 where t1.d<=17 or a not in (b,11,a)),(t1.b))+b>=t1.a) then 11 else a end then d else a end+11*f FROM t1 WHERE NOT ((t1.b*19<=17))"
    end, {
        -- <randexpr-2.1196>
        6700
        -- </randexpr-2.1196>
    })

test:do_test(
    "randexpr-2.1197",
    function()
        return test:execsql "SELECT +(abs(13)/abs(+~~case t1.e | +11-b-coalesce((select max(c) from t1 where 19 in (select cast(avg(coalesce((select max(case when t1.a<t1.d and t1.f<(11) then t1.f else  -a end*t1.c) from t1 where e<=d and c<f),17)) AS integer)- -max(t1.e)-count(distinct a) from t1 union select max(f) from t1)),t1.c) when t1.a then t1.e else t1.c end*17)) FROM t1 WHERE t1.a between 19 and (t1.b)"
    end, {
        -- <randexpr-2.1197>
        0
        -- </randexpr-2.1197>
    })

test:do_test(
    "randexpr-2.1198",
    function()
        return test:execsql "SELECT +(abs(13)/abs(+~~case t1.e | +11-b-coalesce((select max(c) from t1 where 19 in (select cast(avg(coalesce((select max(case when t1.a<t1.d and t1.f<(11) then t1.f else  -a end*t1.c) from t1 where e<=d and c<f),17)) AS integer)- -max(t1.e)-count(distinct a) from t1 union select max(f) from t1)),t1.c) when t1.a then t1.e else t1.c end*17)) FROM t1 WHERE NOT (t1.a between 19 and (t1.b))"
    end, {
        -- <randexpr-2.1198>
        
        -- </randexpr-2.1198>
    })

test:do_test(
    "randexpr-2.1199",
    function()
        return test:execsql "SELECT +(abs(13)/abs(+~~case t1.e & +11-b-coalesce((select max(c) from t1 where 19 in (select cast(avg(coalesce((select max(case when t1.a<t1.d and t1.f<(11) then t1.f else  -a end*t1.c) from t1 where e<=d and c<f),17)) AS integer)- -max(t1.e)-count(distinct a) from t1 union select max(f) from t1)),t1.c) when t1.a then t1.e else t1.c end*17)) FROM t1 WHERE t1.a between 19 and (t1.b)"
    end, {
        -- <randexpr-2.1199>
        0
        -- </randexpr-2.1199>
    })

test:do_test(
    "randexpr-2.1200",
    function()
        return test:execsql "SELECT coalesce((select t1.f from t1 where case d-(select case cast(avg(coalesce((select case when not 11<>e*c then 11 else 13 end from t1 where  -t1.c not between t1.f and 11),t1.e)) AS integer) when case max( -d) when ((min(17))) then cast(avg(t1.a) AS integer) else min(e) end+cast(avg((t1.b)) AS integer) then cast(avg(t1.d) AS integer) else  -(max(c)) end from t1)-f | b*13+e when t1.b then (f) else t1.a end in (select d from t1 union select 17 from t1)),d) FROM t1 WHERE t1.e*c>13-+t1.f | (abs((select abs(min(b)-abs( - -count(distinct 17-d-13+ -e-(t1.d)*e)+max(t1.e)) | (~abs((max(c)))+cast(avg(17) AS integer)-count(*)*cast(avg(11) AS integer))) from t1))/abs(t1.f))"
    end, {
        -- <randexpr-2.1200>
        400
        -- </randexpr-2.1200>
    })

test:do_test(
    "randexpr-2.1201",
    function()
        return test:execsql "SELECT coalesce((select t1.f from t1 where case d-(select case cast(avg(coalesce((select case when not 11<>e*c then 11 else 13 end from t1 where  -t1.c not between t1.f and 11),t1.e)) AS integer) when case max( -d) when ((min(17))) then cast(avg(t1.a) AS integer) else min(e) end+cast(avg((t1.b)) AS integer) then cast(avg(t1.d) AS integer) else  -(max(c)) end from t1)-f | b*13+e when t1.b then (f) else t1.a end in (select d from t1 union select 17 from t1)),d) FROM t1 WHERE NOT (t1.e*c>13-+t1.f | (abs((select abs(min(b)-abs( - -count(distinct 17-d-13+ -e-(t1.d)*e)+max(t1.e)) | (~abs((max(c)))+cast(avg(17) AS integer)-count(*)*cast(avg(11) AS integer))) from t1))/abs(t1.f)))"
    end, {
        -- <randexpr-2.1201>
        
        -- </randexpr-2.1201>
    })

test:do_test(
    "randexpr-2.1202",
    function()
        return test:execsql "SELECT coalesce((select t1.f from t1 where case d-(select case cast(avg(coalesce((select case when not 11<>e*c then 11 else 13 end from t1 where  -t1.c not between t1.f and 11),t1.e)) AS integer) when case max( -d) when ((min(17))) then cast(avg(t1.a) AS integer) else min(e) end+cast(avg((t1.b)) AS integer) then cast(avg(t1.d) AS integer) else  -(max(c)) end from t1)-f & b*13+e when t1.b then (f) else t1.a end in (select d from t1 union select 17 from t1)),d) FROM t1 WHERE t1.e*c>13-+t1.f | (abs((select abs(min(b)-abs( - -count(distinct 17-d-13+ -e-(t1.d)*e)+max(t1.e)) | (~abs((max(c)))+cast(avg(17) AS integer)-count(*)*cast(avg(11) AS integer))) from t1))/abs(t1.f))"
    end, {
        -- <randexpr-2.1202>
        400
        -- </randexpr-2.1202>
    })

test:do_test(
    "randexpr-2.1203",
    function()
        return test:execsql "SELECT t1.b-~case when ~(abs(17)/abs(t1.a))+17+t1.b in (select count(distinct d) | count(*) from t1 union select case count(*) | count(distinct e) when count(*) then  -count(*) else cast(avg(11) AS integer) end from t1) and t1.e>b or e not between (e) and c and 17 in (t1.c,b,b) and t1.a not between a and (t1.f) then coalesce((select t1.a*t1.c from t1 where  -11 in (t1.a,(t1.f), -f)),13)*t1.c else t1.f end FROM t1 WHERE (t1.e<>t1.a+~~c-t1.a+13*e-17+t1.b)"
    end, {
        -- <randexpr-2.1203>
        801
        -- </randexpr-2.1203>
    })

test:do_test(
    "randexpr-2.1204",
    function()
        return test:execsql "SELECT t1.b-~case when ~(abs(17)/abs(t1.a))+17+t1.b in (select count(distinct d) | count(*) from t1 union select case count(*) | count(distinct e) when count(*) then  -count(*) else cast(avg(11) AS integer) end from t1) and t1.e>b or e not between (e) and c and 17 in (t1.c,b,b) and t1.a not between a and (t1.f) then coalesce((select t1.a*t1.c from t1 where  -11 in (t1.a,(t1.f), -f)),13)*t1.c else t1.f end FROM t1 WHERE NOT ((t1.e<>t1.a+~~c-t1.a+13*e-17+t1.b))"
    end, {
        -- <randexpr-2.1204>
        
        -- </randexpr-2.1204>
    })

test:do_test(
    "randexpr-2.1205",
    function()
        return test:execsql "SELECT t1.b-~case when ~(abs(17)/abs(t1.a))+17+t1.b in (select count(distinct d) & count(*) from t1 union select case count(*) & count(distinct e) when count(*) then  -count(*) else cast(avg(11) AS integer) end from t1) and t1.e>b or e not between (e) and c and 17 in (t1.c,b,b) and t1.a not between a and (t1.f) then coalesce((select t1.a*t1.c from t1 where  -11 in (t1.a,(t1.f), -f)),13)*t1.c else t1.f end FROM t1 WHERE (t1.e<>t1.a+~~c-t1.a+13*e-17+t1.b)"
    end, {
        -- <randexpr-2.1205>
        801
        -- </randexpr-2.1205>
    })

test:do_test(
    "randexpr-2.1206",
    function()
        return test:execsql "SELECT ((abs(b)/abs(t1.e+coalesce((select max((abs(coalesce((select max(11) from t1 where t1.a<=coalesce((select case when t1.a in (case t1.b when t1.d then t1.d else a end,17,11) then 13 when t1.a>b then 19 else d end from t1 where c in (select (~case count(*) when min(f) then  -min(d) else count(distinct (t1.f)) end)*(count(*)) from t1 union select  -min((t1.c)) from t1)),11) and (b<=t1.c)),t1.f))/abs(e))-13) from t1 where b not in (d,( -e),e)),c)-t1.c))) FROM t1 WHERE (exists(select 1 from t1 where b in (select +( -abs(max(19+((select case  -+cast(avg(e) AS integer) when  -max(19)-min(t1.c) | count(*) then count(distinct t1.e) else min(f) end-cast(avg( -19) AS integer)*count(*) | count(*) from t1))-17)) | +cast(avg((select cast(avg(a) AS integer) from t1)*f) AS integer)-cast(avg(13-t1.a+b) AS integer))+ -max(t1.a) from t1 union select cast(avg( -f) AS integer) from t1)))"
    end, {
        -- <randexpr-2.1206>
        
        -- </randexpr-2.1206>
    })

test:do_test(
    "randexpr-2.1207",
    function()
        return test:execsql "SELECT ((abs(b)/abs(t1.e+coalesce((select max((abs(coalesce((select max(11) from t1 where t1.a<=coalesce((select case when t1.a in (case t1.b when t1.d then t1.d else a end,17,11) then 13 when t1.a>b then 19 else d end from t1 where c in (select (~case count(*) when min(f) then  -min(d) else count(distinct (t1.f)) end)*(count(*)) from t1 union select  -min((t1.c)) from t1)),11) and (b<=t1.c)),t1.f))/abs(e))-13) from t1 where b not in (d,( -e),e)),c)-t1.c))) FROM t1 WHERE NOT ((exists(select 1 from t1 where b in (select +( -abs(max(19+((select case  -+cast(avg(e) AS integer) when  -max(19)-min(t1.c) | count(*) then count(distinct t1.e) else min(f) end-cast(avg( -19) AS integer)*count(*) | count(*) from t1))-17)) | +cast(avg((select cast(avg(a) AS integer) from t1)*f) AS integer)-cast(avg(13-t1.a+b) AS integer))+ -max(t1.a) from t1 union select cast(avg( -f) AS integer) from t1))))"
    end, {
        -- <randexpr-2.1207>
        1
        -- </randexpr-2.1207>
    })

test:do_test(
    "randexpr-2.1208",
    function()
        return test:execsql "SELECT t1.f-17+(abs(case when ~e*coalesce((select max(coalesce((select d from t1 where not  -(19*t1.d*17) not in (t1.a*t1.c,b,b)),f)) from t1 where 13 between t1.d and 19),11* -t1.e)-(t1.a)>d then 17 when (e in (select  -(t1.d) from t1 union select  -(t1.b) from t1)) then e else  -t1.d end)/abs(17))*a FROM t1 WHERE 17 in (select 19 from t1 union select  -17 | d from t1)"
    end, {
        -- <randexpr-2.1208>
        
        -- </randexpr-2.1208>
    })

test:do_test(
    "randexpr-2.1209",
    function()
        return test:execsql "SELECT t1.f-17+(abs(case when ~e*coalesce((select max(coalesce((select d from t1 where not  -(19*t1.d*17) not in (t1.a*t1.c,b,b)),f)) from t1 where 13 between t1.d and 19),11* -t1.e)-(t1.a)>d then 17 when (e in (select  -(t1.d) from t1 union select  -(t1.b) from t1)) then e else  -t1.d end)/abs(17))*a FROM t1 WHERE NOT (17 in (select 19 from t1 union select  -17 | d from t1))"
    end, {
        -- <randexpr-2.1209>
        683
        -- </randexpr-2.1209>
    })

test:do_test(
    "randexpr-2.1210",
    function()
        return test:execsql "SELECT case t1.a when case when 13+( -f-b)*c-t1.d-t1.c | c+d>=d*case when not ++c+t1.d<>+b- -a*t1.e then  -f else 17 end+t1.f then t1.e when 11<>19 then c else 11 end then e else f end FROM t1 WHERE (case when (abs(t1.f+case f-case when exists(select 1 from t1 where t1.c>13) then t1.e when t1.f>= -f then b else e end when 13 then t1.e else t1.c end)/abs(c)) in (select max(f)*max(f)*( -max( -17)) | min(t1.a) | cast(avg(13) AS integer)+count(*) from t1 union select ( -max(e)) from t1) then ( -d) when c not between f and ( -c) then 13 else b end between t1.a and e) and 19 not between 19 and c"
    end, {
        -- <randexpr-2.1210>
        
        -- </randexpr-2.1210>
    })

test:do_test(
    "randexpr-2.1211",
    function()
        return test:execsql "SELECT case t1.a when case when 13+( -f-b)*c-t1.d-t1.c | c+d>=d*case when not ++c+t1.d<>+b- -a*t1.e then  -f else 17 end+t1.f then t1.e when 11<>19 then c else 11 end then e else f end FROM t1 WHERE NOT ((case when (abs(t1.f+case f-case when exists(select 1 from t1 where t1.c>13) then t1.e when t1.f>= -f then b else e end when 13 then t1.e else t1.c end)/abs(c)) in (select max(f)*max(f)*( -max( -17)) | min(t1.a) | cast(avg(13) AS integer)+count(*) from t1 union select ( -max(e)) from t1) then ( -d) when c not between f and ( -c) then 13 else b end between t1.a and e) and 19 not between 19 and c)"
    end, {
        -- <randexpr-2.1211>
        600
        -- </randexpr-2.1211>
    })

test:do_test(
    "randexpr-2.1212",
    function()
        return test:execsql "SELECT case t1.a when case when 13+( -f-b)*c-t1.d-t1.c & c+d>=d*case when not ++c+t1.d<>+b- -a*t1.e then  -f else 17 end+t1.f then t1.e when 11<>19 then c else 11 end then e else f end FROM t1 WHERE NOT ((case when (abs(t1.f+case f-case when exists(select 1 from t1 where t1.c>13) then t1.e when t1.f>= -f then b else e end when 13 then t1.e else t1.c end)/abs(c)) in (select max(f)*max(f)*( -max( -17)) | min(t1.a) | cast(avg(13) AS integer)+count(*) from t1 union select ( -max(e)) from t1) then ( -d) when c not between f and ( -c) then 13 else b end between t1.a and e) and 19 not between 19 and c)"
    end, {
        -- <randexpr-2.1212>
        600
        -- </randexpr-2.1212>
    })

test:do_test(
    "randexpr-2.1213",
    function()
        return test:execsql "SELECT case when 19=t1.e or (abs(t1.f)/abs(((select  -count(distinct f+~t1.e-t1.b-coalesce((select max(b*c) from t1 where 17<>b),b))+~cast(avg(d) AS integer) from t1)))) not between f and d then coalesce((select max( -a) from t1 where 13<=11 or t1.d>=f),t1.d) when 17 in (select 11 from t1 union select t1.a from t1) then t1.d else t1.c end | 19 FROM t1 WHERE (case t1.d when ~a then coalesce((select max((abs( -~+b)/abs(t1.c))) from t1 where case t1.e when (abs((abs(case t1.a++t1.d | 19-coalesce((select e from t1 where b not between t1.f+b+c and t1.b), -t1.f) when t1.e then t1.a else f end)/abs(t1.b)))/abs(t1.e)) then t1.d else t1.d end>t1.f),t1.d)*t1.b else t1.f end not between a and e)"
    end, {
        -- <randexpr-2.1213>
        403
        -- </randexpr-2.1213>
    })

test:do_test(
    "randexpr-2.1214",
    function()
        return test:execsql "SELECT case when 19=t1.e or (abs(t1.f)/abs(((select  -count(distinct f+~t1.e-t1.b-coalesce((select max(b*c) from t1 where 17<>b),b))+~cast(avg(d) AS integer) from t1)))) not between f and d then coalesce((select max( -a) from t1 where 13<=11 or t1.d>=f),t1.d) when 17 in (select 11 from t1 union select t1.a from t1) then t1.d else t1.c end | 19 FROM t1 WHERE NOT ((case t1.d when ~a then coalesce((select max((abs( -~+b)/abs(t1.c))) from t1 where case t1.e when (abs((abs(case t1.a++t1.d | 19-coalesce((select e from t1 where b not between t1.f+b+c and t1.b), -t1.f) when t1.e then t1.a else f end)/abs(t1.b)))/abs(t1.e)) then t1.d else t1.d end>t1.f),t1.d)*t1.b else t1.f end not between a and e))"
    end, {
        -- <randexpr-2.1214>
        
        -- </randexpr-2.1214>
    })

test:do_test(
    "randexpr-2.1215",
    function()
        return test:execsql "SELECT case when 19=t1.e or (abs(t1.f)/abs(((select  -count(distinct f+~t1.e-t1.b-coalesce((select max(b*c) from t1 where 17<>b),b))+~cast(avg(d) AS integer) from t1)))) not between f and d then coalesce((select max( -a) from t1 where 13<=11 or t1.d>=f),t1.d) when 17 in (select 11 from t1 union select t1.a from t1) then t1.d else t1.c end & 19 FROM t1 WHERE (case t1.d when ~a then coalesce((select max((abs( -~+b)/abs(t1.c))) from t1 where case t1.e when (abs((abs(case t1.a++t1.d | 19-coalesce((select e from t1 where b not between t1.f+b+c and t1.b), -t1.f) when t1.e then t1.a else f end)/abs(t1.b)))/abs(t1.e)) then t1.d else t1.d end>t1.f),t1.d)*t1.b else t1.f end not between a and e)"
    end, {
        -- <randexpr-2.1215>
        16
        -- </randexpr-2.1215>
    })

test:do_test(
    "randexpr-2.1216",
    function()
        return test:execsql "SELECT coalesce((select t1.c from t1 where  -a in (select e from t1 union select 13 from t1)),(select count(distinct coalesce((select max((17)) from t1 where c not between case 19-t1.b when a then ~+(abs((select count(distinct (t1.a)) from t1)+(t1.b))/abs((t1.a)*a+13 | t1.d | t1.a)) else a end and 13 or d in (a,a,t1.f)),d)) from t1) | t1.d) FROM t1 WHERE e<d or case case when  -t1.a between coalesce((select coalesce((select d from t1 where (t1.f=~coalesce((select max(t1.d) from t1 where t1.d<=t1.e),f)*19)),17) from t1 where (t1.f in ( -11,t1.f,a)) or 19<=13),t1.b) and c then t1.f when t1.d=f then t1.f else f end when t1.d then 11 else 17 end*t1.e not in (t1.a,t1.f,e)"
    end, {
        -- <randexpr-2.1216>
        401
        -- </randexpr-2.1216>
    })

test:do_test(
    "randexpr-2.1217",
    function()
        return test:execsql "SELECT coalesce((select t1.c from t1 where  -a in (select e from t1 union select 13 from t1)),(select count(distinct coalesce((select max((17)) from t1 where c not between case 19-t1.b when a then ~+(abs((select count(distinct (t1.a)) from t1)+(t1.b))/abs((t1.a)*a+13 | t1.d | t1.a)) else a end and 13 or d in (a,a,t1.f)),d)) from t1) | t1.d) FROM t1 WHERE NOT (e<d or case case when  -t1.a between coalesce((select coalesce((select d from t1 where (t1.f=~coalesce((select max(t1.d) from t1 where t1.d<=t1.e),f)*19)),17) from t1 where (t1.f in ( -11,t1.f,a)) or 19<=13),t1.b) and c then t1.f when t1.d=f then t1.f else f end when t1.d then 11 else 17 end*t1.e not in (t1.a,t1.f,e))"
    end, {
        -- <randexpr-2.1217>
        
        -- </randexpr-2.1217>
    })

test:do_test(
    "randexpr-2.1218",
    function()
        return test:execsql "SELECT coalesce((select t1.c from t1 where  -a in (select e from t1 union select 13 from t1)),(select count(distinct coalesce((select max((17)) from t1 where c not between case 19-t1.b when a then ~+(abs((select count(distinct (t1.a)) from t1)+(t1.b))/abs((t1.a)*a+13 & t1.d & t1.a)) else a end and 13 or d in (a,a,t1.f)),d)) from t1) & t1.d) FROM t1 WHERE e<d or case case when  -t1.a between coalesce((select coalesce((select d from t1 where (t1.f=~coalesce((select max(t1.d) from t1 where t1.d<=t1.e),f)*19)),17) from t1 where (t1.f in ( -11,t1.f,a)) or 19<=13),t1.b) and c then t1.f when t1.d=f then t1.f else f end when t1.d then 11 else 17 end*t1.e not in (t1.a,t1.f,e)"
    end, {
        -- <randexpr-2.1218>
        0
        -- </randexpr-2.1218>
    })

test:do_test(
    "randexpr-2.1219",
    function()
        return test:execsql "SELECT case when case when t1.b<=f+coalesce((select max(11) from t1 where not e in (select count(distinct f) from t1 union select count(*) from t1)),t1.d) or 19 between (e) and 19 and f not in (t1.d,(19),t1.e) and exists(select 1 from t1 where t1.e<=19) or t1.e>t1.a then (select +abs(count(distinct t1.f)*max(13)) from t1) else +d end>=b+t1.c and b not in (f,13,b) then t1.d when b>b then d else t1.d end*11 FROM t1 WHERE d<>b"
    end, {
        -- <randexpr-2.1219>
        4400
        -- </randexpr-2.1219>
    })

test:do_test(
    "randexpr-2.1220",
    function()
        return test:execsql "SELECT case when case when t1.b<=f+coalesce((select max(11) from t1 where not e in (select count(distinct f) from t1 union select count(*) from t1)),t1.d) or 19 between (e) and 19 and f not in (t1.d,(19),t1.e) and exists(select 1 from t1 where t1.e<=19) or t1.e>t1.a then (select +abs(count(distinct t1.f)*max(13)) from t1) else +d end>=b+t1.c and b not in (f,13,b) then t1.d when b>b then d else t1.d end*11 FROM t1 WHERE NOT (d<>b)"
    end, {
        -- <randexpr-2.1220>
        
        -- </randexpr-2.1220>
    })

test:do_test(
    "randexpr-2.1221",
    function()
        return test:execsql "SELECT ~(abs(case when t1.a not between  -t1.d*(b) and 17 then f when e<=t1.f then b*t1.d else 13*(a) end)/abs((coalesce((select d from t1 where +(abs((select (min(a)) from t1))/abs((select count(distinct a) from t1)))- -t1.a in (s