/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef FORMATTINGTOOLBAR_H
#define FORMATTINGTOOLBAR_H

#include <QToolBar>
#include <QAction>
#include <QTextCharFormat>
#include <QFontComboBox>
#include <QDialog>
#include <QLabel>

class ColorPicker;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class FormattingToolBar : public QToolBar
{
  Q_OBJECT
  private:
    QFontComboBox* m_fontFamilyCmbx;
    QComboBox*     m_fontSizeCmbx;
    QComboBox*     m_textStyleCmbx;

    QAction*       m_setBoldAct;
    QAction*       m_setItalicAct;
    QAction*       m_setUnderlineAct;
    QAction*       m_insertTableAct;

    ColorPicker*   m_colorPicker;
    QDialog*       m_tableSizeDlg;

    int            m_tableRows;
    int            m_tableCols;

    QLabel*        m_enterTableSizeLab;
    QLabel*        m_rowsLab;
    QLabel*        m_colsLab;

  public:
    FormattingToolBar(QWidget*);
    ~FormattingToolBar();

    void retranslate();
    void setIcons();

  private slots:
    void setTableRows (int val){m_tableRows = val;}
    void setTableCols (int val){m_tableCols  = val;}
    void createTable(){emit wantCreateTable(m_tableRows, m_tableCols);}

  public slots:
    void currentCharFormatChanged(const QTextCharFormat &);

  signals:
    void wantSetBold(bool);
    void wantSetItalic(bool);
    void wantSetUnderline(bool);
    void wantSetColor(const QColor&);
    void wantSetFontFamily(const QString&);
    void wantSetFontSize(const QString&);
    void wantSetTextStyle(int);
    void wantCreateTable(uint, uint);
};

#endif
