###############################################################################
# 
#  Copyright (2008) Alexander Stukowski
#
#  This file is part of OVITO (Open Visualization Tool).
#
#  OVITO is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  OVITO is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
###############################################################################

#
# This Python package is part of the highlevel scripting interface
# for the AtomViz plugin.
#

import math
import sys

from Scripting import *
from AtomViz import *
from AtomImport import *

def RenderSnapshot(templateFile, dumpFile, imageFile):

	# Load the template scene file
	DataSetManager.Instance.FileLoad(templateFile)

	# Get access to the atoms object
	atomsNode = GetAtomsObjectNode()
	if atomsNode == None:
		raise RuntimeError, "The scene '%s' does not contain any atoms object." % templateFile		
	obj = atomsNode.SceneObject
	while obj != None and not isinstance(obj, AtomsImportObject) and isinstance(obj, ModifiedObject):
		obj = obj.InputObject
	if not isinstance(obj, AtomsImportObject):
		raise RuntimeError, "The object node does not contain an AtomsImportObject."

	# Load a new dump file.
	obj.Parser.InputFile = dumpFile
	obj.ReloadInputFile()
	
	# Iterate over all modifiers and update analysis modifiers.
	obj = atomsNode.SceneObject
	while isinstance(obj, ModifiedObject):
		for modapp in obj.ModifierApplications:
			modifier = modapp.Modifier
			if isinstance(modifier, AtomsObjectAnalyzerBase):
				modifier.PerformAnalysis(AnimManager.Instance.Time, True)
		obj = obj.InputObject

	# Render scene to image file
	DataSetManager.Instance.CurrentSet.RenderSettings.ImageFilename = imageFile
	ActionManager.Instance.InvokeAction(ActionManager.ACTION_RENDER_ACTIVE_VIEWPORT)
