###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hyleos_chemview_activex_mult_bof_vuln.nasl 7392 2010-02-26 17:50:24Z feb $
#
# Hyleos ChemView ActiveX Control Multiple Buffer Overflow Vulnerabilities
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900749);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0679");
  script_bugtraq_id(38225);
  script_name("Hyleos ChemView ActiveX Control Multiple Buffer Overflow Vulnerabilities");
  desc = "
  Overview: This host is installed with Hyleos ChemView ActiveX Control and is
  prone to multiple Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to two boundary errors in the 'HyleosChemView.ocx'
  which can be exploited to cause stack-based buffer overflows by passing
  strings containing an overly large number of white-space characters to the
  'SaveasMolFile()' and 'ReadMolFile()' methods.

  Impact:
  Successful exploitation could allow an attacker to execute arbitrary code
  within the context of the affected application.

  Impact Level: Application

  Affected Software/OS:
  Hyleos ChemView ActiveX Control version 1.9.5.1 and prior.

  Workaround:
  Set the Killbit for the vulnerable CLSID {C372350A-1D5A-44DC-A759-767FC553D96C}

  Fix: No solution or patch is available as on 25th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.hyleos.net/?s=applications&p=ChemView

  References:
  http://secunia.com/advisories/38523
  http://www.exploit-db.com/exploits/11422
  http://packetstormsecurity.org/1002-advisories/chemviewx-overflow.txt
  http://packetstormsecurity.org/1002-exploits/hyleoschemview-heap.rb.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the HyleosChemView.ocx Version and Killbit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_hyleos_chemview_detect.nasl");
  script_require_keys("Hyleos/ChemViewX/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

chemVer = get_kb_item("Hyleos/ChemViewX/Ver");
if(!chemVer){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
      exit(0);
}

if(!version_is_less_equal(version:chemVer, test_version:"1.9.5.1")){
  exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  name = registry_get_sz(key:key + item, item:"DisplayName");
  if("Hyleos - ChemViewX" >< name)
  {
    chemPath = registry_get_sz(key:key + item, item:"InstallLocation");
    dllPath = chemPath + "\Common\HyleosChemView.ocx";

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

    dllVer = GetVer(file:file, share:share);
    if(dllVer != NULL)
    {
      # Grep for HyleosChemView.ocx version 1.9.5.1 and prior
      if(version_is_less_equal(version:dllVer, test_version:"1.9.5.1"))
      {
        # Workaround check
        if(is_killbit_set(clsid:"{C372350A-1D5A-44DC-A759-767FC553D96C}") == 0){
          security_hole(0);
        }
      }
    }
  }
}
