###############################################################################
# OpenVAS Vulnerability Test
# $Id: httpdx_38242.nasl 7515 2010-05-04 08:18:47Z chandra $
#
# httpdx 'MKD' Command Directory Traversal Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100496);
 script_bugtraq_id(38242);
 script_version ("1.0-$Revision: 7515 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("httpdx 'MKD' Command Directory Traversal Vulnerability");

desc = "Overview:
The 'httpdx' program is prone to a directory-traversal vulnerability
because it fails to sufficiently sanitize user-supplied input.

Exploiting this issue allows an authenticated user to create
directories outside the FTP root directory, which may lead to
other attacks.

This issue affects httpdx 1.5; other versions may also be affected.

References:
http://www.securityfocus.com/bid/38242
http://sourceforge.net/projects/httpdx/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if httpdx is prone to a directory-traversal vulnerability");
 script_category(ACT_ATTACK);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port);
if("httpdx" >!< banner)exit(0);

version = eregmatch(pattern: "httpdx/([0-9.]+)", string:banner);
if(!isnull(version[1])) {
 
  if(version_is_equal(version: version[1], test_version: "1.5")) {
    security_warning(port:port);
    exit(0);
  }   
}  

exit(0);
