###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_serv_bof_vuln_lin.nasl 5655 2009-11-10 12:25:32Z nov $
#
# Sun Java System Web Server Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801147);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3878");
  script_bugtraq_id(36813);
  script_name("Sun Java System Web Server Buffer Overflow Vulnerability (Linux)");
  desc = "
  Overview: This host has Sun Java Web Server running which is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  An unspecified error that can be exploited to cause a buffer overflow.

  Impact:
  Successful exploitation lets the attackers to execute arbitrary code
  in the context of an affected system.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java System Web Server version 7.0 update 6 and prior on Linux.

  Fix:
  No solution or patch is available as on 10th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.sun.com/

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=79
  http://secunia.com/advisories/37115
  http://www.vupen.com/english/advisories/2009/3024

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Java System Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_require_ports("Services/www", 80, 8888, 8989);
  exit(0);
}


include("ssh_func.inc");
include("http_func.inc");
include("version_func.inc");

foreach jswsPort (make_list(8989, 8888, 80))
{
  if(get_port_state(jswsPort))
  {
    jswsSock = ssh_login_or_reuse_connection();
    if(!jswsSock){
      exit(0);
    }

    paths = find_file(file_name:"webservd", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:jswsSock);
    foreach jswsBin (paths)
    {
      ver = get_bin_version(full_prog_name:chomp(jswsBin), sock:jswsSock,
                            version_argv:"-v",
                            ver_pattern:"Sun (ONE |Java System )Web Server " +
                                        "([0-9.]+)(SP|U)?([0-9]+)?([^0-9.]|$)");
      if(ver[2] != NULL)
      {
        if(ver[4] != NULL)
          ver = ver[2] + "." + ver[4];
        else
          ver = ver[2];

        # Check for Web Server version <= 7.0 Update 6
        if(version_is_less_equal(version:ver, test_version:"7.0.6"))
        {
          security_hole(jswsPort);
          exit(0);
        }
      }
    }
  }
}
ssh_close_connection();
