/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_SoftwareInstallationServiceCapabilitiesAccess.h"

string InstanceID="OpenDRIM:SoftwareInstallationServiceCapabilities:";

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	string name;
	CF_assert(CF_getSoftwareInstallationServiceName(name,errorMessage));
	InstanceID+=name;
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareInstallationServiceCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_SoftwareInstallationServiceCapabilities instance;
	
	instance.setInstanceID(InstanceID);
	
	if(discriminant=="ei")
		CF_assert(SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareInstallationServiceCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	if(instance.InstanceID!=InstanceID)
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	
	CF_assert(SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_populate(instance,errorMessage));
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationServiceCapabilities& newInstance, const OpenDRIM_SoftwareInstallationServiceCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationServiceCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareInstallationServiceCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_SoftwareInstallationServiceCapabilities_populate(OpenDRIM_SoftwareInstallationServiceCapabilities& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID                      [KEY]
	 * [X] SupportedInstallOptions
	 * + Optional:
	 * [X] SupportedExtendedResourceTypes
	 */
	
	vector<unsigned short> resourceTypes;
	vector<unsigned short> installOptions;
	
	if(instance.InstanceID.substr(49)=="apt")
		resourceTypes.push_back(8); // 8 value for Deb package
	else if(instance.InstanceID.substr(49)=="yum")
		resourceTypes.push_back(3);// 3 value for RPM package
	instance.setSupportedExtendedResourceTypes(resourceTypes);
	
	installOptions.push_back(4); // 4 - install
	installOptions.push_back(5); // 5 - update
	installOptions.push_back(9); // 9 - uninstall
	instance.setSupportedInstallOptions(installOptions);
	_L_;
	return OK;
}

