<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<div class="section">
	<h1>Welcome to Spring Travel</h1>
	<p>
	 	This reference application shows how to use Spring MVC, Spring Javascript, and Spring Web Flow together with JavaServerPages (JSP) and Tiles to power rich web applications.
	</p>
	<p>
		The key features illustrated in this sample include:
	</p>
	<ul>
		<li>A declarative navigation model enabling full browser button support and dynamic navigation rules</li>
		<li>A fine-grained state management model, including support for ConversationScope and ViewScope</li>
		<li>Modularization of web application functionality by domain use case, illustrating project structure best-practices</li>
		<li>Managed persistence contexts with the Java Persistence API (JPA)</li>
		<li>Unified Expression Language (EL) integration</li>
		<li>Spring Security integration</li>
		<li>Annotated POJO @Controllers for implementing RESTful user interactions.
		<li>Declarative page authoring with JSP, JSTL, and Spring MVC's form tag library</li>
		<li>Page layout and composition with Tiles</li>
		<li>A Javascript API for decorating HTML elements with behaviors such as Ajax, validation, and effects.	
		<li>Exception handling support across all layers of the application</li>
		<li>Spring IDE tooling integration, with support for graphical flow modeling and visualization</li>
	</ul>
	<p align="right">
		<a href="hotels/index">Start your Spring Travel experience</a>
	</p>
</div>
