/* bg.hh - send process to the background
 * Copyright 2005 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_BG_HH
#define SHEVEK_BG_HH

namespace shevek
{
  /// Send process to the background.
  /** Send process to the background, returning control to the caller.  If "bg"
   *  is specified in the environment variable SHEVEK_DEBUG, this function's
   *  only action is to print a message to the standard error pipe.
   */
  void bg (bool exit_on_fail = true);
}

#endif
