//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An SBML compartment, where species are located.
 *
 * A compartment in SBML represents a bounded space in which species are
 * located.  Compartments do not necessarily have to correspond to actual
 * structures inside or outside of a biological cell.
 *
 * It is important to note that although compartments are optional in the
 * overall definition of Model, every species in an SBML model must be
 * located in a compartment.  This in turn means that if a model defines
 * any species, the model must also define at least one compartment.  The
 * reason is simply that species represent physical things, and therefore
 * must exist @em somewhere.  Compartments represent the @em somewhere.
 *
 * Compartment has one required attribute, 'id', to give the compartment a
 * unique identifier by which other parts of an SBML model definition can
 * refer to it.  A compartment can also have an optional 'name' attribute
 * of type @c string.  Identifiers and names must be used according to the
 * guidelines described in the SBML specifications.
 *
 * Compartment also has an optional attribute 'spatialDimensions' that is
 * used to indicate the number of spatial dimensions possessed by the
 * compartment.  Most modeling scenarios involve compartments with integer
 * values of 'spatialDimensions' of @c 3 (i.e., a three-dimensional
 * compartment, which is to say, a volume), or 2 (a two-dimensional
 * compartment, a surface), or @c 1 (a one-dimensional compartment, a
 * line).  In SBML Level&nbsp;3, the type of this attribute is @c double,
 * there are no restrictions on the permitted values of the
 * 'spatialDimensions' attribute, and there are no default values.  In SBML
 * Level&nbsp;2, the value must be a positive @c integer, and the default
 * value is @c 3; the permissible values in SBML Level&nbsp;2 are @c 3,
 * @c 2, @c 1, and @c 0 (for a point).
 *
 * Another optional attribute on Compartment is 'size', representing the @em
 * initial total size of that compartment in the model.  The 'size' attribute
 * must be a floating-point value and may represent a volume (if the
 * compartment is a three-dimensional one), or an area (if the compartment is
 * two-dimensional), or a length (if the compartment is one-dimensional).
 * There is no default value of compartment size in SBML Level&nbsp;2 or
 * Level&nbsp;3.  In particular, a missing 'size' value <em>does not imply
 * that the compartment size is 1</em>.  (This is unlike the definition of
 * compartment 'volume' in SBML Level&nbsp;1.)  When the compartment's
 * 'spatialDimensions' attribute does not have a value of @c 0, a missing
 * value of 'size' for a given compartment signifies that the value either is
 * unknown, or to be obtained from an external source, or determined by an
 * InitialAssignment, AssignmentRule, AlgebraicRule or RateRule
 * @if conly structure @else object@endif elsewhere in the model.  In SBML
 * Level&nbsp;2, there are additional special requirements on the values of
 * 'size'; we discuss them in a <a href='#comp-l2'>separate section
 * below</a>.
 *
 * The units associated with a compartment's 'size' attribute value may be
 * set using the optional attribute 'units'.  The rules for setting and
 * using compartment size units differ between SBML Level&nbsp;2 and
 * Level&nbsp;3, and are discussed separately below.
 *
 * Finally, the Compartment attribute named 'constant' is used to
 * indicate whether the compartment's size stays constant after simulation
 * begins.  A value of @c true indicates the compartment's 'size' cannot be
 * changed by any other construct except InitialAssignment; a value of
 * @c false indicates the compartment's 'size' can be changed by other
 * constructs in SBML.  In SBML Level&nbsp;2, there is an additional
 * explicit restriction that if 'spatialDimensions'=@c '0', the value
 * cannot be changed by InitialAssignment either.  Further, in
 * Level&nbsp;2, 'constant' is optional, and has a default value of @c true.  In SBML
 * Level&nbsp;3, there is no default value for the 'constant' attribute,
 * and it is required.
 *
 *
 * @section comp-l2 Additional considerations in SBML Level&nbsp;2
 *
 * In SBML Level&nbsp;2, the default units of compartment size, and the kinds
 * of units allowed as values of the attribute 'units', interact with the
 * number of spatial dimensions of the compartment.  The value of the 'units'
 * attribute of a Compartment @if conly structure @else object@endif must
 * be one of the base units (see Unit), or the predefined unit identifiers
 * @c volume, @c area, @c length or @c dimensionless, or a new unit defined by a
 * UnitDefinition @if conly structure @else object@endif in the enclosing
 * Model, subject to the restrictions detailed in the following table:
 *
 * <table border='0' class='centered text-table width80 normal-font alt-row-colors'
 *        style='padding-bottom: 0.5em'>
 * <caption class='top-caption'>Restrictions on values permitted for
 * compartment <code>size</code> and <code>units</code> attributes.</caption>
 *  <tr>
 *      <th align='left' valign='bottom'>
 *        Value of<br><code>spatialDimensions</code>
 *      </th>
 *      <th align='left' valign='bottom'>
 *        <code>size</code><br>allowed?
 *      </th>
 *      <th align='left' valign='bottom'>
 *        <code>units</code><br>allowed?
 *      </th>
 *      <th align='left' valign='bottom'>
 * 	  Allowable kinds of units
 *      </th>
 *      <th align='left' valign='bottom'>
 * 	  Default value of attribute <code>units</code>
 *      </th>
 *  </tr>
 *  <tr>
 *      <td><code>3</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of volume, or <code>dimensionless</code></td>
 *      <td><code>volume</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>2</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of area, or <code>dimensionless</code></td>
 *      <td><code>area</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>1</code></td>
 *      <td>yes</td>
 *      <td>yes</td>
 *      <td>units of length, or <code>dimensionless</code></td>
 *      <td><code>length</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>0</code></td>
 *      <td>no</td>
 *      <td>no</td>
 *      <td>(no units allowed)</td>
 *      <td></td>
 *  </tr>
 *  </tr>
 * </table>
 *
 * In SBML Level&nbsp;2, the units of the compartment size, as defined by the
 * 'units' attribute or (if 'units' is not set) the default value listed in
 * the table above, are used in the following ways when the compartment has
 * a 'spatialDimensions' value greater than @c 0:
 * <ul>
 * <li> The value of the 'units' attribute is used as the units of the
 * compartment identifier when the identifier appears as a numerical
 * quantity in a mathematical formula expressed in MathML.
 *
 * <li> The @c math element of an AssignmentRule or InitialAssignment
 * referring to this compartment @em must (in Level&nbsp;2 Versions&nbsp;1-3)
 * or @em should (in Level&nbsp;2 Version 4) have identical units.
 *
 * <li> In RateRule objects that set the rate of change of the compartment's
 * size, the units of the rule's @c math element @em must (in Level&nbsp;2 
 * Versions&nbsp;1&ndash;3) or @em should (in Level&nbsp;2 Version 4) be identical to the
 * compartment's units (whether defined by the 'units' attribute or by taking the 
 * default value from the Model) divided by the default @em time units.
 * (In other words, the units for the rate of change of compartment size
 * are <em>compartment size</em>/<em>time</em> units.
 *
 * <li> When a Species is to be treated in terms of concentrations or
 * density, the units of the spatial size portion of the concentration
 * value (i.e., the denominator in the units formula @em substance/@em
 * size) are those indicated by the value of the 'units' attribute on the
 * compartment in which the species is located.
 * </ul>
 *
 * Compartments with 'spatialDimensions'=@c 0 require special treatment in
 * this framework.  As implied above, the 'size' attribute must not have a
 * value on an SBML Level&nbsp;2 Compartment
 * @if conly structure @else object@endif if the 'spatialDimensions'
 * attribute has a value of @c 0.  An additional related restriction is that
 * the 'constant' attribute must default to or be set to @c true if the value
 * of the 'spatialDimensions' attribute is @c 0, because a zero-dimensional
 * compartment cannot ever have a size.
 *
 * If a compartment has no size or dimensional units, how should such a
 * compartment's identifier be interpreted when it appears in mathematical
 * formulas?  The answer is that such a compartment's identifier should not
 * appear in mathematical formulas in the first place---it has no
 * value, and its value cannot change.  Note also that a zero-dimensional
 * compartment is a point, and species located at points can only be
 * described in terms of amounts, not spatially-dependent measures such as
 * concentration.  Since SBML KineticLaw formulas are already in terms of
 * @em substance/@em time and not (say) @em concentration/@em time, volume
 * or other factors in principle are not needed for species located in
 * zero-dimensional compartments.
 *
 * Finally, in SBML Level&nbsp;2 Versions 2&ndash;4, each compartment in a
 * model may optionally be designated as belonging to a particular
 * compartment @em type.  The optional attribute 'compartmentType' is used
 * identify the compartment type represented by the Compartment structure.
 * The 'compartmentType' attribute's value must be the identifier of a
 * CompartmentType instance defined in the model.  If the 'compartmentType'
 * attribute is not present on a particular compartment definition, a
 * unique virtual compartment type is assumed for that compartment, and no
 * other compartment can belong to that compartment type.  The values of
 * 'compartmentType' attributes on compartments have no effect on the
 * numerical interpretation of a model.  Simulators and other numerical
 * analysis software may ignore 'compartmentType' attributes.  The
 * 'compartmentType' attribute and the CompartmentType
 * @if conly structures @else class of objects@endif are
 * not present in SBML Level&nbsp;3 Core nor in SBML Level&nbsp;1.
 *
 *
 * @section comp-l3 Additional considerations in SBML Level&nbsp;3
 *
 * One difference between SBML Level&nbsp;3 and lower Levels of SBML is
 * that there are no restrictions on the permissible values of the
 * 'spatialDimensions' attribute, and there is no default value defined for
 * the attribute.  The value of 'spatialDimensions' does not have to be an
 * integer, either; this is to allow for the possibility of representing
 * structures with fractal dimensions.
 *
 * The number of spatial dimensions possessed by a compartment cannot enter
 * into mathematical formulas, and therefore cannot directly alter the
 * numerical interpretation of a model.  However, the value of
 * 'spatialDimensions' @em does affect the interpretation of the units
 * associated with a compartment's size.  Specifically, the value of
 * 'spatialDimensions' is used to select among the Model attributes
 * 'volumeUnits', 'areaUnits' and 'lengthUnits' when a Compartment
 * @if conly object @else structure@endif does not define a value for its
 * 'units' attribute.
 *
 * The 'units' attribute may be left unspecified for a given compartment in a
 * model; in that case, the compartment inherits the unit of measurement
 * specified by one of the attributes on the enclosing Model
 * @if conly structure @else object@endif instance.  The applicable
 * attribute on Model depends on the value of the compartment's
 * 'spatialDimensions' attribute; the relationship is shown in the table
 * below.  If the Model @if conly structure @else object@endif does not
 * define the relevant attribute ('volumeUnits', 'areaUnits' or
 * 'lengthUnits') for a given 'spatialDimensions' value, the unit associated
 * with that Compartment @if conly structure @else object@endif's size is
 * undefined.  If a given Compartment's 'units' are left unset and 
 * the 'spatialDimensions' either has a value other than @c 1, @c 2, or 
 * @c 3 or is left unset itself (as it has no default value),
 * then no unit can be chosen from among the Model's 'volumeUnits',
 * 'areaUnits' or 'lengthUnits' attributes (even if the Model instance
 * provides values for those attributes), because there is no basis to select
 * between them.
 * Leaving the units of compartments' sizes undefined in an SBML model does
 * not render the model invalid; however, as a matter of best practice, we
 * strongly recommend that all models specify the units of measurement for
 * all compartment sizes.
 *
 * <table border='0' class='centered text-table width80 normal-font alt-row-colors'
 *        style='padding-bottom: 0.5em'>
 * <caption class='top-caption'>Interpretation of the Compartment 'units' attribute.</caption>
 *  <tr>
 *      <th align='left' valign='bottom'>
 *        Value of attribute<br>'spatialDimensions'
 *      </th>
 *      <th align='left' valign='bottom'>
 *        Attribute of Model used<br>for inheriting the unit
 *      </th>
 *      <th align='left' valign='bottom'>
 *        Recommended candidate units
 *      </th>
 *  </tr>
 *  <tr>
 *      <td><code>3</code></td>
 *      <td>&quot;volumeUnits&quot;</td>
 *      <td>units of volume, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>2</code></td>
 *      <td>&quot;areaUnits&quot;</td>
 *      <td>units of area, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><code>1</code></td>
 *      <td>&quot;lengthUnits&quot;</td>
 *      <td>units of length, or <code>dimensionless</code></td>
 *  </tr>
 *  <tr>
 *      <td><em>other</em></td>
 *      <td><em>no units inherited</em></td>
 *      <td><em>no specific recommendations</em></td>
 *  </tr>
 *  </tr>
 * </table>
 *
 * The unit of measurement associated with a compartment's size, as defined
 * by the 'units' attribute or (if 'units' is not set) the inherited value
 * from Model according to the table above, is used in the following ways:
 *
 * <ul>
 *
 * <li> When the identifier of the compartment appears as a numerical
 * quantity in a mathematical formula expressed in MathML, it represents
 * the size of the compartment, and the unit associated with the size is
 * the value of the 'units' attribute.
 *
 * <li> When a Species is to be treated in terms of concentrations or
 * density, the unit associated with the spatial size portion of the
 * concentration value (i.e., the denominator in the formula
 * <em>amount</em>/<em>size</em>) is specified by the value of the 'units'
 * attribute on the compartment in which the species is located.
 *
 * <li> The 'math' elements of AssignmentRule, InitialAssignment and
 * EventAssignment @if conly structures @else objects@endif setting the
 * value of the compartment size should all have the same units as the unit
 * associated with the compartment's size.
 *
 * <li> In a RateRule @if conly structure @else object@endif that defines a
 * rate of change for a compartment's size, the unit of the rule's 'math'
 * element should be identical to the compartment's 'units' attribute divided
 * by the model-wide unit of <em>time</em>.  (In other words, {<em>unit of
 * compartment size</em>}/{<em>unit of time</em>}.)
 *
 * </ul>
 *
 *
 * @section comp-other Other aspects of Compartment
 *
 * In SBML Level&nbsp;1 and Level&nbsp;2, Compartment has an optional
 * attribute named 'outside', whose value can be the identifier of another
 * Compartment @if conly structure @else object@endif defined in the
 * enclosing Model @if conly structure @else object@endif.  Doing so means
 * that the other compartment contains it or is outside of it.  This enables
 * the representation of simple topological relationships between
 * compartments, for those simulation systems that can make use of the
 * information (e.g., for drawing simple diagrams of compartments).  It is
 * worth noting that in SBML, there is no relationship between compartment
 * sizes when compartment positioning is expressed using the 'outside'
 * attribute.  The size of a given compartment does not in any sense include
 * the sizes of other compartments having it as the value of their 'outside'
 * attributes.  In other words, if a compartment @em B has the identifier of
 * compartment @em A as its 'outside' attribute value, the size of @em A does
 * not include the size of @em B.  The compartment sizes are separate.
 *
 * In Level&nbsp;2, there are two restrictions on the 'outside' attribute.
 * First, because a compartment with 'spatialDimensions' of @c 0 has no
 * size, such a compartment cannot act as the container of any other
 * compartment @em except compartments that @em also have
 * 'spatialDimensions' values of @c 0.  Second, the directed graph formed
 * by representing Compartment structures as vertexes and the 'outside'
 * attribute values as edges must be acyclic.  The latter condition is
 * imposed to prevent a compartment from being contained inside itself.  In
 * the absence of a value for 'outside', compartment definitions in SBML
 * Level&nbsp;2 do not have any implied spatial relationships between each
 * other.
 *
 *
 * 
 */

public class Compartment : SBase {
	private HandleRef swigCPtr;
	
	internal Compartment(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Compartment_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.CompartmentUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Compartment obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Compartment obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Compartment() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Compartment(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Compartment object using the given SBML @p level and @p
   * version values.
   *
   * @param level a long integer, the SBML Level to assign to this Compartment.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Compartment.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Compartment(long level, long version) : this(libsbmlPINVOKE.new_Compartment__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Compartment object using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   *
   * It is worth emphasizing that although this constructor does not take an
   * identifier argument, in SBML Level&nbsp;2 and beyond, the 'id'
   * (identifier) attribute of a Compartment object is required to have a
   * value.  Thus, callers are cautioned to assign a value after calling this
   * constructor.  Setting the identifier can be accomplished using the
   * method @if java Compartment::setId(String id)@else setId()@endif.
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Compartment(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Compartment__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor.
   *
   * This creates a copy of a Compartment object.
   *
   * @param orig the Compartment instance to copy.
   */ public
 Compartment(Compartment orig) : this(libsbmlPINVOKE.new_Compartment__SWIG_2(Compartment.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Compartment object.
   *
   * @return the (deep) copy of this Compartment object.
   */ public new
 Compartment clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Compartment_clone(swigCPtr);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, true);
    return ret;
  }

  
/**
   * Initializes the fields of this Compartment object to 'typical' default
   * values.
   *
   * The SBML Compartment component has slightly different aspects and
   * default attribute values in different SBML Levels and Versions.
   * This method sets the values to certain common defaults, based
   * mostly on what they are in SBML Level&nbsp;2.  Specifically:
   *
   * @li Sets attribute 'spatialDimensions' to @c 3
   * @li Sets attribute 'constant' to @c true
   * @li (Applies to Level&nbsp;1 models only) Sets attribute 'volume' to @c 1.0
   * @li (Applies to Level&nbsp;3 models only) Sets attribute 'units' to @c litre
   */ public
 void initDefaults() {
    libsbmlPINVOKE.Compartment_initDefaults(swigCPtr);
  }

  
/**
   * Returns the value of the 'id' attribute of this Compartment.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
   *
   * @return the id of this Compartment.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Compartment_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Compartment object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Compartment_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'compartmentType' attribute of this Compartment
   * object.
   *
   * @return the value of the 'compartmentType' attribute of this
   * Compartment object as a string.
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   *
   * @see isSetCompartmentType()
   * @see setCompartmentType(@if java String@endif)
   * @see unsetCompartmentType()
   */ public
 string getCompartmentType() {
    string ret = libsbmlPINVOKE.Compartment_getCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Get the number of spatial dimensions of this Compartment object.
   *
   * @return the value of the 'spatialDimensions' attribute of this
   * Compartment object as a long integereger.
   *
   *
 * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
 * attribute is @c double, whereas in Level&nbsp;2, it is @c integer.  To
 * avoid backward compatibility issues, libSBML provides two separate methods
 * for obtaining the value as either an integer or a type @c double, for
 * models where it is relevant.
 *
 *
   *
   * @see getSpatialDimensionsAsDouble()
   * @see setSpatialDimensions(@if java unsigned int@endif)
   * @see isSetSpatialDimensions()
   * @see unsetSpatialDimensions()
   */ public
 long getSpatialDimensions() { return (long)libsbmlPINVOKE.Compartment_getSpatialDimensions(swigCPtr); }

  
/**
   * Get the number of spatial dimensions of this Compartment object,
   * as a double.
   *
   * @return the value of the 'spatialDimensions' attribute of this
   * Compartment object as a double, or @c NaN if this model is not in SBML
   * Level&nbsp;3 format.
   *
   *
 * @note In SBML Level&nbsp;3, the data type of the 'spatialDimensions'
 * attribute is @c double, whereas in Level&nbsp;2, it is @c integer.  To
 * avoid backward compatibility issues, libSBML provides two separate methods
 * for obtaining the value as either an integer or a type @c double, for
 * models where it is relevant.
 *
 *
   *
   * @see getSpatialDimensions()
   * @see setSpatialDimensions(@if java unsigned int@endif)
   * @see isSetSpatialDimensions()
   * @see unsetSpatialDimensions()
   */ public
 double getSpatialDimensionsAsDouble() {
    double ret = libsbmlPINVOKE.Compartment_getSpatialDimensionsAsDouble(swigCPtr);
    return ret;
  }

  
/**
   * Get the size of this Compartment object.
   *
   *
 * 
 * In SBML Level&nbsp;1, compartments are always three-dimensional
 * constructs and only have volumes, whereas in SBML Level&nbsp;2 and higher,
 * compartments may be other than three-dimensional, and therefore the
 * 'volume' attribute is named 'size' in Level&nbsp;2 and above.  LibSBML
 * provides both @if conly Compartment_getSize() and Compartment_getVolume()
 * @else getSize() and getVolume()@endif
 * for easier support of different SBML Levels.
 *
 *
   *
   * @return the value of the 'size' attribute ('volume' in Level&nbsp;1) of
   * this Compartment object as a floating-point number.
   *
   * @note This method is identical to
   * @if java Compartment::getVolume()@else getVolume()@endif.
   *
   * @see getVolume()
   * @see isSetSize()
   * @see setSize(@if java double@endif)
   * @see unsetSize()
   */ public
 double getSize() {
    double ret = libsbmlPINVOKE.Compartment_getSize(swigCPtr);
    return ret;
  }

  
/**
   * Get the volume of this Compartment object.
   *
   *
 * 
 * In SBML Level&nbsp;1, compartments are always three-dimensional
 * constructs and only have volumes, whereas in SBML Level&nbsp;2 and higher,
 * compartments may be other than three-dimensional, and therefore the
 * 'volume' attribute is named 'size' in Level&nbsp;2 and above.  LibSBML
 * provides both @if conly Compartment_getSize() and Compartment_getVolume()
 * @else getSize() and getVolume()@endif
 * for easier support of different SBML Levels.
 *
 *
   *
   * @return the value of the 'volume' attribute ('size' in Level&nbsp;2) of
   * this Compartment object, as a floating-point number.
   *
   *
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (@c 1.0) and therefore methods such as
 * @if conly Compartment_isSetVolume() @else isSetVolume()@endif
 * will always return @c true for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
 *
 *
   *
   * @note This method is identical to
   * @if java Compartment::getSize()@else getSize()@endif.
   *
   * @see getSize()
   * @see isSetVolume()
   * @see setVolume(@if java double@endif)
   * @see unsetVolume()
   */ public
 double getVolume() {
    double ret = libsbmlPINVOKE.Compartment_getVolume(swigCPtr);
    return ret;
  }

  
/**
   * Get the units of this Compartment object's size.
   *
   * The value of an SBML compartment's 'units' attribute establishes the
   * unit of measurement associated with the compartment's size.
   *
   * @return the value of the 'units' attribute of this Compartment object,
   * as a string.  An empty string indicates that no units have been assigned
   * to the value of the size.
   *
   *
 * @note There is an important distinction to be made between <em>no units
 * assigned</em>, and assuming a value without units has any specific unit
 * such as <code>dimensionless</code>.  In SBML, default units are never
 * attributed to numbers, and numbers without units are not automatically
 * assumed to have the unit <code>dimensionless</code>.  Please consult the
 * relevant SBML specification document for a more in-depth explanation of
 * this topic and the SBML unit system.
 *
 *
   *
   * @see isSetUnits()
   * @see setUnits(@if java String@endif)
   * @see unsetUnits()
   */ public
 string getUnits() {
    string ret = libsbmlPINVOKE.Compartment_getUnits(swigCPtr);
    return ret;
  }

  
/**
   * Get the identifier, if any, of the Compartment object that is designated
   * as being outside of @em this one.
   *
   * @return the value of the 'outside' attribute of this Compartment object.
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   *
   * @see isSetOutside()
   * @see setOutside(@if java String@endif)
   * @see unsetOutside()
   */ public
 string getOutside() {
    string ret = libsbmlPINVOKE.Compartment_getOutside(swigCPtr);
    return ret;
  }

  
/**
   * Get the value of the 'constant' attribute of this Compartment object.
   *
   * @return @c true if this Compartment object's size is flagged as being
   * constant, @c false otherwise.
   *
   * @see isSetConstant()
   * @see setConstant(@if java bool@endif)
   */ public
 bool getConstant() {
    bool ret = libsbmlPINVOKE.Compartment_getConstant(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'id' attribute
   * is set.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
 *
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Compartment_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'name'
   * attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Compartment_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's
   * 'compartmentType' attribute is set.
   *
   * @return @c true if the 'compartmentType' attribute of this Compartment
   * is set, @c false otherwise.
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   *
   * @see setCompartmentType(@if java String@endif)
   * @see getCompartmentType()
   * @see unsetCompartmentType()
   */ public
 bool isSetCompartmentType() {
    bool ret = libsbmlPINVOKE.Compartment_isSetCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'size'
   * attribute is set.
   *
   * This method is similar but not identical to
   * @if java Compartment::isSetVolume()@else isSetVolume()@endif.  The latter
   * should be used in the context of SBML Level&nbsp;1 models instead of
   * @if java Compartment::isSetSize()@else isSetSize()@endif
   * because @if java Compartment::isSetVolume()@else isSetVolume()@endif
   * performs extra processing to take into account the difference in
   * default values between SBML Levels&nbsp;1 and&nbsp;2.
   *
   * @return @c true if the 'size' attribute ('volume' in Level&nbsp;2) of
   * this Compartment object is set, @c false otherwise.
   *
   * @see isSetVolume()
   * @see setSize(@if java double@endif)
   * @see getSize()
   * @see unsetSize()
   */ public
 bool isSetSize() {
    bool ret = libsbmlPINVOKE.Compartment_isSetSize(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'volume'
   * attribute is set.
   *
   * This method is similar but not identical to
   * @if java Compartment::isSetSize()@else isSetSize()@endif.  The latter
   * should not be used in the context of SBML Level&nbsp;1 models because the
   * present method performs extra processing to take into account
   * the difference in default values between SBML Levels&nbsp;1 and&nbsp;2.
   *
   * @return @c true if the 'volume' attribute ('size' in Level&nbsp;2 and
   * above) of this Compartment object is set, @c false otherwise.
   *
   *
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (@c 1.0) and therefore methods such as
 * @if conly Compartment_isSetVolume() @else isSetVolume()@endif
 * will always return @c true for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
 *
 *
   *
   * @see isSetSize()
   * @see getVolume()
   * @see setVolume(@if java double@endif)
   * @see unsetVolume()
   */ public
 bool isSetVolume() {
    bool ret = libsbmlPINVOKE.Compartment_isSetVolume(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'units'
   * attribute is set.
   *
   * @return @c true if the 'units' attribute of this Compartment object is
   * set, @c false otherwise.
   *
   *
 * @note There is an important distinction to be made between <em>no units
 * assigned</em>, and assuming a value without units has any specific unit
 * such as <code>dimensionless</code>.  In SBML, default units are never
 * attributed to numbers, and numbers without units are not automatically
 * assumed to have the unit <code>dimensionless</code>.  Please consult the
 * relevant SBML specification document for a more in-depth explanation of
 * this topic and the SBML unit system.
 *
 *
   *
   * @see setUnits(@if java String@endif)
   * @see getUnits()
   * @see unsetUnits()
   */ public
 bool isSetUnits() {
    bool ret = libsbmlPINVOKE.Compartment_isSetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'outside'
   * attribute is set.
   *
   * @return @c true if the 'outside' attribute of this Compartment object is
   * set, @c false otherwise.
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   *
   * @see getOutside()
   * @see setOutside(@if java String@endif)
   * @see unsetOutside()
   */ public
 bool isSetOutside() {
    bool ret = libsbmlPINVOKE.Compartment_isSetOutside(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's
   * 'spatialDimensions' attribute is set.
   *
   * @return @c true if the 'spatialDimensions' attribute of this
   * Compartment object is set, @c false otherwise.
   *
   * @see getSpatialDimensions()
   * @see setSpatialDimensions(@if java unsigned int@endif)
   * @see unsetSpatialDimensions()
   */ public
 bool isSetSpatialDimensions() {
    bool ret = libsbmlPINVOKE.Compartment_isSetSpatialDimensions(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this Compartment object's 'constant'
   * attribute is set.
   *
   * @return @c true if the 'constant' attribute of this Compartment object is
   * set, @c false otherwise.
   *
   * @see getConstant()
   * @see setConstant(@if java bool@endif)
   */ public
 bool isSetConstant() {
    bool ret = libsbmlPINVOKE.Compartment_isSetConstant(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Compartment object.
   *
   * The string @p sid is copied.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
   *
   * @param sid the string to use as the identifier of this Compartment object. If
   * the string is @c null, this method will return
   * @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @see getId()
   * @see unsetId()
   * @see isSetId()
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setId(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Compartment object.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Compartment_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the 'compartmentType' attribute of this Compartment object.
   *
   * @param sid the identifier of a CompartmentType object defined elsewhere
   * in this Model. If the string is @c null, this method will return
   * @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   *
   * @see isSetCompartmentType()
   * @see getCompartmentType()
   * @see unsetCompartmentType()
   */ public
 int setCompartmentType(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setCompartmentType(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this Compartment object.
   *
   * @param value a long integereger indicating the number of dimensions
   * of this compartment.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see getSpatialDimensions()
   * @see isSetSpatialDimensions()
   * @see unsetSpatialDimensions()
   */ public
 int setSpatialDimensions(long value) {
    int ret = libsbmlPINVOKE.Compartment_setSpatialDimensions__SWIG_0(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'spatialDimensions' attribute of this Compartment object as a double.
   *
   * @param value a double indicating the number of dimensions
   * of this compartment.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see getSpatialDimensions()
   * @see isSetSpatialDimensions()
   * @see unsetSpatialDimensions()
   */ public
 int setSpatialDimensions(double value) {
    int ret = libsbmlPINVOKE.Compartment_setSpatialDimensions__SWIG_1(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'size' attribute (or 'volume' in SBML Level&nbsp;1) of this
   * Compartment object.
   *
   * @param value a @c double representing the size of this compartment
   * instance in whatever units are in effect for the compartment.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @note This method is identical to
   * @if java Compartment::setVolume(double value)@else setVolume()@endif.
   *
   * @see setVolume(@if java double@endif)
   * @see getSize()
   * @see isSetSize()
   * @see unsetSize()
   */ public
 int setSize(double value) {
    int ret = libsbmlPINVOKE.Compartment_setSize(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'volume' attribute (or 'size' in SBML Level&nbsp;2) of this
   * Compartment object.
   *
   * This method is identical to
   * @if java Compartment::setSize(double value)@else setSize()@endif
   * and is provided for compatibility between SBML Level&nbsp;1 and
   * higher Levels of SBML.
   *
   * @param value a @c double representing the volume of this compartment
   * instance in whatever units are in effect for the compartment.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   *
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (@c 1.0) and therefore methods such as
 * @if conly Compartment_isSetVolume() @else isSetVolume()@endif
 * will always return @c true for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
 *
 *
   *
   * @see setSize(@if java double@endif)
   * @see getVolume()
   * @see isSetVolume()
   * @see unsetVolume()
   */ public
 int setVolume(double value) {
    int ret = libsbmlPINVOKE.Compartment_setVolume(swigCPtr, value);
    return ret;
  }

  
/**
   * Sets the 'units' attribute of this Compartment object.
   *
   * @param sid the identifier of the defined units to use.  If @p sid is
   * @c null, then this method will return
   * @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @see isSetUnits()
   * @see getUnits()
   * @see unsetUnits()
   */ public
 int setUnits(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setUnits(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the 'outside' attribute of this Compartment object.
   *
   * @param sid the identifier of a compartment that encloses this one. If @p
   * sid is @c null, then this method will return
   * @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   *
   * @see isSetOutside()
   * @see getOutside()
   * @see unsetOutside()
   */ public
 int setOutside(string sid) {
    int ret = libsbmlPINVOKE.Compartment_setOutside(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the value of the 'constant' attribute of this Compartment object.
   *
   * @param value a boolean indicating whether the size/volume of this
   * compartment should be considered constant (@c true) or variable
   * (@c false).
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @see isSetConstant()
   * @see getConstant()
   */ public
 int setConstant(bool value) {
    int ret = libsbmlPINVOKE.Compartment_setConstant(swigCPtr, value);
    return ret;
  }

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Compartment_renameSIdRefs(swigCPtr, oldid, newid);
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Compartment_renameUnitSIdRefs(swigCPtr, oldid, newid);
  }

  
/**
   * Unsets the value of the 'name' attribute of this Compartment object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Compartment_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'compartmentType' attribute of this Compartment object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note The 'compartmentType' attribute is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.
   *
   * @see setCompartmentType(@if java String@endif)
   * @see isSetCompartmentType()
   * @see getCompartmentType()
   */ public
 int unsetCompartmentType() {
    int ret = libsbmlPINVOKE.Compartment_unsetCompartmentType(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'constant' attribute of this Compartment object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isSetConstant()
   * @see setConstant(@if java bool@endif)
   * @see getConstant()
   */ public
 int unsetConstant() {
    int ret = libsbmlPINVOKE.Compartment_unsetConstant(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'size' attribute of this Compartment object.
   *
   * In SBML Level&nbsp;1, a compartment's volume has a default value
   * (@c 1.0) and therefore <em>should always be set</em>.  Calling this method
   * on a Level&nbsp;1 model resets the value to @c 1.0 rather than actually
   * unsetting it.  In Level&nbsp;2, a compartment's 'size' is optional with
   * no default value, and unsetting it will result in the compartment having
   * no defined size.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note This method is identical to
   * @if java Compartment::unsetVolume()@else unsetVolume()@endif.
   *
   * @see unsetVolume()
   * @see getSize()
   * @see isSetSize()
   * @see setSize(@if java double@endif)
   */ public
 int unsetSize() {
    int ret = libsbmlPINVOKE.Compartment_unsetSize(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'volume' attribute of this Compartment object.
   *
   * This method is identical to
   * @if java Compartment::unsetSize()@else unsetSize()@endif.  Please refer
   * to that method's documentation for more information about its behavior.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note The attribute 'volume' only exists by that name in SBML
 * Level&nbsp;1.  In Level&nbsp;2 and above, the equivalent attribute is
 * named 'size'.  In SBML Level&nbsp;1, a compartment's volume has a default
 * value (@c 1.0) and therefore methods such as
 * @if conly Compartment_isSetVolume() @else isSetVolume()@endif
 * will always return @c true for a Level&nbsp;1 model.  In Level&nbsp;2, a
 * compartment's size (the equivalent of SBML Level&nbsp;1's 'volume') is
 * optional and has no default value, and therefore may or may not be set.
 *
 *
   *
   * @see unsetSize()
   * @see getVolume()
   * @see setVolume(@if java double@endif)
   * @see isSetVolume()
   */ public
 int unsetVolume() {
    int ret = libsbmlPINVOKE.Compartment_unsetVolume(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'units' attribute of this Compartment object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see isSetUnits()
   * @see setUnits(@if java String@endif)
   * @see getUnits()
   */ public
 int unsetUnits() {
    int ret = libsbmlPINVOKE.Compartment_unsetUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'outside' attribute of this Compartment object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'outside' attribute is defined in SBML Level&nbsp;1 and
   * Level&nbsp;2, but does not exist in SBML Level&nbsp;3.
   *
   * @see isSetOutside()
   * @see getOutside()
   * @see setOutside(@if java String@endif)
   */ public
 int unsetOutside() {
    int ret = libsbmlPINVOKE.Compartment_unsetOutside(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'spatialDimensions' attribute of this
   * Compartment object.
   *
   * In SBML Levels prior to Level&nbsp;3, compartments must always have a
   * value for the number of dimensions.  Consequently, calling this method
   * on a model of SBML Level 1&ndash;2 will result in a return value of
   * @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   *
   * @note This function is only valid for SBML Level&nbsp;3.
   *
   * @see getSpatialDimensions()
   * @see isSetSpatialDimensions()
   * @see setSpatialDimensions(@if java unsigned int@endif)
   */ public
 int unsetSpatialDimensions() {
    int ret = libsbmlPINVOKE.Compartment_unsetSpatialDimensions(swigCPtr);
    return ret;
  }

  
/**
   * Constructs and returns a UnitDefinition that corresponds to the units
   * of this Compartment object's designated size.
   *
   *
 * 
 * Compartments in SBML have an attribute ('units') for declaring the
 * units of measurement intended for the value of the compartment's size.  In
 * the absence of a value given for this attribute, the units are inherited
 * from values either defined on the enclosing Model (in SBML Level&nbsp;3)
 * or in defaults (in SBML Level&nbsp;2).  This method returns a
 * @if conly UnitDefinition_t structure @else UnitDefinition object@endif
 * based on how this compartment's units are interpreted according to the
 * relevant SBML guidelines, or it returns @c null if no units have been
 * declared and no defaults are defined by the relevant SBML specification.
 *
 * Note that unit declarations for
 * @if conly Compartment_t structures @else Compartment objects @endif
 * are specified in terms of the @em identifier of a unit,
 * but @em this method returns @if conly a structure @else an object @endif,
 * not a unit identifier.  It does this by constructing an appropriate
 * @if conly UnitDefinition_t structure @else UnitDefinition object@endif.  For
 * SBML Level&nbsp;2 models, it will do this even when the value of the
 * 'units' attribute is one of the special SBML Level&nbsp;2 unit identifiers
 * @c 'substance', @c 'volume', @c 'area', @c 'length' or @c 'time'.  Callers
 * may find this useful in conjunction with the helper methods provided by
 * the @if conly UnitDefinition_t structure @else UnitDefinition
 * class@endif for comparing different UnitDefinition objects.
 *
 *
   *
   * @return a UnitDefinition that expresses the units of this
   * Compartment object, or @c null if one cannot be constructed.
   *
   *
 * @note The libSBML system for unit analysis depends on the model as a
 * whole.  In cases where the
 * @if conly Compartment_t structure @else Compartment object@endif has not
 * yet been added to a model, or the model itself is incomplete, unit
 * analysis is not possible, and consequently this method will return
 * @c null.
   *
   * @see isSetUnits()
   * @see getUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Compartment_getDerivedUnitDefinition__SWIG_0(swigCPtr);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 * The exception to this is lists:  all SBML-style list elements have the type 
 * @link libsbml#SBML_LIST_OF SBML_LIST_OF@endlink, regardless of what package they 
 * are from.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_COMPARTMENT SBML_COMPARTMENT@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * ListOf::getItemTypeCode()).</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Compartment_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object
   *
   * For Compartment, the XML element name is always @c 'compartment'.
   *
   * @return the name of this element.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Compartment_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if all the required attributes for this
   * Compartment object have been set.
   *
   * The required attributes for a Compartment object are:
   * @li 'id' (or 'name' in SBML Level&nbsp;1)
   * @li 'constant' (in SBML Level&nbsp;3 only)
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.Compartment_hasRequiredAttributes(swigCPtr);
    return ret;
  }

}

}
