# -*- perl -*-
# generated by perlify.pl from libsbml/src/sbml/test/TestWriteSBML.cpp
# followed by little human processing to fix syntactic specialties
# perify.pl is unable to handle right now =;) xtof
use Test::More;
BEGIN { plan tests => 9 };

use LibSBML;
use strict;
#########################

my $level   = 3;
my $version = 1;

# some global(s)
my $D = new LibSBML::SBMLDocument($level,$version);

test_WriteSBML_error();
test_WriteSBML_SBMLDocument();
test_WriteSBML_Model();
test_WriteSBML_FunctionDefinition();
test_WriteSBML_Unit();
test_WriteSBML_UnitDefinition();
test_WriteSBML_UnitDefinition_full();
# some global(s)

#---
sub setUp {
 $D   = new LibSBML::SBMLDocument();
}

#---
sub readSBMLFromString {
 my $s = shift;
 my $rd = new LibSBML::SBMLReader;
 $rd->readSBMLFromString($s);
}

#---
sub NS_L3v1 {
 "xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" ";
}

#---
sub SBML_END {
 "</sbml>\n";
}

#---
sub SBML_START {
 "<sbml ";
}

#---
sub LV_L3v1 {
 "level=\"3\" version=\"1\">\n";
}

#---
sub XML_START {
 "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
}

#---
sub wrapXML {
 XML_START() . $_[0];
}

#---
sub wrapSBML_L3v1 {
 XML_START() . SBML_START() . NS_L3v1() . LV_L3v1() . $_[0] . SBML_END();
}

#---
sub test_WriteSBML_error {
 my $d = new LibSBML::SBMLDocument($level,$version);
 my $w = new LibSBML::SBMLWriter();
 ok( ! $w->writeSBML($d, "/tmp/impossible/path/should/fail") );
 ok( $d->getNumErrors() == 1 );
 ok( $d->getError(0)->getErrorId() == $LibSBML::XMLFileUnwritable );
}

#---
sub test_WriteSBML_SBMLDocument {
 setUp();
 $D->setLevelAndVersion(3, 1, 0);
 my $expected = wrapXML("<sbml xmlns=\"http://www.sbml.org/sbml/level3/version1/core\" " . 
                        "level=\"3\" version=\"1\"/>\n");
 my $S = $D->writeSBMLToString();
 ok( $expected eq $S );
}

#---
sub test_WriteSBML_Model {
 setUp();
 $D->setLevelAndVersion(3, 1, 0);
 my $expected = wrapSBML_L3v1("  <model id=\"Branch\"/>\n");
 my $m = $D->createModel();
 $m->setId("Branch");
 my $S = $D->writeSBMLToString();
 ok( $expected eq $S );
}

#---
sub test_WriteSBML_FunctionDefinition {
 setUp();
 my $expected = "<functionDefinition id=\"pow3\">\n" . 
                        "  <math xmlns=\"http://www.w3.org/1998/Math/MathML\">\n" . 
                        "    <lambda>\n" . 
                        "      <bvar>\n" . 
                        "        <ci> x </ci>\n" . 
                        "      </bvar>\n" . 
                        "      <apply>\n" . 
                        "        <power/>\n" . 
                        "        <ci> x </ci>\n" . 
                        "        <cn type=\"integer\"> 3 </cn>\n" . 
                        "      </apply>\n" . 
                        "    </lambda>\n" . 
                        "  </math>\n" . 
                        "</functionDefinition>";
 my $fd = new LibSBML::FunctionDefinition($level,$version);
 $fd->setId("pow3");
 $fd->setMath(LibSBML::parseFormula("lambda(x, x^3)"));
 ok( $expected eq $fd->toSBML() );
}

#---
sub test_WriteSBML_Unit {
 setUp();
 $D->setLevelAndVersion(3, 1);
 my $expected = "<unit kind=\"kilogram\" exponent=\"2.2\" scale=\"-3\" multiplier=\"1\"/>";
 my $u = new LibSBML::Unit(3,1);
 $u->setKind($LibSBML::UNIT_KIND_KILOGRAM);
 $u->setExponent(2.2);
 $u->setScale(-3);
 $u->setMultiplier(1);
 ok( $expected eq $u->toSBML() );
}

#---
sub test_WriteSBML_UnitDefinition {
 setUp();
 $D->setLevelAndVersion(3, 1);
 my $expected = "<unitDefinition id=\"mmls\"/>";
 my $ud = new LibSBML::UnitDefinition(3,1);
 $ud->setId("mmls");
 ok( $expected eq $ud->toSBML());
}

#---
sub test_WriteSBML_UnitDefinition_full {
 setUp();
 $D->setLevelAndVersion(3, 1);
 my $expected = "<unitDefinition id=\"mmls\">\n" . 
                        "  <listOfUnits>\n" . 
                        "    <unit kind=\"mole\" exponent=\"1\" scale=\"-3\" multiplier=\"1\"/>\n" . 
                        "    <unit kind=\"litre\" exponent=\"-1\" scale=\"0\" multiplier=\"1\"/>\n" . 
                        "    <unit kind=\"second\" exponent=\"-1\" scale=\"0\" multiplier=\"1\"/>\n" . 
                        "  </listOfUnits>\n" . 
                        "</unitDefinition>";
 my $ud = new LibSBML::UnitDefinition(3,1);
 $ud->setId("mmls");
 my $u1 = new LibSBML::Unit(3,1);
 $u1->setKind($LibSBML::UNIT_KIND_MOLE);
 $u1->initDefaults();
 $u1->setScale(-3);
 my $u2 = new LibSBML::Unit(3, 1);
 $u2->setKind($LibSBML::UNIT_KIND_LITRE);
 $u2->initDefaults();
 $u2->setExponent(-1);
 my $u3 = new LibSBML::Unit(3, 1);
 $u3->setKind($LibSBML::UNIT_KIND_SECOND);
 $u3->initDefaults();
 $u3->setExponent(-1);

 $ud->addUnit($u1);
 $ud->addUnit($u2);
 $ud->addUnit($u3);
 ok( $expected eq $ud->toSBML());
}

