/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  The rate expression for an SBML reaction.
 <p>
 * An object of class {@link KineticLaw} is used to describe the rate at which the
 * process defined by a given {@link Reaction} takes place.  {@link KineticLaw} has
 * subelements called 'math' (for MathML content) and 'listOfParameters'
 * (of class {@link ListOfParameters}), in addition to the attributes and
 * subelements it inherits from {@link SBase}.
 <p>
 * {@link KineticLaw}'s 'math' subelement for holding a MathML formula (required 
 * through SBML Level&nbsp;3 Version&nbsp;1, but optional as of SBML 
 * Level&nbsp;3 Version&nbsp;2) defines the
 * rate of the reaction.  The formula may refer to other entities in a
 * model as well as local parameter definitions within the scope of the
 * {@link Reaction} (see below).  It is important to keep in mind, however, that
 * the only {@link Species} identifiers that can be used in this formula are those
 * declared in the lists of reactants, products and modifiers in the
 * {@link Reaction} structure.  (In other words, before a species can be referenced
 * in the {@link KineticLaw}, it must be declared in one of those lists.)
 <p>
 * {@link KineticLaw} provides a way to define <em>local</em> parameters whose
 * identifiers can be used in the 'math' formula of that {@link KineticLaw}
 * instance.  Prior to SBML Level&nbsp;3, these parameter definitions are
 * stored inside a 'listOfParameters' subelement containing {@link Parameter}
 * objects; in SBML Level&nbsp;3, this is achieved using a specialized
 * object class called {@link LocalParameter} and the containing subelement is
 * called 'listOfLocalParameters'.  In both cases, the parameters so
 * defined are only visible within the {@link KineticLaw} (or, as of SBML
 * Level&nbsp;3 Version&nbsp;2, only visible within the parent {@link Reaction}); 
 * they cannot be accessed
 * outside.  A local parameter within one reaction is not visible from
 * within another reaction, nor is it visible to any other construct
 * outside of the {@link KineticLaw} in which it is defined.  In addition, another
 * important feature is that if such a {@link Parameter} (or in Level&nbsp;3,
 * {@link LocalParameter}) object has the same identifier as another object in the
 * scope of the enclosing {@link Model}, the definition inside the {@link KineticLaw} takes
 * precedence.  In other words, within the {@link KineticLaw}'s 'math' formula,
 * references to local parameter identifiers <strong>shadow any identical
 * global identifiers</strong>.
 <p>
 * The values of local parameters defined within {@link KineticLaw} objects cannot
 * change.  In SBML Level&nbsp;3, this quality is built into the
 * {@link LocalParameter} construct.  In Level&nbsp;2, where the same kind of
 * {@link Parameter} object class is used as for global parameters, the {@link Parameter}
 * objects' 'constant' attribute must always have a value of <code>true</code>
 * (either explicitly or left to its default value).
 <p>
 * <h2>A warning about identifier shadowing</h2>
 <p>
 * A common misconception is that different classes of objects (e.g.,
 * species, compartments, parameters) in SBML have different identifier
 * scopes.  They do not.  The implication is that if a {@link KineticLaw}'s local
 * parameter definition uses an identifier identical to <em>any</em> other
 * identifier defined in the model outside the {@link KineticLaw}, even if the
 * other identifier does <em>not</em> belong to a parameter type of object, the
 * local parameter's identifier takes precedence within that {@link KineticLaw}'s
 * 'math' formula.  It is not an error in SBML for identifiers to shadow
 * each other this way, but can lead to confusing and subtle errors.
 <p>
 * <h2>SBML Level/Version differences</h2>
 <p>
 * In SBML Level&nbsp;2 Version&nbsp;1, the SBML specification
 * included two additional attributes on {@link KineticLaw} called 'substanceUnits'
 * and 'timeUnits'.  They were removed beginning with SBML Level&nbsp;2
 * Version&nbsp;2 because further research determined they introduced many
 * problems.  The most significant problem was that their use could easily
 * lead to the creation of valid models whose reactions nevertheless could
 * not be integrated into a system of equations without outside knowledge
 * for converting the quantities used.  Examination of real-life models
 * revealed that a common reason for using 'substanceUnits' on {@link KineticLaw}
 * was to set the units of all reactions to the same set of substance
 * units, something that is better achieved by using {@link UnitDefinition} to
 * redefine <code>'substance'</code> for the whole {@link Model}.
 <p>
 * As mentioned above, in SBML Level&nbsp;2 Versions 2&ndash;4, local
 * parameters are of class {@link Parameter}.  In SBML Level&nbsp;3, the class of
 * object is {@link LocalParameter}.
 <p>
 * In SBML Level&nbsp;3 Version&nbsp;2, the scope of the {@link LocalParameter}
 * was expanded to the entire {@link Reaction}, instead of just the {@link KineticLaw}.  
 * This introduced a single new restriction: an L3v2 {@link LocalParameter} may 
 * not now shadow the <code>id</code> of any {@link Species} referenced by a {@link SpeciesReference}
 * in the same {@link Reaction}.  Other than that, there is no difference in any 
 * core construct.  However, packages may take advantage of this new scope by 
 * adding elements to the {@link Reaction} that may now reference a {@link LocalParameter} 
 * defined in the same {@link Reaction}.
 */

public class KineticLaw extends SBase {
   private long swigCPtr;

   protected KineticLaw(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.KineticLaw_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(KineticLaw obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (KineticLaw obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_KineticLaw(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link KineticLaw} using the given SBML <code>level</code> and <code>version</code>
   * values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link KineticLaw}.
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link KineticLaw}.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>level</code> and <code>version</code> combination are invalid
 * or if this object is incompatible with the given level and version.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 KineticLaw(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link KineticLaw} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * <p>
 * @throws SBMLConstructorException
 * Thrown if the given <code>sbmlns</code> is inconsistent or incompatible
 * with this object.
   <p>
   * <p>
 * @note Attempting to add an object to an {@link SBMLDocument} having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * {@link SBMLDocument}), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
   */ public
 KineticLaw(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link KineticLaw}.
   <p>
   * @param orig the object to copy.
   */ public
 KineticLaw(KineticLaw orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_KineticLaw__SWIG_2(KineticLaw.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link KineticLaw} object.
   <p>
   * @return the (deep) copy of this {@link KineticLaw} object.
   */ public
 KineticLaw cloneObject() {
    long cPtr = libsbmlJNI.KineticLaw_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, true);
  }

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide SId namespace, or <code>null</code> if no such object is found.
   <p>
   * @param id string representing the id of the object to find.
   <p>
   * @return pointer to the first element found with the given <code>id</code>.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.KineticLaw_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with the given <code>metaid</code>, or
   * <code>null</code> if no such object is found.
   <p>
   * @param metaid string representing the metaid of the object to find.
   <p>
   * @return pointer to the first element found with the given <code>metaid</code>.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.KineticLaw_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as a text string.
   <p>
   * This is fundamentally equivalent to
   * {@link KineticLaw#getMath()}.
   * This variant is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1.
   <p>
   * @return a string representing the formula of this {@link KineticLaw}.
   <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   <p>
   * @see #getMath()
   */ public
 String getFormula() {
    return libsbmlJNI.KineticLaw_getFormula(swigCPtr, this);
  }

  
/**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as an AST.
   <p>
   * This is fundamentally equivalent to
   * {@link KineticLaw#getFormula()}.
   * The latter is provided principally for compatibility compatibility
   * with SBML Level&nbsp;1, which represented mathematical formulas in
   * text-string form.
   <p>
   * @return the {@link ASTNode} representation of the mathematical formula, 
   * or <code>null</code> if the math is not set.
   <p>
   * @see #getFormula()
   */ public
 ASTNode getMath() {
    long cPtr = libsbmlJNI.KineticLaw_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'timeUnits' attribute of this {@link KineticLaw} object.
   <p>
   * @return the 'timeUnits' attribute value.
   <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 String getTimeUnits() {
    return libsbmlJNI.KineticLaw_getTimeUnits(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Returns the value of the
   * 'substanceUnits' attribute of this {@link KineticLaw} object.
   <p>
   * @return the 'substanceUnits' attribute value.
   <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 String getSubstanceUnits() {
    return libsbmlJNI.KineticLaw_getSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this {@link KineticLaw}'s 'formula' attribute is
   * set.
   <p>
   * This is functionally identical to the method
   * {@link KineticLaw#isSetMath()}.  It is
   * provided in order to mirror the parallel between
   * {@link KineticLaw#getFormula()} and
   * {@link KineticLaw#getMath()}.
   <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} is set, <code>false</code> otherwise.
   <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   <p>
   * @see #isSetMath()
   */ public
 boolean isSetFormula() {
    return libsbmlJNI.KineticLaw_isSetFormula(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this Kinetic's 'math' subelement is set.
   <p>
   * This is identical to the method
   * {@link KineticLaw#isSetFormula()}.
   * It is provided in order to mirror the parallel between
   * {@link KineticLaw#getFormula()} and
   * {@link KineticLaw#getMath()}.
   <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} is set, <code>false</code> otherwise.
   <p>
   * @see #isSetFormula()
   */ public
 boolean isSetMath() {
    return libsbmlJNI.KineticLaw_isSetMath(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning <code>true</code> if
   * this {@link SpeciesReference}'s 'timeUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link KineticLaw} object
   * is set, <code>false</code> otherwise.
   <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 boolean isSetTimeUnits() {
    return libsbmlJNI.KineticLaw_isSetTimeUnits(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Predicate returning <code>true</code> if
   * this {@link SpeciesReference}'s 'substanceUnits' attribute is set.
   <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link KineticLaw}
   * object is set, <code>false</code> otherwise.
   <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 boolean isSetSubstanceUnits() {
    return libsbmlJNI.KineticLaw_isSetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Sets the mathematical expression of this {@link KineticLaw} instance to the
   * given <code>formula</code>.
   <p>
   * The given <code>formula</code> string is copied.  Internally, libSBML stores the
   * mathematical expression as an {@link ASTNode}.
   <p>
   * @param formula the mathematical expression to use, represented in
   * text-string form.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical formulas.
SBML Level&nbsp;2 uses MathML, an XML format for representing mathematical
expressions.  LibSBML provides an Abstract Syntax Tree API for working with
mathematical expressions; this API is more powerful than working with
formulas directly in text form, and ASTs can be translated into either
MathML or the text-string syntax.  The libSBML methods that accept
text-string formulas directly (such as this constructor) are provided for
SBML Level&nbsp;1 compatibility, but developers are encouraged to use the
AST mechanisms.

   <p>
   * @see #setMath(ASTNode math)
   */ public
 int setFormula(String formula) {
    return libsbmlJNI.KineticLaw_setFormula(swigCPtr, this, formula);
  }

  
/**
   * Sets the mathematical expression of this {@link KineticLaw} instance to a copy
   * of the given {@link ASTNode}.
   <p>
   * This is fundamentally identical to
   * {@link KineticLaw#setFormula(String formula)}.
   * The latter is provided principally for compatibility compatibility with
   * SBML Level&nbsp;1, which represented mathematical formulas in text-string
   * form.
   <p>
   * @param math an {@link ASTNode} representing a formula tree.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   *
   * </ul> <p>
   * @see #setFormula(String formula)
   */ public
 int setMath(ASTNode math) {
    return libsbmlJNI.KineticLaw_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'timeUnits' attribute
   * of this {@link KineticLaw} object to a copy of the identifier in <code>sid</code>.
   <p>
   * @param sid the identifier of the units to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 int setTimeUnits(String sid) {
    return libsbmlJNI.KineticLaw_setTimeUnits(swigCPtr, this, sid);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Sets the 'substanceUnits'
   * attribute of this {@link KineticLaw} object to a copy of the identifier given
   * in <code>sid</code>.
   <p>
   * @param sid the identifier of the units to use.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 int setSubstanceUnits(String sid) {
    return libsbmlJNI.KineticLaw_setSubstanceUnits(swigCPtr, this, sid);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'timeUnits'
   * attribugte of this {@link KineticLaw} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 int unsetTimeUnits() {
    return libsbmlJNI.KineticLaw_unsetTimeUnits(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;2 Version&nbsp;1 only) Unsets the 'substanceUnits'
   * attribute of this {@link KineticLaw} object.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * <p>
 * @note The attributes 'timeUnits' and 'substanceUnits' are present only
 * in SBML Level&nbsp;2 Version&nbsp;1.  In SBML Level&nbsp;2
 * Version&nbsp;2, the 'timeUnits' and 'substanceUnits' attributes were
 * removed.  For compatibility with new versions of SBML, users are
 * cautioned to avoid these attributes. 
   */ public
 int unsetSubstanceUnits() {
    return libsbmlJNI.KineticLaw_unsetSubstanceUnits(swigCPtr, this);
  }

  
/**
   * Adds a copy of the given {@link Parameter} object to the list of local
   * parameters in this {@link KineticLaw}.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @param p the {@link Parameter} to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createParameter()
   */ public
 int addParameter(Parameter p) {
    return libsbmlJNI.KineticLaw_addParameter(swigCPtr, this, Parameter.getCPtr(p), p);
  }

  
/**
   * Adds a copy of the given {@link LocalParameter} object to the list of local
   * parameters in this {@link KineticLaw}.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @param p the {@link LocalParameter} to add.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH}
   * <li> {@link libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createLocalParameter()
   */ public
 int addLocalParameter(LocalParameter p) {
    return libsbmlJNI.KineticLaw_addLocalParameter(swigCPtr, this, LocalParameter.getCPtr(p), p);
  }

  
/**
   * Creates a new {@link Parameter} object, adds it to this {@link KineticLaw}'s list of
   * parameters, and returns the {@link Parameter} object created.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @return a new {@link Parameter} object instance.
   <p>
   * @see #addParameter(Parameter p)
   */ public
 Parameter createParameter() {
    long cPtr = libsbmlJNI.KineticLaw_createParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Creates a new {@link LocalParameter} object, adds it to this {@link KineticLaw}'s list
   * of local parameters, and returns the {@link LocalParameter} object created.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @return a new {@link LocalParameter} object instance.
   <p>
   * @see #addLocalParameter(LocalParameter p)
   */ public
 LocalParameter createLocalParameter() {
    long cPtr = libsbmlJNI.KineticLaw_createLocalParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Returns the list of parameters in this {@link KineticLaw} object.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @return the list of Parameters for this {@link KineticLaw}.
   */ public
 ListOfParameters getListOfParameters() {
    long cPtr = libsbmlJNI.KineticLaw_getListOfParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfParameters(cPtr, false);
  }

  
/**
   * Returns the list of local parameters in this {@link KineticLaw} object.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @return the list of LocalParameters for this {@link KineticLaw}.
   */ public
 ListOfLocalParameters getListOfLocalParameters() {
    long cPtr = libsbmlJNI.KineticLaw_getListOfLocalParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfLocalParameters(cPtr, false);
  }

  
/**
   * Returns the nth {@link Parameter} object in the list of parameters in
   * this {@link KineticLaw} instance.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @param n the index of the {@link Parameter} object sought.
   <p>
   * @return the nth {@link Parameter} of this {@link KineticLaw}.
   */ public
 Parameter getParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Returns the nth {@link LocalParameter} object in the list of local parameters in
   * this {@link KineticLaw} instance.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @param n the index of the {@link LocalParameter} object sought.
   <p>
   * @return the nth {@link LocalParameter} of this {@link KineticLaw}.
   */ public
 LocalParameter getLocalParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_getLocalParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Returns a parameter based on its identifier.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @param sid the identifier of the {@link Parameter} being sought.
   <p>
   * @return the {@link Parameter} object in this {@link KineticLaw} instace having the
   * given 'id', or <code>null</code> if no such {@link Parameter} exists.
   */ public
 Parameter getParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
/**
   * Returns a local parameter based on its identifier.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @param sid the identifier of the {@link LocalParameter} being sought.
   <p>
   * @return the {@link LocalParameter} object in this {@link KineticLaw} instace having the
   * given 'id', or <code>null</code> if no such {@link LocalParameter} exists.
   */ public
 LocalParameter getLocalParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_getLocalParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, false);
  }

  
/**
   * Returns the number of parameters in this {@link KineticLaw} instance.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * @return the number of Parameters in this {@link KineticLaw}.
   */ public
 long getNumParameters() {
    return libsbmlJNI.KineticLaw_getNumParameters(swigCPtr, this);
  }

  
/**
   * Returns the number of local parameters in this {@link KineticLaw} instance.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * @return the number of LocalParameters in this {@link KineticLaw}.
   */ public
 long getNumLocalParameters() {
    return libsbmlJNI.KineticLaw_getNumLocalParameters(swigCPtr, this);
  }

  
/**
   * Calculates and returns a {@link UnitDefinition} that expresses the units of
   * measurement assumed for the 'math' expression of this {@link KineticLaw}.
   <p>
   * <p>
 * The units are calculated based on the mathematical expression in the
 * {@link KineticLaw} and the model quantities referenced by <code>&lt;ci&gt;</code>
 * elements used within that expression.  The
 * {@link KineticLaw#getDerivedUnitDefinition()}
 * method returns the calculated units. 
   <p>
   * <p>
 * @note The functionality that facilitates unit analysis depends on the
 * model as a whole.  Thus, in cases where the object has not been added to
 * a model or the model itself is incomplete, unit analysis is not possible
 * and this method will return <code>null.</code> 
   <p>
   * <p>
 * @warning <span class='warning'>Note that it is possible the 'math'
 * expression in the {@link KineticLaw} contains pure numbers or parameters with
 * undeclared units.  In those cases, it is not possible to calculate the
 * units of the overall expression without making assumptions.  LibSBML does
 * not make assumptions about the units, and
 * {@link KineticLaw#getDerivedUnitDefinition()} returns the units as far as it is
 * able to determine them.  For example, in an expression <em>X + Y</em>, if
 * <em>X</em> has unambiguously-defined units and <em>Y</em> does not, it
 * will return the units of <em>X</em>.  <strong>It is important that callers
 * also invoke the method</strong>
 * {@link KineticLaw#containsUndeclaredUnits()}<strong>to determine whether this
 * situation holds</strong>.  Callers may wish to take suitable actions in
 * those scenarios.</span>
   <p>
   * @return a {@link UnitDefinition} that expresses the units of the math 
   * expression of this {@link KineticLaw}, or <code>null</code> if one cannot be constructed.
   <p>
   * @see #containsUndeclaredUnits()
   */ public
 UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.KineticLaw_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
/**
   * Predicate returning <code>true</code> if the math expression of this {@link KineticLaw}
   * contains parameters/numbers with undeclared units.
   <p>
   * @return <code>true</code> if the math expression of this {@link KineticLaw}
   * includes parameters/numbers 
   * with undeclared units, <code>false</code> otherwise.
   <p>
   * @note A return value of <code>true</code> indicates that the {@link UnitDefinition}
   * returned by
   * {@link KineticLaw#getDerivedUnitDefinition()}
   * may not accurately represent the units of the expression.
   <p>
   * @see #getDerivedUnitDefinition()
   */ public
 boolean containsUndeclaredUnits() {
    return libsbmlJNI.KineticLaw_containsUndeclaredUnits__SWIG_0(swigCPtr, this);
  }

  
/**
   * Removes the nth {@link Parameter} object in the list of parameters 
   * in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link Parameter} object to remove.
   <p>
   * @return the {@link Parameter} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>null</code> is returned if the given index 
   * is out of range.
   */ public
 Parameter removeParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_removeParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
/**
   * Removes the nth {@link LocalParameter} object in the list of local parameters 
   * in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link LocalParameter} object to remove.
   <p>
   * @return the {@link LocalParameter} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>null</code> is returned if the given index 
   * is out of range.
   */ public
 LocalParameter removeLocalParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_removeLocalParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

  
/**
   * Removes a {@link Parameter} object with the given identifier in the list of
   * parameters in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
 * This function should be used for SBML Level&nbsp;1 and Level&nbsp;2 documents, 
 * as the equivalent constructs in Level&nbsp;3 are {@link LocalParameter} objects instead.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link Parameter} to remove.
   <p>
   * @return the {@link Parameter} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>null</code> is returned if no {@link Parameter}
   * object with the identifier exists in this {@link KineticLaw} instance.
   */ public
 Parameter removeParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_removeParameter__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, true);
  }

  
/**
   * Removes a {@link LocalParameter} object with the given identifier in the list of
   * local parameters in this {@link KineticLaw} instance and returns a pointer to it.
   * <p>
 * This function should be used for SBML Level&nbsp;3 documents, as the equivalent 
 * constructs in Level&nbsp;2 and Level&nbsp;1 are {@link Parameter} objects instead.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param sid the identifier of the {@link LocalParameter} to remove.
   <p>
   * @return the {@link LocalParameter} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>null</code> is returned if no {@link LocalParameter}
   * object with the identifier exists in this {@link KineticLaw} instance.
   */ public
 LocalParameter removeLocalParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_removeLocalParameter__SWIG_1(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new LocalParameter(cPtr, true);
  }

  public void connectToChild() {
    libsbmlJNI.KineticLaw_connectToChild(swigCPtr, this);
  }

  
/** * @internal */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.KineticLaw_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Returns the libSBML type code for this SBML object.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>{@link SBase#getPackageName()}
 * </code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link libsbmlConstants#SBML_KINETIC_LAW SBML_KINETIC_LAW} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.KineticLaw_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link Species}, is
   * always <code>'kineticLaw'.</code>
   <p>
   * @return the name of this element, i.e., <code>'kineticLaw'.</code>
   */ public
 String getElementName() {
    return libsbmlJNI.KineticLaw_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required attributes for this
   * {@link KineticLaw} object have been set.
   <p>
   * The required attributes for a {@link KineticLaw} object are:
   * <ul>
   * <li> 'formula' (SBML Level&nbsp;1 only)
   *
   * </ul> <p>
   * @return <code>true</code> if the required attributes have been set, <code>false</code>
   * otherwise.
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.KineticLaw_hasRequiredAttributes(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required elements for this
   * {@link KineticLaw} object have been set.
   <p>
   * @note The required elements for a {@link KineticLaw} object are:
   * <ul>
   * <li> 'math' inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
   *     (In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
   *
   * </ul> <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public
 boolean hasRequiredElements() {
    return libsbmlJNI.KineticLaw_hasRequiredElements(swigCPtr, this);
  }

  
/**
   * Finds this {@link KineticLaw}'s {@link Reaction} parent and calls unsetKineticLaw() on
   * it, indirectly deleting itself.
   <p>
   * Overridden from the {@link SBase} function since the parent is not a {@link ListOf}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED}
   * </ul>
   */ public
 int removeFromParentAndDelete() {
    return libsbmlJNI.KineticLaw_removeFromParentAndDelete(swigCPtr, this);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>SIdRef</code> type attribute value with another
 * value.
 <p>
 * <p>
 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of <code>oldid</code>.  If any matches are found, the
 * matching values are replaced with <code>newid</code>.  The method does <em>not</em>
 * descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameSIdRefs(String oldid, String newid) {
    libsbmlJNI.KineticLaw_renameSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/**
   * <p>
 * Replaces all uses of a given <code>UnitSIdRef</code> type attribute value with
 * another value.
 <p>
 * <p>
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 <p>
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of <code>oldid</code>.  If any matches
 * are found, the matching values are replaced with <code>newid</code>.  The method
 * does <em>not</em> descend into child elements.
 <p>
 * @param oldid the old identifier.
 * @param newid the new identifier.
   */ public
 void renameUnitSIdRefs(String oldid, String newid) {
    libsbmlJNI.KineticLaw_renameUnitSIdRefs(swigCPtr, this, oldid, newid);
  }

  
/** * @internal */ public
 void replaceSIDWithFunction(String id, ASTNode function) {
    libsbmlJNI.KineticLaw_replaceSIDWithFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 void divideAssignmentsToSIdByFunction(String id, ASTNode function) {
    libsbmlJNI.KineticLaw_divideAssignmentsToSIdByFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

  
/** * @internal */ public
 void multiplyAssignmentsToSIdByFunction(String id, ASTNode function) {
    libsbmlJNI.KineticLaw_multiplyAssignmentsToSIdByFunction(swigCPtr, this, id, ASTNode.getCPtr(function), function);
  }

}
