/*
 * Decompiled with CFR 0.152.
 */
package sun.text.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.DefaultLocaleList;
import sun.misc.Launcher;
import sun.security.action.GetPropertyAction;

public class LocaleData {
    private static Vector classPathSegments = new Vector();
    private static Locale[] localeList;
    private static final String PACKAGE = "sun.text.resources";
    private static final String PREFIX = "LocaleElements_";
    private static final char ZIPSEPARATOR = '/';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale[] getAvailableLocales(String string) {
        Locale[] localeArray;
        if (localeList == null) {
            localeArray = LocaleData.class;
            synchronized (localeArray) {
                if (localeList == null) {
                    localeList = LocaleData.createLocaleList();
                }
            }
        }
        localeArray = new Locale[localeList.length];
        System.arraycopy(localeList, 0, localeArray, 0, localeList.length);
        return localeArray;
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.LocaleElements", locale);
    }

    public static ResourceBundle getDateFormatZoneData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.DateFormatZoneData", locale);
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(string, locale);
            }
        });
    }

    private static Locale[] createLocaleList() {
        int n;
        int n2;
        Object[] objectArray;
        Object object;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java.class.path"));
        if (string2 != null && string2.length() != 0) {
            string = string + File.pathSeparator + string2;
        }
        while (string != null && string.length() != 0) {
            int n3 = string.lastIndexOf(File.pathSeparatorChar);
            object = string.substring(n3 + 1);
            string = n3 == -1 ? null : string.substring(0, n3);
            classPathSegments.insertElementAt(object, 0);
        }
        ClassLoader classLoader = Launcher.getLauncher().getClassLoader();
        object = (URLClassLoader)classLoader.getParent();
        if (object != null) {
            objectArray = ((URLClassLoader)object).getURLs();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                classPathSegments.insertElementAt(((URL)objectArray[n2]).getPath(), 0);
            }
        }
        objectArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LocaleData.getClassList(LocaleData.PACKAGE, LocaleData.PREFIX);
            }
        });
        n2 = PREFIX.length();
        localeList = new Locale[objectArray.length + DefaultLocaleList.list.length];
        for (n = 0; n < objectArray.length; ++n) {
            LocaleData.localeList[n] = LocaleData.getLocale(((String)objectArray[n]).substring(n2));
        }
        for (n = 0; n < DefaultLocaleList.list.length; ++n) {
            LocaleData.localeList[objectArray.length + n] = LocaleData.getLocale(DefaultLocaleList.list[n]);
        }
        return localeList;
    }

    private static Locale getLocale(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = string.indexOf(95);
        int n2 = 0;
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            n2 = string.indexOf(95, n + 1);
            if (n2 == -1) {
                string3 = string.substring(n + 1);
            } else {
                string3 = string.substring(n + 1, n2);
                if (n2 < string.length()) {
                    string4 = string.substring(n2 + 1);
                }
            }
        }
        return new Locale(string2, string3, string4);
    }

    private static String[] getClassList(String string, String string2) {
        Vector vector = new Vector();
        String string3 = string.replace('.', File.separatorChar) + File.separatorChar;
        String string4 = string.replace('.', '/') + '/';
        for (int i = 0; i < classPathSegments.size(); ++i) {
            String string5;
            File file;
            String string6 = (String)classPathSegments.elementAt(i);
            File file2 = new File(string6);
            if (!file2.exists()) continue;
            if (file2.isFile()) {
                LocaleData.scanFile(file2, string4, vector, string2);
                continue;
            }
            if (!file2.isDirectory() || !(file = new File(string5 = string6.endsWith(File.separator) ? string6 + string3 : string6 + File.separatorChar + string3)).exists() || !file.isDirectory()) continue;
            LocaleData.scanDir(file, vector, string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void addClass(String string, Vector vector, String string2) {
        if (string != null && string.startsWith(string2) && !vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private static String midString(String string, String string2, String string3) {
        String string4 = string.startsWith(string2) && string.endsWith(string3) ? string.substring(string2.length(), string.length() - string3.length()) : null;
        return string4;
    }

    private static void scanDir(File file, Vector vector, String string) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            LocaleData.addClass(LocaleData.midString(stringArray[i], "", ".class"), vector, string);
        }
    }

    private static void scanFile(File file, String string, Vector vector, String string2) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            boolean bl = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string3 = zipEntry.getName();
                if (string3.startsWith(string)) {
                    bl = true;
                    if (!string3.endsWith(".class")) continue;
                    LocaleData.addClass(LocaleData.midString(string3, string, ".class"), vector, string2);
                    continue;
                }
                if (!bl) continue;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("file not found:" + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("file IO Exception:" + iOException);
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
        }
    }
}

