/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactIntArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private int[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactIntArray() {
        this(0);
    }

    public CompactIntArray(int n) {
        int n2;
        this.values = new int[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n2 = 0; n2 < 65536; ++n2) {
            this.values[n2] = n;
        }
        for (n2 = 0; n2 < 512; ++n2) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
        }
        this.isCompact = false;
    }

    public CompactIntArray(short[] sArray, int[] nArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i = 0; i < 512; ++i) {
            short s = sArray[i];
            if (s >= 0 && s < nArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = nArray;
        this.isCompact = true;
    }

    public int elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public void setElementAt(char c, int n) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = n;
        this.touchBlock(c >> 7, n);
    }

    public void setElementAt(char n, char c, int n2) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i = n; i <= c; ++i) {
            this.values[i] = n2;
            this.touchBlock(i >> 7, n2);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.indices.length) {
                this.indices[n4] = -1;
                boolean bl = this.blockTouched(n4);
                if (!bl && n3 != -1) {
                    this.indices[n4] = n3;
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < n) {
                        if (this.hashes[n4] == this.hashes[n6] && Utility.arrayRegionMatches(this.values, n2, this.values, n5, 128)) {
                            this.indices[n4] = (short)n5;
                            break;
                        }
                        ++n6;
                        n5 += 128;
                    }
                    if (this.indices[n4] == -1) {
                        System.arraycopy(this.values, n2, this.values, n5, 128);
                        this.indices[n4] = (short)n5;
                        this.hashes[n6] = this.hashes[n4];
                        ++n;
                        if (!bl) {
                            n3 = (short)n5;
                        }
                    }
                }
                ++n4;
                n2 += 128;
            }
            n4 = n * 128;
            int[] nArray = new int[n4];
            System.arraycopy(this.values, 0, nArray, 0, n4);
            this.values = nArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public int[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactIntArray compactIntArray = (CompactIntArray)super.clone();
            compactIntArray.values = (int[])this.values.clone();
            compactIntArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactIntArray.hashes = (int[])this.hashes.clone();
            }
            return compactIntArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactIntArray compactIntArray = (CompactIntArray)object;
        for (int i = 0; i < 65536; ++i) {
            if (this.elementAt((char)i) == compactIntArray.elementAt((char)i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        for (int i = 0; i < this.values.length; i += n2) {
            n = n * 37 + this.values[i];
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            int n;
            this.hashes = new int[512];
            int[] nArray = new int[65536];
            for (n = 0; n < 65536; ++n) {
                int n2;
                nArray[n] = n2 = this.elementAt((char)n);
                this.touchBlock(n >> 7, n2);
            }
            for (n = 0; n < 512; ++n) {
                this.indices[n] = (short)(n << 7);
            }
            this.values = nArray;
            this.isCompact = false;
        }
    }
}

