/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public abstract class Signature
extends SignatureSpi {
    private static final boolean debug = false;
    private String algorithm;
    private Provider provider;
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;

    protected Signature(String string) {
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "Signature", (String)null);
            if (objectArray[0] instanceof Signature) {
                Signature signature = (Signature)objectArray[0];
                signature.provider = (Provider)objectArray[1];
                return signature;
            }
            Delegate delegate = new Delegate((SignatureSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "Signature", string2);
        if (objectArray[0] instanceof Signature) {
            Signature signature = (Signature)objectArray[0];
            signature.provider = (Provider)objectArray[1];
            return signature;
        }
        Delegate delegate = new Delegate((SignatureSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "Signature", provider);
        if (objectArray[0] instanceof Signature) {
            Signature signature = (Signature)objectArray[0];
            signature.provider = (Provider)objectArray[1];
            return signature;
        }
        Delegate delegate = new Delegate((SignatureSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
        this.state = 3;
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        boolean[] blArray;
        Serializable serializable;
        Set set;
        if (certificate instanceof X509Certificate && (set = (serializable = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !set.isEmpty() && set.contains(new String("2.5.29.15")) && (blArray = ((X509Certificate)serializable).getKeyUsage()) != null && !blArray[0]) {
            throw new InvalidKeyException("Wrong key usage");
        }
        serializable = certificate.getPublicKey();
        this.engineInitVerify((PublicKey)serializable);
        this.state = 3;
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.state = 2;
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey, secureRandom);
        this.state = 2;
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            return this.engineSign();
        }
        throw new SignatureException("object not initialized for signing");
    }

    public final int sign(byte[] byArray, int n, int n2) throws SignatureException {
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        if (this.state != 2) {
            throw new SignatureException("object not initialized for signing");
        }
        return this.engineSign(byArray, n, n2);
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (this.state == 3) {
            return this.engineVerify(byArray);
        }
        throw new SignatureException("object not initialized for verification");
    }

    public final boolean verify(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 3) {
            if (byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IllegalArgumentException("Bad arguments");
            }
            return this.engineVerify(byArray, n, n2);
        }
        throw new SignatureException("object not initialized for verification");
    }

    public final void update(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException("object not initialized for signature or verification");
        }
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 2 && this.state != 3) {
            throw new SignatureException("object not initialized for signature or verification");
        }
        this.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        String string = "";
        switch (this.state) {
            case 0: {
                string = "<not initialized>";
                break;
            }
            case 3: {
                string = "<initialized for verifying>";
                break;
            }
            case 2: {
                string = "<initialized for signing>";
            }
        }
        return "Signature object: " + this.getAlgorithm() + string;
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(algorithmParameterSpec);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private static void debug(String string) {
    }

    private static void debug(Exception exception) {
    }

    static class Delegate
    extends Signature {
        private SignatureSpi sigSpi;

        public Delegate(SignatureSpi signatureSpi, String string) {
            super(string);
            this.sigSpi = signatureSpi;
        }

        public Object clone() throws CloneNotSupportedException {
            if (this.sigSpi instanceof Cloneable) {
                SignatureSpi signatureSpi = (SignatureSpi)this.sigSpi.clone();
                Delegate delegate = new Delegate(signatureSpi, ((Signature)this).algorithm);
                ((Signature)delegate).provider = ((Signature)this).provider;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.sigSpi.engineInitVerify(publicKey);
        }

        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.sigSpi.engineInitSign(privateKey);
        }

        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            this.sigSpi.engineInitSign(privateKey, secureRandom);
        }

        protected void engineUpdate(byte by) throws SignatureException {
            this.sigSpi.engineUpdate(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            this.sigSpi.engineUpdate(byArray, n, n2);
        }

        protected byte[] engineSign() throws SignatureException {
            return this.sigSpi.engineSign();
        }

        protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
            return this.sigSpi.engineSign(byArray, n, n2);
        }

        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            return this.sigSpi.engineVerify(byArray);
        }

        protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
            return this.sigSpi.engineVerify(byArray, n, n2);
        }

        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.sigSpi.engineSetParameter(algorithmParameterSpec);
        }

        protected AlgorithmParameters engineGetParameters() {
            return this.sigSpi.engineGetParameters();
        }
    }
}

