/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

final class Parameter {
    private TypeInfo typeInfo;
    private String typeDefinition = null;
    private boolean isOutput;
    private int registeredOutJdbcType = 999;
    private int outScale = 4;
    private String name;
    private DTV outDTV;
    private DTV inDTV;
    private DTV dtv;

    Parameter() {
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    boolean isOutput() {
        return this.isOutput;
    }

    int getJdbcType() throws SQLServerException {
        return null != this.inDTV ? this.inDTV.getJdbcType(null) : this.registeredOutJdbcType;
    }

    void registerForOutput(int n) {
        this.isOutput = true;
        this.registeredOutJdbcType = n;
        this.resetOutputValue();
    }

    int getOutScale() {
        return this.outScale;
    }

    void setOutScale(int n) {
        this.outScale = n;
    }

    final Parameter cloneForBatch() {
        Parameter parameter = new Parameter();
        parameter.typeInfo = this.typeInfo;
        parameter.typeDefinition = this.typeDefinition;
        parameter.isOutput = this.isOutput;
        parameter.registeredOutJdbcType = this.registeredOutJdbcType;
        parameter.outScale = this.outScale;
        parameter.name = this.name;
        parameter.outDTV = this.outDTV;
        parameter.inDTV = this.inDTV;
        parameter.dtv = this.dtv;
        return parameter;
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        this.outDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    final void skipRetValStatus(TDSReader tDSReader) throws SQLServerException {
        StreamRetValue streamRetValue = new StreamRetValue();
        streamRetValue.setFromTDS(tDSReader);
    }

    private void throwConversionError(int n, String string, boolean bl) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
        Object[] objectArray = new Object[2];
        objectArray[bl ? 0 : 1] = DataTypes.sqlNativeTypeToString(n);
        objectArray[bl ? 1 : 0] = string;
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
    }

    final void checkGetAsciiStream(TDSReader tDSReader) throws SQLServerException {
        this.deriveTypeInfo(tDSReader);
        this.checkConvertsAsciiStream(true);
    }

    private void checkConvertsAsciiStream(boolean bl) throws SQLServerException {
        boolean bl2 = DataTypes.canConvertFromNativeTypeToAsciiStream(this.typeInfo);
        if (bl2 && DataTypes.isNonUnicode(this.typeInfo.getNativeType())) {
            bl2 = this.typeInfo.getSQLCollation().supportsAsciiConversion();
        }
        if (!bl2) {
            this.throwConversionError(this.typeInfo.getNativeType(), "AsciiStream", bl);
        }
    }

    final void checkGetBinaryStream(TDSReader tDSReader) throws SQLServerException {
        this.deriveTypeInfo(tDSReader);
        this.checkConvertsBinaryStream(true);
    }

    private void checkConvertsBinaryStream(boolean bl) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToBinaryStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "BinaryStream", bl);
        }
    }

    final void checkGetCharacterStream(TDSReader tDSReader) throws SQLServerException {
        this.deriveTypeInfo(tDSReader);
        this.checkConvertsCharacterStream(true);
    }

    private void checkConvertsCharacterStream(boolean bl) throws SQLServerException {
        if (!DataTypes.canConvertFromNativeTypeToCharStream(this.typeInfo)) {
            this.throwConversionError(this.typeInfo.getNativeType(), "CharacterStream", bl);
        }
    }

    DTV getInDTV() {
        return this.inDTV;
    }

    void setInDTV(DTV dTV) throws SQLServerException {
        this.dtv = this.inDTV = dTV;
    }

    void clearInputValue() {
        this.dtv = this.outDTV;
        this.inDTV = null;
    }

    void resetOutputValue() {
        this.outDTV = null;
        this.dtv = this.inDTV;
        this.typeInfo = null;
    }

    void deriveTypeInfo(TDSReader tDSReader) throws SQLServerException {
        if (null == this.typeInfo) {
            this.typeInfo = new TypeInfo();
            this.typeInfo.setFromTDS(tDSReader);
            this.dtv = this.outDTV;
        }
    }

    void setFromReturnStatus(int n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.outDTV.setValue(null, 4, new Integer(n), null, sQLServerConnection);
        this.dtv = this.outDTV;
    }

    void setValue(int n, Object object, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.setValue(n, object, null, sQLServerConnection);
    }

    void setValue(int n, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        DTV dTV = new DTV();
        dTV.setValue(null, n, object, object2, sQLServerConnection);
        this.dtv = this.inDTV = dTV;
    }

    boolean isNull() {
        if (null != this.outDTV) {
            return this.outDTV.isNull();
        }
        return false;
    }

    boolean isValueGotten() {
        return null != this.outDTV;
    }

    Object getValue(int n, TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        return this.getValue(n, InputStreamGetterArgs.getDefaultArgs(), null, tDSReader);
    }

    Object getValue(int n, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        return this.getValue(n, InputStreamGetterArgs.getDefaultArgs(), calendar, tDSReader);
    }

    Object getValue(int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.outDTV.getValue(n, this.outScale, inputStreamGetterArgs, calendar, this.typeInfo, tDSReader);
    }

    byte getByte(TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.outDTV.getByte(this.typeInfo, tDSReader);
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.outDTV.getInt(this.typeInfo, tDSReader);
    }

    short getShort(TDSReader tDSReader) throws SQLServerException {
        if (null == this.outDTV) {
            this.outDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.outDTV.getShort(this.typeInfo, tDSReader);
    }

    String getTypeDefinition(SQLServerConnection sQLServerConnection, TDSReader tDSReader) throws SQLServerException {
        DTV dTV = this.dtv;
        int n = this.getJdbcType();
        if (null == this.dtv && !this.isOutput) {
            return null;
        }
        GetTypeDefinitionOp getTypeDefinitionOp = new GetTypeDefinitionOp(this, sQLServerConnection);
        DTV.executeOp(dTV, getTypeDefinitionOp, null != dTV ? dTV.getValue(n, this.outScale, null, null, this.typeInfo, tDSReader) : null, n);
        return this.typeDefinition;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection, int n) throws SQLServerException {
        DTV dTV = this.inDTV;
        int n2 = this.getJdbcType();
        if (null == dTV) {
            if (!this.isOutput) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(n + 1)};
                SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, false);
            }
            dTV = new DTV();
            dTV.setValue(null, n2, null, null, sQLServerConnection);
        }
        dTV.sendByRPC(this.name, n2, 0, this.outScale, this.isOutput, tDSWriter, sQLServerConnection, n);
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private static final String NVARCHAR_MAX = "nvarchar(max)";
        private static final String NVARCHAR_4K = "nvarchar(4000)";
        private static final String NTEXT = "ntext";
        private static final String VARCHAR_MAX = "varchar(max)";
        private static final String VARCHAR_8K = "varchar(8000)";
        private static final String TEXT = "text";
        private static final String VARBINARY_MAX = "varbinary(max)";
        private static final String VARBINARY_8K = "varbinary(8000)";
        private static final String IMAGE = "image";
        private final Parameter param;
        private final SQLServerConnection con;
        int scale = 0;
        long streamLength = 0L;
        int streamType = 0;

        GetTypeDefinitionOp(Parameter parameter2, SQLServerConnection sQLServerConnection) {
            this.param = parameter2;
            this.con = sQLServerConnection;
        }

        private void setTypeDefinition(int n) {
            switch (n) {
                case -6: {
                    this.param.typeDefinition = "tinyint";
                    break;
                }
                case 5: {
                    this.param.typeDefinition = "smallint";
                    break;
                }
                case 4: {
                    this.param.typeDefinition = "int";
                    break;
                }
                case -5: {
                    this.param.typeDefinition = "bigint";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.param.typeDefinition = "float";
                    break;
                }
                case 2: 
                case 3: {
                    Integer n2;
                    if (this.scale > 38) {
                        this.scale = 38;
                    }
                    if (null != this.param.dtv && null != (n2 = (Integer)this.param.dtv.getSetterArgs()) && this.scale < n2) {
                        this.scale = n2;
                    }
                    if (this.param.isOutput() && this.scale < this.param.getOutScale()) {
                        this.scale = this.param.getOutScale();
                    }
                    this.param.typeDefinition = "decimal(38," + this.scale + ")";
                    break;
                }
                case -7: 
                case 16: {
                    this.param.typeDefinition = "bit";
                    break;
                }
                case -4: 
                case 2004: {
                    if (this.param.isOutput() && this.con.isYukonOrLater()) {
                        this.param.typeDefinition = VARBINARY_MAX;
                        break;
                    }
                }
                case -3: 
                case -2: {
                    if (-1L == this.streamLength) {
                        this.param.typeDefinition = VARBINARY_MAX;
                        break;
                    }
                    if (this.streamLength > (long)(2 == this.streamType ? 16000 : 8000)) {
                        this.param.typeDefinition = this.con.isYukonOrLater() ? VARBINARY_MAX : IMAGE;
                        break;
                    }
                    if (VARBINARY_MAX == this.param.typeDefinition || IMAGE == this.param.typeDefinition) break;
                    this.param.typeDefinition = VARBINARY_8K;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.param.typeDefinition = "datetime";
                    break;
                }
                case -1: 
                case 2005: {
                    if (this.param.isOutput() && this.con.isYukonOrLater()) {
                        this.param.typeDefinition = 2 == this.streamType && this.con.sendStringParametersAsUnicode() ? NVARCHAR_MAX : VARCHAR_MAX;
                        break;
                    }
                }
                case 1: 
                case 12: {
                    if (2 == this.streamType && this.con.sendStringParametersAsUnicode()) {
                        if (-1L == this.streamLength) {
                            this.param.typeDefinition = NVARCHAR_MAX;
                            break;
                        }
                        if (NVARCHAR_MAX == this.param.typeDefinition || NTEXT == this.param.typeDefinition) break;
                        this.param.typeDefinition = this.streamLength <= 4000L ? NVARCHAR_4K : (this.con.isYukonOrLater() ? NVARCHAR_MAX : NTEXT);
                        break;
                    }
                    if (-1L == this.streamLength) {
                        this.param.typeDefinition = VARCHAR_MAX;
                        break;
                    }
                    if (VARCHAR_MAX == this.param.typeDefinition || TEXT == this.param.typeDefinition) break;
                    this.param.typeDefinition = this.streamLength <= 8000L ? VARCHAR_8K : (this.con.isYukonOrLater() ? VARCHAR_MAX : TEXT);
                    break;
                }
                default: {
                    this.param.typeDefinition = NVARCHAR_4K;
                }
            }
        }

        void execute(String string, int n) throws SQLServerException {
            this.streamType = 2;
            if (null != string) {
                this.streamLength = string.length();
            }
            this.setTypeDefinition(n);
        }

        void execute(Clob clob, int n) throws SQLServerException {
            this.streamType = 2;
            if (null != clob) {
                try {
                    this.streamLength = clob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(Byte by, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.setTypeDefinition(n2);
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Float f, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Double d, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            if (null != bigDecimal) {
                this.scale = bigDecimal.scale();
                if (this.scale < 0) {
                    this.scale = 0;
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(Long l, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Short s, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.streamType = 1;
            if (null != byArray) {
                this.streamLength = byArray.length;
            }
            this.setTypeDefinition(n);
        }

        void execute(Blob blob, int n) throws SQLServerException {
            this.streamType = 1;
            if (null != blob) {
                try {
                    this.streamLength = blob.length();
                }
                catch (SQLException sQLException) {
                    SQLServerException.makeFromDriverError(null, null, sQLException.toString(), null, false);
                }
            }
            this.setTypeDefinition(n);
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            if (null != inputStream) {
                InputStreamSetterArgs inputStreamSetterArgs = (InputStreamSetterArgs)dTV.getSetterArgs();
                this.streamType = inputStreamSetterArgs.streamType;
                this.streamLength = inputStreamSetterArgs.length;
            }
            this.setTypeDefinition(n);
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            this.streamType = 2;
            this.streamLength = null == reader ? 0L : (long)((CharacterStreamSetterArgs)dTV.getSetterArgs()).length;
            this.setTypeDefinition(n);
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            this.setTypeDefinition(n);
        }
    }
}

