/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.test.annotation.factory.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import junit.framework.Test;

import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.AnnotationValidationException;
import org.jboss.test.annotation.factory.support.ComplexWithDefault;

 
/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 70541 $
 */
public class NoJavassistAnnotationCreatorTestCase extends AnnotationCreatorTest
{
   public static Test suite()
   {
      return suite(NoJavassistAnnotationCreatorTestCase.class);
   }
   
   public NoJavassistAnnotationCreatorTestCase(String name)
   {
      super(name);
   }
   
   public void testDefaultValues() throws Exception
   {
      ClassLoader old = Thread.currentThread().getContextClassLoader();
      ClassLoader test = new TestClassLoader();
      Thread.currentThread().setContextClassLoader(test);
      try
      {
         String expr = "@org.jboss.test.annotation.factory.support.ComplexWithDefault";
         Class<?> annotation = test.loadClass(ComplexWithDefault.class.getName());
         Class<?> annotationCreator = test.loadClass(AnnotationCreator.class.getName());
         Method createAnnotation = annotationCreator.getDeclaredMethod("createAnnotation", new Class[] { String.class, Class.class });
         createAnnotation.invoke(null, new Object[] { expr, annotation });
         fail("Should have had a validation exception");
      }
      catch (InvocationTargetException expected)
      {
         Throwable cause = expected.getCause();
         assertEquals(AnnotationValidationException.class.getName(), cause.getClass().getName());
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(old);
      }
    }
   
   public class TestClassLoader extends ClassLoader
   {
      public TestClassLoader()
      {
         super(TestClassLoader.class.getClassLoader());
      }
      
      public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException
      {
         System.out.println(name);
         if (name.startsWith("javassist"))
            throw new ClassNotFoundException("exluding javassist");
         if (name.startsWith("org.jboss"))
         {
            String classPath = name.replace('.', '/') + ".class";
            try
            {
               InputStream is = getResourceAsStream(classPath);
               ByteArrayOutputStream baos = new ByteArrayOutputStream();
               byte[] bytes = new byte[1024];
               int read = is.read(bytes);
               while (read >= 0)
               {
                  baos.write(bytes, 0, read);
                  read = is.read(bytes);
               }
               is.close();
               baos.flush();
               bytes = baos.toByteArray();
               return defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e)
            {
               throw new RuntimeException(e);
            }
         }
         return super.loadClass(name, resolve);
      }
   }
}
