/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;


/**
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 5836 $
 */
public class DummyEvictionConfiguration implements EvictionPolicyConfig, Cloneable
{
   public String getEvictionPolicyClass()
   {
      return DummyEvictionPolicy.class.getName();
   }

   public void validate() throws ConfigurationException
   {
      // no-op      
   }
   
   public void reset()
   {
      // no-op
   }

   @Override
   public DummyEvictionConfiguration clone() throws CloneNotSupportedException
   {
      return (DummyEvictionConfiguration) super.clone();
   }   
   
   
}
