/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

/**
 * Most Recently Used Policy.
 * <p/>
 * This algorithm will evict the most recently used cache entries from cache.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 5730 $
 */
public class MRUPolicy extends BaseEvictionPolicy
{
   private MRUAlgorithm algorithm;


   public MRUPolicy()
   {
      super();
      algorithm = new MRUAlgorithm();
   }

   public EvictionAlgorithm getEvictionAlgorithm()
   {
      return algorithm;
   }

   public Class<MRUConfiguration> getEvictionConfigurationClass()
   {
      return MRUConfiguration.class;
   }
}
