/*
 * Created on 17-Feb-2005
 *
 *
 *
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import static org.testng.AssertJUnit.*;
import org.testng.annotations.Test;

/**
 * @author xenephon
 */
@SuppressWarnings("unchecked")
@Test(groups = "functional")
public class NodeInterceptorTransactionTest extends AbstractOptimisticTestCase
{
   public void testNoTransactionCRUDMethod() throws Exception
   {

      TestListener listener = new TestListener();
      final CacheSPI cache = createCacheWithListener(listener);

      CommandInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
      CommandInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
      MockInterceptor dummy = new MockInterceptor();

      interceptor.setNext(nodeInterceptor);
      nodeInterceptor.setNext(dummy);

      TestingUtil.replaceInterceptorChain(cache, interceptor);

      try
      {
         cache.put("/one/two", "key1", new Object());
         fail();
      }
      catch (Throwable t)
      {

         assertTrue(true);
      }
      assertEquals(null, dummy.getCalledCommand());
      cache.stop();
   }

   public void testNoTransactionGetMethod() throws Exception
   {

      TestListener listener = new TestListener();
      final CacheSPI cache = createCacheWithListener(listener);

      CommandInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
      CommandInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
      MockInterceptor dummy = new MockInterceptor();

      interceptor.setNext(nodeInterceptor);
      nodeInterceptor.setNext(dummy);

      TestingUtil.replaceInterceptorChain(cache, interceptor);

      boolean fail = false;
      try
      {
         assertEquals(null, cache.get("/one/two", "key1"));
      }
      catch (Exception e)
      {
         fail = true;
      }
      assertTrue(fail);
      assertEquals(null, dummy.getCalledCommand());
      cache.stop();
   }


}
