/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.loader;

import org.jboss.cache.Fqn;
import static org.testng.AssertJUnit.*;
import org.testng.annotations.Test;

import java.util.Properties;

/**
 * This test runs cache loader tests using Database as the cache loader store.
 * The default test is configured using Derby embedded framework.
 * The server and database configuration is read from a properties file located at
 * /etc/cache-jdbc.properties.
 * <p/>
 * To run this test with any other RDBMS, The appropriate JDBC driver
 * (i.e mysql-connector-java-3.0.10-stable-bin.jar)
 * must be in the lib directory.
 *
 * @author <a href="hmesha@novell.com">Hany Mesha</a>
 * @author <a href="mailto:galder.zamarreno@jboss.com">Galder Zamarreno</a>
 * @version <tt>$Revision: 6072 $</tt>
 */
@Test(groups = {"functional"})
public class JDBCCacheLoaderTest extends CacheLoaderTestsBase
{
   protected void configureCache() throws Exception
   {
      Properties prop = getProperties();

      String props = "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" +
            "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" +
            "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" +
            "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" +
            "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" +
            "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat") + "\n" +
            "cache.jdbc.table.name=" + prop.getProperty("cache.jdbc.table.name") + "\n" +
            "cache.jdbc.table.drop=false";

      // make sure dropTable is false!!

      cache.getConfiguration().setCacheLoaderConfig(getSingleCacheLoaderConfig("",
            "org.jboss.cache.loader.JDBCCacheLoader", props, false, true, false));
   }

   public void testLargeObject()
   {
      try
      {
         String key = "LargeObj";
         // create an object with size bigger than 4k (k=1024 bytes)
         StringBuilder text = new StringBuilder("LargeObject");
         while (text.toString().getBytes().length < (1024 * 100))
         {
            text.append(text);
         }
         String initialValue = text.toString();
         // insert it into the cache loader
         loader.remove(Fqn.fromString("/"));

         Object retVal = loader.put(FQN, key, initialValue);
         assertNull(retVal);
         addDelay();
         // load the object from the cache loader and validate it
         assertEquals(initialValue, (String) loader.get(FQN).get(key));
         // update the object and validate it
         String updatedValue = initialValue.concat(("UpdatedValue"));
         retVal = loader.put(FQN, key, updatedValue);
         assertEquals(initialValue, (String) retVal);
         assertEquals(updatedValue, (String) loader.get(FQN).get(key));
      }
      catch (Exception e)
      {
         fail(e.toString());
      }
   }

   protected Properties getProperties() throws Exception
   {
      Properties properties = new Properties();
      try
      {
         properties.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
         return properties;
      }
      catch (Exception e)
      {
         throw new Exception("Error loading jdbc properties ", e);
      }
   }

   public void testRootIsCreated() throws Exception
   {
      loader.put(Fqn.fromString("/a/b/c"), "a", "b");
      assertTrue(loader.exists(Fqn.ROOT));
   }
}
