/* Copyright (c) 2011 Peter Troshin
 *  
 *  JAva Bioinformatics Analysis Web Services (JABAWS) @version: 2.0     
 * 
 *  This library is free software; you can redistribute it and/or modify it under the terms of the
 *  Apache License version 2 as published by the Apache Software Foundation
 * 
 *  This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 *  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Apache 
 *  License for more details.
 * 
 *  A copy of the license is in apache_license.txt. It is also available here:
 * @see: http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Any republication or derived work distributed in source code form
 * must include this copyright and license notice.
 */

package compbio.data.sequence;

/**
 * The list of programmes that can produce alignments
 * 
 * @author pvtroshin
 * 
 */
public enum Program {

	/**
	 * ClustalW
	 */
	CLUSTAL,

	/**
	 * ClustalO
	 */
	ClustalO,
	/**
	 * Mafft
	 */
	Mafft,

	/**
	 * Muscle
	 */
	Muscle,

	/**
	 * Tcoffee
	 */
	Tcoffee,

	/**
	 * Probcons
	 */
	Probcons,

	/**
	 * MSAprobs
	 */
	MSAprobs,

	/**
	 * GLprobs
	 */
	GLprobs,

	/**
	 * Jpred
	 */
//	Jpred
}
