/*
 *  @(#)ITransition.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1;


/**
 * Corresponds to a state-machine transition from one state to another.
 * Transitions must verify that their associated action can be performed
 * on the current system's state.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 12, 2002
 */
public interface ITransition
{
    /**
     * Retrieves the name for the transition.  This should be unique for
     * state-machine assembly purposes, but it does not have to be.
     *
     * @return a non-null name for this transition.
     */
    public String getName();
    
    
    /**
     * Returns the next state if the corresponding action is executed.
     *
     * @return destination state, which can never be <tt>null</tt>.
     */
    public IState getDestinationState();
    
    
    /**
     * Returns the action used to transition to the destination state.
     *
     * @return transition's action, which can never be <tt>null</tt>.
     */
    public IAction getAction();
    
    
    /**
     * Returns all validation methods used to assert that the system can
     * perform this transition.
     *
     * @return a list of associated validation instances.
     */
    public IValidate[] getValidates();
}

