/*
 * @(#)IntegrationTestCaseUTest.java
 *
 * Copyright (C) 2002-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.junit.v1;

//import net.sourceforge.groboutils.testing.junitlog.v1.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.TestResult;
import junit.framework.TestFailure;

import java.util.Enumeration;
import java.io.IOException;
import java.lang.reflect.Method;


/**
 * Tests the IntegrationTestCase class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 1, 2002
 * @version   $Date: 2004/01/09 20:32:26 $
 */
public class IntegrationTestCaseUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IntegrationTestCaseUTest.class;
    private static final org.apache.log4j.Logger LOG =
        org.apache.log4j.Logger.getLogger( THIS_CLASS );
    
    public IntegrationTestCaseUTest( String name )
    {
        super( name );
    }

    


    //-------------------------------------------------------------------------
    // Tests
    
    private static final String MSG = "#$%-=!";
    
    
    public void testSoftAssert1()
    {
        IntegrationTestCase itc = createIntegrationTestCase();
        
        // ensure that adding a failing test doesn't cause failures in the
        // owning test.
        itc.softFail();
    }
    
    
    public void testSoftAssert2()
    {
        IntegrationTestCase itc = createIntegrationTestCase();
        
        // ensure that adding a passing test doesn't cause failures in owning
        // test.
        itc.softAssertTrue( true );
    }
    
    
    //---------
    public static class ITC_True1 extends IntegrationTestCase
    {
        public ITC_True1( String name ) { super( name ); }
        public void test1()
        {
            softAssertTrue( true );
        }
    }
    public void testSoftAssertTrue1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_True1.class, 2, 0, 0, false );
    }
    
    //---------
    public static class ITC_True2 extends IntegrationTestCase
    {
        public ITC_True2( String name ) { super( name ); }
        public void test1()
        {
            softAssertTrue( MSG, true );
        }
    }
    public void testSoftAssertTrue2()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_True2.class, 2, 0, 0, true );
    }
    
    //---------
    public static class ITC_True3 extends IntegrationTestCase
    {
        public ITC_True3( String name ) { super( name ); }
        public void test1()
        {
            softAssertTrue( false );
        }
    }
    public void testSoftAssertTrue3()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_True3.class, 2, 1, 0, false );
    }
    
    //---------
    public static class ITC_True4 extends IntegrationTestCase
    {
        public ITC_True4( String name ) { super( name ); }
        public void test1()
        {
            softAssertTrue( MSG, false );
        }
    }
    public void testSoftAssertTrue4()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_True4.class, 2, 1, 0, true );
    }
    
    //---------
    public static class ITC_False1 extends IntegrationTestCase
    {
        public ITC_False1( String name ) { super( name ); }
        public void test1()
        {
            softAssertFalse( false );
        }
    }
    public void testSoftAssertFalse1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_False1.class, 2, 0, 0, false );
    }
    
    //---------
    public static class ITC_False2 extends IntegrationTestCase
    {
        public ITC_False2( String name ) { super( name ); }
        public void test1()
        {
            softAssertFalse( MSG, false );
        }
    }
    public void testSoftAssertFalse2()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_False2.class, 2, 0, 0, true );
    }
    
    //---------
    public static class ITC_False3 extends IntegrationTestCase
    {
        public ITC_False3( String name ) { super( name ); }
        public void test1()
        {
            softAssertFalse( true );
        }
    }
    public void testSoftAssertFalse3()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_False3.class, 2, 1, 0, false );
    }
    
    //---------
    public static class ITC_False4 extends IntegrationTestCase
    {
        public ITC_False4( String name ) { super( name ); }
        public void test1()
        {
            softAssertFalse( MSG, true );
        }
    }
    public void testSoftAssertFalse4()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_False4.class, 2, 1, 0, true );
    }
    
    //---------
    public static class ITC_Fail1 extends IntegrationTestCase
    {
        public ITC_Fail1( String name ) { super( name ); }
        public void test1()
        {
            softFail();
        }
    }
    public void testSoftFail1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Fail1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Fail2 extends IntegrationTestCase
    {
        public ITC_Fail2( String name ) { super( name ); }
        public void test1()
        {
            softFail( MSG );
        }
    }
    public void testSoftFail2()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Fail2.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_NotNull_O1 extends IntegrationTestCase
    {
        public ITC_NotNull_O1( String name ) { super( name ); }
        public void test1()
        {
            softAssertNotNull( null );
        }
    }
    public void testSoftAssertNotNull_O1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_NotNull_O1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_NotNull_O2 extends IntegrationTestCase
    {
        public ITC_NotNull_O2( String name ) { super( name ); }
        public void test1()
        {
            softAssertNotNull( new Object() );
        }
    }
    public void testSoftAssertNotNull_O2()
    {
        // Ensure that two tests run, and there are no failures.
        runITC( ITC_NotNull_O2.class, 2, 0, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SJJ1 extends IntegrationTestCase
    {
        public ITC_Equals_SJJ1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Long.MIN_VALUE, Long.MAX_VALUE );
        }
    }
    public void testSoftAssertEquals_SJJ1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SJJ1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_NotSame_SOO1 extends IntegrationTestCase
    {
        public ITC_NotSame_SOO1( String name ) { super( name ); }
        public void test1()
        {
            Object o = new Object();
            softAssertNotSame( MSG, o, o );
        }
    }
    public void testSoftAssertNotSame_SOO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_NotSame_SOO1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_SOO1 extends IntegrationTestCase
    {
        public ITC_Equals_SOO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, new Object(), "check string" );
        }
    }
    public void testSoftAssertEquals_SOO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SOO1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_NotSame_OO1 extends IntegrationTestCase
    {
        public ITC_NotSame_OO1( String name ) { super( name ); }
        public void test1()
        {
            Object o = new Object();
            softAssertNotSame( o, o );
        }
    }
    public void testSoftAssertNotSame_OO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_NotSame_OO1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Null_SO1 extends IntegrationTestCase
    {
        public ITC_Null_SO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertNull( MSG, new Object() );
        }
    }
    public void testSoftAssertNull_SO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Null_SO1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_XX1 extends IntegrationTestCase
    {
        public ITC_Equals_XX1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Short.MAX_VALUE, Short.MIN_VALUE );
        }
    }
    public void testSoftAssertEquals_XX1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_XX1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_OO1 extends IntegrationTestCase
    {
        public ITC_Equals_OO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( new Object(), "t2" );
        }
    }
    public void testSoftAssertEquals_OO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_OO1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SSS1 extends IntegrationTestCase
    {
        public ITC_Equals_SSS1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, "t1", "t2" );
        }
    }
    public void testSoftAssertEquals_SSS1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SSS1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_BB1 extends IntegrationTestCase
    {
        public ITC_Equals_BB1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Byte.MAX_VALUE, Byte.MIN_VALUE );
        }
    }
    public void testSoftAssertEquals_BB1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_BB1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SFFF1 extends IntegrationTestCase
    {
        public ITC_Equals_SFFF1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Float.MIN_VALUE, Float.MAX_VALUE, 10.0f );
        }
    }
    public void testSoftAssertEquals_SFFF1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SFFF1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_SCC1 extends IntegrationTestCase
    {
        public ITC_Equals_SCC1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, '1', '2' );
        }
    }
    public void testSoftAssertEquals_SCC1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SCC1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Same_OO1 extends IntegrationTestCase
    {
        public ITC_Same_OO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertSame( new Object(), new Object() );
        }
    }
    public void testSoftAssertSame_OO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Same_OO1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_JJ1 extends IntegrationTestCase
    {
        public ITC_Equals_JJ1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Long.MIN_VALUE, Long.MAX_VALUE );
        }
    }
    public void testSoftAssertEquals_JJ1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_JJ1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SZZ1 extends IntegrationTestCase
    {
        public ITC_Equals_SZZ1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, true, false );
        }
    }
    public void testSoftAssertEquals_SZZ1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SZZ1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_DDD1 extends IntegrationTestCase
    {
        public ITC_Equals_DDD1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Double.MAX_VALUE, Double.MIN_VALUE, 1.0 );
        }
    }
    public void testSoftAssertEquals_DDD1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_DDD1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Same_SOO1 extends IntegrationTestCase
    {
        public ITC_Same_SOO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertSame( MSG, new Object(), new Object() );
        }
    }
    public void testSoftAssertSame_SOO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Same_SOO1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_NotNull_SO1 extends IntegrationTestCase
    {
        public ITC_NotNull_SO1( String name ) { super( name ); }
        public void test1()
        {
            softAssertNotNull( MSG, null );
        }
    }
    public void testSoftAssertNotNull_SO1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_NotNull_SO1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_SII1 extends IntegrationTestCase
    {
        public ITC_Equals_SII1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Integer.MIN_VALUE, Integer.MAX_VALUE );
        }
    }
    public void testSoftAssertEquals_SII1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SII1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Null_O1 extends IntegrationTestCase
    {
        public ITC_Null_O1( String name ) { super( name ); }
        public void test1()
        {
            softAssertNull( new Object() );
        }
    }
    public void testSoftAssertNull_O1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Null_O1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SDDD1 extends IntegrationTestCase
    {
        public ITC_Equals_SDDD1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Double.MIN_VALUE, Double.MAX_VALUE, 1.0 );
        }
    }
    public void testSoftAssertEquals_SDDD1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SDDD1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_CC1 extends IntegrationTestCase
    {
        public ITC_Equals_CC1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( 'a', 'b' );
        }
    }
    public void testSoftAssertEquals_CC1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_CC1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SXX1 extends IntegrationTestCase
    {
        public ITC_Equals_SXX1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Short.MAX_VALUE, Short.MIN_VALUE );
        }
    }
    public void testSoftAssertEquals_SXX1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SXX1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_ZZ1 extends IntegrationTestCase
    {
        public ITC_Equals_ZZ1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( true, false );
        }
    }
    public void testSoftAssertEquals_ZZ1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_ZZ1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_SBB1 extends IntegrationTestCase
    {
        public ITC_Equals_SBB1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( MSG, Byte.MAX_VALUE, Byte.MIN_VALUE );
        }
    }
    public void testSoftAssertEquals_SBB1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SBB1.class, 2, 1, 0, true );
    }
    
    
    //---------
    public static class ITC_Equals_SS1 extends IntegrationTestCase
    {
        public ITC_Equals_SS1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( "t1", "t2" );
        }
    }
    public void testSoftAssertEquals_SS1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_SS1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_II1 extends IntegrationTestCase
    {
        public ITC_Equals_II1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Integer.MAX_VALUE, Integer.MIN_VALUE );
        }
    }
    public void testSoftAssertEquals_II1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_II1.class, 2, 1, 0, false );
    }
    
    
    //---------
    public static class ITC_Equals_FFF1 extends IntegrationTestCase
    {
        public ITC_Equals_FFF1( String name ) { super( name ); }
        public void test1()
        {
            softAssertEquals( Float.MAX_VALUE, Float.MIN_VALUE, 1.0f );
        }
    }
    public void testSoftAssertEquals_FFF1()
    {
        // Ensure that two tests run, and there is one failure.
        runITC( ITC_Equals_FFF1.class, 2, 1, 0, false );
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    protected IntegrationTestCase createIntegrationTestCase()
    {
        return new IntegrationTestCase( "name" );
    }
    
    
    protected TestResult runITC( Class itcClass,
            int runCount, int failureCount, int errorCount,
            boolean hasMessage )
    {
        TestSuite suite = new TestSuite( itcClass );
        TestResult tr = new TestResult();
        LOG.info( "Running tests..." );
        try
        {
            suite.run( tr );
        }
        catch (RuntimeException re)
        {
            re.printStackTrace();
            throw re;
        }
        catch (Error e)
        {
            e.printStackTrace();
            throw e;
        }
        LOG.info( "Expected "+runCount+" runs, but found "+tr.runCount()+"." );
        LOG.info( "Expected "+failureCount+" failures, but found "+
            tr.failureCount()+"." );
        LOG.info( "Expected "+errorCount+" errors, but found "+
            tr.errorCount()+"." );
        //LOG.info( tr.failures().nextElement().toString() );
        assertEquals(
            "Did not have the correct number of failures.",
            failureCount,
            tr.failureCount() );
        assertEquals(
            "Did not have the correct number of errors.",
            errorCount,
            tr.errorCount() );
        assertEquals(
            "Did not have the correct number of test runs.",
            runCount,
            tr.runCount() );
        Enumeration enum = tr.failures();
        while (enum.hasMoreElements())
        {
            TestFailure tf = (TestFailure)enum.nextElement();
            String msg = tf.thrownException().getMessage();
            assertEquals(
                "Message expectation not met (true = has message);",
                hasMessage,
                msg.indexOf( MSG ) >= 0 );
        }
        return tr;
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

