/*
 * @(#)AutoDocJDK13UTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import net.sourceforge.groboutils.autodoc.v1.spi.*;
import net.sourceforge.groboutils.autodoc.v1.defimpl.*;
import java.util.*;


/**
 * Tests the AutoDoc class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:14 $
 * @since     March 21, 2002
 */
public class AutoDocJDK13UTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocJDK13UTest.class;
    
    public AutoDocJDK13UTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    private MockControl factoryControl;
    private AutoDocFactory mockFactory;

    private MockControl logControl;
    private AutoDocLog mockLog;

    private MockControl itControl;
    private AutoDocIT mockIT;

    private MockControl tpControl;
    private AutoDocTP mockTP;
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        this.factoryControl = EasyMock.controlFor( AutoDocFactory.class );
        this.mockFactory = (AutoDocFactory)this.factoryControl.getMock();
        
        this.logControl = EasyMock.controlFor( AutoDocLog.class );
        this.mockLog = (AutoDocLog)this.logControl.getMock();
        
        this.itControl = EasyMock.controlFor( AutoDocIT.class );
        this.mockIT = (AutoDocIT)this.itControl.getMock();
        
        this.tpControl = EasyMock.controlFor( AutoDocTP.class );
        this.mockTP = (AutoDocTP)this.tpControl.getMock();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new AutoDoc( this.getClass() );
    }
    
    
    public void testConstructor2()
    {
        try
        {
            new AutoDoc( null );
            fail("AutoDoc constructor did not throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException e)
        {
            // test exception?
        }
    }
    
    /*
    public void testFactoryUse1()
    {
        this.mockFactory.createLog( this.getClass() );
        this.factoryControl.setReturnValue( this.mockLog, 1 );
        
        this.mockFactory.createIT( this.getClass() );
        this.factoryControl.setReturnValue( this.mockIT, 1 );
        
        this.mockFactory.createTP( this.getClass() );
        this.factoryControl.setReturnValue( this.mockTP, 1 );
        
        this.factoryControl.activate();
        this.logControl.activate();
        this.itControl.activate();
        this.tpControl.activate();
        
        MockAutoDoc mad = new MockAutoDoc( this.getClass(),
            this.mockFactory );
        
        assertIsOrContains(
            "Did not use specified log factory.",
            this.mockLog,
            mad.getLog() );
        assertIsOrContains(
            "Did not use specified log factory.",
            this.mockLog,
            mad.getLog() );
        assertIsOrContains(
            "Did not use specified it factory.",
            this.mockIT,
            mad.getIT() );
        assertIsOrContains(
            "Did not use specified it factory.",
            this.mockIT,
            mad.getIT() );
        assertIsOrContains(
            "Did not use specified tp factory.",
            this.mockTP,
            mad.getTP() );
        assertIsOrContains(
            "Did not use specified tp factory.",
            this.mockTP,
            mad.getTP() );
        
        
        this.factoryControl.verify();
        this.logControl.verify();
        this.itControl.verify();
        this.tpControl.verify();
        mad.mockVerify();
    }
    */
    
    public void testFactoryStore1()
    {
        assertNotNull(
            "SingletonStore cannot be null.",
            AutoDoc.getFactoryStore() );
    }
    
    
    public void testGetFactory1()
    {
        Enumeration origEnum = AutoDoc.getFactoryStore().getSingletons();
        assertNotNull(
            "Static set of factories returned null.",
            origEnum );
         
        AutoDoc ad = new AutoDoc( THIS_CLASS );
        AutoDocFactory[] adf = ad.getFactories();
        assertNotNull( "AutoDoc instance returned null factory.", adf );
        
        int foundCount = 0;
        while (origEnum.hasMoreElements())
        {
            AutoDocFactory orig = (AutoDocFactory)origEnum.nextElement();
            assertNotNull(
                "Static set of factories contains null.",
                orig );
            boolean found = false;
            for (int i = 0; i < adf.length; ++i)
            {
                if (orig == adf[i])
                {
                    ++foundCount;
                    // null it out so we don't accidentily count it again
                    adf[i] = null;
                    found = true;
                    break;
                }
            }
            assertTrue(
                "Did not find static factory "+orig+" in AutoDoc instance.",
                found );
        }
        assertEquals(
            "Static set of factories contained fewer elements than "+
                "AutDoc instance.",
            foundCount,
            adf.length );
    }
    
    
    public void testAddFactory1()
    {
        AutoDoc ad = new AutoDoc( THIS_CLASS );
        ad.addFactory( this.mockFactory );
        AutoDocFactory[] adf = ad.getFactories();
        assertNotNull( "AutoDoc instance returned null factory.", adf );
        boolean found = false;
        for (int i = 0; i < adf.length; ++i)
        {
            if (adf[i] == this.mockFactory)
            {
                found = true;
                break;
            }
        }
        assertTrue(
            "Default autodoc must contain the exact factory added.",
            found );
    }
    
    
    public void testOwner1()
    {
        AutoDoc ad = new AutoDoc( THIS_CLASS );
        assertEquals(
            "Did not store class correctly.",
            THIS_CLASS,
            ad.getOwner() );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    protected void assertIsOrContains( String msg, Object orig, Object ret )
    {
        String rmsg = msg+": original=<"+orig+">, found=<"+ret+">";
        if (orig == null)
        {
            assertNull( rmsg, ret );
        }
        if (orig == ret
            || orig.equals( ret ))
        {
            return;
        }
        
        if (ret instanceof IAutoDocSet)
        {
            Enumeration enum = ((IAutoDocSet)ret).getSetContents();
            while (enum.hasMoreElements())
            {
                Object next = enum.nextElement();
                if (orig == next
                    || orig.equals( next ))
                {
                    // found it - assert passed.
                    return;
                }
            }
            // was not found
            fail( rmsg );
        }
        else
        {
            fail( rmsg );
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

