/*
 *  @(#)LogFileServer.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1.server;


import java.io.File;
import java.io.Writer;
import java.io.IOException;

import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestInfo;

import net.sourceforge.groboutils.pmti.v1.autodoc.v1.ITFTestData;


/**
 * An interface which corresponds to a part of the framework that knows how
 * to deal with the framework's <tt>TestData</tt>.  It may directly deal with
 * the data, or pass it off to a remote server.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:51:56 $
 */
public class LogFileServer extends AbstractAppendFileServer
{
    public LogFileServer( File f )
    {
        super( f );
    }
    
    
    
    
    /**
     * Write the TestData with all the result's encountered BugTestLog
     * events.
     */
    protected void writeTestData( TestData td, Writer w )
            throws IOException
    {
        if (td == null || !(td instanceof ITFTestData))
        {
            return;
        }
        String newline = System.getProperty( "line.separator" );
        ITFTestData itd = (ITFTestData)td;
        TestInfo ti = td.getTestInfo();
        
        StringBuffer sb = new StringBuffer( ti.getSuite() );
        sb.append( '#' ).
            append( ti.getMethod() ).
            append( " test count=" ).
            append( itd.getTestCount() ).
            append( " runtime in ms=" ).
            append( itd.getRunTime() ).
            append( newline ).
            append( "    Failures:" );
        appendArray( sb, itd.getFailures(), newline );
        sb.append( newline ).
            append( "    Errors:" );
        appendArray( sb, itd.getErrors(), newline );
        sb.append( newline ).
            append( "    Bugs: " );
        String logs[] = itd.getIssues();
        if (logs.length <= 0)
        {
            sb.append("none" );
        }
        else
        {
            sb.append( logs[0] );
            for (int i = 1; i < logs.length; ++i)
            {
                sb.append( ", " ).
                    append( logs[i] );
            }
        }
        sb.append( newline );
        
        w.write( sb.toString() );
        w.flush();
    }
    
    
    void appendArray( StringBuffer sb, Object[] list, String newline )
    {
        if (list == null || list.length <= 0)
        {
            sb.append( " none" );
        }
        else
        {
            for (int i = 0; i < list.length; ++i)
            {
                sb.append( newline ).
                    append( "        " ).
                    append( list[i] );
            }
        }
    }
}

