<?xml version="1.0" encoding="ISO-8859-1"?>


<!--
Site-wide style for each sub-project
version $Date: 2004/01/09 20:32:25 $


Creates an HTML-viewable document for a code-coverage report.

 @author Matt Albrecht (mailto:groboclown@users.sourceforge.net)
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0' >

    <xsl:output method="html" indent="no"
        doctype-public="-//W3C//DTD HTML 4.01 Frameset//EN"
        doctype-system="http://www.w3.org/TR/html4/frameset.dtd"
    />

    <xsl:param name="perfectP" select="'100'" />
    <xsl:param name="goodP" select="'80'" />
    <xsl:param name="warnP" select="'60'" />
    
    <!-- not used
    <xsl:param name="do-weight" select="false" />
    -->
    <xsl:param name="title" select="'Code Coverage Report'" />
    
    <xsl:param name="TSTAMP" select="'(unknown)'" />
    
    
    <!-- base document: contains all coverage reports -->
    <xsl:template match="coveragereport">
<!--
Stolen from the JavaDoc web pages...
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
-->
<html>
  <head>
    <title><xsl:value-of select="$title" /></title>
  </head>
  <frameset cols="20%,80%">
    <frameset rows="30%,70%">
      <frame name="packageListFrame" src="overview-frame.html" title="All Packages" />
      <frame name="packageFrame" src="allclasses-frame.html" title="All Classes" />
    </frameset>

    <frame name="classFrame" src="overview-summary.html" title="Summary of Packages" />
  </frameset>
  <noframes>
<h2>
Frame Alert</h2>

<p />
This document is designed to be viewed using the frames feature. If you see
this message, you are using a non-frame-capable web client.
  <br />
Link to <a HREF="overview-summary.html">Non-frame version.</a>
  </noframes>
</html>
    </xsl:template>
</xsl:stylesheet>
