------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Traces; use GNATCOLL.Traces;
with GNATCOLL.VFS;    use GNATCOLL.VFS;

procedure Wildcard is
   Me : constant Trace_Handle := Create ("FOO");
   Bar : constant Trace_Handle := Create ("BAR");
   Bar2Test : constant Trace_Handle := Create ("BAR2TEST"); --  Active
   Bar2 : constant Trace_Handle := Create ("BAR2"); --  Inactive
   Bar2_Child1 : constant Trace_Handle := Create ("BAR2.CHILD1"); -- Active
   Bar2_Child2 : constant Trace_Handle := Create ("BAR2.CHILD2"); -- inactive
   Bar2_Child3 : constant Trace_Handle := Create ("BAR2.CHILD3"); -- inactive
   Me_Except : constant Trace_Handle := Create ("FOO.EXCEPTIONS"); -- Active

   Inactive : constant Trace_Handle := Create ("INACTIVE", Off);
   --  inactive by default, but the corresponding EXCEPTIONS stream should
   --  be active.

   --  Override a declaration from code (this is only taken into account
   --  if there is no such declaration from the config file)

   Config_Exceptions : Trace_Handle;
begin
   Parse_Config_File (Create_From_Base ("gnatdebug_traces4"));
   Config_Exceptions :=
      Create ("*.CHILD3", Default => On, Stream => "wildcard.out");

   Trace (Me, "Appended trace");
   Trace (Bar, "Appended trace");

   Trace (Bar2Test, "Test1");
   Trace (Bar2, "Test2");  --  Should have no effect (Bar2 is inactive)
   Trace (Bar2_Child1, "Test3");
   Trace (Bar2_Child2, "Test4");  --  Should have no effect (Bar2 is inactive)
   Trace (Bar2_Child3, "Test5"); --  Active now
   Trace (Me_Except, "Test6");

   begin
      raise Program_Error with "Some message";
   exception
      when E : Program_Error =>
         --  This in fact prints on Me_Except, so on stdout
         Trace (Me, E);
   end;

   begin
      raise Program_Error with "Some message2";
   exception
      when E : Program_Error =>
         --  This in fact prints on "BAR.EXCEPTIONS", so on stdout
         Trace (Bar, E);
   end;

   begin
      raise Program_Error with "Some message3";
   exception
      when E : Program_Error =>
         --  This in fact prints on "BAR2.EXCEPTIONS", so inactive
         Trace (Bar2, E);
   end;

   begin
      raise Program_Error with "Some message4";
   exception
      when E : others =>
         --  Should be visible because "*.EXCEPTIONS=yes"
         Trace (Inactive, E);
   end;
end Wildcard;
