------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;     use GNAT.IO;
with Ada.Unchecked_Deallocation;

package body Traces2_Support is

   procedure Put (Stream : in out My_Stream; Str : Msg_Strings.XString) is
      S : constant String := Str.To_String;
   begin
      Put_Line (Stream.Args.all & "--" & S (S'First .. S'Last - 1) & "--");
   end Put;

   procedure Close (Stream : in out My_Stream) is
      procedure Unchecked_Free is new Ada.Unchecked_Deallocation
         (String, GNAT.Strings.String_Access);
   begin
      Unchecked_Free (Stream.Args);
      Close (Trace_Stream_Record (Stream));
   end Close;

   function New_Stream
     (Fact : Factory; Args : String) return Trace_Stream
   is
      pragma Unreferenced (Fact);
   begin
      return new My_Stream'
         (Trace_Stream_Record with Args => new String'(Args));
   end New_Stream;

   procedure Before_Message
     (Self    : in out My_Decorator;
      Handle  : not null Logger;
      Msg     : in out Msg_Strings.XString)
   is
      pragma Unreferenced (Handle);
   begin
      Msg.Append ("[MY_DECORATOR.PRE]");
   end Before_Message;

   procedure After_Message
     (Self    : in out My_Decorator;
      Handle  : not null Logger;
      Msg     : in out Msg_Strings.XString)
   is
      pragma Unreferenced (Handle);
   begin
      Msg.Append ("[MY_DECORATOR.POST]");
   end After_Message;

end Traces2_Support;
