/* desktop-entry-impl-gnome.c generated by valac 0.10.4, the Vala compiler
 * generated from desktop-entry-impl-gnome.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop Entry implementation using GNOME.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/fdo.h>
#include <libgnome/gnome-desktop-item.h>
#include <libdesktop-agnostic/vfs.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>


#define DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME (desktop_agnostic_fdo_desktop_entry_gnome_get_type ())
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME, DesktopAgnosticFDODesktopEntryGNOME))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME, DesktopAgnosticFDODesktopEntryGNOMEClass))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GNOME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME))
#define DESKTOP_AGNOSTIC_FDO_IS_DESKTOP_ENTRY_GNOME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME))
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME, DesktopAgnosticFDODesktopEntryGNOMEClass))

typedef struct _DesktopAgnosticFDODesktopEntryGNOME DesktopAgnosticFDODesktopEntryGNOME;
typedef struct _DesktopAgnosticFDODesktopEntryGNOMEClass DesktopAgnosticFDODesktopEntryGNOMEClass;
typedef struct _DesktopAgnosticFDODesktopEntryGNOMEPrivate DesktopAgnosticFDODesktopEntryGNOMEPrivate;
#define _gnome_desktop_item_unref0(var) ((var == NULL) ? NULL : (var = (gnome_desktop_item_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DesktopAgnosticFDODesktopEntryGNOME {
	GObject parent_instance;
	DesktopAgnosticFDODesktopEntryGNOMEPrivate * priv;
};

struct _DesktopAgnosticFDODesktopEntryGNOMEClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticFDODesktopEntryGNOMEPrivate {
	GnomeDesktopItem* item;
	DesktopAgnosticVFSFile* _file;
	GKeyFile* _keyfile;
};


static gpointer desktop_agnostic_fdo_desktop_entry_gnome_parent_class = NULL;
static DesktopAgnosticFDODesktopEntryIface* desktop_agnostic_fdo_desktop_entry_gnome_desktop_agnostic_fdo_desktop_entry_parent_iface = NULL;

GType desktop_agnostic_fdo_desktop_entry_gnome_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME, DesktopAgnosticFDODesktopEntryGNOMEPrivate))
enum  {
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_FILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_KEYFILE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_DATA,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ENTRY_TYPE,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_NAME,
	DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ICON
};
static void desktop_agnostic_fdo_desktop_entry_gnome_real_constructed (GObject* base);
static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key);
static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value);
static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key);
static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value);
static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale);
static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value);
static char** desktop_agnostic_fdo_desktop_entry_gnome_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key);
static char** _vala_array_dup1 (char** self, int length);
static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value);
static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_exists (DesktopAgnosticFDODesktopEntry* base);
static GPid desktop_agnostic_fdo_desktop_entry_gnome_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error);
static void _g_list_free_g_free (GList* self);
static void desktop_agnostic_fdo_desktop_entry_gnome_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error);
DesktopAgnosticFDODesktopEntryGNOME* desktop_agnostic_fdo_desktop_entry_gnome_new (void);
DesktopAgnosticFDODesktopEntryGNOME* desktop_agnostic_fdo_desktop_entry_gnome_construct (GType object_type);
static void desktop_agnostic_fdo_desktop_entry_gnome_finalize (GObject* obj);
static void desktop_agnostic_fdo_desktop_entry_gnome_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_fdo_desktop_entry_gnome_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void desktop_agnostic_fdo_desktop_entry_gnome_real_constructed (GObject* base) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	if (self->priv->item == NULL) {
		GnomeDesktopItem* _tmp0_;
		self->priv->item = (_tmp0_ = gnome_desktop_item_new (), _gnome_desktop_item_unref0 (self->priv->item), _tmp0_);
	}
}


static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_key_exists (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	result = gnome_desktop_item_attr_exists (self->priv->item, key);
	return result;
}


static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_get_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_val_if_fail (key != NULL, FALSE);
	result = gnome_desktop_item_get_boolean (self->priv->item, key);
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_boolean (DesktopAgnosticFDODesktopEntry* base, const char* key, gboolean value) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_if_fail (key != NULL);
	gnome_desktop_item_set_boolean (self->priv->item, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_string (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	char* result = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_val_if_fail (key != NULL, NULL);
	result = g_strdup (gnome_desktop_item_get_string (self->priv->item, key));
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_string (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* value) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	gnome_desktop_item_set_string (self->priv->item, key, value);
}


static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	char* result = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_val_if_fail (key != NULL, NULL);
	if (locale == NULL) {
		result = g_strdup (gnome_desktop_item_get_localestring (self->priv->item, key));
		return result;
	}
	result = g_strdup (gnome_desktop_item_get_localestring_lang (self->priv->item, key, locale));
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_localestring (DesktopAgnosticFDODesktopEntry* base, const char* key, const char* locale, const char* value) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_if_fail (key != NULL);
	g_return_if_fail (locale != NULL);
	g_return_if_fail (value != NULL);
	gnome_desktop_item_set_localestring_lang (self->priv->item, key, locale, value);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static char** desktop_agnostic_fdo_desktop_entry_gnome_real_get_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	char** result = NULL;
	char** _tmp0_;
	char** _tmp1_;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_val_if_fail (key != NULL, NULL);
	result = (_tmp1_ = (char**) (_tmp0_ = gnome_desktop_item_get_strings (self->priv->item, key)), (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)));
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_string_list (DesktopAgnosticFDODesktopEntry* base, const char* key, char** value) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	g_return_if_fail (key != NULL);
	gnome_desktop_item_set_strings (self->priv->item, key, value);
}


static gboolean desktop_agnostic_fdo_desktop_entry_gnome_real_exists (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	result = gnome_desktop_item_exists (self->priv->item);
	return result;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static GPid desktop_agnostic_fdo_desktop_entry_gnome_real_launch (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryLaunchFlags flags, GSList* documents, GError** error) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	GPid result = 0;
	GList* file_list;
	GnomeDesktopItemLaunchFlags lflags;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	file_list = NULL;
	lflags = 0;
	{
		GSList* document_collection;
		GSList* document_it;
		document_collection = documents;
		for (document_it = document_collection; document_it != NULL; document_it = document_it->next) {
			const char* document;
			document = (const char*) document_it->data;
			{
				file_list = g_list_append (file_list, g_strdup (document));
			}
		}
	}
	if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_ONLY_ONE) != 0) {
		lflags = lflags | GNOME_DESKTOP_ITEM_LAUNCH_ONLY_ONE;
	}
	if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_USE_CWD) != 0) {
		lflags = lflags | GNOME_DESKTOP_ITEM_LAUNCH_USE_CURRENT_DIR;
	}
	if ((flags & DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_LAUNCH_FLAGS_DO_NOT_REAP_CHILD) != 0) {
		lflags = lflags | GNOME_DESKTOP_ITEM_LAUNCH_DO_NOT_REAP_CHILD;
	}
	_tmp0_ = gnome_desktop_item_launch (self->priv->item, file_list, lflags, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_list_free_g_free0 (file_list);
		return 0;
	}
	result = (GPid) _tmp0_;
	__g_list_free_g_free0 (file_list);
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_save (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* new_file, GError** error) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	char* uri;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	uri = NULL;
	if (new_file != NULL) {
		char* _tmp0_;
		uri = (_tmp0_ = desktop_agnostic_vfs_file_get_uri (new_file), _g_free0 (uri), _tmp0_);
	} else {
		if (self->priv->_file != NULL) {
			char* _tmp1_;
			uri = (_tmp1_ = desktop_agnostic_vfs_file_get_uri (self->priv->_file), _g_free0 (uri), _tmp1_);
		} else {
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_ERROR_INVALID_FILE, "No filename specified.");
			{
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				return;
			}
		}
	}
	gnome_desktop_item_save (self->priv->item, uri, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (uri);
		return;
	}
	_g_free0 (uri);
}


DesktopAgnosticFDODesktopEntryGNOME* desktop_agnostic_fdo_desktop_entry_gnome_construct (GType object_type) {
	DesktopAgnosticFDODesktopEntryGNOME * self = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticFDODesktopEntryGNOME* desktop_agnostic_fdo_desktop_entry_gnome_new (void) {
	return desktop_agnostic_fdo_desktop_entry_gnome_construct (DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME);
}


static DesktopAgnosticVFSFile* desktop_agnostic_fdo_desktop_entry_gnome_real_get_file (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	result = self->priv->_file;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_file (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	if (value != NULL) {
		if (self->priv->item == NULL) {
			char* path;
			DesktopAgnosticVFSFile* _tmp0_;
			char* _tmp1_;
			path = NULL;
			self->priv->_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file), _tmp0_);
			path = (_tmp1_ = desktop_agnostic_vfs_file_get_path (value), _g_free0 (path), _tmp1_);
			if (path == NULL) {
				char* _tmp2_;
				GnomeDesktopItem* _tmp3_;
				GnomeDesktopItem* _tmp4_;
				GnomeDesktopItem* _tmp5_;
				_tmp4_ = (_tmp3_ = gnome_desktop_item_new_from_uri (_tmp2_ = desktop_agnostic_vfs_file_get_uri (value), 0, &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
				if (_inner_error_ != NULL) {
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->item = (_tmp5_ = _tmp4_, _gnome_desktop_item_unref0 (self->priv->item), _tmp5_);
			} else {
				GnomeDesktopItem* _tmp6_;
				GnomeDesktopItem* _tmp7_;
				_tmp6_ = gnome_desktop_item_new_from_file (path, 0, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->item = (_tmp7_ = _tmp6_, _gnome_desktop_item_unref0 (self->priv->item), _tmp7_);
			}
			_g_free0 (path);
		} else {
			g_warning ("desktop-entry-impl-gnome.vala:60: The desktop entry has already been i" \
"nitialized.");
		}
	}
	g_object_notify ((GObject *) self, "file");
}


static GKeyFile* desktop_agnostic_fdo_desktop_entry_gnome_real_get_keyfile (DesktopAgnosticFDODesktopEntry* base) {
	GKeyFile* result;
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	result = self->priv->_keyfile;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_keyfile (DesktopAgnosticFDODesktopEntry* base, GKeyFile* value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	if (value != NULL) {
		if (self->priv->item == NULL) {
			char* data;
			gsize length = 0UL;
			char* _tmp0_;
			GnomeDesktopItem* _tmp1_;
			GnomeDesktopItem* _tmp2_;
			data = NULL;
			self->priv->_keyfile = value;
			data = (_tmp0_ = g_key_file_to_data (value, &length, NULL), _g_free0 (data), _tmp0_);
			_tmp1_ = gnome_desktop_item_new_from_string ("", data, (gssize) length, 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->item = (_tmp2_ = _tmp1_, _gnome_desktop_item_unref0 (self->priv->item), _tmp2_);
			_g_free0 (data);
		} else {
			g_warning ("desktop-entry-impl-gnome.vala:89: The desktop entry has already been i" \
"nitialized.");
		}
	}
	g_object_notify ((GObject *) self, "keyfile");
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_data (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	if (value != NULL) {
		_tmp0_ = _vala_strcmp0 (value, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->item == NULL) {
			GnomeDesktopItem* _tmp1_;
			GnomeDesktopItem* _tmp2_;
			_tmp1_ = gnome_desktop_item_new_from_string ("", value, (gssize) (-1), 0, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			self->priv->item = (_tmp2_ = _tmp1_, _gnome_desktop_item_unref0 (self->priv->item), _tmp2_);
		} else {
			g_warning ("desktop-entry-impl-gnome.vala:108: The desktop entry has already been " \
"initialized.");
		}
	}
	g_object_notify ((GObject *) self, "data");
}


static DesktopAgnosticFDODesktopEntryType desktop_agnostic_fdo_desktop_entry_gnome_real_get_entry_type (DesktopAgnosticFDODesktopEntry* base) {
	DesktopAgnosticFDODesktopEntryType result;
	DesktopAgnosticFDODesktopEntryGNOME* self;
	DesktopAgnosticFDODesktopEntryType _result_ = 0;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	switch (gnome_desktop_item_get_entry_type (self->priv->item)) {
		case GNOME_DESKTOP_ITEM_TYPE_APPLICATION:
		{
			_result_ = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION;
			break;
		}
		case GNOME_DESKTOP_ITEM_TYPE_LINK:
		{
			_result_ = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK;
			break;
		}
		case GNOME_DESKTOP_ITEM_TYPE_DIRECTORY:
		{
			_result_ = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_DIRECTORY;
			break;
		}
		default:
		{
			_result_ = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN;
			break;
		}
	}
	result = _result_;
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_entry_type (DesktopAgnosticFDODesktopEntry* base, DesktopAgnosticFDODesktopEntryType value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	switch (value) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN:
		{
			gnome_desktop_item_set_entry_type (self->priv->item, GNOME_DESKTOP_ITEM_TYPE_OTHER);
			break;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			gnome_desktop_item_set_entry_type (self->priv->item, GNOME_DESKTOP_ITEM_TYPE_APPLICATION);
			break;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			gnome_desktop_item_set_entry_type (self->priv->item, GNOME_DESKTOP_ITEM_TYPE_LINK);
			break;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_DIRECTORY:
		{
			gnome_desktop_item_set_entry_type (self->priv->item, GNOME_DESKTOP_ITEM_TYPE_DIRECTORY);
			break;
		}
	}
	g_object_notify ((GObject *) self, "entry-type");
}


static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_name (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	result = g_strdup (gnome_desktop_item_get_string (self->priv->item, GNOME_DESKTOP_ITEM_NAME));
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_name (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	gnome_desktop_item_set_string (self->priv->item, GNOME_DESKTOP_ITEM_NAME, value);
	g_object_notify ((GObject *) self, "name");
}


static char* desktop_agnostic_fdo_desktop_entry_gnome_real_get_icon (DesktopAgnosticFDODesktopEntry* base) {
	char* result;
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	result = g_strdup (gnome_desktop_item_get_icon (self->priv->item, gtk_icon_theme_get_default ()));
	return result;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_real_set_icon (DesktopAgnosticFDODesktopEntry* base, const char* value) {
	DesktopAgnosticFDODesktopEntryGNOME* self;
	self = (DesktopAgnosticFDODesktopEntryGNOME*) base;
	if (value == NULL) {
		g_warning ("desktop-entry-impl-gnome.vala:179: Cannot set a NULL value for 'Icon'.");
	} else {
		gnome_desktop_item_set_string (self->priv->item, GNOME_DESKTOP_ITEM_ICON, value);
	}
	g_object_notify ((GObject *) self, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_gnome_class_init (DesktopAgnosticFDODesktopEntryGNOMEClass * klass) {
	desktop_agnostic_fdo_desktop_entry_gnome_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticFDODesktopEntryGNOMEPrivate));
	G_OBJECT_CLASS (klass)->constructed = desktop_agnostic_fdo_desktop_entry_gnome_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_fdo_desktop_entry_gnome_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_fdo_desktop_entry_gnome_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_fdo_desktop_entry_gnome_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_FILE, "file");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_KEYFILE, "keyfile");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_DATA, "data");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ENTRY_TYPE, "entry-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ICON, "icon");
}


static void desktop_agnostic_fdo_desktop_entry_gnome_desktop_agnostic_fdo_desktop_entry_interface_init (DesktopAgnosticFDODesktopEntryIface * iface) {
	desktop_agnostic_fdo_desktop_entry_gnome_desktop_agnostic_fdo_desktop_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->key_exists = desktop_agnostic_fdo_desktop_entry_gnome_real_key_exists;
	iface->get_boolean = desktop_agnostic_fdo_desktop_entry_gnome_real_get_boolean;
	iface->set_boolean = desktop_agnostic_fdo_desktop_entry_gnome_real_set_boolean;
	iface->get_string = desktop_agnostic_fdo_desktop_entry_gnome_real_get_string;
	iface->set_string = desktop_agnostic_fdo_desktop_entry_gnome_real_set_string;
	iface->get_localestring = desktop_agnostic_fdo_desktop_entry_gnome_real_get_localestring;
	iface->set_localestring = desktop_agnostic_fdo_desktop_entry_gnome_real_set_localestring;
	iface->get_string_list = desktop_agnostic_fdo_desktop_entry_gnome_real_get_string_list;
	iface->set_string_list = desktop_agnostic_fdo_desktop_entry_gnome_real_set_string_list;
	iface->exists = desktop_agnostic_fdo_desktop_entry_gnome_real_exists;
	iface->launch = desktop_agnostic_fdo_desktop_entry_gnome_real_launch;
	iface->save = desktop_agnostic_fdo_desktop_entry_gnome_real_save;
	iface->get_file = desktop_agnostic_fdo_desktop_entry_gnome_real_get_file;
	iface->set_file = desktop_agnostic_fdo_desktop_entry_gnome_real_set_file;
	iface->get_keyfile = desktop_agnostic_fdo_desktop_entry_gnome_real_get_keyfile;
	iface->set_keyfile = desktop_agnostic_fdo_desktop_entry_gnome_real_set_keyfile;
	iface->set_data = desktop_agnostic_fdo_desktop_entry_gnome_real_set_data;
	iface->get_entry_type = desktop_agnostic_fdo_desktop_entry_gnome_real_get_entry_type;
	iface->set_entry_type = desktop_agnostic_fdo_desktop_entry_gnome_real_set_entry_type;
	iface->get_name = desktop_agnostic_fdo_desktop_entry_gnome_real_get_name;
	iface->set_name = desktop_agnostic_fdo_desktop_entry_gnome_real_set_name;
	iface->get_icon = desktop_agnostic_fdo_desktop_entry_gnome_real_get_icon;
	iface->set_icon = desktop_agnostic_fdo_desktop_entry_gnome_real_set_icon;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_instance_init (DesktopAgnosticFDODesktopEntryGNOME * self) {
	self->priv = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_GET_PRIVATE (self);
	self->priv->item = NULL;
	self->priv->_file = NULL;
	self->priv->_keyfile = NULL;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_finalize (GObject* obj) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME (obj);
	_gnome_desktop_item_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (desktop_agnostic_fdo_desktop_entry_gnome_parent_class)->finalize (obj);
}


GType desktop_agnostic_fdo_desktop_entry_gnome_get_type (void) {
	static volatile gsize desktop_agnostic_fdo_desktop_entry_gnome_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_fdo_desktop_entry_gnome_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticFDODesktopEntryGNOMEClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_fdo_desktop_entry_gnome_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticFDODesktopEntryGNOME), 0, (GInstanceInitFunc) desktop_agnostic_fdo_desktop_entry_gnome_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_fdo_desktop_entry_info = { (GInterfaceInitFunc) desktop_agnostic_fdo_desktop_entry_gnome_desktop_agnostic_fdo_desktop_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_fdo_desktop_entry_gnome_type_id;
		desktop_agnostic_fdo_desktop_entry_gnome_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticFDODesktopEntryGNOME", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_fdo_desktop_entry_gnome_type_id, DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY, &desktop_agnostic_fdo_desktop_entry_info);
		g_once_init_leave (&desktop_agnostic_fdo_desktop_entry_gnome_type_id__volatile, desktop_agnostic_fdo_desktop_entry_gnome_type_id);
	}
	return desktop_agnostic_fdo_desktop_entry_gnome_type_id__volatile;
}


static void desktop_agnostic_fdo_desktop_entry_gnome_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_FILE:
		g_value_set_object (value, desktop_agnostic_fdo_desktop_entry_get_file ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_KEYFILE:
		g_value_set_pointer (value, desktop_agnostic_fdo_desktop_entry_get_keyfile ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ENTRY_TYPE:
		g_value_set_enum (value, desktop_agnostic_fdo_desktop_entry_get_entry_type ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_NAME:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_name ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ICON:
		g_value_take_string (value, desktop_agnostic_fdo_desktop_entry_get_icon ((DesktopAgnosticFDODesktopEntry*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_fdo_desktop_entry_gnome_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticFDODesktopEntryGNOME * self;
	self = DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_FILE:
		desktop_agnostic_fdo_desktop_entry_set_file ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_KEYFILE:
		desktop_agnostic_fdo_desktop_entry_set_keyfile ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_pointer (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_DATA:
		desktop_agnostic_fdo_desktop_entry_set_data ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ENTRY_TYPE:
		desktop_agnostic_fdo_desktop_entry_set_entry_type ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_enum (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_NAME:
		desktop_agnostic_fdo_desktop_entry_set_name ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_GNOME_ICON:
		desktop_agnostic_fdo_desktop_entry_set_icon ((DesktopAgnosticFDODesktopEntry*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result = 0UL;
	result = DESKTOP_AGNOSTIC_FDO_TYPE_DESKTOP_ENTRY_GNOME;
	return result;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




