/*--------------------------------------------------------------------------*/
/* ALBERTA_UTIL:  tools for messages, memory allocation, parameters, etc.   */
/*                                                                          */
/* file:     divers.c                                                       */
/*                                                                          */
/* description:  generating filenames and handling of general lists         */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  authors:   Alfred Schmidt                                               */
/*             Zentrum fuer Technomathematik                                */
/*             Fachbereich 3 Mathematik/Informatik                          */
/*             Universitaet Bremen                                          */
/*             Bibliothekstr. 2                                             */
/*             D-28359 Bremen, Germany                                      */
/*                                                                          */
/*             Kunibert G. Siebert                                          */
/*             Institut fuer Mathematik                                     */
/*             Universitaet Augsburg                                        */
/*             Universitaetsstr. 14                                         */
/*             D-86159 Augsburg, Germany                                    */
/*                                                                          */
/*  http://www.mathematik.uni-freiburg.de/IAM/ALBERTA                       */
/*                                                                          */
/*  (c) by A. Schmidt and K.G. Siebert (1996-2003)                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#include "alberta_util.h"

const char *generate_filename(const char *path, const char *fn, int ntime)
{
  static char  name[1024];
  char         *cp = name;

  *cp = 0;
/*---  adjust path   -------------------------------------------------------*/
  if (path == nil || *path == '\0')
    strcpy(name, "./");
  else if (*path == '~')
  {
    strcpy(name, getenv("HOME"));
    strcat(name, path+1);
  }
  else
    strcpy(name, path);

  while (*cp)
    cp++;
  cp--;
  if (*cp != '/')
    strcat(cp, "/");

/*---  append  filename  ---------------------------------------------------*/
  strcat(cp, fn);

/*---  finally append normalized iteration counter  ------------------------*/
  while (*cp) cp++;
  sprintf(cp, "%06d", ntime);

  return((const char *) name);
}

/*--------------------------------------------------------------------------*/
/*  handling of general lists                                               */
/*--------------------------------------------------------------------------*/

static VOID_LIST_ELEMENT *first_element = nil;

VOID_LIST_ELEMENT *get_void_list_element(void)
{
  VOID_LIST_ELEMENT  *list;
  const int          n_elements = 20;
  int                i;
  
  if (!first_element)
  {
    first_element = MEM_ALLOC(n_elements, VOID_LIST_ELEMENT);
    for (i = 0; i < n_elements-1; i++)
    {
      first_element[i].data = nil;
      first_element[i].next = first_element+(i+1);
    }
    first_element[n_elements-1].data = nil;
    first_element[n_elements-1].next = nil;
  }
  list = first_element;
  first_element = list->next;

  list->next = nil;
  return(list);
}

void free_void_list_element(VOID_LIST_ELEMENT *list)
{
  list->data = nil;
  list->next = first_element;
  first_element = list;
  return;
}
