/*--------------------------------------------------------------------------*/
/* ALBERTA:  an Adaptive multi Level finite element toolbox using           */
/*           Bisectioning refinement and Error control by Residual          */
/*           Techniques for scientific Applications                         */
/*                                                                          */
/* file:     element_0d.c                                                   */
/*                                                                          */
/*                                                                          */
/* description:  routines on elements that depend on the dimension in 1d    */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  authors:   Alfred Schmidt                                               */
/*             Zentrum fuer Technomathematik                                */
/*             Fachbereich 3 Mathematik/Informatik                          */
/*             Universitaet Bremen                                          */
/*             Bibliothekstr. 2                                             */
/*             D-28359 Bremen, Germany                                      */
/*                                                                          */
/*             Kunibert G. Siebert                                          */
/*             Institut fuer Mathematik                                     */
/*             Universitaet Augsburg                                        */
/*             Universitaetsstr. 14                                         */
/*             D-86159 Augsburg, Germany                                    */
/*                                                                          */
/*  http://www.mathematik.uni-freiburg.de/IAM/ALBERTA                       */
/*                                                                          */
/*  (c) by A. Schmidt and K.G. Siebert (1996-2003)                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#include "alberta.h"


/****************************************************************************/
/* Some trivial 0d stuff.                                                   */
/****************************************************************************/

int world_to_coord_0d(const EL_INFO *el_info,
		      const REAL *x, REAL lambda[N_LAMBDA])
{
  FUNCNAME("world_to_coord_0d");

  ERROR_EXIT("... does not make sense for dim == 0\n");

  return -1;
}

const REAL *coord_to_world_0d(const EL_INFO *el_info, const REAL *l, REAL_D w)
{
  FUNCNAME("coord_to_world_0d");
  static REAL world[DIM_OF_WORLD];
  REAL        *ret;
  int         i;

  DEBUG_TEST_FLAG(FILL_COORDS, el_info);
  DEBUG_TEST_EXIT(!el_info->mesh->parametric || el_info->mesh->parametric->use_reference_mesh, "You must enable the use_reference_mesh entry in the PARAMETRIC structure to use this function on the reference mesh. Use parametric->coord_to_world() to access the parametric mesh\n");

  ret = w ? w : world;

  for(i = 0; i < DIM_OF_WORLD; i++)
    ret[i] = el_info->coord[0][i];

  return((const REAL *) ret);
}

REAL el_grd_lambda_0d(const EL_INFO *el_info,
		      REAL grd_lam[N_LAMBDA][DIM_OF_WORLD])
{
  int i;

  for(i = 0; i < DIM_OF_WORLD; i++)
    grd_lam[0][i] = 0.0;

  return(1.0);
}

REAL el_det_0d(const EL_INFO *el_info)
{
    return 1.0;
}

REAL el_volume_0d(const EL_INFO *el_info)
{
    return 1.0;
}

REAL get_wall_normal_0d(const EL_INFO *el_info, int i0, REAL *normal)
{
  FUNCNAME("get_face_normal_0d");

  WARNING("Does not makes sense for dim == 0!\n");

  return HUGE_VAL;
}

int *sorted_wall_indices_0d(int face, int permno)
{
  FUNCNAME("sorted_face_indices_0d");

  WARNING("Does not makes sense for dim == 0!\n");

  return NULL;
}

int wall_orientation_0d(const EL *el, int face, int **vecp)
{
  FUNCNAME("wall_orientation");

  WARNING("Does not makes sense for dim == 0!\n");

  return -1;
}

int *sort_wall_indices_0d(const EL *el, int wall, int *vec)
{
  FUNCNAME("sort_wall_indices");

  WARNING("Does not makes sense for dim == 0!\n");

  return NULL;
}


