<?php
/*
# Copyright 2004, Revolution Linux Inc., Alban Crequy
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Printer.php';
	require_once 'Node.php';

	/**
	*
	* This class read browser data and generate navigation path.
	* 
	* @package MILLE-CONFIGURATOR
	* @author Alban Crequy
	*/
	class PrintingBrowser{
		/**
		* Debug Level: set to 1 in order to view debug messages, 0 otherwise
		* @access private
		* @var int
		*/
		var $debugLevel;
		/**
		* Currently selected printer object
		* @access private
		* @var object
		*/
		var $prt;
		/**
		* True if a printer is currently selected
		* @access private
		* @var boolean
		*/
		var $isSelected;
		/**
		* Currently selected node object
		* @access private
		* @var object
		*/
		var $node;
		/**
		* True if a node is currently selected
		* @access private
		* @var boolean
		*/
		var $nodeIsSelected;
		/**
		* List of errors
		* @access private
		* @var array of string
		*/
		var $errors;
		/**
		* List of User's informations
		* @access private
		* @var array of string
		*/
		var $infos;
		/**
		* List of debugging messages
		* @access private
		* @var array of string
		*/
		var $debug;
		/**
		* The regexp chosen to filter the printer list
		* @access private
		* @var regexp string
		*/
		var $prt_filter;
		/**
		* The list of printers after the regexp filter
		* @access private
		* @var array of hash
		*/
		var $prt_filter_result;
		/**
		* The page the user want to view
		* @access private
		* @var int
		*/
		var $numpage;

		/**
		* The constructor of the PrintingBrowser class
		*
		* The initialisation is done by printing.php
		*
		* @access public
		*/
		function PrintingBrowser() {
			$this->debugLevel = 1;
			/* Request: Delete a printer */
			if (isset($_POST['do_delete']) && (1==$_POST['do_delete'])) {
				if($this->delete_a_printer($_POST['delete_printerid'])) {
					unset($_GET['printer_id']);
					unset($_POST['printer_id']);
				}
			}

			/* Request: Add a printer */
			if (isset($_POST['do_add']) && (1==$_POST['do_add'])) {
				if ($this->add_a_printer($_POST['add_printername'],
					$_POST['add_description'],
					$_POST['add_priceperpage'],
					$_POST['add_priceperjob'])) {
	
					$_GET['printer_id'] = $_POST['add_printername'];
					unset($_POST['printer_id']);
				}
			}
			
			/* Request: Update the dictionary */
			/* Automatically called when adding/removing a printer. */
			if (isset($_POST['do_sync_dict']) && (1==$_POST['do_sync_dict'])) {
				$this->updateDict();
			}

			/* Request: Update users */
			if (isset($_POST['do_sync_users']) && (1==$_POST['do_sync_users'])) {
				$this->updateUsers();
			}

			/* Request: Update quota */
			if (isset($_POST['do_sync_quota']) && (1==$_POST['do_sync_quota'])) {
				/* WARNING!!! This function is under developpement
				 * and its spec is not defined!! */
				$this->updateQuota();
			}

			/* Build the printer object */
			$this->PrintingBrowser_buildprinterobject();

			/* Build the node object */
			$this->PrintingBrowser_buildnodeobject();

			/* Search the SQL regexp */
			$this->getPrinterListFromDB();
		
		}
		
		/**
		* Build the Printer Object
		*
		* Called by the constructor
		*
		* @access private
		* @return none
		*/
		function PrintingBrowser_buildprinterobject() {
			$prtOK = false;
			unset($this->prt_filter);
			
			/* By default, the regexp is all (%) */
			if (!isset($_GET['printer_filter'])) {
				$_GET['printer_filter'] = '%';
			}

			if (isset($_POST['printer_id'])) {
				/* The user select a printer */
				$prtOK = $this->buildPrinter($_POST['printer_id']);
				if ($prtOK) {
					/* the user manage to find his printer */
					$_GET['printer_id'] = $_POST['printer_id'];
				} else {
					/* the user fail to find his printer: help him */
					$_GET['printer_filter'] = $_POST['printer_id'];
					$this->prt_filter = $_POST['printer_id'];
				}
			}

			/* the user fail to find a new printer; select the
			 * previously selected one */
			if (isset($_GET['printer_id']) && !$prtOK) {
				$prtOK = $this->buildPrinter($_GET['printer_id']);
			}
			if ($prtOK) {
				$this->isSelected = true;
			} else {
				$this->isSelected = false;
				unset($_GET['printer_id']);
			}
			if (!isset($this->prt_filter)) {
				$this->prt_filter = $_GET['printer_filter'];
			}
		}

		/**
		* Build the Node Object
		*
		* Called by the constructor
		*
		* @access private
		* @return none
		*/
		function PrintingBrowser_buildnodeobject() {
			$this->node = new Node(trim($_GET['node_id']));
			if ($this->node->isError()) {
				$this->nodeIsSelected = false;
				unset($_GET['node_id']);
			} else {
				$this->nodeIsSelected = true;
			}
		}
	

		/**
		* Delete a printer
		*
		* @access public
		* @return boolean
		*/
		function delete_a_printer($printerid) {
			/* First, delete printergroups that reference this printer */
			$sql_query = "DELETE FROM printergroupsmembers where printerid=".$printerid;
			if ($error = delete($sql_query)) {
				$this->errors[] = getMessage('db_write_error').$error." : ".$sql_query;
				return false;
			}

			/* then delete the printer */
			$sql_query = "DELETE FROM printers where id=".$printerid;
			if ($error = delete($sql_query)) {
				$this->errors[] = getMessage('db_write_error').$error." : ".$sql_query;
				return false;
			} else {
				$this->updateDict();
				$this->infos[] = getMessage('delete_printer_ok');
				return true;
			}
		}

		/**
		* Add a printer
		*
		* @access public
		* @return boolean
		*/
		function add_a_printer($printername, $description, $priceperpage, $priceperjob) {
			if (!is_string($description)) {$description="";}
			if (!is_numeric($priceperpage)) {$priceperpage=0;}
			if (!is_numeric($priceperjob)) {$priceperjob=0;}
			$sql_query = "INSERT INTO printers (printername, description, priceperpage, priceperjob)"
				." VALUES ('".$printername."','".$description."',".$priceperpage.",".$priceperjob.")";
			if ($error = write($sql_query)) {
				$this->errors[] = getMessage('db_write_error').$error." : ".$sql_query;
				return false;
			} else {
				$this->updateDict();
				$this->infos[] = getMessage('add_printer_ok');
				return true;
			}

		}

		/**
		* Put all printers in the group allprinters
		*
		* @access private
		* @return boolean
		*/
		function updateQuota() {
			/* Ajoute toutes les imprimantes dans le groupe allprinters */

			$this->debug[] = "enter into updateQuota";
			$sql_query_allprinters = "SELECT id FROM printers WHERE printername='allprinters'";
			$r = singleResultSelect($sql_query_allprinters);
			if (NULL==$r) {
				/* allprinters doesn't exist... add it. */
				$sql_query = "INSERT INTO printers"
					." (printername, description, priceperpage, priceperjob)"
					." VALUES ('allprinters', 'group for all printers', 0, 0";
				if ($error = write($sql_query)) {
					$this->errors[] = getMessage('db_write_error').$error." : ".$sql_query;
					return false;
				}

			} else {
				$this->debug[] = "allprinters already exist :)";
			}

			$sql_query = "SELECT * from printers WHERE printername!='allprinters'";
			$printersList = select($sql_query);
			if (!is_array($printersList) && !is_null($printersList)) {
				$this->errors[] = getMessage('db_write_error') . $printersList;
			} else if (!is_null($printersList)) {
				foreach ($printersList as $a_printer) {
					$this->debug[] = "adding the printer ".$a_printer['printername'];
					$sql_query = "INSERT INTO printergroupsmembers"
						." (groupid, printerid)"
						." VALUES ((".$sql_query_allprinters."), "
						.$a_printer['id'].")";
					write($sql_query);
					/* this produce errors if already exists... don't care */
				}
			}
		}

		/**
		* Update the users
		*
		* @access public
		* @return none
		*/
		function updateUsers() {
			/* We can't remove all users in the PyKota database and then put
			 * them again because they are reference on them. Instead we
			 * have to check one by one the list...
			 */
			$getent_users = split("\n", rtrim(shell_exec("getent passwd|cut -d: -f1")));
			foreach($getent_users as $u) {
				$sql_query = "SELECT * FROM users"
					." WHERE username='".$u."'";
				if (NULL==singleResultSelect($sql_query)) {
					/* Add the user */
					$sql_query = "INSERT INTO users"
						." (username)"
						." VALUES ('".$u."')";
					write($sql_query);
					$this->debug[] = "User ".$u." : ADDED in PyKota database";
				} else {
					$this->debug[] = "User ".$u." : OK";
				}
			}

		}
		
		/**
		* Update the dictionary
		*
		* Automatically called when adding/deleting a printer
		*
		* @access public
		* @return none
		*/
		function updateDict() {
			/* We can't remove all words in the dictionnaire and then put them again because
			 * they are reference on them. Instead we have to check one by one the list...
			*/

			$this->debug[] = "enter into updateDict";
			
			/* Check if the attribute LDM_PRINTER_LIST exists */
			$sql_query = "SELECT name FROM attributesdef WHERE name='LDM_PRINTER_LIST'";
			$r = singleResultSelect($sql_query);
			if (NULL==$r) {
				$this->debug[] = "LDM_PRINTER_LIST undefined";
				$this->errors[] = getMessage('cannot_update_dico');
			}

			/* select all printers from the dict... */
			$sql_query = "SELECT def.id AS id, dict.value AS printername"
				." FROM attributesdefdict AS dict, attributesdef AS def"
				." WHERE dict.attributesdef_id = def.id"
				." AND def.name = 'LDM_PRINTER_LIST'";
			$wordsList = select($sql_query);
			/* ... and delete these that are still not relevant */
			if (!is_array($wordsList) && !is_null($wordsList)) {
				$this->errors[] = getMessage('cannot_update_dico') . $wordsList;
			} else if (!is_null($wordsList)) {
				foreach ($wordsList as $a_printer) {
					/* if $a_printer['printername'] still not exist, delete it. */
					$sql_query = "SELECT * FROM printers WHERE printername='".$a_printer['printername']."'";
					if (NULL==singleResultSelect($sql_query)) {
						$sql_query = "DELETE FROM attributesselect"
							." WHERE value='".$a_printer['printername']."'"
							." AND attributesdef_id="
							."(SELECT id FROM attributesdef".
								" WHERE name='LDM_PRINTER_LIST')";
						$error = delete($sql_query);
						if ($error) {
							$this->errors[] = getMessage('cannot_update_dico') . $error." - ".$sql_query;
						}
						$sql_query = "DELETE FROM attributesdefdict"
							." WHERE value='".$a_printer['printername']."'"
							." AND attributesdef_id="
							."(SELECT id FROM attributesdef".
								" WHERE name='LDM_PRINTER_LIST')";
						$error = delete($sql_query);
						if ($error) {
							$this->errors[] = getMessage('cannot_update_dico') . $error." - ".$sql_query;
						}
						$this->debug[] = "Dictionary printer ".$a_printer['printername']." : DELETED";
					} else {
						$this->debug[] = "Dictionary printer ".$a_printer['printername']." : OK";
					}
				}
			}

			/* select all printers form Pykota... */
			$sql_query = "SELECT * FROM printers";
			$wordsList = select($sql_query);
			/* ... and add these that misses */
			if (!is_array($wordsList) && !is_null($wordsList)) {
				$this->errors[] = getMessage('cannot_update_dico').$wordsList;
			} else if (!is_null($wordsList)) {
				foreach ($wordsList as $a_printer) {
					/* if $a_printer['printername'] didn't exist, create it. */
					$sql_query = "SELECT dict.value"
						." FROM attributesdefdict as dict, attributesdef AS def"
						." WHERE dict.attributesdef_id = def.id"
						." AND def.name = 'LDM_PRINTER_LIST'"
						." AND dict.value = '".$a_printer['printername']."'";
					if (NULL==singleResultSelect($sql_query)) {
						$sql_query = "INSERT INTO attributesdefdict"
							." (attributesdef_id, value, sortval)"
							." VALUES ((SELECT id from attributesdef where name='LDM_PRINTER_LIST'), '"
							.$a_printer['printername']."', 0)";
						write($sql_query);
						$this->debug[] = "Pykota printer ".$a_printer['printername']." : ADDED";
					} else {
						$this->debug[] = "Pykota printer ".$a_printer['printername']." : OK";
					}
				}
			}
			
		}

		/**
		* Get the the current page printer list with the regexp
		*
		* @access private
		* @return boolean
		*/
		function getPrinterListFromDB() {
			$itemPerPage=5;
			
			/* Get the page number requested */
			if (isset($_GET['numpage']) && (is_numeric($_GET['numpage']))) {
				$this->numpage = $_GET['numpage'];
			} else {
				$this->numpage = 0;
			}

			/* Get the total number of pages */
			$sql_query = "SELECT count(*) as c FROM printers"
				." WHERE printername"
				." LIKE '".$this->prt_filter."'";
			$r = singleResultSelect($sql_query);
			$this->nbpage = ceil($r['c'] / $itemPerPage);

			/* Check if we are under the limit */
			if ($this->numpage > $this->nbpage) {
				$this->numpage = 0;
			}
			if ($this->numpage < 0) {
				$this->numpage = 0;
			}

			/* Get the page requested */
			$sql_query = "SELECT *"
		       		." FROM printers"
				." WHERE (printername LIKE '".$this->prt_filter."')"
				." ORDER BY printers.printername"
				." LIMIT ".$itemPerPage." OFFSET ".$this->numpage*$itemPerPage
				;
			$this->prt_filter_result = select($sql_query);
		}

		/**
		* Assign a node to a printer. This function is obselete.
		*
		* @access private
		* @return none
		*/
		function assign_prt_node($n, $p) {
			/* The user want to assign a printer to a local */
			//print "*".$_POST['assign_node'] . "*<br>\n";
			//print "*".$_POST['assign_printer'] . "*<br>\n";
			$assigned_node = new Node($n);
			$assigned_printer = new Printer($p);

			/* Check if Node is correctly created */
			if ($assigned_node->isError()) {
				$this->errors[] = $assigned_node->lastError();
				return;
			}
			
			/* Check if Printer is correctly created */
			if ($assigned_printer->isError()) {
				$this->errors[] = $assigned_printer->lastError();
				return;
			}
			
			/* Check if the record already exists */
			if (NULL==$assigned_printer->getFromDB("*","printerid=".$assigned_printer->getID()." AND nodeid=".$assigned_node->getID(),"printernode")) {
				/* The record doesn't exist yet... INSERT INTO */
				$sql_query = "INSERT INTO printernode (printerid, nodeid) VALUES ("
					.$assigned_printer->getID().", "
					.$assigned_node->getID().")";
			}
			//print "<pre>".$sql_query."</pre>";
			write($sql_query);
		}

		/**
		* Print the list of errors
		*
		* @access public
		* @return none
		*/
		function printErrors() {
			if (isset($this->errors[0])) print "<p>\n";
			else return;
			foreach ($this->errors as $error) {
				print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
		}

		/**
		* Print the list of user's informations
		*
		* @access public
		* @return none
		*/
		function printInfos() {
			if (isset($this->infos[0])) print "<p>\n";
			else return;
			foreach ($this->infos as $error) {
				print "<font color=\"green\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
		}
		
		/**
		* Print the list of debugging message
		*
		* No effect if debugLevel is set to 0
		*
		* @access public
		* @return none
		*/
		function printDebug() {
			if ($this->debugLevel > 0) {
				if (isset($this->debug[0])) print "<p>\n";
				else return;
				foreach ($this->debug as $error) {
					print "<font color=\"blue\" size=\"-1\">Debug: ".$error."</font><br>\n";
				}
				print "</p>\n";
			}
		}
		
		/**
		* Print the module, with printingView.php
		*
		* @access public
		* @return none
		*/
		function print_printing() {
			include 'printingView.php';
		}

		/**
		* Create the printer object
		*
		* @access private
		* @return boolean
		*/
		function buildPrinter($id){
			$this->prt = new Printer($id);
			if ($this->prt->isError()) {
				$this->errors[] = $this->prt->lastError();
			}
			return !$this->prt->isError();
		}
	}
?>
