; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=CHECK,X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/avx512f-builtins.c


define zeroext i16 @test_mm512_kunpackb(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, <8 x i64> %__D, <8 x i64> %__E, <8 x i64> %__F) local_unnamed_addr #0 {
; X86-LABEL: test_mm512_kunpackb:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-64, %esp
; X86-NEXT:    subl $64, %esp
; X86-NEXT:    vmovdqa64 136(%ebp), %zmm3
; X86-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X86-NEXT:    vpcmpneqd 8(%ebp), %zmm2, %k1
; X86-NEXT:    kunpckbw %k0, %k1, %k1
; X86-NEXT:    vpcmpneqd 72(%ebp), %zmm3, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_kunpackb:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X64-NEXT:    vpcmpneqd %zmm3, %zmm2, %k1
; X64-NEXT:    kunpckbw %k0, %k1, %k1
; X64-NEXT:    vpcmpneqd %zmm5, %zmm4, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__E to <16 x i32>
  %1 = bitcast <8 x i64> %__F to <16 x i32>
  %2 = bitcast <8 x i64> %__A to <16 x i32>
  %3 = bitcast <8 x i64> %__B to <16 x i32>
  %4 = icmp ne <16 x i32> %2, %3
  %5 = bitcast <8 x i64> %__C to <16 x i32>
  %6 = bitcast <8 x i64> %__D to <16 x i32>
  %7 = icmp ne <16 x i32> %5, %6
  %8 = shufflevector <16 x i1> %4, <16 x i1> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %9 = shufflevector <16 x i1> %7, <16 x i1> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %10 = shufflevector <8 x i1> %8, <8 x i1> %9, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %11 = icmp ne <16 x i32> %0, %1
  %12 = and <16 x i1> %11, %10
  %13 = bitcast <16 x i1> %12 to i16
  ret i16 %13
}

define i32 @test_mm512_kortestc(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, <8 x i64> %__D) {
; X86-LABEL: test_mm512_kortestc:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-64, %esp
; X86-NEXT:    subl $64, %esp
; X86-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X86-NEXT:    vpcmpneqd 8(%ebp), %zmm2, %k1
; X86-NEXT:    korw %k0, %k1, %k0
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    cmpw $-1, %ax
; X86-NEXT:    sete %al
; X86-NEXT:    andb $1, %al
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_kortestc:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X64-NEXT:    vpcmpneqd %zmm3, %zmm2, %k1
; X64-NEXT:    korw %k0, %k1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    cmpw $-1, %ax
; X64-NEXT:    sete %al
; X64-NEXT:    andb $1, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = icmp ne <16 x i32> %0, %1
  %3 = bitcast <8 x i64> %__C to <16 x i32>
  %4 = bitcast <8 x i64> %__D to <16 x i32>
  %5 = icmp ne <16 x i32> %3, %4
  %6 = or <16 x i1> %5, %2                                                                                                                                                                                                                                 %7 = bitcast <16 x i1> %6 to i16
  %8 = icmp eq i16 %7, -1
  %9 = zext i1 %8 to i32
  ret i32 %9
}

define i32 @test_mm512_kortestz(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, <8 x i64> %__D) {
; X86-LABEL: test_mm512_kortestz:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-64, %esp
; X86-NEXT:    subl $64, %esp
; X86-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X86-NEXT:    vpcmpneqd 8(%ebp), %zmm2, %k1
; X86-NEXT:    korw %k0, %k1, %k0
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    cmpw $0, %ax
; X86-NEXT:    sete %al
; X86-NEXT:    andb $1, %al
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_kortestz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; X64-NEXT:    vpcmpneqd %zmm3, %zmm2, %k1
; X64-NEXT:    korw %k0, %k1, %k0
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    cmpw $0, %ax
; X64-NEXT:    sete %al
; X64-NEXT:    andb $1, %al
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = icmp ne <16 x i32> %0, %1
  %3 = bitcast <8 x i64> %__C to <16 x i32>
  %4 = bitcast <8 x i64> %__D to <16 x i32>
  %5 = icmp ne <16 x i32> %3, %4
  %6 = or <16 x i1> %5, %2
  %7 = bitcast <16 x i1> %6 to i16
  %8 = icmp eq i16 %7, 0
  %9 = zext i1 %8 to i32
  ret i32 %9
}

define <16 x float> @test_mm512_shuffle_f32x4(<16 x float> %__A, <16 x float> %__B) {
; CHECK-LABEL: test_mm512_shuffle_f32x4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vshuff64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[0,1,0,1]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <16 x float> %__A, <16 x float> %__B, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 16, i32 17, i32 18, i32 19>
  ret <16 x float> %shuffle
}


define <16 x float> @test_mm512_mask_shuffle_f32x4(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_shuffle_f32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff32x4 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3,4,5,6,7],zmm2[0,1,2,3,0,1,2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3,4,5,6,7],zmm2[0,1,2,3,0,1,2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <16 x float> %__A, <16 x float> %__B, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 16, i32 17, i32 18, i32 19>
  %0 = bitcast i16 %__U to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %shuffle, <16 x float> %__W
  ret <16 x float> %1
}

define <16 x float> @test_mm512_maskz_shuffle_f32x4(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_shuffle_f32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff32x4 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,4,5,6,7],zmm1[0,1,2,3,0,1,2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_f32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff32x4 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,4,5,6,7],zmm1[0,1,2,3,0,1,2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <16 x float> %__A, <16 x float> %__B, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 16, i32 17, i32 18, i32 19>
  %0 = bitcast i16 %__U to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %shuffle, <16 x float> zeroinitializer
  ret <16 x float> %1
}

define <8 x double> @test_mm512_shuffle_f64x2(<8 x double> %__A, <8 x double> %__B) {
; CHECK-LABEL: test_mm512_shuffle_f64x2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vshuff64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[0,1,0,1]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <8 x double> %__A, <8 x double> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  ret <8 x double> %shuffle
}

define <8 x double> @test_mm512_mask_shuffle_f64x2(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_shuffle_f64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff64x2 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3],zmm2[0,1,0,1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3],zmm2[0,1,0,1]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x double> %__A, <8 x double> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %shuffle, <8 x double> %__W
  ret <8 x double> %1
}

define <8 x double> @test_mm512_maskz_shuffle_f64x2(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_shuffle_f64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshuff64x2 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3],zmm1[0,1,0,1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_f64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshuff64x2 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3],zmm1[0,1,0,1]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x double> %__A, <8 x double> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %shuffle, <8 x double> zeroinitializer
  ret <8 x double> %1
}

define <8 x i64> @test_mm512_shuffle_i32x4(<8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm512_shuffle_i32x4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[0,1,0,1]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  ret <8 x i64> %shuffle
}

define <8 x i64> @test_mm512_mask_shuffle_i32x4(<8 x i64> %__W, i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; X86-LABEL: test_mm512_mask_shuffle_i32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi32x4 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3,4,5,6,7],zmm2[0,1,2,3,0,1,2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3,4,5,6,7],zmm2[0,1,2,3,0,1,2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast <8 x i64> %shuffle to <16 x i32>
  %1 = bitcast <8 x i64> %__W to <16 x i32>
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i32> %0, <16 x i32> %1
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_maskz_shuffle_i32x4(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; X86-LABEL: test_mm512_maskz_shuffle_i32x4:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi32x4 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,4,5,6,7],zmm1[0,1,2,3,0,1,2,3]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_i32x4:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi32x4 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3,4,5,6,7],zmm1[0,1,2,3,0,1,2,3]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast <8 x i64> %shuffle to <16 x i32>
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> zeroinitializer
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_shuffle_i64x2(<8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm512_shuffle_i64x2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm0[0,1,2,3],zmm1[0,1,0,1]
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  ret <8 x i64> %shuffle
}

define <8 x i64> @test_mm512_mask_shuffle_i64x2(<8 x i64> %__W, i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; X86-LABEL: test_mm512_mask_shuffle_i64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3],zmm2[0,1,0,1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,3],zmm2[0,1,0,1]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %shuffle, <8 x i64> %__W
  ret <8 x i64> %1
}

define <8 x i64> @test_mm512_maskz_shuffle_i64x2(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) local_unnamed_addr #0 {
; X86-LABEL: test_mm512_maskz_shuffle_i64x2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3],zmm1[0,1,0,1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_i64x2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,3],zmm1[0,1,0,1]
; X64-NEXT:    retq
entry:
  %shuffle = shufflevector <8 x i64> %__A, <8 x i64> %__B, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 8, i32 9>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %shuffle, <8 x i64> zeroinitializer
  ret <8 x i64> %1
}


define zeroext i16 @test_mm512_testn_epi32_mask(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_testn_epi32_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmd %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    movzwl %ax, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = bitcast <8 x i64> %and1.i.i to <16 x i32>
  %1 = icmp eq <16 x i32> %0, zeroinitializer
  %2 = bitcast <16 x i1> %1 to i16
  ret i16 %2
}

define zeroext i16 @test_mm512_mask_testn_epi32_mask(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_testn_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmd %zmm0, %zmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_testn_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmd %zmm0, %zmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = bitcast <8 x i64> %and1.i.i to <16 x i32>
  %1 = icmp eq <16 x i32> %0, zeroinitializer
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = and <16 x i1> %1, %2
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i8 @test_mm512_testn_epi64_mask(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_testn_epi64_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vptestnmq %zmm0, %zmm1, %k0
; CHECK-NEXT:    kmovw %k0, %eax
; CHECK-NEXT:    movzbl %al, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = icmp eq <8 x i64> %and1.i.i, zeroinitializer
  %1 = bitcast <8 x i1> %0 to i8
  ret i8 %1
}

define zeroext i8 @test_mm512_mask_testn_epi64_mask(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_testn_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestnmq %zmm0, %zmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_testn_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestnmq %zmm0, %zmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = icmp eq <8 x i64> %and1.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = and <8 x i1> %0, %1
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define zeroext i16 @test_mm512_mask_test_epi32_mask(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_test_epi32_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmd %zmm0, %zmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    movzwl %ax, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_test_epi32_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmd %zmm0, %zmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzwl %ax, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = bitcast <8 x i64> %and1.i.i to <16 x i32>
  %1 = icmp ne <16 x i32> %0, zeroinitializer
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = and <16 x i1> %1, %2
  %4 = bitcast <16 x i1> %3 to i16
  ret i16 %4
}

define zeroext i8 @test_mm512_mask_test_epi64_mask(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_test_epi64_mask:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vptestmq %zmm0, %zmm1, %k0 {%k1}
; X86-NEXT:    kmovw %k0, %eax
; X86-NEXT:    movzbl %al, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_test_epi64_mask:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vptestmq %zmm0, %zmm1, %k0 {%k1}
; X64-NEXT:    kmovw %k0, %eax
; X64-NEXT:    movzbl %al, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %and1.i.i = and <8 x i64> %__B, %__A
  %0 = icmp ne <8 x i64> %and1.i.i, zeroinitializer
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = and <8 x i1> %0, %1
  %3 = bitcast <8 x i1> %2 to i8
  ret i8 %3
}

define <8 x i64> @test_mm512_mask_set1_epi32(<8 x i64> %__O, i16 zeroext %__M, i32 %__A) {
; X86-LABEL: test_mm512_mask_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpbroadcastd %eax, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %esi, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <16 x i32> undef, i32 %__A, i32 0
  %vecinit15.i.i = shufflevector <16 x i32> %vecinit.i.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %0 = bitcast <8 x i64> %__O to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %vecinit15.i.i, <16 x i32> %0
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_maskz_set1_epi32(i16 zeroext %__M, i32 %__A)  {
; X86-LABEL: test_mm512_maskz_set1_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpbroadcastd %eax, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_set1_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %esi, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <16 x i32> undef, i32 %__A, i32 0
  %vecinit15.i.i = shufflevector <16 x i32> %vecinit.i.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %0 = bitcast i16 %__M to <16 x i1>
  %1 = select <16 x i1> %0, <16 x i32> %vecinit15.i.i, <16 x i32> zeroinitializer
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_mask_set1_epi64(<8 x i64> %__O, i8 zeroext %__M, i64 %__A) {
; X86-LABEL: test_mm512_mask_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <8 x i64> undef, i64 %__A, i32 0
  %vecinit7.i.i = shufflevector <8 x i64> %vecinit.i.i, <8 x i64> undef, <8 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %vecinit7.i.i, <8 x i64> %__O
  ret <8 x i64> %1
}

define <8 x i64> @test_mm512_maskz_set1_epi64(i8 zeroext %__M, i64 %__A)  {
; X86-LABEL: test_mm512_maskz_set1_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_set1_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %rsi, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecinit.i.i = insertelement <8 x i64> undef, i64 %__A, i32 0
  %vecinit7.i.i = shufflevector <8 x i64> %vecinit.i.i, <8 x i64> undef, <8 x i32> zeroinitializer
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %vecinit7.i.i, <8 x i64> zeroinitializer
  ret <8 x i64> %1
}


define <8 x i64> @test_mm512_broadcastd_epi32(<2 x i64> %a0) {
; CHECK-LABEL: test_mm512_broadcastd_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg0, <4 x i32> undef, <16 x i32> zeroinitializer
  %res1 = bitcast <16 x i32> %res0 to <8 x i64>
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_mask_broadcastd_epi32(<8 x i64> %a0, i16 %a1, <2 x i64> %a2) {
; X86-LABEL: test_mm512_mask_broadcastd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm1, %zmm0 {%k1}
; X64-NEXT:    retq
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <2 x i64> %a2 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg2, <4 x i32> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg1, <16 x i32> %res0, <16 x i32> %arg0
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_maskz_broadcastd_epi32(i16 %a0, <2 x i64> %a1) {
; X86-LABEL: test_mm512_maskz_broadcastd_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd %xmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_broadcastd_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd %xmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <2 x i64> %a1 to <4 x i32>
  %res0 = shufflevector <4 x i32> %arg1, <4 x i32> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg0, <16 x i32> %res0, <16 x i32> zeroinitializer
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_broadcastq_epi64(<2 x i64> %a0) {
; CHECK-LABEL: test_mm512_broadcastq_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> undef, <8 x i32> zeroinitializer
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_mask_broadcastq_epi64(<8 x i64> %a0, i8 %a1, <2 x i64> %a2) {
; X86-LABEL: test_mm512_mask_broadcastq_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm1, %zmm0 {%k1}
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <2 x i64> %a2, <2 x i64> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x i64> %res0, <8 x i64> %a0
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_maskz_broadcastq_epi64(i8 %a0, <2 x i64> %a1) {
; X86-LABEL: test_mm512_maskz_broadcastq_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastq %xmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_broadcastq_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq %xmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <2 x i64> %a1, <2 x i64> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x i64> %res0, <8 x i64> zeroinitializer
  ret <8 x i64> %res1
}

define <8 x double> @test_mm512_broadcastsd_pd(<2 x double> %a0) {
; CHECK-LABEL: test_mm512_broadcastsd_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> undef, <8 x i32> zeroinitializer
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_broadcastsd_pd(<8 x double> %a0, i8 %a1, <2 x double> %a2) {
; X86-LABEL: test_mm512_mask_broadcastsd_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd %xmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm1, %zmm0 {%k1}
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <2 x double> %a2, <2 x double> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_broadcastsd_pd(i8 %a0, <2 x double> %a1) {
; X86-LABEL: test_mm512_maskz_broadcastsd_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd %xmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_broadcastsd_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd %xmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <2 x double> %a1, <2 x double> undef, <8 x i32> zeroinitializer
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <16 x float> @test_mm512_broadcastss_ps(<4 x float> %a0) {
; CHECK-LABEL: test_mm512_broadcastss_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastss %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> undef, <16 x i32> zeroinitializer
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_broadcastss_ps(<16 x float> %a0, i16 %a1, <4 x float> %a2) {
; X86-LABEL: test_mm512_mask_broadcastss_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm1, %zmm0 {%k1}
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <4 x float> %a2, <4 x float> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_broadcastss_ps(i16 %a0, <4 x float> %a1) {
; X86-LABEL: test_mm512_maskz_broadcastss_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss %xmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_broadcastss_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss %xmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <4 x float> %a1, <4 x float> undef, <16 x i32> zeroinitializer
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <8 x double> @test_mm512_movedup_pd(<8 x double> %a0) {
; CHECK-LABEL: test_mm512_movedup_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovddup {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_movedup_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_mask_movedup_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} = zmm1[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_movedup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} = zmm1[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_movedup_pd(i8 %a0, <8 x double> %a1) {
; X86-LABEL: test_mm512_maskz_movedup_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_movedup_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovddup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <16 x float> @test_mm512_movehdup_ps(<16 x float> %a0) {
; CHECK-LABEL: test_mm512_movehdup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovshdup {{.*#+}} zmm0 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <16 x float> %a0, <16 x float> undef, <16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_movehdup_ps(<16 x float> %a0, i16 %a1, <16 x float> %a2) {
; X86-LABEL: test_mm512_mask_movehdup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} = zmm1[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} = zmm1[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <16 x float> %a2, <16 x float> undef, <16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_movehdup_ps(i16 %a0, <16 x float> %a1) {
; X86-LABEL: test_mm512_maskz_movehdup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} {z} = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_movehdup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovshdup {{.*#+}} zmm0 {%k1} {z} = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <16 x float> %a1, <16 x float> undef, <16 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7, i32 9, i32 9, i32 11, i32 11, i32 13, i32 13, i32 15, i32 15>
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_moveldup_ps(<16 x float> %a0) {
; CHECK-LABEL: test_mm512_moveldup_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovsldup {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <16 x float> %a0, <16 x float> undef, <16 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_moveldup_ps(<16 x float> %a0, i16 %a1, <16 x float> %a2) {
; X86-LABEL: test_mm512_mask_moveldup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} = zmm1[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} = zmm1[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <16 x float> %a2, <16 x float> undef, <16 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_moveldup_ps(i16 %a0, <16 x float> %a1) {
; X86-LABEL: test_mm512_maskz_moveldup_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_moveldup_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovsldup {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <16 x float> %a1, <16 x float> undef, <16 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6, i32 8, i32 8, i32 10, i32 10, i32 12, i32 12, i32 14, i32 14>
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <8 x double> @test_mm512_permute_pd(<8 x double> %a0) {
; CHECK-LABEL: test_mm512_permute_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilpd {{.*#+}} zmm0 = zmm0[0,1,2,2,4,4,6,6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_permute_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_mask_permute_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermilpd {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permute_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermilpd {{.*#+}} zmm0 {%k1} = zmm1[0,1,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_permute_pd(i8 %a0, <8 x double> %a1) {
; X86-LABEL: test_mm512_maskz_permute_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermilpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,2,4,4,6,6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permute_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermilpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0,1,2,2,4,4,6,6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <16 x float> @test_mm512_permute_ps(<16 x float> %a0) {
; CHECK-LABEL: test_mm512_permute_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilps {{.*#+}} zmm0 = zmm0[2,0,0,0,6,4,4,4,10,8,8,8,14,12,12,12]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <16 x float> %a0, <16 x float> undef, <16 x i32> <i32 2, i32 0, i32 0, i32 0, i32 6, i32 4, i32 4, i32 4, i32 10, i32 8, i32 8, i32 8, i32 14, i32 12, i32 12, i32 12>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_permute_ps(<16 x float> %a0, i16 %a1, <16 x float> %a2) {
; X86-LABEL: test_mm512_mask_permute_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} = zmm1[2,0,0,0,6,4,4,4,10,8,8,8,14,12,12,12]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permute_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} = zmm1[2,0,0,0,6,4,4,4,10,8,8,8,14,12,12,12]
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <16 x float> %a2, <16 x float> undef, <16 x i32> <i32 2, i32 0, i32 0, i32 0, i32 6, i32 4, i32 4, i32 4, i32 10, i32 8, i32 8, i32 8, i32 14, i32 12, i32 12, i32 12>
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_permute_ps(i16 %a0, <16 x float> %a1) {
; X86-LABEL: test_mm512_maskz_permute_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = zmm0[2,0,0,0,6,4,4,4,10,8,8,8,14,12,12,12]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permute_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermilps {{.*#+}} zmm0 {%k1} {z} = zmm0[2,0,0,0,6,4,4,4,10,8,8,8,14,12,12,12]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <16 x float> %a1, <16 x float> undef, <16 x i32> <i32 2, i32 0, i32 0, i32 0, i32 6, i32 4, i32 4, i32 4, i32 10, i32 8, i32 8, i32 8, i32 14, i32 12, i32 12, i32 12>
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <8 x i64> @test_mm512_permutex_epi64(<8 x i64> %a0) {
; CHECK-LABEL: test_mm512_permutex_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} zmm0 = zmm0[0,0,0,0,4,4,4,4]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x i64> %a0, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_mask_permutex_epi64(<8 x i64> %a0, i8 %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_mask_permutex_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermq {{.*#+}} zmm0 {%k1} = zmm1[0,0,0,0,4,4,4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} zmm0 {%k1} = zmm1[0,0,0,0,4,4,4,4]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a2, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  %res1 = select <8 x i1> %arg1, <8 x i64> %res0, <8 x i64> %a0
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_maskz_permutex_epi64(i8 %a0, <8 x i64> %a1) {
; X86-LABEL: test_mm512_maskz_permutex_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermq {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,0,0,4,4,4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermq {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,0,0,4,4,4,4]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a1, <8 x i64> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  %res1 = select <8 x i1> %arg0, <8 x i64> %res0, <8 x i64> zeroinitializer
  ret <8 x i64> %res1
}

define <8 x double> @test_mm512_permutex_pd(<8 x double> %a0) {
; CHECK-LABEL: test_mm512_permutex_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermpd {{.*#+}} zmm0 = zmm0[0,0,0,0,4,4,4,4]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_permutex_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_mask_permutex_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermpd {{.*#+}} zmm0 {%k1} = zmm1[0,0,0,0,4,4,4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} zmm0 {%k1} = zmm1[0,0,0,0,4,4,4,4]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_permutex_pd(i8 %a0, <8 x double> %a1) {
; X86-LABEL: test_mm512_maskz_permutex_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,0,0,4,4,4,4]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0,0,0,0,4,4,4,4]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> undef, <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 4, i32 4, i32 4, i32 4>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <8 x i64> @test_mm512_shuffle_epi32(<8 x i64> %a0) {
; CHECK-LABEL: test_mm512_shuffle_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilps {{.*#+}} zmm0 = zmm0[1,0,0,0,5,4,4,4,9,8,8,8,13,12,12,12]
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg0, <16 x i32> undef, <16 x i32> <i32 1, i32 0, i32 0, i32 0, i32 5, i32 4, i32 4, i32 4, i32 9, i32 8, i32 8, i32 8, i32 13, i32 12, i32 12, i32 12>
  %res1 = bitcast <16 x i32> %res0 to <8 x i64>
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_mask_shuffle_epi32(<8 x i64> %a0, i16 %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_mask_shuffle_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpshufd {{.*#+}} zmm0 {%k1} = zmm1[1,0,0,0,5,4,4,4,9,8,8,8,13,12,12,12]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpshufd {{.*#+}} zmm0 {%k1} = zmm1[1,0,0,0,5,4,4,4,9,8,8,8,13,12,12,12]
; X64-NEXT:    retq
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <8 x i64> %a2 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg2, <16 x i32> undef, <16 x i32> <i32 1, i32 0, i32 0, i32 0, i32 5, i32 4, i32 4, i32 4, i32 9, i32 8, i32 8, i32 8, i32 13, i32 12, i32 12, i32 12>
  %res1 = select <16 x i1> %arg1, <16 x i32> %res0, <16 x i32> %arg0
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_maskz_shuffle_epi32(i16 %a0, <8 x i64> %a1) {
; X86-LABEL: test_mm512_maskz_shuffle_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpshufd {{.*#+}} zmm0 {%k1} {z} = zmm0[1,0,0,0,5,4,4,4,9,8,8,8,13,12,12,12]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpshufd {{.*#+}} zmm0 {%k1} {z} = zmm0[1,0,0,0,5,4,4,4,9,8,8,8,13,12,12,12]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <8 x i64> %a1 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg1, <16 x i32> undef, <16 x i32> <i32 1, i32 0, i32 0, i32 0, i32 5, i32 4, i32 4, i32 4, i32 9, i32 8, i32 8, i32 8, i32 13, i32 12, i32 12, i32 12>
  %res1 = select <16 x i1> %arg0, <16 x i32> %res0, <16 x i32> zeroinitializer
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x double> @test_mm512_shuffle_pd(<8 x double> %a0, <8 x double> %a1) {
; CHECK-LABEL: test_mm512_shuffle_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufpd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[3],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> %a1, <8 x i32> <i32 0, i32 8, i32 3, i32 10, i32 4, i32 12, i32 6, i32 14>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_shuffle_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2, <8 x double> %a3) {
; X86-LABEL: test_mm512_mask_shuffle_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufpd {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[3],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[3],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> %a3, <8 x i32> <i32 0, i32 8, i32 3, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_shuffle_pd(i8 %a0, <8 x double> %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_maskz_shuffle_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vshufpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[3],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_shuffle_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vshufpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[3],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> %a2, <8 x i32> <i32 0, i32 8, i32 3, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <8 x i64> @test_mm512_unpackhi_epi32(<8 x i64> %a0, <8 x i64> %a1) {
; CHECK-LABEL: test_mm512_unpackhi_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhps {{.*#+}} zmm0 = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast <8 x i64> %a1 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg0, <16 x i32> %arg1, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  %res1 = bitcast <16 x i32> %res0 to <8 x i64>
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_mask_unpackhi_epi32(<8 x i64> %a0, i16 %a1, <8 x i64> %a2, <8 x i64> %a3) {
; X86-LABEL: test_mm512_mask_unpackhi_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckhdq {{.*#+}} zmm0 {%k1} = zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[14],zmm2[14],zmm1[15],zmm2[15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpackhi_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckhdq {{.*#+}} zmm0 {%k1} = zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[14],zmm2[14],zmm1[15],zmm2[15]
; X64-NEXT:    retq
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <8 x i64> %a2 to <16 x i32>
  %arg3 = bitcast <8 x i64> %a3 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg2, <16 x i32> %arg3, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  %res1 = select <16 x i1> %arg1, <16 x i32> %res0, <16 x i32> %arg0
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_maskz_unpackhi_epi32(i16 %a0, <8 x i64> %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_maskz_unpackhi_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckhdq {{.*#+}} zmm0 {%k1} {z} = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpackhi_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckhdq {{.*#+}} zmm0 {%k1} {z} = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <8 x i64> %a1 to <16 x i32>
  %arg2 = bitcast <8 x i64> %a2 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg1, <16 x i32> %arg2, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  %res1 = select <16 x i1> %arg0, <16 x i32> %res0, <16 x i32> zeroinitializer
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_unpackhi_epi64(<8 x i64> %a0, <8 x i64> %a1) {
; CHECK-LABEL: test_mm512_unpackhi_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x i64> %a0, <8 x i64> %a1, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_mask_unpackhi_epi64(<8 x i64> %a0, i8 %a1, <8 x i64> %a2, <8 x i64> %a3) {
; X86-LABEL: test_mm512_mask_unpackhi_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckhqdq {{.*#+}} zmm0 {%k1} = zmm1[1],zmm2[1],zmm1[3],zmm2[3],zmm1[5],zmm2[5],zmm1[7],zmm2[7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpackhi_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckhqdq {{.*#+}} zmm0 {%k1} = zmm1[1],zmm2[1],zmm1[3],zmm2[3],zmm1[5],zmm2[5],zmm1[7],zmm2[7]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a2, <8 x i64> %a3, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res1 = select <8 x i1> %arg1, <8 x i64> %res0, <8 x i64> %a0
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_maskz_unpackhi_epi64(i8 %a0, <8 x i64> %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_maskz_unpackhi_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckhqdq {{.*#+}} zmm0 {%k1} {z} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpackhi_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckhqdq {{.*#+}} zmm0 {%k1} {z} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a1, <8 x i64> %a2, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res1 = select <8 x i1> %arg0, <8 x i64> %res0, <8 x i64> zeroinitializer
  ret <8 x i64> %res1
}

define <8 x double> @test_mm512_unpackhi_pd(<8 x double> %a0, <8 x double> %a1) {
; CHECK-LABEL: test_mm512_unpackhi_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhpd {{.*#+}} zmm0 = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> %a1, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_unpackhi_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2, <8 x double> %a3) {
; X86-LABEL: test_mm512_mask_unpackhi_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} = zmm1[1],zmm2[1],zmm1[3],zmm2[3],zmm1[5],zmm2[5],zmm1[7],zmm2[7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpackhi_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} = zmm1[1],zmm2[1],zmm1[3],zmm2[3],zmm1[5],zmm2[5],zmm1[7],zmm2[7]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> %a3, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_unpackhi_pd(i8 %a0, <8 x double> %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_maskz_unpackhi_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} {z} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpackhi_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhpd {{.*#+}} zmm0 {%k1} {z} = zmm0[1],zmm1[1],zmm0[3],zmm1[3],zmm0[5],zmm1[5],zmm0[7],zmm1[7]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> %a2, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <16 x float> @test_mm512_unpackhi_ps(<16 x float> %a0, <16 x float> %a1) {
; CHECK-LABEL: test_mm512_unpackhi_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpckhps {{.*#+}} zmm0 = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <16 x float> %a0, <16 x float> %a1, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_unpackhi_ps(<16 x float> %a0, i16 %a1, <16 x float> %a2, <16 x float> %a3) {
; X86-LABEL: test_mm512_mask_unpackhi_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhps {{.*#+}} zmm0 {%k1} = zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[14],zmm2[14],zmm1[15],zmm2[15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpackhi_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhps {{.*#+}} zmm0 {%k1} = zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[14],zmm2[14],zmm1[15],zmm2[15]
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <16 x float> %a2, <16 x float> %a3, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_unpackhi_ps(i16 %a0, <16 x float> %a1, <16 x float> %a2) {
; X86-LABEL: test_mm512_maskz_unpackhi_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpckhps {{.*#+}} zmm0 {%k1} {z} = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpackhi_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpckhps {{.*#+}} zmm0 {%k1} {z} = zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[14],zmm1[14],zmm0[15],zmm1[15]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <16 x float> %a1, <16 x float> %a2, <16 x i32> <i32 2, i32 18, i32 3, i32 19, i32 6, i32 22, i32 7, i32 23, i32 10, i32 26, i32 11, i32 27, i32 14, i32 30, i32 15, i32 31>
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <8 x i64> @test_mm512_unpacklo_epi32(<8 x i64> %a0, <8 x i64> %a1) {
; CHECK-LABEL: test_mm512_unpacklo_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklps {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast <8 x i64> %a1 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg0, <16 x i32> %arg1, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = bitcast <16 x i32> %res0 to <8 x i64>
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_mask_unpacklo_epi32(<8 x i64> %a0, i16 %a1, <8 x i64> %a2, <8 x i64> %a3) {
; X86-LABEL: test_mm512_mask_unpacklo_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckldq {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[12],zmm2[12],zmm1[13],zmm2[13]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpacklo_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckldq {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[12],zmm2[12],zmm1[13],zmm2[13]
; X64-NEXT:    retq
  %arg0 = bitcast <8 x i64> %a0 to <16 x i32>
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %arg2 = bitcast <8 x i64> %a2 to <16 x i32>
  %arg3 = bitcast <8 x i64> %a3 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg2, <16 x i32> %arg3, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = select <16 x i1> %arg1, <16 x i32> %res0, <16 x i32> %arg0
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_maskz_unpacklo_epi32(i16 %a0, <8 x i64> %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_maskz_unpacklo_epi32:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpckldq {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpacklo_epi32:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpckldq {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %arg1 = bitcast <8 x i64> %a1 to <16 x i32>
  %arg2 = bitcast <8 x i64> %a2 to <16 x i32>
  %res0 = shufflevector <16 x i32> %arg1, <16 x i32> %arg2, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = select <16 x i1> %arg0, <16 x i32> %res0, <16 x i32> zeroinitializer
  %res2 = bitcast <16 x i32> %res1 to <8 x i64>
  ret <8 x i64> %res2
}

define <8 x i64> @test_mm512_unpacklo_epi64(<8 x i64> %a0, <8 x i64> %a1) {
; CHECK-LABEL: test_mm512_unpacklo_epi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x i64> %a0, <8 x i64> %a1, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_mask_unpacklo_epi64(<8 x i64> %a0, i8 %a1, <8 x i64> %a2, <8 x i64> %a3) {
; X86-LABEL: test_mm512_mask_unpacklo_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[2],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpacklo_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[2],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a2, <8 x i64> %a3, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg1, <8 x i64> %res0, <8 x i64> %a0
  ret <8 x i64> %res1
}

define <8 x i64> @test_mm512_maskz_unpacklo_epi64(i8 %a0, <8 x i64> %a1, <8 x i64> %a2) {
; X86-LABEL: test_mm512_maskz_unpacklo_epi64:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpacklo_epi64:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x i64> %a1, <8 x i64> %a2, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg0, <8 x i64> %res0, <8 x i64> zeroinitializer
  ret <8 x i64> %res1
}

define <8 x double> @test_mm512_unpacklo_pd(<8 x double> %a0, <8 x double> %a1) {
; CHECK-LABEL: test_mm512_unpacklo_pd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklpd {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x double> %a0, <8 x double> %a1, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_mask_unpacklo_pd(<8 x double> %a0, i8 %a1, <8 x double> %a2, <8 x double> %a3) {
; X86-LABEL: test_mm512_mask_unpacklo_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[2],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpacklo_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[2],zmm2[2],zmm1[4],zmm2[4],zmm1[6],zmm2[6]
; X64-NEXT:    retq
  %arg1 = bitcast i8 %a1 to <8 x i1>
  %res0 = shufflevector <8 x double> %a2, <8 x double> %a3, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg1, <8 x double> %res0, <8 x double> %a0
  ret <8 x double> %res1
}

define <8 x double> @test_mm512_maskz_unpacklo_pd(i8 %a0, <8 x double> %a1, <8 x double> %a2) {
; X86-LABEL: test_mm512_maskz_unpacklo_pd:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpacklo_pd:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpcklpd {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; X64-NEXT:    retq
  %arg0 = bitcast i8 %a0 to <8 x i1>
  %res0 = shufflevector <8 x double> %a1, <8 x double> %a2, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  %res1 = select <8 x i1> %arg0, <8 x double> %res0, <8 x double> zeroinitializer
  ret <8 x double> %res1
}

define <16 x float> @test_mm512_unpacklo_ps(<16 x float> %a0, <16 x float> %a1) {
; CHECK-LABEL: test_mm512_unpacklo_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vunpcklps {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <16 x float> %a0, <16 x float> %a1, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_mask_unpacklo_ps(<16 x float> %a0, i16 %a1, <16 x float> %a2, <16 x float> %a3) {
; X86-LABEL: test_mm512_mask_unpacklo_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpcklps {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[12],zmm2[12],zmm1[13],zmm2[13]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_unpacklo_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpcklps {{.*#+}} zmm0 {%k1} = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[12],zmm2[12],zmm1[13],zmm2[13]
; X64-NEXT:    retq
  %arg1 = bitcast i16 %a1 to <16 x i1>
  %res0 = shufflevector <16 x float> %a2, <16 x float> %a3, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = select <16 x i1> %arg1, <16 x float> %res0, <16 x float> %a0
  ret <16 x float> %res1
}

define <16 x float> @test_mm512_maskz_unpacklo_ps(i16 %a0, <16 x float> %a1, <16 x float> %a2) {
; X86-LABEL: test_mm512_maskz_unpacklo_ps:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vunpcklps {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_unpacklo_ps:
; X64:       # %bb.0:
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vunpcklps {{.*#+}} zmm0 {%k1} {z} = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[12],zmm1[12],zmm0[13],zmm1[13]
; X64-NEXT:    retq
  %arg0 = bitcast i16 %a0 to <16 x i1>
  %res0 = shufflevector <16 x float> %a1, <16 x float> %a2, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 4, i32 20, i32 5, i32 21, i32 8, i32 24, i32 9, i32 25, i32 12, i32 28, i32 13, i32 29>
  %res1 = select <16 x i1> %arg0, <16 x float> %res0, <16 x float> zeroinitializer
  ret <16 x float> %res1
}

define <8 x double> @test_mm512_zextpd128_pd512(<2 x double> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextpd128_pd512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x double> %a0, <2 x double> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  ret <8 x double> %res
}

define <8 x double> @test_mm512_zextpd256_pd512(<4 x double> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextpd256_pd512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x double> %a0, <4 x double> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x double> %res
}

define <16 x float> @test_mm512_zextps128_ps512(<4 x float> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextps128_ps512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x float> %a0, <4 x float> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7, i32 4, i32 5, i32 6, i32 7>
  ret <16 x float> %res
}

define <16 x float> @test_mm512_zextps256_ps512(<8 x float> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextps256_ps512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <8 x float> %a0, <8 x float> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x float> %res
}

define <8 x i64> @test_mm512_zextsi128_si512(<2 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextsi128_si512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <2 x i64> %a0, <2 x i64> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 2, i32 3, i32 2, i32 3>
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_zextsi256_si512(<4 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm512_zextsi256_si512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %ymm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = shufflevector <4 x i64> %a0, <4 x i64> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i64> %res
}

define <8 x i64> @test_mm512_mul_epi32(<8 x i64> %__A, <8 x i64> %__B) nounwind {
; CHECK-LABEL: test_mm512_mul_epi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmuldq %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %tmp = shl <8 x i64> %__A, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %tmp1 = ashr exact <8 x i64> %tmp, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %tmp2 = shl <8 x i64> %__B, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %tmp3 = ashr exact <8 x i64> %tmp2, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %tmp4 = mul nsw <8 x i64> %tmp3, %tmp1
  ret <8 x i64> %tmp4
}

define <8 x i64> @test_mm512_maskz_mul_epi32(i8 zeroext %__k, <8 x i64> %__A, <8 x i64> %__B) nounwind {
; X86-LABEL: test_mm512_maskz_mul_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_mul_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = shl <8 x i64> %__A, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %1 = ashr exact <8 x i64> %0, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %2 = shl <8 x i64> %__B, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %3 = ashr exact <8 x i64> %2, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %4 = mul nsw <8 x i64> %3, %1
  %5 = bitcast i8 %__k to <8 x i1>
  %6 = select <8 x i1> %5, <8 x i64> %4, <8 x i64> zeroinitializer
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_mask_mul_epi32(i8 zeroext %__k, <8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__src) nounwind {
; X86-LABEL: test_mm512_mask_mul_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuldq %zmm0, %zmm1, %zmm2 {%k1}
; X86-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_mul_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuldq %zmm0, %zmm1, %zmm2 {%k1}
; X64-NEXT:    vmovdqa64 %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = shl <8 x i64> %__A, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %1 = ashr exact <8 x i64> %0, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %2 = shl <8 x i64> %__B, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %3 = ashr exact <8 x i64> %2, <i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32, i64 32>
  %4 = mul nsw <8 x i64> %3, %1
  %5 = bitcast i8 %__k to <8 x i1>
  %6 = select <8 x i1> %5, <8 x i64> %4, <8 x i64> %__src
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_mul_epu32(<8 x i64> %__A, <8 x i64> %__B) nounwind {
; CHECK-LABEL: test_mm512_mul_epu32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpmuludq %zmm0, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %tmp = and <8 x i64> %__A, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp1 = and <8 x i64> %__B, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %tmp2 = mul nuw <8 x i64> %tmp1, %tmp
  ret <8 x i64> %tmp2
}

define <8 x i64> @test_mm512_maskz_mul_epu32(i8 zeroext %__k, <8 x i64> %__A, <8 x i64> %__B) nounwind {
; X86-LABEL: test_mm512_maskz_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %zmm0, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = and <8 x i64> %__A, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = and <8 x i64> %__B, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %2 = mul nuw <8 x i64> %1, %0
  %3 = bitcast i8 %__k to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> zeroinitializer
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_mask_mul_epu32(i8 zeroext %__k, <8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__src) nounwind {
; X86-LABEL: test_mm512_mask_mul_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmuludq %zmm0, %zmm1, %zmm2 {%k1}
; X86-NEXT:    vmovdqa64 %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_mul_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmuludq %zmm0, %zmm1, %zmm2 {%k1}
; X64-NEXT:    vmovdqa64 %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = and <8 x i64> %__A, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %1 = and <8 x i64> %__B, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %2 = mul nuw <8 x i64> %1, %0
  %3 = bitcast i8 %__k to <8 x i1>
  %4 = select <8 x i1> %3, <8 x i64> %2, <8 x i64> %__src
  ret <8 x i64> %4
}

define <8 x double> @test_mm512_set1_epi8(i8 signext %d) nounwind {
; X86-LABEL: test_mm512_set1_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    vmovd %eax, %xmm0
; X86-NEXT:    vpbroadcastb %xmm0, %ymm0
; X86-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_set1_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vmovd %edi, %xmm0
; X64-NEXT:    vpbroadcastb %xmm0, %ymm0
; X64-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-NEXT:    retq
entry:
  %vecinit.i = insertelement <64 x i8> undef, i8 %d, i32 0
  %vecinit63.i = shufflevector <64 x i8> %vecinit.i, <64 x i8> undef, <64 x i32> zeroinitializer
  %0 = bitcast <64 x i8> %vecinit63.i to <8 x double>
  ret <8 x double> %0
}

define <2 x double> @test_mm_cvtu32_sd(<2 x double> %__A, i32 %__B) {
; X86-LABEL: test_mm_cvtu32_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vcvtusi2sdl {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_cvtu32_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtusi2sd %edi, %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %conv.i = uitofp i32 %__B to double
  %vecins.i = insertelement <2 x double> %__A, double %conv.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_cvtu64_sd(<2 x double> %__A, i64 %__B) {
; X86-LABEL: test_mm_cvtu64_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; X86-NEXT:    vpunpckldq {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1]
; X86-NEXT:    vsubpd {{\.LCPI.*}}, %xmm1, %xmm1
; X86-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; X86-NEXT:    vaddsd %xmm1, %xmm2, %xmm1
; X86-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_cvtu64_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtusi2sd %rdi, %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %conv.i = uitofp i64 %__B to double
  %vecins.i = insertelement <2 x double> %__A, double %conv.i, i32 0
  ret <2 x double> %vecins.i
}

define <4 x float> @test_mm_cvtu32_ss(<4 x float> %__A, i32 %__B) {
; X86-LABEL: test_mm_cvtu32_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vcvtusi2ssl {{[0-9]+}}(%esp), %xmm0, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_cvtu32_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtusi2ss %edi, %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %conv.i = uitofp i32 %__B to float
  %vecins.i = insertelement <4 x float> %__A, float %conv.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_cvtu64_ss(<4 x float> %__A, i64 %__B) {
; X86-LABEL: test_mm_cvtu64_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $16, %esp
; X86-NEXT:    movl 12(%ebp), %eax
; X86-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vpinsrd $1, %eax, %xmm1, %xmm1
; X86-NEXT:    vmovq %xmm1, {{[0-9]+}}(%esp)
; X86-NEXT:    shrl $31, %eax
; X86-NEXT:    fildll {{[0-9]+}}(%esp)
; X86-NEXT:    fadds {{\.LCPI.*}}(,%eax,4)
; X86-NEXT:    fstps {{[0-9]+}}(%esp)
; X86-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_cvtu64_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vcvtusi2ss %rdi, %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %conv.i = uitofp i64 %__B to float
  %vecins.i = insertelement <4 x float> %__A, float %conv.i, i32 0
  ret <4 x float> %vecins.i
}

define <16 x float> @test_mm512_cvtph_ps(<4 x i64> %__A) {
; CHECK-LABEL: test_mm512_cvtph_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtph2ps %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <4 x i64> %__A to <16 x i16>
  %1 = bitcast <16 x i16> %0 to <16 x half>
  %2 = fpext <16 x half> %1 to <16 x float>
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_cvtph_ps(<16 x float> %__W, i16 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm512_mask_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %ymm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %ymm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <16 x i16>
  %1 = bitcast <16 x i16> %0 to <16 x half>
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = fpext <16 x half> %1 to <16 x float>
  %4 = select <16 x i1> %2, <16 x float> %3, <16 x float> %__W
  ret <16 x float> %4
}

define <16 x float> @test_mm512_maskz_cvtph_ps(i16 zeroext %__U, <4 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_cvtph_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtph2ps %ymm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_cvtph_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtph2ps %ymm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <4 x i64> %__A to <16 x i16>
  %1 = bitcast <16 x i16> %0 to <16 x half>
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = fpext <16 x half> %1 to <16 x float>
  %4 = select <16 x i1> %2, <16 x float> %3, <16 x float> zeroinitializer
  ret <16 x float> %4
}

define <8 x double> @test_mm512_cvtps_pd(<8 x float> %__A) {
; CHECK-LABEL: test_mm512_cvtps_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2pd %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = fpext <8 x float> %__A to <8 x double>
  ret <8 x double> %conv.i
}

define <8 x double> @test_mm512_cvtpslo_pd(<16 x float> %__A) {
; CHECK-LABEL: test_mm512_cvtpslo_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcvtps2pd %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %shuffle.i.i = shufflevector <16 x float> %__A, <16 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %conv.i.i = fpext <8 x float> %shuffle.i.i to <8 x double>
  ret <8 x double> %conv.i.i
}

define <8 x double> @test_mm512_mask_cvtps_pd(<8 x double> %__W, i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm512_mask_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %ymm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %ymm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <8 x float> %__A to <8 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %conv.i.i, <8 x double> %__W
  ret <8 x double> %1
}

define <8 x double> @test_mm512_mask_cvtpslo_pd(<8 x double> %__W, i8 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_mask_cvtpslo_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %ymm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtpslo_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %ymm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %shuffle.i.i = shufflevector <16 x float> %__A, <16 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %conv.i.i.i = fpext <8 x float> %shuffle.i.i to <8 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %conv.i.i.i, <8 x double> %__W
  ret <8 x double> %1
}

define <8 x double> @test_mm512_maskz_cvtps_pd(i8 zeroext %__U, <8 x float> %__A) {
; X86-LABEL: test_mm512_maskz_cvtps_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcvtps2pd %ymm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_cvtps_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vcvtps2pd %ymm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = fpext <8 x float> %__A to <8 x double>
  %0 = bitcast i8 %__U to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %conv.i.i, <8 x double> zeroinitializer
  ret <8 x double> %1
}

define <2 x i64> @test_mm512_cvtepi32_epi8(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_cvtepi32_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovdb %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %conv.i = trunc <16 x i32> %0 to <16 x i8>
  %1 = bitcast <16 x i8> %conv.i to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm512_mask_cvtepi32_epi8(<2 x i64> %__O, i16 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_cvtepi32_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovdb %zmm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtepi32_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovdb %zmm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <2 x i64> %__O to <16 x i8>
  %2 = tail call <16 x i8> @llvm.x86.avx512.mask.pmov.db.512(<16 x i32> %0, <16 x i8> %1, i16 %__M)
  %3 = bitcast <16 x i8> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @test_mm512_maskz_cvtepi32_epi8(i16 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_cvtepi32_epi8:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovdb %zmm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_cvtepi32_epi8:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovdb %zmm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i8> @llvm.x86.avx512.mask.pmov.db.512(<16 x i32> %0, <16 x i8> zeroinitializer, i16 %__M)
  %2 = bitcast <16 x i8> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <4 x i64> @test_mm512_cvtepi64_epi32(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_cvtepi64_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqd %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <8 x i64> %__A to <8 x i32>
  %0 = bitcast <8 x i32> %conv.i to <4 x i64>
  ret <4 x i64> %0
}

define <4 x i64> @test_mm512_mask_cvtepi64_epi32(<4 x i64> %__O, i8 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_cvtepi64_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqd %zmm1, %ymm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtepi64_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqd %zmm1, %ymm0 {%k1}
; X64-NEXT:    retq
entry:
  %conv.i.i = trunc <8 x i64> %__A to <8 x i32>
  %0 = bitcast <4 x i64> %__O to <8 x i32>
  %1 = bitcast i8 %__M to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %conv.i.i, <8 x i32> %0
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @test_mm512_maskz_cvtepi64_epi32(i8 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_cvtepi64_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqd %zmm0, %ymm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_cvtepi64_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqd %zmm0, %ymm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %conv.i.i = trunc <8 x i64> %__A to <8 x i32>
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i32> %conv.i.i, <8 x i32> zeroinitializer
  %2 = bitcast <8 x i32> %1 to <4 x i64>
  ret <4 x i64> %2
}

define <2 x i64> @test_mm512_cvtepi64_epi16(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_cvtepi64_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpmovqw %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %conv.i = trunc <8 x i64> %__A to <8 x i16>
  %0 = bitcast <8 x i16> %conv.i to <2 x i64>
  ret <2 x i64> %0
}

define <2 x i64> @test_mm512_mask_cvtepi64_epi16(<2 x i64> %__O, i8 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_cvtepi64_epi16:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqw %zmm1, %xmm0 {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_cvtepi64_epi16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqw %zmm1, %xmm0 {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <2 x i64> %__O to <8 x i16>
  %1 = tail call <8 x i16> @llvm.x86.avx512.mask.pmov.qw.512(<8 x i64> %__A, <8 x i16> %0, i8 %__M)
  %2 = bitcast <8 x i16> %1 to <2 x i64>
  ret <2 x i64> %2
}

define <2 x i64> @test_mm512_maskz_cvtepi64_epi16(i8 zeroext %__M, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_cvtepi64_epi16:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpmovqw %zmm0, %xmm0 {%k1} {z}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_cvtepi64_epi16:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpmovqw %zmm0, %xmm0 {%k1} {z}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i16> @llvm.x86.avx512.mask.pmov.qw.512(<8 x i64> %__A, <8 x i16> zeroinitializer, i8 %__M)
  %1 = bitcast <8 x i16> %0 to <2 x i64>
  ret <2 x i64> %1
}

declare <16 x i8> @llvm.x86.avx512.mask.pmov.db.512(<16 x i32>, <16 x i8>, i16)
declare <8 x i16> @llvm.x86.avx512.mask.pmov.qw.512(<8 x i64>, <8 x i16>, i8)

define <8 x i64> @test_mm512_ternarylogic_epi32(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C) {
; CHECK-LABEL: test_mm512_ternarylogic_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogd $4, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = bitcast <8 x i64> %__C to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2, i32 4)
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

declare <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32>, <16 x i32>, <16 x i32>, i32) #1

define <8 x i64> @test_mm512_mask_ternarylogic_epi32(<8 x i64> %__A, i16 zeroext %__U, <8 x i64> %__B, <8 x i64> %__C) {
; X86-LABEL: test_mm512_mask_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $4, %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $4, %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = bitcast <8 x i64> %__C to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2, i32 4)
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %3, <16 x i32> %0
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_maskz_ternarylogic_epi32(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C) {
; X86-LABEL: test_mm512_maskz_ternarylogic_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $4, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_ternarylogic_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $4, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = bitcast <8 x i64> %__C to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2, i32 4)
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %3, <16 x i32> zeroinitializer
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_ternarylogic_epi64(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C) {
; CHECK-LABEL: test_mm512_ternarylogic_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpternlogq $4, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, i32 4)
  ret <8 x i64> %0
}

declare <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64>, <8 x i64>, <8 x i64>, i32) #1

define <8 x i64> @test_mm512_mask_ternarylogic_epi64(<8 x i64> %__A, i8 zeroext %__U, <8 x i64> %__B, <8 x i64> %__C) {
; X86-LABEL: test_mm512_mask_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq $4, %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq $4, %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__A
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_ternarylogic_epi64(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C) {
; X86-LABEL: test_mm512_maskz_ternarylogic_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogq $4, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_ternarylogic_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogq $4, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %__A, <8 x i64> %__B, <8 x i64> %__C, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

declare <16 x i32> @llvm.x86.avx512.vpermi2var.d.512(<16 x i32>, <16 x i32>, <16 x i32>)

define <8 x i64> @test_mm512_mask2_permutex2var_epi32(<8 x i64> %__A, <8 x i64> %__I, i16 zeroext %__U, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask2_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1 {%k1}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask2_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2d %zmm2, %zmm0, %zmm1 {%k1}
; X64-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__I to <16 x i32>
  %2 = bitcast <8 x i64> %__B to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.vpermi2var.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2)
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %3, <16 x i32> %1
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

declare <8 x double> @llvm.x86.avx512.vpermi2var.pd.512(<8 x double>, <8 x i64>, <8 x double>)

define <8 x double> @test_mm512_mask2_permutex2var_pd(<8 x double> %__A, <8 x i64> %__I, i8 zeroext %__U, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask2_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2pd %zmm2, %zmm0, %zmm1 {%k1}
; X86-NEXT:    vmovapd %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask2_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2pd %zmm2, %zmm0, %zmm1 {%k1}
; X64-NEXT:    vmovapd %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vpermi2var.pd.512(<8 x double> %__A, <8 x i64> %__I, <8 x double> %__B)
  %1 = bitcast <8 x i64> %__I to <8 x double>
  %2 = bitcast i8 %__U to <8 x i1>
  %3 = select <8 x i1> %2, <8 x double> %0, <8 x double> %1
  ret <8 x double> %3
}

declare <16 x float> @llvm.x86.avx512.vpermi2var.ps.512(<16 x float>, <16 x i32>, <16 x float>)

define <16 x float> @test_mm512_mask2_permutex2var_ps(<16 x float> %__A, <8 x i64> %__I, i16 zeroext %__U, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask2_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2ps %zmm2, %zmm0, %zmm1 {%k1}
; X86-NEXT:    vmovaps %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask2_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2ps %zmm2, %zmm0, %zmm1 {%k1}
; X64-NEXT:    vmovaps %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__I to <16 x i32>
  %1 = tail call <16 x float> @llvm.x86.avx512.vpermi2var.ps.512(<16 x float> %__A, <16 x i32> %0, <16 x float> %__B)
  %2 = bitcast <8 x i64> %__I to <16 x float>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x float> %1, <16 x float> %2
  ret <16 x float> %4
}

declare <8 x i64> @llvm.x86.avx512.vpermi2var.q.512(<8 x i64>, <8 x i64>, <8 x i64>)

define <8 x i64> @test_mm512_mask2_permutex2var_epi64(<8 x i64> %__A, <8 x i64> %__I, i8 zeroext %__U, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask2_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermi2q %zmm2, %zmm0, %zmm1 {%k1}
; X86-NEXT:    vmovdqa64 %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask2_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermi2q %zmm2, %zmm0, %zmm1 {%k1}
; X64-NEXT:    vmovdqa64 %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.vpermi2var.q.512(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__I
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_permutex2var_epi32(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_permutex2var_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2d %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__I to <16 x i32>
  %2 = bitcast <8 x i64> %__B to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.vpermi2var.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2)
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_maskz_permutex2var_epi32(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__I to <16 x i32>
  %2 = bitcast <8 x i64> %__B to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.vpermi2var.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2)
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %3, <16 x i32> zeroinitializer
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_mask_permutex2var_epi32(<8 x i64> %__A, i16 zeroext %__U, <8 x i64> %__I, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_permutex2var_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2d %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex2var_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2d %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__I to <16 x i32>
  %2 = bitcast <8 x i64> %__B to <16 x i32>
  %3 = tail call <16 x i32> @llvm.x86.avx512.vpermi2var.d.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2)
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %3, <16 x i32> %0
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x double> @test_mm512_permutex2var_pd(<8 x double> %__A, <8 x i64> %__I, <8 x double> %__B) {
; CHECK-LABEL: test_mm512_permutex2var_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2pd %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vpermi2var.pd.512(<8 x double> %__A, <8 x i64> %__I, <8 x double> %__B)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_permutex2var_pd(<8 x double> %__A, i8 zeroext %__U, <8 x i64> %__I, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vpermi2var.pd.512(<8 x double> %__A, <8 x i64> %__I, <8 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_permutex2var_pd(i8 zeroext %__U, <8 x double> %__A, <8 x i64> %__I, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_permutex2var_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2pd %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex2var_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2pd %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vpermi2var.pd.512(<8 x double> %__A, <8 x i64> %__I, <8 x double> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <16 x float> @test_mm512_permutex2var_ps(<16 x float> %__A, <8 x i64> %__I, <16 x float> %__B) {
; CHECK-LABEL: test_mm512_permutex2var_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__I to <16 x i32>
  %1 = tail call <16 x float> @llvm.x86.avx512.vpermi2var.ps.512(<16 x float> %__A, <16 x i32> %0, <16 x float> %__B)
  ret <16 x float> %1
}

define <16 x float> @test_mm512_mask_permutex2var_ps(<16 x float> %__A, i16 zeroext %__U, <8 x i64> %__I, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__I to <16 x i32>
  %1 = tail call <16 x float> @llvm.x86.avx512.vpermi2var.ps.512(<16 x float> %__A, <16 x i32> %0, <16 x float> %__B)
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x float> %1, <16 x float> %__A
  ret <16 x float> %3
}

define <16 x float> @test_mm512_maskz_permutex2var_ps(i16 zeroext %__U, <16 x float> %__A, <8 x i64> %__I, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_permutex2var_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex2var_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2ps %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__I to <16 x i32>
  %1 = tail call <16 x float> @llvm.x86.avx512.vpermi2var.ps.512(<16 x float> %__A, <16 x i32> %0, <16 x float> %__B)
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x float> %1, <16 x float> zeroinitializer
  ret <16 x float> %3
}

define <8 x i64> @test_mm512_permutex2var_epi64(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_permutex2var_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpermt2q %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.vpermi2var.q.512(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_permutex2var_epi64(<8 x i64> %__A, i8 zeroext %__U, <8 x i64> %__I, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.vpermi2var.q.512(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__A
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_permutex2var_epi64(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_permutex2var_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpermt2q %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_permutex2var_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpermt2q %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx512.vpermi2var.q.512(<8 x i64> %__A, <8 x i64> %__I, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}
define <4 x float> @test_mm_mask_add_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_add_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vaddss %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_add_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vaddss %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %add.i.i = fadd float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %add.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_add_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_add_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vaddss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_add_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vaddss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %add.i.i = fadd float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %add.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <2 x double> @test_mm_mask_add_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_add_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vaddsd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_add_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vaddsd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %add.i.i = fadd double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %add.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_add_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_add_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vaddsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_add_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vaddsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %add.i.i = fadd double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %add.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <4 x float> @test_mm_mask_sub_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_sub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsubss %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_sub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsubss %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %sub.i.i = fsub float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %sub.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_sub_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_sub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsubss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_sub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsubss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %sub.i.i = fsub float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %sub.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <2 x double> @test_mm_mask_sub_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_sub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsubsd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_sub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsubsd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %sub.i.i = fsub double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %sub.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_sub_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_sub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsubsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_sub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsubsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %sub.i.i = fsub double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %sub.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <4 x float> @test_mm_mask_mul_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_mul_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmulss %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmulss %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %mul.i.i = fmul float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %mul.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_mul_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_mul_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmulss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmulss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <4 x float> %__B, i32 0
  %vecext1.i.i = extractelement <4 x float> %__A, i32 0
  %mul.i.i = fmul float %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %mul.i.i
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <2 x double> @test_mm_mask_mul_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_mul_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmulsd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_mul_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmulsd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %mul.i.i = fmul double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %mul.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_mul_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_mul_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmulsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_mul_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmulsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %vecext.i.i = extractelement <2 x double> %__B, i32 0
  %vecext1.i.i = extractelement <2 x double> %__A, i32 0
  %mul.i.i = fmul double %vecext1.i.i, %vecext.i.i
  %0 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %0, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %mul.i.i
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <4 x float> @test_mm_mask_div_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_div_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vdivss %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_div_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vdivss %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %2 = extractelement <4 x float> %__W, i64 0
  %3 = fdiv float %0, %1
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %2
  %7 = insertelement <4 x float> %__A, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_maskz_div_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_maskz_div_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vdivss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_div_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vdivss %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %2 = fdiv float %0, %1
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = extractelement <8 x i1> %3, i64 0
  %5 = select i1 %4, float %2, float 0.000000e+00
  %6 = insertelement <4 x float> %__A, float %5, i64 0
  ret <4 x float> %6
}

define <2 x double> @test_mm_mask_div_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_div_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vdivsd %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_div_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vdivsd %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %2 = extractelement <2 x double> %__W, i64 0
  %3 = fdiv double %0, %1
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %2
  %7 = insertelement <2 x double> %__A, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_maskz_div_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_maskz_div_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vdivsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_div_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vdivsd %xmm1, %xmm0, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %2 = fdiv double %0, %1
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = extractelement <8 x i1> %3, i64 0
  %5 = select i1 %4, double %2, double 0.000000e+00
  %6 = insertelement <2 x double> %__A, double %5, i64 0
  ret <2 x double> %6
}


define <8 x double> @test_mm512_fmadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fmadd_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  ret <8 x double> %0
}

declare <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double>, <8 x double>, <8 x double>, i32) #1

define <8 x double> @test_mm512_mask_fmadd_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fmadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmadd_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fmsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_fmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxorq {{\.LCPI.*}}{1to8}, %zmm2, %zmm2
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxorq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_fmsub_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmsub_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fnmadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_fnmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxorq {{\.LCPI.*}}{1to8}, %zmm0, %zmm0
; X86-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fnmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxorq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; X64-NEXT:    vfmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %__C, i32 8)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask3_fnmadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fnmadd_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fnmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fnmsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fnmsub_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vpxorq %zmm3, %zmm0, %zmm4
; CHECK-NEXT:    vpxorq %zmm3, %zmm2, %zmm0
; CHECK-NEXT:    vfmadd231pd {rn-sae}, %zmm4, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %sub1, i32 8)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_maskz_fnmsub_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fnmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %sub1, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fmadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fmadd_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_fmadd_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) + zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fmadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) + zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) + zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmadd_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fmsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxorq {{\.LCPI.*}}{1to8}, %zmm2, %zmm2
; X86-NEXT:    vfmadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxorq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; X64-NEXT:    vfmadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_fmsub_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmsub_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fnmadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxorq {{\.LCPI.*}}{1to8}, %zmm0, %zmm0
; X86-NEXT:    vfmadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxorq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; X64-NEXT:    vfmadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %__C) #10
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask3_fnmadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231pd {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231pd {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fnmadd_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213pd {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213pd {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fnmsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fnmsub_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vpxorq %zmm3, %zmm0, %zmm4
; CHECK-NEXT:    vpxorq %zmm3, %zmm2, %zmm0
; CHECK-NEXT:    vfmadd231pd {{.*#+}} zmm0 = (zmm1 * zmm4) + zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %sub1.i) #10
  ret <8 x double> %0
}

define <8 x double> @test_mm512_maskz_fnmsub_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213pd {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213pd {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %sub1.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %sub1.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <16 x float> @test_mm512_fmadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fmadd_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  ret <16 x float> %0
}

declare <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float>, <16 x float>, <16 x float>, i32) #1

define <16 x float> @test_mm512_mask_fmadd_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fmadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmadd_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fmsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_fmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxord {{\.LCPI.*}}{1to16}, %zmm2, %zmm2
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxord {{.*}}(%rip){1to16}, %zmm2, %zmm2
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask_fmsub_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmsub_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fnmadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_fnmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxord {{\.LCPI.*}}{1to16}, %zmm0, %zmm0
; X86-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fnmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxord {{.*}}(%rip){1to16}, %zmm0, %zmm0
; X64-NEXT:    vfmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %__C, i32 8)
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask3_fnmadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fnmadd_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fnmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fnmsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fnmsub_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vpxord %zmm3, %zmm0, %zmm4
; CHECK-NEXT:    vpxord %zmm3, %zmm2, %zmm0
; CHECK-NEXT:    vfmadd231ps {rn-sae}, %zmm4, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %sub1, i32 8)
  ret <16 x float> %0
}

define <16 x float> @test_mm512_maskz_fnmsub_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fnmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %sub1, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fmadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fmadd_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask_fmadd_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) + zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fmadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) + zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) + zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmadd_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fmsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxord {{\.LCPI.*}}{1to16}, %zmm2, %zmm2
; X86-NEXT:    vfmadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxord {{.*}}(%rip){1to16}, %zmm2, %zmm2
; X64-NEXT:    vfmadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask_fmsub_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmsub_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fnmadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxord {{\.LCPI.*}}{1to16}, %zmm0, %zmm0
; X86-NEXT:    vfmadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxord {{.*}}(%rip){1to16}, %zmm0, %zmm0
; X64-NEXT:    vfmadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %__C) #10
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask3_fnmadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ps {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ps {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fnmadd_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ps {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ps {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fnmsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fnmsub_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; CHECK-NEXT:    vpxord %zmm3, %zmm0, %zmm4
; CHECK-NEXT:    vpxord %zmm3, %zmm2, %zmm0
; CHECK-NEXT:    vfmadd231ps {{.*#+}} zmm0 = (zmm1 * zmm4) + zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %sub1.i) #10
  ret <16 x float> %0
}

define <16 x float> @test_mm512_maskz_fnmsub_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ps {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ps {{.*#+}} zmm0 {%k1} {z} = -(zmm1 * zmm0) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %sub1.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %sub1.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <8 x double> @test_mm512_fmaddsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fmaddsub_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  ret <8 x double> %0
}

declare <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double>, <8 x double>, <8 x double>, i32) #1

define <8 x double> @test_mm512_mask_fmaddsub_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmaddsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmaddsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fmaddsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmaddsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmaddsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmaddsub_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmaddsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmaddsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fmsubadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_fmsubadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxorq {{\.LCPI.*}}{1to8}, %zmm2, %zmm2
; X86-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsubadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxorq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; X64-NEXT:    vfmaddsub213pd {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_fmsubadd_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmsubadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsubadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_fmsubadd_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmsubadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsubadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213pd {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_fmaddsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fmaddsub_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmaddsub213pd {{.*#+}} zmm0 = (zmm1 * zmm0) +/- zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %1) #10
  %3 = shufflevector <8 x double> %2, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x double> %3
}

define <8 x double> @test_mm512_mask_fmaddsub_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %1) #10
  %3 = shufflevector <8 x double> %2, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x double> %3, <8 x double> %__A
  ret <8 x double> %5
}

define <8 x double> @test_mm512_mask3_fmaddsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %1) #10
  %3 = shufflevector <8 x double> %2, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x double> %3, <8 x double> %__C
  ret <8 x double> %5
}

define <8 x double> @test_mm512_maskz_fmaddsub_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmaddsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) +/- zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmaddsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) +/- zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %2 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %1) #10
  %3 = shufflevector <8 x double> %2, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = select <8 x i1> %4, <8 x double> %3, <8 x double> zeroinitializer
  ret <8 x double> %5
}

define <8 x double> @test_mm512_fmsubadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; CHECK-LABEL: test_mm512_fmsubadd_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmsubadd213pd {{.*#+}} zmm0 = (zmm1 * zmm0) -/+ zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %2 = shufflevector <8 x double> %1, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask_fmsubadd_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132pd {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %2 = shufflevector <8 x double> %1, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x double> %2, <8 x double> %__A
  ret <8 x double> %4
}

define <8 x double> @test_mm512_maskz_fmsubadd_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_maskz_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) -/+ zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213pd {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) -/+ zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %2 = shufflevector <8 x double> %1, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x double> %2, <8 x double> zeroinitializer
  ret <8 x double> %4
}

define <16 x float> @test_mm512_fmaddsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fmaddsub_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  ret <16 x float> %0
}

declare <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float>, <16 x float>, <16 x float>, i32) #1

define <16 x float> @test_mm512_mask_fmaddsub_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmaddsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmaddsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fmaddsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmaddsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmaddsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmaddsub_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmaddsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmaddsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fmsubadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_fmsubadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vpxord {{\.LCPI.*}}{1to16}, %zmm2, %zmm2
; X86-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_fmsubadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vpxord {{.*}}(%rip){1to16}, %zmm2, %zmm2
; X64-NEXT:    vfmaddsub213ps {rn-sae}, %zmm2, %zmm1, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask_fmsubadd_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmsubadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsubadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_fmsubadd_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmsubadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsubadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213ps {rn-sae}, %zmm2, %zmm1, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_fmaddsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fmaddsub_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmaddsub213ps {{.*#+}} zmm0 = (zmm1 * zmm0) +/- zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %1) #10
  %3 = shufflevector <16 x float> %2, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  ret <16 x float> %3
}

define <16 x float> @test_mm512_mask_fmaddsub_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %1) #10
  %3 = shufflevector <16 x float> %2, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x float> %3, <16 x float> %__A
  ret <16 x float> %5
}

define <16 x float> @test_mm512_mask3_fmaddsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) +/- zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) +/- zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %1) #10
  %3 = shufflevector <16 x float> %2, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x float> %3, <16 x float> %__C
  ret <16 x float> %5
}

define <16 x float> @test_mm512_maskz_fmaddsub_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmaddsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmaddsub213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) +/- zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmaddsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmaddsub213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) +/- zmm2
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %2 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %1) #10
  %3 = shufflevector <16 x float> %2, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x float> %3, <16 x float> zeroinitializer
  ret <16 x float> %5
}

define <16 x float> @test_mm512_fmsubadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; CHECK-LABEL: test_mm512_fmsubadd_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmsubadd213ps {{.*#+}} zmm0 = (zmm1 * zmm0) -/+ zmm2
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %2 = shufflevector <16 x float> %1, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_fmsubadd_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd132ps {{.*#+}} zmm0 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %2 = shufflevector <16 x float> %1, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x float> %2, <16 x float> %__A
  ret <16 x float> %4
}

define <16 x float> @test_mm512_maskz_fmsubadd_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_maskz_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) -/+ zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd213ps {{.*#+}} zmm0 {%k1} {z} = (zmm1 * zmm0) -/+ zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %2 = shufflevector <16 x float> %1, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x float> %2, <16 x float> zeroinitializer
  ret <16 x float> %4
}

define <8 x double> @test_mm512_mask3_fmsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fmsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) - zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) - zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <16 x float> @test_mm512_mask3_fmsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fmsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) - zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) - zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <8 x double> @test_mm512_mask3_fmsubadd_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsubadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsubadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmaddsub.pd.512(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fmsubadd_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsubadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsubadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231pd {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %sub.i) #10
  %1 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C) #10
  %2 = shufflevector <8 x double> %1, <8 x double> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  %3 = bitcast i8 %__U to <8 x i1>
  %4 = select <8 x i1> %3, <8 x double> %2, <8 x double> %__C
  ret <8 x double> %4
}

define <16 x float> @test_mm512_mask3_fmsubadd_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsubadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsubadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmaddsub.ps.512(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fmsubadd_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fmsubadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsubadd231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fmsubadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsubadd231ps {{.*#+}} zmm2 {%k1} = (zmm0 * zmm1) -/+ zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %sub.i) #10
  %1 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C) #10
  %2 = shufflevector <16 x float> %1, <16 x float> %0, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x float> %2, <16 x float> %__C
  ret <16 x float> %4
}

define <8 x double> @test_mm512_mask_fnmadd_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fnmadd_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmadd_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %sub, <8 x double> %__B, <8 x double> %__C, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask_fnmadd_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fnmadd_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132pd {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmadd_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132pd {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__A
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %sub.i, <8 x double> %__B, <8 x double> %__C) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <16 x float> @test_mm512_mask_fnmadd_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fnmadd_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmadd_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %sub, <16 x float> %__B, <16 x float> %__C, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_fnmadd_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fnmadd_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd132ps {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) + zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmadd_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd132ps {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) + zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__A
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %sub.i, <16 x float> %__B, <16 x float> %__C) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <8 x double> @test_mm512_mask_fnmsub_round_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fnmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132pd {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %sub, <8 x double> %sub1, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fnmsub_round_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmsub_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmsub_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231pd {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub1 = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.x86.avx512.vfmadd.pd.512(<8 x double> %__A, <8 x double> %sub, <8 x double> %sub1, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask_fnmsub_pd(<8 x double> %__A, i8 zeroext %__U, <8 x double> %__B, <8 x double> %__C) {
; X86-LABEL: test_mm512_mask_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132pd {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132pd {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub2.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %sub.i, <8 x double> %sub2.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__A
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask3_fnmsub_pd(<8 x double> %__A, <8 x double> %__B, <8 x double> %__C, i8 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmsub_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231pd {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    vmovapd %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmsub_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231pd {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    vmovapd %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__B
  %sub2.i = fsub <8 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %__C
  %0 = tail call <8 x double> @llvm.fma.v8f64(<8 x double> %__A, <8 x double> %sub.i, <8 x double> %sub2.i) #10
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__C
  ret <8 x double> %2
}

define <16 x float> @test_mm512_mask_fnmsub_round_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fnmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132ps {rn-sae}, %zmm1, %zmm2, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %sub, <16 x float> %sub1, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fnmsub_round_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmsub_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmsub_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ps {rn-sae}, %zmm1, %zmm0, %zmm2 {%k1}
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1 = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.x86.avx512.vfmadd.ps.512(<16 x float> %__A, <16 x float> %sub, <16 x float> %sub1, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_fnmsub_ps(<16 x float> %__A, i16 zeroext %__U, <16 x float> %__B, <16 x float> %__C) {
; X86-LABEL: test_mm512_mask_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub132ps {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub132ps {{.*#+}} zmm0 {%k1} = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %sub.i, <16 x float> %sub1.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__A
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask3_fnmsub_ps(<16 x float> %__A, <16 x float> %__B, <16 x float> %__C, i16 zeroext %__U) {
; X86-LABEL: test_mm512_mask3_fnmsub_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ps {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) - zmm2
; X86-NEXT:    vmovaps %zmm2, %zmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask3_fnmsub_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ps {{.*#+}} zmm2 {%k1} = -(zmm0 * zmm1) - zmm2
; X64-NEXT:    vmovaps %zmm2, %zmm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__B
  %sub1.i = fsub <16 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %__C
  %0 = tail call <16 x float> @llvm.fma.v16f32(<16 x float> %__A, <16 x float> %sub.i, <16 x float> %sub1.i) #10
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__C
  ret <16 x float> %2
}

define <4 x float> @test_mm_mask_fmadd_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ss {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ss {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__A, i64 0
  %2 = extractelement <4 x float> %__B, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__W, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask_fmadd_round_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__A, i64 0
  %2 = extractelement <4 x float> %__B, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %0
  %7 = insertelement <4 x float> %__W, float %6, i64 0
  ret <4 x float> %7
}

declare float @llvm.x86.avx512.vfmadd.f32(float, float, float, i32) #1

define <4 x float> @test_mm_maskz_fmadd_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ss {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ss {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %2 = extractelement <4 x float> %__C, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %3
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_fmadd_round_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %2 = extractelement <4 x float> %__C, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float 0.000000e+00
  %7 = insertelement <4 x float> %__A, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask3_fmadd_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ss {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ss {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__X, i64 0
  %2 = extractelement <4 x float> %__Y, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__Y, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__Y, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask3_fmadd_round_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__X, i64 0
  %2 = extractelement <4 x float> %__Y, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %2
  %7 = insertelement <4 x float> %__Y, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask_fmsub_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ss {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ss {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__A, i64 0
  %.rhs.i = extractelement <4 x float> %__B, i64 0
  %2 = fsub float -0.000000e+00, %.rhs.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__W, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask_fmsub_round_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__A, i64 0
  %.rhs = extractelement <4 x float> %__B, i64 0
  %2 = fsub float -0.000000e+00, %.rhs
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %0
  %7 = insertelement <4 x float> %__W, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_maskz_fmsub_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ss {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ss {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %.rhs.i = extractelement <4 x float> %__C, i64 0
  %2 = fsub float -0.000000e+00, %.rhs.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %3
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_fmsub_round_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %1 = extractelement <4 x float> %__B, i64 0
  %.rhs = extractelement <4 x float> %__C, i64 0
  %2 = fsub float -0.000000e+00, %.rhs
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float 0.000000e+00
  %7 = insertelement <4 x float> %__A, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask3_fmsub_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ss {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ss {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__X, i64 0
  %.rhs.i = extractelement <4 x float> %__Y, i64 0
  %2 = fsub float -0.000000e+00, %.rhs.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__Y, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__Y, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask3_fmsub_round_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %1 = extractelement <4 x float> %__X, i64 0
  %.rhs = extractelement <4 x float> %__Y, i64 0
  %2 = fsub float -0.000000e+00, %.rhs
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %.rhs
  %7 = insertelement <4 x float> %__Y, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask_fnmadd_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fnmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ss {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ss {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs.i = extractelement <4 x float> %__A, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %2 = extractelement <4 x float> %__B, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__W, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask_fnmadd_round_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fnmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs = extractelement <4 x float> %__A, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %2 = extractelement <4 x float> %__B, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %0
  %7 = insertelement <4 x float> %__W, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_maskz_fnmadd_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ss {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ss {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %.rhs.i = extractelement <4 x float> %__B, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %2 = extractelement <4 x float> %__C, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %3
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_fnmadd_round_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %.rhs = extractelement <4 x float> %__B, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %2 = extractelement <4 x float> %__C, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float 0.000000e+00
  %7 = insertelement <4 x float> %__A, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask3_fnmadd_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ss {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ss {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs.i = extractelement <4 x float> %__X, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %2 = extractelement <4 x float> %__Y, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <4 x float> %__Y, i32 0
  %cond.i = select i1 %tobool.i, float %vecext1.i, float %3
  %vecins.i = insertelement <4 x float> %__Y, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask3_fnmadd_round_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs = extractelement <4 x float> %__X, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %2 = extractelement <4 x float> %__Y, i64 0
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %2
  %7 = insertelement <4 x float> %__Y, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask_fnmsub_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fnmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ss {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ss {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs.i = extractelement <4 x float> %__A, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %.rhs7.i = extractelement <4 x float> %__B, i64 0
  %2 = fsub float -0.000000e+00, %.rhs7.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext2.i = extractelement <4 x float> %__W, i32 0
  %cond.i = select i1 %tobool.i, float %vecext2.i, float %3
  %vecins.i = insertelement <4 x float> %__W, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask_fnmsub_round_ss(<4 x float> %__W, i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B) {
; X86-LABEL: test_mm_mask_fnmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs = extractelement <4 x float> %__A, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %.rhs2 = extractelement <4 x float> %__B, i64 0
  %2 = fsub float -0.000000e+00, %.rhs2
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %0
  %7 = insertelement <4 x float> %__W, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_maskz_fnmsub_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ss {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ss {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %.rhs.i = extractelement <4 x float> %__B, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %.rhs5.i = extractelement <4 x float> %__C, i64 0
  %2 = fsub float -0.000000e+00, %.rhs5.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, float 0.000000e+00, float %3
  %vecins.i = insertelement <4 x float> %__A, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_maskz_fnmsub_round_ss(i8 zeroext %__U, <4 x float> %__A, <4 x float> %__B, <4 x float> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213ss {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__A, i64 0
  %.rhs = extractelement <4 x float> %__B, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %.rhs2 = extractelement <4 x float> %__C, i64 0
  %2 = fsub float -0.000000e+00, %.rhs2
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float 0.000000e+00
  %7 = insertelement <4 x float> %__A, float %6, i64 0
  ret <4 x float> %7
}

define <4 x float> @test_mm_mask3_fnmsub_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ss {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ss {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs.i = extractelement <4 x float> %__X, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %.rhs7.i = extractelement <4 x float> %__Y, i64 0
  %2 = fsub float -0.000000e+00, %.rhs7.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext2.i = extractelement <4 x float> %__Y, i32 0
  %cond.i = select i1 %tobool.i, float %vecext2.i, float %3
  %vecins.i = insertelement <4 x float> %__Y, float %cond.i, i32 0
  ret <4 x float> %vecins.i
}

define <4 x float> @test_mm_mask3_fnmsub_round_ss(<4 x float> %__W, <4 x float> %__X, <4 x float> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_round_ss:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovaps %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_round_ss:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231ss {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovaps %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <4 x float> %__W, i64 0
  %.rhs = extractelement <4 x float> %__X, i64 0
  %1 = fsub float -0.000000e+00, %.rhs
  %.rhs1 = extractelement <4 x float> %__Y, i64 0
  %2 = fsub float -0.000000e+00, %.rhs1
  %3 = tail call float @llvm.x86.avx512.vfmadd.f32(float %0, float %1, float %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, float %3, float %.rhs1
  %7 = insertelement <4 x float> %__Y, float %6, i64 0
  ret <4 x float> %7
}

define <2 x double> @test_mm_mask_fmadd_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213sd {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213sd {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__A, i64 0
  %2 = extractelement <2 x double> %__B, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__W, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask_fmadd_round_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__A, i64 0
  %2 = extractelement <2 x double> %__B, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %0
  %7 = insertelement <2 x double> %__W, double %6, i64 0
  ret <2 x double> %7
}

declare double @llvm.x86.avx512.vfmadd.f64(double, double, double, i32) #1

define <2 x double> @test_mm_maskz_fmadd_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213sd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213sd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %2 = extractelement <2 x double> %__C, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %3
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_fmadd_round_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %2 = extractelement <2 x double> %__C, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double 0.000000e+00
  %7 = insertelement <2 x double> %__A, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask3_fmadd_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231sd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231sd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__X, i64 0
  %2 = extractelement <2 x double> %__Y, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__Y, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__Y, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask3_fmadd_round_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmadd231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmadd231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__X, i64 0
  %2 = extractelement <2 x double> %__Y, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %2
  %7 = insertelement <2 x double> %__Y, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask_fmsub_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213sd {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213sd {{.*#+}} xmm0 {%k1} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__A, i64 0
  %.rhs.i = extractelement <2 x double> %__B, i64 0
  %2 = fsub double -0.000000e+00, %.rhs.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__W, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask_fmsub_round_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__A, i64 0
  %.rhs = extractelement <2 x double> %__B, i64 0
  %2 = fsub double -0.000000e+00, %.rhs
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %0
  %7 = insertelement <2 x double> %__W, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_maskz_fmsub_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213sd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213sd {{.*#+}} xmm0 {%k1} {z} = (xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %.rhs.i = extractelement <2 x double> %__C, i64 0
  %2 = fsub double -0.000000e+00, %.rhs.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %3
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_fmsub_round_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %1 = extractelement <2 x double> %__B, i64 0
  %.rhs = extractelement <2 x double> %__C, i64 0
  %2 = fsub double -0.000000e+00, %.rhs
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double 0.000000e+00
  %7 = insertelement <2 x double> %__A, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask3_fmsub_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231sd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231sd {{.*#+}} xmm2 {%k1} = (xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__X, i64 0
  %.rhs.i = extractelement <2 x double> %__Y, i64 0
  %2 = fsub double -0.000000e+00, %.rhs.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__Y, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__Y, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask3_fmsub_round_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfmsub231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfmsub231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %1 = extractelement <2 x double> %__X, i64 0
  %.rhs = extractelement <2 x double> %__Y, i64 0
  %2 = fsub double -0.000000e+00, %.rhs
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %.rhs
  %7 = insertelement <2 x double> %__Y, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask_fnmadd_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fnmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213sd {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213sd {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs.i = extractelement <2 x double> %__A, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %2 = extractelement <2 x double> %__B, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__W, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask_fnmadd_round_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fnmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs = extractelement <2 x double> %__A, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %2 = extractelement <2 x double> %__B, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %0
  %7 = insertelement <2 x double> %__W, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_maskz_fnmadd_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213sd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213sd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) + xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %.rhs.i = extractelement <2 x double> %__B, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %2 = extractelement <2 x double> %__C, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %3
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_fnmadd_round_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %.rhs = extractelement <2 x double> %__B, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %2 = extractelement <2 x double> %__C, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double 0.000000e+00
  %7 = insertelement <2 x double> %__A, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask3_fnmadd_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231sd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231sd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) + xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs.i = extractelement <2 x double> %__X, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %2 = extractelement <2 x double> %__Y, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext1.i = extractelement <2 x double> %__Y, i32 0
  %cond.i = select i1 %tobool.i, double %vecext1.i, double %3
  %vecins.i = insertelement <2 x double> %__Y, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask3_fnmadd_round_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmadd_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmadd231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmadd_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmadd231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs = extractelement <2 x double> %__X, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %2 = extractelement <2 x double> %__Y, i64 0
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %2
  %7 = insertelement <2 x double> %__Y, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask_fnmsub_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fnmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213sd {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213sd {{.*#+}} xmm0 {%k1} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs.i = extractelement <2 x double> %__A, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %.rhs7.i = extractelement <2 x double> %__B, i64 0
  %2 = fsub double -0.000000e+00, %.rhs7.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext2.i = extractelement <2 x double> %__W, i32 0
  %cond.i = select i1 %tobool.i, double %vecext2.i, double %3
  %vecins.i = insertelement <2 x double> %__W, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask_fnmsub_round_sd(<2 x double> %__W, i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B) {
; X86-LABEL: test_mm_mask_fnmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask_fnmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs = extractelement <2 x double> %__A, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %.rhs2 = extractelement <2 x double> %__B, i64 0
  %2 = fsub double -0.000000e+00, %.rhs2
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %0
  %7 = insertelement <2 x double> %__W, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_maskz_fnmsub_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213sd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213sd {{.*#+}} xmm0 {%k1} {z} = -(xmm1 * xmm0) - xmm2
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %.rhs.i = extractelement <2 x double> %__B, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %.rhs5.i = extractelement <2 x double> %__C, i64 0
  %2 = fsub double -0.000000e+00, %.rhs5.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %cond.i = select i1 %tobool.i, double 0.000000e+00, double %3
  %vecins.i = insertelement <2 x double> %__A, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_maskz_fnmsub_round_sd(i8 zeroext %__U, <2 x double> %__A, <2 x double> %__B, <2 x double> %__C) {
; X86-LABEL: test_mm_maskz_fnmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_maskz_fnmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub213sd {rn-sae}, %xmm2, %xmm1, %xmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__A, i64 0
  %.rhs = extractelement <2 x double> %__B, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %.rhs2 = extractelement <2 x double> %__C, i64 0
  %2 = fsub double -0.000000e+00, %.rhs2
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double 0.000000e+00
  %7 = insertelement <2 x double> %__A, double %6, i64 0
  ret <2 x double> %7
}

define <2 x double> @test_mm_mask3_fnmsub_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231sd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231sd {{.*#+}} xmm2 {%k1} = -(xmm0 * xmm1) - xmm2
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs.i = extractelement <2 x double> %__X, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %.rhs7.i = extractelement <2 x double> %__Y, i64 0
  %2 = fsub double -0.000000e+00, %.rhs7.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #10
  %4 = and i8 %__U, 1
  %tobool.i = icmp eq i8 %4, 0
  %vecext2.i = extractelement <2 x double> %__Y, i32 0
  %cond.i = select i1 %tobool.i, double %vecext2.i, double %3
  %vecins.i = insertelement <2 x double> %__Y, double %cond.i, i32 0
  ret <2 x double> %vecins.i
}

define <2 x double> @test_mm_mask3_fnmsub_round_sd(<2 x double> %__W, <2 x double> %__X, <2 x double> %__Y, i8 zeroext %__U) {
; X86-LABEL: test_mm_mask3_fnmsub_round_sd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vfnmsub231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X86-NEXT:    vmovapd %xmm2, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test_mm_mask3_fnmsub_round_sd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vfnmsub231sd {rn-sae}, %xmm1, %xmm0, %xmm2 {%k1}
; X64-NEXT:    vmovapd %xmm2, %xmm0
; X64-NEXT:    retq
entry:
  %0 = extractelement <2 x double> %__W, i64 0
  %.rhs = extractelement <2 x double> %__X, i64 0
  %1 = fsub double -0.000000e+00, %.rhs
  %.rhs1 = extractelement <2 x double> %__Y, i64 0
  %2 = fsub double -0.000000e+00, %.rhs1
  %3 = tail call double @llvm.x86.avx512.vfmadd.f64(double %0, double %1, double %2, i32 8)
  %4 = bitcast i8 %__U to <8 x i1>
  %5 = extractelement <8 x i1> %4, i64 0
  %6 = select i1 %5, double %3, double %.rhs1
  %7 = insertelement <2 x double> %__Y, double %6, i64 0
  ret <2 x double> %7
}

define <8 x i64> @test_mm512_mask_expandloadu_epi64(<8 x i64> %__W, i8 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_mask_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to i64*
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = tail call <8 x i64> @llvm.masked.expandload.v8i64(i64* %0, <8 x i1> %1, <8 x i64> %__W)
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_expandloadu_epi64(i8 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_maskz_expandloadu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandq (%eax), %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_expandloadu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandq (%rsi), %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to i64*
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = tail call <8 x i64> @llvm.masked.expandload.v8i64(i64* %0, <8 x i1> %1, <8 x i64> zeroinitializer)
  ret <8 x i64> %2
}

define <8 x double> @test_mm512_mask_expandloadu_pd(<8 x double> %__W, i8 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_mask_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to double*
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = tail call <8 x double> @llvm.masked.expandload.v8f64(double* %0, <8 x i1> %1, <8 x double> %__W)
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_expandloadu_pd(i8 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_maskz_expandloadu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandpd (%eax), %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_expandloadu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandpd (%rsi), %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to double*
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = tail call <8 x double> @llvm.masked.expandload.v8f64(double* %0, <8 x i1> %1, <8 x double> zeroinitializer)
  ret <8 x double> %2
}

define <8 x i64> @test_mm512_mask_expandloadu_epi32(<8 x i64> %__W, i16 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_mask_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i8* %__P to i32*
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = tail call <16 x i32> @llvm.masked.expandload.v16i32(i32* %1, <16 x i1> %2, <16 x i32> %0) #11
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_maskz_expandloadu_epi32(i16 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_maskz_expandloadu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vpexpandd (%eax), %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_expandloadu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpexpandd (%rsi), %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to i32*
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = tail call <16 x i32> @llvm.masked.expandload.v16i32(i32* %0, <16 x i1> %1, <16 x i32> zeroinitializer)
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <16 x float> @test_mm512_mask_expandloadu_ps(<16 x float> %__W, i16 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_mask_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to float*
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = tail call <16 x float> @llvm.masked.expandload.v16f32(float* %0, <16 x i1> %1, <16 x float> %__W) #11
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_expandloadu_ps(i16 zeroext %__U, i8* readonly %__P) {
; X86-LABEL: test_mm512_maskz_expandloadu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %ecx, %k1
; X86-NEXT:    vexpandps (%eax), %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_expandloadu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vexpandps (%rsi), %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to float*
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = tail call <16 x float> @llvm.masked.expandload.v16f32(float* %0, <16 x i1> %1, <16 x float> zeroinitializer)
  ret <16 x float> %2
}

define void @test_mm512_mask_compressstoreu_pd(i8* %__P, i8 zeroext %__U, <8 x double> %__A) {
; X86-LABEL: test_mm512_mask_compressstoreu_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompresspd %zmm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_compressstoreu_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to double*
  %1 = bitcast i8 %__U to <8 x i1>
  tail call void @llvm.masked.compressstore.v8f64(<8 x double> %__A, double* %0, <8 x i1> %1)
  ret void
}

define void @test_mm512_mask_compressstoreu_epi64(i8* %__P, i8 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_compressstoreu_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressq %zmm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_compressstoreu_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to i64*
  %1 = bitcast i8 %__U to <8 x i1>
  tail call void @llvm.masked.compressstore.v8i64(<8 x i64> %__A, i64* %0, <8 x i1> %1)
  ret void
}

define void @test_mm512_mask_compressstoreu_ps(i8* %__P, i16 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_mask_compressstoreu_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vcompressps %zmm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_compressstoreu_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8* %__P to float*
  %1 = bitcast i16 %__U to <16 x i1>
  tail call void @llvm.masked.compressstore.v16f32(<16 x float> %__A, float* %0, <16 x i1> %1)
  ret void
}

define void @test_mm512_mask_compressstoreu_epi32(i8* %__P, i16 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_compressstoreu_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpcompressd %zmm0, (%ecx) {%k1}
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_compressstoreu_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %esi, %k1
; X64-NEXT:    vpcompressd %zmm0, (%rdi) {%k1}
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast i8* %__P to i32*
  %2 = bitcast i16 %__U to <16 x i1>
  tail call void @llvm.masked.compressstore.v16i32(<16 x i32> %0, i32* %1, <16 x i1> %2)
  ret void
}

define i64 @test_mm512_reduce_add_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_add_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_add_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add.i = add <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %add.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %add.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %add4.i = add <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %add4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %add7.i = add <2 x i64> %shuffle6.i, %add4.i
  %vecext.i = extractelement <2 x i64> %add7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_reduce_mul_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_mul_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpsrlq $32, %ymm0, %ymm2
; X86-NEXT:    vpmuludq %ymm1, %ymm2, %ymm2
; X86-NEXT:    vpsrlq $32, %ymm1, %ymm3
; X86-NEXT:    vpmuludq %ymm3, %ymm0, %ymm3
; X86-NEXT:    vpaddq %ymm2, %ymm3, %ymm2
; X86-NEXT:    vpsllq $32, %ymm2, %ymm2
; X86-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; X86-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpsrlq $32, %xmm0, %xmm2
; X86-NEXT:    vpmuludq %xmm1, %xmm2, %xmm2
; X86-NEXT:    vpsrlq $32, %xmm1, %xmm3
; X86-NEXT:    vpmuludq %xmm3, %xmm0, %xmm3
; X86-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X86-NEXT:    vpsllq $32, %xmm2, %xmm2
; X86-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm0[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vpmuludq %xmm0, %xmm2, %xmm2
; X86-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X86-NEXT:    vpmuludq %xmm3, %xmm1, %xmm3
; X86-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X86-NEXT:    vpsllq $32, %xmm2, %xmm2
; X86-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_mul_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpsrlq $32, %ymm0, %ymm2
; X64-NEXT:    vpmuludq %ymm1, %ymm2, %ymm2
; X64-NEXT:    vpsrlq $32, %ymm1, %ymm3
; X64-NEXT:    vpmuludq %ymm3, %ymm0, %ymm3
; X64-NEXT:    vpaddq %ymm2, %ymm3, %ymm2
; X64-NEXT:    vpsllq $32, %ymm2, %ymm2
; X64-NEXT:    vpmuludq %ymm1, %ymm0, %ymm0
; X64-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpsrlq $32, %xmm0, %xmm2
; X64-NEXT:    vpmuludq %xmm1, %xmm2, %xmm2
; X64-NEXT:    vpsrlq $32, %xmm1, %xmm3
; X64-NEXT:    vpmuludq %xmm3, %xmm0, %xmm3
; X64-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X64-NEXT:    vpsllq $32, %xmm2, %xmm2
; X64-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm0[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X64-NEXT:    vpmuludq %xmm0, %xmm2, %xmm2
; X64-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-NEXT:    vpmuludq %xmm3, %xmm1, %xmm3
; X64-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X64-NEXT:    vpsllq $32, %xmm2, %xmm2
; X64-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul.i = mul <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %mul.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %mul.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %mul4.i = mul <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %mul4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %mul7.i = mul <2 x i64> %shuffle6.i, %mul4.i
  %vecext.i = extractelement <2 x i64> %mul7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_reduce_or_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_or_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_or_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %or.i = or <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %or.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %or.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %or4.i = or <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %or4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %or7.i = or <2 x i64> %shuffle6.i, %or4.i
  %vecext.i = extractelement <2 x i64> %or7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_reduce_and_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_and_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_and_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpand %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %and.i = and <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %and.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %and.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %and4.i = and <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %and4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %and7.i = and <2 x i64> %shuffle6.i, %and4.i
  %vecext.i = extractelement <2 x i64> %and7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_add_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_add_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_add_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> zeroinitializer
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add.i = add <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %add.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %add.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %add4.i = add <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %add4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %add7.i = add <2 x i64> %shuffle6.i, %add4.i
  %vecext.i = extractelement <2 x i64> %add7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_mul_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_mul_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0]
; X86-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpsrlq $32, %ymm1, %ymm2
; X86-NEXT:    vpmuludq %ymm0, %ymm2, %ymm2
; X86-NEXT:    vpsrlq $32, %ymm0, %ymm3
; X86-NEXT:    vpmuludq %ymm3, %ymm1, %ymm3
; X86-NEXT:    vpaddq %ymm2, %ymm3, %ymm2
; X86-NEXT:    vpsllq $32, %ymm2, %ymm2
; X86-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0
; X86-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpsrlq $32, %xmm0, %xmm2
; X86-NEXT:    vpmuludq %xmm1, %xmm2, %xmm2
; X86-NEXT:    vpsrlq $32, %xmm1, %xmm3
; X86-NEXT:    vpmuludq %xmm3, %xmm0, %xmm3
; X86-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X86-NEXT:    vpsllq $32, %xmm2, %xmm2
; X86-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm0[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X86-NEXT:    vpmuludq %xmm0, %xmm2, %xmm2
; X86-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X86-NEXT:    vpmuludq %xmm3, %xmm1, %xmm3
; X86-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X86-NEXT:    vpsllq $32, %xmm2, %xmm2
; X86-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_mul_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1]
; X64-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpsrlq $32, %ymm1, %ymm2
; X64-NEXT:    vpmuludq %ymm0, %ymm2, %ymm2
; X64-NEXT:    vpsrlq $32, %ymm0, %ymm3
; X64-NEXT:    vpmuludq %ymm3, %ymm1, %ymm3
; X64-NEXT:    vpaddq %ymm2, %ymm3, %ymm2
; X64-NEXT:    vpsllq $32, %ymm2, %ymm2
; X64-NEXT:    vpmuludq %ymm0, %ymm1, %ymm0
; X64-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpsrlq $32, %xmm0, %xmm2
; X64-NEXT:    vpmuludq %xmm1, %xmm2, %xmm2
; X64-NEXT:    vpsrlq $32, %xmm1, %xmm3
; X64-NEXT:    vpmuludq %xmm3, %xmm0, %xmm3
; X64-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X64-NEXT:    vpsllq $32, %xmm2, %xmm2
; X64-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm0[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X64-NEXT:    vpmuludq %xmm0, %xmm2, %xmm2
; X64-NEXT:    vpsrlq $32, %xmm0, %xmm3
; X64-NEXT:    vpmuludq %xmm3, %xmm1, %xmm3
; X64-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; X64-NEXT:    vpsllq $32, %xmm2, %xmm2
; X64-NEXT:    vpmuludq %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul.i = mul <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %mul.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %mul.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %mul4.i = mul <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %mul4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %mul7.i = mul <2 x i64> %shuffle6.i, %mul4.i
  %vecext.i = extractelement <2 x i64> %mul7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_and_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_and_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X86-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_and_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X64-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> <i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1>
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %and.i = and <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %and.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %and.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %and4.i = and <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %and4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %and7.i = and <2 x i64> %shuffle6.i, %and4.i
  %vecext.i = extractelement <2 x i64> %and7.i, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_or_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_or_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_or_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> zeroinitializer
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %or.i = or <4 x i64> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x i64> %or.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x i64> %or.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %or4.i = or <2 x i64> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x i64> %or4.i, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %or7.i = or <2 x i64> %shuffle6.i, %or4.i
  %vecext.i = extractelement <2 x i64> %or7.i, i32 0
  ret i64 %vecext.i
}

define i32 @test_mm512_reduce_add_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_add_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; CHECK-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %add.i = add <8 x i32> %0, %1
  %2 = bitcast <8 x i32> %add.i to <4 x i64>
  %extract3.i = shufflevector <4 x i64> %2, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %3 = bitcast <2 x i64> %extract3.i to <4 x i32>
  %extract4.i = shufflevector <4 x i64> %2, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %4 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %add5.i = add <4 x i32> %3, %4
  %shuffle.i = shufflevector <4 x i32> %add5.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %add6.i = add <4 x i32> %shuffle.i, %add5.i
  %shuffle7.i = shufflevector <4 x i32> %add6.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %add8.i = add <4 x i32> %shuffle7.i, %add6.i
  %vecext.i = extractelement <4 x i32> %add8.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_reduce_mul_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_mul_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; CHECK-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %mul.i = mul <8 x i32> %0, %1
  %2 = bitcast <8 x i32> %mul.i to <4 x i64>
  %extract3.i = shufflevector <4 x i64> %2, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %3 = bitcast <2 x i64> %extract3.i to <4 x i32>
  %extract4.i = shufflevector <4 x i64> %2, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %4 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %mul5.i = mul <4 x i32> %3, %4
  %shuffle.i = shufflevector <4 x i32> %mul5.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %mul6.i = mul <4 x i32> %shuffle.i, %mul5.i
  %shuffle7.i = shufflevector <4 x i32> %mul6.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %mul8.i = mul <4 x i32> %shuffle7.i, %mul6.i
  %vecext.i = extractelement <4 x i32> %mul8.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_reduce_or_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_or_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpor %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpor %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpor %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; CHECK-NEXT:    vpor %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %or25.i = or <4 x i64> %extract.i, %extract2.i
  %extract3.i = shufflevector <4 x i64> %or25.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract4.i = shufflevector <4 x i64> %or25.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %or526.i = or <2 x i64> %extract3.i, %extract4.i
  %or5.i = bitcast <2 x i64> %or526.i to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %or5.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %or6.i = or <4 x i32> %shuffle.i, %or5.i
  %shuffle7.i = shufflevector <4 x i32> %or6.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %or8.i = or <4 x i32> %shuffle7.i, %or6.i
  %vecext.i = extractelement <4 x i32> %or8.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_reduce_and_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_and_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpand %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpand %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpand %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; CHECK-NEXT:    vpand %xmm0, %xmm1, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %and25.i = and <4 x i64> %extract.i, %extract2.i
  %extract3.i = shufflevector <4 x i64> %and25.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract4.i = shufflevector <4 x i64> %and25.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %and526.i = and <2 x i64> %extract3.i, %extract4.i
  %and5.i = bitcast <2 x i64> %and526.i to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %and5.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %and6.i = and <4 x i32> %shuffle.i, %and5.i
  %shuffle7.i = shufflevector <4 x i32> %and6.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %and8.i = and <4 x i32> %shuffle7.i, %and6.i
  %vecext.i = extractelement <4 x i32> %and8.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_add_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_add_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X86-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_add_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X64-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> zeroinitializer
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %extract3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <4 x i64> %extract3.i to <8 x i32>
  %add.i = add <8 x i32> %4, %5
  %6 = bitcast <8 x i32> %add.i to <4 x i64>
  %extract4.i = shufflevector <4 x i64> %6, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %7 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %extract5.i = shufflevector <4 x i64> %6, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %8 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %add6.i = add <4 x i32> %7, %8
  %shuffle.i = shufflevector <4 x i32> %add6.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %add7.i = add <4 x i32> %shuffle.i, %add6.i
  %shuffle8.i = shufflevector <4 x i32> %add7.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %add9.i = add <4 x i32> %shuffle8.i, %add7.i
  %vecext.i = extractelement <4 x i32> %add9.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_mul_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_mul_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; X86-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpmulld %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X86-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_mul_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; X64-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpmulld %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X64-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %extract4.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %5 = bitcast <4 x i64> %extract4.i to <8 x i32>
  %mul.i = mul <8 x i32> %4, %5
  %6 = bitcast <8 x i32> %mul.i to <4 x i64>
  %extract5.i = shufflevector <4 x i64> %6, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %7 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %extract6.i = shufflevector <4 x i64> %6, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %8 = bitcast <2 x i64> %extract6.i to <4 x i32>
  %mul7.i = mul <4 x i32> %7, %8
  %shuffle.i = shufflevector <4 x i32> %mul7.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %mul8.i = mul <4 x i32> %shuffle.i, %mul7.i
  %shuffle9.i = shufflevector <4 x i32> %mul8.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %mul10.i = mul <4 x i32> %shuffle9.i, %mul8.i
  %vecext.i = extractelement <4 x i32> %mul10.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_and_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_and_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X86-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X86-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_and_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X64-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpand %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpand %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X64-NEXT:    vpand %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %and28.i = and <4 x i64> %extract.i, %extract4.i
  %extract5.i = shufflevector <4 x i64> %and28.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract6.i = shufflevector <4 x i64> %and28.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %and729.i = and <2 x i64> %extract5.i, %extract6.i
  %and7.i = bitcast <2 x i64> %and729.i to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %and7.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %and8.i = and <4 x i32> %shuffle.i, %and7.i
  %shuffle9.i = shufflevector <4 x i32> %and8.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %and10.i = and <4 x i32> %shuffle9.i, %and8.i
  %vecext.i = extractelement <4 x i32> %and10.i, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_or_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_or_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X86-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_or_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpor %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpor %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,2,3]
; X64-NEXT:    vpor %xmm0, %xmm1, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> zeroinitializer
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %or27.i = or <4 x i64> %extract.i, %extract3.i
  %extract4.i = shufflevector <4 x i64> %or27.i, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x i64> %or27.i, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %or628.i = or <2 x i64> %extract4.i, %extract5.i
  %or6.i = bitcast <2 x i64> %or628.i to <4 x i32>
  %shuffle.i = shufflevector <4 x i32> %or6.i, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %or7.i = or <4 x i32> %shuffle.i, %or6.i
  %shuffle8.i = shufflevector <4 x i32> %or7.i, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %or9.i = or <4 x i32> %shuffle8.i, %or7.i
  %vecext.i = extractelement <4 x i32> %or9.i, i32 0
  ret i32 %vecext.i
}

define double @test_mm512_reduce_add_pd(<8 x double> %__W) {
; X86-LABEL: test_mm512_reduce_add_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_add_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add.i = fadd <4 x double> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x double> %add.i, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x double> %add.i, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %add4.i = fadd <2 x double> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x double> %add4.i, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %add7.i = fadd <2 x double> %add4.i, %shuffle6.i
  %vecext.i = extractelement <2 x double> %add7.i, i32 0
  ret double %vecext.i
}

define double @test_mm512_reduce_mul_pd(<8 x double> %__W) {
; X86-LABEL: test_mm512_reduce_mul_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vmulpd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmulpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_mul_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vmulpd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmulpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul.i = fmul <4 x double> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x double> %mul.i, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x double> %mul.i, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %mul4.i = fmul <2 x double> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x double> %mul4.i, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %mul7.i = fmul <2 x double> %mul4.i, %shuffle6.i
  %vecext.i = extractelement <2 x double> %mul7.i, i32 0
  ret double %vecext.i
}

define float @test_mm512_reduce_add_ps(<16 x float> %__W) {
; X86-LABEL: test_mm512_reduce_add_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_add_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <16 x float> %__W to <8 x double>
  %extract.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = bitcast <4 x double> %extract.i to <8 x float>
  %extract2.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <4 x double> %extract2.i to <8 x float>
  %add.i = fadd <8 x float> %1, %2
  %extract3.i = shufflevector <8 x float> %add.i, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x float> %add.i, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add5.i = fadd <4 x float> %extract3.i, %extract4.i
  %shuffle.i = shufflevector <4 x float> %add5.i, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %add6.i = fadd <4 x float> %add5.i, %shuffle.i
  %shuffle7.i = shufflevector <4 x float> %add6.i, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %add8.i = fadd <4 x float> %add6.i, %shuffle7.i
  %vecext.i = extractelement <4 x float> %add8.i, i32 0
  ret float %vecext.i
}

define float @test_mm512_reduce_mul_ps(<16 x float> %__W) {
; X86-LABEL: test_mm512_reduce_mul_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_mul_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <16 x float> %__W to <8 x double>
  %extract.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = bitcast <4 x double> %extract.i to <8 x float>
  %extract2.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <4 x double> %extract2.i to <8 x float>
  %mul.i = fmul <8 x float> %1, %2
  %extract3.i = shufflevector <8 x float> %mul.i, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x float> %mul.i, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul5.i = fmul <4 x float> %extract3.i, %extract4.i
  %shuffle.i = shufflevector <4 x float> %mul5.i, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %mul6.i = fmul <4 x float> %mul5.i, %shuffle.i
  %shuffle7.i = shufflevector <4 x float> %mul6.i, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %mul8.i = fmul <4 x float> %mul6.i, %shuffle7.i
  %vecext.i = extractelement <4 x float> %mul8.i, i32 0
  ret float %vecext.i
}

define double @test_mm512_mask_reduce_add_pd(i8 zeroext %__M, <8 x double> %__W) {
; X86-LABEL: test_mm512_mask_reduce_add_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movb 8(%ebp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_add_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vaddpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %__W, <8 x double> zeroinitializer
  %shuffle.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add.i = fadd <4 x double> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x double> %add.i, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x double> %add.i, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %add4.i = fadd <2 x double> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x double> %add4.i, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %add7.i = fadd <2 x double> %add4.i, %shuffle6.i
  %vecext.i = extractelement <2 x double> %add7.i, i32 0
  ret double %vecext.i
}

define double @test_mm512_mask_reduce_mul_pd(i8 zeroext %__M, <8 x double> %__W) {
; X86-LABEL: test_mm512_mask_reduce_mul_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movb 8(%ebp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; X86-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vmulpd %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmulpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_mul_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; X64-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vmulpd %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmulpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %__W, <8 x double> <double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00, double 1.000000e+00>
  %shuffle.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %shuffle1.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul.i = fmul <4 x double> %shuffle.i, %shuffle1.i
  %shuffle2.i = shufflevector <4 x double> %mul.i, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %shuffle3.i = shufflevector <4 x double> %mul.i, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %mul4.i = fmul <2 x double> %shuffle2.i, %shuffle3.i
  %shuffle6.i = shufflevector <2 x double> %mul4.i, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %mul7.i = fmul <2 x double> %mul4.i, %shuffle6.i
  %vecext.i = extractelement <2 x double> %mul7.i, i32 0
  ret double %vecext.i
}

define float @test_mm512_mask_reduce_add_ps(i16 zeroext %__M, <16 x float> %__W) {
; X86-LABEL: test_mm512_mask_reduce_add_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovaps %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_add_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovaps %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vaddps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i16 %__M to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %__W, <16 x float> zeroinitializer
  %2 = bitcast <16 x float> %1 to <8 x double>
  %extract.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x double> %extract.i to <8 x float>
  %extract3.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x double> %extract3.i to <8 x float>
  %add.i = fadd <8 x float> %3, %4
  %extract4.i = shufflevector <8 x float> %add.i, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract5.i = shufflevector <8 x float> %add.i, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %add6.i = fadd <4 x float> %extract4.i, %extract5.i
  %shuffle.i = shufflevector <4 x float> %add6.i, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %add7.i = fadd <4 x float> %add6.i, %shuffle.i
  %shuffle8.i = shufflevector <4 x float> %add7.i, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %add9.i = fadd <4 x float> %add7.i, %shuffle8.i
  %vecext.i = extractelement <4 x float> %add9.i, i32 0
  ret float %vecext.i
}

define float @test_mm512_mask_reduce_mul_ps(i16 zeroext %__M, <16 x float> %__W) {
; X86-LABEL: test_mm512_mask_reduce_mul_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss {{.*#+}} zmm1 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; X86-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_mul_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss {{.*#+}} zmm1 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; X64-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i16 %__M to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %__W, <16 x float> <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 1.000000e+00>
  %2 = bitcast <16 x float> %1 to <8 x double>
  %extract.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x double> %extract.i to <8 x float>
  %extract4.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x double> %extract4.i to <8 x float>
  %mul.i = fmul <8 x float> %3, %4
  %extract5.i = shufflevector <8 x float> %mul.i, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract6.i = shufflevector <8 x float> %mul.i, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %mul7.i = fmul <4 x float> %extract5.i, %extract6.i
  %shuffle.i = shufflevector <4 x float> %mul7.i, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %mul8.i = fmul <4 x float> %mul7.i, %shuffle.i
  %shuffle9.i = shufflevector <4 x float> %mul8.i, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %mul10.i = fmul <4 x float> %mul8.i, %shuffle9.i
  %vecext.i = extractelement <4 x float> %mul10.i, i32 0
  ret float %vecext.i
}

define i64 @test_mm512_reduce_max_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_max_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_max_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %0 = icmp slt <8 x i64> %shuffle.i, %__W
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> %shuffle.i
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %2 = icmp sgt <8 x i64> %1, %shuffle1.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle1.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %4 = icmp sgt <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %vecext.i = extractelement <8 x i64> %5, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_reduce_max_epu64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_max_epu64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpmaxuq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_max_epu64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpmaxuq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %0 = icmp ult <8 x i64> %shuffle.i, %__W
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> %shuffle.i
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %2 = icmp ugt <8 x i64> %1, %shuffle1.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle1.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %4 = icmp ugt <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %vecext.i = extractelement <8 x i64> %5, i32 0
  ret i64 %vecext.i
}

define double @test_mm512_reduce_max_pd(<8 x double> %__W) {
; X86-LABEL: test_mm512_reduce_max_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_max_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %extract.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = tail call <4 x double> @llvm.x86.avx.max.pd.256(<4 x double> %extract.i, <4 x double> %extract2.i)
  %extract4.i = shufflevector <4 x double> %0, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x double> %0, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %1 = tail call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %extract4.i, <2 x double> %extract5.i)
  %shuffle.i = shufflevector <2 x double> %1, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %2 = tail call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %1, <2 x double> %shuffle.i)
  %vecext.i = extractelement <2 x double> %2, i32 0
  ret double %vecext.i
}

define i64 @test_mm512_reduce_min_epi64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_min_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpminsq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_min_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpminsq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %0 = icmp sgt <8 x i64> %shuffle.i, %__W
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> %shuffle.i
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %2 = icmp slt <8 x i64> %1, %shuffle1.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle1.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %4 = icmp slt <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %vecext.i = extractelement <8 x i64> %5, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_reduce_min_epu64(<8 x i64> %__W) {
; X86-LABEL: test_mm512_reduce_min_epu64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpminuq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_min_epu64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpminuq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %shuffle.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %0 = icmp ugt <8 x i64> %shuffle.i, %__W
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> %shuffle.i
  %shuffle1.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %2 = icmp ult <8 x i64> %1, %shuffle1.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle1.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %4 = icmp ult <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %vecext.i = extractelement <8 x i64> %5, i32 0
  ret i64 %vecext.i
}

define double @test_mm512_reduce_min_pd(<8 x double> %__W) {
; X86-LABEL: test_mm512_reduce_min_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vminpd %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_min_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vminpd %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %extract.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x double> %__W, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = tail call <4 x double> @llvm.x86.avx.min.pd.256(<4 x double> %extract.i, <4 x double> %extract2.i)
  %extract4.i = shufflevector <4 x double> %0, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x double> %0, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %1 = tail call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %extract4.i, <2 x double> %extract5.i)
  %shuffle.i = shufflevector <2 x double> %1, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %2 = tail call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %1, <2 x double> %shuffle.i)
  %vecext.i = extractelement <2 x double> %2, i32 0
  ret double %vecext.i
}

define i64 @test_mm512_mask_reduce_max_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,2147483648,0,2147483648,0,2147483648,0,2147483648,0,2147483648,0,2147483648,0,2147483648,0,2147483648]
; X86-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; X64-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> <i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808, i64 -9223372036854775808>
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %2 = icmp sgt <8 x i64> %1, %shuffle.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %4 = icmp sgt <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %shuffle5.i = shufflevector <8 x i64> %5, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %6 = icmp sgt <8 x i64> %5, %shuffle5.i
  %7 = select <8 x i1> %6, <8 x i64> %5, <8 x i64> %shuffle5.i
  %vecext.i = extractelement <8 x i64> %7, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_max_epu64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_epu64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_epu64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa64 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm0[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> zeroinitializer
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %2 = icmp ugt <8 x i64> %1, %shuffle.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle.i
  %shuffle2.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %4 = icmp ugt <8 x i64> %3, %shuffle2.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle2.i
  %shuffle4.i = shufflevector <8 x i64> %5, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %6 = icmp ugt <8 x i64> %5, %shuffle4.i
  %7 = select <8 x i1> %6, <8 x i64> %5, <8 x i64> %shuffle4.i
  %vecext.i = extractelement <8 x i64> %7, i32 0
  ret i64 %vecext.i
}

define double @test_mm512_mask_reduce_max_pd(i8 zeroext %__M, <8 x double> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movb 8(%ebp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf]
; X86-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vmaxpd %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf]
; X64-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vmaxpd %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %__W, <8 x double> <double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000, double 0xFFF0000000000000>
  %extract.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = tail call <4 x double> @llvm.x86.avx.max.pd.256(<4 x double> %extract.i, <4 x double> %extract4.i) #3
  %extract6.i = shufflevector <4 x double> %2, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %extract7.i = shufflevector <4 x double> %2, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %3 = tail call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %extract6.i, <2 x double> %extract7.i) #3
  %shuffle.i = shufflevector <2 x double> %3, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %4 = tail call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %3, <2 x double> %shuffle.i) #3
  %vecext.i = extractelement <2 x double> %4, i32 0
  ret double %vecext.i
}

define i64 @test_mm512_mask_reduce_min_epi64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [4294967295,2147483647,4294967295,2147483647,4294967295,2147483647,4294967295,2147483647,4294967295,2147483647,4294967295,2147483647,4294967295,2147483647,4294967295,2147483647]
; X86-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpminsq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; X64-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpminsq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> <i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807, i64 9223372036854775807>
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %2 = icmp slt <8 x i64> %1, %shuffle.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %4 = icmp slt <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %shuffle5.i = shufflevector <8 x i64> %5, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %6 = icmp slt <8 x i64> %5, %shuffle5.i
  %7 = select <8 x i1> %6, <8 x i64> %5, <8 x i64> %shuffle5.i
  %vecext.i = extractelement <8 x i64> %7, i32 0
  ret i64 %vecext.i
}

define i64 @test_mm512_mask_reduce_min_epu64(i8 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_epu64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X86-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X86-NEXT:    vpminuq %zmm0, %zmm1, %zmm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vpextrd $1, %xmm0, %edx
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_epu64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X64-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm1[4,5,6,7,0,1,2,3]
; X64-NEXT:    vpminuq %zmm0, %zmm1, %zmm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; X64-NEXT:    vmovq %xmm0, %rax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x i64> %__W, <8 x i64> <i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1>
  %shuffle.i = shufflevector <8 x i64> %1, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3>
  %2 = icmp ult <8 x i64> %1, %shuffle.i
  %3 = select <8 x i1> %2, <8 x i64> %1, <8 x i64> %shuffle.i
  %shuffle3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5>
  %4 = icmp ult <8 x i64> %3, %shuffle3.i
  %5 = select <8 x i1> %4, <8 x i64> %3, <8 x i64> %shuffle3.i
  %shuffle5.i = shufflevector <8 x i64> %5, <8 x i64> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  %6 = icmp ult <8 x i64> %5, %shuffle5.i
  %7 = select <8 x i1> %6, <8 x i64> %5, <8 x i64> %shuffle5.i
  %vecext.i = extractelement <8 x i64> %7, i32 0
  ret i64 %vecext.i
}

define double @test_mm512_mask_reduce_min_pd(i8 zeroext %__M, <8 x double> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %ebp, -8
; X86-NEXT:    movl %esp, %ebp
; X86-NEXT:    .cfi_def_cfa_register %ebp
; X86-NEXT:    andl $-8, %esp
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    movb 8(%ebp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf]
; X86-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vminpd %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovsd %xmm0, (%esp)
; X86-NEXT:    fldl (%esp)
; X86-NEXT:    movl %ebp, %esp
; X86-NEXT:    popl %ebp
; X86-NEXT:    .cfi_def_cfa %esp, 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastsd {{.*#+}} zmm1 = [+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf]
; X64-NEXT:    vmovapd %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vminpd %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i8 %__M to <8 x i1>
  %1 = select <8 x i1> %0, <8 x double> %__W, <8 x double> <double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000, double 0x7FF0000000000000>
  %extract.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x double> %1, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = tail call <4 x double> @llvm.x86.avx.min.pd.256(<4 x double> %extract.i, <4 x double> %extract4.i)
  %extract6.i = shufflevector <4 x double> %2, <4 x double> undef, <2 x i32> <i32 0, i32 1>
  %extract7.i = shufflevector <4 x double> %2, <4 x double> undef, <2 x i32> <i32 2, i32 3>
  %3 = tail call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %extract6.i, <2 x double> %extract7.i)
  %shuffle.i = shufflevector <2 x double> %3, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  %4 = tail call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %3, <2 x double> %shuffle.i)
  %vecext.i = extractelement <2 x double> %4, i32 0
  ret double %vecext.i
}

define i32 @test_mm512_reduce_max_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_max_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %2 = icmp sgt <8 x i32> %0, %1
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  %extract4.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %5 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %6 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %7 = icmp sgt <4 x i32> %5, %6
  %8 = select <4 x i1> %7, <4 x i32> %5, <4 x i32> %6
  %shuffle.i = shufflevector <4 x i32> %8, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %9 = icmp sgt <4 x i32> %8, %shuffle.i
  %10 = select <4 x i1> %9, <4 x i32> %8, <4 x i32> %shuffle.i
  %shuffle8.i = shufflevector <4 x i32> %10, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %11 = icmp sgt <4 x i32> %10, %shuffle8.i
  %12 = select <4 x i1> %11, <4 x i32> %10, <4 x i32> %shuffle8.i
  %vecext.i = extractelement <4 x i32> %12, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_reduce_max_epu32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_max_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %2 = icmp ugt <8 x i32> %0, %1
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  %extract4.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %5 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %6 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %7 = icmp ugt <4 x i32> %5, %6
  %8 = select <4 x i1> %7, <4 x i32> %5, <4 x i32> %6
  %shuffle.i = shufflevector <4 x i32> %8, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %9 = icmp ugt <4 x i32> %8, %shuffle.i
  %10 = select <4 x i1> %9, <4 x i32> %8, <4 x i32> %shuffle.i
  %shuffle8.i = shufflevector <4 x i32> %10, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %11 = icmp ugt <4 x i32> %10, %shuffle8.i
  %12 = select <4 x i1> %11, <4 x i32> %10, <4 x i32> %shuffle8.i
  %vecext.i = extractelement <4 x i32> %12, i32 0
  ret i32 %vecext.i
}

define float @test_mm512_reduce_max_ps(<16 x float> %__W) {
; X86-LABEL: test_mm512_reduce_max_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_max_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <16 x float> %__W to <8 x double>
  %extract.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = bitcast <4 x double> %extract.i to <8 x float>
  %extract2.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <4 x double> %extract2.i to <8 x float>
  %3 = tail call <8 x float> @llvm.x86.avx.max.ps.256(<8 x float> %1, <8 x float> %2)
  %extract4.i = shufflevector <8 x float> %3, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract5.i = shufflevector <8 x float> %3, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %extract4.i, <4 x float> %extract5.i)
  %shuffle.i = shufflevector <4 x float> %4, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %5 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %4, <4 x float> %shuffle.i)
  %shuffle8.i = shufflevector <4 x float> %5, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %6 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %5, <4 x float> %shuffle8.i)
  %vecext.i = extractelement <4 x float> %6, i32 0
  ret float %vecext.i
}

define i32 @test_mm512_reduce_min_epi32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_min_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpminsd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %2 = icmp slt <8 x i32> %0, %1
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  %extract4.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %5 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %6 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %7 = icmp slt <4 x i32> %5, %6
  %8 = select <4 x i1> %7, <4 x i32> %5, <4 x i32> %6
  %shuffle.i = shufflevector <4 x i32> %8, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %9 = icmp slt <4 x i32> %8, %shuffle.i
  %10 = select <4 x i1> %9, <4 x i32> %8, <4 x i32> %shuffle.i
  %shuffle8.i = shufflevector <4 x i32> %10, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %11 = icmp slt <4 x i32> %10, %shuffle8.i
  %12 = select <4 x i1> %11, <4 x i32> %10, <4 x i32> %shuffle8.i
  %vecext.i = extractelement <4 x i32> %12, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_reduce_min_epu32(<8 x i64> %__W) {
; CHECK-LABEL: test_mm512_reduce_min_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; CHECK-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vextracti128 $1, %ymm0, %xmm1
; CHECK-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; CHECK-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; CHECK-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    vmovd %xmm0, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %extract.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract2.i = shufflevector <8 x i64> %__W, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %0 = bitcast <4 x i64> %extract.i to <8 x i32>
  %1 = bitcast <4 x i64> %extract2.i to <8 x i32>
  %2 = icmp ult <8 x i32> %0, %1
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  %extract4.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract5.i = shufflevector <4 x i64> %4, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %5 = bitcast <2 x i64> %extract4.i to <4 x i32>
  %6 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %7 = icmp ult <4 x i32> %5, %6
  %8 = select <4 x i1> %7, <4 x i32> %5, <4 x i32> %6
  %shuffle.i = shufflevector <4 x i32> %8, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %9 = icmp ult <4 x i32> %8, %shuffle.i
  %10 = select <4 x i1> %9, <4 x i32> %8, <4 x i32> %shuffle.i
  %shuffle8.i = shufflevector <4 x i32> %10, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %11 = icmp ult <4 x i32> %10, %shuffle8.i
  %12 = select <4 x i1> %11, <4 x i32> %10, <4 x i32> %shuffle8.i
  %vecext.i = extractelement <4 x i32> %12, i32 0
  ret i32 %vecext.i
}

define float @test_mm512_reduce_min_ps(<16 x float> %__W) {
; X86-LABEL: test_mm512_reduce_min_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vminps %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vminss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_reduce_min_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vminps %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vminss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <16 x float> %__W to <8 x double>
  %extract.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %1 = bitcast <4 x double> %extract.i to <8 x float>
  %extract2.i = shufflevector <8 x double> %0, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %2 = bitcast <4 x double> %extract2.i to <8 x float>
  %3 = tail call <8 x float> @llvm.x86.avx.min.ps.256(<8 x float> %1, <8 x float> %2)
  %extract4.i = shufflevector <8 x float> %3, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract5.i = shufflevector <8 x float> %3, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %extract4.i, <4 x float> %extract5.i)
  %shuffle.i = shufflevector <4 x float> %4, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %5 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %4, <4 x float> %shuffle.i)
  %shuffle8.i = shufflevector <4 x float> %5, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %6 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %5, <4 x float> %shuffle8.i)
  %vecext.i = extractelement <4 x float> %6, i32 0
  ret float %vecext.i
}

define i32 @test_mm512_mask_reduce_max_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; X86-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648,2147483648]
; X64-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> <i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648, i32 -2147483648>
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %5 = bitcast <4 x i64> %extract4.i to <8 x i32>
  %6 = icmp sgt <8 x i32> %4, %5
  %7 = select <8 x i1> %6, <8 x i32> %4, <8 x i32> %5
  %8 = bitcast <8 x i32> %7 to <4 x i64>
  %extract6.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract7.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %9 = bitcast <2 x i64> %extract6.i to <4 x i32>
  %10 = bitcast <2 x i64> %extract7.i to <4 x i32>
  %11 = icmp sgt <4 x i32> %9, %10
  %12 = select <4 x i1> %11, <4 x i32> %9, <4 x i32> %10
  %shuffle.i = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %13 = icmp sgt <4 x i32> %12, %shuffle.i
  %14 = select <4 x i1> %13, <4 x i32> %12, <4 x i32> %shuffle.i
  %shuffle10.i = shufflevector <4 x i32> %14, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %15 = icmp sgt <4 x i32> %14, %shuffle10.i
  %16 = select <4 x i1> %15, <4 x i32> %14, <4 x i32> %shuffle10.i
  %vecext.i = extractelement <4 x i32> %16, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_max_epu32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X86-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmovdqa32 %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> zeroinitializer
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract3.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %5 = bitcast <4 x i64> %extract3.i to <8 x i32>
  %6 = icmp ugt <8 x i32> %4, %5
  %7 = select <8 x i1> %6, <8 x i32> %4, <8 x i32> %5
  %8 = bitcast <8 x i32> %7 to <4 x i64>
  %extract5.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract6.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %9 = bitcast <2 x i64> %extract5.i to <4 x i32>
  %10 = bitcast <2 x i64> %extract6.i to <4 x i32>
  %11 = icmp ugt <4 x i32> %9, %10
  %12 = select <4 x i1> %11, <4 x i32> %9, <4 x i32> %10
  %shuffle.i = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %13 = icmp ugt <4 x i32> %12, %shuffle.i
  %14 = select <4 x i1> %13, <4 x i32> %12, <4 x i32> %shuffle.i
  %shuffle9.i = shufflevector <4 x i32> %14, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %15 = icmp ugt <4 x i32> %14, %shuffle9.i
  %16 = select <4 x i1> %15, <4 x i32> %14, <4 x i32> %shuffle9.i
  %vecext.i = extractelement <4 x i32> %16, i32 0
  ret i32 %vecext.i
}

define float @test_mm512_mask_reduce_max_ps(i16 zeroext %__M, <16 x float> %__W) {
; X86-LABEL: test_mm512_mask_reduce_max_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss {{.*#+}} zmm1 = [-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf]
; X86-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vmaxps %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_max_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss {{.*#+}} zmm1 = [-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf,-Inf]
; X64-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vmaxps %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i16 %__M to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %__W, <16 x float> <float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000, float 0xFFF0000000000000>
  %2 = bitcast <16 x float> %1 to <8 x double>
  %extract.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x double> %extract.i to <8 x float>
  %extract4.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x double> %extract4.i to <8 x float>
  %5 = tail call <8 x float> @llvm.x86.avx.max.ps.256(<8 x float> %3, <8 x float> %4)
  %extract6.i = shufflevector <8 x float> %5, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract7.i = shufflevector <8 x float> %5, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %6 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %extract6.i, <4 x float> %extract7.i)
  %shuffle.i = shufflevector <4 x float> %6, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %7 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %6, <4 x float> %shuffle.i)
  %shuffle10.i = shufflevector <4 x float> %7, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %8 = tail call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %7, <4 x float> %shuffle10.i)
  %vecext.i = extractelement <4 x float> %8, i32 0
  ret float %vecext.i
}

define i32 @test_mm512_mask_reduce_min_epi32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; X86-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpminsd %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647,2147483647]
; X64-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpminsd %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> <i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647, i32 2147483647>
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %5 = bitcast <4 x i64> %extract4.i to <8 x i32>
  %6 = icmp slt <8 x i32> %4, %5
  %7 = select <8 x i1> %6, <8 x i32> %4, <8 x i32> %5
  %8 = bitcast <8 x i32> %7 to <4 x i64>
  %extract6.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract7.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %9 = bitcast <2 x i64> %extract6.i to <4 x i32>
  %10 = bitcast <2 x i64> %extract7.i to <4 x i32>
  %11 = icmp slt <4 x i32> %9, %10
  %12 = select <4 x i1> %11, <4 x i32> %9, <4 x i32> %10
  %shuffle.i = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %13 = icmp slt <4 x i32> %12, %shuffle.i
  %14 = select <4 x i1> %13, <4 x i32> %12, <4 x i32> %shuffle.i
  %shuffle10.i = shufflevector <4 x i32> %14, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %15 = icmp slt <4 x i32> %14, %shuffle10.i
  %16 = select <4 x i1> %15, <4 x i32> %14, <4 x i32> %shuffle10.i
  %vecext.i = extractelement <4 x i32> %16, i32 0
  ret i32 %vecext.i
}

define i32 @test_mm512_mask_reduce_min_epu32(i16 zeroext %__M, <8 x i64> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_epu32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X86-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vpminud %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X86-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_epu32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; X64-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextracti64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vpminud %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,0,1]
; X64-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__W to <16 x i32>
  %1 = bitcast i16 %__M to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  %extract.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract4.i = shufflevector <8 x i64> %3, <8 x i64> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x i64> %extract.i to <8 x i32>
  %5 = bitcast <4 x i64> %extract4.i to <8 x i32>
  %6 = icmp ult <8 x i32> %4, %5
  %7 = select <8 x i1> %6, <8 x i32> %4, <8 x i32> %5
  %8 = bitcast <8 x i32> %7 to <4 x i64>
  %extract6.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 0, i32 1>
  %extract7.i = shufflevector <4 x i64> %8, <4 x i64> undef, <2 x i32> <i32 2, i32 3>
  %9 = bitcast <2 x i64> %extract6.i to <4 x i32>
  %10 = bitcast <2 x i64> %extract7.i to <4 x i32>
  %11 = icmp ult <4 x i32> %9, %10
  %12 = select <4 x i1> %11, <4 x i32> %9, <4 x i32> %10
  %shuffle.i = shufflevector <4 x i32> %12, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %13 = icmp ult <4 x i32> %12, %shuffle.i
  %14 = select <4 x i1> %13, <4 x i32> %12, <4 x i32> %shuffle.i
  %shuffle10.i = shufflevector <4 x i32> %14, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %15 = icmp ult <4 x i32> %14, %shuffle10.i
  %16 = select <4 x i1> %15, <4 x i32> %14, <4 x i32> %shuffle10.i
  %vecext.i = extractelement <4 x i32> %16, i32 0
  ret i32 %vecext.i
}

define float @test_mm512_mask_reduce_min_ps(i16 zeroext %__M, <16 x float> %__W) {
; X86-LABEL: test_mm512_mask_reduce_min_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vbroadcastss {{.*#+}} zmm1 = [+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf]
; X86-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X86-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X86-NEXT:    vminps %ymm0, %ymm1, %ymm0
; X86-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X86-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X86-NEXT:    vminss %xmm1, %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    vzeroupper
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_reduce_min_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vbroadcastss {{.*#+}} zmm1 = [+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf,+Inf]
; X64-NEXT:    vmovaps %zmm0, %zmm1 {%k1}
; X64-NEXT:    vextractf64x4 $1, %zmm1, %ymm0
; X64-NEXT:    vminps %ymm0, %ymm1, %ymm0
; X64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; X64-NEXT:    vminps %xmm1, %xmm0, %xmm0
; X64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; X64-NEXT:    vminss %xmm1, %xmm0, %xmm0
; X64-NEXT:    vzeroupper
; X64-NEXT:    retq
entry:
  %0 = bitcast i16 %__M to <16 x i1>
  %1 = select <16 x i1> %0, <16 x float> %__W, <16 x float> <float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000, float 0x7FF0000000000000>
  %2 = bitcast <16 x float> %1 to <8 x double>
  %extract.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x double> %extract.i to <8 x float>
  %extract4.i = shufflevector <8 x double> %2, <8 x double> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %4 = bitcast <4 x double> %extract4.i to <8 x float>
  %5 = tail call <8 x float> @llvm.x86.avx.min.ps.256(<8 x float> %3, <8 x float> %4)
  %extract6.i = shufflevector <8 x float> %5, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extract7.i = shufflevector <8 x float> %5, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %6 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %extract6.i, <4 x float> %extract7.i)
  %shuffle.i = shufflevector <4 x float> %6, <4 x float> undef, <4 x i32> <i32 2, i32 3, i32 0, i32 1>
  %7 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %6, <4 x float> %shuffle.i)
  %shuffle10.i = shufflevector <4 x float> %7, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  %8 = tail call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %7, <4 x float> %shuffle10.i)
  %vecext.i = extractelement <4 x float> %8, i32 0
  ret float %vecext.i
}

define <8 x double> @test_mm512_mask_max_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_max_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxpd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_max_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxpd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_max_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_max_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_max_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <16 x float> @test_mm512_mask_max_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_max_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxps %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_max_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxps %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

define <8 x double> @test_mm512_mask_max_round_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_max_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxpd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_max_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxpd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

declare <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double>, <8 x double>, i32)

define <8 x double> @test_mm512_maskz_max_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_max_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_max_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_max_round_pd(<8 x double> %__A, <8 x double> %__B) {
; CHECK-LABEL: test_mm512_max_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmaxpd %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.max.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  ret <8 x double> %0
}

define <16 x float> @test_mm512_maskz_max_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_max_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_max_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_max_round_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_max_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxps %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_max_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxps %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

declare <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float>, <16 x float>, i32)

define <16 x float> @test_mm512_maskz_max_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_max_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vmaxps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_max_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vmaxps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_max_round_ps(<16 x float> %__A, <16 x float> %__B) {
; CHECK-LABEL: test_mm512_max_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmaxps %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.max.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  ret <16 x float> %0
}

define <8 x double> @test_mm512_mask_min_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_min_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminpd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_min_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminpd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_min_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_min_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_min_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask_min_round_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_mask_min_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminpd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_min_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminpd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

declare <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double>, <8 x double>, i32)

define <8 x double> @test_mm512_maskz_min_round_pd(i8 zeroext %__U, <8 x double> %__A, <8 x double> %__B) {
; X86-LABEL: test_mm512_maskz_min_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_min_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminpd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_min_round_pd(<8 x double> %__A, <8 x double> %__B) {
; CHECK-LABEL: test_mm512_min_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vminpd %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.min.pd.512(<8 x double> %__A, <8 x double> %__B, i32 4)
  ret <8 x double> %0
}

define <16 x float> @test_mm512_mask_min_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_min_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminps %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_min_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminps %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_min_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_min_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_min_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_min_round_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_mask_min_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminps %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_min_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminps %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

declare <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float>, <16 x float>, i32)

define <16 x float> @test_mm512_maskz_min_round_ps(i16 zeroext %__U, <16 x float> %__A, <16 x float> %__B) {
; X86-LABEL: test_mm512_maskz_min_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vminps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_min_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vminps %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_min_round_ps(<16 x float> %__A, <16 x float> %__B) {
; CHECK-LABEL: test_mm512_min_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vminps %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.min.ps.512(<16 x float> %__A, <16 x float> %__B, i32 4)
  ret <16 x float> %0
}

define <8 x double> @test_mm512_sqrt_pd(<8 x double> %a) {
; CHECK-LABEL: test_mm512_sqrt_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsqrtpd %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.sqrt.v8f64(<8 x double> %a)
  ret <8 x double> %0
}

define <8 x double> @test_mm512_mask_sqrt_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A) {
; X86-LABEL: test_mm512_mask_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.sqrt.v8f64(<8 x double> %__A)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

define <8 x double> @test_mm512_maskz_sqrt_pd(i8 zeroext %__U, <8 x double> %__A) {
; X86-LABEL: test_mm512_maskz_sqrt_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_sqrt_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.sqrt.v8f64(<8 x double> %__A)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_mask_sqrt_round_pd(<8 x double> %__W, i8 zeroext %__U, <8 x double> %__A) {
; X86-LABEL: test_mm512_mask_sqrt_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd {rn-sae}, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_sqrt_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd {rn-sae}, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.sqrt.pd.512(<8 x double> %__A, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> %__W
  ret <8 x double> %2
}

declare <8 x double> @llvm.x86.avx512.sqrt.pd.512(<8 x double>, i32)

define <8 x double> @test_mm512_maskz_sqrt_round_pd(i8 zeroext %__U, <8 x double> %__A) {
; X86-LABEL: test_mm512_maskz_sqrt_round_pd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtpd {rn-sae}, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_sqrt_round_pd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtpd {rn-sae}, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.sqrt.pd.512(<8 x double> %__A, i32 8)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x double> %0, <8 x double> zeroinitializer
  ret <8 x double> %2
}

define <8 x double> @test_mm512_sqrt_round_pd(<8 x double> %__A) {
; CHECK-LABEL: test_mm512_sqrt_round_pd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsqrtpd {rn-sae}, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x double> @llvm.x86.avx512.sqrt.pd.512(<8 x double> %__A, i32 8)
  ret <8 x double> %0
}

define <16 x float> @test_mm512_sqrt_ps(<16 x float> %a) {
; CHECK-LABEL: test_mm512_sqrt_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsqrtps %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.sqrt.v16f32(<16 x float> %a)
  ret <16 x float> %0
}

define <16 x float> @test_mm512_mask_sqrt_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_mask_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.sqrt.v16f32(<16 x float> %__A)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

define <16 x float> @test_mm512_maskz_sqrt_ps(i16 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_maskz_sqrt_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_sqrt_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.sqrt.v16f32(<16 x float> %__A)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_mask_sqrt_round_ps(<16 x float> %__W, i16 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_mask_sqrt_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps {rn-sae}, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_sqrt_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps {rn-sae}, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.sqrt.ps.512(<16 x float> %__A, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> %__W
  ret <16 x float> %2
}

declare <16 x float> @llvm.x86.avx512.sqrt.ps.512(<16 x float>, i32)

define <16 x float> @test_mm512_maskz_sqrt_round_ps(i16 zeroext %__U, <16 x float> %__A) {
; X86-LABEL: test_mm512_maskz_sqrt_round_ps:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vsqrtps {rn-sae}, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_sqrt_round_ps:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vsqrtps {rn-sae}, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.sqrt.ps.512(<16 x float> %__A, i32 8)
  %1 = bitcast i16 %__U to <16 x i1>
  %2 = select <16 x i1> %1, <16 x float> %0, <16 x float> zeroinitializer
  ret <16 x float> %2
}

define <16 x float> @test_mm512_sqrt_round_ps(<16 x float> %__A) {
; CHECK-LABEL: test_mm512_sqrt_round_ps:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsqrtps {rn-sae}, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <16 x float> @llvm.x86.avx512.sqrt.ps.512(<16 x float> %__A, i32 8)
  ret <16 x float> %0
}

define <8 x i64> @test_mm512_rol_epi32(<8 x i64> %__A) local_unnamed_addr #0 {
; CHECK-LABEL: test_mm512_rol_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprold $5, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_mask_rol_epi32(<8 x i64> %__W, i16 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <8 x i64> %__W to <16 x i32>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x i32> %1, <16 x i32> %2
  %5 = bitcast <16 x i32> %4 to <8 x i64>
  ret <8 x i64> %5
}

define <8 x i64> @test_mm512_maskz_rol_epi32(i16 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_rol_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprold $5, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rol_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprold $5, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i32> %1, <16 x i32> zeroinitializer
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_rol_epi64(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_rol_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolq $5, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_rol_epi64(<8 x i64> %__W, i8 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__W
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_rol_epi64(i8 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_rol_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolq $5, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rol_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolq $5, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_rolv_epi32(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_rolv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvd %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_mask_rolv_epi32(<8 x i64> %__W, i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast <8 x i64> %__W to <16 x i32>
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %2, <16 x i32> %3
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_maskz_rolv_epi32(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_rolv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rolv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> zeroinitializer
  %5 = bitcast <16 x i32> %4 to <8 x i64>
  ret <8 x i64> %5
}

define <8 x i64> @test_mm512_rolv_epi64(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_rolv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprolvq %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_rolv_epi64(<8 x i64> %__W, i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__W
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_rolv_epi64(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_rolv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprolvq %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rolv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprolvq %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_ror_epi32(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_ror_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprord $5, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <16 x i32> %1 to <8 x i64>
  ret <8 x i64> %2
}


define <8 x i64> @test_mm512_mask_ror_epi32(<8 x i64> %__W, i16 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast <8 x i64> %__W to <16 x i32>
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x i32> %1, <16 x i32> %2
  %5 = bitcast <16 x i32> %4 to <8 x i64>
  ret <8 x i64> %5
}

define <8 x i64> @test_mm512_maskz_ror_epi32(i16 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_ror_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprord $5, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_ror_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprord $5, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> <i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5, i32 5>)
  %2 = bitcast i16 %__U to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i32> %1, <16 x i32> zeroinitializer
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_ror_epi64(<8 x i64> %__A) {
; CHECK-LABEL: test_mm512_ror_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorq $5, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_ror_epi64(<8 x i64> %__W, i8 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_mask_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__W
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_ror_epi64(i8 zeroext %__U, <8 x i64> %__A) {
; X86-LABEL: test_mm512_maskz_ror_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorq $5, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_ror_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorq $5, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> <i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5, i64 5>)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_rorv_epi32(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_rorv_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvd %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_mask_rorv_epi32(<8 x i64> %__W, i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast <8 x i64> %__W to <16 x i32>
  %4 = bitcast i16 %__U to <16 x i1>
  %5 = select <16 x i1> %4, <16 x i32> %2, <16 x i32> %3
  %6 = bitcast <16 x i32> %5 to <8 x i64>
  ret <8 x i64> %6
}

define <8 x i64> @test_mm512_maskz_rorv_epi32(i16 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_rorv_epi32:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rorv_epi32:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvd %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = bitcast <8 x i64> %__A to <16 x i32>
  %1 = bitcast <8 x i64> %__B to <16 x i32>
  %2 = tail call <16 x i32> @llvm.fshr.v16i32(<16 x i32> %0, <16 x i32> %0, <16 x i32> %1)
  %3 = bitcast i16 %__U to <16 x i1>
  %4 = select <16 x i1> %3, <16 x i32> %2, <16 x i32> zeroinitializer
  %5 = bitcast <16 x i32> %4 to <8 x i64>
  ret <8 x i64> %5
}

define <8 x i64> @test_mm512_rorv_epi64(<8 x i64> %__A, <8 x i64> %__B) {
; CHECK-LABEL: test_mm512_rorv_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vprorvq %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_rorv_epi64(<8 x i64> %__W, i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_mask_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %zmm2, %zmm1, %zmm0 {%k1}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_mask_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %zmm2, %zmm1, %zmm0 {%k1}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__W
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_rorv_epi64(i8 zeroext %__U, <8 x i64> %__A, <8 x i64> %__B) {
; X86-LABEL: test_mm512_maskz_rorv_epi64:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    kmovw %eax, %k1
; X86-NEXT:    vprorvq %zmm1, %zmm0, %zmm0 {%k1} {z}
; X86-NEXT:    retl
;
; X64-LABEL: test_mm512_maskz_rorv_epi64:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovw %edi, %k1
; X64-NEXT:    vprorvq %zmm1, %zmm0, %zmm0 {%k1} {z}
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x i64> @llvm.fshr.v8i64(<8 x i64> %__A, <8 x i64> %__A, <8 x i64> %__B)
  %1 = bitcast i8 %__U to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

declare <8 x double> @llvm.fma.v8f64(<8 x double>, <8 x double>, <8 x double>) #9
declare <16 x float> @llvm.fma.v16f32(<16 x float>, <16 x float>, <16 x float>) #9
declare float @llvm.fma.f32(float, float, float) #9
declare double @llvm.fma.f64(double, double, double) #9
declare <8 x i64> @llvm.masked.expandload.v8i64(i64*, <8 x i1>, <8 x i64>)
declare <8 x double> @llvm.masked.expandload.v8f64(double*, <8 x i1>, <8 x double>)
declare <16 x i32> @llvm.masked.expandload.v16i32(i32*, <16 x i1>, <16 x i32>) #10
declare <16 x float> @llvm.masked.expandload.v16f32(float*, <16 x i1>, <16 x float>)
declare void @llvm.masked.compressstore.v8f64(<8 x double>, double*, <8 x i1>)
declare void @llvm.masked.compressstore.v8i64(<8 x i64>, i64*, <8 x i1>)
declare void @llvm.masked.compressstore.v16f32(<16 x float>, float*, <16 x i1>)
declare void @llvm.masked.compressstore.v16i32(<16 x i32>, i32*, <16 x i1>)
declare <4 x double> @llvm.x86.avx.max.pd.256(<4 x double>, <4 x double>)
declare <2 x double> @llvm.x86.sse2.max.pd(<2 x double>, <2 x double>)
declare <4 x double> @llvm.x86.avx.min.pd.256(<4 x double>, <4 x double>)
declare <2 x double> @llvm.x86.sse2.min.pd(<2 x double>, <2 x double>)
declare <8 x float> @llvm.x86.avx.max.ps.256(<8 x float>, <8 x float>)
declare <4 x float> @llvm.x86.sse.max.ps(<4 x float>, <4 x float>)
declare <8 x float> @llvm.x86.avx.min.ps.256(<8 x float>, <8 x float>)
declare <4 x float> @llvm.x86.sse.min.ps(<4 x float>, <4 x float>)
declare <8 x double> @llvm.sqrt.v8f64(<8 x double>)
declare <16 x float> @llvm.sqrt.v16f32(<16 x float>)

declare <16 x i32> @llvm.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.fshr.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <8 x i64> @llvm.fshr.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)

!0 = !{i32 1}

