/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "service_description.h"
#include "service_policy.h"
#include "service_record.h"

#include "service_page.h"

ServicePage::ServicePage()
  : mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

ServicePage::~ServicePage()
{
  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString ServicePage::name() const
{
  return "service";
}

QString ServicePage::title() const
{
  return QObject::tr( "Services" );
}

QString ServicePage::description() const
{
  return QObject::tr( "Manage Services" );
}

QString ServicePage::iconName() const
{
  return "service";
}

bool ServicePage::hasListingMode() const
{
  return false;
}

ListingModel* ServicePage::model()
{
  return 0;
}

Form::Description* ServicePage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::ServiceDescription;

  return mDescription;
}

Form::PagePolicy* ServicePage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::ServicePolicy;

  return mPolicy;
}

Form::Record* ServicePage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::ServiceRecord;

  return mRecord;
}
