#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DIR=jsr107cache-$2.dfsg.1.orig

# clean up the upstream tarball
mkdir $DIR
cd $DIR
jar xf ../../jsr107cache-$2-bundle.jar
jar xf jsr107cache-$2-sources.jar
cd ..
TAR="jsr107cache_$2.dfsg.1.orig.tar.gz"
GZIP=--best tar czf $TAR --exclude '*.jar' $DIR
rm -rf $DIR $3

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
    . .svn/deb-layout
    mv $TAR $origDir
    echo "moved $TAR to $origDir"
fi

exit 0
