/* 
    JSPWiki - a JSP-based WikiWiki clone.

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.  
 */
package com.ecyrd.jspwiki.plugin;

import java.util.Map;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.parser.PluginContent;

/**
 *  Implements a Plugin interface for the parser stage.  Please see PluginManager
 *  for further documentation.
 * 
 *  @since 2.5.30
 */
public interface ParserStagePlugin
{
    /**
     *  Method which is executed during parsing.
     *  
     *  @param element The JDOM element which has already been connected to the Document.
     *  @param context WikiContext, as usual.
     *  @param params  Parsed parameters for the plugin.
     */
    public void executeParser( PluginContent element, WikiContext context, Map params );
}
