/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TryCatchFinally;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.FormTag;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.tag.TagErrorRenderer;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.validation.BooleanTypeConverter;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputTagSupport
extends HtmlTagSupport
implements TryCatchFinally {
    private String formatType;
    private String formatPattern;
    private boolean focus;
    private boolean syntheticId;
    protected List<ValidationError> fieldErrors;
    private boolean fieldErrorsLoaded = false;
    protected TagErrorRenderer errorRenderer;

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    protected Object getOverrideValueOrValues() throws StripesJspException {
        return StripesFilter.getConfiguration().getPopulationStrategy().getValue(this);
    }

    protected Object getSingleOverrideValue() throws StripesJspException {
        Object unknown = this.getOverrideValueOrValues();
        Object returnValue = null;
        if (unknown != null && unknown.getClass().isArray()) {
            if (Array.getLength(unknown) > 0) {
                returnValue = Array.get(unknown, 0);
            }
        } else if (unknown != null && unknown instanceof Collection) {
            Collection collection = (Collection)unknown;
            if (collection.size() > 0) {
                returnValue = collection.iterator().next();
            }
        } else {
            returnValue = unknown;
        }
        return returnValue;
    }

    public Object getValueOnPage() {
        Object value = this.getBodyContentAsString();
        if (value == null) {
            try {
                Method getValue = this.getClass().getMethod("getValue", new Class[0]);
                value = getValue.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public FormTag getParentFormTag() throws StripesJspException {
        FormTag parent = this.getParentTag(FormTag.class);
        if (parent != null && parent.isPartial()) {
            Stack<StripesTagSupport> stack = this.getTagStack();
            ListIterator iter = stack.listIterator(stack.size());
            while (iter.hasPrevious()) {
                StripesTagSupport tag = (StripesTagSupport)iter.previous();
                if (!(tag instanceof FormTag) || ((FormTag)tag).isPartial()) continue;
                parent = (FormTag)tag;
                break;
            }
        }
        if (parent == null) {
            throw new StripesJspException("InputTag of type [" + this.getClass().getName() + "] must be enclosed inside a " + "stripes form tag. If, for some reason, you do not wish to render a complete " + "form you may surround stripes input tags with <s:form partial=\"true\" ...> " + "which will provide support to the input tags but not render the <form> tag.");
        }
        return parent;
    }

    protected boolean isItemSelected(Object value, Object selected) {
        if (selected != null) {
            String stringValue;
            String string = stringValue = value == null ? "" : this.format(value, false);
            if (selected.getClass().isArray()) {
                int length = Array.getLength(selected);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(selected, i);
                    if (!this.format(item, false).equals(stringValue)) continue;
                    return true;
                }
            } else if (selected instanceof Collection) {
                Collection selectedIf = (Collection)selected;
                for (Object item : selectedIf) {
                    if (!this.format(item, false).equals(stringValue)) continue;
                    return true;
                }
            } else if (this.format(selected, false).equals(stringValue)) {
                return true;
            }
        }
        return false;
    }

    public String getLocalizedFieldName() throws StripesJspException {
        String name = this.getAttributes().get("name");
        return this.getLocalizedFieldName(name);
    }

    protected String getLocalizedFieldName(String name) throws StripesJspException {
        Locale locale = this.getPageContext().getRequest().getLocale();
        FormTag form = null;
        try {
            form = this.getParentFormTag();
        }
        catch (StripesJspException sje) {
            // empty catch block
        }
        String actionPath = null;
        Class<ActionBean> beanClass = null;
        if (form != null) {
            actionPath = form.getAction();
            beanClass = form.getActionBeanClass();
        } else {
            ActionBean mainBean = (ActionBean)this.getPageContext().getRequest().getAttribute("actionBean");
            if (mainBean != null) {
                beanClass = mainBean.getClass();
            }
        }
        return LocalizationUtility.getLocalizedFieldName(name, actionPath, beanClass, locale);
    }

    protected ValidationMetadata getValidationMetadata() throws StripesJspException {
        Class<? extends ActionBean> beanClass = this.getParentFormTag().getActionBeanClass();
        if (beanClass != null) {
            String name = this.getName();
            if (name == null) {
                for (InputTagSupport tag = this.getParentTag(InputTagSupport.class); name == null && tag != null; tag = tag.getParentTag(InputTagSupport.class)) {
                    name = tag.getName();
                }
            }
            return StripesFilter.getConfiguration().getValidationMetadataProvider().getValidationMetadata(beanClass, new ParameterName(name));
        }
        return null;
    }

    protected String format(Object input) {
        return this.format(input, true);
    }

    protected String format(Object input, boolean forOutput) {
        String formatted;
        if (input == null) {
            return "";
        }
        FormatterFactory factory = StripesFilter.getConfiguration().getFormatterFactory();
        Formatter<?> formatter = factory.getFormatter(input.getClass(), this.getPageContext().getRequest().getLocale(), this.formatType, this.formatPattern);
        String string = formatted = formatter == null ? String.valueOf(input) : formatter.format(input);
        if (forOutput && formatted != null) {
            try {
                ValidationMetadata validate = this.getValidationMetadata();
                if (validate != null && validate.encrypted()) {
                    formatted = CryptoUtil.encrypt(formatted);
                }
            }
            catch (JspException e) {
                throw new StripesRuntimeException(e);
            }
        }
        return formatted;
    }

    protected void loadErrors() throws StripesJspException {
        ValidationErrors validationErrors;
        ActionBean actionBean = this.getActionBean();
        if (actionBean != null && (validationErrors = actionBean.getContext().getValidationErrors()) != null) {
            this.fieldErrors = (List)validationErrors.get(this.getName());
        }
    }

    public List<ValidationError> getFieldErrors() throws StripesJspException {
        if (!this.fieldErrorsLoaded) {
            this.loadErrors();
            this.fieldErrorsLoaded = true;
        }
        return this.fieldErrors;
    }

    public boolean hasErrors() throws StripesJspException {
        List<ValidationError> errors = this.getFieldErrors();
        return errors != null && errors.size() > 0;
    }

    public ActionBean getActionBean() throws StripesJspException {
        return this.getParentFormTag().getActionBean();
    }

    @Override
    public final int doStartTag() throws JspException {
        this.getTagStack().push(this);
        this.registerWithParentForm();
        if (this.getFieldErrors() != null) {
            this.errorRenderer = StripesFilter.getConfiguration().getTagErrorRendererFactory().getTagErrorRenderer(this);
            this.errorRenderer.doBeforeStartTag();
        }
        return this.doStartInputTag();
    }

    protected void registerWithParentForm() throws StripesJspException {
        this.getParentFormTag().registerField(this);
    }

    public abstract int doStartInputTag() throws JspException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doEndTag() throws JspException {
        try {
            int result = this.doEndInputTag();
            if (this.getFieldErrors() != null) {
                this.errorRenderer.doAfterEndTag();
            }
            if (this.focus) {
                this.makeFocused();
            }
            int n = result;
            return n;
        }
        finally {
            this.errorRenderer = null;
            this.fieldErrors = null;
            this.fieldErrorsLoaded = false;
            this.focus = false;
        }
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        try {
            this.getTagStack().pop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
        if (this.getId() == null) {
            this.syntheticId = true;
            this.setId("stripes-" + new Random().nextInt());
        }
    }

    protected void makeFocused() throws JspException {
        try {
            JspWriter out = this.getPageContext().getOut();
            out.write("<script type=\"text/javascript\">setTimeout(function(){try{var z=document.getElementById('");
            out.write(this.getId());
            out.write("');z.focus();");
            if ("text".equals(this.getAttributes().get("type")) || "password".equals(this.getAttributes().get("type"))) {
                out.write("z.select();");
            }
            out.write("}catch(e){}},1);</script>");
            this.focus = false;
            if (this.syntheticId) {
                this.getAttributes().remove("id");
            }
            this.syntheticId = false;
        }
        catch (IOException ioe) {
            throw new StripesJspException("Could not write javascript focus code to jsp writer.", ioe);
        }
    }

    public abstract int doEndInputTag() throws JspException;

    public void setDisabled(String disabled) {
        boolean isDisabled = "disabled".equalsIgnoreCase(disabled);
        if (!isDisabled) {
            BooleanTypeConverter converter = new BooleanTypeConverter();
            isDisabled = (Boolean)converter.convert(disabled, Boolean.class, (Collection)null);
        }
        if (isDisabled) {
            this.set("disabled", "disabled");
        } else {
            this.getAttributes().remove("disabled");
        }
    }

    public String getDisabled() {
        return this.get("disabled");
    }

    public void setReadonly(String readonly) {
        boolean isReadOnly = "readonly".equalsIgnoreCase(readonly);
        if (!isReadOnly) {
            BooleanTypeConverter converter = new BooleanTypeConverter();
            isReadOnly = (Boolean)converter.convert(readonly, Boolean.class, (Collection)null);
        }
        if (isReadOnly) {
            this.set("readonly", "readonly");
        } else {
            this.getAttributes().remove("readonly");
        }
    }

    public String getReadonly() {
        return this.get("readonly");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setSize(String size) {
        this.set("size", size);
    }

    public String getSize() {
        return this.get("size");
    }
}

